<?php
/**
 * Customizer
 * 
 * @package WordPress
 * @subpackage plumber-works
 * @since plumber-works 1.0
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function plumber_works_customize_register( $wp_customize ) {
	$wp_customize->add_section( new Plumber_Works_Upsell_Section($wp_customize,'upsell_section',array(
		'title'            => __( 'Plumber Works Pro', 'plumber-works' ),
		'button_text'      => __( 'Upgrade Pro', 'plumber-works' ),
		'url'              => 'https://www.wpradiant.net/blocks/plumber-wordpress-theme/',
		'priority'         => 0,
	)));
}
add_action( 'customize_register', 'plumber_works_customize_register' );

/**
 * Enqueue script for custom customize control.
 */
function plumber_works_custom_control_scripts() {
	wp_enqueue_script( 'plumber-works-custom-controls-js', get_template_directory_uri() . '/assets/js/custom-controls.js', array( 'jquery', 'jquery-ui-core', 'jquery-ui-sortable' ), '1.0', true );
}
add_action( 'customize_controls_enqueue_scripts', 'plumber_works_custom_control_scripts' );