<?php
/**
 * Block Styles
 *
 * @link https://developer.wordpress.org/reference/functions/register_block_style/
 *
 * @package WordPress
 * @subpackage plumber-works
 * @since plumber-works 1.0
 */

if ( function_exists( 'register_block_style' ) ) {
	/**
	 * Register block styles.
	 *
	 * @since plumber-works 1.0
	 *
	 * @return void
	 */
	function plumber_works_register_block_styles() {
		
		// Image: Borders.
		register_block_style(
			'core/image',
			array(
				'name'  => 'plumber-works-border',
				'label' => esc_html__( 'Borders', 'plumber-works' ),
			)
		);

		
	}
	add_action( 'init', 'plumber_works_register_block_styles' );
}