<?php

/*
Author: Fiona Coulter
Author URI: https://spiralscripts.co.uk
License: GPL v2
*/



if(! defined('SPIRALFACTCHECKLINKS'))
{
	exit();
}

$options = FactCheckDefinitionsHelper::getOptions();

$fact_checker_org_name = "";

 if(!empty($options["fact_checker_organisation"]))
 {
    $fact_checker_org_name = esc_html($options["fact_checker_organisation"]);
 }
 else
 {
    $fact_checker_org_name = esc_html(get_bloginfo("name"));
	
 }


$claim_reviewed = esc_html( get_post_meta( get_the_ID(), 'claim_reviewed', true ) );

if(empty($claim_reviewed))
{
	//if it is empty, use the post title
	$claim_reviewed = esc_html(get_the_title( get_the_ID() ));
}

$claim_authtype = esc_html( get_post_meta( get_the_ID(), 'claim_authtype', true ) );

if(empty($claim_authtype))
{
	$claim_authtype = "Organization";
}

$claim_urls = json_decode( get_post_meta( get_the_ID(), 'claim_urls', true ), true); 


?>
<p><?php echo get_the_date(); ?> by <?php echo esc_html(get_the_author_meta('display_name')); ?> for <?php echo $fact_checker_org_name; ?></p>

<div style="float: right; margin: 10px">
  <?php echo get_the_post_thumbnail( get_the_ID(), 'medium' ); ?>
</div>
<br /><strong>Claim Author: </strong>
   <?php echo esc_html( get_post_meta( get_the_ID(), 'claim_author', true ) ); ?> 
   <?php if(! empty($claim_reviewed)): ?><br />
   <strong>Claim Reviewed: </strong><?php echo $claim_reviewed; ?>
   <?php endif; ?>
<br />

<?php         // Display yellow stars based on rating -->
        $rating = intval( get_post_meta( get_the_ID(), 'claim_rating', true ) );
		$rating_system = FactCheckDefinitionsHelper::get_rating_system();
?>

<strong>Rating: <?php echo $rating_system[$rating]; ?> </strong><br />

<?php 

$star_rating = "";

for ($star_counter = FactCheckDefinitionsHelper::MIN_RATING; $star_counter <= FactCheckDefinitionsHelper::MAX_RATING; $star_counter++ ) {
	        
	if ( $star_counter <= $rating ) {
		$star_rating .= '<img src="' . plugins_url( 'star-icon.png', SPIRALFACTCHECKLINKS_PLUGIN_FILE) . '" />';
	} else {
		$star_rating .= '<img src="' .
			plugins_url( 'star-icon-grey.png', SPIRALFACTCHECKLINKS_PLUGIN_FILE ) . '" />';
	}
 }
 
echo $star_rating;

//claim type
$claim_types = wp_get_post_terms( get_the_ID(), 'fact_checks_claim_type' ); 

$claims_types_content = '<br /><strong>Type: </strong>';

if ( $claim_types ) { 
	$first_entry = true; 
	for ( $i = 0; $i < count( $claim_types ); $i++ ) { 
		if ( !$first_entry ) {
			$claims_types_content .= ', ';
		}
		$claims_types_content .= esc_html($claim_types[$i]->name); 
		$first_entry = false; 
	} 
} else {
	$claims_types_content .= 'None Assigned';
}

$claims_types_content .= '<br /><br />'; 

echo $claims_types_content;
		
?>


<!-- structured data -->

<script type="application/ld+json">
{
  "@context": "http://schema.org",
  "@type": "ClaimReview",
  "datePublished": "<?php echo get_the_date("Y-m-d", get_the_ID()); ?>",
  "url": "<?php echo get_permalink(get_the_ID()); ?>",
  "itemReviewed":
  {
    "@type": "CreativeWork",
    "author":
    {
      "@type": "<?php echo $claim_authtype; ?>",
      "name": "<?php echo esc_html( get_post_meta( get_the_ID(), 'claim_author', true ) ); ?>"<?php if(count($claim_urls)){ echo ','; } ?>
	  
       <?php if(count($claim_urls)): ?>
	   "sameAs": <?php $i=1; ?>"<?php foreach($claim_urls as $claim_url): ?><?php echo esc_html($claim_url); ?><?php if($i < count($claim_urls)){ echo ', '; } ?><?php $i++; ?><?php endforeach; ?>"
	  <?php endif; ?>
	  
    },
    "datePublished": "2016-06-20"
  },
  "claimReviewed": "<?php echo $claim_reviewed; ?>",
  "author":
  {
    "@type": "Organization",
    "name": "<?php echo $fact_checker_org_name; ?>",
    <?php if(! empty($options["fact_checker_url"])): ?>
    "url" : "<?php echo esc_html($options["fact_checker_url"]); ?>"
    <?php else: ?>
    "url" : "<?php echo esc_html(get_bloginfo("url")); ?>"
    <?php endif; ?>
   },
  "reviewRating":
  {
    "@type": "Rating",
    "ratingValue": "<?php echo $rating; ?>",
    "bestRating": "<?php echo FactCheckDefinitionsHelper::MAX_RATING; ?>",
    "worstRating": "<?php echo FactCheckDefinitionsHelper::MIN_RATING; ?>",
    "alternateName" : "<?php echo $rating_system[$rating]; ?>"
  }
}</script>     

