<?php

/*
Author: Fiona Coulter
Author URI: https://spiralscripts.co.uk
License: GPL v2
*/


if(! defined('SPIRALFACTCHECKLINKS'))
{
	exit();
}

abstract class FactCheckDefinitionsHelper
{

  CONST MIN_RATING = 1;
  CONST MAX_RATING = 5;
  CONST UNCATEGORISED_RATING = -1;
  
  public static $fact_check_rating_system = array(
			
			-1 => "Hard to Categorise",
			1  => "False",
			2  => "Mostly False",
			3  => "Half True",
			4  => "Mostly True",
			5  => "True"
																	
								
  );
  
  private static $claim_author_types = array("Organization", "Person");

  
  public static $options = array( 
			'fact_checker_organisation' => array('Name of Fact Checker Organisation', 'text', '', 'sanitize_text_field'),								 
			'fact_checker_url' => array('Fact Checker Organisation URL', 'text', '', 'sanitize_text_field')								 
								 
  );
  
  public static function get_author_types()
  {
	  return self::$claim_author_types;
  }
 
  public static function get_rating_system()
  { 		
		return self::$fact_check_rating_system;      
  }
  
  
  public static function getOptionValues($name)
  {
	  switch($name)
	  {
		  case 'yesno' : return self::$yesno; break;
		  default: return array(); break;
		  
	  }
  }
	
  public static function validateYesno($input)
  {
	  if(array_key_exists($input, self::$yesno))
	  {
		 return $input;	
	  }
	  else
	  {
		 return '';	
	  }
	  
  }
	
	
	
	public static $yesno = array("1"=>"yes", "2"=>"no");
	
	
	public static function getOptions()
	{
		  $options = get_option('spiral_fact_check_options', array());	
					  
		  return $options;
	}
	
	public static function setDefaultOptions()
	{
		
		$options = get_option('spiral_fact_check_options', array());
		
		$default_option_keys = array_keys(self::$options);
		$default_options = array_fill_keys($default_option_keys, '');
		
		$compare_options = array_diff_key($options, $default_options);
		
		if(empty($options) || !empty($compare_options))
		{			
			$merged_options = wp_parse_args($options, $default_options);
			update_option('spiral_fact_check_options', $merged_options);
		}
		
	}

	



}


?>