<?php 

add_action( 'bizberg_before_homepage_blog', 'construction_sewa_homepage_services' );
function construction_sewa_homepage_services(){

	$services_section_status = bizberg_get_theme_mod( 'services_section_status' );

	if( $services_section_status != true ){
		return;
	}

	$services_title_content_page_id      = bizberg_get_theme_mod( 'services_title_content_page_id' );
	$services_title_content_page_obj     = get_post( $services_title_content_page_id );
	$services_section_subtitle           = bizberg_get_theme_mod( 'services_section_subtitle' );

	$construction_sewa_services_repeater = bizberg_get_theme_mod( 'construction_sewa_services_repeater' );
	$construction_sewa_services_repeater = json_decode( $construction_sewa_services_repeater , true ); ?>

	<div class="services_wrapper">

		<div class="services_content_wrapper">
		
			<div class="container">
				
				<div class="column_wrapper">
					<div class="column">
						<h4>
							<?php echo esc_html( $services_section_subtitle ); ?>
						</h4>
						<h2>
							<?php 
							if( !empty( $services_title_content_page_id ) ){
								echo esc_html( $services_title_content_page_obj->post_title );
							} ?>
						</h2>
					</div>
					<div class="column">
						<?php 
						if( !empty( $services_title_content_page_id ) ){
							echo esc_html( sanitize_text_field( $services_title_content_page_obj->post_content ) );
						} ?>
					</div>
				</div>

			</div>

		</div>

		<?php 

		if( !empty( $construction_sewa_services_repeater ) ){ ?>

			<div class="services_content_bottom_wrapper">

				<div class="container"> 
				
					<div class="column_wrapper">

						<?php 

						foreach( $construction_sewa_services_repeater as $value ){

							$icon    = !empty( $value['icon'] ) ? $value['icon'] : '';
							$page_id = !empty( $value['page_id'] ) ? $value['page_id'] : '';

							$page_obj = get_post( $page_id ); ?>
						
							<div class="item">
								
								<i class="<?php echo esc_attr( $icon ); ?>"></i>

								<?php 

								if( !empty( $page_id ) ){ ?>

									<h3>
										<?php
										echo esc_html( $page_obj->post_title );
										?>
									</h3>

									<div class="feature-item__text">
				                        <?php
										echo esc_html( sanitize_text_field( $page_obj->post_content ) );
										?>                                                      
				                    </div>

				                    <div class="feature-item__more">
				                        <a href="<?php echo esc_url( get_permalink( $page_id ) ); ?>">
				                        	<svg width="20" height="20" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><polyline fill="none" stroke="#000" points="10 5 15 9.5 10 14"></polyline><line fill="none" stroke="#000" x1="4" y1="9.5" x2="15" y2="9.5"></line></svg>
				                        </a>
				                    </div>

				                    <?php 

				                } ?>

							</div>

							<?php

						} ?>
						
					</div>

				</div>

			</div>

			<?php

		} ?>

	</div>

	<?php
}