<?php 

add_action( 'bizberg_before_homepage_blog', 'construction_sewa_homepage_categories' );
function construction_sewa_homepage_categories(){

	$categories_section_status   = bizberg_get_theme_mod( 'categories_section_status' );
	$categories_section_subtitle = bizberg_get_theme_mod( 'categories_section_subtitle' );
	$categories_section_title    = bizberg_get_theme_mod( 'categories_section_title' );

	$construction_sewa_rental_categories = bizberg_get_theme_mod( 'construction_sewa_rental_categories' );
	$construction_sewa_rental_categories = json_decode( $construction_sewa_rental_categories, true );

	if( $categories_section_status != true ){
		return;
	} ?>

	<div class="rental_categories">
		
		<div class="container">
			
			<div class="column_wrapper title_wrapper">
				<h4><?php echo esc_html( $categories_section_subtitle ); ?></h4>
				<h2><?php echo esc_html( $categories_section_title ); ?></h2>
			</div>

			<?php 

			if( !empty( $construction_sewa_rental_categories ) ){ ?>

				<div class="column_wrapper content_wrapper">

					<?php 
					foreach( $construction_sewa_rental_categories as $value ){ 

						$value['image'] = !empty( $value['image'] ) ? $value['image'] : '';
						$img            = wp_get_attachment_image_src( $value['image'], 'large' ); 
						$img            = !empty( $img[0] ) ? $img[0] : '';

						$cat_id         = !empty( $value['cat_id'] ) ? $value['cat_id'] : '';
						$title          = get_cat_name( $cat_id ); ?>
					
						<div class="item">
							
							<a href="<?php echo esc_url( get_category_link( $cat_id ) ); ?>">
								<h3><?php echo esc_html( $title ); ?></h3>
								<div class="overlay"></div>
								<div class="image" style="background-image:url( <?php echo esc_url( $img ); ?> )"></div>
							</a>

						</div>

						<?php 

					} ?>

				</div>

				<?php 

			} ?>

		</div>

	</div>

	<?php
}