<?php

require get_stylesheet_directory() . '/customizer/options-services.php';
require get_stylesheet_directory() . '/customizer/options-categories.php';
require get_stylesheet_directory() . '/sections/services.php';
require get_stylesheet_directory() . '/sections/categories.php';

add_action( 'wp_enqueue_scripts', 'construction_sewa_chld_thm_parent_css' );
function construction_sewa_chld_thm_parent_css() {

    wp_enqueue_style( 
    	'construction_sewa_chld_css', 
    	trailingslashit( get_template_directory_uri() ) . 'style.css', 
    	array( 
    		'bootstrap',
    		'font-awesome-5',
    		'bizberg-main',
    		'bizberg-component',
    		'bizberg-style2',
    		'bizberg-responsive' 
    	) 
    );

    if ( is_rtl() ) {
        wp_enqueue_style( 
            'construction_sewa_parent_rtl', 
            trailingslashit( get_template_directory_uri() ) . 'rtl.css'
        );
    }
    
}

/**
* Change the theme color
*/
add_filter( 'bizberg_theme_color', 'construction_sewa_change_theme_color' );
add_filter( 'bizberg_header_menu_color_hover_sticky_menu', 'construction_sewa_change_theme_color' );
add_filter( 'bizberg_header_button_color_sticky_menu', 'construction_sewa_change_theme_color' );
add_filter( 'bizberg_header_button_color_hover_sticky_menu', 'construction_sewa_change_theme_color' );
add_filter( 'bizberg_header_menu_color_hover', 'construction_sewa_change_theme_color' );
add_filter( 'bizberg_header_button_color', 'construction_sewa_change_theme_color' );
add_filter( 'bizberg_header_button_color_hover', 'construction_sewa_change_theme_color' );
add_filter( 'bizberg_slider_title_box_highlight_color', 'construction_sewa_change_theme_color' );
add_filter( 'bizberg_slider_arrow_background_color', 'construction_sewa_change_theme_color' );
add_filter( 'bizberg_slider_dot_active_color', 'construction_sewa_change_theme_color' );
add_filter( 'bizberg_read_more_background_color', 'construction_sewa_change_theme_color' );
add_filter( 'bizberg_read_more_background_color_2', 'construction_sewa_change_theme_color' );
add_filter( 'bizberg_link_color', 'construction_sewa_change_theme_color' );
add_filter( 'bizberg_link_color_hover', 'construction_sewa_change_theme_color' );
add_filter( 'bizberg_blog_listing_pagination_active_hover_color', 'construction_sewa_change_theme_color' );
add_filter( 'bizberg_sidebar_widget_link_color_hover', 'construction_sewa_change_theme_color' );
add_filter( 'bizberg_sidebar_widget_title_color', 'construction_sewa_change_theme_color' );
add_filter( 'bizberg_footer_social_icon_background', 'construction_sewa_change_theme_color' );
add_filter( 'bizberg_background_color_1', 'construction_sewa_change_theme_color' );
add_filter( 'bizberg_background_color_2', 'construction_sewa_change_theme_color' );
function construction_sewa_change_theme_color(){
    return '#fcb80b';
}

add_filter( 'bizberg_header_button_border_color', 'construction_sewa_btn_border_color' );
add_filter( 'bizberg_header_button_border_color_sticky_menu', 'construction_sewa_btn_border_color' );
function construction_sewa_btn_border_color(){
    return '#db9e04';
}

add_filter( 'bizberg_slider_gradient_primary_color', 'construction_sewa_gradient_primary_color' );
function construction_sewa_gradient_primary_color(){
    return 'rgba(252,184,11,0.65)';
}

add_filter( 'bizberg_footer_social_icon_color', 'construction_sewa_footer_social_icon_color' );
function construction_sewa_footer_social_icon_color(){
    return '#fff';
}

add_filter( 'bizberg_banner_title', 'construction_sewa_banner_title' );
function construction_sewa_banner_title(){
    return current_user_can( 'edit_theme_options' ) ? esc_html__( 'Creating better urban lifestyle homes for you.' , 'construction-sewa' ) : '';
}

add_action( 'after_setup_theme', 'construction_sewa_setup_theme' );
function construction_sewa_setup_theme() {
    add_theme_support( 'title-tag' );
    add_theme_support( 'automatic-feed-links' );
}

add_filter( 'bizberg_sticky_content_sidebar' , 'construction_sewa_sticky_content_sidebar' );
function construction_sewa_sticky_content_sidebar(){
    return false;
}

add_filter( 'bizberg_footer_social_links' , 'construction_sewa_footer_social_links' );
function construction_sewa_footer_social_links(){
    return [];
}

add_filter( 'bizberg_banner_image', 'construction_sewa_banner_image' );
function construction_sewa_banner_image(){
    return [
        'background-color'      => 'rgba(20,20,20,.8)',
        'background-image'      => get_stylesheet_directory_uri() . '/assets/images/field-train-asphalt-transport-vehicle-soil-1049789-pxhere.com.jpg',
        'background-repeat'     => 'repeat',
        'background-position'   => 'center center',
        'background-size'       => 'cover',
        'background-attachment' => 'scroll',
    ];
}

add_filter( 'bizberg_banner_opacity_primary_color', 'construction_sewa_banner_opacity_primary_color' );
add_filter( 'bizberg_banner_opacity_secondary_color', 'construction_sewa_banner_opacity_primary_color' );
function construction_sewa_banner_opacity_primary_color(){
    return 'rgba(0, 0, 0, 0.3)';
}

add_filter( 'bizberg_excerpt_length', 'construction_sewa_excerpt_length' );
function construction_sewa_excerpt_length(){
    return '30';
}

add_filter( 'bizberg_getting_started_screenshot', 'construction_sewa_getting_started_screenshot' );
function construction_sewa_getting_started_screenshot(){
    return true;
}