<?php

add_action( 'init' , 'construction_sewa_services' );
function construction_sewa_services(){

	Kirki::add_section( 'construction_sewa_services_section', array(
        'title'   => esc_html__( 'Services', 'construction-sewa' ),
        'section' => 'homepage'
    ) );

    Kirki::add_field( 'bizberg', [
		'type'        => 'checkbox',
		'settings'    => 'services_section_status',
		'label'       => esc_html__( 'Enable Services', 'construction-sewa' ),
		'section'     => 'construction_sewa_services_section',
		'default'     => false
	] );

    Kirki::add_field( 'bizberg', [
		'type'        => 'select',
		'settings'    => 'services_title_content_page_id',
		'label'       => esc_html__( 'Select Page', 'construction-sewa' ),
		'section'     => 'construction_sewa_services_section',
		'multiple'    => 1,
		'choices'     => bizberg_get_all_pages(),
		'active_callback' => [
			[
				'setting'  => 'services_section_status',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'bizberg', [
		'type'        => 'text',
		'settings'    => 'services_section_subtitle',
		'label'       => esc_html__( 'Sub Title', 'construction-sewa' ),
		'section'     => 'construction_sewa_services_section',
		'default'     => esc_html__( '30 Years Of Equipment Rental Expertise', 'construction-sewa' ),
		'active_callback' => [
			[
				'setting'  => 'services_section_status',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'bizberg', array(
	    'type'        => 'advanced-repeater',
	    'label'       => esc_html__( 'Services', 'construction-sewa' ),
	    'section'     => 'construction_sewa_services_section',
	    'settings'    => 'construction_sewa_services_repeater',
	    'choices' => [
	    	'limit' => 3,
	        'button_label' => esc_html__( 'Add Services', 'construction-sewa' ),
	        'row_label' => [
	            'value' => esc_html__( 'Services', 'construction-sewa' ),
	        ],
	        'fields' => [
	            'icon'  => [
	                'type'        => 'fontawesome',
	                'label'       => esc_html__( 'Icon', 'construction-sewa' ),
	                'default'     => 'fab fa-accusoft',
	                'choices'     => bizberg_get_fontawesome_options(),
	            ],
	            'page_id' => [
	                'type'        => 'select',
	                'label'       => esc_html__( 'Page', 'construction-sewa' ),
	                'choices'     => bizberg_get_all_pages()
	            ],
	        ]
	    ],
	    'active_callback' => [
			[
				'setting'  => 'services_section_status',
				'operator' => '==',
				'value'    => true,
			]
		],
	) );

}