<?php

add_action( 'init' , 'construction_sewa_categories' );
function construction_sewa_categories(){

	Kirki::add_section( 'construction_sewa_categories', array(
        'title'   => esc_html__( 'Categories', 'construction-sewa' ),
        'section' => 'homepage'
    ) );

    Kirki::add_field( 'bizberg', [
		'type'        => 'checkbox',
		'settings'    => 'categories_section_status',
		'label'       => esc_html__( 'Enable Categories', 'construction-sewa' ),
		'section'     => 'construction_sewa_categories',
		'default'     => false
	] );

	Kirki::add_field( 'bizberg', [
		'type'        => 'text',
		'settings'    => 'categories_section_subtitle',
		'label'       => esc_html__( 'Sub Title', 'construction-sewa' ),
		'section'     => 'construction_sewa_categories',
		'default'     => esc_html__( 'Premier Equipment Rental Service', 'construction-sewa' ),
		'active_callback' => [
			[
				'setting'  => 'categories_section_status',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'bizberg', [
		'type'        => 'text',
		'settings'    => 'categories_section_title',
		'label'       => esc_html__( 'Title', 'construction-sewa' ),
		'section'     => 'construction_sewa_categories',
		'default'     => esc_html__( 'Browse Rental Categories', 'construction-sewa' ),
		'active_callback' => [
			[
				'setting'  => 'categories_section_status',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'bizberg', array(
	    'type'        => 'advanced-repeater',
	    'label'       => esc_html__( 'Categories', 'construction-sewa' ),
	    'section'     => 'construction_sewa_categories',
	    'settings'    => 'construction_sewa_rental_categories',
	    'choices' => [
	        'button_label' => esc_html__( 'Add Categories', 'construction-sewa' ),
	        'row_label' => [
	            'value' => esc_html__( 'Categories', 'construction-sewa' ),
	        ],
	        'fields' => [
	            'image'  => [
	                'type'        => 'image',
	                'label'       => esc_html__( 'Image', 'construction-sewa' ),
	            ],
	            'cat_id' => [
	                'type'        => 'select',
	                'label'       => esc_html__( 'Category', 'construction-sewa' ),
	                'choices'     => bizberg_get_post_categories()
	            ],
	        ]
	    ],
	    'active_callback' => [
			[
				'setting'  => 'categories_section_status',
				'operator' => '==',
				'value'    => true,
			]
		],
	) );

}