<?php
/***************************************************************************
 *
 * 	----------------------------------------------------------------------
 * 						DO NOT EDIT THIS FILE
 *	----------------------------------------------------------------------
 *
 *  				     Copyright (C) Themify
 *
 *	----------------------------------------------------------------------
 *
 ***************************************************************************/

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/*  Utilities
/***************************************************************************/


/**
 * Convert array key name with square bracket to valid array
 * @param array $inputArr
 * @return array
 */
function themify_convert_brackets_string_to_arrays( $inputArr ) {
	$result = array();

	foreach ($inputArr as $key => $val) {
		$keyParts = preg_split('/[\[\]]+/', $key, -1, PREG_SPLIT_NO_EMPTY);

		$ref = &$result;

		while ($keyParts) {
				$part = array_shift($keyParts);

			if ( !isset($ref[$part]) && is_array( $ref )) {
				$ref[$part] = array();
			}

			if ( is_array( $ref ) ) {
				$ref = &$ref[$part];
			}
		}

		$ref = $val;
	}
	return $result;
}


function themify_clear_menu_cache(){
    // delete transient
    global $wpdb;
    $wpdb->get_results( "DELETE FROM $wpdb->options WHERE `option_name` LIKE ('_transient_tf_menu_%')" );
}

///////////////////////////////////////////
// Create ZIP Package
///////////////////////////////////////////

function themify_create_zip($files = array(),$destination = "",$overwrite = false) {
	if(!class_exists('ZipArchive') || (!$overwrite && is_file($destination))) { 
	    return false; 
	}
	$valid_files = array();
	if(is_array($files)) {
		foreach($files as $file) {
		    if(is_file($file)) {
			$valid_files[] = $file;
		    }
		}
	}
	if(!empty($valid_files)) {
		$zip = new ZipArchive();
		$zip_opened = $overwrite ? $zip->open( $destination, ZIPARCHIVE::CREATE | ZIPARCHIVE::OVERWRITE ) : $zip->open( $destination, ZIPARCHIVE::CREATE );
		if( $zip_opened !== true ) {
			return false;
		}
		foreach($valid_files as $file) {
			$zip->addFile($file,pathinfo($file,PATHINFO_BASENAME));
		}
		$zip->close();
		return is_file($destination);
	} else {
		return false;
	}
}

/**
 * Image Helper - Echoes themify_get_image
 * @param string $args Format string.
 */
function themify_image( $args ) {
	echo themify_get_image( $args );
}

/**
 * Returns the post image, either from Themify Custom Panel fields or from WordPress Featured Image.
 * @param string|array $args Format string.
 * @return string String with <img> tag and optional content prepended and/or appended
 */
function themify_get_image( $args ) {
	global $themify;

	/**
	 * List of parameters
	 * @var array
	 */
	$defaults=array(
		'src'		 => '',
		'class' 	 => '',
		'style'=>'',
		'preload'=>false,
		'prefetch'=>false,
		'lazy_load'=>true,
		'is_slider'=>false,
		'disable_responsive'=>false,
		'w'			 => '', // width
		'h'			 => '', // height
		'before' 	 => '',
		'after' 	 => '',
		'alt'		 => '',
		'title'		 => '',
		'crop'		 => true,
		'field_name' => 'post_image,image,wp_thumb,feature_image',
		'urlonly' 	 => false,
		'image_size' => '',
		'image_meta' => false,
		'f_image'=>      false,
		'fallback'=>''//when there is no image
	);
	if(is_string($args)){
	    parse_str($args,$args);
	    foreach($args as $k=>$v){
		if($v==='true'){
		    $args[$k]=true;
		}
		elseif($v==='false'){
		    $args[$k]=false;
		}
	    }
	}
	$args=array_merge($defaults,$args);
	unset($defaults);
	/**
	 * Post ID for single, query or archive views.
	 * Page ID is stored separately in $themify->page_id.
	 * @var string
	 */
	$post_id = get_the_ID();

	/**
	 * URL of the image to use
	 * @var string
	 */
	$img_url = '';

	/**
	 * Image width
	 * @var string
	 */
	$width = $args['w'];
	if($width!==''){
		$width=(int)$width;
	}
	/**
	 * Image height
	 * @var string
	 */
	$height =$args['h'];
	if($height!==''){
		$height=(int)$height;
	}

	$attachment_id = 0;
		
	$is_disabled = themify_is_image_script_disabled();
	if(is_numeric($args['src'])){
		$attachment_id=$args['src'];
		$img = wp_get_attachment_image_src($attachment_id, 'large');
		$args['src']=!empty($img[0])?$img[0]:'';
		unset($img);
	}
	elseif($args['fallback']!=='' && empty($args['src']) && !has_post_thumbnail()){
	    $args['src']=$args['fallback'];
	}
	if ($is_disabled===true ) { // Use WP standard image sizes
		if ( ! empty( $args['image_size'] ) ) { // If image_size parameter is set
			$feature_size = $args['image_size'];
		} 
		elseif (! empty( $themify->image_size ) ) { // or if Themify::image_size is set
			$feature_size = $themify->image_size;
		} 
		elseif ( empty( $themify->is_shortcode ) && in_the_loop()) { // Main query area
			if ( is_single() ) {
				$feature_size = get_post_meta( $post_id, 'feature_size', true );
				if ( empty( $feature_size ) || 'blank' === $feature_size ) {
					$feature_size = themify_get( 'setting-image_post_single_feature_size',null,true );
				}
			} 
			elseif (!empty($themify->page_id) && !empty($themify->query_post_type) && themify_is_query_page() ) {
				$feature_size = get_post_meta( $themify->page_id,$themify->query_post_type . 'feature_size_page', true );
				if(empty($feature_size)){
					$feature_size=null;
				}
			} 
			elseif ( is_archive() || is_tax() || is_search() || is_home() ) {
				$feature_size = themify_get( 'setting-image_post_feature_size',null,true );
			}
		}
		if ( ! isset( $feature_size ) || 'blank' === $feature_size ) {
                    $feature_size = apply_filters( 'themify_global_feature_size', themify_get( 'setting-global_feature_size','large',true ));
		}
		// Set URL to use for final output.
		$img_url = empty( $args['src'] )?themify_image_url( false, $feature_size ):$args['src'];
		$img_url=trim( $img_url);
		// Fix for showing feature_image when Themify Image Script is disabled
		if( '' === $img_url) {
			foreach( explode( ',', $args['field_name'] ) as $field ) {
				if ( $img_url = get_post_meta( $post_id, trim( $field ), true ) ) break;
			}
		}

	} 
	else { // Use Image Script
		if ( empty( $args['src'] ) ) {
			if ( has_post_thumbnail() ) {
				$img_url = $width!=='' && $height!==''?((int) get_post_thumbnail_id()):get_the_post_thumbnail_url(); /* Image script works with thumbnail IDs as well as URLs, use ID which is faster */
			} 
			elseif('attachment' === get_post_type()){
			    $img_url = wp_get_attachment_url( $post_id );
			} 
			else {
				foreach( explode( ',', $args['field_name'] ) as $field ) {
					if ( $img_url = get_post_meta( $post_id, trim( $field ), true ) ) {
						break;
					}
				}
			}
		} 
		else {
		    $img_url = $args['src'];
		}
		if ( $height!=='' && 0 === ((int)$height )) {
		    $height=0;
		    $args['crop'] = false;
		}
		/** filter $img_url before it goes off to themify_do_img for processing **/
		$img_url = apply_filters( 'themify_get_image_before_do_img', $img_url, $width, $height, $args );

		// Set URL to use for final output.
		$temp = themify_do_img( (empty( $attachment_id ) ? $img_url : $attachment_id), $width, $height, (bool) $args['crop'] );
		$img_url = $temp['url'];
		if($temp['width']!=='' && $temp['height']!==''){
			$width=(int)$temp['width'];
			$height=(int)$temp['height'];
		}
		// Get title/alt text by attachment id if it was returned.
		if (!$attachment_id && isset( $temp['attachment_id'] ) ) {
		    $attachment_id = $temp['attachment_id'];
		}
		unset($temp);
	}

	// No image was defined, parse content to find the first image.
	if ( empty( $img_url ) && ($args['f_image'] || themify_check( 'setting-auto_featured_image',true ) )) {

		$content = get_the_content();
		$upload_dir = themify_upload_dir();
		foreach ( array( 'img', 'embed', 'iframe' ) as $tag ) {
			$count = substr_count( $content, '<' . $tag );
			if ( $count >= 1 ) {
				$start = strpos( $content, '<' . $tag, 0 );
				$pos = substr( $content, $start );
				$end = strpos( $pos, '>' );
				$temp = themify_prep_image( substr( $pos, 0, $end + 1 ) );
				$src = $temp['src'];
				$parse = parse_url($src);
				if(!empty($parse['query'])){
					$src = str_replace('?'.$parse['query'], '', $src);
				}
				$ext = strtolower(pathinfo($src,PATHINFO_EXTENSION));
				if ( strpos( $temp['src'], '.' ) && ( $ext === 'jpg' || $ext === 'jpeg' || $ext === 'gif' || $ext === 'png' || $ext==='webp' || $ext==='apng') ) {
					$auto_image_url = isset( $temp['src'] )? $temp['src'] : '';
					$args['class'] .= isset( $temp['class'] )? ' ' . $temp['class'] : '';
					$args['alt'] = $temp['alt'];
					if ( $is_disabled===true ) {
						$img_url = themify_image_url( false, $feature_size, themify_get_attachment_id_from_url( $auto_image_url, $upload_dir['baseurl'] ) );
						if ( empty( $img_url ) ) {
							$img_url = esc_url( $auto_image_url );
						}
					} elseif ( $temp = themify_do_img( $auto_image_url, $width, $height, (bool) $args['crop'] ) ) {
						$img_url = $temp['url'];
					}
					break;
				}
			}
		}
	}

	if ( ! empty( $img_url ) ) {
		
		if($args['preload']!==false || $args['prefetch']!==false){
		    Themify_Enqueue_Assets::addPreLoadMedia($img_url,$args['preload']!==false?'preload':'prefetch');
		}
		themify_generateWebp($img_url);
		if ( $args['urlonly'] ) {
			$out = $img_url;
		} 
		else {
			// Build final image
			$out = '<img src="'.$img_url.'"';
			if ( $width!=='' && $width!==0) {
				$out .= ' width="'.$width.'"';
			}
			if ( $height!=='' && $height!==0) {
				$out .= ' height="'.$height.'"';
			}
			if ( $attachment_id != 0 ) {
				if($args['class']!==''){
				    $args['class'].=' ';
				}
				$args['class'] .= 'wp-post-image wp-image-' . $attachment_id; /* add attachment_id class to img tag */
			}
			if ( $args['class']!=='' ) {
				$out .= ' class="'.$args['class'].'"';
			}
			if ( $args['style']!=='' ) {
				$out .= ' style="'.$args['style'].'"';
			}
			$title='';
			if ( ! empty( $args['alt'] )) {
			    $out_alt = $args['alt'];
			}
			else{
			    $out_alt=$attachment_id?get_post_meta( $attachment_id, '_wp_attachment_image_alt', true ):'';
			    if(!$out_alt){
				    $out_alt=!empty( $args['title'] )?$args['title']:'';
                    if(!$out_alt && $attachment_id){
                        $p = get_post($attachment_id);
                        $out_alt = $p->post_title;
                        $p=null;
                    }
                    if(!$out_alt){
                        $out_alt= the_title_attribute( 'echo=0' );
                    }
				    $title=$out_alt;
			    }
			}
			if($title===''){
			    if ( !empty( $args['title'] ) ) {
					$title=$args['title'];
			    }
			    elseif($attachment_id){
					$p = get_post( $attachment_id );
					if ( ! empty( $p ) ) {
                        $title = $p->post_title;
					}
					$p=null;
			    }
			}
			
			// Add title attribute only if explicitly set in $args
			if ($title!=='') {
				$out .= ' title="' . esc_attr( $title ) . '"';
			}
			if($args['lazy_load']===false){
				$out.=' data-tf-not-load="1"';
			}
			$out .= ' alt="' . esc_attr( $out_alt ) . '">';
			
			if($attachment_id && $args['disable_responsive']===false){
				$out = function_exists( 'wp_filter_content_tags' )
					? wp_filter_content_tags( $out ) // WP 5.5
					: wp_make_content_images_responsive( $out );
			}
			if(($args['is_slider']===true || $themify->post_layout==='slider')&& $args['lazy_load']===true){
				$out=themify_make_lazy($out,false);
			}
			if( $args['image_meta'] == true ) {
				$out .= "<meta itemprop=\"width\" content=\"{$width}\"><meta itemprop=\"height\" content=\"{$height}\"><meta itemprop=\"url\" content=\"{$img_url}\">".$out;
			}
			$out = $args['before'] . $out . $args['after'];
		}
	}
	else {
		$out = '';
	}

	return $out;
}


if (!function_exists('themify_edit_link')){
    
    function themify_edit_link($title=''){
	static $is = null;
	if ($is === null) {
	    $is = is_user_logged_in() && (!class_exists('Themify_Builder_Model') || !Themify_Builder_Model::is_front_builder_activate());
	}
	if($is===true){
	    if($title===''){
		$title=__('Edit', 'themify');
	    }
	    edit_post_link($title, '<span class="edit-button">[', ']</span>');
	}
    }
}

if ( ! function_exists( 'themify_image_url' ) ) {
	/**
	 * Returns the featured image url
	 * @param bool $echo Specify to echo or return the url
	 * @param string $size The image size to return
	 * @param null|int $attachment_id ID of image to load.
	 * @return void|string
	 */
	function themify_image_url( $echo = false, $size = 'full', $attachment_id = null ) {
		$url = '';
		if ( has_post_thumbnail() ) {
			$image = wp_get_attachment_image_src( get_post_thumbnail_id(), $size );
			$url = $image[0];
		} elseif ( ! is_null( $attachment_id ) ) {
			$image = wp_get_attachment_image_src( $attachment_id, $size );
			$url = $image[0];
		}
		$url = apply_filters( 'themify_image_url', $url );
		if ( $echo ) {
			echo esc_url( $url );
			return '';
		} else {
			return $url;
		}
	}
}

/**
 * Image Helper - Prep Image
 * @param $tag
 * @return array
 */
function themify_prep_image( $tag ) {
	$image = array('src' => '', 'alt' => '', 'title' => '');
	preg_match_all( '/(alt|title|src)=(("|\')[^("|\')]*("|\'))/i', $tag, $image_reg );

	foreach( $image_reg[0] as $attr ){
		parse_str( $attr, $tempAttr );
		foreach( $tempAttr as $key => $val ) {
			if( isset( $image[$key] ) ) {
				$image[$key] = str_replace( array('"',"'"), array('',''), $val );
			}
		}
	}

	if ( strpos( $image['src'], 'youtube.com' )!==false || strpos( $image['src'], 'vimeo.com' )!==false ) {
		$image['src'] = themify_video_image( $image['src'] );
	}

	$image['src'] = preg_replace('/(-\d+x\d+)(?=\.\w{3,4})/', '', $image['src'] );

	return $image;
}

/**
 * Vimeo / Youtube Thumbnail grab
 *
 * @param $url
 *
 * @return string
 */
function themify_video_image($url){
	$image_url = parse_url($url);
	$return_url = '';
	if($image_url['host'] === 'www.youtube.com' || $image_url['host'] === 'youtube.com'){
		parse_str($image_url['query'], $query);
		if(!empty($query['v'])){
			$id = $query['v'];
		} else {
			$path = explode('/',$image_url['path']);
			$id = $path[count($path)-1];
		}
		$return_url = 'https://img.youtube.com/vi/'.$id.'/hqdefault.jp';
	} else if($image_url['host'] === 'www.vimeo.com' || $image_url['host'] === 'vimeo.com' || $image_url['host'] === 'player.vimeo.com'){
		parse_str($image_url['query'], $query);
		if(!empty($query['clip_id']) ){
			$id = $query['clip_id'];
		} else {
			$path = explode('/',$image_url['path']);
			$id = $path[(count($path)-1)];
		}
		$content = Themify_Filesystem::get_contents('https://vimeo.com/api/v2/video/'. $id . '.php');
		if(!empty($content)){
		    $hash = unserialize($content);
		    if ( !empty( $hash[0] ) ) {
			    $return_url = $hash[0]["thumbnail_large"];
		    }
		}
	}
	return $return_url;
}

/**
 * Checks if a value referenced by $var exists in theme settings or post meta data.
 * @param $var
 * @return bool
 */
function themify_check( $var,$data_only = false) {
	$val = themify_get($var,null,$data_only);
	return $val!==null && $val!=='' && $val!=='off';
}

/**
 * Returns a value referenced by $var checking in theme settings or post meta data.
 * @param $var
 * @return mixed
 */
function themify_get( $var, $default = null, $data_only = false ) {
	$data = themify_get_data();
	if ( isset( $data[ $var ] ) && $data[ $var ] !== '' ) {
		return $data[ $var ];
	} 
	elseif ( $data_only !== true ) {
		global $post;

		if ( themify_is_shop() && ! in_the_loop() ) {
			$id = themify_shop_pageId();
		} 
		elseif ( is_object( $post ) ) {
			$id = $post->ID;
		}
		else{
			$id = false;
		}

		$val = $id !== false ? get_post_meta( $id, $var, true ) : '';

		if ( $val !== '' ) {
			return $val;
		}
	}

	return $default;
}
/**
 * Returns a value referenced by $meta,$var checking in theme settings or post meta data.
 * @param $meta - post meta
 * @param $var - theme settings
 * @param $default 
 * @return mixed
 */
function themify_get_both( $meta, $var, $default = null ) {
	$val = themify_get($meta);
	if($val===null || $val==='default'){
	    $val=themify_get($var,$default,true);
	}
	return $val;
}

/**
 * Get a color value, uses themify_get and sanitizes the value
 *
 * @return string
 */
function themify_get_color_both( $meta, $var, $default = null) {
	$val = themify_get_color($meta);
	if($val===null|| $val==='default'){
	    $val=themify_get_color($var,$default,true);
	}
	return $val;
}

/**
 * Returns a value referenced by $meta,$var checking in theme settings or post meta data.
 * @param $meta - post meta
 * @param $var - theme settings
 * @return mixed
 */
function themify_check_both( $meta, $var) {
	$val = themify_get($meta,null);
	if($val===null|| $val==='default'){
	    $val=themify_get($var,null,true);
	}
	return $val!==null && $val!=='' && $val!=='off';
}


function themify_shop_pageId(){
	static $id=null;
	if($id===null){
		if(themify_is_woocommerce_active()){
			$id=(int)wc_get_page_id('shop');
			if($id<=0){//wc bug, page id isn't from wc settings,the default should be page with slug 'shop'
				$page = get_page_by_path('shop');
				$id=!empty($page)?(int)$page->ID:false;
			}
		}
		else{
			$id=false;
	    }
	}
	return $id;
}

/**
 * Get a color value, uses themify_get and sanitizes the value
 *
 * @return string
 */
function themify_get_color( $var, $default = null,$data_only=false ) {
	return themify_sanitize_hex_color( themify_get( $var, $default,$data_only ) );
}

/**
 * Sanitize a string to ensure it's valid hex color code
 *
 * @since 3.1.2
 */
function themify_sanitize_hex_color( $value ) {
	$value = ltrim( $value, '#' );
	/* match 3 to 6 hex digits */
	if ( preg_match('|^([A-Fa-f0-9]{3}){1,2}$|', $value ) ) {
		$value = '#' . $value;
	}

	return $value;
}
if ( ! function_exists( 'themify_get_image_sizes_list' ) ) {
	/**
	 * Return list of image sizes with labels for translation.
	 * @param bool $nested
	 * @return mixed|void
	 * @since 1.6.8
	 */
	function themify_get_image_sizes_list( $nested = true ) {
                static $result = array();
                $key = $nested?1:0;
                if(!isset($result[$key])){
                    $size_names = apply_filters( 'image_size_names_choose',
                            array(
                                    'thumbnail' => __( 'Thumbnail', 'themify' ),
                                    'medium' 	=> __( 'Medium', 'themify' ),
                                    'large' 	=> __( 'Large', 'themify' ),
                                    'full' 	=> __( 'Original Image', 'themify' )
                            )
                    );
                    $out = array(
                            array( 'value' => 'blank', 'name' => '' ),
                    );
                    foreach( $size_names as $size => $label ) {
                            $out[] = array( 'value' => $size, 'name' => $label );
                    }
                    $result[$key] = apply_filters( 'themify_get_image_sizes_list', $nested ? $out : $size_names, $nested );
                }
		return $result[$key];
	}
}

/**
 * Check if the site is using an HTTPS scheme and returns the proper url
 * @param String $url requested url
 * @return String
 * @since 1.1.5
 */
function themify_https_esc( $url = '' ) {
	if ( is_ssl() ) {
	    $url = str_replace( 'http:', 'https:', $url);
	}
	return $url;
}

/**
 * Returns an array with the post types managed by Themify,
 * where the Themify Custom Panel is initialized.
 * Filterable using themify_post_types
 * @param Array $types additional post types
 * @return Array
 * @since 1.1.5
 */
function themify_post_types($types = array()){
    $defaults=array('post', 'page')+themify_specific_post_types()+$types;
    if(themify_is_themify_theme() && themify_is_woocommerce_active() && is_file(THEME_DIR . '/admin/post-type-product.php')){
	$defaults[]='product';
    }
    return array_unique(apply_filters('themify_post_types', $defaults));
}

/**
 * Returns an array with the post types that are specific to Themify,
 * where the Themify Custom Panel is initialized.
 * Filterable using themify_post_types
 * @return array
 * @since 1.1.5
 */
function themify_specific_post_types(){
	return array_unique(
		apply_filters('themify_specific_post_types', array(
			'menu',
			'slider',
			'highlight',
			'portfolio',
			'testimonial',
			'section'
		))
	);
}

/**
 * Search array by key and value
 *
 * @param      $array
 * @param      $key
 * @param      $value
 * @param bool $duplicate
 * @param null $uniq_key
 * @param null $uniq_val
 *
 * @return array
 */
function themify_search_arr( $array, $key, $value, $duplicate = false, $uniq_key = null, $uniq_val = null ) {
	$results = array();
	themify_search_r( $array, $key, $value, $results, $duplicate, $uniq_key, $uniq_val );
	return $results;
}

/**
 * Function search array by key and value
 *
 * @param      $array
 * @param      $key
 * @param      $value
 * @param      $results
 * @param bool $duplicate
 * @param null $uniq_key
 * @param null $uniq_val
 */
function themify_search_r( $array, $key, $value, &$results, $duplicate = false, $uniq_key = null, $uniq_val = null ) {
	if ( ! is_array( $array ) ){
		return;
        }
        if(isset( $array[$key] )){
            if ( $duplicate ) {
                    if ( $array[$key] == $value ){
                        $results[] = $array;
                    }
            } 
            elseif (stripos( $array[ $uniq_key ], $uniq_val ) !== false ){
                    $results[] = $array;
            }
        }
	foreach ( $array as $subarray ){
		themify_search_r( $subarray, $key, $value, $results, $duplicate, $uniq_key, $uniq_val );
	}
}

/**
 * Load themify_config
 */
function themify_load_config() {
	$themify_theme_config = array();
	$config_file = locate_template( array( 'custom-config.php', 'theme-config.php' ) );
	include $config_file;

	return apply_filters( 'themify_theme_config_setup', $themify_theme_config );
}

/**
 * Get styling selector by id or selector
 *
 * @param      $key
 * @param      $value
 * @param      $context
 * @param bool $duplicate
 * @param null $uniq_key
 * @param null $uniq_val
 *
 * @return string
 */
function themify_get_styling_selector( $key, $value, $context, $duplicate = false, $uniq_key = null, $uniq_val = null ) {
	$config = themify_load_config();
	$arr = themify_search_arr( $config['panel']['styling']['tab'][ $context ]['element'], $key, $value, $duplicate, $uniq_key, $uniq_val );
	return isset( $arr[0]['selector'] )?$arr[0]['selector']:'';
}


/**
 * Check whether array is associative or indexed
 * @param array $array
 * @return boolean
 */
function themify_is_associative_array( $array ) {
	return ( is_array( $array ) && ! is_numeric( implode( '', array_keys( $array ) ) ) );
}

if(!function_exists('themify_options_module')){
	/**
	 * Returns list of <option>
	 * @param array $options List of options
	 * @param string $key
	 * @param bool $associative
	 * @param string $default
	 * @return string
	 * @since 1.3.5
	 */
	function themify_options_module($options = array(), $key = '', $associative = true, $default = ''){
		$data = themify_get_data();
		$sel=isset($data[$key])?$data[$key]:$default;
		$data=null;
		$output = '';
		if(true === $associative) {
			foreach($options as $option){
				$output .= '<option '.selected($option['value'], $sel, false).' value="' . esc_attr( $option['value'] ) . '">' . esc_html( $option['name'] ) . '</option>';
			}
		} 
		else{
		    foreach($options as $option){
			$option = esc_attr( $option );
			$selected=$sel === $option?' selected="selected"':'';
			$output .= '<option value="' . $option . '"'.$selected.'>' . esc_html( $option ) . '</option>';
		    }
		}
		return $output;
	}
}

if(!function_exists('themify_lightbox_vars_init')){
	/**
	 * Post Gallery lightbox/fullscreen and single lightbox definition
	 * @return array Lightbox/Fullscreen galleries initialization parameters
	 */
	function themify_lightbox_vars_init(){
		$gallery_lightbox = themify_get('setting-gallery_lightbox','lightbox',true);
		// Lightbox default settings
		$overlay_args = array();
		if(themify_check('setting-lightbox_content_images',true)){
		    $overlay_args['contentImagesAreas']='.post, .type-page, .type-highlight, .type-slider';
		}
        if(themify_check('setting-lightbox_disable_share',true)){
            $overlay_args['disable_sharing']=true;
        }
		if ( $gallery_lightbox === 'none' ) {
			$overlay_args['gallerySelector'] = '';
		}

		$overlay_args = apply_filters('themify_gallery_plugins_args', $overlay_args);
		// sanitize contentImagesAreas, ensure it's a valid CSS selector
		if(isset($overlay_args['contentImagesAreas'])){
		    $overlay_args['contentImagesAreas'] = trim( $overlay_args['contentImagesAreas'], ',' );
		}
		$overlay_args['i18n'] = array(
			'tCounter' => __( '%curr% of %total%', 'themify' ),
		);

		return $overlay_args;
	}
}

if ( ! function_exists( 'themify_get_shortcode_template' ) ){
/**
 * Returns markup
 * @param $posts
 * @param string $slug
 * @param string $name
 * @return mixed|void
 */
function themify_get_shortcode_template( $posts, $slug = 'includes/loop', $name = 'index', $args = array() ) {
	global $post, $themify, $ThemifyBuilder;
	Themify_Enqueue_Assets::loadGridCss($themify->post_layout);

	if ( is_object( $post ) )
		$saved_post = clone $post;
	
	$isShortcode=isset($themify->is_shortcode) && $themify->is_shortcode ===true;
	$themify->is_shortcode = true;

	// Add flag that template loop is in builder loop
	if ( is_object( $ThemifyBuilder ) ) {
	    $isLoop=$ThemifyBuilder->in_the_loop===true;
	    $ThemifyBuilder->in_the_loop = true;
	}

	// get_template_part, defined in wp-includes/general-template.php
	$templates = array();
	if ( '' !== $name ){
	    $templates[] = "{$slug}-{$name}.php";
	}
	$templates[] = "{$slug}.php";
	$template_file = apply_filters( 'themify_get_shortcode_template_file', locate_template( $templates, false, false ), $slug, $name );
	$isSlider=$themify->post_layout==='slider' || (isset($args['isSlider']) && $args['isSlider']===true);
	ob_start();
	if( ! empty( $template_file ) ) {
	    $before=isset($args['before_post'])?$args['before_post']:'';
	    $after=isset($args['after_post'])?$args['after_post']:'';
	    foreach ( $posts as $post ) {
		    setup_postdata( $post );
		    if($isSlider===true){
			echo '<div class="tf_lazy swiper-slide">';
		    }
		    echo $before;
		    include $template_file;
		    echo $after;
		    if($isSlider===true){
			echo '</div>';
		    }
	    }
	    $posts=null;
	}
	
	if ( isset( $saved_post ) && is_object( $saved_post ) ) {
		$post = $saved_post;
		/**
		 * WooCommerce plugin resets the global $product on the_post hook,
		 * call setup_postdata on the original $post object to prevent fatal error from WC
		 */
		setup_postdata( $saved_post );
	}
	// Add flag that template loop is in builder loop
	if ( isset( $isLoop ) ) {
		$ThemifyBuilder->in_the_loop = $isLoop;
	}
	$themify->is_shortcode = $isShortcode;
	return ob_get_clean();
}
}

if ( ! function_exists( 'themify_get_gallery_shortcode' ) ) {
    /**
     * Get images from gallery shortcode
     * @return object
     */
    function themify_get_gallery_shortcode($shortcode) {
	if($shortcode){
	    preg_match('/\[gallery.*ids=.(.*).\]/', $shortcode, $ids);
	    if (isset($ids[1])) {
		$ids = trim($ids[1], '\\');
		$ids = trim($ids, '"');
		$image_ids = explode(',', $ids);

		// Check if post has more than one image in gallery
		return get_posts(array(
		    'post__in' => $image_ids,
		    'post_type' => 'attachment',
		    'post_mime_type' => 'image',
		    'numberposts' => -1,
		    'no_found_rows' => true,
		    'cache_results' => false,
		    'update_post_term_cache' => false,
		    'update_post_meta_cache' => false,
		    'orderby' => themify_get_gallery_shortcode_params($shortcode, 'orderby','post__in'),
		    'order' => themify_get_gallery_shortcode_params($shortcode, 'order','ASC')
		));
	    }
	}
	return array();
    }
}

if ( ! function_exists( 'themify_get_gallery_shortcode_params' ) ) {
    /**
     * Get gallery shortcode options
     * @param $shortcode
     * @param $param
     */
    function themify_get_gallery_shortcode_params($shortcode, $param = 'link',$default='') {
	$pattern = '/\[gallery .*?(?=' . $param . ')' . $param . '=.([^\']+)./si';
	preg_match($pattern, $shortcode, $out);
	$out = isset($out[1]) ? explode('"', $out[1]) : array('');
	return $out[0]!==''?$out[0]:$default;
    }

}

function themify_get_additional_image_sizes($size='all',$default=false){
    $allSizes=wp_get_additional_image_sizes();
    if($size==='all'){
	return $allSizes;
    }
    return isset($allSizes[$size])?$allSizes[$size]:$default;
}
if ( ! function_exists( 'themify_get_all_terms_ids' ) ) {
	/**
	 * Returns all IDs from the given taxonomy
	 * @param string $tax Taxonomy to retrieve terms from.
	 * @return array $term_ids Array of all taxonomy terms
	 * @since 1.5.6
	 */
	function themify_get_all_terms_ids($tax = 'category') {
		if ( ! $term_ids = wp_cache_get( 'all_'.$tax.'_ids', $tax ) ) {
			$term_ids = get_terms( $tax, array('fields' => 'ids', 'get' => 'all') );
			wp_cache_add( 'all_'.$tax.'_ids', $term_ids, $tax );
		}
		return $term_ids;
	}
}

if ( ! function_exists( 'themify_is_touch' ) ) {
	/**
	 * According to what $check parameter specifies to check, returns true if it's a phone, tablet, or both.
	 * @param string $check
	 * @return mixed
	 * @since 1.6.8
	 */
	function themify_is_touch( $check = 'all' ) {
		static $arr=array();

		if ( ! isset( $arr[$check] ) ) {
			if ( ! class_exists( 'Themify_Mobile_Detect' ) ) {
				require_once 'class-themify-mobile-detect.php';
			}
			$detect = new Themify_Mobile_Detect;
			$is_tablet = isset($arr['tablet'])?$arr['tablet']:$detect->isTablet();
			$is_mobile = isset($arr['phone'])?$arr['phone']:(wp_is_mobile() || $detect->isMobile());
			$arr = array(
				'phone' => $is_mobile && ! $is_tablet,
				'tablet' =>  $is_tablet,
				'all' => $is_mobile
			);
			$detect=null;
		}

		return $arr[$check];
	}
}

/**
 * Checks that status of the image script.
 * @return bool
 * @since 1.7.4
 */
function themify_is_image_script_disabled() {
    static $is = null;
    if($is===null){
	$is =  themify_check( 'setting-img_settings_use',true );
    }
    return $is;
}
/**
 * Get demo cache dir
 * @return array
 */
function themify_get_cache_dir() {
		static $dir_info = null;
		if($dir_info===null){
			$upload_dir = themify_upload_dir();

			$dir_info = array(
					'path'   => $upload_dir['basedir'] . '/themify/',
					'url'    => $upload_dir['baseurl'] . '/themify/'
			);

			if( ! is_file( $dir_info['path'] ) ) {
					wp_mkdir_p( $dir_info['path'] );
			}
		}
	return $dir_info;
}

/**
 * Uncompress GZip file
 * @param string $srcName
 * @param string $dstName
 */
function themify_uncompress_gzip( $srcName, $dstName ) {
	$sfp = gzopen( $srcName, "rb" );
	if ( ! function_exists( 'WP_Filesystem' ) ) {
		require_once( ABSPATH . 'wp-admin/includes/file.php' );
	}

	WP_Filesystem();
	global $wp_filesystem;

	$string = '';
	while ( ! gzeof( $sfp ) ) {
		$string .= gzgets( $sfp, 8192 );
	}
	$wp_filesystem->put_contents( $dstName, $string, FS_CHMOD_FILE );
	gzclose($sfp);
}

if ( ! function_exists( 'themify_get_available_menus' ) ) {
	/**
	 * Returns available navigation menus.
	 *
	 * @since 1.9.5
	 *
	 * @return array
	 */
	function themify_get_available_menus() {
		$out = array( array( 'name' => '', 'value' => '', 'selected' => true ) );
		$menus = get_terms( 'nav_menu', array(
			'hide_empty' => false,
		) );
		if ( ! empty( $menus ) && ! is_wp_error( $menus ) ) {
			foreach ( $menus as $menu ) {
				$out[] = array( 'name' => $menu->name, 'value' => $menu->slug );
			}
		}
		return apply_filters( 'themify_get_available_menus', $out );
	}
}
/**
 * If installation is in debug mode, returns '' to load non-minified scripts and stylesheets.
 *
 * @since 2.1.3
 */
function themify_minified() {
	return defined( 'WP_DEBUG' ) && WP_DEBUG  ? '' : '.min';
}


/**
 * Returns true if the active theme is using Themify framework
 *
 * @since 2.2.5
 * @return bool
 */
function themify_is_themify_theme() {
	static $is = null;
	if ( $is === null ) {
	    $is = is_file( trailingslashit( get_template_directory() ) . 'themify/themify-utils.php' );
	}

	return $is;
}

if( ! function_exists( 'themify_is_woocommerce_active' ) ) {
	/**
	 * Checks if Woocommerce plugin is active and returns the proper value
	 * @return bool
	 * @since 1.4.6
	 */
	function themify_is_woocommerce_active() {
		static $is = null;
		if ( $is===null ) {
			$plugin = 'woocommerce/woocommerce.php';
			include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
			return is_plugin_active( $plugin )
				// validate if $plugin actually exists, the plugin might be active however not installed.
				&& is_file( trailingslashit( WP_PLUGIN_DIR ) . $plugin );
		}
		return $is;
	}
}

/**
 * Calls is_shop() in a safe manner
 *
 * @note: this function should not be called before template_redirect.
 *
 * @since 2.9.0
 * @return bool
 */
function themify_is_shop($pageId=false) {
    static $is=null;
    if($is===null){
	$is =themify_is_woocommerce_active();
	if($is===true){
	    $is =is_post_type_archive( 'product' ) || ($pageId>0 && $pageId===themify_shop_pageId());//don't use shop function will give error
	    if($is===false){
		$shop_url= themify_get_shop_permalink();//wc bug, page id isn't from wc settings,the default should be page with slug 'shop'
		if($shop_url!==''){
			$current_url='http';
			if(is_ssl() || ((!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') || $_SERVER['SERVER_PORT'] == 443)){
				$current_url.='s';
			}
			$current_url.= '://'; 
			$current_url.= $_SERVER['HTTP_HOST']; 
			$current_url.= $_SERVER['REQUEST_URI']; 
			$is=$current_url===$shop_url;
		}
		else{
			$is=false;
		}
	    }
	}
		
    }
    return $is;
}
/**
 * Modified version of wp_parse_args which adds filters to modify the args
 *
 * @return array
 * @since 2.7.7
 */
function themify_parse_args( $args, $defaults = '', $filter_key = '' ) {
	// Setup a temporary array from $args
	if ( is_object( $args ) ){
            $r = get_object_vars( $args );
        }
	elseif ( is_array( $args ) ){
            $r = & $args;
        }
	else{
            wp_parse_str( $args, $r );
        }
	// Passively filter the args before the parse
	if ( ! empty( $filter_key ) ){
		$r = apply_filters( 'themify_before_' . $filter_key . '_parse_args', $r );
        }
	// Parse
	if ( is_array( $defaults ) ){
		$r = array_merge( $defaults, $r );
        }
	// Aggressively filter the args after the parse
	if ( ! empty( $filter_key ) ){
		$r = apply_filters( 'themify_after_' . $filter_key . '_parse_args', $r );
        }
	// Return the parsed results
	return $r;
}


/**
 * Display the Builder's backend editor in Themify Custom Panel
 *
 * @return null
 * @since 2.8.8
 */
function themify_meta_field_page_builder() {
	do_action( 'themify_builder_metabox' );
}
/**
 * Get an array of key => value pairs and outputs them as HTML attributes
 *
 * @since 2.9.1
 * @return string
 */
function themify_get_element_attributes( $props ) {
	$out = '';
	foreach( $props as $k => $v ) { 
		$out .= ' ' . $k . '="' . esc_attr( $v ) . '"';
	}

	return $out;
}

/**
 * Get contents of a file
 * wp_filesystem sometimes fails, using include seems safer
 *
 * return string|bool
 */
function themify_get_file_contents( $path ) {
	if( is_file( $path ) ) {
		ob_start();
		include $path;
		return ob_get_clean();
	}

	return false;
}
/**
 * Get breakpoints settings
 * if it's framework return customizer breakpoints,else if it's builder plugin builder breakpoints
 * @since 3.0.0
 * @return mixed array/int
 */
function themify_get_breakpoints( $select = 'all',$max_min=false ) {
	static $res = array();
	if(($select==='all' && empty($res)) || (empty($res[$select]))){
		$breakpoints = array(
				'tablet_landscape' => array(769,1280),
				'tablet' => array(681,768),  
				'mobile' => 680
		);
		if($max_min===true){
			return $breakpoints;
		}
		foreach( $breakpoints as $bp => $value ) {
				$v = themify_builder_get('setting-customizer_responsive_design_' . $bp,'builder_responsive_design_' . $bp );
				if ( '' != $v ) {
						if(is_array($value)){
							$res[ $bp ] = array();
							$res[ $bp ][0] = $value[0];
							$res[ $bp ][1] = (int)$v;
						}
						else{
							$res[ $bp ] = (int)$v;
						}
				} else {
						$res[ $bp ] = $value;
				}
		}
		$res[ 'tablet' ][0]=$res[ 'mobile' ]+1;
		$res[ 'tablet_landscape' ][0]=$res[ 'tablet' ][1]+1;
	}
	return 'all' === $select?$res:$res[ $select ];
}
/**
 * Unserialize data if it is serialized
 *
 * If PHP supports it disables unserializing PHP objects in order to prevent object injection.
 *
 * @param string $original Maybe unserialized original, if is needed.
 * @return mixed Unserialized data can be any type.
 */
function themify_maybe_unserialize( $original ) {
	if ( is_serialized( $original ) ) { // don't attempt to unserialize data that wasn't serialized going in
		if( version_compare( PHP_VERSION, '7.0.0' ) >= 0 ) {
			return @unserialize( $original, array( 'allowed_classes' => false ) );
		} else {
			return @unserialize( $original );
		}
	}

	return $original;
}

/**
 * Get a flag
 *
 * @return bool
 */
function themify_get_flag( $name, $default = false ) {
	$flags = get_option( 'themify_flags', array() );

	$value = $default;
	if ( isset( $flags[ $name ] ) ) {
		$value = $flags[ $name ];
	}

	return apply_filters( "themify_flag_{$name}", $value );
}
/**
 * Display the post video
 * Must be used inside the loop
 *
 * @since 2.7.3
 */
function themify_post_video($url=false,$echo=true) {
	$video_file = $url?$url:themify_get( 'video_url' );
	$output='';
	if(!empty($video_file)){
	    if ( 'mp4' !== pathinfo($video_file,PATHINFO_EXTENSION )){
		    global $wp_embed;
		    $output=$wp_embed->run_shortcode('[embed]' . $video_file . '[/embed]');
	    }
	    else{
			$output='<div class="post-video">';
			$output.=do_shortcode( '[video src="' . $video_file . '"]' ); 
			$output.='</div>';

	    }
	}
	if($echo===true){
	    echo $output;
	}
	else{
	    return $output;
	}
}
/**
 * Set a flag
 *
 * @return null
 */
function themify_set_flag( $name, $value = 1 ) {
	$flags = get_option( 'themify_flags', array() );
	$flags[ $name ] = $value;
	update_option( 'themify_flags', $flags );
}

/**
 * Remove a flag
 *
 * @return null
 */
function themify_unset_flag( $name ) {
	$flags = get_option( 'themify_flags', array() );
	unset( $flags[ $name ] );
	update_option( 'themify_flags', $flags );
}
function themify_is_minify_enabled(){
    static $is = null;
    if($is===null){
		$is = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) || defined( 'THEMIFY_DISABLE_MIN' ) || themify_isDevMode();
		if($is===false ) {
		   $is = function_exists( 'themify_builder_get' ) && themify_builder_get( 'setting-script_minification-min','performance-script_minification-min' ) === null; 
		   
			if($is===false && function_exists('get_rocket_option')){
				$is=get_rocket_option('minify_js')?true:false;
			}
		}
		else{
			$is=false;
		}
    }		
    return $is;
}
/**
 * Load/Check minified file is exist
 *
 * @return string/bool
 */
function themify_enque( $url, $check = false,$cdn=true) {
	static $is = null;
	if ( $is === null ) {
	    $is = themify_is_minify_enabled();
	}
	$return = 0;
	if ($is===true) {
	    $f = pathinfo( $url );
	    if( isset( $f['extension'] ) && strpos( $f['basename'], '.min.', 2 ) === false){
			$name= $f['filename'].'.min.' . $f['extension'];
			if(is_file( trailingslashit( WP_CONTENT_DIR ).trailingslashit(str_replace( WP_CONTENT_URL, '', $f['dirname'] )) . $name )){
				if( $check===true) {
					$return = 1;
				} 
				else{
					$url = trailingslashit( $f['dirname'] ) . $name;
				}
			}
	    }
	}

	if ( $check === true ) {
		return $return;
	}

	if ( $cdn===true  && function_exists( 'get_rocket_cdn_url' ) ) {
		/**
		 * WP Rocket CDN
		 * @link https://wp-rocket.me
		 */
		$url = get_rocket_cdn_url( $url );
	}

	return $url;
}
function themify_enque_style($handle, $src = '', $deps = array(), $ver = false, $media = 'all',$in_footer=false  ){
	    Themify_Enqueue_Assets::add_css($handle, $src, $deps, $ver,$media,$in_footer);
}

function themify_enque_script($handle, $src = '', $deps = array(), $ver = THEMIFY_VERSION,$in_footer=false  ){
	Themify_Enqueue_Assets::add_js($handle, $src, $deps, $ver,$in_footer);
}


if( ! function_exists( 'themify_get_query_categories' ) ) {
	function themify_get_query_categories() {
		global $themify;

		$taxes=$themify->query_category == '0'
			? themify_get_all_terms_ids( $themify->query_taxonomy ) 
			: explode( ',', str_replace( ' ', '', $themify->query_category ) );
		if(empty($taxes) || is_wp_error($taxes)){
			return array();
		}
		return $taxes;
	}
}

/**
 * Returns the URL to the WooCommerce Shop page
 *
 * @return string
 * @since 4.5.7
 */
function themify_get_shop_permalink() {
	static $link=null;
	if($link===null){
	    $id=themify_shop_pageId();
	    $link=!empty($id)?get_permalink($id):'';
	}
	return $link;
}


function themify_is_login_page(){
    static $is=null;
    if($is===null){
		global $pagenow;
		$is=!empty($pagenow) && in_array($pagenow, array('wp-login.php', 'wp-register.php'),true);
    }
    return $is;
}
/**
 * load all themify,plugins and theme js with attribute defer(without blocking page render)
 *
 * @since 3.2.3
 */
function themify_defer_js($tag,$handle,$src){
	if ( ! empty( $tag ) && strpos( $tag, ' defer' ) === false ) {
		static $isJq=null;
		if($isJq===null){
			$isJq = themify_check( 'setting-jquery', true ) && ( !is_admin() || themify_is_ajax() ) && !is_customize_preview() && !themify_is_login_page();
		}
		if($isJq===true || $handle === 'admin-bar' || Themify_Enqueue_Assets::is_themify_file( $src, $handle ) || in_array( $handle, Themify_Enqueue_Assets::getKnownJs(), true )){
			static $ex=null;
			if($ex===null){
				$ex = apply_filters( 'themify_defer_js_exclude', array() );
			}
			if(!in_array( $handle, $ex,true)){
				$tag = str_replace(' src', ' defer="defer" src', $tag);
			}
		}
	}

    return $tag;
}


function themify_is_ajax() {
    static $is = null;
    if($is===null){
	$is = defined('DOING_AJAX') || (isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest');
    }
    return $is;
}
function themify_is_rest() {
    static $is = null;
    if($is===null){
	$is = (defined('REST_REQUEST') && REST_REQUEST)|| strpos($_SERVER[ 'REQUEST_URI' ], '/wp-json/') !== false;
    }
    return $is;
}
function themify_is_lazyloading(){
    static $is=null;
    if($is===null){
		$is=!themify_builder_check('setting-disable-lazy', 'performance-disable-lazy', true);
		if($is===true){
			global $wp_customize;
			$is=!is_admin() && themify_is_ajax()===false && !isset($_GET['tf-scroll']) && !isset( $_GET['post_in_lightbox']) && themify_is_prefetch_request()===false && (!class_exists('Themify_Builder') || !Themify_Builder_Model::is_front_builder_activate()) && !( $wp_customize instanceof WP_Customize_Manager && $wp_customize->is_preview());
			if($is===true){
				$is = apply_filters('tf_lazy_enable',$is);
			}
		}
		else{
			add_filter( 'wp_lazy_loading_enabled', '__return_false',100 );
		}
	}
    return $is;
}

function themify_make_lazy($html,$load=true){ 
    if(isset($html) && (strpos($html,'src=')!==false || strpos($html,'<audio')!==false)){
		$hasLazy=themify_is_lazyloading();
		
		static $isSafari=null;
		if($isSafari===null){
			//if there is any cache plugin and native lazy isn't check in themify settings,use js lazy load
			$isSafari=$hasLazy===true && false!==TFCache::get_cache_plugins()? ! themify_builder_check( 'setting-disable-lazy-native', 'performance-disable-lazy-native', true ):TFCache::is_safari();
		}
		$isJsLazy=$load===false || $isSafari===true;//$load need for some modules,which should be init and than load images(e.g slider)
		$extensions=array('img','iframe','audio','video');
		$count=0;	
		$stopLazy=$useJs=false;
		foreach($extensions as $ext){
			$reg=$ext==='img'?'<'.$ext.'.+?>':'<'.$ext.'.+?>.*?<\/'.$ext.'>';
			preg_match_all('/'.$reg.'/is', $html, $matches);
						
			if(!empty($matches[0])){	
				$matches=!is_array($matches[0])?array($matches[0]):$matches[0];
				foreach($matches as $item){	
				    if(strpos($item,'data-lazy',4)===false && strpos($item,'data-tf-not-load',4)===false && strpos($item,'data-tf-src',4)===false){
						if($ext!=='audio' && $ext!=='video'){
							preg_match( '/src="([^"]+)"/', $item,$image_src);
						}
					    if($ext==='audio' ||  $ext==='video' || !empty($image_src[1])){
							$url=$ext==='audio' || $ext==='video'?true:trim($image_src[1]);
							unset($image_src);
							if($url!=='' && ($ext!=='img' || strpos($url,'data:image')===false)){
								if($ext==='img'){
									themify_generateWebp($url);
									if(strpos($item,' srcset',4)!==false){
										preg_match( '/srcset="([^"]+)"/', $item, $srcset );
										if(!empty($srcset[1])){
											themify_generate_srcset_webp($srcset[1]);
										}
										$srcset=null;
									}
									if(strpos($item,' data-src',4)!==false){
										preg_match( '/data-src="([^"]+)"/', $item, $srcset );
										if(!empty($srcset[1])){
											themify_generateWebp($srcset[1]);
										}
										$srcset=null;
									}
								}
								if(strpos($item,'data-src',4)!==false || ($hasLazy===false && $ext!=='audio' && $ext!=='video')){
									continue;
								}
								$orig=$item;
								$s='';
								
								$item=preg_replace('/\s+/', ' ', $item);
								
								if($ext==='audio' || $ext==='video'){
									$s=' data-lazy="1"';
									if(strpos('preload="none"',$item,6)===false){
										$s.=' preload="none"';
									}
									$item=str_replace(array('preload="auto"','preload="metadata"'),'',$item);
								}
								else{
									if($load===false){
										$stopLazy=false;
										$useJs=true;
									}
									else{
										++$count;
										$stopLazy=$count<3;
										$useJs=false;
									}
									if($ext==='iframe'){
										if($stopLazy===false){
											if(strpos($item,' loading=',6)===false){
												$s.=' loading="lazy"';
											}
											if($isJsLazy===true){
												$s.=' data-lazy="1" src="about:blank"';
												$class='tf_iframe_lazy';
												if(strpos($item,'class=',6)===false){
													$s.=' class="'.$class.'"';
												}
												else{
													$item=str_replace(' class="',' class="'.$class.' ',$item);
												}
												$item=strtr($item,array(' src='=>' data-tf-src='));
											}
										}
										else{
											$s.=' data-tf-not-load="1"';
										}
									}
									elseif($ext==='img'){
											$placeholder = themify_get_placeholder($url,$count<15);
											if(strpos($item,' decoding=',4)===false){
												$s.=' decoding="async"';
											}
											if($stopLazy===false){
												$useJs=$isJsLazy===true || $useJs===true;
												if($placeholder===false){
													$placeholder=array(
														's'=>'data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7'
													);
												}
												else{
													if(strpos($item,' loading=',4)===false){
														$s.=' loading="lazy"';
													}
												}
												if($useJs===true){
													$s.=' data-lazy="1"';
													$item=strtr($item,array(' srcset='=>' data-tf-srcset=',' sizes='=>' data-tf-sizes=',' src='=>' data-tf-src='));//sizes need to be replaced to pass html validation
													$s=' src="'.$placeholder['s'].'"'.$s;
												}
											}
											elseif(strpos($s,'data-tf-not-load=')===false){
												$s.=' data-tf-not-load="1"';
											}
											if(isset($placeholder['w'])){
												
												if($useJs===true || $count>6){
													$class='tf_svg_lazy';
													if(strpos($s,'data-lazy=')===false){
														$s.=' data-lazy="1"';
													}
													if(strpos($item,' class=',4)===false){
														$s.=' class="'.$class.'"';
													}
													else{
														$item=str_replace(' class="',' class="'.$class.' ',$item);
													}
												}
												if(strpos($item,' width=',4)===false){
													$s.=' width="'.$placeholder['w'].'"';
												}
												if(strpos($item,' height=',4)===false){
													$s.=' height="'.$placeholder['h'].'"';
												}
											}
											unset($placeholder);
									}
								}
								$item=str_replace('<'.$ext,'<'.$ext.$s,$item);
								if($ext==='audio' || $ext==='video'){
									$c='tf_lazy tf_'.$ext.'_lazy tf_w tf_box';
									if($ext==='video'){
										$c.=' tf_rel tf_overflow';
										themify_get_icon('fas volume-mute','fa');
										themify_get_icon('fas volume-up','fa');
										themify_get_icon('fas undo-alt','fa');
										themify_get_icon('fas redo-alt','fa');
										themify_get_icon('fas external-link-alt','fa');
										themify_get_icon('fas airplay','fa');
										themify_get_icon('far closed-captioning','fa');
										themify_get_icon('fas expand','fa');
									}
									$item='<div class="'.$c.'">'.$item.'</div>';
								}
								$part=$item;
								if($ext==='img'){
									if($useJs===true && $stopLazy===false){
										$part.='<noscript>'.strtr($orig,array(' src='=>' data-tf-not-load src=')).'</noscript>';
									}
									elseif($stopLazy===true){
										Themify_Enqueue_Assets::addPreLoadMedia($url,'preload','image');//load the first images in the page with preload for fast LCP
									}
								}
								$html=str_replace($orig,$part,$html);
							}
					    }
				    }
				}
			}
			unset($matches);
		}
		unset($extensions);
    }
    return $html;
}
function themify_generate_src_webp($url){	
    if(!empty($url[0])){
        themify_generateWebp($url[0]);
    }
    return $url;
}
function themify_generate_srcset_webp($srcset){	
	$srcset=trim($srcset);
	if(!empty($srcset)){
	    $srcset=explode(',',$srcset);
	    foreach($srcset as $s){
		$s = explode(' ',trim($s));
		$s=trim($s[0]);
		if($s!=='' && strpos($s,'data:image')===false){
		    themify_generateWebp($s);
		}
	    }
	}
}

function themify_upload_dir( $reinit = false ) {
	static $dir = null;
	if ( $dir === null || $reinit === true ) {
	    $dir = wp_get_upload_dir();
		/* foolproof the paths, in case they mistakenly have trailing slash */
		$dir = array_map( 'untrailingslashit', $dir );
		$dir['baseurl']=themify_https_esc($dir['baseurl']);
	}

	return $dir;
}

function themify_generateWebp($url){
	if(empty($url)){
		return $url;
	}	
	static $is= null;
	if($is===null){
		$is=!themify_check( 'setting-webp',true )?true:(is_admin() && !themify_is_ajax());
	}
	if($is===true){
		return $url;
	}
	return themify_createWebp($url);
}

function themify_is_prefetch_request(){
    static $is=null;
    if($is===null){
		if(isset($_SERVER['HTTP_PURPOSE'])){
			$prev='HTTP_PURPOSE';
		}
		elseif(isset($_SERVER["HTTP_X_PURPOSE"])){
			$prev='HTTP_X_PURPOSE';
		}
		elseif(isset($_SERVER['HTTP_X_MOZ'])){
		    $prev='HTTP_X_MOZ';
		}
		else{
		    $prev = false;
		}
		if($prev!==false){
			$prev=strtolower($_SERVER[$prev]);
			$is=$prev==='prefetch' || $prev==='preview';
		}
		else{
		    $is=false;
		}
    }
    return $is;
}

function themify_isDevMode(){
	return themify_check('setting-dev-mode',true);
}

function themify_disable_other_lazy(){
	add_filter( 'wp_lazy_loading_enabled', '__return_false',100 );
	add_filter('lazyload_is_enabled','__return_false',1,100);//disable jetpack lazy load
	add_filter( 'rocket_use_native_lazyload','__return_false',1,100 );
}

function themify_get_server(){
	static $is=null;
	if($is===null){
		$is='apache';
		if(!empty($_SERVER['SERVER_SOFTWARE'])){
			$is=explode('/',$_SERVER['SERVER_SOFTWARE']);
			$is=str_replace('microsoft-','',strtolower($is[0]));
		}
		elseif(is_file(get_home_path().'web.config')){
			$is='iis';
		}
		elseif(!is_file(Themify_Enqueue_Assets::getHtaccessFile()) || is_file('/etc/nginx/nginx.conf')){
			$is='nginx';
		}
	}
	return $is;
}

/**
 * Help tooltip Module
 *
 * @return string
 */
function themify_help( $content ) {
	return sprintf('<span class="tf_help"><i tabindex="-1" class="icon" onclick="return false;">%s</i><span class="tf_help_content">%s</span></span>',
        themify_get_icon('ti-help','ti'),
        $content
    );
}