<?php

defined( 'ABSPATH' ) || exit;

/**
 * FontAwesome Icons for Themify Icon Picker
 *
 * Version 5.15.1
 *
 * @link http://fontawesome.io/
 */
class Themify_Icon_FontAwesome extends Themify_Icon_Font {
    
    
    private static $replace=array(
	'#a#'=>'M25 2q1.25 0 2.125.875T28 5v22q0 1.25-.875 2.125T25 30H3q-1.25 0-2.125-.875T0 27V5q0-1.25.875-2.125T3 2h22z',
	'#b#'=>'M28 5v22q0 1.25-.875 2.125T25 30H3q-1.25 0-2.125-.875T0 27V5q0-1.25.875-2.125T3 2h22q1.25 0 2.125.875T28 5z',
	'#c#'=>'M15.5.5Q22.063.5 26.531 5T31 16q0 6.688-4.625 11.094T15.5 31.5q-6.375 0-10.938-4.5',
	'#d#'=>'M15.5.5q6.438 0 10.969 4.531T31 16t-4.531 10.969T15.5 31.5 4.531 26.969 0 16 4.531 5.031 15.5.5zm',
	'#e#'=>'M16 .5q6.438 0 10.969 4.531T31.5 16t-4.531 10.969T16 31.5 5.031 26.969.5 16 5.031 5.031 16 .5zm',
	'#f#'=>'0 28q5.188 0 8.844-3.656T28.5 16t-3.656-8.844T16 3.5 7.156 7.156 3.5 16t3.656 8.844T16 28.5z',
	'#g#'=>'M16 2q6.625 0 11.313 3.813t4.688 9.188-4.688 9.188T16 28.002q-3.5 0-6.688-1.188-4.063 3.188-8.813 3.188-.',
	'#h#'=>'M28 22.375q0 .938-.625 1.25-.125.563-.125 2.188t.125 2.375q.625.625.625 1.188v1q0 .75-.469 1.188t-1.156.438H6q-2.563 0-4.281-1.719T0 26.002v-20q0-2.563 1.719-4.281T6 .002h20.375Q28 .002 28 1.627v20.75z',
	'#i#'=>'M15.5.5q6.438 0 10.969 4.531T31 16t-4.531 10.969T15.5 31.5 4.531 26.969 0 16 4.531 5.031 15.5.5zM',
	'#j#'=>'M14 8.5q0 .625.438 1.063t1.063.438h8.5v20.5q0 .625-.438 1.063t-1.063.438h-21q-.625 0-1.063-.438t-.438-1.063v-29q0-.625.438-1.063T1.5 0H',
	'#k#'=>'M14 16q-3.313 0-5.656-2.344T6 8t2.344-5.656T14 0t5.656 2.344T22 8t-2.344 5.656T14 16z',
	'#l#'=>'M29 2q1.25 0 2.125.875T32 5v22q0 1.25-.875 2.125T29 30H3q-1.25 0-2.125-.875T0 27V5q0-1.25.875-2.125T3 2h26z',
	'#m#'=>'5v-2.5q0-.75.75-.75h2.5q.75 0 .75.75v2.',
	'#n#'=>'q0 1.25-.875 2.125T25',
	'#o#'=>'M23.125 6.125Q24 7 24 8.25V29q0 1.25-.875 2.125T21 32H3q-1.25 0-2.125-.875T0 29V3Q0 1.75.875.875T3 0h12.75Q17 0 17.875.875zM20.75 8L16 3.25V8h4.75zM3 29h18V11h-6.5q-.625 0-1.063-.438t-.438-1.063v-6.5h-10v26z',
	'#p#'=>'0 .625-.438 1.063t-1.063.43',
	'#q#'=>'.188-2.',
	'#r#'=>'.813 2.'
    );
    
    public function __construct() {
	parent::__construct();
    }

    public function get_id() {
	return 'fa';
    }

    public function get_label() {
	return __('FontAwesome', 'themify');
    }

    /**
     * Check if the icon name belongs to the Themify icon font
     * Assumes yes, if the icon name has "fa-" prefix
     *
     * @return bool
     */
    public function is_valid_icon($name) {
	return
		strpos($name, 'fa-') === 0 // FA v4
		|| strpos($name, 'fa ') === 0
		|| in_array(substr($name, 0, 4), array('fas ', 'far ', 'fab '), true); // FA v5
    }
    
    private static function findIcon($ic,$type='fab'){
	$font = $type==='fab'?self::fab():($type==='far'?self::far():self::fas());
	if(!isset($font[$ic]) && !isset($font[$ic.'-alt']) && !isset($font[$ic.'-o'])){
	    $tmp=explode('-',$ic);
	    $s='';
	    foreach($tmp as $t){
			$s.=$t;
			if(isset($font[$s])){
				break;
			}
			$s.='-';
	    }
	    if(isset($font[$s])){
		    $f=$font[$s];
		    $font=is_string($f)?$font[$f]:$f;
	    }
	    else{
		    $font=$s=$tmp=null;
		    if($type==='fab'){
			    return self::findIcon($ic,'far');
		    }
		    elseif($type==='far'){
			    return self::findIcon($ic,'fas');
		    }
		    else{
			    return false;
		    }
	    }
	}
	else{
	    $f = isset($font[$ic])?$font[$ic]:(isset($font[$ic.'-alt'])?$font[$ic.'-alt']:$font[$ic.'-o']);
		
	    $font=is_string($f)?$font[$f]:$f;
	}
	return array($type=>$font);
    }

    function get_classname($ic, $lazy = null, $data_only = false,$attrs=array()) {
			$ic = trim($ic);
			$postfix = '';
			$find = array('fas ', 'far ', 'fab ');
			foreach ($find as $f) {
				if (strpos($ic, $f) !== false) {
				$postfix = trim($f);
				break;
				}
			}
			$find[] = 'fa ';
			$find[] = 'fa-';
			$ic = str_replace($find, '', $ic);
			$find = null;
			if(!$postfix){
				$postfix='fab';
			}
			$font = self::findIcon($ic,$postfix);
			if($font===false){
				$postfix='fas';
			}
			else{
				$postfix=key($font);
				$font=$font[$postfix];
			}
			$k = $postfix . '-' . $ic;
			if (isset($font) && !isset(self::$usedIcons[$k])) {
				$font['p']=strtr($font['p'],self::$replace);
				self::$usedIcons[$k] = $font;
			}
			if ($data_only === true) {
				return self::$usedIcons[$k];
			}
        return '<svg '.parent::svg_attributes($attrs).' class="tf_fa tf-' . $k . '"><use href="#tf-' . $k . '"></use></svg>';
    }

    function get_categories() {
	return array(
	    'fas' => __('Solid', 'themify'),
	    'far' => __('Regular', 'themify'),
	    'fab' => __('Brand', 'themify')
	);
    }

    public function get_icons_by_category($cat = '') {
	if ($cat === '') {
	    $cats = $this->get_categories();
	    $res = array();
	    foreach ($cats as $k => $v) {
		$res[$k] = array();
		$icons = $this->get_icons_by_category($k);
		$icons = $icons[$k];
		foreach ($icons as $ic) {
		    $res[$k][$k . ' ' . $ic] =$ic;
		}
	    }
	    return $res;
	}
	if ($cat === 'fas' || $cat === 'far' || $cat === 'fab') {
	    return array($cat => array_keys(call_user_func("Themify_Icon_FontAwesome::$cat")));
	}
	return array();
    }

    public static function far() {
	return array(
	    'heart' => array(
		'p' => 'M28.625 4q2.25 1.938 3 4.594t.063 5.094-2.375 4.188L18.375 29.001q-1 1-2.375 1t-2.375-1L2.687 17.876Q.999 16.126.312 13.657t.063-5.094 3-4.563q2.688-2.25 6.344-1.969T16 4.937q2.625-2.625 6.281-2.906T28.625 4zm-1.437 11.75q1.813-1.875 1.813-4.594t-2.25-4.844q-1.875-1.5-4.344-1.313t-4.219 2L16 9.187l-2#q#188q-1.75-1.813-4.219-2T5.249 6.312q-2.25 2.125-2.25 4.844t1.813 4.594l11 11.125q.188.25.375 0z'
	    ),
	    'star' => array(
		'p' => 'M33 10.75q1.25.125 1.625 1.313t-.5 2.063L27.5 20.564l1.563 9.125q.188 1.188-.813 1.906t-2.063.156l-8.188-4.25-8.188 4.25q-1.063.625-2.063-.125t-.813-1.938l1.563-9.125-6.625-6.438q-.875-.875-.5-2.063t1.625-1.313l9.125-1.375 4.063-8.25q.563-1.125 1.813-1.125t1.813 1.125l4.063 8.25zm-8.687 8.75l6.25-6.125-8.688-1.25L18 4.25l-3.875 7.875-8.688 1.25 6.25 6.125-1.438 8.688 7.75-4.125 7.75 4.125z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'user' => array(
		'p' => 'M19.625 19q3.438 0 5.906 2.469T28 27.375V29#n# 32H3q-1.25 0-2.125-.875T0 29v-1.625q0-3.438 2.469-5.906T8.375 19q.813 0 2.406.5T14 20t3.25-.5 2.375-.5zM25 29v-1.625q0-2.188-1.594-3.781T19.625 22q-.188 0-1.969.5T14 23t-3.656-.5-1.969-.5q-2.188 0-3.781 1.594T3 27.375V29h22zM14 18q-3.75 0-6.375-2.625T5 9t2.625-6.375T14 0t6.375 2.625T23 9t-2.625 6.375T14 18zm0-15q-2.5 0-4.25 1.75T8 9t1.75 4.25T14 15t4.25-1.75T20 9t-1.75-4.25T14 3z',
		'w' => .875,
		'vw' => 28
	    ),
	    'clock' => array(
		'p' => '#e##f#m3.875-6.5l-5.313-3.875q-.313-.25-.313-.625V7.25q0-.75.75-.75h2q.75 0 .75.75v8.875l4.188 3q.563.438.125 1.063l-1.125 1.625q-.438.625-1.063.188z'
	    ),
	    'list-alt' => array(
		'p' => '#l#m-.375 25Q29 27 29 26.625V5.375Q29 5 28.625 5H3.375Q3 5 3 5.375v21.25Q3 27 3.375 27h25.25zM26 21.25v1.5q0 .75-.75.75h-12.5q-.75 0-.75-.75v-1.5q0-.75.75-.75h12.5q.75 0 .75.75zm0-6v1.5q0 .75-.75.75h-12.5q-.75 0-.75-.75v-1.5q0-.75.75-.75h12.5q.75 0 .75.75zm0-6v1.5q0 .75-.75.75h-12.5q-.75 0-.75-.75v-1.5q0-.75.75-.75h12.5q.75 0 .75.75zM10.25 10q0 .938-.656 1.594T8 12.25t-1.594-.656T5.75 10t.656-1.594T8 7.75t1.594.656T10.25 10zm0 6q0 .938-.656 1.594T8 18.25t-1.594-.656T5.75 16t.656-1.594T8 13.75t1.594.656T10.25 16zm0 6q0 .938-.656 1.594T8 24.25t-1.594-.656T5.75 22t.656-1.594T8 19.75t1.594.656T10.25 22z'
	    ),
	    'flag' => array(
		'p' => 'M21 5q2.75 0 6.813-1.75 1.5-.625 2.844.25T32.001 6v15q0 1.625-1.375 2.5-3#r#5-8 2.5-2.313 0-5.531-1t-4.594-1q-4.063 0-8 1.813v5.188q0 .438-.281.719t-.719.281h-1q-.438 0-.719-.281t-.281-.719V5.626q-1.5-.875-1.5-2.625 0-1.313.938-2.188T3.189 0q1.063.063 1.875.813t.938 1.813v.375q0 .5-.125.938 2.438-.938 5-.938 2.313 0 5.531 1t4.594 1zm8 16V6q-4.313 2-8 2-1.875 0-5.063-1t-5.063-1Q7.311 6 4.499 8v14.5q3.25-1.5 8-1.5 1.875 0 5.063 1t5.063 1q3.563 0 6.375-2z'
	    ),
	    'bookmark' => array(
		'p' => 'M21 0q1.25 0 2.125.875T24 3v29l-12-7-12 7V3Q0 1.75.875.875T3 0h18zm0 26.75V3.375Q21 3 20.625 3H3.375Q3 3 3 3.375V26.75l9-5.25z',
		'w' => .75,
		'vw' => 24
	    ),
	    'image' => array(
		'p' => 'M29 4q1.25 0 2.125.875T32 7v18q0 1.25-.875 2.125T29 28H3q-1.25 0-2.125-.875T0 25V7q0-1.25.875-2.125T3 4h26zm-.375 21Q29 25 29 24.625V7.375Q29 7 28.625 7H3.375Q3 7 3 7.375v17.25Q3 25 3.375 25h25.25zM8 9.5q1.063 0 1.781.719T10.5 12t-.719 1.781T8 14.5t-1.781-.719T5.5 12t.719-1.781T8 9.5zM6 22v-3l2.5-2.5q.5-.5 1 0L12 19l7.5-7.5q.5-.5 1 0L26 17v5H6z'
	    ),
		'picture-o'=>'image',
		'photo'=>'image',
	    'edit' => array(
		'p' => 'M25.125 21.563l2-2q.25-.25.563-.125t.313.5v9.063q0 1.25-.875 2.125t-2.125.875h-22q-1.25 0-2.125-.875t-.875-2.125v-22q0-1.25.875-2.125t2.125-.875h17.125q.313 0 .438.313t-.125.563l-2 2q-.125.125-.313.125H3.001v22h22v-7.125q0-.188.125-.313zm9.813-12.625L18.5 25.376l-5.625.625q-1.25.125-2.125-.75T10 23.126l.625-5.625L27.063 1.063Q28.126 0 29.626 0t2.625 1.063l2.688 2.688q1.063 1.063 1.063 2.594t-1.063 2.594zm-6.188 1.937L25.125 7.25 13.5 18.875l-.438 4.063 4.063-.438zm4.063-5l-2.688-2.688q-.5-.438-.938 0l-1.938 1.938 3.625 3.625 1.938-1.938q.438-.438 0-.938z',
		'w' => 1.123046875,
		'vw' => 36
	    ),
	    'times-circle' => array(
		'p' => '#e##f#m6.375-16.375L18.5 16l3.875 3.875q.5.563 0 1.063l-1.438 1.438q-.5.5-1.063 0l-3.875-3.875-3.875 3.875q-.563.5-1.063 0l-1.438-1.438q-.5-.5 0-1.063L13.498 16l-3.875-3.875q-.5-.563 0-1.063l1.438-1.438q.5-.5 1.063 0l3.875 3.875 3.875-3.875q.563-.5 1.063 0l1.438 1.438q.5.5 0 1.063z'
	    ),
	    'check-circle' => array(
		'p' => '#e#0 3q-5.188 0-8.844 3.656T3.5 16t3.656 8.844T16 28.5t8.844-3.656T28.5 16t-3.656-8.844T16 3.5zm8.75 8.125q.563.563 0 1.063L14 23.376q-.563.563-1.063 0l-5.688-5.688q-.563-.563 0-1.063l1.438-1.438q.5-.5 1.063 0L13.438 19l8.875-8.813q.5-.5 1.063.063z'
	    ),
	    'question-circle' => array(
		'p' => '#e##f#m6.688-15.937q0 1.438-.688 2.438t-1.563 1.438-1.563.938-.688 1v.375q0 .313-.219.531t-.531.219h-2.875q-.313 0-.531-.219t-.219-.531v-.563q0-.75.25-1.375t.813-1.125.875-.719 1.063-.594l.75-.469.531-.375.375-.469.094-.563q0-.75-.781-1.25t-1.719-.5q-.688 0-1.219.219t-.906.594-.938 1.063q-.438.563-1 .125l-1.75-1.313q-.563-.438-.188-1.063Q12.374 7 16.374 7q2.375 0 4.344 1.625t1.969 3.938zM18.625 23q0 1.063-.781 1.844T16 25.625t-1.844-.781T13.375 23t.781-1.844T16 20.375t1.844.781.781 1.844z'
	    ),
	    'eye' => array(
		'p' => 'M18 9q2.938 0 4.969 2.031T25 15.969t-2.031 4.938-4.938 2.031-4.938-2.031-2.031-4.906q0-1 .25-1.938.813.438 1.688.438 1.438 0 2.469-1.031t1.031-2.469q0-.875-.438-1.688Q17 9 18 9zm17.813 6.063q.188.438.188.938t-.188.938q-2.625 5-7.375 8.031T18 28.001q-3.75 0-7.219-1.406T4.625 22.72.187 16.939q-.188-.438-.188-.938t.188-.938q2.625-5 7.375-8.031T18 4.001t10.438 3.031 7.375 8.031zM18 25q4.625 0 8.594-2.406T32.875 16q-2.313-4.188-6.281-6.594T18 7 9.406 9.406 3.125 16q1.5 2.75 3.813 4.781t5.156 3.125T18 25z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'eye-slash' => array(
		'p' => 'M39.625 29.438q.375.313.375.75 0 .375-.25.688l-.625.75q-.25.375-.75.375-.375 0-.625-.25L.375 2.563Q0 2.25 0 1.813q0-.375.25-.688l.625-.75Q1.125 0 1.625 0 2 0 2.25.25zM18.563 9.125Q19.251 9 20.001 9q2.813 0 4.844 1.969t2.156 4.781zm2.875 13.75Q20.75 23 20 23q-2.813 0-4.844-1.969T13 16.25zM20 7q-1.688 0-3.625.438l-2.938-2.25Q16.75 4 20 4q3.75 0 7.219 1.406t6.156 3.875 4.438 5.781q.188.438.188.938t-.188.938q-1.375 2.563-3.313 4.688l-2.375-1.875q1.625-1.688 2.75-3.75-2.313-4.188-6.281-6.594T20 7.001zm0 18q1.688 0 3.625-.438l2.938 2.25Q23.25 28 20 28q-5.688 0-10.438-3.031t-7.375-8.031Q1.999 16.5 1.999 16t.188-.938q1.375-2.563 3.313-4.688l2.375 1.875q-1.625 1.688-2.75 3.75 2.313 4.188 6.281 6.594T20 24.999z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'calendar-alt' => array(
		'p' => 'M9.25 18h-2.5Q6 18 6 17.2#m#5q0 .75-.75.75zm6.75-.75q0 .75-.75.75h-2.5q-.75 0-.75-.7#m#5zm6 0q0 .75-.75.75h-2.5q-.75 0-.75-.7#m#5zm-6 6q0 .75-.75.75h-2.5q-.75 0-.75-.7#m#5zm-6 0q0 .75-.75.75h-2.5Q6 24 6 23.2#m#5zm12 0q0 .75-.75.75h-2.5q-.75 0-.75-.7#m#5zM28 7v22#n# 32H3q-1.25 0-2.125-.875T0 29V7q0-1.25.875-2.125T3 4h3V.75Q6 0 6.75 0h2.5Q10 0 10 .75V4h8V.75q0-.75.75-.75h2.5Q22 0 22 .75V4h3q1.25 0 2.125.875T28 7zm-3 21.625V10H3v18.625Q3 29 3.375 29h21.25Q25 29 25 28.625z',
		'w' => .875,
		'vw' => 28
	    ),
	    'comment' => array(
		'p' => 'M16 2q6.625 0 11.313 3.813t4.688 9.188-4.688 9.188T16 28.002q-2.938 0-5.813-.875-4.063 2.875-8.688 2.875-1 0-1.375-.906t.25-1.594q.125-.125.594-.656t1.188-1.688 1.156-2.281q-3.313-3.5-3.313-7.875 0-5.375 4.688-9.188T16 2.001zm0 23q5.375 0 9#q#938t3.813-7.063-3.813-7.063T16 4.998 6.812 7.936t-3.813 7.063q0 3.188 2.5 5.813l1.25 1.375-.625 1.75q-.5 1.25-1.25 2.563 1.875-.625 3.563-1.875l1.25-.813 1.438.438Q13.5 25 16 25z'
	    ),
	    'folder' => array(
		'p' => 'M29 8q1.25 0 2.125.875T32 11v14q0 1.25-.875 2.125T29 28H3q-1.25 0-2.125-.875T0 25V7q0-1.25.875-2.125T3 4h9.188q.813 0 1.375.563l3.438 3.438h12zm0 17V11H16.562q-.813 0-1.375-.563l-3.438-3.438h-8.75v18h26z'
	    ),
	    'folder-open' => array(
		'p' => 'M33 14q1.75 0 2.625 1.531t-.063 3.031l-5 8Q29.687 28 27.999 28h-25q-1.25 0-2.125-.875T-.001 25V7q0-1.25.875-2.125T2.999 4h10l4 4h10q1.25 0 2.125.875T29.999 11v3h3zM3 7.375v14.563l3.938-6.5Q7.813 14 9.501 14h17.5v-2.625q0-.375-.375-.375H15.751l-4-4H3.376q-.375 0-.375.375zM28 25l5-8H9.312l-4.813 8h23.5z',
		'w' => 1.123046875,
		'vw' => 36
	    ),
	    'bar-chart'=>'chart-bar',
	    'chart-bar' => array(
		'p' => 'M24.813 22q-.313 0-.563-.25t-.25-.563V6.812q0-.313.25-.563t.563-.25h1.375q.313 0 .563.25t.25.563v14.375q0 .313-.25.563t-.563.25h-1.375zm-12 0q-.313 0-.563-.25t-.25-.563V8.812q0-.313.25-.563t.563-.25h1.375q.313 0 .563.25t.25.563v12.375q0 .313-.25.563t-.563.25h-1.375zm6 0q-.313 0-.563-.25t-.25-.563v-8.375q0-.313.25-.563t.563-.25h1.375q.313 0 .563.25t.25.563v8.375q0 .313-.25.563t-.563.25h-1.375zM31 25q.438 0 .719.281T32 26v1q0 .438-.281.719T31 28H2q-.813 0-1.406-.594T0 26V5q0-.438.281-.719T1 4h1q.438 0 .719.281T3 5v20h28zM6.813 22q-.313 0-.563-.25T6 21.187v-4.375q0-.313.25-.563t.563-.25h1.375q.313 0 .563.25t.25.563v4.375q0 .313-.25.563t-.563.25H6.813z'
	    ),
	    'comments' => array(
		'p' => 'M33.25 24.125q.438.875 1.031 1.719t.938 1.25.406.469q.625.688.25 1.563t-1.313.875q-4.063 0-7.813-2.438-1.875.438-3.75.438-4 0-7.219-1.688t-4.719-4.438q-.938-.125-1.813-.313Q5.56 24 1.435 24q-.938 0-1.313-.875t.25-1.563q1.313-1.25 2.375-3.438-2.75-2.688-2.75-6.125 0-4.125 3.813-7.063t9#q#938q4 0 7.25 1.688t4.75 4.438q4.688.563 7.844 3.344t3.156 6.531q0 3.438-2.75 6.125zm-24.562-5.75l1.25.25q1.5.375 3.063.375 4.063 0 7.031-2.063t2.969-4.938-2.969-4.938-7.031-2.063T5.97 7.061t-2.969 4.938q0 2.188 1.875 4l1.5 1.5-.938 2-.5.875q1.375-.438 2.688-1.313zM31.125 22Q33 20.187 33 18q0-2.25-2-4.094t-5.063-2.531q.063.5.063.625 0 2.5-1.469 4.656T20.5 20.187t-5.688 1.688Q17.875 25 23 25q1.563 0 3.063-.375l1.25-.25 1.063.688q1.313.875 2.688 1.313l-.5-.875-.938-2z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'star-half' => array(
		'p' => 'M18 24.063v3.438l-8.188 4.25q-1.063.563-2.063-.156t-.813-1.969l1.563-9.063-6.625-6.438q-.875-.875-.5-2.063t1.625-1.375l9.125-1.313 4.063-8.25Q16.75-.001 18-.001v4.25l-3.875 7.875-8.688 1.25 6.25 6.125-1.438 8.688z',
		'w' => .6015625,
		'vw' => 19
	    ),
	    'lemon' => array(
		'p' => 'M30.25 1.75q1.313 1.313 1.656 3t-.469 3.063q-.25.5-.313 1.656t.188 2.406.125 3-.438 3.5-1.531 3.875-3.156 4.063-4.063 3.125-3.875 1.531-3.5.469-3-.125-2.406-.188-1.656.313q-1.375.813-3.063.469t-3-1.656-1.656-3 .469-3.063q.25-.5.313-1.656t-#q#406-.125-3 .438-3.5 1.531-3.875 3.156-4.063T9.75 2.563t3.875-1.531 3.5-.469 3 .125 2.406.188 1.656-.313Q25.562-.25 27.25.094t3 1.656zm-1.375 4.563q.625-1.125-.75-2.469t-2.438-.719q-1.063.688-2.656.719t-3.281-.156-3.563-.094-4.063 1.094-4.313 3.125-3.125 4.313-1.094 4.063.094 3.563.156 3.281-.719 2.656q-.625 1.125.75 2.469t2.438.719q.938-.563 2.25-.688t2.563.063 2.844.188 3.156-.219 3.406-1.25 3.656-2.781q2.125-2.125 3.125-4.313t1.094-4.063-.094-3.563-.156-3.281.719-2.656zm-10.625.531q.063.531-.25.938t-.875.469q-2.563.313-5.563 3.313t-3.313 5.563q-.063.563-.469.875t-.938.25-.844-.469-.25-.906q.438-3.438 4.063-7.063t7.063-4.063q.5-.063.906.25t.469.844z'
	    ),
	    'credit-card' => array(
		'p' => 'M33 2q.813 0 1.5.406T35.594 3.5 36 5v22q0 1.25-.875 2.125T33 30H3q-1.25 0-2.125-.875T0 27V5q0-1.25.875-2.125T3 2h30zM3.375 5Q3 5 3 5.375V8h30V5.375Q33 5 32.625 5H3.375zm29.25 22Q33 27 33 26.625V16H3v10.625Q3 27 3.375 27h29.25zM12 20.75v2.5q0 .75-.75.75h-4.5Q6 24 6 23.25v-2.5q0-.75.75-.75h4.5q.75 0 .75.75zm12 0v2.5q0 .75-.75.75h-8.5q-.75 0-.75-.75v-2.5q0-.75.75-.75h8.5q.75 0 .75.75z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'hdd' => array(
		'p' => 'M35.438 14.75q.563.75.563 1.688v8.563q0 1.25-.875 2.125t-2.125.875h-30q-1.25 0-2.125-.875t-.875-2.125v-8.563q0-.938.563-1.688l6.563-9.438q.375-.563 1.094-.938t1.344-.375H26.44q.625 0 1.344.375t1.094.938zM9.563 7l-4.875 7h26.625l-4.875-7H9.563zM33 25v-8H3v8h30zm-2-4q0 .813-.594 1.406T29 23t-1.406-.594T27 21t.594-1.406T29 19t1.406.594T31 21zm-6 0q0 .813-.594 1.406T23 23t-1.406-.594T21 21t.594-1.406T23 19t1.406.594T25 21z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'hand-point-right' => array(
		'p' => 'M26.813 8.625q2.125 0 3.656 1.531T32 13.812q0 1.063-.406 2t-1.125 1.656-1.656 1.125-2 .406h-2.25q-.125.75-.5 1.375.25 2.125-1 3.938-.063 2.5-1.719 4.094T16.813 30H15.5q-2.125 0-4.719-1.25T7.562 27.5h-.188q-.563.5-1.375.5h-4q-.813 0-1.406-.531t-.594-1.281V11.813q0-.75.594-1.281t1.406-.531h4q.813 0 1.375.5h.188q.563 0 1.875-1.5 1.063-1.188 1.625-2.063.25-.375.813-1.5t.938-1.719 1.188-1.156T15.814 2q2.625 0 4.188 1.469t1.563 3.719q0 .75-.125 1.438h5.375zm0 7.375q.875 0 1.531-.656T29 13.813t-.656-1.531-1.531-.656h-9.938q0-.438.844-1.813t.844-2.625Q18.563 5 15.813 5q-.25 0-.563.531t-.813 1.5-.813 1.469q-.688 1.125-1.938 2.5-2 2.25-3.688 2.5v11q1.063.125 2.375.75t2.625 1.188 2.5.563h1.313q3.813 0 3.188-3.813.75-.438 1.031-1.438t-.219-1.938q.875-.813.906-2t-.594-1.813h5.688zM5.5 24q0-.625-.438-1.063t-1.063-.438-1.063.438T2.498 24t.438 1.063 1.063.438 1.063-.438T5.5 24z'
	    ),
	    'hand-point-left' => array(
		'p' => 'M0 13.813q0-2.125 1.531-3.656t3.656-1.531h5.375q-.125-.688-.125-1.438 0-2.25 1.563-3.719T16.188 2q1 0 1.813.563t1.188 1.156.938 1.719.813 1.5q.563.875 1.625 2.063 1.313 1.5 1.875 1.5h.188q.563-.5 1.375-.5h4q.438 0 .781.156t.625.375.438.563.156.719v14.375q0 .75-.594 1.281t-1.406.531h-4q-.813 0-1.375-.5h-.188q-.625 0-3.219 1.25t-4.719 1.25h-1.313q-2.875 0-4.531-1.594t-1.719-4.094q-1.25-1.813-1-3.938-.375-.625-.5-1.375h-2.25q-2.125 0-3.656-1.531T.002 13.813zm3 0q0 .875.656 1.531T5.187 16h5.688q-.625.625-.594 1.813t.906 2q-.5.938-.219 1.938t1.031 1.438q-.625 3.813 3.188 3.813H16.5q1.5 0 3.875-1.188T24 24.501v-11q-1.688-.25-3.688-2.5-1.25-1.375-1.938-2.5-.313-.5-.813-1.469t-.813-1.5-.563-.531q-2.75 0-2.75 2.188 0 1.25.844 2.625t.844 1.813H5.185q-.438 0-.844.156t-.688.469-.469.719-.188.844zM28 22.5q-.625 0-1.063.438t-.438 1.063.438 1.063 1.063.438 1.063-.438.438-1.063-.438-1.063T28 22.5z',
		'w' => .998046875
	    ),
	    'hand-point-up' => array(
		'p' => 'M6.625 5.188q0-2.125 1.531-3.656T11.812.001q1.375 0 2.594.688t1.906 1.906T17 5.189v2.25q.75.125 1.375.5 2.125-.25 3.938 1 2.5.063 4.094 1.719t1.594 4.531v1.313q0 2.125-1.25 4.719t-1.25 3.219v.188q.5.563.5 1.375v4q0 .563-.25 1t-.656.719-.906.281H9.814q-.75 0-1.281-.594t-.531-1.406v-4q0-.813.5-1.375v-.188q0-.563-1.5-1.875-1.188-1.063-2.063-1.625-.438-.25-1.25-.656t-1.344-.719-1.125-.781-.906-1.125-.313-1.469q0-2.625 1.469-4.188t3.719-1.563q.75 0 1.438.125V5.189zm7.375 0q0-.875-.656-1.531t-1.531-.656-1.531.656-.656 1.531v9.938q-.438 0-1.813-.844t-2.625-.844Q3 13.438 3 16.188q0 .25.531.563t1.5.813 1.469.813q1.125.688 2.5 1.938 2.25 2 2.5 3.688h11q.125-1.25 1.313-3.625t1.188-3.875V15.19q0-3.813-3.813-3.188-.438-.75-1.438-1.031t-1.938.219q-.813-.875-2-.906t-1.813.594V5.19zM22 26.5q-.625 0-1.063.438t-.438 1.063.438 1.063 1.063.438 1.063-.438.438-1.063-.438-1.063T22 26.5z',
		'w' => .875,
		'vw' => 28
	    ),
	    'hand-point-down' => array(
		'p' => 'M11.813 32q-2.125 0-3.656-1.531t-1.531-3.656v-5.375q-.688.125-1.438.125-2.25 0-3.719-1.563T0 15.812q0-.813.313-1.469t.906-1.125 1.125-.781 1.344-.719 1.25-.656q.875-.563 2.063-1.625 1.5-1.313 1.5-1.875v-.188q-.5-.563-.5-1.375v-4q0-.813.531-1.406t1.281-.594h14.375q.75 0 1.281.594T26 1.999v4q0 .813-.5 1.375v.188q0 .625 1.25 3.219T28 15.5v1.313q0 2.875-1.594 4.531t-4.094 1.719q-1.813 1.25-3.938 1-.625.375-1.375.5v2.25q0 2.125-1.531 3.656T11.812 32zm0-3q.875 0 1.531-.656T14 26.813v-5.688q.625.625 1.813.594t2-.906q.938.5 1.938.219t1.438-1.031q3.813.625 3.813-3.188V15.5q0-1.5-1.188-3.875T22.501 8h-11q-.25 1.688-2.5 3.688-1.375 1.25-2.5 1.938-.5.313-1.469.813t-1.5.813-.531.563q0 2.75 2.188 2.75 1.25 0 2.625-.844t1.813-.844v9.938q0 .875.656 1.531t1.531.656zM20.5 4q0 .625.438 1.063t1.063.438 1.063-.438T23.502 4t-.438-1.063-1.063-.438-1.063.438T20.5 4z',
		'w' => .875,
		'vw' => 28
	    ),
	    'copy' => array(
		'p' => 'M27.125 4.125Q28 5 28 6.25V23#n# 26h-5v3q0 1.25-.875 2.125T17 32H3q-1.25 0-2.125-.875T0 29V9q0-1.25.875-2.125T3 6h5V3q0-1.25.875-2.125T11 0h10.75Q23 0 23.875.875zM16.625 29Q17 29 17 28.625V26h-6q-1.25 0-2.125-.875T8 23V9H3.375Q3 9 3 9.375v19.25Q3 29 3.375 29h13.25zm8-6Q25 23 25 22.625V10h-5.5q-.625 0-1.063-.438t-.438-1.063v-5.5h-6.625q-.375 0-.375.375v19.25q0 .375.375.375h13.25zM25 7v-.625q0-.125-.125-.25l-3-3Q21.75 3 21.625 3H21v4h4z',
		'w' => .875,
		'vw' => 28
	    ),
	    'save' => array(
		'p' => 'M27.125 8.125Q28 9 28 10.25V27#n# 30H3q-1.25 0-2.125-.875T0 27V5q0-1.25.875-2.125T3 2h16.75q1.25 0 2.125.875zM17 5H9v5h8V5zm7.625 22Q25 27 25 26.625v-16.25q0-.125-.125-.25L20 5.25v6.25q#p#8h-11q-.625 0-1.063-.438T5.998 11.5V5H3.373q-.375 0-.375.375v21.25q0 .375.375.375h21.25zM14 14.5q2.25 0 3.875 1.625T19.5 20t-1.625 3.875T14 25.5t-3.875-1.625T8.5 20t1.625-3.875T14 14.5zm0 8q1.063 0 1.781-.719T16.5 20t-.719-1.781T14 17.5t-1.781.719T11.5 20t.719 1.781T14 22.5z',
		'w' => .875,
		'vw' => 28
	    ),
	    'square' => array(
		'p' => '#a#m-.375 25Q25 27 25 26.625V5.375Q25 5 24.625 5H3.375Q3 5 3 5.375v21.25Q3 27 3.375 27h21.25z',
		'w' => .875,
		'vw' => 28
	    ),
	    'envelope' => array(
		'p' => 'M29 4q1.25 0 2.125.875T32 7v18q0 1.25-.875 2.125T29 28H3q-1.25 0-2.125-.875T0 25V7q0-1.25.875-2.125T3 4h26zm0 3H3v2.563q2.188 1.75 8.438 6.625 0 .063.875.781t1.313 1 1.156.656 1.219.375 1.219-.375 1.156-.656 1.313-1 .875-.781q6.25-4.875 8.438-6.625V7zM3 25h26V13.375q-2.188 1.75-6.563 5.188-.125.063-.906.75t-1.219 1-1.25.781-1.563.688-1.5.219-1.531-.219-1.563-.719-1.219-.813-1.219-.969-.906-.719q-4.375-3.438-6.563-5.188v11.625z'
	    ),
	    'lightbulb' => array(
		'p' => 'M11 5q.438 0 .719.281T12 6t-.281.719T11 7Q9.375 7 8.187 8.188t-1.188 2.813q0 .438-.281.719t-.719.281-.719-.281-.281-.719q0-2.5 1.75-4.25t4.25-1.75zM6 28.688V26h10v2.688q0 .313-.188.563l-1.5 2.313q-.313.438-.875.438H8.562q-.563 0-.875-.438l-1.5-2.313q-.188-.25-.188-.563zM11 0q4.563 0 7.781 3.219T22 11q0 4.125-2.75 7.25-.875 1-1.844 2.656T16 24h-3q0-.438.125-.875Q14.313 19.312 17 16.25 19 14 19 11q0-3.313-2.344-5.656T11 3Q7.75 3 5.375 5.313T3 11.001q0 3 2 5.25 2.688 3.063 3.875 6.875.125.438.125.875H6q-.313-1-.906-2.156t-1.219-2.063-1.125-1.531Q0 15.126 0 11.001q0-4.438 3.156-7.719T11 .001z',
		'w' => .6875,
		'vw' => 22
	    ),
	    'bell' => array(
		'p' => 'M27.438 22.625q.563.625.563 1.375 0 .813-.563 1.406T26 26H2q-.563 0-1.031-.281t-.719-.75T0 24q0-.75.563-1.375.063-.063.188-.25.938-.938 1.469-1.688t1.156-2.844.625-4.844q0-3.625 2.25-6.313t5.75-3.375V1.998q0-.813.594-1.406t1.406-.594 1.406.594.594 1.406v1.313q2.313.438 4.125 1.813t2.844 3.438T24.001 13q0 2.75.625 4.844t1.156 2.844 1.469 1.688q.125.188.188.25zM4.25 23h19.5Q21 19.312 21 13.062v-.063q0-2.875-2.063-4.938t-4.938-2.063-4.938 2.063-2.063 4.938v.063q0 6.25-2.75 9.938zM14 32q-1.625 0-2.813-1.156T9.999 28h8q0 1.688-1.188 2.844T13.998 32z',
		'w' => .875,
		'vw' => 28
	    ),
	    'hospital' => array(
		'p' => 'M8 15.2#m#5q0 .75-.75.75h-2.5Q8 16 8 15.25zm8.75.75q-.75 0-.75-.7#m#5q0 .75-.75.75h-2.5zM12 21.25q0 .75-.75.75h-2.5Q8 22 8 21.2#m#5zm4.75.75q-.75 0-.75-.7#m#5q0 .75-.75.75h-2.5zM28 29.75V32H0v-2.25Q0 29 .75 29H2V5.312q0-.563.438-.938t1.063-.375h5.5v-2.5q0-.625.438-1.063t1.063-.438h7q.625 0 1.063.438t.438 1.063v2.5h5.5q.625 0 1.063.375t.438.938V29h1.25q.75 0 .75.75zm-23-.812h7V24.75q0-.75.75-.75h2.5q.75 0 .75.75v4.188h7V7h-4v1.5q#p#8h-7q-.625 0-1.063-.438T8.998 8.5V7h-4v21.938zM16.625 4H15V2.375Q15 2 14.625 2h-1.25Q13 2 13 2.375V4h-1.625Q11 4 11 4.375v1.25Q11 6 11.375 6H13v1.625Q13 8 13.375 8h1.25Q15 8 15 7.625V6h1.625Q17 6 17 5.625v-1.25Q17 4 16.625 4z',
		'w' => .875,
		'vw' => 28
	    ),
	    'plus-square' => array(
		'p' => 'M22 15v2q0 .75-.75.75h-5.5v5.5q0 .75-.75.75h-2q-.75 0-.75-.75v-5.5h-5.5Q6 17.75 6 17v-2q0-.75.75-.75h5.5v-5.5q0-.75.75-.75h2q.75 0 .75.75v5.5h5.5q.75 0 .75.75zm6-10v22#n# 30H3q-1.25 0-2.125-.875T0 27V5q0-1.25.875-2.125T3 2h22q1.25 0 2.125.875T28 5zm-3 21.625V5.375Q25 5 24.625 5H3.375Q3 5 3 5.375v21.25Q3 27 3.375 27h21.25Q25 27 25 26.625z',
		'w' => .875,
		'vw' => 28
	    ),
	    'circle' => array(
		'p' => '#e##f#'
	    ),
	    'smile' => array(
		'p' => '#d#0 28q5.188 0 8.844-3.656T28 16t-3.656-8.844T15.5 3.5 6.656 7.156 3 16t3.656 8.844T15.5 28.5zm-5-13.5q-.813 0-1.406-.594T8.5 13t.594-1.406T10.5 11t1.406.594T12.5 13t-.594 1.406T10.5 15zm10 0q-.813 0-1.406-.594T18.5 13t.594-1.406T20.5 11t1.406.594T22.5 13t-.594 1.406T20.5 15zm.25 4.563q.375-.5 1-.563t1.094.344.531 1.031-.313 1.063q-2.938 3.563-7.563 3.563t-7.563-3.563q-.375-.438-.313-1.063t.531-1.031T9.248 19t1 .563q2.063 2.438 5.25 2.438t5.25-2.438z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'frown' => array(
		'p' => '#d#0 28q5.188 0 8.844-3.656T28 16t-3.656-8.844T15.5 3.5 6.656 7.156 3 16t3.656 8.844T15.5 28.5zm-5-13.5q-.813 0-1.406-.594T8.5 13t.594-1.406T10.5 11t1.406.594T12.5 13t-.594 1.406T10.5 15zm10-4q.813 0 1.406.594T22.5 13t-.594 1.406T20.5 15t-1.406-.594T18.5 13t.594-1.406T20.5 11zm-5 8q3.938 0 6.5 3.063.375.438.313 1.063t-.5 1q-.5.438-1.125.375t-1-.563Q18.063 22 15.5 22t-4.188 1.938q-.375.5-1 .563t-1.094-.344-.531-1.031T9 22.063Q11.563 19 15.5 19z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'meh' => array(
		'p' => '#d#0 28q5.188 0 8.844-3.656T28 16t-3.656-8.844T15.5 3.5 6.656 7.156 3 16t3.656 8.844T15.5 28.5zm-5-13.5q-.813 0-1.406-.594T8.5 13t.594-1.406T10.5 11t1.406.594T12.5 13t-.594 1.406T10.5 15zm10-4q.813 0 1.406.594T22.5 13t-.594 1.406T20.5 15t-1.406-.594T18.5 13t.594-1.406T20.5 11zm.5 9q.625 0 1.063.438t.438 1.063-.438 1.063-1.063.438H10q-.625 0-1.063-.438t-.438-1.063.438-1.063T10 20h11z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'keyboard' => array(
		'p' => 'M33 4q1.25 0 2.125.875T36 7v18q0 1.25-.875 2.125T33 28H3q-1.25 0-2.125-.875T0 25V7q0-1.25.875-2.125T3 4h30zm.5 21V7q0-.5-.5-.5H3q-.5 0-.5.5v18q0 .5.5.5h30q.5 0 .5-.5zm-22.875-8.125q0 .75-.75.75h-1.75q-.75 0-.75-.75v-1.75q0-.75.75-.75h1.75q.75 0 .75.75v1.75zm6 0q0 .75-.75.75h-1.75q-.75 0-.75-.75v-1.75q0-.75.75-.75h1.75q.75 0 .75.75v1.75zm6 0q0 .75-.75.75h-1.75q-.75 0-.75-.75v-1.75q0-.75.75-.75h1.75q.75 0 .75.75v1.75zm6 0q0 .75-.75.75h-1.75q-.75 0-.75-.75v-1.75q0-.75.75-.75h1.75q.75 0 .75.75v1.75zM7.625 22q0 .75-.75.75h-1.75q-.75 0-.75-.75v-1.75q0-.75.75-.75h1.75q.75 0 .75.75V22zm24 0q0 .75-.75.75h-1.75q-.75 0-.75-.75v-1.75q0-.75.75-.75h1.75q.75 0 .75.75V22zm-24-10.25q0 .75-.75.75h-1.75q-.75 0-.75-.75V10q0-.75.75-.75h1.75q.75 0 .75.75v1.75zm6 0q0 .75-.75.75h-1.75q-.75 0-.75-.75V10q0-.75.75-.75h1.75q.75 0 .75.75v1.75zm6 0q0 .75-.75.75h-1.75q-.75 0-.75-.75V10q0-.75.75-.75h1.75q.75 0 .75.75v1.75zm6 0q0 .75-.75.75h-1.75q-.75 0-.75-.75V10q0-.75.75-.75h1.75q.75 0 .75.75v1.75zm6 0q0 .75-.75.75h-1.75q-.75 0-.75-.75V10q0-.75.75-.75h1.75q.75 0 .75.75v1.75zM25.5 21.625q0 .75-.75.75h-13.5q-.75 0-.75-.75v-1q0-.75.75-.75h13.5q.75 0 .75.75v1z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'calendar' => array(
		'p' => 'M25 4q1.25 0 2.125.875T28 7v22#n# 32H3q-1.25 0-2.125-.875T0 29V7q0-1.25.875-2.125T3 4h3V.75Q6 0 6.75 0h2.5Q10 0 10 .75V4h8V.75q0-.75.75-.75h2.5Q22 0 22 .75V4h3zm-.375 25Q25 29 25 28.625V10H3v18.625Q3 29 3.375 29h21.25z',
		'w' => .875,
		'vw' => 28
	    ),
	    'play-circle' => array(
		'p' => 'M23.25 14.875q.75.438.75 1.313t-.75 1.313l-11 6.313q-.563.25-1.063.156t-.844-.5-.344-.969v-13q0-.875.75-1.313t1.5 0zM31.5 16q0 6.438-4.531 10.969T16 31.5 5.031 26.969.5 16 5.031 5.031 16 .5t10.969 4.531T31.5 16zm-28 0q0 5.188 3.656 8.844T16 28.5t8.844-3.656T28.5 16t-3.656-8.844T16 3.5 7.156 7.156 3.5 16z'
	    ),
	    'minus-square' => array(
		'p' => 'M6.75 17.75Q6 17.75 6 17v-2q0-.75.75-.75h14.5q.75 0 .75.75v2q0 .75-.75.75H6.75z#b#m-3 21.625V5.375Q25 5 24.625 5H3.375Q3 5 3 5.375v21.25Q3 27 3.375 27h21.25Q25 27 25 26.625z',
		'w' => .875,
		'vw' => 28
	    ),
	    'check-square' => array(
		'p' => '#a#m0 25V5H3v22h22zm-2.25-15.125L12 22.563q-.563.563-1.063 0l-5.688-5.688q-.563-.563 0-1.063l1.438-1.438q.5-.5 1.063 0l3.688 3.813 8.875-8.75q.5-.563 1.063 0l1.375 1.375q.563.563 0 1.063z',
		'w' => .875,
		'vw' => 28
	    ),
	    'share-square' => array(
		'p' => 'M35.125 9.875Q36 10.75 36 12t-.875 2.125l-9 9q-1.438 1.438-3.281.656T21 21v-3.375q-3.063.25-4.406.844t-1.344 1.594.5 2.5q.688 2-1 3.281t-3.438.219q-2.5-1.563-3.906-3.906T6 17.001q0-3.688 2.25-6.188 1.875-2.063 5.188-3.125 3-.938 7.563-1.125V3q0-2 1.844-2.75t3.281.625zM24 21l9-9-9-9v6.5q-2.063 0-3.563.094t-3.375.344-3.188.781-2.5 1.313-1.781 2.063-.594 2.906q0 4.063 3.875 6.5-.438-1.375-.563-2.531t.125-2.031.75-1.563 1.313-1.156 1.781-.781 2.25-.531 2.563-.281 2.906-.125v6.5zm1.563 5.25q.688-.188 1.313-.563.375-.25.75-.031t.375.656V29#n#.001 32h-22q-1.25 0-2.125-.875T.001 29V7q0-1.25.875-2.125T3.001 4h8.25q.75 0 .75.75V5q0 .563-.5.75-1.25.5-2.375 1.125Q8.938 7 8.751 7H3.376q-.375 0-.375.375v21.25q0 .375.375.375h21.25q.375 0 .375-.375V27q0-.563.563-.75z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'compass' => array(
		'p' => 'M21.75 8.125q.75-.375 1.375.25t.25 1.375l-4.125 9q-.313.688-1 1l-9 4.125q-.75.375-1.375-.25t-.25-1.375l4.125-9q.313-.688 1-1zm-4.844 9.281q.594-.594.594-1.406t-.594-1.406T15.5 14t-1.406.594T13.5 16t.594 1.406T15.5 18t1.406-.594z#d#0 28q5.188 0 8.844-3.656T28 16t-3.656-8.844T15.5 3.5 6.656 7.156 3 16t3.656 8.844T15.5 28.5z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'caret-square-down' => array(
		'p' => 'M7.813 13h12.375q.5 0 .688.469t-.188.781L14.5 20.438q-.5.5-1 0L7.312 14.25q-.375-.313-.188-.781T7.812 13z#b#m-3 21.625V5.375Q25 5 24.625 5H3.375Q3 5 3 5.375v21.25Q3 27 3.375 27h21.25Q25 27 25 26.625z',
		'w' => .875,
		'vw' => 28
	    ),
	    'caret-square-up' => array(
		'p' => 'M20.188 19H7.813q-.5 0-.688-.469t.188-.781l6.188-6.188q.5-.5 1 0l6.188 6.188q.375.313.188.781t-.688.469z#b#m-3 21.625V5.375Q25 5 24.625 5H3.375Q3 5 3 5.375v21.25Q3 27 3.375 27h21.25Q25 27 25 26.625z',
		'w' => .875,
		'vw' => 28
	    ),
	    'caret-square-right' => array(
		'p' => 'M11 22.188V9.813q0-.5.469-.688t.781.188l6.188 6.188q.5.5 0 1l-6.188 6.188q-.313.375-.781.188T11 22.189z#b#m-3 21.625V5.375Q25 5 24.625 5H3.375Q3 5 3 5.375v21.25Q3 27 3.375 27h21.25Q25 27 25 26.625z',
		'w' => .875,
		'vw' => 28
	    ),
	    'file' => array(
		'p' => '#o#',
		'w' => .75,
		'vw' => 24
	    ),
		'file-o'=>'file',
	    'file-alt' => array(
			'p' => 'M18 15.5v1.75q0 .75-.75.75H6.75Q6 18 6 17.25V15.5q0-.75.75-.75h10.5q.75 0 .75.75zm-.75 4.5q.75 0 .75.75v1.75q0 .75-.75.75H6.75q-.75 0-.75-.75v-1.75q0-.75.75-.75h10.5zM24 8.25V29q0 1.25-.875 2.125T21 32H3q-1.25 0-2.125-.875T0 29V3Q0 1.75.875.875T3 0h12.75Q17 0 17.875.875l5.25 5.25Q24 7 24 8.25zm-8-5V8h4.75zM21 29V11h-6.5q-.625 0-1.063-.438t-.438-1.063v-6.5h-10v26h18z',
			'w' => .75,
			'vw' => 24
	    ),
		'file-text-o'=>'file-alt',
		'fa-file-text'=>'file-alt',
	    'thumbs-up' => array(
		'p' => 'M29.125 17.938q.438 2.063-.563 3.938.313 2.25-1.063 4.188-.063 1.75-.781 3.063t-2.313 2.094-3.969.781h-1.375q-2.813 0-4.969-.625t-3.625-1.25-2.531-.625q-.188.625-.719 1.063t-1.219.438h-4q-.813 0-1.406-.594t-.594-1.406v-15q0-.813.594-1.406t1.406-.594h6.188q.5-.438 1.25-1.438t1.594-2.094 1.469-1.656q.188-.25.563-2.063t1.281-3.281T16.937.002q2.813 0 4.406 1.625t1.594 4.938q0 1.438-.563 2.875h2.25q1.5 0 2.75.781t1.938 2T30 14.815q0 1.625-.875 3.125zm-3.812 3.375q.938-.938.969-2.219t-.656-1.906q.438 0 .906-.75t.469-1.625-.688-1.625-1.688-.75h-6.5q0-1.125.906-2.906t.906-2.969q0-.625-.031-.969t-.188-.906-.438-.875-.875-.563T16.936 3q-.5.5-.938 2.719T14.56 8.938q-.438.438-1.313 1.594t-1.563 2.063-1.531 1.656-1.469.75h-.688v11.625q1.563 0 4.969 1.188t5.781 1.188h2.313q4 0 3.375-4.125.75-.438 1.063-1.5t-#q#063zM5.5 27q0-.625-.438-1.063t-1.063-.438-1.063.438T2.498 27t.438 1.063 1.063.438 1.063-.438T5.5 27z',
		'w' => .9375,
		'vw' => 30
	    ),
	    'thumbs-down' => array(
		'p' => 'M29.125 14.063q.875 1.5.875 3.125 0 2.125-1.563 3.75t-3.813 1.625h-2.25q.563 1.438.563 2.875 0 3.313-1.594 4.938t-4.406 1.625q-1.688 0-2.594-1.469t-1.281-3.281-.563-2.063q-.688-.688-2#q#656t-2.125-2.531h-.438q-.625 1-1.75 1h-4q-.813 0-1.406-.594t-.594-1.406v-15q0-.813.594-1.406t1.406-.594h4q.75 0 1.313.5h.688q.938 0 2.375-.625T14.03.626t5.031-.625h1.375q3.5 0 5.25 1.594t1.813 4.344q1.375 1.938 1.063 4.188 1 1.875.563 3.938zM4 18.5q.625 0 1.063-.438t.438-1.063-.438-1.063T4 15.498t-1.063.438-.438 1.063.438 1.063T4 18.5zm20.625 1.063q.625 0 1.188-.344t.875-.906.313-1.125q0-.875-.469-1.625t-.906-.75q.688-.625.656-1.906t-.969-2.219q.5-1 #q#063t-1.063-1.5Q25.063 3 21.063 3H18.75q-2.375 0-5.781 1.188T8 5.376v11.625h.688q.75 0 1.813 1.094t2.313 2.781 1.75 2.188q1 1 1.438 3.219t.938 2.719q1.063 0 1.719-.313t.906-.938.313-1.063.063-1.25q0-1.188-.906-2.969t-.906-2.906h6.5z',
		'w' => .9375,
		'vw' => 30
	    ),
	    'sun' => array(
		'p' => 'M30.875 13.875Q32 14.625 32 15.969t-1.125 2.094l-3.75 2.563.875 4.438q.25 1.313-.688 2.25t-2.25.688l-4.438-.875-2.5 3.75q-.813 1.125-2.156 1.125t-2.094-1.125l-2.5-3.75-4.438.875q-1.313.25-2.25-.688t-.688-2.313l.875-4.375-3.75-2.563q-1.125-.75-1.125-2.094t1.125-2.094l3.75-2.563-.875-4.438q-.25-1.313.688-2.25t2.25-.688l4.438.875 2.5-3.75q.75-1.063 2.125-1.063t2.125 1.063l2.5 3.75 4.438-.875q1.313-.25 2.25.688T28 6.874l-.875 4.438zm-7.062 5.375l4.813-3.313-4.813-3.25 1.125-5.688-5.688 1.125L16 3.311l-3.25 4.813-5.688-1.125 1.125 5.688-4.813 3.25 4.813 3.25-1.125 5.75 5.688-1.125L16 28.625l3.25-4.813 5.688 1.125zM16 9.5q2.688 0 4.594 1.906T22.5 16t-1.906 4.594T16 22.5t-4.594-1.906T9.5 16t1.906-4.594T16 9.5zm0 10q1.438 0 2.469-1.031T19.5 16t-1.031-2.469T16 12.5t-2.469 1.031T12.5 16t1.031 2.469T16 19.5z'
	    ),
	    'moon' => array(
		'p' => 'M17.438 32q-6.625 0-11.313-4.688T1.437 15.999 6.125 4.686 17.438-.002q1.5 0 2.938.25 1.313.25 2 1.344t.406 2.344-1.469 1.875q-1.938 1.125-3.094 3.063t-1.156 4.188q0 3.938 3.031 6.438T27 21.25q2.063-.375 3.125 1.406t-.25 3.406q-2.25 2.813-5.5 4.375T17.437 32zm0-29Q12.063 3 8.25 6.813t-3.813 9.188 3.813 9.188 9.188 3.813q3 0 5.656-1.281t4.469-3.531q-5.25 1-9.375-2.406t-4.125-8.719q0-3.125 1.563-5.75t4.188-4.125q-1.188-#q#375-.188z',
		'w' => .998046875
	    ),
	    'caret-square-left' => array(
		'p' => 'M17 9.813v12.375q0 .5-.469.688t-.781-.188L9.562 16.5q-.5-.5 0-1l6.188-6.188q.313-.375.781-.188t.469.688z#b#m-3 21.625V5.375Q25 5 24.625 5H3.375Q3 5 3 5.375v21.25Q3 27 3.375 27h21.25Q25 27 25 26.625z',
		'w' => .875,
		'vw' => 28
	    ),
	    'dot-circle' => array(
		'p' => 'M16 3.5q-5.188 0-8.844 3.656T3.5 16t3.656 8.844T16 28.5t8.844-3.656T28.5 16t-3.656-8.844T16 3.5zm0-3q6.438 0 10.969 4.531T31.5 16t-4.531 10.969T16 31.5 5.031 26.969.5 16 5.031 5.031 16 .5zM16 11q2.063 0 3.531 1.469T21 16t-1.469 3.531T16 21t-3.531-1.469T11 16t1.469-3.531T16 11z'
	    ),
	    'building' => array(
		'p' => 'M8 9.25v-2.5Q8 6 8.75 6h2.5q.75 0 .75.75v2.5q0 .75-.75.75h-2.5Q8 10 8 9.25zm8.75.75Q16 10 16 9.2#m#5q0 .75-.75.75h-2.5zm-8 6Q8 16 8 15.2#m#5q0 .75-.75.75h-2.5zm8 0q-.75 0-.75-.7#m#5q0 .75-.75.75h-2.5zM12 21.25q0 .75-.75.75h-2.5Q8 22 8 21.2#m#5zm4.75.75q-.75 0-.75-.7#m#5q0 .75-.75.75h-2.5zM28 29.75V32H0v-2.25Q0 29 .75 29H2V1.5q0-.625.438-1.063t1.063-.438h21q.625 0 1.063.438t.438 1.063V29h1.25q.75 0 .75.75zm-23-.812h7V24.75q0-.75.75-.75h2.5q.75 0 .75.75v4.188h7V3.063L5 3v25.938z',
		'w' => .875,
		'vw' => 28
	    ),
	    'file-pdf' => array(
		'p' => '#o#m15.625-9q.625.5.313 1.469t-1.375.969q-1.563 0-3.5-1.063-.938.188-4.313 1.25-2.438 4.25-4.125 3.188-.75-.438-.625-1.25.313-1.375 3#q#875 1-1.75 2.25-4.625-.813-3-.438-4.188.188-.938 1.313-.875t1.313 1.25q.313.875-.313 3.5.75 1.938 2.313 2.875 3.188-.438 4 .375zM6.25 24.875q0 .063.219-.094t.688-.688.969-1.406q-1.625 1.563-1.875 2.188zM11.375 13q-.125 0-.125.438t.031 1.063.219 1q.188-.375.188-1.438T11.375 13zm-1.562 8.5q2.813-1.063 3.438-1.188-1.125-.813-1.875-2.25-#r#188-1.563 3.438zm8.25-.312q.313-.188-.344-.375t-1.969-.125q.875.375 1.469.5t.719.063z',
		'w' => .75,
		'vw' => 24
	    ),
	    'file-word' => array(
		'p' => '#o#m13.75-13h1q.25 0 .438.125t.25.344.063.469q-.625 2.375-2.188 8.5-.125.563-.75.563h-1.5q-.625 0-.75-.563-.438-1.813-1.125-4.5L12 19.875q0 .5-.188 1.063l-1.125 4.5q-.125.563-.688.563H8.436q-.625 0-.75-.563-.188-.688-.594-2.406t-.844-3.469-.625-2.625q-.125-.375.125-.656t.563-.281h1.063q.625 0 .75.625 1.188 6 1.188 6.188 0 .063.063.25 0-.375 1.5-6.5.188-.563.75-.563h.813q.625 0 .75.563 1.438 6.063 1.5 6.25v.25q.063-.375 1.313-6.438.125-.625.75-.625z',
		'w' => .75,
		'vw' => 24
	    ),
	    'file-excel' => array(
		'p' => '#o#m13.25-15q.438 0 .656.375t-.031.75Q14.687 18.938 14 20l2.875 4.875q.25.375.031.75T16.25 26h-1.813q-.438 0-.625-.375-.125-.188-1.813-3.625-.75 1.688-1.813 3.625-.188.375-.625.375H7.748q-.438 0-.656-.375t.031-.75L9.998 20l-2.875-4.875q-.25-.375-.031-.75T7.748 14h1.813q.438 0 .688.375.563 1.125 1.75 3.625.563-1.375 1.813-3.625Q14 14 14.437 14h1.813z',
		'w' => .75,
		'vw' => 24
	    ),
	    'file-powerpoint' => array(
		'p' => '#o#m4.5-3.75v-10.5q0-.75.75-.75h4.313q1.75 0 2.844 1.156t1.094 2.969q0 .688-.125 1.25t-.313.969-.531.75-.625.531-.75.344-.781.219-.813.094-.75.031H10.5v2.938q0 .313-.219.531t-.531.219h-1.5q-.75 0-.75-.75zm3-5.437H12q.688 0 1.094-.469t.406-1.188T13.094 17 12 16.562h-1.5v3.25z',
		'w' => .75,
		'vw' => 24
	    ),
	    'file-image' => array(
		'p' => '#o#m2-3v-4l2.5-2.5q.5-.5 1 0L11 22l5.5-5.5q.5-.5 1 0L19 18v8H5zm3-15q1.25 0 2.125.875T11 14t-.875 2.125T8 17t-2.125-.875T5 14t.875-2.125T8 11z',
		'w' => .75,
		'vw' => 24
	    ),
		'file-photo'=>'file-image',
		'file-photo-o'=>'file-image',
		'file-picture-o'=>'file-image',
	    'file-archive' => array(
		'p' => 'M8 10h2v2H8v-2zm4-6v2h-2V4h2zM8 6h2v2H8V6zm4 2v2h-2V8h2zm11.125-1.875Q24 7 24 8.25V29q0 1.25-.875 2.125T21 32H3q-1.25 0-2.125-.875T0 29V3Q0 1.75.875.875T3 0h12.75Q17 0 17.875.875zM16 3.25V8h4.75zM21 29V11h-6.5q-.625 0-1.063-.438t-.438-1.063v-6.5h-3v1h-2v-1h-5v26h18zm-8.875-12.375l1.125 5.438q.188 1-.219 1.906t-1.219 1.469-1.813.563q-1.563 0-2.531-1.219t-.656-2.719L8 16v-2h2v2h1.375q.625 0 .75.625zm-2.094 7.75q.844 0 1.438-.5t.594-1.188q0-.438-.281-.844t-.75-.625-1.031-.219-1 .219-.719.625-.281.844q0 .688.594 1.188t1.438.5zM12 12v2h-2v-2h2z',
		'w' => .75,
		'vw' => 24
	    ),
	    'file-audio' => array(
		'p' => '#o#m9-4.75q0 .5-.469.688t-.781-.188L8.5 22.5H6.75q-.313 0-.531-.219T6 21.75v-3.5q0-.25.219-.5t.531-.25H8.5l2.25-2.25q.313-.375.781-.188t.469.688v8.5zm2.563-2.937q.438-.438.438-1.063t-.438-1.063q-.625-.625-.344-1.469t1.031-1.031 1.5.438Q18 18.438 18 20.25t-1.25 3.125q-.688.688-1.5.438t-1.031-1 .344-1.5z',
		'w' => .75,
		'vw' => 24
	    ),
	    'file-video' => array(
		'p' => '#o#m14.313-13.187q.438-.5 1.063-.25t.625.938v7q0 .688-.625.938t-1.063-.25L14 20.939v2.313q0 .5-.375.875t-.875.375h-6.5q-.5 0-.875-.375T5 23.252v-6.5q0-.5.375-.875t.875-.375h6.5q.5 0 .875.375t.375.875v2.313z',
		'w' => .75,
		'vw' => 24
	    ),
	    'file-code' => array(
		'p' => 'M9.375 21.813q.375.375 0 .813l-1.063 1.125q-.188.188-.438.188-.188 0-.375-.188l-3.563-3.375q-.438-.375 0-.75l3.563-3.375q.438-.438.813 0l1.063 1.125v.063q.375.375 0 .75l-2.063 1.813zm13.75-15.688Q24 7 24 8.25V29q0 1.25-.875 2.125T21 32H3q-1.25 0-2.125-.875T0 29V3Q0 1.75.875.875T3 0h12.75Q17 0 17.875.875zM16 3.25V8h4.75zM21 29V11h-6.5q-.625 0-1.063-.438t-.438-1.063v-6.5h-10v26h18zm-7.875-15.625l1.5.438q.563.125.375.688l-3.438 11.75q-.125.563-.688.375l-1.5-.438q-.563-.125-.375-.688l3.438-11.75q.125-.5.688-.375zm1.5 4.813q-.375-.375 0-.813l1.063-1.125q.375-.438.813 0l3.563 3.375q.438.375 0 .75l-3.563 3.375q-.438.438-.813 0l-1.063-1.125v-.063q-.375-.375 0-.75l2.063-1.813z',
		'w' => .75,
		'vw' => 24
	    ),
	    'life-ring' => array(
		'p' => 'M16 31.5q-6.438 0-10.969-4.531T.5 16 5.031 5.031 16 .5t10.969 4.531T31.5 16t-4.531 10.969T16 31.5zm-6.437-4.812q2.938 1.813 6.438 1.813t6.438-1.813l-3.313-3.313q-3.125 1.313-6.25 0zM21 16q0-2.063-1.469-3.531T16 11t-3.531 1.469T11 16t1.469 3.531T16 21t3.531-1.469T21 16zm5.688 6.438Q28.501 19.5 28.501 16t-1.813-6.438l-3.313 3.313q1.313 3.125 0 6.25zm-4.25-17.125Q19.5 3.5 16 3.5T9.562 5.313l3.313 3.313q3.125-1.313 6.25 0zM5.313 9.563Q3.5 12.501 3.5 16.001t1.813 6.438l3.313-3.313q-1.313-3.125 0-6.25z'
	    ),
	    'paper-plane' => array(
		'p' => 'M27.5.375q1.625-.875 3.188.156t1.313 2.906l-3.75 24.25q-.25 1.438-1.5 2.125-.688.375-1.438.375-.625 0-1.188-.188l-7-2.875-2.688 3.688q-.875 1.063-2.156 1.188T10 31.25 9 29v-5.25l-7.125-3Q.125 20.062 0 18.187t1.5-2.813zM12 29l2.313-3.125L12 24.937V29zm13.313-1.812L29.001 3l-26 15 6.75 2.813L22.939 9.25q.688-.563 1.344.031t.156 1.344l-8.75 12.625z'
	    ),
	    'futbol' => array(
		'p' => 'M30.25 11.188q2 6.125-.938 11.844t-9 7.719q-2.375.75-4.813.75-4.938 0-9.063-2.938t-5.688-7.75q-2-6.125.938-11.844t9-7.719Q13.061.5 15.499.5q3.25 0 6.219 1.313t5.219 3.75 3.313 5.625zm-4.687 12.125q.75-1 1.063-1.625 1.313-2.625 1.375-5.563l-2.438-2.313-4.438 1.375-1.563 4.75 2.75 3.813zm0-14.688q-2.313-3.25-6.125-4.5L16.5 5.75v4.625l4 2.938 4.438-1.375zm-14-4.5q-3.75 1.25-6.125 4.5l.625 3.313 4.438 1.375 4-2.938V5.75zM8.688 23.75l2.688-3.875-1.5-4.625-4.438-1.438L3 16.125q.063 3.938 2.375 7.188zm3 4.125q3.625 1.188 7.625 0l1.375-3-2.75-3.813H13l-2.688 3.813z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'newspaper' => array(
		'p' => 'M34.5 4q.625 0 1.063.438t.438 1.063v21q#p#8h-31q-1.438 0-2.469-1.031T0 24.502v-17q0-.625.438-1.063t1.063-.438h2.688q.313-.875 1.094-1.438T7.002 4h27.5zM3 24.5q0 .5.5.5t.5-.5V9H3v15.5zm30 .5V7H7v17.5q0 .25-.063.5H33zm-22.25-7.5q-.75 0-.75-.75v-6q0-.75.75-.75h8.5q.75 0 .75.75v6q0 .75-.75.75h-8.5zm1.75-5V15h5v-2.5h-5zM10 21.25v-1.5q0-.75.75-.75h8.5q.75 0 .75.75v1.5q0 .75-.75.75h-8.5q-.75 0-.75-.75zm12 0v-1.5q0-.75.75-.75h6.5q.75 0 .75.75v1.5q0 .75-.75.75h-6.5q-.75 0-.75-.75zm0-9v-1.5q0-.75.75-.75h6.5q.75 0 .75.75v1.5q0 .75-.75.75h-6.5q-.75 0-.75-.75zm0 4.5v-1.5q0-.75.75-.75h6.5q.75 0 .75.75v1.5q0 .75-.75.75h-6.5q-.75 0-.75-.75z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'bell-slash' => array(
		'p' => 'M39.625 29.438q.75.625.125 1.438l-.625.75q-.625.75-1.375.125L.375 2.563q-.75-.625-.125-1.438l.625-.75Q1.5-.375 2.25.25zM10.25 23h11.375l3.875 3H8q-.875 0-1.438-.594T5.999 24q0-.75.563-1.375l.188-.188q.5-.563.781-.875t.781-1.125.781-1.625.563-2.125.281-2.813l2.875 2.188q-.563 4.25-2.563 6.938zM20 6q-2.125 0-3.938 1.188l-2.375-1.813Q15.625 3.812 18 3.312V1.999q0-.813.594-1.406T20-.001t1.406.594T22 1.999v1.313q2.313.438 4.125 1.813t2.844 3.438T30 13.001q0 3.438.875 5.813l-3.688-2.938q-.188-1.438-#q#813V13q0-2.875-2.063-4.938t-4.938-2.063zm0 26q-1.625 0-2.813-1.156T15.999 28h8q0 1.063-.531 2t-1.469 1.469-2 .531z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'copyright' => array(
		'p' => '#e##f#m6.688-6.312q-2.563 2.563-6.5 2.563-3.813 0-6.281-2.531t-2.469-6.281q0-2.438 1.125-4.438t3.125-3.156 4.5-1.156q3.688 0 6.063 2.188.25.25.25.563 0 .188-.125.375l-1.125 1.813q-.438.688-1.125.125-1.75-1.375-3.813-1.375-1.5 0-2.625.656T12 13.347t-.563 2.531q0 2.125 1.313 3.688t3.563 1.563 4.125-1.688q.25-.25.563-.219t.563.281l1.25 1.688q.125.25.125.5t-.25.5z'
	    ),
	    'closed-captioning' => array(
		'p' => 'M29 4q1.25 0 2.125.875T32 7v18q0 1.25-.875 2.125T29 28H3q-1.25 0-2.125-.875T0 25V7q0-1.25.875-2.125T3 4h26zm-.375 21Q29 25 29 24.625V7.375Q29 7 28.625 7H3.375Q3 7 3 7.375v17.25Q3 25 3.375 25h25.25zm-13.187-5.375q.188.25-.063.5-1.625 1.75-4.188 1.906T6.624 20.5t-2-4.625q0-2.875 2.031-4.5t4.594-1.531 4.125 1.656q.188.188.063.375l-1.063 1.875q-.25.375-.625.125-1.875-1.5-3.875-.844t-2 2.781q0 2.313 1.906 3.031t3.844-.969q.313-.313.563.063zm11.875 0q.188.25 0 .5-1.688 1.75-4.25 1.906T18.5 20.5t-2-4.625q0-2.875 2.031-4.5t4.594-1.531T27.25 11.5q.188.188.125.375L26.25 13.75q-.25.375-.563.125-1.938-1.5-3.938-.844t-2 2.781q0 2.313 1.938 3.031t3.813-.969q.375-.313.625.063z'
	    ),
	    'object-group' => array(
		'p' => 'M31.25 8h-.75v16h.75q.75 0 .75.75v4.5q0 .75-.75.75h-4.5q-.75 0-.75-.75v-.75H6v.75q0 .75-.75.75H.75Q0 30 0 29.25v-4.5Q0 24 .75 24h.75V8H.75Q0 8 0 7.25v-4.5Q0 2 .75 2h4.5Q6 2 6 2.75v.75h20v-.75q0-.75.75-.75h4.5q.75 0 .75.75v4.5q0 .75-.75.75zM28 4v2h2V4h-2zM2 4v2h2V4H2zm2 24v-2H2v2h2zm26 0v-2h-2v2h2zm-2.5-4V8h-.75Q26 8 26 7.25V6.5H6v.75Q6 8 5.25 8H4.5v16h.75q.75 0 .75.75v.75h20v-.75q0-.75.75-.75h.75zm-2.25-12q.75 0 .75.75v10.5q0 .75-.75.75h-12.5q-.75 0-.75-.75V20H6.75Q6 20 6 19.25V8.75Q6 8 6.75 8h12.5q.75 0 .75.75V12h5.25zM8.5 10.5v7h9v-7h-9zm15 11v-7H20v4.75q0 .75-.75.75H14.5v1.5h9z'
	    ),
	    'object-ungroup' => array(
		'p' => 'M35.25 14h-.75v10h.75q.75 0 .75.75v4.5q0 .75-.75.75h-4.5q-.75 0-.75-.75v-.75H16v.75q0 .75-.75.75h-4.5q-.75 0-.75-.75v-4.5q0-.75.75-.75h.75v-1.5H6v.75q0 .75-.75.75H.75Q0 24 0 23.25v-4.5Q0 18 .75 18h.75V8H.75Q0 8 0 7.25v-4.5Q0 2 .75 2h4.5Q6 2 6 2.75v.75h14v-.75q0-.75.75-.75h4.5q.75 0 .75.75v4.5q0 .75-.75.75h-.75v1.5H30v-.75q0-.75.75-.75h4.5q.75 0 .75.75v4.5q0 .75-.75.75zM22 4v2h2V4h-2zm0 16v2h2v-2h-2zM4 22v-2H2v2h2zM4 6V4H2v2h2zm2 13.5h14v-.75q0-.75.75-.75h.75V8h-.75Q20 8 20 7.25V6.5H6v.75Q6 8 5.25 8H4.5v10h.75q.75 0 .75.75v.75zm8 8.5v-2h-2v2h2zm17.5-4V14h-.75q-.75 0-.75-.75v-.75h-5.5V18h.75q.75 0 .75.75v4.5q0 .75-.75.75h-4.5q-.75 0-.75-.75v-.75h-5.5V24h.75q.75 0 .75.75v.75h14v-.75q0-.75.75-.75h.75zm2.5 4v-2h-2v2h2zm0-16v-2h-2v2h2z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'sticky-note' => array(
		'p' => 'M28 21.75q0 1.25-.875 2.125l-5.25 5.25Q21 30 19.75 30H3q-1.25 0-2.125-.875T0 27V5q0-1.25.875-2.125T3 2h22q1.25 0 2.125.875T28 5v16.75zm-8 5L24.75 22H20v4.75zM25 5H3v22h14v-6.5q0-.625.438-1.063t1.063-.438h6.5v-14z',
		'w' => .875,
		'vw' => 28
	    ),
	    'clone' => array(
		'p' => 'M29 0q1.25 0 2.125.875T32 3v20q0 1.25-.875 2.125T29 26h-3v3q0 1.25-.875 2.125T23 32H3q-1.25 0-2.125-.875T0 29V9q0-1.25.875-2.125T3 6h3V3q0-1.25.875-2.125T9 0h20zm-6.375 29Q23 29 23 28.625V26H9q-1.25 0-2.125-.875T6 23V9H3.375Q3 9 3 9.375v19.25Q3 29 3.375 29h19.25zm6-6Q29 23 29 22.625V3.375Q29 3 28.625 3H9.375Q9 3 9 3.375v19.25Q9 23 9.375 23h19.25z'
	    ),
	    'hourglass' => array(
		'p' => 'M23 3q0 3.938-1.563 7.531T16.937 16q2.938 1.875 4.5 5.469T23 29h.25q.75 0 .75.75v1.5q0 .75-.75.75H.75Q0 32 0 31.25v-1.5Q0 29 .75 29H1q0-3.938 1.563-7.531T7.063 16q-2.938-1.875-4.5-5.469T1 3H.75Q0 3 0 2.25V.75Q0 0 .75 0h22.5Q24 0 24 .75v1.5q0 .75-.75.75H23zM4 3q0 4.75 2.344 8.125T12 14.5t5.656-3.375T20 3H4zm16 26q0-4.75-2.344-8.125T12 17.5t-5.656 3.375T4 29h16z',
		'w' => .75,
		'vw' => 24
	    ),
	    'hand-rock' => array(
		'p' => 'M25.563 4.938q2.25-1 4.344.375t2.094 3.875v7.125q0 1.5-.563 2.813l-2.688 6.25q-.25.563-.25 2.625 0 .813-.594 1.406t-1.406.594H10.75q-.813 0-1.406-.594t-.594-1.406v-1.656l-.031-.156-.031-.094-.031-.063-.094-.094-6.125-5.313Q0 18.5 0 15.25v-3.563q0-2.188 1.75-3.563t3.938-.875q.125-2.563 2.406-3.813t4.531 0Q14 1.998 16 1.998t3.375 1.438q1.5-.875 3.313-.469t2.875 1.969zM29 16.313V9.188q0-1-.813-1.406t-1.625 0-.813 1.344q0 .438-.281.719t-.719.281h-.438q-.438 0-.719-.281t-.281-.719V7.501q0-1.063-.813-1.469t-1.625 0-.813 1.406v1.688q0 .438-.281.719t-.719.281h-.438q-.438 0-.719-.281t-.281-.719v-2.5q0-1-.813-1.438t-1.625-.031-.813 1.406v2.563q0 .438-.281.719t-.719.281h-.438q-.438 0-.719-.281t-.281-.719V7.501q0-1.063-.813-1.469t-1.625 0-.813 1.406v7.25q0 .438-.281.719t-.719.281q-.375 0-.688-.25l-.438-.375q-.313-.25-.313-.75V11.75q0-1-.813-1.406t-1.625 0-.813 1.344v3.563q0 1.875 1.438 3.125l6.063 5.313q1.25 1.063 1.25 2.688v.625h13.75v-.438q0-1.25.5-2.375l2.688-6.25q.313-.75.313-1.625z'
	    ),
	    'hand-paper' => array(
		'p' => 'M23.313 7.063q1.813-.313 3.25.969t1.438 3.156v8.25q0 1.438-.313 2.813l-1.875 8.188q-.188.688-.719 1.125t-1.281.438H9.938q-1.063 0-1.688-.813L.812 20.626q-1-1.375-.75-3.094t1.625-2.719Q3.5 13.5 5.562 14.25V6.375q0-2.063 1.594-3.313t3.594-.75q1.125-2.25 3.625-2.313t3.75 2.25q1.938-.5 3.563.781t1.625 3.344v.688zM25 19.438v-8.25q0-.75-.563-1.063t-1.156 0-.594 1.125V16q0 .438-.281.719t-.719.281h-.375q-.438 0-.719-.281T20.312 16V6.375q0-.75-.594-1.094t-1.156-.031-.563 1.063v9.688q0 .438-.281.719t-.719.281h-.438q-.375 0-.688-.281t-.313-.719V4.251q0-.75-.563-1.094t-1.125-.031-.563 1.063v11.813q0 .438-.313.719t-.688.281h-.438q-.438 0-.719-.281t-.281-.719V6.439q0-.75-.594-1.094T9.12 5.314t-.563 1.063v12.875q0 .75-.688.969t-1.125-.344l-1.688-2.375q-.25-.375-.625-.469t-.688.031-.531.406-.219.656.25.75l7.188 10.125h12.625l1.688-7.438q.25-1.063.25-2.125z',
		'w' => .875,
		'vw' => 28
	    ),
	    'hand-scissors' => array(
		'p' => 'M16 30q-2.125 0-3.375-1.688T12 24.624q-1-.625-1.531-1.719t-.344-2.344h-5.5q-1.938 0-3.281-1.344T0 15.998t1.344-3.219 3.281-1.344l5.875.563-4.938-1.188q-1.813-.688-2.563-2.438t-.063-3.5 2.438-2.5 3.563-.063L18 5.809q2.688-3.313 5.75-1.563l6.125 3.438Q32 8.872 32 11.309v12.813q0 1.438-.906 2.594t-2.344 1.469l-7.438 1.688q-.438.125-.938.125h-4.375zm0-3h4.375q.125 0 .25-.063l7.438-1.688q.938-.188.938-1.125V11.311q0-.688-.563-1l-6.125-3.438q-.938-.5-1.563.25l-1.375 1.688q-.313.375-.75.375-.188 0-.375-.063l-10.375-4q-1.438-.563-2.063.688-.688 1.313.5 2.063.188.063.313.188l9.75 3.688q.625.25.625.938v.75q0 .375-.281.688t-.719.313H4.625q-1 0-1.438.781t0 1.563 1.438.781H16q.438 0 .719.313t.281.688v.438q0 .438-.281.719t-.719.281h-1.75q-.75 0-1.063.563t0 1.156 1.063.594H16q.438 0 .719.281t.281.719v.375q0 .438-.281.719t-.719.281q-.75 0-1.063.594t0 1.156 1.063.563z'
	    ),
	    'hand-lizard' => array(
		'p' => 'M34.813 18.188q1.188 1.813 1.188 4.063v7.75h-14v-4.5l-6.25-2.375q-.25-.125-.5-.125h-8.25q-1.438 0-2.469-1.031t-1.031-2.469q0-2.25 1.625-3.875t3.875-1.625h7.125l1.125-3H5.001q-2.063 0-3.531-1.469T.001 6.001v-.5q0-1.438 1.031-2.469t2.469-1.031h18.375q2.438 0 3.75 2.063zM33 27v-4.75q0-1.313-.75-2.438L23.125 5.687q-.438-.688-1.25-.688H3.5q-.5 0-.5.5v.5q0 .813.594 1.406T5 7.999h13.313q1.188 0 1.875.969t.25 2.094l-1.5 4q-.25.563-.688 1t-1 .688-1.125.25H9q-1.063 0-1.781.719T6.5 19.5q0 .5.5.5h8.25q.813 0 1.625.313l6.188 2.438q.875.313 1.406 1.063T25 25.502v1.5h8z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'hand-spock' => array(
		'p' => 'M1.313 23.875Q.063 22.687 0 20.937t1.125-3q1.125-1.188 2.781-1.313t2.969.938l-1.938-8.5q-.438-1.938.781-3.5t3.219-1.625Q9 2.562 9.906 1.499T12.187.124q1.688-.375 3.156.531t1.844 2.594l1.375 8.25 1.063-6.563Q20 3.248 21.5 2.342t3.188-.469q1.25.313 2.063 1.25t1.063 2.125q2 0 3.281 1.594t.781 3.594l-2 8.313q-.063.375-.063.75v2.313q0 1.063-.313 2.063l-2 6.688q-.188.625-.719 1.031T25.625 32H10.75q-.813 0-1.375-.563zM3.344 20Q3 20.375 3 20.844t.375.844l7.75 7.313h13.75l1.75-6q.188-.563.188-1.188V19.5q0-.75.188-1.438l1.938-8.375q.188-.688-.313-1.125t-1.156-.281-.781.906l-1.688 7.063q-.188.75-1 .75h-.625q-.438 0-.75-.375t-.188-.875l2.375-9.5q.125-.438-.063-.813t-.5-.531-.656-.156-.656.219-.438.656L19.875 16.25q-.188.75-1 .75h-.813q-.813 0-1-.75L14.249 3.937q-.188-.75-.813-.906t-1.156.281-.344 1.125l2.625 11.313q.063.25 0 .469t-.188.406-.344.281-.469.094h-.5q-.813 0-1-.75l-1.875-8.375q-.188-.75-.844-.906t-1.156.281-.375 1.125l2.188 9.375v4.563q0 .688-.594.938t-1.094-.188l-3.313-3.125q-.375-.313-.844-.313T3.34 20z'
	    ),
	    'hand-pointer' => array(
		'p' => 'M22.375 11.188q2.063-.75 3.844.5T28 15.126v5.25q0 .5-.125.938l-1.688 7.438q-.313 1.438-1.469 2.344t-2.594.906H10.999q-2.125 0-3.375-1.75L.811 20.627q-1-1.375-.75-3.094t1.625-2.719q1.813-1.313 3.875-.563V4.188q0-1.75 1.219-2.969T9.718 0t2.938 1.219 1.219 2.969v4.625q2.063-.313 3.5 1.188 1.313-.625 2.719-.281t2.281 1.469zM5.063 17.5q-.438-.625-1.094-.5t-.875.688.156 1.188l6.813 9.625q.375.5.938.5h11.125q.938 0 1.125-.938l1.688-7.438q.063-.125.063-.25v-5.25q0-.75-.563-1.063t-1.156 0-.594 1.063q0 .25-.125.5T22.22 16t-.531.125h-.375q-.438 0-.719-.281t-.281-.719v-1.313q0-.75-.594-1.063t-1.156 0-.563 1.063v1.313q0 .438-.281.719t-.719.281h-.438q-.25 0-.5-.125t-.375-.375-.125-.5v-2.188q0-.75-.563-1.063t-1.125 0-.563 1.063v2.188q0 .25-.156.5t-.375.375-.469.125h-.438q-.438 0-.719-.281t-.281-.719V4.187q0-.75-.594-1.063t-1.156 0-.563 1.063V19.25q0 .75-.688.969t-1.125-.344zM11 25v-6q0-.438.25-.719t.625-.281h.375q.375 0 .625.281t.25.719v6q0 .188-.063.375t-.188.313-.281.219-.344.094h-.375q-.375 0-.625-.281t-.25-.719zm4.75 0v-6q0-.438.25-.719t.625-.281H17q.313 0 .594.281t.281.719v6q0 .438-.281.719T17 26h-.375q-.375 0-.625-.281T15.75 25zm4.688 0v-6q0-1 .875-1h.375q.875 0 .875 1v6q0 1-.875 1h-.375q-.875 0-.875-1z',
		'w' => .875,
		'vw' => 28
	    ),
	    'hand-peace' => array(
		'p' => 'M22.625 12q1.313-.438 2.563 0t2.031 1.531T28 16v4.375q0 .5-.125.938l-1.688 7.438q-.313 1.438-1.469 2.344t-2.594.906H9.311q-2.438 0-3.625-2.125l-3.438-6.125q-1.75-3.063 1.563-5.75l-3.5-9.063q-.688-1.813.063-3.563t2.5-2.438q1.25-.438 2.406-.281t2.125.938 1.406 1.969l1.188 4.938-.563-5.875q0-1.938 1.344-3.281T13.999.001t3.219 1.344 1.344 3.281v5.5q1.25-.188 2.344.344t1.719 1.531zM25 20.375V16q0-.75-.563-1.063t-1.156 0T22.687 16q0 .438-.281.719t-.719.281h-.375q-.438 0-.719-.281T20.312 16v-1.75q0-.75-.594-1.063t-1.156 0-.563 1.063V16q0 .438-.281.719t-.719.281h-.438q-.375 0-.688-.281T15.56 16V4.625q0-1-.781-1.438t-1.563 0-.781 1.438V16q0 .438-.313.719t-.688.281h-.75q-.688 0-.938-.625l-3.688-9.75q-.375-.938-1.25-1.031t-1.469.594-.219 1.688l4 10.375q.063.188.063.375 0 .438-.375.75L5.12 20.751q-.75.625-.25 1.563l3.438 6.125q.313.563 1 .563h12.813q.938 0 1.125-.938l1.688-7.438q.063-.125.063-.25z',
		'w' => .875,
		'vw' => 28
	    ),
	    'registered' => array(
		'p' => '#e##f#m6.875-5.125q.125.188.125.406t-.094.375-.281.25-.375.094h-2.688q-.438 0-.625-.375l-3-5.625h-2v5.25q0 .313-.219.531t-.531.219h-2.438q-.25 0-.5-.219t-.25-.531V8.25q0-.313.25-.531t.5-.219h4.938q6.375 0 6.375 5.313 0 3#q#5 4.563.125.188 3.313 6zM16.063 15q2 0 2-2.063 0-.625-.156-1.031t-.719-.656-1.563-.25h-1.688v4h2.125z'
	    ),
	    'calendar-plus' => array(
		'p' => 'M21 18.25v1.5q0 .75-.75.75H15.5v4.75q0 .75-.75.75h-1.5q-.75 0-.75-.75V20.5H7.75q-.75 0-.75-.75v-1.5q0-.75.75-.75h4.75v-4.75q0-.75.75-.75h1.5q.75 0 .75.75v4.75h4.75q.75 0 .75.75zM28 7v22#n# 32H3q-1.25 0-2.125-.875T0 29V7q0-1.25.875-2.125T3 4h3V.75Q6 0 6.75 0h2.5Q10 0 10 .75V4h8V.75q0-.75.75-.75h2.5Q22 0 22 .75V4h3q1.25 0 2.125.875T28 7zm-3 21.625V10H3v18.625Q3 29 3.375 29h21.25Q25 29 25 28.625z',
		'w' => .875,
		'vw' => 28
	    ),
	    'calendar-minus' => array(
		'p' => 'M7.75 20.5q-.75 0-.75-.75v-1.5q0-.75.75-.75h12.5q.75 0 .75.75v1.5q0 .75-.75.75H7.75zM28 7v22#n# 32H3q-1.25 0-2.125-.875T0 29V7q0-1.25.875-2.125T3 4h3V.75Q6 0 6.75 0h2.5Q10 0 10 .75V4h8V.75q0-.75.75-.75h2.5Q22 0 22 .75V4h3q1.25 0 2.125.875T28 7zm-3 21.625V10H3v18.625Q3 29 3.375 29h21.25Q25 29 25 28.625z',
		'w' => .875,
		'vw' => 28
	    ),
	    'calendar-times' => array(
		'p' => 'M19.5 23.438l-1.063 1.063q-.563.5-1.063 0l-3.375-3.375-3.375 3.375q-.5.5-1.063 0l-1.063-1.063q-.5-.563 0-1.063L11.873 19l-3.375-3.375q-.5-.5 0-1.063l1.063-1.063q.563-.5 1.063 0l3.375 3.375 3.375-3.375q.5-.5 1.063 0l1.063 1.063q.5.563 0 1.063L16.125 19l3.375 3.375q.5.5 0 1.063zM28 7v22#n# 32H3q-1.25 0-2.125-.875T0 29V7q0-1.25.875-2.125T3 4h3V.75Q6 0 6.75 0h2.5Q10 0 10 .75V4h8V.75q0-.75.75-.75h2.5Q22 0 22 .75V4h3q1.25 0 2.125.875T28 7zm-3 21.625V10H3v18.625Q3 29 3.375 29h21.25Q25 29 25 28.625z',
		'w' => .875,
		'vw' => 28
	    ),
	    'calendar-check' => array(
		'p' => 'M25 4q1.25 0 2.125.875T28 7v22#n# 32H3q-1.25 0-2.125-.875T0 29V7q0-1.25.875-2.125T3 4h3V.75Q6 0 6.75 0h2.5Q10 0 10 .75V4h8V.75q0-.75.75-.75h2.5Q22 0 22 .75V4h3zm-.375 25Q25 29 25 28.625V10H3v18.625Q3 29 3.375 29h21.25zm-3.312-12.562l-8.875 8.875q-.563.5-1.063-.063l-4.688-4.688q-.563-.563 0-1.063l1.438-1.438q.5-.5 1.063 0l2.75 2.813 6.938-6.875q.5-.563 1.063 0l1.375 1.375q.563.563 0 1.063z',
		'w' => .875,
		'vw' => 28
	    ),
	    'map' => array(
		'p' => 'M35 2q.375 0 .688.281t.313.719v21.625q0 .375-.156.75t-.469.688-.625.438l-9.5 3.313q-.625.188-1.25.188t-1.25-.188l-10.75-3.813-10.625 3.938q-.188.063-.375.063-.375 0-.688-.281T0 29.002V7.377q0-.375.156-.75t.469-.688.625-.438l9.5-3.313Q11.375 2 12 2t1.25.188L24 6.001l10.625-3.938Q34.813 2 35 2zM14 5.625V23.5l8 2.875V8.5zm-11 20.5l7.938-2.938h.063V5.312l-8 2.75v18.063zm30-2.187V5.875l-7.938 2.938h-.063v17.875z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'comment-alt' => array(
		'p' => 'M28 0q1.625 0 2.813 1.188t1.188 2.813v18q0 1.625-1.188 2.813T28 26.002h-9l-7.813 5.875q-.188.125-.438.125-.75 0-.75-.75v-5.25h-6q-1.625 0-2.813-1.188t-1#q#813v-18q0-1.625 1#q#813T3.999 0h24zm1 22V4q0-.438-.281-.719T28 3H4q-.438 0-.719.281T3 4v18q0 .438.281.719T4 23h9v3.75l4.188-3.125.813-.625h10q.438 0 .719-.281t.281-.719z'
	    ),
	    'pause-circle' => array(
		'p' => '#e##f#M22 11v10q0 .438-.281.719T21 22h-3q-.438 0-.719-.281T17 21V11q0-.438.281-.719T18 10h3q.438 0 .719.281T22 11zm-7 0v10q0 .438-.281.719T14 22h-3q-.438 0-.719-.281T10 21V11q0-.438.281-.719T11 10h3q.438 0 .719.281T15 11z'
	    ),
	    'stop-circle' => array(
		'p' => 'M31.5 16q0 6.438-4.531 10.969T16 31.5 5.031 26.969.5 16 5.031 5.031 16 .5t10.969 4.531T31.5 16zm-28 0q0 5.188 3.656 8.844T16 28.5t8.844-3.656T28.5 16t-3.656-8.844T16 3.5 7.156 7.156 3.5 16zM22 11v10q0 .438-.281.719T21 22H11q-.438 0-.719-.281T10 21V11q0-.438.281-.719T11 10h10q.438 0 .719.281T22 11z'
	    ),
	    'handshake' => array(
		'p' => 'M32.438 8h7.563v16h-4q-.813 0-1.406-.594T34.001 22h-3.625q-.188.813-.688 1.438l-1.625 2q-.75.938-1.844 1.219t-2.156-.156q-1.188 1.5-3.063 1.5-1.375 0-2.563-1-1.438 1.063-3.281 1t-3.281-1.25l-5.313-4.75h-.563q0 .563-.281 1t-.719.719-1 .281h-4v-16h7.375l3-3q1-1 2.438-1H27q1.438 0 2.5 1zM3 22q.438 0 .719-.313T4 20.968t-.281-.688T3 19.999t-.719.281-.281.688.281.719T3 22zm24.375-.437q.313-.438-.063-.75l-6.75-5.438-.563.438q-1.125 1.063-2.531 1.156t-2.313-.375-1.469-1.031q-1.25-1.375-1.188-3.219t1.438-3.156L16.374 7h-3.563q-.063 0-.156.063t-.156.063l-3.875 3.875H5.999v8h1.75l6.063 5.5q.75.625 1.781.5t1.656-.938l1-1.188 2.313 2q.563.438 1.125-.188l1.875-2.25 1.5 1.188q.375.313.688-.063zM34 19v-8h-2.813l-3.813-3.875Q27.186 7 26.999 7h-5.25q-.938 0-1.688.688l-4.063 3.75q-.5.375-.5 1t.438 1.125q.375.438 1.031.406t1.094-.406l3.438-3.188q.75-.688 1.438.063l.688.75q.688.75-.063 1.375l-.813.75 6.438 5.188.5.5H34zm3 3q.438 0 .719-.313t.281-.719-.281-.688-.719-.281-.719.281-.281.688.281.719T37 22z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'envelope-open' => array(
		'p' => 'M30.938 10.313q1.063.875 1.063 2.313v16.375q0 1.25-.875 2.125t-2.125.875h-26q-1.25 0-2.125-.875t-.875-2.125V12.563q0-1.375 1.125-2.313 2.5-2.063 8.438-6.75.188-.188.75-.656l.938-.781 1.031-.75 1.188-.688L14.69.187l1.313-.188 1.313.188 1.25.438 1.188.719 1 .75.938.75.75.656q6.25 4.938 8.5 6.813zM29 28.625V12.75q0-.125-.125-.25-5.063-4.125-8.313-6.688-.063 0-.906-.719t-1.281-1.031-1.156-.688T16 2.999t-1.219.375-1.156.656-1.281 1.031-.906.75Q8.5 8.124 3.125 12.499q-.125.063-.125.25v15.875q0 .375.375.375h25.25q.375 0 .375-.375zm-2-11.75q.5.625-.125 1.063-3.438 2.813-4.438 3.563-.188.188-.75.656l-.938.781-1.031.75-1.188.688-1.219.438-1.313.188q-.75 0-1.531-.219t-1.563-.719-1.219-.813-1.25-.969-.875-.781q-1-.75-4.438-3.563-.625-.438-.125-1.063l.938-1.125q.5-.563 1.063-.125 3.438 2.75 4.438 3.563.063 0 .906.719t1.281 1.031 1.156.688 1.219.375q.375 0 .781-.156t.781-.375.844-.563.813-.594.75-.625.594-.5q1-.813 4.438-3.563.563-.438 1.063.125z'
	    ),
	    'address-book' => array(
		'p' => 'M27.25 10H26v4h1.25q.75 0 .75.75v2.5q0 .75-.75.75H26v4h1.25q.75 0 .75.75v2.5q0 .75-.75.75H26v3q0 1.25-.875 2.125T23 32H3q-1.25 0-2.125-.875T0 29V3Q0 1.75.875.875T3 0h20q1.25 0 2.125.875T26 3v3h1.25q.75 0 .75.75v2.5q0 .75-.75.75zM23 29V3H3v26h20zM13 16q-1.625 0-2.813-1.188t-1#q#813 1#q#813T13 7.998t2.813 1.188 1.188 2.813-1.188 2.813T13 16zm-5.625 8q-.563 0-.969-.344T6 22.812v-1.188q0-1.5 1.219-2.563t2.969-1.063q.25 0 1.063.25t1.75.25 1.75-.25 1.063-.25q1.75 0 2.969 1.063t1.219 2.563v1.188q0 .5-.406.844t-.969.344H7.377z',
		'w' => .875,
		'vw' => 28
	    ),
	    'address-card' => array(
		'p' => 'M33 2q1.25 0 2.125.875T36 5v22q0 1.25-.875 2.125T33 30H3q-1.25 0-2.125-.875T0 27V5q0-1.25.875-2.125T3 2h30zm0 25V5H3v22h30zM13 16q-1.625 0-2.813-1.188t-1#q#813 1#q#813T13 7.998t2.813 1.188 1.188 2.813-1.188 2.813T13 16zm-5.625 8q-.563 0-.969-.344T6 22.812v-1.188q0-1.5 1.219-2.563t2.969-1.063q.25 0 1.063.25t1.75.25 1.75-.25 1.063-.25q1.75 0 2.969 1.063t1.219 2.563v1.188q0 .5-.406.844t-.969.344H7.377zM22.5 20q-.5 0-.5-.5v-1q0-.5.5-.5h7q.5 0 .5.5v1q0 .5-.5.5h-7zm0-4q-.5 0-.5-.5v-1q0-.5.5-.5h7q.5 0 .5.5v1q0 .5-.5.5h-7zm0-4q-.5 0-.5-.5v-1q0-.5.5-.5h7q.5 0 .5.5v1q0 .5-.5.5h-7z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'user-circle' => array(
		'p' => 'M15.5 6.5q2.5 0 4.25 1.75t1.75 4.25-1.75 4.25-4.25 1.75-4.25-1.75T9.5 12.5t1.75-4.25T15.5 6.5zm0 9q1.25 0 2.125-.875T18.5 12.5t-.875-2.125T15.5 9.5t-2.125.875T12.5 12.5t.875 2.125 2.125.875zm0-15q6.438 0 10.969 4.531T31 16t-4.531 10.969T15.5 31.5 4.531 26.969 0 16 4.531 5.031 15.5.5zm0 28q4.625 0 8.125-3-1.5-2.375-4.375-2.5-1.875.625-3.75.625-1.813 0-3.75-.625-2.813.063-4.375 2.5 3.5 3 8.125 3zm10.188-5.25Q28.001 20 28.001 16q0-5.188-3.656-8.844T15.501 3.5 6.657 7.156 3.001 16q0 4 2.313 7.25Q7.877 20 11.877 20q.188 0 1.344.313t2.281.313 2.281-.313T19.127 20q4 0 6.563 3.25z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'id-badge' => array(
		'p' => 'M21 0q1.25 0 2.125.875T24 3v26q0 1.25-.875 2.125T21 32H3q-1.25 0-2.125-.875T0 29V3Q0 1.75.875.875T3 0h18zm0 29V3H3v26h18zM9 7q-.438 0-.719-.281T8 6t.281-.719T9 5h6q.438 0 .719.281T16 6t-.281.719T15 7H9zm3 11q-1.625 0-2.813-1.188t-1#q#813 1#q#813T12 9.998t2.813 1.188 1.188 2.813-1.188 2.813T12 18zm-5.625 8q-.563 0-.969-.344T5 24.812v-1.188q0-1.5 1.219-2.563t2.969-1.063q.25 0 1.063.25t1.75.25 1.75-.25 1.063-.25q1.75 0 2.969 1.063t1.219 2.563v1.188q0 .5-.406.844t-.969.344H6.377z',
		'w' => .75,
		'vw' => 24
	    ),
	    'id-card' => array(
		'p' => 'M33 2q1.25 0 2.125.875T36 5v22q0 1.25-.875 2.125T33 30H3q-1.25 0-2.125-.875T0 27V5q0-1.25.875-2.125T3 2h30zm0 25V9H3v18h2.063Q5 26.75 5 25.625q0-1.5 1.219-2.563t2.969-1.063q.25 0 1.063.25t1.75.25 1.75-.25 1.063-.25q1.75 0 2.969 1.063t1.219 2.563q0 1.125-.063 1.375h14.063zm-10.5-5q-.5 0-.5-.5v-1q0-.5.5-.5h7q.5 0 .5.5v1q0 .5-.5.5h-7zm0-4q-.5 0-.5-.5v-1q0-.5.5-.5h7q.5 0 .5.5v1q0 .5-.5.5h-7zm0-4q-.5 0-.5-.5v-1q0-.5.5-.5h7q.5 0 .5.5v1q0 .5-.5.5h-7zM12 20q-1.625 0-2.813-1.188t-1#q#813 1#q#813T12 11.998t2.813 1.188 1.188 2.813-1.188 2.813T12 20z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'window-maximize' => array(
		'p' => '#l#m0 24.625V12H3v14.625Q3 27 3.375 27h25.25Q29 27 29 26.625z'
	    ),
	    'window-minimize' => array(
		'p' => 'M30 30H2q-.813 0-1.406-.594T0 28t.594-1.406T2 26h28q.813 0 1.406.594T32 28t-.594 1.406T30 30z'
	    ),
	    'window-restore' => array(
		'p' => 'M29 0q1.25 0 2.125.875T32 3v20q0 1.25-.875 2.125T29 26h-3v3q0 1.25-.875 2.125T23 32H3q-1.25 0-2.125-.875T0 29V9q0-1.25.875-2.125T3 6h3V3q0-1.25.875-2.125T9 0h20zm-6 29V16H3v13h20zm6-6V3H9v3h14q1.25 0 2.125.875T26 9v14h3z'
	    ),
	    'snowflake' => array(
		'p' => 'M27.5 22.188q.375.25.469.625t-.094.75l-.5.875q-.5.875-1.375.375l-2.438-1.438.563 2.125q.063.313 0 .563t-.25.438-.438.25l-.938.25q-.375.125-.75-.094t-.5-.594l-1.313-5.063-4.5-2.625v5.25l3.688 3.688q.688.75 0 1.438l-.75.688q-.688.75-1.375 0l-1.563-1.563v2.875q0 .438-.281.719t-.656.281h-1q-.438 0-.719-.281t-.281-.719v-2.875l-1.563 1.625q-.688.688-1.375 0l-.688-.75q-.25-.25-.25-.688t.25-.688l3.625-3.75v-5.25l-4.5 2.625-1.313 5.063q-.125.375-.469.594t-.719.094l-.938-.25q-.438-.125-.625-.469t-.063-.719l.563-2#q#438 1.438q-.375.188-.781.094t-.594-.469l-.5-.875q-.5-.875.375-1.375l2.438-1.438-2.125-.563q-.375-.125-.594-.469t-.094-.781l.25-.938q.125-.438.469-.625t.719-.125l5 1.375 4.5-2.625-4.5-2.625-5 1.375q-.375.063-.719-.125t-.469-.625l-.25-.938q-.125-.438.094-.781t.594-.469l2.125-.563L.496 9.81q-.875-.5-.375-1.375l.5-.875q.5-.875 1.375-.375l2.438 1.438-.563-2.125q-.125-.438.063-.781t.625-.469l.938-.25q.375-.125.75.094t.438.594l1.313 5.063 4.5 2.625v-5.25L8.873 4.436q-.688-.75 0-1.438l.75-.688q.688-.75 1.375 0l1.563 1.563V.998q0-.438.281-.719t.656-.281h1q.438 0 .719.281t.281.719v2.875l1.563-1.625q.688-.688 1.375 0l.688.75q.688.688 0 1.375l-3.625 3.75v5.25l4.5-2.625 1.313-5.063q.125-.375.469-.594t.719-.094l.938.25q.438.125.625.469t.063.719l-.563 2.188 2.5-1.438q.313-.188.719-.094t.594.469l.5.875q.5.875-.375 1.375l-2.438 1.438 2.125.563q.375.125.594.469t.094.781l-.25.938q-.125.438-.469.625t-.719.125l-5-1.375-4.5 2.625 4.5 2.625 5-1.375q.375-.063.719.125t.469.625l.25.938q.125.438-.094.781t-.594.469l-2.125.563z',
		'w' => .875,
		'vw' => 28
	    ),
	    'trash-alt' => array(
		'p' => 'M16.75 26q-.75 0-.75-.75v-13.5q0-.75.75-.75h1.5q.75 0 .75.75v13.5q0 .75-.75.75h-1.5zM27 5q.438 0 .719.281T28 6v1q0 .438-.281.719T27 8h-1v21q0 1.25-.875 2.125T23 32H5q-1.25 0-2.125-.875T2 29V8H1q-.438 0-.719-.281T0 7V6q0-.438.281-.719T1 5h5.125L8.25 1.437q.375-.563 1.125-1t1.5-.438h6.25q.5 0 1 .188t.938.531.688.719L21.876 5h5.125zM10.75 3.188L9.625 5.001h8.75L17.25 3.188Q17.125 3 16.937 3h-5.875q-.188 0-.313.188zM23 29V8H5v21h18zM9.75 26Q9 26 9 25.25v-13.5q0-.75.75-.75h1.5q.75 0 .75.75v13.5q0 .75-.75.75h-1.5z',
		'w' => .875,
		'vw' => 28
	    ),
	    'images' => array(
		'p' => 'M30 26v1q0 1.25-.875 2.125T27 30H3q-1.25 0-2.125-.875T0 27V11q0-1.25.875-2.125T3 8h1v3h-.625Q3 11 3 11.375v15.25Q3 27 3.375 27h23.25Q27 27 27 26.625V26h3zm2.625-21H9.375Q9 5 9 5.375v15.25Q9 21 9.375 21h23.25Q33 21 33 20.625V5.375Q33 5 32.625 5zM33 2q1.25 0 2.125.875T36 5v16q0 1.25-.875 2.125T33 24H9q-1.25 0-2.125-.875T6 21V5q0-1.25.875-2.125T9 2h24zM16.5 9q0 1.063-.719 1.781T14 11.5t-1.781-.719T11.5 9t.719-1.781T14 6.5t1.781.719T16.5 9zM12 15l2.5-2.5q.5-.5 1 0L18 15l6.5-6.5q.5-.5 1 0L30 13v5H12v-3z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'clipboard' => array(
		'p' => 'M21 4q1.25 0 2.125.875T24 7v22q0 1.25-.875 2.125T21 32H3q-1.25 0-2.125-.875T0 29V7q0-1.25.875-2.125T3 4h5q0-1.625 1#q#813t2.813-1.188 2.813 1.188T16.002 4h5zm-9-1.5q-.625 0-1.063.438t-.438 1.063.438 1.063T12 5.502t1.063-.438.438-1.063-.438-1.063T12 2.5zm9 26.125V7.375Q21 7 20.625 7H18v2.25q0 .75-.75.75H6.75Q6 10 6 9.25V7H3.375Q3 7 3 7.375v21.25Q3 29 3.375 29h17.25Q21 29 21 28.625z',
		'w' => .75,
		'vw' => 24
	    ),
	    'arrow-alt-circle-down' => array(
		'p' => '#e##f#M14 8.75q0-.75.75-.75h2.5q.75 0 .75.75V16h4.188q.5 0 .688.469t-.125.781l-6.25 6.25q-.5.5-1 0l-6.25-6.25q-.313-.313-.125-.781T9.814 16h4.188V8.75z'
	    ),
	    'arrow-alt-circle-left' => array(
		'p' => 'M.5 16q0-6.438 4.531-10.969T16 .5t10.969 4.531T31.5 16t-4.531 10.969T16 31.5 5.031 26.969.5 16zm28 0q0-5.188-3.656-8.844T16 3.5 7.156 7.156 3.5 16t3.656 8.844T16 28.5t8.844-3.656T28.5 16zM24 14.75v2.5q0 .75-.75.75H16v4.188q0 .5-.469.688t-.781-.125l-6.25-6.25q-.5-.5 0-1l6.25-6.25q.313-.313.781-.125t.469.688v4.188h7.25q.75 0 .75.75z'
	    ),
	    'arrow-alt-circle-right' => array(
		'p' => 'M31.5 16q0 6.438-4.531 10.969T16 31.5 5.031 26.969.5 16 5.031 5.031 16 .5t10.969 4.531T31.5 16zm-28 0q0 5.188 3.656 8.844T16 28.5t8.844-3.656T28.5 16t-3.656-8.844T16 3.5 7.156 7.156 3.5 16zM8 17.25v-2.5q0-.75.75-.75H16V9.812q0-.5.469-.688t.781.125l6.25 6.25q.5.5 0 1l-6.25 6.25q-.313.313-.781.125T16 22.186v-4.188H8.75q-.75 0-.75-.75z'
	    ),
	    'arrow-alt-circle-up' => array(
		'p' => 'M16 31.5q-6.438 0-10.969-4.531T.5 16 5.031 5.031 16 .5t10.969 4.531T31.5 16t-4.531 10.969T16 31.5zm0-28q-5.188 0-8.844 3.656T3.5 16t3.656 8.844T16 28.5t8.844-3.656T28.5 16t-3.656-8.844T16 3.5zM17.25 24h-2.5q-.75 0-.75-.75V16H9.812q-.5 0-.688-.469t.125-.781l6.25-6.25q.5-.5 1 0l6.25 6.25q.313.313.125.781t-.688.469h-4.188v7.25q0 .75-.75.75z'
	    ),
	    'gem' => array(
		'p' => 'M29 0q.375 0 .625.313l6.25 9.25q.313.438-.063.875l-17.25 21.313q-.188.25-.563.25t-.563-.25L.186 10.438Q-.189 10 .123 9.563l6.25-9.25Q6.561 0 6.998 0h22zm-1.187 3H24.25l3.25 6h4.25zM15.188 3l-3.25 6h12.125l-3.25-6h-5.625zm-7 0L4.25 9H8.5l3.25-6H8.187zM5.5 12L13 22 8.75 12H5.5zm6.438 0l6.063 15.188L24.064 12H11.939zM23 22l7.5-10h-3.25z',
		'w' => 1.125,
		'vw' => 36
	    ),
		'diamond'=>'gem',
	    'money-bill-alt' => array(
		'p' => 'M20 9q2.5 0 4.25 2.063T26 16.001t-1.75 4.938T20 23.002t-4.25-2.063T14 16.001t1.75-4.938T20 9zm2.5 10.5v-1q0-.5-.5-.5h-1v-5.5q0-.5-.5-.5h-.875q-.438 0-.813.25l-.938.625q-.25.188-.25.438 0 .125.125.25l.5.875q.188.188.438.188.188 0 .313-.063v3.438h-1q-.5 0-.5.5v1q0 .5.5.5h4q.5 0 .5-.5zM38 4q.813 0 1.406.594T40 6v20q0 .813-.594 1.406T38 28H2q-.813 0-1.406-.594T0 26V6q0-.813.594-1.406T2 4h36zm-1 17V11q-1.688 0-2.844-1.156T33 7H7q0 1.688-1.156 2.844T3 11v10q1.688 0 2.844 1.156T7 25h26q0-1.688 1.156-2.844T37 21z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'window-close' => array(
		'p' => '#l#m0 24.625V5.375Q29 5 28.625 5H3.375Q3 5 3 5.375v21.25Q3 27 3.375 27h25.25Q29 27 29 26.625zm-6.75-14.437l-3.813 3.813 3.813 3.813q.563.563 0 1.063l-1.375 1.375q-.5.563-1.063 0l-3.813-3.813-3.813 3.813q-.563.563-1.063 0l-1.375-1.375q-.563-.5 0-1.063l3.813-3.813-3.813-3.813q-.563-.563 0-1.063l1.375-1.375q.5-.563 1.063 0l3.813 3.813 3.813-3.813q.563-.563 1.063 0l1.375 1.375q.563.5 0 1.063z'
	    ),
	    'comment-dots' => array(
		'p' => 'M9 13q.813 0 1.406.594T11 15t-.594 1.406T9 17t-1.406-.594T7 15t.594-1.406T9 13zm7 0q.813 0 1.406.594T18 15t-.594 1.406T16 17t-1.406-.594T14 15t.594-1.406T16 13zm7 0q.813 0 1.406.594T25 15t-.594 1.406T23 17t-1.406-.594T21 15t.594-1.406T23 13zM16 2q6.625 0 11.313 3.813t4.688 9.188-4.688 9.188T16 28.002q-2.938 0-5.813-.875-4.063 2.875-8.688 2.875-1 0-1.375-.906t.25-1.594q.125-.125.594-.656t1.188-1.688 1.156-2.281q-3.313-3.5-3.313-7.875 0-5.375 4.688-9.188T16 2.001zm0 23q5.375 0 9#q#938t3.813-7.063-3.813-7.063T16 4.998 6.812 7.936t-3.813 7.063q0 3.188 2.5 5.813l1.25 1.375-.625 1.75q-.5 1.25-1.25 2.563 1.875-.625 3.563-1.875l1.25-.813 1.438.438Q13.5 25 16 25z'
	    ),
	    'smile-wink' => array(
		'p' => '#d#0 28q5.188 0 8.844-3.656T28 16t-3.656-8.844T15.5 3.5 6.656 7.156 3 16t3.656 8.844T15.5 28.5zm7.344-9.156q.469.406.531 1.031t-.313 1.063q-2.938 3.563-7.563 3.563t-7.563-3.563q-.375-.438-.313-1.063t.531-1.031T9.248 19t1 .563q2.063 2.438 5.25 2.438t5.25-2.438q.375-.5 1-.563t1.094.344zM10.5 15q-.813 0-1.406-.594T8.5 13t.594-1.406T10.5 11t1.406.594T12.5 13t-.594 1.406T10.5 15zm10-3.75q1.25 0 2.406.75t1.344 1.875q.063.5-.406.75T23 14.562l-.625-.563q-.688-.563-1.875-.563t-1.938.563l-.563.563q-.375.313-.844.063t-.406-.75q.125-.75.719-1.375t1.406-.938 1.625-.313z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'angry' => array(
		'p' => '#d#0 28q5.188 0 8.844-3.656T28 16t-3.656-8.844T15.5 3.5 6.656 7.156 3 16t3.656 8.844T15.5 28.5zm0-9q3.313 0 5.438 2.563.375.438.313 1.063t-.5 1q-.5.438-1.125.375t-1-.563q-1.188-1.375-3.125-1.375t-3.125 1.375q-.375.5-1 .563t-1.094-.344-.531-1.031.313-1.063q2.125-2.563 5.438-2.563zm-3-4.5q0 .813-.594 1.406T10.5 17t-1.406-.594T8.5 15q0-.5.313-1l-1.75-.563q-.563-.188-.875-.719t-.125-1.125.719-.906 1.156-.125l5 1.5q.563.188.875.719t.125 1.156Q13.625 15 12.5 15zm12.438-3.406q.188.594-.125 1.125t-.875.719l-1.75.5q.313.563.313 1.063 0 .813-.594 1.406t-1.406.594-1.406-.594-.594-1.406q-1.125 0-1.438-1.063-.125-.313-.063-.594t.188-.531.344-.469.531-.281l5-1.5q.625-.188 1.156.125t.719.906z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'dizzy' => array(
		'p' => '#d#0 28q5.188 0 8.844-3.656T28 16t-3.656-8.844T15.5 3.5 6.656 7.156 3 16t3.656 8.844T15.5 28.5zm-2.125-13.625q-.375.375-.875.375t-.875-.375L10.5 13.75l-1.125 1.125Q9 15.25 8.5 15.25t-.875-.375T7.25 14t.375-.875L8.75 12l-1.125-1.125Q7.25 10.5 7.25 10t.375-.875.875-.375.875.375L10.5 10.25l1.125-1.125Q12 8.75 12.5 8.75t.875.375.375.875-.375.875L12.25 12l1.125 1.125q.375.375.375.875t-.375.875zm10-5.75q.375.375.375.875t-.375.875L22.25 12l1.125 1.125q.375.375.375.875t-.375.875-.875.375-.875-.375L20.5 13.75l-1.125 1.125q-.375.375-.875.375t-.875-.375T17.25 14t.375-.875L18.75 12l-1.125-1.125Q17.25 10.5 17.25 10t.375-.875.875-.375.875.375L20.5 10.25l1.125-1.125Q22 8.75 22.5 8.75t.875.375zM15.5 17q1.625 0 2.813 1.188t1.188 2.813-1.188 2.813-2.813 1#q#813-1.188-1#q#813 1#q#813T15.5 17z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'flushed' => array(
		'p' => '#d#0 28q5.188 0 8.844-3.656T28 16t-3.656-8.844T15.5 3.5 6.656 7.156 3 16t3.656 8.844T15.5 28.5zm6-19.5q2.063 0 3.531 1.469T26.5 14t-1.469 3.531T21.5 19t-3.531-1.469T16.5 14t1.469-3.531T21.5 9zm0 8q1.25 0 2.125-.875T24.5 14t-.875-2.125T21.5 11t-2.125.875T18.5 14t.875 2.125T21.5 17zm0-4.5q.625 0 1.063.438t.438 1.063-.438 1.063-1.063.438-1.063-.438-.438-1.063.438-1.063T21.5 12.5zm-7 1.5q0 2.063-1.469 3.531T9.5 19t-3.531-1.469T4.5 14t1.469-3.531T9.5 9t3.531 1.469T14.5 14zm-5 3q1.25 0 2.125-.875T12.5 14t-.875-2.125T9.5 11t-2.125.875T6.5 14t.875 2.125T9.5 17zm0-4.5q.625 0 1.063.438t.438 1.063-.438 1.063-1.063.438-1.063-.438-.438-1.063.438-1.063T9.5 12.5zm10 9q.625 0 1.063.438t.438 1.063-.438 1.063-1.063.438h-8q-.625 0-1.063-.438t-.438-1.063.438-1.063T11.5 21.5h8z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'frown-open' => array(
		'p' => '#d#0 28q5.188 0 8.844-3.656T28 16t-3.656-8.844T15.5 3.5 6.656 7.156 3 16t3.656 8.844T15.5 28.5zm-3-15.5q0 .813-.594 1.406T10.5 15t-1.406-.594T8.5 13t.594-1.406T10.5 11t1.406.594T12.5 13zm8-2q.813 0 1.406.594T22.5 13t-.594 1.406T20.5 15t-1.406-.594T18.5 13t.594-1.406T20.5 11zm-5 7q1.875 0 3.781 1.063t2.219 2.75q.063.563-.344.938t-.969.188q-3.063-.938-4.688-.938t-4.688.938q-.563.188-.969-.188t-.344-.938q.313-1.688 2.219-2.75T15.498 18z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'grimace' => array(
		'p' => '#d#0 28q5.188 0 8.844-3.656T28 16t-3.656-8.844T15.5 3.5 6.656 7.156 3 16t3.656 8.844T15.5 28.5zm-5-13.5q-.813 0-1.406-.594T8.5 13t.594-1.406T10.5 11t1.406.594T12.5 13t-.594 1.406T10.5 15zm10 0q-.813 0-1.406-.594T18.5 13t.594-1.406T20.5 11t1.406.594T22.5 13t-.594 1.406T20.5 15zm1 1q1.25 0 2.125.875T24.5 19v2q0 1.25-.875 2.125T21.5 24h-12q-1.25 0-2.125-.875T6.5 21v-2q0-1.25.875-2.125T9.5 16h12zM11 22v-1.5H8.5v.5q0 .438.281.719T9.5 22H11zm0-2.5V18H9.5q-.438 0-.719.281T8.5 19v.5H11zm4 2.5v-1.5h-3V22h3zm0-2.5V18h-3v1.5h3zm4 2.5v-1.5h-3V22h3zm0-2.5V18h-3v1.5h3zm3.5 1.5v-.5H20V22h1.5q.438 0 .719-.281T22.5 21zm0-1.5V19q0-.438-.281-.719T21.5 18H20v1.5h2.5z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'grin' => array(
		'p' => '#d#0 28q5.188 0 8.844-3.656T28 16t-3.656-8.844T15.5 3.5 6.656 7.156 3 16t3.656 8.844T15.5 28.5zm6.625-9.437q.438-.188.813.125t.25.813q-.313 2.125-2.719 3.563T15.5 25.002q-1.625 0-3.313-.625t-2.938-1.813-1.438-2.563q-.125-.5.25-.813t.813-.125q2.563.813 6.625.813t6.625-.813zM10.5 15q-.813 0-1.406-.594T8.5 13t.594-1.406T10.5 11t1.406.594T12.5 13t-.594 1.406T10.5 15zm10 0q-.813 0-1.406-.594T18.5 13t.594-1.406T20.5 11t1.406.594T22.5 13t-.594 1.406T20.5 15z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'grin-alt' => array(
		'p' => 'M12.5 15.5q-.313.563-.969.563T10.5 15.5q-.938-1.375-1-3.5.063-2.125 1-3.5.313-.563.969-.563T12.5 8.5q.938 1.375 1 3.5-.063 2.125-1 3.5zm8 0q-.313.563-.969.563T18.5 15.5q-.938-1.375-1-3.5.063-2.125 1-3.5.313-.563.969-.563T20.5 8.5q.938 1.375 1 3.5-.063 2.125-1 3.5zm-5-15q6.438 0 10.969 4.531T31 16t-4.531 10.969T15.5 31.5 4.531 26.969 0 16 4.531 5.031 15.5.5zm0 28q5.188 0 8.844-3.656T28 16t-3.656-8.844T15.5 3.5 6.656 7.156 3 16t3.656 8.844T15.5 28.5zm6.625-9.437q.438-.188.813.125t.25.813q-.313 2.125-2.719 3.563T15.5 25.002t-4.969-1.438-2.719-3.563q-.125-.5.25-.813t.813-.125q2.563.813 6.625.813t6.625-.813z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'grin-beam' => array(
		'p' => '#d#0 28q5.188 0 8.844-3.656T28 16t-3.656-8.844T15.5 3.5 6.656 7.156 3 16t3.656 8.844T15.5 28.5zm6.625-9.437q.438-.188.813.125t.25.813q-.313 2.125-2.719 3.563T15.5 25.002q-1.625 0-3.313-.625t-2.938-1.813-1.438-2.563q-.125-.5.25-.813t.813-.125q2.563.813 6.625.813t6.625-.813zM7.375 14.5q-.438-.125-.375-.563.063-.75.313-1.438t.594-1.25.781-.938.906-.594.906-.219q1.188 0 2.281 1.281T14 13.935q.063.438-.344.563t-.594-.25l-.563-1.063q-.813-1.375-2-1.375t-2 1.375l-.563 1.063q-.188.375-.563.25zm10 0q-.438-.125-.375-.563.125-1.875 1.219-3.156T20.5 9.5t2.281 1.281T24 13.937q.063.438-.344.563t-.594-.25l-.563-1.063q-.813-1.375-2-1.375t-2 1.375l-.563 1.063q-.188.375-.563.25z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'grin-beam-sweat' => array(
		'p' => 'M27.5 10q-1.375 0-2.344-1.063t-.969-2.625q0-1.75 2.875-6.063.438-.688.875 0 2.875 4.313 2.875 6.063 0 1.563-.969 2.625T27.499 10zm-12 15q-1.625 0-3.313-.625t-2.906-1.781T7.812 20q-.125-.5.25-.813t.813-.125q2.563.813 6.625.813t6.625-.813q.438-.188.813.156t.25.781q-.313 2.125-2.719 3.563T15.5 25zm8.156-10.531q-.406.094-.594-.219l-.563-1.063q-.813-1.375-2-1.375t-2 1.375l-.563 1.063q-.188.375-.563.25-.438-.125-.375-.563.125-1.875 1.219-3.156T20.498 9.5t2.281 1.281 1.219 3.156q.063.438-.344.531zm6.594-3.281q.75 2.313.75 4.813 0 6.438-4.531 10.969T15.5 31.501 4.531 26.97 0 16.001 4.531 5.032 15.5.501q4.188 0 7#r#125-.875 1.75-1.063 2.875-3.125-2-6.75-2-5.188 0-8.844 3.656T3 16.001t3.656 8.844 8.844 3.656 8.844-3.656T28 16.001q0-2.063-.688-4 1.625 0 2.938-.813zm-19.75.625q-1.188 0-2 1.375l-.563 1.063q-.188.375-.563.25-.438-.125-.375-.563.063-.75.313-1.438t.594-1.25.781-.938.906-.594.906-.219q1.188 0 2.281 1.281t1.219 3.156q.063.438-.344.563t-.594-.25l-.563-1.063q-.813-1.375-2-1.375z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'grin-hearts' => array(
		'p' => 'M22.125 19.063q.438-.188.813.125t.25.813q-.313 2.125-2.719 3.563T15.5 25.002t-4.969-1.438-2.719-3.563q-.125-.5.25-.813t.813-.125q2.563.813 6.625.813t6.625-.813zM12.563 16l-4.375-1.125q-1-.25-1.438-1.156t-.125-1.844q.313-.813 1.125-1.188t1.688-.188l.438.125.125-.438q.25-.875 1-1.375t1.625-.375q1 .188 1.531 1t.281 1.813l-1.25 4.375q-.125.5-.625.375zm11.812-4.125q.313.938-.125 1.844t-1.438 1.156L18.437 16q-.5.125-.625-.375l-1.25-4.375q-.25-1 .281-1.813t1.531-1q.563-.063 1.125.125t.938.625.563 1l.125.438.438-.125q.375-.063.813-.031t.813.219.688.5.5.688z#d#0 28q5.188 0 8.844-3.656T28 16t-3.656-8.844T15.5 3.5 6.656 7.156 3 16t3.656 8.844T15.5 28.5z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'grin-squint' => array(
		'p' => '#d#0 28q5.188 0 8.844-3.656T28 16t-3.656-8.844T15.5 3.5 6.656 7.156 3 16t3.656 8.844T15.5 28.5zm6.625-9.437q.438-.188.813.125t.25.813q-.313 2.125-2.719 3.563T15.5 25.002q-1.625 0-3.313-.625t-2.938-1.813-1.438-2.563q-.125-.5.25-.813t.813-.125q2.563.813 6.625.813t6.625-.813zM7.406 16.469Q7 16 7.437 15.5L9.5 13l-2.063-2.5q-.438-.5 0-.969t.938-.156l5 3q.375.188.375.625t-.375.625l-5 3q-.563.313-.969-.156zm15.219.156l-5-3q-.375-.188-.375-.625t.375-.625l5-3q.563-.313.938.125.438.5 0 1L21.5 13l2.063 2.5q.438.5.031.969t-.969.156z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'grin-squint-tears' => array(
		'p' => 'M7.313 24q.313-.063.531.156t.156.531Q7.25 29.812 6.062 31q-1 1-2.469 1t-2.531-1.063-1.063-2.531 1-2.469q1.188-1.188 6.313-1.938zM4.75 21.375q-1.688.375-2.938.813-1.938-4.25-1.063-9t4.313-8.125Q9.562.5 16 .5q3.75 0 7.063 1.688-.438 1.313-.75 3.063-2.938-1.75-6.313-1.75-5.188 0-8.813 3.688-2.875 2.813-3.5 6.781t1.063 7.406zm22-11.687q1.813-.375 3.063-.75 2.25 4.313 1.5 9.375T27 26.938q-4.563 4.563-11 4.563-3.188 0-6.188-1.313.438-1.188.813-2.938Q13.188 28.5 16 28.5q5.188 0 8.813-3.688 3.063-3 3.563-7.281t-1.625-7.844zM24.688 8q-.313.063-.531-.156t-.156-.531q.75-5.125 1.938-6.313 1-1 2.469-1t2.531 1.063 1.063 2.531-1 2.469q-1.188 1.188-6.313 1.938zM13 14.75q.313.313.188.75l-1.438 5.625q-.125.563-.688.563h-.063q-.625-.063-.688-.688l-.313-3.25-3.25-.313q-.625-.063-.688-.688t.563-.75l5.625-1.438q.438-.125.75.188zm2.5-1.562q-.563 0-.75-.188-.313-.313-.188-.75L16 6.625q.125-.563.75-.563.625.063.688.688l.313 3.25 3.25.313q.625.063.688.688t-.563.75zm3.25 5.562q2.875-2.938 4.063-5.25.25-.438.719-.469t.719.344q1.188 1.938.563 4.563t-2.438 4.438-4.438 2.469-4.563-.594q-.375-.25-.344-.719t.469-.719q2.375-1.25 5.25-4.063z'
	    ),
	    'grin-stars' => array(
		'p' => '#d#0 28q5.188 0 8.844-3.656T28 16t-3.656-8.844T15.5 3.5 6.656 7.156 3 16t3.656 8.844T15.5 28.5zm6.625-9.437q.438-.188.813.125t.25.813q-.313 2.125-2.719 3.563T15.5 25.002t-4.969-1.438-2.719-3.563q-.125-.5.25-.813t.813-.125q2.563.813 6.625.813t6.625-.813zm-14.25-3.625l.375-2.188-1.625-1.5q-.188-.25-.094-.531t.406-.344l2.188-.313.938-1.938q.125-.313.438-.313t.438.313l.938 1.938 2.188.313q.313.063.406.344t-.094.531l-1.625 1.5.375 2.188q.063.313-.188.469t-.5.031l-1.938-1-1.938 1q-.25.125-.5-.031t-.188-.469zm16.188-4.563q.313.063.406.344t-.094.531l-1.625 1.5.375 2.188q.063.188-.031.344t-.281.188-.375-.031l-1.938-1-1.938 1q-.25.125-.5-.031t-.188-.469l.375-2.188-1.625-1.5q-.188-.25-.094-.531t.406-.344l2.188-.313.938-1.938q.125-.313.438-.313t.438.313l.938 1.938z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'grin-tears' => array(
		'p' => 'M7.313 16q.313-.063.531.156t.156.531Q7.25 21.812 6.062 23q-1 1-2.469 1t-2.531-1.063-1.063-2.531 1-2.469q1.188-1.188 6.313-1.938zM39 17.938q1 1 1 2.469t-1.063 2.531-2.531 1.063-2.469-1q-1.188-1.188-1.938-6.313-.063-.313.156-.531t.531-.156q5.125.75 6.313 1.938zm-7.937 3.812q.688 2 1#r#938-2.188 3.125-5.563 4.969T20 31.501t-7.313-1.844-5.563-4.969q1.125-.938 1.813-2.938 1.563 3.063 4.531 4.906t6.531 1.844 6.531-1.844 4.531-4.906zM7.688 14q-.688-.063-3.125.438.375-3.875 2.531-7.063t5.563-5.031T20.001.5t7.344 1.844 5.563 5.031 2.531 7.125q-2.375-.563-3.125-.5-.688-4.5-4.188-7.5t-8.125-3-8.125 3T7.688 14zM20 25q-2.563 0-4.969-1.438t-2.719-3.563q-.125-.5.25-.813t.813-.125q2.563.813 6.625.813t6.625-.813q.438-.188.813.156t.25.781q-.313 2.125-2.719 3.563T20 24.999zm8.156-10.531q-.406.094-.594-.219l-.563-1.063q-.813-1.375-2-1.375t-2 1.375l-.563 1.063q-.188.375-.563.25-.438-.125-.375-.563.125-1.875 1.219-3.156T24.998 9.5t2.281 1.281 1.219 3.156q.063.438-.344.531zM15 11.813q-1.188 0-2 1.375l-.563 1.063q-.188.375-.563.25-.438-.125-.375-.563.063-.75.313-1.438t.594-1.25.781-.938.906-.594.906-.219q1.188 0 2.281 1.281t1.219 3.156q.063.438-.344.563t-.594-.25l-.563-1.063q-.813-1.375-2-1.375z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'grin-tongue' => array(
		'p' => '#d#4 25v-2.75l-1.125-.563q-.688-.313-1.344.031t-.781 1.031l-.188.75q-.125.438-.563.438t-.563-.438l-.125-.75q-.188-.688-.844-1.031t-1.344-.031l-1.125.563v2.688q0 1.625 1.156 2.844t2.781 1.219q1.125 0 2.063-.531t1.469-1.438.531-2.031zm1.75 1.563q3.063-1.563 4.906-4.531T28 16.001q0-5.188-3.656-8.844T15.5 3.501 6.656 7.157 3 16.001q0 3.563 1.844 6.531t4.906 4.531q-.25-.875-.25-1.563v-2.75Q8.062 21.5 7.812 20q-.125-.5.25-.813t.813-.125q2.563.813 6.625.813t6.625-.813q.438-.188.813.156t.25.781q-.25 1.5-1.688 2.75v2.75q0 .688-.25 1.563zM10.5 11q.813 0 1.406.594T12.5 13t-.594 1.406T10.5 15t-1.406-.594T8.5 13t.594-1.406T10.5 11zm10 0q.813 0 1.406.594T22.5 13t-.594 1.406T20.5 15t-1.406-.594T18.5 13t.594-1.406T20.5 11z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'grin-tongue-squint' => array(
		'p' => '#d#4 25v-2.75l-1.125-.563q-.688-.313-1.344.031t-.781 1.031l-.188.75q-.125.438-.563.438t-.563-.438l-.125-.75q-.188-.688-.844-1.031t-1.344-.031l-1.125.563v2.688q0 1.625 1.156 2.844t2.781 1.219q1.125 0 2.063-.531t1.469-1.438.531-2.031zm1.75 1.563q3.063-1.563 4.906-4.531T28 16.001q0-5.188-3.656-8.844T15.5 3.501 6.656 7.157 3 16.001q0 3.563 1.844 6.531t4.906 4.531q-.25-.875-.25-1.563v-2.75Q8.062 21.5 7.812 20q-.125-.5.25-.813t.813-.125q2.563.813 6.625.813t6.625-.813q.438-.188.813.156t.25.781q-.25 1.5-1.688 2.75v2.75q0 .688-.25 1.563zm2.313-17.532q.438.469 0 .969L21.5 13l2.063 2.5q.438.5.031.969t-.969.156l-5-3q-.375-.188-.375-.625t.375-.625l5-3q.5-.313.938.156zm-10.188 2.844q.375.188.375.625t-.375.625l-5 3q-.563.313-.969-.156t.031-.969L9.5 13l-2.063-2.5q-.438-.5 0-.969t.938-.156z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'grin-tongue-wink' => array(
		'p' => 'M9.5 11.25q.813 0 1.625.313t1.406.938.719 1.375q.063.5-.406.75T12 14.563L11.375 14q-.688-.563-1.875-.563T7.625 14L7 14.563q-.375.375-.844.094t-.406-.781q.188-1.125 1.344-1.875t2.406-.75zM20.5 8q2.063 0 3.531 1.469T25.5 13t-1.469 3.531T20.5 18t-3.531-1.469T15.5 13t1.469-3.531T20.5 8zm0 8q1.25 0 2.125-.875T23.5 13t-.875-2.125T20.5 10t-2.125.875T17.5 13t.875 2.125T20.5 16zm0-4.5q.625 0 1.063.438t.438 1.063-.438 1.063-1.063.438-1.063-.438-.438-1.063.438-1.063T20.5 11.5zm-5-11q6.438 0 10.969 4.531T31 16t-4.531 10.969T15.5 31.5 4.531 26.969 0 16 4.531 5.031 15.5.5zm4 25v-2.75l-1.125-.563q-.688-.313-1.344.031t-.781 1.031l-.188.75q-.125.438-.563.438t-.563-.438l-.125-.75q-.188-.688-.844-1.031t-1.344-.031l-1.125.563v2.688q0 1.625 1.156 2.844t2.781 1.219q1.125 0 2.063-.531t1.469-1.438.531-2.031zm1.75 1.563q3.063-1.563 4.906-4.531T28 16.001q0-5.188-3.656-8.844T15.5 3.501 6.656 7.157 3 16.001q0 3.563 1.844 6.531t4.906 4.531q-.25-.875-.25-1.563v-2.75Q8.062 21.5 7.812 20q-.125-.5.25-.813t.813-.125q2.563.813 6.625.813t6.625-.813q.438-.188.813.156t.25.781q-.25 1.5-1.688 2.75v2.75q0 .688-.25 1.563z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'grin-wink' => array(
		'p' => 'M20.5 11.25q1.25 0 2.406.75t1.344 1.875q.063.5-.406.781T23 14.562l-.625-.563q-.688-.563-1.875-.563t-1.875.563l-.625.563q-.375.375-.844.125t-.406-.813q.188-1.125 1.344-1.875t2.406-.75zM10.5 15q-.813 0-1.406-.594T8.5 13t.594-1.406T10.5 11t1.406.594T12.5 13t-.594 1.406T10.5 15zm11.625 4.063q.438-.188.813.125t.25.813q-.313 2.125-2.719 3.563T15.5 25.002t-4.969-1.438-2.719-3.563q-.125-.5.25-.813t.813-.125q2.563.813 6.625.813t6.625-.813z#d#0 28q5.188 0 8.844-3.656T28 16t-3.656-8.844T15.5 3.5 6.656 7.156 3 16t3.656 8.844T15.5 28.5z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'kiss' => array(
		'p' => 'M10.5 11q.813 0 1.406.594T12.5 13t-.594 1.406T10.5 15t-1.406-.594T8.5 13t.594-1.406T10.5 11zm8.5 8.25q0 1.375-2.188 2.25Q19 22.375 19 23.75q0 1-1.281 1.844t-3.156.906H14.5q-.375 0-.5-.375-.063-.375.313-.563l1.063-.438q1.313-.563 1.313-1.344t-1.313-1.344l-1.063-.438q-.25-.125-.25-.469t.25-.469l1.063-.438q1.313-.563 1.313-1.375t-1.313-1.313l-1.063-.5q-.375-.125-.313-.563.125-.438.5-.375 1 .063 1.844.344t1.406.656.906.844.344.906z#d#0 28q5.188 0 8.844-3.656T28 16t-3.656-8.844T15.5 3.5 6.656 7.156 3 16t3.656 8.844T15.5 28.5zm5-17.5q.813 0 1.406.594T22.5 13t-.594 1.406T20.5 15t-1.406-.594T18.5 13t.594-1.406T20.5 11z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'kiss-beam' => array(
		'p' => 'M10.5 9.5q1.188 0 2.281 1.281T14 13.937q0 .438-.375.563t-.563-.25l-.625-1.063q-.75-1.375-1.938-1.375t-2 1.375l-.563 1.063q-.188.313-.594.219t-.344-.531q.063-.75.313-1.438t.594-1.25.781-.938.906-.594.906-.219zm5-9q6.438 0 10.969 4.531T31 16t-4.531 10.969T15.5 31.5 4.531 26.969 0 16 4.531 5.031 15.5.5zm0 28q5.188 0 8.844-3.656T28 16t-3.656-8.844T15.5 3.5 6.656 7.156 3 16t3.656 8.844T15.5 28.5zm3.5-9.25q0 1.375-2.188 2.25Q19 22.375 19 23.75q0 1-1.281 1.844t-3.156.906H14.5q-.375 0-.5-.375-.063-.375.313-.563l1.063-.438q1.313-.563 1.313-1.344t-1.313-1.344l-1.063-.438q-.25-.125-.25-.469t.25-.469l1.063-.438q1.313-.563 1.313-1.375t-1.313-1.313l-1.063-.5q-.375-.125-.313-.563.125-.438.5-.375 1 .063 1.844.344t1.406.656.906.844.344.906zm1.5-9.75q1.188 0 2.281 1.281T24 13.937q0 .438-.375.563t-.563-.25l-.625-1.063q-.75-1.375-1.938-1.375t-2 1.375l-.563 1.063q-.188.313-.594.219t-.344-.531q.125-1.875 1.219-3.156t2.281-1.281z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'kiss-wink-heart' => array(
		'p' => 'M19 19.25q0 1.375-2.188 2.313Q19 22.438 19 23.813q0 .938-1.281 1.781t-3.156.969H14.5q-.375 0-.5-.375-.063-.438.313-.563l1.063-.5q1.313-.563 1.313-1.344t-1.313-1.344l-1.063-.438q-.25-.125-.25-.469t.25-.469l1.063-.438q1.313-.563 1.313-1.344t-1.313-1.344l-1.063-.438q-.375-.188-.313-.563.125-.438.5-.438 1 .063 1.844.344t1.406.656.906.844.344.906zm4.375-5.187q-.688-.625-1.875-.625t-1.875.625l-.625.563q-.375.313-.844.063t-.406-.75q.125-.563.5-1.063t.875-.844 1.125-.531 1.25-.188q1.25 0 2.406.75t1.344 1.875q.063.5-.406.75T24 14.625zM8.5 13.031q0-.844.594-1.438t1.406-.594 1.406.594.594 1.438-.594 1.406T10.5 15t-1.406-.563-.594-1.406zm22.813 12.094q.438 1.125-.094 2.156t-1.656 1.344L24.375 30q-.625.125-.813-.438l-1.438-5.188q-.188-.75.031-1.469t.781-1.219 1.313-.625q1.063-.125 1.938.469t1.125 1.594l.188.563.5-.125q1-.313 1.969.156t1.344 1.406zM20.875 27.25q.688 2.5#r#938-2.938 1.313-6.188 1.313-6.438 0-10.969-4.531T0 16.001 4.531 5.032 15.5.501t10.969 4.531T31 16.001q0 2.875-1.063 5.625-.688-.188-1.188-.188-.438-.813-1.375-1.5.625-1.938.625-3.938 0-5.188-3.656-8.844T15.499 3.5 6.655 7.156 2.999 16t3.656 8.844 8.844 3.656q2.813 0 5.375-1.25z',
		'w' => .982421875,
		'vw' => 31
	    ),
	    'laugh' => array(
		'p' => '#d#8.844 24.344Q28 21.188 28 16t-3.656-8.844T15.5 3.5 6.656 7.156 3 16t3.656 8.844T15.5 28.5t8.844-3.656zM20.5 14q-.813 0-1.406-.594T18.5 12t.594-1.406T20.5 10t1.406.594T22.5 12t-.594 1.406T20.5 14zm-10 0q-.813 0-1.406-.594T8.5 12t.594-1.406T10.5 10t1.406.594T12.5 12t-.594 1.406T10.5 14zm12.125 4q.438 0 .688.281t.188.656q-.375 2.813-2.531 4.688T15.939 25.5h-.875q-2.875 0-5.031-1.875t-2.531-4.688q-.063-.375.188-.656T8.378 18h14.25z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'laugh-beam' => array(
		'p' => '#d#8.844 24.344Q28 21.188 28 16t-3.656-8.844T15.5 3.5 6.656 7.156 3 16t3.656 8.844T15.5 28.5t8.844-3.656zM20.5 9.5q1.188 0 2.281 1.281T24 13.937q0 .438-.375.531t-.563-.219l-.625-1.063q-.75-1.375-1.938-1.375t-2 1.375l-.563 1.063q-.188.313-.594.219t-.344-.531q.125-1.875 1.219-3.156T20.498 9.5zM7.938 14.25q-.188.313-.594.219T7 13.938q.125-1.875 1.219-3.156T10.5 9.501t2.281 1.281T14 13.938q0 .438-.375.531t-.563-.219l-.563-1.063q-.813-1.375-2-1.375t-2 1.375zM22.625 18q.438 0 .688.281t.188.656q-.375 2.813-2.531 4.688T15.939 25.5h-.875q-2.875 0-5.031-1.875t-2.531-4.688q-.063-.375.188-.656T8.378 18h14.25z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'laugh-squint' => array(
		'p' => '#d#8.844 24.344Q28 21.188 28 16t-3.656-8.844T15.5 3.5 6.656 7.156 3 16t3.656 8.844T15.5 28.5t8.844-3.656zM21.5 12.25l2.063 2.5q.438.5 0 .969t-.938.156l-5-3q-.375-.188-.375-.625t.375-.625l5-3q.5-.313.938.156t0 .969zM8.375 15.875q-.563.313-.969-.156t.031-.969l2.063-2.5-2.063-2.5q-.438-.5 0-.969t.938-.156l5 3q.375.188.375.625t-.375.625zM22.625 18q.438 0 .688.281t.188.656q-.375 2.813-2.531 4.688T15.939 25.5h-.875q-2.875 0-5.031-1.875t-2.531-4.688q-.063-.375.188-.656T8.378 18h14.25z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'laugh-wink' => array(
		'p' => '#d#8.844 24.344Q28 21.188 28 16t-3.656-8.844T15.5 3.5 6.656 7.156 3 16t3.656 8.844T15.5 28.5t8.844-3.656zM20.5 10.25q.813 0 1.625.313t1.406.938.719 1.375q.063.5-.406.75T23 13.563L22.375 13q-.688-.563-1.875-.563T18.562 13l-.563.563q-.375.313-.844.063t-.406-.75q.125-.75.719-1.375t1.406-.938 1.625-.313zM10.5 14q-.813 0-1.406-.594T8.5 12t.594-1.406T10.5 10t1.406.594T12.5 12t-.594 1.406T10.5 14zm12.125 4q.438 0 .688.281t.188.656q-.375 2.813-2.531 4.688T15.939 25.5h-.875q-2.875 0-5.031-1.875t-2.531-4.688q-.063-.375.188-.656T8.378 18h14.25z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'meh-blank' => array(
		'p' => '#d#0 28q5.188 0 8.844-3.656T28 16t-3.656-8.844T15.5 3.5 6.656 7.156 3 16t3.656 8.844T15.5 28.5zm-5-17.5q.813 0 1.406.594T12.5 13t-.594 1.406T10.5 15t-1.406-.594T8.5 13t.594-1.406T10.5 11zm10 0q.813 0 1.406.594T22.5 13t-.594 1.406T20.5 15t-1.406-.594T18.5 13t.594-1.406T20.5 11z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'meh-rolling-eyes' => array(
		'p' => '#d#0 28q5.188 0 8.844-3.656T28 16t-3.656-8.844T15.5 3.5 6.656 7.156 3 16t3.656 8.844T15.5 28.5zm5.5-19q1.875 0 3.188 1.313t1.313 3.188-1.313 3.188T21 18.502t-3.188-1.313-1.313-3.188 1.313-3.188T21 9.5zm0 7q1.063 0 1.781-.719T23.5 14q0-1.25-1.125-2 .125.25.125.5 #p#8-1.063-.438-.438-1.063q0-.25.125-.5-1.125.75-1.125 2 0 1.063.719 1.781t1.781.719zM14.5 14q0 1.875-1.313 3.188t-3.188 1.313-3.188-1.313T5.498 14t1.313-3.188 3.188-1.313 3.188 1.313T14.5 14zm-7 0q0 1.063.719 1.781T10 16.5t1.781-.719T12.5 14q0-1.25-1.125-2 .125.25.125.5 #p#8-1.063-.438-.438-1.063q0-.25.125-.5-1.125.75-1.125 2zm12 8q.625 0 1.063.438t.438 1.063-.438 1.063-1.063.438h-8q-.625 0-1.063-.438t-.438-1.063.438-1.063T11.5 22h8z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'sad-cry' => array(
		'p' => '#d#9 24.125Q28 21 28 16q0-5.188-3.656-8.844T15.5 3.5 6.656 7.156 3 16q0 5 3.5 8.625V17.5q0-.625.438-1.063t1.063-.438 1.063.438.438 1.063v9.438q2.813 1.563 6 1.563t6-1.563V17.5q0-.625.438-1.063t1.063-.438 1.063.438.438 1.063v7.125zm-11.656-9.969q-.469.281-.844-.094l-.563-.563q-.75-.563-1.938-.563t-1.875.563l-.625.563q-.375.375-.844.094t-.406-.781q.125-.75.719-1.375t1.406-.938 1.625-.313q1.25 0 2.406.75t1.344 1.875q.063.5-.406.781zM21.5 11.25q1.25 0 2.406.75t1.344 1.875q.063.5-.406.75T24 14.562l-.625-.563q-.688-.563-1.875-.563t-1.875.563l-.625.563q-.375.313-.844.063t-.406-.75q.188-1.125 1.344-1.875t2.406-.75zm-6 5.75q1.438 0 2.469 1.188T19 21.001t-1.031 2.813-2.469 1#q#469-1.188T12 21.001t1.031-2.813T15.5 17z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'sad-tear' => array(
		'p' => '#d#0 28q5.188 0 8.844-3.656T28 16t-3.656-8.844T15.5 3.5 6.656 7.156 3 16t3.656 8.844T15.5 28.5zM16 19q3.75 0 6.125 2.875.438.5.375 1.125t-.563 1-1.094.313-.969-.5Q18.374 22 15.999 22q-.625 0-1.063-.438t-.438-1.063.438-1.063 1.063-.438zm-5.5-4q-.813 0-1.406-.594T8.5 13t.594-1.406T10.5 11t1.406.594T12.5 13t-.594 1.406T10.5 15zm10-4q.813 0 1.406.594T22.5 13t-.594 1.406T20.5 15t-1.406-.594T18.5 13t.594-1.406T20.5 11zm-10.375 6.188q.375-.5.75 0 2.25 3.063 2.25 4.25 0 1.063-.781 1.813t-1.844.75-1.844-.75-.781-1.813q0-1.188 2.25-4.25z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'smile-beam' => array(
		'p' => '#d#0 28q5.188 0 8.844-3.656T28 16t-3.656-8.844T15.5 3.5 6.656 7.156 3 16t3.656 8.844T15.5 28.5zm5.25-8.937q.375-.5 1-.563t1.094.344.531 1.031-.313 1.063q-2.938 3.563-7.563 3.563t-7.563-3.563q-.375-.438-.313-1.063t.531-1.031T9.248 19t1 .563q2.063 2.438 5.25 2.438t5.25-2.438zM8.5 13.188l-.563 1.063q-.188.375-.563.25-.438-.125-.375-.563.063-.75.313-1.438t.594-1.25.781-.938.906-.594.906-.219q1.188 0 2.281 1.281t1.219 3.156q.063.438-.344.563t-.594-.25l-.563-1.063q-.813-1.375-2-1.375t-2 1.375zm12-3.688q1.188 0 2.281 1.281T24 13.937q.063.438-.344.563t-.594-.25l-.563-1.063q-.813-1.375-2-1.375t-2 1.375l-.563 1.063q-.188.375-.563.25-.438-.125-.375-.563.125-1.875 1.219-3.156T20.498 9.5z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'surprise' => array(
		'p' => '#d#0 28q5.188 0 8.844-3.656T28 16t-3.656-8.844T15.5 3.5 6.656 7.156 3 16t3.656 8.844T15.5 28.5zm0-11q1.625 0 2.813 1.188t1.188 2.813-1.188 2.813-2.813 1#q#813-1.188-1#q#813 1#q#813T15.5 17.5zm-3-4.5q0 .813-.594 1.406T10.5 15t-1.406-.594T8.5 13t.594-1.406T10.5 11t1.406.594T12.5 13zm8-2q.813 0 1.406.594T22.5 13t-.594 1.406T20.5 15t-1.406-.594T18.5 13t.594-1.406T20.5 11z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'tired' => array(
		'p' => '#d#0 28q5.188 0 8.844-3.656T28 16t-3.656-8.844T15.5 3.5 6.656 7.156 3 16t3.656 8.844T15.5 28.5zm8.094-18.969q.406.469-.031.969L21.5 13l2.063 2.5q.438.5.031.969t-.969.156l-5-3q-.375-.188-.375-.625t.375-.625l5-3q.563-.313.969.156zM13.75 13q0 .438-.375.625l-5 3q-.563.313-.969-.156t.031-.969L9.5 13l-2.063-2.5q-.438-.5 0-.969t.938-.156l5 3q.375.188.375.625zm1.75 4q2.25 0 4.344 1.688t2.406 4.125q.063.563-.25.938t-.75.188q-2.188-.938-5.75-.938t-5.75.938q-.25.125-.5 0t-.406-.438-.094-.688q.313-2.438 2.406-4.125T15.5 17z',
		'w' => .96875,
		'vw' => 31
	    )
	);
    }

    public static function fab() {
	return array(
		'500px' => array(
			'p' => 'M 6.457031 21.519531 C 6.050781 20.632812 6.023438 20.375 6.917969 20.074219 C 8.519531 19.574219 7.417969 20.648438 9.617188 23.148438 L 9.636719 23.148438 L 9.636719 17.28125 C 9.710938 14.144531 12.386719 11.519531 15.742188 11.519531 C 19.113281 11.519531 21.851562 14.238281 21.851562 17.570312 C 21.851562 21.53125 18.050781 24.644531 13.820312 23.398438 C 13.164062 23.136719 13.6875 21.417969 14.351562 21.613281 C 17.664062 21.613281 19.9375 20.980469 19.9375 17.585938 C 19.9375 13.773438 15.117188 11.988281 12.632812 14.800781 C 11.164062 16.449219 11.53125 17.429688 11.53125 24.648438 C 14.699219 26.585938 18.925781 26.023438 21.554688 23.394531 C 23.105469 21.84375 23.960938 19.769531 23.960938 17.582031 C 23.960938 15.382812 23.101562 13.320312 21.539062 11.75 C 19.988281 10.199219 17.925781 9.34375 15.707031 9.34375 C 13.488281 9.34375 11.40625 10.207031 9.863281 11.75 C 9.84375 11.769531 8.863281 12.78125 8.539062 13.242188 L 8.507812 13.28125 C 8.300781 13.574219 8.113281 13.851562 7.25 13.664062 C 6.820312 13.554688 6.355469 13.300781 6.355469 12.925781 L 6.355469 1.25 C 6.355469 0.9375 6.601562 0.59375 7.011719 0.59375 L 22.09375 0.59375 C 22.613281 0.59375 22.613281 1.320312 22.613281 1.539062 C 22.613281 1.78125 22.613281 2.480469 22.09375 2.480469 L 8.144531 2.480469 L 8.144531 10.789062 L 8.164062 10.789062 C 14.675781 3.925781 25.835938 8.539062 25.835938 17.59375 C 25.835938 28.726562 10.539062 31.363281 6.457031 21.519531 Z M 10.414062 5.21875 C 10.382812 5.480469 10.699219 6.75 11.324219 6.507812 C 19.125 3.539062 24 9.03125 24.414062 9.03125 C 24.710938 9.03125 25.835938 8.074219 25.304688 7.605469 C 19.480469 2.042969 10.648438 4.042969 10.414062 5.21875 Z M 24.5625 25.917969 C 17.6875 32.789062 5.875 29.71875 3.8125 19.40625 C 3.8125 18.644531 1.914062 18.945312 2.007812 19.613281 C 3.507812 30.449219 17.382812 35.667969 25.855469 27.195312 C 26.289062 26.707031 25.070312 25.417969 24.5625 25.917969 Z M 13.351562 19.164062 C 13.351562 19.414062 13.617188 19.617188 13.695312 19.695312 C 13.882812 19.882812 14.074219 19.96875 14.226562 19.96875 C 14.460938 19.96875 14.386719 19.980469 15.617188 18.75 C 16.84375 19.957031 16.8125 19.96875 17.011719 19.96875 C 17.351562 19.96875 18.167969 19.320312 17.679688 18.832031 L 16.601562 17.75 L 17.738281 16.613281 C 18.132812 16.1875 17.105469 15.25 16.726562 15.632812 L 15.605469 16.75 C 14.445312 15.574219 14.457031 15.53125 14.261719 15.53125 C 13.949219 15.53125 13.136719 16.261719 13.488281 16.613281 L 14.625 17.75 C 13.492188 18.867188 13.351562 18.949219 13.351562 19.164062 Z M 13.351562 19.164062',
			'vw' => 28
		),
		'airbnb' => array(
			'p' => 'M 14 23.320312 C 12.421875 21.339844 11.496094 19.605469 11.1875 18.121094 C 9.777344 12.621094 18.226562 12.621094 16.816406 18.121094 C 16.476562 19.636719 15.546875 21.371094 14.003906 23.320312 Z M 22.632812 27.898438 C 20.003906 29.042969 17.40625 27.21875 15.179688 24.742188 C 21.671875 16.613281 18.058594 12.242188 14 12.242188 C 10.566406 12.242188 8.675781 15.148438 9.421875 18.523438 C 9.851562 20.347656 10.996094 22.421875 12.820312 24.742188 C 10.789062 26.996094 9.039062 28.035156 7.5 28.175781 C 4.375 28.640625 1.929688 25.609375 3.042969 22.480469 C 3.988281 20.035156 10.027344 8.03125 10.285156 7.382812 C 11.269531 5.503906 11.882812 3.796875 13.996094 3.796875 C 16.019531 3.796875 16.710938 5.417969 17.769531 7.539062 C 20.019531 11.953125 23.355469 18.632812 24.949219 22.480469 C 25.769531 24.546875 24.863281 26.9375 22.632812 27.898438 Z M 25.570312 19.390625 C 17.515625 2.246094 17.070312 2 14 2 C 11.15625 2 9.945312 3.980469 8.707031 6.550781 C 2.074219 19.820312 1.429688 21.699219 1.375 21.863281 C -0.203125 26.195312 3.046875 30 6.976562 30 C 8.332031 30 10.765625 29.621094 14 26.101562 C 17.667969 30.085938 20.328125 30 21.023438 30 C 24.953125 30.003906 28.203125 26.195312 26.625 21.863281 C 26.625 21.621094 25.574219 19.433594 25.574219 19.390625 Z M 25.570312 19.390625',
			'vw' => 28
		),
		'battle-net' => array(
			'p' => 'M 28.039062 14.101562 C 29.71875 14.113281 30.261719 13.636719 30.46875 13.328125 C 31.25 12.308594 30.03125 10.351562 27.167969 8.871094 C 28.277344 6.769531 29.050781 4.890625 29.4375 3.539062 C 29.648438 2.800781 29.507812 2.351562 29.46875 2.273438 C 29.359375 2.929688 28.476562 5.300781 26.453125 8.527344 C 24.890625 7.824219 22.921875 7.269531 20.59375 7.039062 C 20.035156 5.980469 18.414062 3.046875 16.8125 1.480469 C 15.761719 0.445312 14.917969 0.0664062 14.261719 0.015625 L 14.257812 0.015625 C 13.394531 -0.0820312 12.839844 0.378906 12.546875 0.703125 C 11.46875 1.859375 11.023438 3.753906 10.984375 5.957031 C 10.53125 5.183594 9.910156 4.417969 9.203125 4.335938 L 9.191406 4.335938 C 7.898438 4.117188 6.792969 6.160156 6.941406 9.414062 C 4.542969 9.5 2.503906 9.773438 1.128906 10.117188 C 0.507812 10.269531 0.113281 10.570312 0.0195312 10.726562 C 0.0820312 10.703125 1.417969 10.148438 6.992188 10.148438 C 7.316406 13.460938 8.851562 16.511719 8.617188 15.972656 C 8.007812 16.9375 6.226562 19.871094 5.660156 22.078125 C 5.292969 23.507812 5.386719 24.429688 5.667969 25.027344 C 6.015625 25.824219 6.695312 26.070312 7.117188 26.167969 C 8.679688 26.523438 10.578125 25.941406 12.535156 24.84375 C 12.066406 25.648438 11.667969 26.628906 11.96875 27.304688 C 12.425781 28.53125 14.75 28.46875 17.5 26.714844 C 18.757812 28.726562 20.003906 30.335938 20.980469 31.347656 C 21.140625 31.519531 21.324219 31.667969 21.527344 31.789062 C 21.847656 31.988281 22.0625 32 22.0625 32 C 21.546875 31.578125 19.9375 29.625 18.152344 26.265625 C 19.542969 25.265625 21.007812 23.835938 22.371094 21.933594 C 30.046875 22.222656 31.328125 20.386719 31.621094 19.957031 C 32.539062 18.714844 31.835938 16.367188 28.039062 14.101562 Z M 23.171875 20.738281 C 24.660156 18.382812 25.070312 16.503906 25.011719 14.96875 C 26.753906 16.066406 27.960938 17.316406 28.078125 18.644531 C 28.152344 19.453125 27.574219 20.464844 23.171875 20.738281 Z M 13.554688 24.230469 C 14.167969 23.839844 14.777344 23.410156 15.382812 22.949219 C 15.796875 23.78125 16.230469 24.582031 16.667969 25.335938 C 14.132812 26.703125 12.367188 26.132812 13.554688 24.230469 Z M 26.992188 13.519531 C 26.351562 13.1875 25.671875 12.875 24.96875 12.582031 C 25.464844 11.828125 25.941406 11.058594 26.390625 10.273438 C 28.832031 11.78125 29.261719 13.597656 26.992188 13.519531 Z M 17.449219 24.875 C 17.105469 24.164062 16.761719 23.40625 16.417969 22.597656 C 19.121094 22.675781 20.320312 21.425781 20.371094 21.320312 C 20.371094 21.328125 18.808594 22.300781 16.464844 22.085938 C 18.378906 20.488281 20.15625 18.730469 21.78125 16.835938 C 22.324219 16.199219 22.84375 15.550781 23.339844 14.894531 C 23.316406 14.875 23.242188 14.707031 22.308594 14.144531 C 19.074219 17.910156 15.910156 20.269531 14.011719 21.386719 C 12.722656 20.6875 11.457031 19.402344 10.527344 17.546875 C 9.277344 15.050781 8.652344 12.394531 8.554688 10.289062 C 9.324219 10.347656 10.132812 10.425781 10.984375 10.53125 C 9.589844 12.832031 10.082031 14.46875 10.140625 14.546875 C 10.140625 14.542969 10.082031 12.722656 11.398438 10.824219 C 11.960938 14.105469 12.898438 17.308594 14.191406 20.375 C 14.25 20.351562 14.308594 20.433594 15.359375 19.859375 C 13.714844 15.207031 13.25 11.226562 13.234375 9.023438 C 14.484375 8.246094 16.246094 7.785156 18.335938 7.910156 C 21.121094 8.074219 23.734375 8.863281 25.605469 9.828125 C 25.160156 10.480469 24.675781 11.15625 24.148438 11.859375 C 22.851562 9.5 21.195312 9.113281 21.09375 9.125 C 21.101562 9.125 22.710938 10.003906 23.6875 12.078125 C 21.34375 11.214844 18.933594 10.554688 16.480469 10.09375 C 15.664062 9.941406 14.84375 9.816406 14.019531 9.714844 C 14.015625 9.746094 13.90625 9.832031 13.882812 10.988281 C 18.75 11.890625 22.421875 13.480469 24.335938 14.5625 C 24.382812 16.035156 23.902344 17.789062 22.746094 19.535156 C 21.210938 21.867188 19.222656 23.738281 17.449219 24.875 Z M 19.160156 6.9375 C 16.375 6.832031 14.5625 7.402344 13.242188 8.230469 C 13.367188 4.960938 14.574219 3.457031 15.632812 3.523438 C 16.6875 3.257812 19.0625 6.785156 19.160156 6.9375 Z M 10.996094 7.132812 C 11.027344 7.886719 11.09375 8.671875 11.195312 9.460938 C 10.285156 9.40625 9.398438 9.382812 8.546875 9.382812 C 8.542969 9.585938 8.539062 6.195312 10.089844 6.28125 L 10.09375 6.28125 C 10.453125 6.351562 10.757812 6.714844 10.996094 7.132812 Z M 9.242188 17.257812 C 10.539062 19.738281 11.949219 21.042969 13.320312 21.777344 C 10.394531 23.324219 8.472656 23.027344 8.011719 22.058594 C 8 22.042969 7.316406 21.101562 9.242188 17.257812 Z M 22.371094 21.929688',
		),
		'bootstrap' => array(
			'p' => 'M 18.269531 19.496094 C 18.269531 22.144531 15.785156 22.085938 15.523438 22.085938 L 10.46875 22.085938 L 10.46875 16.980469 L 15.523438 16.980469 C 18.183594 16.980469 18.269531 18.972656 18.269531 19.496094 Z M 15.132812 14.925781 C 15.175781 14.925781 17.535156 14.988281 17.535156 12.65625 C 17.535156 11.6875 17.316406 10.414062 15.132812 10.414062 L 10.46875 10.414062 L 10.46875 14.925781 Z M 28 6.667969 L 28 25.332031 C 27.992188 27.90625 25.90625 29.992188 23.332031 30 L 4.667969 30 C 2.09375 29.992188 0.0078125 27.90625 0 25.332031 L 0 6.667969 C 0.0078125 4.09375 2.09375 2.007812 4.667969 2 L 23.332031 2 C 25.90625 2.007812 27.992188 4.09375 28 6.667969 Z M 21.128906 19.867188 C 21.128906 18.519531 20.710938 16.222656 18.0625 15.65625 L 18.0625 15.609375 C 19.496094 15 20.394531 13.84375 20.394531 12.132812 C 20.394531 11.695312 20.519531 8.085938 15.546875 8.085938 L 7.609375 8.085938 L 7.609375 24.417969 C 15.625 24.417969 16.351562 24.523438 17.832031 24.0625 C 18.722656 23.785156 21.128906 22.9375 21.128906 19.867188 Z M 21.128906 19.867188',
			'vw' => 28
		),
		'buffer' => array(
			'p' => 'M 26.738281 23.792969 L 14.457031 29.90625 C 14.167969 30.03125 13.835938 30.03125 13.542969 29.90625 L 1.261719 23.792969 C 1.011719 23.667969 1.011719 23.460938 1.261719 23.335938 L 4.203125 21.875 C 4.496094 21.75 4.828125 21.75 5.121094 21.875 L 13.542969 26.0625 C 13.835938 26.1875 14.167969 26.1875 14.457031 26.0625 L 22.882812 21.875 C 23.175781 21.75 23.503906 21.75 23.796875 21.875 L 26.738281 23.339844 C 26.992188 23.460938 26.992188 23.667969 26.738281 23.792969 Z M 26.738281 15.257812 L 23.796875 13.792969 C 23.503906 13.667969 23.175781 13.667969 22.882812 13.792969 L 14.457031 17.988281 C 14.164062 18.113281 13.835938 18.113281 13.542969 17.988281 L 5.121094 13.792969 C 4.828125 13.667969 4.496094 13.667969 4.203125 13.792969 L 1.261719 15.257812 C 1.011719 15.382812 1.011719 15.589844 1.261719 15.714844 L 13.542969 21.828125 C 13.835938 21.953125 14.167969 21.953125 14.457031 21.828125 L 26.738281 15.714844 C 26.992188 15.589844 26.992188 15.382812 26.738281 15.257812 Z M 1.261719 8.152344 L 13.542969 13.792969 C 13.835938 13.910156 14.164062 13.910156 14.457031 13.792969 L 26.738281 8.152344 C 26.988281 8.035156 26.988281 7.84375 26.738281 7.730469 L 14.457031 2.085938 C 14.164062 1.96875 13.835938 1.96875 13.542969 2.085938 L 1.261719 7.730469 C 1.007812 7.84375 1.007812 8.035156 1.261719 8.152344 Z M 1.261719 8.152344',
			'vw' => 28,
		),
		'buy-n-large' => array(
			'p' => 'M 18 2 C 8.328125 2 0.488281 8.269531 0.488281 16 C 0.488281 23.730469 8.328125 30 18 30 C 27.671875 30 35.511719 23.730469 35.511719 16 C 35.511719 8.269531 27.671875 2 18 2 Z M 12.664062 24.324219 L 4.007812 24.410156 L 8.835938 6.238281 L 17.175781 6.238281 C 21.121094 6.238281 22.484375 8.027344 22.050781 10.789062 C 22.027344 10.933594 21.996094 11.078125 21.957031 11.21875 C 21.601562 11.136719 21.242188 11.097656 20.878906 11.097656 C 18.234375 11.097656 16.085938 13.214844 16.085938 15.828125 C 16.085938 18.148438 17.78125 20.078125 20.019531 20.480469 C 18.878906 22.800781 16.511719 24.285156 12.664062 24.324219 Z M 22.375 12.945312 L 24.375 12.945312 L 22.988281 18.589844 L 20.777344 18.589844 L 20.078125 16.363281 L 19.589844 18.589844 L 17.222656 18.589844 L 18.886719 12.945312 L 20.847656 12.945312 L 21.785156 15.242188 Z M 31.492188 24.324219 L 19.175781 24.324219 L 20.164062 20.5 C 20.402344 20.535156 20.640625 20.550781 20.882812 20.550781 C 23.527344 20.550781 25.675781 18.433594 25.675781 15.824219 C 25.675781 13.78125 24.363281 12.046875 22.527344 11.382812 L 23.859375 6.234375 L 29.640625 6.234375 L 26.324219 19.070312 L 32.816406 19.070312 Z M 13.230469 16.835938 L 11.6875 16.835938 L 10.824219 20.367188 L 12.367188 20.367188 C 13.378906 20.367188 14.375 20.167969 14.738281 18.699219 C 15.085938 17.304688 14.242188 16.835938 13.230469 16.835938 Z M 14.5625 10.625 L 13.230469 10.625 L 12.5 13.605469 L 13.835938 13.605469 C 14.960938 13.605469 16.046875 12.691406 16.285156 11.722656 C 16.578125 10.542969 15.691406 10.625 14.5625 10.625 Z M 14.5625 10.625',
			'vw' => 36
		),
		'chromecast' => array(
			'p' => 'M 27.988281 4 L 4 4 C 2.523438 4 1.332031 5.195312 1.332031 6.667969 L 1.332031 10.664062 L 4 10.664062 L 4 6.667969 L 27.988281 6.667969 L 27.988281 25.332031 L 18.664062 25.332031 L 18.664062 28 L 28 28 C 29.476562 28 30.667969 26.804688 30.667969 25.332031 L 30.667969 6.667969 C 30.667969 5.195312 29.460938 4 27.988281 4 Z M 1.332031 23.976562 L 1.332031 27.96875 L 5.324219 27.96875 C 5.324219 25.761719 3.539062 23.976562 1.332031 23.976562 Z M 1.332031 18.664062 L 1.332031 21.3125 C 5.011719 21.3125 7.992188 24.320312 7.992188 28 L 10.664062 28 C 10.667969 22.851562 6.480469 18.667969 1.332031 18.664062 Z M 13.335938 28 L 16.007812 28 C 15.976562 19.90625 9.425781 13.355469 1.332031 13.335938 L 1.332031 15.988281 C 7.957031 15.976562 13.332031 21.375 13.335938 28 Z M 13.335938 28',
		),
		'cloudflare' => array(
			'p' => 'M 25.492188 19.996094 L 11.070312 19.8125 C 10.980469 19.808594 10.894531 19.765625 10.84375 19.691406 C 10.792969 19.613281 10.78125 19.519531 10.8125 19.433594 C 10.863281 19.289062 10.992188 19.1875 11.144531 19.175781 L 25.703125 18.992188 C 27.433594 18.914062 29.300781 17.519531 29.957031 15.820312 L 30.785156 13.660156 C 30.808594 13.601562 30.820312 13.539062 30.820312 13.476562 C 30.820312 13.441406 30.816406 13.410156 30.808594 13.375 C 29.863281 9.246094 26.292969 6.238281 22.0625 6.015625 C 17.828125 5.789062 13.960938 8.394531 12.578125 12.398438 C 11.136719 11.308594 9.160156 11.25 7.65625 12.253906 C 6.148438 13.253906 5.441406 15.097656 5.886719 16.847656 C 2.621094 16.945312 0 19.609375 0 22.882812 C 0 23.175781 0.0234375 23.464844 0.0625 23.753906 C 0.0859375 23.894531 0.203125 23.996094 0.34375 23.996094 L 26.972656 24 C 26.976562 24 26.976562 24 26.980469 24 C 27.132812 23.996094 27.265625 23.894531 27.308594 23.75 L 27.515625 23.042969 C 27.757812 22.207031 27.667969 21.433594 27.257812 20.863281 C 26.882812 20.339844 26.253906 20.03125 25.492188 19.996094 Z M 32.117188 13.820312 C 31.980469 13.820312 31.847656 13.824219 31.714844 13.828125 C 31.621094 13.835938 31.539062 13.902344 31.507812 13.996094 L 30.941406 15.945312 C 30.699219 16.78125 30.789062 17.554688 31.199219 18.125 C 31.574219 18.648438 32.199219 18.957031 32.960938 18.992188 L 36.039062 19.175781 C 36.125 19.179688 36.207031 19.222656 36.257812 19.296875 C 36.308594 19.371094 36.320312 19.46875 36.289062 19.554688 C 36.238281 19.699219 36.105469 19.800781 35.953125 19.8125 L 32.757812 19.996094 C 31.023438 20.074219 29.15625 21.46875 28.5 23.167969 L 28.269531 23.769531 C 28.25 23.820312 28.257812 23.878906 28.285156 23.921875 C 28.316406 23.96875 28.367188 23.996094 28.421875 24 C 28.425781 24 28.425781 24 28.429688 24 L 39.425781 24 C 39.554688 24 39.671875 23.914062 39.707031 23.789062 C 39.902344 23.097656 40 22.382812 40 21.664062 C 40 17.332031 36.46875 13.820312 32.117188 13.820312 Z M 32.117188 13.820312',
			'vw' => 40
		),
		'cotton-bureau' => array(
			'p' => 'M 29.644531 20.652344 C 28.164062 26.390625 23.753906 29.6875 17.027344 29.921875 L 17.027344 26.851562 C 17.027344 23.851562 18.675781 22.199219 21.675781 22.199219 C 25.550781 22.199219 27.875 19.875 27.875 16 C 27.875 12.164062 25.59375 9.859375 21.789062 9.808594 C 19.726562 5.476562 12.632812 5.769531 10.710938 9.808594 C 6.90625 9.859375 4.625 12.164062 4.625 16 C 4.625 19.882812 6.953125 22.214844 10.835938 22.214844 C 13.835938 22.214844 15.496094 23.851562 15.496094 26.863281 L 15.496094 29.9375 C 7.09375 29.625 2.304688 24.621094 2.304688 16 C 2.304688 7.136719 7.386719 2.050781 16.253906 2.050781 C 23.425781 2.050781 28.117188 5.375 29.671875 11.351562 L 31.25 11.351562 C 29.617188 4.46875 24.265625 0.5 16.238281 0.5 C 6.5625 0.5 0.75 6.324219 0.75 15.988281 C 0.75 25.695312 6.574219 31.519531 16.238281 31.5 C 24.253906 31.5 29.605469 27.511719 31.21875 20.652344 Z M 22.3125 11.394531 C 24.898438 11.609375 26.324219 13.207031 26.324219 16 C 26.324219 19 24.671875 20.652344 21.675781 20.652344 C 19.886719 20.652344 18.59375 20.050781 17.824219 18.941406 C 23.015625 17.90625 22.550781 12.714844 22.3125 11.394531 Z M 17.207031 17.480469 C 17.054688 16.835938 16.1875 12.042969 20.722656 11.417969 C 20.863281 12.046875 21.753906 16.863281 17.207031 17.480469 Z M 16.25 8.25 C 18.039062 8.25 19.3125 8.855469 20.089844 9.976562 C 18.316406 10.316406 17.003906 11.261719 16.242188 12.691406 C 15.476562 11.261719 14.164062 10.316406 12.390625 9.976562 C 13.167969 8.871094 14.46875 8.265625 16.238281 8.265625 Z M 11.78125 11.421875 C 16.351562 12.082031 15.460938 16.84375 15.3125 17.484375 C 10.785156 16.867188 11.625 12.046875 11.796875 11.421875 Z M 10.824219 20.652344 C 7.824219 20.652344 6.175781 19 6.175781 16 C 6.175781 13.226562 7.605469 11.625 10.1875 11.394531 C 9.765625 13.71875 10.101562 18.054688 14.667969 18.941406 C 13.90625 20.042969 12.613281 20.648438 10.84375 20.648438 Z M 14.152344 21.425781 C 15.042969 20.953125 15.777344 20.222656 16.25 19.328125 C 16.734375 20.234375 17.457031 20.925781 18.363281 21.425781 C 17.464844 21.902344 16.734375 22.636719 16.265625 23.539062 C 15.765625 22.632812 15.074219 21.898438 14.167969 21.425781 Z M 14.152344 21.425781',
		),
		'dailymotion' => array(
			'p' => 'M 18.683594 16.6875 C 18.21875 16.425781 17.695312 16.292969 17.160156 16.300781 C 16.335938 16.300781 15.636719 16.574219 15.070312 17.128906 C 14.503906 17.683594 14.21875 18.378906 14.21875 19.21875 C 14.21875 20.097656 14.496094 20.820312 15.050781 21.378906 C 15.601562 21.941406 16.300781 22.21875 17.140625 22.21875 C 17.992188 22.21875 18.703125 21.933594 19.269531 21.359375 C 19.839844 20.785156 20.121094 20.070312 20.125 19.21875 C 20.128906 18.703125 19.996094 18.199219 19.742188 17.75 C 19.496094 17.304688 19.128906 16.9375 18.683594 16.6875 Z M 0 2 L 0 30 L 28 30 L 28 2 Z M 23.417969 25.328125 L 20.101562 25.328125 L 20.101562 23.835938 L 20.058594 23.835938 C 19.402344 24.925781 18.238281 25.472656 16.574219 25.472656 C 15.425781 25.472656 14.40625 25.199219 13.515625 24.65625 C 12.636719 24.117188 11.921875 23.34375 11.457031 22.417969 C 10.976562 21.472656 10.734375 20.414062 10.734375 19.238281 C 10.734375 18.089844 10.980469 17.042969 11.46875 16.097656 C 11.9375 15.179688 12.648438 14.40625 13.527344 13.863281 C 14.410156 13.316406 15.402344 13.042969 16.507812 13.042969 C 17.144531 13.035156 17.773438 13.144531 18.367188 13.371094 C 18.921875 13.585938 19.441406 13.941406 19.929688 14.433594 L 19.929688 9.5625 L 23.417969 8.808594 Z M 23.417969 25.328125',
			'vw' => 28
		),
		'deezer' => array(
			'p' => 'M 28.214844 15.292969 L 36 15.292969 L 36 10.75 L 28.214844 10.75 Z M 28.214844 4.425781 L 28.214844 8.96875 L 36 8.96875 L 36 4.425781 Z M 28.214844 21.617188 L 36 21.617188 L 36 17.074219 L 28.214844 17.074219 Z M 0 27.941406 L 7.785156 27.941406 L 7.785156 23.402344 L 0 23.402344 Z M 9.40625 27.941406 L 17.1875 27.941406 L 17.1875 23.402344 L 9.40625 23.402344 Z M 18.8125 27.941406 L 26.59375 27.941406 L 26.59375 23.402344 L 18.8125 23.402344 Z M 28.214844 27.941406 L 36 27.941406 L 36 23.402344 L 28.214844 23.402344 Z M 18.8125 21.617188 L 26.59375 21.617188 L 26.59375 17.074219 L 18.8125 17.074219 Z M 9.40625 21.617188 L 17.1875 21.617188 L 17.1875 17.074219 L 9.40625 17.074219 Z M 9.40625 15.292969 L 17.1875 15.292969 L 17.1875 10.75 L 9.40625 10.75 Z M 9.40625 15.292969',
			'vw' => 36
		),
		'edge-legacy' => array(
			'p' => 'M 1.605469 14.261719 L 1.628906 14.230469 C 1.628906 14.238281 1.628906 14.25 1.625 14.261719 Z M 30.394531 15.230469 C 30.394531 12.480469 29.90625 9.949219 28.59375 7.578125 C 26.03125 2.992188 21.496094 0.5 16.179688 0.5 C 7.4375 0.484375 2.539062 7.074219 1.628906 14.230469 C 4.28125 10.398438 8.945312 6.644531 15.402344 6.417969 C 15.402344 6.417969 22.257812 6.417969 21.617188 12.980469 L 10.625 12.980469 C 11.023438 10.644531 11.785156 9.292969 12.769531 8.046875 C 8.082031 10.226562 5.15625 14.054688 5.222656 19.816406 C 5.277344 24.28125 8.359375 28.871094 12.769531 30.566406 C 17.980469 32.558594 24.820312 31.015625 27.78125 29.234375 L 27.78125 22.707031 C 22.726562 26.238281 10.851562 26.515625 10.761719 18.484375 L 30.394531 18.484375 Z M 30.394531 15.230469',
		),
		'evernote' => array(
			'p' => 'M 7.550781 8.261719 C 7.652344 9.65625 6.453125 9.613281 6.199219 9.613281 C 1.890625 9.613281 1.597656 9.550781 0.976562 9.820312 C 0.941406 9.835938 0.929688 9.820312 0.953125 9.796875 L 7.738281 2.902344 C 7.761719 2.878906 7.773438 2.890625 7.761719 2.925781 C 7.488281 3.550781 7.550781 3.871094 7.550781 8.261719 Z M 12.488281 27.511719 C 11.570312 25.195312 13.300781 22.703125 15.769531 22.722656 C 16.863281 22.722656 17.183594 24.175781 16.269531 24.6875 C 15.882812 24.894531 14.707031 24.796875 14.695312 25.886719 C 14.695312 26.957031 15.925781 27.449219 16.648438 27.445312 C 18.222656 27.445312 19.5 26.167969 19.5 24.589844 L 19.5 24.585938 C 19.5 23.859375 19.011719 21.632812 16.527344 21.125 C 16.046875 21.03125 12.464844 20.730469 12.257812 17.96875 C 12.023438 19.027344 11.167969 21.9375 9.5625 22.289062 C 9.015625 22.410156 5.207031 22.765625 2.503906 19.988281 C 2.503906 19.988281 1.34375 19.039062 0.742188 16.367188 C 0.53125 15.382812 0.160156 13.886719 0.0429688 12.492188 C 0.0429688 11.367188 0.742188 10.589844 1.609375 10.480469 C 6.671875 10.480469 7.234375 10.625 7.921875 9.992188 C 8.539062 9.414062 8.410156 9.023438 8.410156 3.570312 C 8.472656 3.050781 8.898438 1.644531 11.75 2.058594 C 12.125 2.113281 13.742188 2.320312 14.09375 3.976562 L 18.109375 4.671875 C 19.386719 4.902344 22.542969 5.109375 23.144531 8.292969 C 24.5625 15.859375 23.703125 23.195312 23.632812 23.195312 C 22.632812 30.34375 16.691406 30 16.691406 30 C 15.507812 29.984375 13.300781 29.414062 12.488281 27.511719 Z M 17.546875 14.710938 C 17.484375 14.832031 17.410156 15.085938 17.601562 15.148438 C 18.480469 15.457031 20.085938 15.574219 20.46875 15.492188 C 20.664062 15.476562 20.660156 15.21875 20.625 15.078125 C 20.402344 13.710938 18.070312 13.421875 17.546875 14.707031 Z M 17.546875 14.710938',
			'vw' => 24
		),
		'firefox-browser' => array(
			'p' => 'M 11.835938 9.554688 Z M 8.164062 7.71875 C 8.175781 7.71875 8.167969 7.71875 8.164062 7.71875 Z M 30.128906 10.550781 C 29.464844 8.957031 28.125 7.238281 27.070312 6.695312 C 27.925781 8.375 28.421875 10.0625 28.613281 11.320312 C 28.613281 11.320312 28.613281 11.328125 28.617188 11.34375 C 26.890625 7.046875 23.96875 5.316406 21.582031 1.542969 C 21.460938 1.351562 21.339844 1.160156 21.222656 0.960938 C 21.160156 0.855469 21.105469 0.75 21.054688 0.644531 C 20.957031 0.453125 20.878906 0.25 20.828125 0.0429688 C 20.828125 0.0234375 20.8125 0.00390625 20.792969 0 C 20.785156 0 20.773438 0 20.765625 0 L 20.757812 0.0078125 L 20.746094 0.0117188 L 20.75 0.00390625 C 17.363281 1.988281 15.957031 5.464844 15.59375 7.675781 C 14.546875 7.738281 13.523438 8 12.574219 8.449219 C 12.398438 8.535156 12.3125 8.746094 12.382812 8.933594 C 12.449219 9.132812 12.667969 9.238281 12.867188 9.167969 L 12.902344 9.15625 C 13.726562 8.765625 14.621094 8.53125 15.53125 8.46875 L 15.621094 8.460938 C 15.746094 8.453125 15.871094 8.449219 15.996094 8.449219 C 16.738281 8.441406 17.476562 8.542969 18.1875 8.75 C 18.230469 8.761719 18.269531 8.777344 18.3125 8.789062 C 18.429688 8.824219 18.546875 8.863281 18.664062 8.90625 C 18.75 8.9375 18.832031 8.96875 18.917969 9.003906 C 18.984375 9.03125 19.054688 9.058594 19.121094 9.089844 C 19.226562 9.136719 19.328125 9.183594 19.433594 9.234375 C 19.480469 9.257812 19.527344 9.28125 19.574219 9.308594 C 19.671875 9.359375 19.773438 9.414062 19.871094 9.472656 C 19.933594 9.507812 19.996094 9.546875 20.058594 9.582031 C 21.160156 10.265625 22.078125 11.214844 22.722656 12.34375 C 21.910156 11.769531 20.453125 11.203125 19.046875 11.449219 C 24.53125 14.191406 23.058594 23.628906 15.460938 23.273438 C 14.785156 23.246094 14.113281 23.117188 13.476562 22.890625 C 13.324219 22.835938 13.175781 22.773438 13.027344 22.707031 C 12.941406 22.667969 12.855469 22.628906 12.769531 22.582031 C 10.90625 21.625 9.367188 19.808594 9.175781 17.597656 C 9.175781 17.597656 9.878906 14.976562 14.214844 14.976562 C 14.683594 14.976562 16.023438 13.671875 16.046875 13.289062 C 16.042969 13.164062 13.390625 12.109375 12.355469 11.089844 C 11.800781 10.546875 11.539062 10.285156 11.308594 10.085938 C 11.183594 9.980469 11.050781 9.882812 10.914062 9.789062 C 10.566406 8.574219 10.550781 7.285156 10.871094 6.0625 C 9.304688 6.777344 8.085938 7.902344 7.199219 8.898438 L 7.191406 8.898438 C 6.589844 8.132812 6.628906 5.609375 6.667969 5.082031 C 6.660156 5.046875 6.214844 5.3125 6.15625 5.351562 C 5.625 5.730469 5.125 6.160156 4.667969 6.625 C 4.144531 7.15625 3.667969 7.726562 3.242188 8.335938 C 2.261719 9.722656 1.566406 11.292969 1.199219 12.953125 C 1.195312 12.96875 1.050781 13.59375 0.949219 14.359375 C 0.929688 14.476562 0.914062 14.597656 0.898438 14.71875 C 0.863281 14.949219 0.835938 15.199219 0.808594 15.59375 C 0.808594 15.609375 0.808594 15.621094 0.804688 15.636719 C 0.796875 15.808594 0.785156 15.976562 0.777344 16.144531 C 0.777344 16.171875 0.777344 16.195312 0.777344 16.222656 C 0.777344 24.640625 7.601562 31.464844 16.019531 31.464844 C 23.5625 31.464844 29.820312 25.992188 31.046875 18.800781 C 31.074219 18.605469 31.09375 18.410156 31.117188 18.214844 C 31.421875 15.597656 31.082031 12.851562 30.128906 10.554688 Z M 30.128906 10.550781',
		),
		'git-alt' => array(
			'p' => 'M 27.472656 14.753906 L 15.25 2.527344 C 14.546875 1.824219 13.402344 1.824219 12.699219 2.527344 L 10.15625 5.066406 L 13.378906 8.289062 C 15.070312 7.714844 16.671875 9.335938 16.089844 11.015625 L 19.195312 14.121094 C 21.332031 13.382812 23.015625 16.058594 21.410156 17.664062 C 19.753906 19.320312 17.023438 17.484375 17.910156 15.332031 L 15.015625 12.4375 L 15.015625 20.054688 C 16.59375 20.835938 16.40625 22.667969 15.582031 23.492188 C 14.742188 24.328125 13.386719 24.328125 12.546875 23.492188 C 11.449219 22.390625 11.855469 20.558594 13.25 19.992188 L 13.25 12.304688 C 11.949219 11.769531 11.710938 10.382812 12.085938 9.492188 L 8.910156 6.3125 L 0.527344 14.695312 C -0.175781 15.402344 -0.175781 16.542969 0.527344 17.246094 L 12.753906 29.472656 C 13.457031 30.175781 14.597656 30.175781 15.304688 29.472656 L 27.472656 17.304688 C 28.175781 16.597656 28.175781 15.457031 27.472656 14.753906 Z M 27.472656 14.753906',
			'vw' => 28
		),
		'google-pay' => array(
			'p' => 'M 6.609375 13.4375 L 6.609375 16.015625 L 10.175781 16.015625 C 10.03125 16.847656 9.554688 17.582031 8.855469 18.054688 C 8.257812 18.460938 7.496094 18.695312 6.605469 18.695312 C 4.878906 18.695312 3.421875 17.515625 2.898438 15.933594 C 2.625 15.101562 2.625 14.203125 2.898438 13.371094 C 3.421875 11.777344 4.878906 10.597656 6.605469 10.597656 C 7.550781 10.578125 8.460938 10.941406 9.136719 11.601562 L 11.03125 9.6875 C 9.835938 8.554688 8.25 7.929688 6.609375 7.949219 C 4.097656 7.957031 1.8125 9.390625 0.707031 11.640625 C -0.234375 13.535156 -0.234375 15.761719 0.707031 17.652344 L 0.707031 17.664062 C 1.8125 19.914062 4.101562 21.34375 6.609375 21.351562 C 8.386719 21.351562 9.890625 20.753906 10.984375 19.730469 C 12.234375 18.566406 12.945312 16.847656 12.945312 14.796875 C 12.945312 14.34375 12.910156 13.886719 12.835938 13.4375 Z M 30.945312 13.1875 C 30.3125 12.601562 29.449219 12.304688 28.359375 12.304688 C 26.953125 12.304688 25.898438 12.824219 25.203125 13.859375 L 26.503906 14.6875 C 26.984375 13.976562 27.632812 13.625 28.460938 13.625 C 28.984375 13.625 29.492188 13.820312 29.882812 14.171875 C 30.265625 14.507812 30.488281 14.992188 30.488281 15.5 L 30.488281 15.84375 C 29.917969 15.527344 29.203125 15.359375 28.320312 15.359375 C 27.292969 15.359375 26.46875 15.601562 25.855469 16.09375 C 25.238281 16.589844 24.925781 17.238281 24.925781 18.066406 C 24.90625 18.816406 25.226562 19.535156 25.796875 20.023438 C 26.375 20.542969 27.109375 20.804688 27.972656 20.804688 C 28.992188 20.804688 29.796875 20.347656 30.410156 19.4375 L 30.472656 19.4375 L 30.472656 20.542969 L 31.886719 20.542969 L 31.886719 15.625 C 31.890625 14.589844 31.578125 13.769531 30.945312 13.1875 Z M 29.742188 18.769531 C 29.304688 19.214844 28.707031 19.464844 28.082031 19.464844 C 27.667969 19.472656 27.261719 19.335938 26.9375 19.074219 C 26.628906 18.84375 26.449219 18.484375 26.453125 18.097656 C 26.453125 17.660156 26.652344 17.296875 27.046875 17.011719 C 27.441406 16.722656 27.957031 16.574219 28.550781 16.574219 C 29.375 16.5625 30.019531 16.75 30.476562 17.121094 C 30.476562 17.753906 30.230469 18.304688 29.742188 18.769531 Z M 23.890625 9.894531 C 23.21875 9.222656 22.304688 8.855469 21.359375 8.875 L 17.441406 8.875 L 17.441406 20.546875 L 18.917969 20.546875 L 18.917969 15.820312 L 21.355469 15.820312 C 22.355469 15.820312 23.199219 15.484375 23.886719 14.824219 C 23.941406 14.765625 24 14.710938 24.054688 14.65625 C 25.304688 13.289062 25.234375 11.167969 23.890625 9.890625 Z M 22.855469 13.78125 C 22.476562 14.183594 21.945312 14.40625 21.394531 14.386719 L 18.917969 14.386719 L 18.917969 10.3125 L 21.394531 10.3125 C 21.925781 10.3125 22.433594 10.519531 22.808594 10.890625 C 23.605469 11.683594 23.625 12.964844 22.855469 13.78125 Z M 38.394531 12.5625 L 36.109375 18.292969 L 36.082031 18.292969 L 33.742188 12.5625 L 32.136719 12.5625 L 35.375 20.035156 L 33.539062 24.054688 L 35.0625 24.054688 L 40 12.5625 Z M 38.394531 12.5625',
			'vw' => 40
		),
		'guilded' => array(
			'p' => 'M 27.714844 4 L 0.285156 4 C 0.285156 10.453125 1.671875 15.253906 3 17.898438 C 7.003906 25.882812 14 28 14.078125 28 C 17.5625 26.722656 20.609375 24.476562 22.863281 21.53125 C 24.480469 19.414062 26.179688 16.082031 26.984375 12.421875 L 10.738281 12.421875 C 11 14.699219 12.125 16.667969 13.558594 17.855469 L 19.09375 17.855469 C 18.03125 19.621094 16.082031 21.257812 14.066406 22.199219 C 12.113281 21.371094 9.75 19.289062 8.03125 16.050781 C 6.363281 12.6875 6.339844 9.433594 6.339844 9.433594 L 27.347656 9.433594 C 27.597656 7.632812 27.71875 5.816406 27.714844 4 Z M 27.714844 4',
			'vw' => 28
		),
		'hive' => array(
			'p' => 'M 16.273438 15.929688 L 8.222656 2.070312 C 8.195312 2.027344 8.152344 2 8.101562 2 C 8.050781 2 8.007812 2.027344 7.980469 2.070312 L 0.0195312 15.929688 C -0.0078125 15.972656 -0.0078125 16.027344 0.0195312 16.070312 L 8.070312 29.929688 C 8.09375 29.972656 8.140625 30 8.191406 30 C 8.238281 30 8.285156 29.972656 8.308594 29.929688 L 16.273438 16.070312 C 16.296875 16.027344 16.296875 15.972656 16.273438 15.929688 Z M 18.714844 14.324219 C 18.738281 14.367188 18.785156 14.390625 18.832031 14.390625 L 22.988281 14.390625 C 23.039062 14.390625 23.085938 14.363281 23.109375 14.320312 C 23.132812 14.277344 23.132812 14.226562 23.109375 14.183594 L 16.195312 2.070312 C 16.171875 2.027344 16.125 2 16.074219 2 L 11.917969 2 C 11.871094 2 11.824219 2.027344 11.800781 2.070312 C 11.777344 2.113281 11.777344 2.167969 11.800781 2.207031 Z M 31.980469 15.929688 L 24.054688 2.070312 C 24.03125 2.027344 23.984375 2 23.9375 2 L 19.773438 2 C 19.726562 2 19.679688 2.027344 19.65625 2.070312 C 19.628906 2.113281 19.628906 2.164062 19.65625 2.207031 L 27.539062 16 L 19.65625 29.792969 C 19.628906 29.835938 19.628906 29.886719 19.65625 29.929688 C 19.679688 29.972656 19.726562 30 19.773438 30 L 23.9375 30 C 23.984375 30 24.03125 29.972656 24.054688 29.929688 L 31.980469 16.070312 C 32.007812 16.027344 32.007812 15.972656 31.980469 15.929688 Z M 22.875 17.808594 L 18.71875 17.808594 C 18.671875 17.808594 18.625 17.832031 18.601562 17.875 L 11.800781 29.792969 C 11.777344 29.832031 11.777344 29.886719 11.800781 29.929688 C 11.824219 29.972656 11.871094 30 11.917969 30 L 16.074219 30 C 16.125 30 16.171875 29.972656 16.195312 29.929688 L 22.996094 18.015625 C 23.019531 17.972656 23.019531 17.921875 22.996094 17.878906 C 22.972656 17.835938 22.925781 17.808594 22.875 17.808594 Z M 22.875 17.808594',
		),
		'ideal' => array(
			'p' => 'M 7.851562 10.34375 C 6.15625 10.34375 4.785156 11.714844 4.78125 13.410156 C 4.78125 15.101562 6.15625 16.476562 7.851562 16.476562 C 9.542969 16.476562 10.917969 15.101562 10.917969 13.410156 C 10.917969 11.714844 9.542969 10.34375 7.851562 10.34375 Z M 5.382812 26.613281 L 10.316406 26.613281 L 10.316406 17.832031 L 5.382812 17.832031 Z M 14.851562 13.390625 C 14.851562 12.140625 14.226562 11.980469 13.679688 11.980469 L 12.800781 11.980469 L 12.800781 14.84375 L 13.679688 14.84375 C 14.289062 14.84375 14.851562 14.667969 14.851562 13.390625 Z M 27.457031 16.265625 L 27.457031 10.558594 L 28.878906 10.558594 L 28.878906 14.84375 L 30.984375 14.84375 C 30.40625 7.066406 24.289062 5.386719 18.730469 5.386719 L 12.800781 5.386719 L 12.800781 10.5625 L 13.675781 10.5625 C 15.277344 10.5625 16.269531 11.648438 16.269531 13.390625 C 16.269531 15.191406 15.300781 16.265625 13.675781 16.265625 L 12.800781 16.265625 L 12.800781 26.617188 L 18.730469 26.617188 C 27.765625 26.617188 30.914062 22.421875 31.023438 16.265625 Z M 20.597656 16.265625 L 17.082031 16.265625 L 17.082031 10.5625 L 20.484375 10.5625 L 20.484375 11.984375 L 18.5 11.984375 L 18.5 12.644531 L 20.375 12.644531 L 20.375 14.0625 L 18.5 14.0625 L 18.5 14.84375 L 20.59375 14.84375 Z M 25.261719 16.265625 L 24.941406 15.160156 L 23.082031 15.160156 L 22.757812 16.265625 L 21.28125 16.265625 L 23 10.558594 L 25.023438 10.558594 L 26.742188 16.265625 Z M 18.726562 2 L 2 2 L 2 30 L 18.726562 30 C 28.84375 30 34.414062 25.015625 34.414062 15.96875 C 34.414062 10.75 32.375 2 18.726562 2 Z M 18.726562 28.683594 L 3.316406 28.683594 L 3.316406 3.316406 L 18.726562 3.316406 C 27.609375 3.316406 33.097656 7.355469 33.097656 15.96875 C 33.097656 24.347656 28.035156 28.683594 18.726562 28.683594 Z M 23.96875 12.128906 L 23.5 13.742188 L 24.523438 13.742188 L 24.054688 12.128906 Z M 23.96875 12.128906',
			'vw' => 36
		),
		'innosoft' => array(
			'p' => 'M 26.410156 9.980469 C 26.398438 9.375 26.070312 8.820312 25.542969 8.523438 C 25.035156 8.234375 24.410156 8.238281 23.90625 8.53125 L 4.621094 19.664062 L 4.621094 11.015625 C 4.621094 10.75 4.765625 10.503906 5 10.371094 L 13.628906 5.386719 C 13.859375 5.257812 14.144531 5.257812 14.375 5.390625 L 16.414062 6.566406 L 7.035156 11.984375 L 7.035156 15.484375 L 22.476562 6.566406 L 15.070312 2.292969 C 14.382812 1.910156 13.675781 1.902344 12.957031 2.277344 L 2.671875 8.214844 C 2.007812 8.597656 1.621094 9.238281 1.589844 10.035156 L 1.589844 22.003906 C 1.601562 22.636719 1.90625 23.171875 2.433594 23.46875 C 2.949219 23.761719 3.585938 23.761719 4.101562 23.464844 L 23.378906 12.335938 L 23.378906 20.980469 C 23.378906 21.246094 23.238281 21.492188 23.007812 21.625 L 14.375 26.609375 C 14.144531 26.742188 13.863281 26.742188 13.628906 26.613281 L 11.585938 25.433594 L 20.964844 20.019531 L 20.964844 16.519531 L 5.523438 25.433594 L 12.949219 29.71875 C 13.613281 30.101562 14.429688 30.09375 15.089844 29.699219 L 25.371094 23.761719 C 26.042969 23.347656 26.410156 22.691406 26.410156 21.917969 Z M 26.410156 9.980469',
			'vw' => 28
		),
		'instagram-square' => array(
			'p' => 'M 14 12.667969 C 12.160156 12.667969 10.667969 14.160156 10.667969 16 C 10.667969 17.84375 12.160156 19.332031 14 19.332031 C 15.84375 19.332031 17.335938 17.839844 17.335938 16 C 17.332031 14.160156 15.839844 12.667969 14 12.667969 Z M 21.792969 10.105469 C 21.453125 9.234375 20.761719 8.546875 19.894531 8.203125 C 18.582031 7.683594 15.457031 7.800781 14 7.800781 C 12.542969 7.800781 9.421875 7.679688 8.105469 8.203125 C 7.234375 8.546875 6.546875 9.234375 6.203125 10.105469 C 5.6875 11.417969 5.804688 14.542969 5.804688 16 C 5.804688 17.453125 5.6875 20.578125 6.207031 21.894531 C 6.550781 22.765625 7.238281 23.453125 8.109375 23.796875 C 9.421875 24.3125 12.546875 24.199219 14.003906 24.199219 C 15.460938 24.199219 18.578125 24.320312 19.894531 23.796875 C 20.765625 23.453125 21.453125 22.765625 21.796875 21.894531 C 22.320312 20.582031 22.199219 17.453125 22.199219 16 C 22.199219 14.546875 22.320312 11.421875 21.796875 10.105469 Z M 14 21.125 C 11.167969 21.125 8.875 18.832031 8.875 16 C 8.875 13.167969 11.167969 10.875 14 10.875 C 16.832031 10.875 19.125 13.167969 19.125 16 C 19.125 17.359375 18.585938 18.664062 17.625 19.625 C 16.664062 20.585938 15.359375 21.125 14 21.125 Z M 19.335938 11.855469 C 18.675781 11.855469 18.140625 11.320312 18.140625 10.660156 C 18.140625 10 18.675781 9.464844 19.335938 9.464844 C 19.996094 9.464844 20.53125 10 20.53125 10.660156 C 20.535156 10.976562 20.40625 11.28125 20.183594 11.507812 C 19.960938 11.730469 19.65625 11.859375 19.339844 11.859375 Z M 25 2 L 3 2 C 1.34375 2 0 3.34375 0 5 L 0 27 C 0 28.65625 1.34375 30 3 30 L 25 30 C 26.65625 30 28 28.65625 28 27 L 28 5 C 28 3.34375 26.65625 2 25 2 Z M 23.929688 20.125 C 23.847656 21.726562 23.484375 23.144531 22.3125 24.3125 C 21.144531 25.480469 19.726562 25.851562 18.125 25.929688 C 16.476562 26.019531 11.527344 26.019531 9.875 25.929688 C 8.273438 25.847656 6.859375 25.480469 5.6875 24.3125 C 4.519531 23.144531 4.148438 21.722656 4.074219 20.125 C 3.980469 18.472656 3.980469 13.523438 4.074219 11.875 C 4.15625 10.273438 4.515625 8.855469 5.6875 7.6875 C 6.863281 6.519531 8.28125 6.152344 9.875 6.078125 C 11.527344 5.984375 16.476562 5.984375 18.125 6.078125 C 19.730469 6.15625 21.148438 6.523438 22.3125 7.691406 C 23.480469 8.859375 23.855469 10.28125 23.929688 11.882812 C 24.023438 13.527344 24.023438 18.472656 23.929688 20.125 Z M 23.929688 20.125',
			'vw' => 28
		),
		'instalod' => array(
			'p' => 'M 9.585938 30 L 24.195312 30 L 31.410156 17.234375 L 12.765625 20.824219 Z M 31.546875 15.003906 L 24.195312 2 L 9.730469 2 L 22.515625 16.742188 Z M 7.773438 3.050781 L 0.453125 16 L 7.703125 28.820312 L 14.101562 10.347656 Z M 7.773438 3.050781',
		),
		'itch-io' => array(
			'p' => 'M 4.496094 2.171875 C 3.136719 2.980469 0.460938 6.050781 0.4375 6.859375 L 0.4375 8.191406 C 0.4375 9.882812 2.019531 11.371094 3.453125 11.371094 C 5.175781 11.371094 6.613281 9.941406 6.613281 8.246094 C 6.613281 9.9375 8 11.371094 9.722656 11.371094 C 11.445312 11.371094 12.785156 9.941406 12.785156 8.246094 C 12.785156 9.9375 14.257812 11.371094 15.980469 11.371094 L 16.011719 11.371094 C 17.734375 11.371094 19.210938 9.941406 19.210938 8.246094 C 19.210938 9.9375 20.550781 11.371094 22.273438 11.371094 C 23.992188 11.371094 25.382812 9.941406 25.382812 8.246094 C 25.382812 9.9375 26.820312 11.371094 28.542969 11.371094 C 29.980469 11.371094 31.558594 9.882812 31.558594 8.191406 L 31.558594 6.859375 C 31.53125 6.050781 28.859375 2.980469 27.5 2.171875 C 23.285156 2.023438 20.359375 2 16 2 C 11.640625 2 5.695312 2.070312 4.496094 2.171875 Z M 12.765625 10.574219 C 11.390625 12.972656 7.894531 12.992188 6.523438 10.589844 C 5.703125 12.035156 3.828125 12.59375 3.023438 12.316406 C 2.78125 14.828125 2.171875 27.136719 4.132812 29.140625 C 9.132812 30.304688 23.011719 30.269531 27.867188 29.140625 C 29.84375 27.121094 29.199219 14.640625 28.976562 12.316406 C 28.167969 12.59375 26.296875 12.03125 25.476562 10.589844 C 24.101562 12.996094 20.609375 12.96875 19.234375 10.574219 C 18.792969 11.355469 17.796875 12.382812 16 12.382812 C 14.671875 12.421875 13.425781 11.726562 12.765625 10.574219 Z M 10.167969 13.933594 C 11.195312 13.933594 12.109375 13.933594 13.242188 15.167969 C 15.074219 14.984375 16.921875 14.984375 18.753906 15.167969 C 19.890625 13.9375 20.804688 13.9375 21.832031 13.9375 C 25.101562 13.9375 25.90625 18.78125 27.074219 22.964844 C 28.152344 26.851562 26.730469 26.945312 24.953125 26.949219 C 22.316406 26.851562 20.859375 24.9375 20.859375 23.023438 C 18.40625 23.425781 14.488281 23.574219 11.136719 23.023438 C 11.136719 24.9375 9.679688 26.851562 7.042969 26.949219 C 5.265625 26.945312 3.84375 26.851562 4.921875 22.964844 C 6.089844 18.777344 6.894531 13.9375 10.164062 13.9375 Z M 16 16.925781 C 16 16.925781 13.226562 19.472656 12.726562 20.375 L 14.539062 20.300781 L 14.539062 21.882812 C 14.539062 21.980469 15.875 21.894531 16 21.894531 C 16.726562 21.929688 17.457031 21.957031 17.457031 21.882812 L 17.457031 20.304688 L 19.269531 20.378906 C 18.769531 19.472656 15.996094 16.925781 15.996094 16.925781 Z M 16 16.925781',
		),
		'mdb' => array(
			'p' => 'M 1.085938 10.027344 L 0.4375 22 L 3.183594 22 L 3.53125 17.011719 L 5.277344 22 L 8.070312 22 L 9.667969 17.160156 L 9.96875 22 L 12.8125 22 L 12.011719 10.027344 L 9.167969 10.027344 L 6.625 17.359375 L 3.980469 10.027344 Z M 18.648438 10.027344 L 15.65625 10.027344 L 15.65625 22 L 18.648438 22 C 18.648438 22 24.585938 22.050781 24.535156 16.011719 C 24.488281 10.125 18.648438 10.027344 18.648438 10.027344 Z M 18.574219 19.179688 L 18.574219 12.796875 C 18.574219 12.796875 21.449219 13.066406 21.5 15.960938 C 21.546875 18.851562 18.574219 19.179688 18.574219 19.179688 Z M 33.464844 14.539062 C 33.914062 13.828125 34.09375 12.976562 33.964844 12.144531 C 33.632812 9.910156 30.523438 10 30.523438 10 L 27.28125 10 L 27.28125 21.972656 L 30.125 21.972656 C 30.125 21.972656 35.5625 22.273438 35.5625 17.984375 C 35.5625 15.285156 33.46875 14.539062 33.46875 14.539062 Z M 30.222656 12.542969 C 30.222656 12.542969 31.070312 12.445312 31.222656 13.140625 C 31.3125 13.558594 30.972656 13.890625 30.972656 13.890625 L 30.222656 13.890625 Z M 30.214844 19.382812 L 30.222656 17.828125 L 30.222656 16.6875 L 30.226562 16.6875 C 30.226562 16.6875 32.828125 16.390625 32.800781 18.089844 C 32.78125 19.691406 30.21875 19.386719 30.21875 19.386719 Z M 30.214844 19.382812',
			'vw' => 36
		),
		'microblog' => array(
			'p' => 'M 24.960938 22.640625 C 26.804688 20.472656 27.902344 17.742188 27.902344 14.777344 C 27.902344 7.71875 21.679688 2 14 2 C 6.320312 2 0.0976562 7.71875 0.0976562 14.777344 C 0.0976562 21.835938 6.320312 27.554688 14 27.554688 C 15.691406 27.558594 17.371094 27.273438 18.964844 26.714844 C 19.152344 26.652344 19.355469 26.714844 19.472656 26.875 C 20.632812 28.441406 22.449219 29.546875 24.464844 29.996094 C 24.613281 30.023438 24.761719 29.929688 24.792969 29.78125 C 24.808594 29.699219 24.789062 29.617188 24.738281 29.554688 C 23.148438 27.492188 23.246094 24.589844 24.96875 22.636719 Z M 20.59375 13.273438 L 17.015625 15.992188 L 18.3125 20.296875 C 18.363281 20.460938 18.300781 20.640625 18.164062 20.742188 C 18.023438 20.84375 17.832031 20.847656 17.691406 20.75 L 14 18.183594 L 10.308594 20.75 C 10.167969 20.847656 9.976562 20.847656 9.835938 20.746094 C 9.699219 20.644531 9.636719 20.464844 9.6875 20.296875 L 10.984375 15.996094 L 7.40625 13.277344 C 7.265625 13.171875 7.210938 12.992188 7.265625 12.828125 C 7.316406 12.664062 7.46875 12.550781 7.640625 12.546875 L 12.136719 12.453125 L 13.613281 8.207031 C 13.671875 8.042969 13.824219 7.933594 13.996094 7.933594 C 14.171875 7.933594 14.324219 8.042969 14.382812 8.207031 L 15.859375 12.453125 L 20.351562 12.546875 C 20.527344 12.546875 20.679688 12.660156 20.734375 12.824219 C 20.789062 12.988281 20.734375 13.171875 20.59375 13.277344 Z M 20.59375 13.273438',
			'vw' => 28
		),
		'mixer' => array(
			'p' => 'M 7.160156 4.753906 C 6.679688 4.105469 5.945312 3.695312 5.140625 3.617188 C 4.335938 3.539062 3.535156 3.808594 2.941406 4.355469 C 1.84375 5.363281 1.753906 7.074219 2.644531 8.277344 L 8.378906 15.964844 L 2.609375 23.722656 C 1.71875 24.925781 1.789062 26.636719 2.90625 27.648438 C 3.503906 28.191406 4.300781 28.460938 5.105469 28.382812 C 5.910156 28.304688 6.640625 27.894531 7.125 27.246094 L 15.179688 16.417969 C 15.371094 16.152344 15.371094 15.792969 15.179688 15.53125 Z M 29.390625 23.722656 L 23.621094 15.964844 L 29.355469 8.277344 C 30.246094 7.074219 30.15625 5.367188 29.058594 4.355469 C 28.464844 3.808594 27.664062 3.542969 26.859375 3.617188 C 26.054688 3.695312 25.320312 4.109375 24.839844 4.753906 L 16.839844 15.511719 C 16.648438 15.777344 16.648438 16.136719 16.839844 16.402344 L 24.875 27.246094 C 25.359375 27.894531 26.089844 28.308594 26.894531 28.382812 C 27.699219 28.460938 28.5 28.191406 29.09375 27.648438 C 30.210938 26.636719 30.28125 24.925781 29.390625 23.722656 Z M 29.390625 23.722656',
		),
		'octopus-deploy' => array(
			'p' => 'M 28.476562 21.824219 C 25.605469 19.382812 26.183594 16.957031 27.46875 13.816406 C 29.699219 8.378906 25.996094 2.132812 20.621094 0.519531 C 14.816406 -1.226562 8.390625 1.519531 6.230469 7.320312 C 5.683594 8.789062 5.449219 10.355469 5.542969 11.917969 C 5.652344 13.765625 6.460938 15.230469 7.046875 16.9375 C 8.125 20.070312 5.292969 22.734375 2.882812 24.285156 C -0.0429688 26.171875 0.613281 26.777344 2.355469 26.902344 C 3.816406 27.007812 5.136719 26.617188 6.433594 25.960938 C 7.007812 25.671875 8.976562 24.777344 9.253906 24.175781 C 8.492188 25.835938 6.945312 28.71875 7.914062 30.554688 C 9.109375 32.820312 12.109375 28.570312 12.707031 27.691406 C 13.246094 26.90625 15.394531 22.613281 16.683594 24.761719 C 17.863281 26.71875 17.222656 29.535156 18.917969 31.300781 C 20.972656 33.4375 22.117188 30.15625 22.132812 28.535156 C 22.140625 27.507812 21.75 22.542969 24 24.789062 C 25.339844 26.125 27.308594 29.238281 29.535156 28.976562 C 31.957031 28.695312 28.152344 24.730469 27.769531 24.058594 C 28.105469 24.328125 31.125 26.191406 31.132812 24.652344 C 31.140625 23.480469 29.253906 22.488281 28.476562 21.824219 Z M 28.476562 21.824219',
		),
		'orcid' => array(
			'p' => 'M 18.421875 11.761719 L 15.550781 11.761719 L 15.550781 21.375 L 18.519531 21.375 C 22.746094 21.375 23.714844 18.167969 23.714844 16.566406 C 23.714844 13.964844 22.054688 11.761719 18.421875 11.761719 Z M 16 0.5 C 7.4375 0.5 0.5 7.4375 0.5 16 C 0.5 24.5625 7.4375 31.5 16 31.5 C 24.5625 31.5 31.5 24.5625 31.5 16 C 31.5 7.4375 24.5625 0.5 16 0.5 Z M 10.949219 23.046875 L 9.085938 23.046875 L 9.085938 10.078125 L 10.949219 10.078125 Z M 10.019531 8.601562 C 9.34375 8.601562 8.796875 8.054688 8.796875 7.378906 C 8.796875 6.703125 9.34375 6.15625 10.019531 6.15625 C 10.695312 6.15625 11.242188 6.703125 11.242188 7.378906 C 11.238281 8.050781 10.691406 8.597656 10.019531 8.601562 Z M 18.75 23.0625 L 13.6875 23.0625 L 13.6875 10.078125 L 18.726562 10.078125 C 23.519531 10.078125 25.628906 13.503906 25.628906 16.570312 C 25.625 19.898438 23.023438 23.0625 18.75 23.0625 Z M 18.75 23.0625',
		),
		'perbyte' => array(
			'p' => 'M 19.082031 17.785156 L 15.414062 17.785156 L 15.414062 23.957031 L 19.082031 23.957031 C 20.097656 23.957031 20.894531 23.667969 21.46875 23.09375 C 22.042969 22.523438 22.328125 21.769531 22.328125 20.839844 C 22.328125 19.929688 22.039062 19.191406 21.453125 18.628906 C 20.867188 18.066406 20.078125 17.785156 19.082031 17.785156 Z M 9.339844 8.042969 L 5.671875 8.042969 L 5.671875 14.214844 L 9.339844 14.214844 C 10.355469 14.214844 11.152344 13.925781 11.726562 13.351562 C 12.300781 12.777344 12.585938 12.027344 12.585938 11.097656 C 12.585938 10.1875 12.292969 9.449219 11.710938 8.886719 C 11.125 8.324219 10.335938 8.042969 9.339844 8.042969 Z M 22.914062 2 L 5.085938 2 C 2.277344 2.003906 0.00390625 4.277344 0 7.085938 L 0 24.914062 C 0.00390625 27.722656 2.277344 29.996094 5.085938 30 L 22.914062 30 C 25.722656 29.996094 27.996094 27.722656 28 24.914062 L 28 7.085938 C 27.996094 4.277344 25.722656 2.003906 22.914062 2 Z M 26.894531 24.914062 C 26.890625 27.109375 25.109375 28.890625 22.914062 28.894531 L 5.085938 28.894531 C 2.890625 28.890625 1.109375 27.109375 1.105469 24.914062 L 1.105469 7.085938 C 1.109375 4.890625 2.890625 3.109375 5.085938 3.105469 L 22.914062 3.105469 C 25.109375 3.109375 26.890625 4.890625 26.894531 7.085938 Z M 19.082031 8.042969 L 15.414062 8.042969 L 15.414062 14.214844 L 19.082031 14.214844 C 20.097656 14.214844 20.894531 13.925781 21.46875 13.351562 C 22.042969 12.777344 22.328125 12.027344 22.328125 11.097656 C 22.328125 10.1875 22.039062 9.449219 21.453125 8.886719 C 20.867188 8.324219 20.078125 8.042969 19.082031 8.042969 Z M 19.082031 8.042969',
			'vw' => 28
		),
		'pied-piper-square' => array(
			'p' => 'M 2 26.1875 L 0 29.949219 L 0.0507812 9.449219 C 0.0507812 5.332031 3.375 2 7.5 2 L 27.949219 2 C 22.136719 3.804688 16.082031 7.886719 12.082031 12.539062 C 7.667969 17.625 5.164062 21.125 2 26.1875 M 28 2 C 28 2 19.074219 6.175781 16.351562 12.445312 C 14.898438 15.792969 14.542969 19.824219 11.914062 22.355469 C 10.105469 24.09375 7.550781 24.742188 5.332031 25.875 C 3.882812 26.625 1.179688 28.40625 0.0234375 30 L 20.550781 30 C 24.675781 30 28.007812 26.667969 28.007812 22.550781 C 28 22.550781 28 2 28 2 Z M 28 2',
			'vw' => 28
		),
		'rust' => array(
			'p' => 'M 31.78125 15.609375 L 30.417969 14.765625 C 30.40625 14.640625 30.398438 14.519531 30.382812 14.398438 L 31.554688 13.304688 C 31.671875 13.195312 31.722656 13.035156 31.691406 12.878906 C 31.660156 12.722656 31.550781 12.59375 31.402344 12.539062 L 29.902344 11.976562 C 29.867188 11.859375 29.835938 11.738281 29.796875 11.625 L 30.734375 10.320312 C 30.828125 10.191406 30.847656 10.023438 30.785156 9.878906 C 30.726562 9.730469 30.59375 9.625 30.4375 9.601562 L 28.847656 9.339844 C 28.789062 9.234375 28.734375 9.125 28.675781 9.019531 L 29.34375 7.554688 C 29.410156 7.410156 29.394531 7.242188 29.308594 7.109375 C 29.21875 6.976562 29.070312 6.898438 28.910156 6.90625 L 27.296875 6.960938 C 27.222656 6.871094 27.144531 6.777344 27.070312 6.6875 L 27.4375 5.113281 C 27.472656 4.960938 27.425781 4.796875 27.316406 4.683594 C 27.203125 4.574219 27.039062 4.527344 26.886719 4.5625 L 25.3125 4.933594 C 25.222656 4.855469 25.128906 4.78125 25.039062 4.707031 L 25.09375 3.09375 C 25.101562 2.933594 25.023438 2.78125 24.890625 2.691406 C 24.757812 2.605469 24.589844 2.589844 24.445312 2.65625 L 22.980469 3.328125 C 22.875 3.269531 22.765625 3.210938 22.660156 3.15625 L 22.398438 1.566406 C 22.375 1.410156 22.269531 1.277344 22.121094 1.21875 C 21.976562 1.15625 21.808594 1.175781 21.679688 1.269531 L 20.375 2.203125 C 20.257812 2.167969 20.140625 2.132812 20.023438 2.097656 L 19.460938 0.597656 C 19.402344 0.449219 19.277344 0.339844 19.121094 0.308594 C 18.964844 0.277344 18.804688 0.332031 18.695312 0.445312 L 17.601562 1.617188 C 17.480469 1.605469 17.355469 1.59375 17.234375 1.582031 L 16.390625 0.21875 C 16.308594 0.0820312 16.160156 0 16 0 C 15.839844 0 15.691406 0.0820312 15.609375 0.21875 L 14.765625 1.582031 C 14.640625 1.59375 14.519531 1.601562 14.398438 1.617188 L 13.304688 0.445312 C 13.195312 0.328125 13.035156 0.277344 12.878906 0.308594 C 12.722656 0.339844 12.59375 0.449219 12.539062 0.597656 L 11.976562 2.097656 C 11.859375 2.132812 11.738281 2.164062 11.621094 2.203125 L 10.320312 1.265625 C 10.191406 1.171875 10.023438 1.152344 9.875 1.214844 C 9.730469 1.277344 9.625 1.40625 9.597656 1.566406 L 9.339844 3.152344 C 9.230469 3.210938 9.125 3.265625 9.015625 3.324219 L 7.554688 2.660156 C 7.410156 2.59375 7.242188 2.605469 7.109375 2.695312 C 6.976562 2.785156 6.898438 2.9375 6.90625 3.097656 L 6.964844 4.710938 C 6.871094 4.785156 6.777344 4.859375 6.6875 4.9375 L 5.113281 4.5625 C 4.960938 4.527344 4.796875 4.574219 4.683594 4.683594 C 4.574219 4.796875 4.527344 4.960938 4.5625 5.113281 L 4.933594 6.6875 C 4.855469 6.777344 4.78125 6.871094 4.707031 6.964844 L 3.09375 6.90625 C 2.933594 6.902344 2.785156 6.976562 2.695312 7.109375 C 2.605469 7.242188 2.59375 7.410156 2.660156 7.554688 L 3.328125 9.019531 C 3.265625 9.125 3.210938 9.234375 3.15625 9.339844 L 1.566406 9.601562 C 1.410156 9.625 1.277344 9.730469 1.21875 9.878906 C 1.15625 10.023438 1.175781 10.191406 1.269531 10.320312 L 2.207031 11.621094 C 2.167969 11.738281 2.136719 11.859375 2.101562 11.976562 L 0.601562 12.539062 C 0.453125 12.59375 0.34375 12.722656 0.3125 12.878906 C 0.28125 13.035156 0.332031 13.195312 0.449219 13.304688 L 1.617188 14.398438 C 1.605469 14.519531 1.59375 14.640625 1.582031 14.765625 L 0.21875 15.609375 C 0.0820312 15.691406 0 15.839844 0 16 C 0 16.160156 0.0820312 16.308594 0.21875 16.390625 L 1.582031 17.234375 C 1.59375 17.359375 1.601562 17.480469 1.617188 17.601562 L 0.445312 18.695312 C 0.328125 18.804688 0.277344 18.964844 0.308594 19.121094 C 0.339844 19.277344 0.449219 19.40625 0.597656 19.460938 L 2.097656 20.023438 C 2.132812 20.140625 2.164062 20.261719 2.203125 20.375 L 1.265625 21.679688 C 1.171875 21.808594 1.152344 21.976562 1.214844 22.121094 C 1.277344 22.269531 1.40625 22.375 1.566406 22.398438 L 3.152344 22.660156 C 3.210938 22.765625 3.265625 22.875 3.324219 22.980469 L 2.660156 24.445312 C 2.59375 24.589844 2.605469 24.757812 2.695312 24.890625 C 2.78125 25.023438 2.933594 25.101562 3.09375 25.09375 L 4.707031 25.039062 C 4.78125 25.128906 4.855469 25.222656 4.933594 25.3125 L 4.5625 26.886719 C 4.527344 27.039062 4.574219 27.203125 4.683594 27.316406 C 4.796875 27.425781 4.960938 27.472656 5.113281 27.4375 L 6.6875 27.066406 C 6.777344 27.144531 6.871094 27.21875 6.964844 27.292969 L 6.90625 28.90625 C 6.898438 29.066406 6.976562 29.214844 7.109375 29.304688 C 7.242188 29.394531 7.410156 29.40625 7.554688 29.339844 L 9.019531 28.671875 C 9.125 28.730469 9.234375 28.789062 9.339844 28.84375 L 9.601562 30.433594 C 9.625 30.589844 9.730469 30.722656 9.878906 30.78125 C 10.023438 30.84375 10.191406 30.824219 10.320312 30.730469 L 11.625 29.792969 C 11.738281 29.832031 11.859375 29.863281 11.976562 29.898438 L 12.539062 31.398438 C 12.59375 31.546875 12.722656 31.65625 12.878906 31.6875 C 13.035156 31.71875 13.195312 31.667969 13.304688 31.550781 L 14.398438 30.382812 C 14.519531 30.394531 14.644531 30.40625 14.765625 30.414062 L 15.609375 31.78125 C 15.695312 31.914062 15.839844 31.996094 16 31.996094 C 16.160156 31.996094 16.308594 31.914062 16.390625 31.78125 L 17.234375 30.414062 C 17.359375 30.40625 17.480469 30.394531 17.601562 30.378906 L 18.695312 31.550781 C 18.804688 31.667969 18.964844 31.71875 19.121094 31.6875 C 19.277344 31.65625 19.40625 31.546875 19.460938 31.398438 L 20.023438 29.898438 C 20.144531 29.863281 20.261719 29.832031 20.378906 29.792969 L 21.679688 30.730469 C 21.808594 30.824219 21.976562 30.84375 22.125 30.78125 C 22.269531 30.722656 22.375 30.589844 22.402344 30.433594 L 22.660156 28.84375 C 22.765625 28.789062 22.875 28.730469 22.980469 28.671875 L 24.445312 29.339844 C 24.589844 29.40625 24.757812 29.394531 24.890625 29.304688 C 25.023438 29.214844 25.101562 29.066406 25.09375 28.90625 L 25.039062 27.292969 C 25.128906 27.21875 25.222656 27.144531 25.3125 27.066406 L 26.886719 27.4375 C 27.039062 27.472656 27.203125 27.425781 27.316406 27.316406 C 27.425781 27.203125 27.472656 27.039062 27.4375 26.886719 L 27.066406 25.3125 C 27.144531 25.222656 27.21875 25.128906 27.292969 25.039062 L 28.90625 25.09375 C 29.066406 25.101562 29.21875 25.023438 29.304688 24.890625 C 29.394531 24.757812 29.40625 24.589844 29.339844 24.445312 L 28.671875 22.980469 C 28.730469 22.875 28.789062 22.765625 28.84375 22.660156 L 30.433594 22.398438 C 30.589844 22.375 30.722656 22.269531 30.78125 22.121094 C 30.84375 21.976562 30.824219 21.808594 30.730469 21.679688 L 29.792969 20.375 C 29.832031 20.261719 29.863281 20.140625 29.898438 20.023438 L 31.398438 19.460938 C 31.546875 19.40625 31.65625 19.277344 31.6875 19.121094 C 31.71875 18.964844 31.667969 18.804688 31.550781 18.695312 L 30.382812 17.601562 C 30.394531 17.480469 30.40625 17.359375 30.414062 17.234375 L 31.78125 16.390625 C 31.914062 16.308594 31.996094 16.160156 31.996094 16 C 31.996094 15.839844 31.914062 15.691406 31.78125 15.609375 Z M 22.34375 23.675781 C 21.875 23.574219 21.414062 23.875 21.3125 24.34375 L 20.835938 26.574219 C 17.726562 27.980469 14.15625 27.964844 11.0625 26.527344 L 10.585938 24.296875 C 10.484375 23.832031 10.023438 23.53125 9.554688 23.632812 L 7.585938 24.054688 C 7.222656 23.675781 6.882812 23.277344 6.570312 22.851562 L 16.144531 22.851562 C 16.25 22.851562 16.324219 22.835938 16.324219 22.734375 L 16.324219 19.347656 C 16.324219 19.25 16.25 19.226562 16.144531 19.226562 L 13.34375 19.226562 L 13.34375 17.082031 L 16.375 17.082031 C 16.652344 17.082031 17.855469 17.160156 18.238281 18.699219 C 18.355469 19.167969 18.621094 20.707031 18.804688 21.199219 C 18.984375 21.75 19.714844 22.851562 20.496094 22.851562 L 25.4375 22.851562 C 25.105469 23.292969 24.746094 23.714844 24.355469 24.105469 Z M 23.957031 25.832031 C 23.957031 26.359375 23.53125 26.785156 23.003906 26.785156 C 22.480469 26.785156 22.050781 26.359375 22.050781 25.835938 C 22.050781 25.308594 22.472656 24.882812 23 24.878906 L 23.027344 24.878906 C 23.542969 24.894531 23.953125 25.316406 23.953125 25.832031 Z M 9.855469 25.789062 C 9.855469 26.316406 9.425781 26.742188 8.902344 26.742188 C 8.375 26.742188 7.949219 26.316406 7.949219 25.789062 C 7.949219 25.265625 8.375 24.835938 8.902344 24.835938 L 8.929688 24.835938 C 9.445312 24.855469 9.851562 25.277344 9.851562 25.789062 Z M 4.347656 14.632812 L 6.398438 13.722656 C 6.609375 13.628906 6.773438 13.457031 6.859375 13.242188 C 6.941406 13.027344 6.933594 12.785156 6.839844 12.578125 L 6.417969 11.625 L 8.078125 11.625 L 8.078125 19.109375 L 4.726562 19.109375 C 4.316406 17.65625 4.183594 16.136719 4.347656 14.632812 Z M 3.644531 12.378906 C 3.644531 11.855469 4.070312 11.429688 4.597656 11.425781 L 4.625 11.425781 C 5.148438 11.441406 5.558594 11.875 5.550781 12.398438 C 5.539062 12.917969 5.113281 13.335938 4.589844 13.332031 C 4.066406 13.328125 3.644531 12.902344 3.644531 12.378906 Z M 13.34375 13.910156 L 13.34375 11.703125 L 17.296875 11.703125 C 17.503906 11.703125 18.742188 11.9375 18.742188 12.867188 C 18.742188 13.636719 17.792969 13.910156 17.011719 13.910156 Z M 24.9375 19.167969 C 24.324219 19.238281 23.648438 18.910156 23.5625 18.539062 C 23.203125 16.507812 22.601562 16.078125 21.652344 15.328125 C 22.832031 14.578125 24.054688 13.472656 24.054688 11.996094 C 24.054688 10.402344 22.960938 9.398438 22.21875 8.90625 C 21.171875 8.21875 20.011719 8.078125 19.703125 8.078125 L 7.269531 8.078125 C 8.988281 6.15625 11.292969 4.855469 13.824219 4.378906 L 15.292969 5.917969 C 15.449219 6.082031 15.667969 6.179688 15.898438 6.183594 C 16.128906 6.191406 16.351562 6.101562 16.515625 5.945312 L 18.160156 4.382812 C 21.542969 5.015625 24.476562 7.105469 26.183594 10.09375 L 25.058594 12.632812 C 24.867188 13.070312 25.0625 13.582031 25.5 13.777344 L 27.660156 14.734375 C 27.730469 15.410156 27.738281 16.089844 27.6875 16.769531 L 26.480469 16.769531 C 26.363281 16.769531 26.3125 16.847656 26.3125 16.964844 L 26.3125 17.515625 C 26.3125 18.8125 25.582031 19.097656 24.9375 19.167969 Z M 15 3.761719 C 15 3.238281 15.425781 2.8125 15.949219 2.8125 L 15.980469 2.8125 C 16.5 2.828125 16.914062 3.261719 16.90625 3.78125 C 16.894531 4.304688 16.464844 4.722656 15.941406 4.71875 C 15.421875 4.710938 15 4.285156 15 3.761719 Z M 27.300781 13.375 C 26.777344 13.375 26.351562 12.949219 26.351562 12.421875 C 26.351562 11.894531 26.777344 11.46875 27.300781 11.46875 L 27.328125 11.46875 C 27.855469 11.476562 28.277344 11.910156 28.269531 12.4375 C 28.261719 12.960938 27.828125 13.382812 27.300781 13.375 Z M 27.300781 13.375',
		),
		'salesforce' => array(
			'p' => 'M 15.554688 15.351562 L 13.910156 15.351562 C 13.953125 15.03125 14.117188 14.46875 14.761719 14.46875 C 15.183594 14.46875 15.507812 14.707031 15.554688 15.351562 Z M 24.097656 14.484375 C 24.066406 14.484375 23.214844 14.375 23.214844 15.734375 C 23.214844 17.09375 24.066406 16.984375 24.097656 16.984375 C 24.910156 16.984375 24.980469 16.140625 24.980469 15.734375 C 24.980469 14.375 24.125 14.484375 24.097656 14.484375 Z M 8.894531 15.96875 C 8.757812 16.078125 8.679688 16.25 8.691406 16.425781 C 8.691406 16.722656 8.820312 16.804688 8.894531 16.867188 C 9.1875 17.097656 9.835938 17 10.203125 16.925781 L 10.203125 15.867188 C 9.871094 15.800781 9.15625 15.746094 8.894531 15.96875 Z M 40 14.5 C 40 19.972656 35 24.148438 29.664062 23.027344 C 28.515625 25.089844 25.246094 27.449219 21.402344 25.628906 C 18.828125 31.632812 10.285156 31.390625 8.039062 25.304688 C 0.558594 26.796875 -3.136719 16.65625 3.335938 12.851562 C 1.164062 7.886719 4.75 2 10.480469 2 C 12.894531 2 15.171875 3.125 16.640625 5.042969 C 17.933594 3.707031 19.726562 2.867188 21.710938 2.867188 C 24.359375 2.867188 26.648438 4.339844 27.886719 6.527344 C 33.6875 3.984375 40 8.292969 40 14.5 Z M 7.527344 16.488281 C 7.527344 15.753906 6.796875 15.539062 6.410156 15.414062 C 6.082031 15.28125 5.574219 15.195312 5.574219 14.855469 C 5.574219 14.265625 6.636719 14.4375 7.144531 14.722656 C 7.144531 14.722656 7.21875 14.765625 7.25 14.695312 C 7.265625 14.648438 7.394531 14.28125 7.410156 14.238281 C 7.421875 14.203125 7.402344 14.164062 7.367188 14.148438 C 6.597656 13.671875 4.824219 13.617188 4.824219 14.945312 C 4.824219 15.722656 5.542969 15.910156 5.941406 16.015625 C 6.234375 16.117188 6.765625 16.203125 6.765625 16.5625 C 6.765625 16.8125 6.542969 17 6.191406 17 C 5.761719 17 5.347656 16.863281 5.003906 16.605469 C 4.972656 16.589844 4.914062 16.5625 4.898438 16.648438 L 4.75 17.117188 C 4.71875 17.175781 4.765625 17.191406 4.765625 17.203125 C 4.875 17.292969 5.40625 17.617188 6.191406 17.617188 C 7.015625 17.617188 7.527344 17.175781 7.527344 16.484375 Z M 9.527344 13.828125 C 8.894531 13.828125 8.363281 14.023438 8.191406 14.148438 C 8.175781 14.160156 8.167969 14.175781 8.164062 14.191406 C 8.160156 14.207031 8.164062 14.222656 8.175781 14.238281 L 8.335938 14.679688 C 8.347656 14.710938 8.378906 14.730469 8.410156 14.722656 C 8.453125 14.722656 8.835938 14.472656 9.46875 14.472656 C 9.71875 14.472656 9.910156 14.515625 10.042969 14.621094 C 10.269531 14.796875 10.234375 15.140625 10.234375 15.28125 C 9.933594 15.261719 9.039062 15.066406 8.394531 15.515625 C 8.097656 15.722656 7.925781 16.0625 7.9375 16.425781 C 7.9375 16.792969 8.03125 17.074219 8.347656 17.324219 C 9.113281 17.832031 10.617188 17.449219 10.730469 17.410156 C 10.828125 17.390625 10.953125 17.371094 10.953125 17.292969 L 10.953125 15.175781 C 10.953125 14.886719 10.972656 13.824219 9.527344 13.824219 Z M 12.4375 12.515625 C 12.4375 12.496094 12.429688 12.476562 12.417969 12.460938 C 12.402344 12.449219 12.382812 12.441406 12.363281 12.441406 L 11.75 12.441406 C 11.730469 12.441406 11.710938 12.449219 11.695312 12.460938 C 11.683594 12.476562 11.675781 12.496094 11.675781 12.515625 L 11.675781 17.453125 C 11.675781 17.472656 11.683594 17.492188 11.695312 17.503906 C 11.710938 17.519531 11.730469 17.527344 11.75 17.527344 L 12.367188 17.527344 C 12.386719 17.527344 12.40625 17.519531 12.421875 17.507812 C 12.433594 17.492188 12.441406 17.472656 12.441406 17.453125 Z M 15.921875 14.324219 C 15.789062 14.179688 15.496094 13.851562 14.820312 13.851562 C 14.597656 13.851562 13.933594 13.867188 13.523438 14.410156 C 13.128906 14.886719 13.113281 15.542969 13.113281 15.75 C 13.113281 15.945312 13.125 16.640625 13.554688 17.074219 C 13.71875 17.253906 14.121094 17.585938 14.980469 17.585938 C 15.65625 17.585938 16.011719 17.441406 16.140625 17.351562 C 16.171875 17.335938 16.1875 17.308594 16.15625 17.234375 L 16.011719 16.808594 C 15.996094 16.773438 15.957031 16.757812 15.921875 16.765625 C 15.761719 16.824219 15.523438 16.941406 14.964844 16.941406 C 13.878906 16.941406 13.914062 16.019531 13.90625 15.894531 L 16.230469 15.894531 C 16.265625 15.894531 16.296875 15.871094 16.304688 15.835938 C 16.285156 15.835938 16.433594 14.917969 15.921875 14.324219 Z M 18.214844 17.617188 C 19.039062 17.617188 19.554688 17.175781 19.554688 16.484375 C 19.554688 15.75 18.820312 15.535156 18.4375 15.410156 C 18.175781 15.308594 17.597656 15.199219 17.597656 14.851562 C 17.597656 14.617188 17.804688 14.457031 18.125 14.457031 C 18.492188 14.464844 18.847656 14.554688 19.171875 14.71875 C 19.171875 14.71875 19.246094 14.765625 19.273438 14.691406 C 19.289062 14.648438 19.421875 14.28125 19.433594 14.234375 C 19.445312 14.199219 19.425781 14.160156 19.390625 14.148438 C 18.898438 13.839844 18.34375 13.839844 18.125 13.839844 C 17.375 13.839844 16.847656 14.292969 16.847656 14.941406 C 16.847656 15.71875 17.566406 15.90625 17.964844 16.015625 C 18.347656 16.140625 18.789062 16.21875 18.789062 16.558594 C 18.789062 16.808594 18.566406 17 18.214844 17 C 17.785156 16.996094 17.371094 16.859375 17.027344 16.601562 C 17.007812 16.585938 16.984375 16.582031 16.960938 16.59375 C 16.941406 16.601562 16.925781 16.621094 16.925781 16.644531 L 16.777344 17.117188 C 16.75 17.175781 16.792969 17.191406 16.792969 17.203125 C 16.898438 17.292969 17.4375 17.617188 18.214844 17.617188 Z M 22.316406 14 C 22.316406 13.957031 22.304688 13.925781 22.246094 13.925781 L 21.507812 13.925781 C 21.507812 13.917969 21.566406 13.367188 21.789062 13.148438 C 22.046875 12.886719 22.523438 13.042969 22.539062 13.042969 C 22.613281 13.074219 22.625 13.042969 22.640625 13.015625 L 22.816406 12.53125 C 22.863281 12.46875 22.816406 12.457031 22.804688 12.441406 C 22.484375 12.316406 21.71875 12.261719 21.273438 12.707031 C 20.933594 13.046875 20.835938 13.578125 20.773438 13.925781 L 20.246094 13.925781 C 20.207031 13.929688 20.175781 13.960938 20.171875 14 L 20.082031 14.484375 C 20.082031 14.527344 20.097656 14.558594 20.15625 14.558594 L 20.671875 14.558594 C 20.140625 17.550781 20.125 17.695312 20.023438 18.027344 C 19.957031 18.253906 19.820312 18.460938 19.65625 18.511719 C 19.652344 18.511719 19.414062 18.617188 19.054688 18.5 C 19.054688 18.5 18.996094 18.46875 18.964844 18.542969 C 18.953125 18.585938 18.804688 18.96875 18.789062 19.011719 C 18.773438 19.058594 18.789062 19.101562 18.820312 19.101562 C 19.136719 19.226562 19.632812 19.210938 19.9375 19.101562 C 20.328125 18.957031 20.542969 18.609375 20.65625 18.292969 C 20.828125 17.8125 20.832031 17.679688 21.390625 14.558594 L 22.15625 14.558594 C 22.195312 14.554688 22.226562 14.523438 22.230469 14.484375 Z M 25.65625 15 C 25.621094 14.894531 25.335938 13.867188 24.082031 13.867188 C 23.128906 13.867188 22.644531 14.492188 22.507812 15 C 22.445312 15.1875 22.3125 15.875 22.507812 16.46875 C 22.515625 16.488281 22.785156 17.601562 24.082031 17.601562 C 25.015625 17.601562 25.511719 17 25.65625 16.46875 C 25.855469 15.871094 25.71875 15.1875 25.65625 15 Z M 28.492188 13.957031 C 28.179688 13.851562 27.453125 13.835938 27.109375 14.292969 L 27.109375 14.015625 C 27.113281 13.996094 27.105469 13.976562 27.089844 13.960938 C 27.074219 13.949219 27.058594 13.941406 27.035156 13.941406 L 26.449219 13.941406 C 26.429688 13.941406 26.410156 13.949219 26.394531 13.960938 C 26.382812 13.976562 26.375 13.996094 26.375 14.015625 L 26.375 17.46875 C 26.375 17.488281 26.382812 17.507812 26.394531 17.523438 C 26.410156 17.539062 26.429688 17.542969 26.449219 17.542969 L 27.050781 17.542969 C 27.070312 17.542969 27.089844 17.539062 27.105469 17.523438 C 27.121094 17.507812 27.125 17.488281 27.125 17.46875 L 27.125 15.734375 C 27.125 15.550781 27.128906 15.023438 27.40625 14.792969 C 27.710938 14.488281 28.15625 14.582031 28.242188 14.601562 C 28.28125 14.601562 28.316406 14.578125 28.332031 14.542969 C 28.402344 14.382812 28.46875 14.214844 28.523438 14.042969 C 28.535156 14.011719 28.523438 13.972656 28.492188 13.957031 Z M 31.417969 17.335938 L 31.285156 16.882812 C 31.257812 16.808594 31.199219 16.835938 31.199219 16.835938 C 30.933594 16.953125 30.5625 16.957031 30.492188 16.957031 C 30.203125 16.957031 29.417969 16.886719 29.417969 15.71875 C 29.417969 15.332031 29.535156 14.484375 30.449219 14.484375 C 30.691406 14.480469 30.9375 14.515625 31.167969 14.589844 C 31.167969 14.589844 31.226562 14.617188 31.242188 14.542969 C 31.300781 14.382812 31.34375 14.265625 31.402344 14.074219 C 31.417969 14.015625 31.375 14 31.359375 14 C 30.636719 13.757812 29.964844 13.84375 29.625 14 C 29.523438 14.046875 28.609375 14.40625 28.609375 15.71875 C 28.609375 15.902344 28.574219 17.601562 30.417969 17.601562 C 30.75 17.601562 31.078125 17.542969 31.390625 17.425781 C 31.417969 17.40625 31.429688 17.371094 31.417969 17.335938 Z M 34.785156 14.867188 C 34.734375 14.679688 34.449219 13.851562 33.386719 13.851562 C 32.386719 13.851562 31.917969 14.484375 31.785156 15.015625 C 31.714844 15.253906 31.679688 15.5 31.683594 15.75 C 31.683594 17.367188 32.859375 17.585938 33.550781 17.585938 C 34.226562 17.585938 34.578125 17.441406 34.710938 17.351562 C 34.742188 17.335938 34.753906 17.308594 34.726562 17.234375 L 34.578125 16.808594 C 34.5625 16.773438 34.527344 16.757812 34.492188 16.765625 C 34.328125 16.824219 34.09375 16.941406 33.535156 16.941406 C 32.445312 16.941406 32.480469 16.019531 32.476562 15.898438 L 34.800781 15.898438 C 34.835938 15.894531 34.863281 15.871094 34.875 15.839844 C 34.859375 15.835938 34.933594 15.394531 34.785156 14.867188 Z M 33.328125 14.46875 C 32.683594 14.46875 32.515625 15.03125 32.476562 15.351562 L 34.125 15.351562 C 34.070312 14.609375 33.648438 14.46875 33.328125 14.46875 Z M 33.328125 14.46875',
			'vw' => 40
		),
		'shopify' => array(
			'p' => 'M 24.269531 6.507812 C 24.25 6.367188 24.136719 6.261719 23.996094 6.257812 C 23.871094 6.257812 21.667969 6.207031 21.667969 6.207031 C 21.667969 6.207031 20.316406 4.90625 19.816406 4.40625 L 19.816406 31.449219 L 27.671875 29.5 C 27.671875 29.5 24.296875 6.65625 24.269531 6.507812 Z M 18.039062 4.40625 C 17.921875 4.027344 17.769531 3.65625 17.589844 3.304688 C 16.9375 2.054688 15.964844 1.375 14.8125 1.375 C 14.726562 1.371094 14.644531 1.378906 14.5625 1.398438 C 14.539062 1.351562 14.488281 1.324219 14.460938 1.273438 C 13.960938 0.726562 13.3125 0.476562 12.535156 0.5 C 11.035156 0.550781 9.535156 1.625 8.332031 3.550781 C 7.484375 4.902344 6.832031 6.605469 6.65625 7.929688 C 4.929688 8.457031 3.730469 8.832031 3.703125 8.855469 C 2.828125 9.132812 2.804688 9.15625 2.703125 9.980469 C 2.628906 10.605469 0.328125 28.21875 0.328125 28.21875 L 19.242188 31.5 L 19.242188 4.105469 C 19.148438 4.109375 19.058594 4.117188 18.964844 4.128906 C 18.964844 4.128906 18.617188 4.230469 18.039062 4.40625 Z M 14.589844 5.480469 C 13.589844 5.78125 12.484375 6.128906 11.410156 6.457031 C 11.710938 5.28125 12.3125 4.105469 13.011719 3.332031 C 13.285156 3.054688 13.664062 2.730469 14.085938 2.53125 C 14.511719 3.429688 14.613281 4.65625 14.589844 5.480469 Z M 12.535156 1.527344 C 12.851562 1.515625 13.164062 1.59375 13.4375 1.75 C 13.039062 1.949219 12.636719 2.277344 12.261719 2.652344 C 11.3125 3.675781 10.585938 5.277344 10.285156 6.804688 C 9.382812 7.078125 8.484375 7.355469 7.660156 7.605469 C 8.207031 5.203125 10.234375 1.578125 12.535156 1.527344 Z M 9.632812 15.289062 C 9.734375 16.890625 13.960938 17.238281 14.210938 21.015625 C 14.386719 23.996094 12.636719 26.019531 10.109375 26.171875 C 7.058594 26.371094 5.382812 24.570312 5.382812 24.570312 L 6.03125 21.820312 C 6.03125 21.820312 7.707031 23.097656 9.058594 22.996094 C 9.933594 22.945312 10.261719 22.21875 10.234375 21.71875 C 10.109375 19.617188 6.65625 19.742188 6.433594 16.292969 C 6.230469 13.390625 8.132812 10.460938 12.335938 10.1875 C 13.960938 10.085938 14.789062 10.488281 14.789062 10.488281 L 13.835938 14.085938 C 13.835938 14.085938 12.761719 13.585938 11.484375 13.6875 C 9.632812 13.8125 9.609375 14.988281 9.632812 15.289062 Z M 15.589844 5.179688 C 15.589844 4.429688 15.488281 3.355469 15.136719 2.453125 C 16.289062 2.679688 16.839844 3.953125 17.089844 4.730469 C 16.640625 4.855469 16.140625 5.003906 15.589844 5.179688 Z M 15.589844 5.179688',
			'vw' => 28
		),
		'speaker-deck' => array(
			'p' => 'M 13.367188 18.5 L 6.25 18.5 C 2.796875 18.5 0 15.703125 0 12.25 C 0 8.796875 2.796875 6 6.25 6 L 14.550781 6 C 15.933594 6 17.050781 7.121094 17.050781 8.5 C 17.050781 9.878906 15.933594 11 14.550781 11 L 6.125 11 C 4.46875 11 4.472656 13.5 6.125 13.5 L 13.238281 13.5 C 16.691406 13.5 19.488281 16.296875 19.488281 19.75 C 19.488281 23.203125 16.691406 26 13.238281 26 L 2.5 26 C 1.121094 26 0 24.878906 0 23.5 C 0 22.121094 1.121094 21 2.5 21 L 13.367188 21 C 15.019531 21 15.019531 18.5 13.367188 18.5 Z M 18.625 26 C 20.332031 24.84375 21.484375 23.035156 21.820312 21 L 25.855469 21 C 26.539062 20.996094 27.089844 20.433594 27.082031 19.75 L 27.082031 12.25 C 27.089844 11.566406 26.539062 11.003906 25.855469 11 L 18.527344 11 C 19.777344 9.566406 19.777344 7.433594 18.527344 6 L 27.085938 6 C 29.800781 6 32 8.238281 32 11 L 32 21 C 32 23.761719 29.800781 26 27.085938 26 Z M 18.625 26',
		),
		'stackpath' => array(
			'p' => 'M 15.289062 14.523438 C 15.289062 15.054688 15.019531 15.804688 13.953125 15.804688 L 12.726562 15.804688 L 12.726562 13.214844 L 13.953125 13.214844 C 15.023438 13.214844 15.289062 13.984375 15.289062 14.523438 Z M 28 2 L 28 30 L 0 30 L 0 2 Z M 9.457031 17.988281 C 9.457031 16.664062 8.699219 15.832031 6.535156 15.1875 C 5.25 14.722656 4.910156 14.503906 4.910156 14.023438 C 4.910156 13.539062 5.347656 13.109375 6.1875 13.109375 C 7.066406 13.109375 7.484375 13.636719 7.484375 14.257812 L 9.40625 14.257812 L 9.417969 14.21875 C 9.449219 12.996094 8.476562 11.617188 6.222656 11.617188 C 4.761719 11.617188 2.9375 12.289062 2.9375 14.011719 C 2.9375 15.222656 3.515625 15.964844 6.109375 16.785156 C 7.1875 17.167969 7.476562 17.433594 7.476562 18 C 7.476562 18.953125 6.28125 18.890625 6.261719 18.890625 C 4.984375 18.890625 4.65625 18.320312 4.65625 17.523438 L 2.734375 17.523438 L 2.722656 17.558594 C 2.679688 19.515625 4.496094 20.382812 6.261719 20.382812 C 8.136719 20.382812 9.457031 19.535156 9.457031 17.988281 Z M 17.292969 14.511719 C 17.292969 12.933594 16.140625 11.671875 13.953125 11.671875 L 10.71875 11.671875 L 10.71875 20.308594 L 12.726562 20.308594 L 12.726562 17.347656 L 13.953125 17.347656 C 15.84375 17.347656 17.292969 16.351562 17.292969 14.511719 Z M 18.621094 20.3125 L 21.6875 11.671875 L 19.746094 11.671875 L 16.75 20.3125 Z M 25.277344 11.671875 L 23.335938 11.671875 L 20.339844 20.3125 L 22.210938 20.3125 Z M 25.277344 11.671875',
			'vw' => 28
		),
		'swift' => array(
			'p' => 'M 28 9.753906 C 28 9.472656 27.996094 9.191406 27.988281 8.910156 C 27.980469 8.292969 27.925781 7.679688 27.828125 7.070312 C 27.722656 6.464844 27.527344 5.875 27.25 5.320312 C 26.6875 4.214844 25.785156 3.3125 24.675781 2.75 C 24.125 2.472656 23.535156 2.277344 22.925781 2.171875 C 22.320312 2.074219 21.703125 2.019531 21.089844 2.011719 C 20.804688 2.003906 20.527344 2 20.242188 2 L 7.757812 2 C 7.476562 2 7.195312 2.003906 6.914062 2.011719 C 6.761719 2.015625 6.605469 2.019531 6.453125 2.027344 C 5.992188 2.046875 5.53125 2.097656 5.074219 2.171875 C 4.621094 2.253906 4.175781 2.378906 3.75 2.554688 C 3.605469 2.617188 3.460938 2.679688 3.324219 2.75 C 2.910156 2.960938 2.527344 3.21875 2.171875 3.519531 C 2.054688 3.621094 1.941406 3.726562 1.835938 3.832031 C 1.398438 4.269531 1.03125 4.773438 0.75 5.324219 C 0.472656 5.875 0.277344 6.464844 0.171875 7.074219 C 0.0742188 7.679688 0.0234375 8.296875 0.015625 8.910156 C 0.0078125 9.191406 0.00390625 9.472656 0 9.753906 L 0 22.246094 C 0 22.527344 0.0078125 22.808594 0.015625 23.089844 C 0.0234375 23.707031 0.078125 24.320312 0.175781 24.929688 C 0.28125 25.535156 0.472656 26.125 0.753906 26.679688 C 1.316406 27.785156 2.214844 28.683594 3.324219 29.25 C 3.875 29.527344 4.464844 29.722656 5.074219 29.824219 C 5.679688 29.925781 6.296875 29.980469 6.914062 29.988281 C 7.195312 29.996094 7.476562 30 7.757812 30 L 20.246094 30 C 20.527344 30 20.808594 29.996094 21.089844 29.988281 C 21.707031 29.980469 22.320312 29.925781 22.929688 29.824219 C 23.539062 29.722656 24.128906 29.527344 24.679688 29.25 C 25.785156 28.683594 26.6875 27.785156 27.25 26.675781 C 27.527344 26.125 27.722656 25.535156 27.828125 24.925781 C 27.925781 24.320312 27.980469 23.703125 27.988281 23.089844 C 27.996094 22.808594 28 22.527344 28 22.246094 L 28 10.757812 C 28 10.425781 28 10.089844 28 9.753906 Z M 23.632812 24.816406 C 22.382812 22.386719 20.054688 22.988281 18.863281 23.601562 C 18.753906 23.664062 18.644531 23.726562 18.535156 23.789062 L 18.507812 23.804688 C 16.039062 25.117188 12.726562 25.214844 9.394531 23.78125 C 6.679688 22.605469 4.386719 20.636719 2.8125 18.132812 C 3.578125 18.699219 4.398438 19.1875 5.261719 19.59375 C 8.78125 21.242188 12.324219 21.125 14.824219 19.59375 C 11.261719 16.851562 8.285156 13.28125 6.003906 10.390625 C 5.570312 9.886719 5.179688 9.34375 4.832031 8.773438 C 7.5625 11.273438 11.875 14.410156 13.421875 15.28125 C 10.136719 11.8125 7.242188 7.535156 7.378906 7.671875 C 12.554688 12.886719 17.328125 15.832031 17.328125 15.832031 C 17.507812 15.933594 17.640625 16.011719 17.75 16.082031 C 17.847656 15.828125 17.933594 15.570312 18.007812 15.304688 C 18.835938 12.285156 17.90625 8.832031 15.800781 5.980469 C 20.601562 8.859375 23.4375 14.332031 22.273438 18.964844 C 22.246094 19.070312 22.214844 19.175781 22.183594 19.28125 C 24.59375 22.246094 23.9375 25.417969 23.628906 24.820312 Z M 23.632812 24.816406',
			'vw' => 28
		),
		'symfony' => array(
			'p' => 'M 16 0.5 C 7.4375 0.5 0.5 7.4375 0.5 16 C 0.5 24.5625 7.4375 31.5 16 31.5 C 24.5625 31.5 31.5 24.5625 31.5 16 C 31.5 7.4375 24.5625 0.5 16 0.5 Z M 24.359375 9.472656 C 23.640625 9.496094 23.144531 9.066406 23.125 8.417969 C 23.105469 7.84375 23.539062 7.578125 23.53125 7.238281 C 23.515625 6.828125 22.894531 6.8125 22.726562 6.820312 C 20.242188 6.902344 19.691406 10.382812 19.046875 13.9375 C 20.386719 14.132812 21.335938 13.890625 21.867188 13.546875 C 22.617188 13.0625 21.660156 12.566406 21.777344 12.015625 C 22.027344 10.878906 23.8125 10.828125 23.777344 12.34375 C 23.757812 13.460938 22.160156 14.957031 18.929688 14.578125 C 18.257812 18.296875 17.78125 21.765625 15.292969 24.683594 C 13.480469 26.835938 11.640625 27.171875 10.816406 27.199219 C 9.277344 27.253906 8.253906 26.429688 8.21875 25.335938 C 8.183594 24.273438 9.121094 23.695312 9.738281 23.671875 C 11.105469 23.625 11.621094 25.277344 10.667969 25.796875 C 9.914062 26.40625 10.675781 26.585938 10.796875 26.582031 C 11.449219 26.558594 11.878906 26.238281 12.183594 26.019531 C 13.683594 24.769531 14.261719 22.589844 15.015625 18.625 C 15.527344 15.519531 16.078125 13.75 16.15625 13.5 C 15.097656 12.703125 14.464844 11.714844 13.039062 11.328125 C 12.066406 11.0625 11.46875 11.289062 11.050781 11.816406 C 10.558594 12.441406 10.722656 13.253906 11.199219 13.734375 L 11.988281 14.609375 C 12.960938 15.730469 13.488281 16.601562 13.289062 17.773438 C 12.972656 19.644531 10.746094 21.082031 8.109375 20.269531 C 5.859375 19.578125 5.441406 17.984375 5.710938 17.109375 C 6.179688 15.597656 8.359375 16.375 7.875 17.957031 C 7.699219 18.496094 7.566406 18.5 7.484375 18.773438 C 7.199219 19.699219 10.097656 20.550781 10.671875 18.6875 C 10.949219 17.78125 10.339844 17.332031 9.28125 16.195312 C 7.5 14.210938 8.28125 12.105469 9.464844 11.21875 C 12.765625 8.757812 15.746094 12.3125 16.375 12.832031 C 18.699219 6.019531 22.65625 6.238281 22.777344 6.234375 C 24.347656 6.183594 25.539062 6.898438 25.578125 8.027344 C 25.59375 8.507812 25.316406 9.4375 24.359375 9.472656 Z M 24.359375 9.472656',
		),
		'tiktok' => array(
			'p' => 'M 28 13.121094 C 25.25 13.125 22.5625 12.269531 20.328125 10.667969 L 20.328125 21.835938 C 20.324219 26.074219 17.695312 29.863281 13.726562 31.347656 C 9.757812 32.832031 5.285156 31.699219 2.503906 28.503906 C -0.277344 25.308594 -0.785156 20.722656 1.234375 16.996094 C 3.25 13.269531 7.367188 11.1875 11.5625 11.769531 L 11.5625 17.386719 C 9.640625 16.78125 7.542969 17.480469 6.371094 19.121094 C 5.195312 20.761719 5.210938 22.96875 6.402344 24.59375 C 7.597656 26.222656 9.699219 26.894531 11.613281 26.269531 C 13.53125 25.640625 14.828125 23.851562 14.828125 21.835938 L 14.828125 0 L 20.328125 0 C 20.324219 0.464844 20.363281 0.929688 20.441406 1.386719 C 20.828125 3.449219 22.046875 5.261719 23.8125 6.398438 C 25.054688 7.21875 26.511719 7.660156 28 7.65625 Z M 28 13.121094',
			'vw' => 28
		),
		'umbraco' => array(
			'p' => 'M 16.023438 0.5 C 7.425781 0.488281 0.449219 7.421875 0.4375 15.980469 C 0.433594 24.542969 7.402344 31.492188 16 31.496094 C 24.585938 31.496094 31.550781 24.578125 31.5625 16.015625 C 31.570312 7.457031 24.617188 0.511719 16.023438 0.5 Z M 25.121094 17.125 C 25.074219 18.820312 24.78125 20.175781 24.242188 21.1875 C 23.703125 22.199219 22.792969 22.929688 21.511719 23.375 C 20.230469 23.820312 18.445312 24.039062 16.148438 24.03125 L 15.863281 24.03125 C 13.570312 24.039062 11.78125 23.820312 10.5 23.375 C 9.21875 22.929688 8.308594 22.199219 7.769531 21.1875 C 7.230469 20.171875 6.9375 18.816406 6.890625 17.125 C 6.847656 16.484375 6.847656 15.84375 6.890625 15.207031 C 6.917969 14.289062 6.992188 13.371094 7.117188 12.464844 C 7.234375 11.625 7.339844 11.050781 7.457031 10.464844 C 7.519531 10.15625 7.535156 10.0625 7.570312 9.933594 C 7.605469 9.792969 7.730469 9.691406 7.878906 9.691406 L 7.921875 9.691406 L 9.929688 10.003906 C 10.082031 10.03125 10.191406 10.164062 10.191406 10.316406 C 10.191406 10.332031 10.191406 10.347656 10.191406 10.363281 L 10.082031 10.914062 C 9.980469 11.464844 9.882812 12.167969 9.78125 13.019531 C 9.675781 13.894531 9.621094 14.773438 9.613281 15.652344 C 9.601562 17.335938 9.773438 18.585938 10.125 19.390625 C 10.484375 20.203125 11.214844 20.789062 12.089844 20.964844 C 13.269531 21.214844 14.476562 21.324219 15.6875 21.289062 L 16.328125 21.289062 C 17.535156 21.320312 18.742188 21.214844 19.921875 20.964844 C 20.792969 20.785156 21.519531 20.195312 21.878906 19.386719 C 22.234375 18.578125 22.402344 17.332031 22.386719 15.652344 C 22.382812 14.769531 22.328125 13.890625 22.222656 13.015625 C 22.121094 12.167969 22.019531 11.464844 21.917969 10.914062 L 21.8125 10.363281 C 21.808594 10.347656 21.808594 10.332031 21.8125 10.316406 C 21.808594 10.160156 21.921875 10.027344 22.074219 10.003906 L 24.082031 9.691406 L 24.132812 9.691406 C 24.28125 9.691406 24.410156 9.789062 24.441406 9.933594 C 24.476562 10.0625 24.492188 10.15625 24.554688 10.460938 C 24.671875 11.0625 24.777344 11.636719 24.894531 12.460938 C 25.019531 13.371094 25.09375 14.285156 25.121094 15.203125 C 25.164062 15.84375 25.164062 16.484375 25.117188 17.125 Z M 25.121094 17.125',
		),
		'uncharted' => array(
			'p' => 'M 10.734375 14.550781 C 10.867188 14.550781 10.992188 14.46875 11.042969 14.34375 C 11.183594 13.734375 11.507812 13.179688 11.976562 12.765625 C 12.050781 12.714844 12.078125 12.609375 12.078125 12.507812 C 12.070312 12.421875 12.023438 12.34375 11.949219 12.300781 L 4.652344 8.03125 L 9.308594 5.3125 C 9.496094 5.207031 9.613281 5.007812 9.621094 4.796875 C 9.625 4.578125 9.503906 4.375 9.308594 4.277344 L 7.914062 3.476562 C 7.726562 3.371094 7.503906 3.371094 7.316406 3.476562 L 1.054688 7.097656 C 0.867188 7.207031 0.75 7.402344 0.746094 7.617188 L 0.746094 14.808594 C 0.742188 15.027344 0.859375 15.226562 1.054688 15.328125 L 2.453125 16.128906 C 2.546875 16.183594 2.652344 16.210938 2.761719 16.207031 C 2.914062 16.210938 3.0625 16.15625 3.175781 16.050781 C 3.289062 15.933594 3.351562 15.777344 3.359375 15.613281 L 3.359375 10.28125 L 10.605469 14.523438 C 10.644531 14.542969 10.6875 14.550781 10.734375 14.550781 Z M 20.203125 23.609375 C 20.097656 23.613281 19.992188 23.640625 19.894531 23.6875 L 15.234375 26.378906 L 15.234375 17.992188 C 15.234375 17.8125 15.054688 17.628906 14.847656 17.707031 C 14.257812 17.882812 13.628906 17.894531 13.035156 17.734375 C 12.945312 17.707031 12.847656 17.726562 12.773438 17.78125 C 12.695312 17.835938 12.648438 17.925781 12.648438 18.019531 L 12.648438 26.351562 L 7.988281 23.660156 C 7.898438 23.605469 7.789062 23.578125 7.679688 23.582031 C 7.351562 23.585938 7.089844 23.851562 7.085938 24.175781 L 7.085938 25.808594 C 7.082031 26.027344 7.199219 26.226562 7.394531 26.324219 L 13.65625 29.921875 C 13.75 29.976562 13.859375 30.003906 13.96875 30 C 14.074219 30 14.183594 29.972656 14.277344 29.921875 L 20.539062 26.324219 C 20.726562 26.21875 20.84375 26.023438 20.851562 25.808594 L 20.851562 24.175781 C 20.800781 23.894531 20.515625 23.609375 20.203125 23.609375 Z M 17.875 4.875 C 18.667969 4.875 19.3125 4.230469 19.3125 3.4375 C 19.3125 2.644531 18.667969 2 17.875 2 C 17.082031 2 16.4375 2.644531 16.4375 3.4375 C 16.4375 4.230469 17.082031 4.875 17.875 4.875 Z M 21.851562 4.246094 C 21.058594 4.246094 20.414062 4.886719 20.414062 5.683594 C 20.414062 6.476562 21.058594 7.121094 21.851562 7.121094 C 22.644531 7.121094 23.289062 6.476562 23.289062 5.683594 C 23.289062 4.886719 22.644531 4.246094 21.851562 4.246094 Z M 25.800781 9.476562 C 26.59375 9.476562 27.238281 8.832031 27.238281 8.039062 C 27.238281 7.242188 26.59375 6.601562 25.800781 6.601562 C 25.007812 6.601562 24.363281 7.242188 24.363281 8.039062 C 24.363281 8.832031 25.007812 9.476562 25.800781 9.476562 Z M 21.851562 8.898438 C 21.058594 8.898438 20.414062 9.542969 20.414062 10.335938 C 20.414062 11.132812 21.058594 11.773438 21.851562 11.773438 C 22.644531 11.773438 23.289062 11.132812 23.289062 10.335938 C 23.289062 9.542969 22.644531 8.898438 21.851562 8.898438 Z M 17.875 14.101562 C 18.667969 14.101562 19.3125 13.460938 19.3125 12.664062 C 19.3125 11.871094 18.667969 11.226562 17.875 11.226562 C 17.082031 11.226562 16.4375 11.871094 16.4375 12.664062 C 16.4375 13.460938 17.082031 14.101562 17.875 14.101562 Z M 13.996094 16.375 C 14.789062 16.375 15.433594 15.730469 15.433594 14.9375 C 15.433594 14.144531 14.789062 13.5 13.996094 13.5 C 13.203125 13.5 12.558594 14.144531 12.558594 14.9375 C 12.558594 15.730469 13.203125 16.375 13.996094 16.375 Z M 25.800781 11.226562 C 25.007812 11.226562 24.363281 11.871094 24.363281 12.664062 C 24.363281 13.460938 25.007812 14.101562 25.800781 14.101562 C 26.59375 14.101562 27.238281 13.460938 27.238281 12.664062 C 27.238281 11.871094 26.59375 11.226562 25.800781 11.226562 Z M 25.800781 15.746094 C 25.007812 15.746094 24.363281 16.386719 24.363281 17.183594 C 24.363281 17.976562 25.007812 18.621094 25.800781 18.621094 C 26.59375 18.621094 27.238281 17.976562 27.238281 17.183594 C 27.238281 16.386719 26.59375 15.746094 25.800781 15.746094 Z M 25.800781 15.746094',
			'vw' => 28
		),
		'unity' => array(
			'p' => 'M 31.132812 12.898438 L 27.832031 0.921875 L 15.511719 4.128906 L 13.6875 7.257812 L 9.988281 7.230469 L 0.972656 16 L 9.988281 24.769531 L 13.6875 24.742188 L 15.515625 27.867188 L 27.832031 31.078125 L 31.132812 19.101562 L 29.257812 16 Z M 13.984375 7.761719 L 23.410156 5.40625 L 18 14.519531 L 7.179688 14.519531 Z M 13.984375 24.238281 L 7.179688 17.480469 L 18 17.480469 L 23.410156 26.59375 Z M 26.046875 25.113281 L 20.636719 16 L 26.046875 6.886719 L 28.660156 16 Z M 26.046875 25.113281',
			'vw' => 36
		),
		'unsplash' => array(
			'p' => 'M 28 14.386719 L 28 30 L 0 30 L 0 14.386719 L 8.820312 14.386719 L 8.820312 22.191406 L 19.179688 22.191406 L 19.179688 14.386719 Z M 19.179688 2 L 8.820312 2 L 8.820312 9.808594 L 19.179688 9.808594 Z M 19.179688 2',
			'vw' => 28
		),
		'watchman-monitoring' => array(
			'p' => 'M 16 1 C 7.714844 1 1 7.714844 1 16 C 1 24.285156 7.714844 31 16 31 C 24.285156 31 31 24.285156 31 16 C 31 7.714844 24.285156 1 16 1 Z M 7.605469 26.820312 C 4.378906 24.3125 2.296875 20.394531 2.296875 16 C 2.296875 14.640625 2.496094 13.292969 2.894531 11.992188 L 9.328125 10.875 L 9.320312 11.558594 L 8.449219 11.683594 C 8.449219 11.683594 8.4375 12.464844 8.4375 12.90625 C 8.433594 13.160156 8.546875 13.398438 8.746094 13.554688 L 9.335938 14.015625 Z M 14.210938 9.117188 L 14.742188 8.640625 C 14.742188 8.640625 15.175781 8.304688 14.734375 8.054688 C 14.28125 7.804688 12.261719 5.898438 12.261719 5.898438 C 11.925781 5.558594 11.746094 5.441406 11.296875 5.898438 C 11.296875 5.898438 9.273438 7.804688 8.824219 8.054688 C 8.382812 8.304688 8.816406 8.640625 8.816406 8.640625 L 9.347656 9.117188 L 9.34375 9.390625 L 4.75 8.191406 C 7.226562 4.632812 11.34375 2.296875 16 2.296875 C 19.953125 2.296875 23.710938 4.007812 26.308594 6.984375 L 14.214844 9.34375 Z M 16.339844 29.695312 L 14.222656 14.015625 L 14.8125 13.554688 C 15.011719 13.398438 15.125 13.160156 15.117188 12.90625 C 15.117188 12.46875 15.109375 11.683594 15.109375 11.683594 L 14.238281 11.558594 L 14.230469 10.90625 L 29.339844 12.867188 C 29.582031 13.894531 29.703125 14.945312 29.703125 16 C 29.703125 23.441406 23.738281 29.511719 16.339844 29.695312 Z M 16.339844 29.695312',
		),
		'waze' => array(
			'p' => 'M 31.386719 12.605469 C 32.292969 17.96875 29.453125 23.097656 24.3125 25.613281 C 25.125 27.742188 23.539062 30 21.292969 30 C 19.574219 30 18.160156 28.652344 18.070312 26.9375 C 17.667969 26.949219 14.058594 26.9375 13.296875 26.898438 C 13.226562 28.679688 11.722656 30.070312 9.9375 29.996094 C 7.820312 29.910156 6.316406 27.816406 7 25.75 C 4.675781 24.929688 2.464844 23.570312 0.773438 21.324219 C -0.0390625 20.246094 0.742188 18.710938 2.078125 18.710938 C 4.96875 18.710938 4.089844 15.328125 4.773438 11.820312 C 5.925781 5.949219 12.070312 2 18.003906 2 C 24.410156 2 30.328125 6.417969 31.386719 12.605469 Z M 23.34375 24.265625 C 25.96875 23.070312 28.425781 20.722656 29.363281 17.882812 C 31.890625 10.191406 25.351562 3.632812 18.003906 3.632812 C 12.789062 3.632812 7.359375 7.097656 6.375 12.132812 C 5.78125 15.191406 6.6875 20.34375 2.078125 20.34375 C 3.636719 22.414062 5.726562 23.632812 7.9375 24.347656 C 9.480469 22.984375 11.929688 23.378906 12.925781 25.242188 C 13.816406 25.304688 17.875 25.316406 18.421875 25.292969 C 18.867188 24.425781 19.679688 23.800781 20.636719 23.601562 C 21.59375 23.402344 22.589844 23.648438 23.34375 24.265625 Z M 12.820312 11.695312 C 12.820312 9.523438 15.996094 9.523438 15.996094 11.695312 C 15.996094 13.867188 12.820312 13.867188 12.820312 11.695312 Z M 20.105469 11.695312 C 20.105469 9.523438 23.285156 9.523438 23.285156 11.695312 C 23.285156 13.867188 20.105469 13.867188 20.105469 11.695312 Z M 12.441406 16.113281 C 12.226562 15.054688 13.828125 14.726562 14.042969 15.789062 L 14.046875 15.804688 C 14.304688 17.144531 15.914062 18.554688 18.054688 18.496094 C 20.285156 18.4375 21.757812 17.109375 22.0625 15.824219 C 22.339844 14.820312 23.847656 15.175781 23.652344 16.199219 C 23.328125 17.585938 21.703125 20.074219 17.9375 20.128906 C 15.277344 20.128906 12.882812 18.390625 12.445312 16.113281 Z M 12.441406 16.113281',
		),
		'wodu' => array(
			'p' => 'M 11.152344 21.230469 L 8.820312 21.230469 L 7.011719 13.96875 L 6.980469 13.96875 L 5.203125 21.230469 L 2.824219 21.230469 L 0 10.558594 L 2.347656 10.558594 L 4.035156 17.824219 L 4.066406 17.824219 L 5.917969 10.558594 L 8.117188 10.558594 L 9.941406 17.914062 L 9.96875 17.914062 L 11.71875 10.558594 L 14.019531 10.558594 Z M 16.960938 13.292969 C 19.398438 13.292969 20.96875 14.910156 20.96875 17.375 C 20.96875 19.828125 19.398438 21.441406 16.960938 21.441406 C 14.542969 21.441406 12.972656 19.828125 12.972656 17.375 C 12.972656 14.910156 14.542969 13.292969 16.960938 13.292969 Z M 16.960938 19.839844 C 18.414062 19.839844 18.847656 18.601562 18.847656 17.375 C 18.847656 16.132812 18.414062 14.894531 16.960938 14.894531 C 15.230469 14.894531 15.09375 16.132812 15.09375 17.375 C 15.09375 18.601562 15.527344 19.839844 16.960938 19.839844 Z M 27.191406 20.246094 L 27.164062 20.246094 C 26.667969 21.082031 25.800781 21.441406 24.816406 21.441406 C 22.484375 21.441406 21.347656 19.4375 21.347656 17.300781 C 21.347656 15.222656 22.5 13.292969 24.769531 13.292969 C 25.683594 13.292969 26.578125 13.683594 27.074219 14.445312 L 27.089844 14.445312 L 27.089844 10.558594 L 29.210938 10.558594 L 29.210938 21.230469 L 27.191406 21.230469 Z M 25.339844 14.894531 C 23.949219 14.894531 23.472656 16.089844 23.472656 17.359375 C 23.472656 18.570312 24.023438 19.839844 25.339844 19.839844 C 26.746094 19.839844 27.164062 18.617188 27.164062 17.34375 C 27.164062 16.089844 26.714844 14.894531 25.339844 14.894531 Z M 37.058594 21.230469 L 35.042969 21.230469 L 35.042969 20.15625 L 34.996094 20.15625 C 34.460938 21.023438 33.53125 21.441406 32.636719 21.441406 C 30.378906 21.441406 29.8125 20.171875 29.8125 18.257812 L 29.8125 13.503906 L 31.933594 13.503906 L 31.933594 17.867188 C 31.933594 19.140625 32.308594 19.765625 33.292969 19.765625 C 34.445312 19.765625 34.9375 19.125 34.9375 17.554688 L 34.9375 13.503906 L 37.058594 13.503906 Z M 37.652344 18.929688 L 40 18.929688 L 40 21.230469 L 37.652344 21.230469 Z M 37.652344 18.929688',
			'vw' => 40
		),
		'yammer' => array(
			'p' => 'M 26.359375 9.511719 C 26.902344 9.082031 27.0625 8.328125 26.742188 7.71875 C 26.425781 7.105469 25.71875 6.804688 25.054688 7 C 25.003906 7.027344 24.949219 7.054688 24.890625 7.085938 C 23.9375 7.613281 17.496094 12.125 18.222656 12.636719 C 18.953125 13.144531 23.351562 11.160156 26.359375 9.511719 Z M 26.359375 23.082031 C 23.351562 21.433594 18.945312 19.453125 18.222656 19.957031 C 17.5 20.464844 23.9375 24.980469 24.890625 25.503906 C 24.949219 25.535156 25.003906 25.566406 25.054688 25.59375 C 25.714844 25.785156 26.421875 25.484375 26.738281 24.875 C 27.054688 24.261719 26.898438 23.515625 26.359375 23.082031 Z M 29.011719 14.8125 C 28.953125 14.8125 28.890625 14.808594 28.824219 14.808594 C 27.738281 14.808594 19.917969 15.667969 20.3125 16.464844 C 20.703125 17.261719 25.515625 17.636719 28.949219 17.636719 C 29.632812 17.527344 30.136719 16.945312 30.152344 16.25 C 30.167969 15.558594 29.6875 14.953125 29.011719 14.8125 Z M 1.9375 6.039062 C 1.679688 5.257812 2.074219 4.410156 2.835938 4.105469 C 3.601562 3.800781 4.472656 4.144531 4.820312 4.890625 L 9.882812 17.707031 L 9.960938 17.707031 L 14.773438 4.984375 C 15.058594 4.253906 15.875 3.875 16.617188 4.128906 C 17.363281 4.386719 17.773438 5.183594 17.550781 5.941406 L 10.699219 23.027344 C 9.539062 25.980469 8.378906 28 4.871094 28 C 4.371094 28 3.871094 27.960938 3.382812 27.878906 C 2.730469 27.691406 2.324219 27.046875 2.433594 26.378906 C 2.542969 25.714844 3.136719 25.234375 3.8125 25.265625 C 3.855469 25.269531 4.496094 25.308594 4.679688 25.308594 C 6.582031 25.308594 7.414062 24.125 8.308594 21.59375 Z M 1.9375 6.039062',
		),
	    'linkedin' => array(
		'p' => 'M26 2q.813 0 1.406.594T28 4v24q0 .813-.594 1.406T26 30H2q-.813 0-1.406-.594T0 28V4q0-.813.594-1.406T2 2h24zM8.438 26h.063V12.625H4.313V26h4.125zM6.375 10.813q1 0 1.719-.719t.719-1.688-.719-1.688-1.719-.719-1.688.719-.688 1.688.688 1.688 1.688.719zM24 26v-7.313q0-1.5-#q#563t-.688-1.969-1.531-1.375-2.531-.469q-1.438 0-2.469.625t-1.469 1.5h-.063v-1.813h-4v13.375h4.188v-6.625q0-1.563.5-2.5t1.938-.938q.75 0 1.25.313t.656.938.219 1.094.063 1.219v6.5H24z'
	    ),
	    'github-square' => array(
		'p' => '#a#m-7.687 24q3.125-1.063 5.031-3.781t1.906-6.156q0-4.25-3.031-7.156t-7.344-2.906-7.219 2.906-2.906 7.156q0 3.438 1.938 6.156T10.751 26q.75.125.75-.5 0-.063-.031-1.063t-.031-1.5q-.125.063-.313.094t-.719.031-.969-.094-.875-.406-.625-.875q-.438-1.188-1.125-1.5l-.438-.438q0-.188.5-.188 1 .063 1.563 1.063 1.063 1.813 3.063.875.125-.938.625-1.375-1.125-.125-1.75-.281t-1.406-.594-1.125-1.375-.344-2.313 1-2.438q-.563-1.25.063-2.813.375-.125 1.094.156t1.281.594l.5.313q1.25-.313 2.594-.313t2.594.313q.25-.125.594-.344t1.125-.531 1.156-.188q.625 1.5.125 2.813 1.063 1.125 1.063 2.438 0 1.375-.375 2.313t-1.188 1.375-1.438.594-1.75.281q.688.563.688 1.875v3.5q0 .625.688.5zm-6.094-3.844q-.219.031-.25-.125t.156-.156q.25-.063.281.094t-.188.188zm-.594-.031q0-.188-.25-.188t-.25.188q0 .125.25.125t.25-.125zm-.875-.094q-.063.156-.25.094-.25-.063-.188-.219t.25-.094q.25.063.188.219zM9 21.688q.063-.063-.094-.25t-.281-.063q-.063.125.063.313.188.125.313 0zm-.562-.563q.125-.063 0-.25t-.25-.063q-.125.063 0 .219t.25.094zm-.407-.594q.094-.094-.031-.219t-.219-.031.031.219.219.031zm-.468-.468q.063-.063-.063-.188-.125 0-.188.063t.125.125q.125.125.125 0z'
	    ),
	    'twitter' => array(
		'p' => 'M28.688 9.5q.063.25.063.813 0 3.313-1.25 6.594t-3.531 6-5.906 4.406-8 1.688q-5.5 0-10.063-2.938.688.063 1.563.063 4.563 0 8#q#813-2.188 0-3.844-1.281t-2.281-3.219q.625.063 1.188.063.875 0 1.75-.188-1.5-.313-2.688-1.25t-1.875-2.281-.688-2.906v-.125q1.375#r#938.875-2.938-2-2.938-5.5 0-1.75.938-3.313Q4.69 7.251 8.221 9.063t7.531 2q-.125-.75-.125-1.5 0-2.688 1.906-4.625T22.127 3q2.875 0 4#r#063 2.25-.438 4.188-1.563-.75 2.313-2.875 3.625 1.875-.25 3.75-1.063-1.375 2-3.313 3.438z',
		'w' => .998046875
	    ),
	    'twitter-square' => array(
		'p' => '#a#m-3.062 9.938q1.188-.875 2.063-2.125-1.188.5-2.375.625 1.313-.813 1.813-2.25-1.25.75-2.625 1-1.188-1.313-2.938-1.313-1.938 0-3.188 1.5t-.813 3.563q-5.188-.313-8.5-4.313-.563.938-.563 2.063 0 .625.25 1.281t.688 1.219.938.938q-1-.063-1.875-.563v.063q0 1.5.938 2.625t2.375 1.438q-.875.188-1.875.063.375 1.25 1.438 2.031t2.375.781q-2.25 1.75-5.063 1.75-.563 0-1-.063 2.875 1.875 6.313 1.875 3.563 0 6.313-1.813t4.031-4.438 1.281-5.438v-.5z'
	    ),
	    'facebook-square' => array(
		'p' => 'M28 5v22#n# 30h-5.313V18.937h3.75l.563-4.25h-4.313v-2.688q0-.688.125-1.094t.625-.688 1.313-.281H24v-3.75q-1.313-.188-3.25-#q#5 0-3.969 1.469t-1.469 4.094v3.125h-3.813v4.25h3.813v11.063H2.999q-1.25 0-2.125-.875t-.875-2.125v-22q0-1.25.875-2.125t2.125-.875h22q1.25 0 2.125.875t.875 2.125z'
	    ),
	    'facebook' => array(
		'p' => 'M13.5 5.313q-1.125 0-1.781.375t-.844.938-.188 1.438v3.938H16l-.75 5.688h-4.563v14.313H4.812V17.69H-.001v-5.688h4.813v-4.5q0-3.563 2-5.531T12.125.002q2.688 0 4.375.25v5.063h-3z',
		'w' => .98,
		'vw' => 17
	    ),
	    'facebook-f'=>'facebook',
	    'facebook-messenger' => array(
		'p' => 'M14 2q5.75 0 9.813 3.781t4.063 9.156q0 4.25-2.594 7.594t-6.75 4.688-8.531.156L5.313 30v-4.938q-2.125-1.625-3.406-3.719t-1.594-4.25.063-4.344 1.563-4.094 2.875-3.406 4.094-2.375 5.094-.875zm1.438 17.375l7.563-8-6.875 3.813-3.563-3.75L5 19.501l6.875-3.875z',
		'w' => .98,
		'vw' => 28
	    ),
	    'github' => array(
		'p' => 'M10.375 24.813q0 .25-.313.25-.375.063-.375-.25 0-.188.313-.188.375-.063.375.188zm-1.969-.25q.094-.25.406-.125.313.063.25.313t-.375.125q-.375-.063-.281-.313zm2.782-.125q.313 0 .344.188t-.281.313q-.313.063-.344-.188t.281-.313zM15.313.5q4.25 0 7.875 2T28.907 8t2.094 7.75q0 5#q#906 9.281t-7.594 5.656q-.5.125-.781-.125t-.281-.625v-5.25q0-2-1.063-2.875 1.375-.188 2.125-.313t1.875-.563 1.719-1.125 1.031-1.938.438-3q0-1.188-.375-1.938t-1.25-1.688q.75-1.938-.125-4.25-.625-.188-1.688.219t-1.875.906l-.75.563q-1.938-.563-3.969-.563t-3.906.563q-.313-.25-.875-.594t-1.719-.813-1.719-.281q-.938 2.313-.188 4.25-1.438 1.563-1.438 3.625 0 1.75.438 3t1 1.938 1.625 1.125 1.844.594 2.094.281q-.813.75-1 2.125-.625.25-1.281.375t-1.656-.25-1.625-1.438q-.375-.688-.969-1.094t-1.031-.469l-.375-.063q-1.375 0-.125.938.438.25.875.813t.625 1l.25.5q.25.75.875 1.25t1.375.625 1.438.125 1.125-.063l.438-.063q0 .75.031 2.25t.031 1.563q0 .375-.281.625t-.781.125q-4.75-1.563-7.688-5.656T.001 15.747q0-6.5 4.406-10.875T15.313.497zm-9.25 21.563q.125-.125.313.063t.063.313-.313-.063-.063-.313zm-.688-.5q.125-.125.313-.063.188.125.125.25-.063.188-.25.063-.25-.125-.188-.25zm2.063 2.187q.125-.188.375.063t.125.438q-.188.188-.438-.063t-.063-.438zm-.75-.875q.188-.188.375.125.188.25 0 .375t-.344-.156-.031-.344z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'pinterest' => array(
		'p' => 'M31 16q0 6.438-4.531 10.969T15.5 31.5q-2.375 0-4.563-.688 1.5-2.5 1.875-4.063l1-3.688q.375.75 1.375 1.25t2.188.5q3.438 0 5.719-2.781t2.281-6.844q0-3.813-2.75-6.375t-6.813-2.563q-4.75 0-7.469 2.75t-2.719 6.625q0 1.813.875 3.594t2.25 2.406q.438.188.5-.188.063-.125.219-.844t.219-.906q.063-.25-.125-.438-1.125-1.438-1.125-3.563 0-2.688 1.906-4.719t5.094-2.031q2.875 0 4.688 1.781t1.813 4.531q0 2.063-.656 3.688t-1.781 2.531-2.438.906q-1.188 0-1.875-.844t-.438-1.969q.125-.625.5-1.75t.563-1.969.188-1.469q0-.563-.188-1.063t-.656-.781-1.094-.281q-1.188 0-2 1.063t-#r#688q0 .25.031.531t.063.5.094.438.094.344.094.25.063.188l.063.063q-1.563 6.438-1.875 7.688-.313 1.563 0 4.438-4.438-1.688-7.156-5.625T.002 15.998q0-6.438 4.531-10.969T15.502.498t10.969 4.531 4.531 10.969z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'pinterest-square' => array(
		'p' => 'M28 5v22#n# 30H9.625q1.375-2.25 1.75-3.688l.938-3.688q.375.75 1.375 1.25t2.125.5q2.313 0 4.125-1.25t2.844-3.438 1.031-4.813q0-3.813-2.719-6.344t-6.781-2.531q-4.688 0-7.406 2.719t-2.719 6.594q0 1.75.875 3.5t2.25 2.438q.438.188.5-.25 0-.063.188-.75t.25-.938-.125-.438q-1.125-1.438-1.125-3.5 0-2.688 1.906-4.688t5.031-2q2.813 0 4.625 1.75t1.813 4.5q0 2-.656 3.625t-1.75 2.5-2.469.875q-1.125 0-1.813-.813t-.438-1.938q.125-.688.469-1.781t.563-1.938.219-1.406q0-1.875-1.563-2.125-1.688-.25-2.625 1.5-.5.938-.5 2.188 0 .375.031.75t.094.656.125.469.125.313l.063.125q-.313 1.313-.719 3.031t-.563 2.344-.375 1.625-.25 1.375-.063 1.063 0 1.219.094 1.344l.188.063H3q-1.25 0-2.125-.875T0 26.999v-22q0-1.25.875-2.125T3 1.999h22q1.25 0 2.125.875T28 4.999z'
	    ),
	    'google-plus-square' => array(
		'p' => '#a#M10.25 22.25q2.688 0 4.344-1.688t1.656-4.438q0-.5-.125-1H10.25v2.125h3.563q-.188.938-1.063 1.813t-2.5.875q-1.063 0-1.938-.531t-1.406-1.438-.531-1.969q0-1.625 1.125-2.781t2.75-1.156q1.5 0 2.5.938l1.688-1.625Q12.688 9.75 10.25 9.75q-2.563 0-4.406 1.844T4 16t1.844 4.406 4.406 1.844zM24 17.125v-1.813h-1.813v-1.813h-1.813v1.813h-1.813v1.813h1.813v1.813h1.813v-1.813H24z'
	    ),
	    'google-plus' => array(
		'p' => 'M24.125 14.25q.188 1.063.188 2 0 5.188-3.188 8.469T12.812 28q-5 0-8.5-3.5T.812 16t3.5-8.5 8.5-3.5q4.688 0 8 3.125l-3.25 3.125q-1.875-1.813-4.75-1.813-2 0-3.719 1t-2.719 2.75-1 3.813q0 3.125 2.188 5.344t5.25 2.219q3.125 0 4.813-1.688t2-3.438h-6.813v-4.188h11.313zm11.563.438h3.5v3.5h-3.5v3.5h-3.5v-3.5H28.75v-3.5h3.438v-3.5h3.5v3.5z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'google-plus-g' => 'google-plus',
	    'linkedin-in' => array(
		'p' => 'M6.25 28H.437V9.312H6.25V28zM3.375 6.75Q2 6.75 1 5.75T0 3.375 1 1t2.375-1T5.75 1t1 2.375-1 2.375-2.375 1zM28 28h-5.813v-9.125q0-.813-.031-1.344t-.188-1.281-.438-1.188-.875-.781-1.469-.344q-2.063 0-2.781 1.313t-.719 3.5V28H9.873V9.312h5.625v2.563h.063q.625-1.25 2.063-2.156t3.438-.906q2.125 0 3.531.656t2.125 1.938 1 2.781.281 3.563v10.25z'
	    ),
	    'github-alt' => array(
		'p' => 'M11.625 20.563q0 1.188-.594 2.313t-1.719 1.125q-.75 0-1.281-.625t-.75-1.375-.219-1.438q0-1.188.594-2.313t1.688-1.125 1.688 1.125.594 2.313zM30 17.375q0 3.688-1.125 5.938-.563 1.188-1.406 2.031t-2.125 1.344-2.281.781-2.719.375-2.469.125-2.5.031h-2.219L11 27.906l-2.438-.219-2.156-.469-2.156-.844-1.625-1.281-1.375-1.781Q0 20.812 0 17.374q0-4.063 2.625-7.063-.5-1.5-.5-3.063 0-1.438.875-3.25 2.188 0 3.719.5t3.094 1.75q2.625-.625 5.563-.625 2.625 0 5 .563 1.563-1.25 3.094-1.719t3.656-.469q.938 1.813.938 3.25 0 1.563-.5 3 2.438 2.875 2.438 7.125zm-4 3.188q0-2.188-1.25-3.688t-3.375-1.5q-.75 0-3.5.375-1.313#q#813.188t-2.813-.188q-2.688-.375-3.5-.375-2.125 0-3.375 1.5t-1.25 3.688q0 1.563.594 2.75t1.469 1.844 2.188 1.063 2.5.531 2.688.125h3q1.875 0 3.375-.219t2.969-.844 2.281-1.969.813-3.281zm-5.156-3.438q1.094 0 1.688 1.125t.594 2.313-.594 2.313-1.688 1.125-1.719-1.125-.625-2.313.625-2.313 1.719-1.125z',
		'w' => .9375,
		'vw' => 30
	    ),
	    'maxcdn' => array(
		'p' => 'M28.813 27.688H22.75L26 12.5q.188-1-.313-1.594t-1.5-.594h-3.063l-3.75 17.375h-6.063l3.688-17.375H9.811l-3.75 17.375H-.002l3.75-17.375-2.813-6h23.25q3.875 0 6.125 2#r#313 2.813 1.5 6.625z',
		'w' => .998046875
	    ),
	    'html5' => array(
		'p' => 'M0 2h24l-2.188 24.75L11.999 30l-9.813-3.25zm19.25 8l.313-3H4.5l.75 9.125h10.438L15.313 20 12 20.875 8.625 20l-.25-2.375H5.437l.375 4.75L12 24.063h.063l6.063-1.688.875-9.313h-11l-.25-3.063h11.5z',
		'w' => .75,
		'vw' => 24
	    ),
	    'css3' => array(
		'p' => 'M30 2l-4 23-13.938 5-12.063-5 1.25-5.938h5.125l-.5 2.563 7.25 2.75 8.375-2.75 1.188-6.063H1.874l1-5.125h20.813l.688-3.313H3.5l1.063-5.125h25.438z',
		'w' => .9375,
		'vw' => 30
	    ),
	    'btc' => array(
		'p' => 'M19.375 15.188q4.813 1.125 4.375 6.25-.375 3.313-2.594 4.688t-6.344 1.625v4.25h-3.063v-4.188H9.374v4.188H6.311v-4.25H.248l.625-3.625h.625q1.063.063 1.469.031t.781-.281.438-.75V9.563q-.188-1-.906-1.219T.749 8.188h-.5v-3.25q5.25.063 6.063 0V0h3.063v4.875q1.563-.063 2.375-.063V-.001h3.063v4.938q1.188.125 2.188.344t1.906.594 1.531.938 1.031 1.406.469 1.844q.375 3.625-2.563 5.125zm-9.937-6.75v6q.063 0 .656.031t.906 0 .969-.031 1.094-.094 1.031-.219.969-.375.719-.563.531-.75.188-1q0-.75-.281-1.281t-.844-.875-1.094-.531-1.375-.25-1.313-.094-1.281 0-.875.031zm0 15.687q.063 0 .781.031t1.094 0 1.156-.063 1.281-.125 1.188-.219 1.125-.406.844-.594.625-.813.219-1.125q0-.813-.344-1.406t-1-.938-1.25-.594-1.625-.313-1.531-.094-1.5 0-1.063.031v6.625z',
		'w' => .748046875,
		'vw' => 24
	    ),
	    'youtube' => array(
		'p' => 'M34.375 7.75q.188.75.344 1.875t.219 2.219.094 2.031.031 1.563v.563q0 5.625-.688 8.313-.313 1.063-1.125 1.875t-1.938 1.125q-1.188.313-4.5.469t-6.063.219h-2.75q-10.688 0-13.313-.688-2.438-.688-3.063-3-.313-1.188-.469-3.281t-.219-3.531v-1.5q0-5.563.688-8.25.313-1.125 1.125-1.938t1.938-1.125q1.188-.313 4.5-.469t6.063-.219h2.75q10.688 0 13.313.688 1.125.313 1.938 1.125t1.125 1.938zM14.5 21.125L23.438 16 14.5 10.937v10.188z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'xing' => array(
		'p' => 'M10.188 13.125l-4.375 7.75q-.5.75-1.125.75H.625q-.375 0-.531-.281t-.031-.594l4.313-7.625-2.75-4.75q-.188-.313 0-.594t.563-.281h4.063q.688 0 1.125.75zm13.75-10.25l-9 15.813 5.688 10.438q.188.313.031.594t-.531.281h-4.125q-.688 0-1.125-.75l-5.75-10.563q.063-.125 1.031-1.813t3.219-5.656 4.813-8.469Q18.627 2 19.252 2h4.125q.375 0 .531.281t.031.594z',
		'w' => .75,
		'vw' => 24
	    ),
	    'xing-square' => array(
		'p' => '#a#M8.75 20q.5 0 .813-.563 3-5.313 3.125-5.5l-2-3.438q-.313-.563-.813-.563H7q-.313 0-.406.188t.031.438l1.938 3.375L5.5 19.375q-.125.25 0 .438t.375.188H8.75zM22.5 6.625q.125-.25 0-.438t-.375-.188h-2.938q-.438 0-.75.563-6.375 11.188-6.5 11.375l4.125 7.5q.313.563.813.563h2.938q.25 0 .375-.188t0-.438l-4.125-7.438z'
	    ),
	    'dropbox' => array(
		'p' => 'M16.5 7.25l-8.25 5.313 8.25 5.25-8.25 5.25L0 17.75l8.25-5.25L0 7.25 8.25 2zm-8.25 17.5l8.25-5.313 8.25 5.313L16.5 30zm8.25-7l8.25-5.25-8.25-5.25L24.75 2 33 7.25l-8.25 5.313 8.25 5.25-8.25 5.25z',
		'w' => 1.03125,
		'vw' => 33
	    ),
	    'stack-overflow' => array(
		'p' => 'M18.188 19.438l-.563 2.438-12#q#563.5-2.438zM21.375 14l-1.625 1.938-9.563-8.063L11.75 6zm-2 2.5l-1 2.25L7 13.5l1.063-2.313zm-3-14.5l7.438 10-2 1.5-7.438-10zm1.25 20.5V25h-12.5v-2.5h12.5zm2.5 5V20h2.5v10H.187V20h2.5v7.5h17.438z',
		'w' => .75,
		'vw' => 24
	    ),
	    'instagram' => array(
		'p' => 'M14 8.813q3 0 5.094 2.094t2.094 5.094-2.094 5.094T14 23.189t-5.094-2.094-2.094-5.094 2.094-5.094T14 8.813zm0 11.875q1.938 0 3.313-1.375T18.688 16t-1.375-3.313T14 11.312t-3.313 1.375T9.312 16t1.375 3.313T14 20.688zM23.125 8.5q0 .688-.469 1.188t-1.156.5-1.188-.5-.5-1.188.5-1.156 1.188-.469 1.156.469.469 1.156zm4.813 1.75q.063 1.688.063 5.75t-.063 5.75q-.188 3.813-2.281 5.906t-5.906 2.219q-1.688.125-5.75.125t-5.75-.125q-3.813-.188-5.875-2.25-.813-.75-1.313-1.75t-.719-1.938-.219-2.188Q0 20.061 0 15.999t.125-5.813q.188-3.75 2.25-5.813Q4.438 2.248 8.25 2.06q1.688-.063 5.75-.063t5.75.063q3.813.188 5.906 2.281t2.281 5.906zm-3 14q.188-.5.313-1.281t.188-1.875.063-1.781v-6.625l-.063-1.781-.188-1.875-.313-1.281q-.75-1.938-2.688-2.688-.5-.188-1.281-.313t-1.875-.188-1.75-.063h-6.656l-1.781.063-1.875.188-1.281.313q-1.938.75-2.688 2.688-.188.5-.313 1.281t-.188 1.875-.063 1.75v6l.031 1.531.094 1.594.188 1.344.25 1.125q.813 1.938 2.688 2.688.5.188 1.281.313t1.875.188 1.75.063h6.656l1.781-.063 1.875-.188 1.281-.313q1.938-#r#688-2.688z'
	    ),
	    'flickr' => array(
		'p' => '#a#M9.031 19.938q1.656 0 2.813-1.156T13 15.969t-1.156-2.813T9.031 12t-2.813 1.156-1.156 2.813 1.156 2#r#813 1.156zm9.938 0q1.656 0 2.813-1.156t1.156-2.813-1.156-2.813T18.969 12t-2.813 1.156T15 15.969t1.156 2#r#813 1.156z'
	    ),
	    'adn' => array(
		'p' => 'M15.5 10.5l4.063 6.125h-8.125zM31 16q0 6.438-4.531 10.969T15.5 31.5 4.531 26.969 0 16 4.531 5.031 15.5.5t10.969 4.531T31 16zm-6.25 5.188L15.5 7.25 6.25 21.188h1.875l2.125-3.25h10.5l2.125 3.25h1.875z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'bitbucket' => array(
		'p' => 'M1 2h29.375q.188.063.344.156t.281.25.188.344 0 .375l-4.25 26.063q-.125.875-1 .813H5.563q-.25 0-.469-.063t-.375-.219-.281-.375-.188-.469L0 3.125v-.188q0-.375.313-.656T1.001 2zm17.875 18.563l1.563-9.188h-9.813l1.75 9.188h6.5z',
		'w' => .974609375,
		'vw' => 31
	    ),
	    'tumblr' => array(
		'p' => 'M19.375 30q-.75.813-2.406 1.406T13.25 32q-2.625 0-4.563-.875t-2.875-2.313-1.344-2.813-.406-2.813v-9H1.124q-.625 0-.625-.625v-4.25q0-.75.688-1 2.625-.875 3.875-2.938T6.5.998q.063-1 1-1h4.375q.625 0 .625.625v7.188h5.25q.625 0 .625.625v5.125q0 .625-.625.625H12.5v8.313q0 1.688 1.094 2.344t3.156-.094q.563-.25.813-.125.313.063.438.5l1.375 4q.25.625 0 .875z',
		'w' => .623046875,
		'vw' => 20
	    ),
	    'tumblr-square' => array(
		'p' => '#a#m-5.125 22.75q.125-.125 0-.563l-.875-2.5q-.063-.25-.25-.313t-.5.063q-1.313.5-2 .094t-.688-1.469v-5.188h3.25q.375 0 .375-.375v-3.25q0-.375-.375-.375h-3.25v-4.5q0-.375-.375-.375h-2.75q-.563 0-.625.625-.25 3.5-3.313 4.563-.438.188-.438.625V14.5q0 .375.375.375h1.875V20.5q0 .875.25 1.75t.844 1.75 1.781 1.438 2.875.563q2.625 0 3.813-1.25z'
	    ),
	    'apple' => array(
		'p' => 'M19.688 16.813q0 3.938 3.813 5.75-.75 2.375-2.563 4.875t-3#r#563q-.875 0-2.313-.563t-2.5-.563-2.531.563-2.156.563q-1.375.063-2.906-1.5t-2.438-3.25-1.406-3.063Q0 19.563 0 17.125 0 13.187 2.156 11t5.031-2.25q.938 0 2.688.625T12 10q.188 0 2.188-.688t3.313-.625Q21.064 9 22.814 11.5q-3.188 1.875-3.125 5.313zM16.125 6.5q-2 2.375-4.313 2.188-.25-2.5 1.563-4.5.75-.875 1.938-1.5T17.626 2q.188 2.5-1.5 4.5z',
		'w' => .734375,
		'vw' => 24
	    ),
	    'windows' => array(
		'p' => 'M0 5.875L11.5 4.25v11.125H0v-9.5zm0 20.25V16.75h11.5v11zm12.75 1.75V16.75H28V30zm0-23.75L28 2v13.375H12.75V4.125z'
	    ),
	    'android' => array(
		'p' => 'M5.625 12.75V20q0 .75-.5 1.25t-1.25.5-1.313-.5T1.999 20v-7.25q0-.688.563-1.188t1.313-.5q.688 0 1.219.5t.531 1.188zm.625 9.875v-11.25h15.5v11.25q0 .75-.563 1.281t-1.313.531h-1.25v3.813q0 1.125-.875 1.563t-1.719 0-.844-1.563v-3.813h-2.375v3.813q0 1.063-.844 1.531t-1.719.031-.875-1.563v-3.813h-1.25q-.75 0-1.313-.531t-.563-1.281zm15.5-11.875H6.187q0-.75.188-1.531t.531-1.438T7.75 6.5t1.125-1.094 1.313-.844L9 2.374q-.188-.25.125-.375l.25.125 1.25 2.25q3.375-1.5 6.75 0l1.25-2.25q.125-.25.313-.063.125.125.063.313l-1.188 2.188q1.813.938 2.875 2.594t1.063 3.594zM11.125 7.313q0-.25-.188-.469t-.469-.219-.469.219-.188.469.188.438.438.188q.313 0 .5-.188t.188-.438zm7.063 0q0-.25-.188-.469t-.438-.219-.469.219-.219.469q0 .188.094.344t.25.219.344.063q.25 0 .438-.188t.188-.438zm5.937 3.75q.5 0 .906.219t.688.625.281.844v7.25q0 .75-.563 1.25t-1.313.5q-.688 0-1.219-.5t-.531-1.25v-7.25q0-.688.531-1.188t1.219-.5z'
	    ),
	    'linux' => array(
		'p' => 'M13.813 7.688h-.125l-.125-.063q0-.063.063-.125.125-.063.375.063.188.063.188.156t-.188.094q-.063 0-.125-.063zm-1.375.125q-.188 0-.188-.063 0-.125.188-.188.25-.125.375 0 .063 0 .031.031t-.156.094h-.063l-.063.063-.125.063zM26.25 25.25q1 1.125 1 1.875-.063.625-.875 1.125-.313.125-1.031.469t-1.25.719-.906.813q-1.375 1.625-3.063 1.75t-2.5-1.438q-.063-.188-.125-.438-.75.063-1.906-.125T14 29.875q-.438 0-.906.094l-.781.156-.688.125-.625.063q-.438 1-1.625 1.25-1.563.375-3.5-.688-.5-.25-1.156-.375t-1.406-.219-1.125-.156q-.938-.188-1.25-.75-.313-.688.125-2 .125-.313-.063-1.313-.063-.5-.063-.75 0-.438.188-.75.313-.625 1.125-.938.875-.313 1.125-.5.063-.125.406-.594t.594-.656q-.25-1.5.375-3.313.938-2.875 3.625-6.063 1.25-1.75 1.438-4.063 0-.313-.063-1.313t-.094-1.781.219-1.844.719-1.781 1.5-1.219 2.594-.5q1.438 0 2.438.594t1.406 1.5.656 2 .219 2.156.031 1.938q-.063.875.313 1.75t.688 1.375 1.063 1.375q2.063 2.5 2.875 4.688 1.063 2.625.25 4.938l.25.125.25.188q.438.313.688 1.375.25 1 .438 1.25zM14 5.438q-.313.688-.188 1.375.5.125.813.313-.125-.563.125-1.031t.625-.469q.375.063.563.625t0 1.125q-.063 0-.25.25.563.188.75.313.938-1.063.313-2.5-.5-1-1.406-1t-1.344 1zm-2.562-.688q-.875 0-1.063 1.281T10.938 8l.375-.313-.063-.063q-.313-.313-.281-1t.406-.75q.188 0 .344.188t.219.469.063.594q.25-.188.625-.313.063-.875-.313-1.469t-.875-.594zm-.875 3.75q-.375.313-.25.813.188.5.938.938.188.125.594.469t.656.469.625.125q.625.063 1.438-.406t.938-.531q1.125-.313 1.375-1.125.313-.75-.625-1.125-.25-.125-.719-.281t-.719-.281q-.875-.563-1.625-.563t-1.688.875q-.063 0-.938.625zm.25 20.875q.063-.688-1#q#344T8.25 25.125L7 22.875q-.625-.875-1.375-1Q5 21.75 4.5 22.313q-.125.125-.406.531t-.469.594q-.375.313-1.188.625-.688.25-.938.688-.188.375-.063 1.25.188 1.125.063 1.5-.438 1.188-.188 1.688.188.375.969.5t1.906.281 1.875.531q1.5.938 3.063.688t1.688-1.813zm-.125-1.562q1.938 1.063 3.719.875t3.469-1.375q.375-1.313.375-1.813.125-1.75.313-2.5.313-1.313 1.313-1.688.188-1.75 2.375-.75 1.75.75 1.438 1.625h.313q.375-1.25-1.938-2.188.25-1.063-.063-2.25-.5-2#q#188-3.688-.25 0 .188.438.813.75 1.406 2.281t.031 3.031q-.375-.125-.688-.125-.313-1.938-1.438-4-1.563-2.875-2.375-6-.438.625-1.375.938-.125.063-.281.125t-.375.219-.344.219q-1.5.875-2.625-.063-.063-.063-.344-.313t-.469-.313q-.125-.125-.375-.313-.063.688-.219 1.469t-.5 1.594-.594 1.438-.625 1.469-.5 1.094q-.813 1.938-.875 3.875-1.5-2 .188-5.188.75-1.375.5-1.313-1.375 2.25-1.688 3.75-.313 1.188 0 2.188.375 1.125 1.563 1.875 1.563.875 2.375 2 .688.938.5 1.563-.25.563-1.063.563.625.75.875 1.25zm16.125-.75q0-.563-.875-1.563-.25-.25-.406-.813t-.281-1.063-.375-.688q-.438-.375-1.438-.313-.375.438-1.094.781t-1.281.219q-1.063-.25-1.188-1.813h-.063q-.625.313-.875 1.313-.125.688-.25 2.438 0 .188-.625 2.563-.375 1.438-.063 2.25.688 1.313 2.125 1.188 1.5-.125 2.75-1.563.563-.688 1.563-1.219t1.656-.906.719-.813zm-16-17.75q-.25-.25-.063-.438.063 0 .156.156l.094.156q.313.313.5.438.75.625 1.5.625t1.875-.625Q15 9.5 15.75 9q.125-.063.219-.219t.156-.094q.25 0-.188.375-.438.438-.938.688-1.25.625-1.938.625-.875 0-1.75-.625-.188-.188-.5-.438z'
	    ),
	    'dribbble' => array(
		'p' => '#e#10.25 7.125q-.375.5-.969 1.125t-2.406 1.938-4 2.188q.563 1.25 1.125 2.625 4.563-.625 9.25.375-.063-4.625-3-8.25zm-1.5-1.5q-2.438-2.188-5.563-2.969t-6.313-.031q2.688 3.563 4.938 7.75 2.125-.75 3.844-1.938t2.25-1.781.844-1.031zM10.375 4.063Q8.5 4.938 7 6.313T4.469 9.469t-1.406 3.844q5.875.063 12.188-1.625-2.25-4.063-4.875-7.625zM2.75 16q0 5.125 3.438 8.875Q7.251 23 8.938 21.25t3.938-3.188 4.563-2.063q-.438-1.125-1.063-2.25-6.75 2-13.625 1.875v.375zm5.125 10.438q2.875 2.313 6.5 2.75t6.813-1q-.813-4.813-2.813-10-3.813 1.25-6.594 3.594t-3.906 4.656zm15.5.562q4.813-3.25 5.688-8.875-3.938-1.25-8.25-.563 1.813 5 2.563 9.438z'
	    ),
	    'skype' => array(
		'p' => 'M26.563 18.75q1.438 1.875 1.438 4.25 0 2.875-2.063 4.938T21 30.001q-2.375 0-4.25-1.438-1.375.25-2.75.25-5.313 0-9.063-3.75T1.187 16q0-1.313.25-2.75Q-.001 11.375-.001 9q0-2.875 2.063-4.938T7 1.999q2.375 0 4.25 1.438 1.375-.25 2.75-.25 5.313 0 9.063 3.75T26.813 16q0 1.313-.25 2.75zm-12.188 5.688q2.813 0 4.906-1.406t2.094-3.969q0-3.563-5.688-4.875-.313-.063-1-.188-1.063-.25-1.5-.375t-.969-.344-.688-.469-.156-.688q0-1.375 2.625-1.375 1.25 0 2.031.5t1.375 1.031 1.281.531q.438 0 .813-.156t.594-.438.375-.625.156-.781q0-1.5-2.125-2.469t-4.844-.969-4.75 1.25-2.031 3.813q0 .688.094 1.25t.375 1 .531.75.813.625.844.5 1.063.406 1.094.313 1.281.313 1.281.281q1.063.313 1.438.406t.781.438.406.906q0 .75-.75 1.219t-1.938.469q-1.125 0-2-.438t-1.281-.969-1-.969-1.219-.438q-.875 0-1.344.531t-.469 1.344q0 1.688 2.219 2.875t5.281 1.188z',
		'w' => .873046875,
		'vw' => 28
	    ),
	    'foursquare' => array(
		'p' => 'M20.188.188q1.813 0 2.438 1t.188 3.063l-3 15.188q-.125.563-.25.813t-.406.75-.813.719-1.344.219h-5.188q-.25 0-.438.188-.125.188-8.188 9.5-.813.938-2.063.438-1.125-.438-1.125-1.875V3.066q0-1.063.781-1.969T3.124.191h17.063zm-1 4.625q.063-.438-.188-.781t-.688-.344H4.624q-.438 0-.719.344t-.281.719v21.188q0 .125.125 0l5.563-6.75q.438-.5.719-.656t.969-.156h4.563q.313 0 .531-.156t.344-.344.188-.313q.25-1.375.688-3.688.125-.438-.188-.781t-.75-.344h-5.625q-.563 0-.906-.375t-.344-.938v-.813q0-.25.094-.5t.25-.406.406-.25.5-.094h6.625q.188 0 .375-.094t.344-.188.25-.25.094-.344z',
		'w' => .71875,
		'vw' => 23
	    ),
	    'trello' => array(
		'p' => 'M24.5 2q1.438 0 2.469 1.031T28 5.5v21q0 .938-.469 1.75t-1.281 1.281T24.5 30h-21q-1.438 0-2.469-1.031T0 26.5v-21q0-1.438 1.031-2.469T3.5 2h21zM12.313 23.188V7.313q0-.688-.5-1.188t-1.188-.5H5.437q-.688 0-1.188.5t-.5 1.188v15.875q0 .5.25.875t.625.594.813.219h5.188q.688 0 1.188-.5t.5-1.188zm12.062-7V7.313q0-.688-.5-1.188t-1.188-.5h-5.063q-.438 0-.844.25t-.625.625-.219.813v8.875q0 .5.25.875t.625.594.813.219h5.063q.688 0 1.188-.5t.5-1.188z',
		'w' => .873046875,
		'vw' => 28
	    ),
	    'gratipay' => array(
		'p' => '#d#7.188 14.125q.188-.313.344-.813t.188-1.156-.344-1.344-1.063-1.188q-1.438-.688-2.469-.406t-1.781 1.156q-.75.813-1.938.844t-1.938-.844-1.813-1.156-2.5.406q-.875.625-1.188 1.625t-.125 1.719.5 1.156l7.063 9.563z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'vk' => array(
		'p' => 'M34.063 7.375q-.188.938-1.469 3.063t-2.344 3.719-1.125 1.656q-.375.563-.375.813t.375.875l.406.438.969 1 1.25 1.313 1.281 1.469 1.063 1.469.656 1.25q.438 1.563-1.25 1.563h-3.688q-.438 0-.75-.125t-.688-.438-.688-.688-.938-1.063-1.25-1.313q-2.5-2.375-3.688-2.375-.75 0-.875.438t-.125 2.5q.063 1 .063 1.625 0 .75-.5 1.094t-2.188.344q-2.938 0-5.938-1.75t-5.25-5q-2.125-2.875-3.531-5.719T1.622 9.189t-.438-2.125q0-1.063 1.25-1.063h3.688q.688 0 1.031.313t.594 1.125q1.313 3.813 3.219 6.813t2.906 3q.375 0 .531-.281t.156-1.094v-5.438q-.063-.875-.313-1.5t-.5-.906-.469-.594-.219-.563.125-.438.344-.313.469-.125h5.813q1 0 1 1.375v7.25q0 1.063.594 1.063t1.719-1.125q1.188-1.313 2.313-3.188t1.688-3.125l.563-1.188q.438-1.063 1.563-1.063h3.688q1.5 0 1.125 1.375z',
		'w' => 1.123046875,
		'vw' => 36
	    ),
	    'weibo' => array(
		'p' => 'M25.438 11.125q.375-1.125-.406-2T23.126 8.5q-.688.125-1.063-.313t-.219-1.031.781-.719q2.375-.5 3.969 1.281t.844 4.031q-.188.625-.781.719t-1-.313-.219-1.031zm-12 16.813q-5.313 0-9.375-2.375T0 19.375q0-4.188 4.75-8.938 4.5-4.5 8.25-4.75 2.75-.188 2.938 2.25.063.875-.313 2.125-.188.688.75.375 3.75-1.688 6.031-.781t1.094 3.969q-.125.438 0 .563t.5.313q4.125 1.25 3.875 4.563-.188 3.313-4.188 6-4.25 2.875-10.25 2.875zm8.968-9.157q-.281-2.594-3.25-4.188t-6.969-1.156q-4 .375-6.594 2.5t-2.344 4.719 3.219 4.188T13.437 26q4-.375 6.625-2.5t2.344-4.719zM21.75 2.188q3.125-.625 5.781.813t3.844 4.25.188 5.813q-.375 1.188-1.531.813t-.781-1.563q1.063-3.313-1.25-5.875t-5.75-1.875q-.75.188-1.188-.344t-.25-1.188.938-.844zm-4.937 19.437q-.75 1.813-2.781 2.688t-4.031.188q-1.875-.563-2.594-2.219t.094-3.344 2.688-2.5 3.75-.313q2 .5 2.844 2.094t.031 3.406zm-5.375-1.875q-.625-.25-1.313 0t-1.063.813q-.375.625-.219 1.219t.781.906 1.344.063 1.094-.875.188-1.25-.813-.875zm2.062-.812q-.563-.188-.938.313-.313.563.25.813.625.25.938-.313.313-.625-.25-.813z',
		'w' => .998046875
	    ),
	    'renren' => array(
		'p' => 'M13.375 10.563q0 5.125-2.563 9.281T4.124 26Q.499 21.687.499 16.062q0-3.813 1.688-7.094T6.812 3.53 13.375.749v9.813zM15.938 31.5Q12 31.5 8.5 29.625q2.813-1.75 4.781-4.281t2.656-5.406q.688 2.875 2.656 5.406t4.781 4.281Q19.936 31.5 15.936 31.5zM27.875 26q-2.063-.938-3.75-2.531t-2.906-3.563-1.906-4.375-.688-4.969V.749q5.5.938 9.188 5.25t3.688 10.063q0 5.625-3.625 9.938z'
	    ),
	    'pagelines' => array(
		'p' => 'M24 19.563q-.938 2.375-2.5 3.594t-3.094 1.281-2.938-.25-2.281-.813l-.875-.438q-1.938 3.875-4.969 6.125t-6.594 2.25q-.75 0-.75-.75t.75-.75q3 0 5.531-1.844t4.344-5.031q-1.188.438-2.344.563t-2.625-.156-2.844-1.688-2.313-3.844q1.938-.813 3.656-1t2.875.125 2.125.969 1.5 1.313.969 1.406q.938-2.25 1.375-5-.125.063-.313.094t-.781.031-1.188-.031-1.406-.156-1.531-.375-1.438-.75-1.281-1.125-.938-1.594-.5-2.219q2.25-.813 3.875-.625t2.719 1.063 1.75 1.844.906 1.781l.313.75q#q#125.188-3.313-.25-.188-.688-.531T11.341 9 9.966 6.75t-.313-2.813T10.997.624q2.188.813 3.375 2.125t1.344 2.656 0 2.594-.531 2l-.313.813v2.063q0-.125.125-.313t.531-.719.875-1 1.219-.969 1.563-.75 1.906-.25 2.281.438q-.063 2.313-1 3.875t-2.25 2.094-2.594.719-2.156.063l-.875-.125q-.438 2.563-1.25 4.875.188-.25.594-.625t1.594-1.094 2.375-1.063T20.716 18t3.281 1.563z',
		'w' => .75,
		'vw' => 24
	    ),
	    'stack-exchange' => array(
		'p' => 'M1.125 20.75h25.75v1.375q0 1.813-1.188 3.031t-2.875 1.219h-1.188L16.186 32v-5.625h-11q-1.688 0-2.875-1.219t-1.188-3.031V20.75zm0-1.437V14h25.75v5.313H1.125zm0-6.875V7.125h25.75v5.313H1.125zM22.813 0q1.688 0 2.875 1.25t1.188 3v1.375H1.126V4.25q0-1.75 1.188-3T5.189 0h17.625z'
	    ),
	    'vimeo-square' => array(
		'p' => '#a#m-1 9.375q.188-3.938-2.938-4-4.125-.188-5.625 4.688.938-.563 1.969-.281t.844 1.656q-.063 1-1.313 3-1.688 2.625-2.438 1.688t-1.75-7.313q-.25-1.75-.969-2.531t-1.906-.656q-.375 0-.875.25t-1.156.781-1.125.938-1.375 1.219-1.344 1.188l.938 1.188q1.313-.938 1.563-.938.438 0 .75.375t.688 1.469.656 1.969.781 2.938q.438 1.563.688 2.438 1.188 3.188 2.938 3.188 2.813 0 6.875-5.25 4-5.125 4.125-8z'
	    ),
	    'slack' => array(
		'p' => 'M5.875 19.688q0 1.25-.875 2.094t-2.063.844-2.063-.844-.875-2.063.875-2.094 2.063-.875h2.938v2.938zm1.5 0q0-1.188.844-2.063t2.063-.875 2.094.875.875 2.063v7.375q0 1.188-.875 2.063t-2.094.875-2.063-.875-.844-2.063v-7.375zm2.938-11.813q-1.25 0-2.094-.875t-.844-2.063.844-2.063 2.063-.875 2.094.875.875 2.063v2.938h-2.938zm0 1.5q1.188 0 2.063.844t.875 2.063-.875 2.094-2.063.875H2.938q-1.188 0-2.063-.875T0 12.313q0-.813.406-1.5T1.469 9.75t1.469-.375h7.375zm11.812 2.938q0-1.25.875-2.094t2.063-.844 2.063.844.875 2.063-.875 2.094-2.063.875h-2.938v-2.938zm-1.5 0q0 1.188-.844 2.063t-2.063.875-2.094-.875-.875-2.063V4.938q0-1.188.875-2.063T17.687 2q.813 0 1.5.406t1.063 1.063.375 1.469v7.375zm-2.937 11.812q1.25 0 2.094.875t.844 2.063-.844 2.063-2.063.875-2.094-.875-.875-2.063v-2.938h2.938zm0-1.5q-1.188 0-2.063-.844t-.875-2.063.875-2.094 2.063-.875h7.375q1.188 0 2.063.875t.875 2.094-.875 2.063-2.063.844h-7.375z'
	    ),
	    'wordpress' => array(
		'p' => 'M3.875 10.563l6.313 17.375q-3.375-1.625-5.438-4.844T2.687 16q0-2.813 1.188-5.438zM25 15.313q0 1.063-1 4.313l-1.375 4.438-4.75-14.313 1.5-.125q.5-.063.469-.594t-.594-.469q-2.125.125-3.5.125l-3.5-.125q-.375-.063-.531.219t-.031.563.438.281q.688.125 1.438.125l2.063 5.688-2.938 8.75L7.876 9.751l1.5-.125q.563-.063.5-.594t-.563-.469q-2.188.125-3.563.125h-.875q1.813-2.75 4.75-4.375T16 2.688q5.188 0 9 3.5h-.188q-.938 0-1.594.719t-.656 1.656q0 1 1.313 3.125Q25 13.563 25 15.313zm-8.75 1.875l4.063 11.188q.063.063.125#q#188.75-4.438.75-1.875 0-3.75-.563zm11.438-7.563q1.625 2.938 1.625 6.375 0 3.625-1.813 6.688t-4.813 4.813l4.063-11.75q1-2.5 1-4.75 0-.75-.063-1.375zM31.5 16q0 6.438-4.531 10.969T16 31.5 5.031 26.969.5 16 5.031 5.031 16 .5t10.969 4.531T31.5 16zm-.687 0q0-6.125-4.344-10.469T16 1.187 5.531 5.531 1.187 16t4.344 10.469T16 30.813t10.469-4.344T30.813 16z'
	    ),
	    'openid' => array(
		'p' => 'M17 27l-4.25 2q-5.438-.5-9.094-3.063T0 19.874q0-3.313 3.406-5.844T12 10.874v2.688q-3.438.563-5.594 2.313t-2.156 4q0 2.375 2.406 4.188t6.031 2.25V5.063L16.937 3v24H17zm11-8.812l-8.188-1#r#313-1.25Q20.25 14 17.75 13.562v-2.688q4.313.5 7.5 2.438l2.188-1.188z'
	    ),
	    'yahoo' => array(
		'p' => 'M15.75 18.25L16 32q-1.438-.25-2-.25t-2.063.25l.25-13.75q-.688-1.188-1.688-2.969t-1.75-3.094-1.75-3.031-1.844-3.125-1.844-3-2-3.031q.938.25 2.125.25 1 0 2.125-.25 2 3.563 8.438 14.125.563-.938 2.406-3.938t3.313-5.469 2.719-4.719q.938.25 2.063.25 1.188 0 2.125-.25-2.313 3.25-10.875 18.25z',
		'w' => .873046875,
		'vw' => 28
	    ),
	    'google' => array(
		'p' => 'M30.5 16.375q0 6.625-4.156 10.875T15.5 31.5q-6.438 0-10.969-4.531T0 16 4.531 5.031 15.5.5q6.063 0 10.375 4.063l-4.188 4.063q-2-1.938-4.781-2.281t-5.188.688-4.125 3.438-1.719 5.531q0 4.063 2.813 6.938t6#r#875q2.188 0 3.906-.719t2.688-1.813 1.5-2.156.719-2H15.5v-5.375h14.75q.25 1.375.25 2.625z',
		'w' => .953125,
		'vw' => 31
	    ),
	    'reddit' => array(
		'p' => 'M12.594 19.125q-.656 0-1.094-.469t-.438-1.094.438-1.094 1.094-.469 1.094.469.438 1.094-.438 1.094-1.094.469zM31.5 16q0 6.438-4.531 10.969T16 31.5 5.031 26.969.5 16 5.031 5.031 16 .5t10.969 4.531T31.5 16zm-8.25-2.562q-.875 0-1.5.625-2.25-1.563-5.375-1.688L17.438 7.5l3.5.75q0 .688.438 1.125t1.094.438 1.094-.469.438-1.094-.438-1.094-1.125-.469q-.938 0-1.375.875l-3.813-.875q-.313-.063-.438.313l-1.188 5.375q-3.125.125-5.375 1.688-.563-.625-1.5-.625-1 0-1.594.75t-.406 1.719 1.125 1.469q-.125.438-.125.938 0 2.5 2.438 4.219t5.813 1.719q1.688 0 3.219-.469t2.656-1.25 1.75-1.906.625-2.313q0-.5-.063-1 .938-.438 1.094-1.406t-.438-1.719-1.594-.75zm-4.312 7.25q.25-.25.5 0 .313.313 0 .563-1.063 1.063-3.438 1.063t-3.438-1.063q-.313-.25 0-.563.25-.25.5 0 .813#r#906.844t2.969-.844zM19.375 16q.688 0 1.125.469t.438 1.094-.438 1.094-1.094.469-1.094-.469-.438-1.094q0-.438.188-.781t.563-.563.75-.219z'
	    ),
	    'reddit-square' => array(
		'p' => 'M17.688 21.625q.313.25 0 .563-1.125 1.125-3.688 1.125t-3.688-1.125q-.313-.313 0-.563.25-.313.563 0 .875.875 3.125.875t3.125-.875q.313-.313.563 0zM12 18.25q0 .688-.5 1.156t-1.188.469-1.156-.469-.469-1.156.469-1.188 1.156-.5 1.188.5.5 1.188zm5.688-1.687q.688 0 1.156.5t.469 1.188-.469 1.156-1.156.469-1.188-.469-.5-1.156.5-1.188 1.188-.5z#b#m-6.25 8.813q-.875 0-1.563.625-2.438-1.688-5.813-1.75l1.188-5.313 3.688.875q0 .438.25.813t.625.594.813.219q.688 0 1.188-.469t.5-1.156-.5-1.188-1.188-.5q-1 0-1.5.938l-4.125-.938q-.313-.063-.438.313l-1.25 5.813q-3.375.125-5.75 1.813-.688-.688-1.625-.688-1.125 0-1.781.813t-.438 1.844 1.219 1.531q-.125.5-.125 1.063 0 2.625 2.625 4.5T14 25.44q3.688 0 6.281-1.875t2.594-4.5q0-.625-.125-1.063 1-.5 1.219-1.531t-.438-1.844-1.781-.813z'
	    ),
	    'stumbleupon-circle' => array(
		'p' => '#e#0 11.125q.438 0 .781.313t.344.75v1.313l1.438.625 2.125-.625v-1.438q0-1.875-1.375-3.219T16 8t-3.313 1.313-1.375 3.188v6.75q0 .5-.313.813t-.781.313-.781-.313-.313-.813v-2.813H5.499v2.875q0 1.938 1.375 3.313t3.313 1.375 3.313-1.344 1.375-3.281v-6.688q0-.438.344-.75t.781-.313zm10.5 7.688v-2.875h-3.625v3q0 .438-.313.75t-.781.313-.781-.313-.313-.75V16.5l-2.125.625-1.438-.688v2.938q0 1.938 1.375 3.281T21.812 24q1.25 0 2.344-.625t1.719-1.719.625-2.344z'
	    ),
	    'stumbleupon' => array(
		'p' => 'M31.438 16.625V21q0 2.875-2.063 4.938t-4.969 2.063-4.969-2.031-2.063-4.906v-4.375l2.125 1 3.25-1v4.438q0 .688.469 1.156t1.156.469 1.188-.469.5-1.156v-4.5h5.375zM17.375 13v-1.938q0-.688-.469-1.188t-1.188-.5-1.188.5-.469 1.188v10q0 2.875-2.063 4.906t-5 2.031q-2.875 0-4.938-2.063t-2.063-4.938v-4.375h5.375v4.313q0 .688.5 1.156t1.188.469q.313 0 .625-.125t.531-.344.344-.531.125-.625V10.748q0-2#r#094-4.781t4.938-1.969 4.938 2 2.094 4.813v2.25l-3.25.938z',
		'w' => .98046875,
		'vw' => 31
	    ),
	    'delicious' => array(
		'p' => 'M27.875 4.25Q28 4.563 28 5v22#n# 30H3q-.375 0-.75-.063-.688-.188-1.25-.688l-.25-.25q-.188-.25-.375-.563t-.281-.688-.094-.75v-22q0-1.25.875-2.125T3 1.998h22q.375 0 .75.125.188 0 .344.063t.344.188q.125.063.25.156t.188.156q.25.188.438.438.188.125.313.375t.188.5q.063.188.063.25zM26 27V16H14V4H3q-.438 0-.719.281T2 5v11h12v12h11q.438 0 .719-.281T26 27z'
	    ),
	    'digg' => array(
		'p' => 'M5.125 10.75V6h3.188v15.688H0V10.75h5.125zm0 8.375v-5.813H3.187v5.813h1.938zm18.563-8.375h8.313V26h-8.313v-2.563h5.125v-1.75h-5.125V10.749zm5.125 8.375v-5.813h-1.938v5.813h1.938zm-14.75 2.563V10.75h8.313V26h-8.313v-2.563h5.125v-1.75h-5.125zm3.187-8.375v5.813h1.938v-5.813H17.25zM9.563 6h3.25v3.188h-3.25V6zm0 4.75h3.25v10.938h-3.25V10.75z'
	    ),
	    'pied-piper-pp' => array(
		'p' => 'M12.813 10.906q0 .969-.563 1.688t-1.375.719q-.688 0-1.125-.25v-4.25q.438-.25 1.125-.25.813 0 1.375.688t.563 1.656zm3.312 4.219q.813 0 1.406.688t.594 1.656-.594 1.688-1.406.719q-.688 0-1.063-.25v-4.25q.438-.25 1.063-.25z#b#M11.563 15.938q1.938 0 3.281-1.469T16.188 11q0-1.375-.625-2.531t-1.688-1.813T11.562 6q-1.125 0-2.188.563H6.561v12.875l3.188-.625v-3.188q.875.313 1.813.313zm9.875 1.562q0-2.063-1.344-3.5t-3.219-1.438q-.375 0-.625.063-.375 1.188-1.188 2.063-1.375 1.438-3.25 1.563v9.75l3.25-.625v-3.188q.75.313 1.75.313 1.938 0 3.281-1.469t1.344-3.531z'
	    ),
	    'pied-piper-alt' => array(
		'p' => 'M15.25 15.375l-1.75.375-.063-.313q.188 0 .563-.125t.625-.125q.313 0 .625.188zm8.5 12.375q.188 0 .406.281t.5.781.469.875.406.906.281.594q-3.188 1.188-6.625.625l-.438-2.813q.688-.5 2.375-.875t2.625-.375zm-2.437-16.687q-.188-.25-2.469-.156t-3.719.781q.5-.938 1.625-1.375.625-.188 1.188-.625T18.751 9t.875-.969.813-.906q.25.188.531.594t.594.656.813.188v1.375h.438q4.438-1.688 6.625-3.375.5-.438.906-.75t.781-.656.594-.563.531-.625.438-.531.438-.656.406-.688.469-.844.563-.938l.125-.188q-.063 1-#r#5-2.75 5.75-9.188 7.313-.188 0-.438.063t-.5.094l-.5.063-.469.125-.406.219q.063.313.438.781t.375.594q0 .25-.438.563-1.125-1.25-1.438-1.375zM34.75 0l-.063.063zM31 23.875q.625 1 1.438 1.969t1.344 1.438 1.781 1.594q-.875.563-1.969 1.063t-2.469 1.031-2 .844q-1.125-.938-1.781-3.438t-.938-4.844-1.344-4.219-2.938-1.875q-.188.063-.313.125.125.063.25.25.125.125.406.344t.406.313.313.281l.281.281.219.281.188.313.156.344.125.438.063.469.031.625v.563q.063.813-.625 4-.438-.063-2.406.219t-2.469-.031v-1.219l.063-1.406q0-.188 1.031-1.219t1.031-1.469q-.438-.063-.813.438-.625.938-2 1.781t-2.438.844q-.375 0-1.031-.75t-1.281-1.625-1.344-1.813-1.094-1.188q-.125-.125-.5-.563-8.563 2-9.25 2-.25 0-.469-.188t-.219-.5q0-.625.563-.75l8.75-1.875q-.125-.313-.188-.5t.188-.344.406-.219.5-.125.406-.063.281-.125.281-.125q.563 0 .875.875 3-.625 3.125-.625.688 0 .75.625t-.563.75l-3.313.75v.25q0 .5 1.469 2.125t1.844 1.625q.875 0 2.156-1.438t1.281-2.313q0-.625-.406-.938t-.906-.344-.906-.188-.406-.594q0-.313.125-.625l-1.188-.375q1-1 .688-3.125 1.438-.313 2.563-.313t1.688.063.969.375.5.531.406 1.063.563 1.406l.875-.438q-.063.875-.625 1.188t-1.063.375-.5.375v.375q1.375-.063 2.594.344t2.125 1.031 1.813 1.719 1.5 1.938 1.344 2.156zM18.75 26.75h.563l.188 1.5-.75.188V26.75zm-4.312-9.375l.875-.25 1.938 3.188-1.25.875zm5.312 9.688q.438-.063 1.125-.188t1.25-.188 1.313-.063l.063.313q0 .125-.313.25t-.813.219-.969.188-.969.156-.563.063z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'drupal' => array(
		'p' => 'M20 7.188q.563.313 1.313 1t1.938 2.063 1.969 3.531.781 4.594q0 5.125-3.5 8.375t-8.375 3.25-8.5-3.406-3.625-8.469q0-2.313.813-4.438t2-3.438 2.063-2.031 1.438-1.031q2.5-1.375 3.313-2.063 1.188-.875 1.375-3.063 2 2.375 2.938 3 .688.438 2.031 1.063t2.031 1.063zm.125 20.312q.313-.313.063-.563-.125-.063-.313.063-1.188.875-3.438.875-.938 0-1.75-.219t-1.125-.406l-.313-.25q-.313 0-.469.281t.031.469q1.313 1.125 3.813.938t3.5-1.188zm-3.375-3.25q-.5.188-1.094.688t-.344.875q.188.188.75-.313.875-.688 1.688-.688.563 0 .875.188t.375.406.156.344.219.063q.375-.313.156-.813T19 24.312q-.313-.25-1.094-.25t-1.156.188zm5.75 1.063q1.438.125 2.25-2.188.938-2.625-.063-3.938-.438-.5-1.188-.5-.625 0-2.531 1.313t-2.594 1.313q-.625 0-1.688-.75t-2.406-1.531-2.656-.781q-1.5 0-2.594.813t-1.531 1.875-.219 2.188 1.094 1.75q1.188.875 2.781.563t2.844-1.031 2.563-1.469 1.875-.688q.625 0 2.125 1.531t1.938 1.531z'
	    ),
	    'joomla' => array(
		'p' => 'M.063 5.75q0-1.563 1.094-2.656T3.751 2q1.438 0 2.469.906t1.281 2.219q3.375-.75 6 1.875l-2.75 2.75q-1.063-.875-1.938-.875t-1.531.688-.656 1.625.625 1.625l6.25 6.25-2.75 2.75q-3.188-3.125-4.219-4.188t-2.031-2.063q-1.25-1.188-1.656-2.875t.094-3.313q-1.25-.25-2.063-1.281T.063 5.749zM8.125 13q5.375-5.313 6.25-6.188 1.188-1.25 2.875-1.656t3.25.094q.188-1.375 1.25-2.313t2.5-.938q1.5 0 2.594 1.094t1.094 2.656q0 1.438-.938 2.469t-2.313 1.281q1 3.5-1.813 6.313l-2.75-2.813q.938-1 .938-1.875t-.688-1.563-1.625-.688-1.625.688l-6.25 6.25zm16.625 9.563q1.375.188 2.313 1.219t.938 2.469q0 1.563-1.094 2.656t-2.656 1.094q-.875 0-1.656-.406t-1.313-1.094-.719-1.5q-1.563.5-3.344.063t-3.031-1.813l2.75-2.75q1 .875 1.875.875t1.563-.688.688-1.625-.688-1.625l-6.25-6.25 2.813-2.75q5.688 5.688 6.188 6.25 2.5 2.5 1.625 5.875zM19.5 19.25l-6.188 6.188q-2.5 2.5-5.938 1.625-.188.875-.688 1.531t-1.281 1.031T3.749 30q-1.563 0-2.656-1.094T-.001 26.25q0-1.313.813-2.344t2.063-1.281Q2 19.187 4.75 16.437L7.5 19.25q-.875 1-.875 1.875t.625 1.563q.688.688 1.656.688t1.594-.688q5.563-5.5 6.25-6.25z'
	    ),
	    'behance' => array(
		'p' => 'M14.5 14.813q4.063 1.125 4.063 5.625 0 3#q#25 4.813t-5.563 1.625H0V4.688h10.438q7.063 0 7.063 5.5 0 3.188-3 4.625zM4.875 8.5v5.188h4.938q2.938 0 2.938-2.688 0-2.5-3.313-2.5H4.875zm5.188 14.625q3.625 0 3.625-2.938 0-3.188-3.5-3.188H4.875v6.125h5.188zM32.5 8.063h-9V5.875h9v2.188zm3.5 11q0 .313-.063.813H24.374q0 2 1.031 3.063t2.906 1.063q.688 0 1.406-.25t1.313-.719.781-1.156h3.875q-1.75 5.375-7.5 5.375-3.75 0-5.969-2.313t-2.219-6.063q0-3.688 2.281-6.094t5.906-2.406 5.719 2.5 2.094 6.188zm-11.625-1.938h7.188q-.313-3.438-3.5-3.438-1.563 0-2.563.938t-1.125 2.5z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'behance-square' => array(
		'p' => 'M11.625 18.313q0 1.563-1.938 1.563H6.874v-3.25h2.875q1.875 0 1.875 1.688zm-.437-5.125q0 1.438-1.625 1.438H6.875v-2.813h2.5q1.813 0 1.813 1.375zm8.25 1.437q1.75 0 1.938 1.875h-3.938q.063-.875.594-1.375t1.406-.5z#b#m-11 6.563h4.875v-1.188H17v1.188zm-2.687 6.875q0-2.563-2.188-3.188 1.625-.813 1.625-2.313 0-3-3.875-3H4.25v12h5.813q1.813 0 3.031-.875t1.219-2.625zm9.437-.938q0-2-1.125-3.344t-3.094-1.344-3.219 1.313-1.25 3.313q0 1 .313 1.844t.875 1.438 1.406.938 1.844.344q3.125 0 4.125-2.938H21.5q-.188.5-.75.813t-1.125.313q-2.125 0-2.125-2.188h6.25v-.5z'
	    ),
	    'steam' => array(
		'p' => 'M31 16q0 4#q#063 7.781t-5.656 5.656T15.5 31.5q-5.313 0-9.438-3.156t-5.5-8.094L6.5 22.688q.313 1.5 1.5 2.5t2.813 1q1.813 0 3.125-1.344t1.25-3.219l5.25-3.75q2.5.063 4.25-1.688t1.75-4.188-1.719-4.125-4.125-1.688-4.125 1.688-1.719 4.125v.063l-3.688 5.375q-1.5-.063-2.75.75l-8.313-3.438q.5-6 4.938-10.125T15.5.499q6.438 0 10.969 4.531T31 15.999zM9.75 24q.938.375 1.844 0t1.313-1.313 0-1.844-1.281-1.281l-2-.813q1.25-.5 2.438 0 1.25.563 1.813 1.813.5 1.25-.031 2.5t-1.781 1.781-2.563.031q-1.125-.5-1.688-1.625zm10.844-8.125q-1.594 0-2.75-1.125T16.688 12t1.156-2.75 2.75-1.125 2.75 1.125T24.5 12t-1.156 2.75-2.75 1.125zm0-.937q1.219 0 2.063-.875T23.501 12t-.844-2.063-2.063-.875-2.063.875T17.687 12t.844 2.063 2.063.875z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'steam-square' => array(
		'p' => 'M11.563 22.281q.375-.844.031-1.719t-1.219-1.25l-1.875-.75q1.125-.438 2.25 0 1.188.5 1.688 1.688t0 2.375-1.688 1.656-2.375-.031q-1.063-.438-1.563-1.5l1.813.75q.875.375 1.719 0t1.219-1.219zM25 2q1.25 0 2.125.875T28 5v22#n# 30H3q-1.25 0-2.125-.875T0 27v-7.063l5.563 2.313q.188.938.75 1.688t1.438 1.188 1.875.438q1.688 0 2.906-1.25t1.156-3.063l4.938-3.5q2.313.063 3.969-1.563t1.656-3.938q0-2.25-1.594-3.844t-3.875-1.594-3.875 1.594-1.594 3.844v.063l-3.5 5.063q-1.375-.125-2.5.688l-7.313-3V5.001q0-1.25.875-2.125T3 2.001h22zm-6.25 13.875q-1.5 0-2.563-1.063t-1.063-2.563 1.063-2.563 2.563-1.063 2.594 1.063 1.094 2.563-1.094 2.563-2.594 1.063zm0-.875q1.188 0 1.969-.813t.781-1.938-.781-1.938-1.938-.813-1.969.813-.813 1.938q0 .75.375 1.375t1 1 1.375.375z'
	    ),
	    'spotify' => array(
		'p' => '#d#6.313 22.813q.375 0 .656-.281t.281-.656q0-.688-.625-1.063-6-3.563-14.813-1.625-.813.188-.813 1.063 0 .375.25.656t.688.281q.125 0 .75-.125 7.75-1.625 12.938 1.5.375.25.688.25zm1.687-4.125q.5 0 .844-.344t.344-.844q0-.813-.688-1.25-4.813-2.813-11.063-2.813-3.125 0-6.125.813-1 .313-1 1.313 0 .5.375.844t.875.344q.125 0 .75-.125 3.938-1 7.906-.469t6.969 2.281q.5.25.813.25zm1.938-4.75q.563 0 1-.406t.438-1.031q0-.938-.813-1.438-5.125-3-12.813-3-4.125 0-7.375 1-1.063.313-1.063 1.438 0 .625.406 1.063t1.031.438q.188 0 .813-.125 3.75-1.125 9-.625t8.563 2.438q.375.25.813.25z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'deviantart' => array(
		'p' => 'M20 5.813l-6.125 11.188.438.625h5.688v8H9.938l-.813.563-2.75 5.25-.563.563H-.001v-5.813l5.813-11.25-.438-.563H-.001v-8h9.75l.875-.563 2.688-5.25.563-.563H20v5.813z',
		'w' => .625,
		'vw' => 20
	    ),
	    'soundcloud' => array(
		'p' => 'M6.938 16l.375 4.063-.375 4.313q0 .25-.25.25t-.25-.25l-.375-4.313L6.438 16q0-.25.25-.25t.25.25zm1.375-2.812q.313 0 .313.313l.313 6.563-.313 4.313q0 .313-.313.313T8 24.377l-.313-4.313L8 13.501q0-.313.313-.313zm1.562-1.5q.375 0 .375.313l.313 8.125-.313 4.25q0 .313-.375.313-.313 0-.313-.313l-.313-4.25.313-8.125q0-.313.313-.313zm-9.437 6q.125 0 .188.188l.313 2.188-.313 2.188q-.063.188-.188.188t-.125-.188L0 20.064l.313-2.188q0-.188.125-.188zm1.5-1.375q.125 0 .188.188l.438 3.563-.438 3.563q-.063.125-.188.125-.188 0-.188-.188l-.375-3.5.375-3.563q0-.188.188-.188zm1.562-.688q.188 0 .188.188l.438 4.25-.438 4.125q0 .188-.188.188t-.188-.188l-.375-4.125.375-4.25q0-.188.188-.188zm1.594-.125q.219 0 .219.188l.438 4.375-.438 4.25q0 .25-.219.25t-.219-.25l-.375-4.25.375-4.375q0-.188.219-.188zm15.094-6.937q.25.125.25.438l.25 11.125-.25 4q0 .5-.5.5-.563 0-.563-.5l-.25-4 .25-11.063V9q0-.25.188-.438.125-.125.375-.125.125 0 .25.125zM18.5 9.5q.25.125.25.438l.188 10.188-.188 3.625v.438q0 .188-.188.313-.125.188-.313.188-.25 0-.438-.188-.063-.125-.063-.313l-.188-4.125.125-10.063.063-.063q0-.313.188-.438.188-.063.313-.063t.25.063zm-6.969 1.438q.344 0 .406.375l.313 8.75-.313 4.188q-.063.375-.375.375-.375 0-.375-.375l-.313-4.188.313-8.75q0-.375.344-.375zm23.532 3.875q2.063 0 3.5 1.469t1.438 3.469q0 2.063-1.438 3.5t-3.5 1.438H21.438q-.563-.063-.563-.625V8.501q0-.438.5-.625 1.5-.563 3.125-.563 3.438 0 5.906 2.281t2.781 5.656q.938-.438 1.875-.438zm-18.5-3.75q.438 0 .438.5l.25 8.563-.25 4.063q0 .5-.438.5-.5 0-.5-.5l-.188-4.063.188-8.563q0-.5.5-.5zm-3.375-.5q.375 0 .438.438l.25 9.063-.25 4.188q-.063.438-.438.438t-.375-.438l-.25-4.188.25-9.063q0-.438.375-.438zm1.687.25q.438 0 .438.438l.25 8.813-.25 4.188q0 .438-.438.438t-.438-.438l-.25-4.188.25-8.813q0-.438.438-.438z',
		'w' => 1.248046875,
		'vw' => 40
	    ),
	    'vine' => array(
		'p' => 'M24 15.938v3.25q-1.688.375-3.25.375-1.563 3.25-4.031 6.125t-3.781 3.625-2.688-.063q-.688-.375-1.531-1.125t-2#q#594-2.5-4#q#281-6.281T0 6.437h4.625q.813 6#r#656 11.156t4.531 7.656q2.813-2.75 4.75-6.625-2.313-1.188-3.656-3.625t-1.344-5.5q0-3.125 1.719-5.156t4.656-2.031q2.5 0 4 1.281t1.813 3.156.125 3.688-.813 3.188q-.375.063-.875.125t-1.563-.25-1.563-1.125q.5-1.688.5-3.063 0-2.875-1.75-2.875-.875 0-1.406.813t-.531 2.313q0 3.625 2.375 5.406t5.75.969z',
		'w' => .75,
		'vw' => 24
	    ),
	    'codepen' => array(
		'p' => 'M31.375 10q.625.375.625 1.125v9.75q0 .75-.625 1.125L16.75 31.75q-.75.5-1.5 0L.625 22Q0 21.625 0 20.875v-9.75q0-.75.625-1.125L15.25.25q.75-.5 1.5 0zm-14-6.062v6.438l5.938 3.938 4.813-3.188zm-2.75 0l-10.75 7.188 4.813 3.188 5.938-3.938V3.938zM2.75 13.688v4.625L6.188 16zm11.875 14.375v-6.438l-5.938-3.938-4.813 3.188zM16 19.25L20.875 16 16 12.75 11.125 16zm1.375 8.813l10.75-7.188-4.813-3.188-5.938 3.938v6.438zm11.875-9.75v-4.625l-3.438 2.313z'
	    ),
	    'jsfiddle' => array(
		'p' => 'M31.938 14.813q2.125 1.188 3.094 3.313t.406 4.375q-.25 1.188-.875 2.188t-1.5 1.719-2 1.125-2.375.406q-2.188.063-15.75.063-4.625 0-5.688-.063-2.25-.063-4.094-1.5T.687 22.876q-.688-2.188.031-4.281t2.531-3.531q.375-.25.313-.563-.375-3.063 2.063-4.813Q8 7.938 10.938 9.125l.5.25q1.563-2.563 4.063-4 2.125-1.188 4.531-1.344t4.531.625 3.844 2.469 2.531 4q.25.563.563 3.063.063.5.438.625zm1.312 9.812q1.813-2.25 1.156-5t-3.344-4q-.625-.313-.625-1-.063-1.875-.719-3.563t-1.719-2.844-2.531-1.938-3.031-1.063-3.25 0-3.125 1.094q-2.5 1.375-3.813 3.875-.125.25-.25.375t-.281.125h-.219l-.313-.156-.313-.219q-2.375-1.25-4.5#q#188 1.5-1.688 3.938.188.938-.625 1.438-1.813 1#q#406 3.25t.281 4q1.688 3.75 5.938 3.75 10.25.125 10.25 0h10.625q2.688-.063 4.5-2.25zm-5.5-5q-.25 1.438-1.469 2.438t-2.719 1q-1.563 0-2.75-1.125-.5-.438-2.781-2.813t-3.219-3q-1.875-1.438-3.75.25-.875.75-1.063 1.781t.281 1.875 1.219 1.438 1.781.563 1.969-.844q.125-.125.375-.406t.438-.406q.375-.313.75-.094t.063.781q-.813 1#q#188 1.719t-2.75.094-2.219-1.625-.844-2.75q#q#375 2.25-3.5 2.313-1.313 4.188.125 1.625 1.25 3.688 3.5t3 2.813q1.188.75 2.406.438t1.906-1.5q.625-1.125.375-2.281t-1.125-1.813-2-.781-2.188.938q-.063.063-.313.344t-.375.344q-.5.313-.781 0t-.031-.625q2.125-2.938 5.188-1.75 1.5.5 2.25 1.875t.438 3z',
		'w' => 1.123046875,
		'vw' => 36
	    ),
	    'rebel' => array(
		'p' => 'M16 31.5q-6.438 0-10.906-4.688T.813 15.624q.125-3.75 2-7.031t5.313-5.469h.063q-.25.25-.844 1.031T5.97 6.53 4.845 9.811t.188 3.75 2.281 3.75q.625.625 1.281.969t1.188.406 1.031-.031.875-.281.656-.406.406-.344l.188-.188q.5-.625.75-1.406t.281-1.5-.063-1.469-.25-1.375-.344-1.094T13 9.873l-.125-.313q-.25-.688-.969-1.313t-1.281-.875L10 7.059l1.813-2q.438.188.875.5t.75.656.563.625.375.469l.125.188q.063-.813-.281-1.781t-.719-1.531l-.375-.5L15.939.497l2.75 3.125q-.563.813-.906 1.781t-.406 1.531v.625q.125-.313.375-.594t.5-.531.531-.469.5-.375.406-.281.25-.188l.125-.063 1.813 2q-.813.25-1.5.875t-1.063 1.125l-.313.5q-.5 1-#r#344t-.125 2.938 1 2.656q.375.625.906.906t1.031.313 1.031-.094.969-.344.781-.406.531-.375l.188-.125q1.813-1.625 2.406-3.656t.156-3.813-1.125-3.313-1.375-2.406l-.688-.875q.063-.125.063-.188 1.563 1.125 2.5 1.969t2.188 2.375T30.5 11.12t.688 4.813q.063 6.813-4.188 11.188t-11 4.375z'
	    ),
	    'empire' => array(
		'p' => 'M18 3.375q-1-#q#125-.188V1.999q3.625.125 6.656 1.906t4.906 4.781l-1 .563q-.625-1-1.25-1.688l-1.125.938q-2.563-2.875-6.375-3.625zM3.313 20.125q.438 1.063.875 2l-1 .563Q1.5 19.563 1.5 16t1.688-6.625l1 .563q-.5.938-.875 1.938l1.438.438q-.625 1.75-.625 3.688 0 1.875.625 3.688zm10 7l-.313 1.5q1.188.188 2.125.188v1.188q-3.625-.125-6.688-1.906t-4.875-4.781l1-.563q.5.813 1.25 1.688l1.125-1q2.563 2.938 6.375 3.688zm-7.5-19.562q-.625.688-1.25 1.688l-1-.563q1.875-3 4.906-4.781t6.656-1.906v1.188Q14 3.189 13 3.377l.313 1.5q-3.813.75-6.375 3.625zm19.375 16.875q.75-.875 1.25-1.688l1 .563q-1.813 3-4.875 4.781T15.875 30v-1.188q.938 0 2.125-.188l-.313-1.5q3.813-.75 6.375-3.688zM31 16q0 6.438-4.531 10.969T15.5 31.5 4.531 26.969 0 16 4.531 5.031 15.5.5t10.969 4.531T31 16zm-.75 0q0-6.125-4.313-10.438T15.499 1.249 5.061 5.562.748 16t4.313 10.438 10.438 4.313 10.438-4.313T30.25 16zm-2.437-6.687q1.688 3.125 1.688 6.688t-1.688 6.625l-1-.563q.5-.875.875-1.938l-1.438-.438q.625-1.813.625-3.688 0-1.938-.625-3.688l1.438-.438q-.375-1-.875-2zM16.375 20.438l.813 4.188q-.875.188-1.688.188t-1.688-.188l.813-4.188q-1.563-.313-2.5-1.438l-3.25 2.75q-1.125-1.313-1.688-2.875l4-1.375q-.188-.75-.188-1.5t.188-1.5l-4-1.375q.563-1.563 1.688-2.875l3.25 2.75q1-1.125 2.5-1.438l-.813-4.188q.75-.188 1.688-.188.875 0 1.688.188l-.813 4.188q1.5.313 2.5 1.438l3.25-2.75q1.125 1.313 1.688 2.875l-4 1.375q.188.75.188 1.5t-.188 1.5l4 1.375q-.563 1.563-1.688 2.875L18.875 19q-1 1.125-2.5 1.438z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'git-square' => array(
		'p' => 'M8.75 21.75q1.875 0 1.875 1.125 0 1.188-1.688 1.188-1.938 0-1.938-1.125 0-1.188 1.75-1.188zM7.188 14.5q0-1.063.688-1.469t1.375 0 .688 1.469q0 1.5-1.313 1.5-1.438 0-1.438-1.5z#b#m-15.062 5.875q-1.375.5-2.438.5-1.813-1.063-3.75-.094T4.812 14.5q0 .875.531 1.813t1.344 1.188v.063q-.688.313-.719 1.375t.781 1.563v.063q-2.063.688-2.063 2.5 0 1.563 1.219 2.25t2.906.688q4.063 0 4.063-3.375 0-1.063-.719-1.656t-1.563-.75-1.531-.438-.688-.844q0-.813.875-.938.875-.188 1.563-.719t1.063-1.281.375-1.688q0-.438-.188-.938.5-.125.875-.25v-2.25zM16.5 11H14q.063.5.063 4.781T14 20.687h2.5q-.063-.625-.063-4.938t.063-4.75zm.25-3.375q0-.625-.438-1.125T15.249 6t-1.063.5-.438 1.156.438 1.125 1.063.469 1.063-.5.438-1.125zM23.313 11H21q0-1.438.063-1.875h-2.5q.063.375.063 1.875h-1.063v2.063h1.063v3.938q0 1.813.5 2.813t2.125 1q1.25 0 2.063-.438v-2.188q-.563.375-1.313.375-1 0-1-1.438v-4.063h2.313v-2.063z'
	    ),
	    'git' => array(
		'p' => 'M1.188 13.875q0-2.063 1.313-3.469t3.063-1.563 3.563.656q1.5 0 3.375-.688v3.125q-.563.188-1.25.375.25.688.25 1.313 0 1.938-1.125 3.344t-3.063 1.781q-1.25.25-1.25 1.313 0 .813 1 1.219t2.188.594 2.156 1.031.969 2.344q0 4.75-5.625 4.75-2.375 0-4.063-.969t-1.688-3.156q0-2.563 2.813-3.5v-.063q-1.125-.75-1.063-2.219t1-1.906v-.063q-1.125-.375-1.844-1.688t-.719-2.563zm5.437 10.25q-2.438 0-2.438 1.625 0 1.563 2.688 1.563 2.375 0 2.375-1.688 0-1.5-2.625-1.5zM6.438 16q1.875 0 1.875-2.125 0-.875-.406-1.469t-.969-.719-1.094 0-.938.719-.406 1.469Q4.5 16 6.438 16zM27 19.125v3q-1.125.625-2.875.625-1.188 0-1.969-.406t-1.125-1.25-.469-1.688-.125-1.969v-5.563q-1.063 0-1.5.063v-3h1.5q0-2-.063-2.563h3.5q-.063.688-.063 2.563h3.188v3q-1.188-.063-3.188-.063v5.688q0 2.063 1.375 2.063 1.063 0 1.813-.5zM17.875 4.281q0 .906-.625 1.594t-1.5.688q-.563 0-1.063-.313t-.781-.844-.281-1.094q0-.938.625-1.625t1.5-.688q.938 0 1.531.688t.594 1.594zM17.5 8.938q-.125.688-.094 6.719t.094 6.906H14q.125-.875.125-6.875T14 8.938h3.5z'
	    ),
	    'hacker-news' => array(
		'p' => 'M0 2h28v28H0V2zm14.938 15.688L20.001 8h-2.188q-1.5 2.813-2.219 4.281t-1.063 2.344-.469 1.25q-.125-.313-.406-1t-.5-1.219-.938-2.031T10.312 8H7.999l5 9.563v6.438h1.938v-6.313z'
	    ),
	    'tencent-weibo' => array(
		'p' => 'M4.5 31q.063.938-.844 1t-.969-.813q-.563-5.938 1.156-10.969t5.156-8.594q-.75-1.688.25-3.281t2.938-1.594q1.375 0 2.406 1.031t1.031 2.469q0 2.063-1.844 3.031t-3.594-.219q-6.688 7.188-5.688 17.938zM12 0q4.313 0 7.375 3.063t3.063 7.375q0 4.875-3.844 8.031t-8.906 2.094q-.938-.25-.719-1.125t1.094-.688q3.875 1 7.188-1.563t3.313-6.75q0-3.563-2.5-6.063t-6.063-2.5q-2.313 0-4.25 1.125t-3 2.906-1.281 4 .906 4.406q.25.5-.063.938t-.813.438-.75-.563q-1.438-2.5-1.156-5.188t1.5-4.906 3.625-3.625T12-.001z',
		'w' => .748046875,
		'vw' => 24
	    ),
	    'qq' => array(
		'p' => 'M27.125 26.281q-.188.031-.563-.313t-.75-.813-.719-.969-.594-.875l-.188-.313q0 1.563-.813 3.281t-2.375 3.031q.5.188.969.375t1.031.469.813.656.063.688q-.938.5-4.375.5t-5.625-.25q-2.188.25-5.594.25t-4.406-.5q-.375-.625.625-1.188t2.25-1q-1.563-1.313-2.375-3.031t-.813-3.281q-.063.063-.125.188t-.281.469-.469.656-.531.688-.531.656-.469.469-.406.125q-.188 0-.313-.594t.094-2.094.844-3.5q.438-1.563 2.5-6.625-.188-5.875 2.344-9.656t7.656-3.781q5.063 0 7.625 3.75t2.375 9.688q2.063 5.063 2.5 6.625.625 2 .844 3.5t.094 2.094-.313.625z'
	    ),
	    'weixin' => array(
		'p' => 'M24.063 10.5q-4.313 0-7.313 2.813t-3 6.813q0 1.25.375 2.5-.625.063-1.125.063-1.188 0-4.25-.563L4.5 24.251l1.188-3.688Q.813 17.125.813 12.313.813 8 4.376 5t8.625-3q4.438 0 7.969 2.438t4.281 6.125q-.563-.063-1.188-.063zm-6.5-3.312q-.75 0-1.313.406t-.563 1.094.563 1.094 1.313.406q.688 0 1.094-.406t.406-1.094-.406-1.094-1.094-.406zm-8.563 3q.688 0 1.125-.406t.438-1.094-.438-1.094T9 7.188t-1.25.406-.563 1.094.563 1.094 1.25.406zm26.188 9.75q0 3.813-4.25 7.063l.938 3-3.375-1.813q-2.5.625-3.625.625-4.375 0-7.375-2.594t-3-6.25 3-6.25 7.375-2.594q4.125 0 7.219 2.625t3.094 6.188zm-13.688-1.5q.438 0 .781-.188t.531-.469.188-.594q0-.188-.094-.406t-.281-.406-.5-.281T21.5 16q-.438 0-.813.375t-.375.813q0 .25.094.469t.25.406.375.281.469.094zm6.688 0q.438 0 .781-.188t.531-.469.188-.594q0-.438-.438-.813t-1.063-.375q-.438 0-.813.375t-.375.844.375.844.813.375z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'wechat'=>'weixin',
	    'slideshare' => array(
		'p' => 'M11.719 9.625q1.594 0 2.719 1.031t1.125 2.531-1.125 2.563-2.719 1.063T9 15.75t-1.125-2.563T9 10.656t2.719-1.031zm9 0q1.594 0 2.719 1.031t1.125 2.531-1.125 2.563-2.719 1.063-2.75-1.063-1.156-2.563 1.156-2.531 2.75-1.031zM30.5 15.25q.688-.5 1.063-.031t-.063 1.156q-2.188 2.625-6.625 4.5 1.875 6.375-1.5 9.625-2.125 2.063-4.625 1.375-2.375-.625-2.313-3.25V22.75q-.188 0-.469-.094t-.406-.094v6.063q.063 2.563-2.313 3.25-2.5.688-4.625-1.375-3.375-3.25-1.438-9.688-4.5-1.813-6.688-4.5-.438-.625-.063-1.094t1.063.031q.063 0 .219.094t.219.156V3.124q0-1.313.844-2.219t2.031-.906h22.438q.75 0 1.406.406t1.063 1.125.406 1.594v12.375zm-1.937 1.188V4.5q0-1-.25-1.625t-.781-.906-1.531-.281H6.188q-1.5 0-2.031.594t-.531 2.219v12.063q1.938 1 4 1.438t3.344.375 2.531-.063q1.188-.063 1.688.438.625.625 1.25 1.125.125-1.688 2.125-1.563 1.188 0 2.5.063t3.438-.406 4.063-1.531z'
	    ),
	    'twitch' => array(
		'p' => 'M2.5 2h24.875v17.125l-7.313 7.313h-5.438l-3.563 3.563h-3.75v-3.563H.623V6.813zm22.375 15.875V4.5H4.812v17.563h5.625v3.563L14 22.063h6.688zm-4.187-8.562v7.313h-2.5V9.313h2.5zm-6.688 0v7.313h-2.5V9.313H14z'
	    ),
	    'yelp' => array(
		'p' => 'M2.625 15l6.25 3.063q.875.438.781 1.438t-1.094 1.25l-6.688 1.625q-.688.188-1.219-.188t-.594-1q-.313-2.75.563-5.313.25-.625.844-.875t1.156 0zm2.75 15q-.563-.375-.625-1.031t.375-1.156l4.625-5.125q.688-.75 1.594-.375t.906 1.375L12 30.626q0 .625-.5 1.031t-1.188.344q-2.688-.5-4.938-2zm9.063-6.875q-.5-.875.125-1.656T16.126 21l6.563 2.125q.625.188.875.781t0 1.219q-1.188 2.438-3.313 4.188-.5.438-1.125.313t-1-.625zm9.312-8.312q.25.625-.031 1.219t-.906.781l-6.688 1.875q-.938.313-1.531-.5t-.031-1.688l3.875-5.688q.375-.563 1-.656t1.125.344q2.063 1.813 3.188 4.313zM3.813 1.875Q7.188.312 10.813 0q.625-.063 1.094.375t.469 1.063v13q0 1.125-1.063 1.406t-1.625-.656l-6.5-11.313q-.313-.5-.125-1.125t.75-.875z',
		'w' => .744140625,
		'vw' => 24
	    ),
	    'paypal' => array(
		'p' => 'M6.938 18.5q0 .25-.125.906t-.25 1.438-.25 1.688-.25 1.719-.25 1.531-.188 1.094q-.063.125-.188.125H.749q-.313 0-.563-.25t-.188-.625L3.686 2.938q.063-.5.406-.781t.844-.281q1.75 0 4-.031t3.031-.031 1.906.031 1.594.125 1.031.219 1.188.375q2.625 1.063 3.25 3.531t-.5 5.219q-1.938 5.563-8.75 5.688-.5 0-1.469-.031t-1.313 0-.875.156-.75.469-.344.906zm15.375-9q2.25 1.688 1.5 5.813-1.375 7-8.938 7h-.813l-.25.031-.188.094-.188.156-.156.219-.156.313-.063.438q-.875 5.438-.938 5.688-.188.938-1.063.938h-4q-.313 0-.5-.25t-.125-.563q.25-1.875 1.688-10.625.063-.563.688-.563h2.406l1.344-.063 1.5-.188 1.438-.344 1.5-.563 1.344-.813 1.281-1.125 1.031-1.5.906-1.906q.375-1.125.563-2.125.063-.188.188-.063z',
		'w' => .75,
		'vw' => 24
	    ),
	    'google-wallet' => array(
		'p' => 'M9.813 7.938q3.313 5.313 5.25 10.125-.75 3.125-1.938 6.188-1.563-6.188-3.5-9.313.125-.813.188-1.75t.031-1.688-.031-1.813v-1.75zm-3 4.562q.5 0 .813.375 3.438 4.75 5.188 12.125h-6.5Q4.376 18.125.626 13.312q-.188-.25-.063-.531t.438-.281h5.813zm3-5.5h6.813q7.875 10.875 8.938 23h-7.125q-.625-10.375-8.625-23zm15.75-4.25Q27.501 9.625 27.501 16q0 6.625-1.563 12.688-1.063-8.625-5.688-16.938-.375-4.625-1.625-9.125-.063-.25.063-.438t.375-.188h5.563q.75 0 .938.75z'
	    ),
	    'cc-visa' => array(
		'p' => 'M29.375 14.438q.5 2.375.563 2.813h-2.063l1-2.688.063-.156.125-.406.125-.375zM36 5v22q0 1.25-.875 2.125T33 30H3q-1.25 0-2.125-.875T0 27V5q0-1.25.875-2.125T3 2h30q1.25 0 2.125.875T36 5zM9.5 20.688l4-9.688h-2.688l-2.438 6.625-.25-1.375-.875-4.438q-.188-.75-1.188-.813h-4l-.063.188q1.438.375 2.625 1.063l2.25 8.438h2.625zm5.938 0L17.001 11h-2.5l-1.563 9.688h2.5zm8.75-3.125q0-1.625-2.125-2.688-1.438-.688-1.438-1.188.063-.813 1.5-.813.938-.063 1.813.375l.25.063.313-2.063q-1-.438-2.25-.438-1.188 0-2.156.406t-1.5 1.156-.531 1.625q-.063 1.563 2.188 2.688 1.313.625 1.313 1.188-.063.938-1.5.938-1.188 0-2.375-.5l-.313-.188-.375 2.188q1.063.5 2.813.563 1.938 0 3.156-.906t1.219-2.406zM33 20.688L31 11h-2q-.938 0-1.25.813L24 20.688h2.625q.438-1.188.5-1.438h3.25l.313 1.438h2.313z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'cc-mastercard' => array(
		'p' => 'M30.188 25.656q0 .719-.719.719t-.719-.719.719-.719.719.719zm-19.438-.718q.688 0 .688.719t-.688.719-.688-.719.688-.719zm7.344-.063q.531 0 .594.563H17.5q.063-.563.594-.563zm6.719.063q.75 0 .75.719t-.75.719q-.688 0-.688-.719t.688-.719zm6.625 1.625q.063 0 .063.063l-.063.063v.063h-.25l-.063-.063v-.125q0-.063.063-.063v-.063h.188l.063.063v.063zm-.125.062h.063V26.5h-.188v.188h.063v-.063l.063.063h.063zM36 5.063v22q0 1.25-.875 2.125T33 30.063H3q-1.25 0-2.125-.875T0 27.063v-22q0-1.25.875-2.125T3 2.063h30q1.25 0 2.125.875T36 5.063zM4 13.781q0 3.594 2.531 6.125t6.094 2.531q2.625 0 4.813-1.438Q14 18.186 14.032 13.78t3.406-7.156q-2.188-1.5-4.813-1.5-3.563 0-6.094 2.531T4 13.78zm14 6.782q3.313-2.563 3.313-6.781T18 7.001q-3.313 2.563-3.313 6.781T18 20.563zm-8.875 4.812q0-.938-.938-.938-.563 0-.813.438-.25-.438-.75-.438-.438 0-.688.313v-.25h-.5v2.313h.5v-1.25l.063-.281.125-.188.156-.156.219-.063q.375 0 .469.313t.094 1.063v.563H7.5v-.906l.031-.344.063-.281.094-.188.156-.156.281-.063q.313 0 .406.313t.094 1.063v.563h.5v-1.438zm2.813-.875h-.5v.25q-.313-.313-.75-.313-.5 0-.813.344t-.313.875.313.875.813.344.75-.375v.313h.5V24.5zm2.5 1.625q0-.563-.719-.688T13 25.124q0-.25.438-.25t.75.188l.188-.375q-.438-.375-1.156-.25t-.719.75q0 .5.719.656t.719.281q0 .313-.5.313t-.813-.25l-.25.375q.563.375 1.313.25t.75-.688zm2.187.563l-.125-.438q-.75.438-.75-.25v-1.063h.813v-.438h-.813v-.688h-.5v.688h-.5v.438h.5V26q0 .75.594.844t.781-.156zm.875-.813h1.688q0-1.438-1.063-1.438-.5 0-.813.344t-.313.844q0 .938.781 1.188t1.344-.313l-.25-.375q-.375.375-.844.281t-.531-.531zm3.688-1.375q-.625-.25-.938.25v-.25h-.5v2.313h.5V25.5q0-.5.313-.594t.438.094zm.687 1.156q0-.531.406-.688t.844.156l.25-.438q-.563-.438-1.313-.156t-.75 1.094q0 .875.781 1.156t1.281-.219l-.25-.375q-.438.313-.844.156t-.406-.688zM26 24.5h-.5v.25q-.375-.5-1.125-.219t-.75 1.094q0 .875.75 1.156T25.5 26.5v.313h.5V24.5zm2.125 0q-.625-.313-.938.25v-.25h-.5v2.313h.5V25.5q0-.438.313-.563T28 25zm2.5-.937h-.5v1.188q-.375-.5-1.125-.219t-.75 1.125.781 1.125 1.094-.281v.313h.5v-3.25zm.5-4.688v.313h.063v-.313h.063v-.063h-.25v.063h.125zm.375 7.75V26.5l-.125-.125h-.188l-.125.125v.188q0 .063.063.063.063.063.094.063h.156l.125-.125v-.063zm.25-7.812h-.125l-.063.25-.125-.25h-.063v.063l.125.25h.063l.063-.25v.25h.125v-.313zm.25-5q0-3.625-2.531-6.156t-6.094-2.531q-2.625 0-4.813 1.438 3.375 2.813 3.406 7.219t-3.406 7.219q2.188 1.438 4.813 1.438 3.563 0 6.094-2.531T32 13.815z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'cc-discover' => array(
		'p' => 'M32.5 12.25q0 .813-.938.813h-.313V11.5h.313q.938 0 .938.75zM33 2q1.25 0 2.125.875T36 5v22q0 1.25-.875 2.125T33 30H3q-1.25 0-2.125-.875T0 27V5q0-1.25.875-2.125T3 2h30zm-2.75 8.688v5.125h1V13.75h.125l1.375 2.063H34l-1.625-2.188q1.188-.188 1.188-1.438 0-.375-.094-.625t-.344-.438-.438-.281-.594-.125-.563-.031h-1.281zm-3.5 0v5.125h2.813v-.875H27.75v-1.375h1.75v-.875h-1.75v-1.125h1.813v-.875H26.75zm-4.312 0h-1.063l2.188 5.25h.5l2.25-5.25h-1.125l-1.375 3.438zm-3.469-.188q-1.156 0-1.969.813t-.813 1.969.813 1.969 1.969.813 1.969-.813.813-1.969-.813-1.969-1.969-.813zm-3.094.375q-1-.438-1.875-.25t-1.469.938-.594 1.688q0 .75.344 1.375t.906.938 1.281.375 1.406-.313v-1.188q-.875.875-1.906.438t-1.031-1.625q0-1.125 1-1.594t1.938.406v-1.188zM9.813 15q-.75 0-1.125-.625L8.063 15q.813 1.188 2.188.906t1.375-1.656q0-.625-.313-.938t-1.188-.625q-.75-.313-.75-.688 0-.438.531-.531t1.031.406l.5-.688q-.875-.813-2-.5t-1.125 1.375q0 1 1.313 1.438.688.25.875.625t-.063.625-.625.25zm-6.375.813q1.375 0 2.094-.781t.719-1.781q0-.75-.375-1.344t-1-.906-1.438-.313H2v5.125h1.438zm4.25 0v-5.125h-1v5.125h1zM34 27.063V18q-3.188 2-10.781 5.281T8 28h25.063q.375 0 .656-.281t.281-.656zM4.625 12q.563.438.563 1.25t-.563 1.313q-.438.375-1.375.375H3v-3.375h.25q.938 0 1.375.438z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'cc-amex' => array(
		'p' => 'M20.313 10.5q0 .875-.75 1.125.688.25.688 1.188v.813h-1v-.813l-.063-.281-.156-.25-.281-.156-.438-.063h-1.125v1.563h-1V9.313h2.438q1.688 0 1.688 1.188zm-1.813.688q.688 0 .688-.5 0-.438-.688-.438h-1.313v.938H18.5zm-1.062 5.625q1.75 0 1.75 1.375 0 .375-.094.656t-.313.438-.438.25-.563.125-.531.031h-1.125v1.438h-2.063l-1.25-1.438-1.313 1.438H7.373v-4.313h4.188l1.25 1.375 1.313-1.375h3.313zm-6.5 3.375l1.188-1.25-1.125-1.25H8.438v.75h2.25v.938h-2.25v.813h2.5zm4.125.562v-3.5L13.5 18.938zm2.375-2q.625 0 .625-.563 0-.5-.625-.5h-1.313v1.063h1.313zm-2-8.5H13V11h2.375v.875H13v.875h2.438v.875H12V9.312h3.438v.938zm8.375 7.688q0 .875-.688 1.188.625.25.625 1.125v.875h-1v-.75q0-.313-.094-.5t-.281-.25-.563-.063h-1.063l-.063 1.563h-1v-4.313h2.438q1.688 0 1.688 1.125zM22 18.625q.688 0 .688-.5 0-.438-.688-.438h-1.25v.938H22zm-10.812-5h-1V10.25l-1.5 3.375H7.75l-1.5-3.375v3.375H4.125l-.375-.938H1.562l-.375.938H.062l1.875-4.313h1.5l1.75 4.125V9.312h1.688L8.25 12.25 9.5 9.312h1.688v4.313zm-9.25-1.812h1.438l-.75-1.75zm29.875 9.937h2.188l.781-.031.719-.125.5-.219V27q0 1.25-.875 2.125T33.001 30h-30q-1.25 0-2.125-.875T.001 27V14.25h1.688q.125-.375.375-.938h1.188q.25.563.438.938h3.313v-.688q.063.125.313.688h1.813q.063-.125.125-.219t.094-.219.094-.25v.688h8.5v-1.563h.563q0 .688.063 1.563h4.125v-.563q.688.563 1.875.563h1.688q.125-.375.375-.938h1.188q.188.438.188.5.063 0 .094.125t.156.313h3.25v-1.375q.438.75.594.969t.281.406h2.563V8.5h-2.5v1.188q-.313-.563-.688-1.188h-2.688v1.313q-.188-.5-.563-1.313h-3.875q-1.188 0-1.938.563V8.5h-2.5v.313q-.125-.063-.219-.094t-.25-.063-.25-.063-.313-.063-.375-.031H9.005q-.313.75-.75 1.875-.125-.188-.469-.938t-.406-.938H4.505v1.313q-.313-.625-.406-.844t-.156-.469h-2.5q-.125.25-.625 1.438t-.813 1.938V4.999q0-1.25.875-2.125t2.125-.875h30q1.25 0 2.125.875t.875 2.125v10.938h-.625q-2.188 0-2.75.313v-.313h-2.188l-.625.031-.531.063-.375.094-.344.188v-.375h-4.938v.313q-.125-.063-.25-.094t-.281-.094-.375-.063-.406-.031-.594-.031h-2.781v.375q-.625-.375-1.563-.375h-3.625q-.063.125-.188.281t-.281.281-.281.313-.188.25q-.25-.313-.438-.5l-.25-.25-.125-.156-.188-.219H6.627v5.813h5.125q.375-.438 1-1.125.438.5.625.719t.375.406h3q0-.5.031-.75t.031-.688q1.438 0 2.125-.438v1.875h2.438v-1.625h.625v1.625q9.188 0 9.563-.188.063 0 .25-.125v.313zm2.25-4.062q-.563 0-.563.438 0 .313.469.344t1.094.063.875.406v1.625q-.375.563-1.438.563h-2l.063-.938h2q.5 0 .5-.375 0-.313-.406-.375t-.906-.063-.938-.313-.438-1q0-1.25 1.5-1.25h2.063v.875h-1.875zm-3.563 2.5q.563 0 .563-.375 0-.313-.438-.406t-.938-.063-.906-.281-.406-1q0-1.313 1.5-1.313h2.063v.938H30q-.563 0-.563.438 0 .25.438.313t.938.031.906.281.406 1q0 1.375-1.625 1.375h-2v-.938h2zm-2.625-2.5h-2.438v.75h2.375v.938h-2.375v.813l2.438.063v.875h-3.5v-4.313h3.5v.875zm-3.562-6.75q.063-.063.5-.063h.188l-.5 1.063q-.125 0-.188-.063t-.063-.469.063-.469zm.312-1.625h1v.938h-1.156l-.313.063-.25.156-.219.219-.094.344-.031.469q0 1.25 1 1.25H25l1.5-3.438H28l1.75 4.125V9.314h1.625l1.813 3.063V9.314h1.063v4.313h-1.5l-1.938-3.25v3.25h-2.125l-.438-.938h-2.125l-.375.938h-1.188q-2.063 0-2.063-2.125 0-2.188 2.125-2.188zm2.625.75l-.75 1.75h1.438zm-6.312-.75h1.063v4.313h-1.063V9.313z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'cc-paypal' => array(
		'p' => 'M11.625 16.125q0 .563-.375.969t-1 .406q-1 0-1-.938 0-.563.406-.969t.969-.406q1 0 1 .938zm-6.625-3q.688 0 .969.156t.156.781q-.125.875-1.375.875h-.5l.313-1.688q0-.125.188-.125h.25zm17.75 0q1.125 0 1.188.688 0 1.125-1.375 1.125h-.5l.25-1.688q0-.125.188-.125h.25zM36 5v22q0 1.25-.875 2.125T33 30H3q-1.25 0-2.125-.875T0 27V5q0-1.25.875-2.125T3 2h30q1.25 0 2.125.875T36 5zM8 13.438q0-1.75-2.125-1.75h-2.5q-.313 0-.375.313l-1 6.375q-.063.25.188.25h1.188q.313 0 .375-.375l.25-1.625q0-.125.094-.219t.25-.094h.781q1.375 0 2.125-.75t.75-2.125zm5.25.562h-1.125q-.25 0-.313.5-.438-.625-1.438-.625-1.125 0-1.938.844t-#r#031q0 .875.563 1.438t1.438.563q1 0 1.688-.75-.063.188-.063.375 0 .25.188.25H12.5q.25 0 .375-.375l.625-4q0-.25-.25-.25zm2.563 6.125l4-5.75v-.125q0-.25-.188-.25h-1.188q-.188 0-.313.188l-1.625 2.438-.688-2.375q-.125-.25-.375-.25h-1.125q-.25 0-.25.25l.313.906.656 1.875.406 1.094q-1.313 1.813-1.313 2t.188.188h1.188q.188 0 .313-.188zm9.937-6.687q0-1.75-2.125-1.75h-2.5q-.313 0-.375.313l-1 6.375q0 .25.188.25h1.313q.188 0 .25-.188l.25-1.813q.063-.125.156-.219t.219-.094h.75q1.375 0 2.125-.75t.75-2.125zM31 14h-1.125q-.25 0-.313.5-.375-.625-1.438-.625-1.188 0-1.969.844t-.781 2.031q0 .875.531 1.438t1.469.563q1 0 1.625-.75v.375q0 .25.188.25h1.063q.25 0 .375-.375l.625-4q0-.25-.25-.25zm3-2.062q0-.25-.188-.25h-1.188q-.188 0-.188.188l-1 6.5v.063q0 .188.188.188h1.063q.25 0 .313-.375zm-5.625 3.25q1 0 1 .938 0 .563-.375.969t-1 .406q-1 0-1-.938 0-.625.406-1t.969-.375z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'cc-stripe' => array(
		'p' => 'M30.75 13.813q.5 0 .813.344t.313 1.094h-2.25q0-.5.156-.844t.438-.469.531-.125zm-7.312.125q.375 0 .688.281t.5.75.188 1.031q0 .938-.375 1.531t-1 .594-1.063-.438v-3.313q.375-.438 1.063-.438zM33 2q1.25 0 2.125.875T36 5v22q0 1.25-.875 2.125T33 30H3q-1.25 0-2.125-.875T0 27V5q0-1.25.875-2.125T3 2h30zM7.625 17.563q0-1.125-.844-1.719T5.093 15t-.844-.625q0-.438.75-.438 1.125 0 2.188.563v-2.125Q6.187 12 4.999 12q-.875 0-1.563.281t-1.063.875-.375 1.344q0 1.063.844 1.625t1.688.844.844.656q0 .563-.875.563-1.063 0-2.375-.75v2.125q1.125.5 2.375.5 1.438 0 2.281-.656t.844-1.844zM11.938 14v-1.875H10.25v-1.938l-2.188.5v7.125q0 .938.656 1.594t1.656.656q1.063 0 1.563-.313v-1.75q-.188.188-.938.094t-.75-.906v-3.188h1.688zm4.625.188v-2.063q-1.25-.438-1.875.688l-.125-.688h-1.938v7.813h2.25v-5.313q.625-.813 1.688-.438zm2.75 5.75v-7.813h-2.25v7.813h2.25zm0-8.938V9.187l-2.25.438v1.813zm4.625 9.063q1.313 0 2.188-1.031t.875-3.031q0-1.875-.906-2.938T23.939 12q-.938 0-1.688.688l-.125-.563h-2V22.5l2.25-.5v-2.5q.813.563 1.563.563zM34 16.875v-.813q0-1.813-.844-2.938t-2.344-1.125q-.813 0-1.438.313t-1.063.844-.688 1.281-.25 1.625q0 1.313.5 2.219t1.313 1.344 1.875.438q1.438 0 2.5-.563v-1.813q-1 .5-2.188.5-1.625 0-1.75-1.313h4.375z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'lastfm' => array(
		'p' => 'M14.125 22.938q-.063.063-.25.219t-.75.469-1.188.563-1.719.469-2.219.219q-3.875 0-5.938-2.188t-2.063-6.375q0-4.375 2.125-6.781t6.125-2.406q1.438 0 2.594.219t1.969.563 1.531 1.063 1.156 1.25.938 1.688.719 1.844.719 2.188q.313.875.438 1.375.5 1.438 1.156 2.406t1.938 1.594 3.031.625q3.813 0 3.813-1.938 0-.375-.094-.719t-.406-.594-.563-.406-.813-.344-.875-.281-1.125-.25-1.125-.281q-4.25-1-4.25-4.75 0-2.813 1.875-4.031t4.688-1.219q5.875 0 6.313 4.625l-3.688.438q-#q#188-2.875-2.188-.813 0-1.375.219t-.875.656-.313 1.063q0 .875.438 1.375t1.625.75q.125.063 1 .25t1.031.219.938.25 1 .344.844.406.813.531.594.656.563.844.281 1.031.125 1.219q0 5.063-7.625 5.063-4.375 0-6.531-1.688t-3.156-4.688q-.188-.563-.594-1.813t-.531-1.688-.5-1.406-.625-1.281-.688-.906-.906-.781-1.094-.375-1.375-.188q-1.938 0-3.219 1.469t-1.281 4.656q0 1.688.531 3t1.531 2 2.25.688 2.438-.531 1.75-1.031l.563-.563z'
	    ),
	    'lastfm-square' => array(
		'p' => '#a#m-5.75 19.563q4.75 0 4.75-3.188 0-.375-.094-.75t-.156-.656-.344-.531-.406-.406-.5-.344l-.5-.25-.625-.188-.594-.156-.688-.156-.594-.125q-1.313-.313-1.313-1.313 0-1.25 1.625-1.25 1.688 0 1.813 1.375l2.25-.25q-.25-2.938-3.875-2.938-1.813 0-2.969.781t-1.156 2.531q0 2.313 2.688 3 .188 0 .5.063t.5.125.438.125.406.125.344.125.313.156l.25.188.188.219.125.281.063.344q0 1#q#375 1#q#875 0-3.875-2.875-.063-.188-.344-1.063t-.344-1.063-.344-.906-.406-.875-.438-.688-.563-.656-.688-.438-.875-.406-1-.188-1.25-.094q-2.5 0-3.844 1.5t-1.344 4.25q0 1.75.594 2.938t1.688 1.813T9 21.562q1.125 0 2.094-.313t1.344-.625l.375-.25-.688-2q-1.25 1.313-3 1.313-1.188 0-1.938-.969t-.75-2.594q0-2 .813-2.938t2-.938q.438 0 .844.125t.688.25.563.5.438.594.375.813.313.844.344 1.063.375 1.125q.188.688.5 1.25t.781 1.094 1.125.875 1.563.563 2.094.219z'
	    ),
	    'ioxhost' => array(
		'p' => 'M38.5 10q.625 0 1.063.438t.438 1.063-.438 1.063-1.063.438h-3.313q.313 1.438.313 3 0 6.438-4.531 10.969T20 31.502q-4.75 0-8.625-2.625t-5.688-6.875H1.499q-.625 0-1.063-.438t-.438-1.063.438-1.063T1.499 19h3.313q-.313-1.438-.313-3 0-6.438 4.531-10.969T19.999.5q4.75 0 8.625 2.625T34.312 10H38.5zm-6 6q0-1.5-.375-3H13.5q-.625 0-1.063-.438t-.438-1.063.438-1.063 1.063-.438H31q-1.625-2.938-4.563-4.719t-6.438-1.781q-5.188 0-8.844 3.656t-3.656 8.844q0 1.5.375 3h18.625q.625 0 1.063.438T28 20.499t-.438 1.063-1.063.438h-17.5q1.625 2.938 4.563 4.719T20 28.5q5.188 0 8.844-3.656T32.5 16zm-19-1.5h13q.625 0 1.063.438t.438 1.063-.438 1.063-1.063.438h-13q-.625 0-1.063-.438t-.438-1.063.438-1.063T13.5 14.5z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'angellist' => array(
		'p' => 'M21.688 13.438q2.063.5 2.75 2t.688 3.875q0 5.5-3.281 9.094t-8.656 3.594q-4.375 0-7.344-2.875t-2.969-6.438 3.188-4.438q-.5-1.375-.5-1.875 0-1.125.969-2.219t2.094-1.094q.5 0 1.25.313Q6.939 5.062 6.939 3.25q0-.688.188-1.281T7.658.938 8.533.25 9.814 0q2.313 0 5.75 10.375.125.313.188.375.063-.125.625-1.719t1.063-2.75 1.219-2.625 1.531-2.281 1.625-.813q1.25 0 1.969.875t.719 2.188q0 1.938-2.813 9.813zM19.5 6.75l-2.063 5.875 2.125.375Q22.5 4.875 22.5 3.75q0-1-.688-1-1 0-2.313 4zM8.875 3q0 1#r#875 9.313.375-.25 2.188-.063l-2.125-6.313q-1.438-4#q#438-3.875-.5.125-.5.938zM8.75 15.25q-.25 0-.531.219t-.5.531-.219.563q0 1.063 1.906 3.594t2.844 2.531q.313 0 .5-.25t.188-.5q0-.938-1.5-3.813T8.75 15.25zm11.5 11.625q1.625-1.75 2.281-4.25T23 18.312t-.813-2.313q-1-.875-3.781-1.375t-4.844-.5q-.5 0-.75.156t-.281.281-.031.438q0 2.5 7.125 2.438H20q.938 0 1.063 1.313-.5.5-1.688 1-1.188.438-1.688.813-1.188.813-1.969 2.031t-.781 2.469q0 .5.344 1.531t.344 1.594l-.125.438q-2.5-.125-2.625-3.813h-.75q.25.875-.469 1.75t-1.906.875q-1.875 0-3.406-2.031t-.219-3.406q.375.563.875 1.219t.719.938.531.594.531.406.531.094q.188 0 .469-.156t.281-.406q0-.625-1.438-2.594t-2-1.969q-.938 0-1.438 1.125t.188 3.188q1.063 2.563 3.156 4.031t4.906 1.469q4.063 0 6.813-3.063zM14.125 19q.438 1.25.563 1.563.688-.75 1.25-1.188z'
	    ),
	    'buysellads' => array(
		'p' => 'M14 9.438l2.688 10h-5.375z#b#m-4.062 20.313L18 6.688h-8L4.062 25.313H9.75l7-5.688 1.5 5.688h5.688z'
	    ),
	    'connectdevelop' => array(
		'p' => 'M34.375 15.063q.75.125.75.938 0 .75-.75.938l-3.438 5.938q.063.188.063.313 0 .75-.75.938L27 29.753q.063.125.063.25 0 .25-.125.469t-.344.344-.469.125q-.438 0-.688-.25h-6.688q-.313.313-.75.313t-.75-.313h-6.625q-.313.313-.75.313-.375 0-.656-.281t-.281-.656q0-.125.063-.375l-3.25-5.563Q5 23.941 5 23.191q0-.125.063-.313L1.625 16.94q-.75-.188-.75-.938 0-.813.75-.938L5 9.314q0-.063-.031-.094l-.031-.031q0-.625.563-.875l3.5-6.063q-.063-.188-.063-.313 0-.25.156-.469t.375-.344T9.938 1q.438 0 .688.375h6.625q.313-.375.75-.375t.75.375h6.625q.313-.375.75-.375.25 0 .469.125t.344.344.125.469q0 .125-.063.313l3.5 6q.375 0 .625.281t.25.656q0 .188-.125.438zM9.625 28.188v-4.75h-2.75zm0-5.25V19.75l-2.813 3q.063.125.063.188h2.75zm0-3.938v-5.75L6.437 10q-.188.125-.438.125l-3.25 5.625V16q0 .125-.063.25l3.5 6 .25.125zm0-6.375v-4.5l-2.75 1v.063q0 .25-.125.5zm0-5v-3.75l-2.75 4.688zM30 10.063V10l-6.125 6.375 4 4.188 2.188-10.438zM18.25 22.188l-.75.75h1.438zm-.062-.688l5-5.125-5.188-5.5-5 5.25zm.375.375l1.063 1.063h7.75l.375-1.75-4.25-4.438zM25.625 2.75l-7.313 7.75L23.5 16l6.125-6.313q-.125-.25-.125-.5v-.063l-3.625-6.25q-.063-.063-.25-.125zm-.562-.125h-.25l-10.375 3.75 3.563 3.813zm-7.688 0h-6.5L14.063 6l9.25-3.375h-4.688q-.25.313-.625.313t-.625-.313zM10.125 3v4.438l3.375-1.25-3.188-3.375q-.063 0-.125.063zm0 4.938v5.188l2.563 2.688 4.938-5.313-3.75-3.938zm0 5.812v4.75l2.25-2.375zm0 5.5v3.688h6.688l1.063-1.125-5.125-5.375zm.438 10.125h.063l5.688-5.938h-6.188v5.625l.063.063q.188.063.375.25zm8.062 0h6.563l-5.75-5.938h-2.375l-5.75 5.938h6.063q.25-.313.625-.313t.625.313zm7.5-.75l1.125-5.188h-7.188l5.625 5.75q.125-.063.188-.125zm.813-1.375l2.188-3.813h-1.375zm2.187-4.312q0-.125.063-.188l-1.063-1.125-.25 1.313h1.25zm4.125-6.75V16l.063-.313-2.875-4.938-2.188 10.25 1.313 1.375q.063-.063.25-.125z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'dashcube' => array(
		'p' => 'M20.438 6.5L26.813 0v26.688q0 2.313-1.656 3.813t-4.031 1.5H6.876q-2.375 0-4.031-1.5t-1.656-3.813V12.375q0-2.438 1.656-4.156T6.876 6.5h13.563zM9.625 26v.063h14l-3.188-3.313v-7.688q0-.563-.281-1.031t-.75-.75-.969-.281H9.624q-.813 0-1.406.625t-.594 1.438v8.938q0 .813.594 1.406t1.406.594z'
	    ),
	    'forumbee' => array(
		'p' => 'M.375 19.375Q0 17.75 0 16.125q0-5.75 4.094-9.844t9.844-4.094q1.5 0 3.063.313-5.75 2.25-10.125 6.656t-6.5 10.219zM24.938 7.5q-7.063 2.063-12.281 7.344T5.376 27.25q-1.5-1#q#813-3.063 2.063-7 7.219-12.219t12.156-7.281q1.688 1.188 3 2.813zm.937 15.813q1.125 3 2.125 6.875-3.438-.875-6.688-2.125-2.5 1.563-5.313 2 4.188-7.813 11.75-11.938-.375 2.813-1.875 5.188zm1.875-9.063q-5.313 2.188-9.375 6.313t-6.25 9.5q-1.938-.25-3.563-.938 2.125-6.5 6.938-11.406t11.25-7.031q.75 1.688 1 3.563z'
	    ),
	    'leanpub' => array(
		'p' => 'M24.188 6.938l.938 15.563h-.688q-3.5-.063-6.438 1.75-2.813-1.75-6.438-1.75-3.5 0-7.688 1.75L5.812 8.126q2.75-1.188 5.75-1.188 3.813 0 6.438 2.688 2.563-2.563 6#q#688zM35.563 28q-2.25 0-4.375-1-3.438-1.563-6.75-1.563-3.875 0-6.438 2.563-2.563-2.563-6.438-2.563-3.313 0-6.75 1.563-2.188 1-4.313 1H.436L3.061 6.187q3.875-2.188 8.313-2.188 4 0 6.625 1#r#625-1.813 6.625-1.813 4.438 0 8.313 2.188zm-2.688-2.812l-2.125-17.5q-2.938-1.313-6.313-1.313-3.875 0-6.438 2.375-2.563-2.375-6.438-2.375-3.375 0-6.313 1.313l-2.125 17.5q1.813-.75 2.844-1.125t2.563-.656 3.031-.281q3.5 0 6.438 1#r#938-1.813 6.438-1#r#188 0 3.969.5t4.469 1.563z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'sellsy' => array(
		'p' => 'M33.75 14.813q2.563.625 4.219 2.719t1.656 4.781q0 3#q#281 5.438t-5.406 2.25H8.063q-3.125 0-5.406-2.25T.376 22.313q0-2.25 1.219-4.125t3.219-2.813q-.188-.688-.188-1.438 0-1.438.688-2.625T7.22 9.406t2.656-.719q1.938 0 3.438 1.313.875-3.5 3.719-5.75T23.502 2q4.313 0 7.406 3.094t3.094 7.406q0 1.25-.25 2.313zM12.5 25.125v-6.938q0-.438-.281-.719t-.656-.281H9.625q-.438 0-.719.281t-.281.719v6.938q0 .375.281.656t.719.281h1.938q.375 0 .656-.281t.281-.656zm5.563 0v-8.25q0-.375-.281-.656t-.656-.281h-1.938q-.375 0-.656.281t-.281.656v8.25q0 .375.281.656t.656.281h1.938q.375 0 .656-.281t.281-.656zm5.625 0V14.937q0-.25-.125-.469t-.344-.344-.469-.125h-1.938q-.438 0-.719.281t-.281.656v10.188q0 .375.281.656t.719.281h1.938q.375 0 .656-.281t.281-.656zm5.437 0V11.062q0-.375-.281-.688t-.656-.313h-1.813q-.375 0-.656.313t-.281.688v14.063q0 .375.281.656t.656.281h1.813q.375 0 .656-.281t.281-.656z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'shirtsinbulk' => array(
		'p' => 'M6.25 25.625L6.5 25l1.938.875-.25.625zm2.438 1.125l.313-.625 1.875.813-.25.625zm10.812-.875L21.375 25l.25.625-1.875.875zm-8.312 1.938l.313-.625 1.875.875-.313.625zm-7.438-3.25l.313-.625 1.875.875-.25.563zM17 26.938l1.875-.813.313.625-1.938.813zm-2.5 1.125l1.938-.875.313.625-1.938.875zm7.438-3.25l1.938-.875.25.625-1.938.813zM10.625 2.938v.625H8.5v-.625h2.125zm-2.937 0v.625H5.563v-.625h2.125zm-2.938 0v.625H2.625v-.625H4.75zm8.813 0v.625H11.5v-.625h2.063zm5.937 0v.625h-2.125v-.625H19.5zm2.938 0v.625h-2.125v-.625h2.125zm-5.938 0v.625h-2.063v-.625H16.5zm8.875 0v.625H23.25v-.625h2.125zm-22.062 19v2.125h-.688v-2.125h.688zm4.375-13.5v.688H5.563v-.688h2.125zm-4.375.687v1.438h-.688V8.438H4.75v.688H3.312zm10.562 14.25q-2.375 0-4.063-1.656t-1.688-4.031 1.688-4.031 4.063-1.656 4.031 1.656 1.656 4.031-1.656 4.031-4.031 1.656zm-3-6.937q0 .938.75 1.313t1.656.313 1.656.094.75.656q0 .938-2.063.938-1.75 0-2.25-.938l-.563 1.125q1.188.75 2.938.75 1.188 0 2.188-.438t1-1.5q0-1-.781-1.438t-1.688-.375-1.688-.031-.781-.531q0-.938 1.875-.938 1.688 0 2.25.813h.063l.5-1q-1.813-.75-2.75-.75-.75 0-1.375.125t-1.156.594-.531 1.219zm-7.562-5.313v2.125h-.688v-2.125h.688zm21.375 12.938v-2.125h.688v2.125h-.688zM3.313 19.25v2.063h-.688V19.25h.688zM0 .25h28v25.375L13.875 31.75 0 25.625V.25zm26.188 24.188V7.563H1.813v16.875l12.063 5.313zm0-18.688V2.062H1.813V5.75h24.375zM3.313 13.875v2.063h-.688v-2.063h.688zm0 2.688v2.063h-.688v-2.063h.688zm7.312-8.125v.688H8.5v-.688h2.125zm14.063 10.187v-2.063h.688v2.063h-.688zm0-2.687v-2.063h.688v2.063h-.688zm-11.125-7.5v.688H11.5v-.688h2.063zm11.125 4.812v-2.125h.688v2.125h-.688zm0 8.125V19.25h.688v2.125h-.688zM16.5 8.438v.688h-2.063v-.688H16.5zm3 0v.688h-2.125v-.688H19.5zm5.188 2.125V9.125H23.25v-.688h2.125v2.125h-.688zm-2.25-2.125v.688h-2.125v-.688h2.125z'
	    ),
	    'simplybuilt' => array(
		'p' => 'M30.063 4q.688 0 1.188.469t.5 1.156v20.75q0 .688-.5 1.156T30.063 28H1.938q-.688 0-1.188-.469t-.5-1.156V5.625q0-.688.5-1.156T1.938 4h6.625q.438 0 .813.219t.594.594.219.813v2.5h11.625v-2.5q0-.688.469-1.156t1.156-.469h6.625zM9.344 22.25q1.719 0 2.938-1.219t1.219-2.938-1.219-2.938-2.938-1.219-2.938 1.219-1.219 2.938 1.219 2.938 2.938 1.219zm13.312 0q1.719 0 2.938-1.219t1.219-2.938-1.219-2.938-2.938-1.219-2.938 1.219-1.219 2.938 1.219 2.938 2.938 1.219z'
	    ),
	    'skyatlas' => array(
		'p' => 'M40 20.563q0 3.063-2.125 5.125t-5.25 2.063q-1.813 0-3.5-.688t-2.938-1.781-2.531-2.5-2.313-2.875-2.313-2.844-2.5-2.5-2.875-1.781-3.469-.656q-2.625 0-4.406 1.375t-2.188 3.313.031 3.875 2.313 3.313 4.563 1.375q4.188 0 7.875-2.625l.281-.281.406-.375.375-.281.313-.125q.313 0 .5.219t.188.469q0 .5-1.125 1.5-2 1.75-4.594 2.813t-5.094 1.063q-4 0-6.813-2.563t-2.813-6.5q0-2.625 1.281-4.781t3.469-3.344 4.813-1.188q2.063 0 3.938.656t3.25 1.719 2.75 2.438 2.438 2.844 2.281 2.844 2.375 2.438 2.594 1.75 3 .688q1.75 0 2.938-.906t1.469-2.188 0-2.563-1.438-2#q#781-.906q-.563 0-1.594.344t-1.344.344q-.375 0-.688-.281t-.313-.656.188-1.125.188-1.125q0-3.125-2.094-5.156t-5.219-2.031q-1.5 0-2.75.563T16.78 8.037t-.844.594q-.313 0-.5-.219t-.188-.531.5-.875q2.375-2.75 6.375-2.75 1.875 0 3.469.656t2.75 1.813 1#r#75.656 3.406q0 .75-.063 1.313 1.125-.313 2.25-.313 2.875 0 4.938 1.938t2.063 4.75z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'pinterest-p' => array(
		'p' => 'M12.75.375q4.563 0 7.906 2.875T24 10.688q0 2.25-.594 4.375t-1.719 3.938-3.031 2.875-4.281 1.063q-1.25 0-2.5-.594t-1.813-1.656l-.531 2.125-.438 1.781-.375 1.344-.5 1.344-.625 1.156-.875 1.438-1.156 1.625q-.188.125-.219.125t-.219-.188q-.25-3-.25-3.563 0-1.688.406-3.844t1.25-5.406.969-3.813q-.625-1.188-.625-3.188 0-3 2.313-4 1.875-.813 3 .563.563.75.563 1.875 0 1.188-.813 3.531t-.813 3.531.844 1.969 2.031.781q1.5 0 2.688-1t1.781-2.563.875-3.094.281-2.906q0-3.25-2.031-5.063t-5.344-1.813q-3.75 0-6.25 2.438t-2.5 6.188q0 1.438.719 2.813t.719 1.438q0 .5-.281 1.344T4 18.501q-1.313 0-2.656-1.938T0 11.625q0-5 3.844-8.125T12.75.375z',
		'w' => .75,
		'vw' => 24
	    ),
	    'whatsapp' => array(
		'p' => 'M23.813 6.063q4.188 4.188 4.188 9.813 0 5.75-4.125 9.813t-9.875 4.063q-3.563 0-6.625-1.688L.001 30.002l2-7.188Q.126 19.626.126 15.876q0-5.75 4.063-9.813T14.002 2t9.813 4.063zM14 27.438q4.75 0 8.188-3.406t3.438-8.156q.063-4.625-3.5-8.125-3.375-3.375-8.125-3.375T5.845 7.751t-3.406 8.125q0 3.313 1.813 6.125l.25.438-1.188 4.25 4.375-1.125.438.25q2.688 1.625 5.875 1.625zm6.313-8.688q.625.313.688.438.188.375-.25 1.688-.188.5-.969 1.031t-1.344.594q-1.625.25-4.188-.875-3.063-1.313-5.875-5.25-1.438-1.938-1.438-3.563 0-1.563 1#q#938.438-.375.938-.375h.688q.563 0 .75.563l1.063 2.563q.188.375.063.625-.25.563-.625.969t-.438.469.063.438q.875 1.625 1.906 2.438t2.781 1.688q.5.25.75-.063.813-.938 1.125-1.375.25-.375.75-.188t2.375 1.125z'
	    ),
	    'viacoin' => array(
		'p' => 'M24 2l-3 7h3v3h-4.25l-.875 2H24v3h-6.438l-5.563 13-5.563-13H-.002v-3h5.125l-.875-2h-4.25V9h3l-3-7h4l5.063 12h5.875l5.063-12h4zM12 21l1.688-4h-3.375z',
		'w' => .75,
		'vw' => 24
	    ),
	    'medium' => array(
		'p' => 'M0 2h28v28H0V2zm23.25 6.625v-.313h-5.188l-3.688 9.25-4.25-9.25H4.686v.313l1.75 2.125q.313.25.25.625v8.313q.063.438-.25.813l-2 2.375v.313h5.625v-.313l-2-2.375q-.313-.375-.25-.813V12.5l4.938 10.688h.563L17.5 12.5v8.563q0 .25-.125.375l-1.5 1.5v.313h7.375v-.313l-1.5-1.438q-.188-.188-.125-.438V10.499q-.063-.25.125-.438z'
	    ),
	    'y-combinator' => array(
		'p' => 'M28 2v28H0V2h28zM14.75 18l4.875-9.125h-2.063l-2.875 5.688q-.438.875-.813 1.688l-.75-1.688-2.813-5.688H8.123l4.75 9v5.875h1.875V18z'
	    ),
	    'optin-monster' => array(
		'p' => 'M35.813 26.313q.125.438.063.688.063 1.438-1.531 2.719t-3.031 1.344q-1.875.125-2.688-1.438-11.563.375-21.25 0-.875 1.5-2.688 1.438-1.438-.063-3.031-1.344T.063 27.001q.063-.375.125-.688-.25-.438-.188-.656t.563-.031q.25-.438.688-.875-.25-1.063.688-.563.438-.313 1-.563 0-.688.406-.719t.656.344q1-.188 1.688.375v-1.25q-.438 0-1.031-.25t-1.156-.781-.688-1.219q-.5-2.125 1.563-3 .063-.25.344-.563t.594-.438q.625-.188.875.625 1.063 0 1.313.5.188 0 .531-.031t.531-.031q-.25-.188-.5-.313-.438-.688-1.563-.75v-.125q-2.5-.063-3.438-1.125-1-1.125-.75-3.344t1.563-3.156q.375-.25.844-.063t.531.688q0 .125.031.406t.063.313.063.281.063.219.125.156.188.125.281.094.375.031.438 0q.813-.75 1.688-1.25-.688-.063-2.75.25 1.75-1.75 3.563-2.688 2.438-1.188 4.75-1.438-.813-.313-3.75-1 10.063-2.125 15.313 2.313 1.625 1.438 2.625 3.75.5.063.844.063h.594l.406-.094.25-.125.156-.281.094-.313.063-.375.031-.438q.063-.438.531-.656t.906.094q1.188.875 1.5 3 .313 2.25-.75 3.438-.938 1.063-3.375 1.125v.188q-1.188 0-1.625.688-.25.125-.5.313.188 0 .531.063t.531.063q.188-.563 1.313-.563.25-.75.875-.625.313.063.594.375t.344.625q1.313.563 1.563 1.625.125.688 0 1.375-.25 1.063-1.188 1.656t-1.688.594v1.25q.688-.5 1.688-.375.25-.375.656-.344t.406.719q.563.25 1 .563.5-.25.656-.063t.031.625q.5.5.688.875.5-.188.563.031t-.188.656zm-4.625-15.875q1.375.563 1.875 2.25.063-.625-.156-1.656t-.719-1.531q-.188-.188-.406-.25t-.344.031-.125.281q0 .5-.125.875zm-.313.437q-.25.25-.875.375 1.313 1.5.813 3.938 1.125-.25 1.625-.75.188-.25.313-.5-.125-2.5-1.875-3.063zm-1.5.438h-.75q.75 1.938.938 4 .313 0 .688-.063.313-1.125.031-2.25t-.906-1.688zM3 12.688q.5-1.688 1.875-2.25-.188-.438-.188-.875 0-.313-.25-.344t-.625.281q-.438.5-.688 1.531t-.125 1.656zm.563 1.75q.5.5 1.625.75-.438-2.438.813-3.938-.625-.125-.875-.375-1.688.563-1.875 3.063.188.313.313.5zm3 .875q.25-2.125 1.25-3.938-.313.063-.938.313l-.75.313v-.063q-.813 1.563-.375 3.313.5.063.813.063zm11.5-10.188q-1.313 0-2.406.656t-1.719 1.75-.625 2.344q0 2 1.406 3.406t3.375 1.406 3.344-1.406 1.375-3.406q0-1.938-1.375-3.344t-3.375-1.406zm7.25 10.938q-.375-.063-2.5-.063.25 1.125.375 2.625.125 1.063.375 1.063.125 0 .313-.063.688-.375 1.031-1.469t.406-2.094zm-3.375-.125h-3.563q-.063.438 0 1.438t.25 1.125q.5.25 1.594.25t1.594-.188q.188-.313.188-1.219t-.063-1.406zm-4.563 3.375q.188-.375.188-1.563t-.063-1.813h-1.156L15 15.968l-1.125.031q-.125.625-.156 1.75T14 19.187q.563.25 1.688.281t1.688-.156zm-6.625-3.188q-.313 1 .063 2t1.313 1.438q.5.25.625-.313.063-.25.125-1.5t.188-1.75q-1.063.063-2.313.125zM8.5 18.063q.313.5-.5.813 4.688 4.938 9.75 6.625 2.938-.813 5.281-2.438T28 18.813q-.625-.25-.5-.688-.25-.063-.531-.094t-.594-.063-.5-.031Q25.25 20 24 20.375q-.688.25-1.063-.5-.125-.188-.313-1-.188.438-1.5.563-1.813.125-2.75-.188-.125.375-.375.563t-.469.219-.844.094q-3.063.313-3.438-.688-.063 1.5-1.563.688-.875-.438-1.25-1.125-.313-.5-.438-1.125zM7.188 28.875q.063-.25.063-.5-.188-.813-.5-1.5t-.75-1.219T5.126 25q-1.125-.375-2.688.813T1 28.376q.313.438.75.875t.938.719 1.031.469.969.25q.875 0 1.594-.5t.906-1.313zm-.563-4.125q.938 1.688 1.063 3.25 3.313-1.938 6.625-2.938-2.688-1.438-6.125-4.813-.063.063-.438.188-.063.125.188.344t.125.469q-.188.375-.938.563-.188.188-.5.375-.063 1.438 0 2.563zm21.125 4q-.813-.438-1.438-.781t-1.375-.719-1.438-.688-1.469-.594-1.531-.531q-1.25.563-2.625 1-.125.063-.25 0-1.063-.313-2.188-.813-3.563 1-7.063 3.125 8.938.375 19.375 0zm.625-.75q.125-1.688 1.063-3.25h-.063q.063-1.313.063-2.563-.25-.125-.5-.438-.688-.125-.938-.5-.125-.375.375-.688-.063-.063-.063-.125-.25-.063-.438-.188-3.438 3.188-6.5 4.75 3.438 1.063 7 3zm6.625.375q.125-1.375-1.438-2.563t-2.688-.813q-.625.188-1.219 1.188t-.906 2.188q0 1.063.781 1.688t1.781.625q.875-.063 2-.719t1.688-1.594zM23.313 4.688q-1.688-1.813-3.75-2.219t-4.125.781q.75-1.75 2.625-2.219t3.5.531 1.75 3.125zM4.688 25.438q.688-.063 1.063.656t.063 1.281q-.125.313-.5.656t-.875.656-.813.375q-.813.25-1.438-.063t-.625-.875q0-.75 1.156-1.688t1.969-1zm13.5-11q-1.5 0-2.5-1.094T15 10.688q.625 1 1.781.688t1.156-1.375-1.063-1.375q1.563-.625 3.063.25t1.5 2.5q0 1.313-.969 2.188t-2.281.875zM4.25 29.625q0-.25.344-.594t.781-.625.688-.344q.375-.063.563.375t.063.75q-.375.75-1.063 1.063-.438.125-.906-.094t-.469-.531zm27.063-4.187q.813.063 1.969 1t1.156 1.688q0 .563-.625.875t-1.438.063q-.563-.125-1.281-.688t-.969-1q-.25-.563.125-1.281t1.063-.656zm-1.375 2.625q.438.063 1.156.625t.656.938q0 .313-.469.531t-.844.094q-.813-.313-1.125-1.063-.125-.313.063-.75t.563-.375z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'opencart' => array(
		'p' => 'M26.438 27.563q0 1.188-.813 2t-2 .813-2.031-.813-.844-2 .844-2.031 2.031-.844 2 .844#r#031zm-15.875-2.875q1.188 0 2.031.844t.844 2.031-.844 2-2.031.813-2-.813-.813-2 .813-2.031 2-.844zm18.25-16.875q2.438 0 4.281.063t3.094.313l2.188.438 1.188.719.438.875-.375 1.156-.938 1.313-1.594 1.594-1.969 1.75-2.438 2.094q-3.188 2.75-4.938 4.313.75-1.375 2.344-3.125t2.781-2.906 1.813-2.375-.094-1.938-3.469-1.125-7.813-.344q-3.625.063-6.656-.188t-5.094-.625-3.844-1.094-2.75-1.281-1.906-1.5-1.313-1.469T.78 2.94t-.781-1.313q2.625 2.75 5.781 4.031t8.094 1.719 14.938.438z',
		'w' => 1.248046875,
		'vw' => 40
	    ),
	    'expeditedssl' => array(
		'p' => 'M15.5 2.688q5.5 0 9.406 3.906T28.812 16t-3.906 9.406-9.406 3.906-9.406-3.906T2.188 16t3.906-9.406T15.5 2.688zM9.438 11h-.063v1.688q0 .563.563.563h1.125q.563 0 .563-.563V11q0-1.438.781-2.438t1.938-1.25 2.281 0 1.938 1.25#r#438v1.688q0 .563.563.563h1.063q.563 0 .563-.563V11q0-2.5-1.781-4.281t-4.281-1.781q-1.625 0-3.031.813T10.254 7.97t-.813 3.031zm14.937 12.75v-8.875q0-.438-.344-.75t-.781-.313H7.75q-.438 0-.781.313t-.344.75v8.875q0 .438.344.781t.781.344h15.5q.438 0 .781-.344t.344-.781zm-15.5-8.562v8.313q0 .25-.313.25h-.563q-.25 0-.25-.25v-8.313q0-.313.25-.313h.563q.313 0 .313.313zm8.813 3q0 1.313-1.063 1.938v1.938q0 .563-.563.563h-1.125q-.563 0-.563-.563v-1.938q-1.125-.625-1.125-1.938 0-.875.656-1.531t1.594-.656 1.563.656.625 1.531z#d#0 29.875q5.938 0 10.156-4.219T29.875 16 25.656 5.844 15.5 1.625 5.344 5.844 1.125 16t4.219 10.156T15.5 30.375z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'cc-jcb' => array(
		'p' => 'M27 15.25v-2h2.375q.813.188.813 1 0 .875-.813 1H27zm2.625 1.25q.875.188.875 1.094t-.875 1.031q-.125.063-2.625.063V16.5h2.625zM36 5v22q0 1.25-.875 2.125T33 30H3q-1.25 0-2.125-.875T0 27V5q0-1.25.875-2.125T3 2h30q1.25 0 2.125.875T36 5zm-24.625 7H7.812q0 .688.031 1.688t.031 1.531-.031 1.25-.156 1.063-.375.688-.688.5-1.063.156q-1.688 0-3.563-.938v1.75q.5.188 1.156.281t1.156.156.969.063h.719l.25.063q1.125 0 1.969-.188t1.406-.375.938-.688.563-.875.25-1.219.063-1.375-.031-1.688-.031-1.844zm11.125.313q-1.563-.438-3.281-.5t-3.313.219-2.625 1.313-1.031 2.656q0 1.688 1.063 2.719t2.75 1.281 3.344.156 3.094-.469v-1.75q-1.5.813-3.031.938t-2.594-.594-1.063-2.281 1.063-2.281 2.594-.594 3.031.938v-1.75zM34 17.875q0-.25-.094-.5t-.219-.469-.344-.406-.5-.313-.594-.188l-.625-.125q.875-.125 1.375-.656t.5-1.219q0-.625-.281-1.063t-.813-.656-1.219-.281h-7.5v8h7.688q1.125 0 1.875-.563t.75-1.563z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'cc-diners-club' => array(
		'p' => 'M15 5q4.563 0 7.781 3.219T26 15.969t-3.219 7.781T15 27t-7.781-3.25T4 15.969t3.219-7.75T15 5zm-2.5 17.5v-13q-2 .75-3.25 2.531T8 16t1.25 3.938 3.25 2.563zm5 0q1.938-.813 3#q#563t1.25-3.938q0-.875-.219-1.719t-.594-1.563-.938-1.344-1.25-1.125-1.438-.75v13zM33 2q1.25 0 2.125.875T36 5v22q0 1.25-.875 2.125T33 30H3q-1.25 0-2.125-.875T0 27V5q0-1.25.875-2.125T3 2h30zM20.625 28q4.938 0 8.719-3.531t3.781-8.344q0-5.25-3.719-8.688t-8.781-3.438h-5.688q-3.313 0-6.063 1.5T4.499 9.812t-1.625 6.313q0 4.875 3.563 8.375t8.5 3.5h5.688z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'creative-commons' => array(
		'p' => 'M15.375 13.438l-2.063 1.063q-.625-1.25-1.75-1.25-2.063 0-2.063 2.75t2.063 2.75q1.375 0 1.938-1.313l1.875.938q-1.313 2.438-4.063 2.438-.625 0-1.313-.188t-1.5-.625-1.313-1.5-.5-2.5q0-2.5 1.406-3.656t3.156-1.156q2.875 0 4.125 2.25zm8.938 0l-2.063 1.063q-.563-1.25-1.75-1.25-2.063 0-2.063 2.75t2.063 2.75q1.375 0 1.938-1.313l1.938.938q-1.375 2.438-4.063 2.438-.688 0-1.375-.188t-1.469-.625-1.281-1.469-.5-2.531q0-2.5 1.406-3.656t3.094-1.156q2.875 0 4.125 2.25zM15.5.5Q22.063.5 26.531 5T31 16q0 3.375-1.281 6.313t-3.438 4.906-4.969 3.125-5.813 1.156q-6.375 0-10.938-4.531T-.002 16q0-4.125 1.969-7.688T7.53 2.624 15.499.499zm0 28.188q5.063 0 8.875-3.594T28.188 16q0-5.313-3.688-9t-9-3.688q-5.375 0-9.031 3.813T2.813 16q0 5.188 3.719 8.938t8.969 3.75z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'gg' => array(
		'p' => 'M11.188 14.375l6.438 6.438-6.438 6.375L0 16 11.188 4.812l2#r#813-1.625 1.563L11.188 8l-8 8 8 8 3.25-3.25L9.625 16zm9.625-9.562l11.188 11.188-11.188 11.188L18 24.376l1.625-1.563 1.188 1.188 8-8-8-8-3.25 3.25 4.813 4.75-1.563 1.625-6.438-6.438z'
	    ),
	    'gg-circle' => array(
		'p' => 'M16.063.5q6.438 0 10.969 4.531T31.563 16t-4.531 10.969T16.063 31.5 5.094 26.969.563 16 5.094 5.031 16.063.5zM13 23.938l4.625-4.688-4.813-4.875-1.5 1.563 3.313 3.313-1.688 1.625-4.813-4.813 4.813-4.813.688.688 1.563-1.5L13 8.188l-7.875 7.875zm6.125-.125L27 15.938l-7.875-7.875-4.625 4.688 4.813 4.875 1.5-1.563L17.5 12.75l1.625-1.625L24 15.938l-4.875 4.813-.688-.688-1.5 1.5z',
		'w' => 1.00390625
	    ),
	    'tripadvisor' => array(
		'p' => 'M10.375 17.563q0 .375-.188.719t-.531.531-.781.188q-.563 0-1.031-.438t-.469-1.031.469-1.031 1.063-.438 1.031.438.438 1.063zm16.563-1.5q.438 0 .781.188t.531.531.188.781q0 .563-.438 1t-1.063.438-1.063-.438-.438-1.031.438-1.031 1.063-.438zm5.625 8.687q-2.938 2.313-6.656 1.844t-6.031-3.406l-1.938 2.938-1.875-2.875q-2.25 2.813-5.844 3.281t-6.531-1.656q-3-2.188-3.563-5.875t1.625-6.688Q1.187 10.375 0 8.688h5.625q2.25-1.375 5.719-2.375t6.156-1h.875q2.563 0 5.969 1T30 8.688h6q-1.188 1.625-1.813 3.563 2.188 2.938 1.719 6.594t-3.344 5.906zm-16.375-7.156q0-2.969-2.094-5.063t-5.063-2.094-5.094 2.094-2.125 5.063 2.125 5.094 5.094 2.125 5.063-2.125 2.094-5.094zM18 16.938q.25-3.438 2.75-5.813t5.938-2.5Q25 7.937 22.563 7.406t-4.313-.531h-.5q-1.875 0-4.375.5t-4.188 1.25q1.75 0 3.313.688t2.719 1.781 1.906 2.625.875 3.219zm15.719-1.782Q32.688 12.375 30 11.125t-5.5-.219-4.063 3.719-.219 5.5 3.75 4.063 5.5.219 4.031-3.75.219-5.5zm-20.344 2.375q0 1.844-1.313 3.156T8.906 22 5.75 20.687t-1.313-3.156 1.313-3.156 3.156-1.313 3.156 1.313 1.313 3.156zm-1.562.032V17.5q0-1.188-.844-2.031t-2.094-.844q-.75 0-1.438.375t-1.063 1.063-.375 1.5q0 1.188.844 2.031t2.063.844 2.063-.844.844-2.031zm19.625 0q0 1.188-.625 2.219t-1.625 1.625-2.25.594q-1.813 0-3.125-1.313T22.5 17.532t1.313-3.156 3.156-1.313 3.125 1.313 1.344 3.188zm-1.563-.032q0-1.219-.844-2.063t-2.063-.844-2.063.844-.844 2.063.844 2.063 2.063.844 2.063-.844.844-2.063z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'odnoklassniki' => array(
		'p' => 'M17.188 20.875q-2.063 1.313-5.625 1.688l6.063 6.063q.813.813.438 1.906t-1.344 1.375-1.906-.406l-4.813-4.813-4.75 4.75q-.813.813-1.906.438T1.97 30.532t.469-1.906l4.75-4.813 1.313-1.25q-3.688-.375-5.688-1.688Q1.126 19.75.626 19.031t.063-1.844q.375-.813 1.219-1.031t2.156.656q.25.188.75.5t2.031.813 3.156.5 3.125-.438 2.125-.938l.688-.438q1.313-.875 2.156-.656t1.281 1.031q.188.688.25 1.063t-.313.875-.813.844-1.313.906zM1.875 8.125q0-3.375 2.375-5.75T10 0q2.188 0 4.063 1.094t2.969 2.938 1.094 4.094q0 3.313-2.375 5.688t-5.75 2.375-5.75-2.375-2.375-5.688zm4.125 0q0 1.625 1.188 2.781t2.813 1.156 2.813-1.156 1#q#781q0-1.688-1#q#844t-2.813-1.156q-1.063 0-2 .531T6.532 6.094t-.531 2.031z',
		'w' => .625,
		'vw' => 20
	    ),
	    'odnoklassniki-square' => array(
		'p' => 'M11.5 11.094q0-1.031.75-1.781t1.75-.75 1.75.75.75 1.781-.75 1.75-1.75.719-1.75-.719-.75-1.75z#b#M8.938 11.063q0 2.125 1.469 3.594t3.594 1.469 3.594-1.469 1.469-3.563T17.595 7.5 14.001 6t-3.594 1.469-1.469 3.594zm10.875 5.687q-.25-.5-.75-.625t-1.375.375Q16.313 17.625 14 17.625q-1 0-1.938-.281t-1.375-.531l-.375-.313q-.875-.5-1.375-.375t-.75.625q-.375.438-.188.875t.469.688 1.031.75q1.25.813 3.563 1.063l-.813.75q0 .063-3 3-.813.813.063 1.719t1.688.094l3-3 3 3q.813.813 1.688-.063t.063-1.75l-2.938-3-.813-.75q2.188-.25 3.5-1.063 1.063-.688 1.375-1.156t-.063-1.156z'
	    ),
	    'get-pocket' => array(
		'p' => 'M25.5 4q1.063 0 1.781.75T28 6.563v8.438q0 5.813-4.094 9.906T14 29.001t-9.906-4.094T0 15.001V6.563Q0 5.5.75 4.75T2.563 4h22.938zM15.375 20.75q1.5-1.438 3.625-3.438 2.563-2.438 3.031-3t.469-1.25q0-.75-.563-1.313t-1.313-.563q-.625 0-1.125.375t-2.625 2.438q-1.688 1.625-2.875 2.75-1.188-1#q#938-2.875-2-1.938-2.5-2.313t-1.125-.375q-.813 0-1.375.563t-.563 1.313q0 .688.469 1.219t3.094 3.031q2.125 2 3.625 3.438.563.563 1.313.563t1.375-.563z'
	    ),
	    'wikipedia-w' => array(
		'p' => 'M40 3.188v.75q-2.438.063-3.5 2.563-.375.813-1.719 3.906t-2.531 5.906-2.75 6.406-2.688 6.156h-.875l-5.125-12.063q-.438.875-2.75 5.313t-3.438 6.75q0 .063-.469.031l-.469-.031q-1.438-3.438-4.469-10.25T4.748 8.312q-.625-1.375-2.125-2.875T-.002 3.999v-.875h10.125v.813Q8.998 4 7.998 4.625t-.625 1.5q.438.875 3.75 8.563t4.125 9.438q.438-.813 1.344-2.563t1.938-3.656 1.406-2.719q-.313-.625-2.156-4.844t-2.344-5.156Q14.748 4 11.936 4v-.875h8.875v.813q-1 .063-1.594.469t-.219 1.156q.563 1.25 1.5 3.313t1.5 3.25q1.813-3.438 3-6.313.313-.625.125-1.031t-.813-.594T22.622 4v-.875h7.688v.813q-2.375.125-3.625 2l-3.688 7.688q.188.563 2.188 5.031t2.125 4.719l7.625-17.625q-.313-.938-1.25-1.344t-1.688-.406v-.875z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'safari' => array(
		'p' => 'M14.813 16.063q0-.25.063-.438t.188-.344.344-.25.406-.094q.438 0 .781.281t.344.719q0 .313-.125.563t-.375.406-.563.156q-.375 0-.719-.281t-.344-.719zM31.5 16q0 6.438-4.531 10.969T16 31.5 5.031 26.969.5 16 5.031 5.031 16 .5t10.969 4.531T31.5 16zm-1.687 0q0-5.75-4.031-9.781t-9.781-4.031T6.22 6.219 2.189 16t4.031 9.781 9.781 4.031 9.781-4.031T29.813 16zm-4.5 6.063q0 .125 1 .75-2.688 4.063-7.375 5.188l-.25-1.125q0-.188-.25-.188t-.188.25l.25 1.188q-1.25.25-2.5.25-3.438 0-6.438-1.813l.75-1.25q0-.25-.188-.25-.125 0-.313.25t-.406.594-.219.406q-4.125-2.688-5.25-7.5l1.188-.25q.188-.063.188-.25t-.25-.188l-1.188.25q-.25-1.188-.25-2.375 0-3.563 1.875-6.563 1.125.688 1.188.688.188 0 .188-.188 0-.125-.219-.313t-.531-.375-.375-.188q2.813-4.063 7.5-5.125l.25 1.188q.063.125.281.125t.156-.25l-.25-1.125q1.25-.25 2.313-.25 3.563 0 6.563 1.875-.688 1-.688 1.125 0 .25.25.25.125 0 .813-1.125 4 2.688 5.063 7.375l-.938.25q-.188 0-.188.25 0 .188.25.188l1-.25q.25 1.25.25 2.438 0 3.5-1.813 6.438-.063-.063-.281-.219t-.438-.281-.281-.125q-.25 0-.25.25zM23.25 6.875Q14.687 14.938 14.625 15l-6 10q8.5-7.938 8.563-8.063z'
	    ),
	    'chrome' => array(
		'p' => 'M8.25 13.625L3.437 6.25Q5.625 3.5 8.812 2T15.437.5q4.188 0 7#r#063 4 2.313 6.063 6.438L16.5 8.313q-1.375-.063-2.656.281t-2.375 1-1.938 1.688-1.281 2.344zm2 2.375q0-1.438.719-2.625t1.906-1.906 2.625-.719q2.188 0 3.719 1.531T20.75 16t-1.531 3.719T15.5 21.25t-3.719-1.531T10.25 16zm19.688-5.562q2.063 5.188.188 10.656t-6.875 8.344q-4 2.313-8.625 2.063l7-10.813q1.563-2.25 1.469-5t-1.844-4.813zM8.375 19q1.25 2.438 3.656 3.719t5.031.781l-3.938 7.813q-5.625-.875-9.375-5.219T-.001 16q0-4.625 2.5-8.5z',
		'w' => .966796875,
		'vw' => 31
	    ),
	    'firefox' => array(
		'p' => 'M29.875 14.688q.125.688.125 1.375v.188q-.125 3.25-1.875 6l-.063.094-.063.156q.25.688-.063 1.375-.438 1.875-2.063 3-1 .875-2.188 1.375l-.125.063-.063.063q-.125 0-.313.125-.188.438-.625.813-.063.125-.25.313t-.781.531-1.344.625-2 .5-2.688.219q-2.25 0-4.375-.625l.125.063q-.313-.125-.5-.188-1.75-.563-3.313-1.625-3.938-2.375-5.813-6.5-1.375-3-1.188-6.313-.25.875-.438 1.625 0-2.813 1-5.375-.5.75-.875 1.563.563-2.125 1.688-4.063.375-.625.75-1.063 0-.25.063-.563.125-1.5.75-2.938h.063v.125q0-.188.094-.375t.281-.375v.25q.063-.25.125-.313.188-.563.688-.875 0 .813.25 1.625l.063-.063h.063q.063.188.125.313.188.25.25.375h.063q.188.375.563.688 1.75-.313 3.438.313.188-.25.438-.438v.125q.375-.438.938-.688v.125q.688-.375 1.438-.563-.063 0-.313.188.375-.125.75-.188.563 0 .813.188-.25.063-.5.25h.125q-1.375.875-1.938 2.438.25 1.125 1.438 1.313 2.313.188 2.375.563v.25q-.125.688-.625 1.125-.188.125-.313.188 0 .063-.125.094t-.313.125-.375.156q-.75.313-1.375.688-.125.125-.25.188l-.063.125q.063.125.063.188l-.125.063q.125.25.063.5.063.438-.125.875-.25-.188-.438-.25.25.125.313.375v.188q-.125-.188-.313-.313-.375-.188-.75-.313l.125.25q-.125-.125-.313-.188-.375.188-.563.563-.375.75.063 1.5.375.563.938.938h-.125l-.125-.063q.5.313.938.563h-.125l-.063-.063q.063.125.25.188.5.25 1 .313t.844-.031.844-.25.813-.219q1.688-.313 2.75 1.063.313.375.094.688t-.656.188q-.063-.063-.188-.063t-.219.031-.25.063-.25.094-.281.156l-.313.156-.375.219-.375.219q-1.688.813-3.5.438l-.875-.25-.125-.063v.063q.875 1.125 2.063 1.875.813.375 1.688.563.75.188 1.563.188 2.875 0 4.875-2.031t2-4.844q.063-1.563-.563-2.938 2 1.188 3.063 3.188-.25-.688-.563-1.281t-.844-1.156-.781-.781-1-.813-.875-.719q-1.875-1.438-2.688-3.625-.438-1.313-.406-2.5t.438-2.25.844-1.844.813-1.281l.375-.438q-.25.938 1.688 2.75 1.813 1.625 1.813 1.688.188-.875.5-1.688.188 1.375.938 2.563.313.5.969 1.281t.969 1.219q.188.25.313.5.5.688.875 1.438.563 1.125.875 2.313.313 1 .375 2l.313-.375q0 .188.063.438zM11.188 8.625q-.063.063-.063.188l.031-.094z',
		'w' => .9375,
		'vw' => 30
	    ),
	    'opera' => array(
		'p' => 'M19.625 2.063q-3.813 0-6#r#313t-4.313 5.656-.906 7.281 2.781 6.938q3.813 4.688 9.25 4.688 3.313 0 6.188-1.875-4.375 3.938-10.313 3.938h-.75q-6.188-.313-10.469-4.781T-.001 15.502q0-6.438 4.531-10.969T15.499.002h.063q5.875 0 10.25 3.938-2.813-1.875-6.188-1.875zM26 26.875q-1.938 1.188-4.156 1.094t-4.094-1.406q2.625-1 4.344-4.063t1.719-7-1.688-7-4.375-4.063q1.938-1.313 4.156-1.406t4.156 1.094Q31 8.75 31 15.531t-5 11.344z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'internet-explorer' => array(
		'p' => 'M30.188 10q2.375 4.25 1.688 8.813H11.313q0 2.25 1.469 3.844t3.438 2.094 4.094-.25 3.313-2.75h7.563q-1.5 4.25-5.219 6.688t-8.344 2.438q-4.375 0-6.375-.938-2.125 1.063-4.063 1.594t-3.594.438T.97 30.69t-.969-3.375q0-2 .813-4.531t1.938-4.531q3.563-6.438 8.5-10.813-3.313 1.375-7.625 6.313Q4.815 8.44 9.096 5.097t9.344-3.031Q24.503-.622 28.003.16t3.5 4.344q0 2.438-1.313 5.5zM4.063 21.688q-1.125 2.313-1.531 4.094t-.125 2.813 1 1.625 1.813.656 2.375-.313 2.719-1.188q-4.563-2.625-6.25-7.688zm7.25-6.813h12.938q0-1.688-.938-3.063t-2.406-2.125-3.094-.75q-2.625 0-4.531 1.688t-1.969 4.25zm11.5-11.75q4.188 1.625 7 6.25.938-2.375.938-4.25 0-1-.438-1.75t-1.219-1.188-1.719-.438q-1.688 0-4.563 1.375z',
		'w' => .998046875
	    ),
	    'contao' => array(
		'p' => 'M2.813 19.063q.688 2.938 1 4.25t1.188 3.344 2.125 3.344h-5q-.875 0-1.5-.625t-.625-1.5V4.126q0-.875.625-1.5t1.5-.625h3.625q-1.313 1#q#313 2.75-.813 1.25-1.25 2.75t-.531 2.594.125 3.031.406 2.781.625 3.156zM29.875 2q.875 0 1.5.625t.625 1.5v23.75q0 .875-.625 1.5t-1.5.625h-3.25q3.875-3.813 3.563-10.25l-8.563 1.875Q21.437 25.5 18 26.188q-2.188.5-3.625-.688-.875-.75-1.531-2.344t-1.531-5.906q-.625-2.938-.844-4.781t-.125-2.563.406-1.406q.813-1.688 3.063-2.125 3.375-.75 5.125 2.688l8.563-1.813q-1.25-3.188-3.25-5.25h5.625z'
	    ),
	    'px' => array(
		'p' => 'M6.438 21.5q-.313-.625-.25-.906t.75-.531q.688-.188.844 0t.563 1.125 1.281 1.938v-5.875q.063-2.313 1.844-4.031t4.281-1.719 4.313 1.781 1.813 4.281q0 3.063-2.469 4.906t-5.594.906q-.5-.188-.219-1.063t.781-.688q1.813 0 2.938-.281t1.875-1.219.75-2.563q0-1.813-1.313-3t-3.063-1.156-2.938 1.406q-.313.375-.5.656t-.344.75-.219.844-.063 1.219v6.344q2.438 1.5 5.25 1.125t4.813-2.375q2.375-2.375 2.375-5.781t-2.375-5.844q-2.438-2.375-5.875-2.375t-5#r#375q-.938.938-1.313 1.5h-.063q-.375.625-1.25.438-.875-.25-.875-.75V1.249q0-.625.625-.625h15.125q.5 0 .5.938t-.5.938h-14v8.313h.063q2.313-2.5 5.469-3.094t5.813.469 4.5 3.594 1.844 5.844q0 2.625-1.156 4.781t-2.938 3.375-4.031 1.625-4.375-.031-4-1.969-2.875-3.906zm4-16.25q0-.313.563-.563t1.469-.469 2.063-.313 2.531.063 2.781.531 2.844 1.156 2.625 1.969q.25.25.063.563t-.5.563-.438.25q-.063 0-.75-.531t-1.844-1#q#656-1.188-3.594-.469-4.281.875q-.375.188-.656-.375t-.219-.875zm14.125 20.688q.375-.375 1 .25t.313 1q-3.063 3.063-7.094 3.875t-7.5-.375-6.094-4.156T2 19.626q-.063-.313.406-.531t.938-.125.469.406q.625 3 2.281 5.313t3.938 3.469 4.844 1.406 5.125-.688 4.563-2.938zm-11.188-6.75q0-.188 1.25-1.438L13.5 16.625q-.188-.188-.063-.438t.406-.469.406-.219 1.375 1.25l1.125-1.125q.25-.313.75.188t.25.813l-1.125 1.125 1.063 1.063q.313.375-.031.781T17 20q-.125 0-1.375-1.25l-.625.625q-.563.625-.75.625-.25 0-.563-.313t-.313-.5z',
		'w' => .873046875,
		'vw' => 28
	    ),
	    'amazon' => array(
		'p' => 'M16.063 10.188V8.157l-.031-.594-.094-.469-.188-.438-.281-.344-.406-.25-.531-.125-.656-.063h-.281l-.625.188-.875.469-.875.906-.719 1.5-4.625-.438q0-2.5 2.281-4.5t6.156-2q1.938 0 3.375.563T19.876 4t1.094 1.656.344 1.469v9.188q0 .813.5 1.625t1 1.25l.5.438-3.563 3.5q-2.375-2.25-2.813-2.938-.813 1.313-2.25 2.094t-3 .844-2.969-.438-2.313-1.844T5.5 17.5q0-1.813.813-3.188t1.969-2.125 2.75-1.219 2.75-.625 2.281-.156zm0 5.437v-2.563q-5.25.188-5.25 3.625 0 1.813 1.75 2.375 1.813.625 2.875-1 .625-.938.625-2.438zm8.5 10.188q-.438.563-1.563 1.406t-3.75 1.813-5.563.969q-3 0-5.938-1.281t-4.531-2.563-2.594-2.469q-.188-.25-.156-.406t.188-.156.281.063q1.5.875 2.188 1.281t2.406 1.219 2.906 1.125 3.188.656 3.781.125 4.094-.813 4.75-1.719q.188-.063.375-.031t.188.25-.25.531zm2.5.125q-.563 1.313-1.313 1.938-.25.25-.406.156t-.031-.406q.375-.688.719-1.875t.094-1.563q-.375-.438-3-.188-.813.063-.875-.031t.094-.219.406-.25.563-.25.656-.219.656-.156q2.375-.25 2.875.375.125.25 0 1.094t-.438 1.594z',
		'w' => .873046875,
		'vw' => 28
	    ),
	    'houzz' => array(
		'p' => 'M16.188 20.688H9.625v9.313H0v-28h6.875v6.5l19.063 5.375v16.125h-9.75v-9.313z',
		'w' => .80859375,
		'vw' => 26
	    ),
	    'vimeo-v' => array(
		'p' => 'M28 9.625q-.188 4.063-5.75 11.188-5.688 7.438-9.625 7.438-2.438 0-4.125-4.563-.375-1.188-.938-3.375-.75-2.813-1.125-4.094t-.906-2.781-1-2.031-1.031-.531q-.313 0-2.188 1.313l-1.313-1.688q.625-.5 1.875-1.656T3.78 7.126t1.594-1.313T6.999 4.75t1.25-.375q3.25-.313 4 4.438 1.5 9.438 2.625 10.438 1 .938 3.125-2.375l.125-.125q1.75-2.813 1.875-4.25.125-1.313-.531-1.906t-1.563-.5-1.844.469q2.063-6.75 7.875-6.563 4.313.125 4.063 5.625z'
	    ),
	    'black-tie' => array(
		'p' => 'M0 2h28v28H0V2zm19.75 20.313l-4-11.5 4-5.375H8.25l4 5.375-4 11.5L14 27.876z'
	    ),
	    'fonticons' => array(
		'p' => 'M0 2h28v28H0V2zm11.688 8.813q.375 0 .594.125t.313.438.094.875l3.188-.375q0-1.938-1.094-2.625t-2.969-.688q-1.625 0-2.656.438t-1.594 1.406-.563 2.531v1.313h-1.75v2.313h1.375q.375 0 .375.188v6.938q0 .438-.438.5l-1.313.125v1.625h8.188v-1.563l-2.75-.25q-.25-.063-.188-.25v-7.313H14l.688-2.313h-4.25q0-.125.063-.25v-1.5q0-.625.063-.938t.313-.531.813-.219zm4.625 15.125h6.438v-1.563l-1-.188q-.188 0-.188-.063v-9.875h-5l-.438 1.875 1.563.375q.375.125.375.5v6.75q0 .375-.438.438l-1.313.188v1.563zm5.062-16l1.375-1.5-.25-.625h-1.688l-1-1.75h-.563l-1 1.75h-1.688l-.25.625 1.375 1.5-.563 2.063.438.5 2-1.063 1.938 1.063.438-.5z'
	    ),
	    'reddit-alien' => array(
		'p' => 'M27.5 12.75q1.688 0 2.625 1.188t.656 2.719T29 18.938q.188.688.188 1.563 0 3.938-3.844 6.719T16 30.001q-3.563 0-6.594-1.281t-4.781-3.438-1.75-4.781q0-.813.188-1.5-1.563-.813-1.844-2.313t.656-2.719T4.5 12.75q1.375 0 2.375 1 3.563-2.5 8.5-2.688l1.938-8.625q.125-.563.688-.438l6.063 1.375q.75-1.375 2.188-1.375 1.063 0 1.781.719t.719 1.75-.719 1.75-1.781.719q-1 0-1.719-.719t-.719-1.719l-5.5-1.25-1.75 7.813q5 .188 8.563 2.625 1-.938 2.375-.938zM8.063 19.313q0 1 .75 1.719t1.75.719q.5 0 .969-.188t.781-.531.5-.781.188-.938q0-1.063-.719-1.781t-1.719-.719q-.688 0-1.25.344t-.906.906-.344 1.25zM21.5 25.125q.438-.375 0-.813t-.875 0q-1.313 1.313-4.656 1.313t-4.656-1.313q-.375-.438-.813 0t0 .813q1.688 1.75 5.469 1.75t5.531-1.75zm-.062-3.375q.688 0 1.25-.313t.906-.875.344-1.25q0-1.063-.75-1.781t-1.75-.719-1.719.75-.719 1.75.719 1.719 1.719.719z',
		'w' => .998046875
	    ),
	    'edge' => array(
		'p' => 'M1.625 14.25zm28.75 1v3.25H10.75q.063 2.813 2 4.5t4.656 1.969T23 24.656t4.75-1.969v6.563q-1.563.938-4 1.594t-5.5.656-5.5-.938q-3.25-1.25-5.375-4.313T5.25 19.811q-.125-8.188 7.5-11.75-1.625 2.063-2.125 4.938h11q.188-1.875-.406-3.219t-1.531-1.969-1.906-.969-1.656-.406h-.75q-4.438.125-7.969 2.344t-5.781 5.469q.75-5.813 4.563-9.781t10-3.969q4 0 7.25 1.844t5.125 5.219q1.813 3.25 1.813 7.688z'
	    ),
	    'codiepie' => array(
		'p' => 'M26.375 12.688q.938 0 1.344.813t.031 1.656-1.375.844h-.688v2.75h-1.625v-6.063h2.313zm3.125 9.375q-1.313 2.875-3.344 4.969t-4.781 3.281-5.875 1.188q-6.438 0-10.969-4.531T0 16.001 4.531 5.032 15.5.501q4.438 0 7.938 2.281t5.688 6.344l-11.625 6.813zm-2.375.75l-3.813-1.938q-2.688 4.5-7.625 4.5-3.875 0-6.594-2.719t-2.719-6.594 2.719-6.594 6.594-2.719q4.5 0 7.313 3.938l3.688-2.188q-1.938-2.938-4.844-4.594T15.5 2.249q-5.688 0-9.719 4.031T1.75 15.999t4.031 9.719 9.719 4.031q3.625 0 6.688-1.844t4.938-5.094z',
		'w' => .921875,
		'vw' => 30
	    ),
	    'modx' => array(
		'p' => 'M22.25 15.125l2.313 1.5V30l-8.313-5.25zM27.5 4.688l-5.188 8.375-9.625-6 1.438-2.375H27.5zm-5.562 8.937L6.313 17.25l-2.875-1.875V2zm-15.875 4.75l15.625-3.625-7.813 12.563H.5z'
	    ),
	    'fort-awesome' => array(
		'p' => 'M30.563 18q.313 0 .313.25V32H19.438v-6q0-1.625-1.063-2.531T16 22.563t-2.375.906T12.562 26v6H1.124V18.25q0-.25.313-.25h1.688q.313 0 .313.25v2h2.25V9.125q0-.25.313-.25h1.688q.313 0 .313.25v2h2.25v-2q0-.25.313-.25h1.688q.313 0 .313.25v2h2.313v-2q0-.25.688-.25v-7q-.563-.25-.563-.875t.5-.875 1 0 .5.875-.625.875v.313Q17.192 2 17.879 2q.375 0 1.063.125t1 .125.844-.125.656-.125q.25 0 .25.25V6q0 .5-1.688.5-.375 0-1-.125t-1-.125q-.688 0-1.625.25v2.375q.75 0 .75.25v2h2.313v-2q0-.25.25-.25h1.75q.25 0 .25.25v2h2.313v-2q0-.25.313-.25h1.688q.313 0 .313.25V20.25h2.25v-2q0-.25.313-.25h1.688zm-18-.312v-4q0-.25-.313-.25h-1.688q-.313 0-.313.25v4q0 .313.313.313h1.688q.313 0 .313-.313zm9.187 0v-4q0-.25-.313-.25h-1.688q-.313 0-.313.25v4q0 .313.313.313h1.688q.313 0 .313-.313z',
		'w' => .998046875
	    ),
	    'usb' => array(
		'p' => 'M40.125 16q0 .313-.313.5l-5.563 3.313q-.188.063-.313.063t-.25-.063q-.313-.125-.313-.438v-2.25H18.498q.5.813 1.313 2.688t1.5 2.938 1.5 1.063h1.688v-1.688q0-.563.563-.563h5.563q.563 0 .563.563v5.563q0 .563-.563.563h-5.563q-.563 0-.563-.563v-1.688h-1.688q-1.563 0-2.781-1.375t-1.844-3.063-1.438-3.063-1.688-1.375H8.747q-.375 1.438-1.563 2.375t-2.75.938q-1.813 0-3.125-1.313T-.004 16t1.313-3.125 3.125-1.313q1.563 0 2.75.938t1.563 2.375q.313 0 .844.031t.688 0 .531-.063.5-.188.406-.406.531-.688.531-1.031.656-1.406q.875-1.938 1.531-3t1.438-1.531 1.344-.563 1.813-.031h.688q.375-1 1.219-1.625t1.906-.625q.688 0 1.313.281t1.063.719.719 1.063.281 1.313q0 .875-.469 1.656T25.061 10t-1.688.438q-1.063 0-1.906-.625T20.248 8.25h-1.875q-.813 0-1.5 1.031t-1.5 2.906-1.375 2.688h19.375v-2.188q0-.313.281-.5t.594 0l5.563 3.375q.313.125.313.438z',
		'w' => 1.251953125,
		'vw' => 40
	    ),
	    'product-hunt' => array(
		'p' => 'M20.375 13.656q0 .969-.688 1.656T18.062 16h-4.375v-4.625h4.375q.938 0 1.625.656t.688 1.625zM31.5 16q0 6.438-4.531 10.969T16 31.5 5.031 26.969.5 16 5.031 5.031 16 .5t10.969 4.531T31.5 16zm-8-2.312q0-2.25-1.594-3.844T18.062 8.25h-7.5v15.5h3.125v-4.625h4.375q2.25 0 3.844-1.594t1.594-3.844z'
	    ),
	    'mixcloud' => array(
		'p' => 'M26.5 13.75q1.313.25 2.375 1.094t1.688 2.063.625 2.594q0 2.438-1.75 4.188t-4.188 1.75H7.125q-2.938 0-5-2.094T.062 18.376q0-2.688 1.719-4.656t4.344-2.344Q7.188 8.188 9.938 6.22t6.125-1.969q4.063 0 7.063 2.75t3.375 6.75zm-1.25 9q.688 0 1.281-.25t1.031-.688.719-1.031.281-1.281q0-1-.594-1.844t-1.531-1.219q-.125.813-.375 1.625-.25.75-1 .875t-1.281-.375-.219-1.313q.375-1.25.375-2.5 0-3.25-2.313-5.563t-5.563-2.313q-2.313 0-4.281 1.281t-2.906 3.344q1.875.5 3.25 1.875.625.563.375 1.281t-.906.906-1.344-.313q-1.313-1.313-3.125-1.313t-3.125 1.281-1.313 3.125 1.313 3.125 3.125 1.281h18.125zm14.688-3.281q0 4.219-2.313 7.719-.438.563-1.125.563-.75 0-1.125-.688t.063-1.375q1.875-2.813 1.875-6.188t-1.875-6.188q-.5-.688-.125-1.344t1.063-.719 1.25.625q2.313 3.375 2.313 7.594zm-4.438 0q0 3.031-1.688 5.531-.375.563-1.063.563-.813 0-1.188-.688t.063-1.375q1.25-1.75 1.25-4t-1.25-4.063q-.438-.625-.063-1.313t1.031-.719 1.219.594q1.688 2.438 1.688 5.469z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'scribd' => array(
		'p' => 'M2.625 15.813q-1.5-1.813-1.5-5 0-4.563 2.938-7.063t7.5-2.5q2.125-.063 4 .344t3.531 1.375 2.188 1.344 1.781 1.313l-3.188 4.5-2.313-1.5 1.688-2.438q-3.5-2.313-7.688-2.25-2.563 0-4.781 1.313t-2.219 3.5q0 1.5 1.813.938 2.063-.438 3.5.875 1.188 1.188 1.156 2.875t-1.219 2.875q-1.375 1.438-3.594 1.281t-3.594-1.781zm19.875.375q.625.75 1.031 1.875T24 20.501t-.156 2.656-.906 2.625-1.688 2.219q-3.25 2.75-8.375 2.75-6.813.063-11.938-4.5l-.938-.875 3.813-4.5L6 22.626l-2.063 2.438q4 3 9 3 5.938 0 7.563-4.063.125-.375.125-.75 0-1.5-1.813-1-2.125.5-3.5-.875-1.25-1.125-1#q#813 0-1.813 1.313-3.063t3.125-1.125q2.375-.063 3.938 1.813z',
		'w' => .75,
		'vw' => 24
	    ),
	    'bluetooth' => array(
		'p' => 'M18.313 10.688l-2.688 2.688-.063-5.375zm-2.75 13.75l.063-5.375 2.625 2.688zM26 16.188q0 3.188-.344 5.656t-1.094 4.188-1.688 2.906-2.313 1.844-2.813.938-3.313.281q-2.875 0-4.969-.688t-3.875-2.375-2.688-4.875-.906-7.844.906-7.938T5.528 3.25 9.372.75 14.31 0q2.75 0 4.813.75t3.656 2.531 2.406 5 .813 7.906zm-9.875 0l4.938-5.5L13.25 2.25v11.063L8.625 8.75l-1.688 1.625 5.813 5.875L6.937 22l1.688 1.688 4.625-4.563.125 10.625 7.938-8z'
	    ),
	    'bluetooth-b' => array(
		'p' => 'M12.25 16.25l6.125 6.438-9.25 9.313-.188-12.375-5.375 5.375-1.938-2 6.75-6.75-6.75-6.75 1.938-2 5.375 5.375V.001l9.125 9.813zm2.563-6.437l-3.125-3.125v6.25zm-3.125 9.75v6.25l3.125-3.125z',
		'w' => .625,
		'vw' => 20
	    ),
	    'gitlab' => array(
		'p' => 'M6.563 1.563l3.563 10.938h-8.25l3.5-10.938q.188-.438.625-.438t.563.438zM.063 18l1.813-5.5 14.125 18.375-15.5-11.5Q-.187 18.812.063 18zm10.062-5.5h11.75L16 30.875zM31.938 18q.25.813-.438 1.375L16 30.875 30.125 12.5zM26.625 1.563l3.5 10.938h-8.25l3.563-10.938q.125-.438.563-.438t.625.438z'
	    ),
	    'wpbeginner' => array(
		'p' => 'M28.938 20.125q1.25 1.5 1.375 3.25t-.688 3.219-2.531 2.438-3.906.969q-1.875 0-3.594-.813t-2.656-2.313h-1.875q-.938 1.5-2.656 2.313t-3.594.813q-2.188 0-3.906-.969t-2.531-2.438-.688-3.219 1.375-3.25q-1.438-2.375-1.594-5t.875-4.938 2.938-4.156 4.719-2.938 6-1.094 6 1.094 4.719 2.938 2.938 4.156.875 4.938-1.594 5zm-21.25-5.187h2.625v-3.625H7.688v3.625zm13.562 5.375v-1.438q-2.813 1-5.969.438T9.562 16.75v1.563q2.375 2.125 5.75 2.688t5.938-.688zm-9.375-5.375H22.25v-3.625H11.875v3.625z',
		'w' => .998046875
	    ),
	    'wpforms' => array(
		'p' => 'M28 4.688v22.625q0 1.125-.781 1.906T25.313 30H2.688q-1.125 0-1.906-.781t-.781-1.906V4.688q0-1.125.781-1.906t1.906-.781h22.625q1.125 0 1.906.781T28 4.688zm-2.312 22.625V4.688q0-.375-.375-.375h-.563l-6.938 4.688-3.813-3.125-3.813 3.125-6.938-4.688h-.563q-.375 0-.375.375v22.625q0 .375.375.375H25.31q.375 0 .375-.375zM9.375 11.625v2.313H4.812v-2.313h4.563zm0 4.625v2.375H4.812V16.25h4.563zm.688-9.187l3.375-2.75H6.063zm13.125 4.562v2.313h-12.25v-2.313h12.25zm0 4.625v2.375h-12.25V16.25h12.25zm-5.25-9.187l4-2.75h-7.375zm5.25 13.875v2.313H17v-2.313h6.188z'
	    ),
	    'envira' => array(
		'p' => 'M0 2q5.375 0 9.531.875t6.656 2.25 4.156 3.313 2.313 3.844.875 4.063.031 3.688-.406 3.031-.219 1.813L28 30.002h-1.625L22 25.564q-.375 0-1.219.156t-1.563.25-1.75#q#031-.031-2.156-.406-2.344-.906-2.375-1.563q-1.625-1.313-2.719-2.75t-1.844-3.469-1.188-3.813-1.25-5.156-1.563-6.063zm5 2.875q-1.438-.625-1.5-.5T4.063 5l.563.438q1.375.938 2.5 2.313t1.594 2.25 1.594 2.938q4.438 8.563 9 10.5 2.375 1 2.375.938.063-.063-.75-.625-.813-.5-1.25-.875-2.313-1.688-5.688-8.125-.875-1.625-1.25-2.281T11.47 10.44 9.782 8.284t-2.031-1.75-2.75-1.656z'
	    ),
	    'glide' => array(
		'p' => 'M15.813 9.313q0 .625-.25 1.625-.563 2.75-1.063 5.25-.063.313-.875.313-1 0-1.438-.875t-.438-2q0-1.563.594-3.063t1.781-2.125q.5-.25.875-.25.813 0 .813 1.125z#b#m-4 11.688q0-.25-.688-1.313t-.938-1.125q-.313-.188-.563-.188-.313 0-.594.031t-.563.125l-.469.156-.531.25-.469.219-.531.281-.469.313-.063-.063q.063-.438.5-2.406t.438-3.031q0-3.938-4.25-3.938-1.563 0-2.906.75T9.748 8.655t-1.25 2.469-.438 2.594.375 2.281 1.063 1.656 1.688 1.031 2.313.375h.188q.25 0 .25.063l-.063.063q-.438 3.75-2.25 4.438-1 .375-1.188-.5l-.063-.25q0-.438.188-.844t.438-.656.5-.438.438-.313l.188-.125q0-.313-.906-.688t-1.344-.375q-.5 0-.906.313t-.656.813-.375 1.031-.125.969q0 1 .406 1.781t1.156 1.219 1.75.438q2.125 0 3.719-1.75t2.156-4q.125-.375.219-.75t.125-.625.094-.438.094-.313.031-.219.031-.125.094-.063.125-.094q2.063-1.063 3.625-1.063.313 0 2.313.313.25.063.25-.188z'
	    ),
	    'glide-g' => array(
		'p' => 'M25.438 13.188q.375.125 1.469 1.844t1.094 2.156q0 .313-.438.313-3.125-.5-3.688-.5-2.5 0-5.813 1.688l-.188.094-.094.125-.063.156-.094.25-.094.375-.094.5-.156.688-.219.906-.25 1.156q-.938 3.5-3.5 6.281t-5.938 2.781q-2.5 0-3.938-1.531t-1.438-3.969q0-1.563.906-3.25t2.344-1.688q.75 0 2.219.594t1.469 1.094q0 .063-.219.188t-.531.344-.688.563-.688.719-.5.906-.188 1.094q0 1.25 1.188 1.375 1.75.063 3.125-2.563 1-1.875 1.375-4.688 0-.25-.063-.25h-.625q-4.125 0-6.406-2.219t-2.281-6.344q0-2.813 1.156-5.563t3.719-4.781T13.246.001q2.25 0 3.75.625t2.281 2.031.781 3.656q0 1.75-.688 4.938t-.813 3.813l.063.063q.188-.125.719-.406t.719-.406.656-.375.719-.344.688-.25.75-.219.75-.125.875-.063q.375 0 .938.25zM14.5 7.938q.313-1.625.313-2.688 0-.375-.031-.656t-.125-.563-.375-.406-.719-.125q-.688 0-1.375.375-1.938 1.063-2.906 3.469t-.969 4.906q0 1.125.25 2.063t.969 1.719 1.844.781h.563l.281-.031.25-.063.156-.125.125-.281q.813-3.938 1.75-8.375z',
		'w' => .9375,
		'vw' => 30
	    ),
	    'viadeo' => array(
		'p' => 'M17.25 9.375v.063Q15.687 4.813 12.812 0q1.938 1.25 3.094 4t1.344 5.375zM19.313 17q1.375-.25 2.625-1.063.813 1.938.906 4.031t-.688 4.406-2.469 4.125q-3.188 3.5-8.125 3.5t-8.125-3.5q-2.5-2.625-3-6.125t.688-6.438 3.969-5 6.469-2.063q2.063 0 3.875.688-.688 1.313-#r#688-1.438-.563-3.063-.563-3.625 0-6.063 2.625t-2.438 6.25q0 2.125.875 3.969t2.469 3.063 3.656 1.594q2.188-.875 3.719-2.906t2.25-4.688 1-5.063.281-4.844q0-1.5-.063-2.25 1.188 3.438 1.188 7 0 8.563-6.813 12.813l-.25.063q3.688.063 6.156-2.5t2.469-6.25q0-1.875-.688-3.563zM26.125.75Q27.688 3 27.75 6.094t-1.406 5.375T22.5 13.75q-1.75 0-3.438-1.625 4.688-2.563 6.25-5.25.375-.813.438-1.25-.938 2.063-3 3.625t-4.375 2.063q-.75-1.188-.75-2.438 0-1.875 1.25-3.125.813-.75 2.313-1.188t2.813-1.219T26.126.749z',
		'w' => .873046875,
		'vw' => 28
	    ),
	    'viadeo-square' => array(
		'p' => '#a#m-7.437 21.813q1.563-1.688 1.875-3.938T19 16q-.813.438-1.688.625.438 1 .438 2.25 0 2.313-1.531 3.906t-3.844 1.531h.125q4.25-2.688 4.25-8 0-2.25-.688-4.375v-.063q-.125-1.063-.438-2.156t-.938-2.125-1.438-1.594q1.813 3.063 2.813 5.938v1.375q0 1.563-.188 3.031t-.625 3.156-1.406 2.938-2.344 1.813q-1.875-.375-3.094-1.875t-1.219-3.5q0-2.25 1.531-3.906t3.781-1.656q1 0 1.875.375.125-.875.563-1.688-1.188-.438-2.438-.438-2.313 0-4.063 1.281t-2.5 3.125-.406 4.031 1.844 3.813Q9.372 26 12.466 26t5.094-2.188zm1.75-9.188q1.5 0 2.406-1.438t.875-3.375-1.031-3.375q-.5 1.188-1.313 1.656t-1.75.75-1.438.719q-.813.813-.813 2 0 .813.5 1.5 1.438-.313 2.719-1.281t1.844-2.219q0 .25-.25.75-1 1.688-3.875 3.313 1 1 2.125 1z'
	    ),
	    'snapchat' => array(
		'p' => '#d#10.625 21.188q.188-.563-.313-.688-.813-.125-1.563-.563t-1.188-.844-.844-.969-.5-.781-.156-.406h-.063q-.188-.5-.063-.813.125-.375 1.188-.688.25-.125.313-.125 1.063-.438 1.063-1.063 0-.5-.625-.75-.5-.125-.875 0-.5.25-.938.313-.188 0-.313-.125.188-3.75-.25-4.813-.5-1.125-1.344-1.875T17.81 6.373t-2.125-.375h-.375q-.5 0-1.031.094t-1.375.406-1.625 1.063-1.219 1.813q-.5 1.063-.25 4.813-.188.125-.438.125-.438 0-1-.25-.25-.125-.531-.063t-.531.25-.25.438q-.188.688 1.063 1.125.063.063.344.156l.469.156.375.219.313.281q.125.313-.125.813-.063.188-.188.406t-.5.781-.844 1-1.188.844-1.531.531q-.375.063-.375.5.063.875 2.813 1.313.063.063.094.156t.063.25l.063.313.094.281q.063.375.5.375.125 0 .656-.094t.969-.094q1.125 0 2.313.875 1.75 1.188 3.063 1.125 1.375.063 3.063-1.125 1.188-.875 2.313-.875.5 0 1 .094t.625.094q.438 0 .5-.375.063-.125.125-.375t.094-.406.094-.219q2.438-.375 2.813-1.125z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'snapchat-ghost' => array(
		'p' => 'M31.938 24.563q-.5 1.125-4.25 1.688 0 .063-.063.313t-.156.594-.156.594q-.188.563-.75.563-.25 0-1-.156t-1.438-.156q-1.188 0-1.813.281t-1.75 1.031q-2.5 1.813-4.625 1.688-1.875.188-4.5-1.688-1.125-.75-1.75-1.031t-1.813-.281q-.625 0-1.438.156t-1 .156q-.563 0-.75-.563-.063-.188-.156-.563l-.156-.625-.063-.313q-1-.125-1.75-.313t-1.625-.656-.938-1.031v-.063q0-.563.563-.625.875-.188 1.719-.531t1.438-.813 1.156-1.031.906-1.031.625-.969.375-.688l.156-.313v-.063q.375-.688.188-1.125-.125-.313-.438-.531t-.594-.313-.719-.219-.5-.188q-1.813-.75-1.625-1.75.125-.563.844-.875t1.219-.063q.875.375 1.5.375.375 0 .625-.125-.188-1.5-.188-3.781t.5-3.469q.75-1.625 1.906-2.75t2.406-1.594 2.063-.625 1.563-.156h.625q1.688 0 3.156.563t2.75 1.719 2.031 2.844q.5 1.188.5 3.469t-.188 3.781q.25.125.563.125.625 0 1.375-.375.625-.313 1.313 0 .938.313.938 1.125 0 .875-1.625 1.563-.125.063-.438.125-1.563.5-1.813 1.125-.188.438.188 1.125v.063q.063.25.25.594t.781 1.156 1.25 1.469 1.781 1.313 2.313.844q.313.063.469.344t.031.656z'
	    ),
	    'snapchat-square' => array(
		'p' => '#a#m-.375 19.688q.188-.563-.313-.688-.625-.063-1.188-.313t-.938-.563-.75-.688-.594-.688-.438-.656-.281-.438-.063-.219h-.063q-.188-.5-.063-.813.125-.375 1.188-.688.25-.125.313-.125 1.063-.438 1.063-1.063 0-.5-.625-.75-.5-.125-.875 0-.5.25-.938.313-.188 0-.313-.125.188-3.75-.25-4.813-.75-1.625-2#q#5t-3.125-.875h-.375q-.5 0-1.031.094t-1.375.406-1.625 1.063-1.219 1.813q-.5 1.063-.25 4.813-.188.125-.438.125-.438 0-1-.25-.313-.188-.781.031t-.531.594q-.188.688 1.063 1.125l.438.156.688.313.375.344q.125.313-.125.813-.063.188-.188.406t-.5.781-.844 1-1.188.844-1.531.531q-.375.063-.375.5.063.875 2.813 1.313.063.063.094.219t.094.406.125.375q.063.375.5.375.125 0 .656-.094t.969-.094q1.125 0 2.313.875 1.75 1.188 3.063 1.125 1.375.063 3.063-1.125 1.188-.875 2.313-.875.5 0 1 .094t.625.094q.438 0 .5-.375.063-.125.125-.375t.094-.406.094-.219q2.438-.375 2.813-1.125z'
	    ),
	    'pied-piper' => array(
		'p' => 'M2 26.188l-2 3.75.063-20.5q0-3.063 2.188-5.25T7.501 2h20.438q-4.313 1.375-8.563 4.188t-7.313 6.375Q6.5 18.938 2 26.188zM28 2v20.563q0 3.063-2.188 5.25t-5.25 2.188H-.001q.813-1.063 2.406-2.25t2.906-1.875q.688-.313 2.156-.938t2.563-1.219 1.906-1.344q1.125-1.125 1.875-2.75t1.406-3.875 1.156-3.313q.5-1.25 1.469-2.531t2.031-2.281 2.219-1.906 2.188-1.563T26.155 3t1.344-.75z'
	    ),
	    'first-order' => array(
		'p' => 'M14 6.063q.75 0 1.375.063l-.25 4.25 1.375-4q1.313.313 2.5 1.063l-1.813 3.813L20 8.064q1.063.813 1.875 1.938l-3.125 2.813 3.813-1.875q.625 1.125 1 2.563l-4 1.375 4.25-.25q.063.563.063 1.375t-.063 1.375l-4.188-.25 4 1.375q-.375 1.313-1.063 2.5l-3.813-1.813 3.125 2.813q-.75 1.063-1.875 1.938l-2.813-3.188 1.813 3.813q-1.063.688-2.5 1.063l-1.375-4.063.25 4.313q-.688.063-1.375.063t-1.375-.063l.25-4.25-1.375 4q-1.313-.313-2.5-1.063l1.875-3.813-2.813 3.188q-1.063-.75-1.938-1.938l3#q#813-3.813 1.875q-.75-1.25-1.063-2.563l4-1.375-4.25.25q-.063-.813-.063-1.375 0-.688.063-1.375l4.25.25-4-1.438q.313-1.25 1.063-2.5l3.813 1.875-3#q#813q.813-1.063 1.938-1.938l2.813 3.188-1.875-3.875q1.188-.688 2.5-1l1.375 4-.188-4.25q.625-.063 1.313-.063zM27.688 8v16L14 32 .312 24V8L14 0zm-1.063.625L14 1.312 1.375 8.625v14.688L14 30.688l12.625-7.375V8.625zM14 2.313l11.75 6.813v13.688L14 29.689 2.25 22.814V9.189zM14 5.5q-4.313 0-7.375 3.063t-3.063 7.438q0 4.313 3.063 7.406T14 26.501t7.375-3.094 3.063-7.406q0-4.375-3.063-7.438T14 5.5z'
	    ),
	    'yoast' => array(
		'p' => 'M5.688 4.75h11.625l-.438 1.188H5.687q-1.813 0-3.156 1.281t-1.344 3.094v12.875q0 1.813 1.344 3.094t3.906 1.281v1.188h-.75q-2.313 0-4-1.656t-1.688-3.969V10.313q0-1.5.75-2.781t2.063-2.031 2.875-.75zM20 1.25h4.188Q23 4.375 21.75 7.656t-2 5.281-1.563 4.156-1.281 3.344-.969 2.438-.813 1.906l-.625 1.313-.594 1.063-.563.781-.719.75q-1.875 1.938-4.875 2.063v-3.188q2.063-.313 3.031-1.75t.969-2.938l.063-.063q0-.688-.313-1.531T9.435 16Q7.81 11.937 6.622 8.875h3.875l3.125 9.813zm8 8.875V28.75H14.625q.625-.875.75-1.188h11.438V10.124q0-2.875-3.063-3.938l.438-1.125q3.813 1.25 3.813 5.063z'
	    ),
	    'themeisle' => array(
		'p' => 'M13 5.531q0-.531.313-.938t.813-.406.781.406.281.906q0 .375-.125.656t-.375.5-.563.219q-.5 0-.813-.406t-.313-.938zM32 15.5q0 2-.594 4.469t-1.656 3.656q-1.063 1.125-3.5 2.531t-4.063 1.906h-.063v2q0 .563-.25 1t-.656.688-.906.25q-1 0-1.563-.875-.563.875-1.563.875t-1.563-.875q-.5.875-1.5.875t-1.563-.875q-.563.875-1.563.875-.563 0-.969-.281t-.625-.75-.219-1.031q-1.625 1.25-3.563 1.25-2.125 0-3.75-1.438.938-.063 1.875-.375-2-.563-3.25-2.25 2.25.5 4.188-.688-3.375-3.438-4.25-5.5-.438-1-.438-2.875 0-1.313.281-2.875t.844-3.219 1.688-2.781 2.563-1.125q1.063 0 1.438.938.375-.5.75-.938l.5-.5 1.313-2.125q1.563-2 3.781-3.188t4.656-1.188q.625 0 1.125.063Q19.998-.001 21.56-.001q1.438 0 2.5 1 .063.125.063.25t-.813 1q1 .313 1 .75 0 .125-.313.438 2#r#5 3.563 6.75.438-.5 1.063-.5.813 0 1.75.875 1.625 1.375 1.625 4.938zM11.75 5.594q0 .906.563 1.625t1.438.719 1.469-.719.594-1.656q0-.563-.25-1.063t-.719-.844-1.094-.344q-.875 0-1.438.688t-.563 1.594zm3.125 6.531q0-1.563.5-3.625-1.188 1.813-1.406 3.875t.406 3.75 2.031 2.781T19.687 20q2 0 3.75-1.25.25-.875.25-1.375 0-1.375-1.313-1.375-.313 0-.813.125-3.25.625-4.969-.188t-1.719-3.813zm-2.562 15.938q0-.563-.375-.938t-.906-.375-.906.375-.375.938v2q0 .313.094.531t.281.406.406.313.469.125q.563 0 .938-.406t.375-.969v-2zm3.062 0q0-.375-.156-.656t-.469-.469-.625-.188q-.563 0-.938.375t-.375.938v2q0 .563.375.969t.906.406.906-.406.375-.969v-2zm3.063 0q0-.563-.344-.938t-.875-.375-.906.375-.375.938v2q0 .563.375.969t.906.406.875-.406.344-.969v-2zm3.125 0q0-.563-.375-.938t-.906-.375-.875.375-.344.938v2q0 .563.344.969t.875.406.906-.406.375-.969v-2zm4.812-10.188q-1 1.875-2.469 3.313t-3.438 2.281-4.031.844q-4.375 0-7.188-3.281t-2.813-7.781q0-1.563.375-3.125-1.875 3.125-1.875 7 0 2.875 1.156 5.563t3.281 4.5q.563-1.063 1.625-1.063 1 0 1.563.938.563-.938 1.563-.938t1.5.938q.563-.938 1.563-.938t1.563.938q.563-.938 1.563-.938 1.063 0 1.563 1 2-1.688 3.188-4.125t1.313-5.125zm.625-6.25Q27 9 25.406 7.031T21.25 5.062q-2.813 0-4.938 2.25-2.563 8.563 2.563 8.563.375 0 1.313-.156t1.594-.219 1.375.094.969.781.063 1.813q2.813-2.563 2.813-6.563z'
	    ),
	    'font-awesome' => array(
		'p' => 'M24.875 2q1.25 0 2.188.938t.938 2.188v21.75q0 1.25-.938 2.188t-2.188.938H3.125q-1.25 0-2.188-.938t-.938-2.188V5.126q0-1.25.938-2.188T3.125 2h21.75zM22 19.75V11q0-.5-.5-.5-.063 0-1.313.5t-2.063.5q-.5 0-.813-.125-2.313-.875-3.813-.875-1.75 0-3.875.875-.125.125-.313.188v-1.188q.813-.563.813-1.625 0-.875-.625-1.469t-1.5-.594-1.469.594-.594 1.469q0 1 .813 1.625v13.688q0 .5.375.875t.875.375q.938 0 1.188-.875v-.063q.063-.063.063-.313v-2.813q.063-.063.125-.063t.125-.063q2.375-1.063 4.188-1.063 1.063 0 2.375.531t2.125.531q1.375 0 3.375-.875.438-.188.438-.5z'
	    ),
	    'linode' => array(
		'p' => 'M27.313 14.125q.063.063-.563 4.563 0 .125-.063.125l-3.438 2.75q-.125.063-.25 0l-1.25-.875-.125 2.063q0 .125-.063.125l-4.188 3.375q-.125.125-.25 0l-1.75-1.5.125 2.875q0 .125-.063.125l-5.25 4.188q-.063.063-.125.063l-.125-.063-4.063-4.313q-.125-.063-1.063-4.938-.063-.125.063-.188l1.125-.688q-1.688-1.563-1.688-1.625l-1.313-6.25q-.063-.125.125-.25l1.688-.813q-2.375-1.813-2.438-1.938L.683 2.623q-.063-.125.125-.188L8.496-.003h.188l5.625 2.75q.125.063.125.188l.375 8.25q0 .125-.125.188l-2.125 1.063 2.25 1.563q.125 0 .125.125l.063 2.188 2.188-1.313q.063-.063.188 0l1.5 1 .063-2q0-.063.063-.125l3.688-2.25q.125-.063.188 0l4.375 2.375zm-12.75.313L8.25 18.001l.875 6.063 5.688-3.813zm-.5-11.25L6.5 6.126l1.25 8.375 6.625-3.438zM2.75 10.813l4.563 3.563-1.188-8.313-5-3.063zm1.938 9.25l4 3.813-.813-5.875L3.5 14.376zm1.5 7.375l3.625 3.813-.625-4.25-3.875-3.75zm4 4l4.938-3.875-.25-4.375-5.313 3.813zm5.125-7.188l1.688 1.438v-4.25L15.126 20q0 .438-.063.5l-1.375.938 1.5 1.25q.125.063.125 1.563zm5.937-1.562l.25-4.188-4.125 2.938.063 4.25zm1.688-1.625l.375-4.188-4-2.5-.063 1.875 2.563 1.688q.125.063.063.188l-.125 2.125zm3.437-2.5l.5-3.938-3.188 2.25-.313 4.063z',
		'w' => .873046875,
		'vw' => 28
	    ),
	    'quora' => array(
		'p' => 'M27.5 24.188q.063.563-.094 1.406T26.75 27.5 25 29.281 22 30q-3.688 0-6-3.875-3.625 1-7.25-.25T2.781 21.5.437 14.312q0-5.313 3.75-8.813t8.625-3.5q4.938 0 8.656 3.469t3.719 8.844q0 5.938-4.625 9.563 1.438 2.25 3.063 2.25.5 0 .906-.188t.625-.5.375-.625.156-.625H27.5zm-8.937-3.625q1.063-2.313 1.063-6.25 0-5-1.656-7.438t-5.156-2.438T7.72 6.875t-1.594 7.438q0 4.938 1.594 7.375t5.094 2.438q1.188 0 2.063-.313-.438-.813-.813-1.375t-.906-1.188-1.188-.938-1.469-.313q-.688 0-1.188.25l-.813-1.5q1.688-1.438 4.375-1.438 2.063 0 3.344.844t2.344 2.406z',
		'w' => .873046875,
		'vw' => 28
	    ),
	    'free-code-camp' => array(
		'p' => 'M4.313 9Q2.438 12.313 2.5 16.219t1.875 7.031q.5.75 1.094 1.5t1 1.125.719.781.313.719-.25.563-.563.25q-.5 0-1.469-.875t-2.063-2.406-1.875-3.969T.5 15.813q0-2.438.781-4.719t1.813-3.719 2-2.313 1.469-.875q.188 0 .406.094t.375.25.156.344q0 .375-.469.875T5.75 7.156 4.312 9zm12.25 13.375q-1.813-.625-2.938-2.094T12.5 17q0-1.5 1.813-4.281T16.126 8.5q0-.75-.406-1.438t-.844-.938q-.313-.188-.313-.313.188-.438.938-.313t1.375.438q1.438.688 2 1.719t.875 2.906q.375 2.063 1 2.063.75 0 .75-.75 0-.188-.5-1.5-.063-.375.063-.438.438 0 1.438 1.063 2 2.125 2 5.125 0 1.313-.469 2.438t-1.188 1.906-1.656 1.281q-.75.5-.75-.125 0-.125.438-.594t.906-1.25.469-1.656q0-1.125-.5-1.938-.5-.625-.75-.625v.063q0 .188.094.531t.094.531q0 .625-.875.75-1-.063-1.063-1.188v-1.313q0-.375-.125-.688-.188-.375-.625-.813t-.813-.438q-.188 0-.188.125 0 .063.25.406t.25.844q0 1-1.375 2.188t-1.375 2.188q0 1.438.625 2.375.438.688 1.188 1 .25.063.25.188 0 .375-.75.063zM29.375 4.188q.563 0 1.531.906t2.031 2.438 1.813 3.969.75 5.063q0 2.313-.75 4.563T33 24.877t-2.031 2.406-1.656.906q-.25 0-.531-.25t-.281-.469.438-.75 1.031-1.156.719-.813q1.938-2.438 2.563-5.625t-.281-6.594-3.344-5.969Q28.502 5.375 28.502 5q0-.313.313-.563t.563-.25zM26.75 24.375q.75 0 .75 1t-.75 1H10.437q-.375 0-.656-.281t-.281-.719q0-.25.094-.469t.313-.375.531-.156h16.313z',
		'w' => 1.123046875,
		'vw' => 36
	    ),
	    'telegram' => array(
		'p' => '#d#7.625 10.625q.125-.75-.219-1.094t-.844-.156L7.124 15.688q-.813.25-.844.625t.656.563l3.813 1.188 8.875-5.563q.375-.25.563-.063.063.063-.063.188l-7.188 6.5-.313 3.938q.438 0 .813-.375l1.875-1.813 3.875 2.875q1.125.625 1.375-.625z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'bandcamp' => array(
		'p' => '#d#3 20.375l5.313-9.75H12.5l-5.313 9.75H18.5z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'grav' => array(
		'p' => 'M18.813 13.25q.5.5 0 1l-.625.625q-.5.563-1 0l-.688-.625q-.438-.563 0-1.063l.625-.625q.5-.5 1.063 0zM16.938 12q-.313.313-.688 0-.313-.313 0-.625.375-.375.688 0 .313.313 0 .625zm-1.625.375q.313-.375.625 0 .375.313 0 .625-.313.313-.625 0-.375-.313 0-.625zm4.5-.875q-1-.75-1.313-1.875t.625-2.375q1.625-1.875 3.688.063.063 0 .25.188l.25.25.219.25.219.25.188.281.156.313.063.313v.375l-.094.375-.188.406q-.563 1.125-1.844 1.5t-2.219-.313zm3-2.75q-.25-.313-.594-.156t-.469.5.125.656q.375.5 1 .125.5-.438-.063-1.125zM31.5 16q0 6.438-4.531 10.969T16 31.5 5.031 26.969.5 16 5.031 5.031 16 .5t10.969 4.531T31.5 16zm-4.125 2.688q.063-.625-.719-1.063t-.844-.563q-.688-1.25-1.469-1.719t-1.969-.219q.313-.188.688-.281t.563-.094h.25q0-.75-.625-1.5.063-.25.094-.469t.031-.375-.031-.313-.031-.219l-.063-.063q1.625-.875 1.875-2.688.125-1.438-.781-2.594T22 5.184q-.688-.063-1.344.094t-1.188.563-.844.969q-.563.875-.625 1.75t.25 1.5.75 1.094 1 .719q-.813-.063-1.531-.625t-.969-1.5q-.5-1.875.563-3.875l-.5-.5q-.875 0-1.563.313.313-.438.719-.656t.656-.219l.188-.063q0-.813-.188-1.313-.25-.563-.938-.563t-1.063.75v-.063q-.25.438.031 2.281t1.031 3.156q-.438.25-.813.625-.375.188-.875.656t-.938.969-.844 1-.594.813l-.25.375q-1.563.563-3.125 2.156t-1.25 2.781q0 .313.125.5l-.5.5q-.625.688-.25 1.344t1.375.219q1.438-.688 2.25-1.938l-.094-.063-.344-.125-.563-.063q2.438-.563 2.875-.563.25.063.375-.469t.125-1.094v-.625q0-1.75-.688-2.563 1.813 1.75 1.75 3.813 0 .313-.125.563t-.25.406-.25.25-.25.156h-.063q-.063.125-.313.563t-.469.813-.469.906-.438 1.063-.313 1.094-.094 1.125.156 1.063q-.563-.875-.625-1.375-2.938 3.313-1.5 4.063 1.188.625 4.094-2.813t3.781-6.063q2.875-1.75 4-4.063 1.125 2.188 3.625 3.75 2.438 1.438 2.688-.063z'
	    ),
	    'etsy' => array(
		'p' => 'M24 21.75q-.625 3.75-1 8.25-10.688-.375-23 0v-1.625q.313-.063.844-.156t.781-.125.625-.125.531-.156.375-.188.313-.219.188-.281.125-.406.031-.531q.313-13 0-20.125 0-.25-.031-.469t-.094-.375-.156-.281l-.188-.25-.313-.188-.375-.125-.5-.125-.594-.125-.75-.156-.813-.156V2.25q16.188.5 22.688-.25l-.5 7.875h-1.438L20.53 9l-.25-.906-.25-.844-.281-.844-.313-.688-.375-.625-.469-.438-.594-.313-.688-.094H8.747q-.438 0-.531.125t-.094.5v10.25l5.5-.188q.313 0 .5-.031l.375-.063.344-.156.25-.188.188-.313.156-.375.156-.531.156-.656.188-.813.25-.938h1.563q-.188 4.688-.188 5.063t.125 4.938H16.06q-.063-.313-.219-.969t-.219-.906-.188-.688-.25-.563-.375-.344-.531-.281-.719-.125q-1.313-.125-5.5-.125v8.688q0 2.438 2#r#438h5.563q.75 0 1.344-.125t1-.188.844-.469.625-.563.563-.906.531-1.031.625-1.406.656-1.563h1.375z',
		'w' => .75,
		'vw' => 24
	    ),
	    'imdb' => array(
		'p' => '#a#M6.063 20v-8H4v8h2.063zm7.062 0v-8h-2.688l-.438 3.75q-.375-2.563-.563-3.75H6.748v8h1.813v-5.313L9.311 20h1.313l.75-5.438V20h1.75zm.75 0h.938q2.875 0 3.344-.438t.406-3.063v-1.688q0-1.125-.125-1.5-.125-.625-.656-.938t-.969-.344-1.188-.031h-1.75v8zm10-1.812v-2.25q0-.688-.031-1.031t-.375-.625-.969-.281q-.75 0-1.313.625v-2.625h-1.938v8h1.875l.063-.5q.563.625 1.313.625 1.375 0 1.375-1.938zm-7.312-3.813v3.781l-.156.313-.469.156v-5.25q.313 0 .438.125t.156.25.031.438v.188zM21.875 16v2.063q0 .875-.375.875-.125 0-.219-.156t-.094-2.781q0-.813.313-.813.375 0 .375.813z'
	    ),
	    'ravelry' => array(
		'p' => 'M25.438 3.875q3.375 1.75 5.125 5.156t1.375 7.281q-.25 2.063-.625 3.25-1.063 3.25-2.781 5.375t-4.906 3.875q-.75.5-1.25.688-1.125.375-2.5.25h-1.125q-4.375 0-7.781-2.656t-4.531-6.781h-.188q-.125 1.188.281 2.813t.906 2.688l.563 1q.125.188.813 1.25-1.75-.938-2.75-2.969t-1.188-3.656l-.125-1.563q-4.25-1.625-4.75-2.375 2.563 1.375 4.75 1.688l.063-.5q.125-2.313 1.438-4.438.625-3.125 2.688-5.625.438-1.813 1.25-3.313.438-.813 1.25-1.188 7.688-3.563 14-.25zm-16.75 6.313q-.688 1-1.188 2.313.625-.688 1.125-1.063zM6.75 17.813q.063.938.25 1.75l2.563.438q-.375-1.188-.625-2.594t-.313-2.219l-.063-.813q-1.25 1.25-1.813 3.438zm.5 2.687q1 3.25 3.594 5.563t6.031 2.813q-.125 0-.188-.063-.188-.125-.563-.344t-1.344-1-1.781-1.625-1.719-2.125-1.344-2.656Q9.623 21 7.248 20.5zm16.875 7.25q3-1.5 4.844-4.438t1.844-6.438q0-5-3.531-8.563t-8.531-3.563q-4.625 0-8 3.063-.5.875-.75 2.438 1.5-1.188 3.781-1.719t3.844-.469l1.5.125q1.375.063 1.313 1.75-3.688-.313-6 .531t-4.563 2.781q.563 4.875 1.688 6.875 3 .125 5.969-.688t4.469-1.75l1.438-.875q1.188-.875 1.313.25.25 1.5-.563 1.875-3.188 1.5-7.188 2.063-2.063.313-4.875.25.625 1.5 1.688 2.719t2.094 1.938 2 1.219 1.594.688l.563.188q2.25.375 4.063-.25z',
		'w' => .998046875
	    ),
	    'sellcast' => array(
		'p' => 'M22.063 2q1.625 0 3 .781t2.156 2.156.781 3v16.125q0 2.438-1.75 4.188T22.062 30H5.937q-2.438 0-4.188-1.75t-1.75-4.188V7.937q0-2.438 1.75-4.188t4.188-1.75h16.125zm-3.125 19.781q1.313-2.281.625-4.813t-2.938-3.844q-.25-.188-.406-.25l-.156-.063q0-.063-.031-.063t-.156-.063-.375-.25q-1.188-.688-1.844.5t.469 1.875q.563.313 1.188.625 1.25.75 1.656 2.219t-.344 2.75-2.219 1.688-2.719-.344q-.313-.188-.438-.25t-.156-.063h-.031v-.031l-.156-.094-.406-.25q-.5-.25-1.031-.125t-.781.625l-1 1.688q-.563 1.063.313 1.75 1.125.938 2.188-.688.063-.125.125-.188 2.25 1.25 4.781.594t3.844-2.938zM20.313 8.75q.438-.75 0-1.406t-1.125-.656T18 7.376l-.313.5q-2.313-1.25-4.844-.563T9.03 10.251t-.625 4.781 2.969 3.844q.25.188.375.25t.188.063v.063l.156.063.406.25q1.188.688 1.844-.5t-.469-1.875l-1.188-.625q-1.313-.75-1.688-2.219t.375-2.75 2.219-1.688 2.719.344q.313.188.438.25l.125.063q.063 0 .063.031t.125.094.438.25q.938.438 1.625-.25.125-.125 1.188-1.938z'
	    ),
	    'superpowers' => array(
		'p' => 'M28 2l-5.438 5.438q3.938 3.875 3.563 9.25-.25 4.375-3.219 7.531t-7.281 3.719q-2.188.313-5 .688T5 29.345t-5 .656l5.438-5.438Q1.5 20.75 1.813 15.313q.25-4.375 3.25-7.531t7.313-3.719q3-.375 8.438-1.094T28.002 2zm-5 14.5q.25-3.688-2.25-6.438t-6.25-3Q12.062 6.937 9.937 8t-3.5 3.063-1.5 4.438q-.188 3.75 2.313 6.469t6.25 2.969q3.688.188 6.5-2.25t3-6.188z'
	    ),
	    'wpexplorer' => array(
		'p' => 'M32 16q0 6.625-4.688 11.313t-11.313 4.688-11.313-4.688T-.002 16 4.686 4.687 15.999-.001t11.313 4.688T32 16zm-2 0q0-5.75-4.094-9.875T16 2 6.094 6.094 2 16t4.094 9.906T16 30t9.906-4.094T30 16zM10.063 7.813l5.438 2.313-2.313 5.438-5.438-2.313zm6.875 10.562l2.938 5.875h-.938L15.813 18l-3.063 6.25h-.875l3.188-6.688-1.375-.625.375-.875 4.25 1.813-.375.938zm-.75-7.312l4.313 1.875-1.875 4.25-4.25-1.813zm5 2.687l3.438 1.438-1.438 3.438-3.438-1.438z'
	    ),
	    'meetup' => array(
		'p' => 'M6.188 25.906q.125.656-.5.781t-.75-.531.5-.781.75.531zm8.937 4.469q.75-.563 1.25.188t-.25 1.25q-.688.563-1.25-.188-.438-.75.25-1.25zM9.781 1.469q-.719.156-.906-.594Q8.75.187 9.438 0q.313-.063.563.094t.313.469q.188.75-.531.906zM2.156 14.156q.469.344.563.906T2.5 16.093t-.875.594-1.031-.219-.563-.906.219-1.063q.313-.438.875-.563t1.031.219zm17-10.687q-.469.281-1.031.156T17.312 3q-.313-.5-.188-1.063t.625-.844T18.78.937t.844.625.156 1.063-.625.844zM7.219 7.063q-.344.25-.781.188t-.688-.438T5.594 6 6 5.312q.375-.188.813-.125t.656.406.156.781-.406.688zm23.281 9.75q.313-.063.625.156t.375.531q.063.375-.125.688t-.563.375q-.313.063-.625-.125t-.375-.563q-.063-.25 0-.469t.25-.375.438-.219zm2.438-3.5q.188.563-.438.75-.688.125-.813-.5t.5-.75.75.5zm-5-4.657q.375-.281.844-.188t.75.5.188.906-.469.75-.875.188-.75-.469-.156-.906.469-.781zm-.375 8.719q1.25 2.063.75 4.406t-2.438 3.656q-1.563 1.125-3.5 1.063-.563 2.25-2.75 2.906t-3.875-.844l-.094.063-.094.125q-1.875 1.25-4.031.844t-3.469-2.219q-.875-1.313-.938-2.938-1.938-.313-3.125-1.875t-1.063-3.531 1.625-3.344q-1.313-2.188-.219-4.5t3.531-2.688q1.25-3.125 4.438-4.25t5.813.875q3.188-1.063 5.813.969t2.375 5.344q1.938.625 2.344 2.625t-1.094 3.313zm-4.375 4.688q-.125-.625-1.375-.813t-1.313-.875q-.125-1.063 1.219-4.125T23 12.375q-.25-1.813-2.125-1.875-.813 0-1.313.313-.438.25-.75-.063-.75-.75-1.188-.75-.813-.188-1.688.563t-1.25.563q-.938-.438-1.5-.688-.5-.188-1.094-.094t-1.125.469-.844.875q-.188.375-.5 1.25t-.656 1.938-.625 1.938-.531 1.719-.25.969q-.438 1.25.313 2.125t2 .813q1-.063 1.563-1.063.125-.25 1.406-3.594t1.406-3.469q.313-.625.875-.313.5.25.375.938 0 .313-.875 2.5t-.938 2.375q-.063.688.375 1t1.063.125 1-.875q.063-.125.531-1.094t1-2.031l1.531-3.063q.375-.5.75-.5.563 0 .438.688 0 .313-1.156 2.656t-1.281 2.844q-.125.625.031 1.25t.563 1.125.969.813q.313.125.938.25t1.281.156 1.094-.25.375-.844zm.312 5.75q.5-.375 1.094-.25t.969.625q.313.5.219 1.094t-.594.938-1.094.219-.938-.594-.219-1.094.563-.938z',
		'w' => 1.029296875,
		'vw' => 33
	    ),
	    'font-awesome-alt' => array(
		'p' => 'M21.188 10.688q.25 0 .406.125t.094.313v8.438q0 .25-.438.438-1.875.875-3.25.875-.813 0-2.063-.5t-2.313-.5q-1.625 0-4.063 1.063-.063.063-.188.063v2.75q0 .188-.063.313v.063q-.25.875-1.125.875-.5 0-.875-.375t-.375-.875v-13.25q-.813-.625-.813-1.625 0-.813.594-1.406t1.438-.594 1.438.594.594 1.406q0 1.063-.75 1.625v1.125q.063 0 .25-.125 2.188-.813 3.75-.813t3.688.813q.375.188.813.188.813 0 2-.5t1.25-.5zM24.875 2q1.25 0 2.188.938t.938 2.188v21.75q0 1.25-.938 2.188t-2.188.938H3.125q-1.25 0-2.188-.938t-.938-2.188V5.126q0-1.25.938-2.188T3.125 2h21.75zm.875 24.875V5.125q0-.375-.25-.625t-.625-.25H3.125q-.375 0-.625.25t-.25.625v21.75q0 .313.25.594t.625.281h21.75q.375 0 .625-.25t.25-.625z'
	    ),
	    'accessible-icon' => array(
		'p' => 'M26.5 16l-.813 9.813q-.125 1.188-1.094 1.594t-1.875-.156-.844-1.75l.625-7.625-2.563.125q1 2 1 4.25 0 3.875-2.625 6.688l-2.438-2.438q1.25-1.438 1.5-3.313t-.438-3.438-2.219-2.656T11.247 16q-2.438 0-4.25 1.625l-2.438-2.438q2.188-2 5.063-2.5l4.75-5.375-2.688-1.563-3.188 2.875q-.938.813-1.938.406T5.339 7.655t.594-1.844l4.25-3.813q1-.875 2.188-.188l8.75 5.063q.75.5.906 1.5t-.531 1.75l-3.625 4.188 6.625-.375q.875-.063 1.469.563t.531 1.5zm-4.062-9.625q-1.313 0-2.25-.938t-.938-2.25.938-2.25 2.25-.938q.875 0 1.594.438t1.156 1.156.438 1.594q0 1.313-.938 2.25t-2.25.938zM11.25 28.5q1.875 0 3.5-1.063l2.438 2.5q-1.813 1.438-4 1.875t-4.219-.125-3.719-1.781-2.719-3.25T1.5 22.25q0-3.313 2.063-5.938l2.5 2.438Q5.063 20.25 5 22t.688 3.188 2.219 2.375 3.344.938z'
	    ),
	    'accusoft' => array(
		'p' => 'M20.125 15.75l-1.438 1.313-2#r#594-1.375 1.281-5#r#125q-.438.188-.438.563 0 .063.031.813t.031.938Q1.185 27.69 1.122 27.69q-1.125.375-1.125.188 0-.063.125-.313.063-.063 3.75-3.688t7.469-7.375 4.031-3.969.469-.406.406-.281.344-.156.281-.125h.063l3.188 4.125v.063zm10 7.5q-.188-.188-7.469-9.531t-7.531-9.594q-.313-.438-.344-.656T15 3.156t.5-.094h.875q3.625-.063 7.25-.063 1.188 0 1.563.125t.813.688q1.063 1.313 13 15.5.938 1.188.438 1.438-.125.063-3.656 1.531t-3.719 1.531q-.438.313-.906.219t-1.031-.781zm9.563.125q.625.125.125.5-.125.063-3.938 2.438t-3.938 2.438q-.313.125-.594.188t-.75.031-.656-.063-.75-.156-.625-.125q-.188-.063-4.969-1.125t-9.5-2.125-4.781-1.063q-.25-.125-.25-.25-.063-.188.688-.438l4.594-1.688 4.781-1.75q.313-.125.875-.188.438 0 4.125.625l3.563 4.625q1.188 1.375 2.25.875l7.375-3.25q.313.063.906.188t1 .219.469.094z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'adversal' => array(
		'p' => 'M30.125 2q1.125 0 1.5.375t.375 1.5v24.25q0 1.188-.375 1.531t-1.5.344H1.812q-1.125 0-1.469-.344t-.344-1.469V3.812q0-1.063.375-1.438t1.438-.375h28.313zm-19 11.75q.875.625.75 1.75-.063.5-1.281.719t-3.063.469-2.781.688q-1.313.688-1.969 1.906t-.531 2.594q.188 1.938 1.719 2.969t3.625.938 3.844-1.219q.5-.375.75-.063.063.063.125.188t.125.188q.313.438 1.406.594t1.531-.156q.313-.25.125-.625-.375-.875-.469-1.938t-.063-1.875-.031-1.75v-2.938l-.031-1.219-.094-1.125-.219-.875-.406-.813-.594-.563-.844-.531q-4-1.625-7.813.313-.563.313-1.25 1.125t-.938 1.656.625 1.219q.438.25 1.438.375.375.125.625.031t.438-.531q.563-1.5 2.281-1.969t2.969.469zm17.938 13.875q0-.313-.125-.469T28.719 27H3.25q-.063 0-.344-.031t-.375 0-.219.188-.125.469q-.063.313.063.469t.25.188.406 0 .344-.031h24.688q.063 0 .344.031t.406.031.25-.156.125-.531zm.25-21.25v-.063q0-.938-.875-.875h-.563q-1.25 0-1.438.219t-.188 1.406V11.5q-1.438-.813-2.75-1.031t-2.219.031-1.688.781-1.188 1.063-.656 1.094q-1.563 3.125-1 6.25.375 2.063 1.375 3.5t2.281 2.031 2.688.531 2.656-.75q.063-.063.188-.125.125-.125.281-.125t.344.313q.25.375.594.438t.906 0 .75-.063q.5 0 .5-.875V6.375zm-3.25 14.5q-.563 1.438-1.719 1.938t-2.25.031-1.656-1.656Q19 18 20.501 14.875q.75-1.625 2.406-1.688t2.656 1.375q.875 1.188.906 3.438t-.406 2.875zM7.688 23.063l-.188-.031-.281-.031-.313-.063-.313-.125-.281-.156-.313-.219-.219-.281-.156-.344-.063-.438q-.063-1.313 1.25-1.625.25-.063 4.563-.938.313-.063.406.063t.094.375v.188q.063 1.563-1.125 2.625t-3.063 1z'
	    ),
	    'affiliatetheme' => array(
		'p' => 'M9.969 14.844q-2.406 3.344-5.063 4.969t-4.031.594-.625-4.094 3.156-6.375T8.469 5t4.031-.625.625 4.063-3.156 6.406zm21.969-3.594q.063.813.063 1.563 0 4.688-2.281 8.625t-6.188 6.25-8.531 2.313q-3.813 0-7.188-1.625t-5.75-4.438q3.313-.875 6-3.063t4.25-5.25q.813 3.188 3.063 4.625 3.438 2.063 8.281-.563t8.281-8.438z',
		'w' => .998046875
	    ),
	    'algolia' => array(
		'p' => 'M14.313 11.438q2.313 0 3.938 1.625t1.625 3.938-1.625 3.938-3.938 1.625-3.938-1.625-1.625-3.938 1.625-3.938 3.938-1.625zm3.937 3.5q.125-.063.063-.188-1.25-2.25-3.813-2.375-.188 0-.188.188v4.188q0 .25.25.125zM24.313 2q1 0 1.844.5t1.344 1.344.5 1.844v20.625q0 1.5-1.094 2.594t-2.594 1.094H3.688q-1.5 0-2.594-1.094T0 26.313V5.688q0-1.5 1.094-2.594T3.688 2h20.625zM11.625 7.313h.063v.938q0 .25.188.188 1.188-.313 2.438-.313t2.438.313q.188.063.188-.188v-.938q0-.5-.375-.875t-.875-.375h-2.813q-.5 0-.875.375t-.375.875zm-5.25 2.312Q6 9.938 6 10.438t.375.875l.5.5q.125.125.25-.063.438-.563.938-1.063.438-.5 1.063-.938.188-.125 0-.25l-.438-.5q-.375-.313-.875-.313t-.875.313zm7.969 15.25q3.281 0 5.594-2.313t2.313-5.594-2.313-5.594-5.594-2.313-5.594 2.313-2.313 5.594 2.313 5.594 5.594 2.313z',
		'w' => .873046875,
		'vw' => 28
	    ),
	    'amilia' => array(
		'p' => 'M15 2q6.063 0 9.031 2.281T27 10.5v18.563q0 .438-.313.563h-4.188q-3.313 0-3.688-.125-.438-.063-.438-.563v-1.563q-1.938 1.063-4.688 1.844T8.81 30q-1.938 0-3.438-.563t-2.281-1.375-1.281-1.781-.656-1.656T.998 23.5v-1.438l.031-1 .094-1.094.219-1.063.344-1.031.5-.813.75-.563q1.375-.563 6.156-1.5t9.031-1.5v-2.375q0-1.313-.063-1.938t-.406-1.344-1.094-1-2.063-.281q-2.5 0-5.188.906T4.934 9.497q-.25.25-.656.156t-.594-.531q-.25-.5-.625-2.438-.188-.875.438-1.25 4.75-3.438 11.5-3.438zm3.125 21.75v-6.688q-1.938.188-4.094.813t-3.406 1.313q-.188.063-.344.219t-.25.281-.188.344-.156.375-.094.375-.063.375-.031.375v.969q0 .313.125.719t.469.906 1.156.813 1.938.313q2.5 0 4.938-1.5z'
	    ),
	    'angrycreative' => array(
		'p' => 'M40 14.875l-.188 1.75-2.188.188-.125 1.125 2.188-.188-.188 1.813-2.188.125-.125 1.25 2.125-.125-.188 1.625-4 .25.75-7.063-2.938 7.188-2 .125-1.5-7.375 1.938-.125.813 5 2-5.188zM26.688 23.25l.813-7.5 1.75-.125-.813 7.5zm-16.563 1L8.937 22l-.25 2.375-1.75.063.188-1.813q-1.313 2.125-3.563 2.25-1.625.063-2.656-.938T0 21.249q.125-1.5 1.281-2.75t2.969-1.375q.5 0 .906.063t.719.188.531.281.406.375.281.375.219.344l.125.188L7.625 17l2.438-.125q2.313-.188 2.625 1.5l.188-1.688 4.063-.25-.188 1.75-2.25.125-.125 1.125 2.25-.125L16.501 21l-2.313.188-.125 1.25 2.313-.188-.125 1.313 3.375-7.313 1.5-.125 2 6.938.563-5.375-1.375.125.188-1.75 4.688-.313-.188 1.75-1.5.125-.625 5.75-3.625.188-.25-.938-2.5.125-.5 1zm-2.75-4.375L5.687 20q-.563-1.063-1.625-1-.438 0-.813.188t-.656.5-.469.656-.25.719q-.063.813.406 1.406T3.686 23q1-.063 1.813-1.188l1.688-.063zm3.5-.5q.063-.563-.313-.688t-1.313-.063l-.188 1.75q.438 0 .656-.031t.531-.125.438-.313.188-.531zm1.313 4.438l.375-3.75q-.438 1.125-1.75 1.688zM20.625 21l-.5-2.375-.938 2.5zM10 16.313l-.25-1.063-2.5.125-.5 1.188-2 .125 3.563-7.625 1.5-.125 1.938 6.375.625-6.5 1.688-.125 2.375 3.938.375-4.125 1.813-.125-.25 2.563q.375-.75.656-1.156t1.219-1.063 2.063-.719q.438-.063.813 0t.656.156.531.219.438.281.344.313.25.313.156.281.125.219l.063.094.188-2 2.438-.188q1.625-.125 2.313.625l-.313-.75 2-.125#r#688 1.438-2.875 1.938-.125-2.688 4.875-.313 2.813-1.813.125.313-2.813-1-2.688q.125 2.25-2 3.125l1.625 2.438-2.313.125-1#q#313-.25 2.438-1.75.125.188-2q-.063.063-.219.313t-.281.406-.375.406-.5.438-.594.375-.781.313-1 .125q-2.563.188-3.438-2.438l-.25 2.5-1.563.125-2.375-3.938-.375 4.125zm17.313-5.125q.938-.063 1.313-.25.438-.25.5-.75t-.188-.688q-.375-.188-1.438-.125zM20.5 13.375q.5.563 1.313.5.438-.063.813-.25.5-.313.938-.875l-2.125.125.188-1.5 3.938-.25.063-.75-1.938.125q-.438-.375-.688-.5-.438-.188-.813-.188-.688.063-1.375.563-.688.625-.813 1.563-.063.875.5 1.438zm-12.625.5l1.5-.063-.5-2.375z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'app-store' => array(
		'p' => 'M16 7.563l.563-1q.25-.438.781-.594t.969.125.594.781-.156 1l-5.438 9.438h3.938q.938 0 1.406.875t.031 1.688H7.125q-.563 0-.938-.375t-.375-.906.375-.906.938-.375h3.25l4.125-7.188-1.25-2.25q-.313-.5-.156-1t.594-.781.969-.125.781.594zm-4.937 13.625l-1.188 2.125q-.313.438-.813.594t-.969-.125-.594-.781.125-1l.938-1.563q1.5-.438 2.5.75zm10.562-3.875h3.313q.563 0 .938.375t.375.906-.375.906-.938.375h-1.813L24.375 22q.25.5.094 1t-.594.781-.969.125-.781-.594q-1.063-1.938-2.625-4.625t-2.063-3.563q-.688-1.438-.469-2.594t.906-1.719q.75 1.313 3.75 6.5zM16 .5q6.438 0 10.969 4.531T31.5 16t-4.531 10.969T16 31.5 5.031 26.969.5 16 5.031 5.031 16 .5zM29.5 16q0-5.625-3.969-9.563T16 2.499q-5.625 0-9.563 3.969t-3.938 9.531q0 5.625 3.969 9.563t9.531 3.938q5.625 0 9.563-3.969T29.5 16z'
	    ),
	    'app-store-ios' => array(
		'p' => '#a#M7.938 24l1#q#063q-.938-1#q#438-.688l-.938 1.5q-.25.5-.094 1t.594.75.938.125.75-.625zm8.687-3.312q.438-.813-.031-1.656t-1.406-.844h-3.875l5.375-9.313q.25-.438.125-.938t-.594-.75-.969-.125-.75.563l-.563.938-.563-.938q-.25-.438-.75-.563t-.938.125-.563.75.125.938l1.25 2.188-4.063 7.125H5.247q-.5 0-.875.344t-.375.875.375.906.875.375h11.375zm6.125 0q.5 0 .875-.375t.375-.906-.375-.875-.875-.344H19.5q-1-1.75-3.688-6.375-.688.5-.906 1.625t.469 2.563q.563 1 2.156 3.75T20 24.001q.25.5.75.625t.938-.125.594-.75-.094-1l-1.25-2.063h1.813z'
	    ),
	    'apper' => array(
		'p' => 'M2.625 14.938q1.063 0 1.469.188t.656.75v-1.438q0-1-1.125-1-.25 0-.406.031t-.281.125-.156.25-.094.406H.313q0-1.125.375-1.5.563-.75 2.875-.75 2.75 0 3.375 1.188.25.563.25 1.5v4.75H4.75l.125-1.188h-.063q-.188.5-.438.75t-.688.375-1.125.125q-1.438 0-2-.531t-.563-1.781q0-1.188.625-1.719t2-.531zm1.063 3q.625 0 .844-.156t.219-.656q0-.438-.25-.594t-1-.156q-1.063 0-1.063.75 0 .5.25.656t1 .156zM8.563 12h2.375l-.063 1.313h.063q.375-.813.844-1.063t1.469-.25q1.313 0 2 .563.75.688.75 3 0 2.5-.75 3.313-.563.625-2.063.625-.938 0-1.406-.281t-.719-1.031H11v4.375H8.562V12.001zm5.062 3.813q0-1.313-.25-1.688t-1.063-.375-1.063.344-.25 1.469q0 1.313.25 1.719t1.125.406q.75 0 1-.375t.25-1.5zM17.25 12h2.375l-.063 1.313q.438-.813.906-1.063t1.469-.25q1.313 0 1.938.563.813.688.813 3 0 2.5-.75 3.313-.563.625-2.063.625-1 0-1.469-.281t-.656-1.031h-.063v4.375h-2.438V12.001zm5.063 3.813q0-1.313-.25-1.688T21 13.75t-1.063.344-.25 1.469q0 .938.125 1.344t.375.594.813.188q.813 0 1.063-.375t.25-1.5zm3.312-.25q0-2.188.813-2.875.75-.688 2.813-.688 2 0 2.75.75t.75 2.75v.688h-4.75v.313q0 .5.125.813t.375.438.75.125q.688 0 .906-.188t.219-.688h2.375v.125q0 1-.438 1.563-.625.813-2.813.813-2.375 0-3.125-.75-.75-.688-.75-3.188zm4.813-.688v-.25q0-.563-.25-.75t-1-.188q-.688 0-.875.188t-.25.75v.25h2.375zM33.875 12h2.438l-.125 1.25h.063Q36.814 12 38.064 12q1.063 0 1.5.594t.438 2.094v.625h-2.188v-.25q0-.75-.125-1t-.5-.25q-.625 0-.813.563-.063.25-.063.813v4.25h-2.438v-7.438z',
		'w' => 1.248046875,
		'vw' => 40
	    ),
	    'asymmetrik' => array(
		'p' => 'M32.375 19.313q-1.313 1.375-3.063 2.5l4.563 6.875H27.5l-2.875-4.438q-1.563.625-3.375 1.125l2.063 3.313h-8.5l1.438-2.313q-2.25.25-4.313.188l-1.375 2.125H4.25L6.375 25.5q-4.313-1.75-4.25-5.188 0-2.563 2.625-5.188 3.688-3.813 10.063-5.813-1.813.625-3.875 1.938Q7.875 12.812 6 14.874q-2.688 2.875-2.313 5.469t3.5 3.969L19.062 6.437 28.5 20.625q1.188-.938 2.188-1.938 4.563-4.875 2.75-9.125T24.5 4.249q-6.688-1.063-13.813.875-5.25.875-10.688 3.625Q5.624 5.624 12.53 4.186t12.906-.563q3.375.5 5.781 1.719t3.594 2.938 1.188 3.781q-.063 3.563-3.625 7.25zm-11.75 5.062q1.688-.5 3.375-1.25L19.062 15.5l-6.375 9.938q2.063.063 4.313-.313l2.063-3.313z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'audible' => array(
		'p' => 'M40 12.5v3.375l-20 12.5-20-12.5V12.5L20 25zM27.875 17q-3.375-4.438-8.656-5.094T9.688 14.75q-.313.25-.438.375h-.063Q11 12.5 13.843 10.937t6.156-1.563q2.188 0 4.25.719t3.719 2 2.844 3.031zm-13.812 1.188q2.188-3.063 5.938-3.063t5.938 3.063l-2.875 1.813q-2.125-3-5.375-3-1.938 0-3.625 1.188zM6.5 10.063q-.875.688-2.188 2.063 2.563-3.938 6.719-6.219T20 3.626t8.969 2.281 6.719 6.219l-3.063 1.875-.063-.063q-3.063-4.25-7.625-6.281t-9.5-1.406-8.938 3.813z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'avianex' => array(
		'p' => 'M28.313 2q1.813 0 2.875 1.281t.75 3.094l-3.563 19.25q-.313 1.813-1.844 3.094T23.187 30h-19.5q-1.813 0-2.875-1.281t-.75-3.094l3.563-19.25q.313-1.813 1.844-3.094T8.813 2h19.5zm-3.625 21.688l.375-.5-5.938-7.438-.25-.438q.438-.313.844-.625t.656-.5.469-.344l.219-.156q.375-.313.313-.875t-.5-1.063-1-.656-.875.156q-.938.875-2.125 2l-.313-.25-6.438-7.063-.563.313-1.188 1.813 4.313 6.25L14 16.125q-1.313 1.375-2.063 2.188l-3.625-1.938-1 1 3.25 3 2.563 3.813 1.125-.813-1.375-4q1.063-.688 2.625-1.688l7.188 6.875z'
	    ),
	    'aws' => array(
		'p' => 'M11.25 12.688q0 .625.156 1.125t.344.844.188.469q0 .25-.25.375l-.813.563q-.125.125-.313.125h-.188l-.406-.406-.719-1.156q-.375.5-1.031.906t-1.406.656-1.375.25h-.063q-1.188.063-2.469-.75t-1.156-2.75q-.125-1.75 1.25-2.813t3.125-.938q1.313 0 2.938.375v-1q.188-1.25-.594-2.063t-2.156-.625q-1.313 0-2.875.625-.375.125-.688.125-.313-.063-.313-.656t.125-.844q.313-.313 1.563-.719T6.687 4h.438q1.688 0 3.063 1.063 1.125 1.25 1.125 2.938 0 .188-.063.375v4.313zm-5.375 2q1.375 0 2.125-.594t.938-1.281q.125-.5.125-1.688-1.25-.313-2.438-.313-.938-.063-1.813.406t-.813 1.594q-.063.813.469 1.375t1.406.5zm10.688 1.437q-.625.063-.813-.625L12.625 5.187q-.063-.25-.063-.5-.063 0-.063-.063 0-.25.25-.25h1.438q.625-.063.75.625l2.25 8#r#063-8.813q.125-.688.813-.625h1.063q.688-.063.813.625l2.063 8.938 2.313-8.938q.125-.688.813-.625h1.313l.156.125.094.375q-.063.125-3.313 10.625-.125.75-.813.688H23.44q-.688.063-.813-.688l-2.063-8.563-2.063 8.563q-.125.75-.813.625h-1.125zm17.062.375q-2.063 0-3.563-.75-.5-.25-.5-.75v-.688q0-.563.563-.375 1.188.5 1.813.625 2.188.438 3.563-.313.563-.313.656-1.031t-.344-1.156q-.125-.125-.25-.188l-.313-.156-.281-.156-.406-.156-.5-.156-.688-.219-.875-.281q-.438-.063-.906-.313t-1.156-1.063-.688-1.875q-.063-1.375 1.156-2.438t3.156-1.063q.5 0 1.156.094t1.375.313.969.594q.125.188.125.438v.625q0 .438-.313.438-.125-.063-.563-.219t-1.094-.313-1.406-.156q-.25 0-.594.031t-.813.156-.75.469-.281.906q0 1.188 1.875 1.688.25.063.875.25t.781.219.563.188.531.219.406.219.438.344.344.375q1.25 1.563.313 3.5-1.125 2.188-4.375 2.125zm2.563 6.563Q33 25.438 28.594 26.719T20 28h-.188q-4.688 0-10.438-2.219T.186 20.437q-.313-.25-.125-.5t.563-.063q3#r#188 9.594 3.719t10.156 1.531h.063q3.25 0 7.688-.906t7.375-2.156q.625-.25.906.188t-.219.813zM38 20.969q-.563-.719-5.125-.156-.313.063-.344-.156t.219-.469q1.188-.75 2.813-1.031t2.813-.094 1.5.5q.438.563-.25 2.969t-2.25 3.719q-.25.188-.469.094t-.094-.344q1.75-4.313 1.188-5.031z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'bimobject' => array(
		'p' => 'M26 2q.813 0 1.406.594T28 4v24q0 .813-.594 1.406T26 30H2q-.813 0-1.406-.594T0 28V4q0-.813.594-1.406T2 2h24zm-4 16.063v-2.188Q22 13.25 20.75 12t-5.25-1.25h-1.063q-4 0-4.375 2.438h-.063V8.5h-4V23h4v-2.188h.063q#r#438 4.375 2.438H15.5q4 0 5.25-1.25T22 18.062zm-4-1.813v1.438q0 1.188-.438 1.656t-1.938.469h-2.875q-.938 0-1.5-.156t-.906-.656-.344-1.375v-1.25q0-1.25.656-1.719t2.094-.469h2.875q1.5 0 1.938.469T18 16.251z'
	    ),
	    'bitcoin' => array(
		'p' => 'M31.5 16q0 6.438-4.531 10.969T16 31.5 5.031 26.969.5 16 5.031 5.031 16 .5t10.969 4.531T31.5 16zm-8.875-2.187q.438-2.625-3.375-3.938l.688-2.813-1.688-.375-.688 2.688q-.5-.125-1.375-.313l.688-2.75-1.688-.438-.688 2.813q-.75-.125-1.125-.25l-2.313-.563-.438 1.813h.063l.219.031.313.063.313.094.219.063h.063q.875.25.813 1l-.813 3.188q.125.063.188.063h-.063l-.125-.063-1.125 4.5q-.188.5-.75.375l-1.25-.313-.813 1.938 2.188.563q.125.063.313.094t.313.063.281.094.281.063l-.688 2.813 1.688.438.75-2.75q.625.125 1.313.313l-.688 2.813 1.688.375.75-2.813q2.125.563 3.719.063t2.281-2.313q.938-2.813-1.563-4.125 1.813-.438 2.125-2.5zM18.75 19.25q-.063.313-.25.563t-.469.375-.594.219-.719.094-.719-.031-.75-.125-.656-.156-.625-.156-.469-.094l.938-3.75q.063 0 .625.125t.875.219.875.281.875.406.656.5.438.688-.031.844zm.563-5.5q-.125.313-.25.5t-.313.344-.438.219-.5.094-.563 0-.531-.031-.531-.094-.5-.125-.469-.094-.344-.125l.875-3.375q.063 0 .438.094t.594.156.625.188.625.25.594.344.469.438.25.563-.031.656z'
	    ),
	    'bity' => array(
		'p' => 'M4.875 4.188Q9.313 0 15.563 0t10.813 4.438q.375.438.219.969t-.656.656-1-.313q-3.938-3.813-9.375-3.813T6.251 5.562q-.438.438-.969.25t-.656-.656.25-.969zm6.188 26.187q-6-1.813-9.063-7.219T.5 11.75q.125-.625.656-.75t.938.25.281.938Q1 17.438 3.656 22.157t7.906 6.344q.625.188.75.719t-.281.938-.969.219zm9.25-.125q-.563.188-.938-.188t-.281-.938.719-.75q4.938-1.625 7.5-6.188t1.438-9.625q-.188-.625.25-1t.969-.25.656.75q1.313 5.813-1.625 11.063t-8.688 7.125zm-3.938-4.937q0 .375-.25.656t-.625.281-.656-.281-.281-.656v-4.5q0-.375.281-.656t.656-.281.656.281.281.656zm4.5-16.813q0-.625.5-.875t1 0 .5.875v4.438q0 3-2.156 4.344T15.5 18.626t-5.219-1.344-2.156-4.344V8.5q0-.625.5-.875t1 0 .5.875q-.063 2.063 0 3.594t.5 2.563 1.594 1.563 3.281.531q2.063 0 3.219-.5t1.625-1.5.531-2.563 0-3.688z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'blackberry' => array(
		'p' => 'M10.375 7.313q0 1.25-1.063 2.156t-3.438.906H1.436l1.313-5.563h4.25q1.813 0 2.594.781t.781 1.719zm7.875-2.5q1.813 0 2.594.781t.781 1.719q0 1.25-1.031 2.156t-3.344.906h-4.375L14 4.812h4.25zM5.563 13q1.75 0 2.563.781t.813 1.719q0 3.063-4.563 3.063H.001L1.314 13h4.25zm11.25 0q1.75 0 2.563.781t.813 1.719q0 3.063-4.438 3.063h-4.375L12.564 13h4.25zm11.812-3.375q1.813 0 2.594.781T32 12.125q0 3.063-4.375 3.063H23.25l1.125-5.563h4.25zm-1.75 8.625q1.25 0 2.031.438t1.063.969.281 1.094q0 3.063-4.375 3.063H21.5l1.125-5.563h4.25zm-11.812 3.375q1.75 0 2.563.75t.75 1.75q0 3.063-4.375 3.063H9.626l1.188-5.563h4.25z',
		'w' => .998046875
	    ),
	    'blogger' => array(
		'p' => 'M10.125 12.25q.125-.125.219-.188t.375-.094.594-.031h1.125q1.75 0 2 .125.5.25.5.875 0 .5-.438.813-.188.125-1.969.125t-1.969-.063q-.5-.125-.625-.656t.188-.906zM14 18.125q2.563 0 3.031.063t.719.25q.375.313.313.813t-.5.75l-.563.063-3 .063q-3.25 0-3.5-.125-.5-.188-.594-.719t.344-.844q.25-.313 3.75-.313zm13.938 8.188q-.125.875-.531 1.594t-1.094 1.25-1.563.719q-.5.125-10.813.125t-10.75-.125q-.75-.188-1.375-.625-.688-.438-1.063-1-.438-.625-.625-1.375-.125-.438-.125-10.875 0-10.375.125-10.813.313-1.188 1.156-2t2.031-1.125Q3.624 2 13.905 2t10.656.063q2.063.438 3 2.313.313.688.375 1.688t.063 9.563q0 10.125-.063 10.688zm-5.313-11.625q-.125-.5-.5-.688-.125-.063-.969-.094t-1.094-.219q-.5-.25-.5-1.125 0-1.938-1.563-3.563-1.188-1.125-2.563-1.563-.313-.063-2.438-.125-3.125 0-4.188.438-2.688 1-3.375 3.875-.063.375-.125 4 0 4.438.25 5.313.438 1.375 1.594 2.375t2.469 1.25q.438.063 4.125.094t4.25-.031q1.813-.25 3.125-1.625 1-1 1.375-2.438.125-.438.156-3.031t-.031-2.844z',
		'w' => .873046875,
		'vw' => 28
	    ),
	    'blogger-b' => array(
		'p' => 'M27.938 13.938q.063.313.031 4.5t-.219 4.938q-.625 2.313-2.188 3.875-.75.813-1.531 1.344t-1.688.844-1.906.438q-.875.125-6.844.125t-6.656-.125q-2.125-.438-3.969-2.031T.437 23.94q-.313-.938-.375-2.344t-.063-6.156q.063-5.875.188-6.5.563-2.188 1.969-3.844t3.406-2.469q1.125-.438 2.344-.531t4.469-.094q3.5.063 3.938.188 2.313.688 4.125 2.563 2.5 2.563 2.563 5.688 0 1.375.75 1.813.438.313 1.813.344t1.563.156q.625.313.813 1.188zm-20.188-4q-.563.563-.313 1.438t1 1.125q.375.063 3.188.063t3.125-.188q.75-.5.75-1.375 0-.938-.813-1.375-.375-.188-3.25-#q#25 0-2.781.063t-.906.438zm12 12.5q.688-.375.781-1.156t-.469-1.281q-.375-.375-1.125-.438t-4.938-.063q-4.125 0-4.938.063t-1.188.313q-.625.625-.5 1.438.125.875.938 1.188.438.188 5.688.125l4.813-.063z'
	    ),
	    'buromobelexperte' => array(
		'p' => 'M0 2h8v8H0V2zm7.5 7.5v-7h-7v7h7zM10 2h8v8h-8V2zm7.5 7.5v-7h-7v7h7zM20 2h8v8h-8V2zm7.5 7.5v-7h-7v7h7zM0 12h8v8H0v-8zm7.5 7.5v-7h-7v7h7zM10 12h8v8h-8v-8zm7.5 7.5v-7h-7v7h7zM20 12h8v8h-8v-8zm7.5 7.5v-7h-7v7h7zM0 22h8v8H0v-8zm7.5 7.5v-7h-7v7h7zM10 22h8v8h-8v-8zm7.5 7.5v-7h-7v7h7zM20 22h8v8h-8v-8z'
	    ),
	    'centercode' => array(
		'p' => 'M20.563 16.781q-.188 1.656-1.469 2.688t-2.938.875-2.688-1.469-.844-2.969 1.469-2.688 2.938-.844 2.688 1.469.844 2.938zM15.188 31.5q-4.438-.25-8.031-2.75t-5.344-6.438-1.188-8.313q.5-4 2.844-7.156t5.844-4.844q2.938-1.375 6.125-1.5t5.969 1 5.031 3.063 3.594 4.844 1.469 6.156q.188 6.813-4.688 11.531t-11.625 4.406zm11.25-11.25q.5-2.125-.438-4.219t-2.594-3.656-4-3-4#q#281-3.594-1.469Q8.936 8.188 8.405 14t1.094 13.125q3.188.75 7.656-1.094t9.281-5.781z'
	    ),
	    'cloudscale' => array(
		'p' => 'M19.875 9.625q.188-.188.406-.125t.281.281-.063.469l-4.75 5.5q.125.875-.5 1.5-.5.5-1.219.5t-1.25-.531-.531-1.25.5-1.219q.625-.625 1.438-.563l1.625-1.25q-1.688-1.563-3.938-1.563-2.438 0-4.156 1.75t-1.656 4.375q-.063-.563-.063-1.25 0-3.375 2.375-5.813t5.688-2.438q2.813 0 5.25 2.125zm-5.25 6.938q.625-.625 0-1.25t-1.25 0 0 1.25 1.25 0zM14 2q5.813 0 9.906 4.094T28 16t-4.094 9.906T14 30t-9.906-4.094T0 16t4.094-9.906T14 2zm0 24q4.125 0 7.063-2.938t2.938-7.063-2.938-7.063T14 5.998 6.937 8.936t-2.938 7.063 2.938 7.063T14 26z'
	    ),
	    'cloudsmith' => array(
		'p' => 'M20.75 26.25q0 1.438-.688 2.625t-1.906 1.906-2.656.719q-2.125 0-3.688-1.531t-1.563-3.719 1.563-3.719T15.531 21t3.688 1.531 1.531 3.719zM15.5 11q-2.125 0-3.563 1.406T10.499 16q0 2.125-1.5 3.563T5.28 21.001t-3.75-1.438T-.001 16q0-2.188 1.563-3.844T5.25 10.5q2.188 0 3.469-1.281T10 5.75q0-2.125 1.656-3.688T15.5.499t3.594 1.531T20.5 5.749t-1.406 3.719-3.594 1.531z',
		'w' => .650390625,
		'vw' => 21
	    ),
	    'cloudversify' => array(
		'p' => 'M9.313 19H6.25q-.313 0-.531-.219T5.5 18.25v-2.5q0-.313.219-.531T6.188 15h2.938v.438q0 1 1.188 1h1.25q.375 0 .656-.156t.438-.438.156-.594v-1.313q0-1.188-.938-1.188 1.125-.938 2.813-1.5.688-2.75 2.125-4.406t4.063-2.469q1.25-.5 2.969-.375t3.375.594 3.125 1#r#156 3.281q3.375 1.063 4.938 3.844t.813 5.844q-.625 2.688-2.844 4.469t-5.344 1.781q-2.25 2.313-5.781 2.375t-5.844-2.063q-3.688.188-6.219-1.75t-2.906-5.188zm14.187.5q.375 2.313 2.156 3.188t3.594.5 3.188-1.656 1.813-3.094q.5-2.375-.625-4.5l-.625-1.25q.063 1.25-.719 2.688t-2.281 2.125q1.938-2.188 1.688-4.188T29.72 9.844t-3.969-1.719q-3.875-.563-7.125 2.688 5.125.5 6.375 4.688-.875-1.438-2.563-2.25t-3.188-.75-2.625.438q-1.688.875-2.688 2.469t-.875 3.406q.063.5.156.938t.281.813l.344.688.469.625.469.5.5.438.5.375.5.344.406.281q-.313-1.375.063-3.156t1.75-2.656q-.813 1.375-.563 2.969t1.438 2.719 3.125 1.594 4.438-.344q-4.25-1.875-3.438-5.438zM8 13H5.5q-.375 0-.688-.313t-.313-.688v-2.5q0-.375.313-.688t.688-.313H8q.438 0 .719.313T9 9.499v2.5q0 .375-.281.688T8 13zM.625 10.5Q0 10.5 0 9.875v-1.75Q0 7.5.625 7.5h1.75q.25 0 .438.188t.188.438v1.75q0 .625-.625.625H.626zM10.5 8.938V7.563q0-.563.563-.563h1.375q.563 0 .563.563v1.375q0 .563-.563.563h-1.375q-.563 0-.563-.563zm-7 5.812v1.5q0 .313-.219.531T2.812 17H1.187q-.25 0-.469-.219t-.219-.531v-1.5q0-.313.219-.531T1.187 14H2.75q.75 0 .75.75z',
		'w' => 1.201171875,
		'vw' => 38
	    ),
	    'cpanel' => array(
		'p' => 'M13.125 13.75q.188.688.031 1.406t-.594 1.313-1.125 1-1.5.406h-2l.375-1.5q.188-.688.875-.688h.688q.563 0 .906-.438t.219-1q-.188-.875-1.125-.875h-1.25L7 19.312Q6.812 20 6.125 20H4.562l2.188-8.125q.188-.688.875-.688h2.313q.563 0 1.094.188t.938.531.719.813.438 1.031zm-9.75 1.75q-.75 0-1.063.594t0 1.188 1.063.594h.688q.125 0 .25.063t.156.188.031.25L4 20.002h-.75q-1.563 0-2.563-1.25t-.563-2.813q.313-1.25 1.188-1.906t2-.656h2.5l-.375 1.438q-.188.688-.938.688H3.374zm15.438-2.187q.938 0 1.469.719t.344 1.594l-.875 3.25q-.313 1.125-1.5 1.125h-3.563q-.75 0-1.25-.438t-.594-1 .031-1.156.625-1 1.25-.406h3l-.25.813q-.188.688-.875.688h-1.313q-.25 0-.25.25t.25.25H17.5q.25 0 .313-.375l.563-1.938q.063-.375-.125-.375h-3.625q-.438 0-.719-.344t-.156-.781l.188-.875h4.875zm20.75-2.125q.188 0 .313.156t.125.344l-1.688 6.188q-.25.938-1.031 1.531t-1.781.594l2.25-8.313q.125-.5.625-.5h1.188zm-14.75 2.187q1.063 0 1.875.563t1.188 1.531.063 1.969l-.563 2.063q-.125.5-.625.5h-1.188q-.188 0-.313-.156t-.125-.344l.688-2.5q.188-.563-.188-1.031t-.938-.469h-1.25l-1.063 4q-.125.5-.625.5h-1.188q-.25 0-.375-.156t-.063-.344l1.625-6.125h3.063zM30.938 18h4.563l-.313 1.313q-.25.688-.938.688h-4.125q-.938 0-1.469-.719t-.281-1.594l.625-2.5q.188-.5.531-.938t.844-.656 1.063-.219h2.938q.938 0 1.469.688t.281 1.563l-.188.75q-.25 1.125-1.438 1.125h-3.313l.188-.813q.188-.688.875-.688h1.375q.188 0 .25-.188l.063-.125q.063-.313-.25-.313h-2.063q-.438 0-.5.375l-.5 1.875q-.125.375.313.375z',
		'w' => 1.248046875,
		'vw' => 40
	    ),
	    'css3-alt' => array(
		'p' => 'M0 2h24l-2.188 24.75L11.999 30l-9.813-3.25zm19.563 5H4.438l.375 2.938h7.688l-.438.188-7 2.938.25 2.875 10.375.063-.25 3.813-3.375.938-3.313-.813-#q#375H5.499l.375 4.625 6.188 1.813 6.125-1.813.813-9.125h-6.938L19.25 9.94z',
		'w' => .75,
		'vw' => 24
	    ),
	    'cuttlefish' => array(
		'p' => 'M21.5 19.125q1.375 5.125 5.438 7.313-2.188 2.375-5.156 3.719t-6.281 1.344q-6.438 0-10.969-4.531T.001 16.001 4.532 5.032 15.501.501q3.313 0 6.281 1.344t5.156 3.719q-4.063 2.188-5.438 7.313-.813-1.438-2.5-2.406t-3.5-.969q-2.625 0-4.563 1.938t-1.938 4.563 1.938 4.563 4.563 1.938q1.188 0 2.375-.438T20 20.847t1.5-1.719z',
		'w' => .841796875,
		'vw' => 27
	    ),
	    'd-and-d' => array(
		'p' => 'M5.125 6.188q-.063-1.875.813-3 .063.813.25 1.313.563-2.563 2.688-4.063-.25.688-.188 1.063Q10.001.376 11.438.126q1.313-.25 2.625.063 3.5.813 4.375 4.5.438 1.875-.5 4.188-.563 1.188-1.313 2.188l-.375-.375q-1.75-1.688-2.313-2.313-.125-.125 0-.25.75-1.313.625-2.75-.125-1-.75-1.625-.688-.75-1.656-.719t-1.656.719q-1 1.125-.688 2.75v.25q-.375 1.375-.188 2.625v.125q-2-1-2.688-3.25-.813 1.75-.438 3.375-1.25-1.25-1.375-3.438zM34.5 13.875l.125.125q-1.125-.25-2.813.063-.938.25-1.625.563-.125.063-.5.313-1-.375-1.125-.438-2.313-.5-3.875 1.25-1.688 1.875-2.938 4.688l-.063.125v.063q-.125-.063-.938-.75t-1.375-.875q.063 0 .063-.031v-.031q2.125-2.875 4.688-4.438 1.625-.938 3.25-1.125.188 0 .313-.063h-.813q-1.75.188-3.688 1.25-1.375.813-2.25 1.875l-.063.125-.063-.063q1-2.813 3.563-4.625l.063.063q-.188.25-.188.313l-.313.625q-.125.313.125.313t.625-.25q.188-.188.594-.531t.625-.5.531-.344.625-.313.688-.188h.25q-.063 0-.125.063-.813.563-.938.75t-.031.344.281.094q.313-.063.5-.125 1-.375 1.813-.438 1.25-.063 2.5.5 1.438.563 2.5 1.625zm-14.687 11q.125.063.063.25-2.75 5.375-7.25 6#q#688.438-4.875-.563-1.875-.813-3-2.25 0-.063-.063-.125t-.156-.188-.094-.188q-.063.625.063 1.375l-.625-.625q-1.063-1.313-1.5-3.25-.75-3.063.5-6.375-.688.375-1.5 1.063.938-2.688 3.5-5.313.25.188.188.5-.375 1.938-.313 2.75 1.688-1.75 4-2.75-.625 1-.688 2.375 1.438-1.375 2.875-.875-2 2.063-2.438 4-.5 2.25.563 3.938t3.063 1.688q1 0 2.125-.688 1.625-1.125 2.75-3l.125-.188q.375.313 2.688 2.25zm10.75-2.937q2 .688 2.688 2.438.438 1.063.156 2.219t-1.219 1.906q-1.5 1.25-3.563 1.125H28.5q1.5 1.063 3.188.625 0 .063-.156.219l-.219.219q-1.063.938-2.688 1.25-1.875.313-3.375-.625t-1.938-2.938l-.063-.438q-.563.438-.625 1.406t.625 1.906q-.063 0-.125-.063h-.125q-1-.438-1.563-1.281t-.5-1.969q.125-1 0-1.938t-.813-1.563q-.375-.25-.813-.625t-.75-.625-.781-.656-.781-.656q-.875-.688-1.063-1.563-.063-.25-.125-.875 0-.563-.5-.938-.125-.063-.25-.188t-.313-.25-.25-.25q-1-.813-.5-1.875.25 1.125 1.438 1.313h.25l.313.031.25.031q.75.125.875.875.125.563.188.625.125.5.625.563h.344l.531.063q.688.063 1.25.5.563.5 1.156 1t1.344 1.094 1.188.969q.563.5 1.188.5.813.063 1.281-.563t.281-1.438v-.125q.438.313.438.375.625.625.813 1.656t-.25 1.844q-.063 0-.5.625.063.063.125.063 1.438.125 2.438-.563.75-.5.844-1.344t-.469-1.531q-.375-.375-1.188-.75.75-.125 1.813.188zM6.188 11.188q-.375-.688-1.375-1.313 1.438-.063 2.5.25Q6.688 9 7 7.687q.438 1 1.5 1.688.375.25 1.438.875t1.438 1q.063.063.625.688 0-.063-.063-.188t-.063-.188q-.438-.938-1.438-1.563-.188-.125-.188-.313-.313-1.063-.063-2.313.063-.313.25-1 .063-.25.25-.438.188 1.75 1.25 2.875.5.5 2.125 2.063 1.188 1.125 1.563 1.625.188.25.25.313-.375-1-1.5-2.125-.75-.688-1.813-1.688-.25-.25-.313-.688-.125-1 .25-1.875.063-.063.125-.188l.063.688q.188.938.75 1.625t2 2l.375.375q1.125 1.063 1.563 1.938.5.938.375 1.875 0 .063.063.125.625.25.625.875.563-.188 1-.875.125.438 0 1t-.344 1.094-.594.938-.75.594q.125-1.5-1.063-1.688-.125-.063-1.438-.188.688-1.25.063-1.375-1.25-.125-2.25 0t-1.375.313q1 0 1.5.188-.375 1.125-.375 1.188-.125.313.063.563t.5 0q.063 0 .125-.063t.125-.063q-.188 1-.188 1.125 0 .438.344.5t.594-.063q-.063.563-1.063 1.125t-1.75.5q.75-.5 1-1.125-.625.063-1.188.188l-.063-.063q.438-.313.688-.813.375-1-.094-1.719t-1.469-.781q-.938-.063-1.625.313.563-1.375 2-2.125-.75-.25-1.5-.438 1.188-.75 2.875-.875-.313-.063-.969-.094t-1.719.344-1.688 1.063q.25.063 1.438.25-2 .563-3.875 2.25 0-.125.031-.25t.063-.219.063-.219.031-.25q.063-.438 0-.813-.125-.938-1.188-1.063-.563-.063-1.5.125h-.188q.438-.438 1.031-.781t1.25-.688 1.031-.656q.5-.375.188-.938zm8.062 1.687q.063.5.281.844t.531.531.688.125q-.5-1.063-1.5-1.5z',
		'w' => 1.123046875,
		'vw' => 36
	    ),
	    'deploydog' => array(
		'p' => 'M23.875 8.5h3.25v15h-3.25v-1.313q-.875 1.063-2.281 1.25t-2.344-.313q-1.25-.563-2-1.75t-.75-2.75q0-1.438.719-2.656t1.969-1.781q.875-.5 2.313-.344t2.375 1.156v-6.5zm-4 10.125q0 .875.563 1.469t1.469.594 1.5-.625.594-1.438-.594-1.438-1.469-.625q-.625 0-1.094.313t-.719.781-.25.969zM11.75 8.5H15v15h-3.25v-1.313q-.813 1.063-2.25 1.25t-2.313-.313q-.813-.375-1.438-1.031t-1-1.563-.375-1.906q0-1.438.719-2.656t2.031-1.781q.875-.5 2.281-.344t2.344 1.156v-6.5zm-4 10.125q0 .875.594 1.469t1.469.594 1.469-.625.594-1.438q0-.5-.25-.969t-.75-.781-1.063-.313q-.875 0-1.469.625t-.594 1.438zM28 6H4q-.813 0-1.406.594T2 8v16q0 .813.594 1.406T4 26h24q.813 0 1.406-.594T30 24V8q0-.813-.594-1.406T28 6zm0-2q1.625 0 2.813 1.188t1.188 2.813v16q0 1.625-1.188 2.813T28 28.002H4q-1.625 0-2.813-1.188t-1#q#813v-16q0-1.625 1#q#813T4 4h24z'
	    ),
	    'deskpro' => array(
		'p' => 'M12.875 32l1.938-2.375q1.438-.063 2.313-.438.438-.25.844-.594t.656-.688.438-.75.25-.719.125-.594.063-.438v-.219q0-.25-.875-1.25-.188-.188-.281-.313t-.281-.344-.375-.406h4.938q0 3.188-.625 4.75-.563 1.313-2.188 2.656t-3.75 1.656q-.688.063-3.188.063zm12.5-10.5h-7.438L19 19.562h11Q28.312 21.5 25.375 21.5zm-2.687-14v10.563h-4.625L16 21.501h-.375q-.938 0-1.625-.375t-1.063-.844-.594-1.094-.281-.906-.063-.469q-.063-.625-.688-.563t-.563.688q.188 2.188 1.625 3.563H6.685q-.75 0-1.781-.375t-2.219-1.125-1.969-2.219-.719-3.406V1.063q0-1 .938-1.063h5.188q.188 0 .594.031t1.031.25 1.063.844.438 1.625q0 .625.625.625t.625-.625q0-1.688-1-2.75h5.25q2.375 0 4.063.781t2.469 2.063 1.094 2.406.313 2.25zM14.375 11l4 1.875q.438-1.375-.313-2.344t-1.875-.875T14.374 11z',
		'w' => .9375,
		'vw' => 30
	    ),
	    'digital-ocean' => array(
		'p' => 'M5.438 30.125V25.5h4.625v4.625H5.438zm-3.875-8.437h3.875v3.813H1.563v-3.813zM30.75 11.063q1.313 4 .531 7.688t-2.844 6.531-5.375 4.531-7.063 1.688v-6q3.188 0 5.688-1.875t3.375-4.781-.188-6.344q-.688-1.875-2.094-3.281t-3.281-2.094q-3.438-1.063-6.344-.188t-4.781 3.406T6.499 16h-6q0-3.75 1.688-7.063t4.531-5.375T13.249.718t7.688.531q3.5 1.125 6.094 3.719t3.719 6.094zM16 25.5h-5.938v-5.938H16V25.5z',
		'w' => .998046875
	    ),
	    'discord' => array(
		'p' => 'M18.563 15.188q0 .75-.469 1.281T16.938 17q-.438 0-.813-.25t-.594-.656-.219-.906q0-.375.125-.688t.344-.563.531-.375.625-.125q.688 0 1.156.5t.469 1.25zm-7.438-1.75q.688 0 1.156.5t.469 1.25-.469 1.281-1.156.531-1.156-.531-.469-1.281.469-1.25 1.156-.5zM28 3.313v28.688q-3.625-3.188-7.438-6.75l.875 3H3.249q-1.313 0-2.281-.969t-.969-2.344V3.313q0-1.375.969-2.344T3.249 0h21.5q1.313 0 2.281.969t.969 2.344zm-4.562 15.125q0-2.25-.563-4.594t-1.188-3.531l-.563-1.188q-.625-.5-1.344-.844t-1.25-.5-.969-.25-.688-.094h-.25l-.188.25q1.188.375 2.188.906t1.375.844l.375.313q-2.75-1.563-6-1.625T8.435 9.25l-.938.5Q8.81 8.5 11.685 7.625l-.125-.188q-2.188 0-4.5 1.688-.25.5-.625 1.313t-1.031 3.281-.656 4.719q.125.313.469.688t1.594 1.063 2.813.688q.625-.688 1.063-1.313-.875-.25-1.594-.719t-.969-.844l-.25-.313q.125.063.281.156t.281.156l.125.063q2.125 1.188 4.719 1.406t5.281-.844q.938-.313 1.813-.938-.813 1.313-2.875 1.938l1.063 1.25q1 0 1.844-.281t1.375-.625.938-.688.531-.594z'
	    ),
	    'discourse' => array(
		'p' => 'M14.125 2q5.75 0 9.813 4.125t4.063 9.844-4.063 9.875T14.125 30H0V15.75q0-5.688 4.188-9.719T14.126 2zM14 24q3.313 0 5.656-2.344T22 16t-2.344-5.656T14 8t-5.656 2.344T6 16q0 2.063.938 3.813L5.5 24.501l5.125-1.25q1.563.75 3.375.75z'
	    ),
	    'dochub' => array(
		'p' => 'M24.875 10H16V1.25zM19 12h6v7.875Q25 32 11.812 32H-.001V0h11.813Q12.937 0 14 .188v5.25q-.938-.125-2.063-.125H5.999v21.063h5.938q7.063 0 7.063-6.25v-8.125z',
		'w' => .78125,
		'vw' => 25
	    ),
	    'docker' => array(
		'p' => 'M21.875 14.75H17.75v-3.688h4.125v3.688zm0-12.75v3.813H17.75V2h4.125zm4.875 9.063v3.688h-4.125v-3.688h4.125zM17 6.563v3.75h-4.125v-3.75H17zm4.875 0v3.75H17.75v-3.75h4.125zm17.313 6.25l.813.563q-.5.938-.5 1.063-1.563 2.875-5.75 2.813-2.563 6.188-7.844 9.469t-12.656 3.281q-6.875 0-10.375-4.125Q1.188 23.814.47 21.002t-.344-5.25h27.188q1.75 0 3.063-.688-.938-1.5-.813-3.313t1-3.188l.563-.875.875.625q2.313 1.688 2.625 3.938 1.188-.188 2.531-.063t2.031.625zM7.25 11.063v3.688H3.125v-3.688H7.25zm4.875 0v3.688H8v-3.688h4.125zm4.875 0v3.688h-4.125v-3.688H17zm-4.875-4.5v3.75H8v-3.75h4.125z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'draft2digital' => array(
		'p' => 'M30 24.875L21 30v-4H0q5.563-5.813 10.063-10.938.188-.188.563-.625 1.313-1.5 2.031-2.375t1.344-2.344.438-2.594q-.25-1.438-1.75-2.156t-3.438.031q-.438.188-1.031.688t-.656.875q.688.063 1.25.406t.938.813.594 1.063.219 1.281q0 1.438-1.031 2.5t-2.531 1.063q-1.688 0-2.75-1.313T3.44 9.5t1.125-3q2.063-3.25 6.563-4.188 1.688-.25 2.969-.313t2.531.313 2 .656 1.469.781.969.719.438.406q.938 1 1.5 2.438t.438 3.375-1.188 3.75q-2.125 3.875-6.938 9.375h5.688v-4.063zm-6.875-1.687v3.375l2.938-1.688zM8.375 10.094q0-.594-.406-1T7 8.688t-1 .406-.438 1 .438 1 1 .406.969-.406.406-1zM5.125 23.75h7.188q5.625-6.125 8-10.375 1-2.063.938-3.656t-.688-2.531L20 6.25Q17.812 4 14.812 3.875q.938.75 1.563 2.25 1.25 3.25-1.813 7.063-3.375 4.125-9.438 10.563z',
		'w' => .9375,
		'vw' => 30
	    ),
	    'dribbble-square' => array(
		'p' => 'M5.625 14.25q.438-1.938 1.688-3.531t3.063-2.469q1.625 2.25 3.188 5-4.188 1.063-7.938 1zm14.063-4.625q-1.375 1.938-4.5 3.063Q13.75 10 12 7.688q2.063-.438 4.063.063t3.625 1.875zM8.75 22.75q.5-.938 1.375-1.938t2.313-1.938 3.063-1.5q1.313 3.438 1.813 6.5-2 .875-4.344.594t-4.219-1.719zM14.938 16q-1.5.438-2.938 1.344t-2.531 2.031-1.844 2.375Q5.437 19.25 5.437 16v-.25q4.25.125 8.813-1.188.438.875.688 1.438zm2.187 1q2.813-.438 5.313.375-.563 3.625-3.688 5.75-.438-2.875-1.625-6.125zm-1.25-3q3.25-1.375 4.75-3.375 1.875 2.313 1.938 5.313-2.938-.688-5.938-.313-.375-.875-.75-1.625z#b#m-4 11q0-4.125-2.938-7.063t-7.063-2.938-7.063 2.938T3.998 16t2.938 7.063 7.063 2.938 7.063-2.938T24 16z'
	    ),
	    'dyalog' => array(
		'p' => 'M0 2h10.688q7.125 0 11.438 4.375 3.875 3.938 3.875 9.625 0 2.625-1 5.125t-2.875 4.5-4.844 3.188-6.594 1.188H0v-4h10.688q5.375 0 8.344-3.031t2.969-6.969q0-4-3.125-7t-8.188-3H4v3.438H0V2.001z',
		'w' => .8125,
		'vw' => 26
	    ),
	    'earlybirds' => array(
		'p' => 'M19.563 3q.063-.625.813-.75t1.5.188q.063 0 .25.094l.5.25.438.313v.281q-.563-.125-1.063-.063t-.938.156-.781.156-.531-.094T19.563 3zM7 3.375q-.313-.188.313-.563t1-.438q.813-.313 1.625-.188t.875.75q.063.5-.156.656t-.594.094-.875-.188-1.031-.188-1.156.063zM19.969 10q.406 0 .688.281t.281.719-.281.719-.719.281q-.25 0-.469-.125t-.375-.375-.156-.5q0-.438.313-.719T19.97 10zm-10 0q.406 0 .719.281t.313.719-.313.719-.719.281-.688-.281T9 11t.281-.719.688-.281zm19.906 10.188q-.688 1.688-4-.063-1.25 6.5-7.875 7.75 0 .063.125.063H19.5q2.063.125 6.063-.5-.5-.375-.688-.969t-.094-.969.219-.438l.25.031.563.219.5.5q.25-.375.688-.594t.781-.281.438 0 .125.406-.063.844-.531.938q.5-.125.625-.125.313-.125.563.375.188.375-.375.438-.125 0-2.938.688-2.813.625-7.313.75l.063.75q.125.875-.719 1.063t-1.031-.688q0 .563-.406.813t-.875.031-.469-.906l-.063.313q0 .875-.875.875t-.875-.875q-.375.625-1.063.406t-.625-.969l.125-.75q-1.063 0-1.969.063t-1.406.094l-.5.031q-.5 0-.75-.313t-.25-.688.25-.688.75-.313q.063 0 .531.031t1.469.094 1.938.063q-6.125-1.563-7.188-7.375-3.563 1.813-4.25.063-.375-.938.375-1.75t2.875-2.188Q4 16 4.313 15.75q.063-.625.125-1.188-.313-.438-.469-.938t-.219-.844-.125-.969-.188-1.063q-1.438.25-1.438-1.438 0-.75.125-.938.063-.063.219-.094t.344-.063.25-.031q.125-.688.625-1.125t1.469-.656 1.625-.281 1.969-.063q2.25-2.5 5.063-3.063-.438-.5-.469-1.125t.094-.969.188-.406.406.063.719.5.5.875q.188-.25.469-.406t.5-.219.281-.031.125.281-.031.656-.406.656q3.375.313 6 3.188 2.125.063 3.375.5t1.438 1.625q.063 0 .281.031t.375.063.156.094q.125.188.125.938-.063 1.625-1.438 1.438 0 .125-.156 1.281t-.406 1.719q.25 1.063.313 2.25.313.25.75.531t.719.469.656.469.594.469.469.406.375.438.219.469.094.469-.125.469zM12.938 10q.063-1-.344-1.594t-1.094-.75-1.594-.219-1.844.063q-2.438.063-2.875.875-.5.938.063 3.406t1.375 2.906q.438.25 2.656.219t2.781-.656q.25-.313.469-1.125t.344-1.688.063-1.438zm3.25 3.625q0-.125-.188-.75t-.344-.906-.406-.344q-.063-.063-.313-.063t-.375.063q-.188 0-.344.281t-.25.563-.219.719-.25.75q.563 0 1 .281t.5.281.219-.156l.406-.406.563-.313zm8.5-5.25q-.375-.813-2.875-.875-1.313-.063-2.406-.031t-1.781.625T16.938 10q0 .938.25 2.375t.563 1.875q.563.625 2.813.688t2.625-.25q.75-.375 1.406-2.844t.094-3.469z',
		'w' => .9375,
		'vw' => 30
	    ),
	    'erlang' => array(
		'p' => 'M5.438 3.375q-4.063 4.938-4.063 12 0 8.063 4.875 13.25H0V3.375h5.438zm14.875.563q2.188 0 3.594 1.438t1.469 3.75H14.751q#q#25 1.781-3.719t3.781-1.469zm14.437-.563H40v25.313h-5.063q2-2.125 3.625-5.063l-6-3q-4.063 6.563-9.5 6.625-4.438-.063-6.563-3.375T14.374 15h23.313v-1.5q.188-5.938-2.938-10.125z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'firstdraft' => array(
		'p' => 'M24 12h-4v8h-8v8H0v-1.625h10.375v-8h8v-8H24V12zm-1.625 2.375H24V24h-8v8H4v-1.625h10.375v-8h8v-8zm1.625 12V28h-4v4h-1.625v-5.625H24zM0 0h24v8h-8v8H8v8H0V0z',
		'w' => .75,
		'vw' => 24
	    ),
	    'fonticons-fi' => array(
		'p' => 'M7.125 14h5.813L12 17.188H7.187v10.188q-.063.25.313.313l3.688.375v2.125H0v-2.188l1.813-.188q.563-.063.563-.688v-9.75q0-.188-.5-.188H.001v-3.188h2.375v-1.813q0-3.125 1.656-4.563t4.969-1.438q2.625 0 4.094.969t1.469 3.594l-4.313.5q0-1.188-.313-1.594t-1.125-.406q-.75 0-1.125.313t-.438.75-.063 1.313v2q0 .063-.031.125l-.063.125-.031.094.063.031zM24 30.188h-8.813v-2.125l1.75-.25q.688-.063.688-.625v-9.25q0-.5-.625-.688l-2.063-.563.563-2.5h6.875v13.375q-.063.125 0 .156t.25.094l1.375.25v2.125zM22.125 8.5l.75 2.813-.625.625-2.625-1.375-2.688 1.375-.625-.625.75-2.813-1.875-2.313.313-.625h2.375l1.313-2.375h.813l1.313 2.375h2.375l.313.875z',
		'w' => .75,
		'vw' => 24
	    ),
	    'fort-awesome-alt' => array(
		'p' => 'M13 14.813q.25 0 .25.25v3.25q0 .188-.25.188h-1.375q-.25 0-.25-.188v-3.25q0-.25.25-.25H13zm7.375 0q.25 0 .25.25v3.25q0 .188-.25.188H19q-.25 0-.25-.188v-3.25q0-.25.25-.25h1.375zM28.625 7q2.875 4.063 2.875 9v.875l-.063.063v.531l-.031.094-.031.125v.125q-.063.188-.063.25v.125l-.063.375v.063q0 .125-.063.25v.188q-.063 0-.063.094v.094l-.031.063-.031.094v.094l-.031.094-.031.094v.094l-.031.094-.031.063q0 .063-.063.188v.188q-.063 0-.063.063v.063q-.063.125-.063.188-.063.125-.125.313 0 .125-.063.188l-.031.063-.031.094-.031.094-.031.063-.063.188-.063.063v.063q-.063.125-.063.188l-.063.188q-.063 0-.125.125v.094l-.031.063-.063.094-.031.125-.063.063q0 .063-.031.125t-.094.125q-.25.5-.438.75v.063q-.063.063-.094.125t-.031.125l-.063.063q-.125.188-.125.219t-.031.063l-.094.094-.063.125-.063.063q0 .063-.063.125t-.063.125h-.063q-3.688 5.375-10 6.438h-.25l-.094.031-.094.031h-.25q-.125.063-.188.063h-.563l-.125.031-.094.031h-1.813l-.094-.031-.094-.031h-.531q-.125-.063-.188-.063h-.375q-.063-.063-.188-.063h-.188q-6.25-1.063-10-6.25v-.063l-.188-.188q0-.063-.031-.094t-.063-.094-.094-.063v-.031l-.063-.094q-.063-.125-.094-.156t-.031-.094q-.063-.063-.094-.125l-.031-.063q0-.063-.031-.063t-.031-.063q-.188-.25-.438-.75 0-.063-.063-.125t-.063-.125q-.063-.063-.063-.094t-.031-.094-.031-.094-.031-.063-.031-.063-.031-.094-.031-.125l-.063-.125q-.063 0-.094-.063t-.031-.094v-.063l-.063-.094-.063-.188-.063-.125q-.063-.125-.063-.188 0-.125-.063-.188 0-.063-.031-.156t-.094-.156v-.188q-.063 0-.063-.063v-.063q-.063-.125-.063-.188t-.031-.094-.031-.063v-.094l-.031-.094-.031-.094v-.063q-.063-.063-.063-.188v-.125l-.031-.094-.031-.094v-.094l-.031-.063-.031-.094v-.094l-.063-.156v-.063l-.063-.375v-.125q-.063-.188-.063-.25v-.5q-.063-.125-.063-.25v-.625l-.063-.125v-.5q0-4.938 2.875-9 .188-.25.438-.563.5-.625 1-1.125.25-.25.5-.563.375-.313.563-.5.438-.313.875-.688.188-.125.313-.188Q9.671 1.499 12.859.811q1.5-.313 3.125-.313 1.563 0 3.125.313 3.188.625 5.875 2.563l.25.188q.5.375.875.688 1.125 1 2.063 2.188.188.188.438.563zM28 23.25v-4.5q0-.25-.25-.25h-1.375q-.25 0-.25.25v1.625h-1.813v-9q0-.25-.25-.25h-1.375q-.25 0-.25.25V13h-1.813v-1.625q0-.25-.25-.25h-1.375q-.25 0-.25.25V13h-1.813v-1.625q0-.25-.625-.25V9.25q.75-.188 1.313-.188.313 0 .813.094t.813.094q1.375 0 1.375-.375V5.812q0-.188-.25-.188-.125 0-.531.094t-.656.094-.813-.094-.875-.094q-.5 0-1.188.125v-.25q.5-.188.5-.688 0-.813-.813-.813t-.813.813q0 .5.5.688v5.625q-.625 0-.625.25v1.625h-1.813v-1.625q0-.25-.25-.25h-1.375q-.25 0-.25.25v1.625H9.56v-1.625q0-.25-.25-.25H7.935q-.25 0-.25.25v9H5.872v-1.625q0-.25-.25-.25H4.247q-.25 0-.25.25v4.5q.875 1.438 2.125 2.625 1.938 1.938 4.438 3 1.313.563 2.688.875v-4.75q0-1.75 1.375-2.469t2.75 0 1.375 2.469v4.75q1.375-.313 2.688-.875 2.5-1.063 4.438-3 1.25-1.188 2.125-2.625z'
	    ),
	    'freebsd' => array(
		'p' => 'M19 6q.938-.938 4.344-2.594t4.344-.719-.719 4.344-2.594 4.344q-.563.563-1.719.125t-2.25-1.531-1.531-2.25T19 6zM6.875 4.25q-3 1.875-4.75 4.938Q-.938 3.875.375 2.563q1.25-1.25 6.5 1.688zm18.563 6.625q.375-.625.688-1.188 1.688 3.063 1.688 6.625 0 5.563-3.938 9.531t-9.531 3.969-9.531-3.969-3.938-9.531q0-3.688 1.813-6.781t4.906-4.906 6.781-1.813q3.25 0 6.188 1.563-.563.313-1.188.688-1.25-.188-1.531.688t.594 2.375q1.063 2.063 3.469 3.688t3.344.688q.5-.5.188-1.625z'
	    ),
	    'gitkraken' => array(
		'p' => 'M35.375 7.375Q36.5 10.438 36.5 13.75q0 7.25-5.031 12.469T19.25 31.688v-9.125q-.75.063-1.5 0v9.125q-7.188-.25-12.219-5.469T.5 13.75q0-3.313 1.125-6.375.313-.688 1-.375.625.25.375.875-1.063 2.813-1.063 5.875 0 6.25 4.125 10.906t10.25 5.469v-7.75q-.688-.125-1.438-.375v6.5q-3.313-.813-5.938-2.938T4.78 20.343t-1.531-6.594q0-4.25 2.156-7.813T11.124.373q.688-.375 1 .313.313.625-.313.938-3.25 1.813-5.188 5.031t-1.938 7.094q0 4.313 2.438 7.781t6.313 5.031v-5.75q-.438-.188-.781-.469t-.563-.719-.219-.938q0-1.25 1.125-1.875-.188-1.688-.656-2.688t-.938-1.25-.844-.531-.375-.781v-.938q0-1.875 3.125-6.031T18.248.31h.5q1.813.125 4.938 4.281t3.125 6.031v.938q0 .375-.25.625t-.594.469-.719.594-.719 1.281-.531 2.281q1.125.625 1.125 1.875 0 .75-.438 1.313t-1.125.813v5.75q3.875-1.563 6.313-5.063t2.438-7.813q0-3.813-1.938-7.031t-5.188-5.031q-.625-.313-.313-.938.313-.688 1-.313 2.375 1.313 4.125 3.313t2.75 4.594 1 5.406q0 5.375-3.281 9.5t-8.344 5.313v-6.5q-.75.25-1.438.375v7.75q4-.5 7.281-2.813t5.188-5.875 1.906-7.75q0-3-1.063-5.813-.25-.625.375-.875.688-.313 1 .375zm-12.5 9.875q-.625 0-1.063.406t-.438 1.031q0 .438.219.781t.531.531.75.188q.625 0 1.063-.438t.438-1.063-.438-1.031-1.063-.406zm-8.75 2.938q.313 0 .594-.125t.469-.313.313-.469.125-.594q0-.625-.438-1.063t-1.063-.438-1.063.438-.438 1.063.438 1.063 1.063.438z',
		'w' => 1.15625,
		'vw' => 37
	    ),
	    'gofore' => array(
		'p' => 'M20.25 20q1.188 0 2.063.5t1.313 1.313.625 1.531.25 1.531Q20.251 30 13.813 30 8 30 4 25.875T0 16q0-5.813 4.031-9.906T13.812 2q5.688 0 9.75 4.125l-3.938 3.938q-2.375-2.438-5.813-2.438t-5.875 2.438-2.438 5.938 2.438 5.938 5.875 2.438q3.25 0 5.625-2.25v-2.125h.813zm-.75-7.062q2.313 0 3.906 1.656T25 19.25v1.875Q23.5 18.5 20.25 18.5h-7.375v-5.563H19.5z',
		'w' => .78125,
		'vw' => 25
	    ),
	    'goodreads' => array(
		'p' => 'M18.75 11.938q.188 1.25 0 2.406T18 16.532t-1.5 1.719q-1 .688-2.313.75t-2.125-.375q-1.625-.813-2.344-2.469t-.594-3.656q#q#625 1.563-4.031t3.188-1.406q1.438 0 2.469.625t1.625 1.688.781 2.563zM28 5.5v21q0 1.438-1.031 2.469T24.5 30h-21q-1.438 0-2.469-1.031T0 26.5v-21q0-1.438 1.031-2.469T3.5 2h21q1.438 0 2.469 1.031T28 5.5zm-7.375 14.063V6h-1.813v2.5q-.063 0-.125-.063-.5-1.125-1.75-2t-3-.875q-2.375 0-4 1.313t-2.25 3.563q-.375 1.313-.375 2.813.063 3.625 1.938 5.5t5.125 1.75q2.875-.125 4.313-2.875l.063-.125h.063v2.125q0 1.563-.438 2.75-.75 2-2#r#438-1.688.375-3.313-.063-2.188-.625-2.563-2.625 0-.063-.125-.063H7.874q.063 1.063.5 1.813 1.063 1.813 3.531 2.406t4.531-.031q4.188-1.063 4.188-6.688z'
	    ),
	    'goodreads-g' => array(
		'p' => 'M2.688 25.188h2.563q.188 0 .188.188.625 3 3.938 3.938 2.438.688 5.063.125 3.125-.688 4.25-3.75.688-1.75.688-4.188.063-.438.063-1.75t-.063-1.5l-.063-.063q0 .063-.063.156t-.063.156q-1.063 2-2.781 3.094t-3.844 1.219q-3.188.125-5.563-1.094t-3.719-3.75-1.469-6.219q0-2.313.563-4.313 1-3.438 3.469-5.438t6.156-2q1.75 0 3.313.719t2.5 1.656 1.438 2q.063.188.125.125V.686h2.75l.063 20.75q-.063 8.563-6.438 10.125-2.313.438-4.594.406T6.72 30.873t-3.219-2.875q-.688-1.188-.813-2.813zM11#r#25Q9.125 2.25 7 4.406t-2.375 6.219q-.188 3.063.875 5.594t3.563 3.719q1.25.688 3.281.594t3.531-1.156q2.125-1.438 2.969-4.094t.406-5.531q-.438-3.5-2.313-5.5t-5.125-2z',
		'w' => .748046875,
		'vw' => 24
	    ),
	    'google-drive' => array(
		'p' => 'M21.188 19.688L10.938 2h10.125l10.188 17.688H21.188zm-8.563 1.437H32L26.937 30H7.562zm-3-16.937l5.188 8.875-9.75 16.938L0 21.126z'
	    ),
	    'google-play' => array(
		'p' => 'M20.313 14.625L6.563.812l17.5 10.063zM2.938 0l16.063 16L2.938 32q-1.375-.688-1.375-2.188V2.187q0-1.5 1.375-2.188zM29.5 14.125q.875.625.906 1.875t-.844 1.875L25.812 20l-4.063-4 4.063-4zM6.563 31.188l13.75-13.813 3.75 3.75z'
	    ),
	    'gripfire' => array(
		'p' => 'M7 18.813q0 .313.063.656t.125.563.25.563.25.5.313.563.313.469.406.531.344.531q.125.125.313.375.813 1.125 1.25 1.75t.813 1.563.375 1.688q0 1.563-1.063 2.938 0-.125.156-.594t.156-.781q0-1.938-4.938-5.438-1.313-1.125-2.063-1.906T2.657 20.69t-.656-2.75q0-2 .938-3.938t2.313-3.469 2.719-3.031 2.281-3.156.938-3.219q0-.313-.063-.625.25.125.813.844t1.125 2.094.563 2.688q0 1.688-1.031 3.469t-2.281 3.063-2.281 2.969-1.031 3.188zm12.875-2.438q.125.813.125 1.563 0 4.188-4.188 8.563l-.188.125q-.25 0-1.25-1.406t-1-1.906q.313-.375.75-1.031t1.156-2.281.719-2.75q0-1.063-.563-2.063-.063.875-.938 2.25t-1.75 2.281-.938.906-.156-.094-.219-.281-.25-.438-.25-.531-.188-.625-.063-.656q0-.5.188-1l.594-.844 1.219-1.844L13.841 12l.531-2.25q0-.625-.188-1.063l-.25-.438q1.188.438 3.313 2.938t2.625 5.188z',
		'w' => .6875,
		'vw' => 22
	    ),
	    'grunt' => array(
		'p' => 'M3.813 11.813q.063-.563.438-.75-.438-.125-.813-.25 2.875-.688 5.188 2 .438.563 1 .688t.875 0l.375-.125q0 .5-.406.844t-.969.344q.063.313-.031.594t-.219.531-.25.469-.25.344l-.125.125q.063-.063.063-.125t.063-.25.094-.375.031-.438-.063-.438q-.063-.25-.188-.5-.563.563-1.313.5t-1.281-.313-.844-.563q-.75-.813-.813-2.125-.188.375-.25 1 0-.063-.063-.156t-.156-.406-.094-.625zm1.812-.063q-.188.375-.094 1.125T6 13.938q1.125#r#375.063-.75-1.125-2.75-2.25zm8.875 2.813q-.563 0-.969-.344t-.406-.844q1.188.625 2.25-.563 2.313-2.688 5.188-2-.375.125-.813.313.375.125.438.688 0 .313-.063.594t-.188.469l-.063.125q-.063-.563-.25-1-.125 1.313-#r#125-.188.188-.563.406t-.875.375-1.031.063-.969-.469q-.125.313-.188.5-.063.375-.031.719t.094.656l.125.25q-.125-.125-.281-.344t-.406-.75-.188-.969zm3.875-2.813q-2 1.125-2.75 2.25 1.188.75 2.313-.063.438-.313.531-1.063t-.094-1.125zM10 26.125q.375 0 .531.188t.094.438q-.25.625-.813 1.25-.313.25-.719.25t-.719-.25q-.625-.563-.875-1.125-.125-.375.063-.563t.625-.188H10zm11.813-6.312l.5.5.688 1.469.125 2.469q-.438 2.5-2.938 3.438-1.25 2.813-4.188 3.063-1.5 1.25-4 1.25t-3.938-1.25q-2.938-.25-4.25-3.063-1.188-.438-1.938-1.281t-1-2.156.094-2.438.781-1.563l.438-.438q.188 1.625 1.563 2.75.188-1.688.188-3.875 0-.625-.281-1.063t-.469-.563-.5-.313q-.813-.438-1.219-.688t-.875-.813-.469-1.25q0-1 1-1.688 0-.063.063-.094l.063-.031q.25-.188.25-.313.188-.375.219-1.281T1.626 9.56Q.563 8.31.876 7.122q.188-.75.875-1.063.5-.25 1.25-.313 0-.125.063-.375.063-.313.063-.5-.063-.563-.188-.688-.188-.375-.656-.656t-.781-.375-.375-.094l-.75-.125.5-.563q1.125-1.125 2.875-1.125.75 0 1.5.25 1.688.5 3.125 2.438.25-.125.375-.125-.063-1.125.594-2.031t1.156-.969v.313l.031.531.125.5.281.344q.25-1.75 2.438-2.5-.375 1.063.125 2.313.563-.5 1.094-.75t.781-.25l.25.063q-.125.125-.25.406t-.281.906-.031 1.063q.313.063.563.188 1.438-1.938 3.125-2.438.75-.25 1.5-.25.813 0 1.531.281t1.031.5.313.281l.5.625-.75.125q-.063 0-.375.094t-.75.375-.688.656q-.125.125-.125.688-.063.188.063.5v.375q.75 0 1.25.25.688.375.875 1.125.125.5-.063 1.125t-.375.906-.313.406-.094 1.031.219 1.281q.063.125.25.313.063 0 .125.063 1 .75 1 1.75 0 .625-.469 1.219t-.875.844-1.219.688q-.438.25-.5.25-.188.188-.469.625t-.281 1.063q0 2.188.25 3.875 1.313-1.125 1.5-2.75zM19.125 2.375q-1.313.375-2.375 2 .125.063.313.125.25.125.438.25.375-.75 1.25-1.438.813-.563 1.813-.563.313 0 .563.063.313-.188.625-.313-.75-.313-1.563-.313-.563 0-1.063.188zM20.438 3.5q-.688 0-1.25.438t-.813 1.375q.375.375.625.75.313-.125.75-.188.188-.313.25-1.094t.25-1.094zM2.875 2.813q.25 0 .563-.063 1 0 1.75.563.938.688 1.313 1.438.313-.188.438-.25t.313-.125q-1.063-1.625-2.375-2-.5-.188-1.063-.188-.813 0-1.563.313.313.125.625.313zm2.75 2.5q-.25-.938-.813-1.375-.5-.438-1.25-.438l.188.188q.188.375.25 1.125t.25 1.063q.313.063.75.188.188-.375.625-.75zm-2 10.937q1.125.625 1.188 2.125.125 1.563-.188 4.75.938.375 2.438.438.25-.438.375-.813 1.063-3 1.625-3.875-.375 2.688-1.438 5.563.375-.063.75-.063h7.25q.438 0 .75.063-1.063-2.875-1.438-5.563.688 1.063 1.625 3.875.125.375.375.813 1.5-.063 2.438-.438-.313-3.188-.188-4.75.063-1.5 1#q#125.438-.25.5-.313.625-.313.938-.5t.656-.594.344-.781q0-.688-.563-1.125l-.063-.063-.063-.031-.063-.094q.125.813.188.938-.75-.938-1-2.75-.188-1.563.313-2.688v.875l.125-.125q.75-.938.563-1.625-.063-.375-.438-.5-.313-.188-.938-.188-.875 0-2.063.375-1.625.5-4 2.375l-.375.25.25-.375q1.375-2.063 3.313-2.938-.313-.375-1.375-.938-2-.938-4.625-.938t-4.625.938q-1.063.563-1.375.938 2 .875 3.313 2.938l.25.375-.375-.25q-2.375-1.875-4-2.375-1.188-.375-2.063-.375-.563 0-.938.188-.375.125-.438.5-.188.688.563 1.625l.125.125v-.875q.5 1.125.313 2.688-.125.813-.344 1.5t-.406 1l-.25.25q.125-.125.188-.938l-.188.188q-.5.438-.5 1.125 0 .563.469.969t1.406.906q.375.25.5.313zm-1.437 9.063q1.125 1.813 3.625 1.813-.438-1.25.25-2l.063-.063q.313-.313.5-.625-3.813-.188-4.688-2.813-.313.125-.281 1.469t.531 2.219zM5 28q.813 1.125 1.938 1.625-.375-.563-.75-1.5-.563 0-1.188-.125zm7 3.125q3.875 0 5.313-4 .313-1-.063-1.5-.375-.438-1.563-.438H8.312q-1.188 0-1.563.469t-.063 1.469q1.438 4 5.313 4zm5.063-1.5q1.125-.5 1.938-1.625-.625.125-1.188.125-.375.938-.75 1.5zm4.75-4.312q.5-.875.531-2.219t-.281-1.469q-.875 2.625-4.625 2.813.188.313.438.625l.063.063q.688.75.25 2 2.563 0 3.625-1.813zM12 11.75q-.375 0-.781-.281t-.656-.594l-.25-.25q.813.5 1.688.5t1.688-.5q-.875 1.125-1.688 1.125zm3.875 14.375q.375.063.563.219t.063.469q-.25.625-.875 1.125-.313.313-.719.313t-.719-.313q-.563-.625-.813-1.188-.063-.25.094-.438t.531-.188h1.875z',
		'w' => .75,
		'vw' => 24
	    ),
	    'gulp' => array(
		'p' => 'M13.125 24.438l-.875 1.563-.313 5q0 .438-1.156.719T8 32.001q-1.063 0-1.969-.125t-1.438-.375-.531-.5l-.375-5-.938-1.563q1.938.813 5.219.813t5.156-.813zM.875 8.625q1.438.813 7.125.781t7.125-.781l-.938 8.5q-.75.688-1 .875-.438.313-.5.313-.188 0-.188-.125.063 0 .375-.375.813-1 .813-1.438 0-.25-.188-.406t-.563-.094-.813.438l-.313.313q.063-.188.063-.375 0-.25-.25-.25-.063 0-.188.063-.125.188-.313.75 0 .063-.125.313l-.063.063q-1 1.063-1.438 1.063-.125 0-.063-.375.125-.25.563-1.375 0-.125.313-.844t.5-1.156q.125-.313.25-.563 0-.063.063-.125.063-.25-.063-.375-.125-.063-.188-.063-.313 0-.438.313-1.563 4-1.625 4.25-.25.188-.438.25-.438.188-.438-.063t.188-.75q.063-.188.219-.531t.219-.469q.125-.313 0-.438t-.25-.125q-.188 0-.313.313-.063.188-.125.313-.063.313-.313.813-.313.563-.688.813-.25.125-.438.125-.25 0-.125-.563.125-.313.625-1.25.125-.375-.063-.5h-.063q-.313-.125-.5.25-.25.563-.438 1-.438 1.188-.313 1.5t.563.313q.875 0 1.375-.938-.188.875.25.969t1-.469q0 .063.031.094l.031.031q.125.563.875.25.438-.188.938-.688l-.063.188q-.938 2.063-.969 2.125t-.031.188.125.188q.125.125.375.063.125-.125.25-.313 0-.063.031-.094t.031-.063.063-.25.188-.469q.188-.5.563-1.375.25-.563.563-.938.25-.438.5-.625.625-.438.75-.188 0 .188-.313.5-.875 1.188-.875 1.375 0 .375.406.438t.656-.063q.438-.188 1.25-.938l-.688 5.938q-.063.125-.75.375t-2.031.469-2.75.219-2.719-.219-2-.469-.75-.375l-.5-5q.188.125.5.125.563 0 1.313-.75.188-.125.438-.375-.438 1.313-.5 1.563 0 .313.063.375.063.125.188.125.25 0 .375-.5.125-.375.5-1.625.125-.5.313-.969t.25-.688.063-.469q0-.188-.125-.281t-.281-.031-.219.313l-.313.938q-.25.438-.813 1-.625.625-1 .625-.188 0-.313-.188-.188-.438.063-1.25.25-.875.75-1.781t1.063-1.281q.688-.5 1.063.188.25.438.438.438.375 0 .25-.563-.063-.438-.625-.75t-1.188-.063q-.813.375-1.5 1.375t-1 2.063zm14.375-.562q0 .625-3.625.875t-7.25 0T.75 8.063q0-.375 2.125-.688T8 7.062q.938 0 1.625.063l.813-3.063 3.813-4q.188-.188.625.188.5.438.313.563v.063l-3.563 3.75-.625 2.563q4.25.25 4.25.875zm-4.375.312q0-.063-.125-.125l-.063.063q0 .125-.688.125t-.688-.125V8.25h.063q-.25.063-.25.125 0 .25.875.25t.875-.25z',
		'w' => .498046875,
		'vw' => 16
	    ),
	    'hacker-news-square' => array(
		'p' => '#a#M14.938 17.688L20.001 8h-2.188q-1.5 2.813-2.219 4.281t-1.063 2.344-.469 1.25q-.125-.313-.406-1t-.5-1.219-.938-2.031T10.312 8H7.999l5 9.563v6.438h1.938v-6.313z'
	    ),
	    'hire-a-helper' => array(
		'p' => 'M27.688 0q.125 1.125.719 2.094t1.531 1.594 2.063.813v23.125q-1.688#q#906 1.438t-1.344 2.938H4.501q-.313-1.688-1.531-2.875T.001 27.689V4.501q1.75-.188 3.031-1.469T4.501.001h23.188zm-2.313 25.313q.375 0 .344-.344t-.344-.344Q24.5 24.312 24 23.75q-.313-.563-.406-2.094T23.5 15.75V9.437q0-.625.281-1.063t.625-.625.906-.313q.375-.125.281-.438t-.344-.313q-1.125 0-1.781.063t-1.781.063q-1 0-1.531-.063t-1.531-.063q-.188 0-.281.281t.219.406l.188.031.281.094.313.188.344.281.281.406.219.625.063.813q0 3.625-.063 4.313 0 .063-.031.25t-.25.375-.469.188h-6.875q-.25 0-.469-.188t-.25-.375-.031-.25q-.063-.688-.063-4.313 0-.438.063-.813t.219-.625.281-.406.344-.281.313-.188.281-.094l.188-.031q.313-.125.219-.406t-.281-.281q-1 0-1.531.063t-1.531.063q-1.125 0-1.781-.063t-1.781-.063q-.25 0-.344.313t.281.438q.875.188 1.344.625t.469 1.375v6.313q0 4.375-.094 5.906t-.406 2.094q-.5.563-1.375.875-.313 0-.344.344t.344.344q1.125 0 1.719-.063t1.719-.063 1.781.063 1.719.063q.25 0 .25-.281t-.25-.344q-1.25-.438-1.563-.813-.188-.313-.281-1.281t-.094-1.844.031-2.219.031-1.719q0-.25.25-.531t.563-.281h7q.313 0 .563.281t.25.531q0 .375.031 1.719t.031 2.219-.094 1.844-.281 1.281q-.25.375-1.563.813-.25.063-.25.344t.25.281q1.063 0 1.719-.063t1.781-.063 1.719.063 1.719.063z'
	    ),
	    'hotjar' => array(
		'p' => 'M25.938 10.125q1.438 2.5 1.875 5.469t-.25 5.781q-.75 2.875-3.219 5.438t-6.094 3.688q1.688-2.375 2.094-5.375t-.594-5.313T16.562 17q2 3.438.063 6.25-1.563 2.188-3.938 1.813-1.75-.25-3.063-2.188-.188.688-.406 1.594t-.156 2.938.875 3.594q-6.938-1-9.063-5.813-1.563-3.75-.25-6.969t5.188-5.844Q8.062 10.812 9.093 9t.844-3.344-.688-2.844T8.186.749l-.625-.75q.563.063 1.5.25t3.563.938 4.875 1.781 4.688 2.906 3.75 4.25z'
	    ),
	    'hubspot' => array(
		'p' => 'M16.688 13.25L6.5 6.062q-.813.438-1.688.438-1.313 0-2.281-.938t-.969-2.281.969-2.313 2.313-.969 2.313.969.969 2.281q0 .438-.125.875 1.813 1.375 5.875 4.344t4.688 3.469q1.25-.688 2.625-.875V7.249q-1.75-.75-1.75-2.688 0-1.25.844-2.125t2.063-.875 2.094.875.875 2.125q0 1.938-1.75 2.688v3.875q2.938.438 4.906 2.719t1.969 5.281q0 3.375-2.375 5.75t-5.75 2.375q-2.75 0-4.938-1.625l-3.125 3.125q.125.313.125.75 0 1.063-.75 1.75-.75.75-1.813.75t-1.75-.75q-.75-.688-.75-1.75t.719-1.781 1.781-.719q.438 0 .875.125l3.125-3.125q-1.625-2.125-1.625-4.875 0-3.5 2.5-5.875zm5.593 10.188q1.781 0 3.063-1.25t1.281-3.063q0-1.188-.594-2.156t-1.563-1.563-2.156-.594q-1.813 0-3.063 1.281t-1.25 3.063 1.25 3.031 3.031 1.25z'
	    ),
	    'itunes' => array(
		'p' => 'M13.969 5q4.406 0 7.563 3.156t3.156 7.563-3.125 7.563T14 26.438t-7.594-3.156-3.156-7.563 3.156-7.563T13.969 5zm4.969 15q.063-.25.063-10.438 0-.625-.563-.563-.063 0-7.188 1.313-.188 0-.438.188-.188.125-.188.375-.063.125-.031 4.219t-.156 4.156q-.125.188-.5.25-1.875.313-2.375.813-.688.625-.375 1.563T8.5 23.001q1.063.188 1.938-.375.75-.375.938-1.188.063-.375.063-7.438 0-.438.438-.5 5.5-1 5.75-1.063.5-.125.5.375v2.75q.063 2.125-.094 2.313t-.531.25q-1.875.313-2.375.75-.5.5-.469 1.188t.594 1.125q.688.563 2 .313 1.375-.25 1.688-1.5zm2.625-18q2.688 0 4.563 1.875t1.875 4.563v15.125q0 2.688-1.875 4.563t-4.563 1.875H6.438q-2.688 0-4.563-1.875T0 23.563V8.438Q0 5.75 1.875 3.875T6.438 2h15.125zM14 27.75q3.25 0 6.031-1.625t4.375-4.375T26 15.719t-1.594-6.031-4.375-4.375T14 3.688q-5 0-8.531 3.531t-3.531 8.5 3.531 8.5T14 27.75z'
	    ),
	    'itunes-note' => array(
		'p' => 'M23.875 24.25q-.313 1.25-1.219 2t-2.219 1q-2.625.5-4.063-.625-1.063-.938-1.125-2.313t1-2.313q.5-.5 1.313-.813t1.344-.438T21 20.373q.688-.125 1-.5.25-.25.281-.813t.031-3.813q-.063-3.188-.063-5.563 0-.938-1.063-.75L9.623 11.122q-.5.063-.688.281t-.188.719v8.063q.063 6.188-.125 6.875v.063q-.375 1.688-1.875 2.438-.813.438-2 .625t-2 .063q-2-.375-2.594-2.25t.781-3.188q.5-.5 1.344-.813t1.375-.406 2.094-.406q.688-.125 1-.438.313-.438.281-8.406t.031-8.469q.063-.563.438-.813.375-.375.813-.375 14.375-2.688 14.563-2.688 1.125-.063 1.125 1.125V15.06q0 8.625-.125 9.125v.063z',
		'w' => .75,
		'vw' => 24
	    ),
	    'jenkins' => array(
		'p' => 'M30.438 26.563q.063.438-.563 2.5-.5 1.625-.875 2.938H2.625q-.063-.063-.125-.25v-.125q-.125-.25-.281-.688t-.281-.75-.219-.719-.156-.719q-.063-.563.156-.906t.844-.625.813-.406q.625-.438 3.5-2.125 1.688-1 1.688-1.125.125-.25.031-.563t-.344-.688-.313-.5q-.438-.938-.5-1.875-1.563-.25-2.438-1.563-.688-1.063-.938-2.469t#q#781l.156-.156.156-.219.125-.25q0-.188-.031-.438t-.094-.5-.063-.438q-.125-3.938 1.875-4.875.188-.563.469-1.094t.594-.875.875-.75.906-.594l1.031-.563 1-.625q.688-.375 2.5-1.063 2.313-.875 5.531-.625t5.094 1.688q.438.313.969.781t1 1 .906 1.094.688 1q1.188 2.5 1.25 6.375t-.875 6.875q-.375 1.313-.688 2-.063.125-.313.563t-.406.75-.125.5.406.563.906.813.594.5q.125.125.5.438t.594.531.438.5.219.531zM12.875 2.125q-1.75.5-3.375 1.563T7.312 6.063q.25-.063.813-.25t.938-.188q.063-.063.406 0t.406 0q.25-.063.531-.406t.531-.813.438-.656.406-.375.469-.344.375-.344q.063 0 .219-.063t.25-.156.094-.219q-.188-.188-.313-.125zM6.313 7.938q-.875 1-.625 4.25 1.25-.75 2.563-.125t1.313 2q.188 0 .313-.125t.094-.313-.063-.344-.125-.438-.094-.406q-.188-.938.156-3.125t-.094-3Q7.626 6.5 6.313 7.937zM8.625 20.5q.563 2.25 1.625 3.813.938 1.25 4.313 1.5.375-.875 2.25-.438-1-.375-2.5-2-1.625-1.813-1.688-3.063 1.063 1.5 1.594 2.125t1.625 1.5 2.406 1.313q2.813.938 6.188-1.5.438-.25 1.563-1.875 2.75-3.938 2.438-9.813-.125-3.125-.563-3.938-.438-.875-1.438-1.25t-1.813.25q-.125-.5.156-.875t.781-.469 1.125.031q-.125-.125-.375-.469t-.406-.531-.406-.469-.438-.5-.438-.438-.469-.406-.531-.313q-1.75-1.063-3.938-1.406t-4.125.406q-4.188 2.063-5.188 4.375.25.625.281 1.375t-.094 1.313-.281 1.375-.219 1.375q0 .563.25 1.531t.313 1.469q-.375.563-1.688.5-.438-2.063-1.563-2.188-1-.125-1.719.563t-.781 1.688q-.063 1.188.781 2.469t1.969 1.156q.313-.063.75-.375t.75-.313q.188.25.094.469t-.25.375-.313.344-.156.313q-.063.25.125 1zM22.5 28.25q-.063.125-.031.438t-.031.563q1.375.375 3.188.438.313-.438.25-1.438 0-.688-.156-1.406t-.469-.906q-.375-.188-.969.063t-1.25.688l-.844.563q.188.563.188.625.625-.188 1.188.125-.938.125-1.063.25zM21.438 27q.188-.188.625-.563t.75-.563q-.375.063-1.219.281t-1.281.25-1.188-.219q0 .063-.063.063t-.063.063q1 .75 2.438.688zm-#r#063q1 .313 1.125-.563.188-.813-.5-.938-.313-.063-.75.25-.063.125.125 1.25zm-6.5-1.625q0-.188.094-.563t.094-.5q-.313-.063-.906-.094t-1-.094-.656-.25q-.438.375.625.906t1.75.594zm-10.5 3.625h11.25l-.125-.438q-.438-1.375-.5-2.25-2.625-1.25-3.563-1.875-.063 0-.438-.469t-.75-.875-.438-.344q-2.563 1-6.375 3.938.5 1.063.938 2.313zm15 .375zm.5-.375h.563q-.063-.063-.188-.25-.063 0-.375.25zm.938-1.563v-.625q-.688-.375-1.438-.375.188-.125.656-.219t.719-.219v-.313q-.375 0-1.375-.563-1.313-.75-2.75-1-.438-.063-.656.188t-.281.656-.094.906.031.875q0 .438.688 2.313.188.563.313.625.688.125 2.125-.625.438-.25 1.125-.844t.938-.781zm3.312 1.563l.063-.813q-.375.063-.875-.281t-.688-.344q-.188-.063-.625.156t-.75.094l-.125.125-.125.156-.125.156q.25.313.563.75h1.063q0-.375.375-.375t.375.375h.875zm.563 0h2.25q-.875-1.313-2.188-.688-.063.375-.063.688zm5.187-2.313q.313-1.375.25-1.563 0-.25-.219-.5t-.625-.563-.469-.375q-.313-.25-.969-.938t-1.094-1.063q-.188.25-.438.469t-.5.406-.375.375q1.375-.688 1.75 1.688.375 2-.25 3.188.063.25.344.531t.344.469q-.063.063-.125.188h1.75q.438-1.313.625-2.313zM13.875 8.125q.313-.75 1.188-1.406t1.625-.594q.438.125.719.438t.031.688q-2.188-.5-3.375 2.063-.563-.125-.188-1.188zm11.5 4q.25-.125.938-.156t.938-.219q-.625-1.688-.563-2.313h.063q1.063 2.188 1.313 2.563-.125.438-.813.75t-1.281.188-.594-.813zm-6 .125q-1.25-1.938-.938-2.813.063.063.406.906t.719 1.156q0 .063.125.156t.188.156.125.188.094.219.031.25-.063.281q-.063.188-.313.375t-.438.25q-.813.25-1.781-.031t-.469-1.031q.125 0 .313.031t.344.063.344.063l.375.063h.344l.313-.094.281-.188zm1.688 4.375q.063.125.125.469t.188.563.438.281q.438.063.969-.063t.938-.281.938-.438.781-.344q.188-.25.219-.469t-.031-.438-.156-.313-.313-.344-.281-.313q-.813-1-1.156-1.438t-.781-1.406-.438-1.844q.375-.25.5.438v.188q.688 1.5 2.938 3.938.063.125.25.281t.281.25l.156.156q.063.313-.125.844t-.188.656q-.875.563-1.438.875t-1.594.563-2.031.125q-.375-.313-.438-.875t.25-1.063zM8.5 16.063q-.188-.063-.344-.406t-.313-.625-.406-.281q-.125 0-.25.063t-.188.219-.094.281-.031.406v1.219q-.375-.313-.438-1.156t.188-1.344q-.125-.125-.25-.063t-.188.125-.188.156-.188.156q.188-1.375 1.344-1.125t1.344 1.563q.063.375 0 .813zm18.688 1.812q-1.313 2.5-3.375 2.563-.063-.938 0-1.188.5-.063 1-.219t.813-.344.781-.438.781-.375zm-8.875.75q1.438.75 4.938.625.125.313.125 1.25-1.75.063-3.219-.375t-1.844-1.5zm5.75 2.938q-.188.563-.563.688-.688.25-1.844.313t-2.094-.313q-.313-.188-.563-.438t-.531-.688-.344-.5l-.188-.188q-.688-.625.188-.625.375.938 1.375 1.375t2.156.406 2.406-.031z',
		'w' => .998046875
	    ),
	    'joget' => array(
		'p' => 'M23.625 2.813q5.5 3.375 6.969 9.625t-1.906 11.719-9.625 6.938-11.719-1.906-6.938-9.625T2.312 7.876q2.188-3.5 5.719-5.438T15.5.5q4.375 0 8.125 2.313zM26.875 23q.5-.75.875-1.625-.125 0-2.344.031t-3.813.094-3.688.313-3.219.625q-.688.25-1.156.563t-.75.563-.406.594-.156.563.031.594.125.5.219.469l.156.344q.438 1.125 1.5 2.688.688.063 1.25.063 3.438 0 6.469-1.688t4.906-4.688zm-12.562-5.375q3.188.063 14.375.313.563-3.875-1.094-7.531T22.5 4.626q-4.688-2.875-10.063-1.594T4.124 9.001q-2.688 4.313-1.75 9.313.313-1.25.938-2.438t1.813-2.656T8.5 10.751t5-1.188q2.563-.188 2.375.813-.125.563-.875 1-.125.125-.719.438t-.906.531-.844.563-1 .781-.844.938q-1.063 1.25-.031 2.094t3.656.906zm11.5-3.437q.625.188.938.438t.25.375v.188l-2.875 1.438-10.625.125q2.125-.688 4.063-2 .313-.188.938-.594t.969-.625.813-.5.844-.375.688-.094.625.125q.313.188.438.375t-.031.375-.313.281-.5.281-.406.25l-3.188 2.125.375.125q.563-.063 1.563-.625 3.938-2.063 5.438-1.688z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'js' => array(
		'p' => 'M0 2h28v28H0V2zm15.25 21.813v-8.938h-2.625v8.938q0 1.625-1.438 1.625-.938 0-1.688-1.313l-2.125 1.25q1.125 2.438 3.938 2.438 1.813 0 2.875-1t1.063-3zm6.188 4q1.938 0 3.156-.969t1.219-2.719q0-1.563-.844-2.438t-2.656-1.688l-.625-.25q-.938-.438-1.281-.75t-.344-.875q0-.313.156-.563t.438-.406.656-.156q1.063 0 1.688 1.125l2.063-1.313q-1#q#125-3.75-2.125-1.75 0-2.813 1t-1.063 2.5#r#406 2.375 1.531l.625.313.844.375.594.344.406.469.094.563q0 .563-.5.938t-1.313.375q-1.563 0-2.563-1.625l-2.125 1.25q1.313 2.688 4.75 2.688z'
	    ),
	    'js-square' => array(
		'p' => '#a#m-9.75 21.813v-8.938h-2.625v8.938q0 1.625-1.438 1.625-.938 0-1.688-1.313l-2.125 1.25q1.125 2.438 3.938 2.438 1.813 0 2.875-1t1.063-3zm6.188 4q1.938 0 3.156-.969t1.219-2.719q0-1.563-.844-2.438t-2.656-1.688l-.625-.25q-.938-.438-1.281-.75t-.344-.875q0-.313.156-.563t.438-.406.656-.156q1.063 0 1.688 1.125l2.063-1.313q-1#q#125-3.75-2.125-1.75 0-2.813 1t-1.063 2.5#r#406 2.375 1.531l.625.313.844.375.594.344.406.469.094.563q0 .563-.5.938t-1.313.375q-1.563 0-2.563-1.625l-2.125 1.25q1.313 2.688 4.75 2.688z'
	    ),
	    'keycdn' => array(
		'p' => 'M4 25.563l3.75-3.688q3.063 4.125 7.938 4.25 2.938.063 5.375-1.438l.469.469.531.563.313.344q-3.063 2-6.75 1.938-4.188-.125-7.375-2.813.063 0-1.063 1.094t-1.313 1.281q.438 1.438-.469 2.656T3 31.438q-1.313 0-2.156-.875T0 28.438q0-1.625 1.281-2.5T4 25.563zm22.188-15.75q1.875 3.063 1.75 6.5-.063 4.25-3 7.563l1.5 1.563q.938-.125 1.625.563.5.563.5 1.344T28 28.659t-1.344.531-1.344-.563q-.625-.688-.438-1.625l-2.813-3q3.938-3.125 4.063-7.75.063-2.625-1.313-5.125zM6.5 3.313q.688.688.5 1.625l2.875 3.063q-.938.688-1.438 1.313-2.438 2.75-2.563 6.438-.063 2.75 1.25 5.125l-1.375 1.375q-1.813-3.063-1.75-6.563.125-4.25 3-7.563L5.374 6.438q-.938.125-1.625-.563-.5-.563-.469-1.313t.563-1.313 1.313-.531 1.344.594zM29.063.5q1.188 0 2.063.906t.875 2.125-.875 2.094-2.063.875q-.688 0-1-.125l-3.938 3.75q-3.063-4.063-7.938-4#q#938-.063-5.375 1.375L9.499 5.937q3.063-1.938 6.75-1.875 4.188.125 7.375 2.813l2.563-2.438q-.125-.438-.125-.938 0-.813.406-1.5T27.562.905t1.5-.406zm-13 6.563q.438 0 1 .063 3.688.5 5.938 3.406t1.813 6.563-3.375 5.938-6.594 1.813-5.906-3.375-1.813-6.594q.438-3.375 2.969-5.563t5.969-2.25zm-3.688 7.5q.063 2.25 2 3.25l-.688 3.25h4.625l-.688-3.25q2-1.063 2-3.25 0-1.563-1.063-2.594t-2.563-1.094q-1.5.063-2.563 1.094t-1.063 2.594z'
	    ),
	    'kickstarter' => array(
		'p' => 'M25 30H3q-1.25 0-2.125-.875T0 27V5q0-1.25.875-2.125T3 2h22q1.25 0 2.125.875T28 5v22#n# 30zM12.5 11.125q0-.688-.219-1.219t-.531-.875-.781-.531T10 8.312q-1.188 0-1.844.813t-.656 2v9.688q0 .563.156 1.094t.469.906.813.594 1.063.219q1.125 0 1.813-.719t.688-2.094v-2.625l3.75 4.75q.625.688 1.656.719t1.844-.719q.688-.688.719-1.625t-.469-1.563l-3.063-3.938 2.5-3.625q.5-.625.438-1.531t-.75-1.531q-.75-.813-1.938-.75t-1.938 1.188l-2.75 4v-2.438z'
	    ),
	    'kickstarter-k' => array(
		'p' => 'M9.188 7.125v4.438l5.188-7.375q1.375-2 3.563-2.125t3.563 1.313q1.25 1.188 1.375 2.844t-.75 2.781l-4.688 6.688 5.688 7.188q.938 1.125.844 2.813t-1.281 2.938q-1.5 1.438-3.438 1.375t-3.063-1.375l-7-8.625v4.75q0 2.625-1.25 3.938t-3.25 1.313q-2.25 0-3.469-1.469T.001 24.754V7.066q0-1.438.531-2.563T2.126 2.69t2.5-.688q2 0 3.281 1.313t1.281 3.813z',
		'w' => .75,
		'vw' => 24
	    ),
	    'laravel' => array(
		'p' => 'M39.875 15.125q.375.438-.313.625-.438.125-5.438 1.5 4.688 6.313 4.938 6.625.188.438.063.594t-.563.344-6.438 2.313-6.563 2.313q-.75.313-1.219.25t-.906-.688q-.625-.813-4.563-7.938-6.688 1.75-8.375 2.188-1.438.313-2.063-1-.063-.125-2.031-4.406t-4-8.656T.185 4.314q-.563-1.25.5-1.375 6-.5 8.063-.625h.5l.344.156.219.219.25.375 9.625 16.063 12.125-2.875q-.375-.563-2.125-3.031t-1.875-2.656q-.438-.625.563-.75.125-.063 1-.219t1.813-.281 1.781-.281.969-.156q.75-.125 1.313.563.375.375 2.406 2.938t2.219 2.75zm-22.062 4.5q.313-.063.063-.375l-9-15.625q-.125-.188-.313-.188-.063 0-3.313.281t-3.313.281q-.188 0 0 .375.125.188 4.156 8.5t4.031 8.375q.063.188.438.063.188 0 3.688-.844t3.563-.844zm19.125 3.563q0-.063-1.938-2.688t-2.063-2.813q-.188-.25-.563-.125l-11.813 3.063q3.625 6.25 3.938 6.625.25.5.625.313.125-.063 2.969-1.031t5.719-1.938 3-1.031q.313-.063.125-.375zm.75-8.375q.5-.125.375-.313-3.063-3.813-3.438-4.313-.188-.313-.5-.25-3 .625-4.5.813-.25.063-.063.313l3.563 4.875q4.313-1.063 4.563-1.125z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'line' => array(
		'p' => 'M17 12.75v4.438q0 .188-.188.188h-.688q-.125 0-.188-.063l-2.063-2.75v2.625q0 .25-.188.25h-.688q-.25 0-.25-.25V12.75q0-.188.25-.188h.688q.125 0 .188.063l2 2.75V12.75q0-.188.188-.188h.75q.188 0 .188.188zm-5.125-.187q.188 0 .188.188v4.438q0 .188-.188.188h-.688q-.188 0-.188-.188v-4.438q0-.188.188-.188h.688zm-1.687 3.75q.188 0 .188.188v.688q0 .188-.25.188H7.313q-.063 0-.125-.031t-.063-.156v-4.438q0-.188.188-.188h.688q.25 0 .25.188v3.563h1.938zm10.562-3.75q.188 0 .188.188v.75q0 .188-.188.188h-1.938v.75h1.938q.188 0 .188.188v.75q0 .188-.188.188h-1.938v.75h1.938q.188 0 .188.188v.688q0 .188-.188.188h-2.875q-.188 0-.188-.188v-4.438q0-.188.188-.188h2.875zM28 7.125v17.813q0 2.125-1.5 3.594t-3.625 1.469H5.062q-2.125 0-3.594-1.5t-1.469-3.625V7.063q0-2.125 1.5-3.594T5.124 2h17.813q2.125 0 3.594 1.5T28 7.125zm-3.875 7.625q0-3.375-2.969-5.813t-7#q#438-7.219 2.438-3 5.813q0 3.063 2.438 5.375t6.125 2.813q.813.188.906.656t-.156 1.656v.25l.031.281.25.156.594-.188q.625-.25 2.063-1.125t3.219-2.25 2.781-2.5q2.125-2.438 2.125-5.125z'
	    ),
	    'lyft' => array(
		'p' => 'M0 5.063h4.875v13.063q0 2.688 1.688 3.813-.75.625-2.125.719t-2.875-.906Q0 20.502 0 18.064v-13zm30.375 10.875q0 .625.469 1.094t1.156.469v4.813q-1.75 0-3.219-.875t-2.344-2.344-.875-3.219v-4.813q0-1-.813-1.438t-1.625 0-.813 1.438v1.438h2.438v4.813h-2.438v.438q0 2.438-1.563 3.688-1.313 1.125-3.188.875V11.127q0-2.688 1.875-4.563t4.5-1.875q2.313 0 4.063 1.438t2.25 3.625h1.625v4.813h-1.5v1.375zM12 9.75v-.063h4.813v11.125q0 2.5-1.313 4.188T12 27.125q-2.375.438-4.875-.313v-4.375q1.5.625 2.813.5 2-.188 2.188-1.563l-.063.031-.25.156-.375.219-.531.219-.688.156h-.781l-.938-.156q-2.813-.75-2.813-4v-8.25H10.5v7.063q0 .688.75.688t.75-.688V9.749z'
	    ),
	    'magento' => array(
		'p' => 'M27.875 8v16l-4 2.25V10.312L14 4.562l-9.938 5.75.063 16-4-2.313v-16L14-.001zM16 26.25V10.312l3.938 2.25v16L14 32l-5.938-3.438v-16L12 10.312v16l2 1.125z'
	    ),
	    'medapps' => array(
		'p' => 'M7.375 14.875q.063-.125.156-.469t.156-.594l.125-.5.188-.375.25-.125q.188.063.344.438t.375.938.406.875q.125-.5.219-1.938t.25-2.438.406-1q.188 0 .375.406t.344 1.094.281 1.281.25 1.281.125.75q.313.125 1.063.219t1.375.156l.625.063q.063.125-.156.25t-.688.156-.781.031-.875.063q-.063.25-.188.781t-.25.719-.25.25q-.125 0-.188-.188t-.156-.531-.219-.719-.25-.844-.313-.844l-.563 4.063q-.188.563-.688-.625-.188-.375-.5-1.25l-.188-.563h-.75l-1.125-.063-1.125-.156v-.281zM14.25 28h-8.5q-1 0-1-1t1-1h8.5q1 0 1 1t-1 1zm-1.5 4h-5.5q-1 0-1-1t1-1h5.5q1 0 1 1t-1 1zm2.125-8.875q-.063.688-.625.844t-1.031-.188-.344-.969q.438-2.75.938-3.625.5-1 1.438-2.531t1.406-2.375.875-2.094.406-2.5q0-3#q#344-5.438T10 1.999t-5.594 2.25-2.344 5.438q0 1.25.406 2.5t.875 2.094 1.406 2.375 1.438 2.531q.5.938.938 3.688.125.563-.344.906t-1.031.188-.625-.781q-.438-2.438-.75-3.063-.563-1.063-1.5-2.563-1-1.688-1.469-2.563t-.938-2.344-.469-2.969q0-2.625 1.344-4.844t3.656-3.531 5-1.313q4.125 0 7.063 2.844T20 9.686q0 1.5-.469 2.969t-.938 2.344-1.469 2.563q-1 1.625-1.5 2.563-.313.625-.75 3z',
		'w' => .625,
		'vw' => 20
	    ),
	    'medium-m' => array(
		'p' => 'M4.5 8.875q0-.563-.438-1L1.249 4.5V4h8.75l6.813 14.875L22.75 4h8.375v.5l-2.438 2.313q-.313.25-.25.688v17q-.063.438.25.688l2.375 2.313v.5H19.187v-.5l2.438-2.375q.25-.25.25-.688v-13.75l-6.75 17.25h-.938l-7.938-17.25v11.563q-.063.75.438 1.313l3.188 3.875v.5h-9v-.5l3.188-3.875q.563-.563.438-1.313V8.877z'
	    ),
	    'medrt' => array(
		'p' => 'M7.125 16q0 5.688 3.438 9.938t8.625 5.125q-1.75.438-3.625.438-6.438 0-11-4.531T0 16.001 4.563 5.032t11-4.531q1.875 0 3.625.438-5.188.875-8.625 5.125t-3.438 9.938zm18.563 6.25q3.625-2.563 4.813-6.75t-.625-7.875q1.063 1 1.938 2.188 2.875 4.125 2.031 9.094t-4.938 7.906-9.031 2.063-7.875-5q-.813-1.188-1.313-2.5 2.875 2.938 7.125 3.219t7.875-2.344zM12 7q3.438-2.563 7.469-2.188t6.406 3.438q2.125 2.813 1.688 6.375t-3.063 6.25q.875-2.375.5-5.031T22.937 11q-2-2.625-5.063-3.625t-6.125-.188l.125-.063zm6.5 7H21q.5 0 .5.5v3q0 .5-.5.5h-2.5q-.5 0-.5.5V21q0 .5-.5.5h-3q-.5 0-.5-.5v-2.5q0-.5-.5-.5H11q-.5 0-.5-.5v-3q0-.5.5-.5h2.5q.5 0 .5-.5V11q0-.5.5-.5h3q.5 0 .5.5v2.5q0 .5.5.5z',
		'w' => 1.0625,
		'vw' => 34
	    ),
	    'microsoft' => array(
		'p' => 'M0 2h13.438v13.438H0V2zm14.563 0h13.438v13.438H14.563V2zM0 16.563h13.438v13.438H0V16.563zm14.563 0h13.438v13.438H14.563V16.563z'
	    ),
	    'mix' => array(
		'p' => 'M0 4h28v12.75q0 1.688-1.375 2.406t-2.75.031-1.375-2.438v-1.5q0-1.688-1.313-2.406t-2.656-.094T17 14.999v7.25q0 1.313-.938 2.031t-2.063.719-2.063-.719-.938-2.031V11.311q0-1.25-.781-2t-1.781-.813-1.875.563-1.063 1.813v14.938q0 1.688-1.375 2.375t-2.75-.031-1.375-2.344V3.999z'
	    ),
	    'mizuni' => array(
		'p' => '#d#-5 22v-14q0-1.063-.719-1.781T8 6t-1.781.719T5.5 8.5v17q2.063-2 5-3zm7.5-.625V8.5q0-1.063-.719-1.781T15.5 6t-1.781.719T13 8.5v13.375q1.25-.188 2.5-.188t2.5.188zm7.5 3.625v-17q0-1.063-.719-1.781T23 6t-1.781.719T20.5 8.5v14q2.938 1 5 3z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'monero' => array(
		'p' => 'M22 24h6.75q-1.313 2.25-3.344 3.938t-4.594 2.625-5.313.938q-4.125 0-7.656-2.031t-5.594-5.469h6.75v-8l6.5 6.563 6.5-6.563v8zM5.5 21H.812q-.813-2.438-.813-5 0-6.438 4.531-10.969T15.499.5t10.969 4.531T30.999 16q0 2.563-.813 5h-4.688V8l-10.063 9.938L5.497 8v13z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'napster' => array(
		'p' => 'M18.625 23.375Q17.25 24.688 15.5 25.25q-1.813-.625-3.125-1.875h6.25zm2.75-12.5Q18.75 9 15.5 9t-5.938 1.875Q7.624 9.25 5.249 8.625v10.063q0 2.813 1.125 5t2.938 3.344 4 1.688 4.375 0 4-1.656 2.938-3.344 1.125-5.031V8.626q-2.438.625-4.375 2.25zm-13-3.625q.625.313 1.25.688Q12.375 6.5 15.5 6.5t5.875 1.438l1.25-.75q-3-2.813-7.125-2.813T8.375 7.25zM2.75 5.813q1.563.063 3.125.5Q9.75 2 15.5 2t9.625 4.313q1.5-.438 3.125-.5v4.313Q31 11.876 31 15.095t-2.75 4.969v.063q-.438 3.625-2.375 6.25T21.25 30.19t-5.781 1.219-5.75-1.156-4.625-3.844-2.344-6.344Q0 18.315 0 15.096t2.75-4.969V5.814zM16.188 22q.563-2.5 1.656-3t4.719-.5q.438.063.688.063v.219l-.031.313-.063.344-.094.438-.188.406-.281.438-.406.406-.563.375q-.625.375-1.625.375zM7.75 18.563h.688q1.625-.063 2.313-.031t1.563.188 1.219.531.688 1.031.594 1.719q-2.25 0-3.875-.063-.938-.063-1.563-.438-.313-.188-.563-.375t-.406-.406-.281-.438-.188-.406-.094-.438-.063-.344-.031-.313v-.219zm10.563 7.687q.125.25.188.563-1.375.813-3 .813t-3-.813q.063-.375.25-.625l.375-.375q2.375.688 4.75 0 .25.125.438.438z',
		'w' => .966796875,
		'vw' => 31
	    ),
	    'node-js' => array(
		'p' => 'M14 31.75q-.625 0-1.188-.313l-3.875-2.313q-.625-.313-.125-.5.938-.313 1.75-.75.125-.125.313 0l2.938 1.75q.188.125.375 0l11.563-6.625q.125-.125.125-.375V9.311q0-.188-.188-.313l-11.5-6.625q-.188-.125-.375 0l-11.5 6.625q-.188.125-.188.313v13.313q0 .25.188.313l3.125 1.875q1.313.5 2.063.094t.75-1.281V10.5q0-.375.313-.375h1.438q.375 0 .375.375v13.125q0 1.688-.906 2.656t-2.531.969q-1.188 0-2.688-.75l-3-1.75Q.064 24.062.064 22.625V9.312q0-1.375 1#q#063L12.815.561q1.188-.688 2.375 0l11.563 6.688q1.25.688 1.25 2.063v13.313q0 1.438-1.25 2.125L15.19 31.438q-.563.313-1.188.313zm9.313-13.125q0 1.875-1.5 2.906t-4.25 1.031q-6.125 0-6.125-4.25 0-.313.375-.313h1.438q.313 0 .375.25.188 1.25.969 1.781t2.969.531q3.438 0 3.438-1.813 0-.313-.031-.469t-.281-.344-.656-.344-1.188-.281-1.906-.25q-1.688-#q#75-.5t-1.688-1.063-.625-2q0-1.75 1.375-2.719t3.875-.969q5.375 0 5.75 4 0 .188-.094.281t-.281.094h-1.5q-.25 0-.313-.25-.25-1.188-1.031-1.656t-2.531-.469q-3 0-3 1.625 0 .625.688.906t3.25.656q2.875.375 4.063 1.125t1.188 2.5z'
	    ),
	    'npm' => array(
		'p' => 'M18 18h-2v-4h2v4zm18-8v12H18v2h-8v-2H0V10h36zm-26 2H2v8h4v-6h2v6h2v-8zm10 0h-8v10h4v-2h4v-8zm14 0H22v8h4v-6h2v6h2v-6h2v6h2v-8z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'ns8' => array(
		'p' => 'M11.688 10h2.813l-3 10H7.938L4.75 13.375 2.812 20H-.001l3.063-10h3.063l3.438 7.125zM40 9.938q.188 1.188-1.094 2t-3.031 1.188q.875 1.438.969 3.125t-.781 3.438q-1.188 2.375-3.656 3.594t-4.781.656q-.938-.25-1.656-.75t-1.219-1.25-.688-1.688Q24 19.938 24 19.563q-.438.25-1.125.313-1.375.125-10.063.125l.688-2.5h7.938q.688 0 .875-.438t.25-.938q.063-.188-.031-.281t-.406-.094h-5.5q-1.5 0-1.906-.406t-.094-1.406q.625-2.25 1.063-2.938.563-.813 1.938-.938.688-.063 10-.063l-.625 2h-8.313q-.688 0-.875.438-.063.188-.188.75-.063.125 0 .25t.25.156.438.031h5.5q1.813 0 2.125 1.063 2.063-2.25 5.875-3v-.063q-.563-1.875 1.344-2.969t4.219-.656q2.375.375 2.625 1.938zM33.188 16.5q.25-1.438-.438-3-3.063.375-4.313 1.688-1.125 1.188-.844 2.5t1.719 1.563q1.25.188 2.406-.625t1.469-2.125zm1.312-5.187q1.5-.25 2.188-.625.625-.375.531-.875t-.844-.625q-1.313-.313-2 .438-.563.625.125 1.688z',
		'w' => 1.248046875,
		'vw' => 40
	    ),
	    'nutritionix' => array(
		'p' => 'M5.5.5h.313l.75.031 1.094.094 1.25.281 1.313.5 1.219.813 1 1.156.563 1.563.063 2.063q0-.063.063-.219t.281-.625.531-.813.844-.719 1.156-.563 1.563-.094 2 .531q0 .063-.063.219t-.25.656-.469.844-.719.844-1 .719-1.313.375T14.001 8q0-.063.063-.188t.219-.5.344-.688.531-.719.75-.688 1-.5 1.219-.281q-.125 0-.281-.031t-.75.063-1.156.344-1.375.969T13.002 7.5q-.063-.25-.156-.656t-.563-1.438-1.063-1.844-1.688-1.5-2.406-.813q.188.063.531.188t1.156.625 1.438 1.188 1.156 1.938.594 2.813q0 .188-1.656-.063T7.064 5.844 5.501.5zM25 20.25q0 4.938-2 8.25-4.125 3-10.5 3T2 28.5q-2-3.313-2-8.25Q0 16.125 2.5 12q4.125-3.063 10-3.063T22.5 12q2.5 4.125 2.5 8.25zm-17.5 6.5q0-.75-.5-1.25T5.75 25t-1.25.5-.5 1.25.5 1.25 1.25.5T7 28t.5-1.25zm0-4.156q0-.719-.5-1.219t-1.25-.5-1.25.5-.5 1.219.5 1.25 1.25.531T7 23.844t.5-1.25zm0-4.125q0-.719-.5-1.219t-1.25-.5-1.25.5-.5 1.219.5 1.25 1.25.531T7 19.719t.5-1.25zM12 26.75q0-.75-.5-1.25t-1.25-.5-1.25.5-.5 1.25T9 28t1.25.5 1.25-.5.5-1.25zm0-4.156q0-.719-.5-1.219t-1.25-.5-1.25.5-.5 1.219.5 1.25 1.25.531 1.25-.531.5-1.25zm0-4.125q0-.719-.5-1.219t-1.25-.5-1.25.5-.5 1.219.5 1.25 1.25.531 1.25-.531.5-1.25zm4.5 8.281q0-.75-.5-1.25t-1.25-.5-1.25.5-.5 1.25.5 1.25 1.25.5T16 28t.5-1.25zm0-4.156q0-.719-.5-1.219t-1.25-.5-1.25.5-.5 1.219.5 1.25 1.25.531 1.25-.531.5-1.25zm0-4.125q0-.719-.5-1.219t-1.25-.5-1.25.5-.5 1.219.5 1.25 1.25.531 1.25-.531.5-1.25zM21 26.75q0-.75-.5-1.25t-1.25-.5-1.25.5-.5 1.25T18 28t1.25.5 1.25-.5.5-1.25zm0-4.156q0-.719-.5-1.219t-1.25-.5-1.25.5-.5 1.219.5 1.25 1.25.531 1.25-.531.5-1.25zm0-4.125q0-.719-.5-1.219t-1.25-.5-1.25.5-.5 1.219.5 1.25 1.25.531 1.25-.531.5-1.25zM22.5 16q-.5-2.438-1-3.5-3.875-2-9-2t-9 2q-.438 1-1 3.5 4.938-.938 10-.938t10 .938z',
		'w' => .78125,
		'vw' => 25
	    ),
	    'page4' => array(
		'p' => 'M15.5 31.5q-6.438 0-10.969-4.531T0 16 4.531 5.031 15.5.5q1.938 0 3.813.5L2.625 24.5H15.5v7zm0-9H6.187L15.5 9.187V22.5zm6 2h6.938q-2.563 3.938-6.938 5.813V24.5zm3.563-8.625v1l-1.313-.5zm-1.25 3.375q.5 0 .5.688v.625h-1v-.5q0-.813.5-.813zM31 16q0 3.438-1.438 6.5h-8.063V1.687q2.063.875 3#r#344t3.031 3.281 1.969 4.063T31 16zm-8.5-7h4.313V6h-.875v2.063h-.875V6.188h-.875v1.875h-.813V6H22.5v3zm4.25 11.563h-1.625v-.688q0-1.563-1.313-1.563t-1.313 1.625V21.5h4.313v-.938h-.063zm0-6.438L22.5 16v.75l4.25 1.875v-1.063l-.875-.375v-1.625l.875-.375v-1.063zm-.25-4.312h-2.25v1.688h.875v-.75h.688q.438.75.094 1.469t-1.281.719q-1 0-1.281-.875t.344-1.5l-.75-.625q-.5.563-.563 1.5t.531 1.719 1.719.781q1.563 0 2.094-1.375t-.219-2.75z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'palfed' => array(
		'p' => 'M24.063 12.125q0 2.375-1.688 4.188t-3.5 1.813q-.875 0-1-.375.063-2.938.25-7.5 1.375-.5 2.656-.594t2.281.5 1 1.969zm-12.188 4.5v-.25q0-1.125 1#q#5t2.438-2.25q-.375 11.813-.063 15.125.063.938.531 1.406t.938.406.781-.438q.375-.375.375-1.188-#q#5-.188-6.25 2.875.688 5.813-2.156t2.938-6.469q0-3.25-2.469-4.406t-5.969-.094q-.125-.688-.719-.906t-1.156.219-.625 1.75q-2.75 1.438-4.531 3.688T9.376 16.5q0 .813.313 1.406t.844.969 1.156.375q1.5 0 1.875-1.313.375-1.188-.688-1.438-.125-.063-.25-.063-.25 0-.75.188zM.5 11.313q0-.688.25-1.156t.594-.688.688-.344T2.626 9h2.063q.25-.938.75-1.656t1.188-1.188 1.469-.844 1.5-.531 1.313-.281.969-.125l.375-.063h1.75V3.124q0-.5.344-.781t.656-.344h5.688q.5 0 .844.281t.406.594l.063.25v1.188h1.75q6.125 0 7.438 4.688h1.938q1.063 0 1.656.563t.656 1.188l.063.563q0 1.063-.594 1.656t-1.219.656h-2.438l-1.438 13.625q0 1.188-.688 1.875t-1.375.813l-.75.063h-18q-.813 0-1.375-.281t-.844-.688-.438-.813-.156-.719v-.25L4.752 13.626H2.877q-1.063 0-1.656-.563t-.656-1.188z',
		'w' => 1.123046875,
		'vw' => 36
	    ),
	    'patreon' => array(
		'p' => 'M32 12.188q0 4.75-3.375 8.125T20.5 23.688t-8.125-3.375T9 12.188t3.375-8.156T20.5.626t8.125 3.406T32 12.188zM0 31.375V.625h5.625v30.75H0z'
	    ),
	    'periscope' => array(
		'p' => 'M23.125 4q3.75 3.938 3.75 9.375 0 5.188-5.125 12.063-.438.563-1.094 1.344t-1.875 2.125-2.469 2.219-2.125.875q-1.5 0-3.688-1.969t-4.188-4.594q-5.188-6.813-5.188-12.063 0-5.5 3.844-9.438t9.219-3.938q5.188 0 8.938 4zm-8.937 26.875q.875 0 2.781-1.781t3.844-4.313 3.406-5.719 1.469-5.688q0-5-3.406-8.625t-8.094-3.625q-5 0-8.438 3.625t-3.438 8.625q0 2.5 1.469 5.688t3.438 5.719 3.969 4.313 3 1.781zm6.937-17.937q0 2.75-2.063 4.781t-4.875 2.031q-2.25 0-4.031-1.125t-2.594-2.781-.656-3.688 1.469-3.719q0 1.125.844 1.969t2 .844 1.969-.844.813-1.969q0-1.813-1.688-2.563 2.313-.563 4.375.281t3.25 2.688 1.188 4.094z'
	    ),
	    'phabricator' => array(
		'p' => 'M20.188 16.375l1.313 1.313-.5 1.25h-1.875l-.563.563v2l-1.25.5-1.375-1.5h-.813l-1.25 1.5-1.25-.5-.125-2.063-.563-.563q-1.813.063-1.875-.063l-.563-1.25 1.313-1.313v-.813l-1.313-1.313.5-1.25h1.875l.563-.563v-1.813l1.25-.5L15 11.31h.875l1.25-1.313 1.25.563.125 1.813.563.563q1.813 0 1.813.063l.625 1.25-1.313 1.313v.813zm-2.813-.562q0-.75-.625-1.313t-1.438-.531-1.344.625-.5 1.406.625 1.344 1.406.531q.563-.063 1-.344t.656-.719.219-1zM29.938 13.5q1.063 1 1.063 2.5t-1.063 2.5q-5.875 5.938-5.938 6-3.5 3.5-8.438 3.5t-8.438-3.438v.063Q4.561 22 1.061 18.5q-1.063-1-1.063-2.5t1.063-2.5q3.938-3.938 5.938-6 3.5-3.5 8.438-3.5t8.438 3.438v-.063zM8.781 22.719q2.781 2.781 6.719 2.813t6.75-2.781 2.813-6.75-2.813-6.719-6.75-2.781-6.719 2.781T6 16.001t2.781 6.719z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'phoenix-framework' => array(
		'p' => 'M13.313 21.5q-2.125.063-4.656-1.656t-3.344-4.969Q5 13.625 4.969 12t-.156-2.5q-.625-4.25-3.5-4.813-.563-.063-1.125 0H0l.125-.125q1.688-1.25 4.031-1.813t4.469-.375q2.188.188 3.938 1.25t3.031 2.531 2.5 2.938 2.844 2.625 3.5 1.469q.25.063.656.094t.531.031h.125q-.125.125-.906.469t-1.344.406q-1.813.375-3.25-.625-.188-.125-1.031-.844t-1.406-.844q-.75-.25-1.438.031t-.781 1.188.781 2.281 2.438 2.375q1.813 1.063 4.375 1.313t4.063-.375l.063-.063h.063q-1.125 1.375-3.094 2.219t-3.656.656q-1.375-#q#625-1.375t-2.438-2.688-2.063-2.063-2-.25-1.25 1.438q-.063.75.375 1.688.313.625.719 1.125t.781.813.781.531.75.344.594.188.438.094l.188.031q-.313.125-1.563.125zM4.688 4.063q.625.625 1.406.469t.844-.906q-1.25.063-2.313.313.063.063.063.125zM17 25.938q-1.938.063-4.063-1.031t-3.625-2.781q-.875-.938-1.188-1.438v-.063q2.125 1.313 3.438 1.688 2.313.688 4.5-.188.5-.188 1-.25t.844.031.563.188.281.219q-1.25.25-1.5.5-.625.563.438 1.063.5.25 2.688.406t3.375 1.156q.438.375.625.688-1.688-.5-2.5-.563-.875-.063-2.469.156t-2.406.219zm10.938-15.75q2.625-.813 4.188-.188 1.375.563 2 2.188.313.813.313 1.75-.063 0-.063.063v-.125q-.313-1.188-1.469-1.813T30.126 12q-1.688.563-3.594.563t-4-.906-3.469-2.656q-.125-.125-.063-.188 0-.063.188.063 1.625 1.25 3.75 1.688 2.438.438 5-.375zm6.437 7.375q-.688 0-1.281.5T32 19.219t-1.563 1.344-2.563 1q-1.625.375-2.813.313v-.063l.313-.094.719-.313.844-.656q.438-.375 1.438-1.375.813-.875 1.344-1.313t1.563-.844 2.219-.281q1.188.063 2.25.75v.063q-.563-.188-1.375-.188zm-.812-1.5q-1.25-.25-2.313-.25t-1.938.5q-.063.063-.5.313t-.563.344-.531.281-.688.25-.719.188-.875.188q-2.5.313-4.125-.5l-.063-.063q1.063.188 1.844.125t1.594-.5q.25-.125.813-.469t.844-.5.781-.406 1-.375 1-.188q2.563-.375 4.438 1.063zm-16.75-10l-.188-.125q2.063 0 3.375.5.438.188.875.469t.719.5.75.563.781.531q.938.625 2.25.5h.281l.313-.031.219-.031h.125l-.125.063q-.75.375-1.625.438-2.25.25-4.563-.938-1.75-.938-3#q#438zM40 21q-.25.188-.938.344t-1.75-.031q-.313-.125-.625-.344t-.688-.594-.625-.563q-.625-.438-1.75-.563l.063-.063q1.438-.875 2.938-.375.188.063.375.156t.313.188.281.25l.906.906q.25.188.531.344t.438.188.344.063l.188.031V21zm-13.25 8.563q.063.063.063.125Q25 29.5 23.875 28.25q-1.188-1.375-3-1.813l.063-.063q1.5.063 2.438.25.313.125.594.25t.531.281.406.313.344.406.281.344.25.344.156.313q.313.375.813.688z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'playstation' => array(
		'p' => 'M35.688 23.25q-.188.25-.531.5t-.656.438-.594.313-.469.188l-.188.125-12.813 4.563v-3.375l9.438-3.375q.813-.25.906-.625t-.531-.563q-1.563-.563-3.5.188l-6.313 2.188v-3.5q2.313-.813 4.75-1.063 4.313-.5 8.125.938 1.313.438 2 1T36 22.284t-.313.969zM21.625 17.5V8.812q0-1.938-1.125-2.25-.5-.188-.844.25t-.344 1.25V29.75l-5.875-1.813V1.999q3.375.625 8.125 2.188Q25.25 5.5 26.718 7.375t1.469 5.438q0 3.438-1.906 4.75t-4.656-.063zM2.688 25.625q-2-.563-2.531-1.656t.531-1.781q.5-.375 1.313-.75t1.375-.563l.563-.25 8.375-2.938v3.375L6.251 23.25q-.813.25-.906.625t.531.563q1.625.563 3.563-.188l2.875-1.063v3.063q-5 .938-9.625-.625z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'pushed' => array(
		'p' => 'M25.438 7q1.063.063 1.438 1.031t-.375 1.781L11.813 24.25l-2.188 5.063q-.5.813-1.594.688t-1.406-1.125L.062 7.126q-.188-.875.219-1.531t1.094-.781l17-2.813q.875-.125 1.563.594t.188 1.781l-.875 2.063zm-6.813-3.625L6.812 5.313l11.063 1 1.063-2.5q.125-.25 0-.375t-.313-.063zM1.438 6.75L11.313 22l6.063-14.375L1.813 6.187q-.25-.063-.406.125t.031.438zM8.5 28.5q.063-.125.188-.406t.469-1.031.594-1.344.531-1.25.406-.906L2.75 11.25l5.188 17.188q.063.188.25.219t.313-.156zM25.563 8.875q.375-.375-.188-.563l-6.625-.563-5.625 13.313z',
		'w' => .84375,
		'vw' => 27
	    ),
	    'python' => array(
		'p' => 'M27.5 12.5q.938 3.938 0 6.813-.563 1.75-1.281 2.563t-2.094.813h-10v.875h6.688v2.563q0 2.375-3.313 3.375-3.375.938-6.688 0-3.375-1-3.375-3.375v-6.375q0-1.375 1-2.375t2.375-1H17.5q1.625 0 2.875-1.281t1.25-2.969v-3h2.5q2.5 0 3.375 3.375zm-9.594 12.75q-.531 0-.906.375t-.375.906.375.906.875.375q.375 0 .656-.188t.438-.469.156-.656q0-.5-.344-.875t-.875-.375zM10.5 15.5q-1.125 0-2.094.563t-1.531 1.531-.563 2.031v3.063H3.999q-1.375 0-2.25-.906t-1.25-2.469q-.875-3.375 0-6.813.375-1.563 1.5-2.469t2.625-.906h9.188v-.813H7.124V5.749q0-.625.094-1.063t.313-.844.563-.688.938-.5 1.469-.406q3.188-.563 6.688 0 1.375.25 2.344 1.219t.969 2.281v6.375q0 1.375-.969 2.375t-2.344 1h-6.688zm-.437-8.875q.375 0 .656-.188t.438-.469.156-.625-.156-.656-.438-.469-.656-.156q-.5 0-.875.375t-.375.875q0 .25.094.5t.281.406.406.281.469.125z'
	    ),
	    'red-river' => array(
		'p' => 'M22.063 2q2.438 0 4.188 1.75t1.75 4.188v16.125q0 2.438-1.75 4.188t-4.188 1.75H5.938q-2.438 0-4.188-1.75T0 24.063V7.938Q0 5.5 1.75 3.75T5.938 2h16.125zm-13 10.563Q9 12 9.501 11.5t1.063-.438h3.5q1.25 0 2.156-.906T17.126 8H7.501q-.625 0-1.063.438T6 9.501v9.625q1.25 0 2.156-.906t.906-2.156v-3.5zm11 4.5q1.25 0 2.156-.906t.906-2.156H13.5q-.625 0-1.063.438t-.438 1.063v9.625q1.25 0 2.156-.906t.906-2.156v-3.5q-.063-.563.438-1.063t1.063-.438h3.5z'
	    ),
	    'wpressr' => array(
		'p' => '#d#10.688 9.938q.25-.563-.313-.563h-8.188q-.375 0-.563.375-.188.5-1.063 2.438-.25.563.313.563h4.75q.563 0 .375.5-.125.313-.625.313h-4.938q-.5 0-.688.438-1.875 4.375-2 4.563-.063.188-.313.25t-.375-.094 0-.531q.063-.188 1.563-3.5.25-.563-.375-.563h-2.813q-.313 0-.438.25-1.813 4.125-1.875 4.25-.188.313-.531.188t-.156-.563q.5-1.125 1.063-2.438 1.75-3.938 2.563-5.75.125-.25 0-.469t-.438-.219H8.435q-.375 0-.5.375-.5 1.125-2.438 5.5-1.188 2.688-1.625 3.688-.125.313.063.563.125.188.906 1.031t1.219 1.281q.188.25.5.25h8.563q.375 0 .5-.313 1.938-4.313 1.938-4.438.188-.438.688-.438h4.313q.563 0 .813-.5 1.063-2.375 2.813-6.438z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'replyd' => array(
		'p' => 'M20 30H8q-3.313 0-5.656-2.344T0 22V10q0-3.313 2.344-5.656T8 2h12q3.313 0 5.656 2.344T28 10v12q0 3.313-2.344 5.656T20 30zm-7.937-12.937q-.563-.188-1-.188-.688 0-1.188.375-.5.313-.813 1h-.063l-.25-1.188h-1.75v8.688h2.25v-5.625q.125-.5.531-.813t1.031-.313q.438 0 1 .188zm7.25 6.5q-.313.188-.875.438-.563.188-1.313.188-1.125 0-1.625-.563t-.563-1.625h5.188q.125-.438.125-.875.063-.375.063-.75 0-1-.313-1.688t-.75-1.125q-.5-.375-1.125-.563t-1.25-.188q-2 0-3.094 1.156t-1.094 3.469q0 2.125.969 3.344T16.75 26q1 0 1.875-.313.938-.25 1.438-.688zm-1.407-4.438q.344.5.281 1.438h-3.188q.063-.875.5-1.406t1.313-.531q.75 0 1.094.5zm5.032.188q.375.375 1 .375t1.031-.375.406-1-.406-.969T23.938 17t-1 .344-.375.969.375 1zm0 6.25q.375.375 1 .375t1.031-.375.406-.969-.406-.938-1.031-.344-1 .344-.375.938.375.969z'
	    ),
	    'resolving' => array(
		'p' => 'M17.563 17.375L5.188 20.938l-1.75-6.125 11.75-3.375q2.5-.688 3.313-.469t1.125 1.281l.688 2.438q.313 1-.188 1.563t-2.563 1.125zM15.5.5q4.25 0 7#r#063t5.625 5.656T31.001 16q0 6.375-4.563 10.938T15.5 31.501q-4.313 0-7.938-2.188l-1.438-5 17.938 2.313 3-.813-.625-2.125L12.687 22l5.813-1.688q2.25-.625 3.813-2.063 2#q#063 1.438-4.625l-.625-2.313q-.875-3-3.875-3.5-2.125-.25-4.938.563l-13.875 4q1.25-5.188 5.438-8.531T15.501.499zM2.375 24.313Q0 20.438 0 16.063z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'rocketchat' => array(
		'p' => 'M30.75 6.625Q34.438 9 35.781 12.5t0 7.031-5.031 5.844q-3.5 2.313-8.156 3.063t-8.531-.063q-2.125 2-4.5 2.906T5.188 32t-3.25-.531T0 30.75q.188-.188.5-.469t1.063-1.156 1.281-1.719.875-1.969.156-2.063q-1.188-1.188-2-2.781T.719 17.03t.438-4.188 2.719-4.219q.313-1.5-.656-3.344T1.126 2.373L.001 1.248q.75-.375 2-.719T5.22-.002t4.344.719 4.5 2.906q3.875-.813 8.531-.063t8.156 3.063zm-12.125 18.75q6 0 10.25-2.75T33.125 16q0-2.563-1.969-4.719t-5.281-3.406-7.25-1.25q-6.063 0-10.281 2.75T4.125 16q0 3.375 3.25 5.938.875 2.75-1 6.25l-.063.125-.125.188q1.75-.125 3.25-.938 1.313-.688 2.313-1.688l1.25-1.25q2.75.75 5.625.75zm-7-7.125q-.563 0-1.063-.281t-.813-.781-.313-1.063q0-1.375 1.063-1.938t2.156-.031T13.749 16v.063q0 .875-.625 1.531t-1.5.656zm4.656-2.156q-.031-1.344 1.063-1.906t2.188-.031 1.094 1.844v.063q0 1.375-1.063 1.938t-2.156 0-1.125-1.906zm9.063 2.156q-.594 0-1.094-.281t-.781-.781-.281-1.063q-.063-1.375 1.031-1.938t2.188-.031T27.501 16v.063q0 .563-.281 1.063t-.781.813-1.094.313z',
		'w' => 1.13671875,
		'vw' => 36
	    ),
	    'rockrms' => array(
		'p' => '#d#9.813 26.25L19 19.312l4.625-.063q1.375.063 2-1.188t-.25-2.313L15.5 4.185q-.625-.813-1.688-.813t-1.688.813l-9.25 10.813h5.625l5.313-6.188 5.25 6.188h-4.688q-1.375 0-1.938 1.281t.25 2.219l7 8.25h5.625z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'schlix' => array(
		'p' => 'M21.875 9.875L18.5 7l4.625-2.438L28 7.312zM12 7.625l2.875-1.75L17 8l-3.438 1.875zm-4.062.438l2-1.375 1.063 1.75-2.313 1.438zm-1.438 5.5l-.563-2.188L7.75 10.25l.875 2.188zm-1.375-5.25l1.5-1.125.563 1.5L5.5 9.813zm-1.437 4.562l-.25-1.75 1.438-.938.375 1.75zM1.75 13.938l1.313-.813.188 2.125-1.375.75zM.063 16.75l1.25-.625V18.5L0 19.063zm3.687 3.688L2 21.001l-.063-2.938 1.563-.688zm2.438-4l-1.938.813-.313-2.563 1.688-.875zm1.5 7.125l-2.563.375-.5-4 2.188-.625zm1.812-8.75l1.313 3.563-2.875.875-.875-3.375zm5.313 14.437L10.375 29l-1.5-6 3.438-.5zM9.5 11.75l2.688-1.375 1.75 2.813-3.188 1.375zm2.625 5.938l3.813-1.188 3.313 5.438-5 .688zm3.188-5.375l4.188-1.813 4.125 4.125-5.563 1.625z'
	    ),
	    'searchengin' => array(
		'p' => 'M13.813 8.125L9.563 21.25v-8.188l-3.375 1.563L9.563 2.687v7.188zm-5.25-6l-.063.25-.938 3.313q-1.938.75-3.125 2.469t-1.188 3.844q0 2.438 1.469 4.281t3.719 2.281v3.375q-3.625-.5-6.031-3.344T0 12t2.469-6.563 6.094-3.313zm19.5 27.938q-.938.938-1.813.625l-3.75-2.75q-.5-.375-.875-.719T21 26.625t-.438-.563-.281-.5-.25-.594-.219-.594q-1.063-2.375-3.625-3.25l-.563-.938q-2.375 1.625-5.125 1.813l.125-.438 1-3.063q2.25-.563 3.656-2.375t1.406-4.125q0-2.625-1.656-4.563t-4.344-2.188v-3.25q1.938.125 3.656.969t2.969 2.156 1.969 3.094.719 3.781q0 3-1.813 5.625l.938.625q.875 2.5 3.25 3.563.188.063.719.281t.688.344.563.375.781.656.813 1.031l2.75 3.75q.313.875-.625 1.813zm-.625-1.125q0-.5-.5-.5t-.5.5.5.5.5-.5z',
		'w' => .896484375,
		'vw' => 29
	    ),
	    'servicestack' => array(
		'p' => 'M5.5 13.5q2.813.375 6.75 2.156t7.656 5.188T24.5 28H0q3.125-.25 5.531-2.656t2.594-5.563T5.5 13.5zm2-9.5q2.563.375 6.063 2.313t7.094 4.938 6.531 7.5 3.813 9.25h-6q-.563-2.813-2.219-5.438t-3.813-4.594-4.313-3.375-4.281-2.219Q10.5 7.312 7.5 4z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'sistrix' => array(
		'p' => 'M28 28.063l-1.875 1.938L17 20.751q-2.875 2.375-6.625 2.375-4.25 0-7.313-3.094t-3.063-7.469 3.063-7.469T10.406 2t7.344 3.094 3.063 7.469q0 3.438-2 6.188zm-17.562-7.375q3.313 0 5.656-2.375t2.344-5.75-2.375-5.75-5.656-2.375-5.656 2.375-2.375 5.75 2.375 5.75 5.688 2.375z'
	    ),
	    'slack-hash' => array(
		'p' => 'M27.875 16.875q.313.938-.125 1.781t-1.313 1.094l-2.813.938 1 2.938q.25.938-.156 1.75t-1.281 1.125q-1 .313-1.813-.156t-1.063-1.281l-1-2.938-5.875 2 1 2.875q.188.625.063 1.219t-.531 1.031-.969.625q-.938.313-1.75-.125t-1.125-1.25l-1-3q-3.25 1.125-3.563 1.063-.688 0-1.281-.438t-.844-1.063q-.125-.438-.094-.906t.219-.844.531-.688.781-.438l2.813-.938-1.875-5.625q-3.313 1.063-3.625 1-.688 0-1.281-.406t-.781-1.094q-.188-.625-.063-1.188t.5-1.031 1-.656l2.813-.938-1-2.938q-.125-.438-.094-.906t.219-.844.531-.688.781-.438q.938-.313 1.781.125t1.094 1.313l1 2.938 5.813-1.938-.938-2.938q-.313-.938.125-1.75t1.313-1.125q.438-.188.875-.125t.844.25.719.531.438.781l1 2.938 2.813-.938q.875-.313 1.719.094t1.125 1.313-.125 1.75-1.281 1.156l-2.875.938 1.938 5.625 2.813-.938q.625-.188 1.188-.094t1.031.5.656.969zm-15.875 3l5.875-2-1.938-5.625-5.813 1.938z'
	    ),
	    'speakap' => array(
		'p' => 'M3.438 24.5Q-.312 20.375 0 14.781t4.469-9.313 9.719-3.438 9.281 4.406 3.438 9.688-4.469 9.313q-.625.563 1.438 1.813 1.375.875 1.438 1.188 0 .188-.25.25-2.75 1.188-6.563 1.375t-8.094-1.188T3.438 24.5zM16.75 11.25l2.438-2.563q-1.813-1.625-4.75-1.688-2.563-.063-4.281 1.281t-1.781 3.719q-.063 2.25 1.813 3.438.813.438 2.281.906t2.313.969.781 1.375q0 .875-.781 1.25t-1.594.313q-1.938 0-3-1.5l-2.5 2.625q2.125 2.063 5.25 2.063.375.063.875.031t1.5-.313 1.75-.75 1.344-1.531.594-2.5q.063-2.375-1.75-3.5-.813-.5-2.25-.938t-2.25-.906-.813-1.281q0-.625.563-1.031t1-.469.813-.063q1.625 0 2.438 1.063z',
		'w' => .83984375,
		'vw' => 27
	    ),
	    'staylinked' => array(
		'p' => 'M23.938 18.25l2.75 2.625q.438.375-.063.75L14.25 31.875q-.25.188-.531.219T13.313 32l-.125-.063L.125 19.687q-.375-.438.125-.813l2.813-2.125q.5-.375.875 0l9.5 9.25q.438.375.875 0l5.813-4.625q.5-.375.063-.75l-5.25-5.125q-.375-.375-.844 0t-.906 0l-4.25-4.063q-.375-.375.063-.75l3.625-2.75q.438-.313.813.063l10.625 10.438zm3.375-5.187q.438.375-.063.75l-2#r#25q-.5.375-.875 0L13.499 6.125q-.375-.438-.875-.063l-5.75 4.5q-.438.375-.063.75l5.938 5.75q.375.375.875 0t.875 0l3.563 3.438q.438.375-.063.75l-.438.375-3.125 2.438q-.5.375-.938 0L2.81 13.75.122 11.125q-.375-.375.125-.75L13.122.25q.563-.438 1.063-.125z',
		'w' => .857421875,
		'vw' => 27
	    ),
	    'steam-symbol' => array(
		'p' => 'M24.75 11.094q0 1.594-1.125 2.688t-2.719 1.094-2.688-1.094-1.094-2.688 1.094-2.719 2.688-1.125 2.719 1.125 1.125 2.719zm3.25.031q0 2.938-2.094 5.031t-5.031 2.094l-6.813 4.938q-.188 2.063-1.719 3.438t-3.594 1.375q-.875 0-1.75-.313t-1.563-.875-1.156-1.344-.656-1.656l-3.625-1.438v-6.688l6.063 2.438q1.438-.875 3.25-.75l4.438-6.313q.063-2.938 2.125-5t5-2.063q1.938 0 3.594.938t2.594 2.594.938 3.594zM12.688 22.688q0-1.625-1.125-2.781T8.75 18.751q-.375 0-.813.125l1.625.625q1.188.5 1.688 1.688t.031 2.375-1.656 1.688-2.375 0q-.25-.063-.906-.344t-1.031-.406q1.125 2.125 3.438 2.125 1.688 0 2.813-1.156t1.125-2.781zm12.937-11.594q0-1.969-1.375-3.344t-3.375-1.375q-1.25 0-2.375.625t-1.75 1.719-.625 2.406q0 1.938 1.406 3.344t3.344 1.406q2 0 3.375-1.406t1.375-3.375z'
	    ),
	    'sticker-mule' => array(
		'p' => 'M34.75 7.625q.25.75.5 1.313l.375.844.219.5.125.313.031.156v.188q0 .25-.438 1.063-.25.438-.438.5-.063 0-.875.125-.688.125-.938-.563v-.281l-.031-.281-.188-.375-.469-.5q-.313-.313-.656-.469t-.75-.313-.594-.281-.313-.156-.25.031-.188.125-.188.219-.188.281q-.5.563-1.063 1.375t-1.156 1.594-1.031 1.344q-1.563 2-2.125 3-.125.188-.25.625t-.25.813-.125.438q-.188.563-.438 1.781t-.625 2.469q-.063.375-.281 1.125t-.219.875q-.188.5-.25 1.813t.188 1.938q.063.125.344.25t.406.25l.125.281.281.594.156.375q0 .188-.156.25t-.344.094l-.188.031q-.188.125-.25.219t-.094.156-.094.125q-.25.125-1.156.125t-1.094-.188q-.313-.188-.125-.938.125-.313.063-.469t-.125-.156h-.25l-.313-.063q-.188-.125-.25-.625l-.125-.25q-.063-.375.219-1.5t.281-1.188q.188-.875.125-1.813t0-1.125q.063-.25.125-.406t.063-.188.031-.188.031-.375v-.719q-.063-.688 0-1.313t.094-.781-.031-.344q-.25 0-1.594.156t-2.5#q#969-.219q-1.25-.25-2.156-.688t-1.375-.813-.531-.438q-.5-.188-1-.031t-.688.469q-.063.063-.594 1.188t-1.156 2.469-.75 1.844q-.438 1.375.25 4.188l.094.219.25.531.281.438q.063.063.156.094t.188.094.156.125q.188.188.563 1 .313.5-.063.625-.313.188-.938.188-.063 0-.094.125t-.094.188q-.125.125-.75.219t-1.063-.094q-.375-.125-.438-.313 0-.063.031-.375t-.094-.375q-.063-.063-.313-.125t-.438-.219-.313-.406q-.125-.375-.125-3.125 0-1.063-.563-2.875-.125-.563 0-1 .063-.063.094-.125l.063-.125.094-.25.063-.313q-.063-.063-.188-.063t-.125-.063q-.313-2.25-.406-3.563t-.063-1.563-.031-1q-.063-.313-.219-1.219t-.219-1.438 0-1.406q.313-1.375 1.5-2.375T3.522 7.78t2.719-.281 5.25.875q.375.125 1.25.313t2.656.063 3.031-.938q.563-.375 1.313-.625t.875-.375q.125-.063 1.063-.844t2.313-1#r#125-1.406q1-.625 1.906-.938t1.406-.313.906.063.469.063q.125-.063.531-.844t.531-.781.156.344 0 .688.031.594q.063.313.375.313l.688-.313q.188-.125.438-.406t.469-.469.344-.188q.313.188.031.719t-.75 1.313-.469.906l.313.563q.188.375.375 1.25.188.688.281.969t.156.344.156.313.281.688z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'studiovinari' => array(
		'p' => 'M30 11.75l.25 1.75v1.75L28.687 18l-2.438 4.875-3.5 4.25-5 2.375-1.063 1.5-.5.75-.625.25q1.125-4 1.25-4l1.25.063 4#q#438-5.813 1.688-3.5 2.25-1.375 1.75-.438.125 1.313-4.625.438-.313 1.25.813 5.563-2.875 3.563-3.188.875-4.25-7.813 1.438.938-1.125-10.813-3.375 5.125-.625L1.187 5.625 8.375 6.75 2 0l15.813 7.938-1.938-2.375 7.75 4.625L14.687 4l1.125 2.375-3.063-1.125L9.874 0l12.188 7.625-2.688-3.5 6.75 6.063.75-.563-1.313-1.063.25-2.313 2.375-.688 1.813 1.563.75.25-.438.375.5.75-.813.5-.625 1.25z',
		'w' => .998046875
	    ),
	    'supple' => array(
		'p' => 'M40 16.375q0 2-2.031 3.688t-5.531 2.656-7.688.969q-2.188 0-4.438-.313h1.5q6.313 0 10.75-2.313T37 15.437q0-2.688-3.188-4.875 2.875 1 4.531 2.531t1.656 3.281zM3 14.25Q3 17 6.188 19.125q-2.875-1-4.531-2.531T.001 13.313q0-3 4.438-5.156t10.75-2.156q2.313 0 4.438.313-.813-.063-1.438-.063-6.313.063-10.75 2.375t-4.438 5.625zm3.75 2.5l.563-.688q.563.625 1.25.625.813 0 .813-.625 0-.375-.625-.656t-1.25-.719-.625-1.125q0-.625.5-1.063t1.25-.438q.563 0 1.063.25t.5.813v.5h-.875v-.25q0-.438-.688-.438-.813 0-.813.563 0 .313.406.531t.875.406.875.563.406 1q0 .688-.5 1.125t-1.313.438q-.5 0-.969-.219t-.656-.406zm7.563-4.625h.938v3.438q0 .875-.563 1.438t-1.5.563-1.531-.563-.594-1.438v-3.438h1v3.438q0 1.063 1.125 1.063t1.125-1.063v-3.438zm2.125 5.375V13h-.5v-.875h2.438q.75 0 1.25.5t.5 1.25-.5 1.25-1.25.5h-.938V17.5h-1zm1-2.687h.813q.875 0 .875-.938 0-.875-.875-.875h-.813v1.813zM21 17.5V13h-.5v-.875h2.438q.75 0 1.219.5t.469 1.25-.469 1.25-1.219.5H22V17.5h-1zm1-2.687h.75q.875 0 .875-.938 0-.875-.875-.875H22v1.813zm3.563 2.125v-3.813q0-.125-.188-.125h-.313v-.875H26q.563 0 .563.5V16.5q0 .125.125.125h1.188q.125 0 .125-.125v-.375h.938v.813q0 .563-.563.563h-2.313q-.5 0-.5-.563zm3.937 0V13H29v-.875h3.25q.5 0 .5.5v.813h-.875v-.313q0-.125-.188-.125h-1.188v1.375h1.75v.813h-1.75v1.313q0 .125.188.125h1.188q.188 0 .188-.125v-.375h.875v.813q0 .563-.5.563H30q-.5 0-.5-.563zm3.688-4.75H33v-.063h.438v.063h-.125v.375h-.125v-.375zm.375-.063h.125l.125.313.125-.313h.188v.438h-.125v-.313l-.125.313h-.125l-.125-.313v.313h-.063v-.438z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'telegram-plane' => array(
		'p' => 'M27.938 6.188l-4.25 19.875q-.5 2.125-2.313 1.125l-6.438-4.75-3.125 3q-.625.625-1.313.625l.5-6.563L22.937 8.75q.438-.438 0-.5-.375-.125-.813.188l-14.75 9.313-6.375-2q-1.063-.313-1-.938t1.313-1.063l24.813-9.625q.938-.313 1.5.219t.313 1.844z',
		'w' => .873046875,
		'vw' => 28
	    ),
	    'uber' => array(
		'p' => 'M25.875 2q.875 0 1.5.625t.625 1.5v23.75q0 .875-.625 1.5t-1.5.625H2.125q-.875 0-1.5-.625T0 27.875V4.125q0-.875.625-1.5T2.125 2h23.75zm-11 22.438q3.5-.375 5.719-3.094t1.844-6.219q-.313-3.25-2.75-5.438T14 7.499 8.312 9.687t-2.75 5.438h5.875v-1.25q0-.438.438-.438h4.25q.438 0 .438.438v4.25q0 .438-.438.438h-4.25q-.438 0-.438-.438v-1.25H5.562q.375 3.5 3.094 5.719t6.219 1.844z',
		'w' => .873046875,
		'vw' => 28
	    ),
	    'uikit' => array(
		'p' => 'M27.75 8v16l-14.125 8L0 24V10.625l5.5 2.813v7.313l8.313 4.688 8.5-4.688v-9.438L16 7.688l5.438-3.313zm-8.437-4.937l-5.5 3.313-5.375-2.938L14.001 0z',
		'w' => .865234375,
		'vw' => 28
	    ),
	    'uniregistry' => array(
		'p' => 'M12 30q-3.688 0-6.688-2h13.375q-3 2-6.688 2zM6.438 17.938v.438H0v-1.25h6.438v.813zm1.25 3.562q.875 1 2.063 1.563H1.126q-.375-.75-.625-1.563h7.188zm-1.063-2.187q.188.75.563 1.438H.313q-.125-.688-.25-1.438h6.563zM6.438 15v1.063H0V15h6.438zm0-10.812v.313H0v-.313h6.438zm0-2.188v.125H0V2h6.438zm0 4.313v.5H0v-.5h6.438zm0 6.5v.938H0v-.938h6.438zm0-4.313v.625H0V8.5h6.438zm0 2.188v.75H0v-.75h6.438zM16.813 20.75q.375-.688.563-1.438h6.563q-.063.75-.25 1.438h-6.875zm.75-11.625V8.5h6.438v.625h-6.438zm0 2.313v-.75h6.438v.75h-6.438zm0-4.625v-.5h6.438v.5h-6.438zm0-4.813h6.438v.125h-6.438V2zM4.875 27.688q-1.25-.938-2.063-1.875h18.313q-.875 1-2 1.875H4.875zM17.563 4.5v-.313h6.438V4.5h-6.438zm0 9.25v-.938h6.438v.938h-6.438zM2.438 25.375q-.25-.313-1-1.75h21.188q-.5.938-1.125 1.75H2.438zm11.812-2.312q1.188-.563 2-1.563h7.25q-.438 1.25-.563 1.563h-8.688zm3.313-5.125v-.813h6.438v1.25h-6.438v-.438zm0-1.875V15h6.438v1.063h-6.438z',
		'w' => .75,
		'vw' => 24
	    ),
	    'untappd' => array(
		'p' => 'M25.063 3.125q-1.125 2.313-2.094 4.156t-1.5 2.813-.938 1.688-.563 1.031-.25.563-.156.563l-.313 2.063q-.188 1.125-.875 2.063l-9.25 13q-.813 1.063-2.125.938-1.875-.25-3.5-1.438T1.061 27.69q-.563-1.188#q#25l9.313-13q.688-.938 1.688-1.5l1.813-.938q.375-.188.563-.375t.688-.719 1.156-1.281 2.313-2.469 3.781-3.844q.125-.5.25-.5.313-.188.375-.313l-.063-.25q0-.25.25-.25.688 0 1.563.625.938.625 1.125 1.313.063.188-.125.25l-.313.063q-.188.063-.125.5 0 .125-.438.375zM14.375 2.25q-.438-.188-.438-.313.25-.688 1.125-1.313t1.625-.625q.188 0 .125.5 0 .188.438.313.125 0 .188.5l1.625 1.625q.125.125 0 .313-1.25 1.25-2.563 2.625-.125.125-.188 0l-1.375-2.75q-.063-.063-.125-.063-.313-.188-.313-.313.063-.438-.125-.5zM38.75 25.438q.75 1.063.188 2.25-.5 1.125-1.438 2.063t-2.094 1.5-2.406.75q-1.313.125-2.063-.938l-9.313-13q-.688-.938-.875-2.063-.188-1 0-1.875 0-.188.063-.313t.125-.313.281-.563.5-.875.844-1.563 1.25-2.313q.063-.188.188 0 .188.188.438.469t.375.406l.531.531.25.188.344.219 1.563.781.563.344.531.406.406.375.438.531z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'ussunnah' => array(
		'p' => 'M9.813 17.813l.313.938h-.5q-.125-.438-.25-.625-.125-.375 0-.625l.25-.313q0 .25.188.625zM28.375 19q-.188 1.25-.625 2.5l2.688 1.438-2.813-1.188q-.5 1.25-1.25 2.313l2.125 1.938-2.313-1.688q-.75 1.125-1.75 2.063L26 28.501l-1.813-2q-1 .938-2.25 1.625l1 2.313-1#q#25q-1.25.688-2.625 1l.438 2.438-.688-2.375q-1.375.375-2.75.375l-.125 2.375-.125-2.375q-1.375-.063-2.75-.375l-.688 2.375.438-2.438q-1.375-.313-2.625-.938l-1.188 2.188.938-2.313q-1.188-.688-2.25-1.563l-1.75 1.938 1.563-2.125q-1-.938-1.813-2l-2.25 1.625 2.125-1.875q-.75-1.125-1.25-2.375l-2.813 1.188 2.688-1.438q-.5-1.25-.688-2.5l-3.188.563 3.188-.875q-.125-.813-.125-1.625v-.875l-3.438-.188 3.5-.188q.125-1.188.5-2.375l-3.625-1 3.688.625q.375-1.063.938-2.125L1.561 9.063l3.688 1.563q.563-1 1.313-1.875l-3.063-2.75 3.375 2.438q.75-.813 1.625-1.438l-2.5-3.5 2.875 3.25q.875-.625 1.875-1.125L9.061 1.563l2.125 3.938q1-.438 2-.688l-.75-4.438 1.188 4.375q1.063-.188 2.125-.25l.25-4.5.25 4.5q1.063 0 2.063.25l1.25-4.375-.75 4.438q1.063.25 2 .688l2.125-3.938-1.688 4.063q.938.5 1.875 1.125l2.875-3.25-2.5 3.5q.875.688 1.625 1.438l3.375-2.438-3.063 2.75q.75.875 1.313 1.875l3.688-1.563-3.5 1.875q.563 1.063.938 2.188l3.75-.688-3.625 1q.375 1.188.5 2.375l3.5.188-3.5.188v.875q0 .75-.063 1.625l3.188.875zM27 17.063q0-4.563-3.219-7.813T16 6 8.187 9.25t-3.25 7.813 3.25 7.781T16 28.063t7.781-3.219T27 17.063zm-1.5 0q0 3.938-2.781 6.75t-6.75 2.813-6.75-2.813-2.781-6.75 2.781-6.75 6.75-2.813 6.75 2#r#781 6.75zm-13.312-2q0 .188.25.313.313.188.5.5.25-.5.25-.688T13 14.75t-.188-.5q-.625.625-.625.813zm-2.563-1.188q0 .188.25.313.313.188.5.5.25-.5.25-.688t-.188-.438-.188-.5q-.625.625-.625.813zm-1.187 0q0 .188.25.313.313.188.5.5.25-.5.25-.688t-.188-.438-.188-.5q-.625.688-.625.813zm12.812 5.5q-.5-.188-.5-1v-7q-.813 1.188-1.125 1.188.563 1.313.563 1.75v4q0 .438-.313.438H18.75q-.125-.313-.938-2.563-.125.125-.688.875.25.188.375.375.375 1.063.438 1.313h-.563q-.438-1.188-.75-2-.063.188-.625.875.188.188.313.375 0 .063.094.313t.156.375h-.563q-.063-.125-.25-.656t-.25-.719q-.125.125-.688.875.25.188.313.375 0 .063.031.094l.031.031h-1.125q-.125-.313-.313-.813t-.281-.813-.094-.5q0-.25.063-.5-.875 1.063-.875 1.563 0 .25.313 1.094t.313.969q0 .188-.063.313-1-1.313-1.188-1.313h-.75l-.688-1.75q-.375-.875-.375-1.188t.125-.75l-.156.188-.219.25q0-.063-.125-.313t-.125-.375q-.063.063-.75.875.063 0 .125.156l.125.313.063.281q-.063.063-.375.469t-.438.594q-.438.625-.188 1.375.188.438-.125.875h3.875q.25 0 .594.5t.344.875q.75-.813 1.063-1.313h6.688q.375 0 .625-.375zm1.25-1.687v-6.313q-.813 1.125-1.25 1.125.625 1.375.625 1.813v4.125q0 .75.375 1t1.125.25.875-.125q-.125-.063-.25-.094t-.219-.063-.156-.094q-1.125-.438-1.125-1.625z'
	    ),
	    'vaadin' => array(
		'p' => 'M14 8.813q.063-.625.156-1.031t.375-1.031.969-.938 1.625-.313h6.188q2 0 2-1.375v-.75q0-.563.375-.969T26.626 2q.375 0 .688.188t.5.5.188.688v2.313q0 2-1.031 2.938t-3.156.938h-6.25q-.688 0-1.125.125t-.625.406-.25.531-.063.625v.188q-.063.625-.5 1.031t-1 .406-1-.406-.438-1.031q-.063-.125-.063-.188 0-.5-.094-.813t-.594-.594-1.313-.281H4.187q-2.125 0-3.156-.938T0 5.688V3.375Q0 3 .188 2.687t.5-.5.688-.188.656.188.469.5.188.688v.75q0 1.375 2 1.375h6.188q1 0 1.656.344t.938.938.375 1 .156 1.031zM14 28.5q-1.125 0-1.625-1 0-.063-1.531-2.719l-3.063-5.313-1.531-2.719q-.563-.875 0-1.813t1.688-.938q1.313 0 1.875 1.25l4.188 7.375 4.188-7.375q.563-1.25 1.875-1.25 1.125 0 1.688.938t0 1.813q-.063.063-3.094 5.375t-3.031 5.375q-.5 1-1.625 1z'
	    ),
	    'viber' => array(
		'p' => 'M27.75 3.125q2.063 1#r#938 5.719t.188 9.656q-.188 1.438-.594 2.625t-.906 2.031-1.156 1.531-1.25 1.094-1.281.719-1.125.469-.969.281-.594.125q-.438.188-1.5.375t-3.375.406-4.625-.031q-1.313 1.438-1.875 2.063-.188.188-.5.531t-.438.469l-.406.406-.406.281-.438.125L9 31.937q-.25-.063-.438-.25t-.25-.406-.094-.438-.031-.344l-.063-.125.063-3.25h-.063q-1.313-.375-2.438-1.031t-1.844-1.469-1.313-1.781-.875-1.969-.5-2.063-.25-2.063-.063-1.938.031-1.688q.125-6.813 3.125-9.813 1.875-1.688 5-2.5t5.375-.813h2.188q3.25.063 5.906.719t3.656 1.25 1.625 1.156zm.875 14.813q.625-4.875-.094-8.281t-2.469-4.906q-.438-.438-1.375-.938t-3.219-1-5.031-.563h-.781l-1.938.094-2.688.313-2.781.813-2.438 1.531q-2.563 2.5-2.688 8.188.063 1.125 0 2.406t.25 2.75.844 2.75 1.781 2.375 3.063 1.594q-.063 4.938-.063 5.375t.25.531.5-.219l4.25-4.938q1.938.125 3.938-.031t2.938-.344 1.313-.313q.063 0 .594-.125t.938-.281 1.094-.469 1.219-.844 1.094-1.25.938-1.813.563-2.406zm-8.687-5.063q0 .438-.406.438t-.406-.375q-.125-2-2.063-2.125-.25 0-.344-.219t.031-.406.375-.188q2.688.125 2#r#875zm1.25.75q.063-2.063-1.188-3.438t-3.563-1.563q-.25 0-.313-.219t.031-.406.344-.188q2.625.188 4.094 1.813t1.406 4q0 .25-.188.344t-.406 0-.219-.344zm2.937.813q0 .25-.188.344t-.406 0-.219-.344q0-3.688-2.156-5.781T15.75 6.563q-.375 0-.375-.406t.375-.406q3.625 0 6 2.344t2.375 6.344zm-.687 6.125q-.625 1.063-1.5 1.719t-1.75.344q-1.063-.313-3.031-1.375t-3.344-2.125q-1.5-1#q#688-2.688-1-1.313-1.875-2.875-.625-1.063-1.031-1.938t-.531-1.25l-.063-.313q-.313-.875.344-1.75t1.719-1.5q.875-.438 1.5.25.75.938 1.125 1.375.438.625.938 1.5.563 1.063-.25 1.688l-.75.563q-.188.125-.25.344t-.063.406v.125l.156.469.5 1.063.938 1.438 1.5 1.344 2.156 1q.563 0 .875-.375l.625-.75q.625-.813 1.625-.25 1.75 1 2.875 2.063.688.625.25 1.5z',
		'w' => .998046875
	    ),
	    'vimeo' => array(
		'p' => 'M25.188 2q1.188 0 2 .813t.813 2v22.375q0 1.188-.813 2t-2 .813H2.813q-1.188 0-2-.813t-.813-2V4.813q0-1.188.813-2t2-.813h22.375zm-1.625 9.313q.188-4-2.938-4.063-4.188-.125-5.688 4.75.938-.563 1.969-.281t.844 1.656q-.063 1.063-1.313 3.063-1.688 2.625-2.438 1.75-.75-.938-1.813-7.438-.563-3.5-2.875-3.25-.438.063-.938.313t-1.156.781-1.125.938l-1.406 1.219-1.375 1.188 1 1.25q1.313-.938 1.563-.938.75 0 1.313 1.469t1.625 5.344q.438 1.563.625 2.438 1.25 3.25 3 3.25 2.875 0 7-5.375 4-5.125 4.125-8.063z'
	    ),
	    'vnv' => array(
		'p' => 'M6.563 22q-.938 0-1.656-.469t-.969-.969l-.313-.438-3.438-7q-.063-.063-.094-.125t-.063-.25 0-.344.219-.281.563-.125h2.063q.188 0 .313.063t.25.188.188.219.219.344.219.313l2.25 4.688q.375.813 1.313.813.438 0 .781-.219t.469-.406l.125-.188 2.25-4.688q.063-.063.188-.313t.188-.344.188-.219.281-.188.344-.063h2.063q.563 0 .719.281t.031.594l-3.625 7.25q0 .063-.063.188t-.313.438-.563.563-.813.469-1.125.219H6.564zm24.687 0q-.938 0-1.656-.469t-.969-.969l-.25-.438-3.5-7q-.688-1.125.625-1.125h2.063q.188 0 .313.063t.25.188.188.219.219.344.219.313l2.25 4.688q.375.813 1.313.813.438 0 .781-.219t.469-.406l.063-.188 2.313-4.688q.063-.063.219-.313t.188-.344.188-.219.281-.188.313-.063h2.063q.563 0 .719.281t.031.594l-.125.25-3.438 7q-.063.063-.125.188t-.313.438-.563.563-.813.469-1.125.219h-2.188zM21.125 12q.938 0 1.656.469t.969.969l.25.438 3.5 7q.625 1.125-.625 1.125h-2.063q-.188 0-.313-.063t-.219-.125-.188-.188-.156-.219-.156-.281-.156-.25l-2.313-4.688q-.313-.813-1.313-.813-.438 0-.781.219t-.406.406l-.125#q#313 4.688q0 .063-.156.313t-.219.344-.188.219-.281.188-.281.063h-2.063q-.625 0-.781-.281t-.031-.594l3.625-7.25q.063-.063.125-.188t.313-.438.531-.563.813-.469T18.874 12h2.25z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'whatsapp-square' => array(
		'p' => 'M13.969 7.688q3.406 0 5.844 2.438 2.5 2.5 2.5 5.813 0 3.375-2.438 5.781T14 24.126q-2.25 0-4.188-1.125l-.313-.188-3.125.813.813-3-.188-.313q-1.25-2-1.25-4.375 0-3.438 2.406-5.844t5.813-2.406zm4.906 11.75q.25-.875.125-1.188-.063-.063-.5-.25-1.375-.75-1.688-.813-.375-.188-.563.125t-.75.938q-.188.25-.563.063-1.25-.625-1.969-1.219t-1.406-1.719q-.063-.313-.031-.344t.313-.344.469-.688q.125-.188 0-.375-.063-.063-.188-.406t-.313-.813-.313-.656q-.125-.375-.5-.438h-.5q-.375 0-.688.313-.875.938-.875 2.063 0 1.25 1.063 2.563l.094.156.188.281.281.375.406.5.5.5.594.531.625.531.719.469.781.406q1.875.813 3 .625.375-.063.938-.406t.75-.781z#a#M14 25.813q4.125 0 7.063-2.906t2.938-6.969q0-4-3-7.063Q18.126 6 14.001 6T6.97 8.906t-2.906 6.969q0 2.688 1.313 5L4.002 26l5.25-1.375q2.188 1.188 4.75 1.188z'
	    ),
	    'whmcs' => array(
		'p' => 'M28 10.063l-1.813.438-.125.75 1.313 1.188-.688 1.25-1.813-.563-.438.5.563 1.75-1.313.75-1.313-1.313-.688.188-.438 1.813h-1.375l-.438-1.813-.75-.188-1.188 1.313-1.25-.75.5-1.688-.438-.5-1.875.438-.625-1.125 1.25-1.25-.188-.75-1.75-.5V8.626l1.75-.438.188-.688-1.25-1.313.688-1.188 1.75.5.5-.563-.5-1.688 1.25-.688 1.188 1.313.75-.25.438-1.625h1.375l.438 1.625.688.25 1.313-1.313 1.188.688-.438 1.75.438.5 1.813-.5.625 1.25-1.25 1.25.188.688 1.75.563v1.313zm-7.437 2.812q.938 0 1.75-.469t1.313-1.281.5-1.813q0-1.438-1.063-2.469t-2.531-1.031-2.5 1.031-1.031 2.5 1.031 2.5 2.531 1.031zm4.5 1.063l2.938.875v2.5l-3.438.813-.25 1.438 2.438 2.188-1.25 2.375-3.375-1-.875.938 1.063 3.25-2.438 1.438-2.438-2.5-1.313.375-.813 3.375h-2.625l-.813-3.375-1.375-.375-2.25 2.438-2.313-1.375.938-3.125-.875-1.063-3.438.938-1.25-2.188 2.375-2.375-.313-1.375-3.375-.875V14.69l3.375-.938.375-1.25-2.438-2.438 1.313-2.25 3.313.875.938-1-.938-3.25 2.313-1.25 2.25 2.438 1.438-.375.75-3.25h2.625l.75 2.875-1.438-.375-.375-.125-.25.375-.688 1.188-.188.375.313.25 1.063 1.125v.063l-1.5.375-.375.125v.375l-.063.813q-2.25.5-3.719 2.313t-1.469 4.188q0 2.688 1.938 4.625t4.688 1.938q2.313 0 4.125-1.469t2.313-3.656h1.25l.125-.438.313-1.5h.125l1.375 1.375.375-.188 1.25-.75.375-.25-.125-.375z'
	    ),
	    'wordpress-simple' => array(
		'p' => 'M16 .5q6.438 0 10.969 4.531T31.5 16t-4.531 10.969T16 31.5 5.031 26.969.5 16 5.031 5.031 16 .5zM2.063 16q0 4.063 2.156 7.438t5.719 5.125L3.25 10.313q-1.188 2.688-1.188 5.688zM16 29.938q2.375 0 4.625-.813-.063-.063-.125-.188l-4.25-11.688-4.188 12.125q1.938.563 3.938.563zM17.938 9.5l5 14.938 1.438-4.625q1.063-3.375 1.063-4.5 0-1.875-1.188-3.875-1.375-2.188-1.375-3.25 0-1 .688-1.75t1.688-.75q.063 0 .188.063-4-3.688-9.438-3.688-2.375 0-4.594.781t-4 2.188-3.031 3.344h.875l3.75-.188q.563-.063.594.5t-.531.625q-.75.125-1.625.188l5.125 15.063 3-9.125-2.125-5.938-1.5-.188q-.313 0-.438-.281t.031-.563.531-.281q2.313.188 3.625.188l3.75-.188q.563-.063.594.5t-.531.625q-.75.125-1.563.188zM23 28.063q3.188-1.875 5.063-5.063t1.875-7q0-3.563-1.688-6.688.063.688.063 1.438 0 2.313-1.063 5z'
	    ),
	    'xbox' => array(
		'p' => 'M23.125 19.875q4.438 5.438 3.375 7.438-.375.688-2.219 1.813t-3.531 1.688q-3.063.938-6.313.625-3.688-.375-6.875-2.438-1.313-.875-1.719-1.344t-.406-1.219q0-2.938 5.563-8.875Q12.5 16 14.188 14.5t1.938-1.438q.438.063 3.063 2.625t3.938 4.188zM11.813 9Q6.188 15.813 4.25 21.125q-1 2.813-.563 4 .125.438-.063.125-.188-.188-.5-.75-2.063-3.125-2.563-7.563-.125-1.188.25-3.75.188-1 .531-2.063t.844-2.063 1.125-1.906 1.313-1.656q.563-.563.813-.625t.938.125q1.688.563 5.063 3.625zm19.437 3.938q.25 1.063.25 2.938t-.188 2.938q-.375 1.938-1.188 3.625-.75 1.688-1.563 2.75-.188.188-.188.125l.125-.438q.188-1.125-.5-3.25-1.688-5.125-7.688-12.625 2.688-2.5 4.063-3.313 1.375-.875 2.25-.875.25 0 1.125.938t1.969 2.938 1.531 4.25zM8#r#688l-.563-.063L9.438 2Q13.376.25 17.157.531t6.906 2.219q-.625 0-1.25-.063t-2.156.344-3.344 1.281q-1.25.625-1.313.563-.063 0-.844-.375t-1.75-.781-2.25-.75-2.344-.281z'
	    ),
	    'yandex' => array(
		'p' => 'M9.563 19.75L4.125 32h-4l6-13.125Q1.437 16.5 1.437 10.062q0-4#r#656-7.438t6.656-2.625h5.125v32h-3.438v-12.25H9.561zm2.875-16.875h-1.813q-2.375 0-3.938 1.75t-1.563 5.438q0 6.813 5.5 6.813h1.813v-14z',
		'w' => .5,
		'vw' => 16
	    ),
	    'yandex-international' => array(
		'p' => 'M8.125 32V21.625L1.125 3h3.5L9.75 17.375 15.625 0h3.25l-7.563 21.75V32H8.124z',
		'w' => .625,
		'vw' => 20
	    ),
	    'apple-pay' => array(
		'p' => 'M7.313 9.875q-.875 1.063-2 .938-.125-1.063.75-2 .75-.938 1.938-1 .125 1.125-.688 2.063zM8 11q1.625.125 2.438 1.313h-.063q-1.438.938-1.375 2.5 0 .313.063.625t.156.531.219.438.281.375l.281.281.281.188.25.125.156.094.063.031q-.188.875-.875 1.875-1.125 1.625-2.063 1.625-.438 0-1.063-.25t-1.125-.25-1.125.25-1 .25q-.938.063-2.125-1.688-.938-1.375-1.25-3.156t.438-3.469Q1.5 11.063 3.25 11q.375 0 .813.156t.813.313.563.156 1.063-.344 1.5-.281zm6.25-2.25h4.563q1.188 0 2.094.5t1.438 1.406.531 2.094q0 1.75-1.156 2.875t-2.969 1.125h-2.625v4.125h-1.875V8.75zm1.875 1.563v4.813h2.188q1.25 0 1.938-.625t.688-1.781-.688-1.781-1.938-.625h-2.188zM26.313 21q-1.313 0-2.156-.719t-.844-1.906q0-2.375 3.375-2.625l2.375-.125v-.688q0-1.5-1.813-1.5-1.563 0-1.813 1.25h-1.688q0-.813.469-1.438t1.281-.969 1.813-.344q1.625 0 2.594.781t.969 2.094v6.063h-1.75v-1.438h-.063q-.813 1.563-2.75 1.563zm.5-1.437q.938 0 1.594-.563t.656-1.375v-.688l-2.125.125q-1.813.063-1.813 1.25 0 .375.219.656t.594.438.875.156zm6.375 4.625H32.5v-1.5q.313.063.563.063 1.188 0 1.563-1.25l.188-.563-3.188-8.875h1.938l2.25 7.188h.063l2.188-7.188h1.938l-3.313 9.313q-.563 1.625-1.313 2.219t-2.188.594z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'cc-apple-pay' => array(
		'p' => 'M18.875 13.656q0 1.719-1.813 1.719h-1.5v-3.438h1.5q1.813 0 1.813 1.719zm3 3.907q0-.813 1.25-.875l1.438-.125v.5q0 .375-.188.688t-.563.5-.813.188q-1.125 0-1.125-.875zM36 4.938v22q0 1.25-.875 2.125T33 29.938H3q-1.25 0-2.125-.875T0 26.938v-22q0-1.25.875-2.125T3 1.938h30q1.25 0 2.125.875T36 4.938zM8 12.313q.75.063 1.375-.625.563-.688.5-1.5-.813.063-1.375.688-.625.688-.5 1.438zM11.75 17q-1.188-.563-1.188-1.875-.063-1.063 1-1.75-.625-.875-1.688-.938-.375-.063-.719.063t-.656.25-.438.125-.656-.219-.844-.219q-1.313.063-1.938 1.188-.5 1.188-.281 2.438t.906 2.188q.813 1.188 1.438 1.188.25 0 .688-.188t.813-.188.813.188.75.188q.625 0 1.375-1.125.375-.563.625-1.313zm8.5-3.375q0-1.25-.781-2t-2.031-.75H14.25v8.5h1.313v-2.938h1.813q.813 0 1.469-.344t1.031-1 .375-1.469zm5.625 1.5q0-.625-.313-1.063t-.875-.688-1.313-.25q-.688 0-1.25.219t-.906.656-.344 1h1.188q.188-.875 1.25-.875 1.25 0 1.25 1.063v.5l-1.625.063q-2.375#q#375 1.875 0 .5.281.938t.75.656 1.031.219q1.438 0 2-1.063v1h1.25v-4.25zm6.375-1.937h-1.375l-1.5 5.063h-.063l-1.563-5.063h-1.375l2.25 6.188-.125.375q-.25.875-1.125.875h-.375v1q.063.063.5.063 1 0 1.531-.438t.906-1.563z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'fly' => array(
		'p' => 'M12.375 26.75q2.125 1.875 2.063 3.125v.188q-.063.875-.75 1.406T12 32q-1.125 0-1.813-.656t-.625-1.594q.063-1.188 2.063-2.938.188-.188.313-.25.25 0 .438.188zM20.75 4.188q1.938 3.313 1.313 7.063-.625 2.938-3.594 6.688t-6.156 6.813l-.25.125h-.188l-.375-.375q-1.75-1.688-3.094-3.125t-2.938-3.5-2.563-4.094-1.156-3.844q-.125-6.063 5.188-8.875Q9.562.001 12 .001q2.5 0 4.813.938 2.688 1.25 3.938 3.25zM11.688 22V1.625q-1.688#q#75 1.75T7.563 6.719t-.188 3.469q.313 4.5 4.313 11.813zm8.875-10.75q.813-2.875-.781-5.813t-5.469-3.75q1.625 1.125 2.344 3.438t.656 4.75q-.125 4.438-4.188 12 6.188-6.25 7.438-10.625z',
		'w' => .748046875,
		'vw' => 24
	    ),
	    'nintendo-switch' => array(
		'p' => 'M6 2.125Q6.438 2 9.938 2t3.563.125T13.564 16v11.719l-.063 2.219q-.125.063-3.688.063-3.563-.063-4-.125-1.5-.375-2.656-1.156t-1.906-1.938-1.125-2.594Q.001 23.625.001 16.5q0-8.063.25-9.125.563-2.063 2.094-3.469t3.656-1.781zM11.25 16V4.25H9q-2.75 0-3.625.375-2.438.938-3 3.563-.063.438-.063 7.813t.063 7.75q.188.938.688 1.719t1.281 1.313T6 27.564q.5.125 2.875.188h2.375v-11.75zM6.5 7.813q1.063-.25 2 .406T9.625 10q.125.938-.375 1.75t-1.438 1.125Q7.437 13 6.874 13t-1-.25q-.813-.375-1.25-1.25-.188-.375-.188-.938-.125-1.313.813-2.125.563-.5 1.25-.625zm9.875-5.75Q16.438 2 18.969 2T22 2.125q1.5.25 2.75 1.031t2.063 2.031 1.125 2.75q.063.438.063 8.063v.375q0 5.75-.031 6.844T27.689 25q0 .063-.063.125-.188.5-.438 1-.813 1.563-2.281 2.594t-3.281 1.219q-.375.063-2.719.063h-2.469q-.063-.063-.063-14V2.063zm6.188 12.625q-1.063-.313-2.063.25t-1.313 1.625q-.25.813 0 1.625.313 1.063 1.313 1.625t2.063.313q1.375-.375 1.938-1.813.375-.875 0-1.813-.5-1.438-1.938-1.813z'
	    ),
	    'node' => array(
		'p' => 'M19.75 28.25q-.188 0-.375-.125l-1.188-.688q-.188-.125-.063-.188.313-.063.563-.25.063 0 .125.063l.875.5q.063.063.125 0l3.625-2.063q.063-.063.063-.125v-4.125q0-.063-.063-.125l-3.625-2.063q-.063-.063-.125 0l-3.563 2.063q-.063.063-.063.125v4.125q0 .063.063.125l.938.563q.438.188.656.031t.219-.406v-4.125q0-.063.125-.063h.438q.125 0 .125.063v4.125q0 1.125-1.063 1.125-.375 0-.813-.188l-1-.563q-.375-.25-.375-.688v-4.125q0-.438.375-.688l3.625-2.063q.375-.25.75 0l3.625 2.063q.375.25.375.688v4.125q0 .5-.375.688l-3.625 2.063q-.125.125-.375.125zm2.938-4.125q0 1.25-1.813 1.25-1.938 0-1.938-1.313 0-.125.125-.125h.5q.063 0 .063.063.125.75 1.25.75T22 24.187q0-.438-1.313-.563-1.563-.125-1.563-1.063 0-1.188 1.625-1.188 1.688 0 1.813 1.25 0 .063-.031.094t-.094.031h-.438q-.125 0-.125-.063-.125-.688-1.125-.688-.938 0-.938.5 0 .188.219.281t1.031.219q.875.125 1.25.344t.375.781zM26.125 21q0 .188-.094.344t-.281.25-.375.094q-.25 0-.469-.188t-.219-.5.219-.5.5-.188.5.188.219.5zM26 21q0-.563-.594-.563t-.594.594.594.563T26 21zm-.312.375h-.125q-.063-.188-.063-.25t-.063-.063h-.125v.313h-.188v-.75h.25q.313 0 .313.188 0 .125-.188.188.125 0 .188.188v.188zm-.188-.531q0-.094-.063-.094h-.125v.188h.063q.125 0 .125-.094zM8.563 11.938v5.938q0 .125-.125.188t-.188 0l-2.313-1.313q-.188-.125-.188-.375v-2.75q0-.313-.25-.438l-1-.563q-.063-.063-.188-.063t-.25.063l-1 .563q-.188.125-.188.438v2.75q0 .25-.25.375l-2.25 1.313q-.125.063-.25 0t-.125-.188v-5.938q0-.25.25-.375l3.813-2.25q.125-.063.188-.063h.063q.125 0 .188.063l3.875 2.25q.188.125.188.375zm20.937-6.5v11.063q0 .25-.188.375l-3#r#25q-.25.125-.5 0l-3.813-2.25q-.25-.125-.25-.375v-4.438q0-.25.25-.438l3.813-2.188q.25-.125.5 0l.938.563q.25.125.25-.125V4q0-.125.094-.219T27 3.75l2.313 1.313q.188.125.188.375zM26.625 13.5v-.063l-1.313-.813h-.125l-1.313.813q-.063 0-.063.063V15q0 .125.063.125l1.313.75q.063.063.063 0l1.375-.75V13.5zm13.125 0l-2.25 1.313q-.125.063-.25 0t-.125-.188V13.5q0-.125-.125-.188l-1.188-.688q-.125-.063-.25 0l-1.188.688q-.125.063-.125.188v1.375q0 .125.125.25l3.875 2.188q.125.063.125.188t-.125.188l-2.313 1.313q-.25.125-.438 0l-3.813-2.188q-.25-.125-.25-.375v-4.438q0-.25.25-.375l3.813-2.25q.25-.125.438 0l3#r#25q.25.125.25.375v1.063q0 .25-.25.438zm-4.812.188l.75-.438h.063l.75.438q.063 0 .063.063v.875l-.063.063-.75.438h-.063l-.75-.438q-.063 0-.063-.063v-.875zm-15.875 2.687v.125q-.063.188-.25.313L15 19.001q-.25.125-.438 0l-3.875-2.188q-.25-.125-.25-.438V12q0-.25.25-.375l3.813-2.25q.25-.125.5 0l3#r#25q.25.125.25.375v4.375zm-4.688-7.75zm4.813 8.125l-.063-.063v.063h.063z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'osi' => array(
		'p' => 'M0 16.188Q.125 10 3.938 5.719T13.376.688q4.188-.563 7.969.969t6.25 4.625 3.156 6.969q1 5.5-1.688 10.281t-7.813 6.844q-.813.375-1.125-.5-.438-1.188-1.063-2.75t-1.219-3.125-1.031-2.75q-.313-.75.438-1.063 2.313-1.063 2.688-3.5.313-1.938-.906-3.469t-3.094-1.656q-1.813-.188-3.219.906t-1.656 2.781q-.25 1.563.469 2.906t2.156 1.969q.813.375.5 1.125-2.25 5.875-3.375 8.75-.25.688-.938.438-5.5-2.125-8.188-7.438-.313-.563-.531-1.125t-.375-1.031-.281-1-.188-.875-.125-.844-.094-.719-.063-.688-.031-.531zm1.313-.125v.438l.031.5.031.438q.313 3.563 2.406 6.625t5.781 4.813q.25.125.375-.125 1.375-3.625 2.813-7.313.063-.25-.188-.438-3-1.875-2.813-5.375.063-2 1.469-3.531t3.406-1.813 3.813.719q1.5.875 2.281 2.406t.531 3.281q-.313 2.813-2.813 4.313-.25.188-.188.375 1.125 2.875 2.875 7.375.063.25.313.125 3.438-1.563 5.5-4.5 3.313-4.5 2.688-10-.688-5.75-5.25-9.469t-10.75-2.906q-3.313.375-6.094 2.25T3.061 9.22t-1.75 6.844z',
		'w' => .966796875,
		'vw' => 31
	    ),
	    'react' => array(
		'p' => 'M26.125 11.063q2.625.938 4.25 2.219T32 16.001t-1.719 2.813-4.531 2.25l-.563.188q.125.438.188.875.375 1.813.313 3.313t-.531 2.625-1.281 1.563q-1.25.688-3.094.063t-3.906-2.313l-.813-.813q-.313.313-.688.625-2.063 1.813-4.031 2.469t-3.219-.031T6.5 27.003t.125-4.563l.25-1.125q-.313-.063-.875-.25-2.688-.938-4.344-2.313T0 16.002t1.563-2.688 4#q#188l1.125-.375q-.125-.5-.188-1.063-.563-2.625-.188-4.594t1.625-2.719q1.25-.688 3.25 0T15.5 5l.5.5q.438-.438.813-.75 2.063-1.813 3.906-2.438t3.094.063q1.313.688 1.688 2.781t-.25 4.906q-.063.438-.125.688.5.125 1 .313zM17.688 5.75q-.375.313-.75.688 1.438 1.563 2.688 3.313 2.063.188 4.188.688.063-.25.125-.625.5-2.438.281-4.125t-1.031-2.188q-.813-.438-2.313.188t-3.188 2.063zm-7.25 13.5q-.375-.75-.875-1.688-.625 1.5-1 2.813 1.375.313 2.875.438-.438-.625-1-1.563zm-1.875-7.562q.438 1.375 1 2.75.375-.75.875-1.625.438-.75.938-1.625-1.5#q#813.5zM10.25 16q.688 1.375 1.375 2.563.688 1.25 1.5 2.438 1.438.063 2.875.063 1.5 0 2.875-.063.875-1.313 1.5-2.5.75-1.25 1.375-2.5-.688-1.375-1.375-2.563t-1.5-2.375q-1.438-.125-2.875-.125t-2.875.125q-.875 1.25-1.5 2.438-.75 1.313-1.375 2.5zm11.313 3.188q-.563 1-1 1.625 1.5-.188 2.938-.5-.438-1.438-1-2.75-.5.938-.938 1.625zm.875-4.75q.625-1.375 1-2.75-1.313-.313-2.813-.5.438.813.938 1.625.375.625.875 1.625zM16 7.375q-1 1.063-1.875 2.25 1.875-.063 3.75 0Q17 8.437 16 7.375zM8.75 3.563q-.75.438-.969 2.031T8 9.438l.188.938q2.125-.438 4.188-.625 1.25-1.75 2.688-3.313L14.626 6q-1.813-1.625-3.438-2.281T8.75 3.563zm-1.5 16.5q.625-2.125 1.5-4.063-.875-1.938-1.5-4-.625.188-1.063.375-2.188.75-3.5 1.75T1.374 16q.125 1.188 1.125 1.875 1.5 1.125 3.938 1.938.438.125.813.25zm7.25 6.125q.313-.25.625-.563-1.5-1.625-2.688-3.375-2.125-.125-4.25-.625-.125.5-.25 1.063-.375 2.25-.156 3.781t1.031 1.969q1.063.438 2.188-.063 1.938-.75 3.5-2.188zm1.563-1.563q1-1.125 1.813-2.25-.875.063-1.875.063-.938 0-1.875-.063.938 1.25 1.938 2.25zM24.25 26.5q.25-2.125-.188-4.125-.063-.375-.188-.75-2.063.438-4.25.625-1.188 1.75-2.625 3.375.5.5.813.688 1.063 1 2.156 1.594t1.875.719 1.344-.125q.938-.75 1.063-2zm1.125-6.687q1.5-.5 2.719-1.188t1.875-1.375.656-1.313q0-.813-1.375-1.844t-3.563-1.781q-.5-.125-.938-.25-.625 2.063-1.5 3.938.938 2 1.563 3.938.188 0 .563-.125zM16 18.875q-1.188 0-2.031-.844T13.125 16t.844-2.031T16 13.125t2.031.844.844 2.031-.844 2.031-2.031.844z'
	    ),
	    'autoprefixer' => array(
		'p' => 'M19.875 1l10.25 30h-4.813l-1.563-5.063h-7.5L14.686 31H9.811zm-2.5 21.375h5.25l-2.563-8.125h-.125zM40 25.313l-9.875.563-1.25-3.5 10.5 1zm-28.875-2.938l-1.25 3.5L0 25.312l.625-1.938z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'less' => array(
		'p' => 'M38.313 13.688q0 1.375 1.688 1.438v1.75q-1.688.063-1.688 1.438 0 .625.094 1.656t.094 1.781q0 1.563-.594 2.188t-1.969.625h-1.25v-1.563h.375v-.063q.438 0 .656-.125t.313-.406.094-.844-.031-1.594-.031-1.656q0-2 1.438-2.313v-.125q-1.438-.313-1.438-2.313 0-.625.031-1.688t.031-1.5q0-.875-.188-1.156t-.875-.281h-.375v-1.5h1.25q1.375 0 1.969.625t.594 2.188q0 .75-.094 1.781t-.094 1.656zm-6.625 2q2.688.875 2.688 3 0 .875-.438 1.594t-1.375 1.156-2.188.438q-2.125 0-3.75-1.375l1.313-1.938q1.313 1.063 2.5 1.063 1.313 0 1.313-.875 0-.563-1.813-1.25-.125-.063-.188-.125-2.625-1-2.625-2.875 0-.688.281-1.25t.75-.969 1.188-.625 1.531-.219q1.75 0 3.438 1.25L33 14.438q-1.125-.813-2.125-.813-1.063 0-1.063.75 0 .188.031.281t.156.219.219.188.313.156.344.156.406.156.406.156zM9.25 19.375h.375L10 21.5q-.625.25-1.5.25-2.688 0-2.688-3.375V9h-.875q-.625 0-.844.281t-.219 1.094q0 .5.031 1.563t.031 1.625q0 2-1.438 2.313v.125q1.438.375 1.438 2.313 0 .625-.031 1.688t-.031 1.563q0 .813.219 1.125t.844.313h.375v1.5h-1.25q-1.375 0-1.969-.625t-.594-2.25q0-.688.094-1.719t.094-1.594q0-1.438-1.688-1.438v-1.75q1.688-.063 1.688-1.438 0-.563-.094-1.625t-.094-1.813q0-1.563.594-2.188t1.969-.625H8.75v11.125q0 .813.5.813zm14.5-3.687q2.688.875 2.688 3 0 .688-.281 1.25t-.781 1-1.25.688-1.75.25q-2.063 0-3.75-1.375l1.313-1.938q1.313 1.063 2.5 1.063 1.313 0 1.313-.875 0-.563-1.813-1.25-.125-.063-.188-.125-2.625-1-2.625-2.875 0-.688.281-1.25t.781-.969 1.188-.625 1.5-.219q1.813 0 3.438 1.25l-1.313 1.75q-1.125-.813-2.063-.813-1.125 0-1.125.75 0 .188.031.281t.156.219.25.188l.313.156.344.156.438.156.406.156zm-9.687-4.313q2 0 3.094 1.344t1.094 3.406q0 .438-.125 1.188h-5.938q.375 2.188 2.563 2.188 1.063 0 2.125-.625l1 1.688q-1.625 1.125-3.5 1.125-1.438 0-2.531-.594t-1.75-1.781-.656-2.75q-.063-2.313 1.344-3.75t3.281-1.438zM12.188 15.5h3.563q0-1.938-1.688-1.938-1.563 0-1.875 1.938z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'sass' => array(
		'p' => 'M34.438 18.25q2.563 0 4.094 1.375t1.469 3.063q-.063 1.063-.75 1.688t-1.125.75q-.313.063-.375-.125 0-.125.313-.313.938-.625 1.094-1.594T38.377 21t-3.25-1.375q-2.188-.25-3.875.438.313.813.375 1.438 0 1.375-1.5 2.5-.625.438-1.375.688-.688.313-1.063.25-1.188-.25-.563-2.063.5-1.438 2.125-2.75-.625-1.25-.75-1.625l-.375-1.625q-.938 2-2.188 3.813 0 .063-.188.313.375 1 .438 1.75.063 1.563-1.188 2.5-.625.375-1.313.625-.563.313-1.438.375-.688 0-1-.188-.375-.313-.188-.875.125-.188 1.875-2.313.375-.375.625-.813.188-.188.375-.5-.75-1.688-.813-1.875l-.375-1.625q-1 2.5-2 4.5-.938 1.875-1.563 2.875 0 .063-.063.125l-.063.063q-.75 1.188-1.438 1.188t-.938-.813-.188-1.625l.125-.875q-.5 1.25-1 2.25-.25.563-.438.844t-.531.5-.719.219q-.625 0-.938-.313-.563-.5-.938-1.656t-.313-2.156q.188-1.625.563-2.688-.875.5-1.5.813-.5.313-.75.5v.063q.563.813.469 2.75t-1.094 3.438q-1.063 1.688-2.938 2.469t-3.75.281q-.813-.25-1.25-1.406t.25-3.031q1-2.25 5.813-4.625.063-.063.156-.094t.156-.094q-.563-.438-1.969-1.438t-2.5-1.781-2.094-2.063-1.25-2.531q-.25-1.063.5-2.781t2.813-3.594q3.563-3.313 9.438-5.438 4.125-1.5 7.844-.688t4.406 3.438q.438 1.688-.281 3.531t-2.25 3.313-3.469 2.219q-2.313.938-4.563 1.031t-2.875-.281q-.938-.313-1.531-.844t-.781-.969q-.188-.5 0-.625.188-.063.5.313 1.25 1.313 4.063 1 4.5-.5 7.219-3.313t1.719-4.938q-.688-1.625-3.938-1.719t-7.938 2.031q-7.688 3.875-7.938 7.938-.063 1.438.906 2.656t2#r#563 2.469 2.094q.063 0 .094.031l.031.031q.188-.063.406-.188t.469-.281.438-.219q1-.563 2.625-1.438.688-.938 1.719-1.688t1.844-.75 1.125.656.188 1.344l-.125.688q.063-.125.125-.125l.063-.063.156-.125.25-.063.344.063q.375.188.438.688l-.156.656-.406 1.656-.375 1.625q-.063.313-.094.625t0 .469l.031.156q.125 0 .313-.375.063-.188.188-.438v.063l.031-.031.031-.094q.25-.5.625-1.313 2.438-5.375 2.625-6 .125-.25.219-.656t.156-.531q.125-.375 1.563-.375.875 0 .875.438l-.094.281-.219.688-.125.719q-.125.563.063 1.563.063.438.563 1.375 2.188-3.625 2.438-4.688.125-.625.313-1.188.125-.375 1.563-.375.875 0 .938.438l-.125.281-.219.688-.156.719q-.063.563.063 1.563.063.375.813 1.875 1.688-.813 3.625-.813zM7.625 27.313q1.938-2.125 1.188-4.938l-.063.063-.094.063-.094.063q-.125.063-.219.125t-.188.094-.188.094-.156.125q-1.688 1-2.688 1.969t-1.281 2.156.281 1.5 1.625-.063 1.875-1.25zM16 21.563q1.313-3.188 1-3.688-.063-.25-.531-.063t-.906.688q-.875 1-1.375 2.5-.313.938-.375 1.844t.094 1.469.344.625q.125 0 .313-.219t.406-.656.375-.813.375-.938.281-.75zm6.938 3.312q1.563-.938 1.563-2.188v-.063q-.313.438-.688.875l-1.188 1.313-.063.188q.063.063.375-.125zm5.375-1.187q1.625-.625 1.625-2.188 0-.25-.125-.625-.813.688-1.188 1.5-.563 1.125-.313 1.313z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'vuejs' => array(
		'p' => 'M22.313 4h5.688l-14 24-14-24h11l3 5.563L17.501 4h4.813zM3.5 6L14 24 24.5 6h-3.375L14 18.375 6.875 6H3.5z'
	    ),
	    'angular' => array(
		'p' => 'M10.625 16.75L13 11l2.375 5.75h-4.75zM13 2l13 4.625-2 17.25L13 30 2 23.875 0 6.625zm8.125 21.375L13 5.125l-8.125 18.25h3l1.688-4.125h6.875l1.625 4.125h3.063z',
		'w' => .810546875,
		'vw' => 26
	    ),
	    'aviato' => array(
		'p' => 'M6.688 17.75L5.5 15.125H2.25L1.062 17.75H-.001L3.874 9.5l3.875 8.25H6.686zm-2.813-6.187l-1.188 2.688h2.438zM10.938 18L7.063 9.75h1.063l2.813 6 2.813-6h1.063zM16 17.75v-8h.938v8H16zm13.063-7.25v7.25h-1.125V10.5h-2.563v-.75h6.25v.75h-2.563zM40 13.688q0 .875-.313 1.625t-.875 1.313-1.313.875-1.625.313-1.625-.313-1.313-.906-.875-1.313-.313-1.594.313-1.625.875-1.313q.313-.313 1.313-.75.75-.313 1.625-.313t1.625.313q1 .438 1.313.75.563.563.875 1.313T40 13.688zm-1 0q0-.688-.219-1.281t-.656-1.031-1-.688q-.625-.25-1.281-.25t-1.219.25-1 .688-.688 1.031-.25 1.281.25 1.25.688 1 1 .688 1.219.25 1.281-.25q.563-.25 1-.688t.656-1 .219-1.25zm-5.875 6.062q.625.063.625.75 0 .313-.219.531T33 21.25t-.531-.219-.219-.531q0-.688.625-.75v-.375l-5 .563v.313q.625.125.625.75t-.781.625-.781-.625.625-.75v-.313l-1.813.188v1.5h.375v.875h-.375v-.438h-.313v.438h-.313v-.875h.313v-1.438l-2.375.25q-.25.313-.531.531t-.469.281l-.188.063v.438h.313v.75h-.25v-.313h-.313v.313h-.25v-.75h.313v-.438q-.688-.125-1.188-.875l-2.375-.25v1.438h.375v.875h-.375v-.438h-.313v.438h-.375v-.875h.375v-1.5l-1.813-.188v.313q.625.125.625.75t-.75.625-.75-.625.563-.75v-.313l-5-.563v.375q.688.063.688.75 0 .313-.25.531t-.563.219-.531-.219-.219-.531q0-.688.625-.75v-.438l-5.563-.625 15.188.875q-.063-.25-.063-.438-.063-.25-.063-.438l-4.063-.5 4.063.125q0-.063.063-.063.063-.5.438-.875t.75-.5l.375-.125.063-1.625h-1.5l-1.125 2.563h-1.125l3.938-8.188 3.875 8.188h-1.063l-1#q#563h-1.5l.063 1.625q1.438.375 1.625 1.5v.063l4-.125-4 .5q0 .188-.063.375 0 .25-.063.5l15.188-.875-5.563.625v.438zm-12.562-5.5h1.125l.063-2.5.125 2.5h1.125l-1.25-2.688z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'ember' => array(
		'p' => 'M40 15.938q0 .25-.063.5t-.188.313l-.063.063q-.188.125-.5.313t-1.094.438-1.344.125q-.375-.125-.656-.438t-.406-.688-.188-.75-.125-.625v-.25h-.125l-1.25 3.625q-.063.188-.188.469t-.469.688-.688.25-.531-.438-.188-.531v-.188q-.125.125-.406.344t-1.156.563-1.875.219q-.875-.063-1.5-.469t-.875-.781l-.188-.375q-1.313.875-4.938 1.625-.75.063-1.438-.156t-1.063-.406l-.313-.25-1.125.625q-1.375.625-1.938-.313-.25-.438-.281-1.438t.031-1.813l.063-.75h-.063q-.813 1.625-1.25 3.125-.188.625-.406.969t-.406.344h-.125q-.938.063-1.188-.688-.063-.5 0-1.344t.25-1.594l.125-.813h-.125l-.75 1.5q-.625 1.5-1 2.156t-.625.781-.688.063q-.313-.063-.5-.344t-.188-.469l-.063-.25-1 .563q-.063 0-.25.094t-.656.219-.906.156-.969-.063-.844-.344q-1-.75-1.25-1.875-1.063-.063-1.75-.375-.313-.125-.313-.375t.188-.5l.125-.25q.25-.313.625 0 .188.125.469.188t.531 0h.188q.125-1.188.5-2 .875-2 2.563-2.063 1.313 0 2 .938.5 1.313-.281 2.375t-1.781 1.5l-1.063.5v.063l.063.188.125.219.313.156.563.063q.5 0 1.25-.313t1.188-.625l.5-.313q.063-.688.406-2.375t.531-2.063q.063-.188.281-.281t.406-.094h.188q.563-.063.625.5.063.25-.031 1t-.219 1.375l-.125.563.063.125 1.313-2.25q.063-.188.219-.375t.625-.531.906-.281q.313 0 .406.344t.031.844-.156.969-.219.844l-.125.313.125.125.063-.125 1.75-2.813q.063-.063.156-.188t.406-.281.563-.094q.563.188.625.875l-.438 3.313v1.375q.125.313.313.375.313 0 .625-.156t.5-.344l.188-.125q.438-3.625.75-6.563.063-.625.188-1.219t.281-1.094.344-.938.344-.75.281-.531.188-.344l.063-.125q.438-.625 1.5-1.063 1.375-.5 1.813 1.438.688 2.813-2.313 6.625.875-.875 1.688-.375 1.125.75 1.25 2t-.313 2.188l-.438.875q.313-.063.813-.344t.875-.531l.375-.25v-.438q.438-2.313 2.313-3.75.25-.188.906-.344t1.375.219.781 1.625q.063 1.188-.781 2.125t-1.656 1.25l-.875.313.125.25.469.281.969.031q.375 0 .781-.188t.719-.375.594-.375l.469-.313.125-.125q.063-.75.438-2.281T33 12.5q.125-.25.625-.281t.563.156l.063 2.313h.063q.125-.313.281-.625l.281-.563.281-.438.219-.25.063-.125q.125-.063.219-.156t.406-.219.531-.063.313.531.031.906l-.063.438q-.25 1.938.625 2 .375.063.844-.094t.719-.344l.25-.188q.625-.25.688.438zm-36.125.312q.375.125 1.25-.5.625-.438.781-1.031t-.219-.906q-.25-.125-.656 0t-.781.813-.375 1.625zM20.938 8.5q-1 3.438-1.063 4.438.125-.188.313-.5t.656-1.188.813-1.594.594-1.531.125-1.188q-.25-1.375-1.375 1.375zm1.406 8.656q.219-.594.281-1.094t-.031-.813-.188-.531-.219-.344l-.063-.063q-.063-.063-.156-.094t-.375-.063-.531.063-.563.438-.469.906-.281 1.094-.125.813v.906q.063.063.219.094t.531.063.688-.063.688-.406.594-.906zm5.281-.906q1 .063 1.625-.875.313-.438.344-.844t-.094-.594l-.125-.188q-.563-.688-1.25.563-.313.563-.438 1.063t-.063.688v.188z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'font-awesome-flag' => array(
		'p' => 'M27.75 22.438q0 .5-.813.875-3.438 1.438-5.75 1.438-1.375 0-3.625-.875t-4.063-.875q-3.125 0-7.25 1.813-.063.063-.188.094t-.188.031v4.875q0 1-.625 1.594t-1.5.594-1.5-.625-.625-1.563V6.376Q.185 5.313.185 3.563q0-1.438 1.063-2.5T3.779 0 6.31 1.063t1.063 2.5q0 1.813-1.438 2.813v2q.063 0 .406-.156t.813-.344 1.188-.406 1.438-.406 1.625-.344 1.719-.156q2.313 0 4.813.875t3.125.875q1.438 0 3.531-.875t2.219-.875q.375 0 .656.25t.281.625v15z',
		'w' => .873046875,
		'vw' => 28
	    ),
	    'gitter' => array(
		'p' => 'M4.125 20.125H1V0h3.125v20.125zM10.438 4.75V32H7.25V4.75h3.188zm6.312 0V32h-3.188V4.75h3.188zm6.25 0v15.438h-3.125V4.75H23z',
		'w' => .75,
		'vw' => 24
	    ),
	    'hooli' => array(
		'p' => 'M9 22v-1q1.188.625 2.438 1.063zm3.625-.312q2.375.813 4.75.813-2.563.688-5.938-.438L12.625 22v-.313zM38.188 14.5q-.75 0-1.281-.531t-.531-1.281.531-1.156 1.313-.406 1.281.406.5 1.156-.531 1.281-1.281.531zM36.375 22v-6.875H40V22h-3.625zm-4.625 0V11.5l3.625-1.688V22H31.75zm-1.937-7.437q.438.375.656.75t.313.906.094.688v1.938l-.094.719-.344.813-.625.75q-.313.313-.75.531t-.844.313-.75.156-.594.063h-.188q-2 .063-3.125-1.063-.438-.438-.656-.813t-.313-.906-.094-.688v-1.156q0-.688.031-1.031t.281-.906.75-1.063 1.281-.781 1.281-.281h.563q2-.125 3.125 1.063zM27.375 19v-2.5q0-.688-.688-.688t-.688.688V19q0 .813.688.813t.688-.813zm-6.687-4.437q.438.375.656.75t.313.906.094.688v1.906l-.031.344-.063.313-.094.313-.125.313-.188.344-.25.313-.313.313q-.313.313-.75.563t-.844.344-.75.156-.594.063l-.188-.063q-2 .125-3.125-1.063-.438-.375-.656-.75t-.313-.906-.094-.688v-.906q0-1.875.563-2.75-2.188-1.625-6.25-3.625v3.375q.813-1.375 2.438-1.375 1.188 0 1.844.688t.656 1.688v5.875q-1.875-.75-3.563-1.875v-3.063q0-.938-.688-.938t-.688 1.188v1.813l-.25-.188q-2.063-1.688-3.375-3.188v1.938q1.125 1 2.438 2 .563.438 1.188.813v1.813H4.061V17.38q-1.063-1-1.875-1.906T.936 13.88.28 12.63t-.25-.969 0-.688.094-.406l.063-.063q.438-.938 2-.969t4.125.906l1.375-.625v1.313q4 1.938 6.375 3.813l.375-.375q.313-.313.75-.563t.844-.344.75-.156.594-.063l.188.063q2-.125 3.125 1.063zM4.063 11.5l1.813-.875q-2.875-1.063-4-.125-.188.188-.25.594t.5 1.625 1.938 2.719V11.5zM18.25 19v-2.5q0-.688-.688-.688t-.688.688V19q0 .813.688.813T18.25 19z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'strava' => array(
		'p' => 'M9.438 0l9.438 18.25h-5.563L9.438 11l-3.875 7.25H0zm9.437 18.25h4.188L16.125 32l-7-13.75h4.188l2.813 5.5z',
		'w' => .720703125,
		'vw' => 23
	    ),
	    'stripe' => array(
		'p' => 'M10.313 9.063v2.375h2.125v2.375h-2.125v3.938q0 .563.281.875t.656.313.688-.063.5-.125v2.125q-.688.375-1.938.375t-2.063-.75-.813-2V9.626zm5.562 3.187q.75-1.375 2.313-.813V14q-1.313-.438-2.125.563v6.438h-2.75v-9.563h2.375zm5.75-4.5V10l-2.75.625v-2.25zm-18.812 6.5q0 .438.656.719t1.469.5 1.469.938.656 1.844q0 .938-.5 1.625t-1.375 1.031-2.063.344q-1.563 0-3-.688v-2.5q1.625.938 3.063.938 1.063 0 1.063-.688 0-.438-.656-.75T2.126 17t-1.469-.906-.656-1.719q0-1.438 1.031-2.281t2.719-.844q1.5 0 2.75.5v2.625q-1.313-.688-2.75-.688-.938 0-.938.563zM40 16.375q0 .563-.063 1h-5.438Q34.687 19 36.687 19q1.5 0 2.75-.563V20.5q-1.313.75-3.125.75-1.375 0-2.375-.531t-1.594-1.656-.594-2.75q0-2.188 1.156-3.625t3.094-1.438q1.875 0 2.938 1.438T40 16.376zm-5.5-1.062h2.875q0-.875-.406-1.344T36 13.5q-.625 0-1.063.469t-.438 1.344zm-7.062-4.063q1.563 0 2.688 1.344t1.125 3.656q0 2.5-1.094 3.75t-2.719 1.25q-1 0-1.938-.75l-.063 3.125-2.75.625V11.437h2.438l.125.688q1-.875 2.188-.875zm-.625 7.688q.75 0 1.219-.75t.469-1.875-.469-1.844-1.219-.719q-.875 0-1.375.5l.063 4.125q.5.563 1.313.563zM18.875 21v-9.563h2.75V21h-2.75z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'stripe-s' => array(
		'p' => 'M9 9.688q0 .875 1.031 1.563t2.531 1.125 3.281 1.188 3.281 1.688 2.5 2.781 1 4.344q0 4.688-3.375 7.156t-9.125 2.469q-5.063 0-9.75-2v-8.063q5.25 2.875 9.75 2.875 3.438 0 3.438-2.188 0-1-1-1.75t-2.5-1.219-3.281-1.219T3.5 16.782 1 14.126t-1-4.063q0-4.688 3.281-7.375T12.062 0q4.75 0 8.875 1.625V10q-4.25-2.25-8.875-2.25-3.063 0-3.063 1.938z',
		'w' => .70703125,
		'vw' => 23
	    ),
	    'typo3' => array(
		'p' => 'M10.75 4.875q0 1.563.875 4.344t2.156 5.5 2.875 4.719 2.844 2q.75 0 1.188-.125-2.375 3.75-4.938 6.219t-4.25 2.469q-2.25 0-5.031-3.938t-4.625-8.938T0 8.875q0-1.438.563-2.313.813-.938 2.625-1.813t4-1.469 4.438-.844q-.875.688-.875 2.438zM18.375 2q8.688 0 8.688 3.25 0 2.438-.875 5.188t-2.031 4.5-2.031 1.75q-1.063 0-2.219-1.375t-2.063-3.281-1.469-4.063-.563-3.719q0-1.375.563-1.813t2-.438z',
		'w' => .845703125,
		'vw' => 27
	    ),
	    'amazon-pay' => array(
		'p' => 'M0 20.313q.188-.375.625-.125 1.75.938 1.938 1 3.75 1.875 7.938 2.938 2.063.438 4 .75 2.938.375 5.875.313 1.563-.063 3.313-.25 5.313-.625 10#q#688.313-.125.563-.063.313.063.406.344t-.156.531q-.125.125-.563.438-2.688 1.875-6.25 3-2.313.75-4.688 1.125-1.813.25-3.313.25l-.188.063h-1.313l-.125-.063h-.688q-1.5-.063-3.188-.313-2.563-.438-5-1.313-5.063-1.813-9.125-5.438 0-.063-.25-.375v-.125zm9.875-16.25h.5l.625.125q1.938.375 2.75 2.313.563 1.25.5 3.063-.063 1.563-.625 2.75-.938 1.875-2.75 2#q#125.438-3.813-.938l-.125-.125v4.688q-.063.313-.313.313-.688.063-1.313 0-.313 0-.313-.313V4.877q0-.313.094-.406t.406-.094h.688q.438 0 .5.375 0 .188.063.563l.063.063q0-.063.094-.125l.188-.125.156-.063q1.063-#r#375-.938l.094-.031.156-.031zM6.938 6.688v5.25q0 .125.063.188 1.188.875 2.375.875 2.063.125 2.625-1.75.25-.813.25-1.938 0-1.188-.313-2.063-.5-1.5-2.063-1.625Q8.375 5.562 7 6.5q-.063.063-.063.188zM19.75 4.063h.75q.125 0 .25.031t.25.031h.188q.813.125 1.375.438 1 .625 1.188 1.938.063.313.063.813v6.75q-.063.313-.313.313h-1q-.313 0-.375-.313 0-.125-.125-.688l-.063.063q-1.188.938-2.563 1.156T17 14.251q-1.125-.625-1.313-2-.125-1.063.25-1.875.563-1.125 1.813-1.563.875-.313 2.125-.25.938.063 2 .313h.063V7.251q0-.625-.313-1.031t-1.063-.531q-1.063-#q#313.063-.313.063-1.5.375-.438.125-.438-.313v-.625q0-.375.375-.5.875-.313 1.063-.313.875-.25 1.813-.313h.188zm2.188 8V10.25q0-.125-.125-.125-.188-.063-.5-.094t-.563-.063-.5-.094q-.875-.063-1.5.125-.813.313-1.063 1-.188.625 0 1.219t.813.844q.438.188 1 .125 1.25-.125 2.375-.938.063-.063.063-.188zm16.25 8.062v1.063q0 .063-.031.313t-.094.375q-.438 2.063-1.563 3.5-.188.25-.75.813-.125.125-.313.188-.125 0-.219-.063t-.031-.188q0-.063.063-.188.75-1.875 1-2.813t.188-1.5q0-.5-.438-.625-.563-.125-.938-.188-.875-.063-2.125.063-.25 0-.75.063t-.688.125h-.188q-.188 0-.219-.125t.031-.25.25-.25q1-.688 2.5-.938 1.188-.25 2.438-.125.813.063 1.313.25.5.125.563.5zm-8.25-7.687l.063.125q0-.063.5-1.375.688-2 2.125-6.25.063-.063.094-.125t.031-.125q.125-.313.5-.313h1.25q.25 0 .188.25 0 .188-.063.375-3.563 9.063-4.438 11.188-.188.563-.563 1.188-.813 1.375-2.5 1.313-.375 0-1-.125-.5-.063-.5-.563v-.625l.313-.25h.5q.5.063.938-.063.688-.125 1-.813.063-.25.25-.719t.313-.656q.125-.375 0-.75Q27.376 10.312 25.251 5q-.125-.125-.125-.375-.063-.25.188-.25h1.438q.25 0 .375.313.375.938.375 1.063.375.938#r#125t.875 2.406.75 2.156z',
		'w' => 1.193359375,
		'vw' => 38
	    ),
	    'cc-amazon-pay' => array(
		'p' => 'M7.813 12.625V8.187q0-.125.063-.188 1.125-.75 2.375-.688 1.313.125 1.75 1.375.25.688.25 1.75 0 .938-.188 1.563-.5 1.625-2.25 1.5-.938 0-1.938-.688-.063-.125-.063-.188zm9.687.875q-.5-.188-.656-.688t-.031-1q.188-.625.875-.813.563-.188 1.313-.125.25 0 .688.094t.563.094.125.125v1.5l-.063.125q-.938.688-1.938.813-.5.063-.875-.125zM36 5v22q0 1.25-.875 2.125T33 30H3q-1.25 0-2.125-.875T0 27V5q0-1.25.875-2.125T3 2h30q1.25 0 2.125.875T36 5zM23 6.5q.063.188.125.313.25.563 1.375 3.344t1.75 4.281q.125.313 0 .625-.063.188-.219.563t-.281.625q-.25.5-.813.688-.375.063-.813.063l-.156-.031-.219-.031q-.25 0-.25.25v.5q0 .438.375.5.563.063.875.063 1.375.063 2.063-1.125.313-.5.5-.938 1.25-3.125 3.688-9.438l.125-.25q0-.25-.25-.25h-1q-.313 0-.438.25 0 .063-.031.125t-.031.125l-1.813 5.25q-.188.5-.438 1.125v-.125q-.375-.938-1.031-2.813t-1.031-2.813q-.125-.375-.313-.875-.125-.25-.375-.25h-1.188q-.188 0-.188.25zm-7.875 6.375q.188 1.125 1.125 1.688.875.438 2.031.25t2.094-.938l.063-.063q.125.438.125.563.063.25.25.25h.875q.25 0 .25-.25V8.687q0-.313-.063-.688-.125-1.063-1-1.563-.438-.25-1.125-.375-.063 0-.25-.031t-.313-.031h-.75q-.875.063-1.563.25-.125.063-.875.313-.313.063-.313.375V7.5q0 .313.375.25.875-.25 1.188-.313 1.125-.188 2-.063.563.063.875.438.25.313.25.813V10h-.063q-.875-.188-1.688-.25-1-.063-1.75.188-1.063.438-1.5 1.313-.375.688-.25 1.625zM6.188 6.688v11.125q0 .25.25.25h1.125q.25 0 .25-.25v-3.938l.125.063q1.375 1.188 3.188.813 1.5-.313 2.25-1.813.563-1 .563-2.313.063-1.5-.438-2.625-.688-1.625-2.25-1.938-.125 0-.375-.063h-.625l-.188.063q-1.063.125-2 .75L7.875 7q-.125.063-.188.125v-.063q0-.125-.031-.25t-.031-.188q-.063-.375-.438-.375h-.563q-.438 0-.438.438zm24.687 14.5q-.188-.063-.5.063-4.063 1.688-8.563 2.25-1.375.125-2.688#q#5.063-5-.25-1.688-.25-3.313-.625-3.563-.875-6.688-2.438-.125-.063-1.625-.875-.313-.188-.5.125v.125q.188.25.25.313 3.375 3 7.625 4.563 2 .688 4.188 1.063 1.313.188 2.625.313h1.938q1.375-.063 2.813-.25 2-.313 3.938-.938 2.938-.938 5#q#5.375-.25.5-.375.188-.188.125-.438t-.313-.313zM34 19.438q-.063-.25-.5-.438-.438-.125-1.063-.188-1.063-.063-2.063.125-1.25#q#125.813-.125.063-.188.188v.188l.188.125h.125l1.188-.188q1.125-.063 1.813 0 .313 0 .75.125.375.063.406.531t-.156 1.219q-.25.938-.875 2.375l-.063.125q0 .125.063.188t.188.063l.25-.125q.5-.5.625-.688.938-1.188 1.313-2.938.063-.188.125-.563v-.938z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'ethereum' => array(
		'p' => 'M19.5 16.313L10 22.126.5 16.313 10 0zM10 23.938l9.5-5.75L10 32.001.5 18.188z',
		'w' => .625,
		'vw' => 20
	    ),
	    'korvue' => array(
		'p' => 'M24.125 2.125q1.563 0 2.656 1.094t1.094 2.656V26.25q0 1.563-1.094 2.656T24.187 30H3.749q-1.563 0-2.656-1.094t-1.094-2.594V5.874q0-1.563 1.094-2.656t2.656-1.094h20.375zM5.438 7.563v8.25h11.75l5.063-8.25h-6.938l-3.875 7.25v-7.25h-6zm10.125 17h7.375l-5.5-8.188h-12v8.188h6v-7.125z',
		'w' => .87109375,
		'vw' => 28
	    ),
	    'elementor' => array(
		'p' => 'M26.625 2q.563 0 .969.406t.406.969v25.25q0 .563-.406.969t-.969.406H1.375q-.563 0-.969-.406T0 28.625V3.375q0-.563.406-.969T1.375 2h25.25zM10.25 22.25V9.75h-2.5v12.5h2.5zm10 0v-2.5h-7.5v2.5h7.5zm0-5v-2.5h-7.5v2.5h7.5zm0-5v-2.5h-7.5v2.5h7.5z'
	    ),
	    'youtube-square' => array(
		'p' => 'M11.688 12.625L17.626 16l-5.938 3.375v-6.75z#b#m-2.625 11q0-3.688-.5-5.5-.375-1.625-2-2-.75-.25-2.969-.375T15.812 8h-1.813q-7.125 0-8.875.5-1.625.375-2 2-.25.813-.375 2.188t-.125 2.375v.938q0 3.75.5 5.5.375 1.625 2 2 .75.25 2.969.375t4.094.125H14q7.125 0 8.875-.5 1.625-.438 2-2 .25-.75.375-2.125t.125-2.375v-1z'
	    ),
	    'flipboard' => array(
		'p' => 'M0 2h28v28H0V2zm22.375 11.188V7.625H5.625v16.75h5.563v-5.563h5.625v-5.625h5.563z'
	    ),
	    'hips' => array(
		'p' => 'M15.75 9.875v12.563q0 .188-.188.188h-2.563q-.188 0-.188-.188V9.875q0-.188.188-.188h2.563q.188 0 .188.188zm-6 .625q1.75 1.25 1.75 3.438v8.5q0 .188-.125.188h-1.75q-.375 0-.688-.281t-.313-.719v-7.688q.063-1.125-1.438-1.5l-1.438-.188q-.813 0-1.438.188t-.875.375-.375.531-.156.406-.031.188v8.5q0 .188-.125.188H.185q-.188 0-.188-.188V5q0-.125.188-.125h2.563q.125 0 .125.125v5.063q1.438-.688 3.125-.688 2.25 0 3.75 1.125zm29.938 6.875q.5 1.188.188 2.438-.563 2#q#813 2.875H37q-.875.25-2.25.25-1.563 0-3-.5-.938-.313-.938-1.313V19q0-.125.094-.156t.219.031q1.563 1.188 3.625 1.188 1.938 0 2.313-.875.313-.813-.813-1.313l-3.313-1.5q-2-.875-2.313-2.688-.375-1.938 1.375-3.375 1.313-.938 3.688-.938 1.75 0 3.438.625.125 0 .125.125v2.813q0 .313-.25.125-2.063-.813-3.406-.813t-1.844.438q-.313.188-.281.5t.406.5L37.5 15.25q1.563.688 2.188 2.125zm-16.188-8q2.875 0 4.844 1.969t1.969 4.813-2 4.813-4.813 1.969q-2.063 0-3.625-1.188v5.563q0 .188-.125.188h-2.563q-.188 0-.188-.188v-11.5q0-1.813.719-3.156t1.813-2.031 2.094-.969 1.875-.281zm0 10.688q1.625 0 2.75-1.156t1.125-2.781q0-1.063-.5-1.938t-1.406-1.406-1.969-.531q-1.625 0-2.75 1.156t-1.125 2.75 1.125 2.75 2.75 1.156zM14.25 4.5q.75 0 1.281.531t.531 1.281-.531 1.281-1.281.531-1.281-.531-.531-1.281.531-1.281T14.25 4.5z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'php' => array(
		'p' => 'M20 6.5q-7.875 0-13.406 2.844T1.063 16t5.531 6.656T20 25.5t13.406-2.844T38.937 16t-5.531-6.656T20 6.5zm0-1q5.438 0 10.031 1.406t7.281 3.813T40 16t-2.688 5.281-7.281 3.813T20 26.5 9.969 25.094t-7.281-3.813T0 16q0-1.438.719-2.813t2-2.5 3.125-2.125 4.063-1.656 4.781-1.031 5.313-.375zm-6.375 9.625q.063-.313.063-.594v-.5l-.156-.375-.25-.281-.344-.188-.406-.094-.531-.063-.563-.031h-1.313l-.875 4.438h1.406l.594-.031.594-.094.469-.156.469-.281.344-.406.313-.563.188-.781zm-7.562 6.75l2.063-10.5h4.438q2 0 2.875 1t.625 2.688-1.5 2.813q-.313.313-.625.531t-.719.344-.656.188-.844.094-.781.063-1 .031h-1l-.563 2.75H6.063zM17.688 8.563h2.313l-.563 2.813q.25 0 .813-.031t.844-.031.719.031.719.063.594.125.563.188.438.281q.125.188.25.313t.156.344.063.406 0 .563-.063.656-.156.875-.219 1.063-.25 1.313-.344 1.531h-2.313q.188-.938.5-2.375.438-2.125.469-2.594t-.156-.781q-.063-.063-.125-.094t-.156-.063-.219-.063-.281-.031h-2.156l-1.188 6h-2.313zm13.875 6.562q.063-.313.063-.594t-.031-.5-.156-.375-.219-.281-.344-.188-.406-.094-.531-.063-.563-.031h-1.313l-.875 4.438h1.531l.625-.063.625-.125.5-.25.5-.406.344-.594.25-.875zM24 21.875l2.063-10.5h4.438q2 0 2.875 1t.594 2.688-1.469 2.813q-.25.25-.563.438t-.531.344-.625.219-.594.125-.75.063-.75.031-.906.031h-.906l-.563 2.75H24z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'quinscape' => array(
		'p' => 'M18.875 29.688q.625.625.813.75-2.063.625-4.438.625-6.313 0-10.781-4.469T0 15.781 4.469 4.968 15.282.499t10.813 4.469 4.469 10.844q0 3.188-1.25 6.063-.125-.188-.688-.938.5-4.375-2.438-7.719t-7.375-3.344q-4.125 0-7.031 2.906t-2.906 7 2.906 7 7.031 2.906h.063zm0-.063zm4.875-10.5q2.563 0 4.375 1.813t1.813 4.375-1.813 4.375-4.375 1.813q-1.25 0-2.406-.5t-2-1.313-1.313-1.969-.469-2.406q0-2.563 1.813-4.375t4.375-1.813z',
		'w' => .955078125,
		'vw' => 31
	    ),
	    'readme' => array(
		'p' => 'M33 2.875q1.25.063 2.125.938T36 5.938v15.313q0 1.25-.875 2.125T33 24.251h-5.625q-4.563 0-6.5 1.094t-2.688 3.594q-.063.125-.188.125t-.188-.125q-.5-1.688-1.375-2.656t-2.781-1.5-5.031-.531H2.999q-1.25 0-2.125-.875t-.875-2.125V5.877q0-1.188.875-2.094t2.125-.906h8.75q2.25 0 4 1.438t2.25 3.625q.5-2.188 2.25-3.625t4-1.438h8.75zM15.125 19.5v-1.438q0-.188-.188-.188H4.874q-.188 0-.188.188V19.5q0 .188.188.188h10q.25 0 .25-.188zm0-3.812V14.25q0-.188-.188-.188H4.874q-.188 0-.188.188v1.438q0 .188.188.188h10q.25 0 .25-.188zm0-3.813v-1.438q0-.188-.188-.188H4.874q-.188 0-.188.188v1.438q0 .25.188.25h10q.25 0 .25-.25zM31.313 19.5v-1.438q0-.25-.188-.25h-10q-.25 0-.25.25V19.5q0 .188.25.188h10q.188 0 .188-.188zm0-3.812V14.25q0-.25-.188-.25h-10q-.25 0-.25.25v1.438q0 .188.25.188h10q.188 0 .188-.188zm0-3.813v-1.438q0-.188-.188-.188h-10q-.25 0-.25.188v1.438q0 .25.25.25h10q.188 0 .188-.25z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'java' => array(
		'p' => 'M17.188 19.563q-4.938 1.313-11.313.75-3.5-.313-3.313-1.063.063-.188.563-.438 1.25-.625 2.5-.906t1.938-.281h.625l-2.5.75q-1.875.813.438 1.125 2.563.313 7.688-.063l4.813-.688q-.813.375-1.438.813zm-5.313-2q-1.063-.938-1.75-1.625t-1.344-1.5-.906-1.5-.25-1.406.438-1.344q.688-1 2#q#25t2.656-2.125 1.844-2.438.25-3.375q.063.063.156.188t.313.594.313.938 0 1.25-.469 1.563-1.25 1.813-2.188 2.094q-1.5 1#q#156 2.25t-.469 2 .563 1.656 1.063 1.656 1 1.563zm7.125-11q-1.938 1.125-3.125 2.031t-1.719 1.531-.469 1.344.281 1.125.844 1.219q.125.188.188.313.5.75.469 1.438t-.438 1.25-.875.969-.906.656l-.375.25.188-.188.375-.5.375-.75.031-.906-.531-1.031q-3.875-4.438 2.438-7.563 1.625-.75 3.25-1.188zm-.375 16.875q4#q#188 3.563-4.375-.375-1.25-1.75-1.375-.25 0-.5.063l-.688.188q.125-.313.5-.438 2.125-.75 3.313.75 1.313 1.438-.313 3.188-1.375 1.375-4.25 2.188v-.063q.125-.063.125-.125zm2.938 3.875q1.688.75-.75 1.75-4.438 1.75-12.875 1.375-3.188-.188-6.313-.688Q-1 29.312.562 28.25q1.563-1.125 3.688-1.188.625 0 .875.188-.375 0-1.125.125-1.875.438-2 1 0 .188.375.313 2.5 1 8.906.938t9.281-.938q.875-.313 1.125-.625t.063-.5zM7.625 24.75l-.375.375q-.125.438 1.25.563 3.188.375 6.625-.25.688.438 1.75.813-4.25 1.875-8.688.813-2.25-.5-2.125-1.313.063-.563 1.563-1zm11.188 6.063q1.938-.375 3.156-.844t1.406-.719l.25-.25q-.188 1.813-4.906 2.531t-9.969.344q-3.25-.188-4.5-#r#5.5 6.781.469t7.781-.719zm-2.688-8.75q.5.5 1.313.813-5.563 1.625-10.25.688-2.25-.438-2.063-1.25.125-.563 1.688-1.063-1.313 1 .75 1.25 4.188.438 8.563-.438z',
		'w' => .736328125,
		'vw' => 24
	    ),
	    'pied-piper-hat' => array(
		'p' => 'M40 1.563q-1.438.938-2.5 1.844t-1.688 1.688-.969 1.313-.594 1.063-.25.594q-.188.313-.625 2.375t-.875 2.875q-.313.625-1.094 1.25t-1.906 1.25l-1.125.625q-.813.563-2.625 4-1.25-.063-2.438.063t-2.063.219-2.094.563-1.813.656-1.969.938-1.75.969-2.031 1.219-2.031 1.25l2.688-1.063q.875-.313 2.688-1.063t2.594-1.031 2.375-.719 2.813-.531 3.094-.063 4.063.344l.125.063q.438.25.188.625l-3.313 6q-.313.5-.875.375-2.563-.563-5.625-.438t-5.125.469-4.719.719-4.406.438q-2.063 0-3.594-.531T.5 28.88t-.5-.625.125-.125q2.375 0 6.438-.938 3.313-6.375 6.5-9.125t6.625-2.75q.188 0 .5.031t1.156.25 1.531.563 1.438 1.156 1.063 1.875l1.75-3.063.531-1.031 1.094-2.094 1.625-2.688 2.188-3q1.438-1.875 3-3.125t2.375-1.688 2.063-.938z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'creative-commons-by' => array(
		'p' => 'M19.688 12.125V18.5h-1.75V26h-4.813v-7.5h-1.813v-6.375q0-.375.313-.688t.688-.313h6.375q.375 0 .688.313t.313.688zm-6.375-3.937Q13.313 6 15.469 6t2.156 2.188q0 2.125-2.156 2.125t-2.156-2.125z#c#31T-.001 16q0-6.313 4.438-10.906T15.5.5zm0 2.813q-5.375 0-9.031 3.813t-3.656 8.875q0 5.188 3.719 8.938t8.969 3.75q3.25 0 6.156-1.563t4.719-4.5 1.813-6.625q0-5.313-3.688-9t-9-3.688z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'creative-commons-nc' => array(
		'p' => 'M15.5.5q6.563 0 11.031 4.469T31 16q0 6.688-4.625 11.094T15.5 31.5q-6.375 0-10.938-4.563T-.001 15.999q0-6.313 4.438-10.906T15.5.499zm-12 11.313q-.688 1.938-.688 4.188 0 5.188 3.75 8.906t8.938 3.719q1.563 0 3.031-.344t2.531-.875 2.031-1.281 1.563-1.344 1.125-1.313.656-.906.25-.438l-5.813-2.563Q20.499 21.125 19.28 22t-2.719 1v2.375h-1.813V23q-2.563 0-4.688-1.875L12.185 19q1.563 1.375 3.469 1.406t1.969-1.531q0-.625-.438-1-1.75-.75-13.688-6.063zm12-8.563q-6.625 0-10.625 5.813l5.938 2.688q.438-1.375 1.563-2.031t2.375-.719V6.563h1.813v2.438q2.125.063 3.875 1.375l-2 2.125q-2.188-1.563-3.938-.625-1 .5-.438 1.313 3 1.313 5#r#563l7.938 3.563q.375-1.625.375-3.313 0-5.375-3.688-9-3.688-3.75-9-3.75z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'creative-commons-nc-eu' => array(
		'p' => 'M15.5.5q6.563 0 11.031 4.469T31 16q0 2.688-.813 5.125t-2.313 4.313-3.438 3.25-4.25 2.094-4.688.719q-6.375 0-10.938-4.563T-.003 16q0-6.313 4.438-10.906T15.498.5zm0 28.188q2.063 0 3.938-.656t3.031-1.438 2.219-1.875 1.375-1.563.625-.969v-.063l-8-3.5H13q.75 3.125 4.25 3.125 1.688 0 2.938-.688l.625 2.875q-1.75 1-4.063 1-2.813 0-5.031-1.656T9 18.624H7.312v-1.875H8.75v-1.188H7.312v-1.875h.25l-4.063-1.813q-.688 1.938-.688 4.125 0 5.188 3.75 8.938t8.938 3.75zm-1-11.938zm4.813-1.187l8.5 3.75q.375-1.563.375-3.313 0-5.313-3.688-9t-9-3.688q-6.75 0-10.625 5.813l5.063 2.25q.438-.688.875-1.25 2.375-2.625 6-2.625 2.125 0 3.875.75l-.688 3q-1.5-.625-2.875-.625-2.063 0-3.25 1.375-.25.313-.5.875l1.75.813H19.5v1.875h-.188z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'creative-commons-nc-jp' => array(
		'p' => '#c#63T-.001 15.999q0-6.313 4.438-10.906T15.5.499zm0 28.188q6.75 0 11-6.188l-5.125-2.25v2.25h-4V26h-3.813v-3.5h-4v-2.438h4v-1.125l-.375-.75H9.562v-2.438h1.75l-7.938-3.5q-.563 1.75-.563 3.75 0 5.188 3.75 8.938t8.938 3.75zm5.5-8.625l-3.438-1.5-.188.375v1.125h3.625zm.375-3.188l6.313 2.813q.5-1.75.5-3.688 0-5.313-3.688-9t-9-3.688q-2 0-3.813.531t-3.125 1.5-2.25 1.938-1.625 2.156l5.063 2.25-1.688-3.188h4.125l2.5 5.375 1.438.625 2.688-6h4.125L19 15.749h2.375v1.125z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'creative-commons-nd' => array(
		'p' => '#c#31T-.001 16q0-6.313 4.438-10.906T15.5.5zm0 2.813q-5.375 0-9.031 3.813t-3.656 8.875q0 5.188 3.719 8.938t8.969 3.75q3.25 0 6.156-1.563t4.719-4.5 1.813-6.625q0-5.313-3.688-9t-9-3.688zm5.875 9v2.688h-11.25v-2.688h11.25zm0 5v2.625h-11.25v-2.625h11.25z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'creative-commons-pd' => array(
		'p' => '#d#0 28.125q2.313 0 4.469-.844t3.813-2.313 2.781-3.406q-.063-.063-13.625-6.063 0 1.063.344 2.063t1.125 1.719 1.906.719q1.313 0 2.25-1.063l2.25 2.75Q18.75 24 15.875 24q-1.25 0-2.438-.375t-2.406-1.219-1.969-2.469-.75-3.813q0-1.063.25-2.063l-4.938-2.188q-1.188 3-.594 6t2.188 5.375 4.344 3.875 5.938 1.5zm12.125-9.375h.063q.438-1.625.438-3.25 0-5.188-3.719-8.906t-8.906-3.719q-3.25 0-6.031 1.563T5.001 9.126l4.625 2.063q2.063-3.25 6.313-3.25 2.875 0 4.875 1.75l-2.5 2.563q-.875-1-2.375-.875t-2.313 1.625z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'creative-commons-pd-alt' => array(
		'p' => '#c#31T-.001 16q0-6.313 4.438-10.906T15.5.5zm0 28.188q3.25 0 6.156-1.563t4.719-4.5T28.188 16q0-5.313-3.688-9t-9-3.688q-5.375 0-9.031 3.813T2.813 16q0 5.188 3.719 8.938t8.969 3.75zm4.313-17.063q4.375 0 4.375 4.281t-4.375 4.281H16.5v-8.563h3.313zm.062 6.75q2.125 0 2.125-2.438 0-.938-.281-1.5t-.75-.75-.656-.219-.5-.031h-1.188v4.938h1.25zm-7.125-6.75q3.125 0 3.125 2.875 0 .375-.094.75t-.406.938-1.094.906-1.969.344h-1.688v2.75H8.499v-8.563h4.25zm-.312 4.188q.813 0 1.188-.656t0-1.281-1.25-.625h-1.75v2.563h1.813z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'creative-commons-remix' => array(
		'p' => '#c#31T-.001 16q0-6.313 4.438-10.906T15.5.5zm0 2.813q-5.375 0-9.031 3.813t-3.656 8.875q0 5.188 3.719 8.938t8.969 3.75q3.25 0 6.156-1.563t4.719-4.5 1.813-6.625q0-5.313-3.688-9t-9-3.688zM25.625 16.25l.313.188v4.375q-.188.063-1.188.5t-1.938.844-1.063.406q-.188 0-2-.75t-3.938-1.625-2.688-1.125l-4 1.688-3.938-1.75v-4l3.688-1.5V9.063l4.188-1.813 9.5 3.875V15zm-4.375 5.125v-2.75h-.063V18.5l-7.063-2.875v2.813l7.063 2.938h.063zm.438-3.625l2.5-1-2.313-1-2.438 1.063zM25 20.125v-2.688l-2.813 1.188v2.688z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'creative-commons-sa' => array(
		'p' => '#c#31T-.001 16q0-6.313 4.438-10.906T15.5.5zm0 2.813q-5.375 0-9.031 3.813t-3.656 8.875q0 5.188 3.719 8.938t8.969 3.75q3.25 0 6.156-1.563t4.719-4.5 1.813-6.625q0-5.313-3.688-9t-9-3.688zm-6.875 10.5q.25-1.813 1.094-3.125t1.969-1.875 2-.781 1.75-.219q2.188 0 3.844.844t2.5 2.188 1.219 2.688.375 2.719q0 2.063-.844 3.906t-2.719 3.094-4.5 1.25q-1.375 0-2.719-.469t-2.563-1.906T8.5 18.439h3.875q.188 2.875 3.438 2.875 1.375 0 2.5-1.25t1.125-3.938q0-1.438-.344-2.5t-.75-1.531-1.031-.719-.875-.281-.563-.031q-3.125 0-3.5 2.75H13.5l-3.063 3.063-3.063-3.063h1.25z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'creative-commons-sampling' => array(
		'p' => '#c#31T-.001 16q0-6.313 4.438-10.906T15.5.5zm0 2.813q-5.375 0-9.031 3.813t-3.656 8.875q0 5.188 3.719 8.938t8.969 3.75q3.25 0 6.156-1.563t4.719-4.5 1.813-6.625q0-5.313-3.688-9t-9-3.688zm.25 3.312q.25 0 .5.156t.25.531l.375 6.75.313-3.75q0-.625.656-.625t.656.625q0 .125.375 5.125l.375-4q.063-.625.625-.625.625 0 .625.563l.75 6.063.313-.813q.188-.438.688-.438h3.625v1.375h-3.188l-1.188 2.75q-.188.5-.688.438t-.563-.625l-.25-2-.5 5.75q-.063.625-.625.625-.625 0-.688-.625 0-.063-.375-4.813l-.313 4.5q-.125.563-.688.563t-.625-.563q0-.063-.375-5.5L15.435 24q0 .75-.656.75t-.656-.75l-.375-5.438q-.313 5.25-.313 5.313-.125.625-.688.625t-.625-.625l-.031-.031-.031-.094-.375-5.563-.313 3.563q-.063.563-.688.563-.5 0-.625-.563L9.371 17q-.25.5-.688.5h-3.25v-1.313h2.813l.875-1.75q.188-.438.656-.375t.594.563l.188 1.25.5-6.125q0-.25.188-.438t.5-.188q.625 0 .625.75l.313 4.313.438-5.75q0-.313.156-.469t.281-.188.188-.031.188.031.313.188.188.469l.313 5 .375-6.125q.063-.625.625-.688z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'creative-commons-sampling-plus' => array(
		'p' => '#c#31T-.001 16q0-6.313 4.438-10.906T15.5.5zm0 2.813q-5.375 0-9.031 3.813t-3.656 8.875q0 5.188 3.719 8.938t8.969 3.75q3.25 0 6.156-1.563t4.719-4.5 1.813-6.625q0-5.313-3.688-9t-9-3.688zm6.688 12.812h3.688v1.438h-3.188l-1.125 2.75q-.188.5-.75.406t-.625-.594L20 18.687l-.375 5.188q-.063.688-.75.688t-.75-.688l-.25-4-.313 3.625q-.063.688-.75.688t-.688-.688l-.313-4.5-.313 5.063q0 .688-.688.688t-.75-.688l-.313-4.563-.25 4.375q-.063.688-.75.688t-.75-.688L11.684 19l-.25 2.688q-.063.688-.719.688t-.719-.625l-.688-4.563q-.188.375-.625.375H5.495v-1.438h2.688l.875-1.75q.188-.438.719-.375t.656.625l.063.75.5-5.625q.063-.625.719-.625t.719.625l.25 3.563.375-5q0-.688.688-.688t.75.688l.25 4.188.313-5.25q.063-.688.75-.688t.688.688l.375 5.875.25-2.813q.063-.625.719-.656t.719.656l.313 4.313.313-3.188q0-.688.656-.688t.781.625l.688 5.813.25-.563q.125-.5.625-.5zm-4.875.375q.5 0 .5-.5t-.5-.5H16v-1.313q0-.5-.5-.5t-.5.5V15.5h-1.313q-.5 0-.5.5t.5.5H15v1.313q0 .5.5.5t.5-.5V16.5h1.313z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'creative-commons-share' => array(
		'p' => '#c#31T-.001 16q0-6.313 4.438-10.906T15.5.5zm0 2.813q-5.375 0-9.031 3.813t-3.656 8.875q0 5.188 3.719 8.938t8.969 3.75q3.25 0 6.156-1.563t4.719-4.5 1.813-6.625q0-5.313-3.688-9t-9-3.688zm6.313 8.25q.375 0 .625.25t.25.625v11.375q0 .375-.25.625t-.625.25h-8.438q-.313 0-.563-.25t-.25-.625v-3.375H9.187q-.188 0-.344-.063t-.281-.156-.188-.281-.063-.313V8.187q0-.688.75-.875h8.563q.188 0 .406.125t.313.313.094.438v3.375h3.375zM10 18.75h2.563v-6.313q0-.75.75-.875h3.438v-2.5h-6.75v9.688zm11-5.5h-6.75V23H21v-9.75z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'creative-commons-zero' => array(
		'p' => '#c#31T-.001 16q0-6.313 4.438-10.906T15.5.5zm0 2.813q-5.375 0-9.031 3.813t-3.656 8.875q0 5.188 3.719 8.938t8.969 3.75q3.25 0 6.156-1.563t4.719-4.5 1.813-6.625q0-5.313-3.688-9t-9-3.688zm0 3.75q1.813 0 3.125.813t2 2.156.969 2.813.281 3.156-.281 3.156-.969 2.813-2 2.156-3.125.813-3.125-.813-2-2.156-.969-2.813-.281-3.156.281-3.156.969-2.813 2-2.156 3.125-.813zm0 3.375q-2.75 0-2.75 5.563 0 1.25.125 2.125l3.375-6.25q.5-.813-.188-1.375-.313-.063-.563-.063zm2.563 2.875l-3.813 6.563q-.563.813-.063 1.25t1.313.438q2.75 0 2.75-5.563 0-1.563-#q#688z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'ebay' => array(
		'p' => 'M37.875 11.875H40L33.812 24h-2.25l1.75-3.375-3.813-7.25q.313.625.313 1.5V19q0 .938.063 1.625H28q-.063-.563-.063-1.25Q26.624 21 24.062 21q-1.813 0-2.813-.813t-1-2q0-.313.063-.563-.375 1.5-1.625 2.438T15.749 21q-2.438 0-3.688-1.563 0 .563-.063 1.188h-2q.125-1.375.125-2.063V7.999h2v5q1.25-1.5 3.625-1.5 1.875 0 3.313 1.25t1.438 3.5q0 .563-.125 1.063.625-2.063 4.813-2.188h2.625v-.25q0-2.063-2.563-2.063-2.063 0-2.188 1.375h-2.125q.25-2.688 4.438-2.688 3 0 4 1.625l-.688-1.25h2.313l3.438 6.813zm-22.656 7.75q1.406 0 2.281-.938t.875-2.438-.875-2.438-2.281-.938-2.25.938-.844 2.438.844 2.438 2.25.938zm12.594-3v-.188q-1.5 0-2.5.063-2.938.063-2.938 1.563 0 .438.219.781t.719.594 1.25.25q1.563 0 2.406-.813t.844-2.25zm-25.75.125q.063 1.688 1.344 2.438t2.625.375 1.719-1.438h2.063q-.188 1-.969 1.688t-1.688.938-1.969.25q-2.625 0-3.906-1.281T.001 16.376q0-2.25 1.313-3.563T5.189 11.5q2.25 0 3.594 1.188t1.344 3.563v.5H2.064zM8 15.438q-.063-1.625-1.469-2.313t-2.813-.031-1.656 2.344H8z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'keybase' => array(
		'p' => 'M11.063 26.938q0 .438-.313.781t-.781.344-.781-.344-.313-.781.313-.781.75-.344q.25 0 .469.094t.344.25.219.344.094.438zm5.812-1.125q.438 0 .781.313t.344.781-.344.813-.781.344-.781-.344-.344-.813.344-.781.781-.313zm8.875-2.25q0 3.688-1.375 6.438h-1.688q1.063-1.75 1.438-4.188t-.063-4.188q-.75 1.313-2.281 1.781t-3.094-.031q-2.125-.625-4.094-.688t-3.281.156-2.781.906-2.156 1.125-1.813 1.313q-.375.25-.5.375l1.188-3.688-2.5 2.625q.438 2.438 1.938 4.5H2.875q-.938-1.5-1.375-3.188L0 28.374V25.53l.031-1.313.125-1.406.219-1.281.313-1.406.469-1.281.656-1.375.906-1.219 1.156-1.313q1.875-1.938 4.313-2.938-.688-1.25-.5-2.875l-1.25-.063q-.813-.063-1.375-.688t-.563-1.5l.125-1.625q.063-.813.656-1.344t1.344-.531q.125 0 1.813.063.875.063 1.438.75.313-.5 1.5-2.188l1.313.75q-.938 1.938-.563 2.313.938 0 2 .313 1.938.688 2#r#5.875 2 .063 3.938 2.938.938 5.188 3.188 3.563 3.75 3.563 8.563zM8 7.625q.25-.875.813-1.813.063-.813-.5-.875-1.563-.063-1.625-.063-.5 0-.563.5L6 6.999q0 .5.5.563zM9.625 11.5q.5.813 1.375 1.25 0-1.125 1.094-1.625t2.219.563l.5.625q.938-.813 1.063-1.969T15.563 8.5q-.5-1.188-1.594-1.594T12.188 6.5q-1.063.063-1.5-.938-2.375 3.75-1.063 5.938zm5.188 4.25l-1.25 1.063q-.188.188-.063.375l.563.688q.188.188.438 0l1.188-1 .375.438q.25.313.563 0 .188-.188 0-.438-1.938-2.313-3.5-4.25-.25-.313-.5 0-.25.188-.063.438.063.063.656.781l.594.719-.563.5q-.313.25.063.563.188.188.375.063l.625-.5zm7.375 1.625q-1.813-2.5-4.563-3.75-.688-.313-1.438-.563-.25.25-.438.375l2 2.5q.5.563.438 1.344t-.688 1.219q-.813.688-1.813.313-.75.625-1.375.625-.875 0-1.375-.625l-.563-.688q-.625-.75-.313-1.688-.75-.875-.313-1.875-1.563-.25-2.625-1.313-1.625.563-3 1.656t-2.125 2.063-1.25 1.969q-1.125 2.25-1.25 5.625 2.875-3 7.125-7.563l-1.875 5.875q5.5-2.938 12.375-.938 2.375.75 3.5-.813t-.438-3.75zM6.938 6.688l.063-.938.938.063-.063.938z',
		'w' => .8046875,
		'vw' => 26
	    ),
	    'mastodon' => array(
		'p' => 'M26.125 11.188q.063 4.5-.563 7.625-.125.563-.531 1.156t-1.094 1.156-1.5 1-1.813.781-2 .469q-6.375.75-11.188-.438 0 .438.063.875.125 1.063.625 1.781t1.406 1.031 1.625.406 1.906.156q1.188 0 2.375-.156t1.813-.344l.625-.125.125 2.313q-1.75.938-4.938 1.125-3.125.125-6.438-.75-1.25-.313-2.219-.906t-1.656-1.531-1.188-1.813-.781-2.281-.469-2.375-.25-2.688-.063-2.625v-3.844q0-1.688.406-3.125t1-2.281 1.188-1.438.969-.781l.438-.25q2.875-1.313 9.031-1.313t9.094 1.313q.188.125.438.281t.938.781 1.219 1.438.969 2.25.438 3.125zM21.438 19v-6.938l-.094-1.406-.219-.969-.344-.906-.531-.719Q19.125 6.687 17 6.718t-3.25 1.719l-.688 1.25-.75-1.25q-1.063-1.625-3.188-1.688t-3.25 1.313q-.375.375-.563.719t-.344.906-.219.969-.063 1.406V19h2.938v-7.125q0-1.938 1.5-2.25 1.5-.375 2.188 1.188.313.688.313 1.5v3.938h2.875v-3.938q0-2.25 1.625-2.688 1.375-.375 2.125 1 .25.5.25 1.25V19h2.938z',
		'w' => .814453125,
		'vw' => 26
	    ),
	    'r-project' => array(
		'p' => 'M36.313 14.188q0 5.125-5.5 8.688l4.188 7.125h-7l-2.5-4.688q-2.063.563-4.375.813v3.875h-6.188v-3.875q-6.375-.75-10.656-4.125T.001 14.188q0-5.063 5.313-8.625T18.127 2q4.938 0 9.125 1.625t6.625 4.438 2.438 6.125zm-29.188.875q0 2.438 2.156 4.469t5.656 3.031v-13h12.781l.813.125 1.125.313 1.188.594 1.125.969.781 1.469.313 2.031q0 1.5-.563 2.656t-1.344 1.719-1.594.906-1.375.406l-.563.063q1.125.375 1.75.688.188.063.438.25 4.375-2.188 4.375-6.688 0-4.125-3.625-6.219t-9.625-2.094q-5.688 0-9.75 2.438t-4.063 5.875zm14.063 2.375q.5 0 1.281.031t1.188.031 1-.031.875-.125.594-.281.438-.531.125-.844q0-.375-.063-.625t-.219-.438-.313-.313-.5-.188-.625-.125-.75-.063h-.844l-1.031.031-1.156.031v3.438zM21.125 22v1.375q1.75 0 3.188-.188-.813-1.188-1.5-1.188h-1.688z',
		'w' => 1.134765625,
		'vw' => 36
	    ),
	    'researchgate' => array(
		'p' => 'M0 2h28v28H0V2zm16.375 20.875v-.438q-.813 0-1.688-.938-1.438-1.563-2.625-3.625 1.063-.25 1.75-1.125t.688-1.875q0-1.375-.969-2.125T11 11.999q-.125 0-2 .063t-2.438 0v.5q.125 0 .344.063t.281.063.25.063.219.125.125.156.094.219.031.344.031.469v6.813q0 .313-.031.5t-.031.313-.094.25-.156.188-.219.094-.219.063-.281.063-.344.031v.5h4.313v-.5q-.125 0-.406-.031t-.344-.063-.25-.063-.25-.094l-.156-.156-.125-.25-.031-.344v-3.375q.375.063 1.313.063 1.438 2.625 2.625 3.938.688.813 1.813 1t1.313-.125zm1.438-8.437q.5 0 .875-.063t.594-.313.375-.406.219-.594.063-.531v-1.156h-1.875V12h1.125q0 1.688-1.375 1.688-1.125 0-1.125-1.438v-1.688q0-.563.406-.906t.844-.344q.375 0 .688.188t.438.438l.125.188.625-.5q0-.125-.094-.281t-.594-.469-1.188-.313q-1.063 0-1.594.594t-.531 1.281v2q0 .875.5 1.438t1.5.563zm-7.25 2.812q-.625 0-1.25-.063v-4.313q.375-.063 1.375-.063 2.313 0 2.313 2.188 0 1-.656 1.625t-1.781.625z'
	    ),
	    'teamspeak' => array(
		'p' => 'M15.25 21.688q-.188 1.063-1.375 1.5-.688.25-3.875.063-1.813-.125-2.688-1.5-1.375-2.125-.938-4.625.25-1.125 1.063-1.531t1.813.156q1.75.813 4 2.875 2.188 2.063 2 3.063zM28.063 23q.688.5.75 2 0 1.438-.5 2.563t-.969 1.563-1.469 1.188q-2.5 1.938-8.875 1.688-3.25-.188-3.313-.625 0-.438 3.125-.625 2.75-.25 4.906-1.188t3.313-2.313 1.688-2.313.844-1.813q.125-.438.5-.125zm3.875-7.687q0 2.875-.063 3.25-.125.75-.625 1.344t-1.219.844-1.469.125q-.563-.188-.563-.938v-5.25Q27.811 7.5 21.561 4.063q-2.5-1.375-5.375-1.375t-5.313 1.156-4.281 3.375-2.344 5.094q-.188.688-.219 1.344t-.031 1.469v5.063q-.063.688-.75.688-1.438.063-2.344-.781t-.906-2.281v-1.313l.063-1.625q.188-1.5 1.563-2.125.313-.188.375-.5.563-3.063 2.438-5.75.25-.313.063-.563-.25-.375.188-.938 2.75-3.063 6.375-4.188 9-2.75 15.813 3.813l.063.063q.875.75.375 1.438-.063.063.125.313 1.938 2.625 2.5 5.875.063.25.375.375 1.625.813 1.625 2.625zM22 23.563l-3.25-.5q-.875-.25-1.344-.75t.094-1.375 2.625-1.688q.063 0 .313-.125 5.063-2 5.188.625.063 1.625-.969 2.781t-2.656 1.031z',
		'w' => .998046875
	    ),
	    'first-order-alt' => array(
		'p' => '#d#0 30.5q6.188 0 10.594-4.406T30.5 16 26.094 5.406 15.5 1 4.906 5.406.5 16t4.406 10.594T15.5 31zm0-28.75q5.688 0 9.719 4.031T29.25 16t-4.031 9.719T15.5 29.75t-9.719-4.031T1.75 16t4.031-9.719T15.5 2.25zm0 27q5.5 0 9.375-3.875T28.75 16t-3.875-9.375T15.5 2.75 6.125 6.625 2.25 16t3.875 9.375T15.5 29.25zm11.625-10.187q-.375 1.563-1.25 3l-4.625-2.25 3.813 3.438q-1 1.313-2.313 2.313l-3.438-3#r#25 4.625q-1.438.875-3 1.25l-1.75-4.875.313 5.188q-.813.125-1.625.125t-1.625-.125l.25-5.188-1.688 4.875q-1.625-.375-3.063-1.25l2.25-4.625-3.375 3.875q-1.375-1.063-2.375-2.375l3.875-3.438-4.625 2.25q-.875-1.438-1.25-3l4.813-1.75-5.125.313q-.125-.813-.125-1.625t.125-1.625l5.188.25-4.875-1.688q.375-1.625 1.25-3.063l4.625 2.25L5.937 8.75q1-1.375 2.313-2.375l3.438 3.875-2.25-4.625q1.438-.875 3-1.25l1.688 4.813-.25-5.125q.813-.125 1.625-.125t1.625.125l-.313 5.125 1.75-4.813q1.563.375 3 1.25l-2.25 4.625 3.438-3.875q1.313 1 2.313 2.375l-3.813 3.375 4.625-2.188q.813 1.375 1.25 3l-4.875 1.688 5.188-.25q.063.813.063 1.625t-.063 1.625l-5.125-.313z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'fulcrum' => array(
		'p' => 'M4.438 10.25L2.188 13 0 10.25l2#q#688zm3-10.25v13.188l-2.563 2#r#563 2.813v13.188l-1.25-12.375L3 16.002l3.188-3.625zm5 10.25l2#q#688 2.25 2.688-2.25 2.75zm-3.063 2.938V0l1.313 12.375L13.876 16l-3.188 3.625L9.375 32V18.812L12 15.999z',
		'w' => .525390625,
		'vw' => 17
	    ),
	    'galactic-republic' => array(
		'p' => 'M15.5 31.5q-6.438 0-10.969-4.531T0 16 4.531 5.031 15.5.5t10.969 4.531T31 16t-4.531 10.969T15.5 31.5zm0-29.937q-6 0-10.219 4.219T1.062 16.001 5.281 26.22 15.5 30.439t10.219-4.219 4.219-10.219-4.219-10.219T15.5 1.563zm1.75 1.312q3.5.5 6.313 2.625l-1.125 1.125q-.938-.75-2.469-1.375t-2.719-.813V2.874zm-3.5 0v1.563q-2.875.438-5.188 2.188L7.437 5.501q2.813-2.125 6.313-2.625zm.75 3.188h2v5.125q.875.188 1.688.75l3.688-3.688 1.375 1.375-3.688 3.688q.563.813.75 1.688h5.125v1.938h-5.125q-.188.938-.75 1.75l3.688 3.688-1.375 1.375-3.688-3.688q-.813.563-1.688.75v5.125h-2v-5.125q-.875-.25-1.688-.75l-3.688 3.688-1.375-1.375 3.688-3.688q-.563-.813-.75-1.688H5.562v-2h5.125q.188-.875.75-1.688L7.749 9.625 9.124 8.25l3.688 3.688q.75-.563 1.688-.75V6.063zM26 7.938q2.125 2#r#625 6.313h-1.563q-.125-.75-.438-1.75t-.781-1.906-.969-1.531zm-21 0l1.125 1.125q-1.75 2.313-2.188 5.188H2.374q.5-3.5 2.625-6.313zM2.375 17.75h1.563q.438 2.875 2.188 5.188l-1.125 1.125Q2.876 21.25 2.376 17.75zm24.688 0h1.563q-.5 3.5-2.625 6.313l-1.125-1.125q1.75-2.313 2.188-5.188zm-18.5 7.625q2.313 1.75 5.188 2.188v1.563q-3.5-.5-6.313-2.625zm13.875 0l1.125 1.125q-2#r#125-6.313 2.625v-1.563q2.875-.438 5#q#188z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'galactic-senate' => array(
		'p' => 'M15.625 2.063h.75v1.688q.625.938 1.063 4.688t.5 8.75q-1.188-1.625-1.188-3v-1.063q0-.5-.188-1-.063-.25-.125-.375-.188-.188-.438-.188t-.438.188q-.063.125-.125.375-.188.5-.125 1v1.063q0 1.375-1.25 3 .063-3.313.25-6.156t.531-4.75.781-2.531V2.064zM14 11.313q-.188 2.063-.25 4.5-2.375 1#q#875 3.75-.813.25-2.563.25-.75-.375-1.625-.375.188-1.375.75-2.625.688.375 1.344.375t.875-.344-.125-.906-1.031-1q.813-1.125 1.875-1.938.5.75 1.063 1.094t.938.125.344-.906-.469-1.438q.813-.375 1.75-.563zm4 0q.938.188 1.75.563-.438.75-.469 1.438t.344.906.938-.125 1.063-1.094q1.063.813 1.875 1.938-.688.438-1.031 1t-.125.906.875.344 1.344-.375q.563 1.25.75 2.625-.875 0-1.625.375-1.75 0-2.563-.25-.5-2.563-2.875-3.75-.063-2.375-.25-4.5zm-2 .562q.375 0 .375 1.25v1.063q0 1.938 1.906 3.938t3.969 2q2.5 0 3.688.031t3.156.469T32 21.939v.125q-.875 1.625-2.063 3-.625-1.063-2.438-1.813t-4.313-.75q-2.063.063-3.594.781t-2.094 1.781q-.75.188-1.5.188t-1.5-.188q-.375-.688-1.156-1.25t-1.969-.938T8.81 22.5q-2.5 0-4.313.75t-2.438 1.813q-1.188-1.375-2.063-3v-.125q.938-.875 2.906-1.313t3.156-.469 3.688-.031q2.063 0 3.969-2t1.906-3.938v-1.063q0-1.25.375-1.25zm0 6q-1.063 0-1.813.75t-.75 1.813.75 1.813 1.813.75 1.813-.75.75-1.813-.75-1.813-1.813-.75zm0 .5q.875 0 1.469.594t.594 1.469-.594 1.469-1.469.594-1.469-.594-.594-1.469.594-1.469T16 18.375zm0 .375q-.688 0-1.188.5t-.5 1.188.5 1.188 1.188.5 1.188-.5.5-1.188-.5-1.188-1.188-.5zm-7.187 4.188q1.688 0 3.063.625 1.438 1.813 3.063 2.063h.063q.5.063 1 .063t1-.063h.063q1.625-.25 3.063-2.063 1.375-.625 3.063-.625 1.25 0 1.875.125-.125 1.188-.438 1.813-.875-.25-1.688-.25-1.938.063-3.25 1.406t-1.688 3.281v.313q-1 .188-2 .188t-2-.188v-.313q-.375-1.938-1.688-3.281t-3.25-1.406q-.813 0-1.688.25-.313-.625-.438-1.813.625-.125 1.875-.125z'
	    ),
	    'jedi-order' => array(
		'p' => 'M24.875 23.375q.188-.125.5-.406t1.156-1.531T28 18.5q0 .25-.063.656t-.438 1.594-.906 2.281-1.625 2.438-2.469 2.281-3.563 1.625-4.813.75h-.25q-2.625-.063-4.781-.719t-3.563-1.688-2.469-2.25-1.625-2.438-.906-2.25-.406-1.656l-.125-.625q.688 1.688 1.438 2.906t1.25 1.594l.438.375q-1.25-1.563-1.969-3.219T.28 17.124t-.094-2.688.375-2.313.625-1.781.563-1.156l.25-.438q-.75 1.5-.781 3.156t.5 2.938 1.188 2.375 1.156 1.656l.563.563q-1.813-3-2.125-5.844t.594-4.781 2.094-3.438 2#q#188l1-.688q-1.688 1.25-2.25 2.938t-.125 3.188 1.094 2.844 1.281 2.156l.625.75q-1.063 2.063-1.406 3.938t-.063 3.281.938 2.625 1.5 2.031 1.563 1.406 1.281.844l.5.25q.063-1.063.125-5.313l-2.125 2.25 1.5-3-3.938-.563 3.938-.563-1.25-3.438 1.938 2.875q.5-18.875.5-19.188 0 .375.5 19.188l1.938-2.875-1.25 3.438 3.938.563-3.938.563 1.5 3q-1.875-2-2.125-2.25l.125 5.313q.375-.188 1-.531t2-1.656 2.156-2.844.719-4.031-1.563-5.313q.25-.313.656-.813t1.25-2.031 1.156-2.938-.219-3.125-2.219-2.969l.563.375 1.313 1.094 1.688 1.813 1.438 2.5.906 3.125-.281 3.719-1.875 4.313q.25-.188.594-.594t1.125-1.594 1.219-2.406.438-2.875-.75-3.219q.188.313.469.813t#r#125.625 3.25-.625 3.938-2.406 4.5z'
	    ),
	    'mandalorian' => array(
		'p' => 'M12.688 32q-.125-.438-.063-1.563.063-1.438.063-1.75.125-1.25.25-1.375v-.938l-.063-1.125v-1.313q-.063-1.188-.188-1.5-.063-.188-.063-.75v-.813q-.25-1.438-.25-2.063.063-.438.125-.625.313-.5.563-1.469t.313-1.281q.063-.438.25-.938.063-.188.094-.438t0-.406-.094-.156l-.125.188-.5.438q-.75.563-.813.813-.063.125-.063.281t.031.188.156.344q.125.438.063.938-.063.188-.125.5 0 .188-.063.5-.063.25-.125.313t-.125-.031-.094-.313-.156-.719q-.313-.938-.063-1.313.125-.25.125-.313 0-.188-.5-.625t-.625-.688q-.188-.313-.313-.125-.125.25-.188 1.375v.75l.125.188q.563.625.875 1.188.25.563.25 1.5 0 1.313.125 1.563.063.063.031.094t.063.281.125.563.156.625q.125.75.125 1.25 0 .375-.063 1.063-.125 3.563-.125 3.875v1.313q-.063 1.625-.188 1.75-.063.125-.75-.563-.25-.25-.188-.625T10.871 28q.063-.563.063-.75.063-.938#q#188.063-1 .094-1.125t.094-1.188v-1.063l-.125-.25q-.125-.313-.813-1l-.813-.813-.125-.188v-.688q.063-.75.063-1.969t-.063-1.719v-.563l-.25-.25q-.25-.375-.313-.656t-.063-1.469q0-.688-.063-.75-.063-.125-.5-.188-.625 0-1.5-.875l-.844-.844-.031-.594.063-.313-.125-.188q-.063-.188-.125-.25-.313-.313-.375-.813-.063-.188.063-.25.188-.25.25-.688.313-1.438.688-1.813.125-.188.313-.094t.25.406q.125.375 0 1.125-.063.438-.063.719t.188.469q.25.375.938.625.188.125.25.188 1.063 1 1.438 1.063.5.063.625.813.188.75.375.75.063 0 .188-.094t.125-.281q0-.563-.125-1.125v-.313q-.063-.125-.063-.375-.25-.938-.313-1-.188-.25-.313-1-.125-.813-.75-1.063-.438-.188-.875-.5-.063-.063-.375-.313-.25-.188-.281-.219l-.156-.156q-.563-.313-.75-.75l-.125-.313v-.813l-.063-.813.438-.375q.438-.438.688-.563t.688-.125q.625 0 .75.125.063.063.063.25t-.094.281-.094.156-.313.563q-.125.125-.125.375.313.25.75.438.313.188.344.313t-.156.813q-.063.188-.063.25l.688.188q.438-1.25.563-1.625 0-.313-.438-.375t-.563-.188q-.125-.313.375-1.188.25-.375.563-.25.125 0 .469-.094t.469-.094.375-.094.406-.031.375.094.375.125.313.125.406-.094l.313-.188h.625q.688 0 1-.188l.25-.125.188.063q.125.125.281.406t.094.469 0 .406.125.344.063.25q.063.313-.125.438-.438.313-.438.563 0 .063-.063.188-.375.813-.938 1.063-.688.375-1 .375-.25 0-.281.063t-.25.219-.281.313-.156.188-.156.094-.438.344-.469.375-.156.094-.156.094-.063.281.094.375q.125.375 0 .688-.125.25.063.563.188.25.063.563-.063.188-.063.563t.094.531.219.156q.125-.063.313-.75.063-.375.125-.531t.219-.281.5-.281.625-.344.594-.313q.563-.25.938-.75.563-.688.813-2.063.063-.313.188-.5t.188-.438q.063-.5.313-.688.313-.313.313.188v.5q-.063.375-.125.875v.438l.25.25.313.25v.563q0 .5.063.688v.125l-.375.375q-.75.75-1.063 1.375-.188.438-.25.5-.25.375-.563 1.25l-.125.5-.438.375q-.438.438-.563.5-.313.25-.313.625 0 .25.125.469t.156.313.094.156.063.594-.063.844q-.063.75-.25.75-.25 0-.313 1.313-.063.25-.094.563t-.094 1q-.063 1.063.125 1.438.313.563-.688 1.438l-.25.188v.375q.063.313.125.563.25 1 .25 2.313-.063 2.375.063 2.75 0 .188.031.406t.094.469.063 1.438v1.188l-.125.188q-.125.063-.344.281t-.438.344zm1.875-2.812q-.063-.063-.063-.938 0-1.438-.125-2.125-.063-.25-.063-1.063 0-1.438-.125-1.688-.188-.313-.188-1.313 0-.313.313-.563t.313-.063q.063.188.188.625.25 1 .25 1.375t-.125 1.125q-.063.5-.063 1.75.063 2-.125 2.563-.063.25-.188.313zm-4.469-2.344q-.031-.031-.094-.688t-.094-.688-.063-.406-.094-.563q-.188-1-.188-1.313 0-.125-.063-.5-.063-.25-.063-1t.063-.75q.125-.125.688.438l.313.375v.375q-.063.438-.063.938t-.031.719-.094 1.031q-.063 1.938-.125 2t-.094.031zM4.688 10.188q.375.25.688.469t.438.281.25.156.375.156q1.188.375 1.438 1.063-4.25 3.563-4.75 4.438-.875 1.688-.813 3.063t1.344 2.094 3.344.281q-.625 1.375-2.906 1.313T.877 21.877q-.875-1.313-.938-3.125t1.125-4.188 3.625-4.375zm13.125 11.187q2.688.313 3.625-1.438t-.688-4.188q-1.688-1.813-4-4.25.313-1.688 1.875-3.313 1.563 1.063 2.75 2.438t1.719 2.375.875 2.156.375 1.531.094.813q.063 1.563-.719 2.719t-1.875 1.594-2.25.344-1.781-.781z',
		'w' => .76171875,
		'vw' => 24
	    ),
	    'old-republic' => array(
		'p' => 'M14.75.625h1.375q.313 0 .688.063.125 0 .938.063.063.063.156.063t.188.031.156.031q.625.125 1.5.313 1.125.313 2.25.875 2.5 1.125 4.438 3.063t3.063 4.375l.094.188.156.25q.25.688.438 1.25.438 1.188.625 2.375 0 .313.063.563.063.375.063.75.063.563.063 1.563 0 .5-.031.906t-.094.656v.156l-.031.188-.031.156q-.125.75-.188 1-.375 1.75-1.125 3.313-1.5 3.125-4.188 5.313-1.625 1.375-3.563 2.188-.688.313-1.188.5-.563.125-.688.188-.688.188-1.25.313-.375.063-.875.125-.75.125-1 .125-.5.063-1.25.063t-1.25-.063q-.375 0-.625-.063h-.156l-.188-.031-.156-.031q-.688-.125-.813-.125l-.75-.188q-.688-.188-1.625-.5-1.063-.438-1.875-.875-.313-.188-.438-.25-1-.625-2-1.375-3.313-2.75-4.75-6.813-.313-.813-.5-1.688l-.188-1.125q0-.125-.031-.281t-.031-.219-.031-.188-.031-.281v-.219q-.063-.688-.063-1.813 0-.375.063-.625v-.219l.031-.219.031-.188v-.156l.031-.188.031-.156.125-.75q.313-1.625.938-3l.156-.313.094-.25q.75-1.625 1.875-2.938 1.875-2.375 4.563-3.938.813-.438 1.438-.688 1.438-.625 3.063-.938.063-.063.688-.125.063 0 .25-.031t.25-.031q.125-.063.375-.063h.25q.125 0 .5-.063zm.5 1.563q-.75 0-1.688.125-.625.063-1.375.25-1.313.313-2.5.938-1.063.438-1.938 1.063l-.75.563q-.5.375-.938.75 0 .063-.438.438-2.688 2.813-3.563 6.563-.188.813-.313 1.625-.063.75-.063 1.688 0 .75.063 1.313.063.5.188 1.313.188.75.25.875.563 2.188 1.875 4.125.75 1.188 1.875 2.25 1.5 1.438 3.438 2.438.813.375 1.375.563.688.25 1 .313 1.063.313 2.125.5h.563q1.313.125 2.563 0 .063 0 .375-.031t.5-.094q.563-.063.625-.125.625-.125.813-.188 2.5-.688 4.563-2.25 1.5-1.125 2.625-2.563.188-.25.625-.813.313-.438.563-1 .25-.438.438-.813.563-1.125.875-2.313.25-1.063.375-1.938.125-1.125.063-2.563 0-.125-.031-.406l-.031-.281q-.188-1.875-.875-3.5-.563-1.438-1.375-2.688-1.25-1.813-2.875-3.125-2.438-1.938-5.375-2.625-.688-.188-1.5-.313h-.438l-.25-.063q-.688-.063-1.438 0zM8.688 5.25q1.188-#r#75-1.313-.063.063-.281.188t-.344.188q-1.063.625-1.875 1.5-.688.75-1.063 1.563-.313.688-.438 1.375-.125.438-.063.875 0 1.25.688 2.438.5.938 1.375 1.75.125.063.469.344t.469.406l.438.438q.25.375.375.688v2q.063.125.063.25v2.188h-.188q-1 0-2-.438-.625-.313-1.063-.625-.563-.438-1-.875-.563-.688-1-1.5-.188-.375-.25-.375 0-.125-.063-.188t-.094-.156-.031-.156q-.375-.875-.5-1.938-.063-.625-.125-.813-.063-1.5.313-2.938.25-.813.5-1.5.625-1.313 1.688-2.375.563-.563 1.25-1zm11-1.312q.125.063.5.188.688.25 1.125.5 1.313.625 2.281 1.563t1.531 2.125q.25.5.25.563.625 1.375.688 2.938.063.313.063.875 0 1.063-.25 2.125-.25.813-.5 1.375-.375.688-.688 1.188-.688 1-1.625 1.688-1 .75-2.188.938-.313.063-.688.125-.25 0-.375-.063v-.375q0-.125.031-.344t.031-.344V15.69q.063-.188.25-.438.25-.5 1.063-1.125.563-.438.938-.875.75-.813 1.188-1.75.25-.625.375-1.125.063-.375.063-.875 0-.688-.25-1.438-.125-.438-.438-1-.375-.625-.875-1.25Q21.25 4.876 20 4.126l-.125-.063-.188-.125zm-6.313 3.687q.125-.125.188-.25-.063.125-.125.188-.313.375-.438.813t-.125.625q0 .313.063.5.063.688.5 1.313.25.313.438.438.063.063.375.188.438.25.563.375.25.188.25.563v14.063l.125.25q.063.188.156.281t.219.094q.125-.063.188-.188.125-.125.188-.313v-2.594l.031-.344.031-.375v-4.5q.063.375.063.688 0 .063.031.188t.031.25v.188l.031.281.031.313.031.25.031.281.063.25q.188 1.188.313 1.688t.25.875q.25.875.625 1.438.125.188.375.438h.063q.063.063.125 0 0-.063.063-.188.313-.625.813-1.438.063-.188.125-.25.125-.125.375-.25.313-.125.563-.125.375-.063 1.25.125.438.063.688.063h.688q.813-.063 1.563-.375.563-.25.938-.5 1.063-.625 1.875-1.688l.125-.125.125-.188q-.063.25-.25.625l-.313.5q-.5 1-1.063 1.75-.375.438-.875.875-.688.688-1.375.938-.813.375-1.625.25-.25-.063-.688-.188l-.5-.25q-.25-.125-.563-.375l.5.5q.5.438.875.688t.813.313q.063.063.25.063-.063.063-.25.188-.813.563-1.875 1-2 .875-4.125 1h-.875q-.688 0-.938-.063-1-.063-2.063-.313-1.063-.313-1.906-.688t-1.531-.813q-.313-.25-.375-.313.625-.063 1.188-.375.563-.25 1-.688.188-.188.375-.438-.375.25-.688.375-.375.188-.813.313-.5.125-1.125.063-.75-.125-1.438-.563-.313-.25-.75-.625-.75-.813-1.563-2.125-.25-.375-.688-1.188-.063-.063-.125-.188t-.125-.188q.125.063.219.156l.344.344q.938 1 1.813 1.563t1.563.688q.063 0 .281.031t.281.031h1.5q.125 0 .625-.063.188-.063.438-.063.375-.125.688 0 .438.188.75.625.188.25.375.563 0 .063.063.219t.125.281q.125.188.188.375l.188.188q.063-.063.125-.188.125-.188.313-.813.188-.688.313-1.25.125-.438.313-1.75 0-.125.031-.25t.031-.281v-.219q.125-1.563.188-2v-2.563q0-.5-.125-1.25-.063-.688-.188-1.125-.125-.625-.563-1.313-.375-.563-.75-.875-.375-.438-.813-.563-.063 0-.313-.063 0-.125.063-.5.188-.75.438-1.438.125-.313.313-.75.375-.625.813-1.125zm1.938.125l.063-.063v3.063h-.063q0-.125-.063-.375t-.125-.313v-.156l-.063-.156h-1.563v-.063q.063-.063.156-.094l.094-.031q.125 0 .344-.063t.344-.125q.188-.063.25-.063v-.125q-.063 0-.25-.063-.063-.063-.188-.094t-.219-.063-.219-.031q0-.063-.125-.094t-.188-.031v-.063h.938q.125-.063.344-.031t.281-.031h.031l.031-.063q0-.125.031-.281t.094-.313.063-.281zm.375-.062q.063 0 .063.063.063.063.094.313t.094.375q0 .063.031.156l.031.094q.063.063.25.031t.25-.031q.375.063.938.063h.125v.063q-.063 0-.25.063-.063 0-.063.063-.188 0-.75.188l-.063.063-.063.125q.125 0 .188.063.125 0 .438.094t.5.156q.063 0 .063.031v.094h-1.563q0 .063-.063.188v.125q-.063.125-.094.25t-.031.25-.063.188h-.063V7.693zM4.063 10.5l.188-.375q-.125.625-.188 1.438Q4 12.188 4 13.001q.125 2 .875 3.625.375.625.688 1.063.688.875 1.25 1.313.438.438.938.688l.625.313q.438.125 1 .313.063 0 .313.063t.375.063q.5.188.813.563.438.438.625 1.125.125.188.188.563v.188q-.688.25-1.25.375-.313.063-.813.063-.875 0-1.875-.313-.438-.188-.688-.313-.75-.375-1.438-.875l-.5-.5q-.813-.875-1.375-2.125-.25-.625-.375-1.063l-.188-.75q-.063-.125-.094-.313t-.031-.25L3 16.442q-.063-.5-.125-1.063.063-.75.125-1.125v-.406l.063-.156q.063-.625.188-1.063.313-1 .813-2.125zm22.75-.375q.063.063.188.313.25.625.375.875.75 1.813.813 3.688v.313q0 .75-.188 1.75-.125.438-.188.688-.438 1.5-1.125 2.625-.813 1.25-2 1.938-.563.375-1.125.563-.625.25-1.125.375-.625.063-1.25.063-.75-.063-1.438-.313-.063 0-.125-.063l-.25-.063q0-.063.063-.313.125-.563.375-1 .188-.5.563-.75.188-.188.5-.313.125-.063.75-.188.688-.188 1.313-.438.938-.438 1.688-1.188.25-.313.313-.313.375-.438.625-.75.625-.875 1.063-2.063.188-.688.25-1 0-.125.063-.563.125-.688.125-1.125 0-.813-.063-1.25-.063-.813-.188-1.5z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'phoenix-squadron' => array(
		'p' => 'M6 3.938Q10.625.375 16.313.5q2.688 0 5.438.938-2.5-.438-4.563-.125-4.125.5-7 3.688.188 0 1-.375 1.813-.75 3.563-.875 1.438-.188 3.75.125-2.25.375-2.75.563-3.375 1.125-5.375 3.938-1.438 2.063-1.563 4.188 0 1.938 1.25 2.75 1.125.688 2.375.438 1.25-.188 2.688-1 1.313-.75 2.063-1.5.125-.188.125-.813-.313-.063-.375 0-1.063.563-2.25.938-2.25.688-3.875.063 1.313.188 2.313-.313.5-.25.969-.563t.813-.563.875-.688.781-.625q2.688-2.063 5.563-3.5 3.063-1.375 5.125-1.5-2.75 2.438-2.938 2.625-1 1-2.5 2.813-.063.125-.875.625-2.125 1.5-3.25 3.75-.938 2.125-.75 4 .25 1.563 1.313 2.188 1.063.688 2.75.313 3.063-.688 5.063-3.5 2-2.625 1.875-6-.063-.063-.094-.594t-.031-.844q.875 2.25 1.063 3.813.125 1.125-.125 2.688-.063.375-.25 1.063t-.25 1q1.938-2.188 2.5-5.125.5-3.375-.938-6.5 1.938 2.875 2.25 6.688.063 1.25 0 2.438-.25 3.25-1.875 6.125-2.5 4.563-7.313 6.75-3.688 1.688-7.906 1.469t-7.656-2.406q-3.75-2.313-5.75-6.188Q.191 20.13.003 17.067v-1.938q.188-3.25 1.781-6.219t4.219-4.969zm13.938 5q.375-.063 1-.25.563-.188.625-.688-1.188.625-1.625.938z',
		'w' => 1.001953125
	    ),
	    'sith' => array(
		'p' => 'M0 2l7.438 4.375-.75-3.688 5.688 4.375q.813-.188 1.625-.188t1.625.188l5.688-4.375-.75 3.688L28.002 2l-4.375 7.438 3.688-.75-4.375 5.688q.313 1.625 0 3.25l4.375 5.688-3.688-.75 4.375 7.438-7.438-4.375.75 3.688-5.688-4.375q-1.625.313-3.25 0l-5.688 4.375.75-3.688L0 30.002l4.375-7.438-3.688.75 4.375-5.688q-.188-.813-.188-1.625t.188-1.625L.687 8.688l3.688.75zm13.969 6.25q-3.219 0-5.469 2.25t-2.25 5.469 2.281 5.5T14 23.75t5.469-2.281T21.75 16t-2.281-5.469-5.5-2.281zM14 10.5q2.25 0 3.875 1.625T19.5 16t-1.625 3.875T14 21.5t-3.875-1.625T8.5 16t1.625-3.875T14 10.5z'
	    ),
	    'trade-federation' => array(
		'p' => 'M15.5.563q6.438 0 10.969 4.531T31 16.063t-4.531 10.969T15.5 31.563 4.531 27.032 0 16.063 4.531 5.094 15.5.563zm0 30.187q6.063 0 10.375-4.313t4.313-10.375-4.313-10.375T15.5 1.374 5.125 5.687.812 16.062t4.313 10.375T15.5 30.75zm9.688-20.562h-9.125v2.188h5.25v2.938h-5.25v12.25h-3V15.251H5.688l-2.313-2.875h9.688V7.251h12.125v2.938zM20.625 13h-5.188V9.5H24.5V8H13.75v5h-9L6 14.5h7.75v12.375h1.688V14.5h5.188V13zM10.5 8.688l1.375-.563-.938 1.125.938 1.125-1.375-.563-.75 1.25.125-1.5-1.438-.313 1.438-.375-.125-1.5zM8.688 7.5l.563.625-.813-.375L8 8.563l.063-.938-.875-.188.875-.25L8 6.374l.5.75.75-.375zM19 16.563l-.563.688.563.625-.813-.313-.438.75.063-.875-.875-.188.875-.25-.063-.875.438.75zm6.688-4.813l-.938 1.063.938 1.063-1.313-.563-.688 1.25.063-1.438-1.375-.313 1.375-.313-.125-1.438.75 1.25zM15.5 1.875q5.875 0 10.031 4.156t4.156 10.031-4.156 10.031T15.5 30.249 5.469 26.093 1.313 16.062 5.469 6.031 15.5 1.875zm5.938 10.375h-5.25v-1.938h9.125V7.124H12.938v5.125H3.125l2.5 3.125h7.313v12.313h3.25v-12.25h5.25v-3.188zM15.5 2.688q-4.375 0-7.875 2.563t-4.813 6.625h9.813V6.751h12.5Q21.187 2.688 15.5 2.688zm0 26.687q5.5 0 9.406-3.906t3.906-9.406q0-4.813-3.063-8.563v3.188h-9.125v1.188h5.25v3.938h-5.25v12.25h-4V15.751H5.436l-2.75-3.5q-.563 1.813-.563 3.813 0 5.5 3.938 9.406t9.438 3.906zm-4.312-12.187l1.438-.563-1.063 1.063.938 1.188-1.313-.688-.813 1.313.25-1.5-1.5-.375 1.5-.25-.125-1.5z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'wolf-pack-battalion' => array(
		'p' => 'M15 29.5l-.75 1.313-.688-1.313-.688.938-.313-.75-.313.438v1.875q-.375-.125-.656-.594t-.438-1.219-.219-1.406-.156-1.563-.156-1.281q0-.188-.094-1.125t-.188-1.438-.438-1.5-.813-1.75-1.375-1.719-2.156-1.781q.938-2.5.188-5-1.063.125-1.719.344t-1.313.969-.969 2.063l1.938.5q-1.188 2.375-.875 4.5l1.75-.438.375 2.125 1.125-.438.563 2.063 1.188-.438-1.625 1.313-.563-1.75-1.5.313-.5-2.188-1.625.875q0-.188-.063-1.063t-.063-1.438.156-1.375.531-1.375L.933 16.5q-.25-1.25.438-3.563l-1.375.625q0-1.25 1.219-2.406t2.656-1.281q1.063-.063 2.281-1.063t1.094-2.188q-.063-.438-.281-.906t-.531-.906-.813-.781-1.063-.469q1.25 1 1.281 2.063t-.5 1.656-1.156.844q-.188-.5-.375-1.531t-.156-2.938T4.183 0q5.563 3.125 5.875 9.25l3.625 2.438.188 5.813-6.688-3.75-.438.438 1.063.25 2.75 2.375 1-.313 1.75 3.063.25 7.5-1.313 1 2 1 2.063-1-1.313-1 .188-7.5 1.75-3.063 1 .313 2.75-2.375 1.125-.25-.438-.438-6.75 3.75.25-5.813 3.625-2.438q.25-6.125 5.813-9.25.5 1.75.531 3.656t-.125 2.938-.406 1.531q-.625-.25-1.156-.844t-.469-1.656 1.313-2.063q-.563.125-1.063.469t-.844.781-.531.906-.25.906.094.844.438.75.625.656.75.531.781.344.688.125q1.438.125 2.625 1.281t1.25 2.406l-1.438-.625q.75 2.313.5 3.563l-1.625-.313q.313.563.469 1.375t.156 1.375-.031 1.438-.094 1.063l-1.625-.875-.438 2.188-1.563-.313-.5 1.75-1.688-1.313 1.25.438.5-2.063 1.188.438.375-2.125 1.688.438q.313-2.125-.813-4.5l1.875-.5q-.375-1.875-1.344-2.531t-2.594-.844q-.75 2.5.188 5-1.25.813-2.156 1.781t-1.406 1.719-.813 1.75-.406 1.5-.188 1.438-.156 1.125q-.063.375-.125 1.281t-.156 1.563-.25 1.406-.406 1.219-.625.594v-1.875l-.313-.438-.375.75zm4.938-5.937l-1-.688q.625-.375 1.188-.75-.063 1.063-.188 1.438zm1.75-3.125q-.063 1.25-.125 2-.938-.25-1.313-.438.5-.5 1.438-1.563zm1.562.375l-1.5-.438q.563-.688 1.125-1.688.375.938.375 2.125zm.188-5.063q1.625 1.063 1.875 3.5-1.563-.625-2.313-.688.438-.938.438-2.813zm-.125-2.875q2.063.25 2.875 1.75-2.438.75-2.75.875 0-.625-.125-2.625zM8.625 23.563q-.125-.375-.25-1.438.563.375 1.25.75zm-1.75-3.125q.875 1.063 1.375 1.563-.313.188-1.313.438-.063-.75-.063-2zm-1.562.375q0-1.188.313-2.125.625 1 1.188 1.688zm-.25-5.063q.063 1.875.438 2.813-.688.063-2.313.688.25-2.438 1.875-3.5zm.125-2.875q-.125 2-.125 2.625-.313-.125-2.75-.875.875-1.5 2.875-1.75z',
		'w' => .890625,
		'vw' => 29
	    ),
	    'hornbill' => array(
		'p' => 'M4.688 23.125q.25 1.75-1.313 2.5-.875.375-1.781.063T.25 24.5t-.125-1.813 1.188-1.375q.688-.313 1.375-.188-1.375-1.938-1.531-3.875t.594-3.344 1.656-2.5 1.719-1.656l.813-.563-.5 5.75q-1 .563-1.438 1.156t-.313 1.031.5.813 1.094.688 1.344.5 1.313.313q.938 2.563 3.188 4.156t5.063 1.594h.313v1.188Q9.19 26.5 4.69 23.125zm6.75-20.437q1.938-1.313 3.844-1.438t3.281.594 2.469 1.688 1.625 1.719.531.813L17.5 5.501q-.688-1-1.25-1.438t-1.031-.281-.844.594-.688 1.188-.5 1.375-.313 1.375q-2.438 1-3.969 3.188T7.374 16.44v.188H5.999Q5.936 9.19 9.312 4.753q-1.625.125-2.313-1.375-.438-.875-.125-1.781T8.062.253 9.875.128t1.375 1.188q.313.625.188 1.375zM30.5 11.063q-.563.25-1.25.188 1.5 2 1.719 3.969t-.5 3.406-1.656 2.563-1.75 1.688l-.875.563.563-5.688q1.125-.75 1.531-1.406t.125-1.125-1-.906-1.469-.688-1.625-.438q-1-2.438-3.219-4t-4.906-1.563q-.063 0-.563.063V6.251q7-.063 11.5 3-.125-.75.219-1.438t1.094-1.063q.875-.375 1.781-.063t1.344 1.188.125 1.813-1.188 1.375zM23.313 27.25q1.5 0 2.188 1.375.375.875.063 1.781t-1.188 1.344-1.813.125-1.375-1.188Q21 30.249 21 29.812q-1.125.75-2.281 1.156t-2.094.438-1.875-.219-1.688-.688-1.406-.938-1.125-1.031-.844-.969-.563-.688l-.125-.25 5.688.5q.75 1.188 1.406 1.563t1.125.094.906-1.031.656-1.5.469-1.625q2.5-.938 4.094-3.188t1.594-5v-.375h1.188q.125 6.813-2.813 11.188z',
		'w' => .994140625
	    ),
	    'mailchimp' => array(
		'p' => 'M13.938 4.563q-.313.188-.438.25l-.188-.75zM6.313 19.625q0 .063.25.188t.438.281.25.469q.063.5-.25.875t-.75.375q-.188 0-.344-.063t-.219-.125-.031-.094.156-.031q.813.125.938-.563v-.313q0-.188-.313-.406t-.375-.281q-.375-.375-.063-.75.25-.188.438-.063 0 .063-.125.125t-.125.25zm.25-.625q-.375-.625-1.25-.438l-.125.063h-.063q-.063.063-.125.063-.375.313-.438.313-.313.438-.313 1.125 0 .313.125.625.063.125 0 .188-.125.063-.25-.125-.25-.25-.313-.625-.313-1.563 1.063-2.063.063-.063.188-.063.313-.125.75-.063.563.063.875.5.313.313.313.625-.063.25-.188.25 0 .063-.063 0l-.031-.125-.156-.25zm6.062-14.687l-.375-.125-.125-.438.188-.563zM13.25 5q-.063.063-.438.313l-.813-.688zM19 16.625q-.375-.25-.25-.563.188-.313.563-.063t.219.531-.531.094zm-2.375-.125q-.625-.063-1.125.188-.25.063-.313.063-.063-.063.125-.313.188-.125.438-.188 0-.063.063-.063t.188-.063q.25 0 .5.063t.344.156.063.125-.281.031zm10.063 3.75q.125.375.031.781t-.219.719l-.188.25q-.063.25-.156.594t-.5 1.188-.875 1.563-1.313 1.625-1.844 1.531-2.438 1.063-3.063.438q-1.938 0-3.719-.625t-2.938-1.531-2-1.781-1.219-1.5l-.438-.625q-.688 0-1.438-.25-1.5-.563-2#q#063t-.125-3l-1.125-.875q-1.25-.938-.813-3.188t2.031-4.563 3.656-4.469 4.125-2.969 3.375.063l1.063.875q2.438-1.5 4.375-1.5 1.438 0 2.188.813.813.938.563 2.531t-1.375 3.406q.438.5.75 1.188.75.563 1 1.75.063.375.125.938t.094 1.063.094.688q.438.188.688.375 1.063.5 1.688 1.125.813.188 1.094.906t-.219 1.344l-.188.188q.375.938.375 1.125.75.188 1.063.813zM1.25 16.75q.063.125.375.375t.563.438.313.188q.563-.813 1.313-1.25h-.063q.5-1.563 1.469-3.25t2.156-3.125 2.563-2.563l1.938-1.438-1.5-1.313-.125-.75 2.063 1.688q-.063 0-.156.094l-.094.094q-.313.25-.625.563l-.875.875q-.875.875-1.813 2-1.313 1.688-2.063 3.063 0 .063.906-1.031t2-2.344 1.469-1.625q.688-.688 1.75-1.531t1.719-1.313.719-.469q1.625-1 2.813-1.25-1.563.125-3.688 1.375l-1.5-1.313-.563.25q-1.563-.375-4.438 1.813t-4.875 5.438q-2.813 4.5-1.75 6.313zM5.563 23q1.313 0 2.156-1.063t.656-2.438q-.188.438-.375.625.063-.938-.25-1.938-.125.375-.25.813l-.125-.5-.125-.438-.125-.313-.156-.219-.219-.219h-.063q-.5-.25-1.125-.25-1.188 0-2 .875t-#r#094#r#094 2 .875zm3.5-10.5q1.313-1.688 3#q#938 2.188-1.438 4.344-1.781t2.844.344l-.063-.063q-.375-.813-1.438-1.125.188.188.313.438-.688-.5-1.563-.688l.063.063q.313.25.375.438-1-.375-1.875-.25l-.063.063h.125q.438.125.563.313-1.563-.25-2.625.375h.125q.625 0 .813.125-1.375.313-2 .813h.75q-1.188.688-2.156 1.656t-1.344 1.594zM25.5 21.625q.438-.5.344-.906t-.656-.406l-.375.063q0-.938-.438-1.688-.813.938-2.5 1.75-2.125 1-4.625 1.063h-.406l-.188.031-.156.094-.156.188-.094.25q-.063.063-.063.188.563.188 1.344.188t1.5-.125 1.313-.281 1.063-.313l.469-.156h.063q.063 0-.125.125t-.594.313-.938.375-1.313.313-1.531.125q-.688 0-1.188-.125.188.688 1.063.875l.813.125q1.688 0 3.469-.75t2.563-1.375 1.031-.875l-.063.063q-.5 1.125-2.625 2.313t-4.375 1.188q-1.5-.063-2.125-.813-.563-.688-.313-1.563t1.125-.938h.438q4.688-.125 7.438-3.438.188-.25 0-.5t-.563-.25h-.063q-.563-.688-1.75-1.25-.188-.063-.438-.188-.5-.25-.625-.813-.063-.313-.125-1.375l-.063-.438q-.188-1.688-.875-2.063-.188-.188-.5-.188-.063 0-.313.063-.375.063-.813.5-.375.313-.688.5t-.688.25-.625.094-.781 0-.781-.031q-1 0-1.781.625t-.906 1.688q-.188 1.125.063 1.875-.375-.25-.5-.5 0 .313.094.563t.219.469.281.406.281.313.25.219.188.156l.063.063h-.5q.688.563 1.25.688-.063.125-.281.344t-.531.656-.5.938q-.125.438-.188.969t-.063.844l.063.313.313-.438q-.188 1.063.188 2.125l.438-.875q-.063 1.125.5 2.063l.125-.75q.313 1 1.063 1.688.688.625 1.969.844t2.875-.188 2.906-1.406q.5-.375.875-.781t.625-.75.469-.688.344-.656.188-.531.094-.344zm-9.312.813zm.062.25zm3.938-6.875q0-.188.094-.281t.219-.094q.313.063.25.438 0 .188-.125.281t-.25.094q-.25-.063-.188-.438zm-3.625-.063q-.938-.375-2 0-.375.125-.438.125-.25 0 .25-.438.875-.688 1.875-.313.5.188.688.5.125.188.063.219t-.438-.094zm2.875-1.875q0-.5.25-.594t.531.406.281 1.125q-.438-.25-.938-.188-.063-.313-.125-.75z',
		'w' => .8359375,
		'vw' => 27
	    ),
	    'megaport' => array(
		'p' => 'M13.375 13.125L15.5 11l2.063 2.125v4.125L15.5 19.313l-2.125-2.063v-4.125z#d#9.063 25.875v-5.438l-3.688-3.688v-5.5l-3.75-3.75V3.311L15.5 2.123l-1.625 1.188v4.688l-3.75 3.75v5.5l-3.688 3.688v5.438l1.625 1.25 1.625-1.25v-4.063l2.063-2.063 2.125 2.063v4.063l1.625 1.25 1.625-1.25v-4.063l2.125-2.063 2.063 2.063v4.063l1.625 1.25z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'nimblr' => array(
		'p' => 'M14.531 18.688q.719 0 1.219.5t.5 1.188q0 .375-.125.688t-.375.531-.563.344-.625.125q-.75 0-1.25-.469t-.5-1.188.5-1.219 1.219-.5zm-8.343 1.687q0-.438.219-.844t.625-.625.875-.219.844.219.594.625.219.844q0 .75-.469 1.219t-1.188.469-1.219-.469-.5-1.219zm4.937-10.437q4.563 0 7.844 3.219t3.281 7.813-3.281 7.813-7.875 3.219-7.844-3.219T0 20.939V.001l2.813 14.188q1.313-2.063 3.813-3.156t4.5-1.094zm0 19.25q3.438 0 5.844-2.406t2.406-5.813-2.406-5.813-5.844-2.406-5.875 2.406-2.438 5#r#438 5.813 5.875 2.406z',
		'w' => .693359375,
		'vw' => 22
	    ),
	    'rev' => array(
		'p' => 'M16.938 17.188q0 1.688-1.219 2.875t-2.906 1#q#875-1.188-1#q#875 1#q#906 2.875-1.219 2.906 1.219 1.219 2.906zm8.687-.313V30H12.5q-5.188-.125-8.844-3.875T0 17.187q0-5.063 3.469-8.75t8.469-4.063V1.999l6.813 3.938-6.813 3.938v-2.5q-3.75.375-6.344 3.188T3 17.188q0 4.063 2.875 6.938t6.938 2.875 6.938-2.875 2.875-6.938q0-2.563-1.219-4.75t-3.281-3.5l2.875-1.625q4.5 3.75 4.625 9.563z',
		'w' => .80078125,
		'vw' => 26
	    ),
	    'shopware' => array(
		'p' => 'M24.75 28.438q-4.125 3.063-9.25 3.063-6.438 0-10.969-4.531T0 16.001 4.531 5.032 15.5.501q5.938 0 10.375 3.938.125.125.031.281t-.219.156q-1.688-.25-3.563-.25-6.25 0-10.063 2.531t-3.813 7.156q0 2 .688 3.625t1.594 2.656 2.625 2.063 2.875 1.531 3.281 1.313q4.063 1.563 5.438 2.625.063.063.063.156t-.063.156zm6.188-13.875q.313 3.688-1 7.063-.063.25-.313.125-1.813-1-5.813-2.5-1.063-.375-1.594-.594t-1.406-.594-1.344-.656-1.063-.688-.875-.781-.5-.875T16.811 14v-.063q-.063-2.063 2.313-2.938 1.125-.375 2.688-.375 4.5 0 9.063 3.813.063 0 .063.125z',
		'w' => .966796875,
		'vw' => 31
	    ),
	    'squarespace' => array(
		'p' => 'M11.625 21.438l9.813-9.813q1.813-1.813 4.375-1.813t4.375 1.813T32.001 16t-1.813 4.375l-7.438 7.438q-.938.938-2.219.938t-2.156-.938L28 18.188q.938-.938.938-2.188t-.906-2.156-2.188-.906-2.219.875l-9.813 9.813q-.438.5-1.094.5t-1.094-.469-.438-1.094.438-1.125zm15.281-6.532q.469.469.469 1.094t-.438 1.063l-9.875 9.875q-1.75 1.813-4.313 1.813t-4.375-1.813q-.5-.5-.5-1.125t.469-1.094 1.094-.469 1.125.5q.875.875 2.156.875t2.219-.875l9.813-9.813q.438-.5 1.063-.5t1.094.469zm-16.343 5.469q-1.813 1.813-4.375 1.813t-4.375-1.813T0 16t1.813-4.375l7.438-7.438q.938-.938 2.219-.938t2.156.938l-9.625 9.625q-.938.938-.938 2.188t.906 2.156 2.188.906 2.219-.875l9.813-9.813q.438-.438 1.094-.438t1.094.438.438 1.063-.438 1.125zm-5.469-3.281q-.469-.469-.469-1.094t.438-1.063l9.875-9.875q1.75-1.813 4.313-1.813t4.375 1.813q.438.5.438 1.125t-.438 1.094-1.063.469-1.125-.5q-.875-.875-2.156-.875t-2.219.875L7.25 17.063q-.438.5-1.063.5t-1.094-.469z'
	    ),
	    'themeco' => array(
		'p' => 'M12.5.75q1.063-.625 2.188 0l11.75 6.625q.5.25.813.813t.313 1.063v13.375q0 .563-.313 1.125t-.813.813l-11.75 6.688q-1.125.625-2.188 0L1.125 24.564q-.5-.25-.813-.813t-.313-1.125V9.251q0-.25.094-.531t.25-.531.344-.469.438-.344zM7.75 13.063h-3v6.25h1.188V17.5h1.813q1.438 0 2.031-1.125t0-2.219-2.031-1.094zm8.625 6.187l-1.938-2.125q.813-.188 1.25-.844t.375-1.375-.688-1.281-1.563-.563h-3v6.25h1.188v-2.063h1.125l1#r#063h1.438v-.063zm-2.562-5.062q.625 0 .906.5t0 1-.906.5H12v-2h1.813zm-5.938-.125q.625 0 .875.594t0 1.188-.875.594H5.937v-2.375h1.938zm11.875-1.125q-1.5 0-2.375 1.031t-.875 2.25.844 2.219 2.406 1q1.25 0 2.063-.656t1-1.625 0-1.906-1-1.625-2.063-.688zm0 1.062q1.313 0 1.844 1.094t0 2.188-1.844 1.094-1.844-1.094 0-2.188T19.75 14z',
		'w' => .861328125,
		'vw' => 28
	    ),
	    'weebly' => array(
		'p' => 'M26.563 4.125q2.375 0 3.906 1.469T32 9.313q0 .813-.313 1.813t-2.125 5.875q-.438 1.188-.719 1.906t-.75 2.063-.906 2.531q-1.625 4.375-5.813 4.375-3.813 0-5.375-3.375-1.563 3.375-5.375 3.375-4.188 0-5.813-4.313-.563-1.688-1.219-3.406t-1.031-2.781-.781-2.156-.625-1.719-.438-1.281-.313-1-.219-.688-.125-.594-.031-.469-.031-.531q0-2 1.594-3.406t3.906-1.406q1.875 0 3.281 1.094t1.906 2.906q.563-1.625 1.688-2.594t1.969-1.188 1.656-.219q.625 0 1.25.125t1.438.5T20.217 6t1.094 2.125q.5-1.813 1.938-2.906t3.313-1.094zm1.625 7.188q.5-1.5.5-1.75 0-.688-.313-1.188t-.844-.75-1.219-.25q-1.813 0-2.25 1.813l-2.75 8.75h-.063l-2.813-8.563q-.625-2-2.438-2t-2.438 2l-2.813 8.563h-.063l-2.75-8.75q-.438-1.813-2.25-1.813-1 0-1.688.531t-.688 1.281q0 .813.5 2.188l4.063 10.938q.875 2.313 2.875 2.313 2.063 0 2.75-2.125l2.438-7.313h.063l2.5 7.313q.625 2.125 2.75 2.125 2 0 2.875-2.313z'
	    ),
	    'wix' => array(
		'p' => 'M24.563 8.25v.125q0 .563-.031.906t-.469.875-1.25.844q-.313.063-.563.219t-.313.281l-.125.063q0-1.438.219-2.094t.844-.969q.188-.063.406-.125t.438-.094.438-.031h.406zm-7.188 2.188q.25-1.188 1.25-1.75t2.188-.438l-4.125 15.5q-1.313.063-2-.25-.75-.375-1.125-.906t-.75-2.031q-.188-.75-.656-2.656t-.844-3.438-.438-1.656q-.188-.688-.469-.688t-.469.688q-.063.125-.438 1.656t-.844 3.469-.656 2.625q-.375 1.5-.75 2.031t-1.125.906q-.313.125-.813.188t-.875.063h-.313l-4.125-15.5q1.188-.125 2.188.438t1.25 1.75l2.188 8.313 1.75-6.813q.375-1.563 1.063-2.281t1.969-.719 1.969.719 1.063 2.281l1.75 6.813zm7.188.312v10q0 1.375-.188 1.906t-.875.844q-.313.188-.719.25t-.719 0h-.25V13.094l.031-.281.094-.219.156-.219.219-.156.313-.156q.125-.063.344-.188t.406-.188.375-.188q.25-.125.469-.313t.281-.313zm10.25 5.313l5.188 7.688q-2.25.25-3.375-.688-.688-.625-3.313-4.438-.375-.625-.813 0-2.688 3.875-3.25 4.438-.5.438-1.344.594t-1.469.156l-.563-.063 5.188-7.688-5.188-7.75q2.188-.375 3.25.625.688.563 3.375 4.5.438.625.813 0 2.75-3.938 3.438-4.5.438-.438 1.25-.594t1.438-.094l.563.063z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'ello' => array(
		'p' => '#d#9 17.813q.125-.313-.063-.656t-.563-.406q-.375-.125-.688.063t-.375.563q-.688 2.438-2.719 4.031t-4.594 1.594-4.594-1.594-2.719-4.031q-.063-.375-.375-.531t-.688-.094q-.313.063-.5.375t-.125.688q.813 3.063 3.313 5.031t5.688 1.969 5.688-1.969 3.313-5.031z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'hackerrank' => array(
		'p' => 'M28.344 8Q29 9.188 29 16t-.656 8-6.563 4.594T14.5 32t-7.25-3.406T.687 24t-.688-8 .688-8T7.25 3.406 14.5 0t7.281 3.406T28.344 8zM18.25 25.875q.188 0 1.344-1.125t1.031-1.25q-.063-.125-1.125-.125 0-.5-.031-1.25t-.031-1.594V17l.125-6.813q0-.313-.313-.313h-2.063q-.25 0-.25.313Q17 12.5 17 15.437h-5q.125-6.438.125-6.625v-.188q1 0 1.063-.125.125-.125-1.031-1.25t-1.344-1.125q-.063 0-.219.125t-.406.313-.5.438l-.5.5-.438.469-.281.375-.094.156q.125.125 1.125.125v.188q.125 7.313 0 13.313 0 .375.313.375h1.938q.375 0 .375-.375-.125-1.688-.125-4.5h5q0 .063.031.156t.031.156q-.063 3-.063 5.438-1.063 0-1.125.094t.469.688 1.156 1.156.75.563z',
		'w' => .90625,
		'vw' => 29
	    ),
	    'kaggle' => array(
		'p' => 'M18.125 31.375l.125.438q-.063.188-.375.188h-4.188q-.375 0-.688-.313l-6.875-8.813-1.938 1.875v6.75q0 .5-.5.5H.498q-.5 0-.5-.5V.5q0-.5.5-.5h3.188q.5 0 .5.5v19.125l8.25-8.375q.313-.375.688-.375h4.313q.313 0 .406.281t-.094.406L8.999 20z',
		'w' => .568359375,
		'vw' => 18
	    ),
	    'markdown' => array(
		'p' => 'M37.125 3.688q1.188 0 2.031.844T40 6.563v18.875q0 1.188-.844 2.031t-2.031.844H2.875q-1.188 0-2.031-.844T0 25.438V6.563q0-1.188.844-2.031t2.031-.844h34.25zm-16 18.875V9.438h-3.813l-3.875 4.813-3.813-4.813H5.749v13.125h3.875v-7.5l3.875 4.813 3.813-4.813v7.5h3.813zm8.5.187l5.75-6.75H31.5V9.437h-3.813V16h-3.813z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'neos' => array(
		'p' => 'M24.188 32H18.25l-6.75-9.688v5.75L6.125 32H0V1.875L2.5 0h6.813l7.688 11V3.937l5.438-3.938h6.063v28.875zM.688 2.188v28.813l4.5-3.313V12.125l13.438 19.25h5.313l3.25-2.438h-4.875L2.564.812zm5.125 29.187l5-3.688v-6.313l-4.938-7.125v13.813l-4.563 3.313h4.5zM3.313.688l19.375 27.625h5.188V.688h-5v19.813L8.938.688H3.313zM17.688 12l4.5 6.375V1l-4.5 3.313v7.688z',
		'w' => .890625,
		'vw' => 29
	    ),
	    'zhihu' => array(
		'p' => 'M10.688 9.25h7.625v13.625H15.25L12.625 24.5l-.5-1.625h-1.438V9.25zm6.062 12.125V10.75h-4.563v10.625h.75l.313 1.125L15 21.375h1.75zM9.375 15.5q.188 0 .313.344t.125.719v.375H6q-.125 1.25-.5 2.563l.938-.75q.5.563 2.25 2.625.125.188.188.406t.094.469 0 .469l-.063.438-.063.375-.031.281v.063l-3.375-4.063q-.375 1.375-.938 2.438t-.938 1.5l-.375.375q-1.313 1.188-3.188.625 4-3.063 4.438-7.813H.312q.25-1.438 1-1.438h3.25q.125-1.438.125-4.625H2.874l-.313.938q-.688 1#q#313 1.375.375-.75.719-1.625t.563-1.438.406-1.125.25-.688q.188-.625.688-.969T3.812 7l.375-.063q-.5 1.313-#r#563h5.5q.313 0 .438.344t.125.719v.313H6.249q0 2.438-.125 4.625h3.25zm25.75-.125l-1.188-.875q1.875-2.5 2.25-3.063.125-.125.281-.188t.313-.031.344.063.313.125.25.156.188.125l.063.063q-1.5 2-2.813 3.625zm-9.375-3.687q.125.125.406.469t.594.75.563.781.438.625l.125.25-1.188.875-2.563-3.625q.125-.063.281-.156t.656-.188.688.219zM40 16.125q.063 1.5-.563 1.5h-7.625v4.563q0 .875-.313 1.531t-.938 1-1.563.344q-.813 0-1.625-.438-.75-.438-1.188-1.375.313.063.844.094t.938.031h.781q.688.063 1.125-.313t.438-1v-4.438h-6.75q-.625 0-1.031-.375t-.469-.688l-.125-.375h8.375v-6.25q-1.188 0-3.563#q#563.063-3.063-.063-.813-.25-1-1.25 1.875 0 5.5-.281t6.375-.531l2.688-.313 1.438-.25q.375.188.375.688t-.188.938l-.125.438q-1.75.125-5.5.313-1 .063-1.438.063v6.313h.125q6.938-.063 8.063-.063z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'alipay' => array(
		'p' => 'M23.625 2q1.813 0 3.094 1.281T28 6.375v14.688q-1.5-.5-4.625-1.625l-4.688-1.688q.625-1.25 1.25-2.656t.875-2.219l.25-.813h-5.5v-1.938h6.813V8.936h-6.813V5.748h-3.188v3.188H5.499v1.188h6.875v1.938h-5.75v1.063h11.125q-.625 1.875-1.688 3.75-5.063-1.563-7.938-1.563-3.625 0-5.031 1.469t-1.156 3.656q.188 1.813 1.625 3.281t4.438 1.469q2.813 0 5.219-1.406t4.031-3.656q4.688 2.125 10.75 5.5 0 1.188-.594 2.188t-1.594 1.594-2.188.594H4.373q-1.813 0-3.094-1.281t-1.281-3.094V6.376q0-1.813 1.281-3.094t3.094-1.281h19.25zM2.938 20.188q-.063-1.125 1.031-2.156t3.906-1.031q2.125 0 6.813 2-3.438 4.563-7.375 4.563-4.188 0-4.375-3.375z'
	    ),
	    'the-red-yeti' => array(
		'p' => 'M30.25 15.125q.313.375.438.813.438 1.125.563 2.125l-.125.063-.813-.938q-.563.875-1.063 1.563 0 3.813-1.906 6.875t-5.094 4.719-6.938 1.656q-5.75 0-9.875-3.75-4.063-3.813-4.063-9.438v-.125l-.063-.188-1.25 1.375q-.438-2#r#063-5 0-.063.031-.125l.031-.063-1.813-.063-.125-.25q.063-.063.438-.219t.656-.281.688-.25.719-.125q.688-1.375 1.75-2.5.063-.563.375-1.625l-.438.25-.125-.063.125-.563q1-2.438 2.875-4.188l-2.063-.875h.25q1.438-.375 3.063 0-.25-.438-.531-1.219t.031-1.594q.5.438.938 1.75.313-1.5 2.125-2.875h.125l-.75 2.813q2.875-1.688 6.125-.75l-1.219 1.219-.625.469-.844.375q1.75.5 2.188.938l-1.563-.438q1.375 1.25 1.563 1.563 2.313.125 4.25.813.25-.125.781-.438t.719-.375.625-.188.719-.031.75.281 1.094.563q0 .313-.031.594T25 7.843v.438l.031.094.031.094.063.094.125.125Q26 8 26.813 7.625q1.188-.563 1.938.375.5 0 .781.531t.344 1.156q.438.063.469.563t-.125.938-.219.438l-.438 1.125q1.438 1.438 2 2.813zm-5.625-8.187q-1.25-.813-1.75-.5.813.688.813 1.25.125.75-.625 1.375l-.25.25q.375.688.5 1.438h.188q-.125-.688-.125-.719t.125-.219q.875.5 1 1.25 1.438-.688 3.438-1.313l-1.125 1q1.625 0 2.875.5.25-1.25.188-1.25l-.313.688q-.188-1.063-.188-1.563-.063-.625-.625-.625 0 .563.125.938l-.125.375q-.313-1.125-.563-1.75-.188-.438-.563-.375t-.688.281-.75.5-.688.281q.75.063 1.688 0l-1.375.375.188.25q-1.063 0-1.375-1.063V6.937zm-2.437-.625l-1.313.75q1 .625 1.75 1.938.625-.25.75-.5.125-.125.188-.438.063-.125-.188-.688-.313-.438-1.188-1.063zM5.438 8.938q-.688 2.063-.813 4.688l.813.313.063-1.688q.625 1.063.813 1.75.625-.438 1.375-.688l.063.125-.438.688q.938-.375 1.75-.063l-.625.5q.188.063.469.188t.375.156.313.125.281.156.219.156.25.219.219.281.25.406l-.75-.125q.438.25 1.094.688t1.125.719 1.25.688 1.5.719 1.719.625 2.125.563q.875-1.375.875-1.438l.063-.063h-.063q-.063-.25-1.125-1.25.5.063.688.188l-1.063-1-.188-.188-.125-.063q1.563.625 2.063 1.75l.125-1.938L18.69 15l.438-.375h-.75l-.531.063-.625.156-.594.313-.563.469h-.188q.688-1.375 1-2.875.188-.938.188-1.75 0-1.813-.813-3.563-.625-1.25-1.875-2.188-.75-.563-1.313-.875-.125-.063-.313-.063-.438 0-1.25-.063v.188q-1 .125-1.563.938h-.063l-.375.188q-.125-.25.25-.563l.688-.688h-.188l.125-.188q-.125 0-.25-.031t-.188-.031v-.063l.125-.125q.063 0 .188.063h.25q.438-.188.875-.125l.188.063v.063q.625-.063 1.5-.188 1.875-.25 3-1.563l-1.313-.063q-2.438 0-4.438 1.188l-.188-.125.063-.313.063-.438q.25-1 .438-1.563-.125 0-.594.688t-.656 1.188q-.125.563-.313.938L8.25 1.874l.5 2.25v.063q-.5 0-1-.125-.375-.063-1.313-.063h-.188q.375.125 1.563.5l.375-.063-1.25 1.25q-.875.75-2.063 3.125l.25-.063.688-.625-.375.313.813-.75-.75 1.125zM22.75 29.563l.219-1.313.063-1.188-.063-.875-.125-1.094-.156-1.094q-1.875.625-2 .625l.688.938-.125.063q-1.063-.313-1.75-.938.313.938.688 1.313t1.188.625q-.688.688-2.125-.75l.125 1.438-.25.188q-.125-.625-.5-1.219t-.656-.906-.406-.313q-3.563 1.063-7.125-.688-.25.063-.563.125t-1.25.063-1.781-.156-1.969-.75-2-1.594q1.438 3.75 4.5 5.188-.438-.938-1.313-1.688.063-.188.063-.625 1.813 1.813 5.813 3.75-1.813-.688-2.688-1.063t-1.063-.469l-.563-.281 1 1.313q-.25.125-.625-.063-1.125-.625-2.188-1.563.125.188.313.375l.719.719 1.094.938 1.469 1 1.781.906 2.094.656 2.406.281 2.688-.25q-1-.438-1.719-1.125t-1.063-1.156-.781-1.25-.625-1.031l1.125.5-.75-1.5q1.125 1.563 2.375 2.813l-1.875-1.063q1.188 2.563 4 3.688l.125-.031.344-.094.594-.188 1.063-.438 1.563-.75zm7.188-13.375l.563.813-.75-2.063q.563 0 1.313.188-.813-1.063-1.688-2l-1.688-1.438.063-.188 1.5-.125q-.938-.25-2.063-.25h-1.125v-.188l.938-.813-2.625 1.25-.75-1.125.188 1-.188.063-.375-.313h-.625l.375.313v.125l-.875 1.688q-.25.875-.625 2t-#r#5-.75 2.375l.063-1-.063.188v.063q-.625 1.5-1.313 2.438l.563-1.375-2.938 1.313q1.125-1.25 2.188-1.188-2-.313-3.688-1t-2.313-1.156-.875-.719q.875 1.5 1 2.5l-.125.063q-.75-2.75-3.5-4.375l1.5.188q-.438-.563-1.344-.844t-1.219-.156l-.125-.188.5-.5-1.375.375.313-.875q-.375.25-1.063.563h-.125q.063-.063-.188-.625 0 .625-.063.75-.063.063-.188.125-1.188-.625-2.156-.719t-1.281 0-1.125.406q.25 0 .563.063t.5.094.344.063.25.031.188.031.125.031.094.031.094.063.094.063.125.094q-1 .5-1.344.719t-.813 1.063-1.031 2.594l1.375-1.375.188 1q.563 2.688 2.844 4.156t5.031 1.094L8 22.629l2.813 1.438-.125.188q.25.063.875.25 2.813.813 5.813.375l-2-1.313q.313.063.656.188t.625.25.531.281.469.344.344.313.313.344.25.281.188.25.125.25l-.438-1.813.063-.188 1.188 1.75-.563-1.688 1.375.875h.063l-.25-.25.438.25-.875-1 .063-.188.5.438q2.75-.75 5.063-2.5 2.688-2 4.5-5l-.25-.563h.188zm-.375-4.5l-1.125.125.875.688zm-15.938.437q.438.813 1.125 1.188-.375.625-1.063.938-.125.063-.188.063-.75.813-1.063.938l.438-.813q-.75.25-1.563.188l-.063-.125q1.813-.188 2.938-1-.375-.375-.563-1.375zm.25-6.375q.563.313.875.875 1.438 2.313.688 3-.75.75-1.625-.188-.875-1-.719-2.5t.781-1.188zm-.312 2.875q.375 1.125 1.188 1 .75-.063.5-1.25-.375-1.563-.969-2.063t-.656-.25q-.25.25-.25 1.563.5-.75.813-.313l-.063.063q-.063.188.125.375l.063-.063V8q-.125.938-.75.625zm-2.813-.312q-.25-.063-.313-.25-.188-.438-.031-.875t.531-.438q.188 0 .313.25-.063.063-.125.188t.188.188q0 .375-.125.625t-.25.281-.188.031zm2.5-3.125L13 5v-.125q1.375 0 1.75.875-.75-.375-1.625-.375v-.188h.125zM8.75 8.25q.125.125.313.438-.875.188-1.313.469t-.563.281q.5-1 1.5-1L8.249 8q.375-.063.719-.031t.531.406q0-.75.188-1.5Q9.812 6.187 10 6q.063-.063.313-.281t.688-.563.813-.531q.375-.25.813-.125.063.063.063.125l-.813.5q.688 1.063.563 2.563-.125 1.063-.938 1.75l.188.313q-.563-.063-.875-.125t-.563-.188-.375-.25-.438-.406-.688-.531zm1.188-1.125Q9.875 7.5 9.75 8.75l.313.375.438.188q.438.063.75.063l.375-.5q.5-.563.531-1.438t-.156-1.563q-.313-.75-.625-.563-.563.125-1 .688-.313.438-.438 1.125zm2.625 3.5l-.188.375q.688-.438 1.188-.5l.438-.063.75.5h-.125q-.875-.375-1.938.438-.063.438.375 1.875h.563q-2 .563-3.063.313-1.5-.438-1.688-1.5Q8.625 11 8.75 9.938q-.563.063-.938.688-.188-.438-.375-.625.938-.438 2.063-.25v.125l-.375.063v.5l.313.781.875.281q.188-.063 2.25-.875z',
		'w' => .986328125
	    ),
	    'acquisitions-incorporated' => array(
		'p' => 'M21.125 29.25q.063.25.219 1.219T21.563 32H.5q-.375 0-.313-.375Q.25 31 .5 29.187q0-.375.438-.375 7.125.063 7.625-.188.938-.375.938-1.438-.063-6.688-.063-8.063 0-.313-.25-.375-.438-.125-3-.75-.125.375-.469 1.125t-.469 1.125q.063.188 2.188.188v1.75H.25q.188-1.25.25-1.563 0-.188.313-.188.625-.063 1.625 0 .313 0 .438-.313.438-1 1.375-3.281t2.875-6.781q.25-.688.5-1.313t.438-1.031.344-.844.25-.625.219-.469.125-.344.063-.25.063-.219.031-.188-.031-.219q0-.75-.781-1.063t-1.594-.313H.44Q.127 1.557.096 1.026T.002.307q-.063-.313.313-.313h21.188q-.125.688-.125 1-.063.188-.156.844t-.094 1.031q-.063.25-.313.25H16.94q-2.75.063-3.5.125-.438.063-.75.281t-.438.594 0 .813q.438 1.313 2.313 5.563.813 1.938 2 4.75 1.563 3.75 1.969 4.438t1.281.75h1.25q.063.375.25 1.688h-7.25v-1.688h1.938l.188-.25-.344-.781-.469-1.156q-.188-.313-.563-.188-.875.25-2.313.563-.375.125-.375.5 0 .563.031 1.219t.031 1.25v5.594q.063 1.25 1.313 1.438.813.188 7.063.188.375 0 .469.031t.094.406zM10.25 16.375q.563.25 1.125 0 .375-.063.781-.188t.906-.281.75-.219q.063 0 .156-.063l.094-.063q-.938-2.563-1.188-3.188t-.563-1.625-.594-2-.531-1.563h-.625q-.75 1.938-3.188 8.25.313.188.375.188.438.125 1.313.406t1.188.344z',
		'w' => .673828125,
		'vw' => 22
	    ),
	    'critical-role' => array(
		'p' => 'M14.063 0q13.25 7.688 13.563 7.813.25.063.25.375v15.688q0 .25-.25.313-.563.375-3.781 2.188t-6.5 3.688-3.406 1.938h-.188Q.376 24.315.126 24.128q-.125-.063-.125-.188V8.127q0-.188.188-.313.625-.375 7-4t6.75-3.813h.125zm-.688 1.25Q12.062 2 1.25 8.188q.25.125 1.938.75-.5.375-.688.313-1.313-.5-1.688-.625v14.375q.063 0 .219-.313t.438-.781l.656-1.094.75-1.281.719-1.281.625-1.094.656-1.094q.063-.125.563-.063.063 0 .063.063-3 5.125-4.25 7.313-.063.063.063.063h11.688q.063 0 .063-.063.063-.313 0-.563h.063l-.375-.063h-.813q-.75 0-1.313-.813-.5-.625-1.375-1.813-.125-.125-1.063-.125-.125 0-.125.063.063 1.688.063 2.063.063.25.625.313.188 0 .188.125t-.125.188H7.752l-1.063-.031-.125-.156.125-.125h.188l.188-.063.063-.188q.063-.813.063-5 0-.75-.313-.813-.063-.063-.156-.063h-.156q-.188-.125.125-.313 3 0 3.5.313.75.438.781 1.281t-.969 2.031q-.063.063 0 .125t.219.281.281.344q1.313 1.563 1.531 1.75t1.031.313q.063 0 .063-.063v-.688l.125-.063q.625.063 1.438-.063.125 0 .125.125l.031.813.031.875.063.063h11.688q-1.75-3.063-5.063-8.813.063 0 .438-.063.125 0 .188.063.188.375 1.406 2.469t2.313 4l1.094 1.906V8.623q-1 .313-6.625 2.5-.063 0-.063-.063-.063-.188-.188-.375 0-.063.063-.063l.344-.125.875-.344 1.188-.469 1.313-.5 1.25-.438 1-.344.469-.219q-1.375-.813-12.25-7.063.688 1.188 2.563 4.438t2.875 5q-.625-.063-.75-.25-2.875-5.063-5.125-8.875-.25.313-1.563 2.656T9.85 8.495t-1.281 2.063h-.563q1-1.688 2.844-4.844t2.531-4.469zm3.25 8.125q.063 0 .375-.063.125 0 .125.125v1.313q-.125.125-.188 0t-.125-.313q0-.25-.313-.313t-2-.125q-.063 0-.063.063l.25 7.625q0 .063.063.063.5.25.563.25.625.438.75 1.25.063.75-.375 1.5t-1.625.813q-1.75.063-2.125-1.5-.25-.813.156-1.438t1.094-.813q.063-.063.063-.188.125-4.5.25-7.563 0-.063-.063-.063h-.563q-1.188 0-1.5.094t-.438.406q-.188.313-.25.063.063-.563.188-1.125.063-.188.188-.125.313.063 2.375.125.063 0 .063-.125.063-1.375.063-1.875.063-.125-.063-.188-.563-.25-.563-.813 0-.688.625-.969t1.063.219q.313.313.281.781t-.406.719q-.125.125-.125.313 0 .063.063 1.875 0 .063.063.063 1.188 0 2.125-.063zm-12.437-.5q.438-.125.906-.125h.719l.844.094.844.094q.25.063.188.25 0 1.188-.063 1.5 0 .063-.063.125-.25 0-.25-.375l-.063-.063q-.063-.75-1.219-1.063t-2.281.313-1.125 2.313q0 1.25.875 2.281t2.5.906q.75-.063 1.063-.375t.344-.625.156-.313q.188 0 .188.25l-.25 1.125v.063q-.063.375-1.406.5t-2.781-.594-1.625-2.531q-.125-1.313.531-2.375t1.969-1.375zm5 5.438H8l-.188-.063q.063-.125.219-.156t.156-.281v-2.5q0-.25-.188-.313-.25 0-.25-.063l.188-.125q1.375 0 1.875.063.438.063.656.5t-.156.875q0 .063-.375.438.563.75 1.063 1.25.188.188.625.188.125 0 .125-.125v-2.563q0-.375-.188-.438-.188 0-.188-.063t.188-.125h1.188q.313 0 .063.188h-.063q-.25.063-.25.313 0 2.375.063 2.688 0 .125.313.125.125 0 .125.063.063.063 0 .094t-.125.031h-2.188l-.25-.063-.188-.125-.188-.219-.188-.219-.219-.313-.219-.313q-.063-.125-.188-.125h-.25L8.873 13q.063.188.063.5 0 .625.188.625t.25.063q-.063.125-.188.125zm17.187-.625q-.188.625-.313.688-2.688-.063-3.125-.063h-.25q-.125-.063-.063-.125.063-.125 0-.25-.063-.25-.25-.625 0-.125-.125-.125h-.938l-.063.063q-.125.313-.313.688 0 .125.125.156t.313 0 .375.031q.25 0 .125.188h-1.75q-.125 0-.063-.188.25 0 .375-.188.063-.188.25-.563 1.125-2.563 1#q#625.063-.125.156-.031t.688 1.563.781 1.719q.063.125.438.125.188 0 .25-.25v-2.625q0-.188-.375-.25-.188 0 0-.188h1.375q.125 0 .156.063t-.094.125h-.125q-.188.063-.188.188v2.563q.063.188.188.188.938 0 1-.25.188-.25.25 0zm-6.5 4.062q-.188 0-.25-.125.125-.063.188-.125h2.313q.063-.063.094-.031t.031.094q0 .25-.063.688 0 .063-.094.063T22 18.189q0-.188-.125-.219t-.5-.031q-.25-.063-.375-.063-.063 0-.063.125v1q0 .125.063.063.938-.063 1-.063.188-.063.188.125 0 .563-.063.688-.063.188-.188 0-.313-.375-.188-.313-.75-.063-.781-.031t-.031.406q0 1 .25 1 .688.063.781 0t.219-.313q.063-.125.125-.125t.063.125q0 .313-.063.625 0 .125-.313.125h-2.188q-.125 0-.125-.094t.125-.156q.25 0 .25-.125.063-3.188-.188-3.188zm-.062-6.875q.188.063.188.313v.563q-.063.125-.156.125t-.094-.125q0-.438-.438-.563-1.125-.313-1.594.375t-.156 1.5q.25.625.813.813t1 .063q.313-.063.438-.375v-.125q.125-.125.188.125.125.313-.125.625l-.25.125q-1.313.188-2-.188-.938-.5-.969-1.469t.531-1.344q.813-.875 2.625-.438zm-1.75 6.625q.125 0 .156.094t-.156.156H18q-.25 0-.25.313v2.563q.063.25.25.25.625.063.844.031t.25-.188.094-.219q.125-.25.125.063.063.375-.031.563t-.125.188h-2.531q-.063 0-.094-.094t.094-.094q.313-.125.313-.188.063-1.813 0-3 0-.188-.375-.25-.063 0-.063-.094t.125-.094h1.438zm-2-3.625q0 .25.375.25.125 0 .125.094t-.125.094h-1.313q-.375 0-.188-.125.063-.063.188-.063t.156-.156.031-1.156V11.25q0-.188-.188-.25h-.125q-.125-.063-.094-.125t.156-.063q1.188-.063 1.313 0 .125.125-.063.188h-.063q-.188.063-.188.188v2.688zM13.75 31.063q.125.063.25 0 .5-.313 6.156-3.531t6.156-3.531H14.937q-.063 0-.063.063v.563l.031.563.031.656v1.406q0 .188-.063.438-.063.125-.875 2.063-.063.125-.125 0l-.75-1.938q-.188-.375-.125-.688 0-.625.063-3 0-.125-.125-.125H1.498q.063 0 1.219.688t2.875 1.656 3.406 1.969 3.094 1.781 1.656.969zM8.063 19.25q0 .188.188.188.5.125.969.063t.656-.5q.313-.688.094-1.469t-.906-.969q-.188-.063-.531-.063t-.469.125v2.625zm6.625-.937q0 .938.063 2.438 0 .313-.375.375t-.781-.125-.406-.438q.063-2.25.063-2.438-.688.313-.594 1.5t1.031 1.563q.875.375 1.375-.438.25-.375.219-1.219t-.594-1.219zm-.75-12.375q-.5 0-.5.469t.5.469q.25 0 .375-.25t.031-.469-.406-.219zm-5 6.468q0 .156.125.156.375.063.563-.125t.188-.406v-.281q-.063-.313-.281-.469t-.406-.125-.188.094v1.156zm13.25.407q-.125-.313-.375-1-.125.375-.375 1h.75z',
		'w' => .869140625,
		'vw' => 28
	    ),
	    'd-and-d-beyond' => array(
		'p' => 'M19.625 15.125q-.313 0-.531-.125t-.344-.219-.125-.156q-.188-.188-.188-.063t.063.188q-.688-.625-.313-1.625L18.124 13l-.125.125q0-.25.156-.469t.281-.344l.125-.063q.063.063.063.094t-.031.156-.031.313q.188-.313.688-.5-.125.188-.125.438.25-.313.5-.188-.5.563-.406 1.125t.594.563.875-.688q.063.063.25.219t.25.219q-.563 1.125-1.563 1.125zm3.25-1.344q0 .219-.313.281.125-.313 0-.563.313.063.313.281zm.625.344q0 .313-.25.5t-.625.125q.313.25.563.125-.188.375-.813.281t-.625-.656q-.313.313 0 .563-.375-.125-.438-.438 0-.188.031-.406t-.094-.313-.563-.406q-.125-.125-.188-.219t-.063-.188v-.156l-.125-.156-.156-.156-.031-.25q0 .188.188.25.063 0 .156.031t.156.031q.063.063.063.188 0 .063.063.125l.156.031.281.094q.063.063.188.156t.25.219.188.125q.25.188.406.063t.094-.313q.188.125.219.375t-.156.375q.563.125.625-.313 0-.313-.313-.375.313-.063.563.156t.25.531zm-2.437-1.187q.688-.938 1.5-1-.688-.063-1.25.563.125-.5.625-.813l-.063.25q.063 0 .156-.063t.25-.188.281-.125l-.188.25.125-.063.375-.063q.5 0 .813.438-.5-.188-.813.125-.813-.5-1.375 1-.313-.25-.438-.313zm15.187 3.25q1.688 0 2.719.844T40 19.251q0 3.063-3.688 3.063-1.5 0-3.25-.125l.5-.5v-4.875l-.5-.5q1.688-.125 3.188-.125zm-1 4.75q2.938.375 2.938-1.688 0-2-2.938-1.688v3.375zm-16.375-9.625l-.25-.438q0-.188.031-.438T19 9.906t.875-.219q1.063 0 1.063 1 0 .5-.313.875l-.5-.5q.188-.25.094-.563t-.406-.313q-.188 0-.313.188t-.063.438q-.125.25-.063.5-.313-.188-.438-.563-.188.25-.063.563zm-.062.375q.063-.188-.313-.313h.438q-.125-.125-.063-.375.125.188.469.375t.406.375q0-.25-.25-.375-.188-.438.063-.688 0 .313.438.719t.438.531q-.063-.25-.438-.563l-.188-.188q-.063-.25.063-.438 0 .25.469.719t.406.781q.125.063.125.125.125 0 .188-.125.063.438-.313.625.063-.188-.063-.281t-.313-.031v-.25q-.063-.188-.688.063.188-.063.313 0-.125.25.063.25v.313h.188q-.188.313-.563.313.188-.063.188-.25-.063.063-.188.063.313-.188.063-.5-.188-.25-.5-.063.063-.25.375-.375-.125 0-.313-.063.25-.188.563-.125-.5-.125-.813.188.125 0 .25.063-.375.063-.688.375l.063-.313q-.063-.188-.5-.125.063-.063.219-.156t.281-.156.125-.125zm1.625.437q-.063-.188-.25-.25.063.25.25.25zm2.437.25l.063-.063.125-.063v1.125q-.125-.063-.313-.063l-.313.063q-.188-.188-.313-.188.313.313-.063.438-.063.063-.125 0v-1l.031-.063.094-.063q.188-.25.438-.25.188 0 .313.125h.063zM5 19.125q.625.188.906.563t.281.5v.5q0 .75-.625 1.125-.125.063-.281.125t-.313.094-.438.063-.5.063-.656.031H.186l.5-.563v-2l-.688-.938h.688v-1.813l-.5-.563h3.5q.875 0 1.594.344t.719 1.219q0 1-1 1.25zm-2.562-1.75v1.313q.063 0 .313.031t.438.031.406-.031.344-.094.219-.188.094-.313v-.125q0-.25-.063-.375t-.313-.156-.469-.063-.719-.031h-.25zm0 3.75h1.063l.281-.031.219-.063.219-.063.156-.094.094-.156.031-.219h-.063v-.25q0-.125-.063-.25t-.188-.188-.281-.094-.375-.031H2.437v1.438zm6.312-1.25v1h3.75l-.875 1.313H6.562L7 21.625v-4.813l-.438-.5h4.563L12 17.625H8.75v.938h2.313l-.875 1.313H8.75zm13.375-3.75q1 0 1.75.344t1.156.906.594 1.219 0 1.313-.563 1.219-1.156.906-1.781.344q-1.375 0-2.281-.656t-1.094-1.563.031-1.813 1.125-1.563 2.219-.656zm0 4.875q1.188 0 1.625-.875t-.031-1.75-1.563-.875-1.563.875 0 1.75 1.531.875zm-5.687-.562v1.188l.438.563h-2.625l.438-.563v-1.188l-2.75-4.125h2.813l-.375.438 1.313 2.375 1.25-2.375-.375-.438h2.625zM14.625 11q-.5-.375-.563-.938.438.25 2.5.25 1.563 0 2 1.438l-.281.188-.219.156-.125.156q.188-.063.563-.063-.625.375-.625 1.25l.188-.188q-.125.375-.063.75-.688.5-1.625.5h-2.188q.25-.063.5-.25.125-.125.125-.375v-2.438q0-.313-.188-.438zm1.375.375V13.5h.688l.281-.094.219-.188.188-.313.063-.469-.063-.469-.188-.313-.219-.188-.281-.094-.281-.031h-.25zm14.313 4.938h2.438l-.438.563v5.313h-1.375q-.125-.438-1.5-1.813t-1.5-1.688v3l.438.5h-2.438l.438-.563v-4.75l-.438-.563h1.938q.125.25 1.406 1.469t1.469 1.719v-2.625zm-6.688-6q.938.063 1.469.563t.594.875.063.688-.125.719-.688.906-1.5.5q.438-.563-.125-1.063 1.188 0 1.188-1.063 0-.25-.031-.469t-.156-.313l-.25-.188-.281-.094h-.719v.25q-.25-.063-.438 0 .188-.125.375-.125-.563-.188-.938.188.063-.125.25-.313-.188.063-.375.25 0-.5-.188-.625-.5-.375-.625-.938.438.25 2.5.25z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'dev' => array(
		'p' => 'M7.5 13.031q.375.281.375.781v4.375q0 .563-.375.813t-.75.25H5.687v-6.5H6.75q.375 0 .75.281zM25.25 2q1.125 0 1.938.813t.813 1.938v22.5q0 1.125-.813 1.938t-1.938.813H2.75q-1.125 0-1.938-.813t-.813-1.938v-22.5q0-1.125.813-1.938T2.75 2h22.5zM9.625 18.188V13.75q0-1.063-.719-2t-2.219-.938h-3v10.313h2.938q1.563 0 2.281-.906t.719-2.031zm6.313-5.5v-1.875H12q-.563 0-.906.375t-.344.938v7.813q0 .5.375.875t.938.313h3.875v-1.813h-3.313v-2.375h2v-1.875h-2v-2.375h3.313zm6.5 7.187l2.375-9.063H22.75l-1.813 7.125-1.875-7.125h-2l2.375 9.063q.5 1.188 1.406 1.281t1.594-1.281z'
	    ),
	    'fantasy-flight-games' => array(
		'p' => 'M16 2.063l13.938 13.938L16 29.939 2.062 16.001zM5.5 16q1.375 1.313 2.563 2.563Q11.688 15 11.938 14.75l1.156 1.156 1.156 1.219q.938-.938 2.25-2.188l-2.25-2.25q-.125-.188 0-.313.75-.75 1.75-.844t1.813.531q.5.375 3.063 2.75 1.563-1.625 2.063-2.188.063 0 .031-.094l-.031-.094q-2.125-2.375-3.875-3.688-1.563-1.25-3.594-1t-3.906 2.125q-4.625 4.688-6.063 6.125zm14.688 6.313L26.501 16q-.25-.25-.531-.5t-.531-.5l-1.5-1.5q-.438.438-1.188 1.156t-1.406 1.375l-1.219 1.219q-.438-.438-1.219-1.25t-1.156-1.125l-.125.063-2 2q-.125.125.063.313l2 2q.188.25 0 .438-.813.75-1.844.781t-1.906-.656q-.375-.313-2.75-2.625l-2.25 2.25q3.313 3.375 4.563 4.188 1.313.875 3.219.594t3.469-1.906zM16 0l16 16-16 16L0 16zM1 16l15 15 15-15L16 1z'
	    ),
	    'penny-arcade' => array(
		'p' => 'M26.375 10.25q.25.563 1.563 3.438l-2.5.688q.875-3.875.938-4.125zM13.5 13.438q1.313-.313 1.688.75.375 1.25-.938 1.938-.375.188-.813.313-.625#q#125.563l-.313-2.875q1.438-.375 2.5-.688zm20.375-1.625Q40 14.876 40 18.376q.063 2.438-3.406 4.188t-9.063 2.094T15 23.627q0 .625-.344 1.125t-.906.688q-7.438 1.938-7.688 1.938-.688 0-1.188-.438t-.563-1.125l-.25-2.75v-.188q0-.5.313-.969t.813-.656l-.125-1.125q-5.063-2.813-5.063-5.938 0-2.25 2.688-3.844t7.094-2.188 9.531-.156q.313-.813 1.188-1.063 4.938-1.313 8.5-2.25.625-.188 1.188.094t.875.844zm-17.937 6.812q.813-.188 1.75-.781t1.438-1.281q.5-.813.625-1.938t-.125-2.156-1.094-1.75T16.438 10h-.063q-.688 0-6.188 1.5-3.125.813-5.375 1.438l.25 2.75 1.313-.313.688 7.188-1.25.313.25 2.75 7.188-1.875-.25-2.813-1.313.375-.125-1.5 3-.813zm12.437 1.063l6.813-1.813-.25-2.813-1.313.375-4.188-9.063q-3.813 1-8.438 2.25l.25 2.75 1.063-.25-2.063 7.875-1.313.375.25 2.75 7.063-1.875-.25-2.438-1.188.313.25-1.125 3.625-.938.375.875-.938.25z',
		'w' => 1.248046875,
		'vw' => 40
	    ),
	    'wizards-of-the-coast' => array(
		'p' => 'M13.688 21.625q.688-.563 1.375.438.625.938 0 1.438-.688.563-1.375-.406t0-1.469zm21.062 4.75q.25-.875.25-1.313 0-1.563-1.781-2.813t-4.469-1.438q-6.063-.375-11.5 4.625h-.063q.063-.688-.25-1.313l.063-.125q5.563-4.438 11.75-3.75 2.875.313 4.688 1.688t1.688 3.188q-.063.75-.313 1.25h-.063zM24.5 15q0-.5.438-.938l.938-.688q-.063 1.688-.125 1.875-.125.438-.688.438-.5-.063-.563-.688zm-3.125-9.437q6.938 0 12.219 3.594t5.969 8.719q-.188.125-.563.313.063.688 0 1h-.063q0-.375-.125-.938-.5.313-1 .75.25.625.25 1.625 0 1.75-1 2.375v-.063q.75-.75.75-2 0-1.563-.875-2.563.25.5.438 1.125-1.375 1.313-1.688 3.875-.25-.563-.688-1 .75.938.75 2.375 0 1.75-1.75 3 1.375-1.188 1.375-2.938 0-1.938-2.281-3.469t-5.844-1.531q-4.313 0-8.188 2.219t-6.625 5.781h-.063q-1.75-5.188-5.313-8.469T.122 15.187l-.063-.125q.5-.563 1.281-1.344t2.875-2.344 4.375-2.75 5.75-2.125 7.031-.938zm-6.187 18.125q1.063-.938.313-1.938-.813-1.188-1.938-.375-.5.375-.563 1t.25 1.063q.375.438.875.531t1.063-.281zm.125-8.5l.125.5-.25-.313-.875 1.688 1.563 1.813.75-.375-.688-4.438zM16.5 22.5q.063-.063.188-.125t.25-.156l.125-.094v-.063q-.063.063-.125.031t-.219-.281-.406-.75q.313-.25.688-.313v-.063q-.063-.188-.125-.313-.188.125-.688.5h-.063q-.25-.563-.313-.625v-.063q.375-.375.75-.5.188-.063.313 0l.063-.063q-.063-.063-.125-.156t-.125-.094v-.063q-1.063.563-1.625 1v.063q.188-.063.313.125.25.438.5.813t.344.5.188.313.063.219-.031.156h.063zm3.438-2v-.063q-.063 0-.125-.031t-.25-.469T19 18.562v-.063q.625-.188.813-.125v-.063l-.188-.313h-.063q-1.438.625-1.75.813l.063.375h.063q0-.125.156-.219t.281-.156.188-.063q.813 1.875.75 2v.063zm2.812-1.062q-.125-.063-.188-.25t-.188-.844-.188-.781q-.063-.188 0-.313-.125 0-.688.125v.063q.125 0 .188.25l.188.563h-.063l-.313.094-.5.156q0-.063-.063-.313l-.125-.25v-.313q-.188 0-.688.188.125 0 .188.25 0 .063.125.438t.281.781.156.469q.063.188 0 .313.5-.188.625-.25-.125-.063-.188-.25 0-.063-.063-.25l-.188-.563.063-.063.75-.25.063.063q.125.563.188.813v.313q.25-.125.625-.188zm2-.438l.125-.375h-.063q-.063.188-.469.281t-.531.031q0-.063-.031-.25t-.063-.344-.031-.219q.438-.063.625 0 0-.125.031-.219l.031-.094h-.063q-.125.063-.625.125h-.063q-.063-.375-.063-.625.813-.188 1 0h.063q-.063-.188-.125-.313v-.063q-.875.063-1.563.188h-.063q.125.063.188.25 0 .188.063.5l.125.625.125.5-.063.25v.063q1-.25 1.438-.25v-.063zm.688-2.75q.438-.25.438-.375l.25.5q1.125.063 1.313.063v-.313q-.25 0-.313-.063-.063-.125-.125-.375 0-.875.063-1.313 0-.063.063-.688t.063-.75q.063-.563 0-.75-.125-.563-.563-.813t-1.094-.219-1.469.031l-.313 1 .188.188q.875-.875 1.688-.313.375.313.125.688-.125.125-.344.281t-.438.25-.5.219-.469.313q-.375.375-.5.906t.125 1.094q.375.688 1.125.625.313 0 .688-.188zm2.312 1.313v-.375q-.688-.375-1.188-.156t-.625.781q-.125.75.5 1.125t1.125.063v-.063l.125-.375q-.313.5-.875.313t-.438-.938q.125-.625.594-.75t.781.375zm.375-5.5q.313.063.313.25l-.313 3.438q-.063.438-.5.438l-.063.313q1.188.188 2.313.438l.063-.313q-.563-.125-.594-.594t.281-2.281q.563-.438 1.313-.063l.688-.688-.156-.156-.344-.219-.438-.063-.938.688.063-1.125q-.875-.438-1.688-.438v.375zm.688 7.187q.875.188 1.125-.75.125-.375-.063-.719t-.563-.469q-.875-.313-1.188.625-.125.313-.063.563t.281.469.469.281zm2.625.563q-.063-.063-.063-.188L31.438 18q-.063 0-.219-.063t-.281-.125V18q-.375.625-.875 1.25l-.188.125q.125 0 .25.063l.125.063v-.063l.063-.188q.063-.063.125-.188t.125-.188q.063 0 .438.188v.438l-.125.125v.063q.063 0 .156.031t.219.063.188.031zm-.313-5.563q-.625.938-.438 2.094T31.75 17.5q.125.063.281 0t.219-.125l.063-.063-.125.438q.875.375 1.125.5l.125-.25q-.188-.25-.094-.625t.781-2.25q.125-.438.219-.688l.281-.75.375-.938q-.438-.438-1.438-1.313l-.125.25q.438.313.313.688l-.5 1.625q-.125-.625-.875-.594t-1.25.844zm1.813 4.938l.188-.188v-.063q-.188-.313-.5-.344t-.438.219q-.125.188.125.563.188.375.125.563-.063.125-.188.125t-.25-.156-.063-.281h-.063q-.125.25-.125.313.125.25.469.281t.469-.219q.188-.313-.063-.625-.188-.438-.125-.5t.156-.063.188.094.094.281zm1.375.812l.063-.25q-.25-.188-.813-.563l-.188.25q.25 0 .375.125-.188.375-.563 1.063l-.125.063-.063.063.375.25q0-.125.063-.25.25-.5.563-1 .188.125.313.25zM36 17.25l.5-.625q-.063-.188-.188-.375t-.5-.469-.75-.219-.531.313-.125.594.125.625.219.563.188.281q.125.563-.25.625-.5.125-.625-.563v-.375l-.188-.125-.313.875q.125.125.25.219t.469.281.594.188q.813-.125.813-1.063 0-.25-.219-.906t-.219-.781q0-.438.438-.25.313.188.25.563 0 .063-.125.438zm2.188-.625h.063q-.938-2.938-3.188-5t-4.625-2.906-4.688-.844q-4.188-.063-8.25 2.25l1.313-3.813-2.125 4.063-.563-1.313.438-.125-.188-.5q-.188 0-.438.125l-.75-1.813.813 3.813h-.063q-1-.5-.313-1.188l-.188-.688q-.125.063-.719.219t-1.281.406l-1.438-.75 3.688 2.688-.313.125-1.063-.875q.125.25.313 1.25l-1.813.813-1.875-2.25-1.063.563.875 2.625-.75.313L15.935 12l-.25.625-.063-.188-.813.25.313 1.5-.25.813-1.625-1.938-2.5.625 1.188 3.688q-.75-.75-1.813-1.875-1.625-1.688-1.938-2.094t-.125-.781l.5-.438-.25-.438q-1.688 1.188-3.625 2.688l.313.375q.063-.063.156-.125t.313-.156.344-.031h.063q.25 0 .625.313t2.438 2.188q2.25 2.063 4 3.625l.75-.5-1.75-5.875 2.25 2.688-.313#r#625-5.5q1.875 4.375 2.063 4.938l-2.125-4.25-.125.313 1.438 3.688q.063.5 0 .563t-.375.25l.188.313q1.125-.5 2.438-.938l-.063-.313q-.625.125-.75-.25-.125-.25-1.313-3.688l-.625-.313-.125-.5 3#r#313-#r#688q1.438-.375 3.125-.625l-.063-1.688-.313.125q-.063 1.313-1.188 1.375l1.375-5q-1.875 0-4.188.563l.25 1-1.563-1.188 5.688-1.313-5.313.563q4#q#438 8.313-2.375 2.813.063 5.156 1.031t3.688 2.438 2.063 2.563 1.031 2.094zM12.688 9.5l.188.563q.438-.125.688-.125l-.563-.5zm9 2.438L21 14.313l-1.375-1.063q.188-.75.719-1.094t.875-.281.469.063zm-1.813-7.75q4.063 0 7.5.969t5.719 2.531 3.875 3.469 2.313 3.75.719 3.531q0 1-.063 1.188h-.063v-.625q0-2.5-1.375-5t-3.781-4.5-6-3.25T21 5.001q-3.75 0-6.875.875h-.063q-.5-.5-1.375-.75v-.063q3.438-.875 7.188-.875zm13.188 10.625q-.25 1-.469 1.5t-.344.594-.313.094q-.5 0-.375-.938.063-.625.375-1.375t.688-.688q.625.063.438.813zM29.25 17.5q.5.125.313.875-.188.813-.75.688t-.375-.938q.25-.813.813-.625zm1.438 1.313v-.063q.25-.375.438-.625-.063.688-.063.75-.125 0-.219-.031t-.156-.031z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'think-peaks' => array(
		'p' => 'M27.625 25.563L14.75 3.5 2 25.5l-2-.063L14.75-.001l12.875 22.125 3.5-5.938h2zm-22.187-2.75l9.375-16.125 14.688 25.313h-2L14.813 10.188 7.438 22.813h-2z',
		'w' => 1.033203125,
		'vw' => 33
	    ),
	    'reacteurope' => array(
		'p' => 'M15.5 13.25l.125-.438-.375-.25h.438l.125-.438.188.438h.438l-.375.25.125.438-.375-.25zm3.938 0l.125-.438-.313-.25h.438l.125-.438.125.438h.438l-.313.25.125.438-.375-.25zm-5.688 3.125q.188 0 .219.125t.031.75q0 .875-1.063.875t-1.063-.875v-2.5q0-.875 1.063-.875T14 14.75q0 .75-.25.75h-.188q-.25 0-.25-.625 0-.375-.375-.375t-.375.375v2.25q0 .375.375.375t.375-.375v-.5l.063-.156.188-.094h.188zM8.688 17.5q.25 0 .25.25v.125q0 .188-.25.188H7.313q-.188 0-.188-.188v-3.75q0-.188.188-.188h1.375q.25 0 .25.188v.188q0 .188-.25.188h-.875v1.188h.688q.25 0 .25.188v.188q0 .188-.25.188h-.688v1.25h.875zm-2.625-1.187l.5 1.5q.125.313-.188.313h-.188q-.188 0-.25-.25l-.5-1.438h-.313v1.438q0 .25-.25.25h-.25q-.188 0-.188-.25v-3.688q0-.25.188-.25h.875q1.063 0 1.063.875v.75q0 .563-.5.75zm-.188-.875v-.563q0-.375-.438-.375h-.313v1.313h.313q.438 0 .438-.375zm4.938-1.313l.688 3.688q.063.25-.188.25h-.25q-.188 0-.25-.188l-.125-.688h-.75l-.125.688q0 .188-.25.188h-.188q-.25 0-.188-.25l.688-3.688q.063-.188.25-.188h.438q.188 0 .25.188zm-.75 2.438h.563l-.313-1.813zm5.562 1.312q0 .188-.25.188h-.188q-.25 0-.25-.188V14.5h-.438q-.25 0-.25-.188v-.188q0-.188.25-.188h1.625q.188 0 .188.188v.188q0 .188-.188.188h-.5v3.375zm15.5-.062q.125 0 .125.125v.063q0 .125-.125.125H29.75q-.125 0-.125-.125v-3.938q0-.188.125-.125h1.375q.125 0 .125.125v.063q0 .125-.125.125h-1.188v1.563h1q.125 0 .125.125v.063q0 .125-.125.125h-1v1.688h1.188zm-5.812-3.938q.938 0 .938.875v2.5q0 .875-.938.875h-.063q-.938 0-.938-.875v-2.5q0-.875.938-.875h.063zm.625 3.25v-2.25q0-.688-.656-.688t-.656.688v2.25q0 .688.656.688t.656-.688zm-2.875-.875l.625 1.688q.063.125-.063.125H23.5q-.063 0-.125-.063l-.625-1.688H22V18q0 .125-.125.125h-.063q-.125 0-.125-.125v-3.938q0-.125.125-.125h.813q1 0 1 .875v.563q0 .688-.563.875zm-.438-.25q.688 0 .688-.688v-.438q0-.688-.688-.688H22v1.813h.625zM28 13.938q.938 0 .938.875v.625q0 .938-.938.938h-.625v1.625q0 .125-.125.125h-.125q-.125 0-.125-.125v-3.938q0-.188.125-.125H28zm.625 1.437v-.5q0-.688-.625-.625h-.625v1.813H28q.625 0 .625-.688zM16 19.25h.5l-.375.25.125.438-.375-.25-.375.25.125-.438-.313-.25h.438l.125-.438zm14.25-8.5q2.813 1.063 4.219 2.563t1.188 3-2.125 2.969-5.406 2.469q1.563 5.688 0 8.375-.938 1.75-2.938 1.75-2.125 0-5#q#219t-6.188-6.656q-2.813-.25-5.313-.813-.875 3.938-.531 5.938t1.531 2.688q.125.063.281.156t.875.125 1.5-.25 2.094-1.125 2.75-2.219q.313.313.688.625-1.438 1.375-2.781 2.281t-2.406 1.25-1.938.313-1.563-.406q-1.5-.875-1.906-3.313t.531-6.313q-.625-.125-1.25-.344t-1.875-.75-2.156-1.125-1.625-1.563-.719-1.969q0-1.875 2.031-3.438t5.469-2.5q-1.5-5.688 0-8.375 1-1.75 3-1.75 2.125 0 5.156 2.219t6.219 6.656q2.875.25 5.313.813.813-3.875.5-5.906t-1.5-2.719q-.188-.063-.406-.156t-.906-.094-1.469.25-2.063 1.094T18.624 4.5l-.625-.625Q20.499 1.437 22.78.5t3.875-.063 1.938 3.406-.594 6.219q1.188.313 2.25.688zM8.313 2.313q-.25.375-.375.906T7.75 4.282t-.063 1.125.063 1.125l.125 1.063.156.938.156.719.125.531.063.219q2.563-.625 5.25-.938 1.563-2.188 3.188-4l.625.625q-1.313 1.5-2.625 3.313 2.875-.25 5.875-.063-2.875-3.875-5.625-5.875t-4.563-2q-1.5 0-2.188 1.25zm19.062 27.375Q28.688 27.25 27.25 22q-2.25.625-5.25.938-1.5 2.188-3.188 4l-.625-.625q1.375-1.5 2.625-3.313-2.813.25-5.813.063 2.813 3.875 5.563 5.906T25.187 31q1.438 0 2.188-1.313zm.563-8.625q5.25-1.5 6.563-3.938.188-.25.25-.438t.094-.875-.344-1.313-1.5-1.469-3-1.531q-1.063-.438-2.188-.688-.313 1.188-.75 2.438-.375.063-.563.375-.188-.188-.438-.313.5-1.375.875-2.75-2-.438-4.5-.688 1.125 1.625 2.188 3.438-.438.125-.688.438-.375-.438-1-1.469t-1.625-2.531q-3.688-.25-7.063.063-1.125 1.625-2.188 3.563-.375.188-.625.5-.063-.313-.375-.5.938-1.75 2.063-3.438-2.5.25-4.5.813.375 1.313.938 2.688-.063.063-.188.125-.25-.313-.875-.313-.438-1.063-.75-2.25-3.25.938-5.063 2.281t-1.938 2.75 1.656 2.813T7.81 21.25q.375-1.25.813-2.5.25 0 .438-.063.125.063.5.063-.5 1.375-.875 2.688 2.375.563 4.5.75-1.063-1.625-2.063-3.438.5 0 .75-.188.125.063.188.125 1.063 1.875 2.313 3.563 3.375.25 7-.063 1.125-1.625 2.125-3.438.438 0 .688-.25.188.125.375.188-.938 1.813-2 3.375 2.688-.25 4.5-.813-.375-1.313-.938-2.625.188-.063.375-.188v-.063q.188.375.625.375.438 1.125#r#313zm-7.188-7.125q.125 0 .188.063v3.25q0 .875-.938.875h-.063q-.938 0-.938-.875v-3.25q0-.063.125-.063h.063q.125 0 .125.063v3.125q0 .688.625.688t.625-.688v-3.125q0-.063.125-.063h.063zm-.812 5.312h.438l-.375.25.125.438-.375-.25-.313.25.125-.438-.375-.25h.438l.125-.438zm-1.938.5h.438l-.375.25.125.438-.375-.25-.313.25.125-.438-.375-.25h.438l.125-.438zm.313-1.937q.125 0 .125.125v.063q0 .125-.125.125h-1.438q-.125 0-.125-.125v-3.938q0-.125.125-.125h1.375q.125 0 .125.125t-.125.125h-1.188v1.625h1q.125 0 .125.125v.063q0 .125-.125.125h-1v1.688h1.25zm-.5-6.25l.188.438h.438l-.375.25.125.438-.375-.25-.313.25.125-.438-.375-.25h.438z',
		'w' => 1.11328125,
		'vw' => 36
	    ),
	    'adobe' => array(
		'p' => 'M18.125 4h10.688v24zm-7.437 0L0 28V4h10.688zm3.687 8.875L21.125 28h-4.563l-1.938-4.75H9.749z',
		'w' => .8984375,
		'vw' => 29
	    ),
	    'artstation' => array(
		'p' => 'M0 23.563h19.688l3.688 6.438H5.563q-2 0-2.875-1.75zm31.25-1.688q1.063 1.688-.125 3.688l-2.563 4.438-16.063-28h5.5q1.938 0 2.875 1.688zM17.063 19H2.625l7.25-12.5z',
		'w' => .9921875
	    ),
	    'atlassian' => array(
		'p' => 'M9.5 14.75q3.125 3.375 4.063 8.219t-.875 8.531q-.25.5-.813.5H.937q-.5 0-.781-.438t-.031-.938l7.813-15.688q.25-.5.719-.531t.844.344zM15.25.5q.375-.5.875-.5t.75.5l15 30.125q.25.5-.031.938t-.781.438H20.188q-.563 0-.875-.5-.563-1.125-1.781-3.438t-1.875-3.625-1.625-3.563-1.344-3.844-.656-3.813 0-4.094 1.063-4.156T15.251.499z'
	    ),
	    'canadian-maple-leaf' => array(
		'p' => 'M22.563 22q-.375.313-.406.438t.094.938l.625 2.188q-5.938-1.25-6.563-1.375-1.188-.125-1.188.75l.375 7.063h-1.875q0-.125.031-.375t.063-.906.063-1.281.063-1.438.063-1.406.063-1.063.031-.594q0-.875-1.125-.75l-6.625 1.375q.313-1.25.625-2.188.125-.813.094-.938T6.565 22L.002 16.187l1.125-.438q.625-.313.25-1.125l-1.25-4.188q3 .625 3.625.813.5.125.813-.5l.938-2q3.25 3.75 3.438 3.875.438.313.813.094t.25-.719L8.316 3.874q1.875 1.125 2.5 1.438.688.438 1.063-.313l2.688-5q2.375 4.5 2.688 5 .375.75 1.063.313l2.5-1.438q-1.688 7.5-1.688 8.125-.125.5.25.719t.813-.094l3.438-3.875q.813 1.688.938 2 .313.625.813.5l3.625-.813q-1.125 3.75-1.25 4.188-.375.813.25 1.125l1.125.438Q22.694 21.812 22.569 22z',
		'w' => .91015625,
		'vw' => 29
	    ),
	    'centos' => array(
		'p' => 'M18.125 6.125l1.938 2-4.75 4.75v-6.75h2.813zm-10.187 2l2-2h2.813v6.75zM10.563 5.5L14.001 2l3.5 3.5h-2.813v8l-.688.688-.688-.688v-8h-2.75zM12.188 16l-.688.688h-8v2.813l-3.5-3.5 3.5-3.5v2.813h8zm4.937-1.312l4.75-4.75 2 1.938v2.813h-6.75zM28 16l-3.5 3.5v-2.813h-8l-.625-.688.625-.688h8v-2.813zM4.063 11V6.125h5l-2 2 5.688 5.625v.938h-1L6.126 9.063zm19.812-4.875V11l-2-1.938-5.625 5.625h-.938v-.938l5.625-5.625-1.938-2h4.875zM12.75 25.875H9.937l-2-1.938 4.813-4.813v6.75zM4.063 14.688v-2.813l2.063-1.938 4.75 4.75H4.063zM23.875 21v4.875H19l1.938-2-5.625-5.625v-.938h.938l5.625 5.625zm0-3.687v2.813l-2 1.938-4.75-4.75h6.75zm-3.812 6.562l-1.938 2h-2.813v-6.75zM6.125 22.063l-2.063-1.938v-2.813h6.813zM17.5 26.5L14 30l-3.438-3.5h2.75v-8l.688-.688.688.688v8h2.813zM7.063 23.875l2 2h-5V21l2.063 1.938 5.625-5.625h1v.938z',
		'w' => .873046875,
		'vw' => 28
	    ),
	    'confluence' => array(
		'p' => 'M.125 25.75q.188-.25.5-.75.875-1.375 1.406-2.188t1.781-2.25 2.375-2.219 3-1.531 3.844-.781 4.688.594 5.719 2.125q3.438 1.625 6.625 3.125.375.188.531.563t-.031.75l-3.125 7.125v.063q-.188.375-.594.5t-.781-.063q-.813-.375-2.25-1.063-2.438-1.188-3.5-1.688t-2.688-1.125-2.219-.75-1.625-.156-1.469.281-1.188.938-1.281 1.469-1.344 2.156q-.5.875-1.375.375L.499 27.125q-.875-.5-.375-1.375zm31.75-19.5q-.188.25-.5.75Q30.562 8.375 30 9.188t-1#r#25-2.375 2.219-3 1.563-3.844.781-4.688-.625-5.781-2.063q-3.063-1.5-6.625-3.125-.375-.188-.5-.594t0-.781l3.188-7.125q.188-.375.594-.531t.781.031q.813.375 2.313 1.125 3.188 1.5 4.469 2.125t3.094 1.188 2.469.438 1.719-.656 1.719-1.5 1.719-2.781l.063-.063q.563-.813 1.375-.25l6.625 4.063q.875.5.375 1.375z'
	    ),
	    'dhl' => array(
		'p' => 'M14.875 18.813l1.375-1.875h3.688l-1.375 1.875h-3.688zM0 17.688h5.375l-.25.375H0v-.375zm10.813-.75h4.25q-1.375 1.875-3.563 1.875H5.25l2.563-3.438h3.188q.438 0 .188.313-.063.063-.688.938-.25.313.313.313zm19.812-.438H26.75l2.5-3.313h3.875zm-24.687.438l-.25.375H0v-.375h5.938zm6.937-1.688q.313-.375-.125-.375h-7l1.313-1.688h7.313q1.313 0 1.813.781t.063 1.406l-.875 1.125h-2.813q-.563 0-.313-.313.063-.125.188-.281t.25-.344.188-.313zM0 18.813v-.375h4.875l-.313.375H-.001zm20.188 0l1.375-1.875h3.688l-1.375 1.875h-3.688zm13.875 0l.313-.375h5.625v.375h-5.938zm1.375-1.875h4.563v.375h-4.813zm-.813 1.125l.25-.375H40v.375h-5.375zm-10.25-4.875H28l-2.438 3.313h-9l2.5-3.313h3.625l-1.375 1.875h1.625zm2.063 3.75h8.313l-1.375 1.875h-5.875q-1.063 0-1.469-.438t.031-.875z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'diaspora' => array(
		'p' => 'M14.188 22.188q-.063 0-2.813 3.75l-2.75 3.75q-.063 0-2.75-1.906t-2.688-1.938 2.719-3.969 2.719-4-2.031-.75-4.25-1.406T0 14.938q-.063 0 .938-3.188t1.031-3.219 2.281.719 4.531 1.5l2.281.75q.063 0 .063-.125l.125-9.313q.063-.063 3.281-.063t3.25.031.063 1.031.094 2.438.094 2.875.063 2.438.094 1 2.219-.75 4.313-1.469l2.156-.719q.063.063 1.031 3.25l.969 3.188-4.375 1.5-4.438 1.563q0 .063 2.594 3.844t2.594 3.813-2.688 2l-2.688 1.969q-.063 0-2.844-3.906t-2.844-3.906z',
		'w' => .900390625,
		'vw' => 29
	    ),
	    'fedex' => array(
		'p' => 'M36.625 17.75L40 21.563h-4L34.562 20l-1.375 1.563h-13.25v-.75h-.063q-.75 1#q#125 1.188-1.5 0-2.563-1.063t-1#q#5H8.623q0 1.125 1.094 1.5t1.781-.625h2.625q-#r#063-2#r#563t-3.656-.656-1.656-3.344q0-.625.125-1.125H3.06v4.813H-.003v-11.5H6.81v2.563H3.06v1.625h3.438v1.5q.75-1.313 2.344-1.813t3.156.219 2.125 2.469q.375-1.25 1.313-2.031t2.25-.781q1.375 0 2.188.938h.063v-4.75h9.438v3.063h-3.5v1h7.438l1.375 1.5 1.375-1.5h3.875zm-27.937-1h2.938q-.25-1.188-1.438-1.219t-1.5 1.219zm9.593 3.063q1.031 0 1.438-1t-.031-1.969-1.375-.969q-1 0-1.438.969t-.031 1.969 1.438 1zM28.75 21v-1.875h-3.5v-2.75h3.5v-1.75h-3.438V12.5h3.5v-1.938h-5.938V21h5.875zm-2.812-2.5h3.5v2.875l3.125-3.563-3.125-3.563v2.75h-3.5v1.5zm8.625.625L36.251 21h2.5l-2.875-3.25 2.813-3.125h-2.375l-1.625 1.813-1.625-1.813h-2.5l2.875 3#q#875 3.188h2.375z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'fedora' => array(
		'p' => 'M14.063 2q5.813 0 9.906 4.125t4.063 9.906-4.125 9.875T14.001 30H3.376Q1.938 30 .97 29t-.969-2.375V15.937q.063-5.75 4.156-9.844t9.906-4.094zm10.625 9.813q-.063-.75-.188-1.375l-3.438-3.5v.063q0 .438-.25.938zm-4-5.938q.188.313.25.625l3.438 3.375q-.938-2.813-3.688-4zM7.375 15.438q-.438.063-1 .188l.5.563q.25-.438.5-.75zm-1.312.25q-.438.125-.875.375l1.688 1.688q-.125-.438-.125-.813l.063-.5zm-1.125.5q-.5.25-.688.438l2.188 2.25q.375-.188.875-.313zM4 16.813q-.5.313-.625.563L5.5 19.564q.313-.313.688-.563zm-.875.75q-.313.375-.5.625l2.25 2.25q.188-.375.438-.688zm-.687.875l-.375.75 2.438 2.5q.063-.5.25-.938zM1.875 19.5q-.125.375-.25.875l3.25 3.375q-.375-.875-.375-1.688zm-.437 2.625q0 .688.188 1.375L5.064 27v-.063q0-.438.188-.875zm.312 1.938q.938 2.813 3.625 4-.125-.25-.25-.563zm-.312-2.313l4 4q.313-.313.625-.5l-4.5-4.563q-.125.625-.125 1.063zM17.25 18.5q.938 0 1.344-.75t0-1.531-1.344-.781h-2.125q-.5 0-.5-.563v-2.938q0-1.813 1.344-2.781T18.75 8.5q.438.125.875-.063t.719-.563.281-.875q0-.563-.344-1t-.906-.5q-.625-.125-1.25-.125-2.75 0-4.688 1.906t-1.938 4.656v3.5H8.874q-1 0-1.406.75t0 1.531 1.406.781h2.063q.188 0 .375.188t.188.375v2.938q0 1.438-1.031 2.469T8 25.499q-.313 0-.563-.063t-.438-.063q-.625 0-1.063.469t-.438 1.094.438 1.063.813.438q2.875.625 5.344-1.313t2.469-5.125v-3.5h2.688zm1.438 0q.5-.063 1.063-.188l-.563-.5q-.188.375-.5.688zM20 18.25q.5-.125.875-.313l-1.688-1.75q.188.438.188.813l-.063.5zm1.125-.5q.375-.188.75-.438l-2.25-2.25q-.313.188-.875.313zm1-.562q.375-.313.625-.563l-2#q#188q-.313.313-.625.5zm.813-.813q.375-.375.563-.625l-2.25-2.25q-.25.438-.5.688zm.687-.875q.25-.375.438-.75l-2.5-2.5q0 .5-.188 1zm.875-1.937l-3.375-3.313q.438.75.5 1.625l2.563 2.625q.188-.5.313-.938zm.063-.313q.063-.438.125-1.063l-4-4.063q-.313.375-.625.625z'
	    ),
	    'figma' => array(
		'p' => 'M16 10.688h-5.313v16q0 2.188-1.563 3.75t-3.781 1.563-3.781-1.563-1.563-3.781 1.563-3.781 3.75-1.563q-2.188 0-3.75-1.563T-.001 16t1.563-3.75 3.75-1.563q-2.188 0-3.75-1.563T-.001 5.343t1.563-3.781 3.75-1.563H16q1.063 0 2.063.438t1.719 1.125 1.125 1.688.406 2.063q0 2.25-1.563 3.813T16 10.689zm0 0q2.188 0 3.75 1.563t1.563 3.75-1.563 3.75T16 21.314t-3.75-1.563-1.563-3.75 1.563-3.75T16 10.688z',
		'w' => .666015625,
		'vw' => 21
	    ),
	    'intercom' => array(
		'p' => 'M24.5 2q1.438 0 2.469 1.031T28 5.5v21q0 1.438-1.031 2.469T24.5 30h-21q-1.438 0-2.469-1.031T0 26.5v-21q0-1.438 1.031-2.469T3.5 2h21zm-6.75 5.125v12.5q0 .875.938.875t.938-.875v-12.5q0-.938-.938-.938t-.938.938zm-4.687-.437v13.5q0 .938.938.938t.938-.938v-13.5q0-.938-.938-.938t-.938.938zm-4.688.437v12.5q0 .875.938.875t.938-.875v-12.5q0-.938-.938-.938t-.938.938zM3.75 9v8.375q0 .938.938.938t.938-.938V9q0-.938-.938-.938T3.75 9zm20.188 14.25q.25-.25.313-.563t-.063-.531-.344-.406-.531-.188-.563.25q-3 2.563-8.688 2.563t-8.813-2.563q-.25-.25-.563-.25t-.531.188-.344.406-.063.531.313.563q3.625 3 10.031 2.969t9.844-2.969zm.312-5.875V9q0-.938-.938-.938T22.374 9v8.375q0 .938.938.938t.938-.938z'
	    ),
	    'invision' => array(
		'p' => 'M25.438 2q1.063 0 1.813.75t.75 1.813v22.875q0 1.063-.75 1.813t-1.813.75H2.563q-1.063 0-1.813-.75T0 27.438V4.563Q0 3.5.75 2.75T2.563 2h22.875zM11 9.125q0-1.063-.844-1.469t-1.688 0-.844 1.469q0 .688.5 1.188t1.25.5q.188 0 .531-.094t.719-.531.375-1.063zm9.813 14.438q2.375 0 3.313-3.25l-1.125-.438q-.688 1.875-1.438 1.875-.563-.063-.563-.813.063-.375.938-3.688.438-1.563.219-2.75t-1.031-1.75-1.75-.594-2 .688-1#r#031l.563-2.5h-4.25l-.625 2.25h2l-1.25 4.938q-.813 1.875-2.438 2.125-1.125.188-1.125-.688 0-.5 2.063-8.625H5.688l-.563 2.25h2q-1.438 5.813-1.5 6.5 0 1.438 1.063 2.125t2.5.188 2.375-2.063l-.5 2h2.813l1.625-6.438q.563-2.25 2.125-2.5 1.313-.188 1.688 1.063.188.625-.063 1.375-.063.188-.313 1t-.344 1.25-.25 1.219-.063 1.25.313.969.781.75 1.438.25z'
	    ),
	    'jira' => array(
		'p' => 'M30.625 15.125Q31 15.5 31 16t-.375.875l-4.438 4.5.063-.125L15.5 32Q13.75 30.187.375 16.875 0 16.5 0 16t.375-.875L15.5 0l7.688 7.688zM15.5 20.75L20.25 16l-4.75-4.75L10.75 16z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'mendeley' => array(
		'p' => 'M39.063 20.313q1 1.125.938 2.969t-.938 2.594q-.875.875-1.969 1.125t-2.063-.063-1.719-1.188-.813-2.125q-.125-1.063.313-2.063 1.438-3-1.625-4.375-2.688-1.188-5.5-.188-3.063 1.125-2.063 3.875 0 .125.063.188v.063q1.25 1.938 0 3.969t-3.688 1.969q-2.438.063-3.688-1.938t.063-4v-.063q1.125-2.813-1.938-4-2.688-1.063-5.438.063-3.063 1.313-1.875 4.25.063.125.063.188 1 2.125-.281 3.969t-3.531 1.531Q1.624 26.875.749 25.5t-.781-2.781.781-2.094q1.563-1.563 3.313-1.375Q6 19.187 6.5 17.625t-.125-4.563q-1.125-2.813.531-5.5t4.969-2.688q1.563.063 2.844.844t1.906 1.75 1.531 1.75T20 9.999q.875 0 1.563-.5t1.281-1.25 1.25-1.5 1.719-1.281 2.375-.594q3.313 0 4.969 2.688t.531 5.5q-.688 3-.156 4.563t2.469 1.625q1.813-.188 3.063 1.063zm-19-1.188q1.813 0 2.875-1.25t1.063-2.688q0-1.625-1.156-2.781t-2.781-1.156h-.063q-1.625 0-2.781 1.156t-1.156 2.781q0 .875.406 1.75t1.344 1.531 2.188.656h.063z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'raspberry-pi' => array(
		'p' => 'M23.25 14.5q.938.625 1.594 1.781T25.407 19t-1.281 2.875q-.063.5-.688 2.25-.25 1.813-1.406 2.938t-2.031 1.313q-1.688 1.313-3.25 1.875-1.75 1.75-4 1.75h-.063q-2.25 0-4-1.75-1.563-.563-3.313-1.875-.813-.188-1.969-1.313T2 24.125q-.625-1.75-.688-2.25Q.124 20.562.031 19t.563-2.719T2.188 14.5l.25-.375q0-1.375.438-2.375t1-1.531 1.438-1.094q-.938-.25-1.063-.813-.938-.25-1.063-1-.938-.625-.875-1.188-.688-.5-.5-1.125-.625-.688-.375-1.25-.5-.625-.063-1.313-.313-.5-.031-.938t1.031-.375q.375-.5 1.563-.5.25-.375 1-.25.5-.5 1.438-.188.25-.188.5-.188.125 0 .281.031t.344.125.25.094q.438-.063.563-.063t.344.125.344.188q.688-.125 1.375.5h.375q1.375.813 2 2.75.563-1.938 1.938-2.75h.438l.063-.063q.563-.625 1.313-.438 0-.063.281-.188t.375-.125.531.063q.063 0 .313-.094t.375-.125.313 0 .438.156q.875-.313 1.375.188.688-.125 1 .25 1.188 0 1.5.5.813-.063 1.094.375t-.031.938q.438.688-.063 1.313.25.563-.375 1.25.188.625-.5 1.125.063.563-.875 1.188-.125.75-1.063 1-.125.563-1.063.813 1.375#r#125 1.906t.75 3.094zm-1.375-.5q.063-1.438-.656-2.5T19.344 10t-2.594-.188q-.75.125 1.938 2.438 2.938 2.438 3.188 1.75zm-2.719 5.844q1.156-.719 1.344-2.188t-.719-2.813-2.344-1.75-2.563.344-1.313 2.219.688 2.781 2.313 1.719 2.594-.313zM14.938 1.813q-.625.625-1.063 1.406T13.5 4.938t1.063 1.375Q17.126 4.25 20.938 3q-4.25 2.188-5.875 3.875.188.688.719 1.156t1.219.625 1.188.219 1 0q-.375-.125-.438-.313.125-.063.75-.125t.938-.25q-.313-.063-.438-.25 1.25-.375 1.5-.625-.375 0-.625-.125 1.25-.625 1.5-.875-.563-.063-.625-.125.688-.438 1.188-.938-.5.063-.625-.063.938-.938 1-1.063-.5.188-.688 0 0-.125.375-.406t.5-.656q-.563.063-.625 0 .125-.5.563-1.125h-.563q-.938 0-.938-.063l.375-.375q-.563-.125-1.625.188-.188-.188.25-.563-.75.063-1.375.313-.063-.125-.063-.156t.188-.219l.188-.188q-.813.125-1.438.563-.188-.188.125-.625-.563.188-1.188.75-.25-.313-.063-.563-.625.313-1 .813-.125-.125-.125-.563-.188.125-1.063 1.063-.125-.063-.188-.5zM12.75 9q-1.188-.063-2.25.656T9.437 11q0 .688.938 1.25t2.438.625q1.5 0 2.406-.5t.906-1.188q.063-.813-1.063-1.5t-2.313-.688zm-7.625-.812q.313.188.938.25t.75.125q-.063.188-.438.313.688.063 1.406 0t1.594-.563 1.063-1.438Q8.875 5.125 4.625 3 8.438 4.25 11 6.313q.938-.438 1.031-1.375t-.375-1.719-1.031-1.406q-.125.438-.188.5-.875-.938-1.063-1.063 0 .438-.125.563-.375-.5-1-.813.188.25-.063.563Q7.498 1 6.936.813q.375.438.188.625Q6.436 1 5.686.875l.188.188.156.219-.031.156q-.625-.188-1.375-.313.438.375.25.563-1.063-.313-1.688-.188l.375.375q.063.063-1.5.063.5.625.625 1.125-.063.063-.688 0 .188.375.531.656t.406.406q-.25.188-.688 0 .063.125 1 1.063-.188.125-.625.063.5.5 1.188.938-.063.063-.625.125.25.25 1.438.875-.188.125-.625.125.313.25 1.563.625-.125.188-.438.25zm3.75 1.5q-2.188-.375-3.719.813T3.75 13.939q.063.875 2.938-1.625 2.688-2.313 2#q#625zm-6.5 11.687q.563.25 1-1 .938-2.313.563-4.313-.25-.875-.75-.813-1.313.688-1.75 1.969t-.125 2.406 1.063 1.75zM8.063 27.5q.625-.5.406-1.813t-1.031-2.313q-1-1.063-2.031-1.531t-1.781-.031q-.563.313-.563 1.531t.688 2.406q1 1.438 2.406 1.844t1.906-.094zm-1.657-7.469q1.156.719 2.594.313t2.344-1.75.719-2.781-1.344-2#q#594-.344-2.313 1.75-.719 2.813 1.313 2.188zM12.813 31q1.25 0 2.438-.813t1.125-1.375q0-.563-1.156-.906t-2.344-.281q-1.188-.063-2.438.375t-1.25 1q0 .25.5.75t1.375.906 1.75.344zm3.687-7.812v-.063q0-1.375-1.094-2.344t-2.625-.969-2.594 1-1.063 2.375v.063q0 1.375 1.094 2.344t2.625.969 2.594-1 1.063-2.375zm5.125 2.687q.813-1.188.75-2.594t-.625-1.906q-1.313-1-3.688 1.625-.875 1-1.219 2.438t.281 2.063q.5.25 1.188.313t1.625-.438 1.688-1.5zm1.438-4.562q.75-.625 1.063-1.75t-.125-2.406-1.75-2.031q-.5-.125-.688.688-.5 1.938.438 4.375.563 1.25 1.063 1.125z',
		'w' => .79296875,
		'vw' => 25
	    ),
	    'redhat' => array(
		'p' => 'M19.5 25.063q.313.25.063.688-.125.25-.375.5-.563.438-1.25 0-.438-.313-.813-.25-.25.063-.344-.125t.031-.375q.25-.688 1.188-.188.688.438 1 .188.188-.125.438-.438h.063zM16 1.875q6.625 0 11.313 4.688t4.688 11.313q0 4.688-2.563 8.688-2.688-.625-4.813.25-.188.063-.188.25 0 .063.031.125t.031.188q-.063.313-.813.5-.5.063-.906.406t-.813.813-.469.531q-.125.125-.375.25t-.5.188-.469.094-.219-.031q-.063-.063 0-.063.938-1.313 1.063-1.563.188-.313.531-.719t.469-.656q.625-.813.75-1.25.063-.25.094-.75t.031-.563.219-.656.219-.844q-.063-.125-.281-.031t-.625.219-.594.125q-.25 0-.719-.156t-.656-.156q-.25 0-.688.188t-.688.188q-.125-.063-.438-.188t-.563-.125-1.25.156-1.875.156q-1-.063-1.906-.875t-1.281-1.375q-.313-.563-.813-.125-.25.188-.469.125t-.344-.25q-.5-.938-1-1.313-.688-.5-1.375-.313-.438.125-.688.563t-.188.875q0 .5.563 1.125.125.125.281.375t.313.438.406.313q.438.188.313.563-.063.25-.594.281t-.969-.219q-.188-.125-.719-.781t-1.219-.656q-.313 0-.625.125-1.25.625-2.688.625H.807q-.813-2.438-.813-5.063 0-6.625 4.688-11.313t11.313-4.688zM29 17.5q.25-1.375-.813-2.406t-3.188-1.531q-.313 1.25-1.375 1.75-.125.063-.156 0t.031-.188q.313-.563.563-1 .313-.75-.063-2-.313-1.125-.781-2.313t-1-2.219-.969-1.469q-1.438-1.438-3.938-.813-.063 0-.375.094t-.563.156-.656.125-.875.031-1.031-.156q-3.375-.75-4 1.625l-.688 2.813q-.188.313-.031.75t.469.844 1.438.875 2.938.781q1.75.375 2.25.875t.594 1.156.656 1.031q.438.25-.25.438h-.125q-.813.125-3.125-.594t-3.938-1.656q-2.25-1.375-1.438-3-1.438-.125-2.531 0t-1.813.531-.906 1.094q-.313 1.063 1.188 2.594t4.25 3 5.875 2.406q5.063 1.563 9.438.531T29 17.499zM14.375 8.438q1.063 0 1.313.5.188.313-.375.438l-.563.125q-1.875.125-2.375.688-.25.188-.5.031t-.438-.406l-.188-.313q-.313-.063-.563-.469t-.063-.781q.188-.438.469-.438t.406.188q.25.313.531.438t.5.125.781-.063 1.063-.063zm3.813-2.5q.75-.063 1.344.063t.844.344.25.469q0 .375-.563.594t-1.313.219q-.5 0-.938-.125v-.125q1.125-.25 1.063-.625-.188-.625-2.188-.313-.063 0-.063-.063t.063-.063q.563-.313 1.5-.375z'
	    ),
	    'sketch' => array(
		'p' => 'M1.125 10.125L6.063 3.5l-.438 8.188H0zm23.063-7.25l.438 8.313L16.188 2zm-17.75 10.75l7.688 15L.063 12.25h5.688zm.125-1.937l8.875-9.625 3.813 4.125 5.063 5.5H6.564zm18.562.562h5.688l-14 16.375zm.25-7.937l5.5 7.375H25.25l-.375-7.063-.063-1.125zM6.5 5.875l.188-3L14.751 2l-8.5 9.188zm18 6.375L15.437 30 9.062 17.437l-2.688-5.188h18.125z',
		'w' => .96484375,
		'vw' => 31
	    ),
	    'sourcetree' => array(
		'p' => 'M25.375 12.688q0 4.125-2.438 7.469t-6.313 4.594v6.375q0 .375-.281.625t-.656.25h-6q-.375 0-.656-.25t-.281-.625v-6.375q-3.875-1.25-6.313-4.594t-2.438-7.469q0-5.25 3.719-8.969T12.687 0t8.969 3.719 3.719 8.969zm-16.937 0q0 1.625.875 2.719t2.125 1.344 2.531 0 2.156-1.344.875-2.719q0-2-1.344-3.156t-2.938-1.156T9.78 9.532t-1.344 3.156z',
		'w' => .79296875,
		'vw' => 25
	    ),
	    'suse' => array(
		'p' => 'M29.188 6.438l.063-.063q5.688.813 8.063 2.188 1.125.625 2.188 4.375 0 .188-.25.375-.813.563-1.406.781t-1.656.313-2.563-.531-3.438-1.938q.625 1.5.688 1.563 3.438 1.813 5.125 1.813 1.563-.063 3.125-1l.25.188q-.25.938-.438 1.063-.188.188-.781.531t-2.219.781-3.438.438q-.625 0-1.531-.094t-1.406-.125-1.031.031-.813.375-.406.938q-.25 1.438 1.188 3.438h-3.063q-.125-.25-.5-1.063t-.656-1.219-.781-.938-1.25-.781-1.75-.25q-1.5 0-2.219.875t-.656 1.813.188 1.563H14.94q-.813-2.875-2.656-4.531t-3.719-1.969q-3.375-.563-5.063 1.594t-.375 4.531q.5 1 1.406 1.563t1.813.688 1.719-.125 1.25-.813q.938-1.188.344-2.594t-2.094-1.531q-.625-.063-1.125.219t-.5.844q0 .313.188.531t.344.281.219.063q.25 0 .375-.031t.219-.063.156-.031q.313-.063.688.156t.375.719q0 .688-.813.938-.5.125-1 .125-.938 0-1.75-.719t-.875-1.906q0-1.563 1.375-2.438.813-.563 1.938-.594t2.375.656q1.375.875 1.875 2.375t.125 2.813q-.563 1.75-2.063 2.625t-3.563.688q-3.188-.25-4.875-2.75-.75-1.063-1.063-2.25-.563-2.25.313-4.438 1.625-3.875 6.25-6.875 2.25-1.375 4.375-2.188t3.719-1.063 3.188-.344 2.656.031q3.938.125 8.5 1.625V6.44zM33 11q-.063 1.563 1.375 2.219t2.563-.438.563-2.563-2.125-1.531q-.438 0-.906.188t-.781.5-.5.719-.188.906zm2.375-1.625q.688.063 1.156.563t.438 1.156-.531 1.125-1.188.469q-.438 0-.813-.25t-.563-.625-.188-.813.219-.813.625-.594.844-.219zm.281 1.813q.719 0 .719-.469t-.719-.469-.719.469.719.469z',
		'w' => 1.232421875,
		'vw' => 39
	    ),
	    'ubuntu' => array(
		'p' => '#d#3.281 5.813q-.406.688-.188 1.5t.938 1.219 1.5.188 1.219-.938.219-1.5-.938-1.188T20 5.406t-1.219.906zM5.438 18q.875 0 1.438-.594T7.439 16q0-.563-.25-1t-.719-.719T5.439 14q-.813 0-1.375.594T3.501 16q0 .563.25 1t.719.719.969.281zm1.812.188q.813 3.125 3.5 4.938l1.5-2.5q-2.438-1.688-2.438-4.625t2.438-4.625l-1.5-2.5q-2.688 1.813-3.5 4.938 1 .875 1 2.219t-1 2.156zm14.281 8.218q.719-.406.938-1.188t-.219-1.5-1.219-.938-1.5.188-.938 1.219.188 1.5 1.219.906 1.531-.188zm-.031-4.343q2.313-2.25 2.563-5.5l-2.875-.063q-.25 2.938-2.813 4.406t-5.25.219l-1.438 2.563q2.938 1.438 6.063.563.125-.875.719-1.5t1.406-.781 1.625.094zm-.312-6.563l2.875-.063q-.25-3.25-2.563-5.5-1.25.5-2.406-.188t-1.344-2q-3.125-.875-6.063.563l1.438 2.563q2.688-1.313 5.25.188t2.813 4.438z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'ups' => array(
		'p' => 'M6.188 18.938V11.25h2.063v8.813q-.5.375-1.438.594t-2.031.25-1.875-.813-.781-2.469V11.25h2.063v6.5q0 .875.438 1.188t.875.219.688-.219zM0 4.625q4.625-2.438 11#q#594t12.25 2.594v13.813q0 1.063-.188 2.031t-.438 1.688-.875 1.5-1.031 1.25-1.438 1.125-1.563 1-1.906 1-2 .938-2.25.969q-1.625-.688-2.313-.969t-2-.906-1.906-1-1.563-1-1.406-1.156-1.063-1.281-.875-1.469-.438-1.688-#q#031V4.626zm22.375 13.813v-13.5q-2.438-.313-5.313-.188t-5.5.563-5.406 1.781-5.094 3.469v7.875q0 1.625.469 2.875t1.125 2.156 2.188 1.875 2.906 1.625 4 1.844q2.125-1 3.344-1.563t2.625-1.344 2.125-1.469 1.375-1.594.906-1.969.25-2.438zM9.25 11.75q.688-.438 1.688-.625t2.125 0 1.938 1.375.813 3.375q0 3.125-1.469 4.219t-3.031.656v4.313H9.251V11.75zm2.063 7.313q.188.063.344.125t.563 0 .719-.313.563-1.031.25-1.969q0-1.063-.219-1.813t-.5-1.031-.656-.375-.594-.031-.469.188v6.25zm4.937-5.375q0-1.875 1.844-2.5t3.156.5v1.75q-.813-.875-1.906-.844t-1.094 1.031q-.063.5.469.938t1.188.719 1.156 1.031.5 1.875q-.063 1.875-1.781 2.5t-3.406-.438v-1.875q.938.875 2.063.813t1.063-1.125q0-.563-.5-1t-1.094-.719-1.125-.969-.531-1.688z',
		'w' => .732421875,
		'vw' => 23
	    ),
	    'usps' => array(
		'p' => 'M27.063 15.125q-.125.25-.188.125-.063-.063 0-.125 0-.188.125-.5t.188-.531l.125-.438.031-.375-.219-.156q-.438-.125-1.906-.063t-2.406.125-1.188-.063q0-.063.438-.125t1.031-.188.906-.25q.5-.5.688-.5h1.688q1.375 0 1.594.563t-.906 2.5zm-7 1.375l-1.625.625-1.969.813-2.031.906-2.688 1.313-3.031 1.5-4 1.969L0 26.001l3.25-15.375h5q3.438 0 6.375.031t5.094.125 3.375.406 1.281.875h-12.25L14 17.876q1.375-.625 3.094-1.313t3.969-1.344 3.75-.719q1.688.063 1.625.375-.063.063-.813.188t-2.281.5-3.281.938zM4.25 6h28.375l-4.25 20H1.937q25.125-9.875 25.438-10 .063-.125.219-.344t.469-.813.469-1.094.125-1.094-.406-.906q-.125-.188-.313-.25t-.656-.125-.875-.063h-1.406q-.063-.688-2.594-1.344T11.501 7.561q-4.5-1-7.25-1.563z',
		'w' => 1.01953125,
		'vw' => 33
	    ),
	    'yarn' => array(
		'p' => 'M24.625 21.563q-1 .25-1.906.781T20.688 23.5t-2.563 1.063q-.188.25-.625.313-1.313.313-4.313.375-1.125.063-1.375-.5-.125-.25-.094-.469t.125-.406.219-.281.25-.156l.063-.063q-.25-.188-.5-.438l-.125-.063q0 .125-.094.5t-.219.688-.313.5q-.75.75-2.188.063-.625-.375.063-1.25-.375.25-.688-.188-.25-.438-.375-.938t.094-1.375 1.031-1.563q-.438-3.313 2.5-5.375-.125-.125-.281-.406t-.5-1.031-.031-1.25q.313-.813.563-.875.688-.25.938-.563.625-.625 1.344-.906t1.156-.281l.438.063.688-1.438q.438-.688.813-.5.063.063.188.281t.281.5.281.531.188.438l.125.188.938-.313q.813 1.625.313 4.063-.125.688-.375 1.313t-.469.969-.5.781-.344.563q-.063 0 .219.219t.719.844.75 1.5q.313.75.344 1.594t-.063 1.344l-.094.5q.125 0 .313.031t.75-.219 1.25-.625q1.688-1.063 2.813-1.063.75 0 .844.625t-.531.75zM31 16q0 6.438-4.531 10.969T15.5 31.5 4.531 26.969 0 16 4.531 5.031 15.5.5t10.969 4.531T31 16zm-4.937 4.688q-.125-.625-.594-1.031t-1.156-.406q-1.375.063-3.313 1.25-.438.25-.75.375#q#938-1.813-4.938 1.125-1.625 1.438-3.313.25-1 .125-2.406t-.563-2.281q-.375-.688-1.313-.438-.563-1.25-.938-1.5-.063-.063-.125-.063t-.25-.063-.344-.063-.406.094-.5.281-.5.594-.5.969q-1.75.125-2.938 1.438-.125.125-.625.313-.625.25-1.063 1.438-.5 1.313.438 2.813-2.313 2.125-2.25 5.188-.75.75-1 1.625t-.094 1.563.344 1.125.375.625q-.125 1.063.75 1.5 1.5#r#75.188.625.625 1.875.625 2.938 0 4.563-.375.5-.125.938-.438 2.125-.75 3.875-1.813 1.25-.875 2.313-1.125.438-.063.719-.344t.406-.625.125-.781z',
		'w' => .96875,
		'vw' => 31
	    )
	);
    }
    
    
    public static function fas() {
	return array(
		'bacteria' => array(
			'p' => 'M 17.023438 14.148438 C 17.292969 14.03125 17.503906 13.8125 17.609375 13.535156 C 17.71875 13.261719 17.710938 12.957031 17.589844 12.6875 L 17.339844 12.121094 C 17.59375 12.042969 17.851562 11.976562 18.113281 11.925781 C 18.871094 11.796875 19.59375 11.503906 20.222656 11.0625 L 20.847656 11.625 C 21.300781 12.039062 22.003906 12.003906 22.417969 11.550781 C 22.828125 11.097656 22.796875 10.394531 22.34375 9.984375 L 21.734375 9.4375 C 22.277344 8.527344 22.53125 7.480469 22.464844 6.425781 L 23.203125 6.203125 C 23.792969 6.03125 24.125 5.414062 23.949219 4.824219 C 23.773438 4.238281 23.15625 3.90625 22.570312 4.078125 L 21.859375 4.289062 C 21.351562 3.332031 20.558594 2.554688 19.585938 2.066406 L 19.765625 1.390625 C 19.917969 0.792969 19.5625 0.1875 18.96875 0.03125 C 18.371094 -0.121094 17.765625 0.234375 17.609375 0.832031 L 17.433594 1.503906 C 17.085938 1.492188 16.734375 1.515625 16.386719 1.574219 C 15.675781 1.6875 15 1.890625 14.320312 2.085938 L 14.109375 1.496094 C 13.902344 0.917969 13.265625 0.613281 12.6875 0.820312 C 12.109375 1.023438 11.804688 1.660156 12.011719 2.238281 L 12.226562 2.851562 C 11.273438 3.261719 10.351562 3.753906 9.480469 4.324219 L 9.085938 3.796875 C 8.71875 3.308594 8.019531 3.207031 7.527344 3.574219 C 7.292969 3.746094 7.132812 4.011719 7.09375 4.300781 C 7.050781 4.59375 7.125 4.890625 7.300781 5.125 L 7.707031 5.664062 C 6.914062 6.335938 6.183594 7.074219 5.519531 7.871094 L 4.96875 7.46875 C 4.472656 7.109375 3.777344 7.214844 3.414062 7.710938 C 3.238281 7.949219 3.167969 8.246094 3.214844 8.535156 C 3.257812 8.828125 3.417969 9.085938 3.65625 9.257812 L 4.210938 9.664062 C 3.65625 10.535156 3.171875 11.453125 2.773438 12.40625 L 2.121094 12.183594 C 1.539062 11.984375 0.910156 12.289062 0.710938 12.867188 C 0.507812 13.449219 0.816406 14.078125 1.394531 14.277344 L 2.042969 14.5 C 1.867188 15.125 1.679688 15.738281 1.570312 16.390625 C 1.507812 16.78125 1.492188 17.179688 1.519531 17.578125 L 0.796875 17.789062 C 0.210938 17.964844 -0.125 18.582031 0.0507812 19.167969 C 0.226562 19.757812 0.84375 20.089844 1.429688 19.914062 L 2.132812 19.707031 C 2.644531 20.664062 3.4375 21.4375 4.410156 21.921875 L 4.230469 22.613281 C 4.085938 23.203125 4.445312 23.800781 5.03125 23.953125 C 5.621094 24.105469 6.222656 23.757812 6.382812 23.171875 L 6.5625 22.484375 C 6.625 22.484375 6.691406 22.5 6.757812 22.5 C 7.773438 22.496094 8.765625 22.191406 9.609375 21.632812 L 10.148438 22.183594 C 10.574219 22.621094 11.277344 22.636719 11.71875 22.207031 C 12.160156 21.78125 12.171875 21.078125 11.746094 20.636719 L 11.171875 20.050781 C 11.554688 19.464844 11.808594 18.804688 11.929688 18.113281 C 11.988281 17.785156 12.066406 17.460938 12.171875 17.140625 L 12.734375 17.40625 C 13.285156 17.667969 13.949219 17.429688 14.207031 16.875 C 14.46875 16.320312 14.234375 15.660156 13.679688 15.398438 L 13.128906 15.140625 C 13.171875 15.078125 13.203125 15.011719 13.25 14.953125 C 13.402344 14.746094 13.566406 14.550781 13.738281 14.363281 C 13.964844 14.109375 14.210938 13.871094 14.46875 13.652344 C 14.667969 13.476562 14.875 13.3125 15.089844 13.164062 C 15.160156 13.113281 15.234375 13.074219 15.304688 13.027344 L 15.550781 13.582031 C 15.730469 13.984375 16.128906 14.242188 16.570312 14.242188 C 16.726562 14.242188 16.878906 14.210938 17.023438 14.148438 Z M 8 16 C 6.894531 16 6 15.105469 6 14 C 6 12.894531 6.894531 12 8 12 C 9.105469 12 10 12.894531 10 14 C 10 15.105469 9.105469 16 8 16 Z M 13 10 C 12.449219 10 12 9.550781 12 9 C 12 8.449219 12.449219 8 13 8 C 13.550781 8 14 8.449219 14 9 C 14 9.550781 13.550781 10 13 10 Z M 39.953125 12.832031 C 39.8125 12.359375 39.378906 12.039062 38.886719 12.039062 C 38.78125 12.039062 38.671875 12.054688 38.570312 12.085938 L 37.867188 12.292969 C 37.355469 11.335938 36.5625 10.5625 35.589844 10.078125 L 35.769531 9.386719 C 35.910156 8.796875 35.554688 8.203125 34.964844 8.050781 C 34.378906 7.902344 33.78125 8.246094 33.617188 8.828125 L 33.4375 9.515625 C 33.375 9.515625 33.308594 9.5 33.242188 9.5 C 32.226562 9.507812 31.234375 9.808594 30.390625 10.371094 L 29.851562 9.820312 C 29.425781 9.378906 28.722656 9.367188 28.28125 9.792969 C 27.839844 10.21875 27.828125 10.921875 28.253906 11.363281 L 28.828125 11.949219 C 28.445312 12.539062 28.191406 13.199219 28.070312 13.890625 C 28.011719 14.21875 27.933594 14.542969 27.828125 14.859375 L 27.265625 14.59375 C 26.714844 14.335938 26.050781 14.570312 25.792969 15.125 C 25.53125 15.679688 25.765625 16.339844 26.320312 16.601562 L 26.871094 16.859375 C 26.828125 16.921875 26.796875 16.988281 26.753906 17.046875 C 26.597656 17.253906 26.433594 17.453125 26.257812 17.640625 C 26.03125 17.894531 25.789062 18.128906 25.53125 18.347656 C 25.332031 18.523438 25.125 18.6875 24.90625 18.839844 C 24.839844 18.886719 24.761719 18.925781 24.691406 18.972656 L 24.445312 18.417969 C 24.265625 18.015625 23.867188 17.757812 23.425781 17.757812 C 23.273438 17.757812 23.117188 17.789062 22.976562 17.851562 C 22.707031 17.96875 22.496094 18.191406 22.390625 18.464844 C 22.285156 18.738281 22.289062 19.042969 22.410156 19.3125 L 22.660156 19.878906 C 22.40625 19.957031 22.148438 20.023438 21.886719 20.074219 C 21.128906 20.203125 20.40625 20.5 19.777344 20.941406 L 19.152344 20.378906 C 18.859375 20.105469 18.441406 20.007812 18.058594 20.128906 C 17.675781 20.25 17.386719 20.566406 17.304688 20.957031 C 17.222656 21.347656 17.355469 21.757812 17.65625 22.019531 L 18.261719 22.566406 C 17.71875 23.472656 17.464844 24.523438 17.535156 25.578125 L 16.792969 25.796875 C 16.207031 25.972656 15.875 26.59375 16.046875 27.179688 C 16.222656 27.765625 16.84375 28.097656 17.429688 27.921875 L 18.136719 27.714844 C 18.648438 28.671875 19.441406 29.449219 20.414062 29.9375 L 20.234375 30.617188 C 20.082031 31.210938 20.4375 31.816406 21.035156 31.972656 C 21.628906 32.125 22.234375 31.769531 22.390625 31.171875 L 22.566406 30.5 C 22.917969 30.511719 23.265625 30.488281 23.613281 30.429688 C 24.324219 30.3125 25.003906 30.113281 25.679688 29.917969 L 25.890625 30.507812 C 26.097656 31.085938 26.734375 31.390625 27.3125 31.183594 C 27.890625 30.980469 28.195312 30.34375 27.988281 29.765625 L 27.773438 29.152344 C 28.726562 28.742188 29.648438 28.25 30.519531 27.679688 L 30.914062 28.207031 C 31.28125 28.695312 31.976562 28.796875 32.472656 28.429688 C 32.710938 28.253906 32.867188 27.992188 32.910156 27.699219 C 32.953125 27.40625 32.875 27.109375 32.699219 26.875 L 32.292969 26.335938 C 33.085938 25.664062 33.816406 24.925781 34.480469 24.128906 L 35.03125 24.53125 C 35.347656 24.777344 35.777344 24.832031 36.148438 24.671875 C 36.519531 24.515625 36.777344 24.164062 36.816406 23.765625 C 36.855469 23.363281 36.675781 22.96875 36.34375 22.738281 L 35.789062 22.335938 C 36.34375 21.464844 36.824219 20.546875 37.226562 19.589844 L 37.878906 19.816406 C 38.457031 20.015625 39.089844 19.707031 39.289062 19.128906 C 39.488281 18.550781 39.183594 17.921875 38.605469 17.71875 L 37.957031 17.5 C 38.132812 16.875 38.320312 16.261719 38.429688 15.613281 C 38.492188 15.21875 38.507812 14.820312 38.480469 14.421875 L 39.203125 14.207031 C 39.484375 14.125 39.722656 13.933594 39.863281 13.675781 C 40.003906 13.417969 40.039062 13.113281 39.953125 12.832031 Z M 26 26 C 24.894531 26 24 25.105469 24 24 C 24 22.894531 24.894531 22 26 22 C 27.105469 22 28 22.894531 28 24 C 28 25.105469 27.105469 26 26 26 Z M 26 26',
			'vw' => 40
		),
		'bacterium' => array(
			'p' => 'M 31.9375 6.433594 C 31.703125 5.648438 30.875 5.203125 30.09375 5.4375 L 29.148438 5.71875 C 28.46875 4.441406 27.410156 3.402344 26.117188 2.753906 L 26.351562 1.847656 C 26.558594 1.054688 26.082031 0.246094 25.289062 0.0390625 C 24.492188 -0.164062 23.683594 0.3125 23.476562 1.105469 L 23.242188 2.003906 C 22.777344 1.988281 22.308594 2.019531 21.847656 2.09375 C 20.910156 2.257812 19.984375 2.472656 19.078125 2.746094 L 18.808594 1.996094 C 18.523438 1.234375 17.683594 0.84375 16.921875 1.113281 C 16.15625 1.386719 15.753906 2.21875 16.011719 2.984375 L 16.28125 3.738281 C 15 4.292969 13.773438 4.960938 12.609375 5.730469 L 12.109375 5.0625 C 11.617188 4.410156 10.691406 4.277344 10.035156 4.765625 C 9.71875 4.996094 9.507812 5.347656 9.453125 5.734375 C 9.394531 6.125 9.496094 6.519531 9.730469 6.832031 L 10.230469 7.496094 C 9.175781 8.398438 8.199219 9.390625 7.3125 10.460938 L 6.625 9.960938 C 6.199219 9.628906 5.628906 9.554688 5.132812 9.769531 C 4.636719 9.980469 4.296875 10.445312 4.242188 10.980469 C 4.1875 11.519531 4.429688 12.042969 4.875 12.347656 L 5.570312 12.851562 C 4.820312 14.015625 4.171875 15.246094 3.636719 16.523438 L 2.828125 16.246094 C 2.328125 16.0625 1.765625 16.164062 1.359375 16.511719 C 0.953125 16.859375 0.765625 17.398438 0.867188 17.921875 C 0.972656 18.445312 1.351562 18.875 1.859375 19.039062 L 2.671875 19.320312 C 2.433594 20.152344 2.242188 21 2.09375 21.851562 C 2.011719 22.375 1.988281 22.910156 2.027344 23.4375 L 1.0625 23.722656 C 0.28125 23.957031 -0.164062 24.777344 0.0703125 25.5625 C 0.300781 26.34375 1.125 26.789062 1.90625 26.554688 L 2.84375 26.277344 C 3.523438 27.550781 4.585938 28.582031 5.878906 29.230469 L 5.636719 30.152344 C 5.433594 30.941406 5.910156 31.75 6.699219 31.953125 C 6.820312 31.984375 6.949219 32 7.074219 32 C 7.75 32 8.339844 31.546875 8.511719 30.894531 L 8.75 29.980469 C 8.835938 29.984375 8.921875 30 9.007812 30 C 10.363281 29.992188 11.683594 29.59375 12.8125 28.84375 L 13.527344 29.578125 C 14.101562 30.144531 15.023438 30.152344 15.601562 29.59375 C 16.179688 29.03125 16.207031 28.109375 15.65625 27.519531 L 14.894531 26.738281 C 15.402344 25.953125 15.746094 25.070312 15.902344 24.152344 C 15.980469 23.710938 16.089844 23.28125 16.226562 22.855469 L 16.976562 23.207031 C 17.453125 23.445312 18.023438 23.402344 18.464844 23.101562 C 18.90625 22.800781 19.148438 22.285156 19.101562 21.75 C 19.054688 21.21875 18.722656 20.753906 18.238281 20.535156 L 17.503906 20.191406 C 17.5625 20.109375 17.605469 20.019531 17.664062 19.9375 C 17.867188 19.667969 18.085938 19.40625 18.316406 19.15625 C 18.617188 18.816406 18.945312 18.496094 19.289062 18.203125 C 19.554688 17.972656 19.832031 17.753906 20.117188 17.550781 C 20.210938 17.488281 20.3125 17.433594 20.40625 17.371094 L 20.734375 18.109375 C 21.0625 18.859375 21.9375 19.203125 22.6875 18.871094 C 23.4375 18.542969 23.78125 17.667969 23.453125 16.917969 L 23.117188 16.160156 C 23.453125 16.058594 23.800781 15.972656 24.148438 15.90625 C 25.160156 15.730469 26.117188 15.335938 26.960938 14.746094 L 27.792969 15.496094 C 28.179688 15.875 28.742188 16.015625 29.261719 15.859375 C 29.78125 15.699219 30.171875 15.269531 30.28125 14.738281 C 30.390625 14.207031 30.199219 13.65625 29.785156 13.308594 L 28.976562 12.578125 C 29.703125 11.371094 30.042969 9.96875 29.949219 8.5625 L 30.9375 8.269531 C 31.3125 8.160156 31.632812 7.902344 31.820312 7.558594 C 32.007812 7.214844 32.050781 6.808594 31.9375 6.433594 Z M 10 23 C 8.34375 23 7 21.65625 7 20 C 7 18.34375 8.34375 17 10 17 C 11.65625 17 13 18.34375 13 20 C 13 21.65625 11.65625 23 10 23 Z M 15 14.5 C 14.171875 14.5 13.5 13.828125 13.5 13 C 13.5 12.171875 14.171875 11.5 15 11.5 C 15.828125 11.5 16.5 12.171875 16.5 13 C 16.5 13.828125 15.828125 14.5 15 14.5 Z M 15 14.5',
		),
		'bahai' => array(
			'p' => 'M 31.015625 12.65625 L 24.140625 11.691406 L 26.753906 5.171875 C 27.171875 4.132812 26.03125 3.160156 25.09375 3.757812 L 19.214844 7.5 L 17.085938 0.800781 C 16.914062 0.265625 16.457031 0 16 0 C 15.542969 0 15.085938 0.265625 14.914062 0.800781 L 12.785156 7.5 L 6.90625 3.757812 C 5.96875 3.160156 4.828125 4.132812 5.246094 5.171875 L 7.859375 11.691406 L 0.984375 12.65625 C -0.113281 12.8125 -0.371094 14.300781 0.609375 14.824219 L 6.742188 18.117188 L 2.085938 23.335938 C 1.40625 24.101562 1.980469 25.269531 2.917969 25.269531 C 3 25.269531 3.085938 25.261719 3.171875 25.242188 L 9.957031 23.765625 L 9.703125 30.796875 C 9.675781 31.527344 10.253906 32 10.851562 32 C 11.171875 32 11.5 31.859375 11.738281 31.550781 L 16 25.996094 L 20.261719 31.550781 C 20.5 31.859375 20.828125 32 21.148438 32 C 21.746094 32 22.328125 31.527344 22.300781 30.796875 L 22.042969 23.765625 L 28.828125 25.242188 C 29.914062 25.476562 30.65625 24.167969 29.914062 23.335938 L 25.257812 18.113281 L 31.394531 14.824219 C 32.371094 14.300781 32.113281 12.8125 31.015625 12.65625 Z M 21.15625 19.480469 L 17.914062 18.773438 L 18.035156 22.136719 L 16 19.480469 L 13.964844 22.136719 L 14.085938 18.773438 L 10.84375 19.480469 L 13.066406 16.984375 L 10.136719 15.410156 L 13.421875 14.949219 L 12.171875 11.832031 L 14.980469 13.621094 L 16 10.421875 L 17.019531 13.621094 L 19.828125 11.832031 L 18.578125 14.949219 L 21.863281 15.410156 L 18.929688 16.984375 Z M 21.15625 19.480469',
		),
		'balance-scale-left' => array(
			'p' => 'M 33 28 L 22 28 L 22 9.578125 C 23.277344 9.019531 24.257812 7.9375 24.710938 6.609375 L 32.960938 3.84375 C 33.484375 3.667969 33.765625 3.101562 33.589844 2.578125 L 32.957031 0.683594 C 32.78125 0.160156 32.214844 -0.125 31.6875 0.0507812 L 24.320312 2.523438 C 23.457031 1.023438 21.855469 0 20 0 C 17.238281 0 15 2.238281 15 5 C 15 5.214844 15.035156 5.417969 15.0625 5.625 L 7.039062 8.316406 C 6.515625 8.492188 6.234375 9.058594 6.410156 9.582031 L 7.042969 11.480469 C 7.21875 12.003906 7.785156 12.285156 8.3125 12.109375 L 17.1875 9.132812 C 17.441406 9.304688 17.714844 9.453125 18 9.578125 L 18 31 C 18 31.550781 18.449219 32 19 32 L 33 32 C 33.554688 32 34 31.550781 34 31 L 34 29 C 34 28.449219 33.550781 28 33 28 Z M 40 19 C 40 17.988281 40.082031 18.453125 34.683594 7.65625 C 33.578125 5.449219 30.421875 5.445312 29.316406 7.65625 C 23.871094 18.546875 24 18.019531 24 19 C 24 21.761719 27.582031 24 32 24 C 36.417969 24 40 21.761719 40 19 Z M 27.5 18 L 32 9 L 36.5 18 Z M 10.683594 15.65625 C 9.578125 13.449219 6.421875 13.445312 5.316406 15.65625 C -0.128906 26.546875 0 26.019531 0 27 C 0 29.761719 3.582031 32 8 32 C 12.417969 32 16 29.761719 16 27 C 16 25.988281 16.082031 26.453125 10.683594 15.65625 Z M 3.5 26 L 8 17 L 12.5 26 Z M 3.5 26',
			'vw' => 40
		),
		'balance-scale-right' => array(
			'p' => 'M 6 29 L 6 31 C 6 31.550781 6.449219 32 7 32 L 21 32 C 21.550781 32 22 31.550781 22 31 L 22 9.578125 C 22.285156 9.453125 22.558594 9.304688 22.8125 9.132812 L 31.691406 12.109375 C 32.214844 12.285156 32.78125 12.003906 32.957031 11.480469 L 33.59375 9.582031 C 33.765625 9.058594 33.484375 8.492188 32.960938 8.316406 L 24.9375 5.625 C 24.964844 5.417969 25 5.214844 25 5 C 25 2.238281 22.761719 0 20 0 C 18.144531 0 16.542969 1.023438 15.679688 2.523438 L 8.308594 0.0507812 C 7.785156 -0.125 7.21875 0.160156 7.042969 0.683594 L 6.40625 2.578125 C 6.234375 3.101562 6.515625 3.667969 7.039062 3.84375 L 15.289062 6.609375 C 15.742188 7.9375 16.722656 9.019531 18 9.578125 L 18 28 L 7 28 C 6.449219 28 6 28.449219 6 29 Z M 0 19 C 0 21.761719 3.582031 24 8 24 C 12.417969 24 16 21.761719 16 19 C 16 18.019531 16.128906 18.546875 10.683594 7.65625 C 9.578125 5.445312 6.417969 5.449219 5.316406 7.65625 C -0.0820312 18.453125 0 17.988281 0 19 Z M 3.5 18 L 8 9 L 12.5 18 Z M 24 27 C 24 29.761719 27.582031 32 32 32 C 36.417969 32 40 29.761719 40 27 C 40 26.019531 40.128906 26.546875 34.683594 15.65625 C 33.578125 13.445312 30.417969 13.449219 29.316406 15.65625 C 23.917969 26.453125 24 25.988281 24 27 Z M 27.5 26 L 32 17 L 36.5 26 Z M 27.5 26',
			'vw' => 40
		),
		'biking' => array(
			'p' => 'M 25 6 C 26.65625 6 28 4.65625 28 3 C 28 1.34375 26.65625 0 25 0 C 23.34375 0 22 1.34375 22 3 C 22 4.65625 23.34375 6 25 6 Z M 24.75 13.5625 C 25.105469 13.847656 25.546875 14 26 14 L 30 14 C 31.105469 14 32 13.105469 32 12 C 32 10.894531 31.105469 10 30 10 L 26.703125 10 L 22.25 6.4375 C 21.5 5.835938 20.429688 5.855469 19.699219 6.480469 L 12.699219 12.480469 C 12.222656 12.886719 11.96875 13.492188 12.003906 14.117188 C 12.042969 14.742188 12.371094 15.316406 12.890625 15.664062 L 18 19.070312 L 18 26 C 18 27.105469 18.894531 28 20 28 C 21.105469 28 22 27.105469 22 26 L 22 18 C 22 17.332031 21.664062 16.707031 21.109375 16.335938 L 18.523438 14.613281 L 22.164062 11.492188 Z M 32 16 C 27.582031 16 24 19.582031 24 24 C 24 28.417969 27.582031 32 32 32 C 36.417969 32 40 28.417969 40 24 C 40 19.582031 36.417969 16 32 16 Z M 32 28 C 29.789062 28 28 26.210938 28 24 C 28 21.789062 29.789062 20 32 20 C 34.210938 20 36 21.789062 36 24 C 36 26.210938 34.210938 28 32 28 Z M 8 16 C 3.582031 16 0 19.582031 0 24 C 0 28.417969 3.582031 32 8 32 C 12.417969 32 16 28.417969 16 24 C 16 19.582031 12.417969 16 8 16 Z M 8 28 C 5.789062 28 4 26.210938 4 24 C 4 21.789062 5.789062 20 8 20 C 10.210938 20 12 21.789062 12 24 C 12 26.210938 10.210938 28 8 28 Z M 8 28',
			'vw' => 40
		),
		'border-all' => array(
			'p' => 'M 26 2 L 2 2 C 0.894531 2 0 2.894531 0 4 L 0 28 C 0 29.105469 0.894531 30 2 30 L 26 30 C 27.105469 30 28 29.105469 28 28 L 28 4 C 28 2.894531 27.105469 2 26 2 Z M 24 6 L 24 14 L 16 14 L 16 6 Z M 12 6 L 12 14 L 4 14 L 4 6 Z M 4 26 L 4 18 L 12 18 L 12 26 Z M 16 26 L 16 18 L 24 18 L 24 26 Z M 16 26',
			'vw' => 28
		),
		'border-none' => array(
			'p' => 'M 15 14 L 13 14 C 12.449219 14 12 14.449219 12 15 L 12 17 C 12 17.550781 12.449219 18 13 18 L 15 18 C 15.550781 18 16 17.550781 16 17 L 16 15 C 16 14.449219 15.550781 14 15 14 Z M 21 14 L 19 14 C 18.449219 14 18 14.449219 18 15 L 18 17 C 18 17.550781 18.449219 18 19 18 L 21 18 C 21.550781 18 22 17.550781 22 17 L 22 15 C 22 14.449219 21.550781 14 21 14 Z M 27 14 L 25 14 C 24.449219 14 24 14.449219 24 15 L 24 17 C 24 17.550781 24.449219 18 25 18 L 27 18 C 27.550781 18 28 17.550781 28 17 L 28 15 C 28 14.449219 27.550781 14 27 14 Z M 9 14 L 7 14 C 6.449219 14 6 14.449219 6 15 L 6 17 C 6 17.550781 6.449219 18 7 18 L 9 18 C 9.550781 18 10 17.550781 10 17 L 10 15 C 10 14.449219 9.550781 14 9 14 Z M 15 26 L 13 26 C 12.449219 26 12 26.449219 12 27 L 12 29 C 12 29.550781 12.449219 30 13 30 L 15 30 C 15.550781 30 16 29.550781 16 29 L 16 27 C 16 26.449219 15.550781 26 15 26 Z M 21 26 L 19 26 C 18.449219 26 18 26.449219 18 27 L 18 29 C 18 29.550781 18.449219 30 19 30 L 21 30 C 21.550781 30 22 29.550781 22 29 L 22 27 C 22 26.449219 21.550781 26 21 26 Z M 27 26 L 25 26 C 24.449219 26 24 26.449219 24 27 L 24 29 C 24 29.550781 24.449219 30 25 30 L 27 30 C 27.550781 30 28 29.550781 28 29 L 28 27 C 28 26.449219 27.550781 26 27 26 Z M 27 20 L 25 20 C 24.449219 20 24 20.449219 24 21 L 24 23 C 24 23.550781 24.449219 24 25 24 L 27 24 C 27.550781 24 28 23.550781 28 23 L 28 21 C 28 20.449219 27.550781 20 27 20 Z M 27 8 L 25 8 C 24.449219 8 24 8.449219 24 9 L 24 11 C 24 11.550781 24.449219 12 25 12 L 27 12 C 27.550781 12 28 11.550781 28 11 L 28 9 C 28 8.449219 27.550781 8 27 8 Z M 15 20 L 13 20 C 12.449219 20 12 20.449219 12 21 L 12 23 C 12 23.550781 12.449219 24 13 24 L 15 24 C 15.550781 24 16 23.550781 16 23 L 16 21 C 16 20.449219 15.550781 20 15 20 Z M 15 8 L 13 8 C 12.449219 8 12 8.449219 12 9 L 12 11 C 12 11.550781 12.449219 12 13 12 L 15 12 C 15.550781 12 16 11.550781 16 11 L 16 9 C 16 8.449219 15.550781 8 15 8 Z M 9 26 L 7 26 C 6.449219 26 6 26.449219 6 27 L 6 29 C 6 29.550781 6.449219 30 7 30 L 9 30 C 9.550781 30 10 29.550781 10 29 L 10 27 C 10 26.449219 9.550781 26 9 26 Z M 15 2 L 13 2 C 12.449219 2 12 2.449219 12 3 L 12 5 C 12 5.550781 12.449219 6 13 6 L 15 6 C 15.550781 6 16 5.550781 16 5 L 16 3 C 16 2.449219 15.550781 2 15 2 Z M 21 2 L 19 2 C 18.449219 2 18 2.449219 18 3 L 18 5 C 18 5.550781 18.449219 6 19 6 L 21 6 C 21.550781 6 22 5.550781 22 5 L 22 3 C 22 2.449219 21.550781 2 21 2 Z M 27 2 L 25 2 C 24.449219 2 24 2.449219 24 3 L 24 5 C 24 5.550781 24.449219 6 25 6 L 27 6 C 27.550781 6 28 5.550781 28 5 L 28 3 C 28 2.449219 27.550781 2 27 2 Z M 3 14 L 1 14 C 0.449219 14 0 14.449219 0 15 L 0 17 C 0 17.550781 0.449219 18 1 18 L 3 18 C 3.550781 18 4 17.550781 4 17 L 4 15 C 4 14.449219 3.550781 14 3 14 Z M 3 26 L 1 26 C 0.449219 26 0 26.449219 0 27 L 0 29 C 0 29.550781 0.449219 30 1 30 L 3 30 C 3.550781 30 4 29.550781 4 29 L 4 27 C 4 26.449219 3.550781 26 3 26 Z M 3 20 L 1 20 C 0.449219 20 0 20.449219 0 21 L 0 23 C 0 23.550781 0.449219 24 1 24 L 3 24 C 3.550781 24 4 23.550781 4 23 L 4 21 C 4 20.449219 3.550781 20 3 20 Z M 3 8 L 1 8 C 0.449219 8 0 8.449219 0 9 L 0 11 C 0 11.550781 0.449219 12 1 12 L 3 12 C 3.550781 12 4 11.550781 4 11 L 4 9 C 4 8.449219 3.550781 8 3 8 Z M 3 2 L 1 2 C 0.449219 2 0 2.449219 0 3 L 0 5 C 0 5.550781 0.449219 6 1 6 L 3 6 C 3.550781 6 4 5.550781 4 5 L 4 3 C 4 2.449219 3.550781 2 3 2 Z M 9 2 L 7 2 C 6.449219 2 6 2.449219 6 3 L 6 5 C 6 5.550781 6.449219 6 7 6 L 9 6 C 9.550781 6 10 5.550781 10 5 L 10 3 C 10 2.449219 9.550781 2 9 2 Z M 9 2',
			'vw' => 28
		),
		'border-style' => array(
			'p' => 'M 15 26 L 13 26 C 12.449219 26 12 26.449219 12 27 L 12 29 C 12 29.550781 12.449219 30 13 30 L 15 30 C 15.550781 30 16 29.550781 16 29 L 16 27 C 16 26.449219 15.550781 26 15 26 Z M 9 26 L 7 26 C 6.449219 26 6 26.449219 6 27 L 6 29 C 6 29.550781 6.449219 30 7 30 L 9 30 C 9.550781 30 10 29.550781 10 29 L 10 27 C 10 26.449219 9.550781 26 9 26 Z M 21 26 L 19 26 C 18.449219 26 18 26.449219 18 27 L 18 29 C 18 29.550781 18.449219 30 19 30 L 21 30 C 21.550781 30 22 29.550781 22 29 L 22 27 C 22 26.449219 21.550781 26 21 26 Z M 27 14 L 25 14 C 24.449219 14 24 14.449219 24 15 L 24 17 C 24 17.550781 24.449219 18 25 18 L 27 18 C 27.550781 18 28 17.550781 28 17 L 28 15 C 28 14.449219 27.550781 14 27 14 Z M 27 20 L 25 20 C 24.449219 20 24 20.449219 24 21 L 24 23 C 24 23.550781 24.449219 24 25 24 L 27 24 C 27.550781 24 28 23.550781 28 23 L 28 21 C 28 20.449219 27.550781 20 27 20 Z M 27 26 L 25 26 C 24.449219 26 24 26.449219 24 27 L 24 29 C 24 29.550781 24.449219 30 25 30 L 27 30 C 27.550781 30 28 29.550781 28 29 L 28 27 C 28 26.449219 27.550781 26 27 26 Z M 27 8 L 25 8 C 24.449219 8 24 8.449219 24 9 L 24 11 C 24 11.550781 24.449219 12 25 12 L 27 12 C 27.550781 12 28 11.550781 28 11 L 28 9 C 28 8.449219 27.550781 8 27 8 Z M 27 2 L 2 2 C 0.894531 2 0 2.894531 0 4 L 0 29 C 0 29.550781 0.449219 30 1 30 L 3 30 C 3.550781 30 4 29.550781 4 29 L 4 6 L 27 6 C 27.550781 6 28 5.550781 28 5 L 28 3 C 28 2.449219 27.550781 2 27 2 Z M 27 2',
			'vw' => 28
		),
		'box-tissue' => array(
			'p' => 'M 23.992188 17.988281 L 27.992188 5.988281 L 21.15625 5.988281 C 19.265625 5.988281 17.589844 4.78125 16.992188 2.988281 C 16.394531 1.195312 14.71875 -0.0117188 12.828125 -0.0117188 L 3.992188 -0.0117188 L 7.992188 17.988281 Z M -0.0078125 29.988281 C -0.0078125 31.09375 0.886719 31.988281 1.992188 31.988281 L 29.992188 31.988281 C 31.097656 31.988281 31.992188 31.09375 31.992188 29.988281 L 31.992188 25.988281 L -0.0078125 25.988281 Z M 29.992188 13.988281 L 27.433594 13.988281 L 26.101562 17.988281 L 26.992188 17.988281 C 27.542969 17.988281 27.992188 18.4375 27.992188 18.988281 C 27.992188 19.542969 27.542969 19.988281 26.992188 19.988281 L 4.992188 19.988281 C 4.441406 19.988281 3.992188 19.542969 3.992188 18.988281 C 3.992188 18.4375 4.441406 17.988281 4.992188 17.988281 L 5.941406 17.988281 L 5.054688 13.988281 L 1.992188 13.988281 C 0.886719 13.988281 -0.0078125 14.882812 -0.0078125 15.988281 L -0.0078125 23.988281 L 31.992188 23.988281 L 31.992188 15.988281 C 31.992188 14.882812 31.097656 13.988281 29.992188 13.988281 Z M 29.992188 13.988281',
		),
		'caravan' => array(
			'p' => 'M 26 13 C 25.449219 13 25 13.449219 25 14 C 25 14.550781 25.449219 15 26 15 C 26.550781 15 27 14.550781 27 14 C 27 13.449219 26.550781 13 26 13 Z M 39 20 L 36 20 L 36 10 C 36 4.476562 31.523438 0 26 0 L 4 0 C 1.789062 0 0 1.789062 0 4 L 0 20 C 0 22.210938 1.789062 24 4 24 L 6 24 C 6 27.3125 8.6875 30 12 30 C 15.3125 30 18 27.3125 18 24 L 39 24 C 39.550781 24 40 23.550781 40 23 L 40 21 C 40 20.449219 39.550781 20 39 20 Z M 12 27 C 10.34375 27 9 25.65625 9 24 C 9 22.34375 10.34375 21 12 21 C 13.65625 21 15 22.34375 15 24 C 15 25.65625 13.65625 27 12 27 Z M 16 12 C 16 13.105469 15.105469 14 14 14 L 6 14 C 4.894531 14 4 13.105469 4 12 L 4 8 C 4 6.894531 4.894531 6 6 6 L 14 6 C 15.105469 6 16 6.894531 16 8 Z M 28 20 L 20 20 L 20 8 C 20 6.894531 20.894531 6 22 6 L 26 6 C 27.105469 6 28 6.894531 28 8 Z M 28 20',
			'vw' => 40
		),
		'compress-alt' => array(
			'p' => 'M 0.292969 26.707031 L 6.5 20.5 L 4.441406 18.5625 C 3.496094 17.617188 4.167969 16 5.503906 16 L 12.503906 16 C 13.332031 16 14 16.671875 14 17.5 L 14 24.5 C 14 25.835938 12.386719 26.503906 11.441406 25.5625 L 9.5 23.5 L 3.292969 29.707031 C 2.902344 30.097656 2.269531 30.097656 1.878906 29.707031 L 0.292969 28.121094 C -0.0976562 27.730469 -0.0976562 27.097656 0.292969 26.707031 Z M 27.707031 5.292969 L 21.5 11.5 L 23.558594 13.4375 C 24.503906 14.382812 23.832031 16 22.496094 16 L 15.496094 16 C 14.667969 16 14 15.328125 14 14.5 L 14 7.5 C 14 6.164062 15.613281 5.496094 16.558594 6.4375 L 18.5 8.5 L 24.707031 2.292969 C 25.097656 1.902344 25.730469 1.902344 26.121094 2.292969 L 27.707031 3.878906 C 28.097656 4.269531 28.097656 4.902344 27.707031 5.292969 Z M 27.707031 5.292969',
			'vw' => 28
		),
		'disease' => array(
			'p' => 'M 29.519531 12.242188 L 25.328125 10.804688 C 24.121094 10.394531 23.230469 9.5 22.941406 8.410156 L 21.941406 4.632812 C 21.21875 1.898438 17.15625 1.0625 15.066406 3.21875 L 12.1875 6.203125 C 11.359375 7.058594 10.089844 7.511719 8.800781 7.410156 L 4.304688 7.058594 C 1.054688 6.804688 -1.125 9.863281 0.617188 12.234375 L 3.027344 15.511719 C 3.71875 16.453125 3.828125 17.628906 3.316406 18.652344 L 1.539062 22.214844 C 0.25 24.792969 2.964844 27.519531 6.132812 26.828125 L 10.507812 25.871094 C 11.765625 25.597656 13.097656 25.871094 14.074219 26.605469 L 17.46875 29.15625 C 19.925781 31.003906 23.78125 29.628906 23.996094 26.832031 L 24.289062 22.964844 C 24.375 21.851562 25.089844 20.847656 26.203125 20.277344 L 30.078125 18.292969 C 32.882812 16.859375 32.550781 13.28125 29.519531 12.242188 Z M 10 16 C 8.894531 16 8 15.105469 8 14 C 8 12.894531 8.894531 12 10 12 C 11.105469 12 12 12.894531 12 14 C 12 15.105469 11.105469 16 10 16 Z M 18 22 C 16.894531 22 16 21.105469 16 20 C 16 18.894531 16.894531 18 18 18 C 19.105469 18 20 18.894531 20 20 C 20 21.105469 19.105469 22 18 22 Z M 19 14 C 18.449219 14 18 13.550781 18 13 C 18 12.449219 18.449219 12 19 12 C 19.550781 12 20 12.449219 20 13 C 20 13.550781 19.550781 14 19 14 Z M 19 14',
		),
		'expand-alt' => array(
			'p' => 'M 13.292969 19.707031 L 7.5 25.5 L 9.558594 27.4375 C 10.503906 28.382812 9.832031 30 8.496094 30 L 1.496094 30 C 0.667969 30 0 29.328125 0 28.5 L 0 21.5 C 0 20.164062 1.613281 19.496094 2.558594 20.4375 L 4.5 22.5 L 10.292969 16.707031 C 10.683594 16.316406 11.316406 16.316406 11.707031 16.707031 L 13.292969 18.292969 C 13.683594 18.683594 13.683594 19.316406 13.292969 19.707031 Z M 14.707031 12.292969 L 20.5 6.5 L 18.441406 4.5625 C 17.496094 3.617188 18.167969 2 19.503906 2 L 26.503906 2 C 27.332031 2 28 2.671875 28 3.5 L 28 10.5 C 28 11.835938 26.386719 12.503906 25.441406 11.5625 L 23.5 9.5 L 17.707031 15.292969 C 17.316406 15.683594 16.683594 15.683594 16.292969 15.292969 L 14.707031 13.707031 C 14.316406 13.316406 14.316406 12.683594 14.707031 12.292969 Z M 14.707031 12.292969',
			'vw' => 28
		),
		'fan' => array(
			'p' => 'M 22.035156 8 C 20.28125 8 18.65625 8.28125 17.21875 8.804688 L 17.996094 1.109375 C 18.0625 0.457031 17.488281 -0.0742188 16.832031 0.0078125 C 11.851562 0.632812 8 4.851562 8 9.964844 C 8 11.71875 8.28125 13.34375 8.804688 14.78125 L 1.109375 14.003906 C 0.457031 13.9375 -0.0742188 14.511719 0.0078125 15.167969 C 0.632812 20.148438 4.851562 24 9.964844 24 C 11.71875 24 13.34375 23.71875 14.78125 23.195312 L 14.003906 30.890625 C 13.9375 31.542969 14.511719 32.074219 15.167969 31.992188 C 20.148438 31.367188 24 27.148438 24 22.035156 C 24 20.28125 23.71875 18.65625 23.195312 17.21875 L 30.890625 17.996094 C 31.542969 18.0625 32.074219 17.488281 31.992188 16.832031 C 31.367188 11.851562 27.148438 8 22.035156 8 Z M 16 18 C 14.894531 18 14 17.105469 14 16 C 14 14.894531 14.894531 14 16 14 C 17.105469 14 18 14.894531 18 16 C 18 17.105469 17.105469 18 16 18 Z M 16 18',
		),
		'faucet' => array(
			'p' => 'M 22 16 L 19.585938 16 C 18.605469 15.160156 17.371094 14.558594 16 14.25 L 16 11.277344 L 14 11.066406 L 12 11.277344 L 12 14.25 C 10.628906 14.5625 9.394531 15.164062 8.414062 16 L 1 16 C 0.449219 16 0 16.449219 0 17 L 0 23 C 0 23.550781 0.449219 24 1 24 L 6.800781 24 C 8.085938 26.359375 10.8125 28 14 28 C 17.1875 28 19.914062 26.359375 21.199219 24 L 22 24 C 23.105469 24 24 24.894531 24 26 C 24 27.105469 24.894531 28 26 28 L 30 28 C 31.105469 28 32 27.105469 32 26 C 32 20.476562 27.523438 16 22 16 Z M 5.097656 9.996094 L 14 9.058594 L 22.902344 9.996094 C 23.488281 10.058594 24 9.570312 24 8.945312 L 24 7.054688 C 24 6.429688 23.488281 5.941406 22.902344 6.003906 L 16 6.734375 L 16 5 C 16 4.449219 15.550781 4 15 4 L 13 4 C 12.449219 4 12 4.449219 12 5 L 12 6.734375 L 5.097656 6.003906 C 4.511719 5.941406 4 6.429688 4 7.054688 L 4 8.945312 C 4 9.570312 4.511719 10.058594 5.097656 9.996094 Z M 5.097656 9.996094',
		),
		'hand-holding-medical' => array(
			'p' => 'M 9.992188 10.988281 L 13.992188 10.988281 L 13.992188 14.988281 C 13.992188 15.542969 14.441406 15.988281 14.992188 15.988281 L 18.992188 15.988281 C 19.542969 15.988281 19.992188 15.542969 19.992188 14.988281 L 19.992188 10.988281 L 23.992188 10.988281 C 24.542969 10.988281 24.992188 10.542969 24.992188 9.988281 L 24.992188 5.988281 C 24.992188 5.4375 24.542969 4.988281 23.992188 4.988281 L 19.992188 4.988281 L 19.992188 0.988281 C 19.992188 0.4375 19.542969 -0.0117188 18.992188 -0.0117188 L 14.992188 -0.0117188 C 14.441406 -0.0117188 13.992188 0.4375 13.992188 0.988281 L 13.992188 4.988281 L 9.992188 4.988281 C 9.441406 4.988281 8.992188 5.4375 8.992188 5.988281 L 8.992188 9.988281 C 8.992188 10.542969 9.441406 10.988281 9.992188 10.988281 Z M 35.503906 21.007812 C 35.113281 20.472656 34.523438 20.117188 33.867188 20.015625 C 33.210938 19.917969 32.542969 20.082031 32.007812 20.480469 L 24.53125 25.988281 L 16.992188 25.988281 C 16.4375 25.988281 15.992188 25.542969 15.992188 24.988281 C 15.992188 24.4375 16.4375 23.988281 16.992188 23.988281 L 21.882812 23.988281 C 22.882812 23.988281 23.804688 23.3125 23.96875 22.328125 C 24.066406 21.746094 23.902344 21.152344 23.519531 20.699219 C 23.140625 20.25 22.582031 19.992188 21.992188 19.992188 L 11.992188 19.992188 C 10.304688 19.992188 8.667969 20.570312 7.359375 21.632812 L 4.453125 23.988281 L 0.992188 23.988281 C 0.441406 23.992188 -0.00390625 24.4375 -0.0078125 24.988281 L -0.0078125 30.988281 C -0.00390625 31.539062 0.441406 31.984375 0.992188 31.988281 L 22.679688 31.988281 C 24.066406 31.988281 25.417969 31.542969 26.535156 30.722656 L 34.976562 24.5 C 36.085938 23.679688 36.320312 22.117188 35.503906 21.007812 Z M 35.503906 21.007812',
			'vw' => 36
		),
		'hand-holding-water' => array(
			'p' => 'M 18 16 C 21.3125 16 24 13.367188 24 10.125 C 24 7.625 20.429688 2.582031 18.800781 0.398438 C 18.398438 -0.132812 17.601562 -0.132812 17.199219 0.398438 C 15.570312 2.582031 12 7.625 12 10.125 C 12 13.367188 14.6875 16 18 16 Z M 35.332031 20.507812 C 34.59375 19.835938 33.445312 19.882812 32.667969 20.507812 L 26.894531 25.125 C 26.1875 25.695312 25.304688 26 24.394531 26 L 17 26 C 16.449219 26 16 25.550781 16 25 C 16 24.449219 16.449219 24 17 24 L 21.894531 24 C 22.886719 24 23.8125 23.320312 23.976562 22.335938 C 24.179688 21.085938 23.21875 20 22 20 L 12 20 C 10.3125 20 8.679688 20.582031 7.367188 21.644531 L 4.460938 24 L 1 24 C 0.449219 24 0 24.449219 0 25 L 0 31 C 0 31.550781 0.449219 32 1 32 L 23.300781 32 C 24.207031 32 25.085938 31.695312 25.800781 31.125 L 35.25 23.5625 C 36.199219 22.804688 36.273438 21.355469 35.332031 20.507812 Z M 35.332031 20.507812',
			'vw' => 36
		),
		'handshake-alt-slash' => array(
			'p' => 'M 22.410156 12.226562 L 31.511719 19.613281 C 32.242188 20.210938 32.734375 21.050781 32.902344 21.980469 L 39 21.980469 C 39.550781 21.980469 40 21.535156 40 20.980469 L 40 8.996094 C 39.996094 8.445312 39.550781 8 39 8 L 32 8 L 28.589844 4.589844 C 28.214844 4.210938 27.707031 4 27.175781 4 L 21.808594 4 C 21.308594 4 20.824219 4.1875 20.457031 4.527344 L 14.949219 9.566406 L 13.34375 8.328125 L 18.066406 4 L 12.832031 4 C 12.300781 4 11.792969 4.210938 11.417969 4.589844 L 10.148438 5.855469 L 2.84375 0.210938 C 2.632812 0.046875 2.367188 -0.0234375 2.101562 0.0078125 C 1.839844 0.0390625 1.601562 0.175781 1.4375 0.386719 L 0.210938 1.964844 C -0.128906 2.402344 -0.0507812 3.03125 0.386719 3.371094 L 37.160156 31.789062 C 37.59375 32.128906 38.222656 32.050781 38.5625 31.613281 L 39.789062 30.035156 C 40.128906 29.597656 40.050781 28.96875 39.613281 28.632812 L 18.960938 12.671875 L 21.003906 10.800781 L 22.691406 9.257812 C 23.101562 8.882812 23.734375 8.910156 24.105469 9.320312 C 24.480469 9.726562 24.453125 10.359375 24.042969 10.730469 Z M 1 8 C 0.449219 8 0 8.449219 0 9 L 0 20.996094 C 0 21.546875 0.449219 21.996094 1 21.996094 L 9.144531 21.996094 L 14.800781 27.113281 C 16.515625 28.503906 19.03125 28.246094 20.425781 26.53125 L 20.4375 26.519531 L 21.558594 27.488281 C 22.550781 28.296875 24.015625 28.144531 24.824219 27.152344 L 25.375 26.472656 L 1.472656 8 Z M 1 8',
			'vw' => 40
		),
		'handshake-slash' => array(
			'p' => 'M 0 8.011719 L 0 24 L 4 24 C 5.105469 24 6 23.105469 6 22 L 6 11.5 L 1.488281 8.011719 Z M 3 20.007812 C 3.550781 20.007812 4 20.453125 4 21.007812 C 4 21.558594 3.550781 22.007812 3 22.007812 C 2.449219 22.007812 2 21.558594 2 21.007812 C 2 20.453125 2.449219 20.007812 3 20.007812 Z M 8 21.996094 L 9.144531 21.996094 L 14.800781 27.113281 C 16.515625 28.503906 19.03125 28.246094 20.425781 26.53125 L 20.4375 26.519531 L 21.558594 27.488281 C 22.550781 28.296875 24.015625 28.144531 24.824219 27.152344 L 25.375 26.472656 L 8 13.046875 Z M 34 8.011719 L 34 22.007812 C 34 23.109375 34.894531 24.007812 36 24.007812 L 40 24.007812 L 40 8.011719 Z M 37 22.007812 C 36.449219 22.007812 36 21.558594 36 21.007812 C 36 20.453125 36.449219 20.007812 37 20.007812 C 37.550781 20.007812 38 20.453125 38 21.007812 C 38 21.558594 37.550781 22.007812 37 22.007812 Z M 18.957031 12.667969 L 22.683594 9.257812 C 23.089844 8.898438 23.710938 8.929688 24.078125 9.332031 C 24.445312 9.734375 24.425781 10.355469 24.03125 10.730469 L 22.402344 12.226562 L 31.5 19.613281 C 31.675781 19.761719 31.84375 19.921875 31.996094 20.09375 L 31.996094 8 L 28.582031 4.589844 C 28.207031 4.210938 27.699219 4 27.167969 4 L 21.800781 4 C 21.300781 4 20.816406 4.1875 20.449219 4.527344 L 14.945312 9.566406 L 13.34375 8.328125 L 18.066406 4 L 12.832031 4 C 12.300781 4 11.792969 4.210938 11.417969 4.589844 L 10.148438 5.859375 L 2.84375 0.210938 C 2.632812 0.046875 2.367188 -0.0234375 2.101562 0.0078125 C 1.839844 0.0390625 1.601562 0.175781 1.4375 0.386719 L 0.210938 1.964844 C -0.128906 2.402344 -0.0507812 3.03125 0.386719 3.371094 L 37.15625 31.789062 C 37.367188 31.953125 37.632812 32.027344 37.898438 31.992188 C 38.160156 31.960938 38.398438 31.824219 38.5625 31.613281 L 39.789062 30.035156 C 40.128906 29.597656 40.050781 28.96875 39.613281 28.632812 Z M 18.957031 12.667969',
			'vw' => 40
		),
		'hand-sparkles' => array(
			'p' => 'M 6.667969 10.664062 L 6.671875 10.664062 L 9.769531 9.375 C 9.90625 9.296875 9.992188 9.15625 10 9 C 9.992188 8.84375 9.90625 8.703125 9.769531 8.625 L 6.671875 7.332031 L 6.667969 7.332031 L 5.375 4.230469 C 5.304688 4.089844 5.160156 4 5.003906 4 C 4.84375 4 4.699219 4.089844 4.628906 4.230469 L 3.335938 7.332031 L 3.332031 7.332031 L 0.230469 8.625 C 0.09375 8.703125 0.0078125 8.84375 0 9 C 0.0078125 9.15625 0.09375 9.296875 0.230469 9.375 L 3.328125 10.664062 L 3.332031 10.664062 L 4.625 13.765625 C 4.695312 13.90625 4.839844 13.996094 4.996094 13.996094 C 5.15625 13.996094 5.300781 13.90625 5.371094 13.765625 L 6.664062 10.664062 Z M 29.460938 29.214844 L 29.398438 29.1875 L 29.335938 29.15625 C 28.519531 28.746094 28.003906 27.910156 28.003906 26.996094 C 28.003906 26.082031 28.519531 25.246094 29.335938 24.835938 L 29.398438 24.804688 L 29.460938 24.777344 L 31.804688 23.800781 L 32.78125 21.457031 L 32.808594 21.394531 L 32.835938 21.335938 C 33.078125 20.851562 33.496094 20.484375 33.984375 20.25 C 33.984375 20.167969 34 20.082031 34 20 L 34 9 C 34 7.894531 33.105469 7 32 7 C 30.894531 7 30 7.894531 30 9 L 30 13.5 C 30 13.777344 29.777344 14 29.5 14 L 28.5 14 C 28.222656 14 28 13.777344 28 13.5 L 28 4 C 28 2.894531 27.105469 2 26 2 C 24.894531 2 24 2.894531 24 4 L 24 13.5 C 24 13.777344 23.777344 14 23.5 14 L 22.5 14 C 22.222656 14 22 13.777344 22 13.5 L 22 2 C 22 0.894531 21.105469 0 20 0 C 18.894531 0 18 0.894531 18 2 L 18 13.5 C 18 13.777344 17.777344 14 17.5 14 L 16.5 14 C 16.222656 14 16 13.777344 16 13.5 L 16 4 C 16 2.894531 15.105469 2 14 2 C 12.894531 2 12 2.894531 12 4 L 12 19.0625 L 10.527344 17.03125 C 9.714844 15.914062 8.148438 15.667969 7.03125 16.480469 C 5.914062 17.292969 5.667969 18.859375 6.480469 19.976562 L 14.332031 30.761719 C 14.894531 31.539062 15.796875 32 16.753906 32 L 29.105469 32 C 30.308594 32 31.335938 31.265625 31.808594 30.199219 L 31.804688 30.191406 Z M 21.863281 21.21875 L 20 21.996094 L 19.222656 23.855469 C 19.179688 23.941406 19.09375 23.996094 19 23.996094 C 18.90625 23.996094 18.820312 23.941406 18.777344 23.855469 L 18 21.996094 L 16.136719 21.21875 C 16.054688 21.175781 16 21.089844 16 20.996094 C 16 20.902344 16.054688 20.816406 16.136719 20.773438 L 18 19.996094 L 18.777344 18.136719 C 18.820312 18.050781 18.90625 17.996094 19 17.996094 C 19.09375 17.996094 19.179688 18.050781 19.222656 18.136719 L 20 19.996094 L 21.863281 20.773438 C 21.945312 20.816406 22 20.902344 22 20.996094 C 22 21.089844 21.945312 21.175781 21.863281 21.21875 Z M 40 26.996094 C 39.992188 26.839844 39.90625 26.695312 39.769531 26.621094 L 36.671875 25.328125 L 36.667969 25.328125 L 35.375 22.226562 C 35.304688 22.085938 35.160156 21.996094 35.003906 21.996094 C 34.84375 21.996094 34.699219 22.085938 34.628906 22.226562 L 33.335938 25.328125 L 33.332031 25.328125 L 30.230469 26.625 C 30.09375 26.703125 30.007812 26.84375 30 27 C 30.007812 27.15625 30.097656 27.296875 30.230469 27.371094 L 33.328125 28.664062 L 33.332031 28.664062 L 34.625 31.761719 C 34.695312 31.90625 34.839844 31.996094 34.996094 31.996094 C 35.15625 31.996094 35.300781 31.90625 35.371094 31.761719 L 36.664062 28.660156 L 36.667969 28.660156 L 39.765625 27.371094 C 39.902344 27.292969 39.988281 27.152344 39.996094 27 Z M 40 26.996094',
			'vw' => 40
		),
		'hands-wash' => array(
			'p' => 'M 31 14 C 32.65625 14 34 12.65625 34 11 C 34 9.34375 32.65625 8 31 8 C 29.34375 8 28 9.34375 28 11 C 28 12.65625 29.34375 14 31 14 Z M 19.46875 11.152344 C 19.800781 11.050781 20.148438 11 20.5 11 C 20.90625 11.003906 21.308594 11.078125 21.6875 11.21875 L 22.648438 8.179688 C 22.785156 7.75 22.71875 7.28125 22.472656 6.90625 C 22.226562 6.527344 21.824219 6.28125 21.375 6.234375 C 20.65625 6.148438 19.988281 6.636719 19.769531 7.328125 L 18.460938 11.464844 Z M 5.851562 24.144531 C 5.902344 24.132812 5.949219 24.113281 6 24.101562 L 6 22.496094 C 6.003906 18.292969 8.699219 14.5625 12.691406 13.246094 L 17.296875 11.824219 L 19.433594 5.066406 C 19.570312 4.636719 19.503906 4.167969 19.257812 3.792969 C 19.011719 3.414062 18.609375 3.167969 18.160156 3.121094 C 17.441406 3.039062 16.773438 3.523438 16.554688 4.214844 L 14.464844 10.867188 C 14.378906 11.132812 14.097656 11.277344 13.835938 11.195312 C 13.574219 11.109375 13.425781 10.828125 13.511719 10.566406 L 16.21875 1.953125 C 16.355469 1.523438 16.292969 1.058594 16.046875 0.679688 C 15.800781 0.304688 15.398438 0.0585938 14.949219 0.0078125 C 14.230469 -0.0742188 13.5625 0.414062 13.34375 1.105469 L 10.347656 10.585938 C 10.265625 10.847656 9.984375 10.996094 9.71875 10.910156 C 9.457031 10.828125 9.3125 10.546875 9.394531 10.285156 L 11.804688 2.660156 C 11.941406 2.230469 11.875 1.761719 11.628906 1.386719 C 11.382812 1.007812 10.980469 0.761719 10.53125 0.714844 C 9.8125 0.625 9.144531 1.113281 8.925781 1.804688 L 5.175781 13.671875 L 5.046875 10.542969 C 5.050781 9.714844 4.386719 9.039062 3.554688 9.035156 C 2.730469 9.03125 2.011719 9.691406 2 10.527344 L 2 17.570312 C 2.039062 20.289062 3.503906 22.785156 5.851562 24.144531 Z M 32.445312 21 L 22.5 21 C 22.222656 21 22 20.777344 22 20.5 C 22 20.222656 22.222656 20 22.5 20 L 30.5 20 C 30.949219 20 31.375 19.796875 31.660156 19.449219 C 31.945312 19.101562 32.058594 18.644531 31.972656 18.203125 C 31.835938 17.488281 31.167969 17 30.445312 17 L 18 17 L 20.941406 15.933594 C 21.734375 15.6875 22.179688 14.847656 21.933594 14.058594 C 21.6875 13.265625 20.847656 12.820312 20.058594 13.066406 L 13.324219 15.144531 C 10.148438 16.1875 8 19.15625 8 22.5 L 8 24.101562 C 9.460938 24.398438 10.710938 25.328125 11.414062 26.644531 C 12.117188 27.957031 12.191406 29.515625 11.625 30.890625 C 12.789062 31.613281 14.132812 31.996094 15.5 32 L 28.5 32 C 28.949219 32 29.375 31.796875 29.660156 31.449219 C 29.945312 31.101562 30.058594 30.644531 29.972656 30.203125 C 29.835938 29.488281 29.167969 29 28.445312 29 L 22.5 29 C 22.222656 29 22 28.777344 22 28.5 C 22 28.222656 22.222656 28 22.5 28 L 30.5 28 C 30.949219 28 31.375 27.796875 31.660156 27.449219 C 31.945312 27.101562 32.058594 26.644531 31.972656 26.203125 C 31.835938 25.488281 31.167969 25 30.445312 25 L 22.5 25 C 22.222656 25 22 24.777344 22 24.5 C 22 24.222656 22.222656 24 22.5 24 L 32.5 24 C 32.949219 24 33.375 23.796875 33.660156 23.449219 C 33.945312 23.101562 34.058594 22.644531 33.972656 22.203125 C 33.835938 21.488281 33.167969 21 32.445312 21 Z M 26 4 C 27.105469 4 28 3.105469 28 2 C 28 0.894531 27.105469 0 26 0 C 24.894531 0 24 0.894531 24 2 C 24 3.105469 24.894531 4 26 4 Z M 7 26 C 5.34375 26 4 27.34375 4 29 C 4 30.65625 5.34375 32 7 32 C 8.65625 32 10 30.65625 10 29 C 10 27.34375 8.65625 26 7 26 Z M 7 26',
			'vw' => 36
		),
		'hat-cowboy' => array(
			'p' => 'M 30.625 18.554688 C 30.03125 14.96875 28.15625 4 24.519531 4 C 23.644531 4 22.863281 4.371094 22.207031 4.875 C 20.902344 5.867188 19.097656 5.867188 17.796875 4.875 C 17.136719 4.375 16.359375 4 15.484375 4 C 11.84375 4 9.96875 14.96875 9.375 18.554688 C 11.800781 19.34375 15.234375 20 20 20 C 24.765625 20 28.203125 19.34375 30.625 18.554688 Z M 39.554688 16.234375 C 39.171875 15.976562 38.664062 16.011719 38.320312 16.328125 C 38.257812 16.382812 31.992188 22 20 22 C 8.074219 22 1.734375 16.378906 1.671875 16.324219 C 1.332031 16.015625 0.824219 15.980469 0.441406 16.234375 C 0.0625 16.492188 -0.09375 16.976562 0.0625 17.40625 C 0.109375 17.535156 4.894531 30 20 30 C 35.105469 30 39.890625 17.535156 39.9375 17.40625 C 40.097656 16.976562 39.941406 16.488281 39.558594 16.234375 Z M 39.554688 16.234375',
			'vw' => 40
		),
		'hat-cowboy-side' => array(
			'p' => 'M 16.300781 18.191406 C 14.511719 16.757812 12.425781 16 10.273438 16 C 5.4375 16 1.34375 19.921875 0.0898438 25.753906 C -0.132812 26.792969 0.0625 27.867188 0.625 28.710938 C 1.171875 29.53125 1.988281 30 2.867188 30 L 37 30 C 30.550781 30 27.3125 27.683594 22.425781 23.472656 Z M 30.964844 17.046875 L 29.273438 7.261719 C 29.089844 6.191406 28.476562 5.238281 27.578125 4.628906 C 26.675781 4.015625 25.566406 3.800781 24.5 4.027344 L 12.554688 6.5625 C 10.859375 6.921875 9.589844 8.328125 9.40625 10.050781 L 8.976562 14.125 C 9.40625 14.074219 9.832031 14 10.273438 14 C 12.886719 14 15.398438 14.910156 17.605469 16.675781 L 23.730469 21.957031 C 28.171875 25.785156 30.929688 28 37 28 C 38.65625 28 40 26.65625 40 25 C 40 23.414062 38.148438 17.542969 30.964844 17.046875 Z M 30.964844 17.046875',
			'vw' => 40
		),
		'head-side-cough' => array(
			'p' => 'M 38.5 19 C 39.328125 19 40 18.328125 40 17.5 C 40 16.671875 39.328125 16 38.5 16 C 37.671875 16 37 16.671875 37 17.5 C 37 18.328125 37.671875 19 38.5 19 Z M 34.5 26 C 33.671875 26 33 26.671875 33 27.5 C 33 28.328125 33.671875 29 34.5 29 C 35.328125 29 36 28.328125 36 27.5 C 36 26.671875 35.328125 26 34.5 26 Z M 30.5 22.5 C 29.671875 22.5 29 23.171875 29 24 C 29 24.828125 29.671875 25.5 30.5 25.5 C 31.328125 25.5 32 24.828125 32 24 C 32 23.171875 31.328125 22.5 30.5 22.5 Z M 38.5 29 C 37.671875 29 37 29.671875 37 30.5 C 37 31.328125 37.671875 32 38.5 32 C 39.328125 32 40 31.328125 40 30.5 C 40 29.671875 39.328125 29 38.5 29 Z M 38.5 22.5 C 37.671875 22.5 37 23.171875 37 24 C 37 24.828125 37.671875 25.5 38.5 25.5 C 39.328125 25.5 40 24.828125 40 24 C 40 23.171875 39.328125 22.5 38.5 22.5 Z M 34.5 20 C 33.671875 20 33 20.671875 33 21.5 C 33 22.328125 33.671875 23 34.5 23 C 35.328125 23 36 22.328125 36 21.5 C 36 20.671875 35.328125 20 34.5 20 Z M 29.828125 17.1875 C 28.515625 14.242188 26.796875 7.703125 25.257812 5.515625 C 22.820312 2.058594 18.859375 0.00390625 14.632812 0 L 12 0 C 5.375 0 0 5.375 0 12 C 0 15.546875 1.546875 18.726562 4 20.929688 L 4 32 L 18 32 L 18 30 L 22 30 C 24.210938 30 26 28.210938 26 26 L 20 26 C 18.894531 26 18 25.105469 18 24 C 18 22.894531 18.894531 22 20 22 L 26 22 L 26 20 L 28 20 C 28.675781 20 29.308594 19.65625 29.675781 19.089844 C 30.042969 18.523438 30.101562 17.804688 29.828125 17.1875 Z M 18 14 C 16.894531 14 16 13.105469 16 12 C 16 10.894531 16.894531 10 18 10 C 19.105469 10 20 10.894531 20 12 C 19.996094 13.105469 19.105469 13.996094 18 14 Z M 18 14',
			'vw' => 40
		),
		'head-side-cough-slash' => array(
			'p' => 'M 28.382812 19.949219 C 29.605469 19.710938 30.359375 18.386719 29.828125 17.1875 C 28.515625 14.242188 26.796875 7.703125 25.257812 5.515625 C 22.820312 2.058594 18.859375 0.00390625 14.632812 0 L 12 0 C 9.59375 -0.00390625 7.246094 0.722656 5.261719 2.082031 L 2.839844 0.210938 C 2.40625 -0.128906 1.777344 -0.0507812 1.4375 0.386719 L 0.210938 1.964844 C -0.128906 2.402344 -0.0507812 3.03125 0.386719 3.371094 L 37.15625 31.789062 C 37.367188 31.953125 37.632812 32.027344 37.898438 31.992188 C 38.160156 31.960938 38.398438 31.824219 38.5625 31.613281 L 39.789062 30.035156 C 40.128906 29.597656 40.050781 28.96875 39.613281 28.632812 Z M 19.585938 13.152344 L 16.476562 10.75 C 16.84375 10.304688 17.378906 10 18 10 C 19.101562 10.003906 19.996094 10.894531 20 12 C 20 12.4375 19.828125 12.824219 19.585938 13.152344 Z M 38.5 19 C 39.328125 19 40 18.328125 40 17.5 C 40 16.671875 39.328125 16 38.5 16 C 37.671875 16 37 16.671875 37 17.5 C 37 18.328125 37.671875 19 38.5 19 Z M 34.5 23 C 35.328125 23 36 22.328125 36 21.5 C 36 20.671875 35.328125 20 34.5 20 C 33.671875 20 33 20.671875 33 21.5 C 33 22.328125 33.671875 23 34.5 23 Z M 18 24 C 18 22.894531 18.894531 22 20 22 L 21.222656 22 L 1.296875 6.597656 C 0.445312 8.273438 0 10.121094 0 12 C 0 15.546875 1.546875 18.726562 4 20.929688 L 4 32 L 18 32 L 18 30 L 22 30 C 24.210938 30 26 28.210938 26 26 L 20 26 C 18.894531 26 18 25.105469 18 24 Z M 38.5 22.5 C 37.671875 22.5 37 23.171875 37 24 C 37 24.828125 37.671875 25.5 38.5 25.5 C 39.328125 25.5 40 24.828125 40 24 C 40 23.171875 39.328125 22.5 38.5 22.5 Z M 38.5 22.5',
			'vw' => 40
		),
		'head-side-mask' => array(
			'p' => 'M 0.0078125 11.527344 C -0.136719 15.261719 1.4375 18.628906 4 20.929688 L 4 32 L 14 32 L 14 19.78125 L 0.230469 9.765625 C 0.109375 10.347656 0.0351562 10.933594 0.0078125 11.527344 Z M 31.828125 17.1875 C 30.515625 14.242188 28.796875 7.703125 27.257812 5.515625 C 24.820312 2.058594 20.859375 0.00390625 16.632812 0 L 12.5 0 C 7.3125 0 2.65625 3.160156 0.828125 7.726562 L 14.949219 18 L 31.984375 18 C 31.992188 17.722656 31.9375 17.445312 31.828125 17.1875 Z M 20 14 C 18.894531 14 18 13.105469 18 12 C 18 10.894531 18.894531 10 20 10 C 21.105469 10 22 10.894531 22 12 C 21.996094 13.105469 21.105469 13.996094 20 14 Z M 21 23 L 31 23 L 32 20 L 16 20 L 16 32 L 25.117188 32 C 26.839844 32 28.367188 30.898438 28.910156 29.265625 L 29 29 L 21 29 C 20.449219 29 20 28.550781 20 28 C 20 27.449219 20.449219 27 21 27 L 29.667969 27 L 30.332031 25 L 21 25 C 20.449219 25 20 24.550781 20 24 C 20 23.449219 20.449219 23 21 23 Z M 21 23',
		),
		'head-side-virus' => array(
			'p' => 'M 17 15 C 16.449219 15 16 15.449219 16 16 C 16 16.550781 16.449219 17 17 17 C 17.550781 17 18 16.550781 18 16 C 18 15.449219 17.550781 15 17 15 Z M 13 11 C 12.449219 11 12 11.449219 12 12 C 12 12.550781 12.449219 13 13 13 C 13.550781 13 14 12.550781 14 12 C 14 11.449219 13.550781 11 13 11 Z M 31.824219 17.1875 C 30.515625 14.242188 28.796875 7.703125 27.257812 5.515625 C 24.824219 2.058594 20.859375 0 16.628906 0 L 12 0 C 5.375 0 0 5.375 0 12 C 0 15.410156 1.453125 18.65625 4 20.925781 L 4 32 L 20 32 L 20 28 L 24 28 C 26.210938 28 28 26.210938 28 24 L 28 20 L 30 20 C 30.675781 20 31.308594 19.65625 31.675781 19.089844 C 32.042969 18.519531 32.101562 17.804688 31.824219 17.1875 Z M 23 15 L 22.242188 15 C 20.460938 15 19.566406 17.15625 20.828125 18.414062 L 21.363281 18.949219 C 21.753906 19.339844 21.753906 19.972656 21.363281 20.363281 C 20.972656 20.753906 20.339844 20.753906 19.949219 20.363281 L 19.414062 19.828125 C 18.15625 18.566406 16 19.460938 16 21.242188 L 16 22 C 16 22.550781 15.550781 23 15 23 C 14.449219 23 14 22.550781 14 22 L 14 21.242188 C 14 19.460938 11.84375 18.566406 10.585938 19.828125 L 10.050781 20.363281 C 9.660156 20.753906 9.027344 20.753906 8.636719 20.363281 C 8.246094 19.972656 8.246094 19.339844 8.636719 18.949219 L 9.171875 18.414062 C 10.433594 17.15625 9.539062 15 7.757812 15 L 7 15 C 6.449219 15 6 14.550781 6 14 C 6 13.449219 6.449219 13 7 13 L 7.757812 13 C 9.539062 13 10.433594 10.84375 9.171875 9.585938 L 8.636719 9.050781 C 8.246094 8.660156 8.246094 8.027344 8.636719 7.636719 C 9.027344 7.246094 9.660156 7.246094 10.050781 7.636719 L 10.585938 8.171875 C 11.84375 9.433594 14 8.539062 14 6.757812 L 14 6 C 14 5.449219 14.449219 5 15 5 C 15.550781 5 16 5.449219 16 6 L 16 6.757812 C 16 8.539062 18.15625 9.433594 19.414062 8.171875 L 19.949219 7.636719 C 20.339844 7.246094 20.972656 7.246094 21.363281 7.636719 C 21.753906 8.027344 21.753906 8.660156 21.363281 9.050781 L 20.828125 9.585938 C 19.566406 10.84375 20.460938 13 22.242188 13 L 23 13 C 23.550781 13 24 13.449219 24 14 C 24 14.550781 23.550781 15 23 15 Z M 23 15',
		),
		'hospital-user' => array(
			'p' => 'M 30 20 C 33.3125 20 36 17.3125 36 14 C 36 10.6875 33.3125 8 30 8 C 26.6875 8 24 10.6875 24 14 C 24 17.3125 26.6875 20 30 20 Z M 33 22 C 32.851562 22 32.703125 22.023438 32.558594 22.066406 C 30.902344 22.644531 29.097656 22.644531 27.441406 22.066406 C 27.296875 22.023438 27.148438 22 27 22 C 25.136719 22 23.351562 22.742188 22.035156 24.0625 C 20.722656 25.386719 19.988281 27.175781 20 29.039062 C 20.007812 30.679688 21.359375 32 23 32 L 37 32 C 38.640625 32 39.992188 30.679688 40 29.039062 C 40.011719 27.175781 39.277344 25.386719 37.964844 24.0625 C 36.648438 22.742188 34.863281 22 33 22 Z M 20.621094 22.652344 C 21.042969 22.238281 21.503906 21.863281 22 21.539062 L 22 8 C 22 6.894531 21.105469 6 20 6 L 18 6 L 18 2 C 18 0.894531 17.105469 0 16 0 L 6 0 C 4.894531 0 4 0.894531 4 2 L 4 6 L 2 6 C 0.894531 6 0 6.894531 0 8 L 0 31 C 0 31.550781 0.449219 32 1 32 L 19.019531 32 C 18.367188 31.152344 18.011719 30.117188 18 29.050781 C 17.980469 26.652344 18.925781 24.347656 20.621094 22.652344 Z M 9 25.25 C 9 25.664062 8.664062 26 8.25 26 L 5.75 26 C 5.335938 26 5 25.664062 5 25.25 L 5 22.75 C 5 22.335938 5.335938 22 5.75 22 L 8.25 22 C 8.664062 22 9 22.335938 9 22.75 Z M 9 17.25 C 9 17.664062 8.664062 18 8.25 18 L 5.75 18 C 5.335938 18 5 17.664062 5 17.25 L 5 14.75 C 5 14.335938 5.335938 14 5.75 14 L 8.25 14 C 8.664062 14 9 14.335938 9 14.75 Z M 12 9.625 C 12 9.832031 11.832031 10 11.625 10 L 10.375 10 C 10.167969 10 10 9.832031 10 9.625 L 10 8 L 8.375 8 C 8.167969 8 8 7.832031 8 7.625 L 8 6.375 C 8 6.167969 8.167969 6 8.375 6 L 10 6 L 10 4.375 C 10 4.167969 10.167969 4 10.375 4 L 11.625 4 C 11.832031 4 12 4.167969 12 4.375 L 12 6 L 13.625 6 C 13.832031 6 14 6.167969 14 6.375 L 14 7.625 C 14 7.832031 13.832031 8 13.625 8 L 12 8 Z M 17 25.25 C 17 25.664062 16.664062 26 16.25 26 L 13.75 26 C 13.335938 26 13 25.664062 13 25.25 L 13 22.75 C 13 22.335938 13.335938 22 13.75 22 L 16.25 22 C 16.664062 22 17 22.335938 17 22.75 Z M 17 17.25 C 17 17.664062 16.664062 18 16.25 18 L 13.75 18 C 13.335938 18 13 17.664062 13 17.25 L 13 14.75 C 13 14.335938 13.335938 14 13.75 14 L 16.25 14 C 16.664062 14 17 14.335938 17 14.75 Z M 17 17.25',
			'vw' => 40
		),
		'house-user' => array(
			'p' => 'M 35.667969 14.765625 L 32 11.527344 L 32 3 C 32 2.449219 31.550781 2 31 2 L 27 2 C 26.449219 2 26 2.449219 26 3 L 26 6.230469 L 19.671875 0.644531 C 19.28125 0.289062 18.53125 0 18 0 C 17.46875 0 16.722656 0.289062 16.328125 0.644531 L 0.328125 14.769531 C 0.132812 14.96875 0.015625 15.234375 0 15.511719 C 0.0117188 15.757812 0.101562 15.992188 0.253906 16.183594 L 1.59375 17.667969 C 1.800781 17.855469 2.066406 17.972656 2.34375 18 C 2.585938 17.976562 2.816406 17.886719 3.011719 17.742188 L 4.003906 16.867188 L 4.003906 30 C 4.003906 31.105469 4.902344 32 6.003906 32 L 30 32 C 31.105469 32 32 31.105469 32 30 L 32 16.867188 L 32.996094 17.742188 C 33.191406 17.886719 33.421875 17.976562 33.664062 18 C 33.941406 17.972656 34.199219 17.855469 34.40625 17.667969 L 35.746094 16.179688 C 35.886719 15.984375 35.976562 15.753906 36 15.511719 C 35.972656 15.234375 35.855469 14.972656 35.667969 14.765625 Z M 18 11 C 20.210938 11 22 12.789062 22 15 C 22 17.210938 20.210938 19 18 19 C 15.789062 19 14 17.210938 14 15 C 14 12.789062 15.789062 11 18 11 Z M 25 28 L 11 28 C 10.449219 28 10 27.550781 10 27 C 10 23.6875 12.6875 21 16 21 L 20 21 C 23.3125 21 26 23.6875 26 27 C 26 27.550781 25.550781 28 25 28 Z M 25 28',
			'vw' => 36
		),
		'icons' => array(
			'p' => 'M 7.289062 13.710938 C 7.476562 13.902344 7.730469 14.011719 8 14.011719 C 8.265625 14.011719 8.519531 13.902344 8.707031 13.710938 L 14.753906 7.46875 C 16.511719 5.65625 16.410156 2.652344 14.445312 0.976562 C 12.734375 -0.480469 10.1875 -0.21875 8.617188 1.402344 L 8 2.035156 L 7.382812 1.402344 C 5.816406 -0.21875 3.265625 -0.480469 1.554688 0.976562 C -0.410156 2.652344 -0.507812 5.65625 1.242188 7.46875 Z M 16.285156 19.988281 L 13.285156 19.988281 L 12.84375 19.101562 C 12.59375 18.429688 11.953125 17.988281 11.238281 17.988281 L 6.757812 17.988281 C 6.042969 17.988281 5.402344 18.429688 5.152344 19.101562 L 4.714844 19.988281 L 1.714844 19.988281 C 0.769531 19.988281 0 20.757812 0 21.707031 L 0 30.285156 C 0 31.230469 0.765625 32 1.714844 32 L 16.285156 32 C 17.234375 32 18 31.230469 18 30.285156 L 18 21.707031 C 18 20.757812 17.234375 19.992188 16.285156 19.988281 Z M 9 29.25 C 7.203125 29.25 5.75 27.796875 5.75 26 C 5.75 24.203125 7.203125 22.75 9 22.75 C 10.796875 22.75 12.25 24.203125 12.25 26 C 12.25 27.796875 10.796875 29.25 9 29.25 Z M 31.210938 22.007812 L 27.425781 22.007812 L 28.824219 18.835938 C 28.953125 18.417969 28.578125 18.007812 28.0625 18.007812 L 23.339844 18.007812 C 22.945312 18.007812 22.609375 18.253906 22.558594 18.578125 L 21.507812 25.261719 C 21.445312 25.65625 21.8125 26.003906 22.289062 26.003906 L 26.183594 26.003906 L 24.671875 31.191406 C 24.550781 31.605469 24.933594 31.996094 25.433594 31.996094 C 25.703125 32.003906 25.957031 31.882812 26.117188 31.667969 L 31.890625 22.988281 C 32.195312 22.554688 31.820312 22.007812 31.210938 22.007812 Z M 29.878906 0.0195312 L 20.59375 1.449219 C 19.679688 1.589844 19 2.433594 19 3.425781 L 19 10.101562 C 18.671875 10.03125 18.335938 9.996094 18 9.992188 C 15.789062 9.992188 14 11.335938 14 12.992188 C 14 14.652344 15.789062 15.992188 18 15.992188 C 20.199219 15.992188 21.984375 14.660156 22 13.015625 L 22 6.230469 L 29 5.152344 L 29 8.101562 C 28.671875 8.035156 28.335938 7.996094 28 7.996094 C 25.789062 7.996094 24 9.335938 24 10.996094 C 24 12.652344 25.789062 13.996094 28 13.996094 C 30.199219 13.996094 31.984375 12.664062 32 11.015625 L 32 2 C 32 0.78125 31 -0.152344 29.878906 0.0195312 Z M 29.878906 0.0195312',
		),
		'laptop-house' => array(
			'p' => 'M 17 18 L 13 18 C 12.449219 18 12 17.550781 12 17 L 12 13 C 12 12.449219 12.449219 12 13 12 L 17 12 C 17.550781 12 18 12.449219 18 13 L 18 15.320312 C 18.695312 14.515625 19.6875 14 20.800781 14 L 29.359375 14 L 29.773438 13.53125 C 29.910156 13.359375 29.988281 13.152344 30 12.9375 C 29.984375 12.6875 29.878906 12.453125 29.703125 12.273438 L 26 9 L 26 3 C 26 2.449219 25.550781 2 25 2 L 23 2 C 22.449219 2 22 2.449219 22 3 L 22 5.457031 L 16.46875 0.558594 C 16.125 0.25 15.464844 0 15.003906 0 C 14.539062 0 13.882812 0.25 13.535156 0.558594 L 0.296875 12.277344 C 0.121094 12.453125 0.015625 12.6875 0 12.9375 C 0.0117188 13.152344 0.0898438 13.355469 0.222656 13.523438 L 1.394531 14.855469 C 1.574219 15.035156 1.8125 15.140625 2.0625 15.15625 C 2.273438 15.144531 2.480469 15.070312 2.644531 14.9375 L 4 13.742188 L 4 24 C 4 25.105469 4.894531 26 6 26 L 17 26 Z M 39.332031 28 L 37 28 L 37 18 C 37 16.894531 36.195312 16 35.199219 16 L 20.800781 16 C 19.804688 16 19 16.894531 19 18 L 19 28 L 16.667969 28 C 16.296875 28 16 28.296875 16 28.667969 L 16 29.332031 C 16.003906 30.800781 17.195312 31.992188 18.664062 32 L 37.335938 32 C 38.804688 31.992188 39.996094 30.800781 40 29.332031 L 40 28.667969 C 40 28.296875 39.703125 28 39.332031 28 Z M 34 28 L 22 28 L 22 19 L 34 19 Z M 34 28',
			'vw' => 40
		),
		'lungs' => array(
			'p' => 'M 39.757812 24.382812 C 38.402344 19.304688 36.253906 14.4375 33.382812 9.945312 C 32 7.785156 31.125 6 28.378906 6 C 25.960938 6 24 7.839844 24 10.105469 L 24 13.863281 L 21.945312 12.492188 C 21.667969 12.308594 21.5 11.996094 21.5 11.660156 L 21.5 1 C 21.5 0.449219 21.050781 0 20.5 0 L 19.5 0 C 18.949219 0 18.5 0.449219 18.5 1 L 18.5 11.660156 C 18.5 11.996094 18.332031 12.308594 18.054688 12.492188 L 16 13.863281 L 16 10.105469 C 16 7.839844 14.039062 6 11.621094 6 C 8.875 6 8 7.785156 6.617188 9.945312 C 3.746094 14.4375 1.597656 19.304688 0.242188 24.382812 C 0.0820312 24.988281 0 25.613281 0 26.234375 C 0 30.0625 3.90625 32.828125 7.828125 31.773438 L 11.546875 30.777344 C 14.183594 30.070312 16 27.8125 16 25.238281 L 16 19.769531 L 10.636719 23.347656 C 10.523438 23.421875 10.390625 23.449219 10.257812 23.421875 C 10.128906 23.394531 10.015625 23.320312 9.941406 23.210938 L 9.386719 22.378906 C 9.3125 22.265625 9.285156 22.132812 9.3125 22.003906 C 9.339844 21.871094 9.414062 21.757812 9.527344 21.683594 L 20 14.703125 L 30.472656 21.683594 C 30.703125 21.835938 30.765625 22.148438 30.613281 22.378906 L 30.058594 23.210938 C 29.90625 23.4375 29.59375 23.5 29.363281 23.347656 L 24 19.769531 L 24 25.238281 C 24 27.8125 25.816406 30.070312 28.453125 30.777344 L 32.171875 31.773438 C 36.09375 32.828125 40 30.0625 40 26.234375 C 40 25.613281 39.917969 24.988281 39.757812 24.382812 Z M 39.757812 24.382812',
			'vw' => 40
		),
		'lungs-virus' => array(
			'p' => 'M 21.5 9.417969 L 21.5 1 C 21.5 0.449219 21.050781 0 20.5 0 L 19.5 0 C 18.949219 0 18.5 0.449219 18.5 1 L 18.5 9.417969 C 19.421875 8.859375 20.578125 8.859375 21.5 9.417969 Z M 12.222656 27.777344 C 11.050781 26.605469 11.050781 24.707031 12.222656 23.535156 L 12.757812 23 L 12 23 C 10.34375 23 9 21.65625 9 20 C 9 18.34375 10.34375 17 12 17 L 12.757812 17 L 12.222656 16.464844 C 11.125 15.375 11.03125 13.632812 12.011719 12.4375 C 12.988281 11.238281 14.714844 10.980469 16 11.839844 L 16 10.109375 C 16 7.835938 14.039062 6 11.625 6 C 8.875 6 8 7.78125 6.617188 9.945312 C 3.757812 14.398438 1.609375 19.269531 0.242188 24.382812 C 0.0820312 24.988281 0 25.609375 0 26.234375 C 0 30.0625 3.90625 32.828125 7.828125 31.773438 L 11.546875 30.78125 C 12.847656 30.4375 14 29.671875 14.828125 28.609375 C 13.875 28.785156 12.898438 28.472656 12.222656 27.777344 Z M 26.363281 26.363281 C 26.753906 25.972656 26.753906 25.339844 26.363281 24.949219 L 25.828125 24.414062 C 24.566406 23.15625 25.460938 21 27.242188 21 L 28 21 C 28.550781 21 29 20.550781 29 20 C 29 19.449219 28.550781 19 28 19 L 27.242188 19 C 25.460938 19 24.566406 16.84375 25.828125 15.585938 L 26.363281 15.050781 C 26.753906 14.660156 26.753906 14.027344 26.363281 13.636719 C 25.972656 13.246094 25.339844 13.246094 24.949219 13.636719 L 24.414062 14.171875 C 23.15625 15.433594 21 14.539062 21 12.757812 L 21 12 C 21 11.449219 20.550781 11 20 11 C 19.449219 11 19 11.449219 19 12 L 19 12.757812 C 19 14.539062 16.84375 15.433594 15.585938 14.171875 L 15.050781 13.636719 C 14.660156 13.246094 14.027344 13.246094 13.636719 13.636719 C 13.246094 14.027344 13.246094 14.660156 13.636719 15.050781 L 14.171875 15.585938 C 15.433594 16.84375 14.539062 19 12.757812 19 L 12 19 C 11.449219 19 11 19.449219 11 20 C 11 20.550781 11.449219 21 12 21 L 12.757812 21 C 14.539062 21 15.433594 23.15625 14.171875 24.414062 L 13.636719 24.949219 C 13.375 25.203125 13.273438 25.574219 13.367188 25.921875 C 13.457031 26.269531 13.730469 26.542969 14.078125 26.636719 C 14.425781 26.726562 14.796875 26.625 15.050781 26.363281 L 15.585938 25.828125 C 16.84375 24.570312 19 25.460938 19 27.242188 L 19 28 C 19 28.550781 19.449219 29 20 29 C 20.550781 29 21 28.550781 21 28 L 21 27.242188 C 21 25.460938 23.15625 24.570312 24.414062 25.828125 L 24.949219 26.363281 C 25.339844 26.753906 25.972656 26.753906 26.363281 26.363281 Z M 18 19 C 17.449219 19 17 18.550781 17 18 C 17 17.449219 17.449219 17 18 17 C 18.550781 17 19 17.449219 19 18 C 19 18.550781 18.550781 19 18 19 Z M 22 23 C 21.449219 23 21 22.550781 21 22 C 21 21.449219 21.449219 21 22 21 C 22.550781 21 23 21.449219 23 22 C 23 22.550781 22.550781 23 22 23 Z M 39.757812 24.382812 C 38.390625 19.269531 36.242188 14.398438 33.382812 9.945312 C 32 7.78125 31.125 6 28.375 6 C 25.960938 6 24 7.835938 24 10.109375 L 24 11.84375 C 25.285156 10.984375 27.011719 11.242188 27.988281 12.4375 C 28.96875 13.636719 28.875 15.378906 27.777344 16.46875 L 27.242188 17 L 28 17 C 29.65625 17 31 18.34375 31 20 C 31 21.65625 29.65625 23 28 23 L 27.242188 23 L 27.777344 23.535156 C 28.722656 24.449219 28.953125 25.871094 28.355469 27.039062 C 27.753906 28.207031 26.464844 28.84375 25.171875 28.609375 C 26 29.671875 27.152344 30.4375 28.453125 30.78125 L 32.171875 31.773438 C 36.09375 32.828125 40 30.0625 40 26.234375 C 40 25.609375 39.917969 24.988281 39.757812 24.382812 Z M 39.757812 24.382812',
			'vw' => 40
		),
		'mouse' => array(
			'p' => 'M 0 22 C 0 27.523438 4.476562 32 10 32 L 14 32 C 19.523438 32 24 27.523438 24 22 L 24 14 L 0 14 Z M 11 0 L 10 0 C 4.476562 0 0 4.476562 0 10 L 0 12 L 11 12 Z M 14 0 L 13 0 L 13 12 L 24 12 L 24 10 C 24 4.476562 19.523438 0 14 0 Z M 14 0',
			'vw' => 24
		),
		'people-arrows' => array(
			'p' => 'M 6 8 C 8.210938 8 10 6.210938 10 4 C 10 1.789062 8.210938 0 6 0 C 3.789062 0 2 1.789062 2 4 C 2 6.210938 3.789062 8 6 8 Z M 6 19.003906 C 6 18.25 6.304688 17.527344 6.851562 17.003906 L 11.359375 12.75 C 11.464844 12.652344 11.597656 12.605469 11.710938 12.527344 C 11.109375 11.003906 9.636719 10 8 10 L 4 10 C 1.789062 10 0 11.789062 0 14 L 0 20 C 0 21.105469 0.894531 22 2 22 L 2 30 C 2 31.105469 2.894531 32 4 32 L 8 32 C 9.105469 32 10 31.105469 10 30 L 10 23.976562 L 6.851562 21.003906 C 6.304688 20.484375 5.996094 19.761719 6 19.003906 Z M 30 8 C 32.210938 8 34 6.210938 34 4 C 34 1.789062 32.210938 0 30 0 C 27.789062 0 26 1.789062 26 4 C 26 6.210938 27.789062 8 30 8 Z M 32 10 L 28 10 C 26.363281 10 24.890625 11.003906 24.289062 12.527344 C 24.402344 12.605469 24.539062 12.652344 24.640625 12.75 L 29.148438 17.003906 C 29.691406 17.527344 30 18.25 30 19.003906 C 30 19.757812 29.691406 20.480469 29.148438 21.003906 L 26 23.976562 L 26 30 C 26 31.105469 26.894531 32 28 32 L 32 32 C 33.105469 32 34 31.105469 34 30 L 34 22 C 35.105469 22 36 21.105469 36 20 L 36 14 C 36 11.789062 34.210938 10 32 10 Z M 27.773438 18.457031 L 23.265625 14.203125 C 23.050781 13.996094 22.730469 13.941406 22.453125 14.058594 C 22.175781 14.175781 22 14.449219 22 14.75 L 22 17 L 14 17 L 14 14.75 C 14 14.449219 13.824219 14.175781 13.546875 14.058594 C 13.269531 13.941406 12.949219 13.996094 12.734375 14.203125 L 8.226562 18.457031 C 7.925781 18.761719 7.925781 19.25 8.226562 19.550781 L 12.734375 23.804688 C 12.949219 24.011719 13.269531 24.070312 13.546875 23.949219 C 13.824219 23.832031 14 23.558594 14 23.257812 L 14 21 L 22 21 L 22 23.257812 C 22 23.558594 22.175781 23.832031 22.453125 23.949219 C 22.730469 24.070312 23.050781 24.011719 23.265625 23.804688 L 27.773438 19.550781 C 28.074219 19.25 28.074219 18.761719 27.773438 18.457031 Z M 27.773438 18.457031',
			'vw' => 36
		),
		'phone-alt' => array(
			'p' => 'M 31.085938 22.613281 L 24.085938 19.613281 C 23.472656 19.351562 22.757812 19.527344 22.335938 20.042969 L 19.238281 23.832031 C 14.371094 21.539062 10.457031 17.621094 8.164062 12.757812 L 11.949219 9.65625 C 12.46875 9.234375 12.644531 8.519531 12.382812 7.90625 L 9.382812 0.90625 C 9.089844 0.242188 8.371094 -0.121094 7.664062 0.0390625 L 1.164062 1.539062 C 0.480469 1.695312 0 2.300781 0 3 C 0 19.03125 12.992188 32 29 32 C 29.699219 32 30.304688 31.519531 30.460938 30.835938 L 31.960938 24.335938 C 32.121094 23.625 31.753906 22.902344 31.085938 22.613281 Z M 31.085938 22.613281',
		),
		'phone-square-alt' => array(
			'p' => 'M 25 2 L 3 2 C 1.34375 2 0 3.34375 0 5 L 0 27 C 0 28.65625 1.34375 30 3 30 L 25 30 C 26.65625 30 28 28.65625 28 27 L 28 5 C 28 3.34375 26.65625 2 25 2 Z M 23.976562 21.210938 L 23.039062 25.273438 C 22.941406 25.699219 22.5625 26 22.125 26 C 12.125 26 4 17.894531 4 7.875 C 4.015625 7.445312 4.308594 7.074219 4.726562 6.960938 L 8.789062 6.023438 C 8.859375 6.007812 8.929688 6 9 6 C 9.371094 6.019531 9.699219 6.234375 9.863281 6.566406 L 11.738281 10.941406 C 11.78125 11.0625 11.808594 11.1875 11.8125 11.3125 C 11.796875 11.589844 11.675781 11.851562 11.46875 12.039062 L 9.101562 13.976562 C 10.535156 17.015625 12.984375 19.464844 16.023438 20.898438 L 17.960938 18.53125 C 18.148438 18.324219 18.410156 18.203125 18.6875 18.1875 C 18.8125 18.191406 18.9375 18.21875 19.058594 18.261719 L 23.433594 20.136719 C 23.765625 20.300781 23.980469 20.628906 24 21 C 24 21.070312 23.992188 21.140625 23.976562 21.210938 Z M 23.976562 21.210938',
			'vw' => 28
		),
		'photo-video' => array(
			'p' => 'M 38 0 L 10 0 C 8.894531 0 8 0.894531 8 2 L 8 8 L 18 8 L 18 4 L 30 4 L 30 24 L 38 24 C 39.105469 24 40 23.105469 40 22 L 40 2 C 40 0.894531 39.105469 0 38 0 Z M 14.5 6.4375 C 14.5 6.75 14.25 7 13.9375 7 L 12.0625 7 C 11.75 7 11.5 6.75 11.5 6.4375 L 11.5 4.5625 C 11.5 4.25 11.75 4 12.0625 4 L 13.9375 4 C 14.25 4 14.5 4.25 14.5 4.5625 Z M 36.5 19.4375 C 36.5 19.75 36.25 20 35.9375 20 L 34.0625 20 C 33.75 20 33.5 19.75 33.5 19.4375 L 33.5 17.5625 C 33.5 17.25 33.75 17 34.0625 17 L 35.9375 17 C 36.25 17 36.5 17.25 36.5 17.5625 Z M 36.5 12.9375 C 36.5 13.25 36.25 13.5 35.9375 13.5 L 34.0625 13.5 C 33.75 13.5 33.5 13.25 33.5 12.9375 L 33.5 11.0625 C 33.5 10.75 33.75 10.5 34.0625 10.5 L 35.9375 10.5 C 36.25 10.5 36.5 10.75 36.5 11.0625 Z M 36.5 6.4375 C 36.5 6.75 36.25 7 35.9375 7 L 34.0625 7 C 33.75 7 33.5 6.75 33.5 6.4375 L 33.5 4.5625 C 33.5 4.25 33.75 4 34.0625 4 L 35.9375 4 C 36.25 4 36.5 4.25 36.5 4.5625 Z M 26 10 L 2 10 C 0.894531 10 0 10.894531 0 12 L 0 30 C 0 31.105469 0.894531 32 2 32 L 26 32 C 27.105469 32 28 31.105469 28 30 L 28 12 C 28 10.894531 27.105469 10 26 10 Z M 6 14 C 7.105469 14 8 14.894531 8 16 C 8 17.105469 7.105469 18 6 18 C 4.894531 18 4 17.105469 4 16 C 4 14.894531 4.894531 14 6 14 Z M 24 28 L 4 28 L 4 26 L 8 22 L 10 24 L 18 16 L 24 22 Z M 24 28',
			'vw' => 40
		),
		'airplay' => array(
			'p' => 'M8.1 25.9L23.9 25.9 16 16.8ZM11.4 19.8L6.1 19.8 6.1 8.6 25.9 8.6 25.9 19.8 20.6 19.8 21.5 20.8 26.9 20.8 26.9 7.6 5.1 7.6 5.1 20.8 10.5 20.8ZM11.4 19.8'
		),
		'plane-slash' => array(
			'p' => 'M 2.03125 9.242188 L 4 16 L 2.03125 22.757812 C 1.957031 23.058594 2.023438 23.371094 2.210938 23.617188 C 2.402344 23.859375 2.691406 24 3 24 L 5.5 24 C 5.816406 24 6.109375 23.851562 6.300781 23.597656 L 9 20 L 15.429688 20 L 12.367188 30.722656 C 12.277344 31.027344 12.339844 31.351562 12.527344 31.601562 C 12.714844 31.851562 13.011719 32 13.324219 32 L 17.417969 32 C 17.777344 32 18.109375 31.808594 18.285156 31.496094 L 22.449219 24.210938 L 2.148438 8.519531 C 2.015625 8.738281 1.972656 8.996094 2.03125 9.242188 Z M 39.613281 28.628906 L 28.445312 20 L 32 20 C 34.207031 20 38 18.207031 38 16 C 38 13.792969 34.207031 12 32 12 L 24.855469 12 L 18.289062 0.503906 C 18.128906 0.226562 17.738281 0 17.417969 0 L 13.324219 0 C 13.011719 0 12.714844 0.148438 12.527344 0.398438 C 12.339844 0.648438 12.277344 0.972656 12.363281 1.273438 L 14.671875 9.355469 L 2.839844 0.210938 C 2.40625 -0.128906 1.777344 -0.0507812 1.4375 0.386719 L 0.210938 1.964844 C -0.128906 2.402344 -0.0507812 3.03125 0.386719 3.371094 L 37.160156 31.789062 C 37.59375 32.128906 38.222656 32.050781 38.5625 31.613281 L 39.789062 30.035156 C 40.128906 29.597656 40.050781 28.96875 39.613281 28.628906 Z M 39.613281 28.628906',
			'vw' => 40
		),
		'pump-medical' => array(
			'p' => 'M 14.71875 9.988281 L 5.265625 9.988281 C 3.195312 9.988281 1.46875 11.566406 1.28125 13.625 L 0.0078125 27.625 C -0.09375 28.746094 0.28125 29.855469 1.039062 30.683594 C 1.796875 31.515625 2.867188 31.988281 3.992188 31.988281 L 15.992188 31.988281 C 17.117188 31.988281 18.1875 31.515625 18.945312 30.683594 C 19.703125 29.855469 20.078125 28.746094 19.976562 27.625 L 18.703125 13.625 C 18.515625 11.566406 16.789062 9.988281 14.71875 9.988281 Z M 14.992188 20.820312 C 14.992188 21.28125 14.617188 21.65625 14.160156 21.65625 L 11.660156 21.65625 L 11.660156 24.15625 C 11.660156 24.617188 11.285156 24.988281 10.824219 24.988281 L 9.160156 24.988281 C 8.699219 24.988281 8.324219 24.617188 8.324219 24.15625 L 8.324219 21.65625 L 5.824219 21.65625 C 5.367188 21.65625 4.992188 21.28125 4.992188 20.820312 L 4.992188 19.15625 C 4.992188 18.695312 5.367188 18.320312 5.824219 18.320312 L 8.324219 18.320312 L 8.324219 15.820312 C 8.324219 15.363281 8.699219 14.988281 9.160156 14.988281 L 10.824219 14.988281 C 11.285156 14.988281 11.660156 15.363281 11.660156 15.820312 L 11.660156 18.320312 L 14.160156 18.320312 C 14.621094 18.320312 14.992188 18.695312 14.992188 19.15625 Z M 23.699219 5.867188 L 20.992188 3.160156 C 20.242188 2.410156 19.226562 1.988281 18.164062 1.988281 L 13.992188 1.988281 C 13.992188 0.882812 13.097656 -0.0117188 11.992188 -0.0117188 L 7.992188 -0.0117188 C 6.886719 -0.0117188 5.992188 0.882812 5.992188 1.988281 L 5.992188 7.988281 L 13.992188 7.988281 L 13.992188 5.988281 L 18.164062 5.988281 L 20.871094 8.695312 C 21.261719 9.085938 21.894531 9.085938 22.285156 8.695312 L 23.699219 7.28125 C 24.089844 6.890625 24.089844 6.257812 23.699219 5.867188 Z M 23.699219 5.867188',
			'vw' => 24
		),
		'pump-soap' => array(
			'p' => 'M 14.726562 10 L 5.273438 10 C 3.203125 10 1.476562 11.578125 1.289062 13.636719 L 0.015625 27.636719 C -0.0859375 28.757812 0.289062 29.867188 1.046875 30.699219 C 1.804688 31.527344 2.875 32 4 32 L 16 32 C 17.125 32 18.195312 31.527344 18.953125 30.699219 C 19.710938 29.867188 20.085938 28.757812 19.984375 27.636719 L 18.710938 13.636719 C 18.523438 11.578125 16.796875 10 14.726562 10 Z M 10 26 C 7.929688 26 6.25 24.355469 6.25 22.328125 C 6.25 20.765625 8.480469 17.609375 9.5 16.25 C 9.617188 16.089844 9.804688 16 10 16 C 10.195312 16 10.382812 16.09375 10.5 16.25 C 11.519531 17.613281 13.75 20.765625 13.75 22.328125 C 13.75 24.355469 12.070312 26 10 26 Z M 23.707031 5.878906 L 21 3.171875 C 20.25 2.421875 19.234375 2 18.171875 2 L 14 2 C 14 0.894531 13.105469 0 12 0 L 8 0 C 6.894531 0 6 0.894531 6 2 L 6 8 L 14 8 L 14 6 L 18.171875 6 L 20.878906 8.707031 C 21.269531 9.097656 21.902344 9.097656 22.292969 8.707031 L 23.707031 7.292969 C 24.097656 6.902344 24.097656 6.269531 23.707031 5.878906 Z M 23.707031 5.878906',
			'vw' => 24
		),
		'record-vinyl' => array(
			'p' => 'M 16 9.5 C 12.410156 9.5 9.5 12.410156 9.5 16 C 9.5 19.589844 12.410156 22.5 16 22.5 C 19.589844 22.5 22.5 19.589844 22.5 16 C 22.5 12.410156 19.589844 9.5 16 9.5 Z M 16 17.5 C 15.171875 17.5 14.5 16.828125 14.5 16 C 14.5 15.171875 15.171875 14.5 16 14.5 C 16.828125 14.5 17.5 15.171875 17.5 16 C 17.5 16.828125 16.828125 17.5 16 17.5 Z M 16 0.5 C 7.4375 0.5 0.5 7.4375 0.5 16 C 0.5 24.5625 7.4375 31.5 16 31.5 C 24.5625 31.5 31.5 24.5625 31.5 16 C 31.5 7.4375 24.5625 0.5 16 0.5 Z M 16 24 C 11.582031 24 8 20.417969 8 16 C 8 11.582031 11.582031 8 16 8 C 20.417969 8 24 11.582031 24 16 C 24 20.417969 20.417969 24 16 24 Z M 16 24',
		),
		'remove-format' => array(
			'p' => 'M 21 26 L 20.300781 26 L 20.878906 24.265625 L 16.6875 21.023438 L 15.03125 26 L 13 26 C 12.449219 26 12 26.449219 12 27 L 12 29 C 12 29.550781 12.449219 30 13 30 L 21 30 C 21.550781 30 22 29.550781 22 29 L 22 27 C 22 26.449219 21.550781 26 21 26 Z M 39.613281 28.632812 L 23.5625 16.222656 L 26.636719 7 L 34 7 L 34 9 C 34 9.550781 34.449219 10 35 10 L 37 10 C 37.550781 10 38 9.550781 38 9 L 38 3 C 38 2.449219 37.550781 2 37 2 L 11 2 C 10.449219 2 10 2.449219 10 3 L 10 5.742188 L 2.839844 0.210938 C 2.40625 -0.128906 1.777344 -0.0507812 1.4375 0.386719 L 0.210938 1.964844 C -0.128906 2.402344 -0.0507812 3.03125 0.386719 3.371094 L 37.160156 31.789062 C 37.59375 32.128906 38.222656 32.050781 38.5625 31.613281 L 39.789062 30.035156 C 40.128906 29.597656 40.050781 28.96875 39.613281 28.632812 Z M 19.371094 12.984375 L 14 8.835938 L 14 7 L 21.363281 7 Z M 19.371094 12.984375',
			'vw' => 40
		),
		'shield-virus' => array(
			'p' => 'M 14 12 C 13.449219 12 13 12.449219 13 13 C 13 13.550781 13.449219 14 14 14 C 14.550781 14 15 13.550781 15 13 C 15 12.449219 14.550781 12 14 12 Z M 29.15625 5.230469 L 17.15625 0.230469 C 16.789062 0.0898438 16.398438 0.0117188 16.003906 0 C 15.609375 0.0117188 15.21875 0.0898438 14.847656 0.230469 L 2.847656 5.230469 C 1.730469 5.695312 1 6.789062 1 8 C 1 20.40625 8.15625 28.984375 14.84375 31.769531 C 15.582031 32.078125 16.414062 32.078125 17.152344 31.769531 C 22.503906 29.539062 31 21.832031 31 8 C 31 6.789062 30.273438 5.695312 29.15625 5.230469 Z M 24 16 L 23.242188 16 C 21.460938 16 20.566406 18.15625 21.828125 19.414062 L 22.363281 19.949219 C 22.753906 20.339844 22.753906 20.972656 22.363281 21.363281 C 21.972656 21.753906 21.339844 21.753906 20.949219 21.363281 L 20.414062 20.828125 C 19.15625 19.566406 17 20.460938 17 22.242188 L 17 23 C 17 23.550781 16.550781 24 16 24 C 15.449219 24 15 23.550781 15 23 L 15 22.242188 C 15 20.460938 12.84375 19.566406 11.585938 20.828125 L 11.050781 21.363281 C 10.660156 21.753906 10.027344 21.753906 9.636719 21.363281 C 9.246094 20.972656 9.246094 20.339844 9.636719 19.949219 L 10.171875 19.414062 C 11.433594 18.15625 10.539062 16 8.757812 16 L 8 16 C 7.449219 16 7 15.550781 7 15 C 7 14.449219 7.449219 14 8 14 L 8.757812 14 C 10.539062 14 11.433594 11.84375 10.171875 10.585938 L 9.636719 10.050781 C 9.246094 9.660156 9.246094 9.027344 9.636719 8.636719 C 10.027344 8.246094 10.660156 8.246094 11.050781 8.636719 L 11.585938 9.171875 C 12.84375 10.433594 15 9.539062 15 7.757812 L 15 7 C 15 6.449219 15.449219 6 16 6 C 16.550781 6 17 6.449219 17 7 L 17 7.757812 C 17 9.539062 19.15625 10.433594 20.414062 9.171875 L 20.949219 8.636719 C 21.339844 8.246094 21.972656 8.246094 22.363281 8.636719 C 22.753906 9.027344 22.753906 9.660156 22.363281 10.050781 L 21.828125 10.585938 C 20.566406 11.84375 21.460938 14 23.242188 14 L 24 14 C 24.550781 14 25 14.449219 25 15 C 25 15.550781 24.550781 16 24 16 Z M 18 16 C 17.449219 16 17 16.449219 17 17 C 17 17.550781 17.449219 18 18 18 C 18.550781 18 19 17.550781 19 17 C 19 16.449219 18.550781 16 18 16 Z M 18 16',
		),
		'sink' => array(
			'p' => 'M 2 26 C 2 29.3125 4.6875 32 8 32 L 24 32 C 27.3125 32 30 29.3125 30 26 L 30 24 L 2 24 Z M 31 18 L 25 18 L 25 16 L 29 16 C 29.550781 16 30 15.550781 30 15 L 30 14 C 30 13.449219 29.550781 13 29 13 L 24 13 C 22.894531 13 22 13.894531 22 15 L 22 18 L 18 18 L 18 6 C 18 4.894531 18.894531 4 20 4 C 21.105469 4 22 4.894531 22 6 L 22 7 C 22 7.550781 22.449219 8 23 8 L 25 8 C 25.550781 8 26 7.550781 26 7 L 26 6 C 25.996094 4.199219 25.1875 2.496094 23.792969 1.355469 C 22.402344 0.214844 20.570312 -0.238281 18.804688 0.117188 C 15.957031 0.667969 14 3.335938 14 6.238281 L 14 18 L 10 18 L 10 15 C 10 13.894531 9.105469 13 8 13 L 3 13 C 2.449219 13 2 13.449219 2 14 L 2 15 C 2 15.550781 2.449219 16 3 16 L 7 16 L 7 18 L 1 18 C 0.449219 18 0 18.449219 0 19 L 0 21 C 0 21.550781 0.449219 22 1 22 L 31 22 C 31.550781 22 32 21.550781 32 21 L 32 19 C 32 18.449219 31.550781 18 31 18 Z M 31 18',
		),
		'sliders-h' => array(
			'p' => 'M 31 24 L 10 24 L 10 23 C 10 22.449219 9.550781 22 9 22 L 7 22 C 6.449219 22 6 22.449219 6 23 L 6 24 L 1 24 C 0.449219 24 0 24.449219 0 25 L 0 27 C 0 27.550781 0.449219 28 1 28 L 6 28 L 6 29 C 6 29.550781 6.449219 30 7 30 L 9 30 C 9.550781 30 10 29.550781 10 29 L 10 28 L 31 28 C 31.550781 28 32 27.550781 32 27 L 32 25 C 32 24.449219 31.550781 24 31 24 Z M 31 14 L 26 14 L 26 13 C 26 12.449219 25.550781 12 25 12 L 23 12 C 22.449219 12 22 12.449219 22 13 L 22 14 L 1 14 C 0.449219 14 0 14.449219 0 15 L 0 17 C 0 17.550781 0.449219 18 1 18 L 22 18 L 22 19 C 22 19.550781 22.449219 20 23 20 L 25 20 C 25.550781 20 26 19.550781 26 19 L 26 18 L 31 18 C 31.550781 18 32 17.550781 32 17 L 32 15 C 32 14.449219 31.550781 14 31 14 Z M 31 4 L 18 4 L 18 3 C 18 2.449219 17.550781 2 17 2 L 15 2 C 14.449219 2 14 2.449219 14 3 L 14 4 L 1 4 C 0.449219 4 0 4.449219 0 5 L 0 7 C 0 7.550781 0.449219 8 1 8 L 14 8 L 14 9 C 14 9.550781 14.449219 10 15 10 L 17 10 C 17.550781 10 18 9.550781 18 9 L 18 8 L 31 8 C 31.550781 8 32 7.550781 32 7 L 32 5 C 32 4.449219 31.550781 4 31 4 Z M 31 4',
		),
		'soap' => array(
			'p' => 'M 26 12 C 25.996094 13.667969 25.296875 15.261719 24.066406 16.386719 C 26.796875 17.386719 28.417969 20.199219 27.90625 23.0625 C 27.398438 25.921875 24.90625 28.007812 22 28 L 10 28 C 6.6875 28 4 25.3125 4 22 C 4 18.6875 6.6875 16 10 16 L 15.558594 16 C 14.558594 14.90625 14.003906 13.480469 14 12 L 6 12 C 2.6875 12 0 14.6875 0 18 L 0 26 C 0 29.3125 2.6875 32 6 32 L 26 32 C 29.3125 32 32 29.3125 32 26 L 32 18 C 32 14.6875 29.3125 12 26 12 Z M 20 16 C 22.210938 16 24 14.210938 24 12 C 24 9.789062 22.210938 8 20 8 C 17.789062 8 16 9.789062 16 12 C 16 14.210938 17.789062 16 20 16 Z M 13 6 C 14.65625 6 16 4.65625 16 3 C 16 1.34375 14.65625 0 13 0 C 11.34375 0 10 1.34375 10 3 C 10 4.65625 11.34375 6 13 6 Z M 24 4 C 25.105469 4 26 3.105469 26 2 C 26 0.894531 25.105469 0 24 0 C 22.894531 0 22 0.894531 22 2 C 22 3.105469 22.894531 4 24 4 Z M 10 18 C 7.789062 18 6 19.789062 6 22 C 6 24.210938 7.789062 26 10 26 L 22 26 C 24.210938 26 26 24.210938 26 22 C 26 19.789062 24.210938 18 22 18 Z M 10 18',
		),
		'sort-alpha-down-alt' => array(
			'p' => 'M 11 22 L 8 22 L 8 3 C 8 2.449219 7.550781 2 7 2 L 5 2 C 4.449219 2 4 2.449219 4 3 L 4 22 L 1 22 C 0.113281 22 -0.335938 23.078125 0.292969 23.707031 L 5.292969 29.707031 C 5.683594 30.097656 6.316406 30.097656 6.707031 29.707031 L 11.707031 23.707031 C 12.335938 23.078125 11.890625 22 11 22 Z M 18 14 L 26 14 C 26.550781 14 27 13.550781 27 13 L 27 11 C 27 10.449219 26.550781 10 26 10 L 22.5 10 L 26.328125 5.597656 C 26.753906 5.21875 27 4.671875 27 4.101562 L 27 3 C 27 2.449219 26.550781 2 26 2 L 18 2 C 17.449219 2 17 2.449219 17 3 L 17 5 C 17 5.550781 17.449219 6 18 6 L 21.5 6 L 17.671875 10.402344 C 17.246094 10.78125 17 11.328125 17 11.898438 L 17 13 C 17 13.550781 17.449219 14 18 14 Z M 27.941406 28.664062 L 24.238281 18.664062 C 24.09375 18.265625 23.71875 18 23.296875 18 L 20.703125 18 C 20.28125 18 19.90625 18.265625 19.761719 18.664062 L 16.058594 28.664062 C 15.949219 28.96875 15.996094 29.308594 16.183594 29.574219 C 16.371094 29.839844 16.675781 30 17 30 L 18.550781 30 C 18.984375 30 19.371094 29.71875 19.503906 29.308594 L 19.78125 28.5 L 24.21875 28.5 L 24.492188 29.308594 C 24.625 29.722656 25.011719 30 25.449219 30 L 27 30 C 27.324219 30 27.628906 29.839844 27.816406 29.574219 C 28.003906 29.308594 28.050781 28.96875 27.941406 28.664062 Z M 20.976562 25 L 22 22 L 23.023438 25 Z M 20.976562 25',
			'vw' => 28
		),
		'sort-alpha-up-alt' => array(
			'p' => 'M 1 10 L 4 10 L 4 29 C 4 29.550781 4.449219 30 5 30 L 7 30 C 7.550781 30 8 29.550781 8 29 L 8 10 L 11 10 C 11.886719 10 12.335938 8.921875 11.707031 8.292969 L 6.707031 2.292969 C 6.316406 1.902344 5.683594 1.902344 5.292969 2.292969 L 0.292969 8.292969 C -0.335938 8.921875 0.109375 10 1 10 Z M 18 14 L 26 14 C 26.550781 14 27 13.550781 27 13 L 27 11 C 27 10.449219 26.550781 10 26 10 L 22.5 10 L 26.328125 5.597656 C 26.753906 5.21875 27 4.671875 27 4.101562 L 27 3 C 27 2.449219 26.550781 2 26 2 L 18 2 C 17.449219 2 17 2.449219 17 3 L 17 5 C 17 5.550781 17.449219 6 18 6 L 21.5 6 L 17.671875 10.402344 C 17.246094 10.78125 17 11.328125 17 11.898438 L 17 13 C 17 13.550781 17.449219 14 18 14 Z M 27.941406 28.664062 L 24.238281 18.664062 C 24.09375 18.265625 23.71875 18 23.296875 18 L 20.703125 18 C 20.28125 18 19.90625 18.265625 19.761719 18.664062 L 16.058594 28.664062 C 15.949219 28.96875 15.996094 29.308594 16.183594 29.574219 C 16.371094 29.839844 16.675781 30 17 30 L 18.550781 30 C 18.984375 30 19.371094 29.71875 19.503906 29.308594 L 19.78125 28.5 L 24.21875 28.5 L 24.492188 29.308594 C 24.625 29.722656 25.011719 30 25.449219 30 L 27 30 C 27.324219 30 27.628906 29.839844 27.816406 29.574219 C 28.003906 29.308594 28.050781 28.96875 27.941406 28.664062 Z M 20.976562 25 L 22 22 L 23.023438 25 Z M 20.976562 25',
			'vw' => 28
		),
		'sort-amount-down-alt' => array(
			'p' => 'M 15 6 L 19 6 C 19.550781 6 20 5.550781 20 5 L 20 3 C 20 2.449219 19.550781 2 19 2 L 15 2 C 14.449219 2 14 2.449219 14 3 L 14 5 C 14 5.550781 14.449219 6 15 6 Z M 15 14 L 23 14 C 23.550781 14 24 13.550781 24 13 L 24 11 C 24 10.449219 23.550781 10 23 10 L 15 10 C 14.449219 10 14 10.449219 14 11 L 14 13 C 14 13.550781 14.449219 14 15 14 Z M 31 26 L 15 26 C 14.449219 26 14 26.449219 14 27 L 14 29 C 14 29.550781 14.449219 30 15 30 L 31 30 C 31.550781 30 32 29.550781 32 29 L 32 27 C 32 26.449219 31.550781 26 31 26 Z M 15 22 L 27 22 C 27.550781 22 28 21.550781 28 21 L 28 19 C 28 18.449219 27.550781 18 27 18 L 15 18 C 14.449219 18 14 18.449219 14 19 L 14 21 C 14 21.550781 14.449219 22 15 22 Z M 11 22 L 8 22 L 8 3 C 8 2.449219 7.550781 2 7 2 L 5 2 C 4.449219 2 4 2.449219 4 3 L 4 22 L 1 22 C 0.113281 22 -0.335938 23.078125 0.292969 23.707031 L 5.292969 29.707031 C 5.683594 30.097656 6.316406 30.097656 6.707031 29.707031 L 11.707031 23.707031 C 12.335938 23.078125 11.890625 22 11 22 Z M 11 22',
		),
		'sort-amount-up-alt' => array(
			'p' => 'M 15 6 L 19 6 C 19.550781 6 20 5.550781 20 5 L 20 3 C 20 2.449219 19.550781 2 19 2 L 15 2 C 14.449219 2 14 2.449219 14 3 L 14 5 C 14 5.550781 14.449219 6 15 6 Z M 15 14 L 23 14 C 23.550781 14 24 13.550781 24 13 L 24 11 C 24 10.449219 23.550781 10 23 10 L 15 10 C 14.449219 10 14 10.449219 14 11 L 14 13 C 14 13.550781 14.449219 14 15 14 Z M 31 26 L 15 26 C 14.449219 26 14 26.449219 14 27 L 14 29 C 14 29.550781 14.449219 30 15 30 L 31 30 C 31.550781 30 32 29.550781 32 29 L 32 27 C 32 26.449219 31.550781 26 31 26 Z M 15 22 L 27 22 C 27.550781 22 28 21.550781 28 21 L 28 19 C 28 18.449219 27.550781 18 27 18 L 15 18 C 14.449219 18 14 18.449219 14 19 L 14 21 C 14 21.550781 14.449219 22 15 22 Z M 1 10 L 4 10 L 4 29 C 4 29.550781 4.449219 30 5 30 L 7 30 C 7.550781 30 8 29.550781 8 29 L 8 10 L 11 10 C 11.886719 10 12.335938 8.921875 11.707031 8.292969 L 6.707031 2.292969 C 6.316406 1.902344 5.683594 1.902344 5.292969 2.292969 L 0.292969 8.292969 C -0.335938 8.921875 0.109375 10 1 10 Z M 1 10',
		),
		'sort-numeric-down-alt' => array(
			'p' => 'M 11 22 L 8 22 L 8 3 C 8 2.449219 7.550781 2 7 2 L 5 2 C 4.449219 2 4 2.449219 4 3 L 4 22 L 1 22 C 0.113281 22 -0.335938 23.078125 0.292969 23.707031 L 5.292969 29.707031 C 5.683594 30.097656 6.316406 30.097656 6.707031 29.707031 L 11.707031 23.707031 C 12.335938 23.078125 11.890625 22 11 22 Z M 25 26 L 24 26 L 24 19 C 24 18.449219 23.550781 18 23 18 L 20 18 C 19.621094 18 19.277344 18.214844 19.105469 18.550781 L 18.105469 20.550781 C 17.953125 20.863281 17.96875 21.230469 18.148438 21.523438 C 18.332031 21.820312 18.652344 22 19 22 L 20 22 L 20 26 L 19 26 C 18.449219 26 18 26.449219 18 27 L 18 29 C 18 29.550781 18.449219 30 19 30 L 25 30 C 25.550781 30 26 29.550781 26 29 L 26 27 C 26 26.449219 25.550781 26 25 26 Z M 20.636719 2.183594 C 18.980469 2.636719 17.675781 3.917969 17.199219 5.566406 C 16.304688 8.757812 18.523438 11.679688 21.5 11.976562 C 21.105469 12.308594 20.667969 12.578125 20.195312 12.78125 C 19.722656 12.996094 19.523438 13.5625 19.6875 14.054688 L 20.304688 15.304688 C 20.484375 15.84375 21.085938 16.148438 21.609375 15.921875 C 25.234375 14.375 27 12.074219 27 7.671875 L 27 7 C 27 3.800781 23.976562 1.292969 20.636719 2.183594 Z M 22 8.25 C 21.308594 8.25 20.75 7.691406 20.75 7 C 20.75 6.308594 21.308594 5.75 22 5.75 C 22.691406 5.75 23.25 6.308594 23.25 7 C 23.25 7.691406 22.691406 8.25 22 8.25 Z M 22 8.25',
			'vw' => 28
		),
		'sort-numeric-up-alt' => array(
			'p' => 'M 6.707031 2.292969 C 6.316406 1.902344 5.683594 1.902344 5.292969 2.292969 L 0.292969 8.292969 C -0.335938 8.921875 0.109375 10 1 10 L 4 10 L 4 29 C 4 29.550781 4.449219 30 5 30 L 7 30 C 7.550781 30 8 29.550781 8 29 L 8 10 L 11 10 C 11.886719 10 12.335938 8.921875 11.707031 8.292969 Z M 25 26 L 24 26 L 24 19 C 24 18.449219 23.550781 18 23 18 L 20 18 C 19.621094 18 19.277344 18.214844 19.105469 18.550781 L 18.105469 20.550781 C 17.953125 20.863281 17.96875 21.230469 18.148438 21.523438 C 18.332031 21.820312 18.652344 22 19 22 L 20 22 L 20 26 L 19 26 C 18.449219 26 18 26.449219 18 27 L 18 29 C 18 29.550781 18.449219 30 19 30 L 25 30 C 25.550781 30 26 29.550781 26 29 L 26 27 C 26 26.449219 25.550781 26 25 26 Z M 20.636719 2.183594 C 18.980469 2.636719 17.675781 3.917969 17.199219 5.566406 C 16.304688 8.757812 18.523438 11.679688 21.5 11.976562 C 21.105469 12.308594 20.667969 12.578125 20.195312 12.78125 C 19.722656 12.996094 19.523438 13.5625 19.6875 14.054688 L 20.304688 15.304688 C 20.484375 15.84375 21.085938 16.148438 21.609375 15.921875 C 25.234375 14.375 27 12.074219 27 7.671875 L 27 7 C 27 3.800781 23.976562 1.292969 20.636719 2.183594 Z M 22 8.25 C 21.308594 8.25 20.75 7.691406 20.75 7 C 20.75 6.308594 21.308594 5.75 22 5.75 C 22.691406 5.75 23.25 6.308594 23.25 7 C 23.25 7.691406 22.691406 8.25 22 8.25 Z M 22 8.25',
			'vw' => 28
		),
		'spell-check' => array(
			'p' => 'M 17 16 L 22.710938 16 C 25.410156 16 27.835938 13.988281 27.992188 11.292969 C 28.078125 9.808594 27.5 8.363281 26.414062 7.347656 C 26.871094 6.488281 27.070312 5.511719 26.980469 4.542969 C 26.742188 1.910156 24.332031 0 21.6875 0 L 17 0 C 16.449219 0 16 0.449219 16 1 L 16 15 C 16 15.550781 16.449219 16 17 16 Z M 19.5 3.5 L 22 3.5 C 22.828125 3.5 23.5 4.171875 23.5 5 C 23.5 5.828125 22.828125 6.5 22 6.5 L 19.5 6.5 Z M 19.5 9.5 L 23 9.5 C 23.828125 9.5 24.5 10.171875 24.5 11 C 24.5 11.828125 23.828125 12.5 23 12.5 L 19.5 12.5 Z M 9.695312 1.390625 C 9.429688 0.5625 8.660156 0 7.789062 0 L 6.210938 0 C 5.339844 0 4.570312 0.5625 4.304688 1.390625 L 0.0351562 14.734375 C -0.046875 15.035156 0.015625 15.355469 0.203125 15.605469 C 0.394531 15.855469 0.6875 16 1 16 L 2.558594 16 C 3.007812 16 3.402344 15.699219 3.523438 15.265625 L 4.269531 13 L 9.730469 13 L 10.476562 15.265625 C 10.597656 15.699219 10.992188 16 11.441406 16 L 13 16 C 13.3125 16 13.605469 15.855469 13.796875 15.605469 C 13.984375 15.355469 14.046875 15.035156 13.964844 14.734375 Z M 5.585938 9 L 7 4.707031 L 8.414062 9 Z M 35.710938 17.28125 L 32.886719 14.449219 C 32.699219 14.261719 32.445312 14.152344 32.179688 14.152344 C 31.914062 14.152344 31.660156 14.261719 31.472656 14.449219 L 22.003906 23.917969 L 18.542969 20.449219 C 18.355469 20.261719 18.101562 20.152344 17.835938 20.152344 C 17.570312 20.152344 17.316406 20.261719 17.128906 20.449219 L 14.296875 23.28125 C 13.910156 23.671875 13.910156 24.300781 14.296875 24.691406 L 21.296875 31.703125 C 21.484375 31.894531 21.738281 32 22.003906 32 C 22.269531 32 22.523438 31.894531 22.710938 31.703125 L 35.710938 18.691406 C 36.097656 18.300781 36.097656 17.667969 35.710938 17.28125 Z M 35.710938 17.28125',
			'vw' => 36
		),
		'stopwatch-20' => array(
			'p' => 'M 24.90625 11.933594 L 24.941406 11.894531 L 26.605469 10.234375 C 26.996094 9.84375 26.996094 9.207031 26.605469 8.816406 L 25.1875 7.402344 C 24.796875 7.011719 24.164062 7.011719 23.773438 7.402344 L 22.230469 8.941406 C 20.441406 7.472656 18.289062 6.511719 16 6.15625 L 16 4 L 18 4 C 18.550781 4 19 3.550781 19 3 L 19 1 C 19 0.449219 18.550781 0 18 0 L 10 0 C 9.449219 0 9 0.449219 9 1 L 9 3 C 9 3.550781 9.449219 4 10 4 L 12 4 L 12 6.15625 C 5.816406 7.117188 1.199219 12.34375 1.003906 18.597656 C 0.789062 25.71875 6.671875 31.890625 13.796875 32 C 21.070312 32.109375 27 26.25 27 19 C 27.007812 16.492188 26.277344 14.035156 24.90625 11.933594 Z M 12.773438 23.597656 C 13.054688 23.59375 13.289062 23.820312 13.292969 24.101562 L 13.292969 25.496094 C 13.289062 25.777344 13.054688 26.003906 12.773438 26 L 7.59375 26 C 7.308594 26.003906 7.03125 25.886719 6.835938 25.675781 C 6.636719 25.46875 6.535156 25.1875 6.558594 24.898438 C 6.730469 22.699219 7.472656 21.3125 8.960938 19.1875 C 10.234375 17.363281 10.652344 16.855469 10.652344 15.292969 C 10.652344 14.234375 10.542969 13.773438 9.890625 13.773438 C 9.304688 13.773438 9.097656 14.238281 9.097656 15.191406 L 9.097656 15.519531 C 9.09375 15.800781 8.859375 16.027344 8.578125 16.023438 L 7.019531 16.023438 C 6.738281 16.027344 6.503906 15.800781 6.5 15.519531 L 6.5 15.265625 C 6.5 13.558594 7.03125 11.5 10.027344 11.5 C 12.714844 11.5 13.5 13.117188 13.5 15.3125 C 13.5 17.535156 12.722656 18.511719 11.351562 20.394531 C 10.628906 21.332031 9.816406 22.617188 9.703125 23.59375 Z M 21.5 22.019531 C 21.5 24.21875 20.730469 26 17.921875 26 C 15.199219 26 14.5 24.15625 14.5 22.035156 L 14.5 15.453125 C 14.5 12.90625 15.722656 11.5 18.011719 11.5 C 20.3125 11.5 21.5 12.914062 21.5 15.332031 Z M 17.992188 13.859375 C 17.402344 13.859375 17.164062 14.328125 17.164062 15.109375 L 17.164062 22.355469 C 17.164062 23.175781 17.390625 23.640625 17.992188 23.640625 C 18.59375 23.640625 18.804688 23.140625 18.804688 22.3125 L 18.804688 15.066406 C 18.804688 14.363281 18.617188 13.859375 17.992188 13.859375 Z M 17.992188 13.859375',
			'vw' => 28
		),
		'store-alt-slash' => array(
			'p' => 'M 1.117188 7.726562 L 0.34375 8.886719 C -0.542969 10.21875 0.40625 12 2.007812 12 L 6.648438 12 Z M 36 25.839844 L 36 14 L 32 14 L 32 22.75 L 24 16.5625 L 24 14 L 20.683594 14 L 18.09375 12 L 38 12 C 39.59375 12 40.542969 10.21875 39.660156 8.886719 L 34.332031 0.886719 C 33.957031 0.332031 33.332031 0 32.664062 0 L 7.339844 0 C 6.671875 0 6.046875 0.332031 5.675781 0.886719 L 5.007812 1.886719 L 2.839844 0.210938 C 2.40625 -0.128906 1.777344 -0.0507812 1.4375 0.386719 L 0.210938 1.964844 C -0.128906 2.402344 -0.0507812 3.03125 0.386719 3.371094 L 37.15625 31.789062 C 37.367188 31.953125 37.632812 32.027344 37.898438 31.992188 C 38.160156 31.960938 38.398438 31.824219 38.5625 31.613281 L 39.789062 30.035156 C 40.128906 29.597656 40.050781 28.96875 39.613281 28.632812 Z M 20 24 L 8 24 L 8 14 L 4 14 L 4 30 C 4 31.105469 4.894531 32 6 32 L 22 32 C 23.105469 32 24 31.105469 24 30 L 24 25.410156 L 20 22.320312 Z M 20 24',
			'vw' => 40
		),
		'store-slash' => array(
			'p' => 'M 7.59375 24 L 7.59375 17.761719 C 7.023438 17.910156 6.433594 17.992188 5.84375 18 C 5.488281 18 5.128906 17.976562 4.777344 17.925781 C 4.445312 17.871094 4.121094 17.796875 3.800781 17.699219 L 3.800781 30 C 3.800781 31.105469 4.652344 32 5.703125 32 L 31.609375 32 L 21.777344 24 Z M 5.84375 15.996094 C 7.414062 15.996094 8.800781 15.324219 9.84375 14.292969 L 1.5 7.503906 C -0.40625 10.839844 1.347656 15.410156 5.03125 15.941406 C 5.300781 15.976562 5.570312 15.996094 5.84375 15.996094 Z M 37.632812 28.628906 L 34.199219 25.839844 L 34.199219 17.699219 C 33.882812 17.800781 33.558594 17.878906 33.226562 17.925781 C 32.867188 17.972656 32.507812 18 32.144531 18 C 31.554688 17.992188 30.96875 17.914062 30.394531 17.761719 L 30.394531 22.742188 L 21.78125 15.734375 C 22.296875 15.898438 22.832031 15.988281 23.371094 15.996094 C 25.128906 15.996094 26.683594 15.183594 27.753906 13.925781 C 28.828125 15.183594 30.382812 15.996094 32.132812 15.996094 C 32.40625 15.996094 32.675781 15.976562 32.945312 15.9375 C 36.675781 15.410156 38.445312 10.761719 36.449219 7.414062 L 32.597656 0.9375 C 32.265625 0.363281 31.652344 0.0078125 30.988281 0 L 7 0 C 6.335938 0.0078125 5.726562 0.363281 5.390625 0.9375 L 4.804688 1.921875 L 2.699219 0.210938 C 2.503906 0.046875 2.246094 -0.0234375 1.996094 0.0078125 C 1.742188 0.0429688 1.515625 0.179688 1.367188 0.386719 L 0.199219 1.964844 C -0.121094 2.40625 -0.046875 3.019531 0.367188 3.371094 L 35.300781 31.789062 C 35.496094 31.953125 35.753906 32.023438 36.003906 31.992188 C 36.257812 31.957031 36.484375 31.820312 36.632812 31.613281 L 37.800781 30.035156 C 38.121094 29.59375 38.046875 28.980469 37.632812 28.628906 Z M 37.632812 28.628906',
			'vw' => 40
		),
		'toilet-paper-slash' => array(
			'p' => 'M 4 12 L 4 22.757812 C 4 25.328125 3.390625 26.679688 2.054688 30.6875 C 1.953125 30.992188 2.007812 31.324219 2.195312 31.585938 C 2.378906 31.84375 2.679688 32 3 32 L 20.554688 32 C 21.414062 32.003906 22.183594 31.453125 22.453125 30.632812 C 23.035156 28.894531 23.578125 27.296875 23.839844 25.285156 L 4.089844 10.019531 C 4.03125 10.667969 4 11.324219 4 12 Z M 39.613281 28.628906 L 33.238281 23.703125 C 35.953125 22.558594 38 17.769531 38 12 C 38 5.375 35.3125 0 32 0 C 28.6875 0 26 5.375 26 12 C 26 14.625 26.4375 17.023438 27.152344 19 L 24 16.5625 L 24 12 C 24 6.773438 25.476562 2.40625 27.78125 0 L 10 0 C 8.542969 0 7.210938 1.050781 6.171875 2.78125 L 2.839844 0.210938 C 2.40625 -0.128906 1.777344 -0.0507812 1.4375 0.386719 L 0.210938 1.964844 C -0.128906 2.402344 -0.0507812 3.03125 0.386719 3.371094 L 37.160156 31.789062 C 37.59375 32.128906 38.222656 32.050781 38.5625 31.613281 L 39.789062 30.035156 C 40.128906 29.597656 40.050781 28.96875 39.613281 28.628906 Z M 32 16 C 30.898438 16 30 14.210938 30 12 C 30 9.789062 30.898438 8 32 8 C 33.101562 8 34 9.789062 34 12 C 34 14.210938 33.101562 16 32 16 Z M 32 16',
			'vw' => 40
		),
		'trailer' => array(
			'p' => 'M 39 20 L 34 20 L 34 5 C 34 4.449219 33.550781 4 33 4 L 1 4 C 0.449219 4 0 4.449219 0 5 L 0 23 C 0 23.550781 0.449219 24 1 24 L 4.101562 24 C 4.589844 20.613281 7.476562 18 11 18 C 14.523438 18 17.410156 20.613281 17.898438 24 L 39 24 C 39.550781 24 40 23.550781 40 23 L 40 21 C 40 20.449219 39.550781 20 39 20 Z M 6 15.230469 C 5.289062 15.589844 4.617188 16.023438 4 16.523438 L 4 8.5 C 4 8.222656 4.222656 8 4.5 8 L 5.5 8 C 5.777344 8 6 8.222656 6 8.5 Z M 12 14.070312 C 11.667969 14.039062 11.339844 14 11 14 C 10.660156 14 10.332031 14.039062 10 14.070312 L 10 8.5 C 10 8.222656 10.222656 8 10.5 8 L 11.5 8 C 11.777344 8 12 8.222656 12 8.5 Z M 18 16.523438 C 17.382812 16.023438 16.710938 15.589844 16 15.230469 L 16 8.5 C 16 8.222656 16.222656 8 16.5 8 L 17.5 8 C 17.777344 8 18 8.222656 18 8.5 Z M 24 20 L 22 20 L 22 8.5 C 22 8.222656 22.222656 8 22.5 8 L 23.5 8 C 23.777344 8 24 8.222656 24 8.5 Z M 30 20 L 28 20 L 28 8.5 C 28 8.222656 28.222656 8 28.5 8 L 29.5 8 C 29.777344 8 30 8.222656 30 8.5 Z M 11 20 C 8.238281 20 6 22.238281 6 25 C 6 27.761719 8.238281 30 11 30 C 13.761719 30 16 27.761719 16 25 C 16 22.238281 13.761719 20 11 20 Z M 11 27 C 9.894531 27 9 26.105469 9 25 C 9 23.894531 9.894531 23 11 23 C 12.105469 23 13 23.894531 13 25 C 13 26.105469 12.105469 27 11 27 Z M 11 27',
			'vw' => 40
		),
		'users-slash' => array(
			'p' => 'M 8.289062 13.269531 L 2.261719 8.609375 C 2.09375 9.054688 2.003906 9.523438 2 10 C 1.996094 11.492188 2.824219 12.863281 4.148438 13.550781 C 5.472656 14.238281 7.070312 14.128906 8.289062 13.269531 Z M 10.816406 17.164062 C 10.070312 16.417969 9.054688 16 8 16 L 4 16 C 1.792969 16.003906 0.00390625 17.792969 0 20 L 0 22 C 0 23.105469 0.894531 24 2 24 L 6.121094 24 C 6.503906 21.101562 8.25 18.5625 10.816406 17.164062 Z M 34 14 C 36.210938 14 38 12.210938 38 10 C 38 7.789062 36.210938 6 34 6 C 31.789062 6 30 7.789062 30 10 C 30.003906 12.207031 31.792969 13.996094 34 14 Z M 31.285156 22.195312 C 30.308594 20.046875 28.332031 18.519531 26.003906 18.113281 L 22.5625 15.453125 C 25.152344 14.433594 27 11.957031 27 9 C 27 7.144531 26.265625 5.363281 24.949219 4.050781 C 23.636719 2.734375 21.855469 2 20 2 C 16.429688 2 13.519531 4.675781 13.085938 8.128906 L 2.839844 0.210938 C 2.40625 -0.128906 1.777344 -0.0507812 1.4375 0.386719 L 0.210938 1.964844 C -0.128906 2.402344 -0.0507812 3.03125 0.386719 3.371094 L 37.15625 31.789062 C 37.367188 31.953125 37.632812 32.027344 37.898438 31.992188 C 38.160156 31.960938 38.398438 31.824219 38.5625 31.613281 L 39.789062 30.035156 C 40.128906 29.597656 40.050781 28.96875 39.613281 28.632812 Z M 8 25.199219 L 8 27 C 8 28.65625 9.34375 30 11 30 L 29 30 C 29.265625 29.996094 29.53125 29.957031 29.785156 29.882812 L 14.5 18.070312 C 10.859375 18.425781 8 21.464844 8 25.199219 Z M 36 16 L 32 16 C 30.945312 16 29.929688 16.417969 29.183594 17.164062 C 31.75 18.558594 33.492188 21.101562 33.875 24 L 38 24 C 39.105469 24 40 23.105469 40 22 L 40 20 C 39.996094 17.792969 38.207031 16.003906 36 16 Z M 36 16',
			'vw' => 40
		),
		'vest' => array(
			'p' => 'M 27.328125 14.992188 L 24 10 L 24 2 C 24 0.894531 23.105469 0 22 0 L 20 0 C 19.703125 0 19.414062 0.0859375 19.167969 0.25 L 17.605469 1.292969 C 15.421875 2.753906 12.578125 2.753906 10.394531 1.292969 L 8.832031 0.25 C 8.585938 0.0859375 8.296875 0 8 0 L 6 0 C 4.894531 0 4 0.894531 4 2 L 4 10 L 0.671875 14.992188 C 0.234375 15.648438 0 16.421875 0 17.210938 L 0 30 C 0 31.105469 0.894531 32 2 32 L 12 32 L 12 18 C 12 17.785156 12.035156 17.570312 12.101562 17.367188 L 12.945312 14.835938 L 9.386719 4.160156 C 10.792969 4.957031 12.382812 5.378906 14 5.390625 C 15.617188 5.378906 17.207031 4.957031 18.613281 4.160156 L 14 18 L 14 32 L 26 32 C 27.105469 32 28 31.105469 28 30 L 28 17.210938 C 28 16.421875 27.765625 15.648438 27.328125 14.992188 Z M 8.207031 23.207031 L 5.207031 26.207031 C 4.816406 26.585938 4.191406 26.582031 3.804688 26.195312 C 3.417969 25.808594 3.414062 25.183594 3.792969 24.792969 L 6.792969 21.792969 C 7.183594 21.414062 7.808594 21.417969 8.195312 21.804688 C 8.582031 22.191406 8.585938 22.816406 8.207031 23.207031 Z M 24.207031 26.207031 C 23.816406 26.597656 23.183594 26.597656 22.792969 26.207031 L 19.792969 23.207031 C 19.414062 22.816406 19.417969 22.191406 19.804688 21.804688 C 20.191406 21.417969 20.816406 21.414062 21.207031 21.792969 L 24.207031 24.792969 C 24.597656 25.183594 24.597656 25.816406 24.207031 26.207031 Z M 24.207031 26.207031',
			'vw' => 28
		),
		'vest-patches' => array(
			'p' => 'M 27.328125 14.992188 L 24 10 L 24 2 C 24 0.894531 23.105469 0 22 0 L 20 0 C 19.703125 0 19.414062 0.0859375 19.167969 0.25 L 17.605469 1.292969 C 15.421875 2.753906 12.578125 2.753906 10.394531 1.292969 L 8.832031 0.25 C 8.585938 0.0859375 8.296875 0 8 0 L 6 0 C 4.894531 0 4 0.894531 4 2 L 4 10 L 0.671875 14.992188 C 0.234375 15.648438 0 16.421875 0 17.210938 L 0 30 C 0 31.105469 0.894531 32 2 32 L 12 32 L 12 18 C 12 17.785156 12.035156 17.570312 12.101562 17.367188 L 12.945312 14.835938 L 9.386719 4.160156 C 10.792969 4.957031 12.382812 5.378906 14 5.390625 C 15.617188 5.378906 17.207031 4.957031 18.613281 4.160156 L 14 18 L 14 32 L 26 32 C 27.105469 32 28 31.105469 28 30 L 28 17.210938 C 28 16.421875 27.765625 15.648438 27.328125 14.992188 Z M 3.96875 17.03125 C 3.679688 16.734375 3.683594 16.265625 3.972656 15.972656 C 4.265625 15.683594 4.738281 15.679688 5.03125 15.96875 L 6 16.9375 L 6.96875 15.96875 C 7.261719 15.679688 7.734375 15.683594 8.027344 15.972656 C 8.316406 16.265625 8.320312 16.734375 8.03125 17.03125 L 7.0625 18 L 8.03125 18.96875 C 8.320312 19.265625 8.316406 19.734375 8.027344 20.027344 C 7.734375 20.316406 7.261719 20.320312 6.96875 20.03125 L 6 19.0625 L 5.03125 20.03125 C 4.738281 20.320312 4.265625 20.316406 3.972656 20.027344 C 3.683594 19.734375 3.679688 19.265625 3.96875 18.96875 L 4.9375 18 Z M 6 28.5 C 4.621094 28.5 3.5 27.378906 3.5 26 C 3.5 24.621094 4.621094 23.5 6 23.5 C 7.378906 23.5 8.5 24.621094 8.5 26 C 8.5 27.378906 7.378906 28.5 6 28.5 Z M 22.453125 20.988281 L 19.417969 21 C 19.308594 21 19.199219 20.957031 19.121094 20.878906 C 19.042969 20.800781 19 20.691406 19 20.582031 L 19.011719 17.546875 C 19.019531 17.109375 19.203125 16.695312 19.527344 16.402344 C 19.851562 16.113281 20.28125 15.96875 20.714844 16.007812 C 21.515625 16.078125 22.097656 16.796875 22.09375 17.59375 L 22.089844 17.910156 L 22.40625 17.910156 C 23.207031 17.90625 23.921875 18.488281 23.992188 19.289062 C 24.03125 19.722656 23.886719 20.152344 23.59375 20.476562 C 23.300781 20.796875 22.886719 20.984375 22.453125 20.988281 Z M 22.453125 20.988281',
			'vw' => 28
		),
		'virus' => array(
			'p' => 'M 30.222656 14.222656 L 28.875 14.222656 C 25.707031 14.222656 24.121094 10.390625 26.359375 8.152344 L 27.3125 7.199219 C 27.964844 6.5 27.945312 5.40625 27.269531 4.730469 C 26.589844 4.054688 25.5 4.035156 24.800781 4.6875 L 23.847656 5.640625 C 21.609375 7.878906 17.777344 6.292969 17.777344 3.125 L 17.777344 1.777344 C 17.777344 0.796875 16.980469 0 16 0 C 15.019531 0 14.222656 0.796875 14.222656 1.777344 L 14.222656 3.125 C 14.222656 6.292969 10.390625 7.878906 8.152344 5.640625 L 7.199219 4.6875 C 6.5 4.035156 5.410156 4.054688 4.730469 4.730469 C 4.054688 5.40625 4.035156 6.5 4.6875 7.199219 L 5.640625 8.152344 C 7.878906 10.390625 6.292969 14.222656 3.125 14.222656 L 1.777344 14.222656 C 1.136719 14.210938 0.535156 14.546875 0.210938 15.101562 C -0.113281 15.65625 -0.113281 16.34375 0.210938 16.898438 C 0.535156 17.453125 1.136719 17.789062 1.777344 17.777344 L 3.125 17.777344 C 6.292969 17.777344 7.878906 21.609375 5.640625 23.847656 L 4.6875 24.800781 C 4.042969 25.5 4.0625 26.585938 4.738281 27.261719 C 5.414062 27.9375 6.5 27.957031 7.199219 27.3125 L 8.152344 26.359375 C 10.390625 24.121094 14.222656 25.707031 14.222656 28.875 L 14.222656 30.21875 C 14.222656 31.203125 15.019531 32 16 32 C 16.980469 32 17.777344 31.203125 17.777344 30.21875 L 17.777344 28.875 C 17.777344 25.707031 21.609375 24.121094 23.847656 26.359375 L 24.800781 27.3125 C 25.5 27.957031 26.585938 27.9375 27.261719 27.261719 C 27.9375 26.585938 27.957031 25.5 27.3125 24.800781 L 26.359375 23.847656 C 24.121094 21.609375 25.707031 17.777344 28.875 17.777344 L 30.21875 17.777344 C 30.863281 17.789062 31.460938 17.453125 31.789062 16.898438 C 32.113281 16.34375 32.113281 15.65625 31.789062 15.101562 C 31.460938 14.546875 30.863281 14.210938 30.21875 14.222656 Z M 14 17 C 12.34375 17 11 15.65625 11 14 C 11 12.34375 12.34375 11 14 11 C 15.65625 11 17 12.34375 17 14 C 17 15.65625 15.65625 17 14 17 Z M 19 20.5 C 18.171875 20.5 17.5 19.828125 17.5 19 C 17.5 18.171875 18.171875 17.5 19 17.5 C 19.828125 17.5 20.5 18.171875 20.5 19 C 20.5 19.828125 19.828125 20.5 19 20.5 Z M 19 20.5',
		),
		'viruses' => array(
			'p' => 'M 39 22 L 38.242188 22 C 36.460938 22 35.566406 19.84375 36.828125 18.585938 L 37.363281 18.050781 C 37.753906 17.660156 37.753906 17.027344 37.363281 16.636719 C 36.972656 16.246094 36.339844 16.246094 35.949219 16.636719 L 35.414062 17.171875 C 34.15625 18.433594 32 17.539062 32 15.757812 L 32 15 C 32 14.449219 31.550781 14 31 14 C 30.449219 14 30 14.449219 30 15 L 30 15.757812 C 30 17.539062 27.84375 18.433594 26.585938 17.171875 L 26.050781 16.636719 C 25.660156 16.246094 25.027344 16.246094 24.636719 16.636719 C 24.246094 17.027344 24.246094 17.660156 24.636719 18.050781 L 25.171875 18.585938 C 26.433594 19.84375 25.539062 22 23.757812 22 L 23 22 C 22.449219 22 22 22.449219 22 23 C 22 23.550781 22.449219 24 23 24 L 23.757812 24 C 25.539062 24 26.433594 26.15625 25.171875 27.414062 L 24.636719 27.949219 C 24.246094 28.339844 24.246094 28.972656 24.636719 29.363281 C 25.027344 29.753906 25.660156 29.753906 26.050781 29.363281 L 26.585938 28.828125 C 27.84375 27.566406 30 28.460938 30 30.242188 L 30 31 C 30 31.550781 30.449219 32 31 32 C 31.550781 32 32 31.550781 32 31 L 32 30.242188 C 32 28.460938 34.15625 27.566406 35.414062 28.828125 L 35.949219 29.363281 C 36.339844 29.753906 36.972656 29.753906 37.363281 29.363281 C 37.753906 28.972656 37.753906 28.339844 37.363281 27.949219 L 36.828125 27.414062 C 35.566406 26.15625 36.460938 24 38.242188 24 L 39 24 C 39.550781 24 40 23.550781 40 23 C 40 22.449219 39.550781 22 39 22 Z M 30 24 C 28.894531 24 28 23.105469 28 22 C 28 20.894531 28.894531 20 30 20 C 31.105469 20 32 20.894531 32 22 C 32 23.105469 31.105469 24 30 24 Z M 21.65625 13.332031 L 22.667969 13.332031 C 23.402344 13.332031 24 12.734375 24 12 C 24 11.265625 23.402344 10.667969 22.667969 10.667969 L 21.65625 10.667969 C 19.28125 10.667969 18.089844 7.792969 19.769531 6.113281 L 20.484375 5.398438 C 21.003906 4.878906 21 4.035156 20.480469 3.515625 C 19.960938 2.996094 19.121094 2.996094 18.601562 3.515625 L 17.886719 4.230469 C 16.207031 5.910156 13.332031 4.71875 13.332031 2.34375 L 13.332031 1.332031 C 13.332031 0.597656 12.734375 0 12 0 C 11.265625 0 10.667969 0.597656 10.667969 1.332031 L 10.667969 2.34375 C 10.667969 4.71875 7.792969 5.910156 6.113281 4.230469 L 5.398438 3.515625 C 4.878906 2.996094 4.039062 2.996094 3.519531 3.515625 C 3 4.035156 2.996094 4.878906 3.515625 5.398438 L 4.230469 6.113281 C 5.910156 7.792969 4.71875 10.667969 2.34375 10.667969 L 1.332031 10.667969 C 0.597656 10.667969 0 11.265625 0 12 C 0 12.734375 0.597656 13.332031 1.332031 13.332031 L 2.34375 13.332031 C 4.71875 13.332031 5.910156 16.207031 4.230469 17.886719 L 3.515625 18.601562 C 2.992188 19.121094 2.992188 19.964844 3.515625 20.484375 C 4.035156 21.007812 4.878906 21.007812 5.398438 20.484375 L 6.113281 19.769531 C 7.792969 18.089844 10.667969 19.28125 10.667969 21.65625 L 10.667969 22.667969 C 10.667969 23.402344 11.265625 24 12 24 C 12.734375 24 13.332031 23.402344 13.332031 22.667969 L 13.332031 21.65625 C 13.332031 19.28125 16.207031 18.089844 17.886719 19.769531 L 18.601562 20.484375 C 19.121094 21.007812 19.964844 21.007812 20.484375 20.484375 C 21.007812 19.964844 21.007812 19.121094 20.484375 18.601562 L 19.769531 17.886719 C 18.089844 16.207031 19.28125 13.332031 21.65625 13.332031 Z M 10 12 C 8.894531 12 8 11.105469 8 10 C 8 8.894531 8.894531 8 10 8 C 11.105469 8 12 8.894531 12 10 C 12 11.105469 11.105469 12 10 12 Z M 15 14 C 14.449219 14 14 13.550781 14 13 C 14 12.449219 14.449219 12 15 12 C 15.550781 12 16 12.449219 16 13 C 16 13.550781 15.550781 14 15 14 Z M 15 14',
			'vw' => 40
		),
		'virus-slash' => array(
			'p' => 'M 7.125 14.226562 L 5.773438 14.226562 C 4.792969 14.226562 4 15.019531 4 16 C 4 16.980469 4.792969 17.773438 5.773438 17.773438 L 7.125 17.773438 C 10.292969 17.773438 11.882812 21.605469 9.636719 23.84375 L 8.6875 24.800781 C 7.96875 25.46875 7.925781 26.59375 8.585938 27.3125 C 9.25 28.03125 10.382812 28.074219 11.101562 27.414062 C 11.132812 27.382812 11.167969 27.351562 11.199219 27.3125 L 12.148438 26.363281 C 14.386719 24.125 18.21875 25.707031 18.21875 28.875 L 18.21875 30.21875 C 18.21875 31.199219 19.019531 31.992188 20 31.992188 C 20.980469 31.992188 21.773438 31.199219 21.773438 30.21875 L 21.773438 28.875 C 21.773438 27.210938 22.835938 26.007812 24.164062 25.539062 L 8.882812 13.726562 C 8.355469 14.042969 7.742188 14.21875 7.125 14.226562 Z M 38.5625 31.613281 L 39.789062 30.03125 C 40.125 29.59375 40.050781 28.96875 39.613281 28.625 L 29.414062 20.75 C 29.675781 19.164062 30.96875 17.78125 32.875 17.78125 L 34.21875 17.78125 C 35.199219 17.78125 35.992188 16.988281 35.992188 16.007812 C 35.992188 15.023438 35.199219 14.230469 34.21875 14.230469 L 32.875 14.230469 C 29.707031 14.230469 28.117188 10.398438 30.363281 8.164062 L 31.3125 7.207031 C 31.980469 6.488281 31.9375 5.363281 31.210938 4.695312 C 30.53125 4.0625 29.480469 4.0625 28.800781 4.695312 L 27.851562 5.644531 C 25.613281 7.882812 21.78125 6.300781 21.78125 3.132812 L 21.78125 1.78125 C 21.773438 0.792969 20.980469 0 20 0 C 19.019531 0 18.226562 0.792969 18.226562 1.773438 L 18.226562 3.125 C 18.226562 6.292969 14.394531 7.882812 12.15625 5.636719 L 11.199219 4.6875 C 10.507812 3.992188 9.363281 4.023438 8.667969 4.71875 L 2.84375 0.210938 C 2.40625 -0.125 1.78125 -0.0507812 1.4375 0.386719 L 0.210938 1.96875 C -0.125 2.40625 -0.0507812 3.03125 0.386719 3.375 L 37.164062 31.792969 C 37.59375 32.132812 38.226562 32.050781 38.5625 31.613281 Z M 20.960938 14.21875 L 17.03125 11.179688 C 17.335938 11.070312 17.667969 11.007812 17.992188 11 C 19.648438 11 20.992188 12.34375 20.992188 14 C 21 14.074219 20.96875 14.144531 20.960938 14.21875 Z M 20.960938 14.21875',
			'vw' => 40
		),
		'voicemail' => array(
			'p' => 'M 31 8 C 27.679688 8 24.628906 9.828125 23.0625 12.757812 C 21.496094 15.6875 21.671875 19.238281 23.515625 22 L 16.484375 22 C 18.777344 18.566406 18.441406 14.015625 15.667969 10.957031 C 12.898438 7.898438 8.398438 7.117188 4.757812 9.0625 C 1.117188 11.007812 -0.734375 15.183594 0.269531 19.1875 C 1.273438 23.191406 4.871094 26 9 26 L 31 26 C 35.96875 26 40 21.96875 40 17 C 40 12.03125 35.96875 8 31 8 Z M 4 17 C 4 14.238281 6.238281 12 9 12 C 11.761719 12 14 14.238281 14 17 C 14 19.761719 11.761719 22 9 22 C 6.238281 22 4 19.761719 4 17 Z M 31 22 C 28.238281 22 26 19.761719 26 17 C 26 14.238281 28.238281 12 31 12 C 33.761719 12 36 14.238281 36 17 C 36 19.761719 33.761719 22 31 22 Z M 31 22',
			'vw' => 40
		),
		'wave-square' => array(
			'p' => 'M 29.75 30 L 20.25 30 C 19.007812 30 18 28.992188 18 27.75 L 18 6 L 12 6 L 12 15.75 C 12 16.992188 10.992188 18 9.75 18 L 1 18 C 0.449219 18 0 17.550781 0 17 L 0 15 C 0 14.449219 0.449219 14 1 14 L 8 14 L 8 4.25 C 8 3.007812 9.007812 2 10.25 2 L 19.75 2 C 20.992188 2 22 3.007812 22 4.25 L 22 26 L 28 26 L 28 16.25 C 28 15.007812 29.007812 14 30.25 14 L 39 14 C 39.550781 14 40 14.449219 40 15 L 40 17 C 40 17.550781 39.550781 18 39 18 L 32 18 L 32 27.75 C 32 28.992188 30.992188 30 29.75 30 Z M 29.75 30',
			'vw' => 40
		),
		'automobile' => 'car',
		'dollar' => 'dollar-sign',
	    'glass-martini' => array(
		'p' => 'M31.375 3.625L18 17v12h3.5q1.063 0 1.781.719T24 31.5q0 .5-.5.5h-15q-.5 0-.5-.5 0-1.063.719-1.781T10.5 29H14V17L.625 3.625q-1-1-.469-2.313T2.125-.001h27.75q1.438 0 1.969 1.313t-.469 2.313z'
	    ),
	    'music' => array(
		'p' => 'M32 2v22q0 1.688-1.75 2.844T26 28t-4.25-1.156T20 24t1.75-2.844T26 20q.938 0 2 .25V8.687l-16 4.688V28q0 1.688-1.75 2.844T6 32t-4.25-1.156T0 28t1.75-2.844T6 24q.938 0 2 .25V7.875Q8 6.437 9.375 6l20-5.875q1-.313 1.813.281T32.001 2z'
	    ),
	    'search' => array(
		'p' => 'M31.563 27.688q.438.438.438 1.063t-.438 1.063l-1.75 1.75q-.438.438-1.063.438t-1.063-.438l-6.25-6.25q-.438-.438-.438-1.063v-1q-3.5 2.75-8 2.75-5.375 0-9.188-3.813T-.002 13t3.813-9.188 9.188-3.813 9.188 3.813T26 13q0 4.5-2.75 8h1q.625 0 1.063.438zM13 21q3.313 0 5.656-2.344T21 13t-2.344-5.656T13 5 7.344 7.344 5 13t2.344 5.656T13 21z',
		'w' => .998046875
	    ),
	    'heart' => array(
		'p' => 'M28.875 3.938q2.938 2.5 3.125 6.375t-2.5 6.563l-12.063 12.5q-.625.625-1.438.625t-1.438-.625l-12.063-12.5q-2.688-2.688-2.5-6.563t3.125-6.375Q5.686 1.75 9.029 2.032t5.719 2.719l1.25 1.25 1.25-1.25q2.375-2.438 5.719-2.719t5.906 1.906z'
	    ),
	    'star' => array(
		'p' => 'M16.188 1.125Q16.751 0 18.001 0t1.813 1.125l4.063 8.25 9.125 1.375q1.25.125 1.625 1.313t-.5 2.063l-6.625 6.438 1.563 9.125q.188 1.188-.813 1.906t-2.063.156l-8.188-4.25-8.188 4.25q-1.063.625-2.063-.125t-.813-1.938L8.5 20.563l-6.625-6.438q-.875-.875-.5-2.063T3 10.749l9.125-1.375z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'user' => array(
		'p' => '#k#m5.625 2q3.438 0 5.906 2.469T28 26.375V29#n# 32H3q-1.25 0-2.125-.875T0 29v-2.625q0-3.438 2.469-5.906T8.375 18h1.063q2.188 1 4.563 1t4.563-1h1.063z',
		'w' => .875,
		'vw' => 28
	    ),
	    'film' => array(
		'p' => 'M30.5 4q.625 0 1.063.438t.438 1.063v21q#p#8H30v-1.25q0-.75-.75-.75h-2.5q-.75 0-.75.75v1.25H6v-1.25q0-.75-.75-.75h-2.5q-.75 0-.75.75v1.25h-.5q-.625 0-1.063-.438t-.438-1.063v-21q0-.625.438-1.063T1.5 4H2v1.25Q2 6 2.75 6h2.5Q6 6 6 5.25V4h20v1.25q0 .75.75.75h2.5Q30 6 30 5.25V4h.5zM6 23.25v-2.5Q6 20 5.25 20h-2.5Q2 20 2 20.75v2.5q0 .75.75.75h2.5Q6 24 6 23.25zm0-6v-2.5Q6 14 5.25 14h-2.5Q2 14 2 14.75v2.5q0 .75.75.75h2.5Q6 18 6 17.25zm0-6v-2.5Q6 8 5.25 8h-2.5Q2 8 2 8.75v2.5q0 .75.75.75h2.5Q6 12 6 11.25zm17 13v-6q0-.75-.75-.75H9.75q-.75 0-.75.75v6q0 .75.75.75h12.5q.75 0 .75-.75zm0-10.5v-6Q23 7 22.25 7H9.75Q9 7 9 7.75v6q0 .75.75.75h12.5q.75 0 .75-.75zm7 9.5v-2.5q0-.75-.75-.75h-2.5q-.75 0-.75.75v2.5q0 .75.75.75h2.5q.75 0 .75-.75zm0-6v-2.5q0-.75-.75-.75h-2.5q-.75 0-.75.75v2.5q0 .75.75.75h2.5q.75 0 .75-.75zm0-6v-2.5Q30 8 29.25 8h-2.5Q26 8 26 8.75v2.5q0 .75.75.75h2.5q.75 0 .75-.75z'
	    ),
	    'th-large' => array(
		'p' => 'M18.5 2h12q.625 0 1.063.438t.438 1.063v10q#p#8h-12q-.625 0-1.063-.438t-.438-1.063v-10q0-.625.438-1.063T18.5 2zm-5 0q.625 0 1.063.438t.438 1.063v10q#p#8h-12q-.625 0-1.063-.438t-.438-1.063v-10q0-.625.438-1.063T1.5 2h12zM0 18.5q0-.625.438-1.063t1.063-.438h12q.625 0 1.063.438t.438 1.063v10q#p#8h-12q-.625 0-1.063-.438T0 28.5v-10zM18.5 30q-.625 0-1.063-.438t-.438-1.063v-10q0-.625.438-1.063t1.063-.438h12q.625 0 1.063.438t.438 1.063v10q0 .625-.438 1.063T30.5 30h-12z'
	    ),
	    'th' => array(
		'p' => 'M9.313 3.5v5q#p#8H1.499q-.625 0-1.063-.438T-.002 8.5v-5q0-.625.438-1.063t1.063-.438h6.313q.625 0 1.063.438T9.313 3.5zm11.375 15q0 .438-.219.781t-.563.531-.719.188h-6.375q-.625 0-1.063-.438t-.438-1.063v-5q0-.625.438-1.063t1.063-.438h6.375q.625 0 1.063.438t.438 1.063v5zm2-15q0-.625.438-1.063t1.063-.438h6.313q.625 0 1.063.438t.438 1.063v5q#p#8h-6.313q-.625 0-1.063-.438T22.688 8.5v-5zm-2 5q0 .313-.125.594t-.344.469-.469.313-.563.125h-6.375q-.625 0-1.063-.438T11.311 8.5v-5q0-.625.438-1.063t1.063-.438h6.375q.625 0 1.063.438t.438 1.063v5zM7.813 12q.625 0 1.063.438t.438 1.063v5q#p#8H1.5q-.625 0-1.063-.438t-.438-1.063v-5q0-.625.438-1.063T1.5 12h6.313zM0 23.5q0-.625.438-1.063t1.063-.438h6.313q.625 0 1.063.438t.438 1.063v5q#p#8H1.501q-.625 0-1.063-.438T0 28.5v-5zM24.188 20q-.625 0-1.063-.438t-.438-1.063v-5q0-.625.438-1.063t1.063-.438h6.313q.625 0 1.063.438t.438 1.063v5q0 .625-.438 1.063T30.501 20h-6.313zm0 10q-.625 0-1.063-.438t-.438-1.063v-5q0-.625.438-1.063t1.063-.438h6.313q.625 0 1.063.438t.438 1.063v5q0 .625-.438 1.063T30.501 30h-6.313zm-12.875-6.5q0-.625.438-1.063t1.063-.438h6.375q.625 0 1.063.438t.438 1.063v5q#p#8h-6.375q-.625 0-1.063-.438t-.438-1.063v-5z'
	    ),
	    'th-list' => array(
		'p' => 'M9.313 13.5v5q#p#8H1.499q-.625 0-1.063-.438T-.002 18.5v-5q0-.625.438-1.063t1.063-.438h6.313q.625 0 1.063.438t.438 1.063zM0 23.5q0-.625.438-1.063t1.063-.438h6.313q.625 0 1.063.438t.438 1.063v5q#p#8H1.501q-.625 0-1.063-.438T0 28.5v-5zM7.813 2q.625 0 1.063.438t.438 1.063v5q#p#8H1.5q-.625 0-1.063-.438t-.438-1.063v-5q0-.625.438-1.063T1.5 2h6.313zm5 28q-.625 0-1.063-.438t-.438-1.063v-5q0-.625.438-1.063t1.063-.438h17.688q.625 0 1.063.438t.438 1.063v5q0 .625-.438 1.063T30.501 30H12.813zm-1.5-26.5q0-.625.438-1.063t1.063-.438h17.688q.625 0 1.063.438t.438 1.063v5q#p#8H12.814q-.625 0-1.063-.438T11.313 8.5v-5zm1.5 16.5q-.625 0-1.063-.438t-.438-1.063v-5q0-.625.438-1.063t1.063-.438h17.688q.625 0 1.063.438t.438 1.063v5q0 .625-.438 1.063T30.501 20H12.813z'
	    ),
	    'check' => array(
		'p' => 'M10.875 27.438L.437 17.063q-.438-.438-.438-1.125t.438-1.125l2.313-2.25q.438-.5 1.094-.5t1.156.5l7 7 15-15q.5-.5 1.156-.5t1.094.5l2.313 2.25q.438.438.438 1.125t-.438 1.125L13.125 27.438q-.438.5-1.125.5t-1.125-.5z'
	    ),
	    'times' => array(
		'p' => 'M15.188 16l6.25 6.25q.563.563.563 1.375t-.563 1.438l-1.375 1.375q-.625.563-1.438.563t-1.375-.563L11 20.188l-6.25 6.25q-.563.563-1.375.563t-1.438-.563L.562 25.063q-.563-.625-.563-1.438t.563-1.375L6.812 16 .562 9.75q-.563-.563-.563-1.375t.563-1.438l1.375-1.375q.625-.563 1.438-.563t1.375.563l6.25 6.25 6.25-6.25q.563-.563 1.375-.563t1.438.563l1.375 1.375q.563.625.563 1.438t-.563 1.375z',
		'w' => .6875,
		'vw' => 22
	    ),
	    'search-plus' => array(
		'p' => 'M19 12v2q0 .75-.75.75h-3.5v3.5q0 .75-.75.75h-2q-.75 0-.75-.75v-3.5h-3.5Q7 14.75 7 14v-2q0-.75.75-.75h3.5v-3.5q0-.75.75-.75h2q.75 0 .75.75v3.5h3.5q.75 0 .75.75zm12.563 17.813l-1.75 1.75q-.438.438-1.063.438t-1.063-.438l-6.25-6.25q-.438-.438-.438-1.063v-1q-3.5 2.75-8 2.75-5.375 0-9.188-3.813t-3.813-9.188 3.813-9.188 9.188-3.813 9.188 3.813T26 12.999q0 4.5-2.75 8h1q.625 0 1.063.438l6.25 6.25q.438.438.438 1.063t-.438 1.063zM21.5 13q0-3.5-2.5-6t-6-2.5T7 7t-2.5 6T7 19t6 2.5 6-2.5 2.5-6z',
		'w' => .998046875
	    ),
	    'search-minus' => array(
		'p' => 'M19 12v2q0 .75-.75.75H7.75Q7 14.75 7 14v-2q0-.75.75-.75h10.5q.75 0 .75.75zm12.563 17.813l-1.75 1.75q-.438.438-1.063.438t-1.063-.438l-6.25-6.25q-.438-.438-.438-1.063v-1q-3.5 2.75-8 2.75-5.375 0-9.188-3.813t-3.813-9.188 3.813-9.188 9.188-3.813 9.188 3.813T26 12.999q0 4.5-2.75 8h1q.625 0 1.063.438l6.25 6.25q.438.438.438 1.063t-.438 1.063zM21.5 13q0-3.5-2.5-6t-6-2.5T7 7t-2.5 6T7 19t6 2.5 6-2.5 2.5-6z',
		'w' => .998046875
	    ),
	    'power-off' => array(
		'p' => 'M25 3.375q3 2.125 4.75 5.469T31.5 16q0 6.438-4.531 10.969T16 31.5q-4.188 0-7.75-2.063t-5.656-5.625T.5 15.999q0-2.563.813-4.938t2.25-4.313 3.438-3.375q.563-.375 1.219-.219t.969.719l1 1.75q.25.5.125 1.063t-.563.875q-1 .75-1.781 1.656t-1.313 1.969-.844 2.281-.313 2.531q0 4.313 3.063 7.406t7.438 3.094q4.313 0 7.406-3.063t3.094-7.5q0-2.438-1.125-4.656T22.251 7.56q-.438-.313-.563-.875t.125-1.063l1-1.75q.313-.563.969-.719t1.219.219zM18.5 16.5q#p#8h-2q-.625 0-1.063-.438t-.438-1.063v-15q0-.625.438-1.063t1.063-.438h2q.625 0 1.063.438T18.5 1.5v15z',
		'w' => .998046875
	    ),
	    'signal' => array(
		'p' => 'M13.5 18q.438 0 .719.281T14.5 19v12q0 .438-.281.719T13.5 32h-3q-.438 0-.719-.281T9.5 31V19q0-.438.281-.719T10.5 18h3zm-8 6q.438 0 .719.281T6.5 25v6q0 .438-.281.719T5.5 32h-3q-.438 0-.719-.281T1.5 31v-6q0-.438.281-.719T2.5 24h3zm16-12q.438 0 .719.281T22.5 13v18q0 .438-.281.719T21.5 32h-3q-.438 0-.719-.281T17.5 31V13q0-.438.281-.719T18.5 12h3zm8-6q.438 0 .719.281T30.5 7v24q0 .438-.281.719T29.5 32h-3q-.438 0-.719-.281T25.5 31V7q0-.438.281-.719T26.5 6h3zm8-6q.438 0 .719.281T38.5 1v30q0 .438-.281.719T37.5 32h-3q-.438 0-.719-.281T33.5 31V1q0-.438.281-.719T34.5 0h3z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'cog' => array(
		'p' => 'M30.438 19.75q.563.25.375.875-1.063 3.313-3.438 5.875-.375.438-.875.188l-2.688-1.563q-1.688 1.438-3#r#188v3.063q0 .625-.563.75-3.438.75-6.813 0-.625-.125-.625-.75v-3.063q-2.125-.75-3.813-2.188L5.56 26.688q-.563.25-.938-#q#375-2.563-3.438-5.875-.188-.563.375-.875l2.625-1.563q-.188-1.063-#q#188t#q#188l-2.625-1.563q-.563-.25-.375-.875Q2.247 8.06 4.622 5.498q.375-.438.938-.125l2.625 1.5q1.688-1.438 3.813-2.188V1.622q0-.625.563-.75 3.438-.75 6.875 0 .563.125.563.75v3.063q2.125.75 3#r#188l2.625-1.563q.563-.25.938.188 2.375 2.563 3.438 5.875.188.625-.375.875l-2.625 1.563q.375 2.188 0 4.375zM16 21q2.063 0 3.531-1.469T21 16t-1.469-3.531T16 11t-3.531 1.469T11 16t1.469 3.531T16 21z'
	    ),
	    'gear'=>'cog',
	    'home' => array(
		'p' => 'M17.5 9.25q.25-.125.5-.125t.5.125l11.5 9.5V29q0 .438-.281.719T29 30h-7q-.438 0-.719-.313T21 28.999v-6q0-.25-.125-.5t-.375-.375-.5-.125h-4q-.438 0-.719.281t-.281.719v6q0 .375-.281.688T14 30H7q-.438 0-.719-.281T6 29V18.75zm18.25 6.438q.25.25.25.625 0 .25-.188.438l-1.563 1.938q-.25.313-.563.313t-.5-.188L18.498 6.689q-.25-.125-.5-.125t-.5.125L2.81 18.814q-.188.188-.438.188-.375 0-.625-.313L.184 16.751q-.188-.188-.188-.438 0-.375.25-.625l15.813-13Q16.934 2 17.997 2t1.875.688l5.625 4.625V2.75q0-.313.219-.531T26.247 2h3.5q.313 0 .531.219t.219.531v8.688z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'clock' => array(
		'p' => '#e#3.563 21.875q.625.438 1.063-.125l1.75-2.438q.438-.625-.125-1.063l-4-2.875V7.249q0-.75-.75-.75h-3q-.75 0-.75.75v10.5q0 .375.313.625z'
	    ),
	    'road' => array(
		'p' => 'M35.813 25.188q.438 1-.125 1.906T34.063 28h-12.25l-.688-6.125q0-.375-.281-.625t-.719-.25h-4.25q-.25 0-.469.125t-.375.313-.156.438l-.688 6.125H1.937q-1.063 0-1.625-.906t-.125-1.906l8.75-20q.5-1.188 1.688-1.188h6.125l-.188 1.438q0 .25.156.406t.344.156h1.875q.188 0 .344-.156t.156-.406l-.188-1.438h6.125q1.188 0 1.688 1.188zM16.25 8.438l-.25 2.75q-.063.313.156.563t.594.25h2.5q.375 0 .594-.25t.156-.563l-.25-2.75Q19.687 8 19.25 8h-2.5q-.438 0-.5.438zM19.75 19q.25 0 .5-.156t.375-.406.125-.563l-.375-3q0-.375-.281-.625t-.656-.25h-2.875q-.375 0-.656.25t-.281.625l-.375 3q0 .313.125.563t.375.406.5.156h3.5z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'download' => array(
		'p' => 'M13.5 0h5q.625 0 1.063.438t.438 1.063v10.5h5.5q.813 0 1.125.781t-.25 1.344l-9.5 9.5q-.375.375-.875.375t-.875-.375l-9.5-9.5q-.563-.563-.25-1.344t1.125-.781h5.5v-10.5q0-.625.438-1.063T13.502 0zM32 23.5v7q#p#8h-29q-.625 0-1.063-.438T-.002 30.5v-7q0-.625.438-1.063t1.063-.438h9.188l3.063 3.063Q14.688 26 16 26t2.25-.938l3.063-3.063h9.188q.625 0 1.063.438t.438 1.063zM24.25 29q0-.5-.375-.875T23 27.75t-.875.375-.375.875.375.875.875.375.875-.375.375-.875zm4 0q0-.5-.375-.875T27 27.75t-.875.375-.375.875.375.875.875.375.875-.375.375-.875z'
	    ),
	    'inbox' => array(
		'p' => 'M35.5 15.25q.5.75.5 1.688v8.063q0 1.25-.875 2.125T33 28.001H3q-1.25 0-2.125-.875T0 25.001v-8.063Q0 16 .5 15.25l6.625-9.938q.25-.313.656-.625t.906-.5.938-.188h16.75q.688 0 1.406.406t1.094.906zM10.125 8l-5.313 8H12.5l2 4h7l2-4h7.688l-5.313-8h-15.75z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'redo' => array(
		'p' => 'M31.25 0q.313 0 .531.219T32 .75v12.5q0 .313-.219.531T31.25 14h-12.5q-.313 0-.531-.219T18 13.25v-2.938q0-.313.219-.531t.594-.219l6.313.313q-1.5-2.25-3.906-3.563t-5.219-1.313q-4.563 0-7.781 3.219t-3.219 7.781T8.22 23.78t7.781 3.219q4.188 0 7.25-2.75.563-.438 1.063.063l2.125 2.125q.563.563-.063 1.063-4.438 4-10.375 4-6.438 0-10.969-4.531T.501 16q0-4.188 2.063-7.75T8.22 2.594 16.001.5q3.5 0 6.563 1.438t5.25 4l-.25-5.125q0-.375.219-.594T28.314 0h2.938z',
		'w' => 1.015625,
		'vw' => 33
	    ),
	    'sync' => array(
		'p' => 'M27.563.813q0-.375.219-.594T28.313 0h2.938q.313 0 .531.219t.219.531v12.5q0 .313-.219.531t-.531.219h-12.5q-.313 0-.531-.219t-.219-.531v-2.938q0-.313.219-.531t.594-.219l6.313.313q-1.5-2.25-3.906-3.563t-5.219-1.313q-3.875 0-6.844 2.375t-3.844 6.063q-.125.563-.75.563H1.501q-.25 0-.438-.125t-.25-.344-.063-.406q1.063-5.438 5.344-9.031T16 .5q3.5 0 6.563 1.438t5.25 4zM16 27q3.875 0 6.844-2.375t3.844-6.063q.125-.563.75-.563h3.063q.375 0 .594.281t.156.594q-.688 3.563-2.844 6.438t-5.406 4.531-7 1.656q-3.5 0-6.563-1.438t-5.25-4l.25 5.125q.063.375-.156.594t-.594.219H.75q-.75 0-.75-.75v-12.5q0-.313.219-.531t.531-.219h12.5q.313 0 .531.219t.219.531v2.938q0 .313-.219.531t-.531.219l-6.375-.313q1.5 2.25 3.906 3.563T16 27z'
	    ),
	    'list-alt' => array(
		'p' => 'M29 30H3q-1.25 0-2.125-.875T0 27V5q0-1.25.875-2.125T3 2h26q1.25 0 2.125.875T32 5v22q0 1.25-.875 2.125T29 30zM8 7.5q-1.063 0-1.781.719T5.5 10t.719 1.781T8 12.5t1.781-.719T10.5 10t-.719-1.781T8 7.5zm0 6q-1.063 0-1.781.719T5.5 16t.719 1.781T8 18.5t1.781-.719T10.5 16t-.719-1.781T8 13.5zm0 6q-1.063 0-1.781.719T5.5 22t.719 1.781T8 24.5t1.781-.719T10.5 22t-.719-1.781T8 19.5zM26 11V9q0-.75-.75-.75h-12.5Q12 8.25 12 9v2q0 .75.75.75h12.5q.75 0 .75-.75zm0 6v-2q0-.75-.75-.75h-12.5q-.75 0-.75.75v2q0 .75.75.75h12.5q.75 0 .75-.75zm0 6v-2q0-.75-.75-.75h-12.5q-.75 0-.75.75v2q0 .75.75.75h12.5q.75 0 .75-.75z'
	    ),
	    'lock' => array(
		'p' => 'M25 14q1.25 0 2.125.875T28 17v12#n# 32H3q-1.25 0-2.125-.875T0 29V17q0-1.25.875-2.125T3 14h1.5V9.5q0-3.938 2.781-6.719T14 0t6.719 2.781T23.5 9.5V14H25zm-6.5 0V9.5q0-1.875-1.313-3.188t-3.188-1.313-3.188 1.313T9.498 9.5V14h9z',
		'w' => .875,
		'vw' => 28
	    ),
	    'flag' => array(
		'p' => 'M21.875 6.188q3 0 7.313-2 .938-.438 1.875.125t.938 1.688v15.188q0 1.063-.875 1.625-3.688 2.563-7.625 2.563-2.25 0-5.5-1.094t-4.875-1.094q-3.875 0-7.125 1.438v5.875q#p#8h-1q-.625 0-1.063-.438t-.438-1.063V6.377q-1.5-1.063-1.5-2.875 0-1.5 1.063-2.531T4.125.002q1.375.063 2.344 1T7.5 3.252v.25q0 .625-.25 1.25 2.063-.75 4.281-.75T17 5.096t4.875 1.094z',
		'w' => 1.015625,
		'vw' => 33
	    ),
	    'headphones' => array(
		'p' => 'M16 2q6.625 0 11.313 4.688t4.688 11.313v3q0 .5-.313 1.031t-.813.781l-.875.438q-.125 2.813-2.156 4.781T23 30.001h-1.5q-.625 0-1.063-.438t-.438-1.063v-11q0-.625.438-1.063t1.063-.438H23q2.938 0 5 2.125v-.125q0-4.938-3.531-8.469T16 5.999 7.531 9.53 4 17.999v.125q2.063-2.125 5-2.125h1.5q.625 0 1.063.438t.438 1.063v11q#p#8H9q-2.813 0-4.844-1.969T2 23.251l-.875-.438q-.5-.25-.813-.781t-.313-1.031v-3q0-6.625 4.688-11.313T16 2z'
	    ),
	    'volume-off' => array(
		'p' => 'M13.5 4.438q.75-.688 1.656-.313t.906 1.375v21q0 1-.906 1.375t-1.656-.313l-5.563-5.563H1.562q-.625 0-1.063-.438t-.438-1.063v-9q0-.625.438-1.063t1.063-.438h6.375z',
		'w' => .50390625,
		'vw' => 16
	    ),
	    'volume-down' => array(
		'p' => 'M13.438 4.5q.688-.688 1.625-.313t.938 1.375v21q0 1-.938 1.375t-1.625-.313l-5.563-5.563H1.5q-.625 0-1.063-.438t-.438-1.063v-9q0-.625.438-1.063t1.063-.438h6.375zm7.687 6.75q1.313.75 2.094 2.031T24 16.062t-.781 2.781-2.094 2.031q-.5.313-1.125.125t-.906-.719-.125-1.125.719-.906q1.313-.75 1.313-2.188t-1.313-2.188q-.563-.313-.719-.906t.125-1.125.906-.719 1.125.125z',
		'w' => .75,
		'vw' => 24
	    ),
	    'volume-up' => array(
		'p' => 'M13.438 4.438q.688-.688 1.625-.313t.938 1.375v21q0 1-.938 1.375t-1.625-.313l-5.563-5.563H1.5q-.625 0-1.063-.438t-.438-1.063v-9q0-.625.438-1.063T1.5 9.997h6.375zM28 1.25q3.75 2.438 5.875 6.375T36 16t-2.125 8.375T28 30.75q-.5.375-1.125.219t-.969-.656-.219-1.125.688-.938q2.063-1.375 3.531-3.281t2.281-4.219T33 16q0-3.688-1.781-6.938t-4.844-5.313q-.563-.313-.688-.938t.219-1.125.969-.656T28 1.249zM30 16q0 3-1.406 5.594t-3.969 4.156q-.563.375-1.156.219t-.906-.656q-.313-.563-.188-1.156t.688-.969q1.188-.75 2.094-1.875t1.375-2.5.469-2.813-.469-2.813-1.375-2.5-2.094-1.875q-.563-.375-.688-.969t.188-1.125.938-.688 1.125.219q2.563 1.563 3.969 4.156t1.406 5.594zm-8.875-4.812q1.313.75 2.094 2.031T24 16t-.781 2.781-2.094 2.031q-.5.313-1.125.125t-.906-.719-.125-1.125.719-.906q1.313-.75 1.313-2.188t-1.313-2.188q-.563-.313-.719-.906t.125-1.125.906-.719 1.125.125z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'qrcode' => array(
		'p' => 'M0 14V2h12v12H0zm4-8v4h4V6H4zm12-4h12v12H16V2zm8 8V6h-4v4h4zM0 30V18h12v12H0zm4-8v4h4v-4H4zm22-4h2v8h-6v-2h-2v6h-4V18h6v2h4v-2zm0 10h2v2h-2v-2zm-4 0h2v2h-2v-2z',
		'w' => .875,
		'vw' => 28
	    ),
	    'barcode' => array(
		'p' => 'M0 28V4h1.125v24H0zm1.688 0V4h.563v24h-.563zm1.687 0V4h.563v24h-.563zm2.813 0V4h.563v24h-.563zm2.25 0V4h1.125v24H8.438zm2.812 0V4h.563v24h-.563zm1.125 0V4h.563v24h-.563zm1.125 0V4h.563v24H13.5zm2.188 0V4h1.125v24h-1.125zm2.812 0V4h1.125v24H18.5zm2.25 0V4h1.125v24H20.75zM23 28V4h1.125v24H23zm1.688 0V4h1.125v24h-1.125zm2.812 0V4h1.688v24H27.5zm2.25 0V4h.563v24h-.563zm1.125 0V4H32v24h-1.125z'
	    ),
	    'tag' => array(
		'p' => 'M0 15.75V3Q0 1.75.875.875T3 0h12.75Q17 0 17.875.875l13.25 13.25Q32 15 32 16.25t-.875 2.125l-12.75 12.75Q17.5 32 16.25 32t-2.125-.875L.875 17.875Q0 17 0 15.75zM7 4q-1.25 0-2.125.875T4 7t.875 2.125T7 10t2.125-.875T10 7t-.875-2.125T7 4z',
		'w' => .998046875
	    ),
	    'tags' => array(
		'p' => 'M31.125 14.125Q32 15 32 16.25t-.875 2.125l-12.75 12.75Q17.5 32 16.25 32t-2.125-.875L.875 17.875Q0 17 0 15.75V3Q0 1.75.875.875T3 0h12.75Q17 0 17.875.875zM7 10q1.25 0 2.125-.875T10 7t-.875-2.125T7 4t-2.125.875T4 7t.875 2.125T7 10zm32.125 8.375l-12.75 12.75Q25.5 32 24.25 32t-2.125-.875L33 20.25q1.625-1.688 1.625-4t-1.625-4L20.687 0h3.063Q25 0 25.875.875l13.25 13.25Q40 15 40 16.25t-.875 2.125z',
		'w' => 1.248046875,
		'vw' => 40
	    ),
	    'book' => array(
		'p' => 'M28 22.5q0 .75-.563 1.188-.188.688-.188 2.313t.188 2.313q.563.5.563 1.188v1q#p#8h-20.5q-2.5 0-4.25-1.75t-1.75-4.25v-20q0-2.5 1.75-4.25t4.25-1.75h20.5q.625 0 1.063.438T28 1.504v21zM8 8.375v1.25Q8 10 8.375 10h13.25Q22 10 22 9.625v-1.25Q22 8 21.625 8H8.375Q8 8 8 8.375zm0 4v1.25Q8 14 8.375 14h13.25Q22 14 22 13.625v-1.25Q22 12 21.625 12H8.375Q8 12 8 12.375zM23.813 28q-.188-2 0-4H6q-.813 0-1.406.594T4 26t.594 1.406T6 28h17.813z',
		'w' => .875,
		'vw' => 28
	    ),
	    'bookmark' => array(
		'p' => 'M0 32V3Q0 1.75.875.875T3 0h18q1.25 0 2.125.875T24 3v29l-12-7z',
		'w' => .75,
		'vw' => 24
	    ),
	    'print' => array(
		'p' => 'M28 12q1.688 0 2.844 1.156T32 16v7q0 .438-.281.719T31 24h-3v6q0 .813-.594 1.406T26 32H6q-.813 0-1.406-.594T4 30v-6H1q-.438 0-.719-.281T0 23v-7q0-1.688 1.156-2.844T4 12V2q0-.813.594-1.406T6 0h17.188q.813 0 1.375.563l2.875 2.875q.563.563.563 1.375v7.188zm-4 16v-6H8v6h16zm0-14V8h-3q-.438 0-.719-.281T20 7V4H8v10h16zm3 4.5q.625 0 1.063-.438t.438-1.063-.438-1.063T27 15.498t-1.063.438-.438 1.063.438 1.063T27 18.5z'
	    ),
	    'camera' => array(
		'p' => 'M32 9v18q0 1.25-.875 2.125T29 30H3q-1.25 0-2.125-.875T0 27V9q0-1.25.875-2.125T3 6h5.5l.75-2.063q.25-.563.656-1t.969-.688 1.188-.25h7.875q.938 0 1.688.531t1.125 1.406l.75 2.063h5.5q1.25 0 2.125.875t.875 2.125zm-8.5 9q0-3.125-2.188-5.313t-5.313-2.188-5.313 2.188T8.498 18t2.188 5.313 5.313 2.188 5.313-2.188T23.5 18zm-2 0q0 2.25-1.625 3.875T16 23.5t-3.875-1.625T10.5 18t1.625-3.875T16 12.5t3.875 1.625T21.5 18z'
	    ),
	    'font' => array(
		'p' => 'M27 26q.438 0 .719.281T28 27v2q0 .438-.281.719T27 30h-8.5q-.438 0-.719-.281T17.5 29v-2q0-.438.281-.719T18.5 26h1.438l-1.625-5.063H9.688L8 26h1.5q.438 0 .719.281T10.5 27v2q0 .438-.281.719T9.5 30H1q-.438 0-.719-.281T0 29v-2q0-.438.281-.719T1 26h1.688l8.063-23.313q.25-.688 1-.688h4.5q.75 0 1 .688L25.314 26h1.688zm-16.125-9.25h6.188L14.5 9q-.375-1.063-.5-2.125-.188 1.063-.5 2.125z',
		'w' => .875,
		'vw' => 28
	    ),
	    'bold' => array(
		'p' => 'M19.063 15.25q2.063.688 3.25 2.438t1.188 4.188q0 2.75-1.563 4.844t-4 2.781q-1.688.5-4.188.5H1.5q-.438 0-.719-.281T.5 29.001v-2q0-.438.281-.719t.719-.281h2.063V6.063H1.5q-.438 0-.719-.281T.5 5.063V3q0-.438.281-.719T1.5 2h11.625q3.125 0 5 .75 2 .75 3.125 2.5t1.125 4q0 1.938-.875 3.531t-2.438 2.469zM8.875 6.313v7.063h4.813q1.563 0 2.438-.969t.875-2.594q0-2.25-1.563-3.063-.875-.438-2.313-.438h-4.25zm7.063 19.062q1-.375 1.594-1.438t.594-2.375q0-1.813-1.063-2.875t-2.875-1.063H8.875v8.063h5.063q1.25 0 2-.313z',
		'w' => .75,
		'vw' => 24
	    ),
	    'italic' => array(
		'p' => 'M12.813 26q.438 0 .75.375t.188.813l-.375 2q-.125.813-.938.813H2.5q-.5 0-.781-.375t-.219-.813l.438-2Q2.063 26 2.876 26h2.5L9.251 6H7.126q-.313 0-.563-.156t-.375-.438-.063-.594l.438-2q.125-.813.938-.813h10q.5 0 .781.375t.219.813l-.438 2Q17.938 6 17.125 6h-2.563l-3.875 20h2.125z',
		'w' => .625,
		'vw' => 20
	    ),
	    'text-height' => array(
		'p' => 'M1 2h18q.438 0 .719.281T20 3v6q0 .438-.281.719T19 10h-2.188q-.438 0-.719-.281T15.812 9V6h-3.438v20h2.125q.438 0 .719.281t.281.719v2q0 .438-.281.719t-.719.281h-9q-.438 0-.719-.281T4.499 29v-2q0-.438.281-.719T5.499 26h2.125V6H4.186v3q0 .438-.281.719T3.186 10H.998q-.438 0-.719-.281T-.002 9V3q0-.438.281-.719T.998 2zm29.688.313l5 5q.5.438.25 1.063T35 9.001h-3v14h3q.688 0 .938.625t-.25 1.063l-5 5q-.688.75-1.375 0l-5-5q-.5-.438-.25-1.063t.938-.625h3v-14h-3q-.688 0-.938-.625t.25-1.063l5-5q.688-.75 1.375 0z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'text-width' => array(
		'p' => 'M1 2h26q.438 0 .719.281T28 3v6q0 .438-.281.719T27 10h-2.188q-.438 0-.719-.281T23.812 9V6h-7.438v8h2.125q.438 0 .719.281t.281.719v2q0 .438-.281.719t-.719.281h-9q-.438 0-.719-.281T8.499 17v-2q0-.438.281-.719T9.499 14h2.125V6H4.186v3q0 .438-.281.719T3.186 10H.998q-.438 0-.719-.281T-.002 9V3q0-.438.281-.719T.998 2zm26.688 21.313q.75.688 0 1.375l-5 5q-.438.5-1.063.25T21 29v-3H7v3q0 .688-.625.938t-1.063-.25l-5-5q-.75-.688 0-1.375l5-5q.438-.5 1.063-.25t.625.938v3h14v-3q0-.688.625-.938t1.063.25z',
		'w' => .875,
		'vw' => 28
	    ),
	    'align-left' => array(
		'p' => 'M18 2.75v2.5q0 .438-.281.719T17 6.25H1q-.438 0-.719-.281T0 5.25v-2.5q0-.438.281-.719T1 1.75h16q.438 0 .719.281T18 2.75zm-18 8q0-.438.281-.719T1 9.75h26q.438 0 .719.281t.281.719v2.5q0 .438-.281.719T27 14.25H1q-.438 0-.719-.281T0 13.25v-2.5zm1 19.5q-.438 0-.719-.281T0 29.25v-2.5q0-.438.281-.719T1 25.75h26q.438 0 .719.281t.281.719v2.5q0 .438-.281.719T27 30.25H1zm16-12.5q.438 0 .719.281t.281.719v2.5q0 .438-.281.719T17 22.25H1q-.438 0-.719-.281T0 21.25v-2.5q0-.438.281-.719T1 17.75h16z',
		'w' => .875,
		'vw' => 28
	    ),
	    'align-center' => array(
		'p' => 'M22 2.75v2.5q0 .438-.281.719T21 6.25H7q-.438 0-.719-.281T6 5.25v-2.5q0-.438.281-.719T7 1.75h14q.438 0 .719.281T22 2.75zM1 14.25q-.438 0-.719-.281T0 13.25v-2.5q0-.438.281-.719T1 9.75h26q.438 0 .719.281t.281.719v2.5q0 .438-.281.719T27 14.25H1zm0 16q-.438 0-.719-.281T0 29.25v-2.5q0-.438.281-.719T1 25.75h26q.438 0 .719.281t.281.719v2.5q0 .438-.281.719T27 30.25H1zm20-12.5q.438 0 .719.281t.281.719v2.5q0 .438-.281.719T21 22.25H7q-.438 0-.719-.281T6 21.25v-2.5q0-.438.281-.719T7 17.75h14z',
		'w' => .875,
		'vw' => 28
	    ),
	    'align-right' => array(
		'p' => 'M10 5.25v-2.5q0-.438.281-.719T11 1.75h16q.438 0 .719.281T28 2.75v2.5q0 .438-.281.719T27 6.25H11q-.438 0-.719-.281T10 5.25zm-9 9q-.438 0-.719-.281T0 13.25v-2.5q0-.438.281-.719T1 9.75h26q.438 0 .719.281t.281.719v2.5q0 .438-.281.719T27 14.25H1zm0 16q-.438 0-.719-.281T0 29.25v-2.5q0-.438.281-.719T1 25.75h26q.438 0 .719.281t.281.719v2.5q0 .438-.281.719T27 30.25H1zm10-8q-.438 0-.719-.281T10 21.25v-2.5q0-.438.281-.719T11 17.75h16q.438 0 .719.281t.281.719v2.5q0 .438-.281.719T27 22.25H11z',
		'w' => .875,
		'vw' => 28
	    ),
	    'align-justify' => array(
		'p' => 'M0 5.25v-2.5q0-.438.281-.719T1 1.75h26q.438 0 .719.281T28 2.75v2.5q0 .438-.281.719T27 6.25H1q-.438 0-.719-.281T0 5.25zm1 9q-.438 0-.719-.281T0 13.25v-2.5q0-.438.281-.719T1 9.75h26q.438 0 .719.281t.281.719v2.5q0 .438-.281.719T27 14.25H1zm0 16q-.438 0-.719-.281T0 29.25v-2.5q0-.438.281-.719T1 25.75h26q.438 0 .719.281t.281.719v2.5q0 .438-.281.719T27 30.25H1zm0-8q-.438 0-.719-.281T0 21.25v-2.5q0-.438.281-.719T1 17.75h26q.438 0 .719.281t.281.719v2.5q0 .438-.281.719T27 22.25H1z',
		'w' => .875,
		'vw' => 28
	    ),
	    'list' => array(
		'p' => 'M8 7.25v-2.5q0-.438.281-.719T9 3.75h22q.438 0 .719.281T32 4.75v2.5q0 .438-.281.719T31 8.25H9q-.438 0-.719-.281T8 7.25zm1 11q-.438 0-.719-.281T8 17.25v-2.5q0-.438.281-.719T9 13.75h22q.438 0 .719.281t.281.719v2.5q0 .438-.281.719T31 18.25H9zm0 10q-.438 0-.719-.281T8 27.25v-2.5q0-.438.281-.719T9 23.75h22q.438 0 .719.281t.281.719v2.5q0 .438-.281.719T31 28.25H9zM1 9q-.438 0-.719-.281T0 8V4q0-.438.281-.719T1 3h4q.438 0 .719.281T6 4v4q0 .438-.281.719T5 9H1zm0 10q-.438 0-.719-.281T0 18v-4q0-.438.281-.719T1 13h4q.438 0 .719.281T6 14v4q0 .438-.281.719T5 19H1zm0 10q-.438 0-.719-.281T0 28v-4q0-.438.281-.719T1 23h4q.438 0 .719.281T6 24v4q0 .438-.281.719T5 29H1z'
	    ),
	    'outdent' => array(
		'p' => 'M0 5.25v-2.5q0-.438.281-.719T1 1.75h26q.438 0 .719.281T28 2.75v2.5q0 .438-.281.719T27 6.25H1q-.438 0-.719-.281T0 5.25zm13 9q-.438 0-.719-.281T12 13.25v-2.5q0-.438.281-.719T13 9.75h14q.438 0 .719.281t.281.719v2.5q0 .438-.281.719T27 14.25H13zm-12 16q-.438 0-.719-.281T0 29.25v-2.5q0-.438.281-.719T1 25.75h26q.438 0 .719.281t.281.719v2.5q0 .438-.281.719T27 30.25H1zm12-8q-.438 0-.719-.281T12 21.25v-2.5q0-.438.281-.719T13 17.75h14q.438 0 .719.281t.281.719v2.5q0 .438-.281.719T27 22.25H13zM.313 16.688q-.75-.688 0-1.375l6-6q.438-.5 1.063-.25t.625.938v12q0 .688-.625.938t-1.063-.25z',
		'w' => .875,
		'vw' => 28
	    ),
	    'indent' => array(
		'p' => 'M0 5.25v-2.5q0-.438.281-.719T1 1.75h26q.438 0 .719.281T28 2.75v2.5q0 .438-.281.719T27 6.25H1q-.438 0-.719-.281T0 5.25zm11 9q-.438 0-.719-.281T10 13.25v-2.5q0-.438.281-.719T11 9.75h16q.438 0 .719.281t.281.719v2.5q0 .438-.281.719T27 14.25H11zm-10 16q-.438 0-.719-.281T0 29.25v-2.5q0-.438.281-.719T1 25.75h26q.438 0 .719.281t.281.719v2.5q0 .438-.281.719T27 30.25H1zm10-8q-.438 0-.719-.281T10 21.25v-2.5q0-.438.281-.719T11 17.75h16q.438 0 .719.281t.281.719v2.5q0 .438-.281.719T27 22.25H11zm-3.312-6.937q.75.688 0 1.375l-6 6q-.438.5-1.063.25T0 22V10q0-.688.625-.938t1.063.25z',
		'w' => .875,
		'vw' => 28
	    ),
	    'video' => array(
		'p' => 'M21 4q1.25 0 2.125.875T24 7v18q0 1.25-.875 2.125T21 28H3q-1.25 0-2.125-.875T0 25V7q0-1.25.875-2.125T3 4h18zm11.875 2.375q1-.688 2.063-.156T36.001 8v16q0 1.25-1.094 1.781t-2.031-.156l-6.875-4.688v-9.875z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'image' => array(
		'p' => 'M29 28H3q-1.25 0-2.125-.875T0 25V7q0-1.25.875-2.125T3 4h26q1.25 0 2.125.875T32 7v18q0 1.25-.875 2.125T29 28zM7 7.5q-1.438 0-2.469 1.031T3.5 11t1.031 2.469T7 14.5t2.469-1.031T10.5 11 9.469 8.531 7 7.5zM4 24h24v-7l-5.5-5.5q-.5-.5-1 0L13 20l-3.5-3.5q-.5-.5-1 0L4 21v3z'
	    ),
	    'map-marker' => array(
		'p' => 'M10.75 31.375q-1.5-2.188-3.406-4.938t-2.719-3.875-1.875-2.781-1.406-2.344-.75-1.75-.5-1.844T0 11.999q0-5 3.5-8.5t8.5-3.5 8.5 3.5 3.5 8.5q0 1.063-.094 1.844t-.5 1.844-.75 1.75-1.406 2.344-1.875 2.781-2.719 3.875-3.406 4.938Q12.812 32 12 32t-1.25-.625z',
		'w' => .75,
		'vw' => 24
	    ),
	    'adjust' => array(
		'p' => 'M.5 16q0-6.438 4.531-10.969T16 .5t10.969 4.531T31.5 16t-4.531 10.969T16 31.5 5.031 26.969.5 16zM16 27.5q4.75 0 8.125-3.375T27.5 16t-3.375-8.125T16 4.5v23z'
	    ),
	    'tint' => array(
		'p' => 'M12.813 1.375q1 3.25 2.688 6.219t3.063 4.656 2.406 3.969 1.031 4.656q0 4.625-3.219 7.875T11.001 32 3.22 28.75.001 20.875q0-2.375 1.031-4.625t2.438-4 3.063-4.688 2.656-6.188q.438-1.375 1.844-1.375t1.781 1.375zM11 28q.438 0 .719-.281T12 27t-.281-.719T11 26q-2.063 0-3.531-1.469T6 21q0-.438-.281-.719T5 20t-.719.281T4 21q0 2.875 2.063 4.938t4.938 2.063z',
		'w' => .6875,
		'vw' => 22
	    ),
	    'edit' => array(
		'p' => 'M25.188 5.188l5.625 5.625q.438.438 0 .875L17.125 25.376l-5.75.625q-.375.063-.719-.125t-.531-.531-.125-.719l.625-5.75L24.313 5.188q.438-.438.875 0zM35.313 3.75q.688.75.688 1.75t-.688 1.75l-2.25 2.188q-.438.438-.875 0l-5.625-5.625q-.438-.438 0-.875L28.813.75Q29.501 0 30.501 0t1.75.75zM24 21.625q0-.313.25-.5l2.5-2.5q.313-.375.781-.188t.469.688V29#n# 32H3q-1.25 0-2.125-.875T0 29V7q0-1.25.875-2.125T3 4h17.875q.5 0 .688.469t-.188.781l-2.5 2.5q-.188.25-.5.25H4v20h20v-6.375z',
		'w' => 1.123046875,
		'vw' => 36
	    ),
	    'step-backward' => array(
		'p' => 'M4 29.25V2.75Q4 2 4.75 2h3q.75 0 .75.75v11L20.75 2.437q.938-#r#094-.25T24 4v24q0 1.25-1.156 1.813t-2.094-.25L8.5 18.313v10.938q0 .75-.75.75h-3q-.75 0-.75-.75z',
		'w' => .875,
		'vw' => 28
	    ),
	    'fast-backward' => array(
		'p' => 'M0 27.25V4.75Q0 4 .75 4h2.5Q4 4 4 4.75v9.5l10.75-9.813q.938-#r#094-.25T18 6v8.25l10.75-9.813q.938-#r#094-.25T32 6v20q0 1.25-1.156 1.813t-2.094-.25L18 17.813v8.188q0 1.25-1.156 1.813t-2.094-.25L4 17.814v9.438q0 .75-.75.75H.75q-.75 0-.75-.75z'
	    ),
	    'backward' => array(
		'p' => 'M.75 17.563Q0 16.938 0 16t.75-1.563l12-10q.938-#r#094-.25T16 6v20q0 1.25-1.156 1.813t-2.094-.25zm16 0Q16 16.938 16 16t.75-1.563l12-10q.938-#r#094-.25T32 6v20q0 1.25-1.156 1.813t-2.094-.25z'
	    ),
	    'play' => array(
		'p' => 'M26.5 13.438q1.5.875 1.5 2.563t-1.5 2.563l-22 13q-1.438.875-2.969.031T0 29.001v-26Q0 1.126 1.594.345T4.5.439z',
		'w' => .873046875,
		'vw' => 28
	    ),
	    'pause' => array(
		'p' => 'M9 29.938H3q-1.25 0-2.125-.875T0 26.938v-22q0-1.25.875-2.125T3 1.938h6q1.25 0 2.125.875T12 4.938v22q0 1.25-.875 2.125T9 29.938zm19-3#n# 29.938h-6q-1.25 0-2.125-.875T16 26.938v-22q0-1.25.875-2.125T19 1.938h6q1.25 0 2.125.875T28 4.938v22z',
		'w' => .875,
		'vw' => 28
	    ),
	    'stop' =>'square',
	    'forward' => array(
		'p' => 'M31.25 14.438q.75.625.75 1.563t-.75 1.563l-12 10q-.938.813-2.094.25T16 26.001v-20q0-1.25 1.156-1.813t2.094.25zm-16 0q.75.625.75 1.563t-.75 1.563l-12 10q-.938.813-2.094.25T0 26.001v-20q0-1.25 1.156-1.813t2.094.25z',
		'w' => .998046875
	    ),
	    'fast-forward' => array(
		'p' => 'M32 4.75v22.5q0 .75-.75.75h-2.5q-.75 0-.75-.75v-9.5l-10.75 9.813q-.938.813-2.094.25T14 26v-8.25L3.25 27.563q-.938.813-2.094.25T0 26V6q0-1.25 1.156-1.813t2.094.25L14 14.187V5.999q0-1.25 1.156-1.813t2.094.25L28 14.186V4.748q0-.75.75-.75h2.5q.75 0 .75.75z'
	    ),
	    'step-forward' => array(
		'p' => 'M24 2.75v26.5q0 .75-.75.75h-3q-.75 0-.75-.75v-11L7.25 29.563q-.938.813-2.094.25T4 28V4q0-1.25 1.156-1.813t2.094.25l12.25 11.25V2.749q0-.75.75-.75h3q.75 0 .75.75z',
		'w' => .875,
		'vw' => 28
	    ),
	    'eject' => array(
		'p' => 'M28 24v4q0 .813-.594 1.406T26 30H2q-.813 0-1.406-.594T0 28v-4q0-.813.594-1.406T2 22h24q.813 0 1.406.594T28 24zM3 20q-1.938 0-2.719-1.781T.812 15l11-12Q12.687 2 14 2t2.188 1l11 12q1.313 1.438.531 3.219T25 20H3z',
		'w' => .875,
		'vw' => 28
	    ),
	    'chevron-left' => array(
		'p' => 'M2.188 14.938L14.313 2.813q.438-.438 1.063-.438t1.063.438l1.375 1.375q.438.438.469 1.063t-.406 1.063l-9.688 9.688 9.688 9.688q.438.438.406 1.063t-.469 1.063l-1.375 1.375q-.438.438-1.063.438t-1.063-.438L2.188 17.066q-.5-.438-.5-1.063t.5-1.063z',
		'w' => .625,
		'vw' => 20
	    ),
	    'chevron-right' => array(
		'p' => 'M17.813 17.063L5.688 29.188q-.438.438-1.063.438t-1.063-.438l-1.375-1.375q-.438-.438-.469-1.063t.406-1.063l9.688-9.688-9.688-9.688q-.438-.438-.406-1.063t.469-1.063L3.562 2.81Q4 2.372 4.625 2.372t1.063.438l12.125 12.125q.5.438.5 1.063t-.5 1.063z',
		'w' => .623046875,
		'vw' => 20
	    ),
	    'plus-circle' => array(
		'p' => '#e#9 17.25v-3.5q0-.75-.75-.75H18.5V7.75q0-.75-.75-.75h-3.5q-.75 0-.75.75v5.75H7.75q-.75 0-.75.75v3.5q0 .75.75.75h5.75v5.75q0 .75.75.75h3.5q.75 0 .75-.75V18.5h5.75q.75 0 .75-.75z'
	    ),
	    'minus-circle' => array(
		'p' => '#e#-8.25 18h16.5q.75 0 .75-.75v-3.5q0-.75-.75-.75H7.75q-.75 0-.75.75v3.5q0 .75.75.75z'
	    ),
	    'times-circle' => array(
		'p' => '#e#7.625 19.563L19.5 16l4.125-4.063q.5-.563 0-1.063l-2.5-2.5q-.5-.5-1.063 0l-4.063 4.125-4.063-4.125q-.563-.5-1.063 0l-2.5 2.5q-.5.5 0 1.063L12.498 16l-4.125 4.063q-.5.563 0 1.063l2.5 2.5q.5.5 1.063 0l4.063-4.125 4.063 4.125q.563.5 1.063 0l2.5-2.5q.5-.5 0-1.063z'
	    ),
	    'check-circle' => array(
		'p' => 'M31.5 16q0 6.438-4.531 10.969T16 31.5 5.031 26.969.5 16 5.031 5.031 16 .5t10.969 4.531T31.5 16zm-17.312 8.188l11.5-11.5q.75-.688 0-1.375l-1.375-1.438q-.75-.688-1.438 0L13.5 19.25l-4.375-4.375q-.688-.688-1.438 0l-1.375 1.438q-.75.688 0 1.375l6.5 6.5q.688.75 1.375 0z'
	    ),
	    'question-circle' => array(
		'p' => 'M31.5 16q0 6.438-4.531 10.969T16 31.5 5.031 26.969.5 16 5.031 5.031 16 .5t10.969 4.531T31.5 16zM16.438 5.625q-4.625 0-7.313 4-.375.563.188 1l2.188 1.625q.563.438 1-.125.688-.813 1.094-1.219t1.031-.719 1.438-.313q1.063 0 1.969.594t.906 1.469q0 .688-.469 1.094t-1.531 1.031q-1.125.625-1.656 1t-1.156 1.313-.625 2.125v.25q0 .75.75.75h3.5q.75 0 .75-.75v-.063q0-.563.813-1.125t1.781-1.063 1.781-1.688.813-2.813q0-2.625-2.25-4.5t-5-1.875zM16 21.125q-1.188 0-2.031.844T13.125 24t.844 2.031 2.031.844 2.031-.844.844-2.031-.844-2.031T16 21.125z'
	    ),
	    'info-circle' => array(
		'p' => '#e#0 6.875q-1.063 0-1.844.781T13.375 10t.781 1.844 1.844.781 1.844-.781.781-1.844-.781-1.844T16 7.375zm3.5 15.875v-1.5q0-.75-.75-.75H18v-6.25q0-.75-.75-.75h-4q-.75 0-.75.75v1.5q0 .75.75.75H14v4h-.75q-.75 0-.75.75v1.5q0 .75.75.75h5.5q.75 0 .75-.75z'
	    ),
	    'crosshairs' => array(
		'p' => 'M31.25 14q.75 0 .75.75v2.5q0 .75-.75.75h-1.875q-.438 2.875-2.031 5.313t-4.031 4.031T18 29.375v1.875q0 .75-.75.75h-2.5q-.75 0-.75-.75v-1.875q-4.375-.688-7.531-3.844T2.625 18H.75Q0 18 0 17.25v-2.5Q0 14 .75 14h1.875q.688-4.375 3.844-7.531T14 2.625V.75q0-.75.75-.75h2.5Q18 0 18 .75v1.875q4.375.688 7.531 3.844T29.375 14h1.875zM18 25.313q2.75-.625 4.719-2.594T25.313 18H22.75q-.75 0-.75-.75v-2.5q0-.75.75-.75h2.563q-.625-2.75-2.594-4.719T18 6.687V9.25q0 .75-.75.75h-2.5Q14 10 14 9.25V6.687q-2.75.625-4.719 2.594T6.687 14H9.25q.75 0 .75.75v2.5q0 .75-.75.75H6.687q.625 2.75 2.594 4.719T14 25.313V22.75q0-.75.75-.75h2.5q.75 0 .75.75v2.563zM18 16q0 .813-.594 1.406T16 18t-1.406-.594T14 16t.594-1.406T16 14t1.406.594T18 16z'
	    ),
	    'ban' => array(
		'p' => '#e#8.125 7.375q-3-3-7.25-3.344t-7.5 2.031l16.063 16.063q2.375-3.25 2.031-7.5t-3.344-7.25zm-16.25 16.25q3 3 7.25 3.344t7.5-2.031L6.562 9.375q-2.375 3.25-2.031 7.5t3.344 7.25z'
	    ),
	    'arrow-left' => array(
		'p' => 'M16.125 27.813l-1.438 1.375q-.438.438-1.063.438t-1.063-.438L.436 17.063Q-.002 16.625-.002 16t.438-1.063L12.561 2.812q.438-.438 1.063-.438t1.063.438l1.438 1.375q.438.438.406 1.063t-.469 1.063l-7.5 7.188H26.5q.625 0 1.063.438t.438 1.063v2q#p#8H8.562l7.5 7.188q.438.438.469 1.063t-.406 1.063z',
		'w' => .875,
		'vw' => 28
	    ),
	    'arrow-right' => array(
		'p' => 'M11.875 4.188l1.438-1.375q.438-.438 1.063-.438t1.063.438l12.125 12.125q.438.438.438 1.063t-.438 1.063L15.439 29.189q-.438.438-1.063.438t-1.063-.438l-1.438-1.375q-.438-.438-.406-1.063t.469-1.063l7.5-7.188H1.5q-.625 0-1.063-.438t-.438-1.063v-2q0-.625.438-1.063t1.063-.438h17.938l-7.5-7.188q-.438-.438-.469-1.063t.406-1.063z',
		'w' => .875,
		'vw' => 28
	    ),
	    'arrow-up' => array(
		'p' => 'M2.188 18.125L.813 16.687q-.438-.438-.438-1.063t.438-1.063L12.938 2.436q.438-.438 1.063-.438t1.063.438l12.125 12.125q.438.438.438 1.063t-.438 1.063l-1.375 1.375q-.438.5-1.063.469t-1.063-.469l-7.188-7.5V28.5q#p#8h-2q-.625 0-1.063-.438t-.438-1.063V10.562l-7.188 7.5q-.438.438-1.063.469t-1.063-.406z',
		'w' => .873046875,
		'vw' => 28
	    ),
	    'arrow-down' => array(
		'p' => 'M25.813 13.875l1.375 1.438q.438.438.438 1.063t-.438 1.063L15.063 29.564q-.438.438-1.063.438t-1.063-.438L.812 17.439q-.438-.438-.438-1.063t.438-1.063l1.375-1.438q.438-.438 1.063-.406t1.063.469l7.188 7.5V3.5q0-.625.438-1.063t1.063-.438h2q.625 0 1.063.438t.438 1.063v17.938l7.188-7.5q.438-.438 1.063-.469t1.063.406z',
		'w' => .875,
		'vw' => 28
	    ),
	    'share' => array(
		'p' => 'M31.5 11.875q.5.438.5 1.125t-.5 1.125l-11 9.5q-.75.625-1.625.219T18 22.5V17q-3.063.063-5.188.406t-3.688 1.125-2.281 2.094-.719 3.313.813 4.688q.25.75-.406 1.188t-1.344-.063q-2.188-1.563-3.688-4.219t-1.5-5.406.938-4#r#5-3.344 3.938-2.063 4.875-1.063T18 8.499v-5q0-.938.875-1.344t1.625.219z'
	    ),
	    'expand' => array(
		'p' => 'M0 11.25V3.5q0-.625.438-1.063t1.063-.438h7.75q.75 0 .75.75v2.5q0 .75-.75.75h-5.25v5.25q0 .75-.75.75h-2.5q-.75 0-.75-.75zm18-8.5q0-.75.75-.75h7.75q.625 0 1.063.438t.438 1.063v7.75q0 .75-.75.75h-2.5q-.75 0-.75-.75v-5.25h-5.25q-.75 0-.75-.75v-2.5zM27.25 20q.75 0 .75.75v7.75q#p#8h-7.75q-.75 0-.75-.75v-2.5q0-.75.75-.75h5.25v-5.25q0-.75.75-.75h2.5zM10 29.25q0 .75-.75.75H1.5q-.625 0-1.063-.438t-.438-1.063v-7.75q0-.75.75-.75h2.5q.75 0 .75.75v5.25h5.25q.75 0 .75.75v2.5z',
		'w' => .875,
		'vw' => 28
	    ),
	    'compress' => array(
		'p' => 'M27.25 12H19.5q-.625 0-1.063-.438t-.438-1.063v-7.75q0-.75.75-.75h2.5q.75 0 .75.75v5.25h5.25q.75 0 .75.75v2.5q0 .75-.75.75zM10 10.5q#p#8H.749q-.75 0-.75-.75v-2.5q0-.75.75-.75h5.25v-5.25q0-.75.75-.75h2.5q.75 0 .75.75v7.75zm0 18.75q0 .75-.75.75h-2.5Q6 30 6 29.25V24H.75Q0 24 0 23.25v-2.5Q0 20 .75 20H8.5q.625 0 1.063.438t.438 1.063v7.75zm12 0q0 .75-.75.75h-2.5q-.75 0-.75-.75V21.5q0-.625.438-1.063t1.063-.438h7.75q.75 0 .75.75v2.5q0 .75-.75.75h-5.25v5.25z',
		'w' => .875,
		'vw' => 28
	    ),
	    'plus' => array(
		'p' => 'M26 13q.813 0 1.406.594T28 15v2q0 .813-.594 1.406T26 19h-9v9q0 .813-.594 1.406T15 30h-2q-.813 0-1.406-.594T11 28v-9H2q-.813 0-1.406-.594T0 17v-2q0-.813.594-1.406T2 13h9V4q0-.813.594-1.406T13 2h2q.813 0 1.406.594T17 4v9h9z',
		'w' => .875,
		'vw' => 28
	    ),
	    'minus' => array(
		'p' => 'M26 13q.813 0 1.406.594T28 15v2q0 .813-.594 1.406T26 19H2q-.813 0-1.406-.594T0 17v-2q0-.813.594-1.406T2 13h24z',
		'w' => .875,
		'vw' => 28
	    ),
	    'asterisk' => array(
		'p' => 'M29.875 20.875q.563.313.719.906t-.156 1.156l-1.188 2.125q-.313.563-.938.719t-1.125-.219l-8.688-5.25.188 10.125q.063.688-.375 1.125T17.187 32h-2.375q-.688 0-1.125-.438t-.375-1.125l.188-10.125-8.688 5.25q-.5.375-1.125.219t-.938-.719l-1#q#125q-.313-.563-.156-1.156t.719-.906L10.999 16l-8.875-4.875q-.563-.313-.719-.906t.156-1.156l1#q#125q.313-.563.938-.719t1.125.219l8.688 5.25-.188-10.125q-.063-.438.156-.781t.563-.563.781-.219h2.375q.688 0 1.125.438t.375 1.125l-.188 10.125 8.688-5.25q.5-.375 1.125-.219t.938.719l1.188 2.125q.313.563.156 1.156t-.719.906L21 16z'
	    ),
	    'exclamation-circle' => array(
		'p' => 'M31.5 16q0 6.438-4.531 10.969T16 31.5 5.031 26.969.5 16 5.031 5.031 16 .5t10.969 4.531T31.5 16zM16 19.125q-1.188 0-2.031.844T13.125 22t.844 2.031 2.031.844 2.031-.844.844-2.031-.844-2.031T16 19.125zM13.25 8.813l.5 8.5q0 .688.75.688h3q.75 0 .75-.688l.5-8.5q0-.375-.219-.594T18 8h-4q-.313 0-.531.219t-.219.594z'
	    ),
	    'gift' => array(
		'p' => 'M2 28v-8h12v10H4q-.813 0-1.406-.594T2 28zm16 2V20h12v8q0 .813-.594 1.406T28 30H18zm12-20q.813 0 1.406.594T32 12v5q0 .438-.281.719T31 18H1q-.438 0-.719-.281T0 17v-5q0-.813.594-1.406T2 10h2.75q-.625-1.188-.625-2.5 0-2.25 1.625-3.875T9.625 2q1.875 0 3.313 1t3.125 3.25Q17.751 4 19.188 3t3.313-1q2.25 0 3.875 1.625T28.001 7.5q0 1.25-.625 2.5h2.625zM9.625 10H15q-2.188-3.313-3.219-4.156T9.625 5q-.688 0-1.25.344t-.906.906-.344 1.25q0 1.063.719 1.781T9.625 10zM22.5 10q1.063 0 1.781-.719T25 7.5t-.719-1.781T22.5 5q-.75 0-1.281.219t-1.531 1.344-2.563 3.438H22.5z'
	    ),
	    'leaf' => array(
		'p' => 'M34.125.625Q36 4.75 36 9.625q0 8.188-4.719 13.969T19.25 29.938q-3.5.375-6.344-1.063t-4.531-3.75q-3.313 2.75-4.5 5.625-.313.75-1.094 1.094t-1.531.031-1.094-1.094-.031-1.531q.563-1.313 1.563-2.781t3-3.406 4.531-3.438 6.438-2.563 8.344-1.063q.438 0 .719-.281t.281-.719-.281-.719-.719-.281q-10.563 0-17.875 5.25-.125-.875-.125-1.25 0-5 3.5-8.5t8.5-3.5h5q2.938 0 5.406-1.469T32.376.499q.313-.5.906-.5t.844.625z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'fire' => array(
		'p' => 'M13.5 1.5q0 1.75 1.094 3.313t2.625 2.938 3.063 2.938 2.625 3.969 1.094 5.344q0 4.938-3.531 8.469t-8.469 3.531-8.469-3.531-3.531-8.469q0-4.875 3.438-8.438.688-.75 1.625-.375t.938 1.438v5.313q0 1.688 1.156 2.875t2.781 1.188q1.688 0 2.875-1.156t1#q#844q0-1.063-.594-2.063t-1.406-1.813-1.719-1.688-1.5-1.938-.781-2.375.469-3.219T10.752.688q.625-.938 1.688-.625t1.063 1.438z',
		'w' => .75,
		'vw' => 24
	    ),
	    'eye' => array(
		'p' => 'M35.813 15.063q.188.438.188.938t-.188.938q-2.625 5-7.375 8.031T18 28.001q-3.75 0-7.219-1.406T4.625 22.72.187 16.939q-.188-.438-.188-.938t.188-.938q2.625-5 7.375-8.031T18 4.001t10.438 3.031 7.375 8.031zM18 25q3.75 0 6.375-2.625T27 16t-2.625-6.375T18 7t-6.375 2.625T9 16t2.625 6.375T18 25zm0-15q2.5 0 4.25 1.75T24 15.969t-1.75 4.25T18.031 22t-4.25-1.781T12 16q0-.813.25-1.563Q13 15 14 15q1.25 0 2.125-.875T17 12q0-1-.563-1.75Q17.187 10 18 10z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'eye-slash' => array(
		'p' => 'M20 25q.813 0 1.625-.188l3.25 2.563Q22.312 28 20 28q-5.688 0-10.438-3.031t-7.375-8.031Q1.999 16.5 1.999 16t.188-.938q.875-1.625 2.313-3.438l6.563 5.063q.188 2.313 1.406 4.219t3.219 3T20.001 25zm19.625 3.625q.375.313.375.813 0 .313-.188.625l-1.25 1.563q-.313.375-.813.375-.313 0-.563-.188L.373 3.375q-.375-.313-.375-.813 0-.313.188-.625L1.436.374q.313-.375.813-.375.313 0 .563.188l8 6.188q1.125-.688 2.781-1.219t3.375-.844 3.031-.313q5.688 0 10.438 3.031t7.375 8.031q.188.438.188.938t-.188.938q-.813 1.5-2.313 3.375t-2.813 3zm-11.5-8.875Q29 17.937 29 16q0-3.75-2.625-6.375T20 7q-1.313 0-3 .594t-2.688 1.469l4.563 3.563q.125-.313.125-.625 0-1-.563-1.75.813-.25 1.625-.25 2.438 0 4.188 1.75T26 15.939v.063q0 .938-.313 1.875z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'exclamation-triangle' => array(
		'p' => 'M35.625 27.5q.813 1.5-.031 3T33 32H3q-1.75 0-2.594-1.5t-.031-3l15-26Q16.25 0 18 0t2.625 1.5zM18 22.125q-1.188 0-2.031.844T15.125 25t.844 2.031 2.031.844 2.031-.844.844-2.031-.844-2.031T18 22.125zm-2.75-10.312l.5 8.5q0 .688.75.688h3q.75 0 .75-.688l.5-8.5q0-.375-.219-.594T20 11h-4q-.313 0-.531.219t-.219.594z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'plane' => array(
		'p' => 'M30 12q1.875 0 3.938 1.219T36.001 16t-2.063 2.781T30 20h-7.125l-6.563 11.5q-.313.5-.875.5h-4.125q-.5 0-.781-.406t-.156-.844L13.438 20H7l-2.688 3.625Q3.999 24 3.499 24h-2.5q-.5 0-.781-.375t-.219-.875l2-6.75-2-6.75q-.063-.5.219-.875T.999 8h2.5q.5 0 .813.375L7 12h6.438L10.375 1.25q-.063-.188-.031-.438t.188-.438.344-.281.438-.094h4.125q.563 0 .875.5l6.563 11.5h7.125z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'calendar-alt' => array(
		'p' => 'M0 29V12h28v17#n# 32H3q-1.25 0-2.125-.875T0 29zm20-12.25v2.5q0 .75.75.75h2.5q.75 0 .75-.75v-2.5q0-.75-.75-.75h-2.5q-.75 0-.75.75zm0 8v2.5q0 .75.75.75h2.5q.75 0 .75-.75v-2.5q0-.75-.75-.75h-2.5q-.75 0-.75.75zm-8-8v2.5q0 .75.75.75h2.5q.75 0 .75-.75v-2.5q0-.75-.75-.75h-2.5q-.75 0-.75.75zm0 8v2.5q0 .75.75.75h2.5q.75 0 .75-.75v-2.5q0-.75-.75-.75h-2.5q-.75 0-.75.75zm-8-8v2.5q0 .75.75.75h2.5Q8 20 8 19.25v-2.5Q8 16 7.25 16h-2.5Q4 16 4 16.75zm0 8v2.5q0 .75.75.75h2.5Q8 28 8 27.25v-2.5Q8 24 7.25 24h-2.5Q4 24 4 24.75zM25 4q1.25 0 2.125.875T28 7v3H0V7q0-1.25.875-2.125T3 4h3V1q0-.438.281-.719T7 0h2q.438 0 .719.281T10 1v3h8V1q0-.438.281-.719T19 0h2q.438 0 .719.281T22 1v3h3z',
		'w' => .875,
		'vw' => 28
	    ),
	    'random' => array(
		'p' => 'M31.563 22.438q.438.438.438 1.063t-.438 1.063l-5 5q-.688.688-1.625.313T24 28.502v-2.5h-3.688q-.313 0-.563-.25l-4.375-4.688 3.313-3.625L22 21.002h2v-2.5q0-1 .938-1.375t1.625.313zM.75 11Q0 11 0 10.25v-3.5Q0 6 .75 6h6.938q.313 0 .563.25l4.375 4.688-3.313 3.625L6 11H.75zM24 11h-2L8.25 25.75Q8 26 7.687 26H.749q-.75 0-.75-.75v-3.5q0-.75.75-.75h5.25l13.75-14.75q.25-.25.563-.25H24V3.5q0-1 .938-1.375t1.625.313l5 5q.438.438.438 1.063t-.438 1.063l-5 5q-.688.688-1.625.313T24 13.502v-2.5z'
	    ),
	    'comment' => array(
		'p' => '#g#125 0-.25-.094t-.188-.219q-.125-.313.094-.531t.75-.875 1.406-2.188 1.25-2.906q-3.563-3.563-3.563-8.188 0-5.375 4.688-9.188T15.999 2z'
	    ),
	    'magnet' => array(
		'p' => 'M10.25 10H.75Q0 10 0 9.25v-5q0-.938.656-1.594T2.25 2h6.5q.938 0 1.594.656T11 4.25v5q0 .313-.219.531T10.25 10zM32 9.25q0 .188-.094.375t-.281.281-.375.094h-9.5q-.313 0-.531-.219T21 9.25v-5q0-.938.656-1.594T23.25 2h6.5q.938 0 1.594.656T32 4.25v5zM21.75 12h9.5q.313 0 .531.219t.219.531v3.313q0 4.5-2.438 8.125t-6.063 5.469-7.469 1.844-7.469-1.844-6.094-5.469-2.469-8.125V12.75q0-.313.219-.531T.748 12h9.5q.313 0 .531.219t.219.531V16q0 2.813 1.563 4.438t3.438 1.625 3.438-1.625T21 16v-3.25q0-.313.219-.531T21.75 12z'
	    ),
	    'chevron-up' => array(
		'p' => 'M15.063 8.188l12.125 12.125q.438.438.438 1.063t-.438 1.063l-1.375 1.375q-.438.438-1.063.469t-1.063-.406l-9.688-9.688-9.688 9.688q-.438.438-1.063.406t-1.063-.469L.81 22.439q-.438-.438-.438-1.063t.438-1.063L12.935 8.188q.438-.5 1.063-.5t1.063.5z',
		'w' => .875,
		'vw' => 28
	    ),
	    'chevron-down' => array(
		'p' => 'M12.938 23.813L.813 11.688q-.438-.438-.438-1.063t.438-1.063l1.375-1.375q.438-.438 1.063-.469t1.063.406l9.688 9.688 9.688-9.688q.438-.438 1.063-.406t1.063.469l1.375 1.375q.438.438.438 1.063t-.438 1.063L15.066 23.813q-.438.5-1.063.5t-1.063-.5z',
		'w' => .873046875,
		'vw' => 28
	    ),
	    'retweet' => array(
		'p' => 'M39.375 21.5l-6.313 6.25q-.438.438-1.063.438t-1.063-.438l-6.313-6.25q-.438-.438-.438-1.063t.438-1.063l.688-.688q.438-.438 1.094-.438t1.094.438l2.5 2.688V9.999h-11.75q-.563 0-1.063-.438l-1-1q-.688-.688-.313-1.625t1.375-.938h15.25q.625 0 1.063.438t.438 1.063v13.875l2.5-2.688q.438-.438 1.094-.438t1.094.438l.688.688q.438.438.438 1.063t-.438 1.063zm-16.562.938l1 1q.688.688.313 1.625t-1.375.938H7.501q-.625 0-1.063-.438T6 24.5V10.625l-2.5 2.688q-.438.438-1.094.438t-1.094-.438l-.688-.688q-.438-.438-.438-1.063t.438-1.063l6.313-6.25Q7.375 3.811 8 3.811t1.063.438l6.313 6.25q.438.438.438 1.063t-.438 1.063l-.688.688q-.438.438-1.094.438t-1.094-.438L10 10.625V22h11.75q.563 0 1.063.438z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'shopping-cart' => array(
		'p' => 'M33 18.813q-.25 1.188-1.438 1.188H13.249l.375 2h16.813q.688 0 1.125.563t.313 1.25l-.375 1.563q2 .938 2 3.125 0 1.438-1.031 2.469T30 32.002t-2.469-1.031-1.031-2.469q0-1.5 1.063-2.5H14.438q1.063 1 1.063 2.5 0 1.438-1.031 2.469t-2.469 1.031-2.469-1.031-1.031-2.469q0-2 1.75-3.063L5.876 4.001H1.501q-.625 0-1.063-.438T0 2.5v-1Q0 .875.438.437t1.063-.438h6.438q.5 0 .906.344t.531.844L9.939 4h24.563q.75 0 1.188.563t.25 1.25z',
		'w' => 1.123046875,
		'vw' => 36
	    ),
	    'folder' => array(
		'p' => 'M29 8q1.25 0 2.125.875T32 11v14q0 1.25-.875 2.125T29 28H3q-1.25 0-2.125-.875T0 25V7q0-1.25.875-2.125T3 4h10l4 4h12z'
	    ),
	    'folder-open' => array(
		'p' => 'M35.813 18.25L31.25 26q-.438.813-1.469 1.406T27.812 28h-25q-.875 0-1.313-.75t0-1.5L6.062 18q.438-.813 1.469-1.406T9.5 16h25q.875 0 1.313.75t0 1.5zM9.5 14q-1.063 0-2.063.375t-1.781 1.031T4.312 17l-4.313 7.375V7q0-1.25.875-2.125T2.999 4h10l4 4h10q1.25 0 2.125.875T29.999 11v3h-20.5z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'chart-bar' => array(
		'p' => 'M20.813 20q-.313 0-.563-.25t-.25-.563v-8.375q0-.313.25-.563t.563-.25h2.375q.313 0 .563.25t.25.563v8.375q0 .313-.25.563t-.563.25h-2.375zm6 0q-.313 0-.563-.25t-.25-.563V4.812q0-.313.25-.563t.563-.25h2.375q.313 0 .563.25t.25.563v14.375q0 .313-.25.563t-.563.25h-2.375zm-18 0q-.313 0-.563-.25T8 19.187v-4.375q0-.313.25-.563t.563-.25h2.375q.313 0 .563.25t.25.563v4.375q0 .313-.25.563t-.563.25H8.813zm6 0q-.313 0-.563-.25t-.25-.563V6.812q0-.313.25-.563t.563-.25h2.375q.313 0 .563.25t.25.563v12.375q0 .313-.25.563t-.563.25h-2.375zM31 24q.438 0 .719.281T32 25v2q0 .438-.281.719T31 28H2q-.813 0-1.406-.594T0 26V5q0-.438.281-.719T1 4h2q.438 0 .719.281T4 5v19h27z'
	    ),
	    'camera-retro' => array(
		'p' => 'M3 2h26q1.25 0 2.125.875T32 5v22q0 1.25-.875 2.125T29 30H3q-1.25 0-2.125-.875T0 27V5q0-1.25.875-2.125T3 2zm0 2q-.438 0-.719.281T2 5v.625Q2 6 2.375 6h7.25Q10 6 10 5.625v-1.25Q10 4 9.625 4H3zm26.625 6Q30 10 30 9.625V5q0-.438-.281-.719T29 4H13.187q-.188 0-.313.188l-1.875 2.813H2.374q-.375 0-.375.375v2.25q0 .375.375.375h27.25zM16 26.5q3.125 0 5.313-2.188t2.188-5.313-2.188-5.313T16 11.498t-5.313 2#q#188 5.313 2.188 5.313T16 26.5zm0-13q2.25 0 3.875 1.625T21.5 19t-1.625 3.875T16 24.5t-3.875-1.625T10.5 19t1.625-3.875T16 13.5zM13 20q.438 0 .719-.281T14 19q0-.813.594-1.406T16 17q.438 0 .719-.281T17 16t-.281-.719T16 15q-1.625 0-2.813 1.188t-1.188 2.813q0 .438.281.719t.719.281z'
	    ),
	    'key' => array(
		'p' => 'M32 11q0 4.563-3.219 7.781T21 22q-1.063 0-2.063-.188l-1.5 1.688q-.438.5-1.125.5h-2.313v2.5q#p#8h-2.5v2.5q#p#8h-7q-.625 0-1.063-.438t-.438-1.063v-4.875q0-.625.438-1.063l10.125-10.125Q9.996 12.75 9.996 11q0-3 1.469-5.531t4-4T20.996 0q4.563 0 7.781 3.219T31.996 11zM21 8q0 1.25.875 2.125T24 11t2.125-.875T27 8t-.875-2.125T24 5t-2.125.875T21 8z'
	    ),
	    'cogs' => array(
		'p' => 'M32 11.938l-.5.875q-.313.563-.938.375-1.125-.438-2-1.188-.5-.438-.188-1l.5-.875q-.625-.75-1-1.688h-1q-.688 0-.75-.688-.25-1.125 0-2.313.063-.625.75-.625h1q.375-.938 1-1.688l-.5-.938q-.313-.563.188-.938.875-.75 2-1.188.625-.25.938.313l.5.938q1-.188 2 0l.5-.938q.313-.563.938-.313 1.125.375 2 1.188.5.375.188.938l-.5.938q.625.75 1 1.688h1q.688 0 .75.625.25 1.188 0 2.313-.063.688-.75.688h-1q-.375.938-1 1.688l.5.875q.313.625-.188 1-.875.75-2 1.188-.625.188-.938-.375l-.5-.875q-1 .188-2 0zm-.625-3.688q1.125.875 2.313.5t1.469-1.469-.531-2.344q-1.125-.875-2.313-.5t-1.469 1.469.531 2.344zm-7.25 9.625l2.125 1.063q1.063.625.625 1.813-.563 1.625-2.625 4.125-.813.938-1.875.313L20.5 24.126q-1.5 1.313-3.375 2v2.125q0 .5-.375.938t-.875.5q-2.375.438-4.75 0-.563-.063-.906-.5t-.344-.938v-2.125q-1.938-.688-3.438-2l-1.813 1.063q-1.063.625-1.875-.313-2-2.438-2.625-4.125-.438-1.188.625-1.813l2.063-1.063q-.375-2 0-3.938L.749 12.874q-1.125-.625-.625-1.813.625-1.688 2.625-4.125.75-.938 1.875-.313l1.813 1Q8 6.31 9.875 5.685V3.56q0-.563.344-.969t.906-.469q2.375-.438 4.75 0 .25 0 .469.156t.406.344.281.438.094.5v2.125Q19 6.373 20.5 7.623l1.875-1q1.063-.688 1.875.313 2 2.375 2.625 4.125.438 1.188-.625 1.813l-2.125 1.063q.375 1.938 0 3.938zm-7.312 1.313q1.063-1.375 1#q#875t-.563-2.594-1.781-1.781-2.594-.531-2.875 1.219Q9.125 14.001 9 15.501t.563 2.594 1.781 1.781 2.594.531 2.875-1.219zM32 30.625l-.5.875q-.313.563-.938.375-1.125-.438-2-1.188-.5-.438-.188-1l.5-.875q-.625-.75-1-1.688h-1q-.688 0-.75-.688-.25-1.125 0-2.313.063-.625.75-.625h1q.375-.938 1-1.75l-.5-.875q-.313-.563.188-1 .875-.75 2-1.125.625-.25.938.313l.5.938q1-.188 2 0l.5-.938q.313-.563.938-.313 1.125.375 2 1.125.5.438.188 1l-.5.875q.625.813 1 1.75h1q.688 0 .75.625.25 1.188 0 2.313-.063.688-.75.688h-1q-.375.938-1 1.688l.5.875q.313.563-.188 1-.875.75-2 1.188-.625.188-.938-.375l-.5-.875q-1 .188-2 0zm-.625-3.687q1.125.875 2.313.5t1.469-1.469-.531-2.344q-1.125-.875-2.313-.5t-1.469 1.469.531 2.344z',
		'w' => 1.248046875,
		'vw' => 40
	    ),
	    'gears'=>'cogs',
	    'comments' => array(
		'p' => 'M26 12q0 4.125-3.813 7.063t-9.188 2.938q-3.75 0-6.938-1.563-2.688 1.563-5.563 1.563-.125 0-.25-.094t-.188-.219q-.125-.313.063-.563 1.313-1.25 2.25-3.375Q-.002 15.187-.002 12q0-4.125 3.813-7.063t9#q#938 9.188 2.938T26 12zm7.625 13.75q.938 2.125 2.25 3.375.188.25.063.563t-.438.313q-2.875 0-5.563-1.563-3.188 1.563-6.938 1.563-4 0-7.25-1.688t-4.75-4.438q1.125.125 2 .125 6.188 0 10.594-3.531T27.999 12q0-.688-.063-1.25 3.563 1.125 5.813 3.656T35.999 20q0 3#q#375 5.75z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'star-half' => array(
		'p' => 'M18 0v27.5l-8.188 4.25q-1.063.563-2.063-.156t-.813-1.969l1.563-9.063-6.625-6.438q-.875-.875-.5-2.063t1.625-1.375l9.125-1.313 4.063-8.25Q16.75-.002 18-.002z',
		'w' => .6015625,
		'vw' => 19
	    ),
	    'thumbtack' => array(
		'p' => 'M18.625 13.375q1.563.75 2.75 1.75t1.906 2.406T24 20.5q#p#8h-8.5v6.5q0 .125-.063.25l-1.5 3q-.125.25-.438.25t-.438-.25l-1.5-3q-.063-.125-.063-.25v-6.5h-8.5q-.625 0-1.063-.438T-.004 20.5q0-2.25 1.5-4.125t3.875-3L6.121 6H3.496q-.625 0-1.063-.438t-.438-1.063v-3q0-.625.438-1.063t1.063-.438h17q.625 0 1.063.438t.438 1.063v3q0 .625-.438 1.063T20.496 6h-2.625z',
		'w' => .75,
		'vw' => 24
	    ),
	    'trophy' => array(
		'p' => 'M34.5 4q.625 0 1.063.438t.438 1.063v3.5q0 3.5-3.875 6.313-3 2.125-6.875 2.563-1.938 3.25-4.25 4.625v4.5h3q1.688 0 2.844.938t1.156 2.563v.75q0 .75-.75.75h-18.5q-.75 0-.75-.75v-.75q0-1.625 1.156-2.563t2.844-.938h3v-4.5q-.25-.125-.688-.438t-1.563-1.5-2-2.688q-3.875-.438-6.875-2.563Q0 12.5 0 9V5.5q0-.625.438-1.063t1.063-.438h6.5v-2.5q0-.625.438-1.063t1.063-.438h17q.625 0 1.063.438t.438 1.063v2.5h6.5zM6.188 12.063q1.188#r#625 1.313Q8.125 10.813 8 8.001H4v1q0 1.438 2.188 3.063zM32 9V8h-4q-.125 2.813-.813 5.375 1.438-.5 2.625-1.313Q32 10.437 32 8.999z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'upload' => array(
		'p' => 'M18.5 24h-5q-.625 0-1.063-.438t-.438-1.063v-10.5h-5.5q-.813 0-1.125-.781t.25-1.344l9.5-9.5q.375-.375.875-.375t.875.375l9.5 9.5q.563.563.25 1.344t-1.125.781h-5.5v10.5q0 .625-.438 1.063T18.498 24zm13.5-.5v7q#p#8h-29q-.625 0-1.063-.438T-.002 30.5v-7q0-.625.438-1.063t1.063-.438h8.5v.5q0 1.438 1.031 2.469t2.469 1.031h5q1.438 0 2.469-1.031t1.031-2.469v-.5h8.5q.625 0 1.063.438T32 23.5zM24.25 29q0-.5-.375-.875T23 27.75t-.875.375-.375.875.375.875.875.375.875-.375.375-.875zm4 0q0-.5-.375-.875T27 27.75t-.875.375-.375.875.375.875.875.375.875-.375.375-.875z'
	    ),
	    'lemon' => array(
		'p' => 'M30.563 1.438q1.063 1.063 1.344 2.406t-.281 2.281q-.5.813-.563 2.156t.156 2.75.156 3.25T31 17.937t-1.531 4-3.281 4.25-4.25 3.281-4 1.531-3.656.375-3.25-.156-2.75-.156-2.156.563q-.938.563-2.281.281t-2.406-1.344-1.344-2.406.281-2.281q.5-.813.563-2.156t-.156-2.75-.156-3.25.375-3.656 1.531-4 3.281-4.25 4.25-3.281 4-1.531T17.72.626t3.25.156 2.75.156 2.156-.563q.938-.563 2.281-.281t2.406 1.344zM15.25 6q.375-.125.594-.469t.125-.75-.438-.625T14.75 4q-3.25.875-6.563 4.188t-4.188 6.563q0 .188.031.406t.125.375.25.281.344.188h.25q.75 0 1-.75.625-2.75 3.563-5.688T15.25 6z'
	    ),
	    'phone' => array(
		'p' => 'M30.813 1.563q1.188.25 1.188 1.438 0 12-8.5 20.5t-20.5 8.5q-1.188 0-1.438-1.188l-1.5-6.5q-.313-1.188.875-1.688l7-3q1-.438 1.75.438l3.063 3.75q3.688-1.688 6.531-4.563t4.531-6.5l-3.75-3.125q-.875-.688-.438-1.75l3-7q.5-1.125 1.688-.813z'
	    ),
	    'phone-square' => array(
		'p' => '#a#M5.875 26q7.5 0 12.813-5.313t5.313-12.813q0-.75-.75-.938l-4.063-.938H19q-.625 0-.875.563l-1.875 4.375q-.063.188-.063.375 0 .438.375.75l2.313 1.938Q16.687 18.687 12 20.874l-1.938-2.313q-.313-.375-.75-.375-.188 0-.375.063l-4.375 1.875q-.563.25-.563.875v.188l.938 4.063q.188.75.938.75z',
		'w' => .875,
		'vw' => 28
	    ),
	    'unlock' => array(
		'p' => 'M25 16q1.25 0 2.125.875T28 19v10#n# 32H3q-1.25 0-2.125-.875T0 29V19q0-1.25.875-2.125T3 16h1.5V9.625q0-4 2.781-6.813t6.688-2.813 6.719 2.781 2.813 6.719v1q0 .625-.438 1.063T22 12h-2q-.625 0-1.063-.438t-.438-1.063v-1q0-1.875-1.344-3.188t-3.219-1.313q-1.813 0-3.125 1.344T9.498 9.561v6.438h15.5z',
		'w' => .875,
		'vw' => 28
	    ),
	    'credit-card' => array(
		'p' => 'M0 27V16h36v11q0 1.25-.875 2.125T33 30H3q-1.25 0-2.125-.875T0 27zm12-4.25v2.5q0 .75.75.75h8.5q.75 0 .75-.75v-2.5q0-.75-.75-.75h-8.5q-.75 0-.75.75zm-8 0v2.5q0 .75.75.75h4.5q.75 0 .75-.75v-2.5q0-.75-.75-.75h-4.5Q4 22 4 22.75zM36 5v3H0V5q0-1.25.875-2.125T3 2h30q1.25 0 2.125.875T36 5z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'rss' => array(
		'p' => 'M8 25.969q0 1.656-1.156 2.844t-2.813 1#q#844-1.188-1#q#844 1#q#813T4.031 22t2.813 1.156T8 25.969zm11 2.969q0 .438-.281.75t-.719.313h-3q-.438 0-.719-.281T14 29.064q-.375-5.25-4.094-8.969T.937 16.001q-.375 0-.656-.281T0 15.001v-3q0-.438.313-.719t.75-.281q7.25.438 12.375 5.563t5.563 12.375zm9 0q0 .438-.281.75t-.719.313h-3q-.438 0-.719-.281T23 29.064q-.375-9-6.719-15.344T.937 7.001q-.375 0-.656-.281T0 6.001v-3q0-.438.313-.719t.75-.281q5.375.188 10.281 2.406t8.5 5.781 5.781 8.469T28 28.938z',
		'w' => .875,
		'vw' => 28
	    ),
	    'hdd' => array(
		'p' => 'M36 19v6q0 1.25-.875 2.125T33 28H3q-1.25 0-2.125-.875T0 25v-6q0-1.25.875-2.125T3 16h30q1.25 0 2.125.875T36 19zm-3-5H3q-1 0-1.938.375l6.063-9.063q.25-.313.656-.625t.906-.5.938-.188h16.75q.688 0 1.406.406t1.094.906l6.063 9.063Q34 13.999 33 13.999zm-3 6q-.813 0-1.406.594T28 22t.594 1.406T30 24t1.406-.594T32 22t-.594-1.406T30 20zm-6 0q-.813 0-1.406.594T22 22t.594 1.406T24 24t1.406-.594T26 22t-.594-1.406T24 20z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'bullhorn' => array(
		'p' => 'M36 15q0 2.313-2 3.438v9.563q0 .625-.5 1.313t-1.5.688q-.688 0-1.25-.438l-5.313-4.25q-4.125-3.313-9.438-3.313h-1.75q-.25 1-.25 2 0 2.688 1.625 4.813.688 1 .125 2.094t-1.75 1.094H9.311q-1.25 0-1.75-1.063-1.563-3.313-1.563-6.938 0-1 .125-2H3.998q-1.688 0-2.844-1.156t-1.156-2.844v-6q0-1.688 1.156-2.844t2.844-1.156h12q5.313 0 9.438-3.313l5.313-4.25Q31.312 0 31.999 0q1 0 1.5.688t.5 1.313v9.563q2 1.125 2 3.438zm-6 8.813V6.188l-2.063 1.625q-5.25 4.188-11.938 4.188v6q6.688 0 11.938 4.188z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'certificate' => array(
		'p' => 'M28.688 16l2.875 2.813q.625.625.375 1.469t-1.063 1.031l-3.938 1 1.125 3.875q.25.875-.375 1.5t-1.5.375l-3.875-1.125-1 3.938q-.188.875-1.063 1.094t-1.438-.406l-2.813-2.875-2#r#875q-.563.625-1.438.406t-1.063-1.094l-1-3.938-3.875 1.125q-.875.25-1.5-.375t-.375-1.5l1.125-3.875-3.938-1q-.813-.188-1.063-1.031t.375-1.469L3.308 16 .433 13.187q-.625-.625-.375-1.469t1.063-1.031l3.938-1-1.125-3.875q-.25-.875.375-1.5t1.5-.375l3.875 1.125 1-3.938Q10.872.249 11.747.03t1.438.406l2#r#938L18.811.436q.625-.625 1.469-.375t1.031 1.063l1 3.938 3.875-1.125q.875-.25 1.5.375t.375 1.5l-1.125 3.875 3.938 1q.813.188 1.063 1.031t-.375 1.469z',
		'w' => .998046875
	    ),
	    'hand-point-right' => array(
		'p' => 'M32 12.5q0 1.063-.844 1.875t-1.969.813h-6.25q.813.813.781 2.156t-1.156 2.281q.625 1.125.25 2.281t-1.25 1.656q.25 1.5-.25 2.5t-1.594 1.469-2.719.469h-1q-2.188 0-4.406-1.125t-3.344-1.313q-.5-.063-.875-.469t-.375-.969v-10.75q0-1.938 1.75-2.75 1.938-.813 4.094-2.219t2.656-2.594q.75-1#r#5-1.813 1.625 0 2.5 1.344t.25 2.844q-.313.75-.875 1.563h9.313q1.125 0 1.969.813T32 12.5zm-26 0v12q#p#8h-3q-.625 0-1.063-.438T-.002 24.5v-12q0-.625.438-1.063t1.063-.438h3q.625 0 1.063.438T6 12.5zM4.25 23q0-.5-.375-.875T3 21.75t-.875.375T1.75 23t.375.875.875.375.875-.375T4.25 23z'
	    ),
	    'hand-point-left' => array(
		'p' => 'M2.813 9.75h9.313q-.563-.813-.875-1.563-.625-1.5.25-2.844t2.5-1.344q1.75 0 2.5 1.813.5 1.188 2.656 2.594t4.094 2.219q1.75.813 1.75 2.75v10.75q0 .563-.375.969t-.875.469q-1.125.188-3.344 1.313t-4.406 1.125h-1q-2.5 0-3.719-1.125t-.844-3.313q-.875-.5-1.25-1.656t.25-2.281q-1.125-.938-1.156-2.281t.781-2.156h-6.25q-1.125 0-1.969-.813T0 12.501q0-1.125.844-1.938t1.969-.813zM27.5 11h3q.625 0 1.063.438t.438 1.063v12q#p#8h-3q-.625 0-1.063-.438t-.438-1.063v-12q0-.625.438-1.063T27.5 11zM29 24.25q.5 0 .875-.375T30.25 23t-.375-.875T29 21.75t-.875.375-.375.875.375.875.875.375z'
	    ),
	    'hand-point-up' => array(
		'p' => 'M8.5 0q1.063 0 1.875.844t.813 1.969v6.25q.813-#r#156-.781t2.281 1.156q1.125-.625 2.281-.25t1.656 1.25q2.188-.375 3.313.844T24 15.001v1q0 2.188-1.125 4.406t-1.313 3.344q0 .313-.219.625t-.531.469-.688.156H9.374q-1.938 0-2.75-1.75-.813-1.938-2.219-4.094t-2.594-2.656q-1.813-.75-1.813-2.5 0-1.625 1.344-2.5t2.844-.25q.75.313 1.563.875V2.813q0-1.125.813-1.969T8.5 0zm0 26h12q.625 0 1.063.438t.438 1.063v3q#p#8h-12q-.625 0-1.063-.438t-.438-1.063v-3q0-.625.438-1.063T8.5 26zM19 27.75q-.5 0-.875.375T17.75 29t.375.875.875.375.875-.375.375-.875-.375-.875T19 27.75z',
		'w' => .75,
		'vw' => 24
	    ),
	    'hand-point-down' => array(
		'p' => 'M5.75 29.188v-9.313q-.813.563-1.563.875-1.5.625-2.844-.25T-.001 18q0-1.75 1.813-2.5Q3 15 4.406 12.844T6.625 8.75Q7.438 7 9.375 7h10.75q.563 0 .969.375t.469.875q.188 1.125 1.313 3.344T24.001 16v1q0 2.5-1.125 3.719t-3.313.844q-.5.875-1.656 1.25t-2.281-.25q-.938 1.125-2.281 1.156t-2.156-.781v6.25q0 1.125-.813 1.969t-1.875.844q-1.125 0-1.938-.844t-.813-1.969zM7 4.5v-3q0-.625.438-1.063t1.063-.438h12q.625 0 1.063.438t.438 1.063v3q#p#8h-12q-.625 0-1.063-.438T7 4.5zM20.25 3q0-.5-.375-.875T19 1.75t-.875.375T17.75 3t.375.875.875.375.875-.375T20.25 3z',
		'w' => .75,
		'vw' => 24
	    ),
	    'arrow-circle-left' => array(
		'p' => 'M16 31.5q-6.438 0-10.969-4.531T.5 16 5.031 5.031 16 .5t10.969 4.531T31.5 16t-4.531 10.969T16 31.5zm1.813-9l-4.75-4.5h11.438q.625 0 1.063-.438t.438-1.063v-1q0-.625-.438-1.063t-1.063-.438H13.063l4.75-4.5q.438-.438.438-1.094t-.438-1.094l-.688-.688q-.438-.438-1.063-.438t-1.063.438l-8.25 8.313q-.438.438-.438 1.063t.438 1.063l8.25 8.313q.438.438 1.063.438t1.063-.438l.688-.688q.438-.438.438-1.094t-.438-1.094z'
	    ),
	    'arrow-circle-right' => array(
		'p' => '#e#-1.812 9l4.75 4.5H7.5q-.625 0-1.063.438t-.438 1.063v1q0 .625.438 1.063t1.063.438h11.438l-4.75 4.5q-.438.438-.438 1.094t.438 1.094l.688.688q.438.438 1.063.438t1.063-.438l8.25-8.313q.438-.438.438-1.063t-.438-1.063l-8.25-8.313q-.438-.438-1.063-.438t-1.063.438l-.688.688q-.438.438-.438 1.094t.438 1.094z'
	    ),
	    'arrow-circle-up' => array(
		'p' => 'M.5 16q0-6.438 4.531-10.969T16 .5t10.969 4.531T31.5 16t-4.531 10.969T16 31.5 5.031 26.969.5 16zm9 1.813l4.5-4.75v11.438q0 .625.438 1.063t1.063.438h1q.625 0 1.063-.438t.438-1.063V13.063l4.5 4.75q.438.438 1.094.438t1.094-.438l.688-.688q.438-.438.438-1.063t-.438-1.063l-8.313-8.25q-.438-.438-1.063-.438t-1.063.438l-8.313 8.25q-.438.438-.438 1.063t.438 1.063l.688.688q.438.438 1.094.438t1.094-.438z'
	    ),
	    'arrow-circle-down' => array(
		'p' => 'M31.5 16q0 6.438-4.531 10.969T16 31.5 5.031 26.969.5 16 5.031 5.031 16 .5t10.969 4.531T31.5 16zm-9-1.812l-4.5 4.75V7.5q0-.625-.438-1.063t-1.063-.438h-1q-.625 0-1.063.438T13.998 7.5v11.438l-4.5-4.75q-.438-.438-1.094-.438t-1.094.438l-.688.688q-.438.438-.438 1.063t.438 1.063l8.313 8.25q.438.438 1.063.438t1.063-.438l8.313-8.25q.438-.438.438-1.063t-.438-1.063l-.688-.688q-.438-.438-1.094-.438t-1.094.438z'
	    ),
	    'globe' => array(
		'p' => 'M21 10H10q.688-4.25 2.188-6.875T15.501.5t3.313 2.625T21.002 10zM9.5 16q0-2 .188-4h11.625q.188 2 .188 4t-.188 4H9.688Q9.5 18 9.5 16zm20.313-6h-6.75q-.938-5.75-3.125-8.875 3.313 1 5.906 3.344T29.813 10zm-18.75-8.875Q8.813 4.25 7.938 10h-6.75q1.375-3.188 3.969-5.531t5.906-3.344zM30.438 12q.563 2 .563 4t-.563 4h-7.125q#q#063.188-4t-.188-4h7.125zM7.5 16q0 1.875.188 4H.563Q0 17.937 0 16t.563-4h7.125Q7.5 14.063 7.5 16zm2.5 6h11q-.688 4.25-2.188 6.875T15.499 31.5t-3.313-2.625T9.998 22zm9.938 8.875q2.25-3.125 3.125-8.875h6.75q-1.375 3.188-3.969 5.531t-5.906 3.344zM1.188 22h6.75q.938 5.75 3.125 8.875-3.313-1-5.906-3.344T1.188 22z',
		'w' => .966796875,
		'vw' => 31
	    ),
	    'wrench' => array(
		'p' => 'M31.75 6.813q.563 2.25-.063 4.531t-2.313 4.031q-1.875 1.813-4.375 2.375t-4.875-.25L6.811 30.813q-1.188 1#q#844 1.188t-2.813-1.156-1.156-2.813 1#q#844l13.313-13.375q-.813-2.313-.25-4.844t2.375-4.344q1.688-1.688 4-2.313t4.563-.063q.438.125.531.531t-.219.719l-4.625 4.688.688 4.25 4.25.688L30.5 6.5q.313-.313.719-.219t.531.531zM4 29.5q.625 0 1.063-.438t.438-1.063-.438-1.063T4 26.498t-1.063.438-.438 1.063.438 1.063T4 29.5z'
	    ),
	    'tasks' => array(
		'p' => 'M13 8.25q-.438 0-.719-.281T12 7.25v-2.5q0-.438.281-.719T13 3.75h18q.438 0 .719.281T32 4.75v2.5q0 .438-.281.719T31 8.25H13zm0 10q-.438 0-.719-.281T12 17.25v-2.5q0-.438.281-.719T13 13.75h18q.438 0 .719.281t.281.719v2.5q0 .438-.281.719T31 18.25H13zm0 10q-.438 0-.719-.281T12 27.25v-2.5q0-.438.281-.719T13 23.75h18q.438 0 .719.281t.281.719v2.5q0 .438-.281.719T31 28.25H13zM4 23q1.25 0 2.125.875T7 26t-.875 2.125T4 29t-2.156-.875T.938 26t.906-2.125T4 23zM9.75 4.313l-4.5 4.5-.938 1q-.563.563-1.125 0l-2.938-3q-.563-.5 0-1.063l.938-.938q.563-.563 1.063 0l1.438 1.375 4-3.938q.5-.563 1.063 0l1.063 1q.5.563-.063 1.063zm0 10l-5.438 5.438q-.563.563-1.125 0L.249 16.813q-.563-.563 0-1.063l.938-1q.563-.5 1.063 0l1.438 1.375 4-3.938q.5-.563 1.063 0l1.063 1.063q.5.5-.063 1.063z'
	    ),
	    'filter' => array(
		'p' => 'M30.5 0q1 0 1.375.938t-.313 1.625L19.999 14.126v16.375q0 .938-.813 1.344t-1.563-.094l-5-3.5q-.625-.5-.625-1.25V14.126L.435 2.563Q-.253 1.875.122.938T1.497 0h29z'
	    ),
	    'briefcase' => array(
		'p' => 'M20 21v-3h12v9q0 1.188-.906 2.094T29 30H3q-1.188 0-2.094-.906T0 27v-9h12v3q0 .438.281.719T13 22h6q.438 0 .719-.281T20 21zm9-13q1.188 0 2.094.906T32 11v5H0v-5q0-1.188.906-2.094T3 8h5V5q0-1.188.906-2.094T11 2h10q1.188 0 2.094.906T24 5v3h5zm-9 0V6h-8v2h8z'
	    ),
	    'arrows-alt' => array(
		'p' => 'M22 26.625l-4.938 4.938q-.438.438-1.063.438t-1.063-.438l-4.938-4.938q-.688-.75-.313-1.656t1.375-.906h3.188V17.75H7.935v3.188q0 1-.906 1.375T5.373 22L.435 17.062q-.438-.438-.438-1.063t.438-1.063l4.938-4.938q.75-.75 1.656-.344t.906 1.406v3.188h6.313V7.935H11.06q-1 0-1.406-.906t.344-1.656L14.936.435q.438-.438 1.063-.438t1.063.438L22 5.373q.688.75.313 1.656t-1.375.906H17.75v6.313h6.313V11.06q0-1 .906-1.375t1.656.313l4.938 4.938q.438.438.438 1.063t-.438 1.063L26.625 22q-.75.75-1.656.344t-.906-1.406V17.75H17.75v6.313h3.188q1 0 1.406.906T22 26.625z',
		'w' => .998046875
	    ),
	    'users' => array(
		'p' => 'M6 14q-1.625 0-2.813-1.188T1.999 9.999t1#q#813T6 5.998t2.813 1.188 1.188 2.813-1.188 2.813T6 14zm28 0q-1.625 0-2.813-1.188t-1#q#813 1#q#813T34 5.998t2.813 1.188 1.188 2.813-1.188 2.813T34 14zm2 2q1.625 0 2.813 1.188t1.188 2.813v2q0 .813-.594 1.406t-1.406.594h-4.125q-.188-1.438-.813-2.75t-1.625-2.344-2.25-1.719Q30.376 16 32.001 16h4zm-16 0q-2.875 0-4.938-2.063t-2.063-4.938 2.063-4.938T20 1.998t4.938 2.063 2.063 4.938-2.063 4.938T20 16zm4.813 2q3 0 5.094 2.094t2.094 5.094v1.813q0 1.25-.875 2.125t-2.125.875h-18q-1.25 0-2.125-.875t-.875-2.125v-1.813q0-3 2.094-5.094T15.189 18h.563q2.063 1 4.25 1t4.25-1h.563zm-14-.812q-1.875 1-3.125 2.813t-1.563 4H2q-.813 0-1.406-.594T0 22.001v-2q0-1.625 1#q#813T4.001 16h4q1.625 0 2.813 1.188z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'link' => array(
		'p' => 'M20.438 11.563q2.75 2#r#75 6.75t-2.75 6.688l-4.25 4.25q-2.75 2.75-6.688 2.75T2.781 29.22 0 22.501t2.75-6.688l2.375-2.375q.438-.438 1.031-.188t.656.875q.063 1.688.625 3.313.188.563-.25 1l-.813.875q-1.313 1.313-1.344 3.156t1.281 3.156Q7.624 27 9.499 27t3.188-1.313l4.188-4.188q1.313-1.313 1.313-3.188t-1.313-3.188q-.313-.313-.625-.563-.438-.25-.438-.75-.063-1.125.688-1.875l1.375-1.313q.563-.625 1.25-.125t1.313 1.063zm8.781-8.782Q32 5.562 32 9.5t-2.75 6.688l-2.375 2.375q-.438.438-1.031.188t-.656-.875q-.063-1.688-.625-3.313-.188-.563.25-1l.813-.875q1.313-1.313 1.344-3.156t-1.281-3.156q-1.313-1.375-3.188-1.375t-3.188 1.313l-4.188 4.188q-1.313 1.313-1.313 3.188t1.313 3.188q.313.313.625.563.438.25.438.75.063 1.125-.688 1.875l-1.375 1.313q-.563.625-1.25.125t-1.313-1.063q-2.75-2.813-2.75-6.75t2.75-6.688l4.25-4.25Q18.562.003 22.5.003t6.719 2.781z'
	    ),
	    'cloud' => array(
		'p' => 'M33.625 14.188q1.813.313 3.25 1.438t2.281 2.813.844 3.563q0 3.313-2.344 5.656T32 30.002H9q-3.75 0-6.375-2.625T0 21.002q0-2.938 1.688-5.25t4.313-3.25v-.5q0-4.125 2.938-7.063t7.063-2.938q2.75 0 5.063 1.375t3.625 3.625q1.5-1 3.313-1 2.5 0 4.25 1.75t1.75 4.25q0 1.125-.375 2.188z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'flask' => array(
		'p' => 'M27.313 25.25q1.375 2.188.125 4.469T23.563 32H4.438q-2.625 0-3.875-2.281t.125-4.469l7.313-11.813V3.999h-.5q-.625 0-1.063-.438T6 2.498v-1q0-.625.438-1.063t1.063-.438h13q.625 0 1.063.438t.438 1.063v1q#p#8h-.5v9.438zM8.625 20h10.75l-3-4.875Q16 14.625 16 14V4h-4v10q0 .625-.375 1.125z',
		'w' => .875,
		'vw' => 28
	    ),
	    'cut' => array(
		'p' => 'M17.375 16L27.75 26.375q.563.563 0 1.063-1.5 1.563-3.688 1.563t-3.688-1.563l-7.25-7.188-1.563 1.563q.438 1.063.438 2.188 0 2.5-1.75 4.25t-4.25 1.75-4.25-1.75-1.75-4.25 1.75-4.25 4.25-1.75q.438 0 .813.063l2.063-2.063-2.063-2.063q-.375.063-.813.063-2.5 0-4.25-1.75t-1.75-4.25 1.75-4.25 4.25-1.75 4.25 1.75 1.75 4.25q0 1.125-.438 2.188l1.563 1.563 7.25-7.188q1.5-1.563 3.688-1.563t3.688 1.563q.563.5 0 1.063zM6 10q.813 0 1.406-.594T8 8t-.594-1.406T6 6t-1.406.594T4 8t.594 1.406T6 10zm0 16q.813 0 1.406-.594T8 24t-.594-1.406T6 22t-1.406.594T4 24t.594 1.406T6 26z',
		'w' => .873046875,
		'vw' => 28
	    ),
	    'copy' => array(
		'p' => 'M20 28v2.5q#p#8h-17q-.625 0-1.063-.438T-.002 30.5v-23q0-.625.438-1.063t1.063-.438h4.5v18.5q0 1.438 1.031 2.469t2.469 1.031h10.5zm0-21.5q0 .625.438 1.063t1.063.438h6.5v16.5q#p#8h-17q-.625 0-1.063-.438t-.438-1.063v-23q0-.625.438-1.063T9.5 0H20v6.5zm7.563-1.937q.438.438.438 1.063v.375h-6v-6h.375q.625 0 1.063.438z',
		'w' => .875,
		'vw' => 28
	    ),
	    'paperclip' => array(
		'p' => 'M2.688 29.125Q0 26.312.032 22.344t2.781-6.781L15.876 2.125Q18.001 0 20.939 0t5 2.125 2.063 5.094-2.063 5.031L14.501 23.938q-1.375 1.438-3.375 1.406t-3.375-1.469Q6.438 22.5 6.47 20.531t1.406-3.344l8.938-9.188q.75-.688 1.438 0l1.438 1.375q.688.75 0 1.438l-9 9.188q-.563.563 0 1.125.5.5.938 0L23.066 9.5q.938-1 .938-2.313t-.938-2.25q-.875-.938-2.125-.938t-2.188.938L5.628 18.312Q4.003 20 4.003 22.343t1.594 4 3.844 1.656 3.813-1.625l10.75-11q.75-.75 1.438 0l1.438 1.375q.688.688 0 1.438l-10.75 11Q13.317 32 9.38 32t-6.688-2.875z',
		'w' => .875,
		'vw' => 28
	    ),
	    'save' => array(
		'p' => 'M27.125 8.125Q28 9 28 10.25V27#n# 30H3q-1.25 0-2.125-.875T0 27V5q0-1.25.875-2.125T3 2h16.75q1.25 0 2.125.875zM14 26q1.688 0 2.844-1.156T18 22t-1.156-2.844T14 18t-2.844 1.156T10 22t1.156 2.844T14 26zm6-19.062q0-.25-.25-.5l-.188-.188q-.25-.25-.5-.25H4.749q-.75 0-.75.75v6.5q0 .75.75.75h14.5q.75 0 .75-.75V6.937z',
		'w' => .875,
		'vw' => 28
	    ),
	    'square' => array(
		'p' => '#a#',
		'w' => .875,
		'vw' => 28
	    ),
	    'bars' => array(
		'p' => 'M1 8.25q-.438 0-.719-.281T0 7.25v-2.5q0-.438.281-.719T1 3.75h26q.438 0 .719.281T28 4.75v2.5q0 .438-.281.719T27 8.25H1zm0 10q-.438 0-.719-.281T0 17.25v-2.5q0-.438.281-.719T1 13.75h26q.438 0 .719.281t.281.719v2.5q0 .438-.281.719T27 18.25H1zm0 10q-.438 0-.719-.281T0 27.25v-2.5q0-.438.281-.719T1 23.75h26q.438 0 .719.281t.281.719v2.5q0 .438-.281.719T27 28.25H1z',
		'w' => .875,
		'vw' => 28
	    ),
	    'list-ul' => array(
		'p' => 'M6 6q0 1.25-.875 2.125T3 9 .875 8.125 0 6t.875-2.125T3 3t2.125.875T6 6zm-3 7q1.25 0 2.125.875T6 16t-.875 2.125T3 19t-2.125-.875T0 16t.875-2.125T3 13zm0 10q1.25 0 2.125.875T6 26t-.875 2.125T3 29t-2.125-.875T0 26t.875-2.125T3 23zM9 8.25q-.438 0-.719-.281T8 7.25v-2.5q0-.438.281-.719T9 3.75h22q.438 0 .719.281T32 4.75v2.5q0 .438-.281.719T31 8.25H9zm0 10q-.438 0-.719-.281T8 17.25v-2.5q0-.438.281-.719T9 13.75h22q.438 0 .719.281t.281.719v2.5q0 .438-.281.719T31 18.25H9zm0 10q-.438 0-.719-.281T8 27.25v-2.5q0-.438.281-.719T9 23.75h22q.438 0 .719.281t.281.719v2.5q0 .438-.281.719T31 28.25H9z'
	    ),
	    'list-ol' => array(
		'p' => 'M.188 8.75q0-.75.75-.75h.938V5.5l.063-.625h-.063l-.188.188Q1.25 5.563.75 5l-.375-.375q-.5-.5.063-1l1.313-1.25Q2.189 2 2.689 2h.75q.75 0 .75.75V8h.938q.75 0 .75.75v.5q0 .75-.75.75H.939q-.75 0-.75-.75v-.5zM.125 19.063q0-1.313.813-2.219t1.594-1.375.781-.781q0-.5-.563-.5-.313 0-.625.25-.5.5-1 .125l-.5-.438q-.563-.438-.188-.938.875-1.188 2.5-1.188 1.125 0 1.969.625t.844 1.875q0 1-.75 1.75t-1.5 1.156-.813.594h2.438q.75 0 .75.75v.563q0 .688-.75.688H.875q-.75 0-.75-.688v-.25zm.25 9.375l.313-.625q.375-.563 1-.188.438.188.875.188.938 0 .938-.5 0-.563-1-.563h-.313q-.5 0-.75-.5l-.063-.125q-.25-.438.125-.938l.375-.438.75-.813v-.063q-.25.125-.75.125h-.813q-.75 0-.75-.75v-.563q0-.688.75-.688h3.625q.75 0 .75.688v.25q0 .5-.375.875l-1.063 1.25q.875.25 1.344.844t.469 1.344q0 1.125-.781 1.938t-2.281.813q-1.25 0-2.25-.563-.5-.438-.125-1zM9 8.25q-.438 0-.719-.281T8 7.25v-2.5q0-.438.281-.719T9 3.75h22q.438 0 .719.281T32 4.75v2.5q0 .438-.281.719T31 8.25H9zm0 10q-.438 0-.719-.281T8 17.25v-2.5q0-.438.281-.719T9 13.75h22q.438 0 .719.281t.281.719v2.5q0 .438-.281.719T31 18.25H9zm0 10q-.438 0-.719-.281T8 27.25v-2.5q0-.438.281-.719T9 23.75h22q.438 0 .719.281t.281.719v2.5q0 .438-.281.719T31 28.25H9z',
		'w' => 1.00390625
	    ),
	    'strikethrough' => array(
		'p' => 'M31 18H1q-.438 0-.719-.281T0 17v-2q0-.438.281-.719T1 14h30q.438 0 .719.281T32 15v2q0 .438-.281.719T31 18zm-13.437 1h7.688q.625 1.375.625 3.188 0 1.313-.344 2.5t-1.031 2.125-1.594 1.656-2.031 1.156-2.438.688-2.688.25q-3.875 0-6.75-1.688t-2.875-4.688v-1.188q0-.438.281-.719t.719-.281h2.813q.313 0 .531.125t.344.375.125.5v.125q0 1.375 1.5 2.063t3.313.688q2.188 0 3.469-.906t1.281-2.469q0-2.125-2.938-3.5zm-1.938-6H7.562q-.813-1.5-.813-3.563 0-3#r#625-5.813t6.813-2q1.313 0 2.594.188t2.438.625 2 1 1.344 1.375.5 1.813V8.5q0 .438-.281.719t-.719.281h-2.875q-.375 0-.688-.281t-.313-.719v-.125q0-.813-1.063-1.438t-2.938-.625q-1.75 0-2.906.719T12.124 9.25q0 1.375.906 2.188t2.594 1.563z'
	    ),
	    'underline' => array(
		'p' => 'M14 24.25q-4.438 0-7.094-2.438t-2.656-7V3.999H2.437q-.375 0-.688-.281t-.313-.719v-2q0-.438.313-.719t.688-.281h8.625q.375 0 .688.281t.313.719v2q0 .438-.313.719t-.688.281H9.249v10.813q0 4.938 4.75 4.938 1.5 0 2.563-.531t1.625-1.656.563-2.813V4H17q-.438 0-.719-.281T16 3V1q0-.438.281-.719T17 0h8.563q.375 0 .688.281t.313.719v2q0 .438-.313.719T25.563 4H23.75v10.813q0 3-1.25 5.188t-3.438 3.219-5.063 1.031zM1 28h26q.438 0 .719.281T28 29v2q0 .438-.281.719T27 32H1q-.438 0-.719-.281T0 31v-2q0-.438.281-.719T1 28z',
		'w' => .875,
		'vw' => 28
	    ),
	    'table' => array(
		'p' => '#l#M14 26v-6H4v6h10zm0-10v-6H4v6h10zm14 10v-6H18v6h10zm0-10v-6H18v6h10z'
	    ),
	    'magic' => array(
		'p' => 'M14 6l-1-2-2-1 2-1 1-2 1 2 2 1-2 1zm-9 4L3.312 6.687-.001 4.999l3.313-1.688L5-.002l1.688 3.313 3.313 1.688-3.313 1.688zm22 8l1.688 3.313 3.313 1.688-3.313 1.688L27 28.002l-1.688-3.313-3.313-1.688 3.313-1.688zm4.438-12.125q.563.625.563 1.438t-.563 1.375l-22.75 22.75q-.563.563-1.375.563t-1.438-.563L.562 26.125q-.563-.625-.563-1.438t.563-1.375L23.312.562q.563-.563 1.375-.563t1.438.563zm-9 6.813l5.438-5.375-3.188-3.188-5.375 5.438z'
	    ),
	    'truck' => array(
		'p' => 'M39 22q.438 0 .719.281T40 23v2q0 .438-.281.719T39 26h-3q0 2.5-1.75 4.25T30 32t-4.25-1.75T24 26h-8q0 2.5-1.75 4.25T10 32t-4.25-1.75T4 26H3q-1.25 0-2.125-.875T0 23V3Q0 1.75.875.875T3 0h20q1.25 0 2.125.875T26 3v3h2.75q1.25 0 2.125.875l6.25 6.25Q38 14 38 15.25V22h1zm-29 7q1.25 0 2.125-.875T13 26t-.875-2.125T10 23t-2.125.875T7 26t.875 2.125T10 29zm20 0q1.25 0 2.125-.875T33 26t-.875-2.125T30 23t-2.125.875T27 26t.875 2.125T30 29zm5-13v-.75L28.75 9H26v7h9z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'money-bill' => array(
		'p' => 'M38 4q.813 0 1.406.594T40 6v20q0 .813-.594 1.406T38 28H2q-.813 0-1.406-.594T0 26V6q0-.813.594-1.406T2 4h36zM3 25h4q0-1.688-1.156-2.844T3 21v4zm0-14q1.688 0 2.844-1.156T7 7H3v4zm17 11q2.063 0 3.531-1.75T25 16t-1.469-4.25T20 10t-3.531 1.75T15 16t1.469 4.25T20 22zm17 3v-4q-1.688 0-2.844 1.156T33 25h4zm0-14V7h-4q0 1.688 1.156 2.844T37 11z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'caret-down' => array(
		'p' => 'M1.938 12h16.125q.813 0 1.125.781t-.25 1.344l-8.063 8.063q-.375.375-.875.375t-.875-.375l-8.063-8.063q-.563-.563-.25-1.344T1.937 12z',
		'w' => .623046875,
		'vw' => 20
	    ),
	    'caret-up' => array(
		'p' => 'M18.063 22H1.938q-.813 0-1.125-.781t.25-1.344l8.063-8.063q.375-.375.875-.375t.875.375l8.063 8.063q.563.563.25 1.344T18.064 22z',
		'w' => .625,
		'vw' => 20
	    ),
	    'caret-left' => array(
		'p' => 'M12 7.938v16.125q0 .813-.781 1.125t-1.344-.25l-8.063-8.063Q1.437 16.5 1.437 16t.375-.875l8.063-8.063q.563-.563 1.344-.25T12 7.937z',
		'w' => .419921875,
		'vw' => 13
	    ),
	    'caret-right' => array(
		'p' => 'M0 24.063V7.938q0-.813.781-1.125t1.344.25l8.063 8.063q.375.375.375.875t-.375.875l-8.063 8.063q-.563.563-1.344.25T0 24.064z',
		'w' => .328125,
		'vw' => 11
	    ),
	    'columns' => array(
		'p' => '#l#M14 26V10H4v16h10zm14 0V10H18v16h10z'
	    ),
	    'sort' => array(
		'p' => 'M2.563 18h14.875q1 0 1.375.938t-.313 1.625l-7.438 7.438q-.438.438-1.063.438t-1.063-.438l-7.438-7.438q-.688-.688-.313-1.625T2.56 18zM18.5 11.438q.688.688.313 1.625t-1.375.938H2.563q-1 0-1.375-.938t.313-1.625L8.939 4q.438-.438 1.063-.438T11.065 4z',
		'w' => .625,
		'vw' => 20
	    ),
	    'sort-down' => array(
		'p' => 'M2.563 18h14.875q1 0 1.375.938t-.313 1.625l-7.438 7.438q-.438.438-1.063.438t-1.063-.438l-7.438-7.438q-.688-.688-.313-1.625T2.56 18z',
		'w' => .625,
		'vw' => 20
	    ),
	    'sort-up' => array(
		'p' => 'M17.438 14H2.563q-1 0-1.375-.938t.313-1.625l7.438-7.438q.438-.438 1.063-.438t1.063.438l7.438 7.438q.688.688.313 1.625T17.441 14z',
		'w' => .623046875,
		'vw' => 20
	    ),
	    'envelope' => array(
		'p' => 'M31.375 11.938q.188-.188.406-.063t.219.375V25q0 1.25-.875 2.125T29 28H3q-1.25 0-2.125-.875T0 25V12.25q0-.25.219-.344t.406.031Q2.688 13.5 10.25 19q.125.125.844.688t1.156.844 1.125.688 1.344.594 1.281.188q.563 0 1.125-.156t1.063-.375 1.063-.594.938-.656l.875-.656.688-.563q7.375-5.313 9.625-7.063zM16 20q-.5 0-1.219-.344t-1.156-.625-1.281-.938-.906-.656Q3.813 11.874.563 9.374 0 8.936 0 8.186V6.998q0-1.25.875-2.125T3 3.998h26q1.25 0 2.125.875T32 6.998v1.188q0 .75-.563 1.188-3.063 2.375-10.875 8.063-.063 0-.906.656t-1.281.938-1.156.625T16 20z'
	    ),
	    'undo' => array(
		'p' => 'M13.25 14H.75q-.313 0-.531-.219T0 13.25V.75Q0 0 .75 0h3q.75 0 .75.75v4.875q2#q#438 5.219-3.781T16.125.5q6.438.063 10.938 4.594t4.469 10.938-4.563 10.938T16 31.501q-5.938 0-10.375-4-.625-.563-.063-1.125l2.125-2.125q.5-.5 1.063 0 3.125 2.75 7.25 2.75 4.563 0 7.781-3.219T27 16.001 23.781 8.22 16 5.001q-2.688 0-5 1.219T7.125 9.501h6.125q.313 0 .531.219t.219.531v3q0 .313-.219.531t-.531.219z',
		'w' => .984375
	    ),
	    'gavel' => array(
		'p' => 'M31.563 12.438q.438.438.438 1.063t-.438 1.063l-7.75 7.813q-.5.438-1.094.438t-1.031-.438l-1.438-1.438q-.438-.438-.438-1.063t.438-1.063l.375-.313-2.5-2.5-5.063 5.063.375.375q.563.563.563 1.406t-.563 1.406l-7.188 7.188q-.563.563-1.406.563t-1.406-.563L.562 28.563Q-.001 28-.001 27.157t.563-1.406l7.188-7.188Q8.313 18 9.156 18t1.406.563l.375.375L16 13.875l-2.5-2.5-.313.375q-.438.438-1.063.438t-1.063-.438l-1.438-1.438q-.438-.438-.438-1.031t.438-1.094l7.813-7.75q.438-.438 1.063-.438t1.063.438l1.375 1.438q.438.438.438 1.063t-.438 1.063l-.313.313 7.063 7.063.313-.313q.438-.438 1.063-.438t1.063.438z'
	    ),
	    'bolt' => array(
		'p' => 'M18.5 10q.875 0 1.313.75t0 1.5l-11 19Q8.375 32 7.5 32q-.75 0-1.188-.563t-.25-1.313l2.875-12.125H1.499q-.438 0-.813-.25t-.563-.625-.125-.813l2-15q.063-.375.281-.688T2.81.154t.688-.156h9q.75 0 1.188.594t.25 1.281l-2.625 8.125h7.188z',
		'w' => .625,
		'vw' => 20
	    ),
	    'sitemap' => array(
		'p' => 'M8 22q.813 0 1.406.594T10 24v6q0 .813-.594 1.406T8 32H2q-.813 0-1.406-.594T0 30v-6q0-.813.594-1.406T2 22h6zm-1.5-5v3h-3v-3.625q0-.938.719-1.656T5.875 14H18.5v-4H16q-.813 0-1.406-.594T14 8V2q0-.813.594-1.406T16 0h8q.813 0 1.406.594T26 2v6q0 .813-.594 1.406T24 10h-2.5v4h12.625q.938 0 1.656.719t.719 1.656V20h-3v-3h-12v3h-3v-3h-12zM23 22q.813 0 1.406.594T25 24v6q0 .813-.594 1.406T23 32h-6q-.813 0-1.406-.594T15 30v-6q0-.813.594-1.406T17 22h6zm15 0q.813 0 1.406.594T40 24v6q0 .813-.594 1.406T38 32h-6q-.813 0-1.406-.594T30 30v-6q0-.813.594-1.406T32 22h6z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'umbrella' => array(
		'p' => 'M36 17.563q.063.5-.313.813t-.875-.125q-1.625-1.75-3.281-2.156t-3.375.688-3.281 3.781q-.25.438-.625.438t-.563-.438l-.125-.219-.25-.469-.375-.625-.5-.719-.594-.719-.781-.688-.906-.563-1.031-.406L18 16q-1.938 0-3.188 1.219t-2.5 3.344q-.188.438-.563.438t-.625-.438q-1.563-2.688-3.281-3.813t-3.344-.688-3.313 2.188q-.5.438-.875.125t-.313-.813q1.313-6.188 5.781-10t10.219-4.438V1.999q0-.813.594-1.406t1.406-.594 1.406.594.594 1.406v1.125q5.75.625 10.219 4.438t5.781 10zm-20 1.312Q16.938 18 18 18q1 0 2 .875V27q0 2.063-1.469 3.531T15 32q-1.563 0-2.875-.906t-1.813-2.406q-.313-.813.063-1.563t1.156-1.031 1.5.094 1.031 1.125q.25.688.938.688.438 0 .719-.281t.281-.719v-8.125z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'paste' => array(
		'p' => 'M8 11.5V26H1.5q-.625 0-1.063-.438t-.438-1.063v-21q0-.625.438-1.063T1.5 1.998h5.063q1.125-2 3.438-2t3.438 2h5.063q.625 0 1.063.438t.438 1.063v4.5h-8.5q-1.438 0-2.469 1.031t-1.031 2.469zm2-9q-.625 0-1.063.438t-.438 1.063.438 1.063T10 5.502t1.063-.438.438-1.063-.438-1.063T10 2.5zM21.5 18H28v12.5q#p#8h-15q-.625 0-1.063-.438T9.998 30.5v-19q0-.625.438-1.063t1.063-.438h8.5v6.5q0 .625.438 1.063T21.5 18zm6.5-2.375V16h-6v-6h.375q.625 0 1.063.438l4.125 4.125q.438.438.438 1.063z',
		'w' => .875,
		'vw' => 28
	    ),
	    'lightbulb' => array(
		'p' => 'M6 28.375V26h10v2.375q0 .625-.313 1.125l-1.063 1.625q-.625.875-1.688.875H9.061q-1.063 0-1.625-.875L6.311 29.5q-.313-.5-.313-1.125zM0 11q0-4.438 3.125-7.719T10.938 0q4.625 0 7.844 3.219T22.001 11q0 4.125-2.75 7.25-2.313 2.688-3.25 5.688v.063h-10v-.063q-.938-3-3.25-5.688Q.001 15.125.001 11zm11-5q.438 0 .719-.281T12 5t-.281-.719T11 4Q8.125 4 6.062 6.063t-2.063 4.938q0 .438.281.719t.719.281.719-.281.281-.719q0-2.063 1.469-3.531t3.531-1.469z',
		'w' => .6875,
		'vw' => 22
	    ),
	    'user-md' => array(
		'p' => '#k#M6.5 26.5q0-.625.438-1.063t1.063-.438 1.063.438.438 1.063-.438 1.063-1.063.438-1.063-.438T6.5 26.5zM20 18.063q3.375.125 5.688 2.563t2.313 5.75v2.813q0 1.188-.813 2t-2 .813H2.813q-1.188 0-2-.813t-.813-2v-2.813q0-3.063 2-5.406t5-2.844v5.063q-1.063.313-1.781 1.219T4.5 26.502q0 1.438 1.031 2.469T8 30.002t2.469-1.031 1.031-2.469q0-1.188-.688-2.094t-1.813-1.219v-5.125q.75.125 1.438.313 1.75.625 3.563.625t3.625-.625q.063 0 .188-.031t.188-.094v2.875q-1.75.313-2.875 1.688t-1.125 3.188v2.75q0 .875.875 1l1.938.25q.5.063.563-.375l.25-1q.063-.5-.438-.625l-1.188-.188v-1.688q0-2 1.5-2.781t3 0 1.5 2.656v1.75l-1.188.25q-.5.125-.438.625l.25 1q.063.438.563.375l2-.438q.813-.125.813-.938v-2.625q0-1.813-1.125-3.188t-2.875-1.688v-3.063z',
		'w' => .875,
		'vw' => 28
	    ),
	    'stethoscope' => array(
		'p' => 'M27.938 7q1.125 0 2.063.531t1.469 1.438.531 2.031q0 2.313-2 3.438v7.063q0 4.313-3.219 7.406t-7.781 3.094q-4.438 0-7.656-2.969t-3.344-7.219q-3.438-.688-5.719-3.469T.001 12V2.312q0-.563.344-.969t.844-.531l3.938-.75q.625-.125 1.125.219t.625.906l.188 1q.125.625-.219 1.125t-.906.625l-1.938.375V12q0 2.5 1.781 4.25T10.064 18q2.438 0 4.188-1.813t1.75-4.25V4.312l-1.938-.375q-.625-.125-.969-.625t-.219-1.125l.25-1q.063-.375.313-.688t.625-.438.813-.063l3.938.813q.5.125.844.531t.344.969v9.688q0 3.563-2.281 6.313t-5.719 3.5q.125 1.688 1.063 3.125t2.531 2.25 3.406.813q2.875 0 4.938-1.906t2.063-4.594v-7.063q-2.063-1.125-2-3.5.063-1.625 1#q#781T27.942 7zM28 12q.438 0 .719-.281T29 11t-.281-.719T28 10t-.719.281T27 11t.281.719T28 12z'
	    ),
	    'suitcase' => array(
		'p' => 'M8 30V5q0-1.25.875-2.125T11 2h10q1.25 0 2.125.875T24 5v25H8zm4-24v2h8V6h-8zm20 5v16q0 1.25-.875 2.125T29 30h-3V8h3q1.25 0 2.125.875T32 11zM6 30H3q-1.25 0-2.125-.875T0 27V11q0-1.25.875-2.125T3 8h3v22z'
	    ),
	    'bell' => array(
		'p' => 'M14 32q-1.625 0-2.813-1.156T9.999 28h8q0 1.688-1.188 2.844T13.998 32zm13.438-9.375q.563.625.563 1.375 0 .813-.563 1.406T26 26H2q-.563 0-1.031-.281t-.719-.75T0 24q0-.75.563-1.375.063-.063.188-.25.938-.938 1.469-1.688t1.156-2.844.625-4.844q0-3.625 2.25-6.313t5.75-3.375V1.998q0-.813.594-1.406t1.406-.594 1.406.594.594 1.406v1.313q2.313.438 4.125 1.813t2.844 3.438T24.001 13q0 2.75.625 4.844t1.156 2.844 1.469 1.688q.125.188.188.25z',
		'w' => .875,
		'vw' => 28
	    ),
	    'coffee' => array(
		'p' => 'M12 24q-2.5 0-4.25-1.75T6 18V3.5q0-.625.438-1.063t1.063-.438h24.5q3.313 0 5.656 2.344t2.344 5.656-2.344 5.656-5.656 2.344h-2q0 2.5-1.75 4.25t-4.25 1.75h-12zM32 6h-2v8h2q1.625 0 2.813-1.188t1#q#813-1#q#813T32 5.998zm3 24H3Q.937 30 .187 28q-.563-1.5.25-1.938.125-.063.313-.063h36.5q.938 0 .688 1.438-.313 1.813-1.938 2.375-.5.188-1 .188z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'hospital' => array(
		'p' => 'M28 30.75V32H0v-1.25Q0 30 .75 30H2V7.5q0-.625.438-1.063t1.063-.438h5.5v-4.5q0-.625.438-1.063t1.063-.438h7q.625 0 1.063.438t.438 1.063v4.5h5.5q.625 0 1.063.438t.438 1.063V30h1.25q.75 0 .75.75zM19.25 12h-2.5q-.75 0-.75.75v2.5q0 .75.75.75h2.5q.75 0 .75-.75v-2.5q0-.75-.75-.75zm-10.5 4h2.5q.75 0 .75-.75v-2.5q0-.75-.75-.75h-2.5Q8 12 8 12.75v2.5q0 .75.75.75zm6.5 8h-2.5q-.75 0-.75.75V30h4v-5.25q0-.75-.75-.75zm4-6h-2.5q-.75 0-.75.75v2.5q0 .75.75.75h2.5q.75 0 .75-.75v-2.5q0-.75-.75-.75zm-7.25.75q0-.75-.75-.75h-2.5Q8 18 8 18.75v2.5q0 .75.75.75h2.5q.75 0 .75-.75v-2.5zM11.375 6H13v1.625Q13 8 13.375 8h1.25Q15 8 15 7.625V6h1.625Q17 6 17 5.625v-1.25Q17 4 16.625 4H15V2.375Q15 2 14.625 2h-1.25Q13 2 13 2.375V4h-1.625Q11 4 11 4.375v1.25Q11 6 11.375 6z',
		'w' => .875,
		'vw' => 28
	    ),
	    'ambulance' => array(
		'p' => 'M39 22q.438 0 .719.281T40 23v2q0 .438-.281.719T39 26h-3q0 2.5-1.75 4.25T30 32t-4.25-1.75T24 26h-8q0 2.5-1.75 4.25T10 32t-4.25-1.75T4 26H3q-1.25 0-2.125-.875T0 23V3Q0 1.75.875.875T3 0h20q1.25 0 2.125.875T26 3v3h2.75q1.25 0 2.125.875l6.25 6.25Q38 14 38 15.25V22h1zm-29 7q1.25 0 2.125-.875T13 26t-.875-2.125T10 23t-2.125.875T7 26t.875 2.125T10 29zm9-15.5v-3q0-.5-.5-.5H15V6.5q0-.5-.5-.5h-3q-.5 0-.5.5V10H7.5q-.5 0-.5.5v3q0 .5.5.5H11v3.5q0 .5.5.5h3q.5 0 .5-.5V14h3.5q.5 0 .5-.5zM30 29q1.25 0 2.125-.875T33 26t-.875-2.125T30 23t-2.125.875T27 26t.875 2.125T30 29zm5-13v-.75L28.75 9H26v7h9z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'medkit' => array(
		'p' => 'M6 30V8h2V5q0-1.25.875-2.125T11 2h10q1.25 0 2.125.875T24 5v3h2v22H6zm6-24v2h8V6h-8zm20 5v16q0 1.25-.875 2.125T29 30h-1V8h1q1.25 0 2.125.875T32 11zM4 30H3q-1.25 0-2.125-.875T0 27V11q0-1.25.875-2.125T3 8h1v22zm18-13q0-.438-.281-.719T21 16h-3v-3q0-.438-.281-.719T17 12h-2q-.438 0-.719.281T14 13v3h-3q-.438 0-.719.281T10 17v2q0 .438.281.719T11 20h3v3q0 .438.281.719T15 24h2q.438 0 .719-.281T18 23v-3h3q.438 0 .719-.281T22 19v-2z'
	    ),
	    'fighter-jet' => array(
		'p' => 'M34 14q6 1.313 6 2t-6 2l-8 1-3 1h-1.5l-7.313 9.25h2.5q1.313 0 1.313.375T16.687 30H9.499v-.75h1V19h-3l-4.188 5H1.186l-.688-.688v-4.313h.5v-1h3v-.188l-4-.5v-2.625l4-.5v-.188h-3v-1h-.5V8.685l.688-.688h2.125l4.188 5h3V2.747h-1v-.75h7.188q1.313 0 1.313.375t-1.313.375h-2.5l7.313 9.25H23l3 1z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'beer' => array(
		'p' => 'M23 6q2.063 0 3.531 1.469T28 11v8.063q0 1.5-#r#719t-2.125 1.844l-5.063 2.25v2.625q#p#8h-17q-.625 0-1.063-.438t-.438-1.063v-25q0-.625.438-1.063T1.498 2h17q.625 0 1.063.438t.438 1.063v2.5h3zm1 13.063V11q0-.438-.281-.719T23 10h-3v11.5l3.438-1.563q.563-.25.563-.875zM13 24q.438 0 .719-.281T14 23V9q0-.438-.281-.719T13 8t-.719.281T12 9v14q0 .438.281.719T13 24zm-6 0q.438 0 .719-.281T8 23V9q0-.438-.281-.719T7 8t-.719.281T6 9v14q0 .438.281.719T7 24z',
		'w' => .875,
		'vw' => 28
	    ),
	    'h-square' => array(
		'p' => '#b#m-7 3h-2q-.438 0-.719.281T18 9v5h-8V9q0-.438-.281-.719T9 8H7q-.438 0-.719.281T6 9v14q0 .438.281.719T7 24h2q.438 0 .719-.281T10 23v-5h8v5q0 .438.281.719T19 24h2q.438 0 .719-.281T22 23V9q0-.438-.281-.719T21 8z',
		'w' => .875,
		'vw' => 28
	    ),
	    'plus-square' => array(
		'p' => '#a#m-2 15.75v-3.5q0-.75-.75-.75H16.5V7.75q0-.75-.75-.75h-3.5q-.75 0-.75.75v5.75H5.75q-.75 0-.75.75v3.5q0 .75.75.75h5.75v5.75q0 .75.75.75h3.5q.75 0 .75-.75V18.5h5.75q.75 0 .75-.75z',
		'w' => .875,
		'vw' => 28
	    ),
	    'angle-double-left' => array(
		'p' => 'M14 14.938l8.5-8.5Q22.938 6 23.563 6t1.063.438l1.375 1.438q.438.438.438 1.063t-.438 1.063l-6 6 6 6q.313.313.406.688t0 .781-.406.656l-1.375 1.438q-.438.438-1.063.438t-1.063-.438l-8.5-8.5q-.438-.438-.438-1.063T14 14.939zM2 17.063q-.438-.438-.438-1.063T2 14.937l8.5-8.5q.438-.438 1.063-.438t1.063.438l1.375 1.438q.438.438.438 1.063t-.438 1.063l-6 6 6 6q.438.438.438 1.063t-.438 1.063l-1.375 1.438q-.438.438-1.063.438t-1.063-.438z',
		'w' => .875,
		'vw' => 28
	    ),
	    'angle-double-right' => array(
		'p' => 'M14 17.063l-8.5 8.5q-.438.438-1.063.438t-1.063-.438l-1.375-1.438q-.438-.438-.438-1.063t.438-1.063l6-6-6-6q-.438-.438-.438-1.063t.438-1.063l1.375-1.438q.438-.438 1.063-.438t1.063.438l8.5 8.5q.438.438.438 1.063T14 17.061zm12-2.125q.438.438.438 1.063T26 17.064l-8.5 8.5q-.438.438-1.063.438t-1.063-.438l-1.375-1.438q-.438-.438-.438-1.063T13.999 22l6-6-6-6q-.438-.438-.438-1.063t.438-1.063l1.375-1.438q.25-.188.531-.313t.563-.125.563.125.469.313z',
		'w' => .875,
		'vw' => 28
	    ),
	    'angle-double-up' => array(
		'p' => 'M11.063 16l8.5 8.5q.438.438.438 1.063t-.438 1.063l-1.438 1.375q-.438.438-1.063.438t-1.063-.438l-6-6-6 6q-.438.438-1.063.438t-1.063-.438L.435 26.626q-.438-.438-.438-1.063T.435 24.5l8.5-8.5q.438-.438 1.063-.438t1.063.438zM8.938 4q.438-.438 1.063-.438T11.064 4l8.5 8.5q.438.438.438 1.063t-.438 1.063l-1.438 1.375q-.438.438-1.063.438T16 16.001l-6-6-6 6q-.25.25-.531.344t-.563.094-.563-.094-.469-.344L.436 14.626q-.438-.438-.438-1.063T.436 12.5z',
		'w' => .625,
		'vw' => 20
	    ),
	    'angle-double-down' => array(
		'p' => 'M8.938 16l-8.5-8.5Q0 7.062 0 6.437t.438-1.063l1.438-1.375q.438-.438 1.063-.438t1.063.438l6 6 6-6q.438-.438 1.063-.438t1.063.438l1.438 1.375q.438.438.438 1.063T19.566 7.5l-8.5 8.5q-.438.438-1.063.438T8.94 16zm2.125 12q-.438.438-1.063.438T8.937 28l-8.5-8.5q-.438-.438-.438-1.063t.438-1.063l1.438-1.375q.438-.438 1.063-.438t1.063.438l6 6 6-6q.438-.438 1.063-.438t1.063.438l1.438 1.375q.438.438.438 1.063t-.438 1.063z',
		'w' => .625,
		'vw' => 20
	    ),
	    'angle-left' => array(
		'p' => 'M2 14.938l8.5-8.5Q10.938 6 11.563 6t1.063.438l1.375 1.438q.438.438.438 1.063t-.438 1.063l-6 6 6 6q.313.313.406.688t0 .781-.406.656l-1.375 1.438q-.438.438-1.063.438t-1.063-.438l-8.5-8.5q-.438-.438-.438-1.063T2 14.939z',
		'w' => .5,
		'vw' => 16
	    ),
	    'angle-right' => array(
		'p' => 'M14 17.063l-8.5 8.5q-.438.438-1.063.438t-1.063-.438l-1.375-1.438q-.438-.438-.438-1.063t.438-1.063l6-6-6-6q-.438-.438-.438-1.063t.438-1.063l1.375-1.438q.438-.438 1.063-.438t1.063.438l8.5 8.5q.438.438.438 1.063T14 17.061z',
		'w' => .5,
		'vw' => 16
	    ),
	    'angle-up' => array(
		'p' => 'M11.063 10l8.5 8.5q.438.438.438 1.063t-.438 1.063l-1.438 1.375q-.438.438-1.063.438t-1.063-.438l-6-6-6 6q-.438.438-1.063.438t-1.063-.438L.435 20.626q-.438-.438-.438-1.063T.435 18.5l8.5-8.5q.438-.438 1.063-.438t1.063.438z',
		'w' => .625,
		'vw' => 20
	    ),
	    'angle-down' => array(
		'p' => 'M8.938 22l-8.5-8.5Q0 13.062 0 12.437t.438-1.063l1.438-1.375q.438-.438 1.063-.438t1.063.438l6 6 6-6q.438-.438 1.063-.438t1.063.438l1.438 1.375q.438.438.438 1.063t-.438 1.063l-8.5 8.5q-.438.438-1.063.438T8.94 22z',
		'w' => .623046875,
		'vw' => 20
	    ),
	    'desktop' => array(
		'p' => 'M33 0q1.25 0 2.125.875T36 3v20q0 1.25-.875 2.125T33 26H21l1 3h4.5q.625 0 1.063.438t.438 1.063-.438 1.063-1.063.438h-17q-.625 0-1.063-.438t-.438-1.063.438-1.063T9.5 29H14l1-3H3q-1.25 0-2.125-.875T0 23V3Q0 1.75.875.875T3 0h30zm-1 22V4H4v18h28z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'laptop' => array(
		'p' => 'M39 26q.438 0 .719.281T40 27v1q0 1.625-1.188 2.813t-2.813 1.188h-32q-1.625 0-2.813-1.188T-.002 28v-1q0-.438.281-.719T.998 26h14.938q0 .688.625 1.344t1.438.656h3.813q.875 0 1.438-.531T23.875 26H39zM36 3v21H4V3q0-1.25.875-2.125T7 0h26q1.25 0 2.125.875T36 3zm-4 17V4H8v16h24z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'tablet' => array(
		'p' => 'M25 0q1.25 0 2.125.875T28 3v26#n# 32H3q-1.25 0-2.125-.875T0 29V3Q0 1.75.875.875T3 0h22zM14 30q.813 0 1.406-.594T16 28t-.594-1.406T14 26t-1.406.594T12 28t.594 1.406T14 30z',
		'w' => .875,
		'vw' => 28
	    ),
	    'mobile' => array(
		'p' => 'M17 0q1.25 0 2.125.875T20 3v26q0 1.25-.875 2.125T17 32H3q-1.25 0-2.125-.875T0 29V3Q0 1.75.875.875T3 0h14zm-7 30q.813 0 1.406-.594T12 28t-.594-1.406T10 26t-1.406.594T8 28t.594 1.406T10 30z',
		'w' => .625,
		'vw' => 20
	    ),
	    'quote-left' => array(
		'p' => 'M29 16q1.25 0 2.125.875T32 19v8q0 1.25-.875 2.125T29 30h-8q-1.25 0-2.125-.875T18 27V12q0-4.125 2.938-7.063t7.063-2.938h.5q.625 0 1.063.438t.438 1.063v3q#p#8h-.5q-1.625 0-2.813 1.188T24 12.002v4h5zm-18 0q1.25 0 2.125.875T14 19v8q0 1.25-.875 2.125T11 30H3q-1.25 0-2.125-.875T0 27V12q0-4.125 2.938-7.063t7.063-2.938h.5q.625 0 1.063.438t.438 1.063v3q#p#8h-.5q-1.625 0-2.813 1.188T6 12.002v4h5z'
	    ),
	    'quote-right' => array(
		'p' => 'M29 2q1.25 0 2.125.875T32 5v15q0 4.125-2.938 7.063t-7.063 2.938h-.5q-.625 0-1.063-.438t-.438-1.063v-3q0-.625.438-1.063t1.063-.438h.5q1.625 0 2.813-1.188T26 19.998v-4h-5q-1.25 0-2.125-.875T18 12.998v-8q0-1.25.875-2.125T21 1.998h8zM11 2q1.25 0 2.125.875T14 5v15q0 4.125-2.938 7.063t-7.063 2.938h-.5q-.625 0-1.063-.438T1.998 28.5v-3q0-.625.438-1.063t1.063-.438h.5q1.625 0 2.813-1.188T8 19.998v-4H3q-1.25 0-2.125-.875T0 12.998v-8q0-1.25.875-2.125T3 1.998h8z'
	    ),
	    'spinner' => array(
		'p' => 'M19 3q0 1.25-.875 2.125T16 6t-2.125-.875T13 3t.875-2.125T16 0t2.125.875T19 3zm-3 23q1.25 0 2.125.875T19 29t-.875 2.125T16 32t-2.125-.875T13 29t.875-2.125T16 26zm13-13q1.25 0 2.125.875T32 16t-.875 2.125T29 19t-2.125-.875T26 16t.875-2.125T29 13zM6 16q0 1.25-.875 2.125T3 19t-2.125-.875T0 16t.875-2.125T3 13t2.125.875T6 16zm.813 6.188q1.25 0 2.125.875t.875 2.125-.875 2.125-2.125.875-2.125-.875-.875-2.125.875-2.125 2.125-.875zm18.375 0q1.25 0 2.125.875t.875 2.125-.875 2.125-2.125.875-2.125-.875-.875-2.125.875-2.125 2.125-.875zM6.813 3.813q1.25 0 2.125.875t.875 2.125-.875 2.125-2.125.875-2.125-.875-.875-2.125.875-2.125 2.125-.875z'
	    ),
	    'circle' => array(
		'p' => 'M16 .5q6.438 0 10.969 4.531T31.5 16t-4.531 10.969T16 31.5 5.031 26.969.5 16 5.031 5.031 16 .5z'
	    ),
	    'smile' => array(
		'p' => '#d#5 10.5q-.813 0-1.406.594T18.5 13t.594 1.406T20.5 15t1.406-.594T22.5 13t-.594-1.406T20.5 11zm-10 0q-.813 0-1.406.594T8.5 13t.594 1.406T10.5 15t1.406-.594T12.5 13t-.594-1.406T10.5 11zm12.188 10.625q.25-.25.25-.594t-.188-.563-.469-.375-.594-.094-.563.375q-2.188 2.625-5.625 2.625t-5.625-2.625q-.25-.313-.563-.375t-.594.094-.469.375-.188.563.25.594Q11.123 25 15.498 25t7.188-3.375z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'frown' => array(
		'p' => '#d#5 10.5q-.813 0-1.406.594T18.5 13t.594 1.406T20.5 15t1.406-.594T22.5 13t-.594-1.406T20.5 11zm-10 0q-.813 0-1.406.594T8.5 13t.594 1.406T10.5 15t1.406-.594T12.5 13t-.594-1.406T10.5 11zm10.625 13.625q.438.5 1 .375t.719-.625-.156-1Q19.875 20 15.5 20t-7.188 3.375q-.375.438-.156.969t.75.625.969-.344Q12.063 22 15.5 22t5.625 2.625z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'meh' => array(
		'p' => '#d#-5 10.5q-.813 0-1.406.594T8.5 13t.594 1.406T10.5 15t1.406-.594T12.5 13t-.594-1.406T10.5 11zm11 12q1 0 1-1t-1-1h-12q-1 0-1 1t1 1h12zm-1-8q.813 0 1.406-.594T22.5 13t-.594-1.406T20.5 11t-1.406.594T18.5 13t.594 1.406T20.5 15z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'gamepad' => array(
		'p' => 'M30 6q4.125 0 7.063 2.938t2.938 7.063-2.938 7.063T30 26.002q-4.188 0-7.125-3h-5.75q-2.938 3-7.125 3-4.125 0-7.063-2.938t-2.938-7.063 2.938-7.063T10 6h20zM16 17.25v-2.5q0-.75-.75-.75H12v-3.25q0-.75-.75-.75h-2.5Q8 10 8 10.75V14H4.75Q4 14 4 14.75v2.5q0 .75.75.75H8v3.25q0 .75.75.75h2.5q.75 0 .75-.75V18h3.25q.75 0 .75-.75zm11.5 4.25q1.25 0 2.125-.875T30.5 18.5t-.875-2.125T27.5 15.5t-2.125.875T24.5 18.5t.875 2.125 2.125.875zm5-5q1.25 0 2.125-.875T35.5 13.5t-.875-2.125T32.5 10.5t-2.125.875T29.5 13.5t.875 2.125 2.125.875z',
		'w' => 1.248046875,
		'vw' => 40
	    ),
	    'keyboard' => array(
		'p' => 'M33 28H3q-1.25 0-2.125-.875T0 25V7q0-1.25.875-2.125T3 4h30q1.25 0 2.125.875T36 7v18q0 1.25-.875 2.125T33 28zM8 11.25v-2.5Q8 8 7.25 8h-2.5Q4 8 4 8.75v2.5q0 .75.75.75h2.5Q8 12 8 11.25zm6 0v-2.5Q14 8 13.25 8h-2.5Q10 8 10 8.75v2.5q0 .75.75.75h2.5q.75 0 .75-.75zm6 0v-2.5Q20 8 19.25 8h-2.5Q16 8 16 8.75v2.5q0 .75.75.75h2.5q.75 0 .75-.75zm6 0v-2.5Q26 8 25.25 8h-2.5Q22 8 22 8.75v2.5q0 .75.75.75h2.5q.75 0 .75-.75zm6 0v-2.5Q32 8 31.25 8h-2.5Q28 8 28 8.75v2.5q0 .75.75.75h2.5q.75 0 .75-.75zm-21 6v-2.5q0-.75-.75-.75h-2.5Q7 14 7 14.75v2.5q0 .75.75.75h2.5q.75 0 .75-.75zm6 0v-2.5q0-.75-.75-.75h-2.5q-.75 0-.75.75v2.5q0 .75.75.75h2.5q.75 0 .75-.75zm6 0v-2.5q0-.75-.75-.75h-2.5q-.75 0-.75.75v2.5q0 .75.75.75h2.5q.75 0 .75-.75zm6 0v-2.5q0-.75-.75-.75h-2.5q-.75 0-.75.75v2.5q0 .75.75.75h2.5q.75 0 .75-.75zm-21 6v-2.5Q8 20 7.25 20h-2.5Q4 20 4 20.75v2.5q0 .75.75.75h2.5Q8 24 8 23.25zm18 0v-2.5q0-.75-.75-.75h-14.5q-.75 0-.75.75v2.5q0 .75.75.75h14.5q.75 0 .75-.75zm6 0v-2.5q0-.75-.75-.75h-2.5q-.75 0-.75.75v2.5q0 .75.75.75h2.5q.75 0 .75-.75z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'flag-checkered' => array(
		'p' => 'M15.188 11.875q.563.125 2.125.656t2.5.719v4.25q-.563-.125-2.125-.656t-2.5-.719v-4.25zm13.937-7.687q1-.438 1.938.125t.938 1.688v15.188q0 1.063-.875 1.625-3.688 2.563-7.625 2.563-2.25 0-5.531-1.063t-4.844-1.063q-3.875 0-7.125 1.375v5.875q#p#8h-1q-.625 0-1.063-.438t-.438-1.063V6.376q-1.5-1.063-1.5-2.875 0-1.5 1.063-2.531T4.125.001Q5 .064 5.75.501t1.219 1.156.531 1.594q.063.813-.25 1.5 2.063-.75 4.281-.75T17 5.095t4.875 1.094q3 0 7.25-2zm-18.5 16.187v-4.5Q8.5 16.063 6 17v4.375q2.188-.813 4.625-1zM29 11.938V7.5q-2.438 1.063-4.625 1.438v4.5q-2.188.375-4.563-.188V9q-.75-.125-4.625-1.375v4.25q-2.375-.688-4.563-.375V7.062q-1.188.063-4.625 1.375v4.375q2.875-1.063 4.625-1.313v4.375q2.5-.188 4.563.25v4.25q.688.125 4.625 1.375v-4.25q2.375.688 4.563.375v4.5q2.313-.25 4.625-1.75v-4.375q-2 1.25-4.625 1.625v-4.438q1.688-.25 4.625-1.5z',
		'w' => 1.013671875
	    ),
	    'terminal' => array(
		'p' => 'M16.125 17.063L4 29.188q-.438.438-1.063.438t-1.063-.438L.436 27.813q-.438-.438-.438-1.063t.438-1.063l9.625-9.688L.436 6.311q-.438-.438-.438-1.063t.438-1.063L1.874 2.81q.438-.438 1.063-.438T4 2.81l12.125 12.125q.438.438.438 1.063t-.438 1.063zM40 28.5q#p#8h-19q-.625 0-1.063-.438t-.438-1.063v-2q0-.625.438-1.063t1.063-.438h19q.625 0 1.063.438T40 26.5v2z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'code' => array(
		'p' => 'M17.438 32l-3.813-1.125q-.75-.188-.5-.938l8.5-29.375q.188-.75.938-.563l3.813 1.125q.75.188.5.938l-8.5 29.375q-.25.75-.938.563zm-7.125-7.062q-.5.563-1.063.063l-9-8.438q-.625-.563 0-1.125L9.25 7q.563-.5 1.063.063l2.688 2.875q.563.563 0 1.063l-5.688 5 5.688 5q.563.5 0 1.063zM30.75 25q-.563.5-1.063-.063l-2.688-2.875q-.563-.563 0-1.063l5.688-5-5.688-5q-.563-.5 0-1.063l2.688-2.875q.5-.563 1.063-.063l9 8.438q.625.563 0 1.125z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'reply-all' => array(
		'p' => 'M8.5 11.875l11-9.5q.75-.625 1.625-.219T22 3.5v5.188q3.188.25 5.625.906T32 11.532t2.969 3.469T36 20.126q0 2.75-1.5 5.406t-3.688 4.219q-.688.5-1.344.063t-.406-1.188q1.75-5.625-.031-8.188T22 17.25v5.25q0 .938-.875 1.344t-1.625-.219l-11-9.5Q8 13.687 8 13t.5-1.125zm-8 2.25Q0 13.687 0 13t.5-1.125l11-9.5q.75-.625 1.625-.219T14 3.5v1l-6.813 5.875q-.5.438-.844 1.188t-.344 1.438q0 .688.344 1.438t.844 1.188L14 21.502v1q0 .938-.875 1.344t-1.625-.219z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'location-arrow' => array(
		'p' => 'M27.813.25q1.75-.75 3.219.719t.719 3.219l-11.938 26q-.5 1.063-1.5 1.5t-1.938.25-1.656-1T14 29V18H3q-1.563 0-2.406-1.156t-.531-2.563 1.75-2.094z'
	    ),
	    'crop' => array(
		'p' => 'M30.5 22q.625 0 1.063.438t.438 1.063v3q#p#8H28v2.5q#p#8h-3q-.625 0-1.063-.438t-.438-1.063V12.814l-9.188 9.188h7.188v6h-14.5q-.625 0-1.063-.438t-.438-1.063v-16.5h-2.5q-.625 0-1.063-.438T-.004 8.5v-3q0-.625.438-1.063t1.063-.438h2.5v-2.5q0-.625.438-1.063t1.063-.438h3q.625 0 1.063.438t.438 1.063v17.688l9.188-9.188h-7.188v-6h13.188L28.875.311q.688-.75 1.438 0l1.375 1.375q.75.75 0 1.438L28 6.812V22h2.5z'
	    ),
	    'code-branch' => array(
		'p' => 'M24 9q0 1.625-.938 2.938t-2.438 1.813q-.063 2.625-1.375 4.25-.813 1-2.219 1.594t-2.406.781-2.75.313q-3.125.313-4.125.813-.625.313-.938.813 1.438.563 2.313 1.844t.875 2.844q0 2.063-1.469 3.531t-3.531 1.469-3.531-1.469-1.469-3.531q0-1.125.438-2.094t1.25-1.656 1.813-1v-12.5Q1.937 9.315.969 8.003t-.969-3Q0 2.94 1.469 1.472T5 .003t3.531 1.469T10 5.003q0 1.688-.969 3T6.5 9.753v9q1.5-.688 5.063-1.063 1.5-.125 2.25-.219t1.688-.438 1.375-.906q.688-.813.75-2.313-1.063-.313-1.875-1t-1.281-1.688-.469-2.125q0-2.063 1.469-3.531t3.531-1.469 3.531 1.469 1.469 3.531zM5 4q-.438 0-.719.281T4 5t.281.719T5 6t.719-.281T6 5t-.281-.719T5 4zm0 24q.438 0 .719-.281T6 27t-.281-.719T5 26t-.719.281T4 27t.281.719T5 28zM19 8q-.438 0-.719.281T18 9t.281.719T19 10t.719-.281T20 9t-.281-.719T19 8z',
		'w' => .75,
		'vw' => 24
	    ),
	    'unlink' => array(
		'p' => 'M19 25.375q.563.5 0 1.063l-2#r#813q-2.75 2.75-6.688 2.75T2.78 29.22t-2.781-6.719 2.75-6.688L5.562 13q.563-.563 1.063 0l2.5 2.5q.5.5 0 1l-2#r#813q-1.313 1.313-1.313 3.188t1.313 3.188T9.5 27.002t3.188-1.313l2.813-2.813q.5-.5 1 0zm-3.5-16.25l-2.5-2.5q-.563-.5 0-1.063l2.813-2.813q2.75-2.75 6.688-2.75T29.22 2.78t2.781 6.719-2.75 6.688L26.438 19q-.563.563-1.063 0l-2.5-2.5q-.5-.5 0-1l2.813-2.813q1.313-1.313 1.313-3.188t-1.313-3.188T22.5 4.998t-3.188 1.313l-2#r#813q-.5.5-1 0zm14.625 22.438q-.438.438-1.063.438t-1.063-.438L.436 4q-.438-.438-.438-1.063t.438-1.063L1.874.436q.438-.438 1.063-.438T4 .436l27.563 27.563q.438.438.438 1.063t-.438 1.063z'
	    ),
	    'question' => array(
		'p' => 'M12.625 0q4.125 0 7.563 2.813t3.438 6.813q0 2-.813 3.531t-1.969 2.375-2.313 1.469-1.969 1.281-.813 1.344v.375q#p#8h-4.5q-.625 0-1.063-.438t-.438-1.063v-.625q0-1.375.406-2.438t1.375-1.906 1.563-1.219 1.781-1.063q1.688-.938 2.375-1.594t.688-1.594q0-1.375-1.375-2.25t-2.938-.875q-1.188 0-2.094.406t-1.531 1-1.563 1.656q-.375.5-.969.594t-1.094-.281L2.183 7.749q-.5-.375-.594-.969t.281-1.094Q5.808-.002 12.62-.002zM12 23.313q1.813 0 3.063 1.281t1.25 3.063-1.25 3.063T12 32.001 8.937 30.72t-1.25-3.063 1.25-3.063T12 23.313z',
		'w' => .787109375,
		'vw' => 25
	    ),
	    'info' => array(
		'p' => 'M1.25 26.5H2.5v-9H1.25q-.5 0-.875-.375T0 16.25v-3q0-.5.375-.875T1.25 12h7q.5 0 .875.375t.375.875V26.5h1.25q.5 0 .875.375t.375.875v3q0 .5-.375.875T10.75 32h-9.5q-.5 0-.875-.375T0 30.75v-3q0-.5.375-.875t.875-.375zM6 0q1.875 0 3.188 1.313t1.313 3.188-1.313 3.188T6 9.002 2.812 7.689 1.499 4.501t1.313-3.188T6 0z',
		'w' => .375,
		'vw' => 12
	    ),
	    'exclamation' => array(
		'p' => 'M11 27q0 2.063-1.469 3.531T6 32t-3.531-1.469T1 27t1.469-3.531T6 22t3.531 1.469T11 27zM1.563 1.563q0-.625.438-1.094T3.064 0h5.875q.625 0 1.063.469t.438 1.094l-.875 17q0 .625-.438 1.031T8.064 20H3.939q-.625 0-1.063-.406t-.438-1.031z',
		'w' => .375,
		'vw' => 12
	    ),
	    'superscript' => array(
		'p' => 'M17 12q.438 0 .719.281T18 13v2q0 .438-.281.719T17 16h-1.75l-3.313 4.75L15.625 26H17q.438 0 .719.281T18 27v2q0 .438-.281.719T17 30h-3.875q-.563 0-.875-.5L9.375 25q-.125-.25-.375-.625-.188.375-.375.625l-2.75 4.5Q5.562 30 5 30H1q-.438 0-.719-.281T0 29v-2q0-.438.281-.719T1 26h1.625l3.563-5.188-3.313-4.813H1q-.438 0-.719-.281T0 14.999v-2q0-.438.281-.719T1 11.999h4.313q.563 0 .813.5l2.5 4.063q.25.438.375.625l.375-.625 2.563-4.063q.25-.5.813-.5h4.25zm14 4q.438 0 .719.281T32 17v2q0 .438-.281.719T31 20H20.5q-.875 0-1-.875-.063-.688-.063-1.188 0-1.313.406-2.469t1.063-1.969 1.438-1.5 1.594-1.219 1.469-1 1.063-.938.406-.906q0-.625-.406-1.063t-1.219-.438q-1.125 0-2 1.125-.563.75-1.375.25l-1.875-1.313q-.813-.563-.25-1.375.875-1.375 2.406-2.25t3.469-.875q2.438 0 4.281 1.438t1.844 4.063q0 2.25-1.625 4.063-.938 1-3.125 2.438-2.063 1.25-2.313 2h6.313z'
	    ),
	    'subscript' => array(
		'p' => 'M17 2q.438 0 .719.281T18 3v2q0 .438-.281.719T17 6h-1.75l-3.313 4.75L15.625 16H17q.438 0 .719.281T18 17v2q0 .438-.281.719T17 20h-3.875q-.563 0-.875-.5L9.375 15q-.125-.25-.375-.625-.188.375-.375.625l-2.75 4.5Q5.562 20 5 20H1q-.438 0-.719-.281T0 19v-2q0-.438.281-.719T1 16h1.625l3.563-5.188-3.313-4.813H1q-.438 0-.719-.281T0 4.999v-2q0-.438.281-.719T1 1.999h4.313q.563 0 .813.5l2.5 4.063q.25.438.375.625l.375-.625 2.563-4.063q.25-.5.813-.5h4.25zm14 24q.438 0 .719.281T32 27v2q0 .438-.281.719T31 30H20.5q-.875 0-1-.875-.063-.688-.063-1.188 0-1.813.75-3.281t1.844-2.406 2.188-1.656 1.875-1.406.781-1.281-.406-1.031-1.219-.438q-1.125 0-2 1.125-.563.75-1.375.25L20 16.5q-.813-.563-.25-1.375.875-1.375 2.406-2.25T25.625 12q2.438 0 4.281 1.438t1.844 4.063q0 2.25-1.625 4.063-.938 1-3.125 2.438-2.063 1.25-2.313 2H31z'
	    ),
	    'eraser' => array(
		'p' => 'M31.125 17.125L22.25 26h9q.75 0 .75.75v2.5q0 .75-.75.75H9q-1.25 0-2.125-.875l-6-6Q0 22.25 0 21t.875-2.125l16-16Q17.75 2 19 2t2.125.875l10 10Q32 13.75 32 15t-.875 2.125zm-18.937-3.937l-7.75 7.813 5 5h7.125l4.25-4.188z'
	    ),
	    'puzzle-piece' => array(
		'p' => 'M32.438 18.063q1.125 0 1.969.594t1.219 1.5.375 1.969q0 1.688-.906 2.781t-2.531 1.094q-1.25 0-2.781-1.125t-2.594-1.125-1.625.781-.594 1.875.094 2.188.313 1.906l.188.75q-.625 0-1.656.125t-2.031.219-2.125.219-2.094.063-1.75-.25-1.219-.688-.438-1.313q0-1.063 1.125-2.563t1.125-2.813q0-1.563-1.094-2.469t-2.781-.906q-1.063 0-1.969.375T9.22 22.438t-.531 1.938.625 2.094 1.25 1.688.625 1.281q0 1.25-1.156 1.875t-2.813.656-3.281-.094-2.813-.375l-1.125-.25V10.438l4 .625q7 .688 7-2.438 0-.563-1-2.125t-1-3q0-1.625 1.219-2.563t2.969-.938q1.625 0 2.719.906t1.094 2.531q0 1.25-1.125 2.75t-1.125 2.625q0 1.063.656 1.625t1.75.656 2.406-.031 2.625-.5 2.375-.719 1.75-.594l.688-.25-1.063 4.313q-1.188 6.688 1.375 6.688.563 0 2.125-.969t3-.969z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'microphone' => array(
		'p' => 'M11 22q-2.5 0-4.25-1.75T5 16V6q0-2.5 1.75-4.25T11 0t4.25 1.75T17 6v10q0 2.5-1.75 4.25T11 22zm10-10q.438 0 .719.281T22 13v3q0 4.125-2.719 7.219T12.5 26.875V29H16q.438 0 .719.281T17 30v1q0 .438-.281.719T16 32H6q-.438 0-.719-.281T5 31v-1q0-.438.281-.719T6 29h3.5v-2.125q-4.063-.563-6.781-3.844T0 15.5V13q0-.438.281-.719T1 12h1q.438 0 .719.281T3 13v2.625q0 3.188 2.063 5.625t5.125 2.688q3.563.375 6#q#031t2.625-5.906v-3q0-.438.281-.719t.719-.281h1z',
		'w' => .6875,
		'vw' => 22
	    ),
	    'microphone-slash' => array(
		'p' => 'M39.625 28.625q.75.625.188 1.438l-1.25 1.563q-.625.75-1.375.188L.375 3.376q-.75-.625-.188-1.438L1.437.375q.625-.75 1.375-.188L14 8.812V5.999q0-2.5 1.75-4.25T20-.001q1.625 0 3 .813T25.188 3t.813 3v10q0 .875-.313 1.875l1.625 1.25q.688-1.5.688-3.125v-3q0-.438.281-.719t.719-.281h1q.438 0 .719.281t.281.719v3q0 2.625-1.25 5zM25 29q.438 0 .719.281T26 30v1q0 .438-.281.719T25 32H15q-.438 0-.719-.281T14 31v-1q0-.438.281-.719T15 29h3.5v-2.125q-4.063-.563-6.781-3.844T9 15.5v-.438l3.25 2.563q.375 1.625 1.344 3t2.438 2.281 3.156 1.031q.438.063 1.313 0l3.125 2.438q-1.125.375-2.125.5V29h3.5z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'calendar' => array(
		'p' => 'M.75 12h26.5q.75 0 .75.75V29#n# 32H3q-1.25 0-2.125-.875T0 29V12.75Q0 12 .75 12zM28 9.25q0 .75-.75.75H.75Q0 10 0 9.25V7q0-1.25.875-2.125T3 4h3V.75Q6 0 6.75 0h2.5Q10 0 10 .75V4h8V.75q0-.75.75-.75h2.5Q22 0 22 .75V4h3q1.25 0 2.125.875T28 7v2.25z',
		'w' => .875,
		'vw' => 28
	    ),
	    'fire-extinguisher' => array(
		'p' => 'M27.125 1.625q.375-.063.625.188t.25.563v7.25q0 .313-.25.563t-.625.188l-10.5-1.75Q16 8.502 16 7.502h-2.5V9.19q.938.25 1.781.813t1.438 1.313.938 1.719.344 1.969v15.5q#p#8h-9q-.625 0-1.063-.438t-.438-1.063V15.066q0-2.063 1.281-3.719t3.219-2.156V7.503H8.186l-.938.063-.938.156-.75.281-.781.5-.625.719-.688 1-.594 1.344q-.188.563-.781.813t-1.156.031-.813-.813 0-1.156q1.875-4.75 5.625-5.688-.688-1.688.344-3.219T8.997.003q1.75 0 2.813 1.406t.563 3.094h3.625q0-1 .625-1.125zM9 4.5q.438 0 .719-.281T10 3.5t-.281-.719T9 2.5t-.719.281T8 3.5t.281.719T9 4.5z',
		'w' => .875,
		'vw' => 28
	    ),
	    'rocket' => array(
		'p' => 'M31.563 1.188q.438 2.063.438 5.188 0 4.5-2.125 7.625t-5.875 5.563v6.5q0 .813-.5 1.594t-1.188 1.094l-6.125 3.063q-.313.188-.688.188-.625 0-1.063-.438t-.438-1.063v-6.5l-1.375 1.438q-.625.563-1.438.563t-1.438-.563L6.56 22.252q-.563-.625-.563-1.438t.563-1.438l1.438-1.375h-6.5q-.625 0-1.063-.438T-.003 16.5q0-.375.188-.688l3.063-6.188q.313-.625 1.125-1.125t1.563-.5h6.5q2.375-3.813 5.531-5.906t7.656-2.094q3.188 0 5.188.438.625.125.75.75zM24 10.5q1.063 0 1.781-.719T26.5 8t-.719-1.781T24 5.5t-1.781.719T21.5 8t.719 1.781T24 10.5z',
		'w' => .998046875
	    ),
	    'chevron-circle-left' => array(
		'p' => 'M16 31.5q-6.438 0-10.969-4.531T.5 16 5.031 5.031 16 .5t10.969 4.531T31.5 16t-4.531 10.969T16 31.5zM8.875 17.063l8.5 8.438q.438.5 1.063.5t1.063-.5l1-1q.5-.5.5-1.094t-.5-1.031l-6.313-6.375 6.313-6.375q.5-.438.5-1.063t-.5-1.063l-1-1q-.5-.5-1.094-.5t-1.031.5l-8.5 8.438q-.438.438-.438 1.063t.438 1.063z'
	    ),
	    'chevron-circle-right' => array(
		'p' => '#e#7.125 14.438l-8.5-8.438q-.438-.5-1.063-.5t-1.063.5l-1 1q-.5.5-.5 1.094t.5 1.031L17.812 16l-6.313 6.375q-.5.438-.5 1.063t.5 1.063l1 1q.5.5 1.094.5t1.031-.5l8.5-8.438q.438-.438.438-1.063t-.438-1.063z'
	    ),
	    'chevron-circle-up' => array(
		'p' => 'M.5 16q0-6.438 4.531-10.969T16 .5t10.969 4.531T31.5 16t-4.531 10.969T16 31.5 5.031 26.969.5 16zm14.438-7.125l-8.438 8.5q-.5.438-.5 1.063t.5 1.063l1 1q.5.5 1.094.5t1.031-.5L16 14.188l6.375 6.313q.438.5 1.063.5t1.063-.5l1-1q.5-.5.5-1.094t-.5-1.031l-8.438-8.5q-.438-.438-1.063-.438t-1.063.438z'
	    ),
	    'chevron-circle-down' => array(
		'p' => 'M31.5 16q0 6.438-4.531 10.969T16 31.5 5.031 26.969.5 16 5.031 5.031 16 .5t10.969 4.531T31.5 16zm-14.437 7.125l8.438-8.5q.5-.438.5-1.063t-.5-1.063l-1-1q-.5-.5-1.094-.5t-1.031.5l-6.375 6.313-6.375-6.313q-.438-.5-1.063-.5t-1.063.5l-1 1q-.5.5-.5 1.094t.5 1.031l8.438 8.5q.438.438 1.063.438t1.063-.438z'
	    ),
	    'anchor' => array(
		'p' => 'M.813 22q-.5 0-.688-.469t.125-.781L4.5 16.5q.5-.5 1 0l4.25 4.25q.313.313.125.781T9.187 22H6.999q.875 2.438 3.438 3.969T16 27.875V16h-3.25q-.75 0-.75-.75v-2.5q0-.75.75-.75H16v-.313q-1.75-.625-2.875-2.188T12 5.999q0-2.5 1.781-4.281t4.281-1.719 4.219 1.813T24 6q0 1.938-1.125 3.5T20 11.688v.313h3.25q.313 0 .531.219t.219.531v2.5q0 .313-.219.531t-.531.219H20v11.875q3-.375 5.563-1.906t3.438-3.969h-2.188q-.5 0-.688-.469t.125-.781l4.25-4.25q.5-.5 1 0l4.25 4.25q.313.313.125.781t-.688.469h-2q-1 4.563-5.438 7.281t-9.75 2.719-9.75-2.719-5.438-7.281h-2zM18 4q-.813 0-1.406.594T16 6t.594 1.406T18 8t1.406-.594T20 6t-.594-1.406T18 4z',
		'w' => 1.123046875,
		'vw' => 36
	    ),
	    'unlock-alt' => array(
		'p' => 'M25 16q1.25 0 2.125.875T28 19v10#n# 32H3q-1.25 0-2.125-.875T0 29V19q0-1.25.875-2.125T3 16h1.5V9.625q0-4 2.781-6.813t6.688-2.813 6.719 2.781 2.813 6.719v1q0 .625-.438 1.063T22 12h-2q-.625 0-1.063-.438t-.438-1.063v-1q0-1.875-1.344-3.188t-3.219-1.313q-1.813 0-3.125 1.344T9.498 9.561v6.438h15.5zm-8.5 9.5v-3q0-1.063-.719-1.781T14 20t-1.781.719T11.5 22.5v3q0 1.063.719 1.781T14 28t1.781-.719.719-1.781z',
		'w' => .875,
		'vw' => 28
	    ),
	    'bullseye' => array(
		'p' => '#d#0 27q4.75 0 8.125-3.375T27 16t-3.375-8.125T15.5 4.5 7.375 7.875 4 16t3.375 8.125T15.5 27.5zm0-19.5q3.313 0 5.656 2.344T23.5 16t-2.344 5.656T15.5 24t-5.656-2.344T7.5 16t2.344-5.656T15.5 8zm0 12q1.625 0 2.813-1.188t1#q#813-1#q#813-2.813-1#q#813 1.188-1.188 2.813 1.188 2.813T15.5 20z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'ellipsis-h' => array(
		'p' => 'M20.5 16q0 1.875-1.313 3.188t-3.188 1.313-3.188-1.313T11.498 16t1.313-3.188 3.188-1.313 3.188 1.313T20.5 16zm6.5-4.5q1.875 0 3.188 1.313t1.313 3.188-1.313 3.188T27 20.502t-3.188-1.313-1.313-3.188 1.313-3.188T27 11.5zm-22 0q1.875 0 3.188 1.313t1.313 3.188-1.313 3.188T5 20.502t-3.188-1.313-1.313-3.188 1.313-3.188T5 11.5z'
	    ),
	    'ellipsis-v' => array(
		'p' => 'M6 11.5q1.875 0 3.188 1.313t1.313 3.188-1.313 3.188T6 20.502t-3.188-1.313-1.313-3.188 1.313-3.188T6 11.5zM1.5 5q0-1.875 1.313-3.188T6.001.499t3.188 1.313T10.502 5 9.189 8.188 6.001 9.501 2.813 8.188 1.5 5zm0 22q0-1.875 1.313-3.188t3.188-1.313 3.188 1.313T10.502 27t-1.313 3.188-3.188 1.313-3.188-1.313T1.5 27z',
		'w' => .375,
		'vw' => 12
	    ),
	    'rss-square' => array(
		'p' => '#a#M7 26q1.25 0 2.125-.875T10 23t-.875-2.125T7 20t-2.125.875T4 23t.875 2.125T7 26zm9.875 0q.25 0 .469-.219t.219-.531q-.313-5.188-3.969-8.844T4.75 12.437q-.313 0-.531.219T4 13.125v2.188q0 .688.688.688 3.75.25 6.406 2.906T14 25.313q0 .688.688.688h2.188zm6.438 0q.25 0 .469-.219t.219-.531q-.313-7.813-5.844-13.375T4.751 6q-.313 0-.531.219t-.219.469v2.188q0 .688.688.688 6.375.25 10.938 4.813t4.813 10.938q0 .688.688.688h2.188z',
		'w' => .875,
		'vw' => 28
	    ),
	    'play-circle' => array(
		'p' => '#e#7.25 17q.375-.188.563-.563t.188-.75-.188-.75-.563-.563l-11-6.688q-.75-.438-1.5 0T10 9.499v13q0 .875.75 1.313t1.5 0z'
	    ),
	    'minus-square' => array(
		'p' => '#a#M5.75 18.5h16.5q.75 0 .75-.75v-3.5q0-.75-.75-.75H5.75q-.75 0-.75.75v3.5q0 .75.75.75z',
		'w' => .875,
		'vw' => 28
	    ),
	    'check-square' => array(
		'p' => 'M25 30H3q-1.25 0-2.125-.875T0 27V5q0-1.25.875-2.125T3 2h22q1.25 0 2.125.875T28 5v22#n# 30zm-12.812-6.125l11.5-11.5q.75-.688 0-1.438l-1.375-1.375q-.75-.75-1.438 0L11.5 18.937l-4.375-4.375q-.688-.75-1.438 0l-1.375 1.375q-.75.75 0 1.438l6.5 6.5q.688.688 1.375 0z',
		'w' => .875,
		'vw' => 28
	    ),
	    'pen-square' => array(
		'p' => 'M25 30H3q-1.25 0-2.125-.875T0 27V5q0-1.25.875-2.125T3 2h22q1.25 0 2.125.875T28 5v22#n# 30zM14.875 11.125l-8.5 8.5L6 23.188q0 .188.094.406t.313.313.406.094l3.563-.375 8.5-8.5q.25-.25 0-.5l-3.438-3.5q-.313-.25-.563 0zm6.688-.812l-1.875-1.875Q19.25 8 18.625 8t-1.063.438l-1.438 1.438q-.25.25 0 .563l3.438 3.438q.313.25.563 0l1.438-1.438q.438-.438.438-1.063t-.438-1.063z',
		'w' => .875,
		'vw' => 28
	    ),
	    'pencil-square'=>'pen-square',
	    'share-square' => array(
		'p' => 'M35.5 11.063l-9 8.5q-.688.688-1.594.313T24 18.501v-4.5q-2.813 0-4.781.313t-3.469 1.031-2.156 1.938-.656 3.063.75 4.344q.25.75-.375 1.156t-1.188-.031q-1.938-1.5-3.281-3.969T7.5 16.815q0-2.625.875-4.563t2.281-3.125 3.594-1.875 4.5-.969T24 6.002v-4.5q0-1 .906-1.375T26.5.44l9 8.5q.5.438.5 1.063t-.5 1.063zM24 23.688q0-.313.25-.563t.625-.188q.313.063.625.063.75 0 1.5-.25.375-.125.688.094t.313.594v5.563q0 1.25-.875 2.125t-2.125.875h-22q-1.25 0-2.125-.875t-.875-2.125v-22q0-1.25.875-2.125t2.125-.875h7.563q.563 0 .719.563t-.344.875q-1.875.938-3.188 2.313-.25.25-.563.25H4v20h20v-4.313z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'compass' => array(
		'p' => 'M14.094 14.594Q14.688 14 15.5 14t1.406.594T17.5 16t-.594 1.406T15.5 18t-1.406-.594T13.5 16t.594-1.406z#d#7.875 9.25q.25-.5.031-1t-.656-.656-1 .031l-9 4.125q-.688.313-1 1l-4.125 9q-.375.75.25 1.375t1.375.25l9-4.125q.688-.313 1-1z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'caret-square-down' => array(
		'p' => '#b#M5.75 13.75l7.75 7.75q.5.5 1 0l7.75-7.75q.313-.313.125-.781t-.688-.469H6.312q-.5 0-.688.469t.125.781z',
		'w' => .875,
		'vw' => 28
	    ),
	    'caret-square-up' => array(
		'p' => 'M0 27V5q0-1.25.875-2.125T3 2h22q1.25 0 2.125.875T28 5v22#n# 30H3q-1.25 0-2.125-.875T0 27zm22.25-8.75L14.5 10.5q-.5-.5-1 0l-7.75 7.75q-.313.313-.125.781t.688.469h15.375q.5 0 .688-.469t-.125-.781z',
		'w' => .875,
		'vw' => 28
	    ),
	    'caret-square-right' => array(
		'p' => 'M3 2h22q1.25 0 2.125.875T28 5v22#n# 30H3q-1.25 0-2.125-.875T0 27V5q0-1.25.875-2.125T3 2zm8.75 22.25l7.75-7.75q.5-.5 0-1l-7.75-7.75q-.313-.313-.781-.125t-.469.688v15.375q0 .5.469.688t.781-.125z',
		'w' => .875,
		'vw' => 28
	    ),
	    'euro-sign' => array(
		'p' => 'M19.438 25.875l.563 2.75q.125.688-.563.875-1.875.5-3.813.5-4.813 0-8.313-2.688t-4.688-7.063H.749q-.313 0-.531-.219t-.219-.531v-1.75q0-.75.75-.75h1.313q-.063-1.25.063-2.625H.75q-.313 0-.531-.219T0 13.624v-1.875q0-.75.75-.75h2.063q1.375-4 4.844-6.5t7.969-2.5q1.563 0 3.25.313.25.063.406.188t.219.344 0 .406L18.751 6q-.188.688-.875.563-1.313-.25-2.375-.25-2.5 0-4.438 1.25t-2.938 3.438h8.625q.375 0 .594.281t.156.656l-.375 1.813q-.125.625-.75.625H7.187q-.125 1.188 0 2.625h8.375q.375 0 .594.281t.156.656l-.375 1.75q-.125.563-.75.563H8.062q.5 1.188 1.25 2.188t1.719 1.688 2.156 1.094 2.5.406q1.375 0 2.813-.375.75-.125.938.625z',
		'w' => .623046875,
		'vw' => 20
	    ),
	    'pound-sign' => array(
		'p' => 'M19.25 22q.75 0 .75.75v6.5q0 .75-.75.75H.75Q0 30 0 29.25v-2.5Q0 26 .75 26H3v-8H1.25q-.75 0-.75-.75v-2.5q0-.75.75-.75H3V9.875q0-3.438 2.469-5.656T11.75 2q3.438 0 6.375 2.188.563.438.125 1.063l-1#r#25q-.438.5-1 .125-1.875-1.188-3.563-1.188-.563 0-1.094.125t-.969.375-.781.563-.563.719-.344.844-.125.938v4h5.25q.75 0 .75.75v2.5q0 .75-.75.75h-5.25v7.938h7.688v-3.188q0-.313.219-.531t.531-.219h2.813z',
		'w' => .625,
		'vw' => 20
	    ),
	    'dollar-sign' => array(
		'p' => 'M13.063 14.563q2.75.813 4.156 3.438t.406 5.438q-.75 2.063-2.563 3.281t-4.063 1.281v3q0 .438-.281.719t-.719.281h-2q-.438 0-.719-.281t-.281-.719v-3q-3 0-5.375-1.875-.375-.313-.438-.75t.313-.75l2.125-2.125q.625-.563 1.25-.125.938.625 2.125.625h4.125q.813 0 1.344-.531t.531-1.344q0-1.375-1.313-1.75l-6.438-1.875q-2.125-.625-3.563-2.25t-1.688-3.75q-.25-3.063 1.781-5.281t5.094-2.219h.125v-3q0-.438.281-.719t.719-.281h2q.438 0 .719.281t.281.719v3q3 0 5.375 1.875.375.313.438.75t-.313.75l-2.125 2.125q-.625.563-1.25.125-.938-.625-2.125-.625H6.872q-.813 0-1.344.531t-.531 1.344q0 .563.375 1.063t.938.688z',
		'w' => .5625,
		'vw' => 18
	    ),
	    'rupee-sign' => array(
		'p' => 'M19.25 6h-4.563q.563.938.875 2h3.688q.75 0 .75.75v2.5q0 .75-.75.75h-3.313q-.313 3.5-2.688 5.688t-5.938 2.313l9.438 8.688q.375.375.188.844t-.688.469h-5.188q-.313 0-.5-.188L.248 20.251q-.25-.188-.25-.5v-3.313q0-.313.219-.531t.531-.219h5.25q1.938 0 3.156-1T10.685 12H.747q-.75 0-.75-.75v-2.5q0-.75.75-.75h9.125q-1.25-1.688-3.813-1.688H.746q-.313 0-.531-.219t-.219-.531V2.749q0-.75.75-.75h18.5q.75 0 .75.75v2.5q0 .75-.75.75z',
		'w' => .625,
		'vw' => 20
	    ),
	    'yen-sign' => array(
		'p' => 'M21.938 2q.438 0 .656.375t.031.75l-5 9.375h3.625q.75 0 .75.75v2q0 .75-.75.75h-5.5l-1.25 2.313v1.688h6.75q.75 0 .75.75v2q0 .75-.75.75H14.5v5.75q0 .75-.75.75h-3.5q-.75 0-.75-.75v-5.75H2.75q-.75 0-.75-.75v-2q0-.75.75-.75H9.5v-1.688L8.25 16h-5.5Q2 16 2 15.25v-2q0-.75.75-.75h3.625l-5-9.375q-.188-.375.031-.75T2.062 2h4.063q.5 0 .688.438l3.438 7.063 1.688 4.5h.125q.75-2.313 1.688-4.5l3.438-7.063Q17.378 2 17.878 2h4.063z',
		'w' => .75,
		'vw' => 24
	    ),
	    'ruble-sign' => array(
		'p' => 'M14.938 20h-5.75v2h10.063q.75 0 .75.75v2.5q0 .75-.75.75H9.188v3.25q0 .313-.219.531T8.438 30H4.75Q4 30 4 29.25V26H.75Q0 26 0 25.25v-2.5Q0 22 .75 22H4v-2H.75Q0 20 0 19.25v-2.813q0-.313.219-.531t.531-.219H4V2.749q0-.75.75-.75h10.188q4 0 6.531 2.469T24 10.937t-2.531 6.531-6.531 2.531zM9.188 6.313v9.375h4.813q2.25 0 3.5-1.281t1.25-3.469q0-2.125-1.25-3.375t-3.438-1.25H9.188z',
		'w' => .75,
		'vw' => 24
	    ),
	    'won-sign' => array(
		'p' => 'M35.25 12h-3.938l-.438 2h4.375q.75 0 .75.75v2.5q0 .75-.75.75h-5.313l-2.625 11.438q-.125.563-.75.563h-3.563q-.563 0-.688-.563L19.622 18h-3.438l-2.625 11.438q-.125.563-.75.563H9.246q-.563 0-.688-.563L5.995 18H.745q-.75 0-.75-.75v-2.5q0-.75.75-.75H5.12l-.5-2H.745q-.75 0-.75-.75v-2.5q0-.75.75-.75h3L2.62 2.937q-.063-.313.156-.594t.594-.281h2.625q.625 0 .75.563L7.808 8h6.813l1.25-5.375q.125-.563.688-.563h2.75q.625 0 .75.563L21.309 8h6.875l.875-5.375q.125-.563.75-.563h2.875q.375 0 .594.281t.156.594L32.246 8h3q.75 0 .75.75v2.5q0 .75-.75.75zM11.5 21.375L12.25 18H9.875l.688 3.375.375 2.938h.063q.063 0 .094-.375t.125-1.125.281-1.438zM13.188 14l.5-2H8.625L9 14h4.188zm3.937 0h1.625l-.125-.563q-.188-.688-.313-1.438h-.75q-.125.75-.313 1.438zm8.188 7.375l.75-3.375h-2.438l.75 3.375q.188.688.281 1.438t.125 1.125l.031.375h.063q.125-1.375.438-2.938zM26.875 14l.438-2H22.25l.438 2h4.188z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'file' => array(
		'p' => '#j#14v8.5zm10-.875V8h-8V0h.375Q17 0 17.438.438l6.125 6.125q.438.438.438 1.063z',
		'w' => .75,
		'vw' => 24
	    ),
	    'file-alt' => array(
		'p' => '#j#14v8.5zm4 14.75v-.5q0-.75-.75-.75H6.75Q6 22 6 22.75v.5q0 .75.75.75h10.5q.75 0 .75-.75zm0-4v-.5q0-.75-.75-.75H6.75Q6 18 6 18.75v.5q0 .75.75.75h10.5q.75 0 .75-.75zm0-4.5q0-.75-.75-.75H6.75Q6 14 6 14.75v.5q0 .75.75.75h10.5q.75 0 .75-.75v-.5zm6-7.125V8h-8V0h.375Q17 0 17.438.438l6.125 6.125q.438.438.438 1.063z',
		'w' => .75,
		'vw' => 24
	    ),
	    'sort-alpha-down' => array(
		'p' => 'M25.063 26.688q.188 0 .344.094t.281.281.125.375v1.813q0 .313-.219.531t-.531.219h-8.125q-.313 0-.531-.219t-.219-.531v-1.375q0-.25.188-.438l4.188-5.938.125-.188h-3.563q-.25 0-.5-.219t-.25-.531v-1.813q0-.313.25-.531t.5-.219h7.875q.313 0 .531.219t.219.531v1.313q0 .25-.188.438l-4.313 6.188h3.813zM11 23q.688 0 .938.625t-.25 1.063l-5 5q-.688.75-1.375 0l-5-5q-.5-.438-.25-1.063T1.001 23h3V3q0-.438.281-.719T5.001 2h2q.438 0 .719.281T8.001 3v20h3zm15.5-10q.063.188.031.375t-.125.313-.25.219-.344.094h-2.25q-.563 0-.688-.563l-.563-1.75h-2.688l-.5 1.75q-.125.563-.688.563h-2.25q-.375 0-.594-.313T15.497 13L19.06 2.5q.188-.5.688-.5h2.5q.5 0 .688.5zm-5.937-4.437h.875L21 7.125z',
		'w' => .828125,
		'vw' => 27
	    ),
	    'sort-alpha-up' => array(
		'p' => 'M6.688 2.313l5 5q.5.438.25 1.063T11 9.001H8v20q0 .438-.281.719T7 30.001H5q-.438 0-.719-.281T4 29.001v-20H1q-.688 0-.938-.625t.25-1.063l5-5q.688-.75 1.375 0zm18.375 24.375q.188 0 .344.094t.281.281.125.375v1.813q0 .313-.219.531t-.531.219h-8.125q-.313 0-.531-.219t-.219-.531v-1.375q0-.25.188-.438l4.188-5.938.125-.188h-3.563q-.25 0-.5-.219t-.25-.531v-1.813q0-.313.25-.531t.5-.219h7.875q.313 0 .531.219t.219.531v1.313q0 .25-.188.438l-4.313 6.188h3.813zM26.5 13q.063.188.031.375t-.125.313-.25.219-.344.094h-2.25q-.563 0-.688-.563l-.563-1.75h-2.688l-.5 1.75q-.125.563-.688.563h-2.25q-.375 0-.594-.313T15.497 13L19.06 2.5q.188-.5.688-.5h2.5q.5 0 .688.5zm-5.937-4.437h.875L21 7.125z',
		'w' => .828125,
		'vw' => 27
	    ),
	    'sort-amount-down' => array(
		'p' => 'M11.688 24.688l-5 5q-.688.75-1.375 0l-5-5q-.5-.438-.25-1.063T1.001 23h3V3q0-.438.281-.719T5.001 2h2q.438 0 .719.281T8.001 3v20h3q.688 0 .938.625t-.25 1.063zM15 6q-.438 0-.719-.281T14 5V3q0-.438.281-.719T15 2h16q.438 0 .719.281T32 3v2q0 .438-.281.719T31 6H15zm-1 7v-2q0-.438.281-.719T15 10h12q.438 0 .719.281T28 11v2q0 .438-.281.719T27 14H15q-.438 0-.719-.281T14 13zm0 16v-2q0-.438.281-.719T15 26h4q.438 0 .719.281T20 27v2q0 .438-.281.719T19 30h-4q-.438 0-.719-.281T14 29zm0-8v-2q0-.438.281-.719T15 18h8q.438 0 .719.281T24 19v2q0 .438-.281.719T23 22h-8q-.438 0-.719-.281T14 21z'
	    ),
	    'sort-amount-up' => array(
		'p' => 'M.313 7.313l5-5q.688-.75 1.375 0l5 5q.5.438.25 1.063T11 9.001H8v20q0 .438-.281.719T7 30.001H5q-.438 0-.719-.281T4 29.001v-20H1q-.688 0-.938-.625t.25-1.063zM15 6q-.438 0-.719-.281T14 5V3q0-.438.281-.719T15 2h16q.438 0 .719.281T32 3v2q0 .438-.281.719T31 6H15zm-1 7v-2q0-.438.281-.719T15 10h12q.438 0 .719.281T28 11v2q0 .438-.281.719T27 14H15q-.438 0-.719-.281T14 13zm0 16v-2q0-.438.281-.719T15 26h4q.438 0 .719.281T20 27v2q0 .438-.281.719T19 30h-4q-.438 0-.719-.281T14 29zm0-8v-2q0-.438.281-.719T15 18h8q.438 0 .719.281T24 19v2q0 .438-.281.719T23 22h-8q-.438 0-.719-.281T14 21z'
	    ),
	    'sort-numeric-down' => array(
		'p' => 'M19.313 7.125l-1.25-1.313q-.5-.563.063-1.063l2.688-2.563q.25-.188.563-.188h1.938q.313 0 .531.219t.219.531v7.938h1.625q.313 0 .531.219t.219.531v1.813q0 .313-.219.531t-.531.219h-6.813q-.313 0-.531-.219t-.219-.531v-1.813q0-.313.219-.531t.531-.219h1.563V7.061q-.625.563-1.125.063zM17.375 22q0-1.625 1.156-2.906t3.094-1.281q2 0 3.5 1.5t1.5 4.25q0 2.625-1.563 4.625t-4.188 2q-1.375 0-2.438-.438-.625-.25-.438-.875L18.623 27q.188-.75.938-.5 1.5.563 2.375-.25-1.188#q#25-.344t-1.688-1.563-.625-2.344zm5.813 1.25q0-1-.531-1.656t-1.094-.656q-.813 0-.813 1 0 .313.063.594t.438.594 1.063.313q.75 0 .813-.188h.063zM11 23q.688 0 .938.625t-.25 1.063l-5 5q-.688.75-1.375 0l-5-5q-.5-.438-.25-1.063T1.001 23h3V3q0-.438.281-.719T5.001 2h2q.438 0 .719.281T8.001 3v20h3z',
		'w' => .830078125,
		'vw' => 27
	    ),
	    'sort-numeric-up' => array(
			'p' => 'M19.313 7.125l-1.25-1.313q-.5-.563.063-1.063l2.688-2.563q.25-.188.563-.188h1.938q.313 0 .531.219t.219.531v7.938h1.625q.313 0 .531.219t.219.531v1.813q0 .313-.219.531t-.531.219h-6.813q-.313 0-.531-.219t-.219-.531v-1.813q0-.313.219-.531t.531-.219h1.563V7.061q-.625.563-1.125.063zM17.375 22q0-1.625 1.156-2.906t3.094-1.281q2 0 3.5 1.5t1.5 4.25q0 2.625-1.563 4.625t-4.188 2q-1.375 0-2.438-.438-.625-.25-.438-.875L18.623 27q.188-.75.938-.5 1.5.563 2.375-.25-1.188#q#25-.344t-1.688-1.563-.625-2.344zm5.813 1.25q0-1-.531-1.656t-1.094-.656q-.813 0-.813 1 0 .313.063.594t.438.594 1.063.313q.75 0 .813-.188h.063zM1 9q-.688 0-.938-.625t.25-1.063l5-5q.688-.75 1.375 0l5 5q.5.438.25 1.063T10.999 9h-3v20q0 .438-.281.719T6.999 30h-2q-.438 0-.719-.281T3.999 29V9h-3z',
			'w' => .830078125,
			'vw' => 27
	    ),
	    'thumbs-up' => array(
			'p' => 'M6.5 14q.625 0 1.063.438t.438 1.063v15q#p#8h-5q-.625 0-1.063-.438t-.438-1.063v-15q0-.625.438-1.063T1.5 14h5zM4 29.5q.625 0 1.063-.438t.438-1.063-.438-1.063T4 26.498t-1.063.438-.438 1.063.438 1.063T4 29.5zM24 5.063q0 1.563-1 3.531T21.937 11h6.313q1.563 0 2.656 1.094T32 14.625q0 1.875-1.188 3.063h-.063q.5 1.063.375 2.5t-.938 2.5q.375 1.25.063 2.531t-1.063 2.156q.375 1.625-.375 2.75-.625.875-1.938 1.313t-2.344.5-2.844.063h-.188q-3 0-7.5-2-2.188-1-3.25-1-.313 0-.531-.219t-.219-.531V14.876q0-.313.25-.5 1.25-1.313 2.906-3.719t2.656-3.344q.875-.938 1.563-3.688Q18.247 0 19.497 0q.688 0 1.344.156t1.438.625 1.25 1.594.469 2.688z',
			'w' => .998046875
	    ),
	    'thumbs-o-up'=>'thumbs-up',
	    'thumbs-down' => array(
			'p' => 'M0 3.5q0-.625.438-1.063t1.063-.438h5q.625 0 1.063.438T8.002 3.5v15q#p#8h-5q-.625 0-1.063-.438T0 18.5v-15zM2.5 16q0 .625.438 1.063t1.063.438 1.063-.438T5.502 16t-.438-1.063-1.063-.438-1.063.438T2.5 16zm17 16q-1.25 0-2.125-3.625-.688-2.75-1.563-3.688-.875-.813-1.75-2.063t-1.844-2.594-1.969-2.406q-.25-.188-.25-.5V3.749q0-.313.219-.531t.531-.219q1.063 0 3.25-1 4.5-2 7.5-2h.188q1.313 0 2.094.031t1.906.188 1.875.563 1.25 1.094q.75 1.125.375 2.75.75.875 1.063 2.156t-.063 2.531q.813 1.063.938 2.5t-.375 2.5h.063q1.188 1.188 1.188 3.063 0 1.438-1.094 2.531T28.251 21h-6.313q.063.438 1.063 2.406t1 3.531-.469 2.688-1.25 1.594-1.438.625T19.5 32z'
	    ),
	    'thumbs-o-down'=>'thumbs-down',
	    'female' => array(
		'p' => 'M8 0q1.688 0 2.844 1.156T12 4t-1.156 2.844T8 8 5.156 6.844 4 4t1.156-2.844T8 0zm7.438 22.125q.188.75-.25 1.313T14 24.001h-3.5v6.5q#p#8h-2q-.625 0-1.063-.438t-.438-1.063v-6.5h-3.5q-.75 0-1.188-.563t-.25-1.313l3-12q.125-.438.531-.781T4.997 9h.688q2.313 1.063 4.625 0h.688q.5 0 .906.344t.531.781z',
		'w' => .5,
		'vw' => 16
	    ),
	    'male' => array(
		'p' => 'M6 0q1.688 0 2.844 1.156T10 4 8.844 6.844 6 8 3.156 6.844 2 4t1.156-2.844T6 0zm3 9q1.25 0 2.125.875T12 12v8.5q#p#8h-1v8.5q#p#8h-4q-.625 0-1.063-.438t-.438-1.063v-8.5h-1q-.625 0-1.063-.438T-.004 20.5V12q0-1.25.875-2.125T2.996 9h.688q2.313 1.063 4.625 0h.688z',
		'w' => .375,
		'vw' => 12
	    ),
	    'sun' => array(
		'p' => 'M16 10q2.5 0 4.25 1.75T22 16t-1.75 4.25T16 22t-4.25-1.75T10 16t1.75-4.25T16 10zm15.375 5q.625.313.625 1t-.625 1L25.5 19.938l2.063 6.25q.188.625-.281 1.125t-1.094.25l-6.25-2.063-3 5.875Q16.688 32 16 32t-1-.625L12.062 25.5l-6.25 2.063q-.625.25-1.125-.219t-.25-1.156l2.063-6.25L.625 17Q0 16.687 0 16t.625-1L6.5 12.062l-2.063-6.25q-.25-.625.219-1.125t1.156-.25l6.25 2.063L15 .625Q15.313 0 16 0t1 .625L19.938 6.5l6.25-2.063q.625-.25 1.125.25t.25 1.125l-2.063 6.25zm-9.719 6.656Q24 19.312 24 16t-2.344-5.656T16 8t-5.656 2.344T8 16t2.344 5.656T16 24t5.656-2.344z',
		'w' => .998046875
	    ),
	    'moon' => array(
		'p' => 'M17.688 32q-4.313 0-8-2.156t-5.844-5.813T1.688 16q0-6.625 4.688-11.313T17.689-.001q1.5 0 2.938.25.5.125.594.625t-.344.813q-2.938 1.625-4.656 4.563t-1.719 6.313q0 5.875 4.563 9.656t10.375 2.656q.5-.125.75.344t-.063.844q-1.5 1.875-3.438 3.188t-4.25 2.031-4.75.719z'
	    ),
	    'archive' => array(
		'p' => 'M2 28V10h28v18q0 .813-.594 1.406T28 30H4q-.813 0-1.406-.594T2 28zm10-13.25v.5q0 .75.75.75h6.5q.75 0 .75-.75v-.5q0-.75-.75-.75h-6.5q-.75 0-.75.75zM30 2q.813 0 1.406.594T32 4v3q0 .438-.281.719T31 8H1q-.438 0-.719-.281T0 7V4q0-.813.594-1.406T2 2h28z'
	    ),
	    'bug' => array(
		'p' => 'M32 18.063q0 .813-.625 1.375t-1.438.563h-3.438v1q0 2-.875 3.813l3.813 3.75q.563.625.563 1.438t-.594 1.406-1.406.594-1.438-.563l-3.375-3.438q-2.5 2-5.688 2v-15.25q0-.75-.75-.75h-1.5q-.75 0-.75.75v15.25q-3.188 0-5.688-2l-3.375 3.438q-.625.563-1.438.563t-1.406-.594-.594-1.406.563-1.438l3.813-3.75q-.875-1.813-.875-3.813v-1H2.061q-.813 0-1.438-.563t-.625-1.375q0-.875.594-1.469T1.998 16h3.5v-3.688L2.56 9.437q-.563-.625-.563-1.438t.594-1.406 1.406-.594 1.438.563L8.81 10h14.375l3.375-3.438q.625-.563 1.438-.563t1.406.594.594 1.406-.563 1.438l-2.938 2.875V16h3.5q.813 0 1.406.594t.594 1.469zM16.063 0q2.875 0 4.938 2.063t2.063 4.938h-14q0-2.875 2.063-4.938T16.065 0z'
	    ),
	    'caret-square-left' => array(
		'p' => 'M25 30H3q-1.25 0-2.125-.875T0 27V5q0-1.25.875-2.125T3 2h22q1.25 0 2.125.875T28 5v22#n# 30zM16.25 7.75L8.5 15.5q-.5.5 0 1l7.75 7.75q.313.313.781.125t.469-.688V8.312q0-.5-.469-.688t-.781.125z',
		'w' => .875,
		'vw' => 28
	    ),
	    'dot-circle' => array(
		'p' => 'M16 .5q6.438 0 10.969 4.531T31.5 16t-4.531 10.969T16 31.5 5.031 26.969.5 16 5.031 5.031 16 .5zM21 16q0-2.063-1.469-3.531T16 11t-3.531 1.469T11 16t1.469 3.531T16 21t3.531-1.469T21 16z'
	    ),
	    'wheelchair' => array(
		'p' => 'M31 24.125l.875 1.75q.188.375.063.781t-.5.594l-4.063 2.063q-.75.375-1.563.094t-1.188-1.031l-3.875-8.375h-8.75q-.75 0-1.313-.5t-.688-1.188q-2-14.063-2-14.313 0-1.125.563-2.063T10.092.468t2.094-.469q1.563.063 2.656 1.188t1.156 2.688q0 1-.438 1.906T14.341 7.25t-1.781.688l.313 2.063h8.125q.438 0 .719.281t.281.719v2q0 .438-.281.719t-.719.281h-7.563l.313 2h8.25q.5 0 1.031.344t.781.781l3.563 7.688 2.313-1.188q.375-.125.75 0t.563.5zM19.438 22l1.625 3.438q-1.313 2.938-4.031 4.75t-6.031 1.813q-4.563 0-7.781-3.219T.001 21.001q0-3.438 1.906-6.219t5.031-3.969q.25 1.688.563 4.125-1.563.938-2.531 2.531T4.001 21q0 2.875 2.063 4.938t4.938 2.063q2.625 0 4.594-1.719t2.344-4.281h1.5z'
	    ),
	    'lira-sign' => array(
		'p' => 'M23.25 16q.313 0 .531.219t.219.531q-.25 6.25-4.094 9.75T9.75 30h-5Q4 30 4 29.25V17.187l-3.063.688q-.375.063-.656-.156T0 17.125v-2.563q0-.625.563-.75l3.438-.75v-1.875l-3.063.688q-.375.063-.656-.156t-.281-.594V8.562q0-.625.563-.75l3.438-.75V2.749q0-.75.75-.75h3.5q.75 0 .75.75v3.188l8.063-1.813q.375-.063.656.156t.281.594v2.563q0 .625-.563.75l-8.438 1.875v1.875l8.063-1.813q.375-.063.656.156t.281.594v2.563q0 .625-.563.75L9 16.062V26q4.375 0 7.438-2.406t3.063-6.906q0-.25.219-.469t.531-.219h3z',
		'w' => .75,
		'vw' => 24
	    ),
	    'space-shuttle' => array(
		'p' => 'M37.063 13q2.938 1.375 2.938 3t-2.938 3q-3.25 1.5-7.563 1.5H11.625q-.438.625-1 1H23.5q-2.5.5-4.563 1.594t-3.406 2.219-2.656 2.219-3.031 1.781T6 30.001v-8H5v8q-1.25 0-2.125-1.156T2 26.001v-4q-2 0-2-1.5v-2.5q0-1.5 2-1.5v-1q-2 0-2-1.5v-2.5q0-1.5 2-1.5v-4q0-1.688.875-2.844T5 2.001v8h1v-8q2.125 0 3.844.688t3.031 1.781 2.656 2.219 3.406 2.219 4.563 1.594H10.625q.563.375 1 1H29.5q4.313 0 7.563 1.5zM30.5 18.5q.938 0 1.313-1.25t0-2.5T30.5 13.5q-.5 0-.5.5v4q0 .5.5.5z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'envelope-square' => array(
		'p' => '#a#M11.125 16.375q.063 0 .594.438t.781.594.719.375.781.219.781-.219.719-.375.781-.594.594-.438Q21.5 13.062 24 11.062V9.499q0-.625-.438-1.063t-1.063-.438h-17q-.625 0-1.063.438t-.438 1.063v1.563q2.5 2 7.125 5.313zM24 13.625Q22.625 14.688 18.062 18q-.063.063-.563.438t-.781.563-.781.469-.969.406-.969.125-.969-.125-.969-.406-.75-.469-.781-.563T9.936 18q-4.563-3.313-5.938-4.375V22.5q0 .625.438 1.063t1.063.438h17q.625 0 1.063-.438T24 22.5v-8.875z',
		'w' => .875,
		'vw' => 28
	    ),
	    'university' => array(
		'p' => 'M31 8v1q0 .5-.5.5H29v.75q0 .75-.75.75H3.75Q3 11 3 10.25V9.5H1.5Q1 9.5 1 9V8q0-.313.313-.438l14.5-5.5q.063-.063.188-.063t.188.063l14.5 5.5q.313.125.313.438zm-1.5 19q.625 0 1.063.438t.438 1.063v1q0 .5-.5.5h-29q-.5 0-.5-.5v-1q0-.625.438-1.063T2.502 27h27zM6 12h4v12h4V12h4v12h4V12h4v12h2.25q.75 0 .75.75V26H3v-1.25q0-.75.75-.75H6V12z'
	    ),
	    'graduation-cap' => array(
		'p' => 'M38.875 9.563Q40 9.938 40 11.001t-1.125 1.438l-17.438 5.313q-1.438.5-2.875 0l-12.25-3.75q-1.188.875-1.313 2.313 1 .625 1 1.688 0 1-.875 1.625l1.625 7.188q.063.438-.219.813t-.781.375h-3.5q-.5 0-.781-.375t-.219-.813l1.625-7.188q-.875-.625-.875-1.625 0-1.125 1-1.688.063-1.625 1.125-2.938l-3-.938q-1.125-.375-1.125-1.438t1.125-1.438L18.562 4.25q1.438-.5 2.875 0zM22.063 19.688l9.063-2.75.875 7.063q0 1.688-3.5 2.844t-8.5 1.156-8.5-1.156-3.5-2.844l.875-7.063 9.063 2.75q2.063.625 4.125 0z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'language' => array(
		'p' => 'M9.5 14.75l.688 2.375H7.813l.688-2.375.5-2.063q.313 1.313.5 2.063zM38.5 6q.625 0 1.063.438t.438 1.063v17q#p#8H21v-20h17.5zM37 13.5v-1q0-.75-.75-.75h-4v-1q0-.75-.75-.75h-1q-.75 0-.75.75v1h-4q-.75 0-.75.75v1q0 .75.75.75h7.125q-.563 1.313-1.875 2.688-.563-.625-1.063-1.313-.438-.563-1-.188l-.875.5q-.688.438-.25 1.063.625.813 1.313 1.625-.75.563-1.625 1.125-.625.375-.25 1l.5.875q.375.688 1.063.25 1.125-.688 2.188-1.563 1 #r#25 1.563.625.438 1-.25l.5-.875q.375-.625-.25-1-.813-.5-1.625-1.125 2-2.188 2.688-4.375h.688q.75 0 .75-.75zm-37-6q0-.625.438-1.063t1.063-.438h17.5v20h-17.5q-.625 0-1.063-.438T0 24.498v-17zM3.688 21q-.063.25 0 .469t.25.375.438.156h1.438q.563 0 .75-.563l.563-1.938h3.75l.563 1.938q.188.563.75.563h1.438q.375 0 .594-.313t.094-.688l-3.563-10.563q-.188-.5-.75-.5h-2q-.563 0-.75.5z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'fax' => array(
		'p' => 'M4 8q.813 0 1.406.594T6 10v20q0 .813-.594 1.406T4 32H2q-.813 0-1.406-.594T0 30V10q0-.813.594-1.406T2 8h2zm26 2q.813 0 1.406.594T32 12v18q0 .813-.594 1.406T30 32H10q-.813 0-1.406-.594T8 30V2q0-.813.594-1.406T10 0h15.188q.813 0 1.375.563l2.875 2.875q.563.563.563 1.375v5.188zM18 27v-2q0-.438-.281-.719T17 24h-2q-.438 0-.719.281T14 25v2q0 .438.281.719T15 28h2q.438 0 .719-.281T18 27zm0-8v-2q0-.438-.281-.719T17 16h-2q-.438 0-.719.281T14 17v2q0 .438.281.719T15 20h2q.438 0 .719-.281T18 19zm8 8v-2q0-.438-.281-.719T25 24h-2q-.438 0-.719.281T22 25v2q0 .438.281.719T23 28h2q.438 0 .719-.281T26 27zm0-8v-2q0-.438-.281-.719T25 16h-2q-.438 0-.719.281T22 17v2q0 .438.281.719T23 20h2q.438 0 .719-.281T26 19zm1-7V6h-2q-.438 0-.719-.281T24 5V3H11v9h16z'
	    ),
	    'building' => array(
		'p' => 'M27.25 30q.75 0 .75.75V32H0v-1.25Q0 30 .75 30H2V1.5q0-.625.438-1.063t1.063-.438h21q.625 0 1.063.438t.438 1.063V30h1.25zM8 4.75v2.5Q8 8 8.75 8h2.5Q12 8 12 7.25v-2.5Q12 4 11.25 4h-2.5Q8 4 8 4.75zm0 6v2.5q0 .75.75.75h2.5q.75 0 .75-.75v-2.5q0-.75-.75-.75h-2.5Q8 10 8 10.75zM11.25 20q.75 0 .75-.75v-2.5q0-.75-.75-.75h-2.5Q8 16 8 16.75v2.5q0 .75.75.75h2.5zM16 30v-5.25q0-.75-.75-.75h-2.5q-.75 0-.75.75V30h4zm4-10.75v-2.5q0-.75-.75-.75h-2.5q-.75 0-.75.75v2.5q0 .75.75.75h2.5q.75 0 .75-.75zm0-6v-2.5q0-.75-.75-.75h-2.5q-.75 0-.75.75v2.5q0 .75.75.75h2.5q.75 0 .75-.75zm0-6v-2.5Q20 4 19.25 4h-2.5Q16 4 16 4.75v2.5q0 .75.75.75h2.5Q20 8 20 7.25z',
		'w' => .875,
		'vw' => 28
	    ),
	    'child' => array(
		'p' => 'M7.5 4.5q0-1.875 1.313-3.188t3.188-1.313 3.188 1.313T16.502 4.5t-1.313 3.188-3.188 1.313-3.188-1.313T7.5 4.5zm15.906.094Q24 5.188 24 6t-.563 1.438l-5.938 5.875v16.688q0 .813-.594 1.406t-1.406.594h-1q-.813 0-1.406-.594t-.594-1.406v-7h-1v7q0 .813-.594 1.406t-1.406.594h-1q-.813 0-1.406-.594t-.594-1.406V13.313L.561 7.438Q-.002 6.813-.002 6t.594-1.406T1.998 4t1.438.563l5.375 5.438h6.375l5.375-5.438Q21.186 4 21.999 4t1.406.594z',
		'w' => .75,
		'vw' => 24
	    ),
	    'paw' => array(
		'p' => 'M16 14q2.375 0 5.25 2.094t4.813 5.063 1.938 5.344q0 1.625-1.188 2.563t-3.313.938q-1.563 0-3.938-.781t-3.563-.781q-1.125 0-3.531.781t-3.969.781q-2.125 0-3.313-.938t-1#q#563q0-2.375 1.938-5.344t4.813-5.063T15.999 14zm-9.187-.812q.5 1.625-.125 3.031t-2 1.719q-.875.188-1.813-.156t-1.656-1.125-1.031-1.844q-.5-1.625.125-3.031t2-1.719 2.688.594 1#r#531zm5.281-1.25q-1.469.375-2.875-.813T7.25 7.906t.063-3.75 2.125-2.094q.938-.25 1.906.219t1.75 1.469 1.156 2.313q.563 2.063-.063 3.781t-2.094 2.094zm17.594-1.875q1.375.313 2 1.719t.125 3.031T30 17.344t-2.688.594-2-1.719-.125-3.031q.313-1.063 1.031-1.844t1.656-1.125 1.813-.156zm-9.75 1.875q-1.5-.375-2.125-2.094t-.063-3.75 1.969-3.219 2.875-#r#094 2.094.063 3.781q-.25 1-.781 1.844t-1.188 1.375-1.406.75-1.438.031z'
	    ),
	    'cube' => array(
		'p' => 'M14.938.375q1.063-.375 2.125 0l13 4.875q.875.375 1.406 1.125T32 8.063v14.063q0 1.875-1.688 2.688l-13 6.5q-1.313.688-2.688 0l-13-6.5q-1.625-.813-1.625-2.688V8.063q0-.938.531-1.688T1.936 5.25zM16 4.25L4 8.75v.125l12 4.875 12-4.875V8.75zm2 22.25l10-5v-8.375L18 17.25v9.25z',
		'w' => .998046875
	    ),
	    'cubes' => array(
		'p' => 'M30.563 15.625q1.438.563 1.438 2.125v6.875q0 1.375-1.25 2l-6.25 3.125q-1 .5-2 0l-6.5-3.25-6.5 3.25q-1 .5-2 0l-6.25-3.125q-1.25-.625-1.25-2V17.75q0-1.563 1.438-2.125l6.063-2.25v-6.75q0-1.563 1.438-2.125l6.25-2.375q.813-.313 1.625 0l6.25 2.375q1.438.563 1.438 2.125v6.75zm-8#q#187V8.875l-5.313 2.25v4.313zM9.625 6.5v.063L16 9.126l6.375-2.563V6.5L16 4.125zm5.25 18.188V20l-5.313 2.438v4.938zm0-7L8.5 15.25l-6.375 2.438L8.5 20.313zm15 7V20l-5.313 2.438v4.938zm0-7L23.5 15.25l-6.375 2.438 6.375 2.625z'
	    ),
	    'recycle' => array(
		'p' => 'M11.563 16.375q.125.625-.438 1.031T10 17.437l-2.5-1.563-3.188 5.063q-.625 1-.063 2.031t1.75 1.031h3.25q.75 0 .75.75v2.5q0 .75-.75.75h-3.25q-2.25 0-3.938-1.5T.092 22.968t.844-4.156l3.188-5.063-2.563-1.625q-.563-.313-.469-.969t.781-.844l6.875-1.563q.375-.125.75.094t.438.656zm6.125-11.437Q17.125 4 16 4t-1.688.938l-1.125 1.813q-.375.625-1.063.25L9.999 5.626q-.625-.375-.188-1l1.125-1.813Q12.686 0 15.999 0t5.063 2.813l2.625 4.125 2.5-1.563q.563-.375 1.125.031t.375 1.031l-1.563 6.875q-.125.438-.469.656t-.719.094l-6.875-1.563q-.688-.188-.781-.844t.469-.969l2.5-1.625zm13.375 13.875q.938 1.438.938 3.094t-.75 3-2.156 2.219-3.094.875h-6v3q0 .688-.625.938t-1.063-.25l-5-5q-.75-.688 0-1.375l5-5q.438-.5 1.063-.25t.625.938v3h6q1.188 0 1.75-1.031t-.063-2.031L26 18.19q-.438-.625.188-1.063l2.125-1.313q.625-.375 1.063.25z'
	    ),
	    'car' => array(
		'p' => 'M31.25 11q.375 0 .594.281t.156.656l-.375 1.5q-.188.563-.75.563h-1.25Q31 15.188 31 17v3q0 1.5-1 2.625V26q0 .813-.594 1.406T28 28h-2q-.813 0-1.406-.594T24 26v-2H8v2q0 .813-.594 1.406T6 28H4q-.813 0-1.406-.594T2 26v-3.375Q1 21.5 1 20v-3q0-1.813 1.375-3h-1.25q-.563 0-.75-.563L0 11.937q-.063-.375.156-.656T.75 11H4.5l1.063-2.625q.375-.938 1.031-1.781t1.5-1.406 1.844-.875T12.001 4h8q2.125 0 3.906 1.188t2.531 3.188l1.063 2.625h3.75zm-22-1.125L8 13h16l-1.25-3.125q-.313-.813-1.094-1.344T20 8h-8q-.875 0-1.656.531T9.25 9.875zM6 20h1.125l.531-.031.531-.094.406-.156.313-.281L9 19q0-.938-1.063-1.969T5.999 16t-1.438.563-.563 1.438.563 1.438 1.438.563zm20 0q.875 0 1.438-.563t.563-1.438-.563-1.438T26 15.998q-.563 0-1.281.5T23.5 17.717t-.5 1.281q0 .25.094.438t.313.281.406.156.531.094.531.031H26z'
	    ),
	    'taxi' => array(
		'p' => 'M28.875 15.125q1.375.25 2.25 1.344T32 19v3q0 2.25-2 3.438v2.563q0 .813-.594 1.406T28 30.001h-2q-.813 0-1.406-.594T24 28.001v-2H8v2q0 .813-.594 1.406T6 30.001H4q-.813 0-1.406-.594T2 28.001v-2.563Q0 24.313 0 22v-3q0-1.438.875-2.531t2.25-1.344L4.5 9.812q.438-1.688 1.781-2.75t3.031-1.063H10v-2q0-.813.594-1.406T12 1.999h8q.813 0 1.406.594T22 3.999v2h.688q1.688 0 3.031 1.063t1.781 2.75zM6 22q.813 0 1.406-.594T8 20t-.594-1.406T6 18t-1.406.594T4 20t.594 1.406T6 22zm1.313-7h17.375l-1.063-4.188q-.063-.313-.375-.563t-.563-.25H9.312q-.75 0-.938.875zM26 22q.813 0 1.406-.594T28 20t-.594-1.406T26 18t-1.406.594T24 20t.594 1.406T26 22z'
	    ),
	    'tree' => array(
		'p' => 'M23.625 23.625q.625.688.25 1.531T22.562 26h-8.563v1.5l1.875 3.063q.25.5-.031.969t-.844.469h-6q-.563 0-.844-.469t-.031-.969L9.999 27.5V26H1.436q-.938 0-1.313-.844t.25-1.531l5-5.625H3.435q-.938 0-1.313-.813t.188-1.5l4.938-5.688H5.435q-.938 0-1.313-.875-.375-.813.25-1.5L11.247.311q.188-.188.375-.25t.375-.063.375.063.375.25l6.875 7.313q.625.688.25 1.5-.375.875-1.313.875h-1.813l4.938 5.688q.563.688.188 1.5T20.559 18h-1.938z',
		'w' => .75,
		'vw' => 24
	    ),
	    'database' => array(
		'p' => 'M28 4.563v2.875q0 1.875-4.094 3.219T14 12.001q-3.813 0-7.031-.625T1.875 9.72 0 7.439V4.564q0-1.875 4.094-3.219T14 .001q3.813 0 7.031.625t5.094 1.656T28 4.563zM28 11v6.438q0 1.875-4.094 3.219T14 22.001t-9.906-1.344T0 17.438V11q4.438 3.063 14 3.063T28 11zm0 10v6.438q0 1.875-4.094 3.219T14 32.001t-9.906-1.344T0 27.438V21q4.438 3.063 14 3.063T28 21z',
		'w' => .875,
		'vw' => 28
	    ),
	    'file-pdf' => array(
		'p' => 'M11.375 16q-.125-.438-.188-1.156t-.063-1.25.125-.531q.375 0 .375 1.25t-.25 1.688zm-.125 2.938q.875 1.625 2.188 2.563-.75.125-3.938 1.375.813-1.5 1.75-3.938zM5.375 26.75q.25-.688 2#q#5-.375.625-.75 1.094t-.625.75-.438.438-.281.188zM15.5 10H24v20.5q#p#8h-21q-.625 0-1.063-.438T-.002 30.5v-29q0-.625.438-1.063t1.063-.438h12.5v8.5q0 .625.438 1.063T15.5 10zM15 20.75q-1.813-1.125-2.688-3.375.75-2.938.438-4-.188-.875-.844-1.219t-1.344-.094-.813.875q-.375 1.375.5 4.813-1.438 3.375-2.563 5.375-1.813.875-3 2.063t-.438 2.188q.5.625 1.375.625 1.563 0 3.813-3.875 3.875-1.25 4.938-1.438 2.25 1.188 4 1.188 1.25 0 1.563-1.063t-.313-1.625q-1-.938-4.625-.438zm8.563-14.187q.438.438.438 1.063v.375h-8v-8h.375q.625 0 1.063.438zM18.938 22.5q-.375.438-2.688-.563 2.688-.063 2.688.563z',
		'w' => .75,
		'vw' => 24
	    ),
	    'file-word' => array(
		'p' => '#j#14v8.5zm3.563 7.5q-.625 0-.688.625-1.375 6.313-1.375 8.063-.125-.938-1.875-8.125Q13.5 16 12.937 16h-1.813q-.625 0-.75.563-1.75 7.188-1.875 7.688-.063-1.688-1.25-7.625-.125-.625-.75-.625H4.936q-.375 0-.594.281t-.094.656l2.313 10.5q.125.563.75.563h2.313q.563 0 .75-.563 1.5-6.188 1.563-6.938H12q.25 1.438 1.563 6.938.188.563.75.563h2.375q.625 0 .75-.563l2.375-10.5q.063-.25-.031-.469t-.281-.344-.438-.125h-1.5zM24 7.625V8h-8V0h.375Q17 0 17.438.438l6.125 6.125q.438.438.438 1.063z',
		'w' => .75,
		'vw' => 24
	    ),
	    'file-excel' => array(
		'p' => '#j#14v8.5zm3.75 6.625q.25-.375.031-.75T17.125 14h-2.188q-.438 0-.625.375l-2.313 4.313q0-.063-2.313-4.313Q9.498 14 9.061 14H6.873q-.438 0-.656.406t.031.781L9.998 21l-3.75 5.875q-.25.375-.031.75t.656.375h2.188q.438 0 .625-.375 2.125-3#r#313-4.313 1.063 2.063 2.25 4.313.25.375.688.375h2.188q.438 0 .656-.375t-.031-.75L14 21zm6.25-7.5V8h-8V0h.375Q17 0 17.438.438l6.125 6.125q.438.438.438 1.063z',
		'w' => .75,
		'vw' => 24
	    ),
	    'file-powerpoint' => array(
		'p' => 'M12.125 16.938q.813 0 1.25.531t.438 1.375-.469 1.375-1.281.531h-1.688v-3.813h1.75zM23.563 6.563q.438.438.438 1.063v.375h-8v-8h.375q.625 0 1.063.438z#j#14v8.5zm3.313 10.313q0-2.063-1.25-3.438T12.75 14H7.687q-.125 0-.281.063t-.25.156-.156.25-.063.281v12.5q0 .313.219.531t.531.219h1.938q.313 0 .531-.219t.219-.531v-3.563h1.688l1.094-.063 1.219-.25 1.094-.531.969-.875.625-1.313.25-1.844z',
		'w' => .75,
		'vw' => 24
	    ),
	    'file-image' => array(
		'p' => 'M24 7.625V8h-8V0h.375Q17 0 17.438.438l6.125 6.125q.438.438.438 1.063zM15.5 10H24v20.5q#p#8h-21q-.625 0-1.063-.438T-.002 30.5v-29q0-.625.438-1.063t1.063-.438h12.5v8.5q0 .625.438 1.063T15.5 10zm-8.469 1q-1.219 0-2.094.875T4.062 14t.875 2.125T7.031 17t2.125-.875.906-2.125-.906-2.125T7.031 11zm13.032 15v-7l-2.5-2.5q-.5-.5-1.063 0L10.062 23l-2.5-2.5q-.5-.5-1 0l-2.5 2.5v3h16z',
		'w' => .75,
		'vw' => 24
	    ),
	    'file-archive' => array(
		'p' => 'M23.563 6.563q.438.438.438 1.063v.375h-8v-8h.375q.625 0 1.063.438zM8.031 21q.531 0 1 .219t.75.625.281.844q0 .688-.594 1.188t-1.438.5-1.438-.5-.594-1.188q0-.438.281-.844t.75-.625 1-.219z#j#8v2h2V0h4v8.5zM6 2v2h2V2H6zm2 24q1.563 0 2.531-1.188t.719-2.75l-1.125-5.438q-.125-.625-.75-.625H8v-2h2v-2H8v-2h2v-2H8v-2h2v-2H8v2H6v2h2v2H6v2h2v2H6v2l-1.188 6.063q-.313 1.5.656 2.719T7.999 26z',
		'w' => .75,
		'vw' => 24
	    ),
	    'file-audio' => array(
		'p' => '#j#14v8.5zm-4 16.75v-8.5q0-.5-.469-.688t-.781.188L6.5 18.5H4.75q-.75 0-.75.75v3.5q0 .75.75.75H6.5l2.25 2.25q.313.375.781.188T10 25.25zm2.063-3q-.625.688-.344 1.5t1.031 1 1.5-.375q1.25-1.313 1.25-3.156t-1.25-3.094q-.688-.688-1.5-.438t-1.031 1 .344 1.5q.438.438.438 1.031t-.438 1.031zm5.375-7.312q-.625-.625-1.469-.375t-1.031 1 .375 1.5q1.688 1.75 1.688 4.188t-1.688 4.188q-.688.688-.375 1.5t1.063.969 1.438-.406q2.563-2.625 2.563-6.281t-2.563-6.281zM24 7.625V8h-8V0h.375Q17 0 17.438.438l6.125 6.125q.438.438.438 1.063z',
		'w' => .75,
		'vw' => 24
	    ),
	    'file-video' => array(
		'p' => 'M24 7.625V8h-8V0h.375Q17 0 17.438.438l6.125 6.125q.438.438.438 1.063z#j#14v8.5zm6 9q0-1-.938-1.375t-1.625.313l-3.438 3.438v-2.375q0-.625-.438-1.063T12.498 16h-7q-.625 0-1.063.438t-.438 1.063v7q0 .625.438 1.063t1.063.438h7q.625 0 1.063-.438t.438-1.063v-2.375l3.438 3.438q.688.688 1.625.313T20 24.502v-7z',
		'w' => .75,
		'vw' => 24
	    ),
	    'file-code' => array(
		'p' => 'M24 7.625V8h-8V0h.375Q17 0 17.438.438l6.125 6.125q.438.438.438 1.063zM15.5 10H24v20.5q#p#8h-21q-.625 0-1.063-.438T-.002 30.5v-29q0-.625.438-1.063t1.063-.438h12.5v8.5q0 .625.438 1.063T15.5 10zM7.688 25.063l1.25-1.313q.063-.125.063-.25 0-.188-.125-.25L6.376 21l2.5-2.25q.125-.063.125-.25 0-.125-.063-.25l-1.25-1.313q-.063-.063-.25-.063-.125 0-.188.063L3.187 20.75q-.125.125-.125.25t.125.25l4.063 3.813q.063.063.188.063.188 0 .25-.063zm3.25 3.125h.063q.25 0 .313-.25l3.875-13.188v-.125q0-.25-.25-.313l-1.75-.5h-.063q-.25 0-.313.25L8.938 27.25v.125q0 .25.25.313zm10-6.938q.125-.125.125-.25t-.125-.25l-4.063-3.813q-.063-.063-.188-.063-.188 0-.25.063l-1.25 1.313q-.063.125-.063.25 0 .188.125.25l2.5 2.25-2.5 2.25q-.125.063-.125.25 0 .125.063.25l1.25 1.313q.063.063.25.063.125 0 .188-.063z',
		'w' => .75,
		'vw' => 24
	    ),
	    'life-ring' => array(
		'p' => 'M16 .5q6.438 0 10.969 4.531T31.5 16t-4.531 10.969T16 31.5 5.031 26.969.5 16 5.031 5.031 16 .5zM26.875 8Q25.625 6.375 24 5.125l-3.938 4q1.75 1.063 2#r#813zM16 22q2.5 0 4.25-1.75T22 16t-1.75-4.25T16 10t-4.25 1.75T10 16t1.75 4.25T16 22zM8 5.125Q6.375 6.375 5.125 8l4 3.938q1.063-1.75 2.813-2.813zM5.125 24Q6.375 25.625 8 26.875l3.938-4q-1.75-1.063-2.813-2.813zM24 26.875q1.625-1.25 2.875-2.875l-4-3.938q-1.063 1.75-2#r#813z'
	    ),
	    'circle-notch' => array(
		'p' => 'M18 2.438q0-.75.563-1.188T19.876 1q5.063 1.313 8.344 5.469T31.501 16q0 4#q#063 7.75t-5.625 5.656-7.75 2.094q-6.438 0-10.969-4.5T.5 16.062q0-5.375 3.281-9.563t8.344-5.5q.688-.188 1.281.25T14 2.437V3.5q0 1.125-1.125 1.438-3.625 1-6 4.063t-2.375 7q0 4.75 3.375 8.125T16 27.501t8.125-3.375 3.375-8.125q0-3.938-2.375-7t-6-4.063Q18 4.625 18 3.5V2.437z',
		'w' => .998046875
	    ),
	    'paper-plane' => array(
		'p' => 'M29.75.188q.813-.438 1.594.094T32 1.751l-4.5 27q-.125.688-.781 1.063t-1.281.063l-7.813-3.25-4 4.813q-.625.813-1.625.469t-1-1.406V25.44L26.063 7.127q.188-.313-.063-.531t-.5-.031L7.562 22.378l-6.625-2.75q-.875-.375-.938-1.313t.75-1.375z',
		'w' => .998046875
	    ),
	    'history' => array(
		'p' => 'M31.5 15.969q0 6.406-4.531 10.969T16 31.501q-5.5 0-9.75-3.438-.5-.438-.531-1.094t.469-1.156l.688-.688q.375-.375.969-.406T8.876 25q3.125 2.5 7.125 2.5 4.75 0 8.125-3.375T27.501 16t-3.375-8.125T16.001 4.5q-4.563 0-7.875 3.125l3.188 3.188q.438.438.188 1.063t-.938.625H1.501q-.438 0-.719-.281t-.281-.719V2.438q0-.688.625-.938t1.063.188l3.125 3.125Q9.814.5 16.002.5q6.438 0 10.969 4.531t4.531 10.938zm-11.312 4.906q-.375.5-1 .594t-1.125-.281L14 18V9.5q0-.625.438-1.063t1.063-.438h1q.625 0 1.063.438t.438 1.063V16l2.563 2q.5.375.563 1t-.313 1.125z'
	    ),
	    'heading' => array(
		'p' => 'M31 5q0 .438-.281.719T30 6h-2.313v20H30q.438 0 .719.281T31 27v2q0 .438-.281.719T30 30H20q-.438 0-.719-.281T19 29v-2q0-.438.281-.719T20 26h2.375v-8H9.625v8H12q.438 0 .719.281T13 27v2q0 .438-.281.719T12 30H2q-.438 0-.719-.281T1 29v-2q0-.438.281-.719T2 26h2.313V6H2q-.438 0-.719-.281T1 5V3q0-.438.281-.719T2 2h10q.438 0 .719.281T13 3v2q0 .438-.281.719T12 6H9.625v8h12.75V6H20q-.438 0-.719-.281T19 5V3q0-.438.281-.719T20 2h10q.438 0 .719.281T31 3v2z'
	    ),
	    'paragraph' => array(
		'p' => 'M25.5 2q.625 0 1.063.438t.438 1.063v2q#p#8H23v21.5q#p#8h-2q-.625 0-1.063-.438t-.438-1.063v-21.5h-2v21.5q#p#8h-2q-.625 0-1.063-.438t-.438-1.063v-6.5q-4.125 0-7.063-2.938T.995 12.001t2.969-7.063T11.12 2h14.375z',
		'w' => .873046875,
		'vw' => 28
	    ),
	    'sliders' => array(
		'p' => 'M31 24q.438 0 .719.281T32 25v2q0 .438-.281.719T31 28H10v1q0 .438-.281.719T9 30H7q-.438 0-.719-.281T6 29v-1H1q-.438 0-.719-.281T0 27v-2q0-.438.281-.719T1 24h5v-1q0-.438.281-.719T7 22h2q.438 0 .719.281T10 23v1h21zm0-10q.438 0 .719.281T32 15v2q0 .438-.281.719T31 18h-5v1q0 .438-.281.719T25 20h-2q-.438 0-.719-.281T22 19v-1H1q-.438 0-.719-.281T0 17v-2q0-.438.281-.719T1 14h21v-1q0-.438.281-.719T23 12h2q.438 0 .719.281T26 13v1h5zm0-10q.438 0 .719.281T32 5v2q0 .438-.281.719T31 8H18v1q0 .438-.281.719T17 10h-2q-.438 0-.719-.281T14 9V8H1q-.438 0-.719-.281T0 7V5q0-.438.281-.719T1 4h13V3q0-.438.281-.719T15 2h2q.438 0 .719.281T18 3v1h13z'
	    ),
	    'share-alt' => array(
		'p' => 'M22 20q2.5 0 4.25 1.75T28 26t-1.75 4.25T22 32t-4.25-1.75T16 26q0-.688.125-1.313l-6.375-4Q8.125 22 6 22q-2.5 0-4.25-1.75T0 16t1.75-4.25T6 10q2.125 0 3.75 1.313l6.375-4Q16 6.688 16 6q0-2.5 1.75-4.25T22 0t4.25 1.75T28 6t-1.75 4.25T22 12q-2.125 0-3.75-1.313l-6.375 4Q12 15.312 12 16t-.125 1.313l6.375 4Q19.875 20 22 20z',
		'w' => .875,
		'vw' => 28
	    ),
	    'share-alt-square' => array(
		'p' => '#b#m-9 13.5q-1.375 0-2.375.938l-4.25-2.563q.125-.438.125-.875t-.125-.875l4.25-2.563q1 .938 2.375.938 1.438 0 2.469-1.031T22.5 10t-1.031-2.469T19 6.5t-2.469 1.031T15.5 10q0 .438.125.875l-4.25 2.563q-1-.938-2.375-.938-1.438 0-2.469 1.031T5.5 16t1.031 2.469T9 19.5q1.375 0 2.375-.938l4.25 2.563q-.125.438-.125.875 0 1.438 1.031 2.469T19 25.5t2.469-1.031T22.5 22t-1.031-2.469T19 18.5z',
		'w' => .875,
		'vw' => 28
	    ),
	    'bomb' => array(
		'p' => 'M27.5 5.5l-3.25 3.25 1.688 1.688q.438.438.438 1.063t-.438 1.063l-1.063 1.063Q26 16.19 26 19.002q0 5.375-3.813 9.188t-9.188 3.813-9.188-3.813-3.813-9.188 3.813-9.188 9.188-3.813q2.813 0 5.375 1.125l1.063-1.063q.438-.438 1.063-.438t1.063.438l1.625 1.688 3.25-3.25zm3.75-1.75q.75 0 .75.75t-.75.75h-1.5q-.75 0-.75-.75t.75-.75h1.5zM27.5 0q.75 0 .75.75v1.5q0 .75-.75.75t-.75-.75V.75q0-.75.75-.75zm2.125 3.438q-.5.563-1.063 0t0-1.063l1.063-1.063q.5-.563 1.031 0t.031 1.063zm-4.25 0l-1.063-1.063q-.5-.5.031-1.063t1.031 0l1.063 1.063q.563.5.031 1.063t-1.094 0zm4.25 2.125l1.063 1.063q.5.563-.031 1.094t-1.031-.031l-1.063-1.063q-.563-.5-.031-1.063t1.094 0zM7 17q0-1.625 1#q#813t2.813-1.188q.438 0 .719-.281t.281-.719-.281-.719-.719-.281q-2.5 0-4.25 1.75t-1.75 4.25q0 .438.281.719t.719.281.719-.281.281-.719z'
	    ),
	    'futbol' => array(
		'p' => 'M31.5 16q0 6.438-4.531 10.969T16 31.5 5.031 26.969.5 16 5.031 5.031 16 .5t10.969 4.531T31.5 16zm-3 0l-1.625 1.375-3.938-3.625L24 8.5l2.125.188q-2.438-3.375-6.313-4.563l.875 1.938-4.688 2.625-4.688-2.625.875-1.938Q8.311 5.313 5.873 8.688L8.061 8.5l1 5.25-3.938 3.625L3.498 16q0 4.125 2.375 7.375l.5-2.125 5.313.688 2.313 4.813-1.875 1.125q3.875 1.25 7.75 0l-1.875-1.125 2.313-4.813 5.313-.688.5 2.125Q28.5 20.125 28.5 16zM13 20.375l-1.875-5.75 4.875-3.5 4.875 3.5L19 20.375h-6z'
	    ),
	    'tty' => array(
		'p' => 'M.313 6.5q4.25-4.25 9.969-5.781t11.438 0T31.689 6.5q.625.625.125 1.438l-2.688 4.313q-.313.5-1 .5-.188 0-.375-.063L22.313 10.5q-.688-.25-.688-1.063v-.063L22 5.624q-6-2.188-12 0l.375 3.75v.063q0 .813-.688 1.063l-5.438 2.188q-.188.063-.375.063-.688 0-1-.5L.186 7.938q-.188-.313-.188-.625 0-.5.313-.813zM6 19.25q0 .75-.75.75h-2.5Q2 20 2 19.2#m#5zm6 0q0 .75-.75.75h-2.5Q8 20 8 19.2#m#5zm6 0q0 .75-.75.75h-2.5q-.75 0-.75-.7#m#5zm6 0q0 .75-.75.75h-2.5q-.75 0-.75-.7#m#5zm6 0q0 .75-.75.75h-2.5q-.75 0-.75-.7#m#5zm-21 6q0 .75-.75.75h-2.5Q5 26 5 25.2#m#5zm6 0q0 .75-.75.75h-2.5q-.75 0-.75-.7#m#5zm6 0q0 .75-.75.75h-2.5q-.75 0-.75-.7#m#5zm6 0q0 .75-.75.75h-2.5q-.75 0-.75-.7#m#5zm-21 6q0 .75-.75.75h-2.5Q2 32 2 31.2#m#5zm18 0q0 .75-.75.75H8.75Q8 32 8 31.25v-2.5q0-.75.75-.75h14.5q.75 0 .75.75v2.5zm6 0q0 .75-.75.75h-2.5q-.75 0-.75-.7#m#5z'
	    ),
	    'binoculars' => array(
		'p' => 'M26 3v3h-6V3q0-.438.281-.719T21 2h4q.438 0 .719.281T26 3zM4 10q0-.813.594-1.406T6 8h6v10h-2v10q0 .813-.594 1.406T8 30H2q-.813 0-1.406-.594T0 28v-2.75q.063-2.25.469-4.094t.969-3.125 1.125-2.438.969-2.563.469-3.031zm24 0q.063 1.938.656 3.719t1.313 3.063 1.344 3.5.688 4.969v2.75q0 .813-.594 1.406t-1.406.594h-6q-.813 0-1.406-.594t-.594-1.406v-10h-2v-10h6q.563 0 1 .281t.719.719.281 1zM11 2q.438 0 .719.281T12 3v3H6V3q0-.438.281-.719T7 2h4zm3 16V8h4v10h-4z'
	    ),
	    'plug' => array(
		'p' => 'M16 9V2q0-.813.594-1.406T18 0t1.406.594T20 2v7h-4zm7 1q.438 0 .719.281T24 11v2q0 .438-.281.719T23 14h-1v2q0 3.625-2.281 6.375T14 25.813v6.188h-4v-6.188q-3.438-.688-5.719-3.438T2 16v-2H1q-.438 0-.719-.281T0 13v-2q0-.438.281-.719T1 10h22zM8 9H4V2q0-.813.594-1.406T6 0t1.406.594T8 2v7z',
		'w' => .75,
		'vw' => 24
	    ),
	    'newspaper' => array(
		'p' => 'M34.5 4q.625 0 1.063.438t.438 1.063v19.5q0 1.25-.875 2.125t-2.125.875h-29.5q-1.438 0-2.469-1.031T.001 24.501v-17q0-.625.438-1.063T1.502 6h2.5v-.5q0-.625.438-1.063t1.063-.438h29zm-31 21q.5 0 .5-.5V9H3v15.5q0 .5.5.5zm14.75-1q.75 0 .75-.75v-.5q0-.75-.75-.75h-9.5Q8 22 8 22.75v.5q0 .75.75.75h9.5zm13 0q.75 0 .75-.75v-.5q0-.75-.75-.75h-9.5q-.75 0-.75.75v.5q0 .75.75.75h9.5zm-13-6q.75 0 .75-.75v-.5q0-.75-.75-.75h-9.5Q8 16 8 16.75v.5q0 .75.75.75h9.5zm13 0q.75 0 .75-.75v-.5q0-.75-.75-.75h-9.5q-.75 0-.75.75v.5q0 .75.75.75h9.5zm0-6q.75 0 .75-.75v-2.5Q32 8 31.25 8H8.75Q8 8 8 8.75v2.5q0 .75.75.75h22.5z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'wifi' => array(
		'p' => 'M39.688 9.688q.313.25.313.688t-.313.75l-2.125 2.125q-.688.688-1.375 0Q29.313 7.001 20 7.001t-16.188 6.25q-.688.688-1.375 0L.312 11.126q-.313-.313-.313-.75t.313-.688Q5.75 4.625 12.875 2.844t14.25 0 12.563 6.844zM20 22q1.688 0 2.844 1.156T24 26t-1.156 2.844T20 30t-2.844-1.156T16 26t1.156-2.844T20 22zm12.688-5.25q.313.313.313.75t-.313.75l-2.125 2.125q-.688.625-1.375 0Q25.25 17 20 17t-9.188 3.375q-.688.625-1.375 0L7.312 18.25q-.313-.313-.313-.75t.313-.75Q12.75 12 20 12t12.688 4.75z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'calculator' => array(
		'p' => 'M25 0q1.188 0 2.094.906T28 3v26q0 1.188-.906 2.094T25 32H3q-1.188 0-2.094-.906T0 29V3Q0 1.812.906.906T3 0h22zM8 27.188v-2.375q0-.313-.25-.563T7.187 24H4.812q-.313 0-.563.25t-.25.563v2.375q0 .313.25.563t.563.25h2.375q.313 0 .563-.25t.25-.563zm0-8v-2.375q0-.313-.25-.563T7.187 16H4.812q-.313 0-.563.25t-.25.563v2.375q0 .313.25.563t.563.25h2.375q.313 0 .563-.25t.25-.563zm8 8v-2.375q0-.313-.25-.563t-.563-.25h-2.375q-.313 0-.563.25t-.25.563v2.375q0 .313.25.563t.563.25h2.375q.313 0 .563-.25t.25-.563zm0-8v-2.375q0-.313-.25-.563t-.563-.25h-2.375q-.313 0-.563.25t-.25.563v2.375q0 .313.25.563t.563.25h2.375q.313 0 .563-.25t.25-.563zm8 8V16.813q0-.313-.25-.563t-.563-.25h-2.375q-.313 0-.563.25t-.25.563v10.375q0 .313.25.563t.563.25h2.375q.313 0 .563-.25t.25-.563zm0-16V4.813q0-.313-.25-.563T23.187 4H4.812q-.313 0-.563.25t-.25.563v6.375q0 .313.25.563t.563.25h18.375q.313 0 .563-.25t.25-.563z',
		'w' => .875,
		'vw' => 28
	    ),
	    'bell-slash' => array(
		'p' => 'M39.625 28.625q.75.625.188 1.438l-1.25 1.563q-.625.75-1.375.188L.375 3.376q-.75-.625-.188-1.438L1.437.375q.625-.75 1.375-.188l9.063 7Q14.188 4.124 18 3.312V1.999q0-.813.594-1.406T20-.001t1.406.594T22 1.999v1.313q3.5.688 5.75 3.375T30 13q0 2.75.625 4.844t1.156 2.844 1.469 1.688q.125.188.188.25.563.625.563 1.375 0 .063-.031.156l-.031.094zM9.813 15.75L23.126 26H8.001q-.563 0-1.031-.281t-.719-.75-.25-.969q0-.75.563-1.375.875-.938 1.25-1.375t1.063-2 .938-3.5zM20 32q-1.625 0-2.813-1.156T15.999 28h8q0 1.063-.531 2t-1.469 1.469-2 .531z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'trash' => array(
		'p' => 'M27 2q.438 0 .719.281T28 3v2q0 .438-.281.719T27 6H1q-.438 0-.719-.281T0 5V3q0-.438.281-.719T1 2h7.5L9.063.812q.438-.813 1.375-.813h7.125q.938 0 1.375.813L19.501 2h7.5zM3.313 29.188L2 8h24l-1.313 21.188q-.063 1.188-.938 2t-2.063.813H6.311q-1.188 0-2.063-.813t-.938-2z',
		'w' => .875,
		'vw' => 28
	    ),
	    'copyright' => array(
		'p' => '#e#7.313 21.688q.188-.25.188-.5t-.125-.438l-1.563-2.125q-.188-.25-.563-.281t-.563.219l-.219.219-.563.438-.844.531-1.125.438-1.375.188q-2.188 0-3.406-1.5t-1.219-3.5q0-2.063 1.25-3.406t3.375-1.344q2.25 0 3.875 1.5.25.25.594.188t.531-.313l1.375-2.188q.125-.188.125-.375 0-.313-.188-.563l-.156-.156-.438-.344-.688-.469-.906-.5-1.188-.469-1.438-.313L16.434 7q-3.875 0-6.438 2.563t-2.563 6.375q0 2.563 1.125 4.625t3.219 3.25 4.656 1.188q2 0 3.75-.75t2.281-1.25.844-.813z'
	    ),
	    'at' => array(
		'p' => 'M16 .5q6.625 0 11.063 3.875T31.501 14.5q0 3.938-2.313 6.563t-7.063 2.625q-.938 0-1.438-.031t-1.219-.219-1.156-.656-.625-1.219q-.813 1.063-2.125 1.75t-2.563.688q-2.75 0-4.375-1.781t-1.625-4.844q0-4.125 2.531-6.813t6.094-2.688q2.625 0 3.75 1.375.063-.75.813-.75H23q.75 0 1.188.531t.313 1.281l-1.5 7.563q-.188.813-.031 1.313t.906.563q1.625-.188 2.625-1.75t1-3.5q0-4.625-3.313-7.313T16 4.5q-4.75 0-8.125 3.375T4.5 16t3.375 8.125T16 27.5q3.375 0 6.188-1.813.5-.313 1.063-.219t.938.531l.625.75q.438.563.313 1.219t-.688 1.031q-3#r#5-8.438 2.5-6.438 0-10.969-4.531T.501 15.999 5.032 5.03 16.001.499zm-1.375 19q1.313 0 2.469-1.281T18.25 15q0-1.188-.563-1.875t-1.625-.688q-1.438 0-2.563 1.281t-1.125 3.281q0 1.188.625 1.844t1.625.656z'
	    ),
	    'eye-dropper' => array(
		'p' => 'M3.188 20.813l7.875-7.875 8 8-7.875 7.875Q10 30.001 8.313 30.001H5.5l-3.5 2-2-2 2-3.5v-2.813Q2 22 3.188 20.813zM30.25 1.75Q32 3.5 32 6t-1.75 4.25l-4.813 4.813.813.813q.438.438.438 1.063t-.438 1.063l-2.563 2.563q-.438.438-1.063.438t-1.063-.438L11.436 10.44q-.438-.438-.438-1.063t.438-1.063l2.563-2.563q.438-.438 1.063-.438t1.063.438l.813.813 4.813-4.813q1.75-1.75 4.25-1.75t4.25 1.75z'
	    ),
	    'paint-brush' => array(
		'p' => 'M10.438 19.313l5.5 4.625.031.219.031.344q0 3.5-2.188 5.5t-5.813 2q-4 0-6-2.75t-2-6.938q.125.125.5.406t.781.563.844.563.781.469.531.188q.688 0 .938-.625 1.625-4.25 6.063-4.563zM28.625 0Q30 0 31 .875t1 2.25Q32 4.313 31.125 6q-5.313 9.938-7.813 12.969T17.937 22q-.625 0-1.375-.188l-4-3.313q-.563-1.188-.563-2.438 0-.563.031-1t.281-.938.5-.875.875-1.094 1.25-1.281 1.844-1.656 2.375-2.063 3.125-2.719T26.124.997q1.125-1 2.5-1z'
	    ),
	    'birthday-cake' => array(
		'p' => 'M28 24q-.75 0-1.969-1t-2.688-1-2.688 1-1.969 1-1.969-1-2.719-1q-1.438 0-2.688 1t-1.938 1q-.813 0-2.031-1t-2.688-1-2.688 1-1.969 1v-5q0-1.25.875-2.125T2.996 16h1V7h4v9h4V7h4v9h4V7h4v9h1q1.25 0 2.125.875T27.996 19v5zm0 8H0v-6q1.5 0 2.719-1t1.969-1 1.969 1 2.688 1 2.688-1 1.969-1 1.969 1 2.688 1 2.688-1 2.031-1q.688 0 1.906 1t2.719 1v6zM6 6q-.813 0-1.406-.594T4 4q0-.875 1-1.75T6 0q.625 0 1.313 1.156T8.001 3.5t-.563 1.844T6 6zm8 0q-.813 0-1.406-.594T12 4q0-.875 1-1.75T14 0q.625 0 1.313 1.156t.688 2.344-.563 1.844T14 6zm8 0q-.813 0-1.406-.594T20 4q0-.875 1-1.75T22 0q.625 0 1.313 1.156t.688 2.344-.563 1.844T22 6z',
		'w' => .875,
		'vw' => 28
	    ),
	    'chart-area' => array(
		'p' => 'M31.25 24q.75 0 .75.75v2.5q0 .75-.75.75H.75Q0 28 0 27.25V4.75Q0 4 .75 4h2.5Q4 4 4 4.75V24h27.25zm-7.937-14q.25-.25.594-.156t.469.406L30.001 22h-24v-6.5l5.438-9.063q.188-.313.594-.344t.656.281l5.313 7.125z'
	    ),
	    'chart-pie' => array(
		'p' => 'M33 18q.438 0 .75.344t.25.781q-.75 5.188-4.563 8.813-.688.625-1.375-.063L18.124 18h14.875zm-1-4.062q0 .438-.281.75t-.719.313H17v-14q0-.438.313-.719t.75-.281q5.563.375 9.563 4.375t4.375 9.563zM14 18l9.75 9.75q.313.313.281.781t-.406.719q-3.75 2.688-8.438 2.75-6 .063-10.5-4.219T-.001 17.5Q-.189 11.75 3.53 7.344t9.344-5.156q.438-.063.781.219t.344.781v14.813z',
		'w' => 1.0625,
		'vw' => 34
	    ),
	    'chart-line' => array(
		'p' => 'M31 24q.438 0 .719.281T32 25v2q0 .438-.281.719T31 28H2q-.813 0-1.406-.594T0 26V5q0-.438.281-.719T1 4h2q.438 0 .719.281T4 5v19h27zM29 6q.438 0 .719.281T30 7v7.375q0 1-.938 1.375t-1.625-.313l-2-2-6 6q-.625.563-1.438.563t-1.438-.563l-4.563-4.625-2.875 2.875q-.688.75-1.438 0L6.31 16.312q-.75-.75 0-1.438l4.25-4.313q.625-.563 1.438-.563t1.438.563l4.563 4.625 4.563-4.625-2-2q-.688-.688-.313-1.625t1.375-.938h7.375z'
	    ),
	    'toggle-off' => array(
		'p' => 'M24 4q5 0 8.5 3.5T36 16t-3.5 8.5T24 28H12q-5 0-8.5-3.5T0 16t3.5-8.5T12 4h12zM4 16q0 3.313 2.344 5.656T12 24t5.656-2.344T20 16t-2.344-5.656T12 8t-5.656 2.344T4 16zm20 8q3.313 0 5.656-2.344T32 16t-2.344-5.656T24 8h-3.063Q24 11.438 24 16t-3.063 8H24z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'toggle-on' => array(
		'p' => 'M24 4q5 0 8.5 3.5T36 16t-3.5 8.5T24 28H12q-5 0-8.5-3.5T0 16t3.5-8.5T12 4h12zm0 20q3.313 0 5.656-2.344T32 16t-2.344-5.656T24 8t-5.656 2.344T16 16t2.344 5.656T24 24z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'bicycle' => array(
		'p' => 'M32.063 12q3.313 0 5.656 2.406T40 20.125t-2.406 5.625T31.938 28q-3.25-.063-5.594-2.406T24 20q0-3.5 2.563-5.875l-.938-1.5-5.375 8.688q-.438.688-1.25.688h-3.25q-.688 2.625-2.844 4.313T8 28.002q-3.313 0-5.656-2.344T0 19.939q0-3.25 2.375-5.594T8 12.001q1.438 0 2.688.5l1.875-3H9.5q-.625 0-1.063-.438T7.999 8q0-.375.219-.719t.563-.563.781-.219H15q.438 0 .719.281t.281.719v1h7.125l-.938-1.5h-3.188q-.438 0-.719-.281t-.281-.719v-1q0-.438.281-.719t.719-.281h4q.813 0 1.25.688l4.875 7.813q1.375-.5 2.938-.5zm-20.375 4.625L10.188 19h2.688q-.25-1.375-1#q#375zM8 25q1.5 0 2.75-.813t1.813-2.188H7.5q-.875 0-1.313-.781t.063-1.531l2.813-4.563q-.5-.125-1.063-.125-2.063 0-3.531 1.469T3 19.999t1.469 3.531T8 24.999zm10.188-6l4.625-7.5h-8l-1.5 2.5q2.25 2 2.625 5h2.25zm13.562 6q2.125.125 3.688-1.375T37.001 20q0-2.063-1.469-3.531T32.001 15q-.625 0-1.25.125l2.813 4.5q.188.375.094.781t-.469.594l-.813.563q-.375.188-.781.094t-.594-.469l-2.813-4.438q-1.25 1.5-1.188 3.438t1.438 3.313 3.313 1.5z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'bus' => array(
		'p' => 'M30.5 8q.625 0 1.063.438t.438 1.063v5q#p#8H30v10.375q0 .688-.438 1.156t-1.188.469h-.375v2q0 .813-.594 1.406t-1.406.594h-2q-.813 0-1.406-.594t-.594-1.406v-2h-12v2q0 .813-.594 1.406t-1.406.594h-2q-.813 0-1.406-.594t-.594-1.406v-2q-.813 0-1.406-.594t-.594-1.406v-10h-.5q-.625 0-1.063-.438t-.438-1.063v-5q0-.625.438-1.063T1.499 8h.5V5q0-2.125 4.063-3.563T16-.001t9.938 1.438T30.001 5v3h.5zM7 25q.813 0 1.406-.594T9 23t-.594-1.406T7 21t-1.406.594T5 23t.594 1.406T7 25zm1-7h16q.813 0 1.406-.594T26 16V8q0-.813-.594-1.406T24 6H8q-.813 0-1.406.594T6 8v8q0 .813.594 1.406T8 18zm17 7q.813 0 1.406-.594T27 23t-.594-1.406T25 21t-1.406.594T23 23t.594 1.406T25 25z'
	    ),
	    'closed-captioning' => array(
		'p' => 'M29 4q1.25 0 2.125.875T32 7v18q0 1.25-.875 2.125T29 28H3q-1.25 0-2.125-.875T0 25V7q0-1.25.875-2.125T3 4h26zM13.625 18q-1.938 1.688-3.844.969t-1.906-3.031q0-2.125 2-2.781t3.875.844q.375.25.625-.125l1.063-1.875q.125-.188-.063-.375-1.563-1.563-4.125-1.656t-4.594 1.531-2.031 4.5q0 2.938 1.969 4.625t4.563 1.531 4.219-1.906q.25-.25.063-.5l-1.25-1.688q-.25-.375-.563-.063zM25.5 18q-1.875 1.688-3.813.969t-1.938-3.031q0-2.125 2-2.781t3.938.844q.313.25.563-.125l1.125-1.875q.063-.188-.125-.375-1.563-1.563-4.125-1.656t-4.594 1.531-2.031 4.5q0 2.938 2 4.625t4.563 1.531 4.25-1.906q.188-.25 0-.5l-1.188-1.688q-.25-.375-.625-.063z'
	    ),
	    'shekel-sign' => array(
		'p' => 'M15.5 10.5q0-1.438-1.031-2.469T12 7H5v22q0 .438-.281.719T4 30H1q-.438 0-.719-.281T0 29V3.5q0-.625.438-1.063t1.063-.438h10.5q3.5 0 6 2.5t2.5 6v10.5q0 .438-.281.719t-.719.281h-3q-.438 0-.719-.281t-.281-.719v-10.5zM27 2q.438 0 .719.281T28 3v18.5q0 3.5-2.5 6t-6 2.5H9q-.625 0-1.063-.438t-.438-1.063v-17.5q0-.438.281-.719t.719-.281h3q.438 0 .719.281t.281.719v14h7q1.438 0 2.469-1.031t1.031-2.469v-18.5q0-.438.281-.719t.719-.281h3z',
		'w' => .875,
		'vw' => 28
	    ),
	    'cart-plus' => array(
		'p' => 'M31.563 20H13.25l.375 2h16.813q.688 0 1.125.563t.313 1.25l-.375 1.563q2 .938 2 3.125 0 1.438-1.031 2.469t-2.531 1.031q-1.375 0-2.375-1t-1.063-2.375q-.063-1.563 1.063-2.625H14.439q1.063 1 1.063 2.5t-1.094 2.531-2.594.969q-1.313-.063-2.281-1.031t-1.031-2.281q0-.688.188-1.313t.594-1.094.969-.844L5.878 4H1.503Q.878 4 .44 3.562T.002 2.499v-1Q.002.874.44.436t1.063-.438h6.438q.313 0 .625.156t.531.438.281.594l.563 2.813h24.563q.75 0 1.188.563t.25 1.25l-2.938 13Q32.754 20 31.566 20zM25.5 10.5h-3V8q0-.438-.281-.719T21.5 7h-1q-.438 0-.719.281T19.5 8v2.5h-3q-.438 0-.719.281t-.281.719v1q0 .438.281.719t.719.281h3V16q0 .438.281.719T20.5 17h1q.438 0 .719-.281T22.5 16v-2.5h3q.438 0 .719-.281t.281-.719v-1q0-.438-.281-.719T25.5 10.5z',
		'w' => 1.123046875,
		'vw' => 36
	    ),
	    'cart-arrow-down' => array(
		'p' => 'M31.563 20H13.25l.375 2h16.813q.688 0 1.125.563t.313 1.25l-.375 1.563q2 .938 2 3.125 0 1.438-1.031 2.469t-2.531 1.031q-1.375 0-2.375-1t-1.063-2.375q-.063-1.563 1.063-2.625H14.439q1.063 1 1.063 2.5t-1.094 2.531-2.594.969q-1.313-.063-2.281-1.031t-1.031-2.281q0-.688.188-1.313t.594-1.094.969-.844L5.878 4H1.503Q.878 4 .44 3.562T.002 2.499v-1Q.002.874.44.436t1.063-.438h6.438q.313 0 .625.156t.531.438.281.594l.563 2.813h24.563q.75 0 1.188.563t.25 1.25l-2.938 13Q32.754 20 31.566 20zm-6.375-8H22.5V8.25q0-.75-.75-.75h-1.5q-.75 0-.75.75V12h-2.688q-.5 0-.688.469t.125.781l4.25 4.25q.5.5 1 0l4.25-4.25q.313-.313.125-.781T25.186 12z',
		'w' => 1.123046875,
		'vw' => 36
	    ),
	    'ship' => array(
		'p' => 'M31.063 23.313q.875 2.125 2.781 3.406T38.5 28q.625 0 1.063.438t.438 1.063v1q#p#8q-5.5 0-8.938-3.688-.688 1.625-2.188 2.656t-3.375 1.031h-8q-1.25 0-2.344-.469t-1.938-1.313-1.281-1.906q-3.438 3.688-8.938 3.688-.625 0-1.063-.438T-.003 30.5v-1q0-.625.438-1.063t1.063-.438q2.75 0 4.688-1.281t2.75-3.406l-4.375-4.375q-.75-.813-.5-1.906t1.313-1.406l2.625-.875V6q0-.813.594-1.406T9.999 4h4V1.5q0-.625.438-1.063T15.5-.001h9q.625 0 1.063.438t.438 1.063V4h4q.813 0 1.406.594T32.001 6v8.75l2.625.875q1.063.313 1.313 1.406t-.5 1.906zM12 8v5.5l7.375-2.375Q19.688 11 20 11t.625.125L28 13.5V8H12z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'user-secret' => array(
		'p' => 'M24 19.25q1.813 1.125 2.906 3.031T28 26.375v2.813q0 1.188-.813 2t-2 .813H2.812q-1.188 0-2-.813t-.813-2v-2.813q0-2.25 1.156-4.188t3.031-3.063l-1.563-3.75q-.25-.5.063-.938t.813-.438h3.625q-1.125-1.938-1.125-4-4-.813-4-2 0-1.25 4.375-2.063.875-3.063 2.563-5.188.438-.563 1.125-.719t1.313.156l1.75.875q.875.438 1.75 0l1.75-.875q.625-.313 1.313-.156t1.125.719q1.688 2.125 2.563 5.188 4.375.813 4.375 2.063 0 1.188-4 2 0 2.063-1.125 4h3.688q.5 0 .813.438t.125.938zM11 30l2-7.5-1.5-2.5-3.125-2zm6 0l2.625-12-3.125 2-1.5 2.5zm2.625-18.625q0-.188.375-.375v-.688q-2.75.375-6 .375-3.125 0-6-.375V11h.063q.313.188.313.375.563 1.563 1.063 2.063.25.188.688.375t1.063.188 1.25-.531 1-1.594q.125-.375.563-.375t.563.375q.438 1.313 1.344 1.781t1.594.313 1.063-.531q.5-.438 1.063-2.063z',
		'w' => .875,
		'vw' => 28
	    ),
	    'motorcycle' => array(
		'p' => 'M32.063 12q3.25 0 5.594 2.344t2.344 5.594q.063 3.375-2.313 5.75t-5.75 2.313q-3.25 0-5.594-2.344T24 20.063q0-3.688 2.813-6.125L26 12.625q-1.188.938-2 2.219t-1.188 2.688-.313 2.906q.063.625-.406 1.094t-1.094.469h-5.25q-.688 2.625-2.844 4.313t-4.906 1.688q-3.375 0-5.719-2.406t-2.281-5.781q.063-3.188 2.313-5.438t5.375-2.375q1.375-.063 2.563.313l.75-1.25q-1-1.563-3-1.563H4.5q-.625 0-1.063-.438t-.438-1.063.438-1.063T4.5 6.5H8q4.313 0 6.25 2.5h9.625l-1.25-2H18.5q-.438 0-.719-.281T17.5 6V5q0-.438.281-.719T18.5 4h5q.875 0 1.313.75l1.375 2.375L28.563 4.5q.438-.5 1.125-.5h2.813q.625 0 1.063.438t.438 1.063v2q#p#8h-5.125l2 3.438q1.313-.438 2.688-.438zM8 25q1.5 0 2.75-.844T12.563 22H7.5q-.875 0-1.313-.75t0-1.5l2.563-4.688q-.313-.063-.75-.063-2.063 0-3.531 1.469T3 19.999t1.469 3.531T8 24.999zm29-4.75q.125-2.125-1.375-3.688T32 14.999q-.5 0-1 .125l3.063 5.063q.188.313.094.719t-.469.656l-.813.5q-.375.188-.781.094t-.594-.469l-3.125-5.125Q27 18 27 20q0 2.125 1.563 3.625T32.251 25q1.938-.125 3.281-1.469t1.469-3.281z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'street-view' => array(
		'p' => 'M23 20.625q4.063.75 6.531 2.188T32 26.001q0 2.5-4.688 4.25t-11.313 1.75-11.313-1.75-4.688-4.25q0-1.75 2.469-3.188t6.531-2.188q.5.563 1 .813v1.438q-2.063.313-3.656.781T3.873 24.72t-.875 1.281q0 1.438 3#r#469t9.188 1.031 9.188-1.031T29 26.001q0-1-1.906-1.844T22 22.876v-1.438q.5-.25 1-.813zM16 8q-1.688 0-2.844-1.156T12 4t1.156-2.844T16 0t2.844 1.156T20 4t-1.156 2.844T16 8zm-4 12q-.813 0-1.406-.594T10 18v-6q0-1.25.875-2.125T13 9h.75q1.063.5 2.25.5t2.25-.5H19q1.25 0 2.125.875T22 12v6q0 .813-.594 1.406T20 20v6q0 .813-.594 1.406T18 28h-4q-.813 0-1.406-.594T12 26v-6z'
	    ),
	    'heartbeat' => array(
		'p' => 'M20 15.25L21.375 18h6.813L16.813 29.625q-.375.375-.844.375t-.781-.375L3.813 18h5.875l1.875-4.5 3.563 7.938q.25.563.875.563t.875-.563zm9.625-10.625q2.25 2.313 2.375 5.594T30.062 16h-7.438l-1.75-3.438q-.25-.563-.875-.563t-.875.563l-3.063 6.125-3.625-8.125q-.313-.563-.969-.563t-.906.625l-2.25 5.375H1.936q-2.063-2.5-1.938-5.781t2.375-5.594l.188-.125q2.375-2.5 5.813-2.5t5.875 2.5l1.75 1.75 1.75-1.813q2.438-2.438 5.875-2.438t5#r#438z'
	    ),
	    'venus' => array(
		'p' => 'M18 11q0 3.188-1.969 5.625T11 19.75V23h2.25q.75 0 .75.75v2.5q0 .75-.75.75H11v2.25q0 .75-.75.75h-2.5Q7 30 7 29.25V27H4.75Q4 27 4 26.25v-2.5q0-.75.75-.75H7v-3.25q-3.063-.688-5.031-3.125T0 11q0-3.75 2.625-6.375T9 2t6.375 2.625T18 11zM4 11q0 2.063 1.469 3.531T9 16t3.531-1.469T14 11t-1.469-3.531T9 6 5.469 7.469 4 11z',
		'w' => .5625,
		'vw' => 18
	    ),
	    'mars' => array(
		'p' => 'M23.25 4q.75 0 .75.75v4.938q0 .5-.469.688t-.781-.125l-1.063-1.063-5.063 5q1.375 2.188 1.375 4.813 0 3.75-2.625 6.375t-6.375 2.625-6.375-2.625-2.625-6.375 2.625-6.375 6.375-2.625q2.625 0 4.813 1.375l5-5.063-1.063-1.063q-.313-.313-.125-.781T18.312 4h4.938zM9 24q2.063 0 3.531-1.469T14 19t-1.469-3.531T9 14t-3.531 1.469T4 19t1.469 3.531T9 24z',
		'w' => .75,
		'vw' => 24
	    ),
	    'mercury' => array(
		'p' => 'M18 13q0 3.188-1.969 5.625T11 21.75V25h2.25q.75 0 .75.75v2.5q0 .75-.75.75H11v2.25q0 .75-.75.75h-2.5Q7 32 7 31.25V29H4.75Q4 29 4 28.25v-2.5q0-.75.75-.75H7v-3.25q-3.063-.688-5.031-3.125T0 13q0-4.188 3.188-6.875-.25-.188-.438-.375Q.375 3.75.062.812-.001.499.218.249t.594-.25h2.5q.625 0 .75.625.25 1.188 1.313 2.125Q6.813 3.999 9 3.999t3.625-1.25q1.063-.938 1.313-2.125.125-.625.75-.625h2.5q.375 0 .594.25t.156.563Q17.625 3.75 15.25 5.75q-.25.25-.438.375Q18 8.813 18 13zM4 13q0 2.063 1.469 3.531T9 18t3.531-1.469T14 13t-1.469-3.531T9 8 5.469 9.469 4 13z',
		'w' => .5625,
		'vw' => 18
	    ),
	    'transgender' => array(
		'p' => 'M23.25 0Q24 0 24 .75v4.938q0 .5-.469.688t-.781-.125l-1.063-1.063-5.063 5q1.375 2.188 1.375 4.813 0 3.188-1.969 5.625t-5.031 3.125v1.75h2.25q.75 0 .75.75v2.5q0 .75-.75.75h-2.25v1.75q0 .75-.75.75h-2.5q-.75 0-.75-.75v-1.75h-2.25q-.75 0-.75-.75v-2.5q0-.75.75-.75h2.25v-1.75q-3.063-.688-5.031-3.125t-1.969-5.625q0-3.75 2.625-6.375t6.375-2.625q2.625 0 4.813 1.375l5-5.063-1.063-1.063q-.313-.313-.125-.781T18.312 0h4.938zM9 20q2.063 0 3.531-1.469T14 15t-1.469-3.531T9 10t-3.531 1.469T4 15t1.469 3.531T9 20z',
		'w' => .75,
		'vw' => 24
	    ),
	    'transgender-alt' => array(
		'p' => 'M29.25 0Q30 0 30 .75v4.938q0 .5-.469.688t-.781-.125l-1.063-1.063-5.063 5q1.375 2.188 1.375 4.813 0 3.188-1.969 5.625t-5.031 3.125v1.75h2.25q.75 0 .75.75v2.5q0 .75-.75.75h-2.25v1.75q0 .75-.75.75h-2.5q-.75 0-.75-.75v-1.75h-2.25q-.75 0-.75-.75v-2.5q0-.75.75-.75h2.25v-1.75q-2-.438-3.594-1.688t-2.5-3.094T5.999 15q0-2.625 1.375-4.813l-1-1-1.25 1.25q-.563.5-1.063 0l-1.75-1.813q-.563-.5 0-1.063l1.188-1.188-1.188-1.188-1.063 1.063q-.313.313-.781.125t-.469-.688V.747q0-.75.75-.75h4.938q.5 0 .688.469t-.188.781L5.123 2.31l1.25 1.188 1.188-1.25q.563-.5 1.063 0l1.813 1.813q.5.5 0 1.063l-1.25 1.25 1 1Q12.375 5.999 15 5.999t4.813 1.375l5-5.063-1.063-1.063q-.313-.313-.125-.781t.688-.469h4.938zM15 20q2.063 0 3.531-1.469T20 15t-1.469-3.531T15 10t-3.531 1.469T10 15t1.469 3.531T15 20z',
		'w' => .9375,
		'vw' => 30
	    ),
	    'venus-double' => array(
		'p' => 'M18 11q0 3.188-1.969 5.625T11 19.75V23h2.25q.75 0 .75.75v2.5q0 .75-.75.75H11v2.25q0 .75-.75.75h-2.5Q7 30 7 29.25V27H4.75Q4 27 4 26.25v-2.5q0-.75.75-.75H7v-3.25q-3.063-.688-5.031-3.125T0 11q0-3.75 2.625-6.375T9 2t6.375 2.625T18 11zM4 11q0 2.063 1.469 3.531T9 16t3.531-1.469T14 11t-1.469-3.531T9 6 5.469 7.469 4 11zm21 8.75V23h2.25q.75 0 .75.75v2.5q0 .75-.75.75H25v2.25q0 .75-.75.75h-2.5q-.75 0-.75-.75V27h-2.25q-.75 0-.75-.75v-2.5q0-.75.75-.75H21v-3.25q-1.938-.438-3.563-1.688 1.313-1.625 2-3.563 1.438 1.5 3.563 1.5 2.063 0 3.531-1.469T28 10.999t-1.469-3.531T23 5.999q-2.125 0-3.563 1.5-.688-2-2-3.563Q19.875 1.998 23 1.998q3.75 0 6.375 2.625T32 10.998q0 3.188-1.969 5.625T25 19.748z'
	    ),
	    'mars-double' => array(
		'p' => 'M21.25 0Q22 0 22 .75v4.938q0 .313-.219.531t-.531.219-.5-.188l-1.063-1.063-3.063 3q1.375 2.188 1.375 4.813 0 3.75-2.625 6.375T8.999 22t-6.375-2.625T-.001 13t2.625-6.375T8.999 4q2.625 0 4.813 1.375l3-3.063-1.063-1.063q-.313-.313-.125-.781t.688-.469h4.938zM9 18q2.063 0 3.531-1.469T14 13t-1.469-3.531T9 8 5.469 9.469 4 13t1.469 3.531T9 18zm22.25-8q.313 0 .531.219t.219.531v4.938q0 .313-.219.531t-.531.219-.5-.188l-1.063-1.063-3.063 3q1.375 2.188 1.375 4.813 0 3.75-2.625 6.375T18.999 32q-2.313 0-4.281-1.063t-3#q#906-1.469-4.094q2.063-.188 3.938-1.125V23q0 2.063 1.469 3.531T18.999 28t3.531-1.469T23.999 23q0-1.375-.656-2.531t-1.813-1.813T18.999 18h-.188q.938-1.875 1.125-3.938 2.063.188 3.875 1.313l3-3.063-1.063-1.063q-.313-.313-.125-.781t.688-.469h4.938z'
	    ),
	    'venus-mars' => array(
		'p' => 'M35.25 0Q36 0 36 .75v4.938q0 .313-.219.531t-.531.219-.5-.188l-1.063-1.063-3.063 3q1.375 2.188 1.375 4.813 0 3.75-2.625 6.375T22.999 22q-3.125 0-5.563-1.938 1.313-1.563 2-3.563 1.438 1.5 3.563 1.5 2.063 0 3.531-1.469t1.469-3.531-1.469-3.531-3.531-1.469q-2.125 0-3.563 1.5-.688-1.938-2-3.563 2.438-1.938 5.563-1.938 2.625 0 4.813 1.375l3-3.063-1.063-1.063q-.313-.313-.125-.781t.688-.469h4.938zM9 4q3.75 0 6.375 2.625T18 13q0 3.188-1.969 5.625T11 21.75V25h2.25q.75 0 .75.75v2.5q0 .75-.75.75H11v2.25q0 .75-.75.75h-2.5Q7 32 7 31.25V29H4.75Q4 29 4 28.25v-2.5q0-.75.75-.75H7v-3.25q-3.063-.688-5.031-3.125T0 13q0-3.75 2.625-6.375T9 4zm0 14q2.063 0 3.531-1.469T14 13t-1.469-3.531T9 8 5.469 9.469 4 13t1.469 3.531T9 18z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'mars-stroke' => array(
		'p' => 'M23.25 4q.313 0 .531.219T24 4.75v4.938q0 .5-.469.688t-.781-.188l-1.063-1.063-1.125 1.125.875.875q.563.563 0 1.063l-1.75 1.75q-.563.563-1.063 0l-.875-.875-1.125 1.125q1.375 2.188 1.375 4.813 0 3.75-2.625 6.375t-6.375 2.625-6.375-2.625-2.625-6.375q0-2.438 1.219-4.5t3.281-3.281 4.5-1.219q2.625 0 4.813 1.375l1.125-1.125-.938-.875q-.5-.5 0-1.063l1.813-1.75q.5-.563 1.063 0l.875.875 1.063-1.125L17.75 5.25q-.313-.313-.125-.781T18.313 4h4.938zM9 24q2.063 0 3.531-1.469T14 19t-1.469-3.531T9 14t-3.531 1.469T4 19t1.469 3.531T9 24z',
		'w' => .75,
		'vw' => 24
	    ),
	    'mars-stroke-v' => array(
		'p' => 'M15.375 14.625Q18 17.25 18 21t-2.625 6.375T9 30t-6.375-2.625T0 21t2.625-6.375Q4.5 12.812 7 12.25v-1.625H5.75q-.313 0-.531-.219T5 9.875v-2.5q0-.313.219-.531t.531-.219H7v-1.5H5.5q-.5 0-.688-.469T5 3.812l3.5-3.5q.5-.5 1 0l3.5 3.5q.375.375.188.813t-.688.438H11v1.563h1.25q.313 0 .531.219t.219.531v2.5q0 .313-.219.531t-.531.219H11v1.625q2.5.563 4.375 2.375zm-2.844 9.906Q14 23.062 14 21t-1.469-3.531T9 16t-3.531 1.469T4 21t1.469 3.531T9 26t3.531-1.469z',
		'w' => .5625,
		'vw' => 18
	    ),
	    'mars-stroke-h' => array(
		'p' => 'M29.75 15.5q.563.5 0 1l-3.5 3.5q-.313.375-.781.188T25 19.5V18h-1.5v1.25q0 .75-.75.75h-2.5q-.75 0-.75-.75V18h-1.75q-.563 2.5-2.375 4.375Q12.75 25 9 25t-6.375-2.625T0 16t2.625-6.375T9 7t6.375 2.625Q17.188 11.5 17.75 14h1.75v-1.25q0-.75.75-.75h2.5q.75 0 .75.75V14H25v-1.5q0-.5.469-.688t.781.188zm-17.219 4.031Q14 18.062 14 16t-1.469-3.531T9 11t-3.531 1.469T4 16t1.469 3.531T9 21t3.531-1.469z',
		'w' => .935546875,
		'vw' => 30
	    ),
	    'neuter' => array(
		'p' => 'M18 11q0 3.188-1.969 5.625T11 19.75v9.5q0 .75-.75.75h-2.5Q7 30 7 29.25v-9.5q-3.063-.688-5.031-3.125T0 11q0-3.75 2.625-6.375T9 2t6.375 2.625T18 11zm-9 5q2.063 0 3.531-1.469T14 11t-1.469-3.531T9 6 5.469 7.469 4 11t1.469 3.531T9 16z',
		'w' => .5625,
		'vw' => 18
	    ),
	    'genderless' => array(
		'p' => 'M9 11q-2.063 0-3.531 1.469T4 16t1.469 3.531T9 21t3.531-1.469T14 16t-1.469-3.531T9 11zm0-4q3.75 0 6.375 2.625T18 16t-2.625 6.375T9 25t-6.375-2.625T0 16t2.625-6.375T9 7z',
		'w' => .5625,
		'vw' => 18
	    ),
	    'server' => array(
		'p' => 'M30 10H2q-.813 0-1.406-.594T0 8V4q0-.813.594-1.406T2 2h28q.813 0 1.406.594T32 4v4q0 .813-.594 1.406T30 10zm-3-5.5q-.625 0-1.063.438t-.438 1.063.438 1.063T27 7.502t1.063-.438.438-1.063-.438-1.063T27 4.5zm-4 0q-.625 0-1.063.438t-.438 1.063.438 1.063T23 7.502t1.063-.438.438-1.063-.438-1.063T23 4.5zM30 20H2q-.813 0-1.406-.594T0 18v-4q0-.813.594-1.406T2 12h28q.813 0 1.406.594T32 14v4q0 .813-.594 1.406T30 20zm-3-5.5q-.625 0-1.063.438t-.438 1.063.438 1.063 1.063.438 1.063-.438.438-1.063-.438-1.063T27 14.5zm-4 0q-.625 0-1.063.438t-.438 1.063.438 1.063 1.063.438 1.063-.438.438-1.063-.438-1.063T23 14.5zM30 30H2q-.813 0-1.406-.594T0 28v-4q0-.813.594-1.406T2 22h28q.813 0 1.406.594T32 24v4q0 .813-.594 1.406T30 30zm-3-5.5q-.625 0-1.063.438t-.438 1.063.438 1.063 1.063.438 1.063-.438.438-1.063-.438-1.063T27 24.5zm-4 0q-.625 0-1.063.438t-.438 1.063.438 1.063 1.063.438 1.063-.438.438-1.063-.438-1.063T23 24.5z'
	    ),
	    'user-plus' => array(
		'p' => 'M39 13q.438 0 .719.281T40 14v2q0 .438-.281.719T39 17h-4v4q0 .438-.281.719T34 22h-2q-.438 0-.719-.281T31 21v-4h-4q-.438 0-.719-.281T26 16v-2q0-.438.281-.719T27 13h4V9q0-.438.281-.719T32 8h2q.438 0 .719.281T35 9v4h4zm-25 3q-3.313 0-5.656-2.344T6 8t2.344-5.656T14 0t5.656 2.344T22 8t-2.344 5.656T14 16zm5.625 2q3.438 0 5.906 2.469T28 26.375V29#n# 32H3q-1.25 0-2.125-.875T0 29v-2.625q0-3.438 2.469-5.906T8.375 18h1.063q2.188 1 4.563 1t4.563-1h1.063z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'user-times' => array(
		'p' => 'M36.875 15l2#r#875q.75.688 0 1.375l-1.438 1.438q-.688.75-1.375 0L34 17.875l-2.875 2.813q-.688.75-1.375 0l-1.438-1.438q-.75-.688 0-1.375L31.125 15l-2.813-2.875q-.75-.688 0-1.375l1.438-1.438q.688-.75 1.375 0L34 12.125l2.875-2.813q.688-.75 1.375 0l1.438 1.438q.75.688 0 1.375z#k#m5.625 2q3.438 0 5.906 2.469T28 26.375V29#n# 32H3q-1.25 0-2.125-.875T0 29v-2.625q0-3.438 2.469-5.906T8.375 18h1.063q2.188 1 4.563 1t4.563-1h1.063z',
		'w' => 1.248046875,
		'vw' => 40
	    ),
	    'bed' => array(
		'p' => 'M11 16q-2.063 0-3.531-1.469T6 11t1.469-3.531T11 6t3.531 1.469T16 11t-1.469 3.531T11 16zm22-8q2.875 0 4.938 2.063t2.063 4.938v12q0 .438-.281.719t-.719.281h-2q-.438 0-.719-.281t-.281-.719v-3h-32v3q0 .438-.281.719t-.719.281h-2q-.438 0-.719-.281t-.281-.719v-22q0-.438.281-.719t.719-.281h2q.438 0 .719.281t.281.719v13h14v-9q0-.438.281-.719t.719-.281h14z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'train' => array(
		'p' => 'M28 6v16q0 2.438-2.438 4.219T19.874 28l3.938 3.125q.25.188.156.531t-.469.344h-19q-.375 0-.469-.344t.156-.531L8.124 28q-3.25 0-5.688-1.781T-.002 22V6q0-2.438 2.469-4.219T7.998 0h12q3.125 0 5.563 1.781T27.999 6zm-3 8.5v-7q0-.625-.438-1.063t-1.063-.438h-19q-.625 0-1.063.438T2.998 7.5v7q0 .625.438 1.063t1.063.438h19q.625 0 1.063-.438T25 14.5zm-11 4q-1.438 0-2.469 1.031T10.5 22t1.031 2.469T14 25.5t2.469-1.031T17.5 22t-1.031-2.469T14 18.5z',
		'w' => .875,
		'vw' => 28
	    ),
	    'subway' => array(
		'p' => 'M28 6v16q0 2.438-2.438 4.219T19.874 28l3.938 3.125q.25.188.156.531t-.469.344h-19q-.375 0-.469-.344t.156-.531L8.124 28q-3.25 0-5.688-1.781T-.002 22V6q0-2.438 2.469-4.219T7.998 0h12q3.125 0 5.563 1.781T27.999 6zm-15.5 8.5v-7q0-.625-.438-1.063t-1.063-.438h-6.5q-.625 0-1.063.438T2.998 7.5v7q0 .625.438 1.063t1.063.438h6.5q.625 0 1.063-.438T12.5 14.5zm12.5 0v-7q0-.625-.438-1.063t-1.063-.438h-6.5q-.625 0-1.063.438T15.498 7.5v7q0 .625.438 1.063t1.063.438h6.5q.625 0 1.063-.438T25 14.5zM22 18q-1.25 0-2.125.875T19 21t.875 2.125T22 24t2.125-.875T25 21t-.875-2.125T22 18zM6 18q-1.25 0-2.125.875T3 21t.875 2.125T6 24t2.125-.875T9 21t-.875-2.125T6 18z',
		'w' => .875,
		'vw' => 28
	    ),
	    'battery-full' => array(
		'p' => 'M34 10H4v12h30v-4h2v-4h-2v-4zm1-4q1.25 0 2.125.875T38 9v1h.5q.625 0 1.063.438t.438 1.063v9q#p#8H38v1q0 1.25-.875 2.125T35 26.002H3q-1.25 0-2.125-.875T0 23.002v-14q0-1.25.875-2.125T3 6.002h32zm-3 6v8H6v-8h26z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'battery-three-quarters' => array(
		'p' => 'M34 10H4v12h30v-4h2v-4h-2v-4zm1-4q1.25 0 2.125.875T38 9v1h.5q.625 0 1.063.438t.438 1.063v9q#p#8H38v1q0 1.25-.875 2.125T35 26.002H3q-1.25 0-2.125-.875T0 23.002v-14q0-1.25.875-2.125T3 6.002h32zm-9 6v8H6v-8h20z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'battery-half' => array(
		'p' => 'M34 10H4v12h30v-4h2v-4h-2v-4zm1-4q1.25 0 2.125.875T38 9v1h.5q.625 0 1.063.438t.438 1.063v9q#p#8H38v1q0 1.25-.875 2.125T35 26.002H3q-1.25 0-2.125-.875T0 23.002v-14q0-1.25.875-2.125T3 6.002h32zm-15 6v8H6v-8h14z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'battery-quarter' => array(
		'p' => 'M34 10H4v12h30v-4h2v-4h-2v-4zm1-4q1.25 0 2.125.875T38 9v1h.5q.625 0 1.063.438t.438 1.063v9q#p#8H38v1q0 1.25-.875 2.125T35 26.002H3q-1.25 0-2.125-.875T0 23.002v-14q0-1.25.875-2.125T3 6.002h32zm-21 6v8H6v-8h8z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'battery-empty' => array(
		'p' => 'M34 10H4v12h30v-4h2v-4h-2v-4zm1-4q1.25 0 2.125.875T38 9v1h.5q.625 0 1.063.438t.438 1.063v9q#p#8H38v1q0 1.25-.875 2.125T35 26.002H3q-1.25 0-2.125-.875T0 23.002v-14q0-1.25.875-2.125T3 6.002h32z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'mouse-pointer' => array(
		'p' => 'M18.875 20.563H12.25l3.5 8.5q.188.438 0 .875t-.625.625l-3.063 1.375q-.438.125-.844-.031t-.594-.594L7.311 23.25l-5.438 5.563q-.5.563-1.188.25T-.003 28V1.125q0-.75.719-1.031t1.156.219l17.813 18.313q.5.5.219 1.219t-1.031.719z',
		'w' => .625,
		'vw' => 20
	    ),
	    'i-cursor' => array(
		'p' => 'M16 3.25q0 .313-.219.531T15.25 4Q10 4 10 7v7h2.25q.75 0 .75.75v2.5q0 .75-.75.75H10v7q0 3.063 5.25 3 .313 0 .531.219t.219.531v2.5q0 .313-.219.531T15.25 32q-1.438 0-2.375-.094t-2.344-.656T8 29.625q-1.125 1.125-2.563 1.688t-2.375.625-2.313.063q-.313 0-.531-.219t-.219-.531v-2.5q0-.313.219-.531t.531-.219q5.25 0 5.25-3v-7h-2.25q-.75 0-.75-.75v-2.5q0-.75.75-.75h2.25v-7q0-3.063-5.25-3-.188 0-.375-.094t-.281-.281-.094-.375v-2.5q0-.125.063-.281T.218.22.437.064.75.001q1.438 0 2.375.094t2.344.656T8 2.376Q9.125 1.251 10.563.688t2.375-.625T15.251 0q.313 0 .531.219t.219.531v2.5z',
		'w' => .5,
		'vw' => 16
	    ),
	    'object-group' => array(
		'p' => 'M30 8v18h1.25q.75 0 .75.75v2.5q0 .75-.75.75h-2.5q-.75 0-.75-.75V28H4v1.25q0 .75-.75.75H.75Q0 30 0 29.25v-2.5Q0 26 .75 26H2V6H.75Q0 6 0 5.25v-2.5Q0 2 .75 2h2.5Q4 2 4 2.75V4h24V2.75q0-.75.75-.75h2.5q.75 0 .75.75v2.5q0 .75-.75.75H30v2zM6 17.25q0 .75.75.75h10.5q.75 0 .75-.75v-8.5Q18 8 17.25 8H6.75Q6 8 6 8.75v8.5zm20 6v-8.5q0-.75-.75-.75H20v4.5q#p#8h-4.5v3.25q0 .75.75.75h10.5q.75 0 .75-.75z'
	    ),
	    'object-ungroup' => array(
		'p' => 'M4 20v1.625Q4 22 3.625 22H.375Q0 22 0 21.625v-3.25Q0 18 .375 18H2V6H.375Q0 6 0 5.625v-3.25Q0 2 .375 2h3.25Q4 2 4 2.375V4h18V2.375Q22 2 22.375 2h3.25Q26 2 26 2.375v3.25Q26 6 25.625 6H24v12h1.625q.375 0 .375.375v3.25q0 .375-.375.375h-3.25Q22 22 22 21.625V20H4zm30-4v10h1.625q.375 0 .375.375v3.25q0 .375-.375.375h-3.25Q32 30 32 29.625V28H14v1.625q0 .375-.375.375h-3.25Q10 30 10 29.625v-3.25q0-.375.375-.375H12v-4.5h8.5v.5q0 .625.438 1.063t1.063.438h4q.625 0 1.063-.438T27.502 22v-4q0-.625-.438-1.063t-1.063-.438h-.5v-4.5h6.5v-1.625q0-.375.375-.375h3.25q.375 0 .375.375v3.25q0 .375-.375.375h-1.625v2z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'sticky-note' => array(
		'p' => 'M19.5 20q-.625 0-1.063.438t-.438 1.063v8.5h-16.5q-.625 0-1.063-.438T-.002 28.5v-25q0-.625.438-1.063t1.063-.438h25q.625 0 1.063.438T28 3.5V20h-8.5zm8.063 3.438l-6.125 6.125q-.438.438-1.063.438H20v-8h8v.375q0 .625-.438 1.063z',
		'w' => .875,
		'vw' => 28
	    ),
	    'clone' => array(
		'p' => 'M29 0q1.25 0 2.125.875T32 3v18q0 1.25-.875 2.125T29 24H11q-1.25 0-2.125-.875T8 21V3q0-1.25.875-2.125T11 0h18zM11 26h13v3q0 1.25-.875 2.125T21 32H3q-1.25 0-2.125-.875T0 29V11q0-1.25.875-2.125T3 8h3v13q0 2.063 1.469 3.531T11 26z'
	    ),
	    'balance-scale' => array(
		'p' => 'M16 21q0 2.063-2.344 3.531T8 26t-5.656-1.469T0 21v-.063q0-.5.313-1.219t2.188-4.469l2.813-5.625q.813-1.625 2.688-1.625t2.688 1.625q1.25 2.5 2.875 5.813 1.813 3.563 2.125 4.25t.313 1.25V21zM8 11l-4.5 9h9zm32 10q0 1.375-1.063 2.531t-2.906 1.813T32 26q-3.313 0-5.656-1.469T24 21v-.063q0-.5.313-1.219t2.188-4.469l.469-.938.5-.969.594-1.156.594-1.188.656-1.375q.813-1.625 2.688-1.625t2.688 1.625q1.25 2.5 2.875 5.813 1.813 3.563 2.125 4.25t.313 1.25v.063zm-12.5-1h9L32 11zm5.5 8q.438 0 .719.281T34 29v2q0 .438-.281.719T33 32H7q-.438 0-.719-.281T6 31v-2q0-.438.281-.719T7 28h11V9.562q-2.375-1-2.875-3.563H7q-.438 0-.719-.281T6 4.999v-2q0-.438.281-.719T7 1.999h9q1.563-2 4-2t4 2h9q.438 0 .719.281t.281.719v2q0 .438-.281.719T33 5.999h-8.125q-.5 2.563-2.875 3.563V28h11z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'hourglass-start' => array(
		'p' => 'M22.5 0q.625 0 1.063.438t.438 1.063v1q#p#8q0 4#q#125 7.531t-5.438 4.469q3.313 1.125 5.438 4.469t2.125 7.531q.625 0 1.063.438t.438 1.063v1q#p#8h-21q-.625 0-1.063-.438t-.438-1.063v-1q0-.625.438-1.063t1.063-.438q0-4.188 2.125-7.531t5.438-4.469q-2.188-.75-3.906-2.5T2.469 9.283 1.5 4.002q-.625 0-1.063-.438t-.438-1.063v-1q0-.625.438-1.063T1.5 0h21zm-4 28q0-3.688-1.906-6.344T12 19t-4.594 2.656T5.5 28h13z',
		'w' => .75,
		'vw' => 24
	    ),
	    'hourglass-half' => array(
		'p' => 'M22.5 0q.625 0 1.063.438t.438 1.063v1q#p#8q0 4#q#125 7.531t-5.438 4.469q3.313 1.125 5.438 4.469t2.125 7.531q.625 0 1.063.438t.438 1.063v1q#p#8h-21q-.625 0-1.063-.438t-.438-1.063v-1q0-.625.438-1.063t1.063-.438q0-4.188 2.125-7.531t5.438-4.469q-2.188-.75-3.906-2.5T2.469 9.283 1.5 4.002q-.625 0-1.063-.438t-.438-1.063v-1q0-.625.438-1.063T1.5 0h21zm-4.687 24q-.813-2.25-2.375-3.625T12 19t-3.438 1.375T6.187 24h11.625zm0-16q.688-1.875.688-4h-13q0 2.125.688 4h11.625z',
		'w' => .75,
		'vw' => 24
	    ),
	    'hourglass-end' => array(
		'p' => 'M22.5 4q0 4#q#125 7.531T14.937 16q3.313 1.125 5.438 4.469T22.5 28q.625 0 1.063.438t.438 1.063v1q#p#8h-21q-.625 0-1.063-.438t-.438-1.063v-1q0-.625.438-1.063T1.5 28q0-4.188 2.125-7.531T9.063 16q-2.188-.75-3.906-2.5T2.469 9.281 1.5 4Q.875 4 .437 3.562t-.438-1.063v-1q0-.625.438-1.063T1.5-.002h21q.625 0 1.063.438t.438 1.063v1q0 .625-.438 1.063T22.5 4zM12 13q2.688 0 4.594-2.656T18.5 4h-13q0 3.688 1.906 6.344T12 13z',
		'w' => .75,
		'vw' => 24
	    ),
	    'hourglass' => array(
		'p' => 'M22.5 4q0 4#q#125 7.531T14.937 16q3.313 1.125 5.438 4.469T22.5 28q.625 0 1.063.438t.438 1.063v1q#p#8h-21q-.625 0-1.063-.438t-.438-1.063v-1q0-.625.438-1.063T1.5 28q0-4.188 2.125-7.531T9.063 16q-2.188-.75-3.906-2.5T2.469 9.281 1.5 4Q.875 4 .437 3.562t-.438-1.063v-1q0-.625.438-1.063T1.5-.002h21q.625 0 1.063.438t.438 1.063v1q0 .625-.438 1.063T22.5 4z',
		'w' => .75,
		'vw' => 24
	    ),
	    'hand-rock' => array(
		'p' => 'M29.063 5q.813 0 1.469.438t1.063 1.125.406 1.5v8.313q0 1.25-.5 2.375l-3 7.25q-.5 1.125-.5 2.313v.188q0 .438-.188.781t-.531.531-.781.188h-15q-.625 0-1.063-.438T10 28.501v-.438q0-1.313-1-2.188l-7-6.25q-2-1.813-2-4.5V11q0-1.25.906-2.125T3.062 8q1.188 0 2.063.906T6 11.062v3l.5.438V6q0-1.25.906-2.125T9.562 3q1.188 0 2.063.906t.875 2.156V8h.5V5q0-1.25.906-2.125T16.062 2q1.188 0 2.063.906T19 5.062V8h.5V6q0-1.25.906-2.125T22.562 3q1.188 0 2.063.906t.875 2.156V8h.5q0-1.25.906-2.125T29.062 5z'
	    ),
	    'hand-paper' => array(
		'p' => 'M25.563 8q.625 0 1.219.344t.906.906.313 1.25v9.375q0 1.438-.313 2.75L26 29.688q-.188 1-1.031 1.656T23.125 32H10.75q-.625 0-1.344-.375t-1.094-.875L.499 20q-.625-.875-.469-1.906t1-1.625 1.875-.438T4.499 17l2 2.75V5q0-.688.313-1.25t.906-.906T8.937 2.5q1.063 0 1.813.75t.75 1.813v10.938h.5v-13.5q0-.688.313-1.25t.906-.906 1.219-.344q.5 0 1 .188t.844.531.531.844.188 1v13.438h.5V4.939q0-1 .719-1.75t1.719-.75q1.063 0 1.813.75t.75 1.813v11h.5v-5.438q0-1.063.75-1.813t1.813-.75z',
		'w' => .873046875,
		'vw' => 28
	    ),
	    'hand-scissors' => array(
		'p' => 'M13.5 27.5q0-1.063.719-1.781T16 25v-.5h-2q-1.063 0-1.781-.719T11.5 22t.719-1.781T14 19.5h2V19H3q-1.25 0-2.125-.875T0 16t.875-2.125T3 13h13v-.875L4.875 7.812q-.75-.313-1.25-.938t-.594-1.406.156-1.594q.5-1.125 1.625-1.625t2.313-.063L19 6.874l1.563-1.938q.563-.75 1.469-.906t1.719.281l7 4q.5.313.875.938t.375 1.25v15q0 .875-.531 1.563t-1.406.875l-8.5 2q-.25.063-.563.063h-5q-1.063 0-1.781-.719t-.719-1.781z'
	    ),
	    'hand-lizard' => array(
		'p' => 'M24 30v-3.813q0-.875-.688-1.313l-7-4.438q-.75-.438-1.625-.438H5.499q-.625 0-1.063-.438t-.438-1.063v-.5q0-1.688 1.156-2.844t2.844-1.156h7.75q.5 0 1.063-.375t.75-.875l1.375-3.188q.188-.563-.125-1.063t-.938-.5H3.498q-1.438 0-2.469-1.031T-.002 4.496v-1q0-.625.438-1.063t1.063-.438h20.875q.625 0 1.375.406t1.125.969l10.188 16.188Q36 20.996 36 22.746v7.25H24z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'hand-spock' => array(
		'p' => 'M30.063 6.063q1 .25 1.563 1.125t.313 1.875l-2.25 9.563q-.188.688-.188 1.375v2.625q0 .875-.25 1.688l-1.625 5.563q-.313.938-1.094 1.531t-1.781.594H11.188q-1.188 0-2.063-.813L.812 23.314q-.75-.688-.781-1.719t.656-1.781 1.719-.781 1.781.656L8 23.252v-5L5.562 7.564q-.125-.5-.031-1t.344-.906.656-.688.906-.406q1-.25 1.875.313t1.125 1.563l2.188 9.563h.625l-3-12.938q-.25-1 .313-1.875T12.126.065q.688-.125 1.313.063t1.094.656.594 1.156l3.25 14.063h.938l3-12.125q.25-1 1.156-1.531t1.906-.281 1.531 1.156.281 1.906l-2.75 10.875h.688l1.938-8.063q.25-1 1.125-1.563t1.875-.313z'
	    ),
	    'hand-pointer' => array(
		'p' => 'M28 15v6q0 .313-.063.563l-2 8.5q-.188.875-.875 1.406T23.499 32h-13q-1.25 0-2-1l-8-11q-.625-.875-.469-1.906t1-1.625 1.875-.438T4.499 17l2 2.75V2.5q0-1.063.719-1.781T8.999 0t1.781.719.719 1.781V15h.5v-2.5q0-1.063.719-1.781T14.499 10t1.781.719.719 1.781V15h.5v-1.5q0-1.063.719-1.781T19.999 11t1.781.719.719 1.781V15h.5q0-1.063.719-1.781t1.781-.719 1.781.719.719 1.781zm-16 5h-.5v6h.5v-6zm5.5 0H17v6h.5v-6zm5.5 0h-.5v6h.5v-6z',
		'w' => .875,
		'vw' => 28
	    ),
	    'hand-peace' => array(
		'p' => 'M25.5 13.5q1.063 0 1.781.719T28 16v5q0 .313-.063.563l-2 8.5q-.188.875-.875 1.406T23.499 32h-15q-.375 0-.813-.156t-.813-.469-.563-.625l-4-7q-.438-.813-.281-1.719t.906-1.469l1.938-1.563L.185 7.124q-.438-1.188.063-2.313t1.656-1.594 2.281.031T5.81 4.873l4.313 11.125h.875v-13q0-1.25.875-2.125t2.125-.875 2.125.875.875 2.125v13h.5v-2q0-1.063.719-1.781t1.781-.719 1.781.719.719 1.781v2h.5q0-1.063.719-1.781t1.781-.719z',
		'w' => .875,
		'vw' => 28
	    ),
	    'trademark' => array(
		'p' => 'M16.313 6q.188 0 .344.094t.281.281.063.375v2.688q0 .313-.219.531t-.531.219h-5.313v15.063q0 .313-.219.531t-.531.219H6.813q-.313 0-.531-.219t-.219-.531V10.188H.75q-.313 0-.531-.219T0 9.438V6.75Q0 6 .75 6h15.563zM40 25.188q.063.813-.75.813h-3.375q-.688 0-.75-.688L34.562 17v-3.375h-.063Q33.811 15.75 33.374 17l-1.875 5.313q-.188.438-.75.438h-3.125q-.563 0-.688-.438L24.998 17l-1.125-3.375h-.063q.125 1.875 0 3.375l-.563 8.313q-.063.688-.75.688h-3.375q-.375 0-.594-.25t-.156-.563l1.5-18.5q.063-.688.75-.688h4.063q.563 0 .75.5l2.688 7.938 1 3.313h.063q.563-2 1.063-3.313L32.937 6.5q.188-.5.75-.5h4.063q.688 0 .75.688z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'registered' => array(
		'p' => 'M17.813 12.938q0 1.813-1.75 1.813h-1.875v-3.5h1.438q1.313 0 1.75.375t.438 1.313zM31.5 16q0 6.438-4.531 10.969T16 31.5 5.031 26.969.5 16 5.031 5.031 16 .5t10.969 4.531T31.5 16zm-8.812 6.5q-2.688-4.938-2.75-5.063 2.375-1.5 2.375-4.625 0-5.563-6.625-5.563H11.25q-.563 0-1.031.438T9.75 8.75v14.5q0 .625.469 1.063t1.031.438h1.438q.625 0 1.063-.438t.438-1.063v-4.5h1.625l2.75 5.188q.438.813 1.313.813h1.5q.875 0 1.313-.75t0-1.5z'
	    ),
	    'tv' => array(
		'p' => 'M37 0q1.25 0 2.125.875T40 3v20q0 1.25-.875 2.125T37 26H22.312v2h10q.813 0 1.406.594T34.312 30t-.594 1.406-1.406.594h-24q-.813 0-1.406-.594T6.312 30t.594-1.406T8.312 28h10v-2H2.999q-1.25 0-2.125-.875T-.001 23V3q0-1.25.875-2.125T2.999 0h34zm-1 22V4H4v18h32z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'calendar-plus' => array(
		'p' => 'M27.25 10H.75Q0 10 0 9.25V7q0-1.25.875-2.125T3 4h3V.75Q6 0 6.75 0h2.5Q10 0 10 .75V4h8V.75q0-.75.75-.75h2.5Q22 0 22 .75V4h3q1.25 0 2.125.875T28 7v2.25q0 .75-.75.75zM.75 12h26.5q.75 0 .75.75V29#n# 32H3q-1.25 0-2.125-.875T0 29V12.75Q0 12 .75 12zm19.75 8.75q0-.75-.75-.75H16v-3.75q0-.75-.75-.75h-2.5q-.75 0-.75.75V20H8.25q-.75 0-.75.75v2.5q0 .75.75.75H12v3.75q0 .75.75.75h2.5q.75 0 .75-.75V24h3.75q.75 0 .75-.75v-2.5z',
		'w' => .875,
		'vw' => 28
	    ),
	    'calendar-minus' => array(
		'p' => 'M27.25 10H.75Q0 10 0 9.25V7q0-1.25.875-2.125T3 4h3V.75Q6 0 6.75 0h2.5Q10 0 10 .75V4h8V.75q0-.75.75-.75h2.5Q22 0 22 .75V4h3q1.25 0 2.125.875T28 7v2.25q0 .75-.75.75zM.75 12h26.5q.75 0 .75.75V29#n# 32H3q-1.25 0-2.125-.875T0 29V12.75Q0 12 .75 12zm19 12q.75 0 .75-.75v-2.5q0-.75-.75-.75H8.25q-.75 0-.75.75v2.5q0 .75.75.75h11.5z',
		'w' => .875,
		'vw' => 28
	    ),
	    'calendar-times' => array(
		'p' => 'M27.25 10H.75Q0 10 0 9.25V7q0-1.25.875-2.125T3 4h3V.75Q6 0 6.75 0h2.5Q10 0 10 .75V4h8V.75q0-.75.75-.75h2.5Q22 0 22 .75V4h3q1.25 0 2.125.875T28 7v2.25q0 .75-.75.75zM.75 12h26.5q.75 0 .75.75V29#n# 32H3q-1.25 0-2.125-.875T0 29V12.75Q0 12 .75 12zm16.063 10l3-3q.563-.563 0-1.063l-1.75-1.75q-.5-.563-1.063 0l-3 3-3-3q-.563-.563-1.063 0l-1.75 1.75q-.563.5 0 1.063l3 3-3 3q-.563.563 0 1.063l1.75 1.75q.5.563 1.063 0l3-3 3 3q.563.563 1.063 0l1.75-1.75q.563-.5 0-1.063z',
		'w' => .875,
		'vw' => 28
	    ),
	    'calendar-check' => array(
		'p' => 'M27.25 10H.75Q0 10 0 9.25V7q0-1.25.875-2.125T3 4h3V.75Q6 0 6.75 0h2.5Q10 0 10 .75V4h8V.75q0-.75.75-.75h2.5Q22 0 22 .75V4h3q1.25 0 2.125.875T28 7v2.25q0 .75-.75.75zM.75 12h26.5q.75 0 .75.75V29#n# 32H3q-1.25 0-2.125-.875T0 29V12.75Q0 12 .75 12zm20.813 6l-1.75-1.75q-.5-.563-1.063-.063l-6.625 6.625-2.875-2.938q-.5-.5-1.063 0l-1.75 1.75q-.563.563 0 1.063l5.125 5.25q.563.5 1.063 0l8.938-8.875q.563-.563 0-1.063z',
		'w' => .875,
		'vw' => 28
	    ),
	    'industry' => array(
		'p' => 'M29.688 10.25q.75-.5 1.531-.063T32 11.5v17q#p#8h-29q-.625 0-1.063-.438T-.002 28.5v-25q0-.625.438-1.063t1.063-.438h7q.625 0 1.063.438T10 3.5v12.25l8.688-5.5q.75-.5 1.531-.063T21 11.5v4.25z'
	    ),
	    'map-pin' => array(
		'p' => 'M7 19.813q1.063.188 2 .188t2-.188v9.813l-1.375 2.063q-.25.313-.625.313t-.625-.313L7 29.626v-9.813zM9 0q3.75 0 6.375 2.625T18 9t-2.625 6.375T9 18t-6.375-2.625T0 9t2.625-6.375T9 0zm0 4.75q.75 0 .75-.75T9 3.25q-2.375 0-4.063 1.688T3.249 9.001q0 .75.75.75t.75-.75q0-1.75 1.25-3t3-1.25z',
		'w' => .5625,
		'vw' => 18
	    ),
	    'map-signs' => array(
		'p' => 'M31.688 5.313q.75.688 0 1.375L29 9.438q-.563.563-1.438.563H3.499q-.625 0-1.063-.438T1.998 8.5v-5q0-.625.438-1.063t1.063-.438h10.5v-1q0-.438.281-.719t.719-.281h2q.438 0 .719.281t.281.719v1h9.563q.875 0 1.438.563zM14 31v-7h4v7q0 .438-.281.719T17 32h-2q-.438 0-.719-.281T14 31zm14.5-17q.625 0 1.063.438t.438 1.063v5q#p#8H4.437q-.875 0-1.438-.563l-2.688-2.75q-.75-.688 0-1.375l2.688-2.75q.563-.563 1.438-.563H14v-2h4v2h10.5z'
	    ),
	    'map' => array(
		'p' => 'M0 7.375q0-.375.156-.75t.469-.688.625-.438l8.75-3.5v24l-8.625 3.938q-.5.188-.938-.125t-.438-.813V7.374zM12 26V2l12 4v24zM34.625 2.063q.375-.125.656-.031t.5.344.219.625v21.625q0 .375-.156.75t-.469.688-.625.438l-8.75 3.5v-24z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'comment-alt' => array(
		'p' => 'M28 0q1.625 0 2.813 1.188t1.188 2.813v18q0 1.625-1.188 2.813T28 26.002h-9l-7.813 5.875q-.375.25-.781.031T10 31.252v-5.25H4q-1.625 0-2.813-1.188t-1#q#813v-18q0-1.625 1#q#813T4 0h24z'
	    ),
	    'pause-circle' => array(
		'p' => 'M16 .5q6.438 0 10.969 4.531T31.5 16t-4.531 10.969T16 31.5 5.031 26.969.5 16 5.031 5.031 16 .5zM15 21V11q0-.438-.281-.719T14 10h-3q-.438 0-.719.281T10 11v10q0 .438.281.719T11 22h3q.438 0 .719-.281T15 21zm7 0V11q0-.438-.281-.719T21 10h-3q-.438 0-.719.281T17 11v10q0 .438.281.719T18 22h3q.438 0 .719-.281T22 21z'
	    ),
	    'stop-circle' => array(
		'p' => 'M16 .5q6.438 0 10.969 4.531T31.5 16t-4.531 10.969T16 31.5 5.031 26.969.5 16 5.031 5.031 16 .5zM22 21V11q0-.438-.281-.719T21 10H11q-.438 0-.719.281T10 11v10q0 .438.281.719T11 22h10q.438 0 .719-.281T22 21z'
	    ),
	    'shopping-bag' => array(
		'p' => 'M22 10h6v17q0 2.063-1.469 3.531T23 32H5q-2.063 0-3.531-1.469T0 27V10h6V8q0-3.313 2.344-5.656T14 0t5.656 2.344T22 8v2zM10 8v2h8V8q0-1.625-1#q#813t-2.813-1#q#813 1.188T9.998 8zm10 7.5q.625 0 1.063-.438t.438-1.063-.438-1.063T20 12.498t-1.063.438-.438 1.063.438 1.063T20 15.5zm-12 0q.625 0 1.063-.438t.438-1.063-.438-1.063T8 12.498t-1.063.438-.438 1.063.438 1.063T8 15.5z',
		'w' => .875,
		'vw' => 28
	    ),
	    'shopping-basket' => array(
		'p' => 'M36 13.5v1q#p#8h-.5l-1.625 11.438q-.125.688-.531 1.281t-1.063.938-1.406.344H6.624q-1.125 0-1.969-.719t-1.031-1.844L1.999 16.001h-.5q-.625 0-1.063-.438T-.002 14.5v-1q0-.625.438-1.063t1.063-.438h4.188l6.688-9.188q.5-.688 1.313-.813t1.5.375.813 1.313-.375 1.5l-5 6.813h14.75l-5-6.813q-.5-.688-.375-1.5t.813-1.313 1.5-.375 1.313.813l6.688 9.188h4.188q.625 0 1.063.438t.438 1.063zm-16.5 11v-7q0-.625-.438-1.063t-1.063-.438-1.063.438-.438 1.063v7q0 .625.438 1.063t1.063.438 1.063-.438.438-1.063zm7 0v-7q0-.625-.438-1.063t-1.063-.438-1.063.438-.438 1.063v7q0 .625.438 1.063t1.063.438 1.063-.438.438-1.063zm-14 0v-7q0-.625-.438-1.063t-1.063-.438-1.063.438-.438 1.063v7q0 .625.438 1.063t1.063.438 1.063-.438.438-1.063z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'hashtag' => array(
		'p' => 'M27.563 11.375q-.125.625-.75.625h-4.938l-1.438 8h4.688q.313 0 .563.281t.188.594l-.5 2.5q-.063.625-.688.625h-5l-.938 5.375Q18.625 30 18 30h-2.5q-.375 0-.594-.281t-.156-.594L15.625 24H9.5l-1 5.375Q8.437 30 7.812 30H5.249q-.375 0-.594-.281t-.156-.594L5.437 24H.749q-.375 0-.594-.281t-.156-.594l.438-2.5Q.562 20 1.187 20h4.938l1.438-8H2.875q-.313 0-.563-.281t-.188-.594l.5-2.5Q2.687 8 3.312 8h5l.938-5.375Q9.375 2 10 2h2.5q.375 0 .594.281t.156.594L12.375 8H18.5l1-5.375Q19.563 2 20.188 2h2.563q.375 0 .594.281t.156.594L22.563 8h4.688q.375 0 .594.281t.156.594zM16.375 20l1.438-8h-6.188l-1.438 8h6.188z',
		'w' => .875,
		'vw' => 28
	    ),
	    'percent' => array(
		'p' => 'M7 14q-2.875 0-4.938-2.063T-.001 6.999t2.063-4.938T7-.002t4.938 2.063 2.063 4.938-2.063 4.938T7 14zM7 4q-1.25 0-2.125.875T4 7t.875 2.125T7 10t2.125-.875T10 7t-.875-2.125T7 4zm14 14q2.875 0 4.938 2.063t2.063 4.938-2.063 4.938T21 32.002t-4.938-2.063-2.063-4.938 2.063-4.938T21 18zm0 10q1.25 0 2.125-.875T24 25t-.875-2.125T21 22t-2.125.875T18 25t.875 2.125T21 28zm3.5-28h2q.875 0 1.313.813t-.063 1.563l-22.938 29q-.438.625-1.188.625H1.499q-.875 0-1.313-.813t.125-1.563l23-29Q23.749 0 24.499 0z',
		'w' => .875,
		'vw' => 28
	    ),
	    'universal-access' => array(
		'p' => 'M16 3q-5.375 0-9.188 3.813t-3.813 9.188 3.813 9.188T16 29.002t9.188-3.813 3.813-9.188-3.813-9.188T16 3zm0-2.5q6.438 0 10.969 4.531T31.5 16t-4.531 10.969T16 31.5 5.031 26.969.5 16 5.031 5.031 16 .5zM16 4q5 0 8.5 3.5T28 16t-3.5 8.5T16 28t-8.5-3.5T4 16t3.5-8.5T16 4zm0 2.75q-.938 0-1.594.656T13.75 9t.656 1.594T16 11.25t1.594-.656T18.25 9t-.656-1.594T16 6.75zm7.375 6.125q.375-.063.594-.438t.125-.781-.438-.625-.781-.094Q18.375 12 16 12t-6.875-1.063q-.438-.125-.781.094t-.438.625.125.75.594.469q3.313.75 5.125 1 0 2.938-.281 4.969T13 21.469t-#r#094q-.125.438.063.875t.625.594.844-.031.594-.563q1.125-2.875 1.375-4.938h.625q.25 2.063 1.375 4.938.188.375.594.563t.844.031.625-.594.063-.875q-.625-1.5-.813-2.094t-.469-2.625-.281-4.969q1.813-.25 5.125-1z'
	    ),
	    'blind' => array(
		'p' => 'M23.75 31.938q-.125.063-.25.063-.313 0-.438-.25l-7.813-12.875q.5-.188.813-.625l7.875 13q.063.125.063.25 0 .313-.25.438zM8.938 19.625l3.938 9.625q.313.75-.031 1.531t-1.094 1.094-1.531-.031-1.094-1.094l-2.25-5.5zM6 5.5q-1.125 0-1.938-.813t-.813-1.938.813-1.938T6-.002t1.938.813.813 1.938-.813 1.938T6 5.5zm9.688 10.563q.375.5.313 1.125t-.563 1q-.438.375-1.063.313t-1.063-.563L6.937 9.875q-.063-.125-.188-.125-.25 0-.25.25 0 .125.063.188L8.5 12.626v6.75L4.375 30.689q-.25.75-1 1.125t-1.531.094-1.156-1.031-.063-1.563L4 20.001v-8.75l-1 1.25v5q#p#8-1.063-.438-.438-1.125v-5.938l3.813-4.938Q4.249 6 4.999 6h2q.75 0 1.188.563z',
		'w' => .748046875,
		'vw' => 24
	    ),
	    'audio-description' => array(
		'p' => 'M10.188 14.938l.563 1.875H9.126l.563-1.875q.125-.375.25-1 .125.625.25 1zm10.375-2q1.375 0 2.156.781T23.5 16q0 3.063-2.938 3.063h-.875v-6.125h.875zM32 7v18q0 1.25-.875 2.125T29 28H3q-1.25 0-2.125-.875T0 25V7q0-1.25.875-2.125T3 4h26q1.25 0 2.125.875T32 7zM15.313 21L11.75 10.5q-.125-.5-.688-.5h-2.25q-.5 0-.688.5L4.561 21q-.063.188-.031.375t.125.313.25.219.344.094h1.813q.563 0 .75-.563l.5-1.875h3.25l.5 1.875q.188.563.75.563h1.813q.25 0 .438-.156t.281-.375-.031-.469zm11.562-5q0-1.875-.75-3.219t-2.156-2.063-3.281-.719h-3.563q-.313 0-.531.219t-.219.531v10.5q0 .313.219.531t.531.219h3.563q2.875 0 4.531-1.625t1.656-4.375z'
	    ),
	    'phone-volume' => array(
		'p' => 'M6.063 31.688q-4-4-5.406-9.344t.031-10.688 5.375-9.344q.625-.625 1.375-.125l4 2.5q.5.313.5.938 0 .188-.063.375l-2 5.063q-.25.688-1 .688H8.75l-3.5-.375q-2 5.625 0 11.25l3.5-.375h.125q.75 0 1 .688l2 5.063q.063.188.063.375 0 .625-.5.938l-4 2.5q-.313.188-.625.188-.438 0-.75-.313zm9.375-25.75q.563 1 .563 2.063t-.563 2.063q-.188.313-.531.344t-.656-.219l-.375-.375q-.375-.375-.125-.875.25-.438.25-.938t-.25-.938q-.25-.5.125-.875l.375-.375q.313-.25.656-.219t.531.344zM21.188.25Q24.001 3.625 24.001 8t-2.813 7.75q-.5.625-1.125.063l-.313-.375q-.563-.5-.063-1Q22 11.625 22 8t-2.313-6.438q-.5-.5.063-1l.313-.375q.625-.563 1.125.063zm-2.875 2.813q1.688 2.188 1.688 4.938t-1.688 4.938q-.5.625-1.125.063l-.375-.375q-.5-.438-.063-.938Q18 10.064 18 8.001t-1.25-3.688q-.438-.5.063-.938L17.188 3q.625-.563 1.125.063z',
		'w' => .748046875,
		'vw' => 24
	    ),
	    'braille' => array(
		'p' => 'M8 16q0 1.688-1.156 2.844T4 20t-2.844-1.156T0 16t1.156-2.844T4 12t2.844 1.156T8 16zm-4 8q.813 0 1.406.594T6 26t-.594 1.406T4 28t-1.406-.594T2 26t.594-1.406T4 24zM4 2q1.688 0 2.844 1.156T8 6 6.844 8.844 4 10 1.156 8.844 0 6t1.156-2.844T4 2zm10 12q.813 0 1.406.594T16 16t-.594 1.406T14 18t-1.406-.594T12 16t.594-1.406T14 14zm0 10q.813 0 1.406.594T16 26t-.594 1.406T14 28t-1.406-.594T12 26t.594-1.406T14 24zm0-22q1.688 0 2.844 1.156T18 6t-1.156 2.844T14 10t-2.844-1.156T10 6t1.156-2.844T14 2zm14 12q.813 0 1.406.594T30 16t-.594 1.406T28 18t-1.406-.594T26 16t.594-1.406T28 14zm0 10q.813 0 1.406.594T30 26t-.594 1.406T28 28t-1.406-.594T26 26t.594-1.406T28 24zm0-22q1.688 0 2.844 1.156T32 6t-1.156 2.844T28 10t-2.844-1.156T24 6t1.156-2.844T28 2zm10 12q.813 0 1.406.594T40 16t-.594 1.406T38 18t-1.406-.594T36 16t.594-1.406T38 14zm0 10q.813 0 1.406.594T40 26t-.594 1.406T38 28t-1.406-.594T36 26t.594-1.406T38 24zm0-20q.813 0 1.406.594T40 6t-.594 1.406T38 8t-1.406-.594T36 6t.594-1.406T38 4z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'assistive-listening-systems' => array(
		'p' => 'M13.5 16.25q0 .75-.5 1.25t-1.25.5-1.25-.5-.5-1.25q0-2.063 1.469-3.531T15 11.25t3.531 1.469T20 16.25q0 .75-.5 1.25t-1.25.5-1.25-.5-.5-1.25q0-.625-.438-1.063t-1.063-.438-1.063.438-.438 1.063zm1.5-11q4.563 0 7.781 3.219T26 16.25q0 1.688-.469 3.031t-1.125 2.156-1.313 1.438-1.125 1.219-.469 1.156q0 2.813-1.969 4.781T14.749 32q-.75 0-1.25-.5t-.5-1.25.5-1.25 1.25-.5q1.375 0 2.313-.938T18 25.249q0-1.563.719-2.719t1.563-1.75 1.531-1.781.688-2.75q0-3.125-2.188-5.313T15 8.748t-5.313 2#q#188 5.313q0 .75-.5 1.25t-1.25.5-1.25-.5-.5-1.25q0-4.563 3.219-7.781t7.781-3.219zM10 20q.813 0 1.406.594T12 22t-.594 1.406T10 24t-1.406-.594T8 22t.594-1.406T10 20zm-8 8q.813 0 1.406.594T4 30t-.594 1.406T2 32t-1.406-.594T0 30t.594-1.406T2 28zm30-11.75q0 .75-.5 1.25t-1.25.5-1.25-.5-.5-1.25V16q-.063-4.25-2.594-7.719t-6.531-4.844q-.688-.25-1-.906t-.125-1.344q.125-.313.375-.594t.531-.406.656-.156.688.094q5.063 1.688 8.25 6.063t3.25 9.75v.313zM9.563 27.438l-2.125 2.125-5-5 2.125-2.125z'
	    ),
	    'american-sign-language-interpreting' => array(
		'p' => 'M18.188 11.813q-2-1-4.063-.25 3.813 0 5.313 3.188.438.813-.063 1.594T18 17.126q.875 0 1.375.781t.063 1.594q-.688 1.438-2.031 2.313t-2.969.875l-5.875-.563-4.188 2.063q-.438.25-.875.094t-.625-.531l-2.75-5.563q-.5-.938.438-1.5l3.625-2.063 2.563-4.625q.625-5.625 5-9.188.5-.438 1.188-.375t1.125.594.375 1.219-.563 1.125q-1.25 1.063-2.063 2.25 2.125-1.438 4.625-1.75.688-.125 1.25.313t.625 1.125q.063.438-.094.844t-.531.688-.813.344q-1.438.125-2.75.938 2.813-.625 5.5.688.625.313.844.969t-.094 1.281-.969.844-1.219-.094zm-1.75 4.375q-.625-1.313-2-1.313-.938 0-1.563.656t-.625 1.594q0 .625.313 1.156t.813.781 1.063.25q1.375 0 2-1.25.438-.938 1.5-.938-1.063-.063-1.5-.938zm23.437-2.375q.5 1-.438 1.5l-3.625 2.063-2.563 4.625q-.625 5.625-5 9.188-.5.438-1.188.375t-1.125-.594-.375-1.219.563-1.125q1.25-1.063 2.063-2.25-2.125 1.438-4.625 1.75-.563.125-1.188-.281t-.688-1.156q-.063-.438.094-.844t.531-.688.813-.344q1.438-.125 2.75-.938-2.813.625-5.5-.688-.625-.313-.844-.969t.094-1.281.969-.844 1.219.094q2 1 4.063.25-3.813 0-5.313-3.188-.438-.813.063-1.594T22 14.874q-.875 0-1.375-.781t-.063-1.594q.688-1.438 2.031-2.313t3.094-.875l5.75.563 4#q#063q.438-.25.875-.094t.625.531zm-14.312-1.125q-1.375 0-2 1.25-.438.938-1.5.938 1.063.063 1.5 1 .625 1.25 2 1.25.938 0 1.563-.656t.625-1.594-.656-1.563-1.531-.625z',
		'w' => 1.248046875,
		'vw' => 40
	    ),
	    'deaf' => array(
		'p' => 'M13.5 16.25q0 .75-.5 1.25t-1.25.5-1.25-.5-.5-1.25q0-2.063 1.469-3.531T15 11.25t3.531 1.469T20 16.25q0 .75-.5 1.25t-1.25.5-1.25-.5-.5-1.25q0-.625-.438-1.063t-1.063-.438-1.063.438-.438 1.063zm1.5-11q4.563 0 7.781 3.219T26 16.25q0 1.688-.469 3.031t-1.125 2.156-1.313 1.438-1.125 1.219-.469 1.156q0 2.813-1.969 4.781T14.749 32q-.75 0-1.25-.5t-.5-1.25.5-1.25 1.25-.5q1.375 0 2.313-.938T18 25.249q0-1.563.719-2.719t1.563-1.75 1.531-1.781.688-2.75q0-3.125-2.188-5.313T15 8.748t-5.313 2#q#188 5.313q0 .75-.5 1.25t-1.25.5-1.25-.5-.5-1.25q0-4.563 3.219-7.781t7.781-3.219zM31.75 2q.563.5 0 1.063l-5.438 5.438q-.5.5-1.063 0l-1.75-1.75q-.5-.563 0-1.063L28.937.25Q29.5-.313 30 .25zM10.563 19.688l1.75 1.75q.563.563 0 1.063l-9.25 9.25q-.25.25-.563.25t-.5-.25l-1.75-1.75q-.563-.5 0-1.063l9.25-9.25q.5-.563 1.063 0z'
	    ),
	    'sign-language' => array(
		'p' => 'M5.688 30.25q0-.75.531-1.281t1.344-.531h3.875v-.375H3.563q-.75 0-1.281-.531t-.531-1.281.531-1.25 1.219-.5h7.938v-.375H1.814q-.75 0-1.281-.531t-.531-1.281q0-.688.531-1.219t1.281-.531h9.625v-.375H3.626q-.75 0-1.313-.531t-.5-1.281q0-.688.5-1.219t1.25-.531h10.563l-1.938-1.375q-.625-.438-.75-1.188t.313-1.344 1.188-.688 1.313.281l7.75 5.625q.875.625.875 1.75v8.813q0 .75-.469 1.344t-1.219.719l-5 1.188q-1 .25-2 .25H7.501q-.75 0-1.25-.5t-.563-1.25zm4.625-14.125L8 13.25q-.438-.625-.344-1.344t.656-1.156q.563-.5 1.313-.406t1.25.719l.813 1.063q-.813.688-.75 1.781t.938 1.719l.688.5h-2.25zM28 16v.063q0 1.063-.813 1.688l-3.813 3v-1.063q0-1.375-1.125-2.125l-7.688-5.625q-1.313-.938-2.625-.063l-3.25-4.188q-.438-.563-.344-1.313t.656-1.25q.625-.438 1.344-.344t1.156.719l4.875 6.188.25-.188-5.875-7.563q-.5-.625-.406-1.375t.719-1.188q.563-.438 1.281-.344t1.156.656l5.938 7.625.313-.25-4.813-6.125q-.5-.625-.406-1.375t.719-1.188q.563-.438 1.281-.344t1.219.656l6.438 8.313-.063-2.375q-.063-.75.469-1.281t1.25-.563 1.281.469.563 1.25z',
		'w' => .873046875,
		'vw' => 28
	    ),
	    'low-vision' => array(
		'p' => 'M35.563 14.5q.438.688.438 1.5t-.438 1.5q-3.063 5.25-8.5 7.938l2.688 3.625q.313.5.219 1.125t-.594.938l-.813.625q-.5.313-1.125.219t-1-.594L10.688 9.063q-1.25.563-2.375 1.375l11.875 16.938q-1.125.125-2.188.125-1.375 0-2.75-.188l-2.563-3.625L5.249 13q-1 1.063-1#r#25l7.813 11.125Q4.186 23.875.436 17.5q-.938-1.5 0-3 3.063-5.25 8.5-7.938L6.248 2.937q-.313-.5-.219-1.125t.594-.938l.813-.625q.5-.313 1.125-.219t1 .594l3.313 4.5q2.5-.625 5.125-.625 5.563 0 10.219 2.719t7.344 7.281zm-11.188 7.125Q26.5 19.187 26.5 16q0-3.5-2.5-6t-6-2.5q-1.625 0-3.125.563l1.188 1.75q2.625-.813 5 .438-1.125 0-1.906.781t-.781 1.906q0 .75.344 1.344t.969.969 1.375.375q1.125 0 1.906-.781t.781-1.906q.875 1.625.719 3.531t-1.281 3.469z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'handshake' => array(
		'p' => 'M27.188 4q.813 0 1.375.563l3.438 3.438v12.125q-.25-.313-.5-.5l-9.125-7.375 1.625-1.5q.75-.688.125-1.438Q23.813 9 23.407 9t-.719.25l-5 4.563v.063q-.813.625-1.875.563t-1.688-.75q-.625-.75-.625-1.781t.813-1.719v-.063l6.125-5.625q.563-.5 1.375-.5h5.375zM34 8h6v16h-4q-.813 0-1.406-.594T34 22V8zm3 14q.438 0 .719-.281T38 21t-.281-.719T37 20t-.719.281T36 21t.281.719T37 22zM0 24V8h6v14q0 .813-.594 1.406T4 24H0zm3-4q-.438 0-.719.281T2 21t.281.719T3 22t.719-.281T4 21t-.281-.719T3 20zm27.25 1.188q.625.5.719 1.313t-.469 1.5l-.563.75q-.5.625-1.344.719t-1.469-.469l-.313-.25-2 2.375q-.563.75-1.531.875t-1.719-.5l-1.125-1q-1.063 1.313-2.719 1.5t-2.906-.875l-5.688-5.125H7.998v-14l3.438-3.438Q11.999 4 12.811 4h5.25l-5.125 4.688q-1.375 1.25-1.438 3.125t1.188 3.25q1.25 1.313 3.094 1.406t3.281-1.156l1.875-1.688z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'envelope-open' => array(
		'p' => 'M32 29q0 1.25-.875 2.125T29 32H3q-1.25 0-2.125-.875T0 29V12.562q0-1.5 1.125-2.375 2.563-2 10.313-7.625l.875-.656 1.313-.938 1.156-.625 1.219-.344 1.219.344 1.156.625 1.313.938.875.656q7.75 5.625 10.313 7.625 1.125.875 1.125 2.375V29zm-4.125-12.312q-.25-.375-.688-.125-2.188 1.688-6.625 4.875l-.875.656-1.313.938-1.156.625-1.219.344q-.438 0-.938-.188t-1.031-.531-.938-.625-.969-.719-.688-.5Q6.997 18.25 4.81 16.563q-.438-.25-.688.125l-.563.875q-.125.125-.125.25 0 .25.188.438 2.25 1.625 6.625 4.75.125.125.813.656t1.125.844 1.156.719 1.375.594 1.281.188 1.281-.188 1.375-.594 1.156-.719 1.125-.844.813-.656q4.375-3.125 6.625-4.75.188-.188.188-.438 0-.125-.125-.25z'
	    ),
	    'address-book' => array(
		'p' => 'M27.25 10H26v4h1.25q.75 0 .75.75v2.5q0 .75-.75.75H26v4h1.25q.75 0 .75.75v2.5q0 .75-.75.75H26v3q0 1.25-.875 2.125T23 32H3q-1.25 0-2.125-.875T0 29V3Q0 1.75.875.875T3 0h20q1.25 0 2.125.875T26 3v3h1.25q.75 0 .75.75v2.5q0 .75-.75.75zM13 8q-1.625 0-2.813 1.188t-1.188 2.813 1.188 2.813T13 16.002t2.813-1.188 1#q#813-1#q#813T13 8zm7 14.813v-1.188q0-1.5-1.219-2.563t-2.969-1.063h-.313q-1.188.5-2.5.5t-2.5-.5h-.313q-1.125 0-2.094.469t-1.531 1.313-.563 1.844v1.188q0 .5.406.844t.969.344h11.25q.563 0 .969-.344t.406-.844z',
		'w' => .875,
		'vw' => 28
	    ),
	    'address-card' => array(
		'p' => 'M33 2q1.25 0 2.125.875T36 5v22q0 1.25-.875 2.125T33 30H3q-1.25 0-2.125-.875T0 27V5q0-1.25.875-2.125T3 2h30zM11 8Q9.375 8 8.187 9.188t-1.188 2.813 1.188 2.813T11 16.002t2.813-1.188 1#q#813-1#q#813T11 8zm7 14.813v-1.188q0-1.5-1.219-2.563t-2.969-1.063h-.313q-1.188.5-2.5.5t-2.5-.5h-.313q-1.75 0-2.969 1.063t-1.219 2.563v1.188q0 .5.406.844t.969.344h11.25q.563 0 .969-.344t.406-.844zM32 19.5v-1q0-.5-.5-.5h-9q-.5 0-.5.5v1q0 .5.5.5h9q.5 0 .5-.5zm0-4v-1q0-.5-.5-.5h-9q-.5 0-.5.5v1q0 .5.5.5h9q.5 0 .5-.5zm0-4v-1q0-.5-.5-.5h-9q-.5 0-.5.5v1q0 .5.5.5h9q.5 0 .5-.5z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'user-circle' => array(
		'p' => '#d#0 6q-2.25 0-3.875 1.625T10 12t1.625 3.875T15.5 17.5t3.875-1.625T21 12t-1.625-3.875T15.5 6.5zm0 21.5q5.563 0 9.125-4.25-.875-1.688-2.5-2.719T18.5 20q-.188 0-.438.063-1.313.438-2.563.438t-2.563-.438q-.25-.063-.438-.063-2 0-3.625 1.031t-2.5 2.719Q9.936 28 15.498 28z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'id-badge' => array(
		'p' => 'M21 0q1.25 0 2.125.875T24 3v26q0 1.25-.875 2.125T21 32H3q-1.25 0-2.125-.875T0 29V3Q0 1.75.875.875T3 0h18zM9 2q-.438 0-.719.281T8 3t.281.719T9 4h6q.438 0 .719-.281T16 3t-.281-.719T15 2H9zm3 8q-1.625 0-2.813 1.188t-1.188 2.813 1.188 2.813T12 18.002t2.813-1.188 1#q#813-1#q#813T12 10zm7 14.813v-1.188q0-1.5-1.219-2.563t-2.969-1.063h-.313q-1.188.5-2.5.5t-2.5-.5h-.313q-1.75 0-2.969 1.063t-1.219 2.563v1.188q0 .5.406.844t.969.344h11.25q.563 0 .969-.344t.406-.844z',
		'w' => .75,
		'vw' => 24
	    ),
	    'id-card' => array(
		'p' => 'M33 2q1.25 0 2.125.875T36 5v1H0V5q0-1.25.875-2.125T3 2h30zM0 27V8h36v19q0 1.25-.875 2.125T33 30H3q-1.25 0-2.125-.875T0 27zm22-14.5v1q0 .5.5.5h9q.5 0 .5-.5v-1q0-.5-.5-.5h-9q-.5 0-.5.5zm0 4v1q0 .5.5.5h9q.5 0 .5-.5v-1q0-.5-.5-.5h-9q-.5 0-.5.5zm0 4v1q0 .5.5.5h9q.5 0 .5-.5v-1q0-.5-.5-.5h-9q-.5 0-.5.5zM11 12q-1.625 0-2.813 1.188t-1.188 2.813 1.188 2.813T11 20.002t2.813-1.188 1#q#813-1#q#813T11 12zM4.188 24.75q-.125.438.188.844t.813.406h11.625q.5 0 .813-.375t.188-.875q-.375-1.188-1.438-1.969T14.002 22h-.5q-1.188.5-2.5.5t-2.5-.5h-.5q-.875 0-1.656.344t-1.344.969-.813 1.438z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'thermometer-full' => array(
		'p' => 'M14 6v12.688q2 2.313 2 5.313 0 3.313-2.344 5.656T8 32.001h-.063q-3.313 0-5.625-2.375t-2.313-5.688q0-3 2-5.25V6q0-2.5 1.75-4.25T7.999 0t4.25 1.75T13.999 6zM8 29q2.063 0 3.531-1.469T13 24q0-.375-.063-.75t-.125-.656-.25-.625-.281-.531-.313-.469-.313-.406-.344-.406-.313-.344V6q0-1.25-.875-2.125T7.998 3t-2.125.875T4.998 6v13.813q-.063.063-.313.375t-.344.406-.313.375-.313.469-.281.531-.25.625-.125.625-.063.781q0 1.313.656 2.469t1.813 1.844 2.469.688h.063zm4-5q0 1.688-1.156 2.844T8 28t-2.844-1.156T4 24q0-2.313 2-3.438V5.999q0-.813.594-1.406T8 3.999t1.406.594T10 5.999v14.563q2 1.125 2 3.438z',
		'w' => .5,
		'vw' => 16
	    ),
	    'thermometer-three-quarters' => array(
		'p' => 'M12 24q0 1.688-1.156 2.844T8 28t-2.844-1.156T4 24q0-2.313 2-3.438V9.999q0-.813.594-1.406T8 7.999t1.406.594T10 9.999v10.563q2 1.125 2 3.438zm2-5.312q2 2.313 2 5.313 0 3.313-2.344 5.656T8 32.001h-.063q-3.313 0-5.625-2.375t-2.313-5.688q0-3 2-5.25V6q0-2.5 1.75-4.25T7.999 0t4.25 1.75T13.999 6v12.688zM13 24q0-.375-.063-.75t-.125-.656-.25-.625-.281-.531-.313-.469-.313-.406-.344-.406-.313-.344V6q0-1.25-.875-2.125T7.998 3t-2.125.875T4.998 6v13.813q-.063.063-.313.375t-.344.406-.313.375-.313.469-.281.531-.25.625-.125.625-.063.781q0 1.313.656 2.469t1.813 1.844 2.469.688h.063q2.063 0 3.531-1.469t1.469-3.531z',
		'w' => .5,
		'vw' => 16
	    ),
	    'thermometer-half' => array(
		'p' => 'M12 24q0 1.688-1.156 2.844T8 28t-2.844-1.156T4 24q0-2.313 2-3.438v-6.563q0-.813.594-1.406T8 11.999t1.406.594.594 1.406v6.563q2 1.125 2 3.438zm2-5.312q2 2.313 2 5.313 0 3.313-2.344 5.656T8 32.001h-.063q-3.313 0-5.625-2.375t-2.313-5.688q0-3 2-5.25V6q0-2.5 1.75-4.25T7.999 0t4.25 1.75T13.999 6v12.688zM13 24q0-.375-.063-.75t-.125-.656-.25-.625-.281-.531-.313-.469-.313-.406-.344-.406-.313-.344V6q0-1.25-.875-2.125T7.998 3t-2.125.875T4.998 6v13.813q-.063.063-.313.375t-.344.406-.313.375-.313.469-.281.531-.25.625-.125.625-.063.781q0 1.313.656 2.469t1.813 1.844 2.469.688h.063q2.063 0 3.531-1.469t1.469-3.531z',
		'w' => .5,
		'vw' => 16
	    ),
	    'thermometer-quarter' => array(
		'p' => 'M12 24q0 1.688-1.156 2.844T8 28t-2.844-1.156T4 24q0-2.313 2-3.438v-2.563q0-.813.594-1.406T8 15.999t1.406.594.594 1.406v2.563q2 1.125 2 3.438zm2-5.312q2 2.313 2 5.313 0 3.313-2.344 5.656T8 32.001h-.063q-3.313 0-5.625-2.375t-2.313-5.688q0-3 2-5.25V6q0-2.5 1.75-4.25T7.999 0t4.25 1.75T13.999 6v12.688zM13 24q0-.375-.063-.75t-.125-.656-.25-.625-.281-.531-.313-.469-.313-.406-.344-.406-.313-.344V6q0-1.25-.875-2.125T7.998 3t-2.125.875T4.998 6v13.813q-.063.063-.313.375t-.344.406-.313.375-.313.469-.281.531-.25.625-.125.625-.063.781q0 1.313.656 2.469t1.813 1.844 2.469.688h.063q2.063 0 3.531-1.469t1.469-3.531z',
		'w' => .5,
		'vw' => 16
	    ),
	    'thermometer-empty' => array(
		'p' => 'M12 24q0 1.688-1.156 2.844T8 28t-2.844-1.156T4 24t1.156-2.844T8 20t2.844 1.156T12 24zm2-5.312q2 2.313 2 5.313 0 3.313-2.344 5.656T8 32.001h-.063q-3.313 0-5.625-2.375t-2.313-5.688q0-3 2-5.25V6q0-2.5 1.75-4.25T7.999 0t4.25 1.75T13.999 6v12.688zM13 24q0-.375-.063-.75t-.125-.656-.25-.625-.281-.531-.313-.469-.313-.406-.344-.406-.313-.344V6q0-1.25-.875-2.125T7.998 3t-2.125.875T4.998 6v13.813q-.063.063-.313.375t-.344.406-.313.375-.313.469-.281.531-.25.625-.125.625-.063.781q0 1.313.656 2.469t1.813 1.844 2.469.688h.063q2.063 0 3.531-1.469t1.469-3.531z',
		'w' => .5,
		'vw' => 16
	    ),
	    'shower' => array(
		'p' => 'M24.375 8.5L14.5 18.375q-.438.438-1.063.438t-1.063-.438l-.75-.75q-.438-.438-.438-1.063t.438-1.063q-1.563-1.875-1.625-4.344t1.438-4.406q-1.188-.75-2.563-.75-2 0-3.438 1.438t-1.438 3.438V30h-4V10.875q0-3.688 2.594-6.281T8.873 2q3.438 0 6 2.313 1.625-.5 3.438-.156t3.188 1.469q.438-.438 1.063-.438t1.063.438l.75.75q.438.438.438 1.063t-.438 1.063zM24 13q0 .438-.281.719T23 14t-.719-.281T22 13t.281-.719T23 12t.719.281T24 13zm2 0q0-.438.281-.719T27 12t.719.281T28 13t-.281.719T27 14t-.719-.281T26 13zm6 0q0 .438-.281.719T31 14t-.719-.281T30 13t.281-.719T31 12t.719.281T32 13zm-10 2q0 .438-.281.719T21 16t-.719-.281T20 15t.281-.719T21 14t.719.281T22 15zm3-1q.438 0 .719.281T26 15t-.281.719T25 16t-.719-.281T24 15t.281-.719T25 14zm5 1q0 .438-.281.719T29 16t-.719-.281T28 15t.281-.719T29 14t.719.281T30 15zm-10 2q0 .438-.281.719T19 18t-.719-.281T18 17t.281-.719T19 16t.719.281T20 17zm2 0q0-.438.281-.719T23 16t.719.281T24 17t-.281.719T23 18t-.719-.281T22 17zm6 0q0 .438-.281.719T27 18t-.719-.281T26 17t.281-.719T27 16t.719.281T28 17zm-8 2q0-.438.281-.719T21 18t.719.281T22 19t-.281.719T21 20t-.719-.281T20 19zm6 0q0 .438-.281.719T25 20t-.719-.281T24 19t.281-.719T25 18t.719.281T26 19zm-6 2q0 .438-.281.719T19 22t-.719-.281T18 21t.281-.719T19 20t.719.281T20 21zm4 0q0 .438-.281.719T23 22t-.719-.281T22 21t.281-.719T23 20t.719.281T24 21zm-2 2q0 .438-.281.719T21 24t-.719-.281T20 23t.281-.719T21 22t.719.281T22 23zm-2 2q0 .438-.281.719T19 26t-.719-.281T18 25t.281-.719T19 24t.719.281T20 25z'
	    ),
	    'bath' => array(
		'p' => 'M30.5 16q.625 0 1.063.438t.438 1.063v1q#p#8H30v2q0 2.688-2 4.5v2q#p#8h-1q-.625 0-1.063-.438t-.438-1.063v-.5h-16v.5q#p#8h-1q-.625 0-1.063-.438t-.438-1.063v-2q-2-1.813-2-4.5v-2h-.5q-.625 0-1.063-.438t-.438-1.063v-1q0-.625.438-1.063T1.496 16h.5V7q0-2.063 1.469-3.531T6.996 2q2.625 0 4.125 2.125 2.25-.625 4 1 .5-.5 1 0l.75.75q.5.5 0 1.063l-5.938 5.938q-.563.5-1.063 0l-.75-.75q-.5-.5 0-1-1-1.063-1.125-2.531t.688-2.656q-.563-.938-1.688-.938-.813 0-1.406.594t-.594 1.406v9h25.5z'
	    ),
	    'podcast' => array(
		'p' => 'M16.688 30.563q-.375 1.438-2.688 1.438t-2.688-1.438q-.438-1.563-.875-4.219t-.438-4.094q0-2.75 4-2.75t4 2.75q0 1.438-.438 4.094t-.875 4.219zm-6.875-12.5q.313.313-.063.563-.875.625-1.313 1.563-.25.5-.563.125-2.875-2.688-2.875-6.563 0-3#r#719-6.469t6.531-2.531q3.563.125 6.125 2.656t2.625 6.094q.125 4.063-2.875 6.813-.313.375-.563-.125-.438-.938-1.313-1.563-.375-.25-.063-.563 1.813-1.813 1.813-4.313 0-2.563-1.844-4.344T13.748 7.75q-2.313.125-3.969 1.781T7.998 13.5q-.125 2.688 1.813 4.563zM14 0q5.813 0 9.906 4.094T28 14q0 4.125-2.188 7.5t-5.688 5.063q-.188.125-.375 0t-.125-.375q.25-1.688.313-2.938 2.313-1.5 3.688-3.938T25 13.999q0-1.813-.563-3.469t-1.594-3.031-2.375-2.375-3.031-1.563-3.438-.563q-4.563 0-7.781 3.219t-3.219 7.719q0 2.813 1.313 5.25t3.563 3.938q.188.125.188.313.063 1.188.313 2.75.063.25-.125.375t-.375 0q-3.563-1.688-5.719-5.063t-2.156-7.5q0-5.813 4.094-9.906t9.906-4.094zm0 10q1.688 0 2.844 1.156T18 14t-1.156 2.844T14 18t-2.844-1.156T10 14t1.156-2.844T14 10z',
		'w' => .875,
		'vw' => 28
	    ),
	    'window-maximize' => array(
		'p' => '#l#m-1 10V6.75Q28 6 27.25 6H4.75Q4 6 4 6.75V12h24z'
	    ),
	    'window-minimize' => array(
		'p' => 'M29 22q1.25 0 2.125.875T32 25v2q0 1.25-.875 2.125T29 30H3q-1.25 0-2.125-.875T0 27v-2q0-1.25.875-2.125T3 22h26z'
	    ),
	    'window-restore' => array(
		'p' => 'M32 3v18q0 1.25-.875 2.125T29 24h-3V11q0-2.063-1.469-3.531T21 6H8V3q0-1.25.875-2.125T11 0h18q1.25 0 2.125.875T32 3zm-8 8v18q0 1.25-.875 2.125T21 32H3q-1.25 0-2.125-.875T0 29V11q0-1.25.875-2.125T3 8h18q1.25 0 2.125.875T24 11zm-4.25 1.75q0-.75-.75-.75H4.75Q4 12 4 12.75V16h15.75v-3.25z'
	    ),
	    'microchip' => array(
		'p' => 'M26 3v26q0 1.25-.875 2.125T23 32H9q-1.25 0-2.125-.875T6 29V3q0-1.25.875-2.125T9 0h14q1.25 0 2.125.875T26 3zm6 3.625v.75q0 .375-.375.375H30.5v.375q0 .375-.375.375H27.5v-3h2.625q.375 0 .375.375v.375h1.125q.375 0 .375.375zm0 6v.75q0 .375-.375.375H30.5v.375q0 .375-.375.375H27.5v-3h2.625q.375 0 .375.375v.375h1.125q.375 0 .375.375zm0 6v.75q0 .375-.375.375H30.5v.375q0 .375-.375.375H27.5v-3h2.625q.375 0 .375.375v.375h1.125q.375 0 .375.375zm0 6v.75q0 .375-.375.375H30.5v.375q0 .375-.375.375H27.5v-3h2.625q.375 0 .375.375v.375h1.125q.375 0 .375.375zM1.875 23.5H4.5v3H1.875q-.375 0-.375-.375v-.375H.375Q0 25.75 0 25.375v-.75q0-.375.375-.375H1.5v-.375q0-.375.375-.375zm0-6H4.5v3H1.875q-.375 0-.375-.375v-.375H.375Q0 19.75 0 19.375v-.75q0-.375.375-.375H1.5v-.375q0-.375.375-.375zm0-6H4.5v3H1.875q-.375 0-.375-.375v-.375H.375Q0 13.75 0 13.375v-.75q0-.375.375-.375H1.5v-.375q0-.375.375-.375zm0-6H4.5v3H1.875q-.375 0-.375-.375V7.75H.375Q0 7.75 0 7.375v-.75q0-.375.375-.375H1.5v-.375q0-.375.375-.375z'
	    ),
	    'snowflake' => array(
		'p' => 'M27.5 21.563q.375.188.469.594t-.094.719l-1 1.688q-.438.813-1.313.375l-2.063-1.25.375 1.625q.125.375-.063.719t-.563.469l-.938.25q-.375.125-.75-.094t-.438-.594l-1.188-4.438-3.938-2.25v4.875l3.313 3.313q.313.313.313.719t-.313.719l-.688.688q-.313.313-.719.313t-.656-.313l-1.25-1.188v2.5q0 .438-.313.719t-.688.281h-2q-.438 0-.719-.281t-.281-.719v-2.5l-1.25 1.188q-.313.313-.719.313t-.656-.313l-.75-.688q-.313-.313-.313-.719t.313-.656l3.375-3.375v-4.875l-3.938 2.25-1.188 4.438q-.125.375-.469.594t-.719.094l-.938-.25q-.375-.063-.563-.438t-.125-.75l.438-1.625-2.063 1.25q-.875.438-1.313-.375l-1-1.688q-.5-.813.375-1.313l2.125-1.188-1.625-.438q-.438-.125-.625-.469t-.063-.719l.25-.938q.063-.375.406-.594t.781-.094l4.375 1.188 4-2.313-4-2.313-4.375 1.188q-.438.125-.781-.094t-.406-.594l-.25-.938q-.125-.375.063-.719t.625-.469l1.625-.438-2.125-1.188q-.875-.5-.375-1.313l1-1.688q.438-.813 1.313-.375l2.063 1.25-.375-1.625q-.125-.25-.031-.5t.25-.438.406-.25l.938-.25q.25-.063.5 0t.438.25.25.438l1.188 4.438 3.938 2.25V7.746L8.62 4.433q-.25-.313-.25-.719t.25-.719l.75-.688q.688-.75 1.375 0l1.25 1.188v-2.5q0-.438.281-.719t.719-.281h2q.438 0 .719.281t.281.719v2.5l1.25-1.188q.25-.313.688-.313t.688.313l.75.688q.25.313.25.719t-.25.719l-3.375 3.313v4.875l3.938-2.25 1.188-4.438q.063-.375.438-.594t.75-.094l.938.25q.375.125.563.469t.063.719l-.375 1.625 2.063-1.25q.875-.438 1.313.375l1 1.688q.438.813-.375 1.313l-2.125 1.188L27 12.06q.438.125.625.469t.063.719l-.25.938q-.063.375-.406.594t-.781.094l-4.375-1.188-4 2.313 4 2.313 4.375-1.188q.438-.125.781.094t.406.594l.25.938q.125.375-.063.719t-.625.469l-1.625.438z',
		'w' => .875,
		'vw' => 28
	    ),
	    'utensil-spoon' => array(
		'p' => 'M30 2q2.5 2.625 1.875 6.906T28.25 16.25q-2.25 2.25-5 2.656T18.187 18l-12 13.438q-.5.563-1.219.563t-1.281-.5L.499 28.313q-.5-.563-.5-1.281t.563-1.219l13.438-12q-1.313-2.313-.906-5.063t2.656-5q3.063-3 7.344-3.625T30 2z'
	    ),
	    'utensils' => array(
		'p' => 'M13 .938q1 5.938 1 8.063 0 2.375-1.156 4.094t-3.156 2.469l.813 14.875q.063.625-.406 1.094t-1.094.469h-4q-.625 0-1.094-.469t-.406-1.094l.813-14.875q-1.313-.5-2.281-1.406t-1.5-2.219-.531-2.938q0-2.125 1-8.063Q1.127 0 2.502 0t1.5 1v8.875q.063.125.5.125t.5-.125q.063-.688#q#906t.219-4.063T5.503 1q.125-1 1.5-1t1.5 1q.063.5.5 8.875.063.125.5.125t.5-.125V1q.125-1 1.5-1t1.5.938zm7.438 17.875q-2.75-2.188-3.813-4.875t-.469-5.063 1.906-4.438 3.094-3.25T24.5-.001q.625 0 1.063.438t.438 1.063v29q#p#8H21q-.688 0-1.125-.5t-.375-1.125z',
		'w' => .8125,
		'vw' => 26
	    ),
	    'cutlery'=>'utensils',
	    'undo-alt' => array(
		'p' => 'M16 .5q4.188 0 7.75 2.063t5.656 5.656T31.5 16q0 6.438-4.531 10.969T16 31.5q-5.938 0-10.375-4Q5 27 5.562 26.437l2.5-2.5q.5-.5 1-.063 3 2.625 6.938 2.625 4.375 0 7.406-3.063t3.094-7.375q.063-4.438-3.094-7.531t-7.469-3.031q-4.125.063-7.125 2.813l2.625 2.625q.688.688.313 1.625t-1.375.938H2q-.625 0-1.063-.438t-.438-1.063V3.624q0-1 .938-1.375t1.625.313l2.25 2.25Q9.75.499 16 .499z'
	    ),
	    'trash-alt' => array(
		'p' => 'M2 29V8h24v21q0 1.25-.875 2.125T23 32H5q-1.25 0-2.125-.875T2 29zm17-16v14q0 .438.281.719T20 28t.719-.281T21 27V13q0-.438-.281-.719T20 12t-.719.281T19 13zm-6 0v14q0 .438.281.719T14 28t.719-.281T15 27V13q0-.438-.281-.719T14 12t-.719.281T13 13zm-6 0v14q0 .438.281.719T8 28t.719-.281T9 27V13q0-.438-.281-.719T8 12t-.719.281T7 13zM27 2q.438 0 .719.281T28 3v2q0 .438-.281.719T27 6H1q-.438 0-.719-.281T0 5V3q0-.438.281-.719T1 2h7.5L9.063.812q.438-.813 1.375-.813h7.125q.938 0 1.375.813L19.501 2h7.5z',
		'w' => .875,
		'vw' => 28
	    ),
	    'sync-alt' => array(
		'p' => 'M23.188 8.313Q20.125 5.5 16 5.5q-3.625 0-6.469 2.219t-3.719 5.719q-.125.563-.75.563H1.499q-.375 0-.594-.281t-.156-.594q1.063-5.438 5.344-9.031T15.999.501q6.188 0 10.688 4.313l2.25-2.25q.688-.688 1.625-.313t.938 1.375v8.375q#p#8h-8.375q-1 0-1.375-.938t.313-1.625zM2 18.5h8.375q1 0 1.375.938t-.313 1.625l-2.625 2.625q3.063 2.813 7.188 2#r#375 0 4.5-1.031t3.625-2#r#063-4.094q.125-.563.75-.563h3.563q.375 0 .594.281t.156.594q-1.063 5.438-5.344 9.031T16.001 31.5q-6.188 0-10.688-4.313l-2.25 2.25q-.688.688-1.625.313T.5 28.375V20q0-.625.438-1.063t1.063-.438z'
	    ),
	    'stopwatch' => array(
		'p' => 'M27 19q0 5.375-3.813 9.188t-9.188 3.813-9.188-3.813T.998 19q0-4.813 3.156-8.469t7.844-4.406V4h-1.75q-.75 0-.75-.75V.75q0-.75.75-.75h7.5q.75 0 .75.75v2.5q0 .75-.75.75h-1.75v2.125q3.5.563 6.25 2.813l1.688-1.688q.563-.563 1.063 0L26.749 9q.563.5 0 1.063l-1.875 1.875q2.125 3.188 2.125 7.063zm-11 2.25v-9.5q0-.25-.219-.5T15.25 11h-2.5q-.313 0-.531.25t-.219.5v9.5q0 .75.75.75h2.5q.75 0 .75-.75z',
		'w' => .875,
		'vw' => 28
	    ),
	    'sign-out-alt' => array(
		'p' => 'M31.063 17.063l-10.5 10.5q-.688.688-1.625.313T18 26.501v-6H9.5q-.625 0-1.063-.438T7.999 19v-6q0-.625.438-1.063t1.063-.438H18v-6q0-1 .938-1.375t1.625.313l10.5 10.5q.438.438.438 1.063t-.438 1.063zM12 27.25q0 .75-.75.75H6q-2.5 0-4.25-1.75T0 22V10q0-2.5 1.75-4.25T6 4h5.25q.75 0 .75.75v2.5q0 .75-.75.75H6q-.813 0-1.406.594T4 10v12q0 .813.594 1.406T6 24h5.25q.75 0 .75.75v2.5z',
		'w' => .982421875,
		'vw' => 31
	    ),
	    'sign-in-alt' => array(
		'p' => 'M26 28h-5.25q-.75 0-.75-.75v-2.5q0-.75.75-.75H26q.813 0 1.406-.594T28 22V10q0-.813-.594-1.406T26 8h-5.25Q20 8 20 7.25v-2.5q0-.75.75-.75H26q2.5 0 4.25 1.75T32 10v12q0 2.5-1.75 4.25T26 28zm-2.937-12.562q.438.438.438 1.063t-.438 1.063l-10.5 10.5q-.688.688-1.625.313T10 27.002v-6H1.5q-.625 0-1.063-.438t-.438-1.063v-6q0-.625.438-1.063T1.5 12H10V6q0-1 .938-1.375t1.625.313z'
	    ),
	    'redo-alt' => array(
		'p' => 'M16 .5q6.25 0 10.688 4.313l2.25-2.25q.688-.688 1.625-.313t.938 1.375V12q0 .625-.438 1.063T30 13.501h-8.375q-1 0-1.375-.938t.313-1.625l2.625-2.625q-3-2.75-7.125-2.813-4.313-.063-7.469 3.031T5.5 16.062q.063 4.313 3.094 7.375T16 26.5q3.938 0 6.938-2.625.5-.438 1 .063l2.5 2.5q.563.563-.063 1.063-4.438 4-10.375 4-6.438 0-10.969-4.531T.5 16.001 5.063 5.032 16.001.501z',
		'w' => .998046875
	    ),
	    'poo' => array(
		'p' => 'M28.188 23.063q1.625.25 2.719 1.5t1.094 2.938q0 1.875-1.313 3.188T27.5 32.002h-23q-1.875 0-3.188-1.313t-1.313-3.188q0-1.688 1.094-2.938t2.719-1.5Q1.999 21.688 1.999 19.5q0-1.875 1.313-3.188T6.5 14.999h.875Q6 13.811 6 11.999q0-1.625 1#q#813t2.813-1.188h1q2.063 0 3.531-1.469t1.469-3.531q0-1.563-.938-2.875.563-.125.938-.125 2.5 0 4.25 1.75t1.75 4.25q0 .938-.375 2h.375q1.625 0 2.813 1.188t1.188 2.813q0 1.813-1.375 3h.875q1.875 0 3.188 1.313t1.313 3.188q0 2.188-1.813 3.563zM12 16q-.813 0-1.406.594T10 18t.594 1.406T12 20t1.406-.594T14 18t-.594-1.406T12 16zm10 8.688q.063-.25-.094-.469T21.5 24h-11q-.25 0-.406.219t-.094.469q.5 1.313 2.375 2.313t3.625 1 3.625-1T22 24.688zM20 20q.813 0 1.406-.594T22 18t-.594-1.406T20 16t-1.406.594T18 18t.594 1.406T20 20z'
	    ),
	    'images' => array(
		'p' => 'M30 26v1q0 1.25-.875 2.125T27 30H3q-1.25 0-2.125-.875T0 27V11q0-1.25.875-2.125T3 8h1v13q0 2.063 1.469 3.531T9 26h21zm6-5q0 1.25-.875 2.125T33 24H9q-1.25 0-2.125-.875T6 21V5q0-1.25.875-2.125T9 2h24q1.25 0 2.125.875T36 5v16zM16 8q0-1.25-.875-2.125T13 5t-2.125.875T10 8t.875 2.125T13 11t2.125-.875T16 8zm-6 9v3h22v-7l-5.5-5.5q-.5-.5-1 0L17 16l-2.5-2.5q-.5-.5-1 0z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'pencil-alt' => array(
		'p' => 'M31.125 8.875L28.25 11.75q-.563.563-1.063 0l-6.938-6.938q-.563-.5 0-1.063L23.124.874q.875-.875 2.125-.875t2.125.875l3.75 3.75q.875.875.875 2.125t-.875 2.125zM17.75 6.25q.563-.563 1.063 0l6.938 6.938q.563.5 0 1.063L9.376 30.626l-7.625 1.375q-.75.125-1.313-.438T0 30.25l1.375-7.625zm-10 15q.625.625 1.25 0l9.625-9.625q.625-.625 0-1.25t-1.25 0L7.75 20q-.625.625 0 1.25zM5.5 26.5v-3H3.25l-.75 4 2 2 4-.75V26.5h-3z'
	    ),
	    'pen' => array(
		'p' => 'M18.188 5.813l8 8L8.813 31.188l-7.125.813q-.75.063-1.25-.438T0 30.313l.813-7.125zm12.937-1.188Q32 5.5 32 6.75t-.875 2.125l-3.563 3.563-8-8L23.125.875Q24 0 25.25 0t2.125.875z'
	    ),
	    'pen-alt' => array(
		'p' => 'M31.125 4.625Q32 5.5 32 6.75t-.875 2.125l-3.563 3.563-8-8L23.125.875Q24 0 25.25 0t2.125.875zm-15.437-1.25l5.313 5.25 5.188 5.188-12.313 12.313q-2.125 2.125-5.688 3.844t-6.5 2.031q-.75.063-1.25-.438T0 30.313q.313-2.938 2.031-6.5t3.844-5.688l9.5-9.5-1.438-1.375-6.375 6.375q-.688.688-1.438 0l-1.375-1.438q-.75-.688 0-1.438l7.438-7.375q.688-.75 1.719-.75t1.781.75z'
	    ),
	    'long-arrow-alt-down' => array(
		'p' => 'M10.5 21.625h2.875q1 0 1.375.938t-.313 1.625l-5.375 5.375q-.438.438-1.063.438t-1.063-.438l-5.375-5.375q-.688-.688-.313-1.625t1.375-.938h2.875V2.75q0-.75.75-.75h3.5q.75 0 .75.75v18.875z',
		'w' => .498046875,
		'vw' => 16
	    ),
		'long-arrow-down'=>'long-arrow-alt-down',
	    'long-arrow-alt-left' => array(
		'p' => 'M8.375 18.5v2.875q0 1-.938 1.375t-1.625-.313L.437 17.062q-.438-.438-.438-1.063t.438-1.063l5.375-5.375q.688-.688 1.625-.313t.938 1.375v2.875H27.25q.75 0 .75.75v3.5q0 .75-.75.75H8.375z',
		'w' => .875,
		'vw' => 28
	    ),
		'long-arrow-left'=>'long-arrow-alt-left',
	    'long-arrow-alt-right' => array(
		'p' => 'M19.625 13.5v-2.875q0-1 .938-1.375t1.625.313l5.375 5.375q.313.313.406.688t0 .75-.406.688l-5.375 5.375q-.688.688-1.625.313t-.938-1.375v-2.875H.75q-.75 0-.75-.75v-3.5q0-.75.75-.75h18.875z',
		'w' => .875,
		'vw' => 28
	    ),
		'long-arrow-right'=>'long-arrow-alt-right',
	    'long-arrow-alt-up' => array(
		'p' => 'M5.5 10.375H2.625q-1 0-1.375-.938t.313-1.625l5.375-5.375q.438-.438 1.063-.438t1.063.438l5.375 5.375q.688.688.313 1.625t-1.375.938h-2.875V29.25q0 .75-.75.75h-3.5q-.75 0-.75-.75V10.375z',
		'w' => .5,
		'vw' => 16
	    ),
		'long-arrow-up'=>'long-arrow-alt-up',
	    'expand-arrows-alt' => array(
		'p' => 'M28 21.5v7q#p#8h-7q-1 0-1.375-.938t.313-1.625l2.25-2.25-6.688-6.688-6.688 6.688 2.25 2.25q.688.688.313 1.625t-1.375.938h-7q-.625 0-1.063-.438T-.002 28.5v-7q0-1 .938-1.375t1.625.313l2.25 2.25L11.499 16 4.811 9.312l-2.25 2.25q-.688.688-1.625.313T-.002 10.5v-7q0-.625.438-1.063t1.063-.438h7q1 0 1.375.938t-.313 1.625l-2.25 2.25 6.688 6.688 6.688-6.688-2.25-2.25q-.688-.688-.313-1.625t1.375-.938h7q.625 0 1.063.438T28 3.5v7q0 1-.938 1.375t-1.625-.313l-2.25-2.25L16.499 16l6.688 6.688 2.25-2.25q.688-.688 1.625-.313T28 21.5z',
		'w' => .875,
		'vw' => 28
	    ),
	    'clipboard' => array(
		'p' => 'M24 7v22q0 1.25-.875 2.125T21 32H3q-1.25 0-2.125-.875T0 29V7q0-1.25.875-2.125T3 4h5q0-1.625 1#q#813t2.813-1.188 2.813 1.188T16.002 4h5q1.25 0 2.125.875T24.002 7zM12 2.5q-.625 0-1.063.438t-.438 1.063.438 1.063T12 5.502t1.063-.438.438-1.063-.438-1.063T12 2.5zm6 7.125v-1.25Q18 8 17.625 8H6.375Q6 8 6 8.375v1.25Q6 10 6.375 10h11.25Q18 10 18 9.625z',
		'w' => .75,
		'vw' => 24
	    ),
	    'arrows-alt-h' => array(
		'p' => 'M23.625 10.625q0-1 .938-1.375t1.625.313l5.375 5.375q.438.438.438 1.063t-.438 1.063l-5.375 5.375q-.688.688-1.625.313t-.938-1.375v-2.875H8.375v2.875q0 1-.938 1.375t-1.625-.313L.437 17.064q-.438-.438-.438-1.063t.438-1.063l5.375-5.375q.688-.688 1.625-.313t.938 1.375V13.5h15.25v-2.875z'
	    ),
		'arrows-h'=>'arrows-alt-h',
	    'arrows-alt-v' => array(
		'p' => 'M13.375 23.625q1 0 1.375.938t-.313 1.625l-5.375 5.375q-.438.438-1.063.438t-1.063-.438l-5.375-5.375q-.688-.688-.313-1.625t1.375-.938h2.875V8.375H2.623q-1 0-1.375-.938t.313-1.625L6.936.437q.438-.438 1.063-.438t1.063.438l5.375 5.375q.688.688.313 1.625t-1.375.938H10.5v15.25h2.875z',
		'w' => .5,
		'vw' => 16
	    ),
		'arrows-v'=>'arrows-alt-v',
	    'arrow-alt-circle-down' => array(
		'p' => 'M31.5 16q0 6.438-4.531 10.969T16 31.5 5.031 26.969.5 16 5.031 5.031 16 .5t10.969 4.531T31.5 16zM13.25 8.75V16H8.812q-.5 0-.688.469t.188.781l7.188 7.188q.5.5 1 0l7.188-7.188q.375-.313.188-.781T23.188 16H18.75V8.75Q18.75 8 18 8h-4q-.75 0-.75.75z'
	    ),
	    'arrow-alt-circle-left' => array(
		'p' => 'M16 31.5q-6.438 0-10.969-4.531T.5 16 5.031 5.031 16 .5t10.969 4.531T31.5 16t-4.531 10.969T16 31.5zm7.25-18.25H16V8.812q0-.5-.469-.688t-.781.188L7.562 15.5q-.5.5 0 1l7.188 7.188q.313.375.781.188t.469-.688V18.75h7.25q.75 0 .75-.75v-4q0-.75-.75-.75z'
	    ),
	    'arrow-alt-circle-right' => array(
		'p' => 'M16 .5q6.438 0 10.969 4.531T31.5 16t-4.531 10.969T16 31.5 5.031 26.969.5 16 5.031 5.031 16 .5zM8.75 18.75H16v4.438q0 .5.469.688t.781-.188l7.188-7.188q.5-.5 0-1L17.25 8.312q-.313-.375-.781-.188T16 8.812v4.438H8.75Q8 13.25 8 14v4q0 .75.75.75z'
	    ),
	    'arrow-alt-circle-up' => array(
		'p' => 'M.5 16q0-6.438 4.531-10.969T16 .5t10.969 4.531T31.5 16t-4.531 10.969T16 31.5 5.031 26.969.5 16zm18.25 7.25V16h4.438q.5 0 .688-.469t-.188-.781L16.5 7.562q-.5-.5-1 0L8.312 14.75q-.375.313-.188.781t.688.469h4.438v7.25q0 .75.75.75h4q.75 0 .75-.75z'
	    ),
	    'external-link-alt' => array(
		'p' => 'M36 1.5v8q0 1-.938 1.375t-1.625-.313l-2.25-2.25-15.188 15.25q-.438.438-1.063.438t-1.063-.438l-1.438-1.438q-.438-.438-.438-1.063t.438-1.063L27.685 4.81l-2.25-2.25q-.688-.688-.313-1.625t1.375-.938h8q.625 0 1.063.438t.438 1.063zM25.438 16.938q.688-.75 1.625-.344T28.001 18v11#n#.001 32h-22q-1.25 0-2.125-.875T.001 29V7q0-1.25.875-2.125T3.001 4h18.5q1 0 1.375.938t-.313 1.625l-1 1q-.438.438-1.063.438H4v20h20v-9q0-.625.438-1.063z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'external-link-square-alt' => array(
		'p' => '#b#m-5.5 1h-7q-1 0-1.375.938t.313 1.625l2 2L4.25 22.751q-.563.563 0 1.063l1.938 1.938q.5.563 1.063 0l12.188-12.188 2 2q.688.688 1.625.313t.938-1.375v-7q0-.625-.438-1.063t-1.063-.438z',
		'w' => .875,
		'vw' => 28
	    ),
	    'exchange-alt' => array(
		'p' => 'M0 10.5v-1q0-.625.438-1.063t1.063-.438h22.5v-3q0-1 .938-1.375t1.625.313l5 5q.438.438.438 1.063t-.438 1.063l-5 5q-.688.688-1.625.313t-.938-1.375v-3h-22.5q-.625 0-1.063-.438T0 10.5zM30.5 20q.625 0 1.063.438t.438 1.063v1q#p#8H8v3q0 1-.938 1.375t-1.625-.313l-5-5q-.438-.438-.438-1.063t.438-1.063l5-5q.688-.688 1.625-.313T8 17v3h22.5z'
	    ),
	    'cloud-download-alt' => array(
		'p' => 'M33.625 14.188q1.813.313 3.25 1.438t2.281 2.813.844 3.563q0 3.313-2.344 5.656T32 30.002H9q-3.75 0-6.375-2.625T0 21.002q0-2.938 1.688-5.25t4.313-3.25v-.5q0-4.125 2.938-7.063t7.063-2.938q2.75 0 5.063 1.375t3.625 3.625q1.5-1 3.313-1 2.5 0 4.25 1.75t1.75 4.25q0 1.125-.375 2.188zm-8.312 5.5q.438-.438.188-1.063T24.563 18H20.5v-7q0-.438-.281-.719T19.5 10h-3q-.438 0-.719.281T15.5 11v7h-4.063q-.688 0-.938.625t.188 1.063l6.625 6.625q.688.688 1.375 0z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'cloud-upload-alt' => array(
		'p' => 'M33.625 14.188q1.813.313 3.25 1.438t2.281 2.813.844 3.563q0 3.313-2.344 5.656T32 30.002H9q-3.75 0-6.375-2.625T0 21.002q0-2.938 1.688-5.25t4.313-3.25v-.5q0-4.125 2.938-7.063t7.063-2.938q2.75 0 5.063 1.375t3.625 3.625q1.5-1 3.313-1 2.5 0 4.25 1.75t1.75 4.25q0 1.125-.375 2.188zM24.563 18q.688 0 .938-.625t-.188-1.063l-6.625-6.625q-.688-.688-1.375 0l-6.625 6.625q-.438.438-.188 1.063t.938.625h4.063v7q0 .438.281.719t.719.281h3q.438 0 .719-.281t.281-.719v-7h4.063z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'gem' => array(
		'p' => 'M30.375 0L36 10h-6.313L25.374 0h5zm-8 0l4.313 10H9.313l4.313-10h8.75zM5.625 0h5L6.312 10H-.001zM0 12h6.313l7.688 15.75q.063.125-.094.219t-.219-.031zm9.25 0h17.5l-8.563 19.875q-.063.125-.188.125t-.188-.125zM22 27.75L29.688 12h6.313L22.313 27.938q-.063.125-.219.031T22 27.75z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'level-down-alt' => array(
		'p' => 'M19.625 24.5l-6.5 7q-.5.5-1.125.5t-1.125-.5l-6.5-7q-.625-.688-.25-1.594T5.5 22h4V5H4.25q-.313 0-.5-.25l-3.5-3.5Q-.125.937.062.469T.75 0H13q.625 0 1.063.438t.438 1.063v20.5h4q1 0 1.375.906t-.25 1.594z',
		'w' => .625,
		'vw' => 20
	    ),
	    'level-up-alt' => array(
		'p' => 'M19.625 7.5q.625.688.25 1.594T18.5 10h-4v20.5q#p#8H.749q-.5 0-.688-.469t.188-.781l3.5-3.5q.188-.25.5-.25h5.25v-17h-4q-1 0-1.375-.906t.25-1.594l6.5-7q.5-.5 1.125-.5t1.125.5z',
		'w' => .625,
		'vw' => 20
	    ),
	    'lock-open' => array(
		'p' => 'M26.469 0q3.906 0 6.719 2.781T36.001 9.5v5q#p#8h-2q-.625 0-1.063-.438t-.438-1.063v-5q0-1.875-1.344-3.188t-3.219-1.313q-1.813 0-3.125 1.344t-1.313 3.219V14h3q1.25 0 2.125.875T27.998 17v12q0 1.25-.875 2.125T24.998 32h-22q-1.25 0-2.125-.875T-.002 29V17q0-1.25.875-2.125T2.998 14h14V9.625q0-4 2.781-6.813t6.688-2.813z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'map-marker-alt' => array(
		'p' => 'M10.75 31.375q-1.5-2.188-3.406-4.938t-2.719-3.875-1.875-2.781-1.406-2.344-.75-1.75-.5-1.844T0 11.999q0-5 3.5-8.5t8.5-3.5 8.5 3.5 3.5 8.5q0 1.063-.094 1.844t-.5 1.844-.75 1.75-1.406 2.344-1.875 2.781-2.719 3.875-3.406 4.938Q12.812 32 12 32t-1.25-.625zM12 17q2.063 0 3.531-1.469T17 12t-1.469-3.531T12 7 8.469 8.469 7 12t1.469 3.531T12 17z',
		'w' => .75,
		'vw' => 24
	    ),
	    'microphone-alt' => array(
		'p' => 'M21 12q.438 0 .719.281T22 13v3q0 4.125-2.719 7.219T12.5 26.875V29H16q.438 0 .719.281T17 30v1q0 .438-.281.719T16 32H6q-.438 0-.719-.281T5 31v-1q0-.438.281-.719T6 29h3.5v-2.125q-4.063-.563-6.781-3.844T0 15.5V13q0-.438.281-.719T1 12h1q.438 0 .719.281T3 13v2.625q0 3.188 2.063 5.625t5.125 2.688q3.563.375 6#q#031t2.625-5.906v-3q0-.438.281-.719t.719-.281h1zM11 22q-2.5 0-4.25-1.75T5 16V6q0-2.5 1.75-4.25T11 0t4.25 1.75T17 6h-5.313q-.688 0-.688.5v1q0 .5.688.5H17v2h-5.313q-.688 0-.688.5v1q0 .5.688.5H17v2h-5.313q-.688 0-.688.5v1q0 .5.688.5H17q0 2.5-1.75 4.25T11 22z',
		'w' => .6875,
		'vw' => 22
	    ),
	    'mobile-alt' => array(
		'p' => 'M17 0q1.25 0 2.125.875T20 3v26q0 1.25-.875 2.125T17 32H3q-1.25 0-2.125-.875T0 29V3Q0 1.75.875.875T3 0h14zm-7 30q.813 0 1.406-.594T12 28t-.594-1.406T10 26t-1.406.594T8 28t.594 1.406T10 30zm7-6.75V3.75Q17 3 16.25 3H3.75Q3 3 3 3.75v19.5q0 .75.75.75h12.5q.75 0 .75-.75z',
		'w' => .625,
		'vw' => 20
	    ),
	    'money-bill-alt' => array(
		'p' => 'M22 18q.5 0 .5.5v1q0 .5-.5.5h-4q-.5 0-.5-.5v-1q0-.5.5-.5h1v-3.438q-.125.063-.313.063-.25 0-.438-.188l-.5-.875q-.125-.125-.125-.25 0-.25.25-.438l.938-.625q.375-.25.813-.25h.875q.5 0 .5.5v5.5h1zM38 4q.813 0 1.406.594T40 6v20q0 .813-.594 1.406T38 28H2q-.813 0-1.406-.594T0 26V6q0-.813.594-1.406T2 4h36zM3 25h4q0-1.688-1.156-2.844T3 21v4zm0-14q1.688 0 2.844-1.156T7 7H3v4zm17 12q2.5 0 4.25-2.063T26 15.999t-1.75-4.938T20 8.998t-4.25 2.063T14 15.999t1.75 4.938T20 23zm17 2v-4q-1.688 0-2.844 1.156T33 25h4zm0-14V7h-4q0 1.688 1.156 2.844T37 11z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'phone-slash' => array(
		'p' => 'M16.75 23.813q.938-.438 2.125-1.125l5 3.875Q16.312 32.001 7 32.001q-1.188 0-1.438-1.188l-1.5-6.5q-.313-1.188.875-1.688l7-3q1-.438 1.75.438zm22.875 4.812q.313.25.375.656t-.188.719l-1.25 1.625q-.625.75-1.375.125L.374 3.375q-.75-.625-.188-1.438L1.436.374q.625-.75 1.438-.188l22.063 17.125q1.813-2.25 2.875-4.563l-3.75-3.125q-.875-.688-.438-1.75l3-7q.5-1.125 1.688-.813l6.5 1.5Q36 1.81 36 2.998q0 10-6.313 18z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'portrait' => array(
		'p' => 'M21 0q1.25 0 2.125.875T24 3v26q0 1.25-.875 2.125T21 32H3q-1.25 0-2.125-.875T0 29V3Q0 1.75.875.875T3 0h18zm-9 8q-1.625 0-2.813 1.188t-1.188 2.813 1.188 2.813T12 16.002t2.813-1.188 1#q#813-1#q#813T12 8zm7 14.813v-1.188q0-1.5-1.219-2.563t-2.969-1.063h-.313q-1.188.5-2.5.5t-2.5-.5h-.313q-1.75 0-2.969 1.063t-1.219 2.563v1.188q0 .5.406.844t.969.344h11.25q.563 0 .969-.344t.406-.844z',
		'w' => .75,
		'vw' => 24
	    ),
	    'reply' => array(
		'p' => 'M.5 11.875l11-9.5q.75-.625 1.625-.219T14 3.5v5q3.25.063 5.75.344t4.875 1.063 3.938 2.063 2.5 3.344.938 4.813-1.5 5.406-3.688 4.219q-.688.5-1.344.063t-.406-1.188q.563-1.938.75-3.5t-.031-2.75-.875-2.094-1.594-1.5-2.375-1-3.125-.563T14 17.001v5.5q0 .938-.875 1.344t-1.625-.219l-11-9.5q-.5-.438-.5-1.125t.5-1.125z'
	    ),
	    'shield-alt' => array(
		'p' => 'M29.125 5.25Q30 5.563 30.5 6.313t.5 1.688q0 3.938-.938 7.531t-2.375 6.188-3.344 4.688-3.688 3.375-3.531 1.969q-1.125.5-2.25 0-2.625-1.063-5.031-3.156t-4.406-5.063-3.219-7.031-1.219-8.5q0-.375.094-.719t.25-.656.375-.563.5-.469.656-.344l12-5q.5-.25 1.125-.25t1.125.25zM16 27.875q4.688-2.313 7.781-7.375T27 8.687L16 4.062v23.813z'
	    ),
	    'tablet-alt' => array(
		'p' => 'M25 0q1.25 0 2.125.875T28 3v26#n# 32H3q-1.25 0-2.125-.875T0 29V3Q0 1.75.875.875T3 0h22zM14 30q.813 0 1.406-.594T16 28t-.594-1.406T14 26t-1.406.594T12 28t.594 1.406T14 30zm11-6.75V3.75Q25 3 24.25 3H3.75Q3 3 3 3.75v19.5q0 .75.75.75h20.5q.75 0 .75-.75z',
		'w' => .875,
		'vw' => 28
	    ),
	    'tachometer-alt' => array(
		'p' => 'M18 2q7.438 0 12.719 5.281T36 20q0 4.875-2.438 9.063-.563.938-1.688.938H4.124q-1.125 0-1.688-.938Q-.002 24.875-.002 20q0-7.438 5.281-12.719T17.998 2zm0 4q-.563 0-1 .281T16.281 7 16 8q0 .813.594 1.406T18 10q.563 0 1.125-.375l.563-1.75q0-.063.125-.25l.063-.125q-.188-.688-.688-1.094T18 6zM6 24q.813 0 1.406-.594T8 22t-.594-1.406T6 20t-1.406.594T4 22t.594 1.406T6 24zm3-10q.813 0 1.406-.594T11 12t-.594-1.406T9 10t-1.406.594T7 12t.594 1.406T9 14zm15.438-4.5q.063-.313.031-.625t-.156-.563-.344-.438-.469-.313q-.625-.188-1.188.094t-.75.844l-3.813 11.5q-1.563.125-2.656 1.281t-1.094 2.719q0 1.063.563 2h6.875q.563-.938.563-2 0-1.813-1.438-3zm.875 3.563q.625.938 1.688.938.813 0 1.406-.594t.594-1.406-.594-1.406-1.406-.594q-.313 0-.688.125zM30 24q.813 0 1.406-.594T32 22t-.594-1.406T30 20t-1.406.594T28 22t.594 1.406T30 24z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'ticket-alt' => array(
		'p' => 'M8 10h20v12H8V10zm25 6q0 1.25.875 2.125T36 19v6q0 1.25-.875 2.125T33 28H3q-1.25 0-2.125-.875T0 25v-6q1.25 0 2.125-.875T3 16t-.875-2.125T0 13V7q0-1.25.875-2.125T3 4h30q1.25 0 2.125.875T36 7v6q-1.25 0-2.125.875T33 16zm-3-6.5q0-.625-.438-1.063t-1.063-.438h-21q-.625 0-1.063.438T5.998 9.5v13q0 .625.438 1.063t1.063.438h21q.625 0 1.063-.438T30 22.5v-13z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'user-alt' => array(
		'p' => 'M16 18q-3.75 0-6.375-2.625T7 9t2.625-6.375T16 0t6.375 2.625T25 9t-2.625 6.375T16 18zm8 2q3.313 0 5.656 2.344T32 28v1q0 1.25-.875 2.125T29 32H3q-1.25 0-2.125-.875T0 29v-1q0-3.313 2.344-5.656T8 20h3.438q2.188 1 4.563 1t4.563-1h3.438z'
	    ),
	    'window-close' => array(
		'p' => '#l#m-5.25 18.125L19.562 16l4.188-4.125q.563-.563 0-1.125l-2.5-2.5q-.563-.563-1.125 0L16 12.438 11.875 8.25q-.563-.563-1.125 0l-2.5 2.5q-.563.563 0 1.125L12.438 16 8.25 20.125q-.563.563 0 1.125l2.5 2.5q.563.563 1.125 0L16 19.562l4.125 4.188q.563.563 1.125 0l2.5-2.5q.563-.563 0-1.125z'
	    ),
	    'baseball-ball' => array(
		'p' => 'M23 22.75q1.188 2.438 3.25 4.375Q21.75 31.5 15.5 31.5T4.75 27.125q2-1.938 3.25-4.375l-1.813-.875q-1.063 2.063-2.813 3.813Q-.001 21.438-.001 16t3.375-9.688q1.75 1.688 2.75 3.75l1.813-.938q-1#q#375-3.188-4.25Q9.249.499 15.499.499t10.75 4.375q-2 1.938-3.188 4.313l1.813.875q1-2.063 2.75-3.75 3.375 4.25 3.375 9.688t-3.438 9.688q-1.688-1.688-2.75-3.813zm-14.25-2q1.563-4.813 0-9.625l-1.938.625q1.375 4.188.063 8.375zm13.5-9.625q-1.563 4.813 0 9.625l1.875-.625q-1.313-4.125.063-8.375z',
		'w' => .966796875,
		'vw' => 31
	    ),
	    'basketball-ball' => array(
		'p' => 'M13.25.625q-.125 4.813-2.75 8.25L5.625 4Q8.938 1.25 13.25.625zm2.25 13.25L12.625 11Q16.188 6.625 16.25.5q5.188.25 9.125 3.5zm-12-7.75L8.375 11q-3.438 2.625-8.25 2.75Q.75 9.437 3.5 6.125zm17 12.75L17.625 16 27.5 6.125q3.25 3.938 3.5 9.125-6.125.125-10.5 3.625zm-5-.75L18.375 21q-3.5 4.375-3.625 10.5-5.188-.25-9.125-3.5zm12 7.75L22.625 21q3.438-2.625 8.25-2.75-.625 4.313-3.375 7.625zm-17-12.75L13.375 16 3.5 25.875Q.25 21.937 0 16.75q6.125-.063 10.5-3.625zm7.25 18.25q.125-4#r#75-8.25L25.375 28q-3.313 2.75-7.625 3.375z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'bowling-ball' => array(
		'p' => '#i#7.5 12q.813 0 1.406-.594T9.5 10t-.594-1.406T7.5 8t-1.406.594T5.5 10t.594 1.406T7.5 12zm4-6q0 .813.594 1.406T13.5 8t1.406-.594T15.5 6t-.594-1.406T13.5 4t-1.406.594T11.5 6zm3 9q.813 0 1.406-.594T16.5 13t-.594-1.406T14.5 11t-1.406.594T12.5 13t.594 1.406T14.5 15z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'chess' => array(
		'p' => 'M4.75 13.125L2.625 7.187q-.188-.375.063-.688t.625-.313h3.188V4.311H5.126q-.375 0-.375-.375V2.498q0-.375.375-.375h1.813V.373q0-.375.375-.375h1.375q.375 0 .375.375v1.75h1.813q.375 0 .375.375v1.438q0 .375-.375.375H9.502v1.875h3.188q.375 0 .625.313t.063.688l-2.125 5.938h-6.5zm14.813 5.688q-.063-.063-.125-.188V14.25q0-.25.25-.25h1.75q.25 0 .25.25v1.938h1.438V14.25q0-.25.25-.25h3.25q.25 0 .25.25v1.938h1.438V14.25q0-.25.25-.25h1.75q.188 0 .188.25v4.375q0 .125-.063.188l-1.563 1.063q0 3.875.75 7.125h-9.25q.813-3.313.75-7.125zm4.5 3.25v1.875h1.875v-1.875q0-.375-.281-.656t-.656-.281-.656.281-.281.656zm7.5 7.312q.063.063.063.188v2.188q0 .25-.25.25h-12.75q-.25 0-.25-.25v-2.188q0-.125.063-.188l.875-.688v-.938q0-.25.25-.25h10.875q.25 0 .25.25v.938zm-16.25-.687q.188.125.188.313v2.625q0 .375-.375.375H.876q-.375 0-.375-.375v-2.625q0-.188.188-.313l1.375-.875v-1.75q0-.375.375-.375h11.125q.375 0 .375.375v1.75zM12.5 15.625h-1.625q0 6.438 1.063 9.625H4.063q1.063-3.188 1.063-9.625H3.501q-.375 0-.375-.375V14q0-.375.375-.375h9q.375 0 .375.375v1.25q0 .375-.375.375z',
		'w' => 1.00390625
	    ),
	    'chess-bishop' => array(
		'p' => 'M7.688 4.875q-.75-.25-1.219-.906T6 2.5q0-1.063.719-1.781T8.5 0h3q1 0 1.75.719T14 2.5q0 .813-.469 1.469t-1.219.906q2.25 1.563 4.25 5.125l-7.5 7.5q-.125.125-.125.281t.125.281l.875.875q.125.125.281.125t.281-.125l7.063-7.063q1.813 3.938 1.813 7.125 0 2.375-.906 3.625t-2.719 1.75v3.625H4.25v-3.625q-1.813-.5-2.719-1.75t-.906-3.625 1.031-5.25 2.688-5.281 3.344-3.594zM20 31.25q0 .75-.75.75H.75Q0 32 0 31.25v-1.5Q0 29 .75 29h18.5q.75 0 .75.75v1.5z',
		'w' => .625,
		'vw' => 20
	    ),
	    'chess-board' => array(
		'p' => 'M12 16h4v4h-4v-4zm20 4h-4v-4h4v4zM0 12h4v4H0v-4zm32 0h-4V8h4v4zm0 16h-4v-4h4v4zM16 16v-4h4v4h-4zM0 32v-4h4v4H0zm8 0v-4h4v4H8zM24 0v4h-4V0h4zM8 0v4H4V0h4zm8 32v-4h4v4h-4zM0 4h4v4H0V4zm0 16h4v4H0v-4zM16 0v4h-4V0h4zm8 32v-4h4v4h-4zM4 24h4v4H4v-4zm16 0h4v4h-4v-4zm-4-12h-4V8h4v4zm8 12v-4h4v4h-4zM8 16v4H4v-4h4zm16 0v-4h4v4h-4zm8-16v4h-4V0h4zM8 8v4H4V8h4zm16-4h4v4h-4V4zM12 24h4v4h-4v-4zm-4-4h4v4H8v-4zm8 0h4v4h-4v-4zm-4-8v4H8v-4h4zm8-4h-4V4h4v4zm-8 0H8V4h4v4zm8 4V8h4v4h-4zm0 8v-4h4v4h-4z'
	    ),
	    'chess-king' => array(
		'p' => 'M26 29.75v1.5q0 .75-.75.75H2.75Q2 32 2 31.25v-1.5q0-.75.75-.75h22.5q.75 0 .75.75zM25.5 9.5q.813 0 1.5.5t.906 1.25-.031 1.563L22.5 28.001h-17L.125 12.813q-.438-1.188.313-2.25T2.501 9.5h10v-3H9.376q-.375 0-.375-.375v-2.25q0-.375.375-.375h3.125V.375q0-.375.375-.375h2.25q.375 0 .375.375V3.5h3.125q.375 0 .375.375v2.25q0 .375-.375.375h-3.125v3h10z',
		'w' => .875,
		'vw' => 28
	    ),
	    'chess-knight' => array(
		'p' => 'M22 14v14H2v-2.938q0-1.375.75-2.594t2-1.844l3.563-1.813q.688-.313 1.188-1.094t.5-1.594v-3.125l-1.375.688q-.625.313-.813 1l-.75 2.938q-.063.375-.438.5l-1.813.75q-.125.063-.313.063-.125 0-.313-.063l-3.75-1.688q-.438-.188-.438-.688V6.623q0-.625.438-1.063l.563-.563-.875-1.75q-.125-.25-.125-.5 0-.75.75-.75h9.25q5 0 8.5 3.5t3.5 8.5zm1.25 15q.75 0 .75.75v1.5q0 .75-.75.75H.75Q0 32 0 31.25v-1.5Q0 29 .75 29h22.5zm-20-21q-.5 0-.875.375T2 9.25t.375.875.875.375.875-.375.375-.875-.375-.875T3.25 8z',
		'w' => .75,
		'vw' => 24
	    ),
	    'chess-pawn' => array(
		'p' => 'M16.5 28h-13q.125-.125.406-.344t.906-1.125 1.125-2.063.906-3.156.406-4.313h-2q-.75 0-.75-.75v-1.5q0-.75.75-.75h2.5q-1.375-.625-2.188-1.906t-.813-2.844q0-2.188 1.531-3.719t3.719-1.531 3.719 1.531 1.531 3.719q0 1.563-#r#844t-2.188 1.906h2.5q.75 0 .75.75v1.5q0 .75-.75.75h-2q0 3.688.938 6.438t1.875 3.688zm1.75 1q.75 0 .75.75v1.5q0 .75-.75.75H1.75Q1 32 1 31.25v-1.5q0-.75.75-.75h16.5z',
		'w' => .625,
		'vw' => 20
	    ),
	    'chess-queen' => array(
		'p' => 'M27.25 32H4.75Q4 32 4 31.25v-1.5q0-.75.75-.75h22.5q.75 0 .75.75v1.5q0 .75-.75.75zM15.969 0q1.469 0 2.5 1.031T19.5 3.5t-1.031 2.469T15.969 7 13.5 5.969t-1-2.469 1-2.469T15.969 0zM28.75 9.688l2.5 1.25q.375.25.375.688 0 .125-.063.313l-6.563 16.063h-18L.436 11.939q-.063-.188-.063-.313 0-.438.375-.688l2.5-1.25q.625-.375 1 .25 1.375 2.375 2.75 2.375.875 0 1.313-.469t.531-1.094.156-2q0-.188.063-.313t.156-.219.219-.156.313-.063h2.563q.5 0 .688.5.875 2.563 3 2.563t3-2.563q.188-.5.688-.5h2.563q.313 0 .531.219t.219.531q.063 2 .406 2.781t1.594.781q1.438 0 2.75-2.375.375-.625 1-.25z'
	    ),
	    'chess-rook' => array(
		'p' => 'M5.063 13.438L2.25 10.813Q2 10.563 2 10.25v-7.5Q2 2 2.75 2h2.5Q6 2 6 2.75V5.5h3V2.75q0-.313.219-.531T9.75 2h4.5q.313 0 .531.219T15 2.75V5.5h3V2.75q0-.313.219-.531T18.75 2h2.5q.313 0 .531.219T22 2.75v7.5q0 .313-.25.563l-2#r#625Q19 21.126 21 28.001H3q2-6.875 2.063-14.563zM10 16v4h4v-4q0-.813-.594-1.406T12 14t-1.406.594T10 16zm14 13.75v1.5q0 .75-.75.75H.75Q0 32 0 31.25v-1.5Q0 29 .75 29h22.5q.75 0 .75.75z',
		'w' => .75,
		'vw' => 24
	    ),
	    'dumbbell' => array(
		'p' => 'M6.5 6q.625 0 1.063.438t.438 1.063v17q#p#8h-3q-.625 0-1.063-.438t-.438-1.063v-6.5h-1.5q-.5 0-.5-.5v-3q0-.5.5-.5h1.5v-6.5q0-.625.438-1.063T3.5 6h3zm33 8q.5 0 .5.5v3q0 .5-.5.5H38v6.5q#p#8h-3q-.625 0-1.063-.438t-.438-1.063v-17q0-.625.438-1.063t1.063-.438h3q.625 0 1.063.438T38 7.5V14h1.5zm-11-12q.625 0 1.063.438t.438 1.063v25q#p#8h-3q-.625 0-1.063-.438t-.438-1.063v-10.5h-8v10.5q#p#8h-3q-.625 0-1.063-.438t-.438-1.063v-25q0-.625.438-1.063T11.498 2h3q.625 0 1.063.438t.438 1.063v10.5h8v-10.5q0-.625.438-1.063T25.5 2h3z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'football-ball' => array(
		'p' => 'M30.125 3.75Q30.938 7 31 10.313L21.187.5q3.375.063 6.563.938 1.875.5 2.375 2.313zM.875 28.25Q.062 25 0 21.687L9.813 31.5q-3.375-.063-6.563-.938-1.875-.5-2.375-2.313zM.25 17.688Q1.313 10.75 6.063 6.219T17.251.75l13.5 13.563q-1.063 6.938-5.813 11.469T13.75 31.251zM20.125 10l-1.813 1.75-1.75-1.75q-.375-.375-.688 0l-.75.688q-.313.375 0 .75l1.813 1.75-1.438 1.438-1.75-1.813q-.375-.313-.75 0l-.688.688q-.375.375 0 .75l1.75 1.75-1.375 1.438-1.813-1.813q-.313-.313-.688 0l-.688.75q-.375.313 0 .688l1.75 1.75-1.75 1.813q-.375.313 0 .688l.688.688q.375.375.688 0l1.813-1.75 1.75 1.75q.375.375.688 0l.75-.688q.313-.375 0-.688l-1.813-1.813 1.438-1.375 1.75 1.75q.375.375.75 0l.688-.688q.375-.375 0-.75l-1.75-1.75 1.375-1.438 1.813 1.813q.313.313.688 0l.688-.75q.375-.313 0-.688l-1.75-1.75 1.75-1.813q.375-.313 0-.688l-.688-.688q-.375-.375-.688 0z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'golf-ball' => array(
		'p' => 'M6 26h14q0 .813-.594 1.406T18 28h-1q-.813 0-1.406.594T15 30v1.25q0 .75-.75.75h-2.5q-.75 0-.75-.75V30q0-.813-.594-1.406T9 28H8q-.813 0-1.406-.594T6 26zm20-13q0 1.688-.438 3.344t-1.25 3.031-1.938 2.563-2.5 2.063H6.124q-2.813-1.75-4.469-4.656t-1.656-6.344q0-5.375 3.813-9.188T13 0t9.188 3.813 3.813 9.188zm-11.25 2.75q.875 0 1.469-.594t.594-1.469q0-1.438-1.375-1.938.438 1.25-.469 2.156t-2.156.469q.5 1.375 1.938 1.375zm3.063 2.938q0-1.438-1.375-1.938.313.813-.031 1.531t-1.063 1.031-1.531.063q.5 1.375 1.938 1.375.875 0 1.469-.625t.594-1.438zm4-4q0-1.438-1.375-1.938.438 1.25-.469 2.156t-2.156.469q.5 1.375 1.938 1.375.875 0 1.469-.625t.594-1.438z',
		'w' => .8125,
		'vw' => 26
	    ),
	    'hockey-puck' => array(
		'p' => 'M0 10q0-2.5 4.688-4.25T16.001 4t11.313 1.75T32.002 10t-4.688 4.25T16.001 16 4.688 14.25 0 10zm0 5.125q3.438 2.5 9.719 3.438t12.563 0 9.719-3.438V22q0 2.5-4.688 4.25T16 28 4.687 26.25-.001 22v-6.875z'
	    ),
	    'quidditch' => array(
		'p' => 'M16 13.563l5.438 6.813q0 .25-.094.719t-.5 1.719-.875 2.375-1.375 2.438-1.906 2.125Q15 31.065 10.844 31.596t-7.531.406L0 31.877q.25-1.438.688-3.438l5.938-7q.188-.25 0-.469t-.438-.156l-3.75 1.375q1.563-4.625 3.375-6.063 1.688-1.375 4.219-2t4.281-.625zM30.875 22q2.125 0 3.563 1.469T35.876 27t-1.438 3.531T30.907 32t-3.531-1.469T25.938 27q0-1.063.375-1.969t1.063-1.594 1.594-1.063 1.906-.375zM39.75 1.938q.625.813-.125 1.438l-14.5 11.063 2.125 2.688q.188.313.063.688t-.5.438l-3.688.75-5.375-6.813 1.563-3.438q.188-.313.563-.344t.625.219l2.125 2.688L37.126.19q.813-.563 1.438.188z',
		'w' => 1.248046875,
		'vw' => 40
	    ),
	    'square-full' => array(
		'p' => 'M32 32H0V0h32v32z'
	    ),
	    'table-tennis' => array(
		'p' => 'M31 18.5q-3-2-6.531-1.375t-5.656 3.563L5.563 7.438l3.5-3.5Q13.001 0 18.563 0t9.5 3.938q2.938 2.938 3.688 6.969t-.75 7.594zm-13.625 5Q17 24.875 17 26q0 1.813.688 3.438-2.563-.313-4.375-2.063l-2.25-2.25L5.5 31.563q-.375.438-.906.438t-.906-.375L.375 28.313Q0 27.938 0 27.407t.438-.906l6.438-5.563-2#q#188q-1.813-1.813-2.094-4.344T3.625 9.75zM26 20q2.5 0 4.25 1.75T32 26t-1.75 4.25T26 32t-4.25-1.75T20 26t1.75-4.25T26 20z'
	    ),
	    'volleyball-ball' => array(
		'p' => 'M13.938 15.188q-6.875 4.313-9.125 12.063Q2.5 25.063 1.25 22.126q1.063-4.375 4.031-7.938t7.281-5.563q1.313 3.063 1.375 6.563zm-2.313-8.375Q7.75 8.688 4.781 11.782T.25 18.751q-.938-5 1.281-9.5t6.531-6.875q2.188 2 3.563 4.438zm11.75 10.312Q20 16.75 16.937 15.062q-.25-8.125-5.813-13.938 3-.875 6.125-.5 3.313 3.125 4.906 7.469t1.219 9.031zm-7.812.625q4.75 2.5 9.938 2.5 2.438 0 5.063-.625-.75 3.063-2.625 5.625-4.375 1.25-8.938.469t-8.438-3.469q2.063-2.688 5-4.5zm-6.125 6.188q7.375 5.125 16.063 3.875-4.313 3.688-10 3.688-4.313 0-8.063-2.25.625-2.938 2-5.313zm11.25-22.5q3 1.063 5.344 3.188t3.656 5.094 1.313 6.281v.375q-2.813.938-5.625.875.375-4.313-.844-8.406t-3.844-7.406z',
		'w' => .966796875,
		'vw' => 31
	    ),
	    'allergies' => array(
		'p' => 'M26 7q.813 0 1.406.594T28 9v11q0 1.375-.313 2.625l-1.688 7.063q-.188 1-1.031 1.656T23.124 32H10.749q-1.5 0-2.438-1.25L.498 20q-.625-.875-.469-1.906t1-1.625 1.875-.438T4.498 17l1.5 2.063V4q0-.813.594-1.406T7.998 2t1.406.594T9.998 4v9.5q0 .5.5.5h1q.5 0 .5-.5V2q0-.813.594-1.406T13.998 0t1.406.594T15.998 2v11.5q0 .5.5.5h1q.5 0 .5-.5V4q0-.813.594-1.406T19.998 2t1.406.594T21.998 4v9.5q0 .5.5.5h1q.5 0 .5-.5V9q0-.813.594-1.406T25.998 7zM11 26q.438 0 .719-.281T12 25t-.281-.719T11 24t-.719.281T10 25t.281.719T11 26zm0-6q.438 0 .719-.281T12 19t-.281-.719T11 18t-.719.281T10 19t.281.719T11 20zm4 8q.438 0 .719-.281T16 27t-.281-.719T15 26t-.719.281T14 27t.281.719T15 28zm0-6q.438 0 .719-.281T16 21t-.281-.719T15 20t-.719.281T14 21t.281.719T15 22zm4 2q.438 0 .719-.281T20 23t-.281-.719T19 22t-.719.281T18 23t.281.719T19 24zm2 4q.438 0 .719-.281T22 27t-.281-.719T21 26t-.719.281T20 27t.281.719T21 28zm2-8q.438 0 .719-.281T24 19t-.281-.719T23 18t-.719.281T22 19t.281.719T23 20z',
		'w' => .875,
		'vw' => 28
	    ),
	    'band-aid' => array(
		'p' => 'M0 10q0-1.625 1#q#813t2.813-1.188h6v20h-6q-1.625 0-2.813-1.188T0 21.998v-12zm36-4q1.625 0 2.813 1.188t1.188 2.813v12q0 1.625-1.188 2.813T36 26.002h-6v-20h6zM12 26V6h16v20H12zm11-14.5q-.625 0-1.063.438t-.438 1.063.438 1.063 1.063.438 1.063-.438.438-1.063-.438-1.063T23 11.5zm0 6q-.625 0-1.063.438t-.438 1.063.438 1.063 1.063.438 1.063-.438.438-1.063-.438-1.063T23 17.5zm-6-6q-.625 0-1.063.438t-.438 1.063.438 1.063 1.063.438 1.063-.438.438-1.063-.438-1.063T17 11.5zm0 6q-.625 0-1.063.438t-.438 1.063.438 1.063 1.063.438 1.063-.438.438-1.063-.438-1.063T17 17.5z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'box' => array(
		'p' => 'M31.875 11.563l.063.438H17v-12h8.813q.688 0 1.25.25t1 .719.625 1.094zM15 0v12H.062l.063-.438 3.188-9.5q.313-.938 1.094-1.5t1.781-.563h8.813zM0 14h32v15q0 1.25-.875 2.125T29 32H3q-1.25 0-2.125-.875T0 29V14z'
	    ),
	    'boxes' => array(
		'p' => 'M35 18q.438 0 .719.281T36 19v12q0 .438-.281.719T35 32H21q-.438 0-.719-.281T20 31V19q0-.438.281-.719T21 18h5v6l2-1.313L30 24v-6h5zm-24-4q-.438 0-.719-.281T10 13V1q0-.438.281-.719T11 0h5v6l2-1.313L20 6V0h5q.438 0 .719.281T26 1v12q0 .438-.281.719T25 14H11zm4 4q.438 0 .719.281T16 19v12q0 .438-.281.719T15 32H1q-.438 0-.719-.281T0 31V19q0-.438.281-.719T1 18h5v6l2-1.313L10 24v-6h5z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'briefcase-medical' => array(
		'p' => 'M29 8q1.25 0 2.125.875T32 11v18q0 1.25-.875 2.125T29 32H3q-1.25 0-2.125-.875T0 29V11q0-1.25.875-2.125T3 8h5V5q0-1.25.875-2.125T11 2h10q1.25 0 2.125.875T24 5v3h5zM12 6v2h8V6h-8zm10 15.5v-3q0-.5-.5-.5H18v-3.5q0-.5-.5-.5h-3q-.5 0-.5.5V18h-3.5q-.5 0-.5.5v3q0 .5.5.5H14v3.5q0 .5.5.5h3q.5 0 .5-.5V22h3.5q.5 0 .5-.5z'
	    ),
	    'burn' => array(
		'p' => 'M12 0q5.313 4.813 8.656 9.969T24 18.75q0 5.875-3.344 9.563T12 32.001t-8.656-3.688T0 18.75q0-3.625 3.313-8.781T12.001 0zm0 28q2.625 0 4.313-1.656t1.688-4.281q0-3.5-6-10.063-6 6.563-6 10.063 0 2.625 1.688 4.281T12.002 28z',
		'w' => .75,
		'vw' => 24
	    ),
	    'capsules' => array(
		'p' => 'M34.688 18.75q1.688 2.438 1.188 5.344t-2.938 4.594q-1.813 1.313-4.063 1.313-3.75 0-5.875-3.063L14.812 15.25q-.438-.625-.813-1.563V23q0 2.875-2.063 4.938t-4.938 2.063-4.938-2.063T-.003 23V9q0-2.875 2.063-4.938t4.938-2.063q2.813 0 4.813 1.938t2.125 4.688q.813-2.063 2.625-3.313 1.813-1.313 4.063-1.313 3.75 0 5.875 3.063zM10 16V9q0-1.25-.875-2.125T7 6t-2.125.875T4 9v7h6zm12.188 2.813l5.125-3.625-4.063-5.813Q22.312 8 20.625 8q-1 0-1.75.563-1.125.75-1.344 2.031t.531 2.344z',
		'w' => 1.123046875,
		'vw' => 36
	    ),
	    'clipboard-check' => array(
		'p' => 'M21 4q1.25 0 2.125.875T24 7v22q0 1.25-.875 2.125T21 32H3q-1.25 0-2.125-.875T0 29V7q0-1.25.875-2.125T3 4h5q0-1.625 1#q#813t2.813-1.188 2.813 1.188T16.002 4h5zm-9-1.5q-.625 0-1.063.438t-.438 1.063.438 1.063T12 5.502t1.063-.438.438-1.063-.438-1.063T12 2.5zM19.563 17q.563-.563 0-1.063l-1.75-1.813q-.5-.5-1.063 0l-6.625 6.625-2.875-2.938q-.5-.5-1.063 0l-1.75 1.75q-.563.563 0 1.063l5.125 5.25q.563.5 1.063 0z',
		'w' => .75,
		'vw' => 24
	    ),
	    'clipboard-list' => array(
		'p' => 'M21 4q1.25 0 2.125.875T24 7v22q0 1.25-.875 2.125T21 32H3q-1.25 0-2.125-.875T0 29V7q0-1.25.875-2.125T3 4h5q0-1.625 1#q#813t2.813-1.188 2.813 1.188T16.002 4h5zM6 26.5q.625 0 1.063-.438t.438-1.063-.438-1.063T6 23.498t-1.063.438-.438 1.063.438 1.063T6 26.5zm0-6q.625 0 1.063-.438t.438-1.063-.438-1.063T6 17.498t-1.063.438-.438 1.063.438 1.063T6 20.5zm0-6q.625 0 1.063-.438t.438-1.063-.438-1.063T6 11.498t-1.063.438-.438 1.063.438 1.063T6 14.5zm6-12q-.625 0-1.063.438t-.438 1.063.438 1.063T12 5.502t1.063-.438.438-1.063-.438-1.063T12 2.5zm8 23v-1q0-.5-.5-.5h-9q-.5 0-.5.5v1q0 .5.5.5h9q.5 0 .5-.5zm0-6v-1q0-.5-.5-.5h-9q-.5 0-.5.5v1q0 .5.5.5h9q.5 0 .5-.5zm0-6v-1q0-.5-.5-.5h-9q-.5 0-.5.5v1q0 .5.5.5h9q.5 0 .5-.5z',
		'w' => .75,
		'vw' => 24
	    ),
	    'diagnoses' => array(
		'p' => 'M31 16q-.438 0-.719-.281T30 15t.281-.719T31 14t.719.281T32 15t-.281.719T31 16zm-11-5q-2.25 0-3.875-1.625T14.5 5.5t1.625-3.875T20 0t3.875 1.625T25.5 5.5t-1.625 3.875T20 11zM3.75 22.75l-1.125-1.688q-.438-.563-.281-1.438t.906-1.375q.688-.375 1.813-1 1.5 1.25 3.219.469t1.719-2.719q5.375-2 10-2 3.75 0 8.063 1.375-.313 1.563.688 2.656t2.469 1 2.344-1.469q1.75.813 3.188 1.688.813.5.938 1.375t-.313 1.438l-1.125 1.688q-.438.688-1.25.844t-1.438-.219q-3.125-1.875-6.563-3.063V26h-14v-5.688q-3.5 1.188-6.563 3.063-.625.375-1.438.219t-1.25-.844zM23 21.5q-.625 0-1.063.438t-.438 1.063.438 1.063 1.063.438 1.063-.438.438-1.063-.438-1.063T23 21.5zm-6-6q-.625 0-1.063.438t-.438 1.063.438 1.063 1.063.438 1.063-.438.438-1.063-.438-1.063T17 15.5zM7 16q-.438 0-.719-.281T6 15t.281-.719T7 14t.719.281T8 15t-.281.719T7 16zm32 12q.438 0 .719.281T40 29v2q0 .438-.281.719T39 32H1q-.438 0-.719-.281T0 31v-2q0-.438.281-.719T1 28h38z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'dna' => array(
		'p' => 'M0 30.875q.188-1.313.625-2.781T2.063 24.5t3.063-4.406T10.001 16q-2.813-1.813-4.875-4.094T2.063 7.5.625 3.906 0 1.125Q-.063.687.25.344T1 0h2q.875 0 1 .875.125.5.25 1.125h19.5q.125-.625.25-1.125Q24.125 0 25 0h2q.438 0 .75.344t.25.781q-.125 1.125-.438 2.375t-1.25 3.219-2.25 3.75-3.719 3.781-5.469 3.563q-2.75 1.375-4.875 3.188h7.938q-.813-.75-1.063-.875 2-1.063 3.688-2.25 2.625 2.25 4.406 5.063t2.313 4.563.719 3.375q.063.438-.25.781t-.75.344h-2q-.938 0-1-.875-.063-.375-.25-1.125H4.25L4 31.127q-.125.875-1 .875H1q-.438 0-.75-.344T0 30.877zM14 13.75q2.25-1.25 4-2.75h-8q1.75 1.5 4 2.75zM22.188 6H5.813q.563 1 1.313 2h13.75q.75-1 1.313-2zM5.813 26h16.313q-.5-1-1.313-2H7.125q-.75 1-1.313 2z',
		'w' => .875,
		'vw' => 28
	    ),
	    'dolly' => array(
		'p' => 'M18.375 17.375l-3.313-10q-.063-.25-.031-.5t.219-.469.438-.281l3.875-1.25 2.063 6.188 3.813-1.25-2.063-6.188 3.813-1.313q.188-.063.375-.031t.375.094.313.219.188.344l3.75 11.313q.125.438-.063.813t-.563.5l-10.063 3.313q-1.438-1.063-3.125-1.5zm17.563 3q.125.438-.063.781t-.563.531l-13.313 4.438q-.063 2.75-2.188 4.5t-4.938 1.25q-1.813-.313-3.156-1.688t-1.656-3.25q-.5-3.438 2.25-5.625L6.561 3.999H.998q-.438 0-.719-.281t-.281-.719v-2q0-.438.281-.719t.719-.281h7q1.438 0 1.875 1.375l6.25 18.625q2.813.063 4.563 2.313l13.375-4.438q.375-.125.75.063t.5.563zM16 29q1.25 0 2.125-.875T19 26t-.875-2.125T16 23t-2.125.875T13 26t.875 2.125T16 29z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'dolly-flatbed' => array(
		'p' => 'M13 20q-.438 0-.719-.281T12 19V3q0-.438.281-.719T13 2h9v8l3-2 3 2V2h9q.438 0 .719.281T38 3v16q0 .438-.281.719T37 20H13zm26 4q.438 0 .719.281T40 25v2q0 .438-.281.719T39 28h-5.188q.188.563.188 1 0 1.25-.875 2.125T31 32t-2.125-.875T28 29q0-.5.188-1H15.813q.188.563.188 1 0 1.25-.875 2.125T13.001 32t-2.125-.875T10.001 29q0-.5.188-1H5.001q-.438 0-.719-.281T4.001 27V4h-3q-.438 0-.719-.281T.001 3V1q0-.438.281-.719T1.001 0h6q.438 0 .719.281T8.001 1v23h31z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'file-medical' => array(
		'p' => 'M23.563 6.563q.438.438.438 1.063v.375h-8v-8h.375q.625 0 1.063.438z#j#14v8.5zm4 10q0-.5-.5-.5H14v-3.5q0-.5-.5-.5h-3q-.5 0-.5.5V18H6.5q-.5 0-.5.5v3q0 .5.5.5H10v3.5q0 .5.5.5h3q.5 0 .5-.5V22h3.5q.5 0 .5-.5v-3z',
		'w' => .75,
		'vw' => 24
	    ),
	    'file-medical-alt' => array(
		'p' => 'M18 8.5q0 .625.438 1.063t1.063.438h8.5v20.5q#p#8h-21q-.625 0-1.063-.438t-.438-1.063v-10.5h4.375l2.188 4.375q.125.25.438.25t.438-.25l3.563-7.125 1.375 2.75h5.625q.438 0 .719-.281t.281-.719-.281-.719-.719-.281h-4.375l-2.188-4.375q-.125-.25-.438-.25t-.438.25l-3.563 7.125-1.25-2.5q-.125-.25-.438-.25H.498q-.5 0-.5-.5v-1q0-.5.5-.5h3.5v-14.5q0-.625.438-1.063T5.499 0h12.5v8.5zm9.563-1.937q.438.438.438 1.063v.375h-8v-8h.375q.625 0 1.063.438z',
		'w' => .875,
		'vw' => 28
	    ),
	    'first-aid' => array(
		'p' => 'M0 5q0-1.25.875-2.125T3 2h3v28H3q-1.25 0-2.125-.875T0 27V5zm8 25V2h20v28H8zm4-15.5v3q0 .5.5.5H16v3.5q0 .5.5.5h3q.5 0 .5-.5V18h3.5q.5 0 .5-.5v-3q0-.5-.5-.5H20v-3.5q0-.5-.5-.5h-3q-.5 0-.5.5V14h-3.5q-.5 0-.5.5zM33 2q1.25 0 2.125.875T36 5v22q0 1.25-.875 2.125T33 30h-3V2h3z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'hospital-alt' => array(
		'p' => 'M34 6q.813 0 1.406.594T36 8v23q0 .438-.281.719T35 32H1q-.438 0-.719-.281T0 31V8q0-.813.594-1.406T2 6h8V2q0-.813.594-1.406T12 0h12q.813 0 1.406.594T26 2v4h8zM10 27.25v-2.5q0-.75-.75-.75h-2.5Q6 24 6 24.75v2.5q0 .75.75.75h2.5q.75 0 .75-.75zm0-8v-2.5q0-.75-.75-.75h-2.5Q6 16 6 16.75v2.5q0 .75.75.75h2.5q.75 0 .75-.75zm10 8v-2.5q0-.75-.75-.75h-2.5q-.75 0-.75.75v2.5q0 .75.75.75h2.5q.75 0 .75-.75zm0-8v-2.5q0-.75-.75-.75h-2.5q-.75 0-.75.75v2.5q0 .75.75.75h2.5q.75 0 .75-.75zm1-10.625v-1.25Q21 7 20.625 7H19V5.375Q19 5 18.625 5h-1.25Q17 5 17 5.375V7h-1.625Q15 7 15 7.375v1.25Q15 9 15.375 9H17v1.625q0 .375.375.375h1.25Q19 11 19 10.625V9h1.625Q21 9 21 8.625zm9 18.625v-2.5q0-.75-.75-.75h-2.5q-.75 0-.75.75v2.5q0 .75.75.75h2.5q.75 0 .75-.75zm0-8v-2.5q0-.75-.75-.75h-2.5q-.75 0-.75.75v2.5q0 .75.75.75h2.5q.75 0 .75-.75z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'hospital-symbol' => array(
		'p' => 'M16 0q6.625 0 11.313 4.688t4.688 11.313-4.688 11.313T16 32.002 4.687 27.314-.001 16.001 4.687 4.688 16 0zm7 23.5v-15q0-.5-.5-.5h-3q-.5 0-.5.5V14h-6V8.5q0-.5-.5-.5h-3Q9 8 9 8.5v15q0 .5.5.5h3q.5 0 .5-.5V18h6v5.5q0 .5.5.5h3q.5 0 .5-.5z'
	    ),
	    'id-card-alt' => array(
		'p' => 'M33 4q1.25 0 2.125.875T36 7v22q0 1.25-.875 2.125T33 32H3q-1.25 0-2.125-.875T0 29V7q0-1.25.875-2.125T3 4h9v6h12V4h9zM18 14q-1.625 0-2.813 1.188t-1.188 2.813 1.188 2.813T18 22.002t2.813-1.188 1#q#813-1#q#813T18 14zm5.813 14q.5 0 .813-.406t.188-.844q-.375-1.188-1.438-1.969T21.001 24h-.5q-1.188.5-2.5.5t-2.5-.5h-.5q-.875 0-1.656.344t-1.344.969-.813 1.438q-.125.438.188.844t.813.406h11.625zM22 2v6h-8V2q0-.813.594-1.406T16 0h4q.813 0 1.406.594T22 2z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'notes-medical' => array(
		'p' => 'M21 4q1.25 0 2.125.875T24 7v22q0 1.25-.875 2.125T21 32H3q-1.25 0-2.125-.875T0 29V7q0-1.25.875-2.125T3 4h5q0-1.625 1#q#813t2.813-1.188 2.813 1.188T16.002 4h5zm-9-1.5q-.625 0-1.063.438t-.438 1.063.438 1.063T12 5.502t1.063-.438.438-1.063-.438-1.063T12 2.5zm6 19v-3q0-.5-.5-.5H14v-3.5q0-.5-.5-.5h-3q-.5 0-.5.5V18H6.5q-.5 0-.5.5v3q0 .5.5.5H10v3.5q0 .5.5.5h3q.5 0 .5-.5V22h3.5q.5 0 .5-.5zm0-12v-1q0-.5-.5-.5h-11Q6 8 6 8.5v1q0 .5.5.5h11q.5 0 .5-.5z',
		'w' => .75,
		'vw' => 24
	    ),
	    'pallet' => array(
		'p' => 'M9 16q-.438 0-.719-.281T8 15V1q0-.438.281-.719T9 0h7v8l4-2 4 2V0h7q.438 0 .719.281T32 1v14q0 .438-.281.719T31 16H9zm30 8h-3v4h3q.438 0 .719.281T40 29v2q0 .438-.281.719T39 32H1q-.438 0-.719-.281T0 31v-2q0-.438.281-.719T1 28h3v-4H1q-.438 0-.719-.281T0 23v-2q0-.438.281-.719T1 20h38q.438 0 .719.281T40 21v2q0 .438-.281.719T39 24zm-21 4v-4H8v4h10zm14 0v-4H22v4h10z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'pills' => array(
		'p' => 'M7 2q2.875 0 4.938 2.063t2.063 4.938v14q0 2.875-2.063 4.938T7 30.002t-4.938-2.063-2.063-4.938v-14q0-2.875 2.063-4.938T7 2zm3 14V9q0-1.25-.875-2.125T7 6t-2.125.875T4 9v7h6zm8.75-1.875l13.125 13.188q.438.438 0 .75-2.938 2.188-6.625 1.906t-6.313-2.875-2.875-6.281 1.875-6.625q.375-.438.813-.063zm14.344-1.187q2.594 2.625 2.875 6.313t-1.906 6.625q-.313.438-.75 0L20.125 12.751q-.375-.438.063-#r#938-2.125 6.625-1.875t6.281 2.875z',
		'w' => 1.123046875,
		'vw' => 36
	    ),
	    'prescription-bottle' => array(
		'p' => 'M2 12V8h20v22q0 .813-.594 1.406T20 32H4q-.813 0-1.406-.594T2 30v-4h7.5q.5 0 .5-.5v-1q0-.5-.5-.5H2v-4h7.5q.5 0 .5-.5v-1q0-.5-.5-.5H2v-4h7.5q.5 0 .5-.5v-1q0-.5-.5-.5H2zM22.5 0q.625 0 1.063.438t.438 1.063v3q#p#8h-21q-.625 0-1.063-.438t-.438-1.063v-3q0-.625.438-1.063T1.5 0h21z',
		'w' => .75,
		'vw' => 24
	    ),
	    'prescription-bottle-alt' => array(
		'p' => 'M22.5 0q.625 0 1.063.438t.438 1.063v3q#p#8h-21q-.625 0-1.063-.438t-.438-1.063v-3q0-.625.438-1.063T1.5 0h21zM2 30V8h20v22q0 .813-.594 1.406T20 32H4q-.813 0-1.406-.594T2 30zm4-11.5v3q0 .5.5.5H10v3.5q0 .5.5.5h3q.5 0 .5-.5V22h3.5q.5 0 .5-.5v-3q0-.5-.5-.5H14v-3.5q0-.5-.5-.5h-3q-.5 0-.5.5V18H6.5q-.5 0-.5.5z',
		'w' => .75,
		'vw' => 24
	    ),
	    'procedures' => array(
		'p' => 'M33 14q2.875 0 4.938 2.063t2.063 4.938v10q0 .438-.281.719t-.719.281h-2q-.438 0-.719-.281t-.281-.719v-3h-32v3q0 .438-.281.719t-.719.281h-2q-.438 0-.719-.281t-.281-.719v-22q0-.438.281-.719t.719-.281h2q.438 0 .719.281t.281.719v15h12v-9q0-.438.281-.719t.719-.281h16zM8.5 6Q8 6 8 5.5v-1q0-.5.5-.5h8.813q.313 0 .438.25l1.25 2.5L22.126.562q.25-.563.875-.563t.875.563L25.626 4h6.375q.438 0 .719.281t.281.719-.281.719-.719.281h-7.625l-1.375-2.75-3.125 6.188q-.25.563-.875.563t-.875-.563L16.376 6H8.501zM10 22q-1.625 0-2.813-1.188t-1#q#813 1#q#813T10 13.998t2.813 1.188 1.188 2.813-1.188 2.813T10 22z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'shipping-fast' => array(
		'p' => 'M39 22q.438 0 .719.281T40 23v2q0 .438-.281.719T39 26h-3q0 2.5-1.75 4.25T30 32t-4.25-1.75T24 26h-8q0 2.5-1.75 4.25T10 32t-4.25-1.75T4 26v-8h9.5q.5 0 .5-.5v-1q0-.5-.5-.5H.5q-.5 0-.5-.5v-1q0-.5.5-.5h15q.5 0 .5-.5v-1q0-.5-.5-.5h-13q-.5 0-.5-.5v-1q0-.5.5-.5h15q.5 0 .5-.5v-1q0-.5-.5-.5H.5Q0 8 0 7.5v-1Q0 6 .5 6H4V3q0-1.25.875-2.125T7 0h16q1.25 0 2.125.875T26 3v3h2.75q1.25 0 2.125.875l6.25 6.25Q38 14 38 15.25V22h1zm-29 7q1.25 0 2.125-.875T13 26t-.875-2.125T10 23t-2.125.875T7 26t.875 2.125T10 29zm20 0q1.25 0 2.125-.875T33 26t-.875-2.125T30 23t-2.125.875T27 26t.875 2.125T30 29zm5-13v-.75L28.75 9H26v7h9z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'smoking' => array(
		'p' => 'M39.5 22q.5 0 .5.5v9q0 .5-.5.5h-3q-.5 0-.5-.5v-9q0-.5.5-.5h3zM34.563 5.438q2.563 1.688 4 4.406t1.438 5.781V17.5q0 .5-.5.5h-3q-.5 0-.5-.5v-1.875q0-2.375-1.125-4.438t-3.063-3.313Q30 6.686 30 4.374V.499q0-.5.5-.5h3q.5 0 .5.5v3.875q0 .688.563 1.063zM27 22q.438 0 .719.281T28 23v8q0 .438-.281.719T27 32H3q-1.25 0-2.125-.875T0 29v-4q0-1.25.875-2.125T3 22h24zm-2 7v-4H14v4h11zm5.5-20.125q1.625 1.125 2.563 2.906t.938 3.844V17.5q0 .5-.5.5h-3q-.5 0-.5-.5v-1.875q0-2.75-2.25-4.313-3.75-2.625-3.75-6.688V.499q0-.5.5-.5h3q.5 0 .5.5v3.875q0 2.75 2.5 4.5zM33.5 22q.5 0 .5.5v9q0 .5-.5.5h-3q-.5 0-.5-.5v-9q0-.5.5-.5h3z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'syringe' => array(
		'p' => 'M12.625 10.938l4-4.063 8.5 8.5L13.75 26.688q-1.688 1.75-4.063 1.438l-4-.438-4.125 4.188q-.375.313-.688 0l-.75-.75q-.313-.313 0-.688l4.188-4.125-.438-4q-.25-2.375 1.438-4.063l1.625-1.688 3.5 3.5q.313.375.688 0l.688-.688q.375-.375 0-.75l-3.438-3.438 2.813-2.875 3.5 3.5q.313.375.688 0l.688-.688q.375-.375 0-.688zm19.25-5.813q.313.313 0 .688l-.75.688q-.313.375-.688 0l-1.75-1.75-2#r#813 4.563 4.625q.375.313 0 .688l-2.125 2.125q-.375.375-.688 0L16.999 4.377q-.375-.375 0-.688l2.125-2.125q.375-.375.688 0l1.063 1.063 3.563 3.5 2.813-2.813-1.75-1.75q-.375-.375 0-.688l.688-.75q.375-.313.688 0z'
	    ),
	    'tablets' => array(
		'p' => 'M10 12q3.75 0 6.594 2.406T20 20.437q.063.188-.125.375T19.5 21H.5q-.188 0-.344-.188T0 20.437q.563-3.625 3.406-6.031T10 12zm9.5 11q.188 0 .344.188t.156.375q-.563 3.625-3.406 6.031T10 32q-1.875 0-3.594-.656t-3.031-1.781-2#q#656-1.188-3.344q0-.188.156-.375T.499 23h19zM37.063 2.938q2.625 2.625 2.906 6.313t-1.906 6.625q-.313.438-.75 0L24.125 2.688q-.438-.438 0-.75Q27.063-.25 30.75.032t6.313 2.906zM22.688 4.125l13.188 13.188q.438.438 0 .75-2.938 2.188-6.625 1.906t-6.313-2.906-2.906-6.313 1.906-6.625q.313-.438.75 0z',
		'w' => 1.248046875,
		'vw' => 40
	    ),
	    'thermometer' => array(
		'p' => 'M29.813 1.25q2.188 2.063 2.188 4.625t-1.75 4.313L14.376 26.001h-6.25l-5.563 5.563q-.438.438-1.063.438t-1.063-.438-.438-1.063.438-1.063L6 23.875v-6.313l2.813-2.875 3.125 3.188q.375.313.75 0l.688-.75q.375-.313 0-.688l-3.125-3.125 2.813-2.875 3.125 3.188q.375.313.75 0l.688-.75q.375-.313 0-.688l-3.125-3.125 2.813-2.875 3.125 3.188q.375.313.688 0l.75-.75q.313-.313 0-.688L18.69 4.812l2.875-2.875q1.688-1.75 4.094-1.938t4.156 1.25z'
	    ),
	    'vial' => array(
		'p' => 'M29.875 11.625q.313.375 0 .688l-2.125 2.125q-.375.375-.75 0l-.688-.688-15.375 15.375Q9.062 31 6.374 31q-2.938 0-4.875-2.25-1.688-2-1.5-4.563t2.063-4.438L17.187 4.686l-.688-.688q-.313-.375 0-.75l2.125-2.125q.375-.313.75 0zm-10 4.375l4.375-4.313-4.938-4.938-9.25 9.25h9.813z',
		'w' => .9375,
		'vw' => 30
	    ),
	    'vials' => array(
		'p' => 'M4.5 4Q4 4 4 3.5v-3q0-.5.5-.5h13q.5 0 .5.5v3q0 .5-.5.5H16v15q0 2.063-1.469 3.531T11 24t-3.531-1.469T6 19V4H4.5zM9 4v6h4V4H9zm30 24q.438 0 .719.281T40 29v2q0 .438-.281.719T39 32H1q-.438 0-.719-.281T0 31v-2q0-.438.281-.719T1 28h38zM22.5 4q-.5 0-.5-.5v-3q0-.5.5-.5h13q.5 0 .5.5v3q0 .5-.5.5H34v15q0 2.063-1.469 3.531T29 24t-3.531-1.469T24 19V4h-1.5zM27 4v6h4V4h-4z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'warehouse' => array(
		'p' => 'M31.5 22q.5 0 .5.5v3q0 .5-.5.5h-23q-.5 0-.5-.5v-3q0-.5.5-.5h23zm0 6q.5 0 .5.5v3q0 .5-.5.5h-23q-.5 0-.5-.5v-3q0-.5.5-.5h23zm0-12q.5 0 .5.5v3q0 .5-.5.5h-23q-.5 0-.5-.5l.063-3q0-.5.5-.5h22.938zm6.625-8.687Q40 8.063 40 10.063v21.438q0 .5-.5.5h-5q-.5 0-.5-.5v-15.5q0-.813-.594-1.406t-1.469-.594H8.062q-.875 0-1.469.594t-.594 1.406v15.5q0 .5-.5.5h-5q-.5 0-.5-.5V10.063q0-2 1.875-2.75l17-7.063q.5-.25 1.125-.25t1.125.25z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'weight' => array(
		'p' => 'M28 4q1.625 0 2.813 1.188t1.188 2.813v20q0 1.625-1.188 2.813T28 32.002H4q-1.625 0-2.813-1.188t-1#q#813v-20q0-1.625 1#q#813T4 4h1.625Q4 6.813 4 10q0 4.938 3.531 8.469T16 22t8.469-3.531T28 10q0-3.188-1.625-6H28zM16 20q-4.125 0-7.063-2.938T5.999 9.999t2.938-7.063T16-.002t7.063 2.938 2.938 7.063-2.938 7.063T16 20zm0-9.5q-1.063 0-1.781.75T13.5 13q0 1.063.719 1.781T16 15.5t1.781-.719T18.5 13q0-.938-.688-1.688l2.125-4.938q.125-.375-.031-.75t-.531-.531-.75 0-.563.531z'
	    ),
	    'x-ray' => array(
		'p' => 'M15 24q.438 0 .719.281T16 25t-.281.719T15 26t-.719-.281T14 25t.281-.719T15 24zm10 2q-.438 0-.719-.281T24 25t.281-.719T25 24t.719.281T26 25t-.281.719T25 26zM39 0q.438 0 .719.281T40 1v2q0 .438-.281.719T39 4H1q-.438 0-.719-.281T0 3V1Q0 .562.281.281T1 0h38zm0 28q.438 0 .719.281T40 29v2q0 .438-.281.719T39 32H1q-.438 0-.719-.281T0 31v-2q0-.438.281-.719T1 28h3V6h32v22h3zm-9-12.5v-1q0-.5-.5-.5H21v-2h6.5q.5 0 .5-.5v-1q0-.5-.5-.5H21V8.5q0-.5-.5-.5h-1q-.5 0-.5.5V10h-6.5q-.5 0-.5.5v1q0 .5.5.5H19v2h-8.5q-.5 0-.5.5v1q0 .5.5.5H19v2h-6.5q-.5 0-.5.5v1q0 .5.5.5H19v2h-4q-1.25 0-2.125.875T12 25t.875 2.125T15 28t2.125-.875T18 25v-1h4v1q0 1.25.875 2.125T25 28t2.125-.875T28 25t-.875-2.125T25 22h-4v-2h6.5q.5 0 .5-.5v-1q0-.5-.5-.5H21v-2h8.5q.5 0 .5-.5z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'box-open' => array(
		'p' => 'M26.625 16q.438 0 .813-.125l8.563-2.438v11.125q0 .688-.438 1.219T34.5 26.5l-13.563 3.375q-.938.25-1.938 0L5.499 26.5q-.625-.188-1.063-.719t-.438-1.219V13.437l8.563 2.438q.375.125.813.125 1.75 0 2.625-1.438l4-6.688 4 6.688Q24.874 16 26.624 16zm13.25-7q.25.438.063.875t-.688.563l-12.375 3.5q-.75.25-1.125-.438L20 4l15.625-2q.75-.063 1.063.563zM3.313 2.563Q3.626 1.938 4.376 2l15.625 2-5.75 9.5q-.375.688-1.125.438l-12.375-3.5q-.5-.125-.688-.563T.126 9z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'comment-dots' => array(
		'p' => '#g#125 0-.25-.094t-.188-.219q-.125-.313.094-.531t.75-.875 1.406-2.188 1.25-2.906q-3.563-3.563-3.563-8.188 0-5.375 4.688-9.188T15.999 2zM8 17q.813 0 1.406-.594T10 15t-.594-1.406T8 13t-1.406.594T6 15t.594 1.406T8 17zm8 0q.813 0 1.406-.594T18 15t-.594-1.406T16 13t-1.406.594T14 15t.594 1.406T16 17zm8 0q.813 0 1.406-.594T26 15t-.594-1.406T24 13t-1.406.594T22 15t.594 1.406T24 17z'
	    ),
	    'comment-slash' => array(
		'p' => 'M4 15q0-1.625.563-3.375l20.313 15.75Q22.501 28 20.001 28q-3.5 0-6.688-1.188Q9.25 30 4.5 30q-.313 0-.438-.313t.063-.563q2.75-3.25 3.438-5.938Q4 19.623 4 14.998zm35.625 13.625q.313.25.375.656t-.188.719l-1.25 1.625q-.625.75-1.375.125L.374 3.375q-.75-.625-.188-1.438L1.436.374q.625-.75 1.438-.188l6.563 5.125Q14 1.998 20 1.998q6.625 0 11.313 3.813t4.688 9.188q0 4.5-3.563 8.125z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'couch' => array(
		'p' => 'M10 14q0-1.625-1#q#813T5.999 9.999h-2q0-2.5 1.75-4.25t4.25-1.75h20q2.5 0 4.25 1.75t1.75 4.25h-2q-1.625 0-2.813 1.188T29.998 14v4h-20v-4zm26-2q1.625 0 2.813 1.188t1.188 2.813q0 2.25-2 3.438v7.563q0 .438-.281.719t-.719.281h-4q-.438 0-.719-.281t-.281-.719v-1h-24v1q0 .438-.281.719t-.719.281h-4q-.438 0-.719-.281t-.281-.719v-7.563q-2-1.188-2-3.438 0-1.625 1#q#813T4.002 12h2q.813 0 1.406.594T8.002 14v6h24v-6q0-.813.594-1.406T34.002 12h2z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'donate' => array(
		'p' => 'M16 26q-5.375 0-9.188-3.813t-3.813-9.188 3.813-9.188T16-.002t9.188 3.813 3.813 9.188-3.813 9.188T16 26zM14.625 6.063Q13.062 6.126 12 7.251t-1.063 2.75q0 1.313.75 2.344t1.938 1.406l3.938 1.188q.75.188.75 1.063 0 .5-.313.813t-.75.313h-2.375q-.625 0-1.125-.313t-.875.063l-1 1q-.25.25-.25.563t.313.5q1.188.875 2.688.938v1.063q0 .438.281.75t.719.313h.688q.438 0 .75-.313t.313-.75v-1q1.563-.063 2.625-1.188t1.063-2.75q0-1.313-.75-2.344t-2-1.406l-3.875-1.188q-.75-.188-.75-1.063 0-.5.313-.813t.688-.313h2.438q.625 0 1.125.313t.875-.063l1-1q.25-.25.219-.563t-.281-.5q-1.188-.875-2.688-.938V5.063q0-.438-.313-.75T16.378 4h-.75q-.25 0-.5.125t-.375.375-.125.563v1zM30 22q.813 0 1.406.594T32 24v6q0 .813-.594 1.406T30 32H2q-.813 0-1.406-.594T0 30v-6q0-.813.594-1.406T2 22h2q1.875 2.438 4.563 4H4.625Q4 26 4 26.5v1q0 .5.625.5h22.75Q28 28 28 27.5v-1q0-.5-.625-.5h-4q2.75-1.563 4.625-4h2z'
	    ),
	    'dove' => array(
		'p' => 'M18 10.438q-4.875-1-8.188-4.688 1.063-3.063 3.063-5.375.438-.5 1.031-.313t.719.813Q15.25 5.188 18 8.688v1.75zM25 4h7l-2 4v10q0 4.125-2.938 7.063t-7.063 2.938h-4.813l-4.063 3.5q-.625.5-1.375.5-6.688-.25-9.563-4.75-.313-.438-.125-.938t.688-.625l9-2.25q-1.375-1-2.438-2.063-5.313-5.063-5.313-11.563 0-3.813 1.625-7.25.25-.563.906-.563t.906.625q1.875 4.313 5.781 7.063t8.781 3.063V9q0-2.063 1.469-3.531T24.996 4zm0 6q.438 0 .719-.281T26 9t-.281-.719T25 8t-.719.281T24 9t.281.719T25 10z'
	    ),
	    'hand-holding' => array(
		'p' => 'M35.313 20.5q.75.625.719 1.563t-.781 1.5l-9.438 7.563q-1.125.875-2.5.875H1q-.438 0-.719-.281T0 31.001v-6q0-.438.281-.719T1 24.001h3.438l2.938-2.375q2-1.625 4.625-1.625h10q.938 0 1.531.719t.469 1.594q-.125.75-.75 1.219t-1.375.469h-4.875q-.438 0-.719.281t-.281.719.281.719.719.281h7.375q1.438 0 2.5-.875l5.813-4.625q.563-.5 1.313-.5t1.313.5z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'hand-holding-heart' => array(
		'p' => 'M17.188 15.625L10.375 8.5Q8.937 7 9.031 4.75t1.719-3.625q1.438-1.25 3.344-1.094t3.219 1.531l.688.75.688-.75Q20.064.187 21.939.031t3.313 1.094Q26.94 2.5 27.033 4.75T25.627 8.5l-6.813 7.125q-.375.375-.813.375t-.813-.375zM35.313 20.5q.75.625.719 1.563t-.781 1.5l-9.438 7.563q-1.125.875-2.5.875H1q-.438 0-.719-.281T0 31.001v-6q0-.438.281-.719T1 24.001h3.438l2.938-2.375q2-1.625 4.625-1.625h10q.938 0 1.531.719t.469 1.594q-.125.75-.75 1.219t-1.375.469h-4.875q-.438 0-.719.281t-.281.719.281.719.719.281h7.375q1.438 0 2.5-.875l5.813-4.625q.563-.5 1.313-.5t1.313.5z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'hand-holding-usd' => array(
		'p' => 'M16.125 9q-1.063-.313-1.813-1.094t-.875-1.844q-.188-1.5.719-2.656T16.5 2.125V1q0-.438.281-.719T17.5 0h1q.438 0 .719.281T19.5 1v1.125q1.125.125 2 .688.25.188.281.563t-.219.625l-1.063 1.063q-.375.375-.875.125-.313-.125-.688-.125h-2q-.563 0-.563.5 0 .438.375.5l3.125.938q.688.188 1.281.625t.969 1.031.438 1.281q.188 1.5-.719 2.656t-2.344 1.281v1.125q0 .438-.281.719t-.719.281h-1q-.438 0-.719-.281t-.281-.719v-1.125q-1.125-.125-2-.688-.313-.188-.313-.563t.25-.625l1.063-1.063q.375-.375.875-.125.313.125.625.125h2.063q.563 0 .563-.5 0-.438-.375-.5zm17.25 11.5q.625.625.594 1.563t-.656 1.5l-8.938 7.563q-1.063.875-2.375.875H.937q-.375 0-.656-.281T0 31.001v-6q0-.438.281-.719t.656-.281H4.25l2.688-2.375q1.938-1.625 4.375-1.625h9.438q.875 0 1.469.719t.406 1.594q-.063.5-.344.875t-.719.594-.875.219h-4.625q-.375 0-.656.281t-.281.719.281.719.656.281h7q1.313 0 2.313-.875l5.5-4.625q.563-.5 1.25-.5t1.25.5z',
		'w' => 1.060546875,
		'vw' => 34
	    ),
	    'hands' => array(
		'p' => 'M12.813 14.375l3.563 4.813q1.625 2.125 1.625 4.813v7q0 .438-.281.719t-.719.281h-8.25q-.75 0-.938-.75t-.625-1.313L.625 21.5Q0 20.687 0 19.625V6q0-.813.594-1.406T2 4t1.406.594T4 6v9.25L9.625 22q.25.375.688.375t.75-.313l.813-.813q.625-.563.125-1.25l-2.375-3.188q-.5-.688-.406-1.5t.781-1.313 1.5-.375 1.313.75zM38 4q.813 0 1.406.594T40 6v13.625q0 1.063-.625 1.875l-6.563 8.438q-.438.563-.625 1.313t-.938.75h-8.25q-.438 0-.719-.281t-.281-.719v-7q0-2.688 1.625-4.813l3.563-4.813q.5-.625 1.313-.75T30 14t.781 1.313-.406 1.5L28 20.001q-.5.688.125 1.25l.813.813q.313.313.75.313t.688-.375l5.625-6.75v-9.25q0-.813.594-1.406t1.406-.594z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'hands-helping' => array(
		'p' => 'M30.5 12q.625 0 1.063.438t.438 1.063v3q#p#8H30v4q0 .813-.594 1.406T28 24.002h-1q0 1.625-1.188 2.813t-2.813 1.188h-8.563l-6.438 3.75q-.688.375-1.5.156t-1.25-.906l-5-8.688q-.375-.688-.156-1.5t.906-1.188l5-2.875v-3q0-2.25 1.938-3.438l4.063-2.438v7.625q0 1.875 1.313 3.188t3.188 1.313 3.188-1.313 1.313-3.188v-3.5h9.5zm9.25-2.312q.375.688.156 1.5T39 12.376l-5 2.875v-1.75q0-1.438-1.031-2.469T30.5 10.001H19v5.5q0 1.063-.719 1.781t-1.781.719-1.781-.719T14 15.501V7.626q0-1.125.938-1.688l2.063-1.313q1-.625 2.125-.625h6.438L32.002.25q.688-.375 1.5-.156t1.25.906z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'parachute-box' => array(
		'p' => 'M32 10.938q.063.438-.25.75t-.75.313h-.563l-8.563 9.5q.125.375.125.5v8q0 .563-.281 1t-.719.719-1 .281h-8q-.813 0-1.406-.594t-.594-1.406v-8q0-.125.125-.5l-8.563-9.5H.998q-.438 0-.75-.313t-.25-.75q.25-2.25 1.688-4.281t3.531-3.406 4.656-2.25q-3.875 4.25-3.875 11h-1.75l7.25 8.125q.438-.125.5-.125h3v-8h-7q0-5.125 2.531-8.563T15.998 0t5.469 3.438 2.531 8.563h-7v8h3q.063 0 .5.125l7.25-8.125h-1.75q0-6.75-3.875-11 3.938 1.313 6.688 3.938t3.188 6z'
	    ),
	    'people-carry' => array(
		'p' => 'M8 6q-1.25 0-2.125-.875T5 3 5.875.875 8 0t2.125.875T11 3t-.875 2.125T8 6zm24 0q-1.25 0-2.125-.875T29 3t.875-2.125T32 0t2.125.875T35 3t-.875 2.125T32 6zm7.875 23.25q.313.75-.031 1.531t-1.094 1.094Q38.375 32 38 32q-1.375 0-1.875-1.25l-1.688-4.313.125-1.188 2.563-2.875zM37.75 16.125q.438 2-.938 3.563l-4.188 4.75-.625 5.813q-.063.5-.344.906t-.719.625-.938.219h-.25q-.813-.125-1.313-.75t-.438-1.5l.625-5.75q.188-1.25 1-2.188l2.688-3.063-1.063-4.438-.438 1.313q-.375 1.188-1.563 2l-3.188 2.063q-.375.25-1.063.313h-10q-.688-.063-1.063-.313l-3#q#063q-1.125-.813-1.563-2l-.438-1.313L7.68 18.75l2.688 3.063q.813.938 1 2.188l.625 5.75q.063.875-.438 1.5t-1.313.75h-.25q-.75 0-1.313-.5t-.688-1.25l-.625-5.813-4.188-4.75q-1.375-1.563-.938-3.563l1.188-5q.438-2 2.313-2.813 1.813-.75 3.5.188 2.25 1.313 3.063 3.75l.688 2.125 1 .625V9q0-.438.281-.719T14.992 8h10q.438 0 .719.281t.281.719v6l1-.625.688-2.125q.813-2.438 3-3.75 1.688-.938 3.563-.188 1.875#r#313 2.813zm-34.875 6.25l2.563 2.875.125 1.188-1.688 4.313q-.313.75-1.063 1.094t-1.531.031-1.125-1.094-.031-1.531z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'piggy-bank' => array(
		'p' => 'M35 14q.438 0 .719.281T36 15v8q0 .438-.281.719T35 24h-3.063q-.813 1.125-1.938 1.938v5.063q0 .438-.281.719t-.719.281h-4q-.438 0-.719-.281t-.281-.719v-3h-8v3q0 .438-.281.719t-.719.281h-4q-.438 0-.719-.281t-.281-.719v-5.063q-1.188-.875-2.094-2.094t-1.406-2.719-.5-3.125h-2.5q-1.563 0-2.625-1.188t-.875-2.75q.125-.875.656-1.594t1.313-1.094 1.656-.375q.375 0 .375.375v1.25q0 .375-.375.375h-.063q-.375 0-.688.156t-.531.438-.344.594q-.125.75.344 1.281t1.156.531h2.688q.688-3.438 3.438-5.719t6.375-2.281h8q.438 0 1.438.125Q27.25 5.999 30 5.999h2l-1.188 4.75q1.5 1.375 2.313 3.25H35zm-8 4q.438 0 .719-.281T28 17t-.281-.719T27 16t-.719.281T26 17t.281.719T27 18zM16 6q-1.438 0-2.938.375 0-.063-.031-.188T13 5.999q0-2.5 1.75-4.25T19-.001t4.25 1.75T25 5.999v.063q-.688-.063-1-.063h-8z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'ribbon' => array(
		'p' => 'M.375 27.75l7.313-8.125 4.938 5.5L6.938 31.5q-.875 1-2 .25L.688 30q-.563-.375-.656-1.063t.344-1.188zm27.25 0q.438.5.375 1.188t-.625 1.063l-4.313 1.75q-1.125.75-1.938-.25L5.561 14.313q-.813-.938-1#q#031t-.375-1.938.219-1.688.375-1.125.281-.469l2.75-4.563q.375-.75 1-1.125 2.125-1.375 5.469-1.375t5.281 1.375q.625.375 1 1.125l2.75 4.563q1.063 1.75.844 3.75t-1.531 3.438l-2.125 2.375-4.938-5.438q3.25-3.688 3.5-4.063-2.063-1.125-4.875-1.125T9.123 7.124z',
		'w' => .875,
		'vw' => 28
	    ),
	    'route' => array(
		'p' => 'M26 20q2.5 0 4.25 1.75T32 26t-1.75 4.25T26 32H8.625q1.688-2.063 3-4H26q.813 0 1.406-.594T28 26t-.594-1.406T26 24h-6q-2.5 0-4.25-1.75T14 18t1.75-4.25T20 12h2.813Q20 8 20 6q0-2.5 1.75-4.25T26 0t4.25 1.75T32 6q0 1.5-1.5 4t-3 4.25L26 16h-6q-.813 0-1.406.594T18 18t.594 1.406T20 20h6zm0-16q-.813 0-1.406.594T24 6t.594 1.406T26 8t1.406-.594T28 6t-.594-1.406T26 4zM6 16q2.5 0 4.25 1.75T12 22q0 1.5-1.5 4t-3 4.25L6 32q-.688-.75-1.688-1.938t-2.656-3.875T0 21.999q0-2.5 1.75-4.25T6 15.999zm0 8q.813 0 1.406-.594T8 22t-.594-1.406T6 20t-1.406.594T4 22t.594 1.406T6 24z'
	    ),
	    'seedling' => array(
		'p' => 'M4 6q5.813 0 9.906 4.094T18 20v9q0 .438-.281.719T17 30h-2q-.438 0-.719-.281T14 29v-9q-5.813 0-9.906-4.094T0 6h4zm24-4h4q0 5.375-3.625 9.375t-8.938 4.563q-1-3.813-3.688-6.75.938-1.625 2.219-2.938T20.812 4t3.406-1.469T27.999 2z'
	    ),
	    'sign' => array(
		'p' => 'M31 4q.438 0 .719.281T32 5v2q0 .438-.281.719T31 8H8v23q0 .438-.281.719T7 32H5q-.438 0-.719-.281T4 31V8H1q-.438 0-.719-.281T0 7V5q0-.438.281-.719T1 4h3V1q0-.438.281-.719T5 0h2q.438 0 .719.281T8 1v3h23zM10 24V10h20v14H10z'
	    ),
	    'smile-wink' => array(
		'p' => 'M0 16Q0 9.562 4.531 5.031T15.5.5t10.969 4.531T31 16t-4.531 10.969T15.5 31.5 4.531 26.969 0 16zm12.5-3q0-.813-.594-1.406T10.5 11t-1.406.594T8.5 13t.594 1.406T10.5 15t1.406-.594T12.5 13zm9.875 1l.625.563q.375.375.844.125t.406-.813-.438-1.063-.906-.844-1.156-.531-1.25-.188q-1.25 0-2.406.75t-1.344 1.875q-.063.563.406.813t.844-.125l.625-.563q.688-.563 1.875-.563t1.875.563zm-12.5 6.375q-.438-.5-1-.375t-.719.625.156 1Q11.125 25 15.5 25t7.188-3.375q.625-.75-.156-1.375t-1.406.125Q18.938 23 15.501 23t-5.625-2.625z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'tape' => array(
		'p' => 'M14 12q1.625 0 2.813 1.188t1.188 2.813-1.188 2.813T14 20.002t-2.813-1.188-1#q#813 1#q#813T14 12zm25 14q.438 0 .719.281T40 27v2q0 .438-.281.719T39 30H14q-5.813 0-9.906-4.094T0 16t4.094-9.906T14 2t9.906 4.094T28 16q0 5.875-4.188 10H39zm-25-4q2.5 0 4.25-1.75T20 16t-1.75-4.25T14 10t-4.25 1.75T8 16t1.75 4.25T14 22z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'truck-loading' => array(
		'p' => 'M3.125 23.5L.062 11.875q-.125-.25-.031-.5t.281-.438.438-.313l4.813-1.25 1.563 5.75 3.875-1-1.563-5.813 4.813-1.313q.188 0 .406.031t.375.125.281.25.188.344l3.125 11.563q.063.438-.125.781t-.625.469l-13.5 3.625q-.438.125-.781-.094t-.469-.594zM24 0h16v25q0 2.875-2.063 4.938t-4.938 2.063q-2.813 0-4.844-1.969t-2.156-4.781l-24.563 6.75q-.5.125-.625-.375l-.813-2.875q-.125-.5.375-.625l21.625-5.875V2.001q0-.813.594-1.406t1.406-.594zm9 28q1.25 0 2.125-.875T36 25t-.875-2.125T33 22t-2.125.875T30 25t.875 2.125T33 28z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'truck-moving' => array(
		'p' => 'M38.813 14.813q1.188 1.188 1.188 2.813v5.375q0 .438-.281.719t-.719.281h-1.125q.125.5.125 1 0 2.063-1.469 3.531t-3.531 1.469-3.531-1.469-1.469-3.531q0-.5.125-1h-10.25q.125.5.125 1 0 2.063-1.469 3.531t-3.531 1.469q-2.5 0-4-2-1.5 2-4 2-2.063 0-3.531-1.469T.001 25.001v-21q0-.813.594-1.406t1.406-.594h26q.813 0 1.406.594t.594 1.406v6h2.375q1.625 0 2.813 1.188zM5 27q.813 0 1.406-.594T7 25t-.594-1.406T5 23t-1.406.594T3 25t.594 1.406T5 27zm8 0q.813 0 1.406-.594T15 25t-.594-1.406T13 23t-1.406.594T11 25t.594 1.406T13 27zm17-14v3h5.75l-2.688-2.688q-.313-.313-.688-.313h-2.375zm3 14q.813 0 1.406-.594T35 25t-.594-1.406T33 23t-1.406.594T31 25t.594 1.406T33 27z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'video-slash' => array(
		'p' => 'M39.625 28.625q.313.25.375.656t-.188.719l-1.25 1.625q-.625.75-1.438.188L2.686 5.125.373 3.375q-.75-.625-.188-1.438L1.435.374q.625-.75 1.438-.188l4.875 3.813h15.25q1.25 0 2.125.875t.875 2.125v11.125l2 1.5v-8.563l6.875-4.688q1-.688 2.063-.156t1.063 1.781v16q0 .813-.531 1.375t-1.281.625zM2 25V9.687l22.875 17.688Q24.062 28 23 28H5q-1.25 0-2.125-.875T2 25z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'wine-glass' => array(
		'p' => 'M13.5 29q1.063 0 1.781.719T16 31.5q0 .5-.5.5h-13q-.5 0-.5-.5 0-1.063.719-1.781T4.5 29H7v-7.313q-3.25-.75-5.25-3.469T.062 12.062l1-11.125q0-.313.125-.5t.344-.313T2-.001h14q.375 0 .656.25t.281.688l1 11.125q.313 3.438-1.688 6.156t-5.25 3.469V29h2.5z',
		'w' => .5625,
		'vw' => 18
	    ),
	    'user-alt-slash' => array(
		'p' => 'M39.625 28.625q.313.25.375.656t-.188.719l-1.25 1.625q-.625.75-1.375.125L.374 3.375q-.75-.625-.188-1.438L1.436.374q.625-.75 1.438-.188l8.438 6.563q.75-2.938 3.156-4.844t5.531-1.906q3.75 0 6.375 2.625t2.625 6.375q0 1.688-.594 3.188t-1.625 2.688-2.406 1.938zM12.375 20h3l15.5 12H7q-1.25 0-2.125-.875T4 29v-.625q0-3.438 2.469-5.906T12.375 20z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'user-astronaut' => array(
		'p' => 'M4 14q-.438 0-.719-.281T3 13V7q0-.438.281-.719T4 6h.875Q6 3.312 8.5 1.656T14 0q1.5 0 2.938.438t2.594 1.219 2.094 1.906 1.5 2.438h.875q.438 0 .719.281t.281.719v6q0 .438-.281.719t-.719.281h-.875q-1.125 2.688-3.625 4.344t-5.5 1.656-5.5-1.656-3.625-4.344h-.875zm2.5-5.5V10q0 2.5 1.75 4.25T12.5 16h3q2.5 0 4.25-1.75T21.5 10V8.5q0-1.063-.875-1.781T18.5 6h-9q-1.25 0-2.125.719T6.5 8.5zM11 13l-.75-2.25L8 10l2.25-.75L11 7l.75 2.25L14 10l-2.25.75zm9.5 7.063q3.188.375 5.344 2.75T28 28.376v.625#n# 32.001h-5v-4q0-.813-.594-1.406T18 26.001h-8q-.813 0-1.406.594T8 28.001v4H3q-1.25 0-2.125-.875T0 29.001v-.625q0-3.188 2.156-5.563t5.344-2.75q3 1.938 6.5 1.938t6.5-1.938zM17 28q.438 0 .719.281T18 29t-.281.719T17 30t-.719-.281T16 29t.281-.719T17 28zm-6 0q.438 0 .719.281T12 29v3h-2v-3q0-.438.281-.719T11 28z',
		'w' => .875,
		'vw' => 28
	    ),
	    'user-check' => array(
		'p' => '#k#m5.625 2q3.438 0 5.906 2.469T28 26.375V29#n# 32H3q-1.25 0-2.125-.875T0 29v-2.625q0-3.438 2.469-5.906T8.375 18h1.063q2.188 1 4.563 1t4.563-1h1.063zm20.188-8q.5.5-.063 1l-8.813 8.813q-.5.5-1.063-.063l-5.063-5.125q-.563-.5 0-1.063l1.75-1.688q.5-.563 1.063 0l2#r#813L37 8.187q.563-.5 1.063.063z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'user-clock' => array(
		'p' => 'M31 14q3.75 0 6.375 2.625T40 23t-2.625 6.375T31 32t-6.375-2.625T22 23t2.625-6.375T31 14zm4 9.375v-.75Q35 22 34.375 22H32v-3.375Q32 18 31.375 18h-.75Q30 18 30 18.625v4.75q0 .625.625.625h3.75Q35 24 35 23.375zM20 23q0 2.75 1.25 5.125T24.688 32H3q-1.25 0-2.125-.875T0 29v-2.625q0-3.438 2.469-5.906T8.375 18h1.063q2.188 1 4.563 1t4.563-1h1.063q.688 0 1.5.125Q20.002 20.5 20.002 23zm-6-7q-3.313 0-5.656-2.344T6 8t2.344-5.656T14 0t5.656 2.344T22 8t-2.344 5.656T14 16z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'user-cog' => array(
		'p' => 'M38.125 23.313l1.625.938q.313.188.25.563-.625 2-2.125 3.563-.25.25-.563.125l-1.563-.938q-1.063.875-2.313 1.313v1.875q0 .375-.375.438-2.063.438-4.125 0-.375-.063-.375-.438v-1.875q-1.25-.438-2.313-1.313l-1.625.938q-.313.125-.563-.125-1.438-1.563-2.063-3.563-.125-.375.25-.563l1.563-.938q-.25-1.313 0-2.625l-1.563-.938q-.313-.188-.25-.563.625-2 2.063-3.563.25-.25.563-.125l1.625.938q1.063-.875 2.313-1.313v-1.875q0-.375.375-.438 2.063-.438 4.125 0 .375.063.375.438v1.875q1.25.438 2.313 1.313l1.563-.938q.313-.125.563.125 1.5 1.563 2.125 3.563.063.375-.25.563l-1.625.938q.25 1.313 0 2.625zM31 25q1.25 0 2.125-.875T34 22t-.875-2.125T31 19t-2.125.875T28 22t.875 2.125T31 25zm-17-9q-3.313 0-5.656-2.344T6 8t2.344-5.656T14 0t5.656 2.344T22 8t-2.344 5.656T14 16zm12.563 14.125v.625q0 .313.125.75-.75.5-1.688.5H3q-1.25 0-2.125-.875T0 29v-2.625q0-3.438 2.469-5.906T8.375 18h1.063q2.188 1 4.563 1t4.563-1h1.063q.125 0 .375.031t.313.031q0 .063-.094.25t-.094.313q-.25.813.063 1.625t1.063 1.25l.5.25q-.063.25 0 .5l-.5.313q-.75.438-1.063 1.219t-.063 1.594q.75 2.438 2.5 4.375.75.75 1.813.75.625 0 1.188-.313l.5-.25q.313.188.438.188z',
		'w' => 1.248046875,
		'vw' => 40
	    ),
	    'user-edit' => array(
		'p' => '#k#m5.625 2q3.688 0 6.25 2.875L21 25.688l-.5.5-.063.688-.438 3.813q-.063.625.188 1.313H2.999q-1.25 0-2.125-.875t-.875-2.125v-2.625q0-3.438 2.469-5.906t5.906-2.469h1.063q2.188 1 4.563 1t4.563-1h1.063zm2.813 9.063l8.625-8.563 4.438 4.438-8.563 8.625-3.813.438q-.5.063-.844-.281T22 30.876zm17.125-10.25q.438.438.438 1.063t-.438 1.063l-2.625 2.625-4.5-4.5.313-.25 2.313-2.375q.438-.438 1.063-.438t1.063.438z',
		'w' => 1.248046875,
		'vw' => 40
	    ),
	    'user-friends' => array(
		'p' => 'M12 16q-2.875 0-4.938-2.063T4.999 8.999t2.063-4.938T12 1.998t4.938 2.063 2.063 4.938-2.063 4.938T12 16zm4.813 2q3 0 5.094 2.094t2.094 5.094v1.813q0 1.25-.875 2.125t-2.125.875h-18q-1.25 0-2.125-.875t-.875-2.125v-1.813q0-3 2.094-5.094T7.189 18h.563q2.063 1 4.25 1t4.25-1h.563zM30 16q-2.5 0-4.25-1.75T24 10t1.75-4.25T30 4t4.25 1.75T36 10t-1.75 4.25T30 16zm3 2q2.875 0 4.938 2.063t2.063 4.938q0 1.25-.875 2.125t-2.125.875H25.938q0-.063.031-.188t.031-.188v-2.438q0-3.563-2.5-6.25 1.688-.938 3.5-.938h.25q1.438.5 2.75.5t2.75-.5H33z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'user-graduate' => array(
		'p' => 'M19.938 20.063q3.375.125 5.719 2.531t2.344 5.781V29#n#.001 32h-22q-1.25 0-2.125-.875T.001 29v-.625q0-3.375 2.344-5.781t5.719-2.531l5.938 5.938zM.875 5Q0 4.812 0 4t.875-1L12.75.125q1.25-.25 2.5 0L27.125 3Q28 3.25 28 4.031T27.125 5l-6 1.438Q22 8.188 22 10.001q0 3.313-2.344 5.656T14 18.001t-5.656-2.344T6 10.001q0-1.813.875-3.563l-4.125-1v3.313q.75.438.75 1.25 0 .75-.688 1.25l.938 3.875q.063.25.031.438t-.156.313-.313.125H.687q-.25 0-.406-.281t-.031-.594l.938-3.875q-.688-.5-.688-1.25 0-.813.75-1.25V5.064z',
		'w' => .875,
		'vw' => 28
	    ),
	    'user-lock' => array(
		'p' => 'M20 20v10q0 1.063.563 2H3q-1.25 0-2.125-.875T0 29v-2.625q0-3.438 2.469-5.906T8.375 18h1.063q2.188 1 4.563 1t4.563-1h1.063l.875.125q-.5.875-.5 1.875zm-6-4q-3.313 0-5.656-2.344T6 8t2.344-5.656T14 0t5.656 2.344T22 8t-2.344 5.656T14 16zm24 2q.813 0 1.406.594T40 20v10q0 .813-.594 1.406T38 32H24q-.813 0-1.406-.594T22 30V20q0-.813.594-1.406T24 18h2v-3q0-2.063 1.469-3.531T31 10t3.531 1.469T36 15v3h2zm-5 0v-3q0-.813-.594-1.406T31 13t-1.406.594T29 15v3h4z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'user-minus' => array(
		'p' => 'M39 13q.438 0 .719.281T40 14v2q0 .438-.281.719T39 17H27q-.438 0-.719-.281T26 16v-2q0-.438.281-.719T27 13h12zm-25 3q-3.313 0-5.656-2.344T6 8t2.344-5.656T14 0t5.656 2.344T22 8t-2.344 5.656T14 16zm5.625 2q3.438 0 5.906 2.469T28 26.375V29#n# 32H3q-1.25 0-2.125-.875T0 29v-2.625q0-3.438 2.469-5.906T8.375 18h1.063q2.188 1 4.563 1t4.563-1h1.063z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'user-ninja' => array(
		'p' => 'M20.313 18.063q3.25.313 5.469 2.688t2.219 5.625v2.625q0 1.25-.875 2.125t-2.125.875h-22q-1.25 0-2.125-.875t-.875-2.125v-2.625q0-3.25 2.219-5.625t5.469-2.688l6.313 6.375zM2 12q0-3.188 2.688-5Q2 5.187 2 2q3.063 0 4.875 2.5.438-1 1.188-1.844T9.719 1.25t2-.906T14 0q3.313 0 5.656 2.344T22 8t-2.344 5.656T14 16q-2.75 0-4.844-1.656t-2.844-4.219Q4.562 12 1.999 12zm9-6q-.813 0-1.406.594T9 8h10q0-.813-.594-1.406T17 6h-6z',
		'w' => .875,
		'vw' => 28
	    ),
	    'user-shield' => array(
		'p' => 'M38.875 16.938Q40 17.376 40 18.501q0 2.25-.563 4.25t-1.438 3.469-2 2.656-2.188 1.875-2.125 1.125q-.688.25-1.375 0-3.313-1.313-5.813-4.906t-2.5-8.469q0-1.125 1.125-1.563l7#q#813q.688-.25 1.375 0zM31 28.875q2.063-.938 3.906-3.375T37 19.437l-6-2.375v11.813z#k#m6 2.5q0 4.25 1.719 7.656t4.469 5.594Q25.625 32 25 32H3q-1.25 0-2.125-.875T0 29v-2.625q0-3.438 2.469-5.906T8.375 18h1.063q2.188 1 4.563 1t4.563-1h1.063q.063 0 .219.031t.219.031l-.031.188-.031.25z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'user-slash' => array(
		'p' => 'M39.625 28.625q.313.25.375.656t-.188.719l-1.25 1.625q-.625.75-1.375.125L.374 3.375q-.75-.625-.188-1.438L1.436.374q.625-.75 1.438-.188l9.188 7.125q.188-2 1.281-3.688T16.187.967 20-.002q3.313 0 5.656 2.344T28 7.998q0 2.563-1.5 4.625t-3.875 2.875zM6 26.375q0-2 .906-3.781t2.5-2.938 3.531-1.531L30.875 32H9q-1.25 0-2.125-.875T6 29v-2.625z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'user-tag' => array(
		'p' => 'M39.438 22.813q.563.563.563 1.406t-.625 1.406l-5.75 5.813q-.563.563-1.406.563t-1.406-.563l-5.688-5.688q-1.125-1.125-1.125-2.813v-4.938q0-.813.563-1.406t1.438-.594h4.938q1.688 0 2.813 1.188zM28 21.5q.375 0 .719-.219t.563-.563.219-.75-.219-.75-.563-.531-.719-.188q-.625 0-1.063.438T26.499 20t.438 1.063 1.063.438zM14 16q-2.188 0-4.031-1.063t-2.906-2.906T6 8q0-3.313 2.344-5.656T14 0q2.188 0 4.031 1.063t2.906 2.906T22 8q0 3.313-2.344 5.656T14 16zm8 6.938q0 2.5 1.75 4.25l3.625 3.625q-.938 1#q#375 1.188H3q-1.25 0-2.125-.875T0 29.001v-2.625q0-3.438 2.469-5.906t5.906-2.469h1.063q2.188 1 4.563 1t4.563-1h1.063q1.063 0 2.375.375v4.563z',
		'w' => 1.248046875,
		'vw' => 40
	    ),
	    'user-tie' => array(
		'p' => '#k#m6 2.063q3.313.125 5.656 2.563T28 26.376v2.625#n# 32.001H3q-1.25 0-2.125-.875T0 29.001v-2.625q0-3.313 2.344-5.75T8 18.063l3 11.938 2-8.5-2-3.5h6l-2 3.5 2 8.5z',
		'w' => .875,
		'vw' => 28
	    ),
	    'users-cog' => array(
		'p' => 'M38.125 21.313l1.625.938q.313.188.25.563-.625 2-2.125 3.563-.25.25-.563.125l-1.563-.938q-1.063.875-2.313 1.313v1.875q0 .375-.375.438-2.063.438-4.125 0-.375-.063-.375-.438v-1.875q-1.25-.438-2.313-1.313l-1.625.938q-.313.125-.563-.125-1.438-1.563-2.063-3.563-.125-.375.25-.563l1.563-.938q-.25-1.313 0-2.625l-1.563-.938q-.313-.188-.25-.563.625-2 2.063-3.563.25-.25.563-.125l1.625.938q1.063-.875 2.313-1.313v-1.875q0-.375.375-.438 2.063-.438 4.125 0 .375.063.375.438v1.875q1.25.438 2.313 1.313l1.563-.938q.313-.125.563.125 1.5 1.563 2.125 3.563.063.375-.25.563l-1.625.938q.25 1.313 0 2.625zM31 23q1.25 0 2.125-.875T34 20t-.875-2.125T31 17t-2.125.875T28 20t.875 2.125T31 23zM6 14q-1.625 0-2.813-1.188T1.999 9.999t1#q#813T6 5.998t2.813 1.188 1.188 2.813-1.188 2.813T6 14zm14 2q-2.875 0-4.938-2.063t-2.063-4.938 2.031-4.938 4.938-2.063 4.969 2.063T27 8.999q0 1.563-.688 3-.063 0-.094.031l-.094.094-.5-.313q-.563-.313-1.188-.313-1.063 0-1.813.75-1.438 1.563-2.25 3.688-.063 0-.188.063h-.188zm6.563 12.125v.625q0 .625.375 1.25H11q-1.25 0-2.125-.875T8 27v-1.813q0-3 2.125-5.094t5.063-2.094h.563q2.063 1 4.25 1h.438q.125-.063.188-.063.25.313.625.563l.5.25q-.063.25 0 .5h-.063q-2.188 1.125-1.563 3.125.75 2.438 2.5 4.375.75.75 1.813.75.688 0 1.688-.563h.063zm-15.75-10.937q-1.875 1-3.125 2.813t-1.563 4H2q-.813 0-1.406-.594T0 22.001v-2q0-1.625 1#q#813T4.001 16h4q1.625 0 2.813 1.188z',
		'w' => 1.248046875,
		'vw' => 40
	    ),
	    'blender' => array(
		'p' => 'M26 24q1.688 0 2.844 1.156T30 28v2q0 .813-.594 1.406T28 32H8q-.813 0-1.406-.594T6 30v-2q0-1.688 1.156-2.844T10 24h16zm-8 6q.813 0 1.406-.594T20 28t-.594-1.406T18 26t-1.406.594T16 28t.594 1.406T18 30zm2.5-26q-.5 0-.5.5v1q0 .5.5.5h9.875l-1.125 4H20.5q-.5 0-.5.5v1q0 .5.5.5h8.25l-1.125 4H20.5q-.5 0-.5.5v1q0 .5.5.5h6.563L26 22H10l-.563-6H2.999q-1.25 0-2.125-.875T-.001 13V3q0-1.25.875-2.125T2.999 0h29l-1.063 4H20.498zM4 12h5.063l-.688-8H4v8z'
	    ),
	    'book-open' => array(
		'p' => 'M33.875 2q.875-.063 1.5.5T36 3.938v21.125q0 .75-.531 1.313t-1.344.563q-8.75.5-13.688 2.938-.313.188-.656.125t-.563-.344-.219-.594V6.314q0-.563.438-.813 4.813-2.938 14.438-3.5zM16.563 5.5q.438.25.438.813v22.75q0 .5-.469.781t-.969.031q-4.938-2.438-13.688-2.938-.813 0-1.344-.563T0 25.061V3.936q0-.875.625-1.438t1.5-.5q9.625.563 14.438 3.5z',
		'w' => 1.123046875,
		'vw' => 36
	    ),
	    'broadcast-tower' => array(
		'p' => 'M9.438 12q-.75 0-.938-.688Q8 9.687 8 7.999t.5-3.313q.188-.688.938-.688h2.125q.5 0 .781.406t.156.906Q12 6.623 12 7.998t.5 2.688q.125.5-.156.906t-.781.406H9.438zM5.625 1.438q-.75 1.375-1.219 3t-.344 4.531 1.563 5.594q.25.5-.031.969t-.844.469H2.562q-.625 0-.875-.563Q-.001 11.875-.001 8T1.624.562q.25-.563.938-.563H4.75q.563 0 .844.469t.031.969zm32.75-.875Q40 4.126 40 8.001t-1.625 7.438q-.25.563-.938.563h-2.188q-.375 0-.656-.219t-.313-.563.094-.719q1.375-2.563 1.531-5.406t-.313-4.531-1.219-3.125q-.188-.313-.125-.656t.344-.563.656-.219h2.188q.688 0 .938.563zM30.563 4q.75 0 .938.688.5 1.625.5 3.313t-.5 3.313q-.188.688-.938.688h-2.125q-.5 0-.781-.406t-.156-.906q.5-1.313.5-2.688t-.5-2.688q-.125-.5.156-.906t.781-.406h2.125zm-7.25 6.25l8.125 19.625q.188.375.031.75t-.531.5l-1.875.813q-.375.125-.75-.031t-.563-.531l-3.063-7.375h-9.375l-3.063 7.375q-.188.375-.563.531t-.75.031l-1.875-.813q-.375-.125-.531-.5t.031-.75l8.125-19.625q-.688-1-.688-2.25 0-1.063.531-2t1.469-1.469 2-.531 2 .531T23.467 6t.531 2q0 1.25-.688 2.25zM17 20h6l-3-7.25z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'broom' => array(
		'p' => 'M16 13.563l5.438 6.813q0 .25-.094.688t-.5 1.719-.875 2.406-1.375 2.438-1.906 2.125Q15 31.065 10.844 31.596t-7.531.406L0 31.877q.25-1.438.688-3.438l5.938-7q.188-.25 0-.5t-.438-.125l-3.75 1.375q1.563-4.625 3.375-6.063 1.688-1.375 4.219-2t4.281-.625zM39.813 1.938q.563.813-.188 1.375l-14.5 11.125 2.125 2.688q.188.313.063.688t-.5.438l-3.688.75-5.375-6.813 1.563-3.375q.188-.375.563-.438t.625.25l2.125 2.688L37.126.189q.813-.563 1.438.188z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'chalkboard' => array(
		'p' => 'M6 4v22H2V2.5q0-1.063.719-1.781T4.5 0h31q1.063 0 1.781.719T38 2.5V26h-4V4H6zm33 24q.438 0 .719.281T40 29v2q0 .438-.281.719T39 32H1q-.438 0-.719-.281T0 31v-2q0-.438.281-.719T1 28h17v-4h12v4h9z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'chalkboard-teacher' => array(
		'p' => 'M13 22q2.938 0 4.969 2.063t2.031 5q0 1.188-.875 2.063T17 32.001H3q-1.25 0-2.125-.875T0 29.063q0-2.938 2.031-5T7 22q.25 0 .438.063 1.313.438 2.563.438t2.563-.438q.188-.063.438-.063zm-3-2q-2.5 0-4.25-1.75T4 14t1.75-4.25T10 8t4.25 1.75T16 14t-1.75 4.25T10 20zM37 0q1.25 0 2.125.906T40 3.125v19.75q0 1.313-.875 2.219T37 26H21.687q-.563-2.375-2.438-4h4.75v-4h8v4h4V4h-22v3.125Q12.061 6 9.999 6V3.125q0-1.313.875-2.219T12.999 0h24z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'church' => array(
		'p' => 'M29 15.438q1 .563 1 1.688v14.875h-6v-6q0-1.688-1.156-2.844T20 22.001t-2.844 1.156T16 26.001v6h-6V17.126q0-1.125 1-1.688l7-4.25V8h-3q-.438 0-.719-.281T14 7V5q0-.438.281-.719T15 4h3V1q0-.438.281-.719T19 0h2q.438 0 .719.281T22 1v3h3q.438 0 .719.281T26 5v2q0 .438-.281.719T25 8h-3v3.188zM0 24.75q0-.563.344-1.094t.844-.719l6.813-2.938v12h-7q-.438 0-.719-.281t-.281-.719v-6.25zm38.813-1.812q1.188.5 1.188 1.813v6.25q0 .438-.281.719t-.719.281h-7v-12z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'coins' => array(
		'p' => 'M0 25.313q3#r#688 12 2.688t12-2.688v2.688q0 1.625-3.531 2.813T12 32.002t-8.469-1.188T0 28.001v-2.688zM20 8q-4.938 0-8.469-1.188T8 3.999t3.531-2.813T20-.002t8.469 1.188T32 3.999t-3.531 2.813T20 8zM0 18.75q1.875 1.563 5.125 2.406T12 22q2.375 0 4.625-.344t4.188-1.094 3.188-1.813v3.25q0 1.625-3.531 2.813T12.001 26t-8.469-1.188-3.531-2.813v-3.25zm26 .688V15.5q3.938-.688 6-2.188V16q0 .563-.438 1.063t-1.219.969-1.875.813-2.469.594zM12 10q5 0 8.5 1.469T24 15t-3.5 3.531T12 20t-8.5-1.469T0 15t3.5-3.531T12 10zm13.688 3.5q-.75-2.125-3.75-3.563 6.875-.313 10.063-2.625V10q0 1.125-1.719 2.063t-4.594 1.438z'
	    ),
	    'compact-disc' => array(
		'p' => '#i#5.5 16q0-4.125 2.938-7.063t7.063-2.938v-2q-4.938 0-8.469 3.531t-3.531 8.469h2zm10 6q2.5 0 4.25-1.75T21.5 16t-1.75-4.25T15.5 10t-4.25 1.75T9.5 16t1.75 4.25T15.5 22zm0-8q.813 0 1.406.594T17.5 16t-.594 1.406T15.5 18t-1.406-.594T13.5 16t.594-1.406T15.5 14z',
		'w' => .96875,
		'vw' => 31
	    ),
	    'crow' => array(
		'p' => 'M34 2q2.5 0 4.25 1.156T40 6l-6 1v5q0 4.063-2.406 7.219T25.375 23.5l2.563 7q.25.688-.438.938l-1.375.5q-.75.25-1-.438l-2.75-7.5h-2.813l2.375 6.5q.25.688-.438.938l-1.375.5q-.75.25-1-.438l-2.75-7.5h-6.063l-7.563 3.813q-.938.438-1.844-.094t-.906-1.594q0-.938.75-1.5l23.25-18.313V4.999q0-2.063 1.469-3.531t3.531-1.469q2.438 0 4 2h1zm-5 4.5q.625 0 1.063-.438t.438-1.063-.438-1.063T29 3.498t-1.063.438-.438 1.063.438 1.063T29 6.5z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'crown' => array(
		'p' => 'M33 28q.438 0 .719.281T34 29v2q0 .438-.281.719T33 32H7q-.438 0-.719-.281T6 31v-2q0-.438.281-.719T7 28h26zm4-20q1.25 0 2.125.875T40 11t-.875 2.125T37 14q-.188 0-.5-.063L32 26H8L3.5 13.937Q3.187 14 3 14q-1.25 0-2.125-.875T0 11t.875-2.125T3 8t2.125.875T6 11q0 .625-.25 1.25l4.5 2.688q.688.438 1.531.219T13 14.251l5.125-8.938Q17 4.375 17 3q0-1.25.875-2.125T20 0t2.125.875T23 3q0 1.375-1.125 2.313L27 14.251q.375.688 1.188.906t1.563-.219l4.5-2.688q-.25-.625-.25-1.25 0-1.25.875-2.125T37.001 8z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'dice' => array(
		'p' => 'M37 12q1.25 0 2.125.875T40 15v14q0 1.25-.875 2.125T37 32H23q-1.25 0-2.125-.875T20 29v-2.875l8.5-8.563q1.125-1.125 1.406-2.656T29.562 12H37zm-7 11.5q.625 0 1.063-.438t.438-1.063-.438-1.063T30 20.498t-1.063.438-.438 1.063.438 1.063T30 23.5zm-2.875-11.687q.875.938.875 2.188t-.875 2.188L16.187 27.127q-.938.875-2.188.875t-2.188-.875L.873 16.189q-.875-.938-.875-2.188t.875-2.188L11.811.875Q12.749 0 13.999 0t2.188.875zM6 15.5q.625 0 1.063-.438t.438-1.063-.438-1.063T6 12.498t-1.063.438-.438 1.063.438 1.063T6 15.5zm8 8q.625 0 1.063-.438t.438-1.063-.438-1.063T14 20.498t-1.063.438-.438 1.063.438 1.063T14 23.5zm0-8q.625 0 1.063-.438t.438-1.063-.438-1.063T14 12.498t-1.063.438-.438 1.063.438 1.063T14 15.5zm0-8q.625 0 1.063-.438t.438-1.063-.438-1.063T14 4.498t-1.063.438-.438 1.063.438 1.063T14 7.5zm8 8q.625 0 1.063-.438t.438-1.063-.438-1.063T22 12.498t-1.063.438-.438 1.063.438 1.063T22 15.5z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'dice-five' => array(
		'p' => 'M24 2q1.688 0 2.844 1.156T28 6v20q0 1.688-1.156 2.844T24 30H4q-1.688 0-2.844-1.156T0 26V6q0-1.688 1.156-2.844T4 2h20zM8 24q.813 0 1.406-.594T10 22t-.594-1.406T8 20t-1.406.594T6 22t.594 1.406T8 24zm0-12q.813 0 1.406-.594T10 10t-.594-1.406T8 8t-1.406.594T6 10t.594 1.406T8 12zm6 6q.813 0 1.406-.594T16 16t-.594-1.406T14 14t-1.406.594T12 16t.594 1.406T14 18zm6 6q.813 0 1.406-.594T22 22t-.594-1.406T20 20t-1.406.594T18 22t.594 1.406T20 24zm0-12q.813 0 1.406-.594T22 10t-.594-1.406T20 8t-1.406.594T18 10t.594 1.406T20 12z',
		'w' => .875,
		'vw' => 28
	    ),
	    'dice-four' => array(
		'p' => 'M24 2q1.688 0 2.844 1.156T28 6v20q0 1.688-1.156 2.844T24 30H4q-1.688 0-2.844-1.156T0 26V6q0-1.688 1.156-2.844T4 2h20zM8 24q.813 0 1.406-.594T10 22t-.594-1.406T8 20t-1.406.594T6 22t.594 1.406T8 24zm0-12q.813 0 1.406-.594T10 10t-.594-1.406T8 8t-1.406.594T6 10t.594 1.406T8 12zm12 12q.813 0 1.406-.594T22 22t-.594-1.406T20 20t-1.406.594T18 22t.594 1.406T20 24zm0-12q.813 0 1.406-.594T22 10t-.594-1.406T20 8t-1.406.594T18 10t.594 1.406T20 12z',
		'w' => .875,
		'vw' => 28
	    ),
	    'dice-one' => array(
		'p' => 'M24 2q1.688 0 2.844 1.156T28 6v20q0 1.688-1.156 2.844T24 30H4q-1.688 0-2.844-1.156T0 26V6q0-1.688 1.156-2.844T4 2h20zM14 18q.813 0 1.406-.594T16 16t-.594-1.406T14 14t-1.406.594T12 16t.594 1.406T14 18z',
		'w' => .875,
		'vw' => 28
	    ),
	    'dice-six' => array(
		'p' => 'M24 2q1.688 0 2.844 1.156T28 6v20q0 1.688-1.156 2.844T24 30H4q-1.688 0-2.844-1.156T0 26V6q0-1.688 1.156-2.844T4 2h20zM8 24q.813 0 1.406-.594T10 22t-.594-1.406T8 20t-1.406.594T6 22t.594 1.406T8 24zm0-6q.813 0 1.406-.594T10 16t-.594-1.406T8 14t-1.406.594T6 16t.594 1.406T8 18zm0-6q.813 0 1.406-.594T10 10t-.594-1.406T8 8t-1.406.594T6 10t.594 1.406T8 12zm12 12q.813 0 1.406-.594T22 22t-.594-1.406T20 20t-1.406.594T18 22t.594 1.406T20 24zm0-6q.813 0 1.406-.594T22 16t-.594-1.406T20 14t-1.406.594T18 16t.594 1.406T20 18zm0-6q.813 0 1.406-.594T22 10t-.594-1.406T20 8t-1.406.594T18 10t.594 1.406T20 12z',
		'w' => .875,
		'vw' => 28
	    ),
	    'dice-three' => array(
		'p' => 'M24 2q1.688 0 2.844 1.156T28 6v20q0 1.688-1.156 2.844T24 30H4q-1.688 0-2.844-1.156T0 26V6q0-1.688 1.156-2.844T4 2h20zM8 12q.813 0 1.406-.594T10 10t-.594-1.406T8 8t-1.406.594T6 10t.594 1.406T8 12zm6 6q.813 0 1.406-.594T16 16t-.594-1.406T14 14t-1.406.594T12 16t.594 1.406T14 18zm6 6q.813 0 1.406-.594T22 22t-.594-1.406T20 20t-1.406.594T18 22t.594 1.406T20 24z',
		'w' => .875,
		'vw' => 28
	    ),
	    'dice-two' => array(
		'p' => 'M24 2q1.688 0 2.844 1.156T28 6v20q0 1.688-1.156 2.844T24 30H4q-1.688 0-2.844-1.156T0 26V6q0-1.688 1.156-2.844T4 2h20zM8 12q.813 0 1.406-.594T10 10t-.594-1.406T8 8t-1.406.594T6 10t.594 1.406T8 12zm12 12q.813 0 1.406-.594T22 22t-.594-1.406T20 20t-1.406.594T18 22t.594 1.406T20 24z',
		'w' => .875,
		'vw' => 28
	    ),
	    'divide' => array(
		'p' => 'M14 22q1.688 0 2.844 1.156T18 26t-1.156 2.844T14 30t-2.844-1.156T10 26t1.156-2.844T14 22zm0-12q-1.688 0-2.844-1.156T10 6t1.156-2.844T14 2t2.844 1.156T18 6t-1.156 2.844T14 10zm12 3q.813 0 1.406.594T28 15v2q0 .813-.594 1.406T26 19H2q-.813 0-1.406-.594T0 17v-2q0-.813.594-1.406T2 13h24z',
		'w' => .875,
		'vw' => 28
	    ),
	    'door-closed' => array(
		'p' => 'M39 28q.438 0 .719.281T40 29v2q0 .438-.281.719T39 32H1q-.438 0-.719-.281T0 31v-2q0-.438.281-.719T1 28h7V3.187q0-1.313.875-2.25T11-.001h18q1.25 0 2.125.938T32 3.187V28h7zM26 18q.813 0 1.406-.594T28 16t-.594-1.406T26 14t-1.406.594T24 16t.594 1.406T26 18z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'door-open' => array(
		'p' => 'M39 28q.438 0 .719.281T40 29v2q0 .438-.281.719T39 32h-9V8h-6V4h7q1.25 0 2.125.906T34 7.062V28h5zM19.5.063q.938-.25 1.719.375T22 2.063v29.938H1q-.438 0-.719-.281T0 31.001v-2q0-.438.281-.719T1 28.001h5V5.188q0-.688.438-1.25t1.063-.75zM16.5 18q.625 0 1.063-.594T18.001 16t-.438-1.406T16.5 14t-1.063.594T14.999 16t.438 1.406T16.5 18z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'equals' => array(
		'p' => 'M26 19q.813 0 1.406.594T28 21v2q0 .813-.594 1.406T26 25H2q-.813 0-1.406-.594T0 23v-2q0-.813.594-1.406T2 19h24zm0-12q.813 0 1.406.594T28 9v2q0 .813-.594 1.406T26 13H2q-.813 0-1.406-.594T0 11V9q0-.813.594-1.406T2 7h24z',
		'w' => .875,
		'vw' => 28
	    ),
	    'feather' => array(
		'p' => 'M29.188 2.813q2.438 2.438 2.75 5.656t-1.75 6.781L22 18h6.125l-2.938 2.938-9.188 3.063h6.125q-1.688 1.625-3.906 2.594t-4.375 1.219-3.969.125-3.188-.5l-4.125 4.125q-.438.438-1.063.438t-1.063-.438-.438-1.063.438-1.063l16.25-16.188q.688-.75-.031-1.438t-1.406 0L4.06 22.937q-.375-3.313.531-6.938t3.469-6.25q.438-.375 1.469-1.438t3.906-3.875q2.75-2.75 5.719-3.781t5.5-.438 4.531 2.594z'
	    ),
	    'frog' => array(
		'p' => 'M27.938 6.063q3.625 1.25 6.188 2.625 1.875 1 1.875 3.188 0 .875-.531 1.813t-1.344 1.375l-9.625 5.375 6.125 6.563h3.375q.813 0 1.406.594t.594 1.406q0 .438-.281.719t-.719.281h-5.625l-7.438-7.875q.125-1.5-.406-2.875t-1.063-1.969-1.094-.969q-1.688-1.313-3.875-1.313t-3.938 1.313l-2.188 1.625q-.75.625-.156 1.406t1.406.219l2-1.563q2.188-1.625 4.563-.688 2 .875 2.625 2.938t-.563 3.75l-2.188 3h4.938q.813 0 1.406.594t.594 1.406q0 .438-.281.719t-.719.281h-19q-1.625 0-2.813-1.156t-1#q#781q0-3.063.875-5.969t2.531-5.281 3.906-4.25 5-3.031 5.75-1.406q.375-1.813 1.75-2.969t3.188-1.156 3.188 1.156 1.75 2.906zM23 8.5q.625 0 1.063-.438t.438-1.063-.438-1.063T23 5.498t-1.063.438-.438 1.063.438 1.063T23 8.5z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'gas-pump' => array(
		'p' => 'M21 28q.438 0 .719.281T22 29v2q0 .438-.281.719T21 32H1q-.438 0-.719-.281T0 31v-2q0-.438.281-.719T1 28h20zm9.813-21.312q1.188 1.188 1.188 2.875v13.938q0 2-1.469 3.344t-3.531 1.156q-1.688-#q#844-1.563t-1.156-3.188V21.5q0-1.063-.719-1.781T20.501 19h-.5v7h-18V4q0-1.625 1#q#813T6.002-.001h10q1.625 0 2.813 1.188T20.003 4v12h.5q2.25 0 3.875 1.625t1.625 3.875v2q0 .625.438 1.063t1.063.438 1.063-.438.438-1.063V13.437q-1.25-#q#125-1.156T26.005 10V6.125L23.63 3.75q-.25-.25-.25-.688t.25-.688l.75-.75q.25-.25.688-.25t.688.25zM16 12V4H6v8h10z'
	    ),
	    'glasses' => array(
		'p' => 'M35.875 17.5q.125.5.125 1v4.375q0 2.938-2.094 5.031T28.812 30h-2.313q-2.875 0-4.938-1.906t-2.25-4.656L19.123 21h-2.25l-.188 2.438q-.188 2.75-2.25 4.656T9.497 30H7.184q-3 0-5.094-2.094t-2.094-5.031V18.5q0-.5.125-1L2.934 6.187q.625-2.375 2.719-3.531t4.344-.344l1 .313q.375.125.563.5t.063.75l-.313.938q-.125.375-.5.563t-.75.063l-.875-.25q-1.125-.375-2.063.063-1 .563-1.25 1.625l-2.438 9.625q2.563-.75 5.125-.75 3.688 0 7.125 1.625h4.625q3.438-1.625 7.125-1.625 2.563 0 5.125.75l-2.438-9.625q-.25-1.063-1.25-1.625-.938-.438-2.063-.063l-.875.25q-.375.125-.75-.063t-.5-.563l-.313-.938q-.125-.375.063-.75t.563-.5l1-.313q2.25-.813 4.344.344t2.719 3.531zm-23.187 5.625l.25-2.563q-2.188-.813-4.375-.813-2.313 0-4.563.813v2.313q0 1.313.938 2.219t2.25.906h2.313q1.25 0 2.188-.844t1-2.031zM32 22.875v-2.313q-2.25-.813-4.563-.813-2.188 0-4.375.813l.25 2.563q.063 1.188 1 2.031T26.5 26h2.313q1.313 0 2.25-.906t.938-2.219z',
		'w' => 1.125,
		'vw' => 36
	    ),
	    'greater-than' => array(
		'p' => 'M22.875 13.125q1.125.5 1.125 1.813v2.125q0 .563-.344 1.094t-.781.719L3.687 27.814q-.75.375-1.531.094t-1.094-1.031l-.875-1.813q-.375-.75-.094-1.531t1.031-1.156l13.688-6.375L1.187 9.627Q.374 9.314.093 8.533t.094-1.531l.875-1.813q.313-.813 1.094-1.094t1.531.094z',
		'w' => .75,
		'vw' => 24
	    ),
	    'greater-than-equal' => array(
		'p' => 'M3.438 6.75q-.438-.188-.75-.438t-.469-.594-.188-.75.094-.781l.75-1.875q.313-.75 1.156-1.125t1.656-.063l18.875 7.5Q26 9.062 26 10.499v1q0 1.438-1.438 1.875l-18.813 7.5q-.875.313-1.719-.063t-1.156-1.125l-.75-1.875q-.313-.813.094-1.563t1.219-1l11-4.25zM26.5 25q.625 0 1.063.438t.438 1.063v3q#p#8h-25q-.625 0-1.063-.438t-.438-1.063v-3q0-.625.438-1.063T1.5 25h25z',
		'w' => .875,
		'vw' => 28
	    ),
	    'helicopter' => array(
		'p' => 'M19 24q-1 0-1.625-.813L12 15.999l-10-4-2-6.75q-.063-.5.219-.875T1 3.999h2.5q.5 0 .813.375l2.688 3.625h13v-4h-11q-.438 0-.719-.281t-.281-.719v-2q0-.438.281-.719t.719-.281h26q.438 0 .719.281t.281.719v2q0 .438-.281.719t-.719.281h-11v4q5.813 0 9.906 4.094t4.094 9.906q0 .813-.594 1.406t-1.406.594h-17zm7-11.75V20h7.813q-.438-1.938-1.531-3.563t-2.719-2.719T26 12.249zm13.688 16.438q.313.313.313.75t-.375.688q-2.063 1.875-4.25 1.875H15.001q-.438 0-.719-.281t-.281-.719v-2q0-.438.281-.719t.719-.281h20.375q.813 0 1.531-.688t1.406 0z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'infinity' => array(
		'p' => 'M29.438 6q4.375 0 7.469 2.938t3.094 7.063-3.094 7.063-7.469 2.938q-5.063 0-9.438-4.938-4.375 4.938-9.438 4.938-4.375 0-7.469-2.938t-3.094-7.063 3.094-7.063T10.562 6Q15.625 6 20 10.938 24.375 6 29.438 6zM10.563 20q2.938 0 5.875-4-2.938-4-5.875-4-1.25 0-2.281.531T6.626 14t-.625 2q0 1.625 1.344 2.813t3.219 1.188zm18.875 0q.75 0 1.438-.188t1.25-.563 1-.875.656-1.125.219-1.25q0-1.625-1.344-2.813t-3.219-1.188q-2.938 0-5.875 4 2.938 4 5.875 4z',
		'w' => 1.25,
		'vw' => 40
	    ),
	    'kiwi-bird' => array(
		'p' => 'M36 13.625V29q0 .75-.75 1H35q-.625 0-.875-.5L29.5 20.937Q28.75 21 28 21q-4.75 0-9.5 3.063-1.063.688-2.5 1.25v3.688q0 .438-.281.719t-.719.281h-1q-.438 0-.719-.281T13 29.001v-3.063q-.875.063-1 .063-1.5 0-3-.375v3.375q0 .438-.281.719T8 30.001H7q-.438 0-.719-.281T6 29.001v-4.625q-2.75-1.563-4.375-4.344T0 14.001q0-2.563.875-4.688t2-3.313T5.5 3.937t2.313-1.188 1.375-.438q5.25-1.188 9.625 1.813 4.188 2.875 9.188 2.875h.625q2.875 0 5.031 1.906t2.344 4.719zM29 15.5q.625 0 1.063-.438t.438-1.063-.4