<?php
class Gavias_Footer{
  public static $post_type = 'footer';
  function __construct(){ 
    add_action('init', array($this, 'gavias_post_type_footer'), 10);
    //add_action('wp_head', array($this, 'add_custom_css'));
  }

  function gavias_post_type_footer(){
    $labels = array(
      'name' => __( 'Footers', 'gaviasframework' ),
      'singular_name' => __( 'Footer', 'gaviasframework' ),
      'add_new' => __( 'Add Profile Footer', 'gaviasframework' ),
      'add_new_item' => __( 'Add Profile Footer', 'gaviasframework' ),
      'edit_item' => __( 'Edit Footer', 'gaviasframework' ),
      'new_item' => __( 'New Profile', 'gaviasframework' ),
      'view_item' => __( 'View Footer Profile', 'gaviasframework' ),
      'search_items' => __( 'Search Footer Profiles', 'gaviasframework' ),
      'not_found' => __( 'No Footer Profiles found', 'gaviasframework' ),
      'not_found_in_trash' => __( 'No Footer Profiles found in Trash', 'gaviasframework' ),
      'parent_item_colon' => __( 'Parent Footer:', 'gaviasframework' ),
      'menu_name' => __( 'Footers', 'gaviasframework' ),
    );

    $args = array(
        'labels' => $labels,
        'hierarchical' => true,
        'description' => 'List Footer',
        'supports' => array( 'title', 'editor' ),
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'menu_position' => 5,
        'show_in_nav_menus' => false,
        'publicly_queryable' => false,
        'exclude_from_search' => false,
        'has_archive' => false,
        'query_var' => true,
        'can_export' => true,
        'rewrite' => false
    );
    register_post_type( self::$post_type, $args );

    if($options = get_option('wpb_js_content_types')){
      $check = true;
      foreach ($options as $key => $value) {
        if($value=='footer') $check=false;
      }
      if($check)
        $options[] = 'footer';
      update_option( 'wpb_js_content_types',$options );
    }else{
      $options = array('page','footer');
    }
  }

  function add_custom_css(){
      global $post;
      $args = array(
        'post_type'     => self::$post_type,
        'posts_per_page'   => -1,
        'post_status'    => 'publish',
      );
      $posts = new WP_Query($args);
      if( $posts->have_posts() ){
        $custom_css = '';
        while( $posts->have_posts() ){
          $posts->the_post();
          $custom_css .= get_post_meta( $post->ID, '_wpb_shortcodes_custom_css', true );
        }
        if( !empty($custom_css) ){
          echo '<style type="text/css" data-type="vc_shortcodes-custom-css">';
          echo $custom_css;
          echo '</style>';
        }
      }
      wp_reset_postdata();
    }

  public static function get_footers(){
    $args = array(
      'post_type'        => 'footer',
      'posts_per_page'   => 100,
      'numberposts'      => 100,
      'post_status'     => 'publish',
    );
    $footers = array();
    $footers = array('default' => __('Default Widget Footer', 'gaviasframework') );

    $post_list = get_posts($args);
    foreach ( $post_list as $post ) {
      $footers[$post->ID] = $post->post_title;
    }

    wp_reset_postdata();
    return apply_filters('gaviasthemes_list_footer', $footers );
  }
}

new Gavias_Footer();