<?php
/**
 * Template Name: Custom Home Page
 */
get_header(); ?>

<main id="content">
  <?php if( get_option('recycling_energy_slider_arrows') == '1'){ ?>
    <section id="slider">
      <span class="design-right"></span>
      <div id="carouselExampleIndicators" class="carousel slide" data-ride="carousel">
        <?php
          for ( $i = 1; $i <= 4; $i++ ) {
            $recycling_energy_mod =  get_theme_mod( 'recycling_energy_post_setting' . $i );
            if ( 'page-none-selected' != $recycling_energy_mod ) {
              $recycling_energy_slide_post[] = $recycling_energy_mod;
            }
          }
           if( !empty($recycling_energy_slide_post) ) :
          $recycling_energy_args = array(
            'post_type' =>array('post'),
            'post__in' => $recycling_energy_slide_post,
            'ignore_sticky_posts'  => true, // Exclude sticky posts by default
          );

          // Check if specific posts are selected
          if (empty($recycling_energy_slide_post) && is_sticky()) {
              $args['post__in'] = get_option('sticky_posts');
          }

          $recycling_energy_query = new WP_Query( $recycling_energy_args );
          if ( $recycling_energy_query->have_posts() ) :
            $i = 1;
        ?>
        <div class="carousel-inner" role="listbox">
          <?php  while ( $recycling_energy_query->have_posts() ) : $recycling_energy_query->the_post(); ?>
          <div <?php if($i == 1){echo 'class="carousel-item active"';} else{ echo 'class="carousel-item"';}?>>
            <?php if(has_post_thumbnail()){ ?>
                  <img src="<?php the_post_thumbnail_url('full'); ?>"/>
                <?php }else { ?><div class="bg-color"></div> <?php } ?>
            <div class="carousel-caption slider-inner">
              <h2 class="slider-title"><?php the_title();?></h2>
              <?php if( get_option('recycling_energy_slider_excerpt_show_hide',false) != 'off'){ ?>
                <p class="slider-excerpt mb-0"><?php echo wp_trim_words(get_the_content(), get_theme_mod('recycling_energy_slider_excerpt_count',20) );?></p>
              <?php } ?>
              <div class="home-btn my-4">
                <a class="py-3 px-4" href="<?php the_permalink(); ?>"><?php echo esc_html(get_theme_mod('recycling_energy_slider_read_more',__('Get Involved','recycling-energy'))); ?></a>
              </div>
            </div>
          </div>
          <?php $i++; endwhile;
          wp_reset_postdata();?>
        </div>
        <?php else : ?>
        <div class="no-postfound"></div>
          <?php endif;
        endif;?>
          <a class="carousel-control-prev" href="#carouselExampleIndicators" role="button" data-slide="prev">
            <span class="carousel-control-prev-icon" aria-hidden="true"><i class="fas fa-long-arrow-alt-left"></i></span>
          </a>
          <a class="carousel-control-next" href="#carouselExampleIndicators" role="button" data-slide="next">
            <span class="carousel-control-next-icon" aria-hidden="true"><i class="fas fa-long-arrow-alt-right"></i></span>
          </a>
      </div>
      <div class="clearfix"></div>
    </section>
  <?php }?>
<?php if( get_option('recycling_energy_services_enable') == '1'){ ?>
  <section id="home-mission" class="py-5">
    <div class="container">
      <?php if( get_theme_mod('recycling_energy_mission_main_title') != '' ){ ?>
        <h3 class="text-center"><?php echo esc_html(get_theme_mod('recycling_energy_mission_main_title','')); ?></h3>
        <hr>
      <?php }?>
      <?php if( get_theme_mod('recycling_energy_mission_short_title') != '' ){ ?>
        <p class="text-center"><?php echo esc_html(get_theme_mod('recycling_energy_mission_short_title','')); ?></p>
      <?php }?>

      <div class="owl-carousel pt-4">
        <?php
          $recycling_energy_project_category=  get_theme_mod('recycling_energy_mission_category_setting');if($recycling_energy_project_category){
          $recycling_energy_page_query = new WP_Query(array( 'category_name' => esc_html($recycling_energy_project_category ,'recycling-energy')));?>
            <?php while( $recycling_energy_page_query->have_posts() ) : $recycling_energy_page_query->the_post(); ?>
              <div class="box">
                <div class="row">
                  <div class="col-lg-6 col-md-6 align-self-center">
                    <div class="img-box">
                      <?php the_post_thumbnail(); ?>
                    </div>
                  </div>
                  <div class="col-lg-6 col-md-6 align-self-center">
                    <div class="box-content p-3">
                      <a href="<?php the_permalink(); ?>"><h4 class="mt-3"><?php the_title();?></h4></a>
                      <p><?php echo esc_html(wp_trim_words(get_the_content(),'50') );?></p>
                      <div class="box-button">
                        <a class="py-2 px-3" href="<?php the_permalink(); ?>"><?php esc_html_e('READ MORE','recycling-energy');?></a>
                      </div>
                      <?php if( get_post_meta($post->ID, 'recycling_energy_mission_number', true) ) {?>
                        <div class="progress pink">
                          <div class="progress-bar" style="width:<?php echo esc_html(get_post_meta($post->ID,'recycling_energy_mission_number',true)); ?>; background:#7fb93d;">
                            <div class="progress-value"><?php echo esc_html(get_post_meta($post->ID,'recycling_energy_mission_number',true)); ?></div>
                          </div>
                        </div>
                      <?php }?>
                    </div>
                  </div>
                </div>
              </div>
            <?php endwhile;
          wp_reset_postdata();
        }?>
      </div>
    </div>
  </section>
  <?php }?>
  <section id="custom-page-content" <?php if ( have_posts() && trim( get_the_content() ) !== '' ) echo 'class="pt-3"'; ?>>
    <div class="container">
      <?php while ( have_posts() ) : the_post(); ?>
        <?php the_content(); ?>
      <?php endwhile; ?>
    </div>
  </section>
</main>

<?php get_footer(); ?>
