<?php
/**
 * Recycling Energy: Customizer
 *
 * @subpackage Recycling Energy
 * @since 1.0
 */

function recycling_energy_customize_register( $wp_customize ) {

	wp_enqueue_style('customizercustom_css', esc_url( get_template_directory_uri() ). '/assets/css/customizer.css');

	// fontawesome icon-picker

	load_template( trailingslashit( get_template_directory() ) . '/inc/icon-picker.php' );

	// Add custom control.
  	require get_parent_theme_file_path( 'inc/switch/control_switch.php' );

  	require get_parent_theme_file_path( 'inc/custom-control.php' );

  	//Register the sortable control type.
	$wp_customize->register_control_type( 'Recycling_Energy_Control_Sortable' );

  	// Add homepage customizer file
  	require get_template_directory() . '/inc/customizer-home-page.php';

  	// pro section
  	$wp_customize->add_section('recycling_energy_pro', array(
        'title'    => __('UPGRADE RECYCLING ENERGY PREMIUM', 'recycling-energy'),
        'priority' => 1,
    ));
    $wp_customize->add_setting('recycling_energy_pro', array(
        'default'           => null,
        'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control(new Recycling_Energy_Pro_Control($wp_customize, 'recycling_energy_pro', array(
        'label'    => __('Recycling Energy PREMIUM', 'recycling-energy'),
        'section'  => 'recycling_energy_pro',
        'settings' => 'recycling_energy_pro',
        'priority' => 1,
    )));

  	//logo
	$wp_customize->add_setting('recycling_energy_logo_max_height',array(
		'default'=> '100',
		'transport' => 'refresh',
		'sanitize_callback' => 'recycling_energy_sanitize_integer'
	));
	$wp_customize->add_control(new Recycling_Energy_Slider_Custom_Control( $wp_customize, 'recycling_energy_logo_max_height',array(
		'label'	=> esc_html__('Logo Width','recycling-energy'),
		'section'=> 'title_tagline',
		'settings'=>'recycling_energy_logo_max_height',
		'input_attrs' => array(
			'reset'			   => 100,
            'step'             => 1,
			'min'              => 0,
			'max'              => 250,
        ),
        'priority' => 9,
	)));
	$wp_customize->add_setting('recycling_energy_logo_title',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'recycling_energy_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(new Recycling_Energy_Customizer_Customcontrol_Switch(
			$wp_customize,
			'recycling_energy_logo_title',
			array(
				'settings'        => 'recycling_energy_logo_title',
				'section'         => 'title_tagline',
				'label'           => __( 'Show Site Title', 'recycling-energy' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'recycling-energy' ),
					'off'    => __( 'Off', 'recycling-energy' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->add_setting('recycling_energy_logo_text',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => 'off',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'recycling_energy_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(new Recycling_Energy_Customizer_Customcontrol_Switch(
			$wp_customize,
			'recycling_energy_logo_text',
			array(
				'settings'        => 'recycling_energy_logo_text',
				'section'         => 'title_tagline',
				'label'           => __( 'Show Site Tagline', 'recycling-energy' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'recycling-energy' ),
					'off'    => __( 'Off', 'recycling-energy' ),
				),
				'active_callback' => '',
			)
		)
	);

	// typography
	$wp_customize->add_section( 'recycling_energy_typography_settings', array(
		'title'       => __( 'Typography Settings', 'recycling-energy' ),
		'priority'       => 2,
	) );
	$recycling_energy_font_choices = array(
			'' => 'Select',
			'Source Sans Pro:400,700,400italic,700italic' => 'Source Sans Pro',
			'Open Sans:400italic,700italic,400,700' => 'Open Sans',
			'Oswald:400,700' => 'Oswald',
			'Playfair Display:400,700,400italic' => 'Playfair Display',
			'Montserrat:400,700' => 'Montserrat',
			'Raleway:400,700' => 'Raleway',
			'Droid Sans:400,700' => 'Droid Sans',
			'Lato:400,700,400italic,700italic' => 'Lato',
			'Arvo:400,700,400italic,700italic' => 'Arvo',
			'Lora:400,700,400italic,700italic' => 'Lora',
			'Merriweather:400,300italic,300,400italic,700,700italic' => 'Merriweather',
			'Oxygen:400,300,700' => 'Oxygen',
			'PT Serif:400,700' => 'PT Serif',
			'PT Sans:400,700,400italic,700italic' => 'PT Sans',
			'PT Sans Narrow:400,700' => 'PT Sans Narrow',
			'Cabin:400,700,400italic' => 'Cabin',
			'Fjalla One:400' => 'Fjalla One',
			'Francois One:400' => 'Francois One',
			'Josefin Sans:400,300,600,700' => 'Josefin Sans',
			'Libre Baskerville:400,400italic,700' => 'Libre Baskerville',
			'Arimo:400,700,400italic,700italic' => 'Arimo',
			'Ubuntu:400,700,400italic,700italic' => 'Ubuntu',
			'Bitter:400,700,400italic' => 'Bitter',
			'Droid Serif:400,700,400italic,700italic' => 'Droid Serif',
			'Roboto:400,400italic,700,700italic' => 'Roboto',
			'Open Sans Condensed:700,300italic,300' => 'Open Sans Condensed',
			'Roboto Condensed:400italic,700italic,400,700' => 'Roboto Condensed',
			'Roboto Slab:400,700' => 'Roboto Slab',
			'Yanone Kaffeesatz:400,700' => 'Yanone Kaffeesatz',
			'Rokkitt:400' => 'Rokkitt',
	);
	$wp_customize->add_setting( 'recycling_energy_section_typo_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Recycling_Energy_Customizer_Customcontrol_Section_Heading( $wp_customize, 'recycling_energy_section_typo_heading', array(
		'label'       => esc_html__( 'Typography Settings', 'recycling-energy' ),
		'section'     => 'recycling_energy_typography_settings',
		'settings'    => 'recycling_energy_section_typo_heading',
	) ) );
	$wp_customize->add_setting( 'recycling_energy_headings_text', array(
		'sanitize_callback' => 'recycling_energy_sanitize_fonts',
	));
	$wp_customize->add_control( 'recycling_energy_headings_text', array(
		'type' => 'select',
		'description' => __('Select your suitable font for the headings.', 'recycling-energy'),
		'section' => 'recycling_energy_typography_settings',
		'choices' => $recycling_energy_font_choices
	));
	$wp_customize->add_setting( 'recycling_energy_body_text', array(
		'sanitize_callback' => 'recycling_energy_sanitize_fonts'
	));
	$wp_customize->add_control( 'recycling_energy_body_text', array(
		'type' => 'select',
		'description' => __( 'Select your suitable font for the body.', 'recycling-energy' ),
		'section' => 'recycling_energy_typography_settings',
		'choices' => $recycling_energy_font_choices
	) );

    // Theme General Settings
    $wp_customize->add_section('recycling_energy_theme_settings',array(
        'title' => __('Theme General Settings', 'recycling-energy'),
        'priority' => 2,
    ) );
    $wp_customize->add_setting( 'recycling_energy_sticky_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Recycling_Energy_Customizer_Customcontrol_Section_Heading( $wp_customize, 'recycling_energy_sticky_heading', array(
		'label'       => esc_html__( 'Sticky Header Settings', 'recycling-energy' ),
		'section'     => 'recycling_energy_theme_settings',
		'settings'    => 'recycling_energy_sticky_heading',
	) ) );
    $wp_customize->add_setting(
		'recycling_energy_sticky_header',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => 'off',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'recycling_energy_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Recycling_Energy_Customizer_Customcontrol_Switch(
			$wp_customize,
			'recycling_energy_sticky_header',
			array(
				'settings'        => 'recycling_energy_sticky_header',
				'section'         => 'recycling_energy_theme_settings',
				'label'           => __( 'Show Sticky Header', 'recycling-energy' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'recycling-energy' ),
					'off'    => __( 'Off', 'recycling-energy' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->add_setting( 'recycling_energy_loader_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Recycling_Energy_Customizer_Customcontrol_Section_Heading( $wp_customize, 'recycling_energy_loader_heading', array(
		'label'       => esc_html__( 'Loader Settings', 'recycling-energy' ),
		'section'     => 'recycling_energy_theme_settings',
		'settings'    => 'recycling_energy_loader_heading',
	) ) );
	$wp_customize->add_setting(
		'recycling_energy_theme_loader',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => 'off',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'recycling_energy_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Recycling_Energy_Customizer_Customcontrol_Switch(
			$wp_customize,
			'recycling_energy_theme_loader',
			array(
				'settings'        => 'recycling_energy_theme_loader',
				'section'         => 'recycling_energy_theme_settings',
				'label'           => __( 'Show Site Loader', 'recycling-energy' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'recycling-energy' ),
					'off'    => __( 'Off', 'recycling-energy' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->add_setting( 'recycling_energy_menu_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Recycling_Energy_Customizer_Customcontrol_Section_Heading( $wp_customize, 'recycling_energy_menu_heading', array(
		'label'       => esc_html__( 'Menu Settings', 'recycling-energy' ),
		'section'     => 'recycling_energy_theme_settings',
		'settings'    => 'recycling_energy_menu_heading',
	) ) );
    $wp_customize->add_setting('recycling_energy_menu_text_transform',array(
        'default' => 'CAPITALISE',
        'sanitize_callback' => 'recycling_energy_sanitize_choices'
	));
	$wp_customize->add_control('recycling_energy_menu_text_transform',array(
        'type' => 'select',
        'label' => __('Menus Text Transform','recycling-energy'),
        'section' => 'recycling_energy_theme_settings',
        'choices' => array(
            'CAPITALISE' => __('CAPITALISE','recycling-energy'),
            'UPPERCASE' => __('UPPERCASE','recycling-energy'),
            'LOWERCASE' => __('LOWERCASE','recycling-energy'),
        ),
	) );
	$wp_customize->add_setting( 'recycling_energy_section_scroll_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Recycling_Energy_Customizer_Customcontrol_Section_Heading( $wp_customize, 'recycling_energy_section_scroll_heading', array(
		'label'       => esc_html__( 'Scroll Top Settings', 'recycling-energy' ),
		'section'     => 'recycling_energy_theme_settings',
		'settings'    => 'recycling_energy_section_scroll_heading',
	) ) );
	$wp_customize->add_setting(
		'recycling_energy_scroll_enable',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'recycling_energy_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Recycling_Energy_Customizer_Customcontrol_Switch(
			$wp_customize,
			'recycling_energy_scroll_enable',
			array(
				'settings'        => 'recycling_energy_scroll_enable',
				'section'         => 'recycling_energy_theme_settings',
				'label'           => __( 'show Scroll Top', 'recycling-energy' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'recycling-energy' ),
					'off'    => __( 'Off', 'recycling-energy' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->add_setting( 'recycling_energy_scroll_options',
		array(
			'default' => 'right_align',
			'transport' => 'refresh',
			'sanitize_callback' => 'recycling_energy_sanitize_choices'
		)
	);
	$wp_customize->add_control( new Recycling_Energy_Text_Radio_Button_Custom_Control( $wp_customize, 'recycling_energy_scroll_options',
		array(
			'type' => 'select',
			'label' => esc_html__( 'Scroll Top Alignment', 'recycling-energy' ),
			'section' => 'recycling_energy_theme_settings',
			'choices' => array(
				'left_align' => __('LEFT','recycling-energy'),
				'center_align' => __('CENTER','recycling-energy'),
				'right_align' => __('RIGHT','recycling-energy'),
			)
		)
	) );
	$wp_customize->add_setting('recycling_energy_scroll_top_icon',array(
		'default'	=> 'fas fa-chevron-up',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Recycling_Energy_Fontawesome_Icon_Chooser(
        $wp_customize,'recycling_energy_scroll_top_icon',array(
		'label'	=> __('Add Scroll Top Icon','recycling-energy'),
		'transport' => 'refresh',
		'section'	=> 'recycling_energy_theme_settings',
		'setting'	=> 'recycling_energy_scroll_top_icon',
		'type'		=> 'icon'
	)));

	// Post Layouts
	$wp_customize->add_panel( 'recycling_energy_post_panel', array(
		'title' => esc_html__( 'Post Layout', 'recycling-energy' ),
		'priority' => 4,
	));
    $wp_customize->add_section('recycling_energy_layout',array(
        'title' => __('Single-Post Layout', 'recycling-energy'),
        'panel' => 'recycling_energy_post_panel',
    ) );
    $wp_customize->add_setting( 'recycling_energy_section_post_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Recycling_Energy_Customizer_Customcontrol_Section_Heading( $wp_customize, 'recycling_energy_section_post_heading', array(
		'label'       => esc_html__( 'single Post Structure', 'recycling-energy' ),
		'section'     => 'recycling_energy_layout',
		'settings'    => 'recycling_energy_section_post_heading',
	) ) );
	$wp_customize->add_setting( 'recycling_energy_single_post_option',
		array(
			'default' => 'single_right_sidebar',
			'transport' => 'refresh',
			'sanitize_callback' => 'sanitize_text_field'
		)
	);
	$wp_customize->add_control( new Recycling_Energy_Radio_Image_Control( $wp_customize, 'recycling_energy_single_post_option',
		array(
			'type'=>'select',
			'label' => __( 'select Single Post Page Layout', 'recycling-energy' ),
			'section' => 'recycling_energy_layout',
			'choices' => array(

				'single_right_sidebar' => array(
					'image' => get_template_directory_uri().'/assets/images/2column.jpg',
					'name' => __( 'Right Sidebar', 'recycling-energy' )
				),
				'single_left_sidebar' => array(
					'image' => get_template_directory_uri().'/assets/images/left.png',
					'name' => __( 'Left Sidebar', 'recycling-energy' )
				),
				'single_full_width' => array(
					'image' => get_template_directory_uri().'/assets/images/1column.jpg',
					'name' => __( 'One Column', 'recycling-energy' )
				),
			)
		)
	) );
	$wp_customize->add_setting('recycling_energy_single_post_date',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'recycling_energy_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(new recycling_energy_Customizer_Customcontrol_Switch(
			$wp_customize,
			'recycling_energy_single_post_date',
			array(
				'settings'        => 'recycling_energy_single_post_date',
				'section'         => 'recycling_energy_layout',
				'label'           => __( 'Show Date', 'recycling-energy' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'recycling-energy' ),
					'off'    => __( 'Off', 'recycling-energy' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->selective_refresh->add_partial( 'recycling_energy_single_post_date', array(
		'selector' => '.date-box',
		'render_callback' => 'recycling_energy_customize_partial_recycling_energy_single_post_date',
	) );
	$wp_customize->add_setting('recycling_energy_single_date_icon',array(
		'default'	=> 'far fa-calendar-alt',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Recycling_Energy_Fontawesome_Icon_Chooser(
        $wp_customize,'recycling_energy_single_date_icon',array(
		'label'	=> __('date Icon','recycling-energy'),
		'transport' => 'refresh',
		'section'	=> 'recycling_energy_layout',
		'setting'	=> 'recycling_energy_single_date_icon',
		'type'		=> 'icon'
	)));
	$wp_customize->add_setting('recycling_energy_single_post_admin',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'recycling_energy_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(new recycling_energy_Customizer_Customcontrol_Switch(
			$wp_customize,
			'recycling_energy_single_post_admin',
			array(
				'settings'        => 'recycling_energy_single_post_admin',
				'section'         => 'recycling_energy_layout',
				'label'           => __( 'Show Author/Admin', 'recycling-energy' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'recycling-energy' ),
					'off'    => __( 'Off', 'recycling-energy' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->selective_refresh->add_partial( 'recycling_energy_single_post_admin', array(
		'selector' => '.entry-author',
		'render_callback' => 'recycling_energy_customize_partial_recycling_energy_single_post_admin',
	) );
	$wp_customize->add_setting('recycling_energy_single_author_icon',array(
		'default'	=> 'fas fa-user',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Recycling_Energy_Fontawesome_Icon_Chooser(
        $wp_customize,'recycling_energy_single_author_icon',array(
		'label'	=> __('Author Icon','recycling-energy'),
		'transport' => 'refresh',
		'section'	=> 'recycling_energy_layout',
		'setting'	=> 'recycling_energy_single_author_icon',
		'type'		=> 'icon'
	)));
	$wp_customize->add_setting('recycling_energy_single_post_comment',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'recycling_energy_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(new recycling_energy_Customizer_Customcontrol_Switch(
			$wp_customize,
			'recycling_energy_single_post_comment',
			array(
				'settings'        => 'recycling_energy_single_post_comment',
				'section'         => 'recycling_energy_layout',
				'label'           => __( 'Show Comment', 'recycling-energy' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'recycling-energy' ),
					'off'    => __( 'Off', 'recycling-energy' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->add_setting('recycling_energy_single_comment_icon',array(
		'default'	=> 'fas fa-comments',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Recycling_Energy_Fontawesome_Icon_Chooser(
        $wp_customize,'recycling_energy_single_comment_icon',array(
		'label'	=> __('comment Icon','recycling-energy'),
		'transport' => 'refresh',
		'section'	=> 'recycling_energy_layout',
		'setting'	=> 'recycling_energy_single_comment_icon',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('recycling_energy_single_post_tag_count',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'recycling_energy_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(new Recycling_Energy_Customizer_Customcontrol_Switch(
			$wp_customize,
			'recycling_energy_single_post_tag_count',
			array(
				'settings'        => 'recycling_energy_single_post_tag_count',
				'section'         => 'recycling_energy_layout',
				'label'           => __( 'Show tag count', 'recycling-energy' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'recycling-energy' ),
					'off'    => __( 'Off', 'recycling-energy' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->add_setting('recycling_energy_single_tag_icon',array(
		'default'	=> 'fas fa-tags',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Recycling_Energy_Fontawesome_Icon_Chooser(
        $wp_customize,'recycling_energy_single_tag_icon',array(
		'label'	=> __('tag Icon','recycling-energy'),
		'transport' => 'refresh',
		'section'	=> 'recycling_energy_layout',
		'setting'	=> 'recycling_energy_single_tag_icon',
		'type'		=> 'icon'
	)));
	$wp_customize->add_setting('recycling_energy_single_post_tag',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'recycling_energy_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(new recycling_energy_Customizer_Customcontrol_Switch(
			$wp_customize,
			'recycling_energy_single_post_tag',
			array(
				'settings'        => 'recycling_energy_single_post_tag',
				'section'         => 'recycling_energy_layout',
				'label'           => __( 'Show Tags', 'recycling-energy' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'recycling-energy' ),
					'off'    => __( 'Off', 'recycling-energy' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->selective_refresh->add_partial( 'recycling_energy_single_post_tag', array(
		'selector' => '.single-tags',
		'render_callback' => 'recycling_energy_customize_partial_recycling_energy_single_post_tag',
	) );
	$wp_customize->add_section('recycling_energy_archieve_post_layot',array(
        'title' => __('Archieve-Post Layout', 'recycling-energy'),
        'panel' => 'recycling_energy_post_panel',
    ) );
	$wp_customize->add_setting( 'recycling_energy_section_archive_post_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Recycling_Energy_Customizer_Customcontrol_Section_Heading( $wp_customize, 'recycling_energy_section_archive_post_heading', array(
		'label'       => esc_html__( 'Archieve Post Structure', 'recycling-energy' ),
		'section'     => 'recycling_energy_archieve_post_layot',
		'settings'    => 'recycling_energy_section_archive_post_heading',
	) ) );
    $wp_customize->add_setting( 'recycling_energy_post_option',
		array(
			'default' => 'right_sidebar',
			'transport' => 'refresh',
			'sanitize_callback' => 'sanitize_text_field'
		)
	);
	$wp_customize->add_control( new Recycling_Energy_Radio_Image_Control( $wp_customize, 'recycling_energy_post_option',
		array(
			'type'=>'select',
			'label' => __( 'select Post Page Layout', 'recycling-energy' ),
			'section' => 'recycling_energy_archieve_post_layot',
			'choices' => array(
				'right_sidebar' => array(
					'image' => get_template_directory_uri().'/assets/images/2column.jpg',
					'name' => __( 'Right Sidebar', 'recycling-energy' )
				),
				'left_sidebar' => array(
					'image' => get_template_directory_uri().'/assets/images/left.png',
					'name' => __( 'Left Sidebar', 'recycling-energy' )
				),
				'one_column' => array(
					'image' => get_template_directory_uri().'/assets/images/1column.jpg',
					'name' => __( 'One Column', 'recycling-energy' )
				),
				'three_column' => array(
					'image' => get_template_directory_uri().'/assets/images/3column.jpg',
					'name' => __( 'Three Column', 'recycling-energy' )
				),
				'four_column' => array(
					'image' => get_template_directory_uri().'/assets/images/4column.jpg',
					'name' => __( 'Four Column', 'recycling-energy' )
				),
				'grid_sidebar' => array(
					'image' => get_template_directory_uri().'/assets/images/grid-sidebar.jpg',
					'name' => __( 'Grid-Right-Sidebar Layout', 'recycling-energy' )
				),
				'grid_left_sidebar' => array(
					'image' => get_template_directory_uri().'/assets/images/grid-left.png',
					'name' => __( 'Grid-Left-Sidebar Layout', 'recycling-energy' )
				),
				'grid_post' => array(
					'image' => get_template_directory_uri().'/assets/images/grid.jpg',
					'name' => __( 'Grid Layout', 'recycling-energy' )
				)
			)
		)
	) );
	$wp_customize->add_setting( 'recycling_energy_grid_column',
		array(
			'default' => '3_column',
			'transport' => 'refresh',
			'sanitize_callback' => 'recycling_energy_sanitize_choices'
		)
	);
	$wp_customize->add_control( new Recycling_Energy_Text_Radio_Button_Custom_Control( $wp_customize, 'recycling_energy_grid_column',
		array(
			'type' => 'select',
			'label' => esc_html__('Grid Post Per Row','recycling-energy'),
			'section' => 'recycling_energy_archieve_post_layot',
			'choices' => array(
				'1_column' => __('1','recycling-energy'),
	            '2_column' => __('2','recycling-energy'),
	            '3_column' => __('3','recycling-energy'),
	            '4_column' => __('4','recycling-energy'),
			)
		)
	) );
	$wp_customize->add_setting('archieve_post_order', array(
        'default' => array('title', 'image', 'meta','excerpt','btn'),
        'sanitize_callback' => 'recycling_energy_sanitize_sortable',
    ));
    $wp_customize->add_control(new Recycling_Energy_Control_Sortable($wp_customize, 'archieve_post_order', array(
    	'label' => esc_html__('Post Order', 'recycling-energy'),
        'description' => __('Drag & Drop post items to re-arrange the order and also hide and show items as per the need by clicking on the eye icon.', 'recycling-energy') ,
        'section' => 'recycling_energy_archieve_post_layot',
        'choices' => array(
            'title' => __('title', 'recycling-energy') ,
            'image' => __('media', 'recycling-energy') ,
            'meta' => __('meta', 'recycling-energy') ,
            'excerpt' => __('excerpt', 'recycling-energy') ,
            'btn' => __('Read more', 'recycling-energy') ,
        ) ,
    )));
	$wp_customize->add_setting('recycling_energy_post_excerpt',array(
		'default'=> 30,
		'transport' => 'refresh',
		'sanitize_callback' => 'recycling_energy_sanitize_integer'
	));
	$wp_customize->add_control(new Recycling_Energy_Slider_Custom_Control( $wp_customize, 'recycling_energy_post_excerpt',array(
		'label' => esc_html__( 'Excerpt Limit','recycling-energy' ),
		'section'=> 'recycling_energy_archieve_post_layot',
		'settings'=>'recycling_energy_post_excerpt',
		'input_attrs' => array(
			'reset'			   => 30,
            'step'             => 1,
			'min'              => 0,
			'max'              => 100,
        ),
	)));
	$wp_customize->add_setting('recycling_energy_read_more_text',array(
		'default' => 'Read More',
		'sanitize_callback' => 'sanitize_text_field'
	)); 
	$wp_customize->add_control('recycling_energy_read_more_text',array(
		'label' => esc_html__('Read More Text','recycling-energy'),
		'section' => 'recycling_energy_archieve_post_layot',
		'setting' => 'recycling_energy_read_more_text',
		'type'    => 'text'
	));
	$wp_customize->add_setting('recycling_energy_read_more_icon',array(
		'default'	=> 'fas fa-arrow-right',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Recycling_Energy_Fontawesome_Icon_Chooser(
        $wp_customize,'recycling_energy_read_more_icon',array(
		'label'	=> __('Read More Icon','recycling-energy'),
		'transport' => 'refresh',
		'section'	=> 'recycling_energy_archieve_post_layot',
		'setting'	=> 'recycling_energy_read_more_icon',
		'type'		=> 'icon'
	)));
	$wp_customize->add_setting('recycling_energy_date',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'recycling_energy_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(new Recycling_Energy_Customizer_Customcontrol_Switch(
			$wp_customize,
			'recycling_energy_date',
			array(
				'settings'        => 'recycling_energy_date',
				'section'         => 'recycling_energy_archieve_post_layot',
				'label'           => __( 'Show Date', 'recycling-energy' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'recycling-energy' ),
					'off'    => __( 'Off', 'recycling-energy' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->selective_refresh->add_partial( 'recycling_energy_date', array(
		'selector' => '.date-box',
		'render_callback' => 'recycling_energy_customize_partial_recycling_energy_date',
	) );
	$wp_customize->add_setting('recycling_energy_date_icon',array(
		'default'	=> 'far fa-calendar-alt',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Recycling_Energy_Fontawesome_Icon_Chooser(
        $wp_customize,'recycling_energy_date_icon',array(
		'label'	=> __('date Icon','recycling-energy'),
		'transport' => 'refresh',
		'section'	=> 'recycling_energy_archieve_post_layot',
		'setting'	=> 'recycling_energy_date_icon',
		'type'		=> 'icon'
	)));
	$wp_customize->add_setting('recycling_energy_admin',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'recycling_energy_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(new Recycling_Energy_Customizer_Customcontrol_Switch(
			$wp_customize,
			'recycling_energy_admin',
			array(
				'settings'        => 'recycling_energy_admin',
				'section'         => 'recycling_energy_archieve_post_layot',
				'label'           => __( 'Show Author/Admin', 'recycling-energy' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'recycling-energy' ),
					'off'    => __( 'Off', 'recycling-energy' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->selective_refresh->add_partial( 'recycling_energy_admin', array(
		'selector' => '.entry-author',
		'render_callback' => 'recycling_energy_customize_partial_recycling_energy_admin',
	) );
	$wp_customize->add_setting('recycling_energy_author_icon',array(
		'default'	=> 'fas fa-user',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Recycling_Energy_Fontawesome_Icon_Chooser(
        $wp_customize,'recycling_energy_author_icon',array(
		'label'	=> __('Author Icon','recycling-energy'),
		'transport' => 'refresh',
		'section'	=> 'recycling_energy_archieve_post_layot',
		'setting'	=> 'recycling_energy_author_icon',
		'type'		=> 'icon'
	)));
	$wp_customize->add_setting('recycling_energy_comment',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'recycling_energy_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(new Recycling_Energy_Customizer_Customcontrol_Switch(
			$wp_customize,
			'recycling_energy_comment',
			array(
				'settings'        => 'recycling_energy_comment',
				'section'         => 'recycling_energy_archieve_post_layot',
				'label'           => __( 'Show Comment', 'recycling-energy' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'recycling-energy' ),
					'off'    => __( 'Off', 'recycling-energy' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->selective_refresh->add_partial( 'recycling_energy_comment', array(
		'selector' => '.entry-comments',
		'render_callback' => 'recycling_energy_customize_partial_recycling_energy_comment',
	) );
	$wp_customize->add_setting('recycling_energy_comment_icon',array(
		'default'	=> 'fas fa-comments',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Recycling_Energy_Fontawesome_Icon_Chooser(
        $wp_customize,'recycling_energy_comment_icon',array(
		'label'	=> __('comment Icon','recycling-energy'),
		'transport' => 'refresh',
		'section'	=> 'recycling_energy_archieve_post_layot',
		'setting'	=> 'recycling_energy_comment_icon',
		'type'		=> 'icon'
	)));
	$wp_customize->add_setting('recycling_energy_tag',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'recycling_energy_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(new Recycling_Energy_Customizer_Customcontrol_Switch(
			$wp_customize,
			'recycling_energy_tag',
			array(
				'settings'        => 'recycling_energy_tag',
				'section'         => 'recycling_energy_archieve_post_layot',
				'label'           => __( 'Show tag count', 'recycling-energy' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'recycling-energy' ),
					'off'    => __( 'Off', 'recycling-energy' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->selective_refresh->add_partial( 'recycling_energy_tag', array(
		'selector' => '.tags',
		'render_callback' => 'recycling_energy_customize_partial_recycling_energy_tag',
	) );
	$wp_customize->add_setting('recycling_energy_tag_icon',array(
		'default'	=> 'fas fa-tags',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Recycling_Energy_Fontawesome_Icon_Chooser(
        $wp_customize,'recycling_energy_tag_icon',array(
		'label'	=> __('tag Icon','recycling-energy'),
		'transport' => 'refresh',
		'section'	=> 'recycling_energy_archieve_post_layot',
		'setting'	=> 'recycling_energy_tag_icon',
		'type'		=> 'icon'
	)));

	// breadcrumb
	$wp_customize->add_section('recycling_energy_breadcrumb_settings',array(
        'title' => __('Breadcrumb Settings', 'recycling-energy'),
        'priority' => 4
    ) );
	$wp_customize->add_setting( 'recycling_energy_section_breadcrumb_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Recycling_Energy_Customizer_Customcontrol_Section_Heading( $wp_customize, 'recycling_energy_section_breadcrumb_heading', array(
		'label'       => esc_html__( 'Theme Breadcrumb Settings', 'recycling-energy' ),
		'section'     => 'recycling_energy_breadcrumb_settings',
		'settings'    => 'recycling_energy_section_breadcrumb_heading',
	) ) );
	$wp_customize->add_setting(
		'recycling_energy_enable_breadcrumb',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'recycling_energy_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Recycling_Energy_Customizer_Customcontrol_Switch(
			$wp_customize,
			'recycling_energy_enable_breadcrumb',
			array(
				'settings'        => 'recycling_energy_enable_breadcrumb',
				'section'         => 'recycling_energy_breadcrumb_settings',
				'label'           => __( 'Show Breadcrumb', 'recycling-energy' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'recycling-energy' ),
					'off'    => __( 'Off', 'recycling-energy' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->add_setting('recycling_energy_breadcrumb_separator', array(
        'default' => ' / ',
        'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control('recycling_energy_breadcrumb_separator', array(
        'label' => __('Breadcrumb Separator', 'recycling-energy'),
        'section' => 'recycling_energy_breadcrumb_settings',
        'type' => 'text',
    ));
	$wp_customize->add_setting( 'recycling_energy_single_breadcrumb_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Recycling_Energy_Customizer_Customcontrol_Section_Heading( $wp_customize, 'recycling_energy_single_breadcrumb_heading', array(
		'label'       => esc_html__( 'Single post & Page', 'recycling-energy' ),
		'section'     => 'recycling_energy_breadcrumb_settings',
		'settings'    => 'recycling_energy_single_breadcrumb_heading',
	) ) );
	$wp_customize->add_setting(
		'recycling_energy_single_enable_breadcrumb',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'recycling_energy_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Recycling_Energy_Customizer_Customcontrol_Switch(
			$wp_customize,
			'recycling_energy_single_enable_breadcrumb',
			array(
				'settings'        => 'recycling_energy_single_enable_breadcrumb',
				'section'         => 'recycling_energy_breadcrumb_settings',
				'label'           => __( 'Show Breadcrumb', 'recycling-energy' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'recycling-energy' ),
					'off'    => __( 'Off', 'recycling-energy' ),
				),
				'active_callback' => '',
			)
		)
	);
	if ( class_exists( 'WooCommerce' ) ) { 
		$wp_customize->add_setting( 'recycling_energy_woocommerce_breadcrumb_heading', array(
			'default'           => '',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( new Recycling_Energy_Customizer_Customcontrol_Section_Heading( $wp_customize, 'recycling_energy_woocommerce_breadcrumb_heading', array(
			'label'       => esc_html__( 'Woocommerce Breadcrumb', 'recycling-energy' ),
			'section'     => 'recycling_energy_breadcrumb_settings',
			'settings'    => 'recycling_energy_woocommerce_breadcrumb_heading',
		) ) );
		$wp_customize->add_setting(
			'recycling_energy_woocommerce_enable_breadcrumb',
			array(
				'type'                 => 'option',
				'capability'           => 'edit_theme_options',
				'theme_supports'       => '',
				'default'              => '1',
				'transport'            => 'refresh',
				'sanitize_callback'    => 'recycling_energy_callback_sanitize_switch',
			)
		);
		$wp_customize->add_control(
			new Recycling_Energy_Customizer_Customcontrol_Switch(
				$wp_customize,
				'recycling_energy_woocommerce_enable_breadcrumb',
				array(
					'settings'        => 'recycling_energy_woocommerce_enable_breadcrumb',
					'section'         => 'recycling_energy_breadcrumb_settings',
					'label'           => __( 'Show Breadcrumb', 'recycling-energy' ),				
					'choices'		  => array(
						'1'      => __( 'On', 'recycling-energy' ),
						'off'    => __( 'Off', 'recycling-energy' ),
					),
					'active_callback' => '',
				)
			)
		);
		$wp_customize->add_setting('woocommerce_breadcrumb_separator', array(
	        'default' => ' / ',
	        'sanitize_callback' => 'sanitize_text_field',
	    ));
	    $wp_customize->add_control('woocommerce_breadcrumb_separator', array(
	        'label' => __('Breadcrumb Separator', 'recycling-energy'),
	        'section' => 'recycling_energy_breadcrumb_settings',
	        'type' => 'text',
	    ));
	}

	//woocommerce
	if ( class_exists( 'WooCommerce' ) ) { 
	    $wp_customize->add_section('recycling_energy_woocommerce_settings',array(
	        'title' => __('WooCommerce Settings', 'recycling-energy'),
	        'priority' => 4,
	    ) );
		$wp_customize->add_setting( 'recycling_energy_section_shoppage_heading', array(
			'default'           => '',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( new Recycling_Energy_Customizer_Customcontrol_Section_Heading( $wp_customize, 'recycling_energy_section_shoppage_heading', array(
			'label'       => esc_html__( 'Sidebar Settings', 'recycling-energy' ),
			'section'     => 'recycling_energy_woocommerce_settings',
			'settings'    => 'recycling_energy_section_shoppage_heading',
		) ) );
		$wp_customize->add_setting( 'recycling_energy_shop_page_sidebar',
			array(
				'default' => 'right_sidebar',
				'transport' => 'refresh',
				'sanitize_callback' => 'sanitize_text_field'
			)
		);
		$wp_customize->add_control( new Recycling_Energy_Radio_Image_Control( $wp_customize, 'recycling_energy_shop_page_sidebar',
			array(
				'type'=>'select',
				'label' => __( 'Show Shop Page Sidebar', 'recycling-energy' ),
				'section'     => 'recycling_energy_woocommerce_settings',
				'choices' => array(

					'right_sidebar' => array(
						'image' => get_template_directory_uri().'/assets/images/2column.jpg',
						'name' => __( 'Right Sidebar', 'recycling-energy' )
					),
					'left_sidebar' => array(
						'image' => get_template_directory_uri().'/assets/images/left.png',
						'name' => __( 'Left Sidebar', 'recycling-energy' )
					),
					'full_width' => array(
						'image' => get_template_directory_uri().'/assets/images/1column.jpg',
						'name' => __( 'Full Width', 'recycling-energy' )
					),
				)
			)
		) );
		$wp_customize->add_setting( 'recycling_energy_wocommerce_single_page_sidebar',
			array(
				'default' => 'right_sidebar',
				'transport' => 'refresh',
				'sanitize_callback' => 'sanitize_text_field'
			)
		);
		$wp_customize->add_control( new Recycling_Energy_Radio_Image_Control( $wp_customize, 'recycling_energy_wocommerce_single_page_sidebar',
			array(
				'type'=>'select',
				'label'           => __( 'Show Single Product Page Sidebar', 'recycling-energy' ),
				'section'     => 'recycling_energy_woocommerce_settings',
				'choices' => array(

					'right_sidebar' => array(
						'image' => get_template_directory_uri().'/assets/images/2column.jpg',
						'name' => __( 'Right Sidebar', 'recycling-energy' )
					),
					'left_sidebar' => array(
						'image' => get_template_directory_uri().'/assets/images/left.png',
						'name' => __( 'Left Sidebar', 'recycling-energy' )
					),
					'full_width' => array(
						'image' => get_template_directory_uri().'/assets/images/1column.jpg',
						'name' => __( 'Full Width', 'recycling-energy' )
					),
				)
			)
		) );
		$wp_customize->add_setting( 'recycling_energy_section_archieve_product_heading', array(
			'default'           => '',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( new Recycling_Energy_Customizer_Customcontrol_Section_Heading( $wp_customize, 'recycling_energy_section_archieve_product_heading', array(
			'label'       => esc_html__( 'Archieve Product Settings', 'recycling-energy' ),
			'section'     => 'recycling_energy_woocommerce_settings',
			'settings'    => 'recycling_energy_section_archieve_product_heading',
		) ) );
		$wp_customize->add_setting('recycling_energy_archieve_item_columns',array(
	        'default' => '3',
	        'sanitize_callback' => 'recycling_energy_sanitize_choices'
		));
		$wp_customize->add_control('recycling_energy_archieve_item_columns',array(
	        'type' => 'select',
	        'label' => __('Select No of Columns','recycling-energy'),
	        'section' => 'recycling_energy_woocommerce_settings',
	        'choices' => array(
	            '1' => __('One Column','recycling-energy'),
	            '2' => __('Two Column','recycling-energy'),
	            '3' => __('Three Column','recycling-energy'),
	            '4' => __('four Column','recycling-energy'),
	            '5' => __('Five Column','recycling-energy'),
	            '6' => __('Six Column','recycling-energy'),
	        ),
		) );
		$wp_customize->add_setting( 'recycling_energy_archieve_shop_perpage', array(
			'default'              => 6,
			'type'                 => 'theme_mod',
			'transport' 		   => 'refresh',
			'sanitize_callback'    => 'recycling_energy_sanitize_number_absint',
			'sanitize_js_callback' => 'absint',
		) );
		$wp_customize->add_control( 'recycling_energy_archieve_shop_perpage', array(
			'label'       => esc_html__( 'Display Products','recycling-energy' ),
			'section'     => 'recycling_energy_woocommerce_settings',
			'type'        => 'number',
			'input_attrs' => array(
				'step'             => 1,
				'min'              => 0,
				'max'              => 30,
			),
		) );
		$wp_customize->add_setting( 'recycling_energy_section_related_heading', array(
			'default'           => '',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( new Recycling_Energy_Customizer_Customcontrol_Section_Heading( $wp_customize, 'recycling_energy_section_related_heading', array(
			'label'       => esc_html__( 'Related Product Settings', 'recycling-energy' ),
			'section'     => 'recycling_energy_woocommerce_settings',
			'settings'    => 'recycling_energy_section_related_heading',
		) ) );
		$wp_customize->add_setting('woocommerce_related_products_heading', array(
	        'default' => 'Related products',
	        'sanitize_callback' => 'sanitize_text_field',
	    ));
	    $wp_customize->add_control('woocommerce_related_products_heading', array(
	        'label' => __('Related Products Heading', 'recycling-energy'),
	        'section' => 'recycling_energy_woocommerce_settings',
	        'type' => 'text',
	    ));
		$wp_customize->add_setting('recycling_energy_related_item_columns',array(
	        'default' => '3',
	        'sanitize_callback' => 'recycling_energy_sanitize_choices'
		));
		$wp_customize->add_control('recycling_energy_related_item_columns',array(
	        'type' => 'select',
	        'label' => __('Select No of Columns','recycling-energy'),
	        'section' => 'recycling_energy_woocommerce_settings',
	        'choices' => array(
	            '1' => __('One Column','recycling-energy'),
	            '2' => __('Two Column','recycling-energy'),
	            '3' => __('Three Column','recycling-energy'),
	            '4' => __('four Column','recycling-energy'),
	            '5' => __('Five Column','recycling-energy'),
	            '6' => __('Six Column','recycling-energy'),
	        ),
		) );
		$wp_customize->add_setting( 'recycling_energy_related_shop_perpage', array(
			'default'              => 3,
			'type'                 => 'theme_mod',
			'transport' 		   => 'refresh',
			'sanitize_callback'    => 'recycling_energy_sanitize_number_absint',
			'sanitize_js_callback' => 'absint',
		) );
		$wp_customize->add_control( 'recycling_energy_related_shop_perpage', array(
			'label'       => esc_html__( 'Display Products','recycling-energy' ),
			'section'     => 'recycling_energy_woocommerce_settings',
			'type'        => 'number',
			'input_attrs' => array(
				'step'             => 1,
				'min'              => 0,
				'max'              => 10,
			),
		) );
		$wp_customize->add_setting(
			'recycling_energy_related_product',
			array(
				'type'                 => 'option',
				'capability'           => 'edit_theme_options',
				'theme_supports'       => '',
				'default'              => '1',
				'transport'            => 'refresh',
				'sanitize_callback'    => 'recycling_energy_callback_sanitize_switch',
			)
		);
		$wp_customize->add_control(new Recycling_Energy_Customizer_Customcontrol_Switch($wp_customize,'recycling_energy_related_product',
			array(
				'settings'        => 'recycling_energy_related_product',
				'section'         => 'recycling_energy_woocommerce_settings',
				'label'           => __( 'Show Related Products', 'recycling-energy' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'recycling-energy' ),
					'off'    => __( 'Off', 'recycling-energy' ),
				),
				'active_callback' => '',
			)
		));
	}

	// mobile width
	$wp_customize->add_section('recycling_energy_mobile_options',array(
        'title' => __('Mobile Media settings', 'recycling-energy'),
        'priority' => 4,
    ) );
    $wp_customize->add_setting( 'recycling_energy_section_mobile_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Recycling_Energy_Customizer_Customcontrol_Section_Heading( $wp_customize, 'recycling_energy_section_mobile_heading', array(
		'label'       => esc_html__( 'Mobile Media settings', 'recycling-energy' ),
		'section'     => 'recycling_energy_mobile_options',
		'settings'    => 'recycling_energy_section_mobile_heading',
	) ) );
	$wp_customize->add_setting(
		'recycling_energy_slider_button_mobile_show_hide',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'recycling_energy_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Recycling_Energy_Customizer_Customcontrol_Switch(
			$wp_customize,
			'recycling_energy_slider_button_mobile_show_hide',
			array(
				'settings'        => 'recycling_energy_slider_button_mobile_show_hide',
				'section'         => 'recycling_energy_mobile_options',
				'label'           => __( 'Show Slider Button', 'recycling-energy' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'recycling-energy' ),
					'off'    => __( 'Off', 'recycling-energy' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->add_setting(
		'recycling_energy_scroll_enable_mobile',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'recycling_energy_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Recycling_Energy_Customizer_Customcontrol_Switch(
			$wp_customize,
			'recycling_energy_scroll_enable_mobile',
			array(
				'settings'        => 'recycling_energy_scroll_enable_mobile',
				'section'         => 'recycling_energy_mobile_options',
				'label'           => __( 'Show Scroll Top', 'recycling-energy' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'recycling-energy' ),
					'off'    => __( 'Off', 'recycling-energy' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->add_setting( 'recycling_energy_section_mobile_breadcrumb_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Recycling_Energy_Customizer_Customcontrol_Section_Heading( $wp_customize, 'recycling_energy_section_mobile_breadcrumb_heading', array(
		'label'       => esc_html__( 'Mobile Breadcrumb settings', 'recycling-energy' ),
		'section'     => 'recycling_energy_mobile_options',
		'settings'    => 'recycling_energy_section_mobile_breadcrumb_heading',
	) ) );
	$wp_customize->add_setting(
		'recycling_energy_enable_breadcrumb_mobile',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'recycling_energy_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Recycling_Energy_Customizer_Customcontrol_Switch(
			$wp_customize,
			'recycling_energy_enable_breadcrumb_mobile',
			array(
				'settings'        => 'recycling_energy_enable_breadcrumb_mobile',
				'section'         => 'recycling_energy_mobile_options',
				'label'           => __( 'Theme Breadcrumb', 'recycling-energy' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'recycling-energy' ),
					'off'    => __( 'Off', 'recycling-energy' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->add_setting(
		'recycling_energy_single_enable_breadcrumb_mobile',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'recycling_energy_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Recycling_Energy_Customizer_Customcontrol_Switch(
			$wp_customize,
			'recycling_energy_single_enable_breadcrumb_mobile',
			array(
				'settings'        => 'recycling_energy_single_enable_breadcrumb_mobile',
				'section'         => 'recycling_energy_mobile_options',
				'label'           => __( 'Single Post & Page', 'recycling-energy' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'recycling-energy' ),
					'off'    => __( 'Off', 'recycling-energy' ),
				),
				'active_callback' => '',
			)
		)
	);
	if ( class_exists( 'WooCommerce' ) ) {
		$wp_customize->add_setting(
			'recycling_energy_woocommerce_enable_breadcrumb_mobile',
			array(
				'type'                 => 'option',
				'capability'           => 'edit_theme_options',
				'theme_supports'       => '',
				'default'              => '1',
				'transport'            => 'refresh',
				'sanitize_callback'    => 'recycling_energy_callback_sanitize_switch',
			)
		);
		$wp_customize->add_control(
			new Recycling_Energy_Customizer_Customcontrol_Switch(
				$wp_customize,
				'recycling_energy_woocommerce_enable_breadcrumb_mobile',
				array(
					'settings'        => 'recycling_energy_woocommerce_enable_breadcrumb_mobile',
					'section'         => 'recycling_energy_mobile_options',
					'label'           => __( 'wooCommerce Breadcrumb', 'recycling-energy' ),				
					'choices'		  => array(
						'1'      => __( 'On', 'recycling-energy' ),
						'off'    => __( 'Off', 'recycling-energy' ),
					),
					'active_callback' => '',
				)
			)
		);
	}

	$wp_customize->get_setting( 'blogname' )->transport          = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport   = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport  = 'postMessage';

	$wp_customize->selective_refresh->add_partial( 'blogname', array(
		'selector' => '.site-title a',
		'render_callback' => 'recycling_energy_customize_partial_blogname',
	) );
	$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
		'selector' => '.site-description',
		'render_callback' => 'recycling_energy_customize_partial_blogdescription',
	) );

	//front page
	$num_sections = apply_filters( 'recycling_energy_front_page_sections', 4 );

	// Create a setting and control for each of the sections available in the theme.
	for ( $i = 1; $i < ( 1 + $num_sections ); $i++ ) {
		$wp_customize->add_setting( 'panel_' . $i, array(
			'default'           => false,
			'sanitize_callback' => 'recycling_energy_sanitize_dropdown_pages',
			'transport'         => 'postMessage',
		) );

		$wp_customize->add_control( 'panel_' . $i, array(
			/* translators: %d is the front page section number */
			'label'          => sprintf( __( 'Front Page Section %d Content', 'recycling-energy' ), $i ),
			'description'    => ( 1 !== $i ? '' : __( 'Select pages to feature in each area from the dropdowns. Add an image to a section by setting a featured image in the page editor. Empty sections will not be displayed.', 'recycling-energy' ) ),
			'section'        => 'theme_options',
			'type'           => 'dropdown-pages',
			'allow_addition' => true,
			'active_callback' => 'recycling_energy_is_static_front_page',
		) );

		$wp_customize->selective_refresh->add_partial( 'panel_' . $i, array(
			'selector'            => '#panel' . $i,
			'render_callback'     => 'recycling_energy_front_page_section',
			'container_inclusive' => true,
		) );
	}
}
add_action( 'customize_register', 'recycling_energy_customize_register' );

function recycling_energy_customize_partial_blogname() {
	bloginfo( 'name' );
}
function recycling_energy_customize_partial_blogdescription() {
	bloginfo( 'description' );
}
function recycling_energy_is_static_front_page() {
	return ( is_front_page() && ! is_home() );
}
function recycling_energy_is_view_with_layout_option() {
	return ( is_page() || ( is_archive() && ! is_active_sidebar( 'sidebar-1' ) ) );
}

define('RECYCLING_ENERGY_PRO_LINK',__('https://www.ovationthemes.com/wordpress/recycling-energy-wordpress-theme/','recycling-energy'));

/* Pro control */
if (class_exists('WP_Customize_Control') && !class_exists('Recycling_Energy_Pro_Control')):
    class Recycling_Energy_Pro_Control extends WP_Customize_Control{

    public function render_content(){?>
        <label style="overflow: hidden; zoom: 1;">
	        <div class="col-md upsell-btn">
                <a href="<?php echo esc_url( RECYCLING_ENERGY_PRO_LINK ); ?>" target="blank" class="btn btn-success btn"><?php esc_html_e('UPGRADE RECYCLING ENERGY PREMIUM','recycling-energy');?> </a>
	        </div>
            <div class="col-md">
                <img class="recycling_energy_img_responsive " src="<?php echo esc_url(get_template_directory_uri()); ?>/screenshot.png">
            </div>
	        <div class="col-md">
	            <h3 style="margin-top:10px; margin-left: 20px; text-decoration:underline; color:#333;"><?php esc_html_e('Recycling Energy PREMIUM - Features', 'recycling-energy'); ?></h3>
                <ul style="padding-top:10px">
                    <li class="upsell-recycling_energy"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Responsive Design', 'recycling-energy');?> </li>
                    <li class="upsell-recycling_energy"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Boxed or fullwidth layout', 'recycling-energy');?> </li>
                    <li class="upsell-recycling_energy"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Shortcode Support', 'recycling-energy');?> </li>
                    <li class="upsell-recycling_energy"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Demo Importer', 'recycling-energy');?> </li>
                    <li class="upsell-recycling_energy"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Section Reordering', 'recycling-energy');?> </li>
                    <li class="upsell-recycling_energy"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Contact Page Template', 'recycling-energy');?> </li>
                    <li class="upsell-recycling_energy"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Multiple Blog Layouts', 'recycling-energy');?> </li>
                    <li class="upsell-recycling_energy"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Unlimited Color Options', 'recycling-energy');?> </li>
                    <li class="upsell-recycling_energy"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Designed with HTML5 and CSS3', 'recycling-energy');?> </li>
                    <li class="upsell-recycling_energy"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Customizable Design & Code', 'recycling-energy');?> </li>
                    <li class="upsell-recycling_energy"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Cross Browser Support', 'recycling-energy');?> </li>
                    <li class="upsell-recycling_energy"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Detailed Documentation Included', 'recycling-energy');?> </li>
                    <li class="upsell-recycling_energy"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Stylish Custom Widgets', 'recycling-energy');?> </li>
                    <li class="upsell-recycling_energy"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Patterns Background', 'recycling-energy');?> </li>
                    <li class="upsell-recycling_energy"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('WPML Compatible (Translation Ready)', 'recycling-energy');?> </li>
                    <li class="upsell-recycling_energy"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Woo-commerce Compatible', 'recycling-energy');?> </li>
                    <li class="upsell-recycling_energy"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Full Support', 'recycling-energy');?> </li>
                    <li class="upsell-recycling_energy"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('10+ Sections', 'recycling-energy');?> </li>
                    <li class="upsell-recycling_energy"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Live Customizer', 'recycling-energy');?> </li>
                   	<li class="upsell-recycling_energy"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('AMP Ready', 'recycling-energy');?> </li>
                   	<li class="upsell-recycling_energy"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Clean Code', 'recycling-energy');?> </li>
                   	<li class="upsell-recycling_energy"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('SEO Friendly', 'recycling-energy');?> </li>
                   	<li class="upsell-recycling_energy"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Supper Fast', 'recycling-energy');?> </li>
                </ul>
        	</div>
		    <div class="col-md upsell-btn upsell-btn-bottom">
	            <a href="<?php echo esc_url( RECYCLING_ENERGY_PRO_LINK ); ?>" target="blank" class="btn btn-success btn"><?php esc_html_e('UPGRADE RECYCLING ENERGY PREMIUM','recycling-energy');?> </a>
		    </div>
        </label>
    <?php } }
endif;

function recycling_energy_custom_number() {
    add_meta_box( 'bn_meta', __( 'Our Mission Section', 'recycling-energy' ), 'recycling_energy_add_meta_number', 'post', 'normal', 'high' );
}

if (is_admin()){
  add_action('admin_menu', 'recycling_energy_custom_number');
}

function recycling_energy_add_meta_number( $post ) {
    wp_nonce_field( basename( __FILE__ ), 'recycling_energy_number_mission_meta' );
    $bn_stored_meta = get_post_meta( $post->ID );
    $mission_meta = get_post_meta( $post->ID, 'recycling_energy_mission_number', true );
    ?>
    <table id="list">
        <tbody id="the-list" data-wp-lists="list:meta">
            <tr id="meta-8">
                <td class="left">
                    <?php esc_html_e( 'Mission Percentage Field', 'recycling-energy' )?>
                </td>
                <td class="left">
                    <input type="text" name="recycling_energy_mission_number" id="recycling_energy_mission_number" value="<?php echo esc_html($mission_meta); ?>" />
                </td>
            </tr>
        </tbody>
    </table>
    <?php
}

function recycling_energy_number_save( $post_id ) {
    if (!isset($_POST['recycling_energy_number_mission_meta']) || !wp_verify_nonce( strip_tags( wp_unslash( $_POST['recycling_energy_number_mission_meta']) ), basename(__FILE__))) {
        return;
    }

    if (!current_user_can('edit_post', $post_id)) {
        return;
    }

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }

    if( isset( $_POST[ 'recycling_energy_mission_number' ] ) ) {
        update_post_meta( $post_id, 'recycling_energy_mission_number', strip_tags( wp_unslash( $_POST[ 'recycling_energy_mission_number' ]) ) );
    }
}
add_action( 'save_post', 'recycling_energy_number_save' );
