<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\TransfertDossier;
use App\Models\Dossier;
use App\Models\Fichier;
use App\Models\JuridictionParque;
use App\Notifications\DossierAjouterNotification;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\Notification;
use Illuminate\Support\Facades\Auth;

class TransfertDossierController extends Controller
{

    public function __construct()
    {
        $this->middleware('permission:View transfert', ['only' => ['index']]);
        $this->middleware('permission:Create transfert', ['only' => ['create', 'store']]);
        $this->middleware('permission:Update transfert', ['only' => ['edit', 'update']]);
        $this->middleware('permission:Delete transfert', ['only' => ['destroy']]);
    }

    public function index()

{
    $user = Auth::user();

    $gref = Auth::user();
    $juridiction = $gref->juridiction_parquet_id;

    $transferts = TransfertDossier::join('dossiers', 'transfert_dossiers.dossier_id', '=', 'dossiers.id')
    ->join('type_dossiers', 'dossiers.type_dossier_id', '=', 'type_dossiers.id')
    ->join('juridiction_parques', 'transfert_dossiers.jur_parquet_id', '=', 'juridiction_parques.id')
    ->select('transfert_dossiers.id', 'dossiers.numero', 'type_dossiers.nom as type', 'juridiction_parques.nom', 'juridiction_parques.commune', 'transfert_dossiers.dateT')
    ->where('juridiction_parquet_id', $juridiction)
    ->orderBy('transfert_dossiers.id', 'desc')
    ->get();

    $transfertDo = TransfertDossier::join('dossiers', 'transfert_dossiers.dossier_id', '=', 'dossiers.id')
    ->join('type_dossiers', 'dossiers.type_dossier_id', '=', 'type_dossiers.id')
    ->join('juridiction_parques', 'transfert_dossiers.juridiction_parquet_id', '=', 'juridiction_parques.id')
    ->select('transfert_dossiers.id', 'dossiers.numero', 'type_dossiers.nom as type', 'juridiction_parques.nom', 'juridiction_parques.commune', 'transfert_dossiers.dateT')
    ->whereHas('dossier.user', function($query) use ($user){
        $query->where('juridiction_parquet_id', $user->juridiction_parquet_id);
    })
    ->orderBy('transfert_dossiers.id', 'desc')
    ->get();

    return view('transferts.index', compact('transferts', 'transfertDo'));
}

/**
 * Show the form for creating a new resource.
 *
 * @return \Illuminate\Http\Response
 */
public function create($dossier_id)
{
    $juridictions = JuridictionParque::where('nom', '=', 'Grande Instance')->get();
    $dossier = Dossier::findOrFail($dossier_id);
    
    return view('transferts.create', compact('juridictions','dossier'));
}

public function store(Request $request)
{
   
    $admin = Auth::user();

        $transfert = new TransfertDossier();
        $transfert->dateT = $request->dateT;
        $transfert->dossier_id = $request->dossier_id;
        $transfert->jur_parquet_id = $admin->juridiction_parquet_id;
        $transfert->juridiction_parquet_id = $request->juridiction_parquet_id;
        $transfert->save();

        $role = Role::where('name', 'Président')->first();

        $users = $role->users()
            ->where('juridiction_parquet_id', $request->juridiction_parquet_id)
            ->get();

    
        Notification::send($users, new DossierAjouterNotification($request->dossier_id));

    return redirect()->route('transferts.index')->with('success', "Vous avez transfert un dossier");
}

public function edit(TransfertDossier $transfert)
{
    $jurdictions = Juridiction::All();

    
    return view('transferts.edit', compact('niveaux','etatDossiers','typedossiers','dossier'));
}

public function update(Request $request,TransfertDossier $transfert)
{
    $data = $request->validate([
        'dateT' => 'required',
        'dossier_id' => 'required|exists:dossiers,id',
        'juridiction_parquet_id' => 'required|exists:juridiction_parques,id',
    ]);


    $dossier->update([
        'dateT' => $data['dateT'],
        'dossier_id' => $data['dossier_id'],
        'juridiction_parquet_id' => $data['juridiction_parquet_id'],
    ]);

    return redirect()->route('transferts.index')->with('success', "Vous avez modifier le transfert");
}

public function destroy(TransfertDossier $transfert)
{
    $transfert->delete();

    return redirect()->route('transferts.index')->with('success', 'Vous avez supprimé le transfert');
}

public function show(Request $request, $transId)
{
    $request->id;
    $transfert2 = TransfertDossier::find($transId);
    $transfert = Dossier::find($transfert2->dossier_id);
    $fichiers = Dossier::find($transfert2->dossier_id)->fichiers()->get();
    // dd($fichiers);    

    return view('transferts.show', compact('transfert', 'fichiers'));
}


}
