<?php

namespace App\Http\Controllers; 
use Illuminate\Http\Request;
use App\Models\Dossier;
use App\Models\TypeCategorieDossier;
use App\Models\Niveau;
use App\Models\Juridiction;
use App\Models\EtatDossier;
use App\Models\TypeDossier;
use App\Models\Repartir;
use App\Models\User;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\Auth;
use App\Notifications\AffecterNotification;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Notification;
use Illuminate\Database\Eloquent\Builder;

class RepartirController extends Controller
{

    public function __construct()
    {
        $this->middleware('permission:View repartir', ['only' => ['index']]);
        $this->middleware('permission:Create repartir', ['only' => ['create', 'store']]);
        $this->middleware('permission:Update repartir', ['only' => ['edit', 'update']]);
        $this->middleware('permission:Delete repartir', ['only' => ['destroy']]);
    }
    

public function index(Request $request)

{
    $search = $request->input('search');

    $repartirs = Repartir::query()
    ->join('users', 'repartirs.user_id', '=', 'users.id')
    ->join('dossiers', 'repartirs.dossier_id', '=', 'dossiers.id')
    ->select('users.name as name', 'users.lastname as lastname', 'dossiers.numero as numero', 'repartirs.id as id', 'repartirs.role as role')
    ->when($search, function (Builder $builder) use ($search) {
            $builder->where('repartirs.role', 'like', "%{$search}%");
                // ->orWhere('email', 'like', "%{$request->search}%");
        }
    )
    ->paginate(7);

    return view('repartir.index', compact('repartirs'));
}


public function create($dossier_id)
{

    $dossier = Dossier::findOrFail($dossier_id);

    $user = User::find($dossier->user_id);
    
    // dd($user);
    $gref = Auth::user();
    $juridiction = $gref->juridiction_parquet_id;

    $role = Role::where('name', 'OMP')
     ->first();

     $omps = $role->users()
        ->where('juridiction_parquet_id', $juridiction)
        ->get();
    

    
    return view('repartir.create', compact('omps','dossier'));
}

public function store(Request $request)
{
    $data = $request->validate([
        'role' => 'required',
        'user_id' => 'required|exists:users,id',
        'dossier_id' => 'required|exists:dossiers,id',
    ]);

    Repartir::create($data);

    $role = Role::where('name', 'OMP')->first();

    $users = $role->users()
        ->where('id', $request->user_id)
        ->get();

    
        Notification::send($users, new AffecterNotification($request->dossier_id));
   

    return redirect()->route('repartirs.index')->with('success', "Vous avez réparti le dossier sur un OMP");
}

public function edit(Repartir $repartir)
{
    $gref = Auth::user();
    $juridiction = $gref->juridiction_parquet_id;

    $role = Role::where('name', 'OMP')
     ->first();

     $omps = $role->users()
        ->where('juridiction_parquet_id', $juridiction)
        ->get();
    

    
    return view('repartir.edit', compact('omps','affecter'));
}

public function update(Request $request,Repartir $repartir)
{
    $data = $request->validate([
        'role' => 'required',
        'user_id' => 'required|exists:users,id',
    ]);


    $repartir->update([
        'role' => $data['role'],
        'user_id' => $data['user_id'],
    ]);

    return redirect()->route('repartirs.index')->with('success', "Vous avez modifié la répartition");
}

public function destroy(Repartir $repartir)
{
    $repartir->delete();

    return redirect()->route('repartirs.index')->with('success', 'Vous avez supprimé la répartition');
}

public function show(Dossier $dossier)
{
    $fichiers = $dossier->fichiers()->get();

    return view('dossiers.show', compact('dossier', 'fichiers'));
}

}
