<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Spatie\Permission\Models\Permission;

class PermissionController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:View permission', ['only' => ['index']]);
        $this->middleware('permission:Create permission', ['only' => ['create', 'store']]);
        $this->middleware('permission:Update permission', ['only' => ['edit', 'update']]);
        $this->middleware('permission:Delete permission', ['only' => ['destroy']]);
    }
    
    public function index()
    {
        $permissions = Permission::paginate(4);
        return view('role-permission.permission.index', compact('permissions'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('role-permission.permission.create');
    }

    
    public function store(Request $request)
    {
        $request->validate([
            'name' => [
                'required',
                'string',
                'unique:permissions,name'
            ]
            ]);

            Permission::create([
                'name' => $request->name
            ]);

            return redirect('permissions')->with('status', "Permission Successfully Created");
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

   
    public function edit(Permission $permission)
    {
        return view('role-permission.permission.edit', compact('permission'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Permission $permission)
    {
        $request->validate([
            'name' => [
                'required',
                'string',
                'unique:permissions,name,'.$permission->id
            ]
            ]);

            $permission->update([
                'name' => $request->name
            ]);

            return redirect('permissions')->with('status', "Permission Successfully Updated");
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($permissionId)
    {
        $permission = Permission::find($permissionId);
        $permission->delete();

        return redirect('permissions')->with('status', "Permission Successfully Deleted");
    }
}
