<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Fichier;
use App\Models\TypeFichier;
use App\Models\Dossier;
use App\Notifications\AjouterRembousement;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Notification;
use App\Models\User;

class FichiersController extends Controller
{
    // public function index()
    // {
    //     $fichiers = Fichier::all();

    //     return view('fichiers.index', compact('fichiers'));
    // }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    
     public function __construct()
    {
        $this->middleware('permission:View fichier', ['only' => ['index']]);
        $this->middleware('permission:Create fichier', ['only' => ['create', 'store']]);
        $this->middleware('permission:Update fichier', ['only' => ['edit', 'update']]);
        $this->middleware('permission:Delete fichier', ['only' => ['destroy']]);
    }

    public function create($dossier_id)
    {
        $typefichiers = TypeFichier::All();
        $dossier = Dossier::findOrFail($dossier_id);

        
        return view('fichiers.create', compact('dossier','typefichiers'));
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'lien' => 'required',
            'type_fichier_id' => 'required|exists:type_fichiers,id',
            'dossier_id' => 'required|exists:dossiers,id',
        ]);

        Fichier::create($data);

        

        // $userGref = User::with('role')->whereHas('role', function($query) {
        //     $query->where('nom', 'Greffier');
        // })->first();
        
        // Notification::send($userGref, new AjouterRembousement($request->nom));

        return redirect()->back()->with('success', "Vous avez ajouté un fichier dans le dossier");
    }

    public function edit(Fichier $fichier)
    {
        $typefichiers = TypeFichier::All();

        
        return view('fichiers.edit', compact('typefichiers','fichier'));
    }

    public function update(Request $request,Fichier $fichier)
    {
        $data = $request->validate([
            'lien' => 'required',
            'type_fichier_id' => 'required|exists:type_fichiers,id',
        ]);


        $fichier->update([
            'lien' => $data['lien'],
            'type_fichier_id' => $data['type_fichier_id'],
        ]);

        return redirect()->back()->with('success', "Vous avez modifié un fichier du dossier");
    }

    public function destroy(Fichier $fichier)
    {
        $fichier->delete();

        return redirect()->route('fichiers.index')->with('success', 'Vous avez supprimé un fichier du dossier');
    }
}
