<x-app-layout>
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Les institution (bailleurs)</h1>
          </div>
          <div class="col-sm-6">
            <div class="breadcrumb float-sm-right">
            @can('Créer institution')
              <a href="{{route('institutions.create')}}" class="btn btn-warning">Ajouter institution</a>
            @endcan
            </div>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->

    @if ($errors->has('delete_error'))
    <div class="alert alert-danger">
    <i class="ri-alert-fill"></i> {{ $errors->first('delete_error') }}
    </div>
    @endif
    @if(session('success'))
        <div class="alert alert-success">
          <i class="ri-alert-fill"></i> {{ session('success') }}
        </div>
    @endif

    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            <div class="card">
            <div class="card-header">
                <h3 class="card-title">Les institution (bailleurs)</h3>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>ID</th>
                    <th>Nom</th>
                    <th>Email</th>
                    <th>Actions</th>
                  </tr>
                  </thead>
                  <tbody>
                  @foreach($institutions as $institution)
                  <tr>
                    <td>{{$institution->id}}</td>
                    <td>{{$institution->nom}}</td>
                    <td>{{$institution->email}}</td>
                    <td>
                    @can('Modifier institution')
                      <a href="{{ route('institutions.edit', $institution->id) }}" class="btn btn-success"><i class="nav-icon far fa-edit" title="Modifier"></i></a>
                    @endcan
                    @can('Supprimer institution')
                      <a href="{{url('institutions/'.$institution->id.'/delete')}}" onclick="return confirm('Vous voulez supprimer ça?')" class="btn btn-danger"><i class="nav-icon fa fa-trash" title="Supprimer"></i></a>
                    @endcan
                    </td>
                    
                  </tr>
                  @endforeach
                  </tbody>
                  <tfoot>
                  <tr>
                    <th>ID</th>
                    <th>Nom</th>
                    <th>Email</th>
                    <th>Actions</th>
                  </tr>
                  </tfoot>
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>
</x-app-layout>