<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Jugement extends Model
{
    use HasFactory;
    protected $fillable = [
        'date',
        'description',
        'dossier_id',
        'juridiction_id',
    ];

    public function dossier()
    {
        return $this->belongsTo(Dossier::class);
    }

    public function juridiction()
    {
        return $this->belongsTo(Juridiction::class);
    }
}
