<?php

namespace App\Http\Controllers;
use App\Models\TypeCategorieDossier;
use App\Models\TypeDossier;
use Illuminate\Http\Request;
use Illuminate\Database\Eloquent\Builder;

class TypeDossierController extends Controller
{

    public function __construct()
    {
        $this->middleware('permission:View type dossier', ['only' => ['index']]);
        $this->middleware('permission:Create type dossier', ['only' => ['create', 'store']]);
        $this->middleware('permission:Update type dossier', ['only' => ['edit', 'update']]);
        $this->middleware('permission:Delete type dossier', ['only' => ['destroy']]);
    }

    public function index(Request $request)
    {
        $typedossiers = TypeDossier::join('type_categorie_dossiers', 'type_dossiers.categorie_id', '=', 'type_categorie_dossiers.id')
        ->select('type_dossiers.id', 'type_dossiers.nom', 'type_categorie_dossiers.nom_categorie')
        ->when(
            $request->search,
            function (Builder $builder) use ($request) {
                $builder->where('nom', 'like', "%{$request->search}%");
            }
        )
        ->paginate(7);
    
        return view('typeDossiers.index', compact('typedossiers'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $typecategories = TypeCategorieDossier::All();

        return view('typeDossiers.create', compact('typecategories'));
    }

    
    public function store(Request $request)
    {
        $data = $request->validate([
            'nom' => 'required',
            'categorie_id' => 'required|exists:type_categorie_dossiers,id',
            
        ]);

        TypeDossier::create($data);


        return redirect()->route('typeDossiers.index')->with('success', "Vous avez crée un type du dossier");
    }

    public function edit(TypeDossier $typeDossier)
    {
        $categories = TypeCategorieDossier::All();

        return view('typeDossiers.edit', compact('typeDossier','categories'));
    }

    public function update(Request $request,TypeDossier $typeDossier)
    {
        $data = $request->validate([
            'nom' => 'required',
            'categorie_id' => 'required|exists:type_categorie_dossiers,id',
            
        ]);


        $typeDossier->update([
            'nom' => $data['nom'],
            'categorie_id' => $data['categorie_id'],
           
        ]);

        return redirect()->route('typeDossiers.index')->with('success', "Vous avez modifié un type du dossier");
    }

    public function destroy(TypeDossier $typeDossier)
    {
        $typeDossier->delete();

        return redirect()->route('typeDossiers.index')->with('success', 'Vous avez supprimé un type du dossier');
    }
}
