<x-app-layout>
<main id="main" class="main">



<div class="pagetitle">
<h1 class="card-title">Audiences</h1>  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="#">Table de bord</a></li>
      <li class="breadcrumb-item">Tables</li>
      <li class="breadcrumb-item active">General</li>
    </ol>
  </nav>
</div>

<section class="section">
@if ($errors->has('delete_error'))
    <div class="alert alert-danger">
    <i class="ri-alert-fill"></i> {{ $errors->first('delete_error') }}
    </div>
@endif
@if(session('success'))
    <div class="alert alert-success">
      <i class="ri-alert-fill"></i> {{ session('success') }}
    </div>
@endif
  
  <div class="row">
  <div class="col-lg-4">
    <form method="GET" action="{{ route('audiences.index') }}">
    <div class="form-group d-flex">
        <input type="search" name="search" class="form-control" placeholder="recherche ...">
        <button type="submit" class="badge bg-primary p-2 ms-2" title="Recherche"><i class="bi bi-search"></i></button>&nbsp;&nbsp;
        <a href="{{ route('audiences.index') }}" class="btn btn-success" title="Actualiser"><i class="bi bi-arrow-repeat"></i></a>
    </div>
    </form>
    </div>

    <div class="col-auto text-end float-end ms-auto download-grp">
        @can('Create audience')
        <a href="{{route('audiences.create')}}" class="btn btn-primary"><i class="bi bi-plus"></i> Nouveau Audience</a>
        @endcan
    </div>
    
  </div><br>
  
  <div class="row">
    <div class="col-lg-12">

      

      <div class="card">
        <div class="page-header">
            <div class="row align-items-center">
                <div class="col">
                    <center><h1 class="card-title">Liste des audiences</h1></center>
                </div>
            </div>
        </div>

          <!-- Table with hoverable rows -->
          <table class="table table-hover">
          @if(auth()->check() && auth()->user()->hasRole('Président') || auth()->user()->hasRole('Greffier') || auth()->user()->hasRole('Greffier Caissier') || auth()->user()->hasRole('Admin'))
            <thead>
              <tr>
                <th scope="col">#</th>
                <th scope="col">Description</th>
                <th scope="col">Dossier</th>
                <th scope="col">Date</th>
                <th colspan="2">Actions</th>
              </tr>
            </thead>
            <tbody id="myTable">
            @foreach($audiences as $audience)
              <tr>
                <td>{{$audience->id}}</td>
                <td scope="row">{{$audience->description}}</td>
                <th scope="row">{{$audience->type}} {{$audience->numero}}</th>
                <td scope="row">{{$audience->date}}</td>
                <td>
                  @can('Update audience')
                  <a href="{{ route('audiences.edit', $audience->id) }}" class="badge bg-warning"><i class="bi bi-pencil-square"></i></a>
                  @endcan
              </td>
                          <td>
                          @can('Delete audience')
                          <form action="{{route('audiences.destroy', $audience->id)}}" method="POST">
                            @csrf
                            @method('DELETE')
                          <button type="submit" onclick="return confirm('Vous voulez supprimer ça?')" class="badge bg-danger"><i class="bi bi-trash-fill"></i></button>
                          </form>
                          @endcan
                </td>
              </tr>
            @endforeach
            </tbody>
            @endif

            @if(auth()->check() && auth()->user()->hasRole('Procureur'))
            <thead>
              <tr>
                <th scope="col">#</th>
                <th scope="col">Description</th>
                <th scope="col">Dossier</th>
                <th scope="col">Date</th>
                <th scope="col">Juridiction</th>
                <th colspan="2">Actions</th>
              </tr>
            </thead>
            <tbody id="myTable">
            @foreach($audiencesParquet as $audience)
              <tr>
                <td>{{$audience->id}}</td>
                <td scope="row">{{$audience->description}}</td>
                <th scope="row">{{$audience->type}} {{$audience->numero}}</th>
                <td scope="row">{{$audience->date}}</td>
                <td scope="row">{{$audience->nom}} de {{$audience->commune}}</td>
                <td>
                  @can('Update audience')
                  <a href="{{ route('audiences.edit', $audience->id) }}" class="badge bg-warning"><i class="bi bi-pencil-square"></i></a>
                  @endcan
              </td>
                          <td>
                          @can('Delete audience')
                          <form action="{{route('audiences.destroy', $audience->id)}}" method="POST">
                            @csrf
                            @method('DELETE')
                          <button type="submit" onclick="return confirm('Vous voulez supprimer ça?')" class="badge bg-danger"><i class="bi bi-trash-fill"></i></button>
                          </form>
                          @endcan
                </td>
              </tr>
            @endforeach
            </tbody>
            @endif
          </table>
          <!-- End Table with hoverable rows -->

        </div>
      </div>

      

    </div>
  </div>
</section>

</main>
</x-app-layout>
