-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Hôte : 127.0.0.1
-- Généré le : lun. 11 mars 2024 à 12:29
-- Version du serveur : 10.4.28-MariaDB
-- Version de PHP : 8.0.28

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Base de données : `jurdique`
--

-- --------------------------------------------------------

--
-- Structure de la table `audiences`
--

CREATE TABLE `audiences` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `date` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `juridiction_id` bigint(20) UNSIGNED NOT NULL,
  `dossier_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `dossiers`
--

CREATE TABLE `dossiers` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `numero` varchar(255) NOT NULL,
  `niveau_id` bigint(20) UNSIGNED NOT NULL,
  `etat_id` bigint(20) UNSIGNED NOT NULL,
  `type_dossier_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Déchargement des données de la table `dossiers`
--

INSERT INTO `dossiers` (`id`, `numero`, `niveau_id`, `etat_id`, `type_dossier_id`, `created_at`, `updated_at`) VALUES
(3, '12321', 1, 1, 1, '2024-03-10 13:16:07', '2024-03-10 13:16:07'),
(5, '55455', 1, 5, 3, '2024-03-10 18:37:12', '2024-03-10 18:37:12'),
(7, '323321', 1, 4, 1, '2024-03-10 19:15:54', '2024-03-10 19:15:54'),
(11, '1118765', 1, 3, 3, '2024-03-10 19:49:02', '2024-03-10 19:49:02'),
(12, '666534', 2, 5, 1, '2024-03-11 09:07:17', '2024-03-11 09:07:17');

-- --------------------------------------------------------

--
-- Structure de la table `etat_dossiers`
--

CREATE TABLE `etat_dossiers` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `nom` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Déchargement des données de la table `etat_dossiers`
--

INSERT INTO `etat_dossiers` (`id`, `nom`, `created_at`, `updated_at`) VALUES
(1, 'Dossiers en cours', NULL, '2024-03-10 17:17:55'),
(3, 'Dossiers jugés', '2024-03-10 16:58:42', '2024-03-10 16:58:42'),
(4, 'Dossiers en appel', '2024-03-10 16:59:31', '2024-03-10 16:59:31'),
(5, 'Dossiers exécutés', '2024-03-10 16:59:49', '2024-03-10 16:59:49');

-- --------------------------------------------------------

--
-- Structure de la table `failed_jobs`
--

CREATE TABLE `failed_jobs` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `uuid` varchar(255) NOT NULL,
  `connection` text NOT NULL,
  `queue` text NOT NULL,
  `payload` longtext NOT NULL,
  `exception` longtext NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `fichiers`
--

CREATE TABLE `fichiers` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `nom` varchar(255) NOT NULL,
  `lien` varchar(255) NOT NULL,
  `type_fichier_id` bigint(20) UNSIGNED NOT NULL,
  `dossier_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Déchargement des données de la table `fichiers`
--

INSERT INTO `fichiers` (`id`, `nom`, `lien`, `type_fichier_id`, `dossier_id`, `created_at`, `updated_at`) VALUES
(13, 'Convocation', 'french 2.pdf', 1, 3, '2024-03-10 13:17:05', '2024-03-10 13:17:05'),
(14, 'gsf', 'french 2.pdf', 1, 12, '2024-03-11 09:07:56', '2024-03-11 09:07:56');

-- --------------------------------------------------------

--
-- Structure de la table `jugements`
--

CREATE TABLE `jugements` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `date` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `juridiction_id` bigint(20) UNSIGNED NOT NULL,
  `dossier_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `juges`
--

CREATE TABLE `juges` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `role` varchar(255) NOT NULL,
  `user_id` bigint(20) UNSIGNED NOT NULL,
  `dossier_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Déchargement des données de la table `juges`
--

INSERT INTO `juges` (`id`, `role`, `user_id`, `dossier_id`, `created_at`, `updated_at`) VALUES
(4, 'Membre', 2, 11, '2024-03-11 08:46:50', '2024-03-11 08:46:50');

-- --------------------------------------------------------

--
-- Structure de la table `juridictions`
--

CREATE TABLE `juridictions` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `nom` varchar(255) NOT NULL,
  `numero` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Déchargement des données de la table `juridictions`
--

INSERT INTO `juridictions` (`id`, `nom`, `numero`, `created_at`, `updated_at`) VALUES
(1, 'jurdique', '123', NULL, NULL),
(2, 'Parque', '45', '2024-03-08 20:06:11', '2024-03-08 20:06:11');

-- --------------------------------------------------------

--
-- Structure de la table `migrations`
--

CREATE TABLE `migrations` (
  `id` int(10) UNSIGNED NOT NULL,
  `migration` varchar(255) NOT NULL,
  `batch` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Déchargement des données de la table `migrations`
--

INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
(1, '2014_10_12_000000_create_users_table', 1),
(2, '2014_10_12_100000_create_password_resets_table', 1),
(3, '2019_08_19_000000_create_failed_jobs_table', 1),
(4, '2019_12_14_000001_create_personal_access_tokens_table', 1),
(5, '2024_03_08_101455_create_roles_table', 1),
(6, '2024_03_08_102234_create_juridictions_table', 1),
(7, '2024_03_08_102235_create_utilisateurs_table', 1),
(8, '2024_03_08_102244_create_type_fichiers_table', 1),
(9, '2024_03_08_102301_create_type_categorie_dossiers_table', 1),
(10, '2024_03_08_102310_create_type_dossiers_table', 1),
(11, '2024_03_08_102318_create_niveau_table', 1),
(12, '2024_03_08_102328_create_etat_dossiers_table', 1),
(13, '2024_03_08_102337_create_dossiers_table', 1),
(14, '2024_03_08_102338_create_juges_table', 1),
(15, '2024_03_08_102346_create_audiences_table', 1),
(16, '2024_03_08_102355_create_jugements_table', 1),
(17, '2024_03_08_110011_create_fichiers_table', 1),
(18, '2024_03_10_142554_create_transfert_dossiers_table', 2),
(19, '2024_03_10_201602_create_notifications_table', 3);

-- --------------------------------------------------------

--
-- Structure de la table `niveaux`
--

CREATE TABLE `niveaux` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `nom` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Déchargement des données de la table `niveaux`
--

INSERT INTO `niveaux` (`id`, `nom`, `created_at`, `updated_at`) VALUES
(1, 'Traitement', NULL, NULL),
(2, 'Clôture', '2024-03-08 15:41:50', '2024-03-08 15:41:50');

-- --------------------------------------------------------

--
-- Structure de la table `notifications`
--

CREATE TABLE `notifications` (
  `id` char(36) NOT NULL,
  `type` varchar(255) NOT NULL,
  `notifiable_type` varchar(255) NOT NULL,
  `notifiable_id` bigint(20) UNSIGNED NOT NULL,
  `data` text NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Déchargement des données de la table `notifications`
--

INSERT INTO `notifications` (`id`, `type`, `notifiable_type`, `notifiable_id`, `data`, `read_at`, `created_at`, `updated_at`) VALUES
('239f458b-134b-44c1-b6a7-f43b8e81bf53', 'App\\Notifications\\DossierAjouterNotification', 'App\\Models\\User', 2, '{\"message\":\"Un nouveau Dossier a \\u00e9t\\u00e9 enregistr\\u00e9.\"}', NULL, '2024-03-11 09:07:17', '2024-03-11 09:07:17'),
('559f2367-214a-4c97-b70e-b542818d03fc', 'App\\Notifications\\DossierAjouterNotification', 'App\\Models\\User', 2, '{\"message\":\"Un nouveau Dossier a \\u00e9t\\u00e9 enregistr\\u00e9.\"}', NULL, '2024-03-10 19:49:02', '2024-03-10 19:49:02');

-- --------------------------------------------------------

--
-- Structure de la table `password_resets`
--

CREATE TABLE `password_resets` (
  `email` varchar(255) NOT NULL,
  `token` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `personal_access_tokens`
--

CREATE TABLE `personal_access_tokens` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `tokenable_type` varchar(255) NOT NULL,
  `tokenable_id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(255) NOT NULL,
  `token` varchar(64) NOT NULL,
  `abilities` text DEFAULT NULL,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `roles`
--

CREATE TABLE `roles` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `nom` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Déchargement des données de la table `roles`
--

INSERT INTO `roles` (`id`, `nom`, `created_at`, `updated_at`) VALUES
(1, 'Greffier', NULL, NULL),
(2, 'Président', NULL, NULL),
(3, 'Admin', NULL, NULL),
(4, 'Juge', NULL, NULL),
(5, 'Greffier Caissier', NULL, NULL);

-- --------------------------------------------------------

--
-- Structure de la table `transfert_dossiers`
--

CREATE TABLE `transfert_dossiers` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `dossier_id` bigint(20) UNSIGNED NOT NULL,
  `juridiction_id` bigint(20) UNSIGNED NOT NULL,
  `dateT` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Déchargement des données de la table `transfert_dossiers`
--

INSERT INTO `transfert_dossiers` (`id`, `dossier_id`, `juridiction_id`, `dateT`, `created_at`, `updated_at`) VALUES
(1, 3, 1, '2024-03-17', '2024-03-10 13:20:08', '2024-03-10 13:20:08'),
(2, 7, 2, '2024-03-21', '2024-03-11 08:44:00', '2024-03-11 08:44:00'),
(3, 12, 1, '2024-03-23', '2024-03-11 09:11:01', '2024-03-11 09:11:01');

-- --------------------------------------------------------

--
-- Structure de la table `type_categorie_dossiers`
--

CREATE TABLE `type_categorie_dossiers` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `nom_categorie` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Déchargement des données de la table `type_categorie_dossiers`
--

INSERT INTO `type_categorie_dossiers` (`id`, `nom_categorie`, `created_at`, `updated_at`) VALUES
(1, 'Penal', NULL, NULL),
(3, 'Civil', '2024-03-10 16:11:38', '2024-03-10 16:11:38'),
(4, 'VBG', '2024-03-10 16:12:37', '2024-03-10 16:12:37'),
(5, 'Mineur en conflit avec la loi', '2024-03-10 16:13:30', '2024-03-10 16:13:30');

-- --------------------------------------------------------

--
-- Structure de la table `type_dossiers`
--

CREATE TABLE `type_dossiers` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `nom` varchar(255) NOT NULL,
  `categorie_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Déchargement des données de la table `type_dossiers`
--

INSERT INTO `type_dossiers` (`id`, `nom`, `categorie_id`, `created_at`, `updated_at`) VALUES
(1, 'RPA', 1, NULL, '2024-03-10 16:54:55'),
(3, 'RCA', 3, '2024-03-10 16:55:23', '2024-03-10 16:55:34');

-- --------------------------------------------------------

--
-- Structure de la table `type_fichiers`
--

CREATE TABLE `type_fichiers` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `type` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Déchargement des données de la table `type_fichiers`
--

INSERT INTO `type_fichiers` (`id`, `type`, `created_at`, `updated_at`) VALUES
(1, 'aaa', NULL, NULL),
(2, 'bbb', '2024-03-08 17:35:10', '2024-03-08 17:35:10');

-- --------------------------------------------------------

--
-- Structure de la table `users`
--

CREATE TABLE `users` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `matricule` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `lastname` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) NOT NULL,
  `contact` varchar(255) NOT NULL,
  `role_id` bigint(20) UNSIGNED NOT NULL,
  `juridiction_id` bigint(20) UNSIGNED NOT NULL,
  `remember_token` varchar(100) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Déchargement des données de la table `users`
--

INSERT INTO `users` (`id`, `matricule`, `name`, `lastname`, `email`, `email_verified_at`, `password`, `contact`, `role_id`, `juridiction_id`, `remember_token`, `created_at`, `updated_at`) VALUES
(1, '0012', 'NKURUNZIZA', 'Vincent', 'vincent@gmail.com', NULL, '$2y$10$iKRMD6GWkLfloLOZq2x7N.KsU33ajV/shxvmfBSgO0vChJPf60S2y', '79764234', 1, 1, NULL, NULL, NULL),
(2, '54312', 'KANYANGE', 'Benigne', 'benigne@gmail.com', NULL, '$2y$10$iKRMD6GWkLfloLOZq2x7N.KsU33ajV/shxvmfBSgO0vChJPf60S2y', '68976543', 4, 1, NULL, NULL, NULL),
(3, '4366', 'NIYONGABO', 'Blaise Pascal', 'blaisepas@gmail.com', NULL, '$2y$10$iKRMD6GWkLfloLOZq2x7N.KsU33ajV/shxvmfBSgO0vChJPf60S2y', '67543213', 4, 1, NULL, NULL, NULL),
(4, '987765', 'IGIRANEZA', 'Amandine', 'amanda@gmail.com', NULL, '$2y$10$iKRMD6GWkLfloLOZq2x7N.KsU33ajV/shxvmfBSgO0vChJPf60S2y', '79675234', 3, 1, NULL, NULL, NULL),
(5, '432', 'MANISHAKA', 'Diomède', 'manidios@gmail.com', NULL, '$2y$10$iKRMD6GWkLfloLOZq2x7N.KsU33ajV/shxvmfBSgO0vChJPf60S2y', '4353332', 2, 1, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Structure de la table `utilisateurs`
--

CREATE TABLE `utilisateurs` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `matricule` varchar(255) NOT NULL,
  `nom` varchar(255) NOT NULL,
  `prenom` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `contact` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `role_id` bigint(20) UNSIGNED NOT NULL,
  `juridiction_id` bigint(20) UNSIGNED NOT NULL,
  `remember_token` varchar(100) DEFAULT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Index pour les tables déchargées
--

--
-- Index pour la table `audiences`
--
ALTER TABLE `audiences`
  ADD PRIMARY KEY (`id`),
  ADD KEY `audiences_juridiction_id_foreign` (`juridiction_id`),
  ADD KEY `audiences_dossier_id_foreign` (`dossier_id`);

--
-- Index pour la table `dossiers`
--
ALTER TABLE `dossiers`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `dossiers_numero_unique` (`numero`),
  ADD KEY `dossiers_niveau_id_foreign` (`niveau_id`),
  ADD KEY `dossiers_etat_id_foreign` (`etat_id`),
  ADD KEY `dossiers_type_dossier_id_foreign` (`type_dossier_id`);

--
-- Index pour la table `etat_dossiers`
--
ALTER TABLE `etat_dossiers`
  ADD PRIMARY KEY (`id`);

--
-- Index pour la table `failed_jobs`
--
ALTER TABLE `failed_jobs`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`);

--
-- Index pour la table `fichiers`
--
ALTER TABLE `fichiers`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fichiers_type_fichier_id_foreign` (`type_fichier_id`),
  ADD KEY `fichiers_dossier_id_foreign` (`dossier_id`);

--
-- Index pour la table `jugements`
--
ALTER TABLE `jugements`
  ADD PRIMARY KEY (`id`),
  ADD KEY `jugements_juridiction_id_foreign` (`juridiction_id`),
  ADD KEY `jugements_dossier_id_foreign` (`dossier_id`);

--
-- Index pour la table `juges`
--
ALTER TABLE `juges`
  ADD PRIMARY KEY (`id`),
  ADD KEY `juges_dossier_id_foreign` (`dossier_id`),
  ADD KEY `juges_utilisateur_id_foreign` (`user_id`);

--
-- Index pour la table `juridictions`
--
ALTER TABLE `juridictions`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `juridictions_numero_unique` (`numero`);

--
-- Index pour la table `migrations`
--
ALTER TABLE `migrations`
  ADD PRIMARY KEY (`id`);

--
-- Index pour la table `niveaux`
--
ALTER TABLE `niveaux`
  ADD PRIMARY KEY (`id`);

--
-- Index pour la table `notifications`
--
ALTER TABLE `notifications`
  ADD PRIMARY KEY (`id`),
  ADD KEY `notifications_notifiable_type_notifiable_id_index` (`notifiable_type`,`notifiable_id`);

--
-- Index pour la table `password_resets`
--
ALTER TABLE `password_resets`
  ADD PRIMARY KEY (`email`);

--
-- Index pour la table `personal_access_tokens`
--
ALTER TABLE `personal_access_tokens`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  ADD KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`);

--
-- Index pour la table `roles`
--
ALTER TABLE `roles`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `roles_nom_unique` (`nom`);

--
-- Index pour la table `transfert_dossiers`
--
ALTER TABLE `transfert_dossiers`
  ADD PRIMARY KEY (`id`),
  ADD KEY `transfert_dossiers_dossier_id_foreign` (`dossier_id`),
  ADD KEY `transfert_dossiers_juridiction_id_foreign` (`juridiction_id`);

--
-- Index pour la table `type_categorie_dossiers`
--
ALTER TABLE `type_categorie_dossiers`
  ADD PRIMARY KEY (`id`);

--
-- Index pour la table `type_dossiers`
--
ALTER TABLE `type_dossiers`
  ADD PRIMARY KEY (`id`),
  ADD KEY `type_dossiers_categorie_id_foreign` (`categorie_id`);

--
-- Index pour la table `type_fichiers`
--
ALTER TABLE `type_fichiers`
  ADD PRIMARY KEY (`id`);

--
-- Index pour la table `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `users_email_unique` (`email`),
  ADD UNIQUE KEY `matricule` (`matricule`),
  ADD KEY `role_id` (`role_id`,`juridiction_id`),
  ADD KEY `juridiction_id` (`juridiction_id`);

--
-- Index pour la table `utilisateurs`
--
ALTER TABLE `utilisateurs`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `utilisateurs_matricule_unique` (`matricule`),
  ADD UNIQUE KEY `utilisateurs_email_unique` (`email`),
  ADD KEY `utilisateurs_role_id_foreign` (`role_id`),
  ADD KEY `utilisateurs_juridiction_id_foreign` (`juridiction_id`);

--
-- AUTO_INCREMENT pour les tables déchargées
--

--
-- AUTO_INCREMENT pour la table `audiences`
--
ALTER TABLE `audiences`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT pour la table `dossiers`
--
ALTER TABLE `dossiers`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=13;

--
-- AUTO_INCREMENT pour la table `etat_dossiers`
--
ALTER TABLE `etat_dossiers`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT pour la table `failed_jobs`
--
ALTER TABLE `failed_jobs`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `fichiers`
--
ALTER TABLE `fichiers`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=15;

--
-- AUTO_INCREMENT pour la table `jugements`
--
ALTER TABLE `jugements`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT pour la table `juges`
--
ALTER TABLE `juges`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT pour la table `juridictions`
--
ALTER TABLE `juridictions`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT pour la table `migrations`
--
ALTER TABLE `migrations`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=20;

--
-- AUTO_INCREMENT pour la table `niveaux`
--
ALTER TABLE `niveaux`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT pour la table `personal_access_tokens`
--
ALTER TABLE `personal_access_tokens`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `roles`
--
ALTER TABLE `roles`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT pour la table `transfert_dossiers`
--
ALTER TABLE `transfert_dossiers`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT pour la table `type_categorie_dossiers`
--
ALTER TABLE `type_categorie_dossiers`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT pour la table `type_dossiers`
--
ALTER TABLE `type_dossiers`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT pour la table `type_fichiers`
--
ALTER TABLE `type_fichiers`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT pour la table `users`
--
ALTER TABLE `users`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT pour la table `utilisateurs`
--
ALTER TABLE `utilisateurs`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- Contraintes pour les tables déchargées
--

--
-- Contraintes pour la table `audiences`
--
ALTER TABLE `audiences`
  ADD CONSTRAINT `audiences_dossier_id_foreign` FOREIGN KEY (`dossier_id`) REFERENCES `dossiers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `audiences_juridiction_id_foreign` FOREIGN KEY (`juridiction_id`) REFERENCES `juridictions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Contraintes pour la table `dossiers`
--
ALTER TABLE `dossiers`
  ADD CONSTRAINT `dossiers_etat_id_foreign` FOREIGN KEY (`etat_id`) REFERENCES `etat_dossiers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `dossiers_niveau_id_foreign` FOREIGN KEY (`niveau_id`) REFERENCES `niveaux` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `dossiers_type_dossier_id_foreign` FOREIGN KEY (`type_dossier_id`) REFERENCES `type_dossiers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Contraintes pour la table `fichiers`
--
ALTER TABLE `fichiers`
  ADD CONSTRAINT `fichiers_dossier_id_foreign` FOREIGN KEY (`dossier_id`) REFERENCES `dossiers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fichiers_type_fichier_id_foreign` FOREIGN KEY (`type_fichier_id`) REFERENCES `type_fichiers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Contraintes pour la table `jugements`
--
ALTER TABLE `jugements`
  ADD CONSTRAINT `jugements_dossier_id_foreign` FOREIGN KEY (`dossier_id`) REFERENCES `dossiers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `jugements_juridiction_id_foreign` FOREIGN KEY (`juridiction_id`) REFERENCES `juridictions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Contraintes pour la table `juges`
--
ALTER TABLE `juges`
  ADD CONSTRAINT `juges_dossier_id_foreign` FOREIGN KEY (`dossier_id`) REFERENCES `dossiers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `juges_utilisateur_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Contraintes pour la table `transfert_dossiers`
--
ALTER TABLE `transfert_dossiers`
  ADD CONSTRAINT `transfert_dossiers_dossier_id_foreign` FOREIGN KEY (`dossier_id`) REFERENCES `dossiers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `transfert_dossiers_juridiction_id_foreign` FOREIGN KEY (`juridiction_id`) REFERENCES `juridictions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Contraintes pour la table `type_dossiers`
--
ALTER TABLE `type_dossiers`
  ADD CONSTRAINT `type_dossiers_categorie_id_foreign` FOREIGN KEY (`categorie_id`) REFERENCES `type_categorie_dossiers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Contraintes pour la table `users`
--
ALTER TABLE `users`
  ADD CONSTRAINT `users_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`),
  ADD CONSTRAINT `users_ibfk_2` FOREIGN KEY (`juridiction_id`) REFERENCES `juridictions` (`id`);

--
-- Contraintes pour la table `utilisateurs`
--
ALTER TABLE `utilisateurs`
  ADD CONSTRAINT `utilisateurs_juridiction_id_foreign` FOREIGN KEY (`juridiction_id`) REFERENCES `juridictions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `utilisateurs_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
