<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\CategorieController;
use App\Http\Controllers\SecteurController;
use App\Http\Controllers\TypeEmployeController;
use App\Http\Controllers\EmployeController;
use App\Http\Controllers\RegionController;
use App\Http\Controllers\CommuneController;
use App\Http\Controllers\CollineController;
use App\Http\Controllers\BeneficiaireController;
use App\Http\Controllers\InstitutionController;
use App\Http\Controllers\UserController;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\PermissionController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\DashboardController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('Auth/login');
});

Route::controller(DashboardController::class)->prefix('dashboard')->group(function() {
    Route::get('', 'index')->middleware('auth')->name('dashboard');
    
});

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

Route::post('getCommunes',[CommuneController::class,'getCommunes'])->name('getCommunes');
Route::post('getCollines',[CollineController::class,'getCollines'])->name('getCollines');

Route::resource('categories',CategorieController::class)->names([
    'index' => 'categories.index',
    'create' => 'categories.create',
    'store' => 'categories.store',
    'edit' => 'categories.edit',
    'update' => 'categories.update',
]);
Route::get('categories/{categorieId}/delete', [CategorieController::class, 'destroy']);

Route::resource('secteurs',SecteurController::class)->names([
    'index' => 'secteurs.index',
    'create' => 'secteurs.create',
    'store' => 'secteurs.store',
    'show' => 'secteurs.show',
    'edit' => 'secteurs.edit',
    'update' => 'secteurs.update',
]);
Route::get('secteurs/{secteurId}/delete', [SecteurController::class, 'destroy']);

Route::resource('typeemployes',TypeEmployeController::class)->names([
    'index' => 'typeemployes.index',
    'create' => 'typeemployes.create',
    'store' => 'typeemployes.store',
    'show' => 'typeemployes.show',
    'edit' => 'typeemployes.edit',
    'update' => 'typeemployes.update',
]);
Route::get('typeemployes/{typeemployeId}/delete', [TypeEmployeController::class, 'destroy']);

Route::resource('regions',RegionController::class)->names([
    'index' => 'regions.index',
    'create' => 'regions.create',
    'store' => 'regions.store',
    'show' => 'regions.show',
    'edit' => 'regions.edit',
    'update' => 'regions.update',
]);
Route::get('regions/{regionId}/delete', [RegionController::class, 'destroy']);

Route::resource('communes',CommuneController::class)->names([
    'index' => 'communes.index',
    'create' => 'communes.create',
    'store' => 'communes.store',
    'show' => 'communes.show',
    'edit' => 'communes.edit',
    'update' => 'communes.update',
]);
Route::get('communes/{communeId}/delete', [CommuneController::class, 'destroy']);

Route::resource('collines',CollineController::class)->names([
    'index' => 'collines.index',
    'create' => 'collines.create',
    'store' => 'collines.store',
    'show' => 'collines.show',
    'edit' => 'collines.edit',
    'update' => 'collines.update',
]);
Route::get('collines/{collineId}/delete', [CollineController::class, 'destroy']);

Route::resource('beneficiaires',BeneficiaireController::class)->names([
    'index' => 'beneficiaires.index',
    'create' => 'beneficiaires.create',
    'store' => 'beneficiaires.store',
    'show' => 'beneficiaires.show',
    'edit' => 'beneficiaires.edit',
    'update' => 'beneficiaires.update',
]);
Route::get('beneficiaires/{beneficiaireId}/delete', [BeneficiaireController::class, 'destroy']);

Route::resource('institutions',InstitutionController::class)->names([
    'index' => 'institutions.index',
    'create' => 'institutions.create',
    'store' => 'institutions.store',
    'show' => 'institutions.show',
    'edit' => 'institutions.edit',
    'update' => 'institutions.update',
]);
Route::get('institutions/{institutionId}/delete', [InstitutionController::class, 'destroy']);

Route::resource('employes',EmployeController::class)->names([
    'index' => 'employes.index',
    'create' => 'employes.create',
    'store' => 'employes.store',
    'show' => 'employes.show',
    'edit' => 'employes.edit',
    'update' => 'employes.update',
    'destroy' => 'employes.destroy',
]);
Route::get('employes/{employeId}/delete', [EmployeController::class, 'destroy']);

Route::group(['middleware' => ['isAdmin']], function(){
Route::resource('permissions',PermissionController::class);
Route::get('permissions/{permissionId}/delete', [PermissionController::class, 'destroy']);

Route::resource('roles',RoleController::class);
Route::get('roles/{roleId}/delete', [RoleController::class, 'destroy']);
route::get('roles/{roleId}/give-permission', [RoleController::class, 'addPermissionToRole']);
route::put('roles/{roleId}/give-permission', [RoleController::class, 'givePermissionToRole']);

Route::resource('utilisateurs',UserController::class);
Route::get('users/{userId}/delete', [UserController::class, 'destroy']);
});

require __DIR__.'/auth.php';
