<x-app--layout>
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <a href="{{ url('roles') }}" class="btn btn-secondary">Retour</a>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">General Form</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    @if(session('status'))
        <div class="alert alert-success">
          <i class="ri-alert-fill"></i> {{ session('status') }}
        </div>
    @endif

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <!-- left column -->
          <div class="col-md-12">
            <!-- general form elements -->
            
            <div class="card card-dark">
              <div class="card-header">
                <h3 class="card-title">Rôle : {{$role->name}}</h3>
              </div>
                <form action="{{ url('roles/'.$role->id.'/give-permission') }}" method="POST">
                    @csrf
                    @method('PUT')
                    <div class="mb-3">
                        @error('permission')
                        <span class="text-danger">{{ $message }}</span>
                        @enderror
                        <label for="">Permissions</label>
                        <div class="row">
                            @foreach($permissions as $permission)
                            <div class="col-md-3">
                                <label for="">
                                <input type="checkbox" name="permission[]" value="{{ $permission->name }}"
                                {{ in_array($permission->id, $rolePermission) ? 'checked':'' }}
                                >
                                {{ $permission->name }}
                                </label>
                            </div>
                            @endforeach
                        </div>
                    </div>
                    <div class="mb-3">
                        <button type="submit" class="btn btn-warning">Modifier</button>
                    </div>
                </form>
                </div>
            
            </div>
            <!-- /.card -->
          </div>
          <!--/.col (right) -->
        </div>
        <!-- /.row -->
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>

  
</x-app--layout>