<?php

namespace App\Http\Controllers;
use App\Models\Type_employe;

use Illuminate\Http\Request;

class TypeEmployeController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:Voir type', ['only' => ['index']]);
        $this->middleware('permission:Créer type', ['only' => ['create', 'store']]);
        $this->middleware('permission:Modifier type', ['only' => ['edit', 'update']]);
        $this->middleware('permission:Supprimer type', ['only' => ['destroy']]);
    }

    public function index()
    {
        $typeemployes = Type_employe::all();

        return view('typeemployes.index', compact('typeemployes'));
    }

    
    public function create()
    {
        return view('typeemployes.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'type' => 'required',
            
        ]);

        Type_employe::create($data);


        return redirect()->route('typeemployes.index')->with('success', "Vous avez crée la type d'employe");
    }

    public function edit(Type_employe $typeemploye)
    {
       

        return view('typeemployes.edit', compact('typeemploye'));
    }

    public function update(Request $request,Type_employe $typeemploye)
    {
        $data = $request->validate([
            'type' => 'required',
            
        ]);


        $typeemploye->update([
            'type' => $data['type'],
            
        ]);

        return redirect()->route('typeemployes.index')->with('success', "Vous avez modifié la type d'employe");
    }

    public function destroy($typeemployeId)
    {
        $typeemploye = Type_employe::find($typeemployeId);
        $typeemploye->delete();

        return redirect()->route('typeemployes.index')->with('success', 'Vous avez supprimé la type d\'employe');
    }
}
