<?php

namespace App\Http\Controllers; 
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use App\Events\DossierAjouterEvent;
use App\Models\Dossier;
use App\Models\TypeCategorieDossier;
use App\Models\Niveau;
use App\Models\Juridiction;
use App\Models\EtatDossier;
use App\Models\TypeDossier;
use App\Models\Juge;
use App\Models\Repartir;
use App\Models\User;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\Auth;
use App\Notifications\DossierAjouterNotification;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Notification;

class DossierController extends Controller
{
    
    public function __construct()
    {
        $this->middleware('permission:View dossier', ['only' => ['index']]);
        $this->middleware('permission:Create dossier', ['only' => ['create', 'store']]);
        $this->middleware('permission:Update dossier', ['only' => ['edit', 'update']]);
        $this->middleware('permission:Delete dossier', ['only' => ['destroy']]);
    }

public function index(Request $request)

{
    $user = Auth::user();
    $search = $request->input('search');

    $dossiers = Dossier::leftjoin('fichiers', 'fichiers.dossier_id', 'dossiers.id')
    ->join('etat_dossiers', 'dossiers.etat_id', '=', 'etat_dossiers.id')
    ->join('type_dossiers', 'dossiers.type_dossier_id', '=', 'type_dossiers.id')
    ->join('type_categorie_dossiers', 'type_dossiers.categorie_id', '=', 'type_categorie_dossiers.id')
    ->select('dossiers.id', 'dossiers.numero', DB::raw('count(fichiers.id) as count'), 'dossiers.status', 'etat_dossiers.nom as nomEta', 'type_dossiers.nom as type', 'type_categorie_dossiers.nom_categorie as categorie')
    ->groupBy('dossiers.id', 'dossiers.numero', 'dossiers.status', 'etat_dossiers.nom', 'type_dossiers.nom', 'type_categorie_dossiers.nom_categorie')
    ->orderBy('dossiers.id', 'desc')
    
    ->when(
        $request->search, function (Builder $builder) use ($search) {
            $builder->where('numero', 'like', "%{$search}%")
            ->orWhere('etat_dossiers.nom', 'like', "%{$search}%");
            // ->orWhere('type_dossiers.nom', 'like', "%{$request->search}%")
            // ->orWhere('type_categorie_dossiers.nom_categorie', 'like', "%{$request->search}%")
            // ->orWhere('email', 'like', "%{$request->search}%");
        }
        )
        ->whereHas('user', function($query) use ($user){
            $query->where('juridiction_parquet_id', $user->juridiction_parquet_id);
        })
        ->orderBy('dossiers.id', 'desc')
        ->paginate(10);

        $dossiersPre = Dossier::leftjoin('fichiers', 'fichiers.dossier_id', 'dossiers.id')
    ->join('etat_dossiers', 'dossiers.etat_id', '=', 'etat_dossiers.id')
    ->join('type_dossiers', 'dossiers.type_dossier_id', '=', 'type_dossiers.id')
    ->join('type_categorie_dossiers', 'type_dossiers.categorie_id', '=', 'type_categorie_dossiers.id')
    ->select('dossiers.id', 'dossiers.numero', DB::raw('count(fichiers.id) as count'), 'etat_dossiers.nom as nomEta', 'type_dossiers.nom as type', 'type_categorie_dossiers.nom_categorie as categorie')
    ->groupBy('dossiers.id', 'dossiers.numero', 'etat_dossiers.nom', 'type_dossiers.nom', 'type_categorie_dossiers.nom_categorie')
    ->orderBy('dossiers.id', 'desc')
    ->whereHas('user', function($query) use ($user){
        $query->where('juridiction_parquet_id', $user->juridiction_parquet_id);
    })
    ->when(
        $request->search, function (Builder $builder) use ($search) {
            $builder->where('numero', 'like', "%{$search}%")
            ->orWhere('etat_dossiers.nom', 'like', "%{$search}%");
            // ->orWhere('type_dossiers.nom', 'like', "%{$request->search}%")
            // ->orWhere('type_categorie_dossiers.nom_categorie', 'like', "%{$request->search}%")
            // ->orWhere('email', 'like', "%{$request->search}%");
        }
        )
        ->orderBy('dossiers.id', 'desc')
        ->paginate(10);

    $dossiersJuge = Juge::join('dossiers', 'juges.dossier_id', '=', 'dossiers.id')
    ->leftjoin('fichiers', 'fichiers.dossier_id', 'dossiers.id')
    ->join('etat_dossiers', 'dossiers.etat_id', '=', 'etat_dossiers.id')
    ->join('type_dossiers', 'dossiers.type_dossier_id', '=', 'type_dossiers.id')
    ->join('type_categorie_dossiers', 'type_dossiers.categorie_id', '=', 'type_categorie_dossiers.id')
    ->select('dossiers.id', 'dossiers.numero', DB::raw('count(fichiers.id) as count'), 'etat_dossiers.nom as nomEta', 'type_dossiers.nom as type', 'type_categorie_dossiers.nom_categorie as categorie')
    ->groupBy('dossiers.id', 'dossiers.numero', 'etat_dossiers.nom', 'type_dossiers.nom', 'type_categorie_dossiers.nom_categorie')
    ->where('juges.user_id', auth()->id())
    
    ->when(
        $request->search,
        function (Builder $builder) use ($request) {
            $builder->where('numero', 'like', "%{$request->search}%")
            ->orWhere('etat_dossiers.nom', 'like', "%{$request->search}%");
            // ->orWhere('type_dossiers.nom', 'like', "%{$request->search}%")
            // ->orWhere('type_categorie_dossiers.nom_categorie', 'like', "%{$request->search}%")
            // ->orWhere('email', 'like', "%{$request->search}%");
        }
        )
        ->whereHas('user', function($query) use ($user){
            $query->where('juridiction_parquet_id', $user->juridiction_parquet_id);
        })
    ->orderBy('dossiers.id', 'desc')
    ->paginate(7);

    $dossiersOMP = Repartir::join('dossiers', 'repartirs.dossier_id', '=', 'dossiers.id')
    ->leftjoin('fichiers', 'fichiers.dossier_id', 'dossiers.id')
    ->join('etat_dossiers', 'dossiers.etat_id', '=', 'etat_dossiers.id')
    ->join('type_dossiers', 'dossiers.type_dossier_id', '=', 'type_dossiers.id')
    ->join('type_categorie_dossiers', 'type_dossiers.categorie_id', '=', 'type_categorie_dossiers.id')
    ->select('dossiers.id', 'dossiers.numero', DB::raw('count(fichiers.id) as count'), 'etat_dossiers.nom as nomEta', 'type_dossiers.nom as type', 'type_categorie_dossiers.nom_categorie as categorie')
    ->groupBy('dossiers.id', 'dossiers.numero', 'etat_dossiers.nom', 'type_dossiers.nom', 'type_categorie_dossiers.nom_categorie')
    ->where('repartirs.user_id', auth()->id())
    
    ->when(
        $request->search,
        function (Builder $builder) use ($request) {
            $builder->where('numero', 'like', "%{$request->search}%")
            ->orWhere('etat_dossiers.nom', 'like', "%{$request->search}%");
            // ->orWhere('type_dossiers.nom', 'like', "%{$request->search}%")
            // ->orWhere('type_categorie_dossiers.nom_categorie', 'like', "%{$request->search}%")
            // ->orWhere('email', 'like', "%{$request->search}%");
        }
        )
        ->whereHas('user', function($query) use ($user){
            $query->where('juridiction_parquet_id', $user->juridiction_parquet_id);
        })
    ->orderBy('dossiers.id', 'desc')
    ->paginate(7);

    return view('dossiers.index', compact('dossiers','dossiersJuge','dossiersPre','dossiersOMP'));
}

/**
 * Show the form for creating a new resource.
 *
 * @return \Illuminate\Http\Response
 */
public function create()
{
    
    $etatDossiers = EtatDossier::All();
    $typedossiers = TypeDossier::all();
    
    return view('dossiers.create', compact('etatDossiers','typedossiers'));
}

public function store(Request $request)
{
    $user = Auth::user();

    $dossier = new Dossier();
    $dossier->numero = $request->numero;
    $dossier->etat_id = $request->etat_id;
    $dossier->type_dossier_id = $request->type_dossier_id;
    $dossier->user_id = $user->id;
    $dossier->save();
        

    

    return redirect()->route('dossiers.index')->with('success', "Vous avez crée un Dossier");
}

public function valide(Dossier $dossier)
{
    $dossier = Dossier::findOrFail($dossier->id);
    $dossier->status = 1;
    $dossier->save();
    
    $gref = Auth::user();
    $juridiction = $gref->juridiction_parquet_id;

    $role = Role::where('name', 'Président')->first();

    $users = $role->users()
        ->where('juridiction_parquet_id', $juridiction)
        ->get();

    Notification::send($users, new DossierAjouterNotification($dossier->numero));

        

    return redirect()->back()->with('success', "Dossier est validé");
}

public function edit(Dossier $dossier)
{
    
    $etatDossiers = EtatDossier::All();
    $typedossiers = TypeDossier::all();

    
    return view('dossiers.edit', compact('etatDossiers','typedossiers','dossier'));
}

public function update(Request $request,Dossier $dossier)
{
    $data = $request->validate([
        'etat_id' => 'required|exists:etat_dossiers,id',
        'type_dossier_id' => 'required|exists:type_categorie_dossiers,id',
    ]);


    $dossier->update([
        'etat_id' => $data['etat_id'],
        'type_dossier_id' => $data['type_dossier_id'],
    ]);

    return redirect()->route('dossiers.index')->with('success', "Vous avez modifié un Dossier");
}

public function destroy(Dossier $dossier)
{
    $dossier->delete();

    return redirect()->route('dossiers.index')->with('success', 'Vous avez supprimé un Dossier');
}

public function show(Dossier $dossier)
{
    $fichiers = $dossier->fichiers()->get();

    return view('dossiers.show', compact('dossier', 'fichiers'));
}

}
