<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Dossier;
use Illuminate\Support\Facades\Auth;
use Spatie\Permission\Models\Role;

use Illuminate\Support\Facades\DB;

class DashboardController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $gref = Auth::user();
        $juridiction = $gref->juridiction_parquet_id;

        $role = Role::where('name', 'Juge')
        ->first();

        $juges = $role->users()
        ->where('juridiction_parquet_id', $juridiction)
        ->count();

        $roleG = Role::where('name', 'Greffier')
        ->first();

        $greffiers = $roleG->users()
        ->where('juridiction_parquet_id', $juridiction)
        ->count();

        $roleC = Role::where('name', 'Greffier Caissier')
        ->first();

        $greffierCai = $roleC->users()
        ->where('juridiction_parquet_id', $juridiction)
        ->count();

        

        $roleTous = Role::where('name', 'Greffier Caissier')
        ->orWhere('name', '=', 'Président')
        ->orWhere('name', '=', 'Juge')
        ->orWhere('name', '=', 'Greffier')
        ->orWhere('name', '=', 'Admin')
        ->first();

        $dossEn = Dossier::join('etat_dossiers', 'dossiers.etat_id', '=', 'etat_dossiers.id')
        ->join('users', 'dossiers.user_id', '=', 'users.id')
        ->where('etat_dossiers.nom', '=', 'Dossiers en cours')
        ->where('juridiction_parquet_id', $juridiction)
        ->count();

        $dossAp = Dossier::join('etat_dossiers', 'dossiers.etat_id', '=', 'etat_dossiers.id')
        ->join('users', 'dossiers.user_id', '=', 'users.id')
        ->where('etat_dossiers.nom', '=', 'Dossiers en appel')
        ->where('juridiction_parquet_id', $juridiction)
        ->count();

        $dossJu = Dossier::join('etat_dossiers', 'dossiers.etat_id', '=', 'etat_dossiers.id')
        ->join('users', 'dossiers.user_id', '=', 'users.id')
        ->where('etat_dossiers.nom', '=', 'Dossiers jugés')
        ->where('juridiction_parquet_id', $juridiction)
        ->count();

        $dossEx = Dossier::join('etat_dossiers', 'dossiers.etat_id', '=', 'etat_dossiers.id')
        ->join('users', 'dossiers.user_id', '=', 'users.id')
        ->where('etat_dossiers.nom', '=', 'Dossiers exécutés')
        ->where('juridiction_parquet_id', $juridiction)
        ->count();

        $dossiers = Dossier::leftjoin('fichiers', 'fichiers.dossier_id', 'dossiers.id')
        ->join('users', 'dossiers.user_id', '=', 'users.id')
        ->join('etat_dossiers', 'dossiers.etat_id', '=', 'etat_dossiers.id')
        ->join('type_dossiers', 'dossiers.type_dossier_id', '=', 'type_dossiers.id')
        ->join('type_categorie_dossiers', 'type_dossiers.categorie_id', '=', 'type_categorie_dossiers.id')
        ->select('dossiers.id', 'dossiers.numero', DB::raw('count(fichiers.id) as count'), 'etat_dossiers.nom as nomEta', 'type_dossiers.nom as type', 'type_categorie_dossiers.nom_categorie as categorie')
        ->groupBy('dossiers.id', 'dossiers.numero', 'etat_dossiers.nom', 'type_dossiers.nom', 'type_categorie_dossiers.nom_categorie')
        ->orderBy('dossiers.id', 'desc')
        ->where('juridiction_parquet_id', $juridiction)
        ->get()->take(5);

        return view('/dashboard', compact('juges','greffiers', 'greffierCai', 'dossEn', 'dossAp', 'dossJu', 'dossEx', 'dossiers'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function dashbord()
    {
        $gref = Auth::user();
        $juridiction = $gref->juridiction_parquet_id;

        $roleO = Role::where('name', 'OMP')
        ->first();

        $omps = $roleO->users()
        ->where('juridiction_parquet_id', $juridiction)
        ->count();

        $roleS = Role::where('name', 'Secrétaire')
        ->first();

        $secre = $roleS->users()
        ->where('juridiction_parquet_id', $juridiction)
        ->count();
       

        $dossEn = Dossier::join('etat_dossiers', 'dossiers.etat_id', '=', 'etat_dossiers.id')
        ->join('users', 'dossiers.user_id', '=', 'users.id')
        ->where('etat_dossiers.nom', '=', 'Dossiers en cours')
        ->where('juridiction_parquet_id', $juridiction)
        ->count();

        $dossAp = Dossier::join('etat_dossiers', 'dossiers.etat_id', '=', 'etat_dossiers.id')
        ->join('users', 'dossiers.user_id', '=', 'users.id')
        ->where('etat_dossiers.nom', '=', 'Dossiers en appel')
        ->where('juridiction_parquet_id', $juridiction)
        ->count();

        $dossJu = Dossier::join('etat_dossiers', 'dossiers.etat_id', '=', 'etat_dossiers.id')
        ->join('users', 'dossiers.user_id', '=', 'users.id')
        ->where('etat_dossiers.nom', '=', 'Dossiers jugés')
        ->where('juridiction_parquet_id', $juridiction)
        ->count();

        $dossEx = Dossier::join('etat_dossiers', 'dossiers.etat_id', '=', 'etat_dossiers.id')
        ->join('users', 'dossiers.user_id', '=', 'users.id')
        ->where('etat_dossiers.nom', '=', 'Dossiers exécutés')
        ->where('juridiction_parquet_id', $juridiction)
        ->count();

        $dossiers = Dossier::leftjoin('fichiers', 'fichiers.dossier_id', 'dossiers.id')
        ->join('users', 'dossiers.user_id', '=', 'users.id')
        ->join('etat_dossiers', 'dossiers.etat_id', '=', 'etat_dossiers.id')
        ->join('type_dossiers', 'dossiers.type_dossier_id', '=', 'type_dossiers.id')
        ->join('type_categorie_dossiers', 'type_dossiers.categorie_id', '=', 'type_categorie_dossiers.id')
        ->select('dossiers.id', 'dossiers.numero', DB::raw('count(fichiers.id) as count'), 'etat_dossiers.nom as nomEta', 'type_dossiers.nom as type', 'type_categorie_dossiers.nom_categorie as categorie')
        ->groupBy('dossiers.id', 'dossiers.numero', 'etat_dossiers.nom', 'type_dossiers.nom', 'type_categorie_dossiers.nom_categorie')
        ->orderBy('dossiers.id', 'desc')
        ->where('juridiction_parquet_id', $juridiction)
        ->get()->take(5);

        return view('/dashboardParquet', compact('dossEn', 'dossAp', 'dossJu', 'dossEx', 'dossiers', 'omps', 'secre'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
