/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.6.20-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: vsfgrsgqeqrgh_justice
-- ------------------------------------------------------
-- Server version	10.6.20-MariaDB-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `vsfgrsgqeqrgh_justice`
--


--
-- Table structure for table `audiences`
--

DROP TABLE IF EXISTS `audiences`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `audiences` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `juridiction_parquet_id` bigint(20) unsigned NOT NULL,
  `dossier_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `audiences_dossier_id_foreign` (`dossier_id`),
  KEY `audiences_juridiction_id_foreign` (`juridiction_parquet_id`),
  CONSTRAINT `audiences_dossier_id_foreign` FOREIGN KEY (`dossier_id`) REFERENCES `dossiers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `audiences_juridiction_id_foreign` FOREIGN KEY (`juridiction_parquet_id`) REFERENCES `juridiction_parques` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `audiences`
--

LOCK TABLES `audiences` WRITE;
/*!40000 ALTER TABLE `audiences` DISABLE KEYS */;
INSERT INTO `audiences` (`id`, `date`, `description`, `juridiction_parquet_id`, `dossier_id`, `created_at`, `updated_at`) VALUES (3,'2024-03-22','liste des dossiers',4,40,'2024-03-21 20:24:27','2024-03-21 20:41:35'),(5,'2024-03-28','Dossiers',4,44,'2024-03-27 16:34:08','2024-03-27 18:49:08'),(6,'2024-03-31','Banque et  Cooperative',3,46,'2024-03-27 17:03:25','2024-03-27 17:03:25');
/*!40000 ALTER TABLE `audiences` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `commentaires`
--

DROP TABLE IF EXISTS `commentaires`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `commentaires` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `dossier_id` bigint(20) unsigned NOT NULL,
  `avis` varchar(255) NOT NULL,
  `updated_at` date NOT NULL,
  `created_at` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dossier_id` (`dossier_id`),
  CONSTRAINT `commentaires_ibfk_1` FOREIGN KEY (`dossier_id`) REFERENCES `dossiers` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `commentaires`
--

LOCK TABLES `commentaires` WRITE;
/*!40000 ALTER TABLE `commentaires` DISABLE KEYS */;
INSERT INTO `commentaires` (`id`, `dossier_id`, `avis`, `updated_at`, `created_at`) VALUES (1,43,'french 2.pdf','2024-03-23','2024-03-23'),(4,42,'amende.pdf','2024-03-25','2024-03-25'),(5,42,'convocation.pdf','2024-03-27','2024-03-27'),(6,42,'amende.pdf','2024-03-28','2024-03-28');
/*!40000 ALTER TABLE `commentaires` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `communes`
--

DROP TABLE IF EXISTS `communes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `communes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `nom` varchar(255) NOT NULL,
  `province_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `communes_provinces_id_foreign` (`province_id`),
  CONSTRAINT `communes_provinces_id_foreign` FOREIGN KEY (`province_id`) REFERENCES `provinces` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `communes`
--

LOCK TABLES `communes` WRITE;
/*!40000 ALTER TABLE `communes` DISABLE KEYS */;
INSERT INTO `communes` (`id`, `nom`, `province_id`, `created_at`, `updated_at`) VALUES (1,'Bubanza',1,'2024-03-19 08:31:21','2024-03-19 08:31:21'),(2,'Gihanga',1,'2024-03-19 08:32:22','2024-03-19 08:32:22'),(3,'Muha',2,'2024-03-19 08:32:47','2024-03-19 08:32:47'),(4,'Mukaza',2,'2024-03-19 08:33:01','2024-03-19 08:33:01'),(5,'Ntahangwa',2,'2024-03-19 08:33:16','2024-03-19 08:33:16');
/*!40000 ALTER TABLE `communes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dossiers`
--

DROP TABLE IF EXISTS `dossiers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dossiers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `numero` varchar(255) NOT NULL,
  `etat_id` bigint(20) unsigned NOT NULL,
  `type_dossier_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT 0,
  `valide` tinyint(4) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `dossiers_numero_unique` (`numero`),
  KEY `user_id` (`user_id`),
  KEY `dossiers_etat_id_foreign` (`etat_id`),
  KEY `dossiers_type_dossier_id_foreign` (`type_dossier_id`),
  CONSTRAINT `dossiers_etat_id_foreign` FOREIGN KEY (`etat_id`) REFERENCES `etat_dossiers` (`id`),
  CONSTRAINT `dossiers_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`),
  CONSTRAINT `dossiers_type_dossier_id_foreign` FOREIGN KEY (`type_dossier_id`) REFERENCES `type_dossiers` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dossiers`
--

LOCK TABLES `dossiers` WRITE;
/*!40000 ALTER TABLE `dossiers` DISABLE KEYS */;
INSERT INTO `dossiers` (`id`, `numero`, `etat_id`, `type_dossier_id`, `user_id`, `status`, `valide`, `created_at`, `updated_at`) VALUES (39,'232345',1,3,19,0,0,'2024-03-21 14:46:26','2024-03-21 14:46:26'),(40,'1312416',4,3,19,0,0,'2024-03-21 18:03:59','2024-03-24 12:35:06'),(41,'52865',1,3,19,0,0,'2024-03-22 10:42:14','2024-03-22 10:42:14'),(42,'RP 55430',1,1,29,1,0,'2024-03-22 11:36:44','2024-03-24 16:29:37'),(43,'56235174',1,1,29,1,0,'2024-03-22 12:11:45','2024-03-27 12:43:08'),(44,'354',1,3,19,1,0,'2024-03-23 09:05:21','2024-03-25 08:02:33'),(45,'4352326',1,5,19,0,0,'2024-03-25 12:00:23','2024-03-25 12:00:23'),(46,'66556537',1,4,26,1,0,'2024-03-26 17:28:23','2024-03-26 17:29:18'),(47,'35623',1,4,19,1,0,'2024-03-27 12:25:27','2024-03-27 12:26:20'),(48,'5567567',5,4,26,1,0,'2024-03-28 19:01:20','2024-03-28 19:02:16');
/*!40000 ALTER TABLE `dossiers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `etat_dossiers`
--

DROP TABLE IF EXISTS `etat_dossiers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `etat_dossiers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `nom` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `etat_dossiers`
--

LOCK TABLES `etat_dossiers` WRITE;
/*!40000 ALTER TABLE `etat_dossiers` DISABLE KEYS */;
INSERT INTO `etat_dossiers` (`id`, `nom`, `created_at`, `updated_at`) VALUES (1,'Dossiers en cours',NULL,'2024-03-10 17:17:55'),(3,'Dossiers jugés','2024-03-10 16:58:42','2024-03-10 16:58:42'),(4,'Dossiers en appel','2024-03-10 16:59:31','2024-03-10 16:59:31'),(5,'Dossiers exécutés','2024-03-10 16:59:49','2024-03-10 16:59:49'),(6,'Dossiers à constater','2024-03-24 17:07:54','2024-03-24 17:07:54'),(7,'Dossiers sinédiés','2024-03-24 17:08:27','2024-03-24 17:08:27'),(8,'Dossiers à signifier','2024-03-24 17:08:51','2024-03-24 17:08:51'),(9,'Dossiers mis au rôle général','2024-03-24 17:09:27','2024-03-24 17:09:39'),(13,'Dossier à clôturer','2024-03-25 09:56:04','2024-03-25 09:56:04');
/*!40000 ALTER TABLE `etat_dossiers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) NOT NULL,
  `connection` text NOT NULL,
  `queue` text NOT NULL,
  `payload` longtext NOT NULL,
  `exception` longtext NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fichiers`
--

DROP TABLE IF EXISTS `fichiers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fichiers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `nom` varchar(255) DEFAULT NULL,
  `lien` varchar(255) NOT NULL,
  `type_fichier_id` bigint(20) unsigned NOT NULL,
  `dossier_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fichiers_type_fichier_id_foreign` (`type_fichier_id`),
  KEY `fichiers_dossier_id_foreign` (`dossier_id`),
  CONSTRAINT `fichiers_dossier_id_foreign` FOREIGN KEY (`dossier_id`) REFERENCES `dossiers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fichiers_type_fichier_id_foreign` FOREIGN KEY (`type_fichier_id`) REFERENCES `type_fichiers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fichiers`
--

LOCK TABLES `fichiers` WRITE;
/*!40000 ALTER TABLE `fichiers` DISABLE KEYS */;
INSERT INTO `fichiers` (`id`, `nom`, `lien`, `type_fichier_id`, `dossier_id`, `created_at`, `updated_at`) VALUES (23,'Amende','french 2.pdf',1,39,'2024-03-21 17:08:36','2024-03-21 17:28:08'),(24,'Convocation','french 2.pdf',2,40,'2024-03-21 18:04:31','2024-03-21 18:04:31'),(25,'paiement','french 2.pdf',1,41,'2024-03-22 10:43:19','2024-03-22 10:43:19'),(26,'Convocation','french 2.pdf',2,42,'2024-03-22 12:15:48','2024-03-22 12:15:48'),(27,'amende','amende.pdf',1,44,'2024-03-23 10:28:15','2024-03-23 10:28:15'),(28,NULL,'convocation.pdf',1,46,'2024-03-26 17:28:50','2024-03-26 17:28:50'),(29,NULL,'convocation.pdf',4,47,'2024-03-27 12:26:01','2024-03-27 12:26:01'),(30,NULL,'convocation.pdf',1,48,'2024-03-28 19:01:53','2024-03-28 19:01:53');
/*!40000 ALTER TABLE `fichiers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jugements`
--

DROP TABLE IF EXISTS `jugements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `jugements` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `juridiction_id` bigint(20) unsigned NOT NULL,
  `dossier_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `jugements_juridiction_id_foreign` (`juridiction_id`),
  KEY `jugements_dossier_id_foreign` (`dossier_id`),
  CONSTRAINT `jugements_dossier_id_foreign` FOREIGN KEY (`dossier_id`) REFERENCES `dossiers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `jugements_juridiction_id_foreign` FOREIGN KEY (`juridiction_id`) REFERENCES `juridictions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jugements`
--

LOCK TABLES `jugements` WRITE;
/*!40000 ALTER TABLE `jugements` DISABLE KEYS */;
/*!40000 ALTER TABLE `jugements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `juges`
--

DROP TABLE IF EXISTS `juges`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `juges` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `dossier_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `juges_dossier_id_foreign` (`dossier_id`),
  KEY `juges_utilisateur_id_foreign` (`user_id`),
  CONSTRAINT `juges_dossier_id_foreign` FOREIGN KEY (`dossier_id`) REFERENCES `dossiers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `juges_utilisateur_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `juges`
--

LOCK TABLES `juges` WRITE;
/*!40000 ALTER TABLE `juges` DISABLE KEYS */;
INSERT INTO `juges` (`id`, `role`, `user_id`, `dossier_id`, `created_at`, `updated_at`) VALUES (11,'President',22,41,'2024-03-22 11:10:35','2024-03-22 11:10:35'),(13,'Membre',33,47,'2024-03-27 12:28:28','2024-03-27 18:43:19'),(14,'President',34,48,'2024-03-28 19:13:34','2024-03-28 19:13:34');
/*!40000 ALTER TABLE `juges` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `juridiction_parques`
--

DROP TABLE IF EXISTS `juridiction_parques`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `juridiction_parques` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `nom` varchar(255) NOT NULL,
  `province` varchar(255) NOT NULL,
  `commune` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `juridiction_parques`
--

LOCK TABLES `juridiction_parques` WRITE;
/*!40000 ALTER TABLE `juridiction_parques` DISABLE KEYS */;
INSERT INTO `juridiction_parques` (`id`, `nom`, `province`, `commune`, `created_at`, `updated_at`) VALUES (3,'Résidence','Muyinga','Giteranyi',NULL,NULL),(4,'Grande Instance','Muyinga','Muyinga',NULL,NULL),(5,'Parquet','Muyinga','Muyinga',NULL,NULL),(6,'Grande Instance','Ngozi','Ngozi','2024-03-22 07:26:30','2024-03-22 08:04:39'),(7,'Parquet','Bujumbura Mairie','Mukaza','2024-03-22 08:21:45','2024-03-22 08:22:27');
/*!40000 ALTER TABLE `juridiction_parques` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `juridictions`
--

DROP TABLE IF EXISTS `juridictions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `juridictions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `nom` varchar(255) NOT NULL,
  `juridiction_parquet_id` bigint(20) unsigned NOT NULL,
  `province_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `juridiction_parquet_id` (`juridiction_parquet_id`),
  KEY `province_id` (`province_id`),
  CONSTRAINT `juridictions_ibfk_1` FOREIGN KEY (`juridiction_parquet_id`) REFERENCES `juridiction_parques` (`id`),
  CONSTRAINT `juridictions_ibfk_2` FOREIGN KEY (`province_id`) REFERENCES `provinces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `juridictions`
--

LOCK TABLES `juridictions` WRITE;
/*!40000 ALTER TABLE `juridictions` DISABLE KEYS */;
/*!40000 ALTER TABLE `juridictions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES (1,'2014_10_12_000000_create_users_table',1),(2,'2014_10_12_100000_create_password_resets_table',1),(3,'2019_08_19_000000_create_failed_jobs_table',1),(4,'2019_12_14_000001_create_personal_access_tokens_table',1),(6,'2024_03_08_102234_create_juridictions_table',1),(7,'2024_03_08_102235_create_utilisateurs_table',1),(8,'2024_03_08_102244_create_type_fichiers_table',1),(9,'2024_03_08_102301_create_type_categorie_dossiers_table',1),(10,'2024_03_08_102310_create_type_dossiers_table',1),(11,'2024_03_08_102318_create_niveau_table',1),(12,'2024_03_08_102328_create_etat_dossiers_table',1),(13,'2024_03_08_102337_create_dossiers_table',1),(14,'2024_03_08_102338_create_juges_table',1),(15,'2024_03_08_102346_create_audiences_table',1),(16,'2024_03_08_102355_create_jugements_table',1),(17,'2024_03_08_110011_create_fichiers_table',1),(18,'2024_03_10_142554_create_transfert_dossiers_table',2),(21,'2024_03_12_211157_create_notifications_table',3),(22,'2024_03_19_082557_create_juridiction_parques_table',4),(23,'2024_03_19_091715_create_provinces_table',5),(24,'2024_03_19_091812_create_communes_table',6),(26,'2024_03_21_135343_create_permission_tables',7);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `model_has_permissions`
--

DROP TABLE IF EXISTS `model_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL,
  `model_type` varchar(255) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `model_has_permissions`
--

LOCK TABLES `model_has_permissions` WRITE;
/*!40000 ALTER TABLE `model_has_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `model_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `model_has_roles`
--

DROP TABLE IF EXISTS `model_has_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_roles` (
  `role_id` bigint(20) unsigned NOT NULL,
  `model_type` varchar(255) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `model_has_roles`
--

LOCK TABLES `model_has_roles` WRITE;
/*!40000 ALTER TABLE `model_has_roles` DISABLE KEYS */;
INSERT INTO `model_has_roles` (`role_id`, `model_type`, `model_id`) VALUES (1,'App\\Models\\User',18),(1,'App\\Models\\User',24),(1,'App\\Models\\User',27),(2,'App\\Models\\User',23),(2,'App\\Models\\User',25),(3,'App\\Models\\User',19),(3,'App\\Models\\User',26),(4,'App\\Models\\User',32),(5,'App\\Models\\User',22),(5,'App\\Models\\User',33),(5,'App\\Models\\User',34),(6,'App\\Models\\User',28),(7,'App\\Models\\User',29),(8,'App\\Models\\User',30),(8,'App\\Models\\User',31);
/*!40000 ALTER TABLE `model_has_roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `niveaux`
--

DROP TABLE IF EXISTS `niveaux`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `niveaux` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `nom` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `niveaux`
--

LOCK TABLES `niveaux` WRITE;
/*!40000 ALTER TABLE `niveaux` DISABLE KEYS */;
INSERT INTO `niveaux` (`id`, `nom`, `created_at`, `updated_at`) VALUES (1,'Traitement',NULL,NULL),(2,'Clôture','2024-03-08 15:41:50','2024-03-08 15:41:50');
/*!40000 ALTER TABLE `niveaux` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `notifications`
--

DROP TABLE IF EXISTS `notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notifications` (
  `id` char(36) NOT NULL,
  `type` varchar(255) NOT NULL,
  `notifiable_type` varchar(255) NOT NULL,
  `notifiable_id` bigint(20) unsigned NOT NULL,
  `data` text NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notifications_notifiable_type_notifiable_id_index` (`notifiable_type`,`notifiable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `notifications`
--

LOCK TABLES `notifications` WRITE;
/*!40000 ALTER TABLE `notifications` DISABLE KEYS */;
INSERT INTO `notifications` (`id`, `type`, `notifiable_type`, `notifiable_id`, `data`, `read_at`, `created_at`, `updated_at`) VALUES ('17bd0e91-b58a-402b-9d25-38578783e56a','App\\Notifications\\AffecterNotification','App\\Models\\User',30,'{\"message\":\"Nouveau Dossier pour vous.\",\"name\":\"1\"}','2024-03-23 19:07:40','2024-03-23 19:06:17','2024-03-23 19:07:40'),('1c9d7c2e-6f4c-4a25-bb53-6d70585d4825','App\\Notifications\\ValideAvisNotification','App\\Models\\User',30,'{\"message\":\"Confirmation de l\'avis par le procureur.\",\"name\":\"fixation\"}','2024-03-26 15:33:16','2024-03-26 14:31:49','2024-03-26 15:33:16'),('1fe4e886-3338-4432-a2ec-35f44b54d15f','App\\Notifications\\DossierAjouterNotification','App\\Models\\User',25,'{\"message\":\"Un nouveau Dossier a \\u00e9t\\u00e9 enregistr\\u00e9.\",\"name\":null}','2024-03-26 16:12:58','2024-03-24 12:37:54','2024-03-26 16:12:58'),('22a1a09e-eba5-4102-9628-ae919fc405df','App\\Notifications\\AffecterNotification','App\\Models\\User',30,'{\"message\":\"Nouveau Dossier pour vous.\",\"name\":\"4\"}','2024-03-25 12:15:41','2024-03-25 12:14:13','2024-03-25 12:15:41'),('2388fda9-408e-4c41-ad81-0be883fc67e5','App\\Notifications\\ValideAvisNotification','App\\Models\\User',30,'{\"message\":\"Confirmation de l\'avis par le procureur.\",\"name\":\"poursuite des enqu\\u00eates\"}','2024-03-28 18:47:47','2024-03-28 18:46:18','2024-03-28 18:47:47'),('2c1e37ce-688c-42b1-9096-b9dde79ae4a1','App\\Notifications\\DossierAjouterNotification','App\\Models\\User',23,'{\"message\":\"Un nouveau Dossier a \\u00e9t\\u00e9 enregistr\\u00e9.\",\"name\":\"48\"}',NULL,'2024-03-28 19:02:39','2024-03-28 19:02:39'),('2eab67ff-f6a3-43f7-bd88-550d54d14613','App\\Notifications\\DossierAjouterNotification','App\\Models\\User',28,'{\"message\":\"Un nouveau Dossier a \\u00e9t\\u00e9 enregistr\\u00e9.\",\"name\":\"42\"}','2024-11-06 08:14:08','2024-03-28 18:49:47','2024-11-06 08:14:08'),('340385b2-d9b0-4b01-9b8c-cb018e26a85b','App\\Notifications\\AffecterNotification','App\\Models\\User',30,'{\"message\":\"Nouveau Dossier pour vous.\",\"name\":\"4\"}','2024-03-25 12:15:41','2024-03-25 12:13:59','2024-03-25 12:15:41'),('3d8938c6-3e61-475f-bdd9-090f37898a32','App\\Notifications\\AffecterNotification','App\\Models\\User',34,'{\"message\":\"Nouveau Dossier pour vous.\",\"name\":\"48\"}',NULL,'2024-03-28 19:13:34','2024-03-28 19:13:34'),('4c6809d3-42e7-4fac-b0c8-42d12074b8ec','App\\Notifications\\DossierAjouterNotification','App\\Models\\User',25,'{\"message\":\"Un nouveau Dossier a \\u00e9t\\u00e9 enregistr\\u00e9.\",\"name\":\"66556537\"}','2024-03-27 17:03:13','2024-03-26 17:29:18','2024-03-27 17:03:13'),('57c0d6fc-2738-41cd-a1dd-51bc6bcd601f','App\\Notifications\\ValideAvisNotification','App\\Models\\User',31,'{\"message\":\"Confirmation de l\'avis par le procureur.\",\"name\":\"poursuite des enqu\\u00eates\"}',NULL,'2024-03-28 18:46:18','2024-03-28 18:46:18'),('5e1adccf-323b-46a9-9f3a-c7075c25b7c7','App\\Notifications\\DossierAjouterNotification','App\\Models\\User',28,'{\"message\":\"Un nouveau Dossier a \\u00e9t\\u00e9 enregistr\\u00e9.\",\"name\":\"42\"}','2024-03-27 17:32:40','2024-03-27 12:44:00','2024-03-27 17:32:40'),('71588308-cd6c-425c-a998-e9c38873038a','App\\Notifications\\DossierAjouterNotification','App\\Models\\User',23,'{\"message\":\"Un nouveau Dossier a \\u00e9t\\u00e9 enregistr\\u00e9.\",\"name\":\"43\"}',NULL,'2024-03-28 18:45:37','2024-03-28 18:45:37'),('8aad04ec-99af-45e0-a15d-179833da9e6e','App\\Notifications\\ValideAvisNotification','App\\Models\\User',31,'{\"message\":\"Confirmation de l\'avis par le procureur.\",\"name\":\"poursuite des enqu\\u00eates\"}','2024-03-27 18:10:13','2024-03-26 14:25:47','2024-03-27 18:10:13'),('8d17f945-9b74-4e8b-ae64-fcb6886b9fb2','App\\Notifications\\DossierAjouterNotification','App\\Models\\User',23,'{\"message\":\"Un nouveau Dossier a \\u00e9t\\u00e9 enregistr\\u00e9.\",\"name\":\"46\"}','2024-03-27 12:27:12','2024-03-26 17:29:38','2024-03-27 12:27:12'),('8f1500bb-8699-41b8-b9e8-6d2507dd2d1e','App\\Notifications\\AffecterNotification','App\\Models\\User',22,'{\"message\":\"Nouveau Dossier pour vous.\",\"name\":\"44\"}','2024-03-27 17:57:48','2024-03-25 11:36:25','2024-03-27 17:57:48'),('9201c172-4011-47c4-a69e-096aa492a5e4','App\\Notifications\\ValideAvisNotification','App\\Models\\User',31,'{\"message\":\"Confirmation de l\'avis par le procureur.\",\"name\":\"fixation\"}','2024-03-27 18:10:23','2024-03-26 14:31:49','2024-03-27 18:10:23'),('9856abe6-4509-4582-968b-d7d10f81053e','App\\Notifications\\AffecterNotification','App\\Models\\User',22,'{\"message\":\"Nouveau Dossier pour vous.\",\"name\":\"47\"}','2024-03-27 17:57:48','2024-03-27 12:28:28','2024-03-27 17:57:48'),('9a4c607a-9825-465c-88ca-c2c968e2b08d','App\\Notifications\\DossierAjouterNotification','App\\Models\\User',28,'{\"message\":\"Un nouveau Dossier a \\u00e9t\\u00e9 enregistr\\u00e9.\",\"name\":\"42\"}','2024-03-25 12:13:38','2024-03-25 12:13:12','2024-03-25 12:13:38'),('ad0b27bd-75d0-4813-9c01-4ce17abbb471','App\\Notifications\\DossierAjouterNotification','App\\Models\\User',23,'{\"message\":\"Un nouveau Dossier a \\u00e9t\\u00e9 enregistr\\u00e9.\",\"name\":\"46\"}','2024-03-27 12:39:08','2024-03-27 12:37:32','2024-03-27 12:39:08'),('be761cfc-1f93-4090-8749-4af3f5200af8','App\\Notifications\\DossierAjouterNotification','App\\Models\\User',23,'{\"message\":\"Un nouveau Dossier a \\u00e9t\\u00e9 enregistr\\u00e9.\",\"name\":\"40\"}','2024-03-25 11:35:41','2024-03-24 11:52:24','2024-03-25 11:35:41'),('ca436cfd-dd6a-4dd1-b0a8-13627c70501c','App\\Notifications\\DossierAjouterNotification','App\\Models\\User',23,'{\"message\":\"Un nouveau Dossier a \\u00e9t\\u00e9 enregistr\\u00e9.\",\"name\":\"354\"}','2024-03-25 11:35:49','2024-03-25 08:02:34','2024-03-25 11:35:49'),('cc960dd2-90a8-4f29-9f7c-962618834393','App\\Notifications\\ValideAvisNotification','App\\Models\\User',31,'{\"message\":\"Confirmation de l\'avis par le procureur.\",\"name\":\"poursuite des enqu\\u00eates\"}','2024-03-27 18:10:04','2024-03-27 12:44:30','2024-03-27 18:10:04'),('cfbb64b5-e66b-49ae-b934-f4dd824ea447','App\\Notifications\\AffecterNotification','App\\Models\\User',31,'{\"message\":\"Nouveau Dossier pour vous.\",\"name\":\"4\"}','2024-03-27 18:10:18','2024-03-25 12:13:59','2024-03-27 18:10:18'),('d3364736-0845-4cf4-8017-ed4164198032','App\\Notifications\\DossierAjouterNotification','App\\Models\\User',25,'{\"message\":\"Un nouveau Dossier a \\u00e9t\\u00e9 enregistr\\u00e9.\",\"name\":\"5567567\"}',NULL,'2024-03-28 19:02:16','2024-03-28 19:02:16'),('d4a10a80-f7f3-47d5-b0bc-6f5ed8588b89','App\\Notifications\\AffecterNotification','App\\Models\\User',31,'{\"message\":\"Nouveau Dossier pour vous.\",\"name\":\"1\"}','2024-03-27 18:10:24','2024-03-23 19:06:17','2024-03-27 18:10:24'),('e2f08773-477f-4eda-aca5-db6ddde219e6','App\\Notifications\\AffecterNotification','App\\Models\\User',31,'{\"message\":\"Nouveau Dossier pour vous.\",\"name\":\"4\"}','2024-03-27 18:10:24','2024-03-25 12:14:13','2024-03-27 18:10:24'),('f045ba9c-1499-4841-9c03-4a3d5b6a28c6','App\\Notifications\\ValideAvisNotification','App\\Models\\User',30,'{\"message\":\"Confirmation de l\'avis par le procureur.\",\"name\":\"poursuite des enqu\\u00eates\"}','2024-03-27 18:08:37','2024-03-27 12:44:30','2024-03-27 18:08:37'),('fc3671f1-fe7e-441a-9d86-cdd3f84b40df','App\\Notifications\\ValideAvisNotification','App\\Models\\User',30,'{\"message\":\"Confirmation de l\'avis par le procureur.\",\"name\":\"poursuite des enqu\\u00eates\"}','2024-03-26 15:33:17','2024-03-26 14:25:46','2024-03-26 15:33:17'),('fe6d149a-5641-4032-aa48-899851baae1c','App\\Notifications\\DossierAjouterNotification','App\\Models\\User',23,'{\"message\":\"Un nouveau Dossier a \\u00e9t\\u00e9 enregistr\\u00e9.\",\"name\":\"35623\"}','2024-03-27 12:27:12','2024-03-27 12:26:21','2024-03-27 12:27:12');
/*!40000 ALTER TABLE `notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_resets`
--

DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `password_resets` (
  `email` varchar(255) NOT NULL,
  `token` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_resets`
--

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `permissions`
--

DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `permissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `guard_name` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `permissions_name_guard_name_unique` (`name`,`guard_name`)
) ENGINE=InnoDB AUTO_INCREMENT=84 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `permissions`
--

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES (11,'Create role','web','2024-03-21 12:57:26','2024-03-21 12:57:26'),(12,'View role','web','2024-03-21 12:57:39','2024-03-21 12:57:39'),(13,'Update role','web','2024-03-21 12:59:28','2024-03-21 12:59:28'),(14,'Delete role','web','2024-03-21 12:59:44','2024-03-21 12:59:44'),(15,'Create permission','web','2024-03-21 13:00:03','2024-03-21 13:00:03'),(16,'View permission','web','2024-03-21 13:00:27','2024-03-21 13:00:27'),(17,'Update permission','web','2024-03-21 13:00:45','2024-03-21 13:00:45'),(18,'Delete permission','web','2024-03-21 13:01:02','2024-03-21 13:01:02'),(19,'Create user','web','2024-03-21 13:01:15','2024-03-21 13:01:15'),(20,'View user','web','2024-03-21 13:01:28','2024-03-21 13:01:28'),(21,'Update user','web','2024-03-21 13:01:44','2024-03-21 13:01:44'),(22,'Delete user','web','2024-03-21 13:01:55','2024-03-21 13:01:55'),(23,'Create dossier','web','2024-03-21 13:02:09','2024-03-21 13:02:09'),(24,'View dossier','web','2024-03-21 13:02:28','2024-03-21 13:02:28'),(25,'Update dossier','web','2024-03-21 13:03:29','2024-03-21 13:03:29'),(26,'Delete dossier','web','2024-03-21 13:03:42','2024-03-21 13:03:42'),(27,'Create categorie dossier','web','2024-03-21 13:33:20','2024-03-21 13:33:20'),(28,'View categorie dossier','web','2024-03-21 13:33:35','2024-03-21 13:33:35'),(29,'Update categorie dossier','web','2024-03-21 13:33:48','2024-03-21 13:33:48'),(30,'Delete categorie dossier','web','2024-03-21 13:34:02','2024-03-21 13:34:02'),(31,'Create type dossier','web','2024-03-21 13:34:25','2024-03-21 13:34:25'),(32,'View type dossier','web','2024-03-21 13:34:36','2024-03-21 13:34:36'),(33,'Update type dossier','web','2024-03-21 13:34:49','2024-03-21 13:34:49'),(34,'Delete type dossier','web','2024-03-21 13:35:01','2024-03-21 13:35:01'),(35,'Create etat dossier','web','2024-03-21 13:35:31','2024-03-21 13:35:31'),(36,'View etat dossier','web','2024-03-21 13:36:49','2024-03-21 13:36:49'),(37,'Update etat dossier','web','2024-03-21 13:37:10','2024-03-21 13:37:10'),(38,'Delete etat dossier','web','2024-03-21 13:37:26','2024-03-21 13:37:26'),(39,'Create fichier','web','2024-03-21 13:37:49','2024-03-21 13:37:49'),(40,'View fichier','web','2024-03-21 13:37:59','2024-03-21 13:37:59'),(41,'Update fichier','web','2024-03-21 13:38:40','2024-03-21 13:38:40'),(42,'Delete fichier','web','2024-03-21 13:38:52','2024-03-21 13:38:52'),(43,'Create juridiction','web','2024-03-21 13:40:36','2024-03-21 13:40:36'),(44,'View juridiction','web','2024-03-21 13:40:47','2024-03-21 13:40:47'),(45,'Update juridiction','web','2024-03-21 13:41:03','2024-03-21 13:41:03'),(46,'Delete juridiction','web','2024-03-21 13:41:31','2024-03-21 13:41:31'),(47,'Create audience','web','2024-03-21 13:42:12','2024-03-21 13:42:12'),(48,'View audience','web','2024-03-21 13:42:23','2024-03-21 13:42:23'),(49,'Update audience','web','2024-03-21 13:42:35','2024-03-21 13:42:35'),(50,'Delete audience','web','2024-03-21 13:43:15','2024-03-21 13:43:15'),(51,'Create parquet','web','2024-03-21 13:44:15','2024-03-21 13:44:15'),(52,'View parquet','web','2024-03-21 13:44:26','2024-03-21 13:44:26'),(53,'Update parquet','web','2024-03-21 13:44:37','2024-03-21 13:44:37'),(54,'Delete parquet','web','2024-03-21 13:44:49','2024-03-21 13:44:49'),(55,'Create affecter','web','2024-03-21 14:57:25','2024-03-21 14:57:25'),(56,'View affecter','web','2024-03-21 14:57:35','2024-03-21 14:57:35'),(57,'Update affecter','web','2024-03-21 14:57:48','2024-03-21 14:57:48'),(58,'Delete affecter','web','2024-03-21 14:58:01','2024-03-21 14:58:01'),(59,'Create valide','web','2024-03-21 14:58:31','2024-03-21 14:58:51'),(60,'View valide','web','2024-03-21 14:59:45','2024-03-21 14:59:45'),(61,'Update valide','web','2024-03-21 14:59:58','2024-03-21 14:59:58'),(62,'Delete valide','web','2024-03-21 15:00:10','2024-03-21 15:00:10'),(63,'Create transfert','web','2024-03-21 15:00:38','2024-03-21 15:00:38'),(64,'View transfert','web','2024-03-21 15:00:50','2024-03-21 15:00:50'),(65,'Update transfert','web','2024-03-21 15:01:03','2024-03-21 15:01:03'),(66,'Delete transfert','web','2024-03-21 15:01:13','2024-03-21 15:01:13'),(67,'Show dossier','web','2024-03-21 15:04:43','2024-03-21 15:04:43'),(68,'Valide dossier','web','2024-03-21 15:05:23','2024-03-21 15:05:23'),(69,'Create avis','web','2024-03-23 07:00:51','2024-03-23 07:00:51'),(70,'View avis','web','2024-03-23 07:01:08','2024-03-23 07:01:08'),(71,'Update avis','web','2024-03-23 07:01:23','2024-03-23 07:01:23'),(72,'Delete avis','web','2024-03-23 07:01:39','2024-03-23 07:01:39'),(73,'Valide avis','web','2024-03-23 07:05:24','2024-03-23 07:05:24'),(74,'Create repartir','web','2024-03-23 08:14:08','2024-03-23 08:14:08'),(75,'View repartir','web','2024-03-23 08:14:24','2024-03-23 08:14:24'),(76,'update repartir','web','2024-03-23 08:14:40','2024-03-23 08:14:40'),(77,'Delete repartir','web','2024-03-23 08:15:11','2024-03-23 08:15:11'),(78,'View dossier repartir','web','2024-03-23 08:38:09','2024-03-23 08:38:09'),(79,'Create type fichier','web','2024-03-24 13:08:19','2024-03-24 13:08:19'),(80,'View type fichier','web','2024-03-24 13:08:34','2024-03-24 13:08:55'),(81,'Update type fichier','web','2024-03-24 13:09:09','2024-03-24 13:09:09'),(82,'Delete type fichier','web','2024-03-24 13:09:21','2024-03-24 13:09:21'),(83,'Voir dossier','web','2024-03-29 11:38:04','2024-03-29 11:38:04');
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `personal_access_tokens`
--

DROP TABLE IF EXISTS `personal_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `personal_access_tokens` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(255) NOT NULL,
  `tokenable_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `token` varchar(64) NOT NULL,
  `abilities` text DEFAULT NULL,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `personal_access_tokens`
--

LOCK TABLES `personal_access_tokens` WRITE;
/*!40000 ALTER TABLE `personal_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `personal_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `provinces`
--

DROP TABLE IF EXISTS `provinces`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `provinces` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `nom` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `provinces`
--

LOCK TABLES `provinces` WRITE;
/*!40000 ALTER TABLE `provinces` DISABLE KEYS */;
INSERT INTO `provinces` (`id`, `nom`, `created_at`, `updated_at`) VALUES (1,'Bubanza','2024-03-19 08:23:53','2024-03-19 08:23:53'),(2,'Bujumbura Mairie','2024-03-19 08:25:10','2024-03-19 08:25:38');
/*!40000 ALTER TABLE `provinces` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `repartirs`
--

DROP TABLE IF EXISTS `repartirs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `repartirs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `dossier_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `role` varchar(255) NOT NULL,
  `updated_at` date NOT NULL,
  `created_at` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dossier_id` (`dossier_id`,`user_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `repartirs_ibfk_1` FOREIGN KEY (`dossier_id`) REFERENCES `dossiers` (`id`),
  CONSTRAINT `repartirs_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `repartirs`
--

LOCK TABLES `repartirs` WRITE;
/*!40000 ALTER TABLE `repartirs` DISABLE KEYS */;
INSERT INTO `repartirs` (`id`, `dossier_id`, `user_id`, `role`, `updated_at`, `created_at`) VALUES (1,42,30,'Mise en état','2024-03-23','2024-03-23'),(2,43,31,'Préparation de l’audience','2024-03-23','2024-03-23');
/*!40000 ALTER TABLE `repartirs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_has_permissions`
--

DROP TABLE IF EXISTS `role_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `role_has_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL,
  `role_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`),
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_has_permissions`
--

LOCK TABLES `role_has_permissions` WRITE;
/*!40000 ALTER TABLE `role_has_permissions` DISABLE KEYS */;
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES (11,1),(12,1),(13,1),(14,1),(15,1),(16,1),(17,1),(18,1),(19,1),(20,1),(21,1),(22,1),(23,1),(23,3),(23,4),(23,7),(24,1),(24,2),(24,3),(24,4),(24,5),(24,6),(24,7),(24,8),(25,1),(25,3),(25,4),(25,6),(25,7),(26,1),(26,6),(27,1),(28,1),(28,2),(28,3),(28,4),(28,5),(28,6),(28,7),(28,8),(29,1),(30,1),(31,1),(32,1),(32,2),(32,3),(32,4),(32,5),(32,6),(32,7),(32,8),(33,1),(34,1),(35,1),(36,1),(36,2),(36,3),(36,4),(36,5),(36,7),(36,8),(37,1),(38,1),(39,1),(39,3),(39,4),(39,7),(40,1),(40,2),(40,3),(40,4),(40,5),(40,6),(40,7),(40,8),(41,1),(41,3),(41,4),(41,7),(42,1),(43,1),(44,1),(44,2),(45,1),(46,1),(47,1),(47,2),(47,5),(48,1),(48,2),(48,3),(48,4),(48,5),(48,6),(49,1),(49,2),(49,5),(50,1),(50,2),(51,1),(52,1),(53,1),(54,1),(55,2),(56,2),(57,2),(58,2),(59,3),(60,3),(61,3),(62,3),(63,3),(63,6),(64,2),(64,3),(64,4),(64,6),(65,3),(65,6),(66,3),(67,2),(67,3),(67,4),(67,5),(67,7),(67,8),(68,3),(68,4),(68,6),(68,7),(69,6),(69,8),(70,6),(70,8),(71,8),(72,8),(73,6),(74,6),(75,6),(76,6),(77,6),(79,1),(80,1),(81,1),(82,1),(83,2);
/*!40000 ALTER TABLE `role_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `roles` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `guard_name` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_name_guard_name_unique` (`name`,`guard_name`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roles`
--

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES (1,'Admin','web',NULL,NULL),(2,'Président','web',NULL,NULL),(3,'Greffier','web',NULL,NULL),(4,'Greffier Caissier','web',NULL,NULL),(5,'Juge','web','2024-03-21 13:49:35','2024-03-21 13:49:35'),(6,'Procureur','web','2024-03-21 20:10:35','2024-03-21 20:10:35'),(7,'Secrétaire','web','2024-03-21 20:10:51','2024-03-21 20:10:51'),(8,'OMP','web','2024-03-21 20:11:02','2024-03-21 20:11:02');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfert_dossiers`
--

DROP TABLE IF EXISTS `transfert_dossiers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transfert_dossiers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `jur_parquet_id` bigint(20) unsigned NOT NULL,
  `dossier_id` bigint(20) unsigned NOT NULL,
  `juridiction_parquet_id` bigint(20) unsigned NOT NULL,
  `dateT` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transfert_dossiers_dossier_id_foreign` (`dossier_id`),
  KEY `transfert_dossiers_juridiction_id_foreign` (`juridiction_parquet_id`),
  KEY `jur_parquet_id` (`jur_parquet_id`),
  CONSTRAINT `transfert_dossiers_dossier_id_foreign` FOREIGN KEY (`dossier_id`) REFERENCES `dossiers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `transfert_dossiers_ibfk_1` FOREIGN KEY (`jur_parquet_id`) REFERENCES `juridiction_parques` (`id`),
  CONSTRAINT `transfert_dossiers_juridiction_id_foreign` FOREIGN KEY (`juridiction_parquet_id`) REFERENCES `juridiction_parques` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfert_dossiers`
--

LOCK TABLES `transfert_dossiers` WRITE;
/*!40000 ALTER TABLE `transfert_dossiers` DISABLE KEYS */;
INSERT INTO `transfert_dossiers` (`id`, `jur_parquet_id`, `dossier_id`, `juridiction_parquet_id`, `dateT`, `created_at`, `updated_at`) VALUES (7,4,39,4,'2024-03-23','2024-03-21 15:08:19','2024-03-21 15:08:19'),(13,3,46,4,'2024-03-26','2024-03-26 17:29:38','2024-03-26 17:29:38'),(14,3,46,6,'2024-03-28','2024-03-26 17:48:04','2024-03-26 17:48:04'),(16,5,43,4,'2024-03-29','2024-03-28 18:45:36','2024-03-28 18:45:36'),(17,3,48,4,'2024-03-28','2024-03-28 19:02:39','2024-03-28 19:02:39');
/*!40000 ALTER TABLE `transfert_dossiers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `type_categorie_dossiers`
--

DROP TABLE IF EXISTS `type_categorie_dossiers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `type_categorie_dossiers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `nom_categorie` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `type_categorie_dossiers`
--

LOCK TABLES `type_categorie_dossiers` WRITE;
/*!40000 ALTER TABLE `type_categorie_dossiers` DISABLE KEYS */;
INSERT INTO `type_categorie_dossiers` (`id`, `nom_categorie`, `created_at`, `updated_at`) VALUES (1,'Penal ss',NULL,'2024-03-30 21:26:17'),(3,'Civil','2024-03-10 16:11:38','2024-03-10 16:11:38'),(4,'VBG','2024-03-10 16:12:37','2024-03-10 16:12:37'),(5,'Mineur en conflit avec la loi','2024-03-10 16:13:30','2024-03-10 16:13:30');
/*!40000 ALTER TABLE `type_categorie_dossiers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `type_dossiers`
--

DROP TABLE IF EXISTS `type_dossiers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `type_dossiers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `nom` varchar(255) NOT NULL,
  `categorie_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type_dossiers_categorie_id_foreign` (`categorie_id`),
  CONSTRAINT `type_dossiers_categorie_id_foreign` FOREIGN KEY (`categorie_id`) REFERENCES `type_categorie_dossiers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `type_dossiers`
--

LOCK TABLES `type_dossiers` WRITE;
/*!40000 ALTER TABLE `type_dossiers` DISABLE KEYS */;
INSERT INTO `type_dossiers` (`id`, `nom`, `categorie_id`, `created_at`, `updated_at`) VALUES (1,'RPA',1,NULL,'2024-03-10 16:54:55'),(3,'RCA',3,'2024-03-10 16:55:23','2024-03-10 16:55:34'),(4,'RC',3,'2024-03-24 17:11:22','2024-03-24 17:11:22'),(5,'RCFA',3,'2024-03-24 17:11:42','2024-03-24 17:11:42'),(6,'RS',3,'2024-03-24 17:12:05','2024-03-24 17:13:24'),(7,'ROA',3,'2024-03-24 17:12:18','2024-03-24 17:13:39'),(8,'REA',3,'2024-03-24 17:12:30','2024-03-24 17:12:30'),(9,'RO',1,'2024-03-24 17:12:45','2024-03-24 17:12:45'),(10,'RAD',1,'2024-03-24 17:12:56','2024-03-24 17:12:56'),(11,'RP',1,'2024-03-24 17:13:56','2024-03-24 17:13:56'),(12,'RPC',1,'2024-03-24 17:14:10','2024-03-24 17:14:10'),(13,'RMP',1,'2024-03-24 17:14:24','2024-03-24 17:14:24');
/*!40000 ALTER TABLE `type_dossiers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `type_fichiers`
--

DROP TABLE IF EXISTS `type_fichiers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `type_fichiers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `type_fichiers`
--

LOCK TABLES `type_fichiers` WRITE;
/*!40000 ALTER TABLE `type_fichiers` DISABLE KEYS */;
INSERT INTO `type_fichiers` (`id`, `type`, `created_at`, `updated_at`) VALUES (1,'Convocation',NULL,'2024-03-24 13:26:15'),(2,'Quittance','2024-03-08 17:35:10','2024-03-24 13:30:34'),(4,'Document d’entente','2024-03-24 13:32:15','2024-03-24 13:32:15');
/*!40000 ALTER TABLE `type_fichiers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `matricule` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `lastname` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) NOT NULL,
  `contact` varchar(255) NOT NULL,
  `role` varchar(255) DEFAULT NULL,
  `juridiction_parquet_id` bigint(20) unsigned NOT NULL,
  `remember_token` varchar(100) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  UNIQUE KEY `matricule` (`matricule`),
  KEY `juridiction_parquet_id` (`juridiction_parquet_id`),
  CONSTRAINT `users_ibfk_2` FOREIGN KEY (`juridiction_parquet_id`) REFERENCES `juridiction_parques` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` (`id`, `matricule`, `name`, `lastname`, `email`, `email_verified_at`, `password`, `contact`, `role`, `juridiction_parquet_id`, `remember_token`, `created_at`, `updated_at`) VALUES (18,'01207/2428','Admin','Grande Instance','admingrandeinstance@gmail.com',NULL,'$2y$10$c/W1k4oDTeFlvgYWlop35uQgQSfkdb6YS0mpqNztLaTznfnHE7Veu','68519143','Admin',4,'T9lIqt2Dy34gJ1NZLExCKp0ud3wYv7JQ172qGfNl1TM5Q8F6WMajTf35IOOd',NULL,'2024-03-27 17:52:24'),(19,'5443/875','Greffier','Grande Instance','greffiergrandeinstance1@gmail.com',NULL,'$2y$10$c/W1k4oDTeFlvgYWlop35uQgQSfkdb6YS0mpqNztLaTznfnHE7Veu','76987453',NULL,4,NULL,'2024-03-21 13:11:29','2024-03-27 18:03:51'),(22,'32355','Juge1','Grande Instance','jugegrandeinstance1@gmail.com',NULL,'$2y$10$c/W1k4oDTeFlvgYWlop35uQgQSfkdb6YS0mpqNztLaTznfnHE7Veu','55433221',NULL,4,NULL,'2024-03-21 13:53:02','2024-03-27 17:57:38'),(23,'1234500','Président','Grande Instance','presidentgrandeinstance@gmail.com',NULL,'$2y$10$c/W1k4oDTeFlvgYWlop35uQgQSfkdb6YS0mpqNztLaTznfnHE7Veu','465784',NULL,4,NULL,'2024-03-21 13:54:30','2024-03-27 17:41:32'),(24,'2131','Admin','Résidence','adminresidence@gmail.com',NULL,'$2y$10$c/W1k4oDTeFlvgYWlop35uQgQSfkdb6YS0mpqNztLaTznfnHE7Veu','25788735',NULL,3,NULL,'2024-03-21 17:59:04','2024-03-27 17:59:38'),(25,'4453','Président','Résidence','presidentresidence@gmail.com',NULL,'$2y$10$c/W1k4oDTeFlvgYWlop35uQgQSfkdb6YS0mpqNztLaTznfnHE7Veu','6653434',NULL,3,NULL,'2024-03-21 18:01:56','2024-03-27 18:00:55'),(26,'001764','Greffier1','Résidence','greffierresidence1@gmail.com',NULL,'$2y$10$c/W1k4oDTeFlvgYWlop35uQgQSfkdb6YS0mpqNztLaTznfnHE7Veu','426354',NULL,3,NULL,'2024-03-21 18:03:01','2024-03-27 18:07:22'),(27,'3664','Admin','Parquet','adminparquet@gmail.com',NULL,'$2y$10$c/W1k4oDTeFlvgYWlop35uQgQSfkdb6YS0mpqNztLaTznfnHE7Veu','3564',NULL,5,NULL,'2024-03-21 20:09:28','2024-03-27 17:44:58'),(28,'2634873','Procureur','Muyinga','procureurmuyinga@gmail.com',NULL,'$2y$10$c/W1k4oDTeFlvgYWlop35uQgQSfkdb6YS0mpqNztLaTznfnHE7Veu','4563247',NULL,5,'AfZs0mWMjfX70153A1Hz0SJvZaCM9IddrACOBiqhcq0voOdRPGswa31bfQWB','2024-03-21 20:14:31','2024-03-27 17:39:10'),(29,'6754','Secrétaire1','Parquet','secretaireparquet@gmail.com',NULL,'$2y$10$c/W1k4oDTeFlvgYWlop35uQgQSfkdb6YS0mpqNztLaTznfnHE7Veu','2563684',NULL,5,NULL,'2024-03-21 20:15:45','2024-03-27 17:46:42'),(30,'6800098','OMP','Parquet','omp1@gmail.com',NULL,'$2y$10$c/W1k4oDTeFlvgYWlop35uQgQSfkdb6YS0mpqNztLaTznfnHE7Veu','3976374',NULL,5,NULL,'2024-03-21 20:16:58','2024-03-27 18:09:26'),(31,'113/113','OMP','Parquet','omp2@gmail.com',NULL,'$2y$10$c/W1k4oDTeFlvgYWlop35uQgQSfkdb6YS0mpqNztLaTznfnHE7Veu','47685465',NULL,5,NULL,'2024-03-23 16:46:30','2024-03-27 18:16:24'),(32,'5545464/009','Greffier Caissier','Grande Instance','greffiercaissier@gmail.com',NULL,'$2y$10$c/W1k4oDTeFlvgYWlop35uQgQSfkdb6YS0mpqNztLaTznfnHE7Veu','345167156',NULL,4,NULL,'2024-03-24 11:43:56','2024-03-27 18:18:02'),(33,'56561113','Juge2','Grande Instance','jugegrandeinstance2@gmail.com',NULL,'$2y$10$c/W1k4oDTeFlvgYWlop35uQgQSfkdb6YS0mpqNztLaTznfnHE7Veu','11111333',NULL,4,NULL,'2024-03-24 11:45:32','2024-03-27 18:19:20'),(34,'8886634','Juge','Résidence','jugeresidence@gmail.com',NULL,'$2y$10$v2uwMJxAWrrysX6PG8g3HewCQxz6j4Cxqsb7AX7ZEGTWw60Tm/g6W','78665432',NULL,3,NULL,'2024-03-28 19:12:11','2024-03-28 19:12:11');
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `utilisateurs`
--

DROP TABLE IF EXISTS `utilisateurs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `utilisateurs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `matricule` varchar(255) NOT NULL,
  `nom` varchar(255) NOT NULL,
  `prenom` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `contact` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `juridiction_id` bigint(20) unsigned NOT NULL,
  `remember_token` varchar(100) DEFAULT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `utilisateurs_matricule_unique` (`matricule`),
  UNIQUE KEY `utilisateurs_email_unique` (`email`),
  KEY `utilisateurs_juridiction_id_foreign` (`juridiction_id`),
  CONSTRAINT `utilisateurs_juridiction_id_foreign` FOREIGN KEY (`juridiction_id`) REFERENCES `juridictions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `utilisateurs`
--

LOCK TABLES `utilisateurs` WRITE;
/*!40000 ALTER TABLE `utilisateurs` DISABLE KEYS */;
/*!40000 ALTER TABLE `utilisateurs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `validers`
--

DROP TABLE IF EXISTS `validers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `validers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `commentaire_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `avis` varchar(255) NOT NULL,
  `updated_at` date NOT NULL,
  `created_at` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `commentaire_id` (`commentaire_id`,`user_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `validers_ibfk_1` FOREIGN KEY (`commentaire_id`) REFERENCES `commentaires` (`id`),
  CONSTRAINT `validers_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `validers`
--

LOCK TABLES `validers` WRITE;
/*!40000 ALTER TABLE `validers` DISABLE KEYS */;
INSERT INTO `validers` (`id`, `commentaire_id`, `user_id`, `avis`, `updated_at`, `created_at`) VALUES (1,1,28,'classement sans suite','2024-03-23','2024-03-23'),(2,1,28,'poursuite des enquêtes','2024-03-23','2024-03-23'),(3,1,28,'classement sans suite','2024-03-23','2024-03-23'),(4,1,28,'poursuite des enquêtes','2024-03-23','2024-03-23'),(5,1,28,'fixation','2024-03-23','2024-03-23'),(6,1,28,'fixation','2024-03-23','2024-03-23'),(7,4,28,'classement sans suite','2024-03-25','2024-03-25'),(8,4,28,'fixation','2024-03-25','2024-03-25'),(9,1,28,'poursuite des enquêtes','2024-03-26','2024-03-26'),(10,1,28,'fixation','2024-03-26','2024-03-26'),(11,5,28,'poursuite des enquêtes','2024-03-27','2024-03-27'),(12,5,28,'poursuite des enquêtes','2024-03-28','2024-03-28');
/*!40000 ALTER TABLE `validers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping events for database 'vsfgrsgqeqrgh_justice'
--

--
-- Dumping routines for database 'vsfgrsgqeqrgh_justice'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2024-12-10  3:23:11
