<x-app-layout>
<main id="main" class="main">

<div class="pagetitle">
<h1 class="card-title">Utilisateur</h1>  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Table de bord</a></li>
      <li class="breadcrumb-item">Tables</li>
      <li class="breadcrumb-item active">General</li>
    </ol>
  </nav>
</div><!-- End Page Title -->

<section class="section">
@if ($errors->has('delete_error'))
    <div class="alert alert-danger">
    <i class="ri-alert-fill"></i> {{ $errors->first('delete_error') }}
    </div>
@endif
@if(session('success'))
    <div class="alert alert-success">
      <i class="ri-alert-fill"></i> {{ session('success') }}
    </div>
@endif
<div class="row">
                <div class="col-lg-4">
                    <div class="form-group">
                        <input type="search" id="myInput" class="form-control" placeholder="Search ..." onkeyup="myFunction()">
                    </div>
                </div>

                <div class="col-auto text-end float-end ms-auto download-grp">
                @include('role-permission.nav-links')
                    <a href="{{ route('users.create') }}" class="btn btn-primary mx-3"><i class="bi bi-plus"></i>Nouveau Utilisateur</a>
                </div>
                
            </div><br>
  <div class="row">
    <div class="col-lg-12">

      <div class="card">
        <div class="page-header">
            <div class="row align-items-center">
                <div class="col">
                    <center><h1 class="card-title">Liste des utilisateurs</h1></center>
                                </div>
            </div>
        </div>
        <div class="table-responsive">
          
          
          
          <table  class="table table-hover">
          <thead>
              <tr>
                <th>Id</th>
                <th>Profile</th>
                <th>Nom</th>
                <th>Email</th>
                <th>Rôle</th>
                <th colspan="2">Actions</th>
              </tr>
            </thead>
            <tbody id="myTable">
            @if($users->isNotEmpty())
            <?php $cnt=1; ?>
            @foreach($users as $user)
               
               <tr>
                    <td>{{ $cnt}}</td>
                    <td><img src="/assets/img/NO-IMAGE-AVAILABLE.jpg" alt="Profile" class="rounded-circle" width="50"></td>
                    <td>{{ $user->name}} {{ $user->lastname}}</td>
                    <td>{{ $user->email}}</td>
                    <td>
                      @if (!empty($user->getRoleNames()))
                      @foreach($user->getRoleNames() as $rolename)
                      <label class="badge bg-primary mx-1">{{ $rolename }}</label>
                      @endforeach
                      @endif
                    </td>
                    <td>
                        <div>
                        <a href="{{ route('users.edit', $user->id) }}" class="btn btn-warning"><i class="bi bi-pencil-square"></i></a>
                                <td>
                                <a href="{{ url('users/'.$user->id.'/delete') }}" onclick="return confirm('Vous voulez supprimer ça?')" class="btn btn-danger mx-2"><i class="bi bi-trash-fill"></i></a>
                        </div>
                    </td>
                </tr>
                
                <?php $cnt++; ?>
            @endforeach
            @else
                <tr>
                    <td colspan="4"><center>Not found</center></td>
                </tr>
            @endif
            </tbody>
          </table>
          {{$users->links('pagination::bootstrap-4')}}

        </div>
      </div>

    </div>
  </div>
</section>

</main>
          
</x-app-layout>
