@php
    use App\Models\User;
@endphp
<x-app-layout>
<main id="main" class="main">

<div class="pagetitle">
  <h1>Page de création</h1>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="{{route('users.index')}}">Accueil</a></li>
      <li class="breadcrumb-item">Forms</li>
      <li class="breadcrumb-item active">Mise en page</li>
    </ol>
  </nav>
</div><!-- End Page Title -->
<section class="section">
@if ($errors->has('delete_error'))
    <div class="alert alert-danger">
    <i class="ri-alert-fill"></i> {{ $errors->first('delete_error') }}
    </div>
@endif
@if(session('success'))
    <div class="alert alert-success">
      <i class="ri-alert-fill"></i> {{ session('success') }}
    </div>
@endif
  <div class="row">
    <div class="col-lg-12">

      <div class="card">
        <div class="card-body">
          <h5 class="card-title">Page de création</h5>

          <!-- Horizontal Form -->
          <form method="POST" action="{{ route('users.store') }}">
          @csrf
          <center>
                <div class="row mb-3 col-sm-6">
                  <label for="matricule" class="col-sm-6 col-form-label">Matricule</label>
                  
                    <input id="matricule" type="text" class="form-control" name="matricule" required autocomplete="matricule" autofocus placeholder="">
                  
                </div>

                <div class="row mb-3 col-sm-6">
                  <label for="name" class="col-sm-6 col-form-label">Nom</label>
                  
                    <input id="name" type="text" class="form-control" name="name" required autocomplete="name" autofocus placeholder="">
                  
                </div>

                <div class="row mb-3 col-sm-6">
                  <label for="name" class="col-sm-6 col-form-label">Prénom</label>
                  
                    <input id="name" type="text" class="form-control" name="lastname" required autocomplete="lastname" autofocus placeholder="">
                  
                </div>

                <!-- <div class="row mb-3 col-sm-6">
                  <label for="name" class="col-sm-6 col-form-label">Photo</label>
                  
                    <input id="name" type="file" class="form-control" name="photo" autocomplete="photo" autofocus placeholder="">
                  
                </div> -->

                <div class="row mb-3 col-sm-6">
                  <label for="email" class="col-sm-6 col-form-label">Email</label>
                  
                    <input id="email" type="email" class="form-control" name="email" required autocomplete="email" autofocus placeholder="">
                  
                </div>

                <div class="row mb-3 col-sm-6">
                  <label for="contact" class="col-sm-6 col-form-label">Contact</label>
                  
                    <input id="contact" type="text" class="form-control" name="contact" required autocomplete="contact" autofocus placeholder="+257 65 453 432">
                  
                </div>                

                <div class="row mb-3 col-sm-6">
                  <label for="cours" class="col-sm-6 col-form-label">Rôle</label>
                  
                    <select name ="roles[]" class="form-control" multiple>
                      <option selected disabled>Choisisser le rôle</option>
                     @foreach($roles as $role)
                      <option value="{{$role}}">{{$role}}</option>
                     @endforeach
                      
                    </select>
                  
                </div>
                

                

               

                <div class="row mb-3 col-sm-6">
                  <label for="password" class="col-sm-6 col-form-label">Mot de passe</label>
                  
                    <input id="password" type="password" class="form-control" name="password" required autocomplete="new-password" autofocus placeholder="">
                  
                </div>
                <div class="row mb-3 col-sm-6">
                  <label for="email" class="col-sm-6 col-form-label">Confirme le mot de passe</label>
                  
                    <input id="password" type="password" class="form-control" name="password_confirmation" required autocomplete="new-password" autofocus placeholder="">
                  
                </div>
                
                <div class="text-center">
                  <button type="submit" class="badge bg-primary p-2 ms-6">Soumettre</button>
                  <button type="reset" class="badge bg-secondary p-2 ms-6">Réinitialiser</button>
                </div>
                </center>
          </form>

        </div>
      </div>

      </div>

    
  </div>
</section>

</main>

       
</x-app-layout>
