<x-app-layout>
<main id="main" class="main">



<div class="pagetitle">
<h1 class="card-title">Type des dossiers</h1>  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="#">Table de bord</a></li>
      <li class="breadcrumb-item">Tables</li>
      <li class="breadcrumb-item active">General</li>
    </ol>
  </nav>
</div>

<section class="section">
@if ($errors->has('delete_error'))
    <div class="alert alert-danger">
    <i class="ri-alert-fill"></i> {{ $errors->first('delete_error') }}
    </div>
@endif
@if(session('success'))
    <div class="alert alert-success">
      <i class="ri-alert-fill"></i> {{ session('success') }}
    </div>
@endif
  
  <div class="row">
    <div class="col-lg-4">
        <div class="form-group">
            <input type="search" id="myInput" class="form-control" placeholder="Search ..." onkeyup="myFunction()">
        </div>
    </div>

    <div class="col-auto text-end float-end ms-auto download-grp">
        
        <a href="{{route('typeDossiers.create')}}" class="btn btn-primary"><i class="bi bi-plus"></i> Nouveau type dossier</a>
    </div>
    
  </div><br>
  
  <div class="row">
    <div class="col-lg-12">

      

      <div class="card">
      <div class="page-header">
            <div class="row align-items-center">
                <div class="col">
                    <center><h1 class="card-title">Types des dossiers</h1></center>
                </div>
            </div>
        </div>

          <!-- Table with hoverable rows -->
          <table class="table table-hover">
            <thead>
              <tr>
                <th scope="col">#</th>
                <th scope="col">Nom</th>
                <th scope="col">Categorie</th>
                <th colspan="2">Actions</th>
              </tr>
            </thead>
            <tbody id="myTable">
            @foreach($typedossiers as $typedossier)
              <tr>
                <td>{{$typedossier->id}}</td>
                <th scope="row">{{$typedossier->nom}}</th>
                <th scope="row">{{$typedossier->nom_categorie}}</th>
                <td>
                  <div>
                    @can('Update type dossier')
                    <a href="{{ route('typeDossiers.edit', $typedossier->id) }}" class="badge bg-warning"><i class="bi bi-pencil-square"></i></a></td>
                    @endcan      
                    <td>
                      @can('Delete type dossier')
                          <form action="{{route('typeDossiers.destroy', $typedossier->id)}}" method="POST">
                            @csrf
                            @method('DELETE')
                          <button type="submit" onclick="return confirm('Vous voulez supprimer ça?')" class="badge bg-danger"><i class="bi bi-trash-fill"></i></button>
                          </form>
                          @endcan
                  </div>
                </td>
              </tr>
            @endforeach
            </tbody>
          </table>
          {{$typedossiers->links('pagination::bootstrap-4')}}

        </div>
      </div>

      

    </div>
  </div>
</section>

</main>
</x-app-layout>