<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Notification;
use App\Models\Dossier;
use App\Models\User;

class DossierAjouterNotification extends Notification
{
    use Queueable;

    protected $dossier;

    /**
     * Create a new notification instance.
     *
     * @return void
     */

     

    public function __construct($numero)
    {
        $this->numero = $numero;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['database'];
    }

    
    public function toArray($notifiable)
    {
        return [
            'message' => 'Un nouveau Dossier a été enregistré.',
            'name' => $this->numero,
        ];
    }
}
