<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable, HasRoles;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'matricule',
        'name',
        'lastname',
        'email',
        'password',
        'contact',
        'role',
        'juridiction_parquet_id',
    ];

    public function role()
    {
        return $this->belongsTo(Role::class);
    }

    public function juridictionParquet()
    {
        return $this->belongsTo(JuridictionParque::class);
    }

    public function juge()
    {
        return $this->hasMany(Juge::class);
    }

    public function repartir()
    {
        return $this->hasMany(Repartir::class);
    }

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];
}
