<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class JuridictionParque extends Model
{
    use HasFactory;

    protected $fillable = [
        'nom',
        'province',
        'commune', 
    ];

    public function user()
    {
        return $this->hasMany(User::class);
    }

    public function province()
    {
        return $this->belongsTo(Province::class);
    }



    public static $provinces = [
        'Bubanza',
        'Bujumbura Mairie',
        'Bujumbura Rurale',
        'Bururi',
        'Cankuzo',
        'Cibitoke',
        'Gitega',
        'Karuzi',
        'Kayanza',
        'Kirundo',
        'Makamba',
        'Muramvya',
        'Muyinga',
        'Mwaro',
        'Ngozi',
        'Rumonge',
        'Rutana',
        'Ruyigi',
    ];

    public static $communes = [
        'Bubanza' => [
            'Bubanza',
            'Gihanga',
            'Musigati',
            'Mpanda',
            'Rugazi',
        ],
        'Bujumbura Mairie' => [
            'Muha',
            'Mukaza',
            'Ntahangwa',
        ],
        'Bujumbura Rurale' => [
            'Isare',
            'Kabezi',
            'Kanyosha (Bujumbura rural)',
            'Mubimbi',
            'Mugongomanga',
            'Mukike',
            'Mutambu',
            'Mutimbuzi',
            'Nyabiraba',
        ],
        'Bururi' => [
            'Bururi',
            'Matana',
            'Mugamba',
            'Rutovu',
            'Songa',
            'Vyanda',
        ],
        'Cankuzo' => [
            'Cankuzo',
            'Cendajuru',
            'Gisagara',
            'Kigamba',
            'Mishiha',
        ],
        'Cibitoke' => [
            'Buganda',
            'Bukinanyana',
            'Mabayi',
            'Mugina',
            'Murwi',
            'Rugombo',
        ],
        'Gitega' => [
            'Bugendana',
            'Bukirasazi',
            'Buraza',
            'Giheta',
            'Gishubi',
            'Gitega',
            'Itaba',
            'Makebuko',
            'Mutaho',
            'Nyarusange',
            'Ryansoro',
        ],
        'Karuzi' => [
            'Bugenyuzi',
            'Buhiga',
            'Gihogazi',
            'Gitaramuka',
            'Mutumba',
            'Nyabikere',
            'Shombo',
        ],
        'Kayanza' => [
            'Butaganzwa',
            'Gahombo',
            'Gatara',
            'Kabarore',
            'Kayanza',
            'Matongo',
            'Muhanga',
            'Muruta',
            'Rango',
        ],
        'Kirundo' => [
            'Bugabira',
            'Busoni',
            'Bwambarangwe',
            'Gitobe',
            'Kirundo',
            'Ntega',
            'Vumbi',
        ],
        'Makamba' => [
            'Kayogoro',
            'Kibago',
            'Mabanda',
            'Makamba',
            'Nyanza-Lac',
            'Vugizo',
        ],
        'Muramvya' => [
            'Bukeye',
            'Kiganda',
            'Mbuye',
            'Muramvya',
            'Rutegama',
        ],
        'Muyinga' => [
            'Buhinyuza',
            'Butihinda',
            'Gashoho',
            'Gasorwe',
            'Giteranyi',
            'Muyinga',
            'Mwakiro',
        ],
        'Mwaro' => [
            'Bisoro',
            'Gisozi',
            'Kayokwe',
            'Ndava',
            'Nyabihanga',
            'Rusaka',
        ],
        'Ngozi' => [
            'Busiga',
            'Gashikanwa',
            'Kiremba',
            'Marangara',
            'Mwumba',
            'Ngozi',
            'Nyamurenza',
            'Ruhororo',
            'Tangara',
        ],
        'Rumonge' => [
            'Bugarama',
            'Burambi',
            'Buyengero',
            'Muhuta',
            'Rumonge',
        ],
        'Rutana' => [
            'Bukemba',
            'Giharo',
            'Gitanga',
            'Mpinga-Kayove',
            'Musongati',
            'Rutana',
        ],
        'Ruyigi' => [
            'Butaganzwa',
            'Butezi',
            'Bweru',
            'Gisuru',
            'Kinyinya',
            'Nyabitsinda',
            'Ruyigi',
        ],
    ];

    public static function getCommunesByProvince($province)
    {
        return self::$communes[$province] ?? [];
    }

}
