<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Juridiction extends Model
{
    use HasFactory;
    protected $fillable = [
        'nom', 
        'juridiction_parquet_id',
        'province_id',
    ];

    public function juridiction_parquet()
    {
        return $this->belongsTo(JuridictionParque::class);
    }

    public function province()
    {
        return $this->belongsTo(Province::class);
    }

    public function audience()
    {
        return $this->hasMany(Audience::class);
    }

    public function dossier()
    {
        return $this->hasMany(Dossier::class);
    }

    public function jugement()
    {
        return $this->hasMany(Jugement::class);
    }
}
