<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\TypeDossier;
use App\Models\User;
use App\Events\DossierAjouterEvent;

class Dossier extends Model
{
    use HasFactory;
    protected $fillable = [
        'numero',
        'niveau_id',
        'type_dossier_id',
        'etat_id',
        'user_id',
    ];

    public function niveau()
    {
        return $this->belongsTo(Niveau::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function typeDossier()
    {
        return $this->belongsTo(TypeDossier::class);
    }

    public function etat()
    {
        return $this->belongsTo(EtatDossier::class);
    }

    public function audience()
    {
        return $this->hasMany(Audience::class);
    }


    public function jugement()
    {
        return $this->hasMany(Jugement::class);
    }

    public function fichiers()
    {
        return $this->hasMany(Fichier::class);
    }

    public function juge()
    {
        return $this->hasMany(Juge::class);
    }

    public function repartir()
    {
        return $this->hasMany(Repartir::class);
    }

    public static function boot()
    {
        parent::boot();

        self::created(function ($dossier){
            event(new DossierAjouterEvent($dossier));
        });
    }

}
