<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Audience extends Model
{
    use HasFactory;
    protected $fillable = [
        'date',
        'juridiction_id',
        'description',
        'dossier_id',
    ];

    public function juridiction_parquet()
    {
        return $this->belongsTo(JuridictionParque::class);
    }

    public function dossier()
    {
        return $this->belongsTo(Dossier::class);
    }
}
