<x-app-layout>
<main id="main" class="main">

<div class="pagetitle">
  <h1>General Tables</h1>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="{{route('etatdossiers.index')}}">Table de bord</a></li>
      <li class="breadcrumb-item">Tables</li>
      <li class="breadcrumb-item active">General</li>
    </ol>
  </nav>
</div><!-- End Page Title -->

<section class="section">
@if ($errors->has('delete_error'))
    <div class="alert alert-danger">
    <i class="ri-alert-fill"></i> {{ $errors->first('delete_error') }}
    </div>
@endif
@if(session('success'))
    <div class="alert alert-success">
      <i class="ri-alert-fill"></i> {{ session('success') }}
    </div>
@endif
  
  <div class="row">
  <div class="col-lg-4">
    <form method="GET" action="{{ route('affecters.index') }}">
    <div class="form-group d-flex">
        <input type="search" name="search" class="form-control" placeholder="recherche ...">
        <button type="submit" class="badge bg-primary p-2 ms-2" title="Recherche"><i class="bi bi-search"></i></button>&nbsp;&nbsp;
        <a href="{{ route('affecters.index') }}" class="btn btn-success" title="Actualiser"><i class="bi bi-arrow-repeat"></i></a>
    </div>
    </form>
    </div>

    <div class="col-auto text-end float-end ms-auto download-grp">
        
        <a href="{{route('jugements.create')}}" class="btn btn-primary"><i class="bi bi-plus"></i> Nouveau Jugement</a>
    </div>
    
  </div><br>
  
  <div class="row">
    <div class="col-lg-12">

      

      <div class="card">
        <div class="card-body">
          <h5 class="card-title">Liste des jugements</h5>

          <!-- Table with hoverable rows -->
          <table class="table table-hover">
            <thead>
              <tr>
                <th scope="col">#</th>
                <th scope="col">Description</th>
                <th scope="col">Juridiction</th>
                <th scope="col">Dossier</th>
                <th colspan="2">Actions</th>
              </tr>
            </thead>
            <tbody id="myTable">
            @foreach($jugements as $jugement)
              <tr>
                <td>{{$jugement->id}}</td>
                <th scope="row">{{$jugement->description}}</th>
                <th scope="row">{{$jugement->juridiction->nom}}</th>
                <th scope="row">{{$jugement->dossier->numero}}</th>
                <td> <a href="#">Voir farde</a></td>
                <td> <a href="#">Ajouter fichier</a></td>
              </tr>
            @endforeach
            </tbody>
          </table>
          <!-- End Table with hoverable rows -->

        </div>
      </div>

      

    </div>
  </div>
</section>

</main>
</x-app-layout>