<x-app-layout>
<main id="main" class="main">

<div class="col-auto text-end float-end ms-auto download-grp">
  <a href="{{ route('dossiers.index') }}" class="btn btn-success float-end"><i class="bi bi-arrow-left-square-fill"></i> Retour</a>
</div>

<div class="pagetitle">
<h1 class="card-title">Les documents</h1>  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="#">Table de bord</a></li>
      <li class="breadcrumb-item">Forms</li>
      <li class="breadcrumb-item active">Mise en page</li>
    </ol>
  </nav>
</div>

<section class="section">
@if ($errors->has('delete_error'))
    <div class="alert alert-danger">
    <i class="ri-alert-fill"></i> {{ $errors->first('delete_error') }}
    </div>
@endif
@if(session('success'))
    <div class="alert alert-success">
      <i class="ri-alert-fill"></i> {{ session('success') }}
    </div>
@endif
  
  <div class="row">
    <div class="col-lg-4">
        <div class="form-group">
            <input type="search" id="myInput" class="form-control" placeholder="Search ..." onkeyup="myFunction()">
        </div>
    </div>

    <div class="col-auto text-end float-end ms-auto download-grp">
        @can('Create fichier')
        <a href="{{ route('fichiers.create', ['dossier_id' => $dossier->id]) }}" class="btn btn-primary"><i class="bi bi-plus"></i> Nouveau Fichier</a>
        @endcan
    </div>
    
  </div><br>
  
  <div class="row">
    <div class="col-lg-12">

      

      <div class="card">
        <div class="page-header">
            <div class="row align-items-center">
                <div class="col">
                    <center><h1 class="card-title">Les fichiers</h1></center>
                </div>
            </div>
        </div>
        <div class="table-responsive">

          <!-- Table with hoverable rows -->
          <table class="table table-hover">
            <thead>
              <tr>
                <th scope="col">#</th>
                <th scope="col">Type</th>
                <th scope="col">Fichier</th>
                <th colspan="2">Actions</th>
              </tr>
            </thead>
            <tbody id="myTable">
            @foreach($fichiers as $fichier)
              <tr>
                <td>{{$fichier->id}}</td>
                <th scope="row">{{$fichier->type_fichier->type}}</th>
                <td>
                    <a href="{{ asset('assets/tousfichiers/' . $fichier->lien) }}" target="_blank">
                        {{ $fichier->lien }}
                    </a>
                </td> 
                <td>
                  @can('Update fichier') 
                <a href="{{ route('fichiers.edit', $fichier->id) }}" class="badge bg-warning" title="Modifier fichier"><i class="bi bi-pencil-square"></i></a>
                  @endcan
                </td>
               
              </tr>
            @endforeach
            </tbody>
          </table>
          <!-- End Table with hoverable rows -->

        </div>
      </div>

      

    </div>
  </div>
</section>

</main>
</x-app-layout>