<x-app-layout>
@if(auth()->check() && auth()->user()->juridictionParquet->nom == 'Grande Instance' || auth()->check() && auth()->user()->juridictionParquet->nom == 'Résidence')
<main id="main" class="main">

<div class="pagetitle">
  <h1>Table de bord</h1>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="">Table de bord</a></li>
      <li class="breadcrumb-item active">General</li>
    </ol>
  </nav>
</div><!-- End Page Title -->

<section class="section dashboard">
  <div class="row">

    <!-- Left side columns -->
    <div class="col-lg-8">
      <div class="row">

        <!-- Sales Card -->
        <div class="col-xxl-4 col-md-6">
          <div class="card info-card sales-card">

            <div class="filter">
              <a class="icon" href="#" data-bs-toggle="dropdown"><i class="bi bi-three-dots"></i></a>
              
            </div>

            <div class="card-body">
              <h5 class="card-title">Juges</h5>

              <div class="d-flex align-items-center">
                <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                  <i class="bx bxs-graduation"></i>
                </div>
                <div class="ps-3">
                  <h6>{{$juges}}</h6>
                   

                </div>
              </div>
            </div>

          </div>
        </div><!-- End Sales Card -->

        <!-- Revenue Card -->
        <div class="col-xxl-4 col-md-6">
          <div class="card info-card revenue-card">

            <div class="filter">
              <a class="icon" href="#" data-bs-toggle="dropdown"><i class="bi bi-three-dots"></i></a>
              
            </div>

            <div class="card-body">
              <h5 class="card-title">Greffier</h5>

              <div class="d-flex align-items-center">
                <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                  <i class="bi bi-person-circle"></i>
                </div>
                <div class="ps-3">
                  <h6>{{$greffiers}}</h6>
                  

                </div>
              </div>
            </div>

          </div>
        </div><!-- End Revenue Card -->

        <!-- Customers Card -->
        <div class="col-xxl-4 col-xl-12">

          <div class="card info-card customers-card">

            <div class="filter">
              <a class="icon" href="#" data-bs-toggle="dropdown"><i class="bi bi-three-dots"></i></a>
              
            </div>

            <div class="card-body">
              <h5 class="card-title">Greffier Caissier</h5>

              <div class="d-flex align-items-center">
                <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                  <i class="bi bi-people"></i>
                </div>
                <div class="ps-3">
                  <h6>{{$greffierCai}}</h6>
                  

                </div>
              </div>

            </div>
          </div>

        </div><!-- End Customers Card -->

        

        <!-- Recent Sales -->
        <div class="col-12">
          <div class="card recent-sales overflow-auto">

            <div class="filter">
              <a class="icon" href="#" data-bs-toggle="dropdown"><i class="bi bi-three-dots"></i></a>
              
            </div>

            <div class="card-body">
              <h5 class="card-title">Dossiers Recents</h5>

              <table class="table table-hover">
                <thead>
                  <tr>
                    <th scope="col">Numèro</th>
                    <th scope="col">Etat</th>
                    <th scope="col">Type Dossier</th>
                  </tr>
                </thead>
                <tbody>
                  @foreach($dossiers as $dossier)
                  <tr>
                    <td scope="col">{{$dossier->type}} {{$dossier->numero}}</td>
                    <td scope="col">{{$dossier->nomEta}}</td>
                    <td scope="col">{{$dossier->categorie}}</td>
                    
                  </tr>
                  @endforeach
                </tbody>
              </table>

            </div>

          </div>
        </div><!-- End Recent Sales -->

        

      </div>
    </div><!-- End Left side columns -->

    <!-- Right side columns -->
    <div class="col-lg-4">

      

      

      <!-- Website Traffic -->
      <div class="card">
        <div class="filter">
          <a class="icon" href="#" data-bs-toggle="dropdown"><i class="bi bi-three-dots"></i></a>
          
        </div>

        <div class="card-body pb-0">
          <h5 class="card-title">Etat des Dossiers</h5>

          <div id="trafficChart" style="min-height: 400px;" class="echart"></div>

          <script>
            document.addEventListener("DOMContentLoaded", () => {
              echarts.init(document.querySelector("#trafficChart")).setOption({
                tooltip: {
                  trigger: 'item'
                },
                legend: {
                  top: '5%',
                  left: 'center'
                },
                series: [{
                  name: 'Dossiers',
                  type: 'pie',
                  radius: ['40%', '70%'],
                  avoidLabelOverlap: false,
                  label: {
                    show: false,
                    position: 'center'
                  },
                  emphasis: {
                    label: {
                      show: true,
                      fontSize: '18',
                      fontWeight: 'bold'
                    }
                  },
                  labelLine: {
                    show: false
                  },
                  data: [{
                      value: {{$dossEn}},
                      name: 'En cours'
                    },
                    {
                      value: {{$dossAp}},
                      name: 'En appels'
                    },
                    {
                      value: {{$dossJu}},
                      name: 'Jugés'
                    },
                    {
                      value: {{$dossEx}},
                      name: 'Exécutés'
                    }
                  ]
                }]
              });
            });
          </script>

        </div>
      </div><!-- End Website Traffic -->

      

    </div><!-- End Right side columns -->

  </div>
</section>

</main>


@endif

@if(auth()->check() && auth()->user()->juridictionParquet->nom == 'Parquet')
<main id="main" class="main">

<div class="pagetitle">
  <h1>Table de bord</h1>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="">Table de bord</a></li>
      <li class="breadcrumb-item active">General</li>
    </ol>
  </nav>
</div><!-- End Page Title -->

<section class="section dashboard">
  <div class="row">

    <!-- Left side columns -->
    <div class="col-lg-8">
      <div class="row">

        <!-- Sales Card -->
        <div class="col-xxl-4 col-md-6">
          <div class="card info-card sales-card">

            <div class="filter">
              <a class="icon" href="#" data-bs-toggle="dropdown"><i class="bi bi-three-dots"></i></a>
              
            </div>

            <div class="card-body">
              <h5 class="card-title">OMP</h5>

              <div class="d-flex align-items-center">
                <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                  <i class="bx bxs-graduation"></i>
                </div>
                <div class="ps-3">
                  <h6>{{$omps}}</h6>
                   

                </div>
              </div>
            </div>

          </div>
        </div><!-- End Sales Card -->

        <!-- Revenue Card -->
        <div class="col-xxl-4 col-md-6">
          <div class="card info-card revenue-card">

            <div class="filter">
              <a class="icon" href="#" data-bs-toggle="dropdown"><i class="bi bi-three-dots"></i></a>
              
            </div>

            <div class="card-body">
              <h5 class="card-title">Secrétaires</h5>

              <div class="d-flex align-items-center">
                <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                  <i class="bi bi-person-circle"></i>
                </div>
                <div class="ps-3">
                  <h6>{{$secre}}</h6>
                  

                </div>
              </div>
            </div>

          </div>
        </div><!-- End Revenue Card -->

        

        

        <!-- Recent Sales -->
        <div class="col-12">
          <div class="card recent-sales overflow-auto">

            <div class="filter">
              <a class="icon" href="#" data-bs-toggle="dropdown"><i class="bi bi-three-dots"></i></a>
              
            </div>

            <div class="card-body">
              <h5 class="card-title">Dossiers Recents</h5>

              <table class="table table-hover">
                <thead>
                  <tr>
                    <th scope="col">Numèro</th>
                    <th scope="col">Etat</th>
                    <th scope="col">Type Dossier</th>
                  </tr>
                </thead>
                <tbody>
                  @foreach($dossiers as $dossier)
                  <tr>
                    <td scope="col">{{$dossier->type}} {{$dossier->numero}}</td>
                    <td scope="col">{{$dossier->nomEta}}</td>
                    <td scope="col">{{$dossier->categorie}}</td>
                    
                  </tr>
                  @endforeach
                </tbody>
              </table>

            </div>

          </div>
        </div><!-- End Recent Sales -->

        

      </div>
    </div><!-- End Left side columns -->

    <!-- Right side columns -->
    <div class="col-lg-4">

      

      

      <!-- Website Traffic -->
      <div class="card">
        <div class="filter">
          <a class="icon" href="#" data-bs-toggle="dropdown"><i class="bi bi-three-dots"></i></a>
          
        </div>

        <div class="card-body pb-0">
          <h5 class="card-title">Etat des Dossiers</h5>

          <div id="trafficChart" style="min-height: 400px;" class="echart"></div>

          <script>
            document.addEventListener("DOMContentLoaded", () => {
              echarts.init(document.querySelector("#trafficChart")).setOption({
                tooltip: {
                  trigger: 'item'
                },
                legend: {
                  top: '5%',
                  left: 'center'
                },
                series: [{
                  name: 'Dossiers',
                  type: 'pie',
                  radius: ['40%', '70%'],
                  avoidLabelOverlap: false,
                  label: {
                    show: false,
                    position: 'center'
                  },
                  emphasis: {
                    label: {
                      show: true,
                      fontSize: '18',
                      fontWeight: 'bold'
                    }
                  },
                  labelLine: {
                    show: false
                  },
                  data: [{
                      value: {{$dossEn}},
                      name: 'En cours'
                    },
                    {
                      value: {{$dossAp}},
                      name: 'En appels'
                    },
                    {
                      value: {{$dossJu}},
                      name: 'Jugés'
                    },
                    {
                      value: {{$dossEx}},
                      name: 'Exécutés'
                    }
                  ]
                }]
              });
            });
          </script>

        </div>
      </div><!-- End Website Traffic -->

      

    </div><!-- End Right side columns -->

  </div>
</section>

</main>
@endif
</x-app-layout>
