<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use App\Models\User;

class AffecterNotification extends Notification
{
    use Queueable;

    
    public function __construct($numero)
    {
        $this->numero = $numero;
    }

    
    public function via($notifiable)
    {
        return ['database'];
    }

    
    public function toArray($notifiable)
    {
        return [
            'message' => 'Nouveau Dossier pour vous.',
            'name' => $this->numero,
        ];
    }
}
