<?php

namespace App\Http\Controllers;
use App\Models\Province;

use Illuminate\Http\Request;

class ProvinceController extends Controller
{
    public function index()
    {
        $provinces = Province::all();

        return view('province.index', compact('provinces'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        

        return view('province.create');
    }

    
    public function store(Request $request)
    {
        $data = $request->validate([
            'nom' => 'required',
            
        ]);

        Province::create($data);


        return redirect()->route('provinces.index')->with('success', "Province Successfully Created");
    }

    public function edit(Province $province)
    {
       

        return view('province.edit', compact('province'));
    }

    public function update(Request $request,Province $province)
    {
        $data = $request->validate([
            'nom' => 'required',
            
        ]);


        $province->update([
            'nom' => $data['nom'],
            
        ]);

        return redirect()->route('provinces.index')->with('success', "Province updated successfully");
    }

    public function destroy(Province $province)
    {
        $province->delete();

        return redirect()->route('provinces.index')->with('success', 'Province deleted successful');
    }
}
