<?php

namespace App\Http\Controllers;
use App\Models\Commune;
use App\Models\Province;

use Illuminate\Http\Request;

class CommuneController extends Controller
{
    public function index()
    {
        $communes = Commune::all();

        return view('commune.index', compact('communes'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $provinces = Province::all();

        return view('commune.create', compact('provinces'));
    }

    
    public function store(Request $request)
    {
        $data = $request->validate([
            'nom' => 'required',
            'province_id' => 'required|exists:provinces,id',
        ]);

        Commune::create($data);


        return redirect()->route('communes.index')->with('success', "Commune Successfully Created");
    }

    public function edit(Commune $commune)
    {
        $provinces = Province::all();

        return view('commune.edit', compact('commune', 'provinces'));
    }

    public function update(Request $request,Commune $commune)
    {
        $data = $request->validate([
            'nom' => 'required',
            'province_id' => 'required|exists:provinces,id',
        ]);


        $province->update([
            'nom' => $data['nom'],
            'province_id' => $data['province_id'],
        ]);

        return redirect()->route('communes.index')->with('success', "Commune updated successfully");
    }

    public function destroy(Commune $commune)
    {
        $commune->delete();

        return redirect()->route('communes.index')->with('success', 'Commune deleted successful');
    }
}
