<x-app-layout>
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Les permissions</h1>
          </div>
          <div class="col-sm-6">
            <div class="breadcrumb float-sm-right">
            @include('role-permission.nav-links')
              <a href="{{ url('permissions/create') }}" class="btn btn-primary">Ajouter permission</a>
            </div>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->

    @if ($errors->has('delete_error'))
    <div class="alert alert-danger">
    <i class="ri-alert-fill"></i> {{ $errors->first('delete_error') }}
    </div>
    @endif
    @if(session('status'))
        <div class="alert alert-success">
          <i class="ri-alert-fill"></i> {{ session('status') }}
        </div>
    @endif

    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            <div class="card">
            <div class="card-header">
                <h3 class="card-title">Les permissions</h3>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>ID</th>
                    <th>Nom</th>
                    <th>Actions</th>
                  </tr>
                  </thead>
                  <tbody>
                  @foreach($permissions as $permission)
                        <tr>
                            <td>{{ $permission->id }}</td>
                            <td>{{ $permission->name }}</td>
                            <td>
                                <a href="{{ url('permissions/'.$permission->id.'/edit') }}" class="btn btn-success"><i class="nav-icon far fa-edit" title="Modifier"></i></a>
                                <a href="{{ url('permissions/'.$permission->id.'/delete') }}" onclick="return confirm('Vous voulez supprimer ça?')" class="btn btn-danger mx-2"><i class="nav-icon fa fa-trash" title="Supprimer"></i></a>
                            </td>
                        </tr>
                        @endforeach
                  </tbody>
                  <tfoot>
                  <tr>
                    <th>ID</th>
                    <th>Nom</th>
                    <th>Actions</th>
                  </tr>
                  </tfoot>
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>
</x-app-layout>