<?php

namespace App\Http\Controllers;
use App\Models\Secteur_activite;

use Illuminate\Http\Request;

class SecteurController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:Voir secteur', ['only' => ['index']]);
        $this->middleware('permission:Créer secteur', ['only' => ['create', 'store']]);
        $this->middleware('permission:Modifier secteur', ['only' => ['edit', 'update']]);
        $this->middleware('permission:Supprimer secteur', ['only' => ['destroy']]);
    }

    public function index()
    {
        $secteurs = Secteur_activite::all();

        return view('secteurs.index', compact('secteurs'));
    }

    
    public function create()
    {
        return view('secteurs.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'nom' => 'required',
            
        ]);

        Secteur_activite::create($data);


        return redirect()->route('secteurs.index')->with('success', "Vous avez crée le secteur");
    }

    public function edit(Secteur_activite $secteur)
    {
       

        return view('secteurs.edit', compact('secteur'));
    }

    public function update(Request $request,Secteur_activite $secteur)
    {
        $data = $request->validate([
            'nom' => 'required',
            
        ]);


        $secteur->update([
            'nom' => $data['nom'],
            
        ]);

        return redirect()->route('secteurs.index')->with('success', "Vous avez modifié le secteur");
    }

    public function destroy($secteurId)
    {
        $secteur = Secteur_activite::find($secteurId);
        $secteur->delete();

        return redirect()->route('secteurs.index')->with('success', 'Vous avez supprimé le secteur');
    }
}
