<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Region;

class RegionController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:Voir région', ['only' => ['index']]);
        $this->middleware('permission:Créer région', ['only' => ['create', 'store']]);
        $this->middleware('permission:Modifier région', ['only' => ['edit', 'update']]);
        $this->middleware('permission:Supprimer région', ['only' => ['destroy']]);
    }

    public function index()
    {
        $regions = Region::all();

        return view('regions.index', compact('regions'));
    }

    
    public function create()
    {
        return view('regions.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'nom' => 'required',
            
        ]);

        Region::create($data);


        return redirect()->route('regions.index')->with('success', "Vous avez crée la région");
    }

    public function edit(Region $region)
    {
       

        return view('regions.edit', compact('region'));
    }

    public function update(Request $request,Region $region)
    {
        $data = $request->validate([
            'nom' => 'required',
            
        ]);


        $region->update([
            'nom' => $data['nom'],
            
        ]);

        return redirect()->route('regions.index')->with('success', "Vous avez modifié le région");
    }

    public function destroy($regionId)
    {
        $region = Region::find($regionId);
        $region->delete();

        return redirect()->route('regions.index')->with('success', 'Vous avez supprimé le région');
    }
}
