<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Beneficiaire;
use App\Models\Categorie_professionnelle;
use App\Models\Secteur_activite;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Database\QueryException;
use Illuminate\Validation\ValidationException;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    public function index()
    {
        $admin = Auth::user();

        $beneficiaires = Beneficiaire::where('user_id', $admin->id)->count();

        $secteurs = Secteur_activite::count();

        $categories = Categorie_professionnelle::count();

        $benefi = Beneficiaire::join('secteur_activites', 'beneficiaires.secteur_id', '=', 'secteur_activites.id')
        ->select('beneficiaires.nom', 'beneficiaires.prenom', 'beneficiaires.sexe', 'secteur_activites.nom as sect')
        ->where('beneficiaires.user_id', $admin->id)
        ->orderBy('beneficiaires.id', 'desc')
        ->get()->take(5);

        return view('dashboard', compact('beneficiaires', 'secteurs', 'categories', 'benefi'));
    }
}
