<?php
/**
 * Default Values.
 *
 * @package Education Reform
 */

if ( ! function_exists( 'education_reform_get_default_theme_options' ) ) :
	function education_reform_get_default_theme_options() {

		$education_reform_defaults = array();
		
		// Options.
        $education_reform_defaults['logo_width_range']                                  = 300;
		$education_reform_defaults['global_sidebar_layout']					            = 'right-sidebar';
        $education_reform_defaults['education_reform_header_layout_phone_number']       = '+101 888 999 111';
        $education_reform_defaults['education_reform_header_layout_email_address']      = esc_html__( 'mail@example.com', 'education-reform' );
        $education_reform_defaults['education_reform_pagination_layout']         = 'numeric';
		$education_reform_defaults['footer_column_layout'] 						 = 3;
		$education_reform_defaults['footer_copyright_text'] 				     = esc_html__( 'All rights reserved.', 'education-reform' );
        $education_reform_defaults['twp_navigation_type']              			 = 'theme-normal-navigation';
        $education_reform_defaults['education_reform_post_author']                		= 1;
        $education_reform_defaults['education_reform_post_date']                		= 1;
        $education_reform_defaults['education_reform_post_category']                	= 1;
        $education_reform_defaults['education_reform_post_tags']                		= 1;
        $education_reform_defaults['education_reform_floating_next_previous_nav']       = 1;
        $education_reform_defaults['education_reform_header_banner']               		= 0;
        $education_reform_defaults['education_reform_category_section']               	= 0;
        $education_reform_defaults['education_reform_courses_category_section']         = 0;
        $education_reform_defaults['cat_main_service_title']                            = esc_html__('Meet Our Teachers','education-reform');
        $education_reform_defaults['cat_main_title']                                    = esc_html__('Lorem Ipsum has been the industrys standard dummy text ever since the 1500s.','education-reform');
        $education_reform_defaults['cat_main_courses_title']                            = esc_html__('Lorem Ipsum Simply','education-reform');
        $education_reform_defaults['cat_main_courses_text']                                    = esc_html__('Lorem Ipsum has been the industrys standard dummy text ever since the 1500s.','education-reform');
        $education_reform_defaults['education_reform_background_color']               	= '#fff';

		// Pass through filter.
		$education_reform_defaults = apply_filters( 'education_reform_filter_default_theme_options', $education_reform_defaults );

		return $education_reform_defaults;
	}
endif;
