
jQuery(document).ready( function($){


	/*----------------------------------------------------------------------------*
	*                    TÉLÉCHARGEMENT IMAGE AVATAR PERSONNALISÉ
	*----------------------------------------------------------------------------*/

	var custom_uploader;
	
	// pour Debug
	//alert('le script JS est bien chargé')

	$('#upload_image_button').click( function(e) {

		
		// évite un rechargement de page
		e.preventDefault();

		//Si l'objet de téléchargement a déjà été créé, rouvrez la boîte de dialogue
		if (custom_uploader) {
			custom_uploader.open();
			return;
		}

		//Instance de l'objet wp.media
		custom_uploader = wp.media.frames.file_frame = wp.media({
			title: 'Choose Image',
			button: {
				text: 'Choose Image'
			},
			/* Pas de sélection multiple image */
			multiple: false
		});

		// Lorsqu'un fichier est sélectionné, on récupère l'URL de l'image
		// et on l'affecte comme valeur du champ de texte
		custom_uploader.on('select', function() {
						
			// on récupère l'URL de la première image sélectionné avec la méthode first()
			// on récupère un objet qui n'est pas trés pratique a utilisé
			// on le converti en Json avec la méthode toJSON()
			var attachment = custom_uploader.state().get('selection').first().toJSON();
			
			// Pour Debug
			//console.log(attachment);
			
			/* Pour une sélection simple */
			
			// l'objet récupéré  attachment a un champ url
			// on affecte l'URL au champ de texte
			$('#upload_image').val(attachment.url);
			
			// on affiche notre image sélectionné dans une balise image
			// et on modifie son attribut src en fonction de l'image sélectionnée
			$('#upload_image_src').attr('src',attachment.url)
			
			/* Fin sélection simple */
			
			/* Pour une sélection multiple
			var attachments = [];
			selection.map( function(attachment){
				attachments.push(attachment.url);
			})
			
			// on utilse la méthode join pour réunir toutes les URL
			// du tableau attachments
			$('#upload_image').val(attachments.join(','));
			
			*/
			
		});

		//Ouvrir la boîte de dialogue de téléchargement
		custom_uploader.open();

	});
	
	
	/*----------------------------------------------------------------------------*
	*                   REGLAGE TAILLE AVATAR PERSONNALISÉ
	*----------------------------------------------------------------------------*/
	
	var size_avatar;
		     
	// au changement de valeur de l'input pour régler la taille
	// de l'avatar personnalisé
	$('#avatar_size').change(function() {
	  
		// on récupère la valeur de l'input
		size_avatar = $('#avatar_size').val();
		
		// on modifie les attribut width & height de la balise image
		// pour l'avatar personnalisé avec la valeur de la taille 
		// sélectionnée avec l'input
		$('#upload_image_src').attr('width',size_avatar);
		$('#upload_image_src').attr('height',size_avatar);

	});

	// pour Debug
	//console.log(size_avatar);
	//alert('valeur de la taille ' + size_avatar);
	

});
